#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include "shnmk16min.h"
#include "shnm8x16a.h"

#define SCREEN_WIDTH  (128) // OLED display width, in pixels
#define SCREEN_HEIGHT (64)  // OLED display height, in pixels

#define OLED_RESET     4 // Reset pin # (or -1 if sharing Arduino reset pin)

#define SCREEN_ADDRESS 0x78>>1 ///< See datasheet for Address; 0x3D for 128x64, 0x3C for 128x32
Adafruit_SSD1306 ssd1306(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

void drawKanji(unsigned char *bitmap, int pos_x, int pos_y)
{
	for(int y = 0; y < 16; y++) {
		for(int x = 0; x < 8; x++) {
			if (*bitmap & (0x80>>x)) ssd1306.drawPixel(pos_x + x, pos_y + y, SSD1306_WHITE);
		}
		bitmap++;
		for(int x = 0; x < 8; x++) {
			if (*bitmap & (0x80>>x)) ssd1306.drawPixel(pos_x + x + 8, pos_y + y, SSD1306_WHITE);
		}
		bitmap++;
	}
}

void drawAscii(unsigned char *bitmap, int pos_x, int pos_y)
{
	for(int y = 0; y < 16; y++) {
		for(int x = 0; x < 8; x++) {
			if (*bitmap & (0x80>>x)) ssd1306.drawPixel(pos_x + x, pos_y + y, SSD1306_WHITE);
		}
		bitmap++;
	}
}

void getFont(unsigned char *bitmap, unsigned int utf8)
{
	unsigned char   *pt;
	unsigned int    utf8code;

	for (int i = 0; i < font_num; i++) {
		utf8code = pgm_read_dword_near(&shnmk16min[i].utf8);
		if (utf8code == utf8) {
			pt = (unsigned char *)shnmk16min[i].bitmap;
			for (int pos = 0; pos < 32; pos++, bitmap++, pt++) {
				*bitmap = pgm_read_byte_near(pt);
			}
			break;
		}
	}
}

void getFontAscii(unsigned char *bitmap, unsigned int ascii)
{
	unsigned char   *pt;
	unsigned int    code;

	for (int i = 0; i < font_num; i++) {
		code = pgm_read_byte_near(&shnm8x16a[i].ascii);
		if (code == ascii) {
			pt = (unsigned char *)shnm8x16a[i].bitmap;
			for (int pos = 0; pos < 16; pos++, bitmap++, pt++) {
				*bitmap = pgm_read_byte_near(pt);
			}
			break;
		}
	}
}

void printKanji(char *str)
{
	int pos_x = 0;
	int pos_y = 0;
	int numByte;
	int code;
	int i;
	unsigned char bitmap[32];

	ssd1306.clearDisplay();

	while(*str) {
		switch(*str) {
			case 0x0a:
			case 0x0d:
				pos_y += FONT_HEIGHT;
				str++;
				break;
			default:
				if ((*str & 0x80) == 0x00) { // 1byte文字
					if ((pos_x + FONT_ASCII_WIDTH) > SCREEN_WIDTH) {
						pos_x = 0;
						pos_y += FONT_HEIGHT;
					} 
					getFontAscii(bitmap, *str);
					drawAscii(bitmap, pos_x, pos_y);
					pos_x += (FONT_WIDTH / 2);
					str++;
				} else {
					// UTF-8文字コードのバイト数判定
					       if ((*str & 0xE0) == 0xC0) { numByte=2; // 2byte文字
					} else if ((*str & 0xF0) == 0xE0) { numByte=3; // 3byte文字
					} else if ((*str & 0xF8) == 0xF0) { numByte=4; // 4byte文字
					}
					if ((pos_x + FONT_WIDTH) > SCREEN_WIDTH) {
						pos_x = 0;
						pos_y += FONT_HEIGHT;
					}
					for (code = *str, str++, i = 1; i < numByte; i++, str++) {
						code = (code << 8) + *str;
					};
					getFont(bitmap, code);
					drawKanji(bitmap, pos_x, pos_y);
					pos_x += FONT_WIDTH;
				}
				break;
		}
	}
	ssd1306.display();
}

void setup()
{
	ssd1306.begin(SSD1306_SWITCHCAPVCC, SCREEN_ADDRESS);

	printKanji(" !\"#$%&'()*+,-./0123456789:;<=>@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^`a");
	delay(5000);
	printKanji("東雲フォントを TFT LCD に表示させてみました。");
}

void loop() {}
