typedef struct {
	prog_uint16_t  jis;
	prog_uint16_t  sjis;
	prog_uint16_t  euc;
	prog_uint32_t  utf8;
	prog_uint16_t  utf16;
	prog_uchar     bitmap[32];
} BDF_FORMAT;

int font_num = 6965;

#define FONT_WIDTH  16
#define FONT_HEIGHT 16

const BDF_FORMAT shnmk16min[6965] PROGMEM = {
{0x2121,0x8140,0xA1A1,0xE38080,0x3000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // 　
{0x2122,0x8141,0xA1A2,0xE38081,0x3001,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x10,0x00,0x08,0x00,0x08,0x00}}, // 、
{0x2123,0x8142,0xA1A3,0xE38082,0x3002,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x48,0x00,0x48,0x00,0x30,0x00,0x00,0x00}}, // 。
{0x2124,0x8143,0xA1A4,0xEFBC8C,0xFF0C,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x20,0x00,0x40,0x00}}, // ，
{0x2125,0x8144,0xA1A5,0xEFBC8E,0xFF0E,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00,0x00}}, // ．
{0x2126,0x8145,0xA1A6,0xE383BB,0x30FB,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ・
{0x2127,0x8146,0xA1A7,0xEFBC9A,0xFF1A,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00}}, // ：
{0x2128,0x8147,0xA1A8,0xEFBC9B,0xFF1B,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x80,0x01,0x00,0x00,0x00}}, // ；
{0x2129,0x8148,0xA1A9,0xEFBC9F,0xFF1F,{0x00,0x00,0x03,0xc0,0x04,0x20,0x08,0x10,0x08,0x10,0x08,0x10,0x04,0x20,0x00,0x40,0x00,0x80,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x00}}, // ？
{0x212A,0x8149,0xA1AA,0xEFBC81,0xFF01,{0x00,0x00,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x00}}, // ！
{0x212B,0x814A,0xA1AB,0xE3829B,0x309B,{0x10,0x00,0x48,0x00,0x28,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ゛
{0x212C,0x814B,0xA1AC,0xE3829C,0x309C,{0x00,0x00,0x60,0x00,0x90,0x00,0x90,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ゜
{0x212D,0x814C,0xA1AD,0xC2B4,  0x00B4,{0x00,0x80,0x00,0x80,0x01,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ´
{0x212E,0x814D,0xA1AE,0xEFBD80,0xFF40,{0x02,0x00,0x02,0x00,0x01,0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ｀
{0x212F,0x814E,0xA1AF,0xC2A8,  0x00A8,{0x06,0x60,0x06,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ¨
{0x2130,0x814F,0xA1B0,0xEFBCBE,0xFF3E,{0x01,0x00,0x02,0x80,0x04,0x40,0x08,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ＾
{0x2131,0x8150,0xA1B1,0xEFBFA3,0xFFE3,{0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ￣
{0x2132,0x8151,0xA1B2,0xEFBCBF,0xFF3F,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff}}, // ＿
{0x2133,0x8152,0xA1B3,0xE383BD,0x30FD,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x03,0x00,0x00,0x80,0x00,0x40,0x00,0x20,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ヽ
{0x2134,0x8153,0xA1B4,0xE383BE,0x30FE,{0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x90,0x00,0x50,0x0c,0x40,0x03,0x00,0x00,0x80,0x00,0x40,0x00,0x20,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ヾ
{0x2135,0x8154,0xA1B5,0xE3829D,0x309D,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x03,0x00,0x00,0x80,0x00,0x40,0x00,0x20,0x00,0x70,0x00,0x80,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ゝ
{0x2136,0x8155,0xA1B6,0xE3829E,0x309E,{0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x48,0x0c,0x28,0x03,0x20,0x00,0x80,0x00,0x40,0x00,0x20,0x00,0x70,0x00,0x80,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ゞ
{0x2137,0x8156,0xA1B7,0xE38083,0x3003,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x10,0x01,0x10,0x01,0x10,0x02,0x20,0x02,0x20,0x04,0x40,0x08,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // 〃
{0x2138,0x8157,0xA1B8,0xE4BB9D,0x4EDD,{0x00,0x80,0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x60,0x03,0x00,0x00,0x0f,0xfc,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x3f,0xfe,0x00,0x00}}, // 仝
{0x2139,0x8158,0xA1B9,0xE38085,0x3005,{0x00,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0xf8,0x01,0x08,0x02,0x08,0x02,0x10,0x04,0x10,0x09,0xa0,0x10,0x60,0x00,0x10,0x00,0x08,0x00,0x08,0x00,0x00,0x00,0x00}}, // 々
{0x213A,0x8159,0xA1BA,0xE38086,0x3006,{0x00,0x00,0x00,0x02,0x00,0x02,0x00,0x04,0x00,0x08,0x01,0x90,0x02,0x60,0x04,0x40,0x04,0xa0,0x09,0x00,0x0a,0x00,0x0c,0x00,0x08,0x00,0x10,0x00,0x10,0x00,0x00,0x00}}, // 〆
{0x213B,0x815A,0xA1BB,0xE38087,0x3007,{0x00,0x00,0x03,0xc0,0x0c,0x30,0x10,0x08,0x20,0x04,0x20,0x04,0x40,0x02,0x40,0x02,0x40,0x02,0x40,0x02,0x20,0x04,0x20,0x04,0x10,0x08,0x0c,0x30,0x03,0xc0,0x00,0x00}}, // 〇
{0x213C,0x815B,0xA1BC,0xE383BC,0x30FC,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ー
{0x213D,0x815C,0xA1BD,0xE28095,0x2015,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ―
{0x213E,0x815D,0xA1BE,0xE28090,0x2010,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xe0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ‐
{0x213F,0x815E,0xA1BF,0xEFBC8F,0xFF0F,{0x00,0x01,0x00,0x02,0x00,0x04,0x00,0x08,0x00,0x10,0x00,0x20,0x00,0x40,0x00,0x80,0x01,0x00,0x02,0x00,0x04,0x00,0x08,0x00,0x10,0x00,0x20,0x00,0x40,0x00,0x80,0x00}}, // ／
{0x2140,0x815F,0xA1C0,0x5C,    0x005C,{0x80,0x00,0x40,0x00,0x20,0x00,0x10,0x00,0x08,0x00,0x04,0x00,0x02,0x00,0x01,0x00,0x00,0x80,0x00,0x40,0x00,0x20,0x00,0x10,0x00,0x08,0x00,0x04,0x00,0x02,0x00,0x01}}, // ＼
{0x2141,0x8160,0xA1C1,0xE3809C,0x301C,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,0x00,0x11,0x82,0x20,0x44,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ～
{0x2142,0x8161,0xA1C2,0xE28096,0x2016,{0x04,0x40,0x04,0x40,0x04,0x40,0x04,0x40,0x04,0x40,0x04,0x40,0x04,0x40,0x04,0x40,0x04,0x40,0x04,0x40,0x04,0x40,0x04,0x40,0x04,0x40,0x04,0x40,0x04,0x40,0x04,0x40}}, // ∥
{0x2143,0x8162,0xA1C3,0xEFBD9C,0xFF5C,{0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00}}, // ｜
{0x2144,0x8163,0xA1C4,0xE280A6,0x2026,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x61,0x86,0x61,0x86,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // …
{0x2145,0x8164,0xA1C5,0xE280A5,0x2025,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ‥
{0x2146,0x8165,0xA1C6,0xE28098,0x2018,{0x00,0x08,0x00,0x10,0x00,0x18,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ‘
{0x2147,0x8166,0xA1C7,0xE28099,0x2019,{0x18,0x00,0x18,0x00,0x08,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ’
{0x2148,0x8167,0xA1C8,0xE2809C,0x201C,{0x00,0x24,0x00,0x48,0x00,0x6c,0x00,0x6c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // “
{0x2149,0x8168,0xA1C9,0xE2809D,0x201D,{0x36,0x00,0x36,0x00,0x12,0x00,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ”
{0x214A,0x8169,0xA1CA,0xEFBC88,0xFF08,{0x00,0x00,0x00,0x08,0x00,0x10,0x00,0x20,0x00,0x40,0x00,0x40,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x40,0x00,0x40,0x00,0x20,0x00,0x10,0x00,0x08}}, // （
{0x214B,0x816A,0xA1CB,0xEFBC89,0xFF09,{0x00,0x00,0x10,0x00,0x08,0x00,0x04,0x00,0x02,0x00,0x02,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x02,0x00,0x02,0x00,0x04,0x00,0x08,0x00,0x10,0x00}}, // ）
{0x214C,0x816B,0xA1CC,0xE38094,0x3014,{0x00,0x08,0x00,0x30,0x00,0xc0,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0xc0,0x00,0x30,0x00,0x08}}, // 〔
{0x214D,0x816C,0xA1CD,0xE38095,0x3015,{0x10,0x00,0x0c,0x00,0x03,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x03,0x00,0x0c,0x00,0x10,0x00}}, // 〕
{0x214E,0x816D,0xA1CE,0xEFBCBB,0xFF3B,{0x00,0xf8,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0xf8}}, // ［
{0x214F,0x816E,0xA1CF,0xEFBCBD,0xFF3D,{0x1f,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x1f,0x00}}, // ］
{0x2150,0x816F,0xA1D0,0xEFBD9B,0xFF5B,{0x00,0x08,0x00,0x10,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0xc0,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x10,0x00,0x08}}, // ｛
{0x2151,0x8170,0xA1D1,0xEFBD9D,0xFF5D,{0x10,0x00,0x08,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x03,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x08,0x00,0x10,0x00}}, // ｝
{0x2152,0x8171,0xA1D2,0xE38088,0x3008,{0x00,0x08,0x00,0x08,0x00,0x10,0x00,0x10,0x00,0x20,0x00,0x20,0x00,0x40,0x00,0x80,0x00,0x80,0x00,0x40,0x00,0x20,0x00,0x20,0x00,0x10,0x00,0x10,0x00,0x08,0x00,0x08}}, // 〈
{0x2153,0x8172,0xA1D3,0xE38089,0x3009,{0x10,0x00,0x10,0x00,0x08,0x00,0x08,0x00,0x04,0x00,0x04,0x00,0x02,0x00,0x01,0x00,0x01,0x00,0x02,0x00,0x04,0x00,0x04,0x00,0x08,0x00,0x08,0x00,0x10,0x00,0x10,0x00}}, // 〉
{0x2154,0x8173,0xA1D4,0xE3808A,0x300A,{0x00,0x24,0x00,0x24,0x00,0x48,0x00,0x48,0x00,0x90,0x00,0x90,0x01,0x20,0x02,0x40,0x02,0x40,0x01,0x20,0x00,0x90,0x00,0x90,0x00,0x48,0x00,0x48,0x00,0x24,0x00,0x24}}, // 《
{0x2155,0x8174,0xA1D5,0xE3808B,0x300B,{0x24,0x00,0x24,0x00,0x12,0x00,0x12,0x00,0x09,0x00,0x09,0x00,0x04,0x80,0x02,0x40,0x02,0x40,0x04,0x80,0x09,0x00,0x09,0x00,0x12,0x00,0x12,0x00,0x24,0x00,0x24,0x00}}, // 》
{0x2156,0x8175,0xA1D6,0xE3808C,0x300C,{0x00,0xf8,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // 「
{0x2157,0x8176,0xA1D7,0xE3808D,0x300D,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x1f,0x00}}, // 」
{0x2158,0x8177,0xA1D8,0xE3808E,0x300E,{0x01,0xf8,0x01,0x08,0x01,0x78,0x01,0x40,0x01,0x40,0x01,0x40,0x01,0x40,0x01,0x40,0x01,0x40,0x01,0x40,0x01,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // 『
{0x2159,0x8178,0xA1D9,0xE3808F,0x300F,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x80,0x02,0x80,0x02,0x80,0x02,0x80,0x02,0x80,0x02,0x80,0x02,0x80,0x02,0x80,0x1e,0x80,0x10,0x80,0x1f,0x80}}, // 』
{0x215A,0x8179,0xA1DA,0xE38090,0x3010,{0x00,0xf8,0x00,0xf0,0x00,0xe0,0x00,0xc0,0x00,0xc0,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0xc0,0x00,0xc0,0x00,0xe0,0x00,0xf0,0x00,0xf8}}, // 【
{0x215B,0x817A,0xA1DB,0xE38091,0x3011,{0x1f,0x00,0x0f,0x00,0x07,0x00,0x03,0x00,0x03,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x03,0x00,0x03,0x00,0x07,0x00,0x0f,0x00,0x1f,0x00}}, // 】
{0x215C,0x817B,0xA1DC,0xEFBC8B,0xFF0B,{0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x00,0x00,0x00}}, // ＋
{0x215D,0x817C,0xA1DD,0xE28892,0x2212,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // －
{0x215E,0x817D,0xA1DE,0xC2B1,  0x00B1,{0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x00,0x00,0x00,0x1f,0xfe,0x00,0x00,0x00,0x00}}, // ±
{0x215F,0x817E,0xA1DF,0xC397,  0x00D7,{0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x08,0x08,0x10,0x04,0x20,0x02,0x40,0x01,0x80,0x01,0x80,0x02,0x40,0x04,0x20,0x08,0x10,0x10,0x08,0x00,0x00,0x00,0x00,0x00,0x00}}, // ×
{0x2160,0x8180,0xA1E0,0xC3B7,  0x00F7,{0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00,0x3f,0xfc,0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ÷
{0x2161,0x8181,0xA1E1,0xEFBC9D,0xFF1D,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ＝
{0x2162,0x8182,0xA1E2,0xE289A0,0x2260,{0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x40,0x00,0x80,0x3f,0xfc,0x00,0x80,0x01,0x00,0x01,0x00,0x3f,0xfc,0x01,0x00,0x02,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ≠
{0x2163,0x8183,0xA1E3,0xEFBC9C,0xFF1C,{0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x60,0x01,0x80,0x02,0x00,0x0c,0x00,0x30,0x00,0x0c,0x00,0x02,0x00,0x01,0x80,0x00,0x60,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00}}, // ＜
{0x2164,0x8184,0xA1E4,0xEFBC9E,0xFF1E,{0x00,0x00,0x00,0x00,0x18,0x00,0x06,0x00,0x01,0x80,0x00,0x40,0x00,0x30,0x00,0x0c,0x00,0x30,0x00,0x40,0x01,0x80,0x06,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ＞
{0x2165,0x8185,0xA1E5,0xE289A6,0x2266,{0x00,0x00,0x00,0x00,0x00,0x1c,0x00,0xe0,0x07,0x00,0x38,0x00,0x07,0x00,0x00,0xe0,0x00,0x1c,0x00,0x00,0x3f,0xfc,0x00,0x00,0x00,0x00,0x3f,0xfc,0x00,0x00,0x00,0x00}}, // ≦
{0x2166,0x8186,0xA1E6,0xE289A7,0x2267,{0x00,0x00,0x00,0x00,0x38,0x00,0x07,0x00,0x00,0xe0,0x00,0x1c,0x00,0xe0,0x07,0x00,0x38,0x00,0x00,0x00,0x3f,0xfc,0x00,0x00,0x00,0x00,0x3f,0xfc,0x00,0x00,0x00,0x00}}, // ≧
{0x2167,0x8187,0xA1E7,0xE2889E,0x221E,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1c,0x18,0x26,0x64,0x42,0x42,0x41,0x82,0x41,0x82,0x42,0x42,0x26,0x64,0x18,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ∞
{0x2168,0x8188,0xA1E8,0xE288B4,0x2234,{0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x00,0x00}}, // ∴
{0x2169,0x8189,0xA1E9,0xE29982,0x2642,{0x00,0x00,0x00,0xfe,0x00,0x06,0x00,0x0a,0x00,0x12,0x00,0x22,0x00,0x42,0x1e,0x82,0x21,0x00,0x40,0x80,0x40,0x80,0x40,0x80,0x40,0x80,0x21,0x00,0x1e,0x00,0x00,0x00}}, // ♂
{0x216A,0x818A,0xA1EA,0xE29980,0x2640,{0x00,0x00,0x03,0xc0,0x04,0x20,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x04,0x20,0x03,0xc0,0x01,0x00,0x1f,0xf8,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00}}, // ♀
{0x216B,0x818B,0xA1EB,0xC2B0,  0x00B0,{0x00,0x00,0x30,0x00,0x48,0x00,0x48,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // °
{0x216C,0x818C,0xA1EC,0xE280B2,0x2032,{0x00,0x00,0x08,0x00,0x18,0x00,0x30,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ′
{0x216D,0x818D,0xA1ED,0xE280B3,0x2033,{0x00,0x00,0x11,0x00,0x33,0x00,0x66,0x00,0x44,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ″
{0x216E,0x818E,0xA1EE,0xE28483,0x2103,{0x00,0x00,0x30,0x72,0x49,0x8a,0x4a,0x06,0x32,0x02,0x04,0x02,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x02,0x02,0x02,0x04,0x01,0x98,0x00,0x60,0x00,0x00,0x00,0x00}}, // ℃
{0x216F,0x818F,0xA1EF,0xEFBFA5,0xFFE5,{0x00,0x00,0x1c,0x1c,0x08,0x08,0x04,0x10,0x04,0x10,0x3f,0xfe,0x02,0x20,0x01,0x40,0x00,0x80,0x3f,0xfe,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x01,0xc0,0x00,0x00}}, // ￥
{0x2170,0x8190,0xA1F0,0xEFBC84,0xFF04,{0x00,0x00,0x02,0x80,0x07,0xc0,0x0a,0xa0,0x12,0x90,0x12,0x90,0x0a,0x80,0x07,0x80,0x02,0xe0,0x02,0x90,0x12,0x88,0x12,0x88,0x0a,0x90,0x07,0xe0,0x02,0x80,0x00,0x00}}, // ＄
{0x2171,0x8191,0xA1F1,0xC2A2,  0x00A2,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x03,0xc0,0x04,0x60,0x08,0x50,0x08,0x80,0x08,0x80,0x09,0x10,0x05,0x20,0x03,0xc0,0x02,0x00,0x04,0x00}}, // ￠
{0x2172,0x8192,0xA1F2,0xC2A3,  0x00A3,{0x00,0x00,0x00,0xe0,0x01,0x10,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x3f,0xf8,0x01,0x00,0x01,0x00,0x1e,0x00,0x23,0x02,0x22,0xc4,0x1c,0x38,0x00,0x00}}, // ￡
{0x2173,0x8193,0xA1F3,0xEFBC85,0xFF05,{0x00,0x00,0x38,0x02,0x64,0x04,0x44,0x08,0x44,0x10,0x44,0x20,0x4c,0x40,0x38,0x80,0x01,0x38,0x02,0x64,0x04,0x44,0x08,0x44,0x10,0x44,0x20,0x4c,0x40,0x38,0x00,0x00}}, // ％
{0x2174,0x8194,0xA1F4,0xEFBC83,0xFF03,{0x02,0x10,0x02,0x10,0x02,0x10,0x02,0x10,0x1f,0xfc,0x1f,0xfc,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x3f,0xf8,0x3f,0xf8,0x08,0x40,0x08,0x40,0x08,0x40,0x08,0x40}}, // ＃
{0x2175,0x8195,0xA1F5,0xEFBC86,0xFF06,{0x00,0x00,0x0f,0x00,0x10,0x80,0x10,0x80,0x10,0x80,0x09,0x00,0x06,0x10,0x04,0x10,0x0a,0x10,0x11,0x20,0x20,0xa0,0x20,0x40,0x20,0xa0,0x11,0x12,0x0e,0x0c,0x00,0x00}}, // ＆
{0x2176,0x8196,0xA1F6,0xEFBC8A,0xFF0A,{0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x19,0x30,0x0d,0x60,0x03,0x80,0x01,0x00,0x03,0x80,0x0d,0x60,0x19,0x30,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00}}, // ＊
{0x2177,0x8197,0xA1F7,0xEFBCA0,0xFF20,{0x00,0x00,0x00,0x00,0x03,0xc0,0x0c,0x30,0x10,0x08,0x11,0xa8,0x22,0x64,0x24,0x44,0x24,0x44,0x24,0xe8,0x13,0x70,0x10,0x04,0x0c,0x18,0x03,0xe0,0x00,0x00,0x00,0x00}}, // ＠
{0x2178,0x8198,0xA1F8,0xC2A7,  0x00A7,{0x01,0x80,0x02,0x40,0x04,0x20,0x06,0x20,0x03,0x00,0x03,0x80,0x04,0xc0,0x04,0x60,0x06,0x20,0x03,0x20,0x01,0xc0,0x00,0xc0,0x04,0x60,0x04,0x20,0x02,0x40,0x01,0x80}}, // §
{0x2179,0x8199,0xA1F9,0xE29886,0x2606,{0x00,0x00,0x01,0x00,0x01,0x00,0x02,0x80,0x02,0x80,0x04,0x40,0x7c,0x7c,0x20,0x08,0x10,0x10,0x08,0x20,0x08,0x20,0x11,0x10,0x12,0x90,0x2c,0x68,0x30,0x18,0x00,0x00}}, // ☆
{0x217A,0x819A,0xA1FA,0xE29885,0x2605,{0x00,0x00,0x01,0x00,0x01,0x00,0x03,0x80,0x03,0x80,0x07,0xc0,0x7f,0xfc,0x3f,0xf8,0x1f,0xf0,0x0f,0xe0,0x0f,0xe0,0x1e,0xf0,0x1c,0x70,0x38,0x38,0x20,0x08,0x00,0x00}}, // ★
{0x217B,0x819B,0xA1FB,0xE2978B,0x25CB,{0x00,0x00,0x03,0xc0,0x0c,0x30,0x10,0x08,0x20,0x04,0x20,0x04,0x40,0x02,0x40,0x02,0x40,0x02,0x40,0x02,0x20,0x04,0x20,0x04,0x10,0x08,0x0c,0x30,0x03,0xc0,0x00,0x00}}, // ○
{0x217C,0x819C,0xA1FC,0xE2978F,0x25CF,{0x00,0x00,0x03,0xc0,0x0f,0xf0,0x1f,0xf8,0x3f,0xfc,0x3f,0xfc,0x7f,0xfe,0x7f,0xfe,0x7f,0xfe,0x7f,0xfe,0x3f,0xfc,0x3f,0xfc,0x1f,0xf8,0x0f,0xf0,0x03,0xc0,0x00,0x00}}, // ●
{0x217D,0x819D,0xA1FD,0xE2978E,0x25CE,{0x00,0x00,0x03,0xc0,0x0c,0x30,0x10,0x08,0x23,0xc4,0x24,0x24,0x48,0x12,0x48,0x12,0x48,0x12,0x48,0x12,0x24,0x24,0x23,0xc4,0x10,0x08,0x0c,0x30,0x03,0xc0,0x00,0x00}}, // ◎
{0x217E,0x819E,0xA1FE,0xE29787,0x25C7,{0x01,0x80,0x02,0x40,0x04,0x20,0x08,0x10,0x10,0x08,0x20,0x04,0x40,0x02,0x80,0x01,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x08,0x08,0x10,0x04,0x20,0x02,0x40,0x01,0x80}}, // ◇
{0x2221,0x819F,0xA2A1,0xE29786,0x25C6,{0x01,0x80,0x03,0xc0,0x07,0xe0,0x0f,0xf0,0x1f,0xf8,0x3f,0xfc,0x7f,0xfe,0xff,0xff,0xff,0xff,0x7f,0xfe,0x3f,0xfc,0x1f,0xf8,0x0f,0xf0,0x07,0xe0,0x03,0xc0,0x01,0x80}}, // ◆
{0x2222,0x81A0,0xA2A2,0xE296A1,0x25A1,{0x00,0x00,0x7f,0xfe,0x40,0x02,0x40,0x02,0x40,0x02,0x40,0x02,0x40,0x02,0x40,0x02,0x40,0x02,0x40,0x02,0x40,0x02,0x40,0x02,0x40,0x02,0x40,0x02,0x7f,0xfe,0x00,0x00}}, // □
{0x2223,0x81A1,0xA2A3,0xE296A0,0x25A0,{0x00,0x00,0x7f,0xfe,0x7f,0xfe,0x7f,0xfe,0x7f,0xfe,0x7f,0xfe,0x7f,0xfe,0x7f,0xfe,0x7f,0xfe,0x7f,0xfe,0x7f,0xfe,0x7f,0xfe,0x7f,0xfe,0x7f,0xfe,0x7f,0xfe,0x00,0x00}}, // ■
{0x2224,0x81A2,0xA2A4,0xE296B3,0x25B3,{0x00,0x00,0x01,0x00,0x01,0x00,0x02,0x80,0x02,0x80,0x04,0x40,0x04,0x40,0x08,0x20,0x08,0x10,0x10,0x10,0x10,0x08,0x20,0x08,0x20,0x04,0x7f,0xfe,0x00,0x00,0x00,0x00}}, // △
{0x2225,0x81A3,0xA2A5,0xE296B2,0x25B2,{0x00,0x00,0x01,0x00,0x01,0x00,0x03,0x80,0x03,0x80,0x07,0xc0,0x07,0xe0,0x0f,0xe0,0x0f,0xf0,0x1f,0xf0,0x1f,0xf8,0x3f,0xfc,0x3f,0xfc,0x7f,0xfe,0x00,0x00,0x00,0x00}}, // ▲
{0x2226,0x81A4,0xA2A6,0xE296BD,0x25BD,{0x00,0x00,0x00,0x00,0x7f,0xfe,0x20,0x04,0x20,0x08,0x10,0x08,0x10,0x10,0x08,0x10,0x08,0x20,0x04,0x40,0x04,0x40,0x02,0x80,0x02,0x80,0x01,0x00,0x01,0x00,0x00,0x00}}, // ▽
{0x2227,0x81A5,0xA2A7,0xE296BC,0x25BC,{0x00,0x00,0x00,0x00,0x7f,0xfe,0x3f,0xfc,0x3f,0xfc,0x1f,0xf8,0x1f,0xf0,0x0f,0xf0,0x0f,0xe0,0x07,0xe0,0x07,0xc0,0x03,0x80,0x03,0x80,0x01,0x00,0x01,0x00,0x00,0x00}}, // ▼
{0x2228,0x81A6,0xA2A8,0xE280BB,0x203B,{0x00,0x00,0x00,0x00,0x21,0x84,0x11,0x88,0x08,0x10,0x04,0x20,0x02,0x40,0x31,0x8c,0x31,0x8c,0x02,0x40,0x04,0x20,0x08,0x10,0x11,0x88,0x21,0x84,0x00,0x00,0x00,0x00}}, // ※
{0x2229,0x81A7,0xA2A9,0xE38092,0x3012,{0x00,0x00,0x3f,0xfc,0x3f,0xfc,0x00,0x00,0x00,0x00,0x7f,0xfe,0x7f,0xfe,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x00,0x00}}, // 〒
{0x222A,0x81A8,0xA2AA,0xE28692,0x2192,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x10,0x00,0x0c,0xff,0xff,0x00,0x0c,0x00,0x10,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // →
{0x222B,0x81A9,0xA2AB,0xE28690,0x2190,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x08,0x00,0x30,0x00,0xff,0xff,0x30,0x00,0x08,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ←
{0x222C,0x81AA,0xA2AC,0xE28691,0x2191,{0x01,0x00,0x01,0x00,0x03,0x80,0x03,0x80,0x05,0x40,0x09,0x20,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00}}, // ↑
{0x222D,0x81AB,0xA2AD,0xE28693,0x2193,{0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x09,0x20,0x05,0x40,0x03,0x80,0x03,0x80,0x01,0x00,0x01,0x00}}, // ↓
{0x222E,0x81AC,0xA2AE,0xE38093,0x3013,{0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0xfe,0x3f,0xfe,0x3f,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0xfe,0x3f,0xfe,0x3f,0xfe,0x00,0x00,0x00,0x00,0x00,0x00}}, // 〓
{0x223A,0x81B8,0xA2BA,0xE28888,0x2208,{0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xf8,0x08,0x00,0x10,0x00,0x10,0x00,0x1f,0xf8,0x10,0x00,0x10,0x00,0x08,0x00,0x07,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ∈
{0x223B,0x81B9,0xA2BB,0xE2888B,0x220B,{0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xe0,0x00,0x10,0x00,0x08,0x00,0x08,0x1f,0xf8,0x00,0x08,0x00,0x08,0x00,0x10,0x1f,0xe0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ∋
{0x223C,0x81BA,0xA2BC,0xE28A86,0x2286,{0x00,0x00,0x00,0x00,0x0f,0xfc,0x10,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x10,0x00,0x0f,0xfc,0x00,0x00,0x00,0x00,0x3f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⊆
{0x223D,0x81BB,0xA2BD,0xE28A87,0x2287,{0x00,0x00,0x00,0x00,0x3f,0xf0,0x00,0x08,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x08,0x3f,0xf0,0x00,0x00,0x00,0x00,0x3f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⊇
{0x223E,0x81BC,0xA2BE,0xE28A82,0x2282,{0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xfc,0x0c,0x00,0x10,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x10,0x00,0x0c,0x00,0x03,0xfc,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⊂
{0x223F,0x81BD,0xA2BF,0xE28A83,0x2283,{0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0xc0,0x00,0x30,0x00,0x08,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x08,0x00,0x30,0x3f,0xc0,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⊃
{0x2240,0x81BE,0xA2C0,0xE288AA,0x222A,{0x00,0x00,0x00,0x00,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x08,0x10,0x08,0x10,0x04,0x20,0x03,0xc0,0x00,0x00,0x00,0x00}}, // ∪
{0x2241,0x81BF,0xA2C1,0xE288A9,0x2229,{0x00,0x00,0x00,0x00,0x03,0xc0,0x04,0x20,0x08,0x10,0x08,0x10,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x00,0x00,0x00,0x00}}, // ∩
{0x224A,0x81C8,0xA2CA,0xE288A7,0x2227,{0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x01,0x40,0x01,0x40,0x02,0x20,0x02,0x20,0x04,0x10,0x04,0x10,0x08,0x08,0x08,0x08,0x10,0x04,0x10,0x04,0x00,0x00,0x00,0x00}}, // ∧
{0x224B,0x81C9,0xA2CB,0xE288A8,0x2228,{0x00,0x00,0x00,0x00,0x10,0x04,0x10,0x04,0x08,0x08,0x08,0x08,0x04,0x10,0x04,0x10,0x02,0x20,0x02,0x20,0x01,0x40,0x01,0x40,0x00,0x80,0x00,0x80,0x00,0x00,0x00,0x00}}, // ∨
{0x224C,0x81CA,0xA2CC,0xC2AC,  0x00AC,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0xfc,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ￢
{0x224D,0x81CB,0xA2CD,0xE28792,0x21D2,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x08,0xff,0xfc,0x00,0x02,0x00,0x01,0x00,0x02,0xff,0xfc,0x00,0x08,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⇒
{0x224E,0x81CC,0xA2CE,0xE28794,0x21D4,{0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x10,0x10,0x08,0x3f,0xfc,0x40,0x02,0x80,0x01,0x40,0x02,0x3f,0xfc,0x10,0x08,0x08,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⇔
{0x224F,0x81CD,0xA2CF,0xE28880,0x2200,{0x00,0x00,0x20,0x02,0x20,0x02,0x10,0x04,0x10,0x04,0x0f,0xf8,0x08,0x08,0x04,0x10,0x04,0x10,0x02,0x20,0x02,0x20,0x01,0x40,0x01,0x40,0x00,0x80,0x00,0x80,0x00,0x00}}, // ∀
{0x2250,0x81CE,0xA2D0,0xE28883,0x2203,{0x00,0x00,0x00,0x00,0x1f,0xf0,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x1f,0xf0,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x1f,0xf0,0x00,0x00,0x00,0x00,0x00,0x00}}, // ∃
{0x225C,0x81DA,0xA2DC,0xE288A0,0x2220,{0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x10,0x00,0x20,0x00,0x40,0x00,0x80,0x01,0x00,0x02,0x00,0x04,0x00,0x08,0x00,0x10,0x00,0x3f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00}}, // ∠
{0x225D,0x81DB,0xA2DD,0xE28AA5,0x22A5,{0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x3f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⊥
{0x225E,0x81DC,0xA2DE,0xE28C92,0x2312,{0x07,0xe0,0x38,0x1c,0x40,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⌒
{0x225F,0x81DD,0xA2DF,0xE28882,0x2202,{0x00,0x00,0x00,0xc0,0x03,0x20,0x04,0x10,0x00,0x10,0x00,0x10,0x03,0xb0,0x04,0x60,0x0c,0x60,0x08,0x60,0x18,0x40,0x18,0xc0,0x09,0x80,0x06,0x00,0x00,0x00,0x00,0x00}}, // ∂
{0x2260,0x81DE,0xA2E0,0xE28887,0x2207,{0x00,0x00,0x7f,0xfe,0x20,0x04,0x30,0x04,0x10,0x08,0x18,0x08,0x08,0x10,0x0c,0x10,0x04,0x20,0x06,0x20,0x02,0x40,0x03,0x40,0x01,0x80,0x00,0x80,0x00,0x00,0x00,0x00}}, // ∇
{0x2261,0x81DF,0xA2E1,0xE289A1,0x2261,{0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ≡
{0x2262,0x81E0,0xA2E2,0xE28992,0x2252,{0x00,0x00,0x00,0x00,0x18,0x00,0x18,0x00,0x00,0x00,0x3f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0xfc,0x00,0x00,0x00,0x18,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00}}, // ≒
{0x2263,0x81E1,0xA2E3,0xE289AA,0x226A,{0x00,0x00,0x00,0x88,0x01,0x10,0x02,0x20,0x04,0x40,0x08,0x80,0x11,0x00,0x22,0x00,0x11,0x00,0x08,0x80,0x04,0x40,0x02,0x20,0x01,0x10,0x00,0x88,0x00,0x44,0x00,0x00}}, // ≪
{0x2264,0x81E2,0xA2E4,0xE289AB,0x226B,{0x00,0x00,0x11,0x00,0x08,0x80,0x04,0x40,0x02,0x20,0x01,0x10,0x00,0x88,0x00,0x44,0x00,0x88,0x01,0x10,0x02,0x20,0x04,0x40,0x08,0x80,0x11,0x00,0x22,0x00,0x00,0x00}}, // ≫
{0x2265,0x81E3,0xA2E5,0xE2889A,0x221A,{0x00,0xff,0x00,0x80,0x00,0x80,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x02,0x00,0x02,0x00,0x22,0x00,0x22,0x00,0x34,0x00,0x54,0x00,0x5c,0x00,0x08,0x00,0x08,0x00}}, // √
{0x2266,0x81E4,0xA2E6,0xE288BD,0x223D,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1c,0x38,0x20,0x44,0x40,0x82,0x40,0x82,0x41,0x02,0x41,0x02,0x22,0x04,0x1c,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ∽
{0x2267,0x81E5,0xA2E7,0xE2889D,0x221D,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1c,0x38,0x22,0x44,0x41,0x80,0x41,0x80,0x41,0x80,0x41,0x80,0x22,0x44,0x1c,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ∝
{0x2268,0x81E6,0xA2E8,0xE288B5,0x2235,{0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x0c,0x30,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00}}, // ∵
{0x2269,0x81E7,0xA2E9,0xE288AB,0x222B,{0x01,0xc0,0x02,0x40,0x02,0x00,0x02,0x00,0x03,0x00,0x03,0x00,0x01,0x00,0x01,0x80,0x01,0x80,0x00,0x80,0x00,0xc0,0x00,0xc0,0x00,0x40,0x00,0x40,0x02,0x40,0x03,0x80}}, // ∫
{0x226A,0x81E8,0xA2EA,0xE288AC,0x222C,{0x0e,0x38,0x12,0x48,0x10,0x40,0x10,0x40,0x18,0x60,0x18,0x60,0x08,0x20,0x0c,0x30,0x0c,0x30,0x04,0x10,0x06,0x18,0x06,0x18,0x02,0x08,0x02,0x08,0x12,0x48,0x1c,0x70}}, // ∬
{0x2272,0x81F0,0xA2F2,0xE284AB,0x212B,{0x00,0xc0,0x01,0x20,0x01,0x20,0x00,0xc0,0x00,0x80,0x00,0x80,0x01,0x40,0x01,0x40,0x02,0x20,0x02,0x20,0x03,0xe0,0x04,0x10,0x04,0x10,0x0e,0x38,0x00,0x00,0x00,0x00}}, // Å
{0x2273,0x81F1,0xA2F3,0xE280B0,0x2030,{0x00,0x00,0x00,0x08,0x18,0x10,0x34,0x20,0x24,0x20,0x24,0x40,0x24,0x80,0x2d,0x00,0x1a,0x00,0x05,0x8c,0x07,0x5a,0x0a,0x52,0x12,0x52,0x22,0xd6,0x41,0x8c,0x00,0x00}}, // ‰
{0x2274,0x81F2,0xA2F4,0xE299AF,0x266F,{0x00,0x20,0x04,0x20,0x04,0x20,0x04,0x3c,0x07,0xfc,0x3f,0xe0,0x3c,0x20,0x04,0x20,0x04,0x20,0x04,0x3c,0x07,0xfc,0x3f,0xe0,0x3c,0x20,0x04,0x20,0x04,0x20,0x04,0x00}}, // ♯
{0x2275,0x81F3,0xA2F5,0xE299AD,0x266D,{0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x05,0xe0,0x06,0x30,0x04,0x30,0x04,0x30,0x04,0x60,0x04,0xc0,0x05,0x00,0x06,0x00,0x04,0x00}}, // ♭
{0x2276,0x81F4,0xA2F6,0xE299AA,0x266A,{0x00,0x80,0x00,0x80,0x00,0xc0,0x00,0xe0,0x00,0xb0,0x00,0x98,0x00,0x8c,0x00,0x84,0x00,0x84,0x00,0x88,0x00,0x90,0x00,0x80,0x0f,0x80,0x1f,0x80,0x1f,0x00,0x0e,0x00}}, // ♪
{0x2277,0x81F5,0xA2F7,0xE280A0,0x2020,{0x00,0x80,0x01,0xc0,0x04,0x90,0x0f,0xf8,0x04,0x90,0x00,0x80,0x03,0xe0,0x01,0xc0,0x01,0xc0,0x01,0xc0,0x01,0xc0,0x01,0xc0,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // †
{0x2278,0x81F6,0xA2F8,0xE280A1,0x2021,{0x01,0x00,0x03,0x80,0x09,0x20,0x1f,0xf0,0x09,0x20,0x03,0x80,0x03,0x80,0x01,0x00,0x01,0x00,0x03,0x80,0x03,0x80,0x09,0x20,0x1f,0xf0,0x09,0x20,0x03,0x80,0x01,0x00}}, // ‡
{0x2279,0x81F7,0xA2F9,0xC2B6,  0x00B6,{0x00,0x00,0x07,0xe0,0x0f,0x20,0x1f,0x20,0x1f,0x20,0x0f,0x20,0x07,0x20,0x01,0x20,0x01,0x20,0x01,0x20,0x01,0x20,0x01,0x20,0x01,0x20,0x01,0x20,0x01,0x20,0x01,0x20}}, // ¶
{0x227E,0x81FC,0xA2FE,0xE297AF,0x25EF,{0x03,0xc0,0x0c,0x30,0x10,0x08,0x20,0x04,0x40,0x02,0x40,0x02,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x40,0x02,0x40,0x02,0x20,0x04,0x10,0x08,0x0c,0x30,0x03,0xc0}}, // ◯
{0x2330,0x824F,0xA3B0,0xEFBC90,0xFF10,{0x00,0x00,0x03,0xc0,0x04,0x20,0x08,0x10,0x08,0x10,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x08,0x10,0x08,0x10,0x04,0x20,0x03,0xc0,0x00,0x00}}, // ０
{0x2331,0x8250,0xA3B1,0xEFBC91,0xFF11,{0x00,0x00,0x00,0x80,0x00,0x80,0x01,0x80,0x02,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x01,0xc0,0x00,0x00}}, // １
{0x2332,0x8251,0xA3B2,0xEFBC92,0xFF12,{0x00,0x00,0x03,0xe0,0x04,0x10,0x08,0x08,0x08,0x08,0x00,0x08,0x00,0x10,0x00,0x20,0x00,0x40,0x00,0x80,0x01,0x00,0x02,0x00,0x04,0x00,0x04,0x00,0x0f,0xf8,0x00,0x00}}, // ２
{0x2333,0x8252,0xA3B3,0xEFBC93,0xFF13,{0x00,0x00,0x03,0xc0,0x0c,0x20,0x10,0x10,0x00,0x10,0x00,0x20,0x00,0x40,0x03,0xe0,0x00,0x10,0x00,0x08,0x00,0x08,0x00,0x08,0x10,0x10,0x0c,0x60,0x03,0x80,0x00,0x00}}, // ３
{0x2334,0x8253,0xA3B4,0xEFBC94,0xFF14,{0x00,0x00,0x00,0x20,0x00,0x20,0x00,0x60,0x00,0xa0,0x01,0x20,0x02,0x20,0x04,0x20,0x08,0x20,0x10,0x20,0x1f,0xfc,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x70,0x00,0x00}}, // ４
{0x2335,0x8254,0xA3B5,0xEFBC95,0xFF15,{0x00,0x00,0x0f,0xf8,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x0b,0xe0,0x0c,0x10,0x08,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x10,0x0c,0x60,0x03,0x80,0x00,0x00}}, // ５
{0x2336,0x8255,0xA3B6,0xEFBC96,0xFF16,{0x00,0x00,0x00,0xe0,0x03,0x00,0x04,0x00,0x08,0x00,0x08,0x00,0x13,0xc0,0x14,0x20,0x18,0x10,0x10,0x08,0x10,0x08,0x10,0x08,0x08,0x10,0x04,0x20,0x03,0xc0,0x00,0x00}}, // ６
{0x2337,0x8256,0xA3B7,0xEFBC97,0xFF17,{0x00,0x00,0x1f,0xf8,0x10,0x08,0x10,0x10,0x10,0x10,0x00,0x20,0x00,0x20,0x00,0x40,0x00,0x40,0x00,0x80,0x00,0x80,0x00,0x80,0x01,0x00,0x01,0x00,0x01,0x00,0x00,0x00}}, // ７
{0x2338,0x8257,0xA3B8,0xEFBC98,0xFF18,{0x00,0x00,0x03,0xc0,0x0c,0x30,0x10,0x08,0x10,0x08,0x10,0x08,0x0c,0x30,0x03,0xc0,0x04,0x20,0x08,0x10,0x10,0x08,0x10,0x08,0x18,0x18,0x0c,0x30,0x03,0xc0,0x00,0x00}}, // ８
{0x2339,0x8258,0xA3B9,0xEFBC99,0xFF19,{0x00,0x00,0x03,0xc0,0x04,0x20,0x08,0x10,0x10,0x08,0x10,0x08,0x10,0x08,0x08,0x18,0x04,0x28,0x03,0xc8,0x00,0x10,0x00,0x10,0x00,0x20,0x00,0xc0,0x07,0x00,0x00,0x00}}, // ９
{0x2341,0x8260,0xA3C1,0xEFBCA1,0xFF21,{0x00,0x00,0x00,0x80,0x00,0x80,0x01,0x40,0x01,0x40,0x02,0x20,0x02,0x20,0x04,0x10,0x07,0xf0,0x04,0x10,0x08,0x08,0x08,0x08,0x10,0x04,0x38,0x0e,0x00,0x00,0x00,0x00}}, // Ａ
{0x2342,0x8261,0xA3C2,0xEFBCA2,0xFF22,{0x00,0x00,0x3f,0xe0,0x08,0x10,0x08,0x08,0x08,0x08,0x08,0x10,0x0f,0xe0,0x08,0x10,0x08,0x08,0x08,0x04,0x08,0x04,0x08,0x08,0x08,0x30,0x3f,0xc0,0x00,0x00,0x00,0x00}}, // Ｂ
{0x2343,0x8262,0xA3C3,0xEFBCA3,0xFF23,{0x00,0x00,0x03,0xc8,0x0c,0x28,0x18,0x18,0x10,0x08,0x20,0x08,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x10,0x08,0x18,0x18,0x0c,0x30,0x03,0xc0,0x00,0x00,0x00,0x00}}, // Ｃ
{0x2344,0x8263,0xA3C4,0xEFBCA4,0xFF24,{0x00,0x00,0x3f,0x80,0x08,0x60,0x08,0x10,0x08,0x08,0x08,0x08,0x08,0x04,0x08,0x04,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x10,0x08,0x60,0x3f,0x80,0x00,0x00,0x00,0x00}}, // Ｄ
{0x2345,0x8264,0xA3C5,0xEFBCA5,0xFF25,{0x00,0x00,0x3f,0xf8,0x08,0x08,0x08,0x04,0x08,0x00,0x08,0x00,0x08,0x40,0x0f,0xc0,0x08,0x40,0x08,0x00,0x08,0x00,0x08,0x04,0x08,0x08,0x3f,0xf8,0x00,0x00,0x00,0x00}}, // Ｅ
{0x2346,0x8265,0xA3C6,0xEFBCA6,0xFF26,{0x00,0x00,0x1f,0xf8,0x04,0x08,0x04,0x04,0x04,0x00,0x04,0x00,0x04,0x20,0x07,0xe0,0x04,0x20,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x1f,0x00,0x00,0x00,0x00,0x00}}, // Ｆ
{0x2347,0x8266,0xA3C7,0xEFBCA7,0xFF27,{0x00,0x00,0x03,0xc8,0x0c,0x38,0x18,0x08,0x10,0x08,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x3e,0x20,0x08,0x10,0x08,0x18,0x18,0x0c,0x68,0x03,0x88,0x00,0x00,0x00,0x00}}, // Ｇ
{0x2348,0x8267,0xA3C8,0xEFBCA8,0xFF28,{0x00,0x00,0x38,0x1c,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x38,0x1c,0x00,0x00,0x00,0x00}}, // Ｈ
{0x2349,0x8268,0xA3C9,0xEFBCA9,0xFF29,{0x00,0x00,0x03,0x80,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x03,0x80,0x00,0x00,0x00,0x00}}, // Ｉ
{0x234A,0x8269,0xA3CA,0xEFBCAA,0xFF2A,{0x00,0x00,0x00,0x70,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x08,0x20,0x04,0x40,0x03,0x80,0x00,0x00,0x00,0x00}}, // Ｊ
{0x234B,0x826A,0xA3CB,0xEFBCAB,0xFF2B,{0x00,0x00,0x1c,0x1c,0x08,0x10,0x08,0x20,0x08,0x40,0x08,0x80,0x09,0x00,0x0b,0x00,0x0c,0x80,0x08,0x40,0x08,0x20,0x08,0x10,0x08,0x08,0x1c,0x0e,0x00,0x00,0x00,0x00}}, // Ｋ
{0x234C,0x826B,0xA3CC,0xEFBCAC,0xFF2C,{0x00,0x00,0x0e,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x04,0x04,0x04,0x0f,0xfc,0x00,0x00,0x00,0x00}}, // Ｌ
{0x234D,0x826C,0xA3CD,0xEFBCAD,0xFF2D,{0x00,0x00,0x60,0x0c,0x20,0x08,0x30,0x18,0x30,0x18,0x28,0x28,0x28,0x28,0x24,0x48,0x24,0x48,0x24,0x48,0x22,0x88,0x22,0x88,0x21,0x08,0x71,0x1c,0x00,0x00,0x00,0x00}}, // Ｍ
{0x234E,0x826D,0xA3CE,0xEFBCAE,0xFF2E,{0x00,0x00,0x38,0x1c,0x18,0x08,0x14,0x08,0x14,0x08,0x12,0x08,0x11,0x08,0x11,0x08,0x10,0x88,0x10,0x48,0x10,0x48,0x10,0x28,0x10,0x18,0x38,0x08,0x00,0x00,0x00,0x00}}, // Ｎ
{0x234F,0x826E,0xA3CF,0xEFBCAF,0xFF2F,{0x00,0x00,0x03,0xc0,0x0c,0x30,0x18,0x18,0x10,0x08,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x10,0x08,0x18,0x18,0x0c,0x30,0x03,0xc0,0x00,0x00,0x00,0x00}}, // Ｏ
{0x2350,0x826F,0xA3D0,0xEFBCB0,0xFF30,{0x00,0x00,0x1f,0xe0,0x04,0x18,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x18,0x07,0xe0,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x0e,0x00,0x00,0x00,0x00,0x00}}, // Ｐ
{0x2351,0x8270,0xA3D1,0xEFBCB1,0xFF31,{0x00,0x00,0x03,0xc0,0x0c,0x30,0x18,0x18,0x10,0x08,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x11,0x88,0x1a,0x50,0x0c,0x20,0x03,0xd2,0x00,0x0c,0x00,0x00}}, // Ｑ
{0x2352,0x8271,0xA3D2,0xEFBCB2,0xFF32,{0x00,0x00,0x3f,0xc0,0x08,0x30,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x30,0x0f,0xc0,0x08,0x20,0x08,0x20,0x08,0x10,0x08,0x10,0x08,0x08,0x1c,0x1c,0x00,0x00,0x00,0x00}}, // Ｒ
{0x2353,0x8272,0xA3D3,0xEFBCB3,0xFF33,{0x00,0x00,0x03,0xd0,0x04,0x30,0x08,0x10,0x08,0x00,0x08,0x00,0x04,0x00,0x03,0xc0,0x00,0x30,0x00,0x08,0x10,0x08,0x18,0x08,0x14,0x10,0x03,0xe0,0x00,0x00,0x00,0x00}}, // Ｓ
{0x2354,0x8273,0xA3D4,0xEFBCB4,0xFF34,{0x00,0x00,0x3f,0xf8,0x21,0x08,0x41,0x04,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x03,0x80,0x00,0x00,0x00,0x00}}, // Ｔ
{0x2355,0x8274,0xA3D5,0xEFBCB5,0xFF35,{0x00,0x00,0x38,0x1c,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x08,0x10,0x04,0x20,0x03,0xc0,0x00,0x00,0x00,0x00}}, // Ｕ
{0x2356,0x8275,0xA3D6,0xEFBCB6,0xFF36,{0x00,0x00,0x38,0x1c,0x10,0x08,0x10,0x08,0x08,0x10,0x08,0x10,0x08,0x20,0x04,0x20,0x04,0x40,0x04,0x40,0x02,0x80,0x02,0x80,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00}}, // Ｖ
{0x2357,0x8276,0xA3D7,0xEFBCB7,0xFF37,{0x00,0x00,0x71,0x8e,0x21,0x84,0x21,0x84,0x21,0x84,0x22,0x44,0x12,0x48,0x12,0x48,0x14,0x28,0x14,0x28,0x0c,0x28,0x0c,0x30,0x08,0x10,0x08,0x10,0x00,0x00,0x00,0x00}}, // Ｗ
{0x2358,0x8277,0xA3D8,0xEFBCB8,0xFF38,{0x00,0x00,0x38,0x38,0x10,0x10,0x08,0x20,0x04,0x40,0x04,0x40,0x02,0x80,0x01,0x00,0x02,0x80,0x04,0x40,0x04,0x40,0x08,0x20,0x10,0x10,0x38,0x38,0x00,0x00,0x00,0x00}}, // Ｘ
{0x2359,0x8278,0xA3D9,0xEFBCB9,0xFF39,{0x00,0x00,0x38,0x38,0x10,0x10,0x08,0x20,0x08,0x20,0x04,0x40,0x04,0x40,0x02,0x80,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x03,0x80,0x00,0x00,0x00,0x00}}, // Ｙ
{0x235A,0x8279,0xA3DA,0xEFBCBA,0xFF3A,{0x00,0x00,0x0f,0xf8,0x08,0x10,0x10,0x20,0x00,0x40,0x00,0x40,0x00,0x80,0x01,0x00,0x01,0x00,0x02,0x00,0x04,0x00,0x04,0x08,0x08,0x08,0x1f,0xf8,0x00,0x00,0x00,0x00}}, // Ｚ
{0x2361,0x8281,0xA3E1,0xEFBD81,0xFF41,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xc0,0x04,0x20,0x00,0x20,0x03,0xa0,0x04,0x60,0x08,0x20,0x08,0x60,0x08,0xa8,0x07,0x18,0x00,0x00,0x00,0x00}}, // ａ
{0x2362,0x8282,0xA3E2,0xEFBD82,0xFF42,{0x00,0x00,0x0c,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x05,0xc0,0x06,0x20,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x06,0x20,0x05,0xc0,0x00,0x00,0x00,0x00}}, // ｂ
{0x2363,0x8283,0xA3E3,0xEFBD83,0xFF43,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x80,0x04,0x40,0x08,0x20,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x20,0x04,0x40,0x03,0x80,0x00,0x00,0x00,0x00}}, // ｃ
{0x2364,0x8284,0xA3E4,0xEFBD84,0xFF44,{0x00,0x00,0x00,0x60,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x03,0xa0,0x04,0x60,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x04,0x60,0x03,0xb0,0x00,0x00,0x00,0x00}}, // ｄ
{0x2365,0x8285,0xA3E5,0xEFBD85,0xFF45,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x80,0x04,0x40,0x08,0x20,0x08,0x20,0x0f,0xe0,0x08,0x00,0x08,0x00,0x04,0x20,0x03,0xc0,0x00,0x00,0x00,0x00}}, // ｅ
{0x2366,0x8286,0xA3E6,0xEFBD86,0xFF46,{0x00,0x00,0x00,0xf0,0x01,0x90,0x01,0x00,0x01,0x00,0x0f,0xf0,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x03,0x80,0x00,0x00,0x00,0x00}}, // ｆ
{0x2367,0x8287,0xA3E7,0xEFBD87,0xFF47,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xd0,0x06,0x20,0x04,0x20,0x04,0x20,0x03,0xc0,0x04,0x00,0x07,0xe0,0x08,0x18,0x08,0x08,0x04,0x18,0x03,0xe0}}, // ｇ
{0x2368,0x8288,0xA3E8,0xEFBD88,0xFF48,{0x00,0x00,0x0c,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x05,0xc0,0x06,0x20,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x0e,0x38,0x00,0x00,0x00,0x00}}, // ｈ
{0x2369,0x8289,0xA3E9,0xEFBD89,0xFF49,{0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00,0x01,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x01,0xc0,0x00,0x00,0x00,0x00}}, // ｉ
{0x236A,0x828A,0xA3EA,0xEFBD8A,0xFF4A,{0x00,0x00,0x00,0xc0,0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x08,0x80,0x07,0x00}}, // ｊ
{0x236B,0x828B,0xA3EB,0xEFBD8B,0xFF4B,{0x00,0x00,0x18,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x70,0x08,0x40,0x09,0x80,0x0e,0x00,0x09,0x00,0x08,0x80,0x08,0x40,0x08,0x20,0x1c,0x78,0x00,0x00,0x00,0x00}}, // ｋ
{0x236C,0x828C,0xA3EC,0xEFBD8C,0xFF4C,{0x00,0x00,0x03,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x03,0x80,0x00,0x00,0x00,0x00}}, // ｌ
{0x236D,0x828D,0xA3ED,0xEFBD8D,0xFF4D,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x17,0x30,0x09,0xc8,0x08,0x88,0x08,0x88,0x08,0x88,0x08,0x88,0x08,0x88,0x08,0x88,0x1d,0xdc,0x00,0x00,0x00,0x00}}, // ｍ
{0x236E,0x828E,0xA3EE,0xEFBD8E,0xFF4E,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0xe0,0x05,0x30,0x06,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x0e,0x38,0x00,0x00,0x00,0x00}}, // ｎ
{0x236F,0x828F,0xA3EF,0xEFBD8F,0xFF4F,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xc0,0x04,0x20,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x04,0x20,0x03,0xc0,0x00,0x00,0x00,0x00}}, // ｏ
{0x2370,0x8290,0xA3F0,0xEFBD90,0xFF50,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0d,0xc0,0x06,0x20,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x06,0x20,0x05,0xc0,0x04,0x00,0x04,0x00,0x0e,0x00}}, // ｐ
{0x2371,0x8291,0xA3F1,0xEFBD91,0xFF51,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xb0,0x04,0x60,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x04,0x60,0x03,0xa0,0x00,0x20,0x00,0x20,0x00,0x70}}, // ｑ
{0x2372,0x8292,0xA3F2,0xEFBD92,0xFF52,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x70,0x02,0x90,0x03,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x07,0x00,0x00,0x00,0x00,0x00}}, // ｒ
{0x2373,0x8293,0xA3F3,0xEFBD93,0xFF53,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xd0,0x04,0x30,0x04,0x10,0x03,0x00,0x00,0xc0,0x00,0x20,0x04,0x10,0x06,0x10,0x05,0xe0,0x00,0x00,0x00,0x00}}, // ｓ
{0x2374,0x8294,0xA3F4,0xEFBD94,0xFF54,{0x00,0x00,0x00,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x1f,0xe0,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x03,0x40,0x01,0xc0,0x00,0x00,0x00,0x00}}, // ｔ
{0x2375,0x8295,0xA3F5,0xEFBD95,0xFF55,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x30,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x02,0x30,0x01,0xd8,0x00,0x00,0x00,0x00}}, // ｕ
{0x2376,0x8296,0xA3F6,0xEFBD96,0xFF56,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1c,0x70,0x08,0x20,0x08,0x20,0x04,0x40,0x04,0x40,0x02,0x80,0x02,0x80,0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00}}, // ｖ
{0x2377,0x8297,0xA3F7,0xEFBD97,0xFF57,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x39,0x1c,0x11,0x08,0x11,0x88,0x11,0x88,0x0a,0x50,0x0a,0x50,0x0a,0x50,0x04,0x20,0x04,0x20,0x00,0x00,0x00,0x00}}, // ｗ
{0x2378,0x8298,0xA3F8,0xEFBD98,0xFF58,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x30,0x04,0x20,0x02,0x40,0x01,0x80,0x01,0x80,0x02,0x40,0x04,0x20,0x08,0x10,0x1c,0x38,0x00,0x00,0x00,0x00}}, // ｘ
{0x2379,0x8299,0xA3F9,0xEFBD99,0xFF59,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,0x38,0x04,0x10,0x04,0x10,0x02,0x20,0x02,0x20,0x01,0x40,0x01,0x40,0x00,0x80,0x00,0x80,0x09,0x00,0x06,0x00}}, // ｙ
{0x237A,0x829A,0xA3FA,0xEFBD9A,0xFF5A,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0xf0,0x08,0x20,0x00,0x40,0x00,0x80,0x00,0x80,0x01,0x00,0x02,0x10,0x04,0x10,0x0f,0xf0,0x00,0x00,0x00,0x00}}, // ｚ
{0x2421,0x829F,0xA4A1,0xE38181,0x3041,{0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x02,0xc0,0x0f,0x00,0x02,0x40,0x03,0xe0,0x02,0x50,0x06,0x88,0x0a,0x88,0x13,0x08,0x16,0x10,0x09,0x20,0x00,0x40,0x00,0x00}}, // ぁ
{0x2422,0x82A0,0xA4A2,0xE38182,0x3042,{0x02,0x00,0x01,0x00,0x11,0x60,0x0f,0x80,0x02,0x00,0x02,0x40,0x03,0xf0,0x04,0x48,0x0c,0x44,0x14,0x82,0x25,0x02,0x22,0x02,0x15,0x04,0x18,0x18,0x00,0x60,0x00,0x00}}, // あ
{0x2423,0x82A1,0xA4A3,0xE38183,0x3043,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x04,0x00,0x04,0x10,0x08,0x08,0x08,0x04,0x08,0x0c,0x05,0x04,0x06,0x00,0x02,0x00,0x00,0x00}}, // ぃ
{0x2424,0x82A2,0xA4A4,0xE38184,0x3044,{0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x08,0x10,0x08,0x08,0x08,0x04,0x10,0x04,0x10,0x02,0x11,0x02,0x12,0x06,0x0a,0x02,0x04,0x00,0x04,0x00,0x00,0x00,0x00,0x00}}, // い
{0x2425,0x82A3,0xA4A5,0xE38185,0x3045,{0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x04,0xe0,0x03,0x10,0x00,0x10,0x00,0x10,0x00,0x20,0x00,0x20,0x00,0x40,0x00,0x80,0x00,0x00}}, // ぅ
{0x2426,0x82A4,0xA4A6,0xE38186,0x3046,{0x01,0x00,0x00,0xe0,0x00,0x00,0x00,0x00,0x08,0xe0,0x07,0x10,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x10,0x00,0x10,0x00,0x20,0x00,0x40,0x00,0x80,0x01,0x00}}, // う
{0x2427,0x82A5,0xA4A7,0xE38187,0x3047,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x01,0x80,0x00,0x00,0x00,0x00,0x09,0xe0,0x06,0x40,0x00,0x80,0x01,0x00,0x06,0x80,0x08,0x80,0x10,0x80,0x00,0x78}}, // ぇ
{0x2428,0x82A6,0xA4A8,0xE38188,0x3048,{0x02,0x00,0x01,0x00,0x00,0xc0,0x00,0x00,0x08,0xf0,0x07,0x20,0x00,0x40,0x00,0x80,0x01,0x00,0x03,0x80,0x04,0x40,0x08,0x40,0x10,0x40,0x20,0x20,0x00,0x1c,0x00,0x00}}, // え
{0x2429,0x82A7,0xA4A9,0xE38189,0x3049,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x02,0x00,0x0a,0xd0,0x07,0x0c,0x02,0x00,0x02,0xe0,0x03,0x10,0x06,0x08,0x1a,0x48,0x06,0x30,0x02,0x00,0x00,0x00}}, // ぉ
{0x242A,0x82A8,0xA4AA,0xE3818A,0x304A,{0x08,0x00,0x04,0x00,0x04,0x10,0x04,0x8c,0x07,0x02,0x3c,0x07,0x04,0x00,0x04,0xf0,0x07,0x08,0x04,0x04,0x0c,0x04,0x64,0x04,0x34,0x48,0x0c,0x30,0x04,0x00,0x00,0x00}}, // お
{0x242B,0x82A9,0xA4AB,0xE3818B,0x304B,{0x00,0x00,0x08,0x00,0x04,0x00,0x04,0x10,0x04,0x08,0x27,0x84,0x1c,0x44,0x04,0x42,0x04,0x46,0x08,0x42,0x08,0x40,0x10,0x40,0x14,0x80,0x22,0x80,0x01,0x00,0x00,0x00}}, // か
{0x242C,0x82AA,0xA4AC,0xE3818C,0x304C,{0x00,0x00,0x08,0x02,0x04,0x05,0x04,0x15,0x04,0x08,0x27,0x84,0x1c,0x44,0x04,0x42,0x04,0x46,0x08,0x42,0x08,0x40,0x10,0x40,0x14,0x80,0x22,0x80,0x01,0x00,0x00,0x00}}, // が
{0x242D,0x82AB,0xA4AD,0xE3818D,0x304D,{0x01,0x00,0x00,0x88,0x00,0xb0,0x07,0xc0,0x00,0x44,0x00,0x78,0x0f,0xa0,0x00,0x10,0x00,0x10,0x03,0xe8,0x04,0x18,0x08,0x00,0x08,0x00,0x06,0x00,0x01,0xe0,0x00,0x00}}, // き
{0x242E,0x82AC,0xA4AE,0xE3818E,0x304E,{0x01,0x04,0x01,0x12,0x01,0x6a,0x1f,0x80,0x00,0x88,0x00,0xf0,0x3f,0x40,0x00,0x20,0x00,0x20,0x07,0xd0,0x08,0x30,0x10,0x00,0x10,0x00,0x0c,0x00,0x03,0xc0,0x00,0x00}}, // ぎ
{0x242F,0x82AD,0xA4AF,0xE3818F,0x304F,{0x00,0x20,0x00,0x20,0x00,0x40,0x00,0x40,0x00,0x80,0x01,0x00,0x02,0x00,0x04,0x00,0x02,0x00,0x01,0x00,0x00,0x80,0x00,0x40,0x00,0x40,0x00,0x20,0x00,0x20,0x00,0x00}}, // く
{0x2430,0x82AE,0xA4B0,0xE38190,0x3050,{0x00,0x20,0x00,0x20,0x00,0x44,0x00,0x52,0x00,0x8a,0x01,0x08,0x02,0x00,0x04,0x00,0x02,0x00,0x01,0x00,0x00,0x80,0x00,0x40,0x00,0x40,0x00,0x20,0x00,0x20,0x00,0x00}}, // ぐ
{0x2431,0x82AF,0xA4B1,0xE38191,0x3051,{0x00,0x20,0x20,0x20,0x10,0x10,0x10,0x10,0x10,0x1e,0x23,0xf0,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x28,0x10,0x10,0x10,0x10,0x20,0x00,0x20,0x00,0x40,0x00,0x80}}, // け
{0x2432,0x82B0,0xA4B2,0xE38192,0x3052,{0x00,0x22,0x20,0x29,0x10,0x15,0x10,0x14,0x10,0x1e,0x23,0xf0,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x28,0x10,0x10,0x10,0x10,0x20,0x00,0x20,0x00,0x40,0x00,0x80}}, // げ
{0x2433,0x82B1,0xA4B3,0xE38193,0x3053,{0x00,0x00,0x00,0x00,0x04,0x00,0x03,0xf8,0x00,0x20,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x08,0x04,0x07,0xf8,0x00,0x00,0x00,0x00}}, // こ
{0x2434,0x82B2,0xA4B4,0xE38194,0x3054,{0x00,0x04,0x00,0x12,0x04,0x0a,0x03,0xf8,0x00,0x20,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x08,0x04,0x07,0xf8,0x00,0x00,0x00,0x00}}, // ご
{0x2435,0x82B3,0xA4B5,0xE38195,0x3055,{0x01,0x00,0x00,0x80,0x00,0x4c,0x08,0x70,0x07,0xa0,0x00,0x20,0x00,0x10,0x00,0x10,0x03,0xe8,0x04,0x18,0x08,0x00,0x08,0x00,0x04,0x00,0x03,0x00,0x00,0xf0,0x00,0x00}}, // さ
{0x2436,0x82B4,0xA4B6,0xE38196,0x3056,{0x01,0x00,0x00,0x82,0x00,0x49,0x08,0x75,0x07,0xa4,0x00,0x20,0x00,0x10,0x00,0x10,0x03,0xe8,0x04,0x18,0x08,0x00,0x08,0x00,0x04,0x00,0x03,0x00,0x00,0xf0,0x00,0x00}}, // ざ
{0x2437,0x82B5,0xA4B7,0xE38197,0x3057,{0x00,0x00,0x10,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x08,0x08,0x10,0x04,0x60,0x03,0x80,0x00,0x00}}, // し
{0x2438,0x82B6,0xA4B8,0xE38198,0x3058,{0x00,0x00,0x10,0x00,0x08,0x10,0x08,0x48,0x08,0x28,0x08,0x20,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x08,0x08,0x10,0x04,0x60,0x03,0x80,0x00,0x00}}, // じ
{0x2439,0x82B7,0xA4B9,0xE38199,0x3059,{0x00,0x80,0x00,0x40,0x20,0x7e,0x1f,0xc0,0x00,0x40,0x00,0x40,0x03,0xc0,0x06,0x40,0x04,0x20,0x02,0x60,0x01,0xa0,0x00,0x20,0x00,0x40,0x00,0x40,0x00,0x80,0x01,0x00}}, // す
{0x243A,0x82B8,0xA4BA,0xE3819A,0x305A,{0x01,0x02,0x00,0x81,0x40,0xfd,0x3f,0x84,0x00,0x80,0x00,0x80,0x07,0x80,0x0c,0x80,0x08,0x40,0x04,0xc0,0x03,0x40,0x00,0x40,0x00,0x80,0x00,0x80,0x01,0x00,0x02,0x00}}, // ず
{0x243B,0x82B9,0xA4BB,0xE3819B,0x305B,{0x00,0x00,0x00,0x40,0x08,0x20,0x04,0x20,0x04,0x3e,0x45,0xe0,0x3e,0x20,0x04,0x20,0x04,0x20,0x04,0x60,0x04,0x20,0x04,0x00,0x02,0x00,0x01,0xf8,0x00,0x00,0x00,0x00}}, // せ
{0x243C,0x82BA,0xA4BC,0xE3819C,0x305C,{0x00,0x02,0x00,0x49,0x08,0x25,0x04,0x24,0x04,0x3e,0x45,0xe0,0x3e,0x20,0x04,0x20,0x04,0x20,0x04,0x60,0x04,0x20,0x04,0x00,0x02,0x00,0x01,0xf8,0x00,0x00,0x00,0x00}}, // ぜ
{0x243D,0x82BB,0xA4BD,0xE3819D,0x305D,{0x00,0x00,0x04,0xe0,0x03,0x20,0x00,0x40,0x00,0x80,0x01,0x00,0x02,0x3c,0x07,0xc0,0x38,0x80,0x01,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x01,0x00,0x00,0xe0,0x00,0x00}}, // そ
{0x243E,0x82BC,0xA4BE,0xE3819E,0x305E,{0x00,0x04,0x04,0xf2,0x03,0x2a,0x00,0x48,0x00,0x80,0x01,0x00,0x02,0x3c,0x07,0xc0,0x38,0x80,0x01,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x01,0x00,0x00,0xe0,0x00,0x00}}, // ぞ
{0x243F,0x82BD,0xA4BF,0xE3819F,0x305F,{0x08,0x00,0x04,0x00,0x04,0x40,0x05,0x80,0x06,0x00,0x3c,0x00,0x08,0x38,0x08,0xcc,0x08,0x10,0x10,0x00,0x10,0x00,0x11,0x00,0x21,0x00,0x20,0x80,0x20,0x7c,0x00,0x00}}, // た
{0x2440,0x82BE,0xA4C0,0xE381A0,0x3060,{0x08,0x04,0x04,0x12,0x04,0x4a,0x05,0x88,0x06,0x00,0x3c,0x00,0x08,0x38,0x08,0xcc,0x08,0x10,0x10,0x00,0x10,0x00,0x11,0x00,0x21,0x00,0x20,0x80,0x20,0x7c,0x00,0x00}}, // だ
{0x2441,0x82BF,0xA4C1,0xE381A1,0x3061,{0x04,0x00,0x02,0x00,0x02,0x30,0x23,0xc0,0x1e,0x00,0x02,0x00,0x04,0x00,0x04,0xf0,0x07,0x08,0x0c,0x04,0x08,0x04,0x00,0x04,0x00,0x08,0x00,0x30,0x03,0xc0,0x00,0x00}}, // ち
{0x2442,0x82C0,0xA4C2,0xE381A2,0x3062,{0x04,0x04,0x02,0x12,0x02,0x2a,0x23,0xc8,0x1e,0x00,0x02,0x00,0x04,0x00,0x04,0xf0,0x07,0x08,0x0c,0x04,0x08,0x04,0x00,0x04,0x00,0x08,0x00,0x30,0x03,0xc0,0x00,0x00}}, // ぢ
{0x2443,0x82C1,0xA4C3,0xE381A3,0x3063,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xf0,0x0e,0x08,0x00,0x08,0x00,0x08,0x00,0x10,0x00,0x60,0x01,0x80,0x00,0x00}}, // っ
{0x2444,0x82C2,0xA4C4,0xE381A4,0x3064,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x03,0x88,0x4c,0x04,0x30,0x02,0x00,0x02,0x00,0x02,0x00,0x04,0x00,0x08,0x00,0x30,0x01,0xc0,0x00,0x00,0x00,0x00,0x00,0x00}}, // つ
{0x2445,0x82C3,0xA4C5,0xE381A5,0x3065,{0x00,0x02,0x00,0x09,0x00,0x05,0x00,0x74,0x03,0x88,0x4c,0x04,0x30,0x02,0x00,0x02,0x00,0x02,0x00,0x04,0x00,0x08,0x00,0x30,0x01,0xc0,0x00,0x00,0x00,0x00,0x00,0x00}}, // づ
{0x2446,0x82C4,0xA4C6,0xE381A6,0x3066,{0x00,0x00,0x00,0x1e,0x43,0xf0,0x3c,0x20,0x00,0x40,0x00,0x80,0x00,0x80,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x00,0x80,0x00,0x40,0x00,0x38,0x00,0x00,0x00,0x00}}, // て
{0x2447,0x82C5,0xA4C7,0xE381A7,0x3067,{0x00,0x00,0x00,0x0e,0x43,0xf0,0x3c,0x22,0x00,0x49,0x00,0x85,0x00,0x84,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x00,0x80,0x00,0x40,0x00,0x38,0x00,0x00,0x00,0x00}}, // で
{0x2448,0x82C6,0xA4C8,0xE381A8,0x3068,{0x00,0x00,0x04,0x00,0x02,0x00,0x02,0x00,0x02,0x08,0x01,0x0c,0x01,0x30,0x01,0x40,0x01,0x80,0x02,0x00,0x04,0x00,0x08,0x00,0x08,0x00,0x04,0x00,0x03,0xfc,0x00,0x00}}, // と
{0x2449,0x82C7,0xA4C9,0xE381A9,0x3069,{0x00,0x00,0x08,0x04,0x04,0x12,0x04,0x0a,0x04,0x08,0x02,0x18,0x02,0x60,0x02,0x80,0x03,0x00,0x04,0x00,0x08,0x00,0x10,0x00,0x10,0x00,0x08,0x00,0x07,0xf8,0x00,0x00}}, // ど
{0x244A,0x82C8,0xA4CA,0xE381AA,0x306A,{0x04,0x00,0x02,0x40,0x03,0x80,0x3e,0x10,0x04,0x0c,0x04,0x12,0x08,0x20,0x08,0x20,0x10,0x20,0x10,0x20,0x20,0x20,0x03,0xe0,0x04,0x38,0x04,0x24,0x03,0xc0,0x00,0x00}}, // な
{0x244B,0x82C9,0xA4CB,0xE381AB,0x306B,{0x00,0x00,0x20,0x00,0x10,0x00,0x10,0x78,0x11,0x8c,0x10,0x10,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x21,0x00,0x21,0x00,0x28,0x80,0x10,0x7c,0x10,0x00,0x00,0x00}}, // に
{0x244C,0x82CA,0xA4CC,0xE381AC,0x306C,{0x00,0x00,0x01,0x00,0x00,0x80,0x10,0x80,0x13,0xf0,0x14,0x88,0x18,0x84,0x11,0x02,0x29,0x02,0x2a,0x02,0x44,0x02,0x4c,0x34,0x52,0x4c,0x22,0x4a,0x00,0x30,0x00,0x00}}, // ぬ
{0x244D,0x82CB,0xA4CD,0xE381AD,0x306D,{0x10,0x00,0x08,0x00,0x08,0x00,0x0a,0x70,0x4c,0x88,0x3d,0x04,0x0a,0x04,0x0c,0x04,0x08,0x04,0x18,0x04,0x18,0x3c,0x28,0x44,0x48,0x46,0x18,0x38,0x08,0x00,0x00,0x00}}, // ね
{0x244E,0x82CC,0xA4CE,0xE381AE,0x306E,{0x00,0x00,0x00,0x00,0x01,0xe0,0x06,0x90,0x08,0x88,0x10,0x84,0x10,0x84,0x21,0x02,0x21,0x02,0x22,0x04,0x14,0x04,0x18,0x08,0x00,0x10,0x00,0x60,0x00,0x00,0x00,0x00}}, // の
{0x244F,0x82CD,0xA4CF,0xE381AF,0x306F,{0x00,0x20,0x20,0x10,0x10,0x10,0x10,0x10,0x12,0x1e,0x11,0xf0,0x10,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x29,0xf0,0x32,0x1c,0x12,0x12,0x11,0xe0,0x00,0x00}}, // は
{0x2450,0x82CE,0xA4D0,0xE381B0,0x3070,{0x00,0x22,0x20,0x19,0x10,0x15,0x10,0x14,0x12,0x1e,0x11,0xf0,0x10,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x29,0xf0,0x32,0x1c,0x12,0x12,0x11,0xe0,0x00,0x00}}, // ば
{0x2451,0x82CF,0xA4D1,0xE381B1,0x3071,{0x00,0x20,0x20,0x16,0x10,0x19,0x10,0x19,0x12,0x1e,0x11,0xf0,0x10,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x29,0xf0,0x32,0x1c,0x12,0x12,0x11,0xe0,0x00,0x00}}, // ぱ
{0x2452,0x82D0,0xA4D2,0xE381B2,0x3072,{0x00,0x00,0x00,0x20,0x02,0x20,0x0e,0x30,0x74,0x10,0x08,0x10,0x08,0x18,0x10,0x14,0x10,0x12,0x20,0x10,0x20,0x10,0x20,0x20,0x10,0x20,0x08,0xc0,0x07,0x00,0x00,0x00}}, // ひ
{0x2453,0x82D1,0xA4D3,0xE381B3,0x3073,{0x00,0x02,0x00,0x29,0x02,0x25,0x0e,0x34,0x74,0x10,0x08,0x10,0x08,0x18,0x10,0x14,0x10,0x12,0x20,0x10,0x20,0x10,0x20,0x20,0x10,0x20,0x08,0xc0,0x07,0x00,0x00,0x00}}, // び
{0x2454,0x82D2,0xA4D4,0xE381B4,0x3074,{0x00,0x00,0x00,0x26,0x02,0x29,0x0e,0x39,0x74,0x16,0x08,0x10,0x08,0x18,0x10,0x14,0x10,0x12,0x20,0x10,0x20,0x10,0x20,0x20,0x10,0x20,0x08,0xc0,0x07,0x00,0x00,0x00}}, // ぴ
{0x2455,0x82D3,0xA4D5,0xE381B5,0x3075,{0x00,0x00,0x02,0x00,0x01,0xc0,0x00,0x40,0x00,0x80,0x01,0x00,0x01,0x00,0x00,0x80,0x00,0x50,0x04,0x4c,0x48,0x22,0x30,0x27,0x24,0x20,0x02,0x40,0x01,0x80,0x00,0x00}}, // ふ
{0x2456,0x82D4,0xA4D6,0xE381B6,0x3076,{0x00,0x04,0x02,0x12,0x01,0xca,0x00,0x48,0x00,0x80,0x01,0x00,0x01,0x00,0x00,0x80,0x00,0x50,0x04,0x4c,0x48,0x22,0x30,0x27,0x24,0x20,0x02,0x40,0x01,0x80,0x00,0x00}}, // ぶ
{0x2457,0x82D5,0xA4D7,0xE381B7,0x3077,{0x00,0x00,0x02,0x0c,0x01,0xd2,0x00,0x52,0x00,0x8c,0x01,0x00,0x01,0x00,0x00,0x80,0x00,0x50,0x04,0x4c,0x48,0x22,0x30,0x27,0x24,0x20,0x02,0x40,0x01,0x80,0x00,0x00}}, // ぷ
{0x2458,0x82D6,0xA4D8,0xE381B8,0x3078,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x04,0x80,0x04,0x40,0x08,0x20,0x50,0x10,0x20,0x0c,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // へ
{0x2459,0x82D7,0xA4D9,0xE381B9,0x3079,{0x00,0x00,0x00,0x08,0x00,0x24,0x00,0x14,0x03,0x10,0x04,0x80,0x04,0x40,0x08,0x20,0x50,0x10,0x20,0x0c,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // べ
{0x245A,0x82D8,0xA4DA,0xE381BA,0x307A,{0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x24,0x03,0x24,0x04,0x98,0x04,0x40,0x08,0x20,0x50,0x10,0x20,0x0c,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ぺ
{0x245B,0x82D9,0xA4DB,0xE381BB,0x307B,{0x00,0x00,0x21,0x0c,0x10,0xf0,0x10,0x10,0x10,0x10,0x10,0x1e,0x13,0xf0,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x29,0xf0,0x32,0x1c,0x12,0x12,0x11,0xe0,0x00,0x00}}, // ほ
{0x245C,0x82DA,0xA4DC,0xE381BC,0x307C,{0x00,0x02,0x21,0x0d,0x10,0xf5,0x10,0x10,0x10,0x10,0x10,0x1e,0x13,0xf0,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x29,0xf0,0x32,0x1c,0x12,0x12,0x11,0xe0,0x00,0x00}}, // ぼ
{0x245D,0x82DB,0xA4DD,0xE381BD,0x307D,{0x00,0x06,0x21,0x09,0x10,0xf9,0x10,0x16,0x10,0x10,0x10,0x1e,0x13,0xf0,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x29,0xf0,0x32,0x1c,0x12,0x12,0x11,0xe0,0x00,0x00}}, // ぽ
{0x245E,0x82DC,0xA4DE,0xE381BE,0x307E,{0x00,0x80,0x00,0x40,0x10,0x78,0x0f,0xc0,0x00,0x40,0x00,0x40,0x10,0x70,0x0f,0xc0,0x00,0x40,0x00,0x40,0x07,0xc0,0x08,0x70,0x10,0x4c,0x18,0x40,0x07,0x80,0x00,0x00}}, // ま
{0x245F,0x82DD,0xA4DF,0xE381BF,0x307F,{0x00,0x00,0x00,0x00,0x08,0x80,0x07,0x80,0x01,0x00,0x01,0x10,0x01,0x08,0x07,0xc8,0x1a,0x38,0x22,0x0c,0x44,0x12,0x44,0x10,0x48,0x20,0x30,0x40,0x00,0x80,0x00,0x00}}, // み
{0x2460,0x82DE,0xA4E0,0xE38280,0x3080,{0x08,0x00,0x04,0x00,0x27,0x80,0x1c,0x18,0x04,0x04,0x04,0x06,0x1c,0x00,0x24,0x00,0x24,0x10,0x24,0x08,0x28,0x08,0x18,0x08,0x08,0x08,0x08,0x10,0x07,0xe0,0x00,0x00}}, // む
{0x2461,0x82DF,0xA4E1,0xE38281,0x3081,{0x00,0x00,0x00,0x80,0x00,0x40,0x10,0x40,0x11,0xe0,0x16,0x98,0x18,0x84,0x18,0x84,0x29,0x02,0x25,0x02,0x42,0x02,0x46,0x04,0x49,0x04,0x30,0x08,0x00,0x30,0x00,0x00}}, // め
{0x2462,0x82E0,0xA4E2,0xE38282,0x3082,{0x02,0x00,0x01,0x00,0x09,0x00,0x07,0x00,0x01,0xc0,0x0a,0x00,0x32,0x00,0x1a,0x10,0x07,0x88,0x04,0x08,0x04,0x08,0x04,0x08,0x04,0x10,0x02,0x20,0x01,0xc0,0x00,0x00}}, // も
{0x2463,0x82E1,0xA4E3,0xE38283,0x3083,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x04,0x60,0x04,0x00,0x04,0xf0,0x03,0x08,0x2e,0x08,0x12,0x10,0x02,0x60,0x01,0x00,0x01,0x00,0x01,0x00,0x00,0x00}}, // ゃ
{0x2464,0x82E2,0xA4E4,0xE38284,0x3084,{0x00,0x00,0x00,0x80,0x00,0x60,0x0c,0x30,0x08,0x00,0x04,0x3c,0x05,0xc2,0x4e,0x02,0x32,0x02,0x02,0x04,0x01,0x38,0x01,0x00,0x01,0x00,0x00,0x80,0x00,0x80,0x00,0x80}}, // や
{0x2465,0x82E3,0xA4E5,0xE38285,0x3085,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x80,0x21,0xe0,0x12,0x90,0x14,0x88,0x18,0x88,0x18,0x88,0x12,0x90,0x11,0xe0,0x00,0x80,0x01,0x00,0x02,0x00}}, // ゅ
{0x2466,0x82E4,0xA4E6,0xE38286,0x3086,{0x00,0x00,0x01,0x80,0x00,0x40,0x40,0xf0,0x21,0x48,0x22,0x44,0x24,0x42,0x28,0x42,0x30,0x42,0x32,0x44,0x21,0x48,0x20,0xf0,0x00,0x40,0x00,0x80,0x01,0x00,0x00,0x00}}, // ゆ
{0x2467,0x82E5,0xA4E7,0xE38287,0x3087,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x01,0x00,0x01,0x20,0x01,0xc0,0x01,0x00,0x01,0x00,0x01,0x00,0x0f,0x00,0x11,0xc0,0x11,0x30,0x0e,0x00,0x00,0x00}}, // ょ
{0x2468,0x82E6,0xA4E8,0xE38288,0x3088,{0x01,0x00,0x00,0x80,0x00,0x80,0x00,0x8c,0x00,0xf0,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x1f,0x80,0x20,0xe0,0x20,0x98,0x21,0x04,0x1e,0x00,0x00,0x00}}, // よ
{0x2469,0x82E7,0xA4E9,0xE38289,0x3089,{0x01,0x00,0x00,0x80,0x00,0xe0,0x01,0x00,0x04,0x00,0x08,0x00,0x08,0x00,0x08,0xf0,0x0b,0x08,0x0c,0x04,0x08,0x04,0x08,0x08,0x00,0x10,0x00,0x60,0x03,0x80,0x00,0x00}}, // ら
{0x246A,0x82E8,0xA4EA,0xE3828A,0x308A,{0x10,0x00,0x09,0xc0,0x0a,0x20,0x0a,0x10,0x0c,0x10,0x0c,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x00,0x20,0x00,0x20,0x00,0x40,0x00,0x80,0x01,0x00,0x02,0x00}}, // り
{0x246B,0x82E9,0xA4EB,0xE3828B,0x308B,{0x00,0x00,0x04,0xe0,0x03,0x20,0x00,0x40,0x00,0x80,0x01,0x00,0x03,0xe0,0x06,0x10,0x08,0x08,0x10,0x04,0x00,0x04,0x03,0x04,0x04,0x88,0x04,0x70,0x03,0xc0,0x00,0x00}}, // る
{0x246C,0x82EA,0xA4EC,0xE3828C,0x308C,{0x08,0x00,0x04,0x00,0x04,0x00,0x04,0x60,0x04,0x90,0x4d,0x10,0x36,0x10,0x04,0x10,0x04,0x10,0x0c,0x10,0x0c,0x10,0x14,0x11,0x24,0x12,0x4c,0x0c,0x04,0x00,0x00,0x00}}, // れ
{0x246D,0x82EB,0xA4ED,0xE3828D,0x308D,{0x00,0x00,0x04,0xe0,0x03,0x20,0x00,0x40,0x00,0x80,0x01,0x00,0x03,0xf0,0x06,0x08,0x08,0x04,0x10,0x04,0x00,0x04,0x00,0x08,0x00,0x10,0x00,0x60,0x03,0x80,0x00,0x00}}, // ろ
{0x246E,0x82EC,0xA4EE,0xE3828E,0x308E,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x04,0x00,0x04,0x00,0x06,0xe0,0x1d,0x10,0x06,0x08,0x04,0x08,0x0c,0x08,0x14,0x10,0x04,0x60,0x04,0x00,0x04,0x00}}, // ゎ
{0x246F,0x82ED,0xA4EF,0xE3828F,0x308F,{0x10,0x00,0x08,0x00,0x08,0x00,0x0a,0x00,0x4c,0x00,0x38,0xf0,0x0b,0x08,0x0c,0x04,0x08,0x02,0x18,0x02,0x18,0x04,0x28,0x04,0x48,0x18,0x18,0x60,0x08,0x00,0x00,0x00}}, // わ
{0x2470,0x82EE,0xA4F0,0xE38290,0x3090,{0x00,0x00,0x08,0x40,0x07,0xc0,0x00,0x80,0x00,0x80,0x01,0xe0,0x07,0x18,0x09,0x04,0x11,0x02,0x22,0x02,0x42,0x02,0x44,0x72,0x48,0x8c,0x30,0x8a,0x00,0x70,0x00,0x00}}, // ゐ
{0x2471,0x82EF,0xA4F1,0xE38291,0x3091,{0x00,0x00,0x09,0xe0,0x06,0x80,0x01,0x00,0x03,0xc0,0x04,0x20,0x08,0x10,0x12,0x10,0x05,0x20,0x04,0xc0,0x03,0x80,0x04,0x00,0x0e,0x70,0x31,0x88,0x40,0x1c,0x00,0x00}}, // ゑ
{0x2472,0x82F0,0xA4F2,0xE38292,0x3092,{0x02,0x00,0x01,0x00,0x11,0xe0,0x0f,0x00,0x02,0x08,0x02,0x06,0x07,0x98,0x08,0x60,0x10,0xc0,0x21,0x40,0x02,0x40,0x04,0x40,0x04,0x00,0x02,0x00,0x01,0xf8,0x00,0x00}}, // を
{0x2473,0x82F1,0xA4F3,0xE38293,0x3093,{0x01,0x00,0x00,0x80,0x00,0x80,0x01,0x00,0x01,0x00,0x02,0x00,0x02,0x00,0x05,0x80,0x06,0x40,0x0c,0x40,0x08,0x40,0x10,0x41,0x10,0x42,0x20,0x24,0x20,0x18,0x00,0x00}}, // ん
{0x2521,0x8340,0xA5A1,0xE382A1,0x30A1,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0xf0,0x0f,0x10,0x00,0x20,0x01,0xc0,0x01,0x00,0x01,0x00,0x01,0x00,0x02,0x00,0x04,0x00,0x00,0x00}}, // ァ
{0x2522,0x8341,0xA5A2,0xE382A2,0x30A2,{0x00,0x00,0x00,0x00,0x20,0x7c,0x1f,0x84,0x00,0x08,0x02,0x10,0x01,0x20,0x01,0xc0,0x01,0x00,0x01,0x00,0x01,0x00,0x02,0x00,0x02,0x00,0x04,0x00,0x08,0x00,0x00,0x00}}, // ア
{0x2523,0x8342,0xA5A3,0xE382A3,0x30A3,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x20,0x00,0x40,0x00,0x80,0x03,0x40,0x0c,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x00}}, // ィ
{0x2524,0x8343,0xA5A4,0xE382A4,0x30A4,{0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x20,0x00,0x40,0x00,0x80,0x01,0x80,0x02,0x40,0x0c,0x40,0x30,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x00}}, // イ
{0x2525,0x8344,0xA5A5,0xE382A5,0x30A5,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x08,0xf8,0x07,0x88,0x04,0x08,0x04,0x10,0x04,0x10,0x00,0x20,0x00,0x40,0x00,0x80,0x00,0x00}}, // ゥ
{0x2526,0x8345,0xA5A6,0xE382A6,0x30A6,{0x00,0x00,0x01,0x00,0x00,0x80,0x00,0x80,0x10,0xfc,0x1f,0x04,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x10,0x00,0x10,0x00,0x20,0x00,0x40,0x00,0x80,0x01,0x00,0x00,0x00}}, // ウ
{0x2527,0x8346,0xA5A7,0xE382A7,0x30A7,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xe0,0x0f,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x03,0xe0,0x1c,0x10,0x00,0x00}}, // ェ
{0x2528,0x8347,0xA5A8,0xE382A8,0x30A8,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x1f,0xc0,0x01,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x03,0xfc,0x7c,0x02,0x00,0x00,0x00,0x00,0x00,0x00}}, // エ
{0x2529,0x8348,0xA5A9,0xE382A9,0x30A9,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x40,0x08,0x78,0x07,0xc0,0x00,0xc0,0x01,0x40,0x02,0x40,0x04,0x40,0x08,0x40,0x00,0xc0,0x00,0x40}}, // ォ
{0x252A,0x8349,0xA5AA,0xE382AA,0x30AA,{0x00,0x00,0x00,0x20,0x00,0x20,0x10,0x3e,0x0f,0xe0,0x00,0x20,0x00,0x60,0x00,0x60,0x00,0xa0,0x01,0x20,0x02,0x20,0x04,0x20,0x18,0x20,0x00,0x60,0x00,0x20,0x00,0x00}}, // オ
{0x252B,0x834A,0xA5AB,0xE382AB,0x30AB,{0x00,0x00,0x01,0x00,0x00,0x80,0x00,0x80,0x10,0xfc,0x0f,0x84,0x00,0x84,0x01,0x04,0x01,0x04,0x02,0x08,0x02,0x08,0x04,0x08,0x08,0x50,0x10,0x30,0x20,0x20,0x00,0x00}}, // カ
{0x252C,0x834B,0xA5AC,0xE382AC,0x30AC,{0x00,0x02,0x01,0x09,0x00,0x85,0x00,0x84,0x10,0xfc,0x0f,0x84,0x00,0x84,0x01,0x04,0x01,0x04,0x02,0x08,0x02,0x08,0x04,0x08,0x08,0x50,0x10,0x30,0x20,0x20,0x00,0x00}}, // ガ
{0x252D,0x834C,0xA5AD,0xE382AD,0x30AD,{0x00,0x00,0x02,0x00,0x01,0x00,0x01,0x18,0x01,0xe0,0x1e,0x80,0x00,0x80,0x00,0x8e,0x00,0xf0,0x03,0x40,0x3c,0x40,0x00,0x40,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x00}}, // キ
{0x252E,0x834D,0xA5AE,0xE382AE,0x30AE,{0x00,0x00,0x02,0x04,0x01,0x12,0x01,0x1a,0x01,0xe8,0x1e,0x80,0x00,0x80,0x00,0x8e,0x00,0xf0,0x03,0x40,0x3c,0x40,0x00,0x40,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x00}}, // ギ
{0x252F,0x834E,0xA5AF,0xE382AF,0x30AF,{0x00,0x00,0x02,0x00,0x01,0x18,0x01,0xe8,0x01,0x08,0x02,0x08,0x02,0x10,0x04,0x10,0x08,0x20,0x10,0x20,0x00,0x40,0x00,0x80,0x01,0x00,0x02,0x00,0x04,0x00,0x00,0x00}}, // ク
{0x2530,0x834F,0xA5B0,0xE382B0,0x30B0,{0x00,0x02,0x04,0x09,0x02,0x35,0x03,0xd4,0x02,0x10,0x04,0x10,0x04,0x20,0x08,0x20,0x10,0x40,0x20,0x40,0x00,0x80,0x01,0x00,0x02,0x00,0x04,0x00,0x08,0x00,0x00,0x00}}, // グ
{0x2531,0x8350,0xA5B1,0xE382B1,0x30B1,{0x00,0x00,0x08,0x00,0x04,0x00,0x04,0x1e,0x07,0xe0,0x04,0x40,0x08,0x20,0x08,0x20,0x10,0x20,0x20,0x40,0x00,0x40,0x00,0x80,0x01,0x00,0x02,0x00,0x04,0x00,0x00,0x00}}, // ケ
{0x2532,0x8351,0xA5B2,0xE382B2,0x30B2,{0x00,0x02,0x08,0x09,0x04,0x05,0x04,0x1c,0x07,0xe0,0x04,0x40,0x08,0x20,0x08,0x20,0x10,0x20,0x20,0x40,0x00,0x40,0x00,0x80,0x01,0x00,0x02,0x00,0x04,0x00,0x00,0x00}}, // ゲ
{0x2533,0x8352,0xA5B3,0xE382B3,0x30B3,{0x00,0x00,0x00,0x00,0x00,0x00,0x20,0xf8,0x1f,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x10,0x00,0x10,0x00,0x10,0x03,0xf0,0x1c,0x10,0x00,0x00,0x00,0x00,0x00,0x00}}, // コ
{0x2534,0x8353,0xA5B4,0xE382B4,0x30B4,{0x00,0x02,0x00,0x09,0x00,0x05,0x20,0xfc,0x1f,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x10,0x00,0x10,0x00,0x10,0x03,0xf0,0x1c,0x10,0x00,0x00,0x00,0x00,0x00,0x00}}, // ゴ
{0x2535,0x8354,0xA5B5,0xE382B5,0x30B5,{0x00,0x20,0x04,0x10,0x02,0x10,0x02,0x10,0x22,0x7e,0x1f,0x90,0x02,0x10,0x02,0x10,0x02,0x10,0x02,0x10,0x00,0x20,0x00,0x20,0x00,0x40,0x00,0x80,0x01,0x00,0x00,0x00}}, // サ
{0x2536,0x8355,0xA5B6,0xE382B6,0x30B6,{0x00,0x22,0x04,0x19,0x02,0x15,0x02,0x14,0x22,0x7e,0x1f,0x90,0x02,0x10,0x02,0x10,0x02,0x10,0x02,0x10,0x00,0x20,0x00,0x20,0x00,0x40,0x00,0x80,0x01,0x00,0x00,0x00}}, // ザ
{0x2537,0x8356,0xA5B7,0xE382B7,0x30B7,{0x00,0x00,0x00,0x00,0x0c,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x18,0x02,0x04,0x04,0x00,0x08,0x00,0x10,0x00,0x20,0x00,0x40,0x00,0x80,0x13,0x00,0x0c,0x00,0x00,0x00}}, // シ
{0x2538,0x8357,0xA5B8,0xE382B8,0x30B8,{0x00,0x02,0x00,0x09,0x0c,0x05,0x02,0x04,0x00,0x00,0x00,0x00,0x18,0x02,0x04,0x04,0x00,0x08,0x00,0x10,0x00,0x20,0x00,0x40,0x00,0x80,0x13,0x00,0x0c,0x00,0x00,0x00}}, // ジ
{0x2539,0x8358,0xA5B9,0xE382B9,0x30B9,{0x00,0x00,0x00,0x00,0x00,0x00,0x10,0xe0,0x0f,0x20,0x00,0x20,0x00,0x40,0x00,0x40,0x00,0x80,0x00,0xc0,0x01,0x20,0x02,0x10,0x04,0x08,0x18,0x04,0x60,0x04,0x00,0x00}}, // ス
{0x253A,0x8359,0xA5BA,0xE382BA,0x30BA,{0x00,0x00,0x00,0x04,0x00,0x12,0x10,0xea,0x0f,0x28,0x00,0x20,0x00,0x40,0x00,0x40,0x00,0x80,0x00,0xc0,0x01,0x20,0x02,0x10,0x04,0x08,0x18,0x04,0x60,0x04,0x00,0x00}}, // ズ
{0x253B,0x835A,0xA5BB,0xE382BB,0x30BB,{0x00,0x00,0x04,0x00,0x02,0x00,0x02,0x00,0x02,0x1e,0x02,0xe2,0x23,0x04,0x1e,0x08,0x02,0x10,0x02,0x20,0x02,0x00,0x02,0x00,0x01,0x00,0x00,0xfc,0x00,0x00,0x00,0x00}}, // セ
{0x253C,0x835B,0xA5BC,0xE382BC,0x30BC,{0x00,0x02,0x08,0x09,0x04,0x05,0x04,0x04,0x04,0x3c,0x05,0xc4,0x46,0x08,0x3c,0x10,0x04,0x20,0x04,0x40,0x04,0x00,0x04,0x00,0x02,0x00,0x01,0xf8,0x00,0x00,0x00,0x00}}, // ゼ
{0x253D,0x835C,0xA5BD,0xE382BD,0x30BD,{0x00,0x00,0x00,0x08,0x10,0x04,0x08,0x04,0x04,0x04,0x04,0x08,0x04,0x08,0x00,0x10,0x00,0x10,0x00,0x20,0x00,0x40,0x00,0x80,0x01,0x00,0x02,0x00,0x04,0x00,0x00,0x00}}, // ソ
{0x253E,0x835D,0xA5BE,0xE382BE,0x30BE,{0x00,0x02,0x00,0x29,0x20,0x15,0x10,0x14,0x08,0x10,0x08,0x20,0x08,0x20,0x00,0x20,0x00,0x40,0x00,0x40,0x00,0x80,0x01,0x00,0x02,0x00,0x04,0x00,0x08,0x00,0x00,0x00}}, // ゾ
{0x253F,0x835E,0xA5BF,0xE382BF,0x30BF,{0x00,0x00,0x04,0x00,0x02,0x38,0x03,0xc8,0x02,0x08,0x04,0x10,0x04,0x10,0x09,0xa0,0x10,0x60,0x20,0x40,0x00,0x80,0x01,0x00,0x02,0x00,0x0c,0x00,0x30,0x00,0x00,0x00}}, // タ
{0x2540,0x835F,0xA5C0,0xE38380,0x30C0,{0x00,0x02,0x04,0x09,0x02,0x05,0x03,0xf4,0x02,0x10,0x04,0x10,0x08,0x20,0x13,0x20,0x20,0xc0,0x40,0x80,0x01,0x00,0x02,0x00,0x04,0x00,0x18,0x00,0x60,0x00,0x00,0x00}}, // ダ
{0x2541,0x8360,0xA5C1,0xE38381,0x30C1,{0x00,0x00,0x00,0x10,0x00,0x60,0x0f,0x80,0x00,0x80,0x00,0x40,0x00,0x7e,0x23,0xc0,0x1c,0x40,0x00,0x40,0x00,0x40,0x00,0x80,0x00,0x80,0x01,0x00,0x02,0x00,0x00,0x00}}, // チ
{0x2542,0x8361,0xA5C2,0xE38382,0x30C2,{0x00,0x02,0x00,0x19,0x00,0x65,0x0f,0x84,0x00,0x80,0x00,0x40,0x00,0x7e,0x23,0xc0,0x1c,0x40,0x00,0x40,0x00,0x40,0x00,0x80,0x00,0x80,0x01,0x00,0x02,0x00,0x00,0x00}}, // ヂ
{0x2543,0x8362,0xA5C3,0xE38383,0x30C3,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x20,0x11,0x10,0x09,0x10,0x08,0x20,0x00,0x20,0x00,0x40,0x00,0x80,0x01,0x00,0x02,0x00,0x00,0x00}}, // ッ
{0x2544,0x8363,0xA5C4,0xE38384,0x30C4,{0x00,0x00,0x00,0x00,0x02,0x08,0x21,0x04,0x10,0x84,0x08,0x84,0x08,0x88,0x08,0x08,0x00,0x10,0x00,0x10,0x00,0x20,0x00,0x40,0x00,0x80,0x01,0x00,0x06,0x00,0x00,0x00}}, // ツ
{0x2545,0x8364,0xA5C5,0xE38385,0x30C5,{0x00,0x02,0x00,0x09,0x04,0x05,0x42,0x14,0x21,0x08,0x11,0x08,0x11,0x10,0x10,0x10,0x00,0x20,0x00,0x20,0x00,0x40,0x00,0x80,0x01,0x00,0x02,0x00,0x0c,0x00,0x00,0x00}}, // ヅ
{0x2546,0x8365,0xA5C6,0xE38386,0x30C6,{0x00,0x00,0x00,0x00,0x08,0x70,0x07,0x80,0x00,0x00,0x00,0x00,0x00,0x3e,0x21,0xc0,0x1e,0x40,0x00,0x40,0x00,0x80,0x00,0x80,0x01,0x00,0x02,0x00,0x04,0x00,0x00,0x00}}, // テ
{0x2547,0x8366,0xA5C7,0xE38387,0x30C7,{0x00,0x04,0x00,0x12,0x08,0x7a,0x07,0x88,0x00,0x00,0x00,0x00,0x00,0x3e,0x21,0xc0,0x1e,0x40,0x00,0x40,0x00,0x80,0x00,0x80,0x01,0x00,0x02,0x00,0x04,0x00,0x00,0x00}}, // デ
{0x2548,0x8367,0xA5C8,0xE38388,0x30C8,{0x00,0x00,0x04,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x03,0x80,0x02,0x60,0x02,0x10,0x02,0x08,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00}}, // ト
{0x2549,0x8368,0xA5C9,0xE38389,0x30C9,{0x00,0x00,0x04,0x04,0x02,0x12,0x02,0x0a,0x02,0x08,0x02,0x00,0x03,0x80,0x02,0x60,0x02,0x10,0x02,0x08,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00}}, // ド
{0x254A,0x8369,0xA5CA,0xE3838A,0x30CA,{0x00,0x00,0x00,0x80,0x00,0x40,0x00,0x40,0x00,0x40,0x20,0x7e,0x1f,0xc0,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x80,0x00,0x80,0x01,0x00,0x02,0x00,0x04,0x00,0x00,0x00}}, // ナ
{0x254B,0x836A,0xA5CB,0xE3838B,0x30CB,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x70,0x07,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x3f,0x02,0x00,0x00,0x00,0x00,0x00,0x00}}, // ニ
{0x254C,0x836B,0xA5CC,0xE3838C,0x30CC,{0x00,0x00,0x00,0x00,0x08,0x78,0x07,0x88,0x00,0x08,0x00,0x10,0x06,0x10,0x01,0xa0,0x00,0x40,0x00,0x60,0x00,0x90,0x01,0x08,0x02,0x04,0x0c,0x00,0x30,0x00,0x00,0x00}}, // ヌ
{0x254D,0x836C,0xA5CD,0xE3838D,0x30CD,{0x01,0x00,0x00,0x80,0x00,0x80,0x10,0xf8,0x0f,0x08,0x00,0x10,0x00,0x20,0x00,0x40,0x01,0xb0,0x06,0x8c,0x38,0x82,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x00}}, // ネ
{0x254E,0x836D,0xA5CE,0xE3838E,0x30CE,{0x00,0x00,0x00,0x10,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x10,0x00,0x10,0x00,0x20,0x00,0x20,0x00,0x40,0x00,0x80,0x01,0x00,0x02,0x00,0x04,0x00,0x08,0x00,0x00,0x00}}, // ノ
{0x254F,0x836E,0xA5CF,0xE3838F,0x30CF,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x04,0x20,0x02,0x10,0x02,0x08,0x04,0x08,0x04,0x04,0x08,0x04,0x10,0x02,0x20,0x02,0x40,0x02,0x00,0x00,0x00,0x00}}, // ハ
{0x2550,0x836F,0xA5D0,0xE38390,0x30D0,{0x00,0x00,0x00,0x04,0x00,0x12,0x00,0x0a,0x04,0x48,0x02,0x20,0x02,0x10,0x04,0x08,0x04,0x08,0x08,0x04,0x08,0x04,0x10,0x02,0x20,0x02,0x40,0x02,0x00,0x00,0x00,0x00}}, // バ
{0x2551,0x8370,0xA5D1,0xE38391,0x30D1,{0x00,0x00,0x00,0x0c,0x00,0x12,0x00,0x12,0x04,0x4c,0x02,0x20,0x02,0x10,0x04,0x08,0x04,0x08,0x08,0x04,0x08,0x04,0x10,0x02,0x20,0x02,0x40,0x02,0x00,0x00,0x00,0x00}}, // パ
{0x2552,0x8371,0xA5D2,0xE38392,0x30D2,{0x00,0x00,0x20,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x30,0x11,0xc0,0x1e,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x08,0x00,0x07,0xf8,0x00,0x00,0x00,0x00}}, // ヒ
{0x2553,0x8372,0xA5D3,0xE38393,0x30D3,{0x00,0x00,0x20,0x04,0x10,0x12,0x10,0x0a,0x10,0x08,0x10,0x60,0x11,0x80,0x1e,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x08,0x00,0x07,0xf8,0x00,0x00,0x00,0x00}}, // ビ
{0x2554,0x8373,0xA5D4,0xE38394,0x30D4,{0x00,0x00,0x40,0x18,0x20,0x24,0x20,0x24,0x20,0x18,0x20,0xc0,0x23,0x00,0x3c,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x10,0x00,0x0f,0xf0,0x00,0x00,0x00,0x00}}, // ピ
{0x2555,0x8374,0xA5D5,0xE38395,0x30D5,{0x00,0x00,0x00,0x00,0x20,0x7c,0x1f,0x84,0x00,0x04,0x00,0x08,0x00,0x08,0x00,0x10,0x00,0x10,0x00,0x20,0x00,0x40,0x00,0x80,0x01,0x00,0x02,0x00,0x0c,0x00,0x00,0x00}}, // フ
{0x2556,0x8375,0xA5D6,0xE38396,0x30D6,{0x00,0x02,0x00,0x09,0x40,0xf5,0x3f,0x14,0x00,0x10,0x00,0x20,0x00,0x20,0x00,0x40,0x00,0x40,0x00,0x80,0x01,0x00,0x02,0x00,0x04,0x00,0x08,0x00,0x30,0x00,0x00,0x00}}, // ブ
{0x2557,0x8376,0xA5D7,0xE38397,0x30D7,{0x00,0x06,0x00,0x09,0x20,0x79,0x1f,0x8e,0x00,0x08,0x00,0x10,0x00,0x10,0x00,0x20,0x00,0x20,0x00,0x40,0x00,0x80,0x01,0x00,0x02,0x00,0x04,0x00,0x18,0x00,0x00,0x00}}, // プ
{0x2558,0x8377,0xA5D8,0xE38398,0x30D8,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x02,0x80,0x04,0x40,0x08,0x20,0x50,0x10,0x20,0x08,0x00,0x04,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ヘ
{0x2559,0x8378,0xA5D9,0xE38399,0x30D9,{0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x12,0x01,0x0a,0x02,0x88,0x04,0x40,0x08,0x20,0x50,0x10,0x20,0x08,0x00,0x04,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ベ
{0x255A,0x8379,0xA5DA,0xE3839A,0x30DA,{0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x12,0x01,0x12,0x02,0x8c,0x04,0x40,0x08,0x20,0x50,0x10,0x20,0x08,0x00,0x04,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ペ
{0x255B,0x837A,0xA5DB,0xE3839B,0x30DB,{0x00,0x00,0x01,0x00,0x00,0x80,0x00,0x80,0x20,0xfc,0x1f,0x80,0x00,0x80,0x00,0x90,0x04,0x88,0x04,0x84,0x08,0x82,0x08,0x82,0x10,0x80,0x21,0x80,0x00,0x80,0x00,0x00}}, // ホ
{0x255C,0x837B,0xA5DC,0xE3839C,0x30DC,{0x00,0x02,0x01,0x09,0x00,0x85,0x00,0x84,0x20,0xfc,0x1f,0x80,0x00,0x80,0x00,0x90,0x04,0x88,0x04,0x84,0x08,0x82,0x08,0x82,0x10,0x80,0x21,0x80,0x00,0x80,0x00,0x00}}, // ボ
{0x255D,0x837C,0xA5DD,0xE3839D,0x30DD,{0x01,0x06,0x00,0x89,0x00,0x89,0x20,0xfe,0x1f,0x80,0x00,0x80,0x00,0x90,0x04,0x88,0x04,0x84,0x08,0x82,0x08,0x82,0x10,0x80,0x21,0x80,0x00,0x80,0x00,0x00,0x00,0x00}}, // ポ
{0x255E,0x837D,0xA5DE,0xE3839E,0x30DE,{0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x7c,0x1f,0x84,0x00,0x08,0x00,0x08,0x00,0x10,0x0c,0x20,0x03,0x40,0x00,0x80,0x00,0x40,0x00,0x20,0x00,0x20,0x00,0x00,0x00,0x00}}, // マ
{0x255F,0x837E,0xA5DF,0xE3839F,0x30DF,{0x00,0x00,0x06,0x00,0x01,0x80,0x00,0x60,0x00,0x10,0x00,0x00,0x06,0x00,0x01,0x80,0x00,0x40,0x00,0x20,0x10,0x00,0x0c,0x00,0x03,0x00,0x00,0xc0,0x00,0x20,0x00,0x10}}, // ミ
{0x2560,0x8380,0xA5E0,0xE383A0,0x30E0,{0x00,0x00,0x01,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x01,0x20,0x01,0x10,0x01,0x08,0x02,0x08,0x02,0x3c,0x25,0xc4,0x1e,0x02,0x00,0x02,0x00,0x02,0x00,0x00}}, // ム
{0x2561,0x8381,0xA5E1,0xE383A1,0x30E1,{0x00,0x00,0x00,0x10,0x00,0x08,0x00,0x08,0x00,0x08,0x06,0x10,0x01,0x90,0x00,0x60,0x00,0x30,0x00,0x28,0x00,0x44,0x00,0x80,0x01,0x00,0x06,0x00,0x18,0x00,0x00,0x00}}, // メ
{0x2562,0x8382,0xA5E2,0xE383A2,0x30E2,{0x00,0x00,0x00,0x00,0x10,0xf0,0x0f,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x43,0xfc,0x3e,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x01,0x00,0x00,0xf8,0x00,0x00,0x00,0x00}}, // モ
{0x2563,0x8383,0xA5E3,0xE383A3,0x30E3,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x04,0x00,0x04,0x78,0x03,0x88,0x26,0x10,0x1a,0x20,0x01,0x00,0x01,0x00,0x00,0x80,0x00,0x80,0x00,0x80}}, // ャ
{0x2564,0x8384,0xA5E4,0xE383A4,0x30E4,{0x00,0x00,0x08,0x00,0x04,0x00,0x04,0x0e,0x02,0xf2,0x27,0x04,0x1a,0x08,0x01,0x10,0x01,0x20,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x00}}, // ヤ
{0x2565,0x8385,0xA5E5,0xE383A5,0x30E5,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xc0,0x0e,0x40,0x00,0x40,0x00,0x80,0x01,0xf0,0x3e,0x08,0x00,0x00,0x00,0x00}}, // ュ
{0x2566,0x8386,0xA5E6,0xE383A6,0x30E6,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x70,0x07,0x90,0x00,0x10,0x00,0x10,0x00,0x20,0x00,0x20,0x00,0x20,0x03,0xfc,0x3c,0x02,0x00,0x00,0x00,0x00,0x00,0x00}}, // ユ
{0x2567,0x8387,0xA5E7,0xE383A7,0x30E7,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x0f,0x10,0x00,0x10,0x00,0x10,0x00,0xe0,0x07,0x20,0x00,0x20,0x00,0xe0,0x0f,0x10,0x00,0x00}}, // ョ
{0x2568,0x8388,0xA5E8,0xE383A8,0x30E8,{0x00,0x00,0x00,0x00,0x01,0xf8,0x1e,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0xf0,0x0f,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0xf0,0x1f,0x08,0x00,0x00,0x00,0x00}}, // ヨ
{0x2569,0x8389,0xA5E9,0xE383A9,0x30E9,{0x00,0x00,0x10,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x23,0xc4,0x1c,0x04,0x00,0x08,0x00,0x08,0x00,0x10,0x00,0x20,0x00,0x40,0x01,0x80,0x06,0x00,0x00,0x00}}, // ラ
{0x256A,0x838A,0xA5EA,0xE383AA,0x30EA,{0x00,0x20,0x08,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x00,0x20,0x00,0x20,0x00,0x40,0x00,0x80,0x01,0x00,0x00,0x00}}, // リ
{0x256B,0x838B,0xA5EB,0xE383AB,0x30EB,{0x00,0x00,0x00,0x80,0x00,0x40,0x08,0x40,0x04,0x40,0x04,0x41,0x04,0x41,0x04,0x42,0x04,0x42,0x04,0x44,0x04,0x48,0x08,0x50,0x08,0x60,0x10,0x40,0x20,0x00,0x00,0x00}}, // ル
{0x256C,0x838C,0xA5EC,0xE383AC,0x30EC,{0x00,0x00,0x08,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x04,0x04,0x08,0x04,0x10,0x04,0x20,0x04,0xc0,0x07,0x00,0x04,0x00,0x00,0x00}}, // レ
{0x256D,0x838D,0xA5ED,0xE383AD,0x30ED,{0x00,0x00,0x00,0x00,0x20,0x00,0x10,0xfc,0x1f,0x04,0x10,0x04,0x08,0x04,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0xf8,0x0f,0x04,0x08,0x00,0x00,0x00,0x00,0x00}}, // ロ
{0x256E,0x838E,0xA5EE,0xE383AE,0x30EE,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x78,0x07,0x88,0x04,0x08,0x04,0x10,0x04,0x10,0x00,0x20,0x00,0x40,0x00,0x80,0x01,0x00,0x00,0x00}}, // ヮ
{0x256F,0x838F,0xA5EF,0xE383AF,0x30EF,{0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x7c,0x1f,0x84,0x10,0x04,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x10,0x00,0x10,0x00,0x20,0x00,0x40,0x00,0x80,0x01,0x00,0x00,0x00}}, // ワ
{0x2570,0x8390,0xA5F0,0xE383B0,0x30F0,{0x00,0x00,0x00,0x80,0x00,0x40,0x00,0x40,0x20,0xfc,0x1f,0x40,0x08,0x40,0x08,0x40,0x04,0x40,0x04,0xfc,0x7f,0x42,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x00}}, // ヰ
{0x2571,0x8391,0xA5F1,0xE383B1,0x30F1,{0x00,0x00,0x00,0x00,0x00,0x00,0x10,0xf8,0x0f,0x10,0x00,0x20,0x01,0x40,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0xf8,0x7e,0x04,0x00,0x00,0x00,0x00,0x00,0x00}}, // ヱ
{0x2572,0x8392,0xA5F2,0xE383B2,0x30F2,{0x00,0x00,0x00,0x00,0x08,0x3c,0x07,0xc4,0x00,0x04,0x00,0x04,0x00,0x78,0x07,0x88,0x00,0x10,0x00,0x10,0x00,0x20,0x00,0x40,0x01,0x80,0x0e,0x00,0x00,0x00,0x00,0x00}}, // ヲ
{0x2573,0x8393,0xA5F3,0xE383B3,0x30F3,{0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x04,0x02,0x02,0x02,0x00,0x04,0x00,0x04,0x00,0x08,0x00,0x10,0x00,0x20,0x00,0x40,0x00,0x80,0x13,0x00,0x0c,0x00,0x00,0x00}}, // ン
{0x2574,0x8394,0xA5F4,0xE383B4,0x30F4,{0x00,0x02,0x01,0x09,0x00,0x85,0x00,0x84,0x10,0xfc,0x1f,0x04,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x10,0x00,0x10,0x00,0x20,0x00,0x40,0x00,0x80,0x01,0x00,0x00,0x00}}, // ヴ
{0x2575,0x8395,0xA5F5,0xE383B5,0x30F5,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x11,0xf0,0x0f,0x10,0x01,0x10,0x02,0x10,0x02,0x20,0x04,0x20,0x08,0xa0,0x10,0x40,0x00,0x00}}, // ヵ
{0x2576,0x8396,0xA5F6,0xE383B6,0x30F6,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x02,0x00,0x02,0x38,0x03,0xc0,0x02,0x20,0x04,0x20,0x08,0x40,0x00,0x40,0x00,0x80,0x01,0x00,0x02,0x00,0x00,0x00}}, // ヶ
{0x2621,0x839F,0xA6A1,0xCE91,  0x0391,{0x00,0x00,0x00,0x80,0x00,0x80,0x01,0x40,0x01,0x40,0x02,0x20,0x02,0x20,0x04,0x10,0x07,0xf0,0x04,0x10,0x08,0x08,0x08,0x08,0x10,0x04,0x38,0x0e,0x00,0x00,0x00,0x00}}, // Α
{0x2622,0x83A0,0xA6A2,0xCE92,  0x0392,{0x00,0x00,0x3f,0xe0,0x08,0x10,0x08,0x08,0x08,0x08,0x08,0x10,0x0f,0xe0,0x08,0x10,0x08,0x08,0x08,0x04,0x08,0x04,0x08,0x08,0x08,0x30,0x3f,0xc0,0x00,0x00,0x00,0x00}}, // Β
{0x2623,0x83A1,0xA6A3,0xCE93,  0x0393,{0x00,0x00,0x1f,0xf8,0x04,0x08,0x04,0x04,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x0e,0x00,0x00,0x00,0x00,0x00}}, // Γ
{0x2624,0x83A2,0xA6A4,0xCE94,  0x0394,{0x00,0x00,0x01,0x00,0x01,0x00,0x02,0x80,0x02,0x80,0x04,0x40,0x04,0x40,0x08,0x20,0x08,0x20,0x08,0x10,0x10,0x10,0x10,0x10,0x20,0x08,0x7f,0xfc,0x00,0x00,0x00,0x00}}, // Δ
{0x2625,0x83A3,0xA6A5,0xCE95,  0x0395,{0x00,0x00,0x3f,0xf8,0x08,0x08,0x08,0x04,0x08,0x00,0x08,0x00,0x08,0x40,0x0f,0xc0,0x08,0x40,0x08,0x00,0x08,0x00,0x08,0x04,0x08,0x08,0x3f,0xf8,0x00,0x00,0x00,0x00}}, // Ε
{0x2626,0x83A4,0xA6A6,0xCE96,  0x0396,{0x00,0x00,0x0f,0xf8,0x08,0x10,0x10,0x20,0x00,0x40,0x00,0x40,0x00,0x80,0x01,0x00,0x01,0x00,0x02,0x00,0x04,0x00,0x04,0x08,0x08,0x08,0x1f,0xf8,0x00,0x00,0x00,0x00}}, // Ζ
{0x2627,0x83A5,0xA6A7,0xCE97,  0x0397,{0x00,0x00,0x38,0x1c,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x38,0x1c,0x00,0x00,0x00,0x00}}, // Η
{0x2628,0x83A6,0xA6A8,0xCE98,  0x0398,{0x00,0x00,0x03,0xc0,0x0c,0x30,0x18,0x18,0x10,0x08,0x20,0x04,0x24,0x24,0x27,0xe4,0x24,0x24,0x20,0x04,0x10,0x08,0x18,0x18,0x0c,0x30,0x03,0xc0,0x00,0x00,0x00,0x00}}, // Θ
{0x2629,0x83A7,0xA6A9,0xCE99,  0x0399,{0x00,0x00,0x03,0x80,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x03,0x80,0x00,0x00,0x00,0x00}}, // Ι
{0x262A,0x83A8,0xA6AA,0xCE9A,  0x039A,{0x00,0x00,0x1c,0x1c,0x08,0x10,0x08,0x20,0x08,0x40,0x08,0x80,0x09,0x00,0x0b,0x00,0x0c,0x80,0x08,0x40,0x08,0x20,0x08,0x10,0x08,0x08,0x1c,0x0e,0x00,0x00,0x00,0x00}}, // Κ
{0x262B,0x83A9,0xA6AB,0xCE9B,  0x039B,{0x00,0x00,0x00,0x80,0x00,0x80,0x01,0x40,0x01,0x40,0x02,0x20,0x02,0x20,0x04,0x10,0x04,0x10,0x04,0x10,0x08,0x08,0x08,0x08,0x10,0x04,0x38,0x0e,0x00,0x00,0x00,0x00}}, // Λ
{0x262C,0x83AA,0xA6AC,0xCE9C,  0x039C,{0x00,0x00,0x60,0x0c,0x20,0x08,0x30,0x18,0x30,0x18,0x28,0x28,0x28,0x28,0x24,0x48,0x24,0x48,0x24,0x48,0x22,0x88,0x22,0x88,0x21,0x08,0x71,0x1c,0x00,0x00,0x00,0x00}}, // Μ
{0x262D,0x83AB,0xA6AD,0xCE9D,  0x039D,{0x00,0x00,0x38,0x1c,0x18,0x08,0x14,0x08,0x14,0x08,0x12,0x08,0x11,0x08,0x11,0x08,0x10,0x88,0x10,0x48,0x10,0x48,0x10,0x28,0x10,0x18,0x38,0x08,0x00,0x00,0x00,0x00}}, // Ν
{0x262E,0x83AC,0xA6AE,0xCE9E,  0x039E,{0x00,0x00,0x3f,0xfc,0x20,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x08,0x1f,0xf8,0x10,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x04,0x3f,0xfc,0x00,0x00,0x00,0x00}}, // Ξ
{0x262F,0x83AD,0xA6AF,0xCE9F,  0x039F,{0x00,0x00,0x03,0xc0,0x0c,0x30,0x18,0x18,0x10,0x08,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x10,0x08,0x18,0x18,0x0c,0x30,0x03,0xc0,0x00,0x00,0x00,0x00}}, // Ο
{0x2630,0x83AE,0xA6B0,0xCEA0,  0x03A0,{0x00,0x00,0x1f,0xf8,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x1c,0x38,0x00,0x00,0x00,0x00}}, // Π
{0x2631,0x83AF,0xA6B1,0xCEA1,  0x03A1,{0x00,0x00,0x1f,0xe0,0x04,0x18,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x18,0x07,0xe0,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x0e,0x00,0x00,0x00,0x00,0x00}}, // Ρ
{0x2632,0x83B0,0xA6B2,0xCEA3,  0x03A3,{0x00,0x00,0x1f,0xf0,0x08,0x10,0x04,0x08,0x02,0x00,0x01,0x00,0x00,0x80,0x00,0xc0,0x00,0x80,0x01,0x00,0x02,0x00,0x04,0x08,0x08,0x08,0x1f,0xf8,0x00,0x00,0x00,0x00}}, // Σ
{0x2633,0x83B1,0xA6B3,0xCEA4,  0x03A4,{0x00,0x00,0x3f,0xf8,0x21,0x08,0x41,0x04,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x03,0x80,0x00,0x00,0x00,0x00}}, // Τ
{0x2634,0x83B2,0xA6B4,0xCEA5,  0x03A5,{0x00,0x00,0x0e,0x38,0x11,0x44,0x20,0x82,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x01,0xc0,0x00,0x00,0x00,0x00}}, // Υ
{0x2635,0x83B3,0xA6B5,0xCEA6,  0x03A6,{0x00,0x00,0x01,0xc0,0x00,0x80,0x03,0xe0,0x0c,0x98,0x08,0x88,0x10,0x84,0x10,0x84,0x10,0x84,0x08,0x88,0x0c,0x98,0x03,0xe0,0x00,0x80,0x01,0xc0,0x00,0x00,0x00,0x00}}, // Φ
{0x2636,0x83B4,0xA6B6,0xCEA7,  0x03A7,{0x00,0x00,0x38,0x38,0x10,0x10,0x08,0x20,0x04,0x40,0x04,0x40,0x02,0x80,0x01,0x00,0x02,0x80,0x04,0x40,0x04,0x40,0x08,0x20,0x10,0x10,0x38,0x38,0x00,0x00,0x00,0x00}}, // Χ
{0x2637,0x83B5,0xA6B7,0xCEA8,  0x03A8,{0x00,0x00,0x03,0x80,0x61,0x0c,0x91,0x12,0x11,0x10,0x11,0x10,0x11,0x10,0x11,0x10,0x19,0x30,0x09,0x20,0x07,0xc0,0x01,0x00,0x01,0x00,0x03,0x80,0x00,0x00,0x00,0x00}}, // Ψ
{0x2638,0x83B6,0xA6B8,0xCEA9,  0x03A9,{0x00,0x00,0x01,0xc0,0x06,0x30,0x0c,0x18,0x08,0x08,0x10,0x04,0x10,0x04,0x10,0x04,0x08,0x08,0x0c,0x18,0x06,0x30,0x11,0x44,0x11,0x44,0x1f,0x7c,0x00,0x00,0x00,0x00}}, // Ω
{0x2641,0x83BF,0xA6C1,0xCEB1,  0x03B1,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x03,0x88,0x04,0x50,0x08,0x50,0x08,0x60,0x10,0x40,0x10,0xc0,0x11,0x48,0x0e,0x30,0x00,0x00,0x00,0x00}}, // α
{0x2642,0x83C0,0xA6C2,0xCEB2,  0x03B2,{0x00,0x00,0x00,0x70,0x00,0x88,0x01,0x08,0x01,0x08,0x02,0x08,0x02,0x10,0x04,0xe0,0x04,0x20,0x04,0x10,0x08,0x10,0x08,0x10,0x0a,0x20,0x09,0xc0,0x10,0x00,0x10,0x00}}, // β
{0x2643,0x83C1,0xA6C3,0xCEB3,  0x03B3,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,0x18,0x11,0x20,0x21,0x40,0x01,0x80,0x01,0x80,0x01,0x00,0x02,0x00,0x02,0x00,0x04,0x00,0x04,0x00}}, // γ
{0x2644,0x83C2,0xA6C4,0xCEB4,  0x03B4,{0x00,0x00,0x01,0x80,0x02,0x60,0x02,0x10,0x01,0x08,0x00,0x80,0x03,0x40,0x04,0x40,0x08,0x20,0x10,0x20,0x10,0x40,0x10,0x40,0x08,0x80,0x07,0x00,0x00,0x00,0x00,0x00}}, // δ
{0x2645,0x83C3,0xA6C5,0xCEB5,  0x03B5,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xe0,0x02,0x10,0x02,0x00,0x01,0xc0,0x02,0x00,0x04,0x00,0x04,0x20,0x03,0xc0,0x00,0x00,0x00,0x00}}, // ε
{0x2646,0x83C4,0xA6C6,0xCEB6,  0x03B6,{0x02,0x00,0x04,0x10,0x04,0x20,0x03,0xc0,0x00,0x80,0x01,0x00,0x02,0x00,0x04,0x00,0x08,0x00,0x08,0x00,0x04,0x00,0x03,0x00,0x00,0x80,0x00,0x40,0x00,0x40,0x01,0x80}}, // ζ
{0x2647,0x83C5,0xA6C7,0xCEB7,  0x03B7,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0xe0,0x13,0x10,0x02,0x10,0x04,0x10,0x04,0x10,0x04,0x20,0x08,0x20,0x08,0x20,0x00,0x40,0x00,0x40}}, // η
{0x2648,0x83C6,0xA6C8,0xCEB8,  0x03B8,{0x00,0x00,0x00,0x60,0x00,0x90,0x01,0x08,0x02,0x08,0x02,0x08,0x07,0xf8,0x04,0x10,0x08,0x10,0x08,0x20,0x08,0x20,0x08,0x40,0x04,0x80,0x03,0x00,0x00,0x00,0x00,0x00}}, // θ
{0x2649,0x83C7,0xA6C9,0xCEB9,  0x03B9,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x02,0x00,0x04,0x00,0x04,0x00,0x08,0x00,0x08,0x20,0x08,0xc0,0x07,0x00,0x00,0x00,0x00,0x00}}, // ι
{0x264A,0x83C8,0xA6CA,0xCEBA,  0x03BA,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x30,0x04,0x48,0x05,0x80,0x06,0x00,0x09,0x00,0x09,0x00,0x11,0x10,0x10,0xe0,0x00,0x00,0x00,0x00}}, // κ
{0x264B,0x83C9,0xA6CB,0xCEBB,  0x03BB,{0x00,0x00,0x00,0x80,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0xc0,0x01,0x40,0x01,0x40,0x02,0x20,0x04,0x20,0x08,0x10,0x10,0x08,0x00,0x00,0x00,0x00}}, // λ
{0x264C,0x83CA,0xA6CC,0xCEBC,  0x03BC,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x40,0x08,0x40,0x08,0x40,0x0c,0xc8,0x13,0x30,0x10,0x00,0x20,0x00}}, // μ
{0x264D,0x83CB,0xA6CD,0xCEBD,  0x03BD,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x10,0x04,0x10,0x04,0x20,0x04,0x20,0x04,0x40,0x08,0x80,0x0b,0x00,0x1c,0x00,0x00,0x00,0x00,0x00}}, // ν
{0x264E,0x83CC,0xA6CE,0xCEBE,  0x03BE,{0x00,0x10,0x00,0xe0,0x01,0x00,0x00,0x80,0x03,0xe0,0x04,0x00,0x04,0x00,0x02,0x00,0x0f,0xc0,0x10,0x00,0x10,0x00,0x0e,0x00,0x01,0x80,0x00,0x40,0x00,0x40,0x0f,0x80}}, // ξ
{0x264F,0x83CD,0xA6CF,0xCEBF,  0x03BF,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xc0,0x02,0x20,0x04,0x10,0x08,0x10,0x08,0x10,0x08,0x20,0x04,0x40,0x03,0x80,0x00,0x00,0x00,0x00}}, // ο
{0x2650,0x83CE,0xA6D0,0xCF80,  0x03C0,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x0f,0xf0,0x12,0x40,0x02,0x40,0x02,0x40,0x04,0x80,0x04,0x80,0x08,0x90,0x10,0x60,0x00,0x00,0x00,0x00}}, // π
{0x2651,0x83CF,0xA6D1,0xCF81,  0x03C1,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xc0,0x02,0x20,0x04,0x10,0x04,0x10,0x04,0x10,0x08,0x10,0x0a,0x20,0x09,0xc0,0x10,0x00,0x10,0x00}}, // ρ
{0x2652,0x83D0,0xA6D2,0xCF83,  0x03C3,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0xf0,0x01,0x20,0x02,0x10,0x04,0x10,0x04,0x10,0x04,0x20,0x02,0x40,0x01,0x80,0x00,0x00,0x00,0x00}}, // σ
{0x2653,0x83D1,0xA6D3,0xCF84,  0x03C4,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x0f,0xf0,0x11,0x00,0x01,0x00,0x02,0x00,0x02,0x00,0x04,0x20,0x04,0x40,0x03,0x80,0x00,0x00,0x00,0x00}}, // τ
{0x2654,0x83D2,0xA6D4,0xCF85,  0x03C5,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x10,0x01,0x08,0x01,0x08,0x01,0x10,0x02,0x10,0x02,0x20,0x02,0x40,0x01,0x80,0x00,0x00,0x00,0x00}}, // υ
{0x2655,0x83D3,0xA6D5,0xCF86,  0x03C6,{0x00,0x00,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x40,0x00,0x40,0x01,0xe0,0x06,0x90,0x08,0x90,0x08,0x90,0x09,0x10,0x09,0x60,0x07,0x80,0x02,0x00,0x02,0x00,0x02,0x00}}, // φ
{0x2656,0x83D4,0xA6D6,0xCF87,  0x03C7,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x10,0x09,0x20,0x01,0x40,0x01,0x80,0x01,0x00,0x03,0x00,0x05,0x00,0x09,0x00,0x10,0x90,0x20,0x60}}, // χ
{0x2657,0x83D5,0xA6D7,0xCF88,  0x03C8,{0x00,0x00,0x00,0x20,0x00,0x20,0x00,0x40,0x00,0x40,0x00,0x40,0x08,0x88,0x14,0x88,0x04,0x90,0x05,0x10,0x09,0x20,0x09,0x40,0x07,0x80,0x02,0x00,0x02,0x00,0x02,0x00}}, // ψ
{0x2658,0x83D6,0xA6D8,0xCF89,  0x03C9,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x10,0x08,0x90,0x10,0x88,0x10,0x88,0x21,0x08,0x21,0x08,0x22,0x90,0x1c,0x60,0x00,0x00,0x00,0x00}}, // ω
{0x2721,0x8440,0xA7A1,0xD090,  0x0410,{0x00,0x00,0x00,0x80,0x00,0x80,0x01,0x40,0x01,0x40,0x02,0x20,0x02,0x20,0x04,0x10,0x07,0xf0,0x04,0x10,0x08,0x08,0x08,0x08,0x10,0x04,0x38,0x0e,0x00,0x00,0x00,0x00}}, // А
{0x2722,0x8441,0xA7A2,0xD091,  0x0411,{0x00,0x00,0x3f,0xf0,0x08,0x10,0x08,0x08,0x08,0x00,0x08,0x00,0x0f,0xe0,0x08,0x10,0x08,0x08,0x08,0x04,0x08,0x04,0x08,0x08,0x08,0x30,0x3f,0xc0,0x00,0x00,0x00,0x00}}, // Б
{0x2723,0x8442,0xA7A3,0xD092,  0x0412,{0x00,0x00,0x3f,0xe0,0x08,0x10,0x08,0x08,0x08,0x08,0x08,0x10,0x0f,0xe0,0x08,0x10,0x08,0x08,0x08,0x04,0x08,0x04,0x08,0x08,0x08,0x30,0x3f,0xc0,0x00,0x00,0x00,0x00}}, // В
{0x2724,0x8443,0xA7A4,0xD093,  0x0413,{0x00,0x00,0x1f,0xf8,0x04,0x08,0x04,0x04,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x0e,0x00,0x00,0x00,0x00,0x00}}, // Г
{0x2725,0x8444,0xA7A5,0xD094,  0x0414,{0x00,0x00,0x0f,0xfc,0x02,0x10,0x02,0x10,0x02,0x10,0x02,0x10,0x02,0x10,0x02,0x10,0x02,0x10,0x02,0x10,0x04,0x10,0x04,0x10,0x08,0x10,0x3f,0xfc,0x20,0x04,0x20,0x04}}, // Д
{0x2726,0x8445,0xA7A6,0xD095,  0x0415,{0x00,0x00,0x3f,0xf8,0x08,0x08,0x08,0x04,0x08,0x00,0x08,0x00,0x08,0x40,0x0f,0xc0,0x08,0x40,0x08,0x00,0x08,0x00,0x08,0x04,0x08,0x08,0x3f,0xf8,0x00,0x00,0x00,0x00}}, // Е
{0x2727,0x8446,0xA7A7,0xD081,  0x0401,{0x04,0x10,0x04,0x10,0x00,0x00,0x3f,0xf0,0x08,0x10,0x08,0x08,0x08,0x00,0x08,0x40,0x0f,0xc0,0x08,0x40,0x08,0x00,0x08,0x08,0x08,0x10,0x3f,0xf0,0x00,0x00,0x00,0x00}}, // Ё
{0x2728,0x8447,0xA7A8,0xD096,  0x0416,{0x00,0x00,0x31,0xc6,0x48,0x89,0x08,0x88,0x08,0x88,0x08,0x88,0x04,0x90,0x07,0xf0,0x08,0x88,0x10,0x84,0x10,0x84,0x20,0x82,0x20,0x82,0x71,0xc7,0x00,0x00,0x00,0x00}}, // Ж
{0x2729,0x8448,0xA7A9,0xD097,  0x0417,{0x00,0x00,0x03,0xc0,0x0c,0x30,0x10,0x18,0x00,0x08,0x00,0x08,0x00,0x10,0x03,0xe0,0x00,0x10,0x00,0x08,0x00,0x08,0x10,0x10,0x0c,0x30,0x03,0xc0,0x00,0x00,0x00,0x00}}, // З
{0x272A,0x8449,0xA7AA,0xD098,  0x0418,{0x00,0x00,0x38,0x1c,0x10,0x18,0x10,0x28,0x10,0x28,0x10,0x48,0x10,0x88,0x10,0x88,0x11,0x08,0x12,0x08,0x12,0x08,0x14,0x08,0x18,0x08,0x10,0x1c,0x00,0x00,0x00,0x00}}, // И
{0x272B,0x844A,0xA7AB,0xD099,  0x0419,{0x06,0x60,0x04,0x20,0x3b,0xcc,0x10,0x18,0x10,0x18,0x10,0x28,0x10,0x48,0x10,0x88,0x10,0x88,0x11,0x08,0x12,0x08,0x14,0x08,0x18,0x08,0x10,0x1c,0x00,0x00,0x00,0x00}}, // Й
{0x272C,0x844B,0xA7AC,0xD09A,  0x041A,{0x00,0x00,0x1c,0x38,0x08,0x44,0x08,0x40,0x08,0x80,0x08,0x80,0x09,0x00,0x0f,0x00,0x08,0x80,0x08,0x40,0x08,0x20,0x08,0x10,0x08,0x08,0x1c,0x1c,0x00,0x00,0x00,0x00}}, // К
{0x272D,0x844C,0xA7AD,0xD09B,  0x041B,{0x00,0x00,0x0f,0xf8,0x02,0x10,0x02,0x10,0x02,0x10,0x02,0x10,0x02,0x10,0x02,0x10,0x02,0x10,0x04,0x10,0x04,0x10,0x08,0x10,0x50,0x10,0x60,0x38,0x00,0x00,0x00,0x00}}, // Л
{0x272E,0x844D,0xA7AE,0xD09C,  0x041C,{0x00,0x00,0x30,0x0c,0x10,0x08,0x18,0x18,0x18,0x18,0x14,0x28,0x14,0x28,0x12,0x28,0x12,0x48,0x22,0x44,0x21,0x44,0x21,0x84,0x20,0x84,0x78,0x8e,0x00,0x00,0x00,0x00}}, // М
{0x272F,0x844E,0xA7AF,0xD09D,  0x041D,{0x00,0x00,0x38,0x1c,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x38,0x1c,0x00,0x00,0x00,0x00}}, // Н
{0x2730,0x844F,0xA7B0,0xD09E,  0x041E,{0x00,0x00,0x03,0xc0,0x0c,0x30,0x18,0x18,0x10,0x08,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x10,0x08,0x18,0x18,0x0c,0x30,0x03,0xc0,0x00,0x00,0x00,0x00}}, // О
{0x2731,0x8450,0xA7B1,0xD09F,  0x041F,{0x00,0x00,0x1f,0xfc,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x1c,0x1c,0x00,0x00,0x00,0x00}}, // П
{0x2732,0x8451,0xA7B2,0xD0A0,  0x0420,{0x00,0x00,0x1f,0xe0,0x04,0x18,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x18,0x07,0xe0,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x0e,0x00,0x00,0x00,0x00,0x00}}, // Р
{0x2733,0x8452,0xA7B3,0xD0A1,  0x0421,{0x00,0x00,0x03,0xc0,0x0c,0x28,0x18,0x18,0x10,0x08,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x10,0x08,0x18,0x18,0x0c,0x30,0x03,0xc0,0x00,0x00,0x00,0x00}}, // С
{0x2734,0x8453,0xA7B4,0xD0A2,  0x0422,{0x00,0x00,0x3f,0xf8,0x21,0x08,0x41,0x04,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x03,0x80,0x00,0x00,0x00,0x00}}, // Т
{0x2735,0x8454,0xA7B5,0xD0A3,  0x0423,{0x00,0x00,0x1c,0x1c,0x08,0x08,0x04,0x10,0x04,0x10,0x02,0x20,0x02,0x20,0x01,0x40,0x01,0x40,0x00,0x80,0x00,0x80,0x01,0x00,0x12,0x00,0x0c,0x00,0x00,0x00,0x00,0x00}}, // У
{0x2736,0x8455,0xA7B6,0xD0A4,  0x0424,{0x00,0x00,0x01,0xc0,0x00,0x80,0x03,0xe0,0x0c,0x98,0x08,0x88,0x10,0x84,0x10,0x84,0x10,0x84,0x08,0x88,0x0c,0x98,0x03,0xe0,0x00,0x80,0x01,0xc0,0x00,0x00,0x00,0x00}}, // Ф
{0x2737,0x8456,0xA7B7,0xD0A5,  0x0425,{0x00,0x00,0x38,0x38,0x10,0x10,0x08,0x20,0x04,0x40,0x04,0x40,0x02,0x80,0x01,0x00,0x02,0x80,0x04,0x40,0x04,0x40,0x08,0x20,0x10,0x10,0x38,0x38,0x00,0x00,0x00,0x00}}, // Х
{0x2738,0x8457,0xA7B8,0xD0A6,  0x0426,{0x00,0x00,0x38,0x38,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x3f,0xfc,0x00,0x04,0x00,0x04}}, // Ц
{0x2739,0x8458,0xA7B9,0xD0A7,  0x0427,{0x00,0x00,0x1c,0x38,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x04,0x30,0x03,0xd0,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x38,0x00,0x00,0x00,0x00}}, // Ч
{0x273A,0x8459,0xA7BA,0xD0A8,  0x0428,{0x00,0x00,0x39,0xce,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x3f,0xfe,0x00,0x00,0x00,0x00}}, // Ш
{0x273B,0x845A,0xA7BB,0xD0A9,  0x0429,{0x00,0x00,0x39,0xce,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x3f,0xff,0x00,0x01,0x00,0x01}}, // Щ
{0x273C,0x845B,0xA7BC,0xD0AA,  0x042A,{0x00,0x00,0x3f,0x00,0x22,0x00,0x42,0x00,0x02,0x00,0x02,0x00,0x03,0xf0,0x02,0x0c,0x02,0x06,0x02,0x02,0x02,0x02,0x02,0x06,0x02,0x0c,0x07,0xf0,0x00,0x00,0x00,0x00}}, // Ъ
{0x273D,0x845C,0xA7BD,0xD0AB,  0x042B,{0x00,0x00,0x38,0x1c,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x1e,0x08,0x11,0x88,0x10,0xc8,0x10,0x48,0x10,0x48,0x10,0xc8,0x11,0x88,0x3e,0x1c,0x00,0x00,0x00,0x00}}, // Ы
{0x273E,0x845D,0xA7BE,0xD0AC,  0x042C,{0x00,0x00,0x1c,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x0f,0xc0,0x08,0x30,0x08,0x18,0x08,0x08,0x08,0x08,0x08,0x18,0x08,0x30,0x1f,0xc0,0x00,0x00,0x00,0x00}}, // Ь
{0x273F,0x845E,0xA7BF,0xD0AD,  0x042D,{0x00,0x00,0x03,0xc0,0x0c,0x30,0x08,0x18,0x10,0x08,0x00,0x0c,0x07,0x14,0x08,0xe4,0x00,0x04,0x00,0x04,0x10,0x08,0x08,0x18,0x0c,0x30,0x03,0xc0,0x00,0x00,0x00,0x00}}, // Э
{0x2740,0x845F,0xA7C0,0xD0AE,  0x042E,{0x00,0x00,0x38,0x70,0x10,0x88,0x11,0x04,0x11,0x04,0x12,0x02,0x12,0x02,0x1e,0x02,0x12,0x02,0x12,0x02,0x11,0x04,0x11,0x04,0x10,0x88,0x38,0x70,0x00,0x00,0x00,0x00}}, // Ю
{0x2741,0x8460,0xA7C1,0xD0AF,  0x042F,{0x00,0x00,0x03,0xf8,0x0c,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x0c,0x10,0x03,0xf0,0x01,0x10,0x02,0x10,0x04,0x10,0x04,0x10,0x18,0x10,0x60,0x38,0x00,0x00,0x00,0x00}}, // Я
{0x2751,0x8470,0xA7D1,0xD0B0,  0x0430,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xc0,0x04,0x20,0x00,0x20,0x03,0xa0,0x04,0x60,0x08,0x20,0x08,0x60,0x08,0xa8,0x07,0x18,0x00,0x00,0x00,0x00}}, // а
{0x2752,0x8471,0xA7D2,0xD0B1,  0x0431,{0x00,0x00,0x00,0x10,0x01,0xe0,0x02,0x00,0x04,0x00,0x04,0x00,0x0b,0xc0,0x0c,0x20,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x04,0x20,0x03,0xc0,0x00,0x00,0x00,0x00}}, // б
{0x2753,0x8472,0xA7D3,0xD0B2,  0x0432,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0xe0,0x04,0x10,0x04,0x10,0x04,0x20,0x07,0xe0,0x04,0x10,0x04,0x10,0x04,0x10,0x0f,0xe0,0x00,0x00,0x00,0x00}}, // в
{0x2754,0x8473,0xA7D4,0xD0B3,  0x0433,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0xf0,0x04,0x10,0x04,0x10,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x0e,0x00,0x00,0x00,0x00,0x00}}, // г
{0x2755,0x8474,0xA7D5,0xD0B4,  0x0434,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xf0,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x04,0x20,0x04,0x20,0x1f,0xf8,0x10,0x08,0x10,0x08}}, // д
{0x2756,0x8475,0xA7D6,0xD0B5,  0x0435,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x80,0x04,0x40,0x08,0x20,0x08,0x20,0x0f,0xe0,0x08,0x00,0x08,0x00,0x04,0x20,0x03,0xc0,0x00,0x00,0x00,0x00}}, // е
{0x2757,0x8476,0xA7D7,0xD191,  0x0451,{0x00,0x00,0x00,0x00,0x04,0x40,0x04,0x40,0x00,0x00,0x03,0x80,0x04,0x40,0x08,0x20,0x08,0x20,0x0f,0xe0,0x08,0x00,0x08,0x00,0x04,0x20,0x03,0xc0,0x00,0x00,0x00,0x00}}, // ё
{0x2758,0x8477,0xA7D8,0xD0B6,  0x0436,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x19,0xcc,0x08,0x88,0x04,0x90,0x03,0xe0,0x02,0xa0,0x04,0x90,0x04,0x90,0x08,0x88,0x11,0xc4,0x00,0x00,0x00,0x00}}, // ж
{0x2759,0x8478,0xA7D9,0xD0B7,  0x0437,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xe0,0x06,0x10,0x00,0x10,0x00,0x20,0x01,0xe0,0x00,0x10,0x00,0x10,0x06,0x10,0x03,0xe0,0x00,0x00,0x00,0x00}}, // з
{0x275A,0x8479,0xA7DA,0xD0B8,  0x0438,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,0x1c,0x04,0x08,0x04,0x18,0x04,0x28,0x04,0x48,0x05,0x88,0x06,0x08,0x04,0x08,0x0e,0x1c,0x00,0x00,0x00,0x00}}, // и
{0x275B,0x847A,0xA7DB,0xD0B9,  0x0439,{0x00,0x00,0x00,0x00,0x03,0x30,0x02,0x10,0x01,0xe0,0x0e,0x1c,0x04,0x08,0x04,0x18,0x04,0x28,0x04,0x48,0x05,0x88,0x06,0x08,0x04,0x08,0x0e,0x1c,0x00,0x00,0x00,0x00}}, // й
{0x275C,0x847B,0xA7DC,0xD0BA,  0x043A,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,0x30,0x04,0x50,0x04,0x80,0x05,0x00,0x07,0x00,0x04,0x80,0x04,0x40,0x04,0x20,0x0e,0x38,0x00,0x00,0x00,0x00}}, // к
{0x275D,0x847C,0xA7DD,0xD0BB,  0x043B,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xf8,0x01,0x10,0x01,0x10,0x01,0x10,0x01,0x10,0x01,0x10,0x11,0x10,0x12,0x10,0x0c,0x38,0x00,0x00,0x00,0x00}}, // л
{0x275E,0x847D,0xA7DE,0xD0BC,  0x043C,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1c,0x1c,0x0c,0x18,0x0a,0x28,0x0a,0x28,0x09,0x48,0x09,0x48,0x08,0x88,0x08,0x88,0x1c,0x1c,0x00,0x00,0x00,0x00}}, // м
{0x275F,0x847E,0xA7DF,0xD0BD,  0x043D,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,0x38,0x04,0x10,0x04,0x10,0x04,0x10,0x07,0xf0,0x04,0x10,0x04,0x10,0x04,0x10,0x0e,0x38,0x00,0x00,0x00,0x00}}, // н
{0x2760,0x8480,0xA7E0,0xD0BE,  0x043E,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xc0,0x04,0x20,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x04,0x20,0x03,0xc0,0x00,0x00,0x00,0x00}}, // о
{0x2761,0x8481,0xA7E1,0xD0BF,  0x043F,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xf0,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x1c,0x70,0x00,0x00,0x00,0x00}}, // п
{0x2762,0x8482,0xA7E2,0xD180,  0x0440,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0d,0xc0,0x06,0x20,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x06,0x20,0x05,0xc0,0x04,0x00,0x04,0x00,0x0e,0x00}}, // р
{0x2763,0x8483,0xA7E3,0xD181,  0x0441,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x80,0x04,0x40,0x08,0x20,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x20,0x04,0x40,0x03,0x80,0x00,0x00,0x00,0x00}}, // с
{0x2764,0x8484,0xA7E4,0xD182,  0x0442,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0xf0,0x11,0x10,0x11,0x10,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x03,0x80,0x00,0x00,0x00,0x00}}, // т
{0x2765,0x8485,0xA7E5,0xD183,  0x0443,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,0x38,0x04,0x10,0x04,0x10,0x02,0x20,0x02,0x20,0x01,0x40,0x01,0x40,0x00,0x80,0x01,0x00,0x09,0x00,0x06,0x00}}, // у
{0x2766,0x8486,0xA7E6,0xD184,  0x0444,{0x00,0x00,0x01,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x06,0xb0,0x09,0xc8,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x09,0xc8,0x06,0xb0,0x00,0x80,0x01,0xc0}}, // ф
{0x2767,0x8487,0xA7E7,0xD185,  0x0445,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,0x38,0x04,0x10,0x02,0x20,0x01,0x40,0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x0e,0x38,0x00,0x00,0x00,0x00}}, // х
{0x2768,0x8488,0xA7E8,0xD186,  0x0446,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1c,0x70,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x1f,0xf8,0x00,0x08,0x00,0x08}}, // ц
{0x2769,0x8489,0xA7E9,0xD187,  0x0447,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,0x38,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x03,0xf0,0x00,0x10,0x00,0x10,0x00,0x38,0x00,0x00,0x00,0x00}}, // ч
{0x276A,0x848A,0xA7EA,0xD188,  0x0448,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x39,0xce,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x3f,0xfe,0x00,0x00,0x00,0x00}}, // ш
{0x276B,0x848B,0xA7EB,0xD189,  0x0449,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x39,0xce,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x3f,0xff,0x00,0x01,0x00,0x01}}, // щ
{0x276C,0x848C,0xA7EC,0xD18A,  0x044A,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x80,0x11,0x00,0x11,0x00,0x01,0x00,0x01,0xf0,0x01,0x0c,0x01,0x04,0x01,0x0c,0x03,0xf0,0x00,0x00,0x00,0x00}}, // ъ
{0x276D,0x848D,0xA7ED,0xD18B,  0x044B,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1c,0x1c,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0x08,0x08,0xc8,0x08,0x48,0x08,0xc8,0x1f,0x1c,0x00,0x00,0x00,0x00}}, // ы
{0x276E,0x848E,0xA7EE,0xD18C,  0x044C,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x03,0xe0,0x02,0x18,0x02,0x08,0x02,0x18,0x07,0xe0,0x00,0x00,0x00,0x00}}, // ь
{0x276F,0x848F,0xA7EF,0xD18D,  0x044D,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xc0,0x04,0x20,0x08,0x10,0x03,0x30,0x04,0xd0,0x00,0x10,0x08,0x10,0x04,0x20,0x03,0xc0,0x00,0x00,0x00,0x00}}, // э
{0x2770,0x8490,0xA7F0,0xD18E,  0x044E,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1c,0x70,0x08,0x88,0x09,0x04,0x09,0x04,0x0f,0x04,0x09,0x04,0x09,0x04,0x08,0x88,0x1c,0x70,0x00,0x00,0x00,0x00}}, // ю
{0x2771,0x8491,0xA7F1,0xD18F,  0x044F,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xf0,0x08,0x20,0x08,0x20,0x08,0x20,0x07,0xe0,0x02,0x20,0x04,0x20,0x04,0x20,0x18,0x70,0x00,0x00,0x00,0x00}}, // я
{0x2821,0x849F,0xA8A1,0xE29480,0x2500,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ─
{0x2822,0x84A0,0xA8A2,0xE29482,0x2502,{0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00}}, // │
{0x2823,0x84A1,0xA8A3,0xE2948C,0x250C,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xff,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00}}, // ┌
{0x2824,0x84A2,0xA8A4,0xE29490,0x2510,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00}}, // ┐
{0x2825,0x84A3,0xA8A5,0xE29498,0x2518,{0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ┘
{0x2826,0x84A4,0xA8A6,0xE29494,0x2514,{0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // └
{0x2827,0x84A5,0xA8A7,0xE2949C,0x251C,{0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0xff,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00}}, // ├
{0x2828,0x84A6,0xA8A8,0xE294AC,0x252C,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00}}, // ┬
{0x2829,0x84A7,0xA8A9,0xE294A4,0x2524,{0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0xff,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00}}, // ┤
{0x282A,0x84A8,0xA8AA,0xE294B4,0x2534,{0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ┴
{0x282B,0x84A9,0xA8AB,0xE294BC,0x253C,{0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0xff,0xff,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00}}, // ┼
{0x282C,0x84AA,0xA8AC,0xE29481,0x2501,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ━
{0x282D,0x84AB,0xA8AD,0xE29483,0x2503,{0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80}}, // ┃
{0x282E,0x84AC,0xA8AE,0xE2948F,0x250F,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xff,0x01,0xff,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80}}, // ┏
{0x282F,0x84AD,0xA8AF,0xE29493,0x2513,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x80,0xff,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80}}, // ┓
{0x2830,0x84AE,0xA8B0,0xE2949B,0x251B,{0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0xff,0x80,0xff,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ┛
{0x2831,0x84AF,0xA8B1,0xE29497,0x2517,{0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0xff,0x01,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ┗
{0x2832,0x84B0,0xA8B2,0xE294A3,0x2523,{0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0xff,0x01,0xff,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80}}, // ┣
{0x2833,0x84B1,0xA8B3,0xE294B3,0x2533,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80}}, // ┳
{0x2834,0x84B2,0xA8B4,0xE294AB,0x252B,{0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0xff,0x80,0xff,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80}}, // ┫
{0x2835,0x84B3,0xA8B5,0xE294BB,0x253B,{0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ┻
{0x2836,0x84B4,0xA8B6,0xE2958B,0x254B,{0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0xff,0xff,0xff,0xff,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80}}, // ╋
{0x2837,0x84B5,0xA8B7,0xE294A0,0x2520,{0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0xff,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80}}, // ┠
{0x2838,0x84B6,0xA8B8,0xE294AF,0x252F,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00}}, // ┯
{0x2839,0x84B7,0xA8B9,0xE294A8,0x2528,{0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0xff,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80}}, // ┨
{0x283A,0x84B8,0xA8BA,0xE294B7,0x2537,{0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ┷
{0x283B,0x84B9,0xA8BB,0xE294BF,0x253F,{0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0xff,0xff,0xff,0xff,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00}}, // ┿
{0x283C,0x84BA,0xA8BC,0xE2949D,0x251D,{0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0xff,0x01,0xff,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00}}, // ┝
{0x283D,0x84BB,0xA8BD,0xE294B0,0x2530,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80}}, // ┰
{0x283E,0x84BC,0xA8BE,0xE294A5,0x2525,{0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0xff,0x00,0xff,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00}}, // ┥
{0x283F,0x84BD,0xA8BF,0xE294B8,0x2538,{0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ┸
{0x2840,0x84BE,0xA8C0,0xE29582,0x2542,{0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0xff,0xff,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80}}, // ╂
{0x2D21,0x8740,0xADA1,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ①
{0x2D22,0x8741,0xADA2,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ②
{0x2D23,0x8742,0xADA3,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ③
{0x2D24,0x8743,0xADA4,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ④
{0x2D25,0x8744,0xADA5,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⑤
{0x2D26,0x8745,0xADA6,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⑥
{0x2D27,0x8746,0xADA7,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⑦
{0x2D28,0x8747,0xADA8,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⑧
{0x2D29,0x8748,0xADA9,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⑨
{0x2D2A,0x8749,0xADAA,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⑩
{0x2D2B,0x874A,0xADAB,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⑪
{0x2D2C,0x874B,0xADAC,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⑫
{0x2D2D,0x874C,0xADAD,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⑬
{0x2D2E,0x874D,0xADAE,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⑭
{0x2D2F,0x874E,0xADAF,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⑮
{0x2D30,0x874F,0xADB0,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⑯
{0x2D31,0x8750,0xADB1,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⑰
{0x2D32,0x8751,0xADB2,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⑱
{0x2D33,0x8752,0xADB3,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⑲
{0x2D34,0x8753,0xADB4,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⑳
{0x2D35,0x8754,0xADB5,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // Ⅰ
{0x2D36,0x8755,0xADB6,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // Ⅱ
{0x2D37,0x8756,0xADB7,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // Ⅲ
{0x2D38,0x8757,0xADB8,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // Ⅳ
{0x2D39,0x8758,0xADB9,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // Ⅴ
{0x2D3A,0x8759,0xADBA,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // Ⅵ
{0x2D3B,0x875A,0xADBB,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // Ⅶ
{0x2D3C,0x875B,0xADBC,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // Ⅷ
{0x2D3D,0x875C,0xADBD,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // Ⅸ
{0x2D3E,0x875D,0xADBE,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // Ⅹ
{0x2D3F,0x875E,0xADBF,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ・
{0x2D40,0x875F,0xADC0,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㍉
{0x2D41,0x8760,0xADC1,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㌔
{0x2D42,0x8761,0xADC2,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㌢
{0x2D43,0x8762,0xADC3,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㍍
{0x2D44,0x8763,0xADC4,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㌘
{0x2D45,0x8764,0xADC5,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㌧
{0x2D46,0x8765,0xADC6,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㌃
{0x2D47,0x8766,0xADC7,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㌶
{0x2D48,0x8767,0xADC8,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㍑
{0x2D49,0x8768,0xADC9,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㍗
{0x2D4A,0x8769,0xADCA,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㌍
{0x2D4B,0x876A,0xADCB,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㌦
{0x2D4C,0x876B,0xADCC,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㌣
{0x2D4D,0x876C,0xADCD,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㌫
{0x2D4E,0x876D,0xADCE,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㍊
{0x2D4F,0x876E,0xADCF,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㌻
{0x2D50,0x876F,0xADD0,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㎜
{0x2D51,0x8770,0xADD1,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㎝
{0x2D52,0x8771,0xADD2,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㎞
{0x2D53,0x8772,0xADD3,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㎎
{0x2D54,0x8773,0xADD4,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㎏
{0x2D55,0x8774,0xADD5,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㏄
{0x2D56,0x8775,0xADD6,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㎡
{0x2D5F,0x877E,0xADDF,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㍻
{0x2D60,0x8780,0xADE0,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // 〝
{0x2D61,0x8781,0xADE1,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // 〟
{0x2D62,0x8782,0xADE2,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // №
{0x2D63,0x8783,0xADE3,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㏍
{0x2D64,0x8784,0xADE4,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ℡
{0x2D65,0x8785,0xADE5,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㊤
{0x2D66,0x8786,0xADE6,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㊥
{0x2D67,0x8787,0xADE7,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㊦
{0x2D68,0x8788,0xADE8,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㊧
{0x2D69,0x8789,0xADE9,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㊨
{0x2D6A,0x878A,0xADEA,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㈱
{0x2D6B,0x878B,0xADEB,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㈲
{0x2D6C,0x878C,0xADEC,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㈹
{0x2D6D,0x878D,0xADED,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㍾
{0x2D6E,0x878E,0xADEE,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㍽
{0x2D6F,0x878F,0xADEF,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ㍼
{0x2D70,0x8790,0xADF0,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ≒
{0x2D71,0x8791,0xADF1,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ≡
{0x2D72,0x8792,0xADF2,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ∫
{0x2D73,0x8793,0xADF3,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ∮
{0x2D74,0x8794,0xADF4,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ∑
{0x2D75,0x8795,0xADF5,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // √
{0x2D76,0x8796,0xADF6,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⊥
{0x2D77,0x8797,0xADF7,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ∠
{0x2D78,0x8798,0xADF8,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ∟
{0x2D79,0x8799,0xADF9,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ⊿
{0x2D7A,0x879A,0xADFA,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ∵
{0x2D7B,0x879B,0xADFB,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ∩
{0x2D7C,0x879C,0xADFC,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ∪
{0x2D7D,0x879D,0xADFD,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ・
{0x2D7E,0x879E,0xADFE,0x00,    0x0000,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // ・
{0x3021,0x889F,0xB0A1,0xE4BA9C,0x4E9C,{0x00,0x00,0x3f,0xff,0x02,0x20,0x02,0x20,0x02,0x20,0x1f,0xfc,0x12,0x24,0x12,0x24,0x12,0x24,0x12,0x24,0x1f,0xfc,0x02,0x20,0x02,0x20,0x02,0x20,0x7f,0xff,0x00,0x00}}, // 亜
{0x3022,0x88A0,0xB0A2,0xE59496,0x5516,{0x00,0x00,0x07,0xff,0x78,0x48,0x48,0x48,0x48,0x48,0x4b,0xfe,0x4a,0x4a,0x4a,0x4a,0x4a,0x4a,0x4b,0xfe,0x48,0x48,0x78,0x48,0x48,0x48,0x00,0x48,0x07,0xff,0x00,0x00}}, // 唖
{0x3023,0x88A1,0xB0A3,0xE5A883,0x5A03,{0x08,0x10,0x08,0x10,0x08,0x10,0x08,0xfe,0x7f,0x10,0x12,0x10,0x12,0x10,0x13,0xff,0x22,0x10,0x7c,0x10,0x44,0xfe,0x06,0x10,0x0a,0x10,0x10,0x10,0x61,0xff,0x00,0x00}}, // 娃
{0x3024,0x88A2,0xB0A4,0xE998BF,0x963F,{0x00,0x00,0x3f,0xff,0x24,0x04,0x24,0x04,0x29,0xe4,0x31,0x24,0x29,0x24,0x25,0x24,0x25,0x24,0x25,0x24,0x25,0xe4,0x25,0x24,0x38,0x04,0x20,0x04,0x20,0x0c,0x20,0x04}}, // 阿
{0x3025,0x88A3,0xB0A5,0xE59380,0x54C0,{0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xfa,0x01,0x82,0x0e,0x84,0x72,0x48,0x02,0x30,0x03,0x90,0x0e,0x0c,0x30,0x03}}, // 哀
{0x3026,0x88A4,0xB0A6,0xE6849B,0x611B,{0x00,0x3c,0x1f,0xc8,0x11,0x08,0x08,0x90,0x7f,0xfe,0x44,0x82,0x54,0x48,0x14,0x14,0x23,0xf2,0x42,0x02,0x07,0xe0,0x0c,0x20,0x33,0x40,0x01,0x80,0x06,0x70,0x78,0x0e}}, // 愛
{0x3027,0x88A5,0xB0A7,0xE68CA8,0x6328,{0x10,0x40,0x10,0x50,0x10,0x48,0x7c,0x84,0x13,0xfa,0x10,0x82,0x10,0x80,0x11,0xfe,0x15,0x20,0x1a,0x20,0x73,0xff,0x10,0x50,0x10,0x50,0x10,0x88,0x11,0x04,0x36,0x02}}, // 挨
{0x3028,0x88A6,0xB0A8,0xE5A7B6,0x59F6,{0x08,0x10,0x08,0x10,0x08,0x28,0x08,0x28,0x7e,0x44,0x12,0x82,0x13,0x01,0x12,0x7c,0x22,0x00,0x24,0x00,0x7c,0xfe,0x46,0x82,0x0a,0x82,0x10,0x82,0x60,0xfe,0x00,0x82}}, // 姶
{0x3029,0x88A7,0xB0A9,0xE980A2,0x9022,{0x00,0x80,0x20,0xfc,0x11,0x08,0x16,0x90,0x00,0x60,0x00,0xd8,0x07,0x07,0x78,0x20,0x0b,0xfc,0x08,0x20,0x09,0xfc,0x08,0x20,0x0f,0xfe,0x14,0x20,0x23,0x20,0x40,0xff}}, // 逢
{0x302A,0x88A8,0xB0AA,0xE891B5,0x8475,{0x02,0x20,0x02,0x20,0x7f,0xff,0x02,0x20,0x0f,0x48,0x21,0x52,0x12,0x24,0x0c,0x18,0x17,0xfc,0x60,0x83,0x00,0x80,0x3f,0xfe,0x01,0x40,0x02,0x20,0x0c,0x18,0x30,0x06}}, // 葵
{0x302B,0x88A9,0xB0AB,0xE88C9C,0x831C,{0x04,0x20,0x04,0x20,0x7f,0xfe,0x04,0x20,0x00,0x00,0x7f,0xfe,0x02,0x40,0x02,0x40,0x3f,0xfc,0x22,0x44,0x22,0x44,0x24,0x3c,0x28,0x04,0x30,0x04,0x3f,0xfc,0x20,0x04}}, // 茜
{0x302C,0x88AA,0xB0AC,0xE7A990,0x7A50,{0x02,0x40,0x0c,0x78,0x38,0x90,0x09,0xfc,0x0a,0xa4,0x08,0xfc,0x7f,0xa4,0x0c,0xfc,0x1a,0x20,0x19,0xfe,0x29,0x22,0x29,0xfe,0x49,0x22,0x09,0xfe,0x08,0x21,0x08,0x1f}}, // 穐
{0x302D,0x88AB,0xB0AD,0xE682AA,0x60AA,{0x00,0x00,0x3f,0xfe,0x02,0x40,0x02,0x40,0x1f,0xf8,0x12,0x48,0x12,0x48,0x1f,0xf8,0x02,0x40,0x7f,0xfe,0x00,0x80,0x12,0x48,0x12,0x44,0x22,0x12,0x42,0x12,0x01,0xf0}}, // 悪
{0x302E,0x88AC,0xB0AE,0xE68FA1,0x63E1,{0x10,0x00,0x13,0xfe,0x12,0x02,0x12,0x02,0x7f,0xfe,0x12,0x00,0x13,0xfe,0x12,0x28,0x16,0x44,0x1b,0xfa,0x72,0x22,0x15,0xfc,0x14,0x20,0x18,0x20,0x17,0xff,0x30,0x00}}, // 握
{0x302F,0x88AD,0xB0AF,0xE6B8A5,0x6E25,{0x10,0x00,0x13,0xfe,0x0a,0x02,0x4a,0x02,0x43,0xfe,0x22,0x00,0x23,0xfe,0x02,0x28,0x0a,0x44,0x0b,0xfa,0x12,0x22,0x15,0xfc,0x24,0x20,0x28,0x20,0x57,0xff,0x40,0x00}}, // 渥
{0x3030,0x88AE,0xB0B0,0xE697AD,0x65ED,{0x08,0x00,0x08,0x7c,0x08,0x44,0x08,0x44,0x7f,0x44,0x09,0x44,0x09,0x7c,0x09,0x44,0x09,0x44,0x09,0x44,0x09,0x44,0x09,0x7c,0x11,0x44,0x11,0x01,0x20,0x81,0x40,0x7f}}, // 旭
{0x3031,0x88AF,0xB0B1,0xE891A6,0x8466,{0x02,0x10,0x7f,0xff,0x02,0x10,0x01,0x00,0x0f,0xf8,0x02,0x08,0x7f,0xff,0x00,0x00,0x07,0xf8,0x04,0x08,0x07,0xf8,0x00,0x40,0x0f,0xfc,0x08,0x40,0x7f,0xff,0x00,0x40}}, // 葦
{0x3032,0x88B0,0xB0B2,0xE88AA6,0x82A6,{0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x00,0x00,0x3f,0xfe,0x00,0x00,0x0f,0xfc,0x08,0x04,0x08,0x04,0x0f,0xfc,0x08,0x04,0x10,0x00,0x10,0x00,0x20,0x00,0x40,0x00}}, // 芦
{0x3033,0x88B1,0xB0B3,0xE9AFB5,0x9BF5,{0x08,0x10,0x0e,0x18,0x12,0x24,0x24,0xfa,0x7f,0x10,0x29,0xff,0x29,0x28,0x3f,0x4c,0x29,0x93,0x29,0x64,0x3f,0x08,0x05,0x32,0x32,0xc4,0x2a,0x08,0x28,0x30,0x40,0xc0}}, // 鯵
{0x3034,0x88B2,0xB0B4,0xE6A293,0x6893,{0x08,0x20,0x08,0x20,0x09,0xfe,0x7e,0x08,0x08,0x88,0x08,0x48,0x1c,0x50,0x1b,0xff,0x1a,0x20,0x28,0x20,0x28,0x20,0x49,0xfe,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20}}, // 梓
{0x3035,0x88B3,0xB0B5,0xE59CA7,0x5727,{0x00,0x00,0x1f,0xfe,0x10,0x00,0x10,0x40,0x10,0x40,0x10,0x40,0x10,0x40,0x17,0xfe,0x10,0x40,0x10,0x40,0x10,0x40,0x20,0x40,0x20,0x40,0x5f,0xff,0x00,0x00,0x00,0x00}}, // 圧
{0x3036,0x88B4,0xB0B6,0xE696A1,0x65A1,{0x08,0x10,0x08,0x10,0x7f,0x28,0x08,0x28,0x3e,0x44,0x22,0xca,0x23,0x29,0x3e,0x28,0x22,0x88,0x22,0x48,0x3e,0x48,0x08,0x0f,0x7f,0x38,0x09,0xc8,0x08,0x08,0x08,0x08}}, // 斡
{0x3037,0x88B5,0xB0B7,0xE689B1,0x6271,{0x10,0x00,0x13,0xf8,0x10,0x88,0x10,0x88,0x7e,0x90,0x10,0x90,0x10,0xbc,0x10,0xc4,0x11,0x44,0x1d,0x24,0x71,0x28,0x11,0x10,0x12,0x18,0x12,0x24,0x34,0xc2,0x1b,0x01}}, // 扱
{0x3038,0x88B6,0xB0B8,0xE5AE9B,0x5B9B,{0x00,0x80,0x00,0x80,0x3f,0xfe,0x28,0x04,0x28,0x00,0x48,0x00,0x0f,0x7c,0x11,0x44,0x12,0x44,0x2a,0x44,0x46,0x44,0x04,0x58,0x04,0x40,0x08,0x42,0x10,0x42,0x60,0x3e}}, // 宛
{0x3039,0x88B7,0xB0B9,0xE5A790,0x59D0,{0x08,0x00,0x08,0xfc,0x08,0x84,0x08,0x84,0x7f,0x84,0x12,0xfc,0x12,0x84,0x12,0x84,0x22,0x84,0x24,0x84,0x7c,0xfc,0x06,0x84,0x0a,0x84,0x10,0x84,0x67,0xff,0x00,0x00}}, // 姐
{0x303A,0x88B8,0xB0BA,0xE899BB,0x867B,{0x08,0x08,0x08,0x08,0x08,0x08,0x3f,0x08,0x29,0xff,0x29,0x20,0x29,0x20,0x29,0x20,0x3f,0x20,0x08,0x20,0x08,0x20,0x0a,0x20,0x09,0x20,0x0f,0x20,0x78,0x9e,0x00,0x80}}, // 虻
{0x303B,0x88B9,0xB0BB,0xE9A3B4,0x98F4,{0x08,0x20,0x08,0x20,0x14,0x20,0x12,0x48,0x29,0x44,0x7e,0x8e,0x23,0xf2,0x3e,0x02,0x22,0x00,0x22,0x7c,0x3e,0x44,0x24,0x44,0x22,0x44,0x26,0x44,0x39,0x7c,0x60,0x44}}, // 飴
{0x303C,0x88BA,0xB0BC,0xE7B5A2,0x7D62,{0x08,0x40,0x08,0x40,0x0a,0x40,0x72,0x7e,0x16,0x82,0x08,0x82,0x0b,0x7a,0x12,0x4a,0x7f,0x7a,0x09,0x4a,0x28,0x4a,0x2a,0x7a,0x29,0x4a,0x29,0x02,0x48,0x04,0x08,0x18}}, // 絢
{0x303D,0x88BB,0xB0BD,0xE7B6BE,0x7DBE,{0x08,0x20,0x08,0x20,0x0b,0xfc,0x72,0x20,0x17,0xff,0x08,0x50,0x0a,0x52,0x12,0x8e,0x7f,0x40,0x0a,0x7c,0x2c,0x88,0x2b,0x50,0x2a,0x20,0x2a,0x50,0x49,0x8c,0x0a,0x03}}, // 綾
{0x303E,0x88BC,0xB0BE,0xE9AE8E,0x9B8E,{0x08,0x10,0x0e,0x10,0x12,0x10,0x24,0x10,0x7f,0x1f,0x29,0x10,0x29,0x10,0x3f,0x10,0x29,0x10,0x29,0x7e,0x3f,0x42,0x02,0x42,0x15,0x42,0x2a,0x42,0x2a,0x7e,0x40,0x42}}, // 鮎
{0x303F,0x88BD,0xB0BF,0xE68896,0x6216,{0x00,0x48,0x00,0x44,0x00,0x44,0x7f,0xff,0x00,0x40,0x00,0x44,0x1f,0x44,0x11,0x44,0x11,0x28,0x11,0x28,0x1f,0x28,0x10,0x92,0x03,0x32,0x0c,0x4a,0x71,0x86,0x06,0x02}}, // 或
{0x3040,0x88BE,0xB0C0,0xE7B29F,0x7C9F,{0x00,0x00,0x7f,0xff,0x02,0x20,0x1f,0xfc,0x12,0x24,0x12,0x24,0x1f,0xfc,0x08,0x88,0x04,0x88,0x02,0x90,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x0c,0x98,0x70,0x86,0x00,0x80}}, // 粟
{0x3041,0x88BF,0xB0C1,0xE8A2B7,0x88B7,{0x08,0x10,0x08,0x10,0x08,0x30,0x7e,0x28,0x02,0x48,0x04,0x44,0x04,0x84,0x0a,0xfa,0x1b,0x01,0x2c,0x00,0x4a,0xfc,0x09,0x84,0x08,0x84,0x08,0x84,0x08,0xfc,0x08,0x84}}, // 袷
{0x3042,0x88C0,0xB0C2,0xE5AE89,0x5B89,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x22,0x04,0x42,0x00,0x02,0x00,0x02,0x00,0x7f,0xfe,0x04,0x40,0x04,0x40,0x08,0x40,0x0e,0x40,0x01,0x80,0x02,0x60,0x0c,0x10,0x30,0x08}}, // 安
{0x3043,0x88C1,0xB0C3,0xE5BAB5,0x5EB5,{0x00,0x80,0x00,0x80,0x1f,0xfe,0x10,0x40,0x1f,0xfe,0x10,0xa0,0x11,0x10,0x13,0xfc,0x1e,0x4b,0x12,0x48,0x13,0xf8,0x12,0x48,0x22,0x48,0x23,0xfa,0x42,0x42,0x00,0x3e}}, // 庵
{0x3044,0x88C2,0xB0C4,0xE68C89,0x6309,{0x10,0x40,0x10,0x40,0x13,0xfe,0x12,0x04,0x7c,0x40,0x10,0x40,0x10,0x40,0x13,0xff,0x1c,0x88,0x70,0x88,0x11,0x10,0x13,0xd0,0x10,0x20,0x10,0x50,0x31,0x88,0x16,0x04}}, // 按
{0x3045,0x88C3,0xB0C5,0xE69A97,0x6697,{0x00,0x20,0x00,0x20,0x7f,0xfe,0x44,0x88,0x44,0x48,0x44,0x50,0x47,0xff,0x7c,0x00,0x44,0xfc,0x44,0x84,0x44,0x84,0x44,0xfc,0x7c,0x84,0x44,0x84,0x00,0xfc,0x00,0x84}}, // 暗
{0x3046,0x88C4,0xB0C6,0xE6A188,0x6848,{0x00,0x80,0x00,0x80,0x3f,0xfe,0x21,0x04,0x5f,0xf8,0x02,0x20,0x0e,0x20,0x01,0xc0,0x06,0x38,0x18,0x84,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x0c,0x98,0x70,0x86,0x00,0x80}}, // 案
{0x3047,0x88C5,0xB0C7,0xE99787,0x95C7,{0x00,0x00,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x42,0x42,0x42,0x42,0x7e,0x7e,0x41,0x02,0x4f,0xf2,0x42,0x42,0x5f,0xfa,0x44,0x22,0x47,0xe2,0x44,0x22,0x47,0xe2,0x40,0x06}}, // 闇
{0x3048,0x88C6,0xB0C8,0xE99E8D,0x978D,{0x12,0x10,0x12,0x10,0x7f,0xff,0x12,0x42,0x12,0xa0,0x1e,0x20,0x08,0x20,0x3f,0xff,0x29,0x24,0x29,0x24,0x3f,0x44,0x08,0x68,0x7f,0x98,0x08,0x24,0x08,0x42,0x09,0x82}}, // 鞍
{0x3049,0x88C7,0xB0C9,0xE69D8F,0x674F,{0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 杏
{0x304A,0x88C8,0xB0CA,0xE4BBA5,0x4EE5,{0x00,0x00,0x10,0x08,0x10,0x08,0x10,0x08,0x12,0x08,0x11,0x08,0x10,0x88,0x10,0x88,0x10,0x08,0x10,0x08,0x10,0x18,0x11,0x14,0x16,0x22,0x18,0x42,0x60,0x81,0x03,0x01}}, // 以
{0x304B,0x88C9,0xB0CB,0xE4BC8A,0x4F0A,{0x04,0x00,0x05,0xfc,0x04,0x24,0x08,0x24,0x08,0x24,0x1f,0xff,0x18,0x24,0x28,0x24,0x48,0x24,0x09,0xfc,0x08,0x24,0x08,0x20,0x08,0x40,0x08,0x40,0x08,0x80,0x09,0x00}}, // 伊
{0x304C,0x88CA,0xB0CC,0xE4BD8D,0x4F4D,{0x04,0x20,0x04,0x20,0x04,0x20,0x08,0x20,0x0b,0xfe,0x18,0x04,0x18,0x04,0x29,0x04,0x48,0x88,0x08,0x88,0x08,0x88,0x08,0x90,0x08,0x90,0x08,0x20,0x0f,0xff,0x08,0x00}}, // 位
{0x304D,0x88CB,0xB0CD,0xE4BE9D,0x4F9D,{0x04,0x20,0x04,0x20,0x04,0x20,0x0f,0xff,0x08,0xc0,0x10,0xa2,0x10,0xa2,0x31,0x24,0x53,0x24,0x15,0x18,0x19,0x10,0x11,0x08,0x11,0x08,0x11,0x64,0x11,0x82,0x16,0x01}}, // 依
{0x304E,0x88CC,0xB0CE,0xE58189,0x5049,{0x04,0x20,0x05,0xfc,0x04,0x44,0x08,0x44,0x0f,0xff,0x10,0x00,0x11,0xfc,0x31,0x04,0x51,0xfc,0x10,0x10,0x11,0xfe,0x11,0x10,0x11,0x10,0x17,0xff,0x10,0x10,0x10,0x10}}, // 偉
{0x304F,0x88CD,0xB0CF,0xE59BB2,0x56F2,{0x00,0x00,0x3f,0xfe,0x20,0x02,0x22,0x22,0x22,0x22,0x2f,0xfa,0x22,0x22,0x22,0x22,0x22,0x22,0x3f,0xfe,0x22,0x22,0x22,0x22,0x24,0x22,0x28,0x22,0x3f,0xfe,0x20,0x02}}, // 囲
{0x3050,0x88CE,0xB0D0,0xE5A4B7,0x5937,{0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x3f,0xfc,0x00,0x84,0x1f,0xfc,0x10,0x80,0x10,0x80,0x1f,0xfe,0x11,0x42,0x01,0x42,0x02,0x2c,0x04,0x10,0x18,0x0c,0x60,0x03}}, // 夷
{0x3051,0x88CF,0xB0D1,0xE5A794,0x59D4,{0x00,0x18,0x1f,0xe0,0x00,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x0c,0x98,0x70,0x87,0x01,0x00,0x7f,0xff,0x02,0x10,0x02,0x10,0x07,0xa0,0x08,0x40,0x01,0xb0,0x3e,0x0c}}, // 委
{0x3052,0x88D0,0xB0D2,0xE5A881,0x5A01,{0x00,0x28,0x00,0x24,0x00,0x24,0x1f,0xff,0x10,0x20,0x1f,0xa0,0x12,0x22,0x12,0x22,0x1f,0xd4,0x14,0x94,0x14,0x98,0x1f,0x08,0x11,0x9a,0x22,0xa6,0x2c,0x42,0x40,0x82}}, // 威
{0x3053,0x88D1,0xB0D3,0xE5B089,0x5C09,{0x00,0x04,0x3f,0x84,0x20,0x84,0x20,0x84,0x3f,0x84,0x20,0x7f,0x2f,0x04,0x20,0x04,0x20,0x24,0x3f,0x94,0x22,0x14,0x2b,0x04,0x2a,0x84,0x2a,0x84,0x52,0x04,0x06,0x0c}}, // 尉
{0x3054,0x88D2,0xB0D4,0xE6839F,0x60DF,{0x08,0x40,0x08,0x48,0x08,0x48,0x08,0x90,0x0c,0xfe,0x2a,0x90,0x2b,0x90,0x28,0xfe,0x48,0x90,0x08,0x90,0x08,0xfe,0x08,0x90,0x08,0x90,0x08,0x90,0x08,0xff,0x08,0x80}}, // 惟
{0x3055,0x88D3,0xB0D5,0xE6848F,0x610F,{0x00,0x80,0x3f,0xfe,0x04,0x10,0x02,0x20,0x7f,0xff,0x00,0x00,0x07,0xf8,0x04,0x08,0x07,0xf8,0x04,0x08,0x07,0xf8,0x12,0x80,0x12,0x42,0x22,0x49,0x42,0x09,0x01,0xf8}}, // 意
{0x3056,0x88D4,0xB0D6,0xE685B0,0x6170,{0x00,0x04,0x3f,0x84,0x20,0x84,0x3f,0x84,0x20,0x7f,0x2f,0x04,0x20,0x24,0x3f,0x94,0x22,0x14,0x2a,0x84,0x56,0x84,0x05,0x0c,0x14,0x80,0x14,0x92,0x24,0x11,0x43,0xf1}}, // 慰
{0x3057,0x88D5,0xB0D7,0xE69893,0x6613,{0x00,0x00,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x02,0x00,0x07,0xfc,0x18,0x94,0x61,0x14,0x06,0x24,0x18,0x44,0x01,0x88,0x00,0x30}}, // 易
{0x3058,0x88D6,0xB0D8,0xE6A485,0x6905,{0x08,0x20,0x08,0x20,0x09,0xfe,0x7e,0x20,0x08,0x50,0x08,0x48,0x1c,0x84,0x1b,0xff,0x1a,0x04,0x29,0xe4,0x29,0x24,0x49,0x24,0x09,0xe4,0x09,0x24,0x08,0x04,0x08,0x0c}}, // 椅
{0x3059,0x88D7,0xB0D9,0xE782BA,0x70BA,{0x10,0x80,0x08,0x80,0x08,0x80,0x3f,0xf8,0x01,0x08,0x01,0x10,0x03,0xfc,0x02,0x04,0x04,0x04,0x0f,0xff,0x08,0x01,0x14,0x91,0x32,0x49,0x49,0x29,0x09,0x21,0x08,0x06}}, // 為
{0x305A,0x88D8,0xB0DA,0xE7958F,0x754F,{0x00,0x00,0x1f,0xf8,0x10,0x88,0x10,0x88,0x1f,0xf8,0x10,0x88,0x10,0x88,0x1f,0xf8,0x00,0x00,0x7f,0xff,0x09,0x04,0x08,0x88,0x08,0x50,0x0b,0x20,0x0c,0x18,0x30,0x07}}, // 畏
{0x305B,0x88D9,0xB0DB,0xE795B0,0x7570,{0x00,0x00,0x1f,0xfc,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x84,0x10,0x84,0x1f,0xfc,0x02,0x20,0x1f,0xfc,0x02,0x20,0x02,0x20,0x7f,0xff,0x02,0x30,0x0c,0x0c,0x30,0x02}}, // 異
{0x305C,0x88DA,0xB0DC,0xE7A7BB,0x79FB,{0x01,0x20,0x06,0x3e,0x38,0x44,0x08,0x84,0x09,0x68,0x7e,0x10,0x08,0x20,0x08,0xc8,0x1c,0x0f,0x1a,0x11,0x29,0x22,0x28,0xda,0x48,0x04,0x08,0x08,0x08,0x30,0x09,0xc0}}, // 移
{0x305D,0x88DB,0xB0DD,0xE7B6AD,0x7DAD,{0x08,0x20,0x08,0x24,0x0a,0x24,0x72,0x48,0x14,0x7f,0x08,0xc8,0x0b,0x48,0x12,0x7e,0x7f,0x48,0x09,0x48,0x2c,0x7e,0x2a,0x48,0x29,0x48,0x29,0x48,0x48,0x7f,0x08,0x40}}, // 維
{0x305E,0x88DC,0xB0DE,0xE7B7AF,0x7DEF,{0x08,0x10,0x08,0xfc,0x0a,0x24,0x72,0x24,0x17,0xff,0x08,0x00,0x0a,0x7e,0x12,0x42,0x7f,0x7e,0x09,0x08,0x2c,0x7e,0x2a,0x48,0x2a,0x48,0x29,0xff,0x48,0x08,0x08,0x08}}, // 緯
{0x305F,0x88DD,0xB0DF,0xE88383,0x80C3,{0x00,0x00,0x3f,0xfc,0x21,0x04,0x21,0x04,0x3f,0xfc,0x21,0x04,0x3f,0xfc,0x00,0x00,0x1f,0xf8,0x10,0x08,0x1f,0xf8,0x10,0x08,0x1f,0xf8,0x10,0x08,0x10,0x08,0x10,0x18}}, // 胃
{0x3060,0x88DE,0xB0E0,0xE8908E,0x840E,{0x02,0x10,0x7f,0xff,0x02,0x10,0x00,0x38,0x1f,0xc0,0x00,0x80,0x7f,0xff,0x02,0xa0,0x0c,0x98,0x30,0x86,0x7f,0xff,0x02,0x20,0x04,0x20,0x1f,0xc0,0x03,0x30,0x3c,0x0c}}, // 萎
{0x3061,0x88DF,0xB0E1,0xE8A1A3,0x8863,{0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0x80,0x02,0x84,0x02,0x44,0x04,0x48,0x1c,0x30,0x64,0x20,0x04,0x10,0x04,0x08,0x05,0xc4,0x0e,0x02,0x30,0x01}}, // 衣
{0x3062,0x88E0,0xB0E2,0xE8AC82,0x8B02,{0x00,0x00,0x3e,0xfe,0x00,0x92,0x7f,0xfe,0x00,0x92,0x3e,0x92,0x00,0xfe,0x00,0x00,0x3e,0x7e,0x00,0x42,0x3e,0x7e,0x22,0x42,0x22,0x7e,0x22,0x42,0x3e,0x42,0x22,0x46}}, // 謂
{0x3063,0x88E1,0xB0E3,0xE98195,0x9055,{0x00,0x20,0x23,0xfc,0x10,0x44,0x10,0x44,0x07,0xff,0x00,0x00,0x01,0xfc,0x79,0x04,0x09,0xfc,0x08,0x10,0x09,0xfe,0x09,0x10,0x0f,0xff,0x14,0x10,0x23,0x10,0x40,0xff}}, // 違
{0x3064,0x88E2,0xB0E4,0xE981BA,0x907A,{0x00,0x20,0x21,0xf8,0x11,0x28,0x11,0xf8,0x00,0x20,0x07,0xfe,0x00,0x00,0x79,0xf8,0x09,0x08,0x09,0xf8,0x09,0x08,0x09,0xf8,0x0d,0x08,0x15,0xf8,0x23,0x04,0x40,0xff}}, // 遺
{0x3065,0x88E3,0xB0E5,0xE58CBB,0x533B,{0x00,0x00,0x3f,0xfe,0x21,0x00,0x21,0x00,0x23,0xfc,0x24,0x40,0x28,0x40,0x3f,0xfe,0x20,0xa0,0x20,0x90,0x21,0x08,0x22,0x04,0x24,0x04,0x28,0x00,0x3f,0xfe,0x20,0x00}}, // 医
{0x3066,0x88E4,0xB0E6,0xE4BA95,0x4E95,{0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x3f,0xfc,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x7f,0xfe,0x04,0x20,0x04,0x20,0x04,0x20,0x08,0x20,0x08,0x20,0x10,0x20}}, // 井
{0x3067,0x88E5,0xB0E7,0xE4BAA5,0x4EA5,{0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0x00,0x01,0x10,0x1a,0x20,0x04,0x40,0x02,0x88,0x01,0x10,0x06,0x20,0x18,0x60,0x00,0x90,0x03,0x08,0x0c,0x04,0x70,0x04}}, // 亥
{0x3068,0x88E6,0xB0E8,0xE59F9F,0x57DF,{0x10,0x10,0x10,0x14,0x10,0x12,0x13,0xff,0x10,0x10,0x7f,0xd2,0x12,0x52,0x12,0x52,0x12,0x54,0x13,0xcc,0x12,0x4c,0x16,0x28,0x18,0xcd,0x63,0x15,0x0c,0x23,0x00,0x41}}, // 域
{0x3069,0x88E7,0xB0E9,0xE882B2,0x80B2,{0x00,0x80,0x00,0x80,0x7f,0xff,0x02,0x20,0x04,0x18,0x0f,0xe4,0x70,0x02,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x18,0x08,0x08}}, // 育
{0x306A,0x88E8,0xB0EA,0xE98381,0x90C1,{0x04,0x00,0x04,0x1e,0x7f,0xf2,0x04,0x12,0x08,0x14,0x0f,0x98,0x18,0x94,0x18,0x92,0x2f,0x91,0x48,0x91,0x08,0x91,0x0f,0x99,0x08,0x96,0x08,0x90,0x09,0x90,0x08,0x90}}, // 郁
{0x306B,0x88E9,0xB0EB,0xE7A3AF,0x78EF,{0x00,0xa4,0x7e,0xa4,0x13,0x78,0x10,0xa4,0x10,0xaa,0x11,0x7d,0x27,0xe4,0x3c,0x22,0x27,0xff,0x64,0x94,0x24,0x94,0x24,0xc8,0x3d,0x29,0x25,0x15,0x22,0x23,0x0c,0x41}}, // 磯
{0x306C,0x88EA,0xB0EC,0xE4B880,0x4E00,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x7f,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // 一
{0x306D,0x88EB,0xB0ED,0xE5A3B1,0x58F1,{0x01,0x00,0x01,0x00,0x7f,0xfe,0x01,0x00,0x01,0x00,0x1f,0xf8,0x00,0x00,0x3f,0xfe,0x20,0x04,0x48,0x20,0x08,0xc0,0x0f,0x00,0x08,0x00,0x08,0x08,0x04,0x08,0x03,0xf8}}, // 壱
{0x306E,0x88EC,0xB0EE,0xE6BAA2,0x6EA2,{0x12,0x04,0x09,0x08,0x09,0x08,0x0f,0xff,0x40,0x90,0x21,0x08,0x21,0x08,0x02,0x04,0x04,0x02,0x1b,0xfd,0x12,0xa4,0x12,0xa4,0x22,0xa4,0x22,0xa4,0x4f,0xff,0x40,0x00}}, // 溢
{0x306F,0x88ED,0xB0EF,0xE980B8,0x9038,{0x00,0x40,0x20,0x78,0x10,0x88,0x11,0x10,0x07,0xfc,0x01,0x24,0x01,0x24,0x79,0x24,0x09,0xfc,0x08,0x50,0x08,0x50,0x08,0x91,0x15,0x11,0x12,0x0f,0x21,0x80,0x40,0x7f}}, // 逸
{0x3070,0x88EE,0xB0F0,0xE7A8B2,0x7A32,{0x02,0x04,0x0c,0x18,0x38,0xe0,0x08,0x02,0x08,0xa2,0x7f,0x54,0x08,0x54,0x08,0x08,0x1c,0xbe,0x1a,0xa2,0x2a,0xa2,0x28,0xbe,0x48,0xa2,0x08,0xa2,0x08,0xbe,0x08,0xa2}}, // 稲
{0x3071,0x88EF,0xB0F1,0xE88CA8,0x8328,{0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x02,0x90,0x10,0x80,0x08,0xfe,0x08,0xa2,0x01,0x24,0x01,0x20,0x0a,0x30,0x08,0x28,0x10,0x48,0x20,0x84,0x43,0x02,0x0c,0x01}}, // 茨
{0x3072,0x88F0,0xB0F2,0xE88A8B,0x828B,{0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x02,0x10,0x00,0x00,0x1f,0xfc,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x03,0x80,0x00,0x80}}, // 芋
{0x3073,0x88F1,0xB0F3,0xE9B0AF,0x9C2F,{0x08,0x00,0x0f,0xfe,0x12,0x22,0x24,0x22,0x7e,0xee,0x2a,0x88,0x2a,0x88,0x3e,0xee,0x2a,0x32,0x2a,0xaa,0x3e,0xaa,0x02,0x66,0x35,0xaa,0x2b,0x32,0x2a,0x22,0x40,0xcc}}, // 鰯
{0x3074,0x88F2,0xB0F4,0xE58581,0x5141,{0x01,0x00,0x01,0x00,0x01,0x40,0x02,0x20,0x02,0x18,0x04,0xf4,0x7f,0x42,0x02,0x40,0x02,0x40,0x02,0x40,0x04,0x40,0x04,0x40,0x08,0x40,0x08,0x42,0x10,0x22,0x20,0x1e}}, // 允
{0x3075,0x88F3,0xB0F5,0xE58DB0,0x5370,{0x01,0x00,0x06,0x00,0x38,0x7e,0x20,0x42,0x20,0x42,0x20,0x42,0x3f,0x42,0x20,0x42,0x20,0x42,0x20,0x42,0x3f,0x42,0x20,0x5c,0x20,0x40,0x00,0x40,0x00,0x40,0x00,0x40}}, // 印
{0x3076,0x88F4,0xB0F6,0xE592BD,0x54BD,{0x00,0x00,0x03,0xfe,0x7a,0x22,0x4a,0x22,0x4a,0x22,0x4a,0x22,0x4b,0xfe,0x4a,0x22,0x4a,0x22,0x4a,0x52,0x4a,0x52,0x7a,0x8a,0x4b,0x06,0x02,0x02,0x03,0xfe,0x02,0x02}}, // 咽
{0x3077,0x88F5,0xB0F7,0xE593A1,0x54E1,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x00,0x00,0x1f,0xfc,0x10,0x04,0x1f,0xfc,0x10,0x04,0x1f,0xfc,0x10,0x04,0x1f,0xfc,0x02,0x30,0x0c,0x0c,0x30,0x02}}, // 員
{0x3078,0x88F6,0xB0F8,0xE59BA0,0x56E0,{0x00,0x00,0x3f,0xfe,0x20,0x02,0x20,0x82,0x20,0x82,0x20,0x82,0x3f,0xfe,0x21,0x42,0x21,0x42,0x22,0x22,0x22,0x22,0x24,0x12,0x28,0x0a,0x20,0x02,0x3f,0xfe,0x20,0x02}}, // 因
{0x3079,0x88F7,0xB0F9,0xE5A7BB,0x59FB,{0x08,0x00,0x08,0xfe,0x08,0x82,0x08,0x92,0x7e,0x92,0x12,0xfe,0x12,0x92,0x12,0x92,0x22,0xaa,0x24,0xaa,0x7c,0xaa,0x06,0xc6,0x0a,0x82,0x10,0x82,0x60,0xfe,0x00,0x82}}, // 姻
{0x307A,0x88F8,0xB0FA,0xE5BC95,0x5F15,{0x00,0x04,0x7f,0x84,0x00,0x84,0x00,0x84,0x00,0x84,0x3f,0x84,0x20,0x04,0x20,0x04,0x20,0x04,0x3f,0x84,0x20,0x84,0x00,0x84,0x00,0x84,0x00,0x84,0x01,0x04,0x0e,0x04}}, // 引
{0x307B,0x88F9,0xB0FB,0xE9A3B2,0x98F2,{0x08,0x20,0x08,0x20,0x14,0x20,0x1a,0x20,0x29,0x7f,0x7e,0x51,0x22,0x52,0x3e,0x94,0x23,0x10,0x22,0x10,0x3e,0x28,0x28,0x28,0x24,0x44,0x26,0x44,0x3a,0x82,0x61,0x01}}, // 飲
{0x307C,0x88FA,0xB0FC,0xE6B7AB,0x6DEB,{0x10,0x04,0x08,0x18,0x0b,0xe2,0x42,0x42,0x21,0x24,0x21,0x28,0x00,0x0c,0x01,0xf0,0x08,0x20,0x08,0x20,0x17,0xff,0x10,0x20,0x20,0x20,0x20,0x20,0x43,0xfe,0x40,0x00}}, // 淫
{0x307D,0x88FB,0xB0FD,0xE883A4,0x80E4,{0x10,0x84,0x10,0x84,0x17,0x24,0x11,0x44,0x10,0x84,0x11,0x34,0x1f,0xec,0x10,0x04,0x13,0xe4,0x12,0x24,0x13,0xe4,0x12,0x24,0x13,0xe4,0x22,0x25,0x22,0x25,0x42,0x63}}, // 胤
{0x307E,0x88FC,0xB0FE,0xE894AD,0x852D,{0x02,0x10,0x7f,0xff,0x02,0x10,0x02,0x20,0x3c,0x30,0x24,0x48,0x28,0xf4,0x33,0x03,0x28,0xf8,0x24,0x10,0x25,0xfc,0x24,0x00,0x3b,0xfe,0x20,0x48,0x20,0x94,0x21,0xe2}}, // 蔭
{0x3121,0x8940,0xB1A1,0xE999A2,0x9662,{0x00,0x10,0x3c,0x10,0x25,0xff,0x25,0x01,0x29,0x01,0x30,0xfe,0x28,0x00,0x24,0x00,0x27,0xff,0x24,0x48,0x24,0x48,0x34,0x48,0x28,0x88,0x20,0x89,0x21,0x09,0x22,0x07}}, // 院
{0x3122,0x8941,0xB1A2,0xE999B0,0x9670,{0x00,0x20,0x3c,0x20,0x24,0x50,0x24,0x88,0x29,0x74,0x32,0x03,0x29,0xf8,0x24,0x10,0x24,0x20,0x25,0xfc,0x24,0x00,0x27,0xff,0x38,0x50,0x20,0x88,0x27,0xfc,0x20,0x04}}, // 陰
{0x3123,0x8942,0xB1A3,0xE99AA0,0x96A0,{0x00,0x06,0x3c,0x1a,0x27,0xe2,0x25,0x24,0x28,0x98,0x31,0xfe,0x28,0x02,0x24,0xfe,0x24,0x02,0x25,0xfe,0x24,0x10,0x25,0x4a,0x39,0x49,0x21,0x41,0x22,0x25,0x20,0x1c}}, // 隠
{0x3124,0x8943,0xB1A4,0xE99FBB,0x97FB,{0x08,0x00,0x08,0xfc,0x7f,0x84,0x22,0x84,0x12,0xfc,0x14,0x00,0x7f,0xfc,0x00,0x84,0x3e,0xfc,0x22,0x84,0x22,0xfc,0x3e,0x84,0x22,0xfc,0x22,0x48,0x3e,0x84,0x23,0x02}}, // 韻
{0x3125,0x8944,0xB1A5,0xE5908B,0x540B,{0x00,0x08,0x00,0x08,0x7c,0x08,0x44,0x08,0x47,0xff,0x44,0x08,0x45,0x08,0x44,0x88,0x44,0x48,0x44,0x48,0x44,0x08,0x7c,0x08,0x44,0x08,0x40,0x08,0x00,0x18,0x00,0x08}}, // 吋
{0x3126,0x8945,0xB1A6,0xE58FB3,0x53F3,{0x01,0x00,0x01,0x00,0x01,0x00,0x7f,0xfe,0x02,0x00,0x02,0x00,0x02,0x00,0x04,0x00,0x07,0xf8,0x0c,0x08,0x14,0x08,0x24,0x08,0x44,0x08,0x04,0x08,0x07,0xf8,0x04,0x08}}, // 右
{0x3127,0x8946,0xB1A7,0xE5AE87,0x5B87,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x20,0x00,0x4f,0xf0,0x01,0x00,0x01,0x00,0x01,0x00,0x7f,0xfe,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x07,0x00,0x01,0x00}}, // 宇
{0x3128,0x8947,0xB1A8,0xE7838F,0x70CF,{0x00,0x80,0x01,0x00,0x1f,0xf0,0x10,0x10,0x10,0x10,0x10,0x10,0x1f,0xf0,0x10,0x00,0x1f,0xff,0x10,0x00,0x1f,0xfe,0x00,0x22,0x29,0x12,0x24,0x92,0x24,0x84,0x40,0x18}}, // 烏
{0x3129,0x8948,0xB1A9,0xE7BEBD,0x7FBD,{0x00,0x00,0x3f,0x7e,0x01,0x02,0x01,0x02,0x11,0x22,0x09,0x12,0x09,0x12,0x01,0x02,0x03,0x06,0x05,0x0a,0x19,0x32,0x61,0xc2,0x01,0x02,0x01,0x02,0x01,0x02,0x03,0x06}}, // 羽
{0x312A,0x8949,0xB1AA,0xE8BF82,0x8FC2,{0x00,0x00,0x23,0xfc,0x10,0x20,0x10,0x20,0x00,0x20,0x00,0x20,0x07,0xfe,0x78,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x14,0xe0,0x12,0x20,0x21,0x80,0x40,0x7f}}, // 迂
{0x312B,0x894A,0xB1AB,0xE99BA8,0x96E8,{0x00,0x00,0x7f,0xff,0x00,0x80,0x00,0x80,0x3f,0xfe,0x20,0x82,0x28,0xa2,0x24,0x92,0x24,0x92,0x20,0x82,0x28,0xa2,0x24,0x92,0x24,0x92,0x20,0x82,0x20,0x8e,0x20,0x02}}, // 雨
{0x312C,0x894B,0xB1AC,0xE58DAF,0x536F,{0x02,0x00,0x0c,0x00,0x30,0x7c,0x22,0x44,0x22,0x44,0x22,0x44,0x22,0x44,0x22,0x44,0x22,0x44,0x22,0x44,0x3e,0x44,0x62,0x44,0x04,0x58,0x04,0x40,0x08,0x40,0x10,0x40}}, // 卯
{0x312D,0x894C,0xB1AD,0xE9B59C,0x9D5C,{0x22,0x10,0x12,0x20,0x14,0x7c,0x7f,0x44,0x09,0x7c,0x3f,0x44,0x28,0x7c,0x28,0x40,0x3f,0x7f,0x09,0x40,0x19,0x7e,0x19,0x52,0x2e,0xaa,0x48,0xaa,0x09,0x02,0x08,0x0c}}, // 鵜
{0x312E,0x894D,0xB1AE,0xE7AABA,0x7ABA,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x22,0x44,0x4c,0x7e,0x30,0x00,0x08,0xfc,0x3e,0x84,0x08,0xfc,0x08,0x84,0x7f,0xfc,0x08,0x84,0x14,0xfc,0x12,0x29,0x20,0xc9,0x43,0x07}}, // 窺
{0x312F,0x894E,0xB1AF,0xE4B891,0x4E11,{0x00,0x00,0x1f,0xf0,0x02,0x10,0x02,0x10,0x02,0x10,0x02,0x10,0x02,0x10,0x7f,0xfe,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x7f,0xff,0x00,0x00}}, // 丑
{0x3130,0x894F,0xB1B0,0xE7A293,0x7893,{0x00,0x24,0x7f,0x24,0x08,0x48,0x08,0xff,0x08,0x88,0x11,0x88,0x1e,0x88,0x32,0xfe,0x32,0x88,0x52,0x88,0x12,0xfe,0x12,0x88,0x1e,0x88,0x12,0x88,0x10,0xff,0x00,0x80}}, // 碓
{0x3131,0x8950,0xB1B1,0xE887BC,0x81FC,{0x00,0x80,0x03,0x00,0x1c,0x7c,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x1e,0x7c,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x1f,0xfc,0x10,0x04}}, // 臼
{0x3132,0x8951,0xB1B2,0xE6B8A6,0x6E26,{0x10,0x00,0x09,0xf8,0x09,0x08,0x01,0x08,0x01,0x78,0x41,0x48,0x21,0x48,0x23,0xfe,0x0a,0x02,0x0a,0xf2,0x12,0x92,0x12,0x92,0x22,0xf2,0x22,0x92,0x42,0x02,0x42,0x06}}, // 渦
{0x3133,0x8952,0xB1B3,0xE59898,0x5618,{0x00,0x20,0x00,0x3e,0x78,0x20,0x4b,0xff,0x4a,0x42,0x4a,0x7c,0x4b,0xc0,0x4a,0x42,0x4a,0x3e,0x4a,0x28,0x7b,0x2a,0x44,0xaa,0x04,0xac,0x08,0x28,0x13,0xff,0x00,0x00}}, // 嘘
{0x3134,0x8953,0xB1B4,0xE59484,0x5504,{0x00,0x00,0x00,0x7e,0x3e,0x42,0x22,0x42,0x22,0x42,0x22,0x7e,0x22,0x42,0x22,0x42,0x22,0x7e,0x22,0x42,0x22,0x42,0x3e,0x42,0x22,0x7e,0x00,0x24,0x00,0xc2,0x03,0x01}}, // 唄
{0x3135,0x8954,0xB1B5,0xE6AC9D,0x6B1D,{0x12,0x48,0x7d,0xbf,0x12,0x4c,0x39,0x9a,0x56,0x69,0x3f,0xfc,0x24,0x44,0x3f,0xfc,0x1e,0x08,0x12,0xff,0x1e,0x08,0x12,0x88,0x1e,0x48,0x14,0x08,0x1a,0x08,0x61,0x18}}, // 欝
{0x3136,0x8955,0xB1B6,0xE8949A,0x851A,{0x04,0x20,0x04,0x20,0x7f,0xff,0x04,0x20,0x00,0x04,0x3f,0x84,0x20,0x84,0x3f,0xff,0x20,0x04,0x2f,0x44,0x20,0x24,0x3f,0xa4,0x2b,0x04,0x2a,0x84,0x52,0x8c,0x06,0x04}}, // 蔚
{0x3137,0x8956,0xB1B7,0xE9B0BB,0x9C3B,{0x08,0x00,0x0e,0x7c,0x12,0x44,0x24,0x7c,0x7f,0x44,0x29,0x7c,0x29,0x00,0x3f,0xfe,0x29,0xaa,0x29,0xfe,0x3f,0x00,0x05,0xfc,0x32,0x48,0x2a,0x30,0x28,0x6c,0x41,0x83}}, // 鰻
{0x3138,0x8957,0xB1B8,0xE5A7A5,0x59E5,{0x08,0x20,0x08,0x24,0x09,0xfc,0x08,0x28,0x7e,0x28,0x12,0x30,0x13,0xff,0x12,0x20,0x22,0x40,0x24,0xc4,0x7d,0x58,0x46,0x60,0x0a,0x40,0x10,0x42,0x60,0x42,0x00,0x3e}}, // 姥
{0x3139,0x8958,0xB1B9,0xE58EA9,0x53A9,{0x00,0x00,0x1f,0xff,0x10,0x00,0x17,0xbe,0x14,0xa8,0x14,0xa8,0x17,0xa8,0x14,0xa8,0x14,0xff,0x17,0x88,0x14,0x18,0x15,0x18,0x24,0xa8,0x25,0xa9,0x46,0x49,0x18,0x87}}, // 厩
{0x313A,0x8959,0xB1BA,0xE6B5A6,0x6D66,{0x10,0x24,0x08,0x22,0x0f,0xff,0x00,0x20,0x40,0x20,0x23,0xfe,0x22,0x22,0x02,0x22,0x0b,0xfe,0x0a,0x22,0x12,0x22,0x13,0xfe,0x22,0x22,0x22,0x22,0x42,0x26,0x42,0x22}}, // 浦
{0x313B,0x895A,0xB1BB,0xE7939C,0x74DC,{0x00,0x08,0x00,0x70,0x1f,0x80,0x10,0x10,0x11,0x10,0x11,0x10,0x11,0x10,0x11,0x10,0x11,0x10,0x11,0x08,0x11,0x48,0x11,0x28,0x11,0x28,0x21,0xf4,0x2e,0x14,0x40,0x12}}, // 瓜
{0x313C,0x895B,0xB1BC,0xE9968F,0x958F,{0x00,0x00,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x40,0x02,0x4f,0xf2,0x41,0x02,0x41,0x02,0x47,0xe2,0x41,0x02,0x41,0x02,0x5f,0xfa,0x40,0x06,0x40,0x02}}, // 閏
{0x313D,0x895C,0xB1BD,0xE59982,0x5642,{0x01,0x08,0x00,0x90,0x7f,0xff,0x48,0xa0,0x4b,0xfc,0x4a,0xa4,0x4b,0x1c,0x4b,0xfc,0x4a,0x04,0x4b,0xfc,0x78,0x10,0x4f,0xff,0x02,0x10,0x01,0x10,0x01,0x10,0x00,0x30}}, // 噂
{0x313E,0x895D,0xB1BE,0xE4BA91,0x4E91,{0x00,0x00,0x00,0x00,0x1f,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x7f,0xfe,0x01,0x00,0x01,0x00,0x02,0x20,0x02,0x10,0x04,0x08,0x08,0xf8,0x7f,0x04,0x00,0x04,0x00,0x04}}, // 云
{0x313F,0x895E,0xB1BF,0xE9818B,0x904B,{0x00,0x00,0x23,0xff,0x12,0x22,0x14,0x20,0x03,0xfe,0x00,0x20,0x03,0xfc,0x7a,0x24,0x0b,0xfc,0x0a,0x24,0x0b,0xfc,0x08,0x20,0x17,0xfe,0x12,0x20,0x21,0x80,0x40,0x7f}}, // 運
{0x3140,0x895F,0xB1C0,0xE99BB2,0x96F2,{0x00,0x00,0x3f,0xfc,0x00,0x80,0x3f,0xfe,0x20,0x82,0x3e,0xbc,0x40,0x80,0x1e,0xbc,0x00,0x00,0x1f,0xf8,0x00,0x00,0x7f,0xfe,0x02,0x40,0x04,0x30,0x3f,0xc8,0x00,0x04}}, // 雲
{0x3141,0x8960,0xB1C1,0xE88D8F,0x834F,{0x02,0x20,0x02,0x20,0x7f,0xff,0x02,0x20,0x02,0x20,0x04,0x04,0x04,0x18,0x09,0xf0,0x08,0x10,0x18,0x10,0x2b,0xff,0x48,0x10,0x08,0x10,0x08,0x10,0x09,0xfe,0x08,0x00}}, // 荏
{0x3142,0x8961,0xB1C2,0xE9A48C,0x990C,{0x08,0x00,0x09,0xff,0x14,0x44,0x12,0x44,0x29,0x44,0x7e,0x7c,0x22,0x44,0x3e,0x44,0x22,0x7c,0x22,0x44,0x3e,0x44,0x24,0x47,0x22,0x7c,0x26,0xc4,0x39,0x04,0x61,0x04}}, // 餌
{0x3143,0x8962,0xB1C3,0xE58FA1,0x53E1,{0x08,0x00,0x0f,0x7c,0x08,0x04,0x7f,0xa4,0x40,0xa4,0x3f,0x24,0x05,0x24,0x2c,0xa4,0x4a,0x14,0x1f,0x98,0x31,0x48,0x5f,0x18,0x11,0x14,0x1f,0x24,0x11,0xc2,0x1f,0x01}}, // 叡
{0x3144,0x8963,0xB1C4,0xE596B6,0x55B6,{0x12,0x08,0x09,0x08,0x09,0x10,0x3f,0xfe,0x20,0x04,0x4f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x01,0x00,0x02,0x00,0x1f,0xf8,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x08}}, // 営
{0x3145,0x8964,0xB1C5,0xE5ACB0,0x5B30,{0x00,0x00,0x3e,0x7c,0x22,0x44,0x3e,0x7c,0x22,0x44,0x3e,0x7c,0x22,0x44,0x3e,0x7c,0x13,0x24,0x21,0x42,0x7f,0xff,0x02,0x20,0x04,0x40,0x0f,0xc0,0x03,0x60,0x3c,0x18}}, // 嬰
{0x3146,0x8965,0xB1C6,0xE5BDB1,0x5F71,{0x00,0x04,0x1f,0x84,0x10,0x88,0x1f,0x88,0x10,0x92,0x1f,0xa2,0x04,0x04,0x7f,0xc4,0x00,0x09,0x1f,0x91,0x10,0x82,0x1f,0x82,0x04,0x04,0x24,0x84,0x44,0x48,0x0c,0x10}}, // 影
{0x3147,0x8966,0xB1C7,0xE698A0,0x6620,{0x00,0x20,0x00,0x20,0x78,0x20,0x49,0xfc,0x49,0x24,0x49,0x24,0x79,0x24,0x49,0x24,0x4f,0xff,0x48,0x20,0x48,0x50,0x78,0x50,0x48,0x88,0x01,0x04,0x02,0x02,0x0c,0x01}}, // 映
{0x3148,0x8967,0xB1C8,0xE69BB3,0x66F3,{0x01,0x00,0x01,0x00,0x1f,0xf8,0x11,0x08,0x11,0x08,0x1f,0xf8,0x11,0x08,0x11,0x08,0x1f,0xfc,0x11,0x08,0x01,0x10,0x00,0xe0,0x01,0x82,0x0e,0x42,0x70,0x32,0x00,0x0e}}, // 曳
{0x3149,0x8968,0xB1C9,0xE6A084,0x6804,{0x22,0x08,0x11,0x08,0x08,0x90,0x08,0xa0,0x3f,0xfe,0x20,0x04,0x41,0x00,0x01,0x00,0x7f,0xfe,0x03,0x80,0x05,0x40,0x09,0x20,0x11,0x18,0x61,0x06,0x01,0x00,0x01,0x00}}, // 栄
{0x314A,0x8969,0xB1CA,0xE6B0B8,0x6C38,{0x03,0x00,0x00,0x80,0x00,0x40,0x07,0x80,0x00,0x84,0x00,0x84,0x3e,0xc8,0x02,0xd0,0x02,0xa0,0x04,0xa0,0x04,0x90,0x08,0x88,0x10,0x84,0x60,0x83,0x03,0x80,0x00,0x80}}, // 永
{0x314B,0x896A,0xB1CB,0xE6B3B3,0x6CF3,{0x10,0xc0,0x08,0x20,0x08,0x10,0x00,0x00,0x41,0xe2,0x20,0x22,0x20,0x24,0x07,0xb4,0x00,0xb8,0x00,0xb0,0x11,0x28,0x11,0x28,0x22,0x24,0x24,0x22,0x48,0xe1,0x40,0x20}}, // 泳
{0x314C,0x896B,0xB1CC,0xE6B4A9,0x6D29,{0x10,0x40,0x08,0x40,0x0b,0xfc,0x0a,0x44,0x42,0x44,0x23,0xfc,0x22,0x44,0x22,0x44,0x0b,0xfe,0x08,0x44,0x10,0x48,0x10,0x30,0x20,0x20,0x20,0xd1,0x4f,0x0d,0x40,0x03}}, // 洩
{0x314D,0x896C,0xB1CD,0xE7919B,0x745B,{0x00,0x88,0x00,0x88,0x7f,0xff,0x10,0x88,0x10,0xa8,0x10,0x20,0x11,0xfc,0x7d,0x24,0x11,0x24,0x11,0x24,0x17,0xff,0x10,0x30,0x1c,0x48,0x70,0x84,0x03,0x02,0x0c,0x01}}, // 瑛
{0x314E,0x896D,0xB1CE,0xE79B88,0x76C8,{0x00,0x00,0x3f,0xf8,0x04,0x08,0x04,0x08,0x07,0xee,0x0a,0x22,0x09,0x42,0x10,0x82,0x23,0x5c,0x4c,0x30,0x1f,0xfc,0x12,0x24,0x12,0x24,0x12,0x24,0x7f,0xff,0x00,0x00}}, // 盈
{0x314F,0x896E,0xB1CF,0xE7A98E,0x7A4E,{0x20,0x00,0x22,0xff,0x3c,0x10,0x20,0x20,0x21,0x7e,0x1f,0x42,0x00,0x42,0x03,0x7e,0x3c,0x42,0x04,0x7e,0x7f,0xc2,0x0e,0x42,0x15,0x7e,0x24,0xa4,0x44,0x42,0x05,0x81}}, // 穎
{0x3150,0x896F,0xB1D0,0xE9A0B4,0x9834,{0x20,0x00,0x22,0xff,0x3c,0x10,0x20,0x20,0x21,0x7e,0x1f,0x42,0x00,0x42,0x1e,0x7e,0x00,0x42,0x7f,0xfe,0x04,0x42,0x16,0x42,0x15,0x7e,0x25,0x24,0x44,0x42,0x0d,0x81}}, // 頴
{0x3151,0x8970,0xB1D1,0xE88BB1,0x82F1,{0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x10,0x04,0x90,0x00,0x80,0x1f,0xfc,0x10,0x84,0x10,0x84,0x10,0x84,0x7f,0xff,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x60,0x03}}, // 英
{0x3152,0x8971,0xB1D2,0xE8A19B,0x885B,{0x09,0x00,0x0b,0xee,0x11,0x20,0x11,0x20,0x27,0xf0,0x44,0x00,0x0b,0xff,0x0a,0x24,0x13,0xe4,0x30,0x44,0x57,0xf4,0x11,0x44,0x11,0x44,0x17,0xf4,0x10,0x4c,0x10,0x44}}, // 衛
{0x3153,0x8972,0xB1D3,0xE8A9A0,0x8A60,{0x00,0x40,0x3c,0x20,0x00,0x10,0x7e,0x02,0x00,0xe2,0x3c,0x22,0x00,0x34,0x03,0xf4,0x3c,0x68,0x00,0x68,0x3c,0xa4,0x24,0xa4,0x25,0x22,0x26,0x21,0x3c,0x60,0x24,0x20}}, // 詠
{0x3154,0x8973,0xB1D4,0xE98BAD,0x92ED,{0x08,0x44,0x08,0x24,0x14,0x28,0x12,0x7e,0x21,0x42,0x7e,0x42,0x08,0x42,0x08,0x42,0x7f,0x7e,0x08,0x28,0x4a,0x28,0x2a,0x28,0x2c,0x48,0x0b,0x49,0x1c,0x89,0x61,0x07}}, // 鋭
{0x3155,0x8974,0xB1D5,0xE6B6B2,0x6DB2,{0x10,0x20,0x08,0x20,0x0f,0xff,0x00,0x90,0x40,0x90,0x21,0x1c,0x21,0x24,0x03,0x34,0x0d,0x6c,0x09,0x54,0x11,0x88,0x11,0x18,0x21,0x14,0x21,0x24,0x41,0x42,0x41,0x81}}, // 液
{0x3156,0x8975,0xB1D6,0xE796AB,0x75AB,{0x00,0x40,0x00,0x40,0x0f,0xff,0x48,0x00,0x29,0xf0,0x29,0x12,0x09,0x12,0x09,0x0e,0x1a,0x00,0x2f,0xf8,0x48,0x88,0x10,0x90,0x10,0x60,0x20,0x50,0x41,0x88,0x0e,0x06}}, // 疫
{0x3157,0x8976,0xB1D7,0xE79B8A,0x76CA,{0x08,0x10,0x04,0x10,0x02,0x20,0x02,0x40,0x7f,0xff,0x04,0x10,0x04,0x10,0x08,0x08,0x10,0x04,0x2f,0xfa,0x49,0x48,0x09,0x48,0x09,0x48,0x09,0x48,0x7f,0xfe,0x00,0x00}}, // 益
{0x3158,0x8977,0xB1D8,0xE9A785,0x99C5,{0x00,0x00,0x3f,0xbe,0x24,0x22,0x24,0x22,0x3f,0x22,0x24,0x22,0x3f,0x3e,0x24,0x32,0x24,0x28,0x3f,0xa8,0x14,0xa8,0x2a,0xa8,0x2a,0xa4,0x28,0xc4,0x41,0x42,0x06,0x81}}, // 駅
{0x3159,0x8978,0xB1D9,0xE682A6,0x60A6,{0x08,0x84,0x08,0x44,0x08,0x48,0x08,0xfc,0x2c,0x84,0x2a,0x84,0x2a,0x84,0x28,0x84,0x48,0xfc,0x08,0x50,0x08,0x50,0x08,0x50,0x08,0x90,0x08,0x92,0x09,0x12,0x0a,0x0e}}, // 悦
{0x315A,0x8979,0xB1DA,0xE8AC81,0x8B01,{0x00,0x00,0x3c,0xfc,0x00,0x84,0x7f,0xfc,0x00,0x84,0x3e,0x84,0x00,0xfc,0x00,0x40,0x3e,0x7e,0x00,0xca,0x3e,0xd2,0x23,0x62,0x22,0x4a,0x22,0x3a,0x3e,0x02,0x22,0x0c}}, // 謁
{0x315B,0x897A,0xB1DB,0xE8B68A,0x8D8A,{0x04,0x14,0x04,0x12,0x04,0x10,0x1f,0x7f,0x04,0x50,0x04,0x52,0x3f,0xd2,0x04,0x52,0x14,0x54,0x17,0x4c,0x14,0x69,0x15,0x95,0x1c,0x23,0x24,0xc1,0x23,0x00,0x40,0xff}}, // 越
{0x315C,0x897B,0xB1DC,0xE996B2,0x95B2,{0x00,0x00,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x44,0x42,0x42,0x82,0x4f,0xe2,0x48,0x22,0x48,0x22,0x4f,0xe2,0x42,0x82,0x42,0x92,0x44,0x72,0x48,0x06}}, // 閲
{0x315D,0x897C,0xB1DD,0xE6A68E,0x698E,{0x08,0x00,0x0b,0xff,0x08,0x20,0x7e,0xfc,0x08,0x84,0x08,0xfc,0x1c,0x84,0x1a,0xfc,0x1a,0x84,0x29,0xfc,0x28,0x20,0x48,0x7c,0x09,0xc8,0x08,0x30,0x08,0xcc,0x0b,0x03}}, // 榎
{0x315E,0x897D,0xB1DE,0xE58EAD,0x53AD,{0x00,0x00,0x3f,0xff,0x20,0x00,0x2f,0x8a,0x28,0x89,0x2f,0x88,0x28,0xff,0x2f,0x88,0x20,0x08,0x2f,0x8c,0x28,0x94,0x2f,0x94,0x28,0x94,0x2f,0xa2,0x48,0xc2,0x49,0x81}}, // 厭
{0x315F,0x897E,0xB1DF,0xE58686,0x5186,{0x00,0x00,0x3f,0xfc,0x21,0x04,0x21,0x04,0x21,0x04,0x21,0x04,0x21,0x04,0x3f,0xfc,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x0c,0x20,0x04}}, // 円
{0x3160,0x8980,0xB1E0,0xE59C92,0x5712,{0x00,0x00,0x3f,0xfe,0x20,0x82,0x27,0xf2,0x20,0x82,0x3f,0xfe,0x20,0x02,0x27,0xf2,0x24,0x12,0x27,0xf2,0x23,0x4a,0x25,0x32,0x39,0x1e,0x21,0x02,0x3f,0xfe,0x20,0x02}}, // 園
{0x3161,0x8981,0xB1E1,0xE5A0B0,0x5830,{0x10,0x00,0x13,0xff,0x12,0x00,0x12,0xfc,0x12,0x84,0x7e,0xfc,0x12,0x84,0x12,0xfc,0x12,0x20,0x13,0xff,0x16,0x48,0x1a,0xd0,0x62,0x38,0x02,0xc4,0x03,0xff,0x02,0x00}}, // 堰
{0x3162,0x8982,0xB1E2,0xE5A584,0x5944,{0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0x40,0x02,0x20,0x04,0x90,0x1f,0xfc,0x68,0x93,0x08,0x90,0x0f,0xf0,0x08,0x90,0x08,0x90,0x0f,0xf0,0x08,0x92,0x00,0x82,0x00,0x7e}}, // 奄
{0x3163,0x8983,0xB1E3,0xE5AEB4,0x5BB4,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x2f,0xf0,0x48,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x01,0x00,0x7f,0xfe,0x02,0x20,0x04,0x20,0x0f,0xc0,0x03,0x30,0x3c,0x08}}, // 宴
{0x3164,0x8984,0xB1E4,0xE5BBB6,0x5EF6,{0x00,0x04,0x7c,0x18,0x05,0xf0,0x08,0x10,0x08,0x10,0x10,0x90,0x3c,0x9e,0x04,0x90,0x24,0x90,0x14,0x90,0x14,0x90,0x08,0x90,0x0f,0xff,0x12,0x00,0x21,0x80,0x40,0x7f}}, // 延
{0x3165,0x8985,0xB1E5,0xE680A8,0x6028,{0x08,0x00,0x0f,0x7e,0x09,0x42,0x11,0x42,0x32,0x4c,0x4a,0x40,0x04,0x41,0x08,0x21,0x10,0x1f,0x61,0x00,0x04,0x80,0x14,0x44,0x14,0x42,0x24,0x09,0x42,0x09,0x01,0xf8}}, // 怨
{0x3166,0x8986,0xB1E6,0xE68EA9,0x63A9,{0x10,0x20,0x10,0x20,0x17,0xff,0x10,0x50,0x7c,0xa8,0x11,0x24,0x13,0xfe,0x15,0x25,0x11,0x24,0x1d,0xfc,0x71,0x24,0x11,0x24,0x11,0xfc,0x10,0x21,0x10,0x21,0x30,0x1f}}, // 掩
{0x3167,0x8987,0xB1E7,0xE68FB4,0x63F4,{0x10,0x0c,0x13,0xf0,0x11,0x44,0x7c,0xa4,0x10,0xa8,0x13,0xfe,0x10,0x40,0x13,0xff,0x1c,0x40,0x70,0xfc,0x11,0x84,0x16,0xc8,0x10,0x30,0x10,0x50,0x11,0x8c,0x36,0x03}}, // 援
{0x3168,0x8988,0xB1E8,0xE6B2BF,0x6CBF,{0x10,0x78,0x08,0x08,0x08,0x88,0x00,0x88,0x40,0x84,0x21,0x04,0x21,0x02,0x22,0x01,0x0d,0xfc,0x09,0x04,0x11,0x04,0x11,0x04,0x21,0x04,0x21,0x04,0x41,0xfc,0x41,0x04}}, // 沿
{0x3169,0x8989,0xB1E9,0xE6BC94,0x6F14,{0x10,0x20,0x08,0x20,0x0b,0xff,0x02,0x02,0x47,0xfe,0x20,0x20,0x23,0xfe,0x02,0x22,0x02,0x22,0x13,0xfe,0x12,0x22,0x22,0x22,0x23,0xfe,0x20,0x8c,0x41,0x02,0x46,0x01}}, // 演
{0x316A,0x898A,0xB1EA,0xE7828E,0x708E,{0x01,0x00,0x09,0x10,0x09,0x10,0x11,0x20,0x22,0x80,0x04,0x40,0x18,0x30,0x61,0x0c,0x01,0x10,0x09,0x10,0x09,0x20,0x12,0x80,0x22,0x40,0x04,0x20,0x18,0x18,0x60,0x06}}, // 炎
{0x316B,0x898B,0xB1EB,0xE78494,0x7114,{0x08,0x20,0x08,0x20,0x08,0x3c,0x0a,0x44,0x2a,0x48,0x2a,0x88,0x2c,0x10,0x29,0x3e,0x49,0x22,0x0d,0x22,0x15,0x22,0x13,0x3e,0x13,0x22,0x21,0x22,0x21,0x3e,0x41,0x22}}, // 焔
{0x316C,0x898C,0xB1EC,0xE78599,0x7159,{0x08,0x00,0x0b,0xfe,0x08,0x50,0x0a,0x50,0x2b,0xfc,0x2b,0x54,0x2d,0x54,0x29,0x54,0x49,0xfc,0x08,0x20,0x0c,0x20,0x14,0xfc,0x12,0x20,0x12,0x20,0x23,0xff,0x40,0x00}}, // 煙
{0x316D,0x898D,0xB1ED,0xE78795,0x71D5,{0x02,0x20,0x02,0x20,0x7f,0xff,0x02,0x20,0x0b,0xe8,0x08,0x0a,0x7b,0xea,0x0a,0x2c,0x0a,0x28,0x1a,0x29,0x6b,0xe9,0x0a,0x27,0x00,0x00,0x12,0x24,0x21,0x12,0x41,0x11}}, // 燕
{0x316E,0x898E,0xB1EE,0xE78CBF,0x733F,{0x08,0x20,0x48,0x20,0x29,0xfc,0x10,0x20,0x17,0xff,0x28,0x00,0x49,0xfc,0x09,0x04,0x19,0x04,0x19,0xfc,0x28,0xa2,0x49,0x92,0x0e,0x94,0x08,0x88,0x68,0xe4,0x13,0x03}}, // 猿
{0x316F,0x898F,0xB1EF,0xE7B881,0x7E01,{0x08,0x00,0x08,0xf8,0x0a,0x08,0x72,0xf8,0x14,0x08,0x09,0xff,0x0a,0x20,0x12,0x52,0x7f,0x94,0x09,0x38,0x2c,0x58,0x2a,0xb4,0x2a,0x52,0x2b,0x91,0x48,0x10,0x08,0x60}}, // 縁
{0x3170,0x8990,0xB1F0,0xE889B6,0x8276,{0x0a,0x10,0x3f,0x9e,0x2a,0xa4,0x3f,0xa4,0x2a,0xc8,0x3f,0xfe,0x00,0x4a,0x7f,0xca,0x00,0x4a,0x3f,0x7e,0x21,0x42,0x3f,0x40,0x12,0x40,0x0c,0x41,0x7f,0xa1,0x00,0x1f}}, // 艶
{0x3171,0x8991,0xB1F1,0xE88B91,0x82D1,{0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x02,0x10,0x08,0x00,0x0f,0xbe,0x08,0xa2,0x10,0xa2,0x19,0x22,0x25,0x22,0x42,0x2c,0x02,0x20,0x04,0x21,0x08,0x11,0x30,0x0f}}, // 苑
{0x3172,0x8992,0xB1F2,0xE89697,0x8597,{0x04,0x10,0x7f,0xff,0x04,0x10,0x3f,0xfe,0x20,0x82,0x27,0xf2,0x20,0x82,0x3f,0xfe,0x24,0x22,0x27,0xe2,0x23,0x92,0x25,0x62,0x39,0x32,0x21,0x0e,0x3f,0xfe,0x20,0x02}}, // 薗
{0x3173,0x8993,0xB1F3,0xE981A0,0x9060,{0x00,0x40,0x20,0x40,0x13,0xfc,0x10,0x40,0x07,0xfe,0x00,0x00,0x03,0xfc,0x7a,0x04,0x0b,0xfc,0x08,0xc4,0x09,0x68,0x0a,0x50,0x0c,0x4c,0x14,0x43,0x23,0x00,0x40,0xff}}, // 遠
{0x3174,0x8994,0xB1F4,0xE9899B,0x925B,{0x08,0x3c,0x08,0x04,0x14,0x24,0x12,0x24,0x22,0x44,0x7f,0x42,0x08,0x82,0x09,0x01,0x7e,0x7c,0x08,0x44,0x4a,0x44,0x2c,0x44,0x29,0x44,0x0e,0x44,0x18,0x7c,0x60,0x44}}, // 鉛
{0x3175,0x8995,0xB1F5,0xE9B49B,0x9D1B,{0x08,0x00,0x0f,0xfc,0x31,0x44,0x0a,0x58,0x0d,0x42,0x72,0x3e,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xff,0x08,0x00,0x0f,0xfe,0x29,0x22,0x24,0x92,0x40,0x0c}}, // 鴛
{0x3176,0x8996,0xB1F6,0xE5A1A9,0x5869,{0x01,0x00,0x11,0x00,0x11,0xfe,0x12,0x00,0x13,0xf8,0x7d,0x08,0x15,0x08,0x11,0xf8,0x10,0x00,0x13,0xfc,0x16,0x94,0x1a,0x94,0x62,0x94,0x02,0x94,0x0f,0xff,0x00,0x00}}, // 塩
{0x3177,0x8997,0xB1F7,0xE696BC,0x65BC,{0x10,0x10,0x10,0x10,0x10,0x10,0x7f,0x28,0x10,0x28,0x10,0x44,0x1e,0x64,0x12,0xa2,0x13,0x11,0x12,0x10,0x12,0x40,0x12,0x20,0x22,0x10,0x22,0x10,0x42,0x08,0x0c,0x08}}, // 於
{0x3178,0x8998,0xB1F8,0xE6B19A,0x6C5A,{0x10,0x00,0x0b,0xfc,0x08,0x40,0x00,0x40,0x00,0x40,0x4f,0xff,0x20,0x80,0x20,0x80,0x08,0x80,0x09,0xfc,0x11,0x04,0x10,0x04,0x20,0x04,0x20,0x04,0x40,0x08,0x40,0x30}}, // 汚
{0x3179,0x8999,0xB1F9,0xE794A5,0x7525,{0x08,0x00,0x09,0xfc,0x29,0x24,0x29,0x24,0x3f,0xfc,0x29,0x24,0x49,0x24,0x09,0xfc,0x3e,0x20,0x0b,0xfe,0x08,0x22,0x08,0x42,0x0e,0x42,0x70,0x82,0x01,0x02,0x06,0x0c}}, // 甥
{0x317A,0x899A,0xB1FA,0xE587B9,0x51F9,{0x00,0x00,0x3e,0x3e,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x23,0xe2,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x3f,0xfe,0x20,0x02,0x00,0x00}}, // 凹
{0x317B,0x899B,0xB1FB,0xE5A4AE,0x592E,{0x00,0x80,0x00,0x80,0x00,0x80,0x1f,0xfc,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x7f,0xff,0x00,0x80,0x01,0x40,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x60,0x03}}, // 央
{0x317C,0x899C,0xB1FC,0xE5A5A5,0x5965,{0x01,0x00,0x02,0x00,0x1f,0xfc,0x10,0x84,0x14,0x94,0x12,0xa4,0x1f,0xfc,0x11,0xc4,0x12,0xa4,0x14,0x9c,0x18,0x84,0x11,0x04,0x7f,0xff,0x01,0x40,0x06,0x30,0x78,0x0e}}, // 奥
{0x317D,0x899D,0xB1FD,0xE5BE80,0x5F80,{0x08,0x40,0x08,0x20,0x10,0x20,0x13,0xfe,0x24,0x20,0x44,0x20,0x08,0x20,0x08,0x20,0x11,0xfc,0x30,0x20,0x50,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x13,0xff,0x10,0x00}}, // 往
{0x317E,0x899E,0xB1FE,0xE5BF9C,0x5FDC,{0x00,0x40,0x00,0x40,0x1f,0xff,0x10,0x80,0x10,0x40,0x10,0x20,0x10,0x90,0x10,0x90,0x14,0x84,0x14,0x82,0x14,0x81,0x24,0x81,0x28,0x81,0x28,0x84,0x50,0x44,0x00,0x3c}}, // 応
{0x3221,0x899F,0xB2A1,0xE68ABC,0x62BC,{0x10,0x00,0x11,0xfe,0x11,0x22,0x11,0x22,0x7d,0x22,0x11,0xfe,0x11,0x22,0x11,0x22,0x11,0x22,0x1d,0xfe,0x70,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x30,0x20,0x10,0x20}}, // 押
{0x3222,0x89A0,0xB2A2,0xE697BA,0x65FA,{0x00,0x00,0x7d,0xfe,0x44,0x20,0x44,0x20,0x44,0x20,0x44,0x20,0x7c,0x20,0x45,0xfe,0x44,0x20,0x44,0x20,0x44,0x20,0x44,0x20,0x7c,0x20,0x44,0x20,0x07,0xff,0x00,0x00}}, // 旺
{0x3223,0x89A1,0xB2A3,0xE6A8AA,0x6A2A,{0x08,0x88,0x08,0x88,0x0b,0xfe,0x7e,0x88,0x08,0x88,0x0b,0xff,0x1c,0x20,0x1b,0xfc,0x19,0x24,0x29,0xfc,0x29,0x24,0x49,0x24,0x09,0xfc,0x08,0x90,0x09,0x0c,0x0e,0x02}}, // 横
{0x3224,0x89A2,0xB2A4,0xE6ACA7,0x6B27,{0x00,0x20,0x3f,0xa0,0x21,0x20,0x21,0x3f,0x31,0x51,0x2a,0x52,0x26,0x94,0x22,0x10,0x26,0x10,0x25,0x30,0x29,0x28,0x29,0x28,0x30,0x44,0x3f,0xc4,0x20,0x82,0x21,0x01}}, // 欧
{0x3225,0x89A3,0xB2A5,0xE6AEB4,0x6BB4,{0x00,0x00,0x3f,0xbc,0x21,0x24,0x21,0x24,0x32,0x25,0x2a,0x45,0x26,0x83,0x22,0xfc,0x26,0x44,0x25,0x44,0x29,0x28,0x29,0x28,0x30,0x10,0x3f,0xa8,0x20,0xc4,0x23,0x03}}, // 殴
{0x3226,0x89A4,0xB2A6,0xE78E8B,0x738B,{0x00,0x00,0x3f,0xfe,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 王
{0x3227,0x89A5,0xB2A7,0xE7BF81,0x7FC1,{0x05,0xf0,0x04,0x10,0x08,0x88,0x10,0x84,0x61,0x63,0x02,0x18,0x3f,0xe4,0x00,0x00,0x3f,0xfc,0x11,0x24,0x09,0x14,0x03,0x0c,0x0d,0x34,0x31,0xc4,0x01,0x04,0x03,0x0c}}, // 翁
{0x3228,0x89A6,0xB2A8,0xE8A596,0x8956,{0x10,0x20,0x10,0x40,0x11,0xfc,0x7d,0x24,0x05,0xac,0x09,0x74,0x09,0xfc,0x15,0x24,0x15,0x74,0x39,0xac,0x55,0x24,0x13,0xff,0x10,0x20,0x10,0x50,0x11,0x88,0x16,0x06}}, // 襖
{0x3229,0x89A7,0xB2A9,0xE9B4AC,0x9D2C,{0x11,0x08,0x08,0x90,0x3f,0xfe,0x22,0x04,0x4f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x00,0x0f,0xfe,0x08,0x00,0x0f,0xfc,0x29,0x24,0x24,0x94,0x40,0x18}}, // 鴬
{0x322A,0x89A8,0xB2AA,0xE9B48E,0x9D0E,{0x00,0x20,0x7f,0x40,0x42,0xfc,0x42,0x84,0x62,0xfc,0x54,0x84,0x4c,0xfc,0x44,0x80,0x4c,0xff,0x4a,0x80,0x52,0xfe,0x52,0x2a,0x61,0x96,0x7f,0x52,0x41,0x42,0x42,0x0c}}, // 鴎
{0x322B,0x89A9,0xB2AB,0xE9BB84,0x9EC4,{0x02,0x20,0x02,0x20,0x1f,0xfc,0x02,0x20,0x02,0x20,0x7f,0xff,0x00,0x80,0x0f,0xf8,0x08,0x88,0x08,0x88,0x0f,0xf8,0x08,0x88,0x08,0x88,0x0f,0xf8,0x04,0x18,0x38,0x06}}, // 黄
{0x322C,0x89AA,0xB2AC,0xE5B2A1,0x5CA1,{0x00,0x00,0x3f,0xfe,0x20,0x22,0x24,0x22,0x22,0x22,0x22,0x42,0x3f,0xfe,0x20,0x82,0x24,0x92,0x24,0x92,0x24,0x92,0x24,0x92,0x27,0xf2,0x24,0x12,0x20,0x02,0x20,0x06}}, // 岡
{0x322D,0x89AB,0xB2AD,0xE6B296,0x6C96,{0x10,0x20,0x08,0x20,0x08,0x20,0x03,0xfe,0x42,0x22,0x22,0x22,0x22,0x22,0x02,0x22,0x0b,0xfe,0x0a,0x22,0x10,0x20,0x10,0x20,0x20,0x20,0x20,0x20,0x40,0x20,0x40,0x20}}, // 沖
{0x322E,0x89AC,0xB2AE,0xE88DBB,0x837B,{0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x04,0x00,0x24,0x10,0x18,0x12,0x08,0x92,0x14,0x94,0x24,0x90,0x0d,0x10,0x14,0x28,0x24,0x28,0x04,0x44,0x05,0x82,0x1e,0x01}}, // 荻
{0x322F,0x89AD,0xB2AF,0xE58484,0x5104,{0x04,0x20,0x04,0x20,0x07,0xfe,0x09,0x04,0x08,0x88,0x17,0xff,0x10,0x00,0x31,0xfc,0x51,0x04,0x11,0xfc,0x11,0x04,0x11,0xfc,0x12,0xa2,0x12,0x91,0x14,0x85,0x10,0x7c}}, // 億
{0x3230,0x89AE,0xB2B0,0xE5B18B,0x5C4B,{0x00,0x00,0x1f,0xfc,0x10,0x04,0x10,0x04,0x1f,0xfc,0x10,0x00,0x1f,0xfe,0x10,0xb0,0x13,0x0c,0x1f,0xfa,0x10,0x40,0x17,0xfc,0x20,0x40,0x20,0x40,0x5f,0xff,0x00,0x00}}, // 屋
{0x3231,0x89AF,0xB2B1,0xE686B6,0x61B6,{0x10,0x40,0x10,0x40,0x17,0xfc,0x11,0x08,0x30,0x90,0x37,0xff,0x38,0x00,0x55,0xfc,0x51,0x04,0x11,0xfc,0x11,0x04,0x11,0xfc,0x12,0xa0,0x12,0x92,0x14,0x89,0x10,0x78}}, // 憶
{0x3232,0x89B0,0xB2B2,0xE88786,0x81C6,{0x00,0x20,0x3c,0x20,0x27,0xfe,0x24,0x84,0x24,0x48,0x3f,0xff,0x24,0x00,0x24,0xfc,0x24,0x84,0x3c,0xfc,0x24,0x84,0x24,0xfc,0x25,0x20,0x25,0x56,0x2e,0x45,0x44,0x3c}}, // 臆
{0x3233,0x89B1,0xB2B3,0xE6A1B6,0x6876,{0x08,0x00,0x09,0xfc,0x08,0x08,0x7e,0x50,0x08,0x20,0x09,0xfe,0x1d,0x22,0x1b,0x22,0x29,0xfe,0x29,0x22,0x49,0x22,0x09,0xfe,0x09,0x22,0x09,0x22,0x09,0x22,0x09,0x06}}, // 桶
{0x3234,0x89B2,0xB2B4,0xE789A1,0x7261,{0x04,0x10,0x14,0x10,0x14,0x10,0x14,0x10,0x1f,0x10,0x14,0xfe,0x24,0x10,0x44,0x10,0x04,0x10,0x07,0x10,0x3c,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x05,0xff,0x04,0x00}}, // 牡
{0x3235,0x89B3,0xB2B5,0xE4B999,0x4E59,{0x00,0x00,0x1f,0xf8,0x00,0x10,0x00,0x60,0x00,0x80,0x01,0x00,0x02,0x00,0x04,0x00,0x08,0x00,0x10,0x00,0x10,0x00,0x20,0x04,0x20,0x04,0x20,0x04,0x1f,0xfc,0x00,0x00}}, // 乙
{0x3236,0x89B4,0xB2B6,0xE4BFBA,0x4FFA,{0x04,0x40,0x04,0x40,0x07,0xff,0x08,0xa0,0x08,0xd0,0x11,0x48,0x13,0xfc,0x36,0x4a,0x5a,0x49,0x13,0xf8,0x12,0x48,0x12,0x48,0x13,0xf8,0x12,0x4a,0x10,0x42,0x10,0x3e}}, // 俺
{0x3237,0x89B5,0xB2B7,0xE58DB8,0x5378,{0x10,0x00,0x10,0x3e,0x1f,0xa2,0x14,0x22,0x24,0x22,0x44,0x22,0x7f,0xe2,0x04,0x22,0x24,0x22,0x27,0xa2,0x24,0x22,0x24,0x22,0x27,0xbc,0x3c,0x20,0x60,0x20,0x00,0x20}}, // 卸
{0x3238,0x89B6,0xB2B8,0xE681A9,0x6069,{0x00,0x00,0x1f,0xfc,0x10,0x84,0x10,0x84,0x1f,0xfc,0x11,0x44,0x12,0x34,0x1c,0x0c,0x1f,0xfc,0x00,0x80,0x12,0x40,0x12,0x24,0x12,0x22,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 恩
{0x3239,0x89B7,0xB2B9,0xE6B8A9,0x6E29,{0x10,0x00,0x09,0xfc,0x09,0x04,0x01,0xfc,0x41,0x04,0x21,0x04,0x21,0xfc,0x00,0x00,0x08,0x00,0x0b,0xfe,0x12,0x52,0x12,0x52,0x22,0x52,0x22,0x52,0x4f,0xff,0x40,0x00}}, // 温
{0x323A,0x89B8,0xB2BA,0xE7A98F,0x7A4F,{0x04,0x04,0x08,0x38,0x7b,0xc2,0x09,0x22,0x08,0xa4,0x09,0xfc,0x7e,0x04,0x08,0xfc,0x1c,0x04,0x1a,0xfc,0x1a,0x20,0x29,0x54,0x29,0x52,0x49,0x55,0x0a,0x45,0x08,0x3c}}, // 穏
{0x323B,0x89B9,0xB2BB,0xE99FB3,0x97F3,{0x00,0x80,0x00,0x80,0x3f,0xfe,0x04,0x10,0x02,0x10,0x02,0x20,0x7f,0xff,0x00,0x00,0x07,0xf0,0x04,0x10,0x04,0x10,0x07,0xf0,0x04,0x10,0x04,0x10,0x07,0xf0,0x04,0x10}}, // 音
{0x323C,0x89BA,0xB2BC,0xE4B88B,0x4E0B,{0x00,0x00,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0xc0,0x00,0xa0,0x00,0x90,0x00,0x88,0x00,0x88,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 下
{0x323D,0x89BB,0xB2BD,0xE58C96,0x5316,{0x02,0x40,0x02,0x40,0x02,0x42,0x04,0x42,0x04,0x44,0x08,0x44,0x08,0x48,0x18,0x50,0x28,0x60,0x48,0x40,0x08,0x40,0x08,0x40,0x08,0x41,0x08,0x41,0x08,0x21,0x08,0x1f}}, // 化
{0x323E,0x89BC,0xB2BE,0xE4BBAE,0x4EEE,{0x04,0x00,0x05,0xff,0x05,0x00,0x09,0x00,0x09,0x00,0x11,0xfc,0x11,0x84,0x31,0x44,0x51,0x48,0x11,0x28,0x12,0x30,0x12,0x10,0x14,0x28,0x14,0x44,0x19,0x82,0x16,0x01}}, // 仮
{0x323F,0x89BD,0xB2BF,0xE4BD95,0x4F55,{0x04,0x00,0x04,0x00,0x07,0xff,0x08,0x04,0x08,0x04,0x13,0xe4,0x12,0x24,0x32,0x24,0x52,0x24,0x12,0x24,0x13,0xe4,0x12,0x24,0x10,0x04,0x10,0x04,0x10,0x1c,0x10,0x04}}, // 何
{0x3240,0x89BE,0xB2C0,0xE4BCBD,0x4F3D,{0x0a,0x00,0x0a,0x00,0x0a,0x1e,0x12,0x12,0x1f,0xd2,0x12,0x52,0x32,0x52,0x32,0x52,0x52,0x52,0x12,0x52,0x12,0x52,0x12,0x52,0x14,0x5e,0x14,0x52,0x19,0x80,0x10,0x00}}, // 伽
{0x3241,0x89BF,0xB2C1,0xE4BEA1,0x4FA1,{0x04,0x00,0x04,0x00,0x07,0xff,0x08,0x50,0x08,0x50,0x10,0x50,0x13,0xfe,0x32,0x52,0x52,0x52,0x12,0x52,0x12,0x52,0x12,0x52,0x12,0x52,0x13,0xfe,0x12,0x02,0x10,0x00}}, // 価
{0x3242,0x89C0,0xB2C2,0xE4BDB3,0x4F73,{0x04,0x20,0x04,0x20,0x05,0xfc,0x08,0x20,0x08,0x20,0x18,0x20,0x2b,0xfe,0x28,0x20,0x48,0x20,0x08,0x20,0x09,0xfc,0x08,0x20,0x08,0x20,0x08,0x20,0x0b,0xfe,0x08,0x00}}, // 佳
{0x3243,0x89C1,0xB2C3,0xE58AA0,0x52A0,{0x08,0x00,0x08,0x00,0x08,0x3e,0x08,0x22,0x7f,0xa2,0x08,0xa2,0x08,0xa2,0x08,0xa2,0x08,0xa2,0x08,0xa2,0x08,0xa2,0x08,0xa2,0x10,0xa2,0x10,0xbe,0x20,0xa2,0x43,0x00}}, // 加
{0x3244,0x89C2,0xB2C4,0xE58FAF,0x53EF,{0x00,0x00,0x00,0x00,0x7f,0xff,0x00,0x08,0x00,0x08,0x0f,0xc8,0x08,0x48,0x08,0x48,0x08,0x48,0x08,0x48,0x0f,0xc8,0x08,0x48,0x00,0x08,0x00,0x08,0x00,0x38,0x00,0x08}}, // 可
{0x3245,0x89C3,0xB2C5,0xE59889,0x5609,{0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x1f,0xfc,0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x02,0x20,0x7f,0xff,0x08,0x00,0x3f,0x7c,0x09,0x44,0x11,0x7c,0x66,0x44}}, // 嘉
{0x3246,0x89C4,0xB2C6,0xE5A48F,0x590F,{0x00,0x00,0x3f,0xfe,0x00,0x80,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x02,0x00,0x07,0xf8,0x0a,0x20,0x31,0xc0,0x06,0x70,0x78,0x0e}}, // 夏
{0x3247,0x89C5,0xB2C7,0xE5AB81,0x5AC1,{0x08,0x20,0x08,0x20,0x09,0xfe,0x09,0x04,0x7e,0x00,0x13,0xfc,0x12,0x40,0x12,0xa2,0x25,0x2a,0x24,0x5c,0x78,0x94,0x0d,0x34,0x14,0x52,0x20,0x91,0x43,0x10,0x00,0x60}}, // 嫁
{0x3248,0x89C6,0xB2C8,0xE5AEB6,0x5BB6,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x40,0x00,0x1f,0xf0,0x02,0x04,0x0d,0x44,0x31,0xc8,0x02,0xb0,0x0c,0xa0,0x31,0x90,0x02,0x88,0x0c,0x84,0x70,0x82,0x03,0x00}}, // 家
{0x3249,0x89C7,0xB2C9,0xE5AFA1,0x5BE1,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x5f,0xf8,0x01,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x7f,0xfe,0x04,0x10,0x1f,0xfc,0x61,0x13,0x06,0x10,0x18,0x60}}, // 寡
{0x324A,0x89C8,0xB2CA,0xE7A791,0x79D1,{0x01,0x04,0x06,0x44,0x3c,0x24,0x04,0x14,0x04,0x14,0x04,0x84,0x7f,0x44,0x04,0x24,0x0e,0x24,0x0d,0x07,0x14,0xbc,0x15,0xc4,0x24,0x04,0x44,0x04,0x04,0x04,0x04,0x04}}, // 科
{0x324B,0x89C9,0xB2CB,0xE69A87,0x6687,{0x00,0x00,0x03,0xde,0x7a,0x42,0x4a,0x42,0x4a,0x42,0x4b,0xde,0x4a,0x00,0x7a,0x3e,0x4b,0xe2,0x4a,0x14,0x4a,0x14,0x4a,0x08,0x7b,0xc8,0x4a,0x14,0x02,0x22,0x02,0x41}}, // 暇
{0x324C,0x89CA,0xB2CC,0xE69E9C,0x679C,{0x00,0x00,0x1f,0xf8,0x11,0x08,0x11,0x08,0x1f,0xf8,0x11,0x08,0x11,0x08,0x1f,0xf8,0x01,0x00,0x7f,0xfe,0x03,0x80,0x05,0x40,0x09,0x20,0x11,0x18,0x61,0x06,0x01,0x00}}, // 果
{0x324D,0x89CB,0xB2CD,0xE69EB6,0x67B6,{0x08,0x00,0x08,0x7c,0x7f,0x44,0x09,0x44,0x09,0x44,0x11,0x44,0x11,0x7c,0x26,0x44,0x41,0x00,0x01,0x00,0x7f,0xfe,0x03,0x40,0x05,0x20,0x19,0x18,0x61,0x06,0x01,0x00}}, // 架
{0x324E,0x89CC,0xB2CE,0xE6AD8C,0x6B4C,{0x00,0x40,0x7f,0xc0,0x02,0x40,0x3a,0x7f,0x2a,0x52,0x3a,0x54,0x2a,0x90,0x06,0x90,0x7f,0x10,0x02,0x10,0x3a,0x28,0x2a,0x28,0x3a,0x44,0x2a,0x44,0x02,0x82,0x07,0x01}}, // 歌
{0x324F,0x89CD,0xB2CF,0xE6B2B3,0x6CB3,{0x10,0x00,0x0b,0xff,0x08,0x04,0x00,0x04,0x43,0xe4,0x22,0x24,0x22,0x24,0x02,0x24,0x0a,0x24,0x0b,0xe4,0x12,0x24,0x10,0x04,0x20,0x04,0x20,0x04,0x40,0x1c,0x40,0x04}}, // 河
{0x3250,0x89CE,0xB2D0,0xE781AB,0x706B,{0x00,0x80,0x00,0x80,0x00,0x84,0x00,0x84,0x08,0x84,0x08,0x88,0x08,0x88,0x08,0x90,0x10,0x80,0x21,0x40,0x01,0x40,0x02,0x20,0x02,0x10,0x04,0x08,0x18,0x04,0x60,0x03}}, // 火
{0x3251,0x89CF,0xB2D1,0xE78F82,0x73C2,{0x00,0x00,0x7f,0xff,0x10,0x04,0x10,0x04,0x11,0xe4,0x11,0x24,0x7d,0x24,0x11,0x24,0x11,0x24,0x11,0x24,0x11,0xe4,0x11,0x24,0x1c,0x04,0x70,0x04,0x00,0x0c,0x00,0x04}}, // 珂
{0x3252,0x89D0,0xB2D2,0xE7A68D,0x798D,{0x08,0x00,0x08,0xfc,0x08,0x84,0x7e,0xbc,0x02,0xa4,0x04,0xa4,0x04,0xa4,0x09,0xfe,0x1d,0x02,0x2b,0x7a,0x49,0x4a,0x09,0x4a,0x09,0x7a,0x09,0x4a,0x09,0x06,0x09,0x02}}, // 禍
{0x3253,0x89D1,0xB2D3,0xE7A6BE,0x79BE,{0x00,0x08,0x00,0x70,0x1f,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x01,0xc0,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80,0x00,0x80,0x00,0x80}}, // 禾
{0x3254,0x89D2,0xB2D4,0xE7A8BC,0x7A3C,{0x02,0x20,0x0c,0x20,0x79,0xfe,0x09,0x04,0x0a,0x00,0x7f,0xfe,0x08,0x44,0x08,0x64,0x1d,0xa8,0x1a,0x58,0x28,0x94,0x2b,0x34,0x48,0x52,0x09,0x91,0x08,0x10,0x08,0x60}}, // 稼
{0x3255,0x89D3,0xB2D5,0xE7AE87,0x7B87,{0x10,0x20,0x10,0x20,0x3f,0xbf,0x24,0x50,0x42,0x88,0x3f,0xfc,0x21,0x04,0x21,0x04,0x3f,0xfc,0x21,0x04,0x27,0xe4,0x24,0x24,0x27,0xe4,0x20,0x04,0x3f,0xfc,0x20,0x04}}, // 箇
{0x3256,0x89D4,0xB2D6,0xE88AB1,0x82B1,{0x04,0x20,0x04,0x20,0x7f,0xfe,0x04,0x20,0x06,0x20,0x02,0x40,0x04,0x44,0x04,0x44,0x08,0x48,0x18,0x50,0x28,0x60,0x48,0x40,0x08,0x40,0x08,0x41,0x08,0x41,0x08,0x3f}}, // 花
{0x3257,0x89D5,0xB2D7,0xE88B9B,0x82DB,{0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x02,0x10,0x00,0x00,0x7f,0xfe,0x00,0x08,0x0f,0xc8,0x08,0x48,0x08,0x48,0x08,0x48,0x0f,0xc8,0x08,0x48,0x00,0x18,0x00,0x08}}, // 苛
{0x3258,0x89D6,0xB2D8,0xE88C84,0x8304,{0x04,0x20,0x04,0x20,0x7f,0xfe,0x04,0x20,0x04,0x20,0x08,0x00,0x08,0x7c,0x7f,0x44,0x09,0x44,0x09,0x44,0x09,0x44,0x09,0x44,0x11,0x44,0x11,0x7c,0x21,0x44,0x46,0x00}}, // 茄
{0x3259,0x89D7,0xB2D9,0xE88DB7,0x8377,{0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x02,0x10,0x04,0x00,0x07,0xff,0x08,0x04,0x09,0xe4,0x19,0x24,0x29,0x24,0x49,0x24,0x09,0xe4,0x08,0x04,0x08,0x04,0x08,0x0c}}, // 荷
{0x325A,0x89D8,0xB2DA,0xE88FAF,0x83EF,{0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x10,0x1f,0xfc,0x08,0x88,0x08,0x88,0x7f,0xff,0x08,0x88,0x08,0x88,0x1f,0xfc,0x00,0x80,0x00,0x80,0x3f,0xfe,0x00,0x80,0x00,0x80}}, // 華
{0x325B,0x89D9,0xB2DB,0xE88F93,0x83D3,{0x02,0x20,0x02,0x20,0x7f,0xff,0x02,0x20,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80}}, // 菓
{0x325C,0x89DA,0xB2DC,0xE89DA6,0x8766,{0x08,0x00,0x08,0xee,0x08,0xa2,0x08,0xa2,0x3e,0xa2,0x2a,0xee,0x2a,0x80,0x2a,0x9e,0x3e,0xea,0x08,0x8a,0x08,0x8a,0x0c,0xe4,0x0a,0x84,0x0e,0x8a,0x72,0x92,0x01,0xa1}}, // 蝦
{0x325D,0x89DB,0xB2DD,0xE8AAB2,0x8AB2,{0x00,0x00,0x3e,0xfe,0x00,0x92,0x7f,0x92,0x00,0xfe,0x3e,0x92,0x00,0x92,0x00,0xfe,0x3e,0x10,0x01,0xff,0x3e,0x38,0x22,0x54,0x22,0x54,0x22,0x92,0x3f,0x11,0x22,0x10}}, // 課
{0x325E,0x89DC,0xB2DE,0xE598A9,0x5629,{0x00,0x88,0x00,0x88,0x7f,0xff,0x48,0x88,0x4b,0xfe,0x49,0x24,0x49,0x24,0x4f,0xff,0x49,0x24,0x49,0x24,0x4b,0xfe,0x78,0x20,0x48,0x20,0x07,0xff,0x00,0x20,0x00,0x20}}, // 嘩
{0x325F,0x89DD,0xB2DF,0xE8B2A8,0x8CA8,{0x02,0x40,0x04,0x44,0x0c,0x78,0x14,0x40,0x64,0x42,0x04,0x3e,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x0c,0x18,0x30,0x04}}, // 貨
{0x3260,0x89DE,0xB2E0,0xE8BFA6,0x8FE6,{0x01,0x00,0x21,0x00,0x11,0x1e,0x17,0xd2,0x01,0x52,0x01,0x52,0x01,0x52,0x79,0x52,0x09,0x52,0x0a,0x52,0x0a,0x52,0x0c,0x5e,0x15,0x92,0x12,0x00,0x21,0x80,0x40,0x7f}}, // 迦
{0x3261,0x89DF,0xB2E1,0xE9818E,0x904E,{0x00,0x00,0x21,0xfc,0x11,0x04,0x11,0x3c,0x01,0x24,0x01,0x24,0x03,0xfe,0x7a,0x02,0x0a,0xfa,0x0a,0x8a,0x0a,0x8a,0x0a,0xfa,0x16,0x8a,0x12,0x06,0x21,0x80,0x40,0x7f}}, // 過
{0x3262,0x89E0,0xB2E2,0xE99C9E,0x971E,{0x00,0x00,0x3f,0xfc,0x00,0x80,0x3f,0xfe,0x20,0x82,0x3e,0xf4,0x4f,0xbc,0x00,0x80,0x3e,0xfc,0x22,0x04,0x3e,0xfc,0x20,0x00,0x3e,0xf8,0x20,0x48,0x3e,0x30,0x21,0xce}}, // 霞
{0x3263,0x89E1,0xB2E3,0xE89A8A,0x868A,{0x08,0x10,0x08,0x10,0x08,0x10,0x3f,0xff,0x29,0x44,0x29,0x44,0x29,0x44,0x29,0x44,0x3f,0x28,0x08,0x28,0x0c,0x10,0x0a,0x10,0x0a,0x28,0x0d,0x48,0x70,0x84,0x01,0x02}}, // 蚊
{0x3264,0x89E2,0xB2E4,0xE4BF84,0x4FC4,{0x04,0x50,0x04,0x94,0x07,0x12,0x09,0x12,0x09,0x10,0x1f,0xff,0x11,0x10,0x31,0x12,0x51,0x52,0x11,0x94,0x17,0x08,0x11,0x1a,0x11,0x2a,0x11,0x46,0x11,0x86,0x13,0x02}}, // 俄
{0x3265,0x89E3,0xB2E5,0xE5B3A8,0x5CE8,{0x10,0x50,0x10,0x94,0x13,0x92,0x54,0x92,0x54,0x90,0x57,0xff,0x54,0x90,0x54,0x92,0x54,0xd2,0x55,0x94,0x56,0x88,0x7c,0x9a,0x44,0xaa,0x40,0xc6,0x00,0x86,0x03,0x02}}, // 峨
{0x3266,0x89E4,0xB2E6,0xE68891,0x6211,{0x01,0x40,0x02,0x50,0x0c,0x48,0x34,0x44,0x04,0x40,0x04,0x40,0x7f,0xff,0x04,0x24,0x04,0x24,0x07,0x28,0x0c,0x18,0x74,0x10,0x04,0x29,0x04,0x45,0x05,0x83,0x0c,0x01}}, // 我
{0x3267,0x89E5,0xB2E7,0xE78999,0x7259,{0x00,0x00,0x07,0xfc,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x7f,0xff,0x00,0x50,0x00,0x90,0x01,0x10,0x02,0x10,0x04,0x10,0x18,0x10,0x60,0x70,0x00,0x10}}, // 牙
{0x3268,0x89E6,0xB2E8,0xE794BB,0x753B,{0x00,0x00,0x7f,0xff,0x00,0x80,0x00,0x80,0x27,0xf2,0x24,0x92,0x24,0x92,0x24,0x92,0x27,0xf2,0x24,0x92,0x24,0x92,0x24,0x92,0x27,0xf2,0x20,0x02,0x3f,0xfe,0x20,0x02}}, // 画
{0x3269,0x89E7,0xB2E9,0xE887A5,0x81E5,{0x00,0x10,0x3f,0x90,0x24,0x10,0x24,0x10,0x24,0x10,0x3f,0x10,0x21,0x10,0x21,0x28,0x21,0x28,0x3f,0x28,0x24,0x28,0x24,0x44,0x24,0x44,0x3f,0x84,0x21,0x02,0x02,0x01}}, // 臥
{0x326A,0x89E8,0xB2EA,0xE88ABD,0x82BD,{0x02,0x20,0x02,0x20,0x7f,0xff,0x02,0x20,0x00,0x00,0x1f,0xfc,0x04,0x20,0x04,0x20,0x04,0x20,0x7f,0xff,0x00,0x60,0x00,0xa0,0x03,0x20,0x0c,0x20,0x70,0xe0,0x00,0x20}}, // 芽
{0x326B,0x89E9,0xB2EB,0xE89BBE,0x86FE,{0x08,0x28,0x08,0x48,0x09,0xcc,0x3e,0x4a,0x2a,0x4a,0x2b,0xff,0x2a,0x48,0x2a,0x4a,0x3e,0x4a,0x08,0x64,0x0d,0xc4,0x0a,0x4c,0x0a,0x4d,0x1f,0x53,0x61,0x63,0x00,0xc1}}, // 蛾
{0x326C,0x89EA,0xB2EC,0xE8B380,0x8CC0,{0x08,0x00,0x08,0x7e,0x7f,0x42,0x09,0x42,0x09,0x42,0x11,0x7e,0x26,0x42,0x4f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x06,0x18,0x38,0x06}}, // 賀
{0x326D,0x89EB,0xB2ED,0xE99B85,0x96C5,{0x00,0x24,0x3f,0x24,0x12,0x48,0x12,0x7f,0x12,0xc8,0x12,0x48,0x7f,0xc8,0x0a,0x7e,0x0a,0x48,0x0a,0x48,0x0a,0x7e,0x12,0x48,0x12,0x48,0x22,0x48,0x42,0x7f,0x06,0x40}}, // 雅
{0x326E,0x89EC,0xB2EE,0xE9A493,0x9913,{0x08,0x28,0x08,0x4c,0x15,0xca,0x1a,0x4a,0x28,0x48,0x7f,0xff,0x22,0x48,0x3e,0x4a,0x22,0x6a,0x22,0x4a,0x3e,0xc4,0x29,0x44,0x24,0x4d,0x2c,0x4b,0x32,0x53,0x62,0xe1}}, // 餓
{0x326F,0x89ED,0xB2EF,0xE9A795,0x99D5,{0x08,0x00,0x7f,0x7e,0x09,0x42,0x09,0x42,0x11,0x7e,0x26,0x42,0x4f,0xf8,0x08,0x80,0x0f,0xf0,0x08,0x80,0x0f,0xf0,0x08,0x80,0x0f,0xfe,0x29,0x22,0x24,0x92,0x40,0x0c}}, // 駕
{0x3270,0x89EE,0xB2F0,0xE4BB8B,0x4ECB,{0x00,0x80,0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x64,0x13,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x08,0x10,0x08,0x10,0x10,0x10,0x20,0x10}}, // 介
{0x3271,0x89EF,0xB2F1,0xE4BC9A,0x4F1A,{0x00,0x80,0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x67,0xf3,0x00,0x00,0x00,0x00,0x3f,0xfe,0x01,0x00,0x01,0x20,0x02,0x10,0x04,0x68,0x3f,0x84,0x00,0x04}}, // 会
{0x3272,0x89F0,0xB2F2,0xE8A7A3,0x89E3,{0x08,0x00,0x0e,0x7e,0x12,0x12,0x24,0x12,0x7f,0x22,0x29,0x4c,0x29,0x90,0x3f,0x50,0x29,0x7e,0x29,0x90,0x3f,0x10,0x21,0xff,0x21,0x10,0x21,0x10,0x23,0x10,0x41,0x10}}, // 解
{0x3273,0x89F1,0xB2F3,0xE59B9E,0x56DE,{0x00,0x00,0x3f,0xfe,0x20,0x02,0x20,0x02,0x20,0x02,0x23,0xe2,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x23,0xe2,0x20,0x02,0x20,0x02,0x20,0x02,0x3f,0xfe,0x20,0x02}}, // 回
{0x3274,0x89F2,0xB2F4,0xE5A18A,0x584A,{0x00,0x20,0x10,0x40,0x11,0xfc,0x11,0x24,0x11,0x24,0x7f,0xfc,0x11,0x24,0x11,0x24,0x11,0xfc,0x10,0x54,0x16,0x54,0x18,0x9a,0x60,0x9f,0x01,0x10,0x06,0x11,0x18,0x0f}}, // 塊
{0x3275,0x89F3,0xB2F5,0xE5A38A,0x58CA,{0x00,0x20,0x10,0x20,0x13,0xfe,0x10,0x20,0x11,0xfc,0x7f,0x54,0x11,0x54,0x11,0xfc,0x10,0x20,0x13,0xff,0x14,0x44,0x18,0xa8,0x61,0x90,0x06,0x88,0x00,0xe4,0x03,0x83}}, // 壊
{0x3276,0x89F4,0xB2F6,0xE5BBBB,0x5EFB,{0x00,0x00,0x3d,0xfe,0x05,0x02,0x09,0x02,0x09,0x7a,0x11,0x4a,0x3d,0x4a,0x05,0x4a,0x05,0x7a,0x25,0x4a,0x15,0x02,0x09,0xfe,0x0d,0x02,0x13,0x00,0x20,0xe0,0x40,0x1f}}, // 廻
{0x3277,0x89F5,0xB2F7,0xE5BFAB,0x5FEB,{0x08,0x20,0x08,0x20,0x08,0x20,0x09,0xfc,0x2c,0x24,0x2a,0x24,0x2a,0x24,0x28,0x24,0x4b,0xff,0x08,0x20,0x08,0x50,0x08,0x50,0x08,0x88,0x08,0x88,0x09,0x04,0x0a,0x02}}, // 快
{0x3278,0x89F6,0xB2F8,0xE680AA,0x602A,{0x08,0x00,0x0b,0xfc,0x08,0x88,0x08,0x48,0x08,0x50,0x2c,0x20,0x2a,0x50,0x2a,0x8c,0x2b,0x23,0x48,0x20,0x09,0xfc,0x08,0x20,0x08,0x20,0x08,0x20,0x0b,0xfe,0x08,0x00}}, // 怪
{0x3279,0x89F7,0xB2F9,0xE68294,0x6094,{0x09,0x00,0x09,0x00,0x09,0xfe,0x09,0x00,0x2a,0x00,0x2a,0xfc,0x2c,0xa4,0x2c,0xa4,0x4b,0xff,0x09,0x24,0x09,0x24,0x09,0x24,0x0b,0xff,0x0a,0x04,0x08,0x08,0x08,0x30}}, // 悔
{0x327A,0x89F8,0xB2FA,0xE681A2,0x6062,{0x08,0x00,0x09,0xff,0x09,0x00,0x09,0x10,0x2d,0x12,0x2b,0x52,0x29,0x54,0x29,0x54,0x49,0x50,0x09,0x90,0x09,0x18,0x09,0x28,0x0a,0x24,0x0a,0x44,0x0d,0x82,0x0e,0x01}}, // 恢
{0x327B,0x89F9,0xB2FB,0xE68790,0x61D0,{0x08,0x20,0x08,0x20,0x0b,0xff,0x08,0x20,0x29,0xfc,0x2d,0x54,0x2d,0x54,0x2b,0xfc,0x48,0x20,0x0b,0xff,0x08,0x44,0x08,0xa4,0x09,0x98,0x0a,0x88,0x08,0xe4,0x09,0x83}}, // 懐
{0x327C,0x89FA,0xB2FC,0xE68892,0x6212,{0x00,0x48,0x00,0x44,0x00,0x44,0x7f,0xff,0x00,0x40,0x09,0x44,0x09,0x44,0x09,0x28,0x7f,0xe8,0x09,0x30,0x09,0x10,0x11,0x30,0x11,0x2a,0x21,0x4a,0x40,0x86,0x01,0x02}}, // 戒
{0x327D,0x89FB,0xB2FD,0xE68B90,0x62D0,{0x08,0x00,0x08,0xfc,0x08,0x84,0x08,0x84,0x7e,0x84,0x08,0xfc,0x08,0x84,0x08,0x00,0x09,0xfe,0x0e,0x22,0x78,0x22,0x08,0x22,0x08,0x42,0x08,0x42,0x18,0x82,0x09,0x0c}}, // 拐
{0x327E,0x89FC,0xB2FE,0xE694B9,0x6539,{0x00,0x40,0x00,0x40,0x7e,0x40,0x02,0x7f,0x02,0x44,0x02,0x44,0x7e,0xa4,0x42,0xa4,0x41,0x28,0x40,0x28,0x40,0x10,0x42,0x18,0x42,0x28,0x3e,0x44,0x00,0x82,0x03,0x01}}, // 改
{0x3321,0x8A40,0xB3A1,0xE9AD81,0x9B41,{0x08,0x04,0x10,0x44,0x3f,0x24,0x25,0x14,0x25,0x94,0x3f,0x44,0x25,0x24,0x25,0x24,0x3f,0x07,0x0c,0xfc,0x0c,0x84,0x0d,0x44,0x17,0xc4,0x14,0x06,0x22,0x02,0x41,0xfe}}, // 魁
{0x3322,0x8A41,0xB3A2,0xE699A6,0x6666,{0x00,0x80,0x00,0x80,0x78,0xff,0x49,0x00,0x49,0x00,0x4a,0xfc,0x4c,0xa4,0x78,0xa4,0x4f,0xff,0x49,0x24,0x49,0x24,0x49,0x24,0x7b,0xff,0x4a,0x04,0x00,0x08,0x00,0x30}}, // 晦
{0x3323,0x8A42,0xB3A3,0xE6A2B0,0x68B0,{0x08,0x10,0x08,0x14,0x08,0x12,0x7f,0xff,0x08,0x10,0x09,0x52,0x19,0x52,0x1d,0x52,0x1b,0xf4,0x29,0x54,0x29,0x4c,0x49,0x48,0x0a,0x5a,0x0a,0x26,0x0c,0x46,0x08,0x82}}, // 械
{0x3324,0x8A43,0xB3A4,0xE6B5B7,0x6D77,{0x10,0x80,0x08,0x80,0x08,0xfe,0x01,0x00,0x41,0x00,0x23,0xfc,0x24,0xa4,0x00,0xa4,0x0f,0xff,0x09,0x24,0x11,0x24,0x11,0x24,0x23,0xff,0x22,0x04,0x40,0x08,0x40,0x30}}, // 海
{0x3325,0x8A44,0xB3A5,0xE781B0,0x7070,{0x00,0x00,0x1f,0xfe,0x10,0x00,0x10,0x40,0x10,0x44,0x12,0x44,0x12,0x44,0x12,0x48,0x14,0x50,0x14,0x40,0x10,0xa0,0x10,0xa0,0x21,0x10,0x22,0x08,0x4c,0x04,0x30,0x03}}, // 灰
{0x3326,0x8A45,0xB3A6,0xE7958C,0x754C,{0x00,0x00,0x1f,0xfc,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x84,0x10,0x84,0x1f,0xfc,0x01,0x40,0x06,0x30,0x1a,0x1c,0x62,0x13,0x04,0x10,0x04,0x10,0x08,0x10,0x10,0x10}}, // 界
{0x3327,0x8A46,0xB3A7,0xE79A86,0x7686,{0x10,0x20,0x10,0x26,0x1f,0xb8,0x10,0x20,0x10,0x21,0x13,0x21,0x1c,0x9f,0x61,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 皆
{0x3328,0x8A47,0xB3A8,0xE7B5B5,0x7D75,{0x08,0x10,0x08,0x10,0x0a,0x28,0x72,0x28,0x14,0x44,0x08,0x82,0x0d,0x7d,0x12,0x00,0x7e,0x00,0x09,0xfe,0x2c,0x20,0x2a,0x28,0x2a,0x44,0x2a,0x5c,0x49,0xe2,0x08,0x02}}, // 絵
{0x3329,0x8A48,0xB3A9,0xE88AA5,0x82A5,{0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x10,0x04,0x90,0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x1a,0x1c,0x62,0x13,0x02,0x10,0x02,0x10,0x04,0x10,0x04,0x10,0x08,0x10}}, // 芥
{0x332A,0x8A49,0xB3AA,0xE89FB9,0x87F9,{0x10,0x00,0x1e,0xfe,0x24,0x22,0x7f,0x46,0x29,0xa8,0x3f,0x3e,0x29,0x48,0x3f,0xff,0x21,0x08,0x43,0x08,0x1f,0xf0,0x11,0x10,0x1f,0xf0,0x01,0x08,0x01,0xfc,0x7e,0x02}}, // 蟹
{0x332B,0x8A4A,0xB3AB,0xE9968B,0x958B,{0x00,0x00,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x42,0x42,0x42,0x42,0x7e,0x7e,0x40,0x02,0x4f,0xf2,0x42,0x42,0x42,0x42,0x7f,0xfa,0x42,0x42,0x44,0x42,0x48,0x46,0x40,0x02}}, // 開
{0x332C,0x8A4B,0xB3AC,0xE99A8E,0x968E,{0x01,0x10,0x3d,0x12,0x25,0xfc,0x25,0x10,0x29,0x10,0x31,0x11,0x29,0xcf,0x27,0x20,0x24,0xfe,0x24,0x82,0x24,0x82,0x24,0xfe,0x38,0x82,0x20,0x82,0x20,0xfe,0x20,0x82}}, // 階
{0x332D,0x8A4C,0xB3AD,0xE8B29D,0x8C9D,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x02,0x30,0x0c,0x08,0x30,0x04}}, // 貝
{0x332E,0x8A4D,0xB3AE,0xE587B1,0x51F1,{0x08,0x00,0x29,0x3c,0x29,0x24,0x3f,0x24,0x00,0x24,0x7f,0xa4,0x00,0x24,0x3f,0x24,0x21,0x24,0x21,0x24,0x3f,0x24,0x22,0x24,0x12,0x24,0x15,0xc5,0x0e,0x45,0x70,0x83}}, // 凱
{0x332F,0x8A4E,0xB3AF,0xE58ABE,0x52BE,{0x04,0x10,0x04,0x10,0x04,0x10,0x7f,0xfe,0x08,0x12,0x0a,0x12,0x72,0x12,0x14,0x92,0x0c,0x92,0x09,0x12,0x11,0x22,0x22,0x22,0x05,0x22,0x08,0xc2,0x10,0x82,0x61,0x0c}}, // 劾
{0x3330,0x8A4F,0xB3B0,0xE5A496,0x5916,{0x04,0x20,0x04,0x20,0x07,0xa0,0x08,0xa0,0x08,0xa0,0x10,0xa0,0x19,0x30,0x25,0x2c,0x43,0x22,0x02,0x21,0x02,0x20,0x04,0x20,0x04,0x20,0x08,0x20,0x10,0x20,0x20,0x20}}, // 外
{0x3331,0x8A50,0xB3B1,0xE592B3,0x54B3,{0x00,0x20,0x00,0x20,0x7c,0x20,0x47,0xff,0x44,0x40,0x44,0x48,0x44,0x90,0x47,0x90,0x44,0x64,0x44,0x44,0x44,0x88,0x7f,0x10,0x44,0x28,0x00,0x44,0x01,0x82,0x06,0x02}}, // 咳
{0x3332,0x8A51,0xB3B2,0xE5AEB3,0x5BB3,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x21,0x04,0x41,0x00,0x3f,0xfc,0x01,0x00,0x1f,0xf8,0x01,0x00,0x7f,0xfe,0x00,0x00,0x1f,0xf8,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x08}}, // 害
{0x3333,0x8A52,0xB3B3,0xE5B496,0x5D16,{0x10,0x84,0x10,0x84,0x1f,0xfc,0x00,0x00,0x1f,0xff,0x10,0x40,0x17,0xfc,0x10,0x40,0x10,0x40,0x1f,0xfe,0x10,0x40,0x17,0xfc,0x20,0x40,0x20,0x40,0x5f,0xff,0x00,0x00}}, // 崖
{0x3334,0x8A53,0xB3B4,0xE685A8,0x6168,{0x10,0x00,0x13,0xff,0x12,0x44,0x12,0x54,0x33,0xd4,0x3a,0x54,0x36,0x54,0x33,0xff,0x53,0x04,0x12,0x8c,0x12,0x8c,0x12,0x4c,0x12,0xd4,0x13,0x55,0x1c,0x25,0x10,0x43}}, // 慨
{0x3335,0x8A54,0xB3B5,0xE6A682,0x6982,{0x10,0x00,0x13,0xff,0x12,0x44,0x12,0x54,0x7f,0xd4,0x12,0x54,0x12,0x54,0x3b,0xff,0x37,0x04,0x32,0x8c,0x52,0x8c,0x12,0x4c,0x12,0xd4,0x13,0x55,0x1c,0x25,0x10,0x43}}, // 概
{0x3336,0x8A55,0xB3B6,0xE6B6AF,0x6DAF,{0x10,0x00,0x0b,0xfe,0x0a,0x10,0x02,0x10,0x42,0xfe,0x22,0x10,0x22,0x10,0x03,0xff,0x0a,0x10,0x0a,0x10,0x12,0xfe,0x12,0x10,0x24,0x10,0x24,0x10,0x4b,0xff,0x40,0x00}}, // 涯
{0x3337,0x8A56,0xB3B7,0xE7A28D,0x788D,{0x00,0x00,0x7f,0x7c,0x08,0x44,0x08,0x7c,0x08,0x44,0x10,0x44,0x1e,0x7c,0x32,0x00,0x33,0xfe,0x52,0x04,0x13,0xff,0x12,0x84,0x1e,0x44,0x12,0x44,0x10,0x0c,0x00,0x04}}, // 碍
{0x3338,0x8A57,0xB3B8,0xE8938B,0x84CB,{0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x90,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x02,0x20,0x04,0x18,0x3f,0xf4,0x00,0x02,0x1f,0xf8,0x12,0x48,0x12,0x48,0x7f,0xff,0x00,0x00}}, // 蓋
{0x3339,0x8A58,0xB3B9,0xE8A197,0x8857,{0x09,0x00,0x09,0x1e,0x17,0xe0,0x11,0x00,0x21,0x00,0x49,0x00,0x0f,0xff,0x11,0x04,0x11,0x04,0x37,0xe4,0x51,0x04,0x11,0x04,0x11,0x64,0x13,0x84,0x1c,0x0c,0x10,0x04}}, // 街
{0x333A,0x8A59,0xB3BA,0xE8A9B2,0x8A72,{0x00,0x10,0x3e,0x10,0x00,0x10,0x7f,0xff,0x00,0x10,0x3e,0x14,0x00,0xe4,0x00,0x28,0x3e,0x1a,0x00,0x12,0x3e,0x24,0x22,0x44,0x22,0x88,0x22,0x14,0x3e,0x62,0x23,0x82}}, // 該
{0x333B,0x8A5A,0xB3BB,0xE98EA7,0x93A7,{0x08,0x10,0x08,0x92,0x14,0x92,0x12,0xfe,0x21,0x00,0x7e,0xff,0x08,0x00,0x08,0x7c,0x7f,0x44,0x08,0x44,0x4a,0x7c,0x2c,0x44,0x28,0x24,0x0e,0x28,0x19,0xff,0x60,0x00}}, // 鎧
{0x333C,0x8A5B,0xB3BC,0xE9AAB8,0x9AB8,{0x00,0x10,0x3e,0x10,0x22,0x10,0x2e,0xff,0x2a,0x10,0x2a,0x14,0x7f,0x64,0x41,0x28,0x7f,0x12,0x62,0x12,0x3e,0x24,0x22,0xc4,0x3e,0x08,0x22,0x14,0x22,0x22,0x26,0xc2}}, // 骸
{0x333D,0x8A5C,0xB3BD,0xE6B5AC,0x6D6C,{0x10,0x00,0x0b,0xfc,0x0a,0x24,0x02,0x24,0x43,0xfc,0x22,0x24,0x22,0x24,0x02,0x24,0x0b,0xfc,0x08,0x20,0x10,0x20,0x17,0xfe,0x20,0x20,0x20,0x20,0x4f,0xff,0x40,0x00}}, // 浬
{0x333E,0x8A5D,0xB3BE,0xE9A6A8,0x99A8,{0x04,0x3c,0x3f,0x25,0x04,0x47,0x7f,0xfc,0x25,0x24,0x3f,0x18,0x20,0x64,0x4f,0x83,0x00,0x80,0x7f,0xff,0x02,0xa0,0x07,0xf0,0x1c,0x1c,0x67,0xf3,0x04,0x10,0x07,0xf0}}, // 馨
{0x333F,0x8A5E,0xB3BF,0xE89B99,0x86D9,{0x08,0x10,0x08,0x10,0x08,0x7e,0x3f,0x10,0x29,0x10,0x29,0x10,0x29,0xff,0x29,0x00,0x3f,0x10,0x08,0x10,0x0c,0xfe,0x0a,0x10,0x0e,0x10,0x19,0x10,0x61,0xff,0x00,0x00}}, // 蛙
{0x3340,0x8A5F,0xB3C0,0xE59EA3,0x57A3,{0x08,0x00,0x09,0xfe,0x08,0x00,0x08,0x00,0x7e,0xfc,0x08,0x84,0x08,0x84,0x08,0xfc,0x08,0x84,0x08,0x84,0x0e,0x84,0x18,0xfc,0x60,0x84,0x00,0x00,0x07,0xff,0x00,0x00}}, // 垣
{0x3341,0x8A60,0xB3C1,0xE69FBF,0x67FF,{0x08,0x20,0x08,0x20,0x08,0x20,0x7f,0xff,0x08,0x20,0x08,0x20,0x19,0xfe,0x1d,0x22,0x1b,0x22,0x29,0x22,0x29,0x22,0x49,0x22,0x09,0x2c,0x09,0x20,0x08,0x20,0x08,0x20}}, // 柿
{0x3342,0x8A61,0xB3C2,0xE89B8E,0x86CE,{0x08,0x00,0x08,0xff,0x08,0x80,0x3e,0x80,0x2a,0xff,0x2a,0x90,0x2a,0x90,0x2a,0x9e,0x3e,0x92,0x08,0x92,0x0c,0x92,0x0a,0x92,0x0f,0x22,0x19,0x22,0x62,0x42,0x04,0x8c}}, // 蛎
{0x3343,0x8A62,0xB3C3,0xE9888E,0x920E,{0x08,0x20,0x08,0x20,0x14,0x20,0x12,0x3e,0x21,0x42,0x7e,0x62,0x08,0xa2,0x09,0x22,0x7f,0x32,0x08,0x4a,0x4a,0x7a,0x2c,0xca,0x28,0x02,0x0b,0x02,0x1c,0x04,0x60,0x18}}, // 鈎
{0x3344,0x8A63,0xB3C4,0xE58A83,0x5283,{0x04,0x02,0x3f,0x92,0x04,0x92,0x7f,0xf2,0x04,0x92,0x3f,0x92,0x04,0x12,0x1f,0x12,0x7f,0xd2,0x24,0x92,0x3f,0x92,0x24,0x92,0x3f,0x82,0x00,0x02,0x7f,0xc2,0x00,0x06}}, // 劃
{0x3345,0x8A64,0xB3C5,0xE59A87,0x5687,{0x01,0x08,0x01,0x08,0x77,0xfe,0x51,0x08,0x51,0x08,0x51,0x08,0x5f,0xff,0x52,0x94,0x52,0x94,0x5a,0xd6,0x7a,0xb5,0x4a,0xb5,0x12,0x94,0x04,0xa4,0x04,0xa4,0x09,0xcc}}, // 嚇
{0x3346,0x8A65,0xB3C6,0xE59084,0x5404,{0x02,0x00,0x02,0x00,0x07,0xf8,0x04,0x10,0x0a,0x20,0x11,0x40,0x20,0xc0,0x03,0x20,0x04,0x10,0x18,0x0c,0x6f,0xfb,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 各
{0x3347,0x8A66,0xB3C7,0xE5BB93,0x5ED3,{0x00,0x80,0x00,0x80,0x1f,0xff,0x11,0x00,0x1f,0xfe,0x10,0x12,0x17,0x94,0x14,0x98,0x17,0x94,0x10,0x12,0x17,0x92,0x11,0x12,0x21,0xd2,0x2f,0x1c,0x41,0x10,0x03,0x10}}, // 廓
{0x3348,0x8A67,0xB3C8,0xE68BA1,0x62E1,{0x10,0x10,0x10,0x10,0x10,0x10,0x11,0xff,0x7d,0x00,0x11,0x10,0x11,0x10,0x11,0x10,0x11,0x10,0x1d,0x10,0x71,0x24,0x12,0x24,0x12,0x42,0x12,0x5e,0x15,0xe1,0x38,0x01}}, // 拡
{0x3349,0x8A68,0xB3C9,0xE692B9,0x64B9,{0x12,0x44,0x11,0x24,0x11,0x28,0x17,0xfe,0x7c,0x02,0x15,0xfa,0x11,0x08,0x11,0xf8,0x1d,0x08,0x71,0xf8,0x11,0x08,0x11,0xf8,0x10,0x50,0x10,0x91,0x13,0x11,0x3c,0x0f}}, // 撹
{0x334A,0x8A69,0xB3CA,0xE6A0BC,0x683C,{0x08,0x40,0x08,0x40,0x08,0x7c,0x7f,0x84,0x08,0xc8,0x08,0xa8,0x1d,0x30,0x1a,0x28,0x1a,0x44,0x28,0x82,0x29,0xfd,0x4a,0x84,0x08,0x84,0x08,0x84,0x08,0xfc,0x08,0x84}}, // 格
{0x334B,0x8A6A,0xB3CB,0xE6A0B8,0x6838,{0x08,0x20,0x08,0x20,0x08,0x20,0x7f,0xff,0x08,0x20,0x08,0x28,0x19,0xc8,0x1c,0x52,0x1a,0x24,0x28,0x24,0x28,0x48,0x49,0x90,0x08,0x28,0x08,0x44,0x08,0x82,0x0b,0x02}}, // 核
{0x334C,0x8A6B,0xB3CC,0xE6AEBB,0x6BBB,{0x08,0x00,0x08,0x3c,0x7f,0x24,0x08,0x24,0x08,0x25,0x3e,0x45,0x00,0x83,0x7f,0xfc,0x40,0x84,0x5e,0xa4,0x12,0x24,0x12,0x18,0x12,0x88,0x13,0x14,0x22,0x62,0x41,0x81}}, // 殻
{0x334D,0x8A6C,0xB3CD,0xE78DB2,0x7372,{0x04,0x48,0x47,0xff,0x28,0x48,0x10,0x90,0x11,0xfe,0x29,0x10,0x4b,0xfc,0x19,0x10,0x15,0xfc,0x25,0x10,0x47,0xfe,0x04,0x88,0x04,0x50,0x08,0x20,0x28,0xd8,0x13,0x06}}, // 獲
{0x334E,0x8A6D,0xB3CE,0xE7A2BA,0x78BA,{0x00,0x20,0x7f,0x20,0x08,0xff,0x08,0xa2,0x09,0x24,0x08,0x48,0x1e,0x7f,0x12,0xc8,0x33,0x48,0x32,0x7e,0x52,0x48,0x12,0x7e,0x1e,0x48,0x12,0x48,0x10,0x7f,0x00,0x40}}, // 確
{0x334F,0x8A6E,0xB3CF,0xE7A9AB,0x7A6B,{0x02,0x44,0x05,0xff,0x78,0x48,0x08,0xfe,0x08,0x90,0x09,0xfe,0x7e,0x90,0x08,0xfe,0x1c,0x90,0x1a,0xfe,0x2a,0x00,0x29,0xfe,0x48,0x48,0x08,0x30,0x08,0x4c,0x0b,0x83}}, // 穫
{0x3350,0x8A6F,0xB3D0,0xE8A69A,0x899A,{0x11,0x08,0x08,0x88,0x08,0x90,0x3f,0xfe,0x20,0x04,0x4f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x02,0x40,0x04,0x41,0x18,0x41,0x60,0x3f}}, // 覚
{0x3351,0x8A70,0xB3D1,0xE8A792,0x89D2,{0x02,0x00,0x03,0xf0,0x04,0x40,0x18,0x80,0x7f,0xfc,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x04,0x10,0x04,0x20,0x04,0x20,0x0c,0x40,0x04}}, // 角
{0x3352,0x8A71,0xB3D2,0xE8B5AB,0x8D6B,{0x04,0x10,0x04,0x10,0x3f,0x7e,0x04,0x10,0x04,0x10,0x04,0x10,0x7f,0xff,0x0a,0x28,0x0b,0x2c,0x2a,0xac,0x2a,0xea,0x2a,0x6a,0x4a,0xaa,0x12,0x48,0x12,0x48,0x26,0x98}}, // 赫
{0x3353,0x8A72,0xB3D3,0xE8BC83,0x8F03,{0x08,0x10,0x08,0x10,0x7f,0x10,0x09,0xff,0x3e,0x44,0x2a,0x44,0x2a,0x82,0x3f,0x45,0x2a,0x44,0x2a,0x28,0x3e,0x28,0x08,0x10,0x7f,0x28,0x08,0x44,0x08,0x82,0x09,0x01}}, // 較
{0x3354,0x8A73,0xB3D4,0xE983AD,0x90ED,{0x04,0x00,0x04,0x3e,0x7f,0xe2,0x00,0x22,0x1f,0xa4,0x10,0xa4,0x1f,0xa8,0x00,0x24,0x3f,0xa2,0x01,0x22,0x02,0x21,0x03,0xb1,0x7e,0x29,0x02,0x26,0x02,0x20,0x06,0x20}}, // 郭
{0x3355,0x8A74,0xB3D5,0xE996A3,0x95A3,{0x00,0x00,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x41,0x02,0x43,0xe2,0x4e,0x42,0x41,0x82,0x46,0x62,0x58,0x1a,0x47,0xe2,0x44,0x22,0x47,0xe2,0x40,0x06}}, // 閣
{0x3356,0x8A75,0xB3D6,0xE99A94,0x9694,{0x00,0x00,0x3d,0xfe,0x24,0x00,0x24,0xfc,0x28,0x84,0x30,0xfc,0x28,0x00,0x25,0xfe,0x25,0x2a,0x25,0x2a,0x25,0x4e,0x25,0x82,0x39,0xfe,0x21,0x12,0x21,0x12,0x21,0x16}}, // 隔
{0x3357,0x8A76,0xB3D7,0xE99DA9,0x9769,{0x02,0x20,0x02,0x20,0x3f,0xfe,0x02,0x20,0x02,0x20,0x03,0xe0,0x00,0x80,0x0f,0xf8,0x08,0x88,0x08,0x88,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80}}, // 革
{0x3358,0x8A77,0xB3D8,0xE5ADA6,0x5B66,{0x11,0x08,0x08,0x88,0x08,0x90,0x3f,0xfe,0x20,0x04,0x20,0x00,0x5f,0xf0,0x00,0x20,0x00,0xc0,0x01,0x00,0x7f,0xfe,0x01,0x00,0x01,0x00,0x01,0x00,0x07,0x00,0x01,0x00}}, // 学
{0x3359,0x8A78,0xB3D9,0xE5B2B3,0x5CB3,{0x00,0x10,0x00,0x60,0x07,0x80,0x04,0x00,0x07,0xfc,0x04,0x10,0x04,0x10,0x04,0x10,0x7f,0xff,0x00,0x80,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x04}}, // 岳
{0x335A,0x8A79,0xB3DA,0xE6A5BD,0x697D,{0x00,0x40,0x20,0x82,0x13,0xe2,0x0a,0x24,0x0a,0x28,0x03,0xe0,0x02,0x28,0x0e,0x26,0x33,0xe1,0x00,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x0c,0x98,0x70,0x87,0x00,0x80}}, // 楽
{0x335B,0x8A7A,0xB3DB,0xE9A18D,0x984D,{0x08,0x00,0x08,0xff,0x3f,0x10,0x22,0x20,0x48,0x7e,0x1e,0x42,0x22,0x42,0x54,0x7e,0x0c,0x42,0x0a,0x7e,0x11,0x42,0x3e,0xc2,0x52,0x7e,0x12,0x24,0x1e,0xc2,0x13,0x01}}, // 額
{0x335C,0x8A7B,0xB3DC,0xE9A18E,0x984E,{0x00,0x00,0x77,0xff,0x55,0x10,0x55,0x20,0x77,0x7e,0x00,0x42,0x3e,0x7e,0x00,0x42,0x7f,0x42,0x10,0x7e,0x10,0x42,0x3e,0x42,0x22,0x7e,0x02,0x24,0x02,0x62,0x0c,0xc1}}, // 顎
{0x335D,0x8A7C,0xB3DD,0xE68E9B,0x639B,{0x10,0x84,0x10,0x84,0x13,0xe4,0x10,0x84,0x7c,0x84,0x10,0x84,0x17,0xf6,0x10,0x85,0x1c,0x85,0x73,0xe4,0x10,0x84,0x10,0x84,0x10,0xb4,0x11,0xc4,0x16,0x04,0x30,0x04}}, // 掛
{0x335E,0x8A7D,0xB3DE,0xE7ACA0,0x7B20,{0x08,0x10,0x08,0x10,0x1f,0xbf,0x24,0x28,0x42,0x44,0x02,0x84,0x00,0x80,0x3f,0xfe,0x00,0x08,0x08,0x08,0x04,0x10,0x02,0x10,0x02,0x20,0x00,0x40,0x7f,0xff,0x00,0x00}}, // 笠
{0x335F,0x8A7E,0xB3DF,0xE6A8AB,0x6A2B,{0x10,0x00,0x13,0xc0,0x12,0xbe,0x7e,0x92,0x13,0xd2,0x12,0x4c,0x1b,0xc8,0x36,0x94,0x32,0xa2,0x33,0xc1,0x50,0x20,0x11,0xfc,0x10,0x20,0x10,0x20,0x17,0xff,0x10,0x00}}, // 樫
{0x3360,0x8A80,0xB3E0,0xE6A9BF,0x6A7F,{0x08,0x00,0x0b,0xff,0x08,0x00,0x7f,0xfc,0x09,0x24,0x19,0xfc,0x1d,0x24,0x1b,0xff,0x2a,0x00,0x29,0xfc,0x49,0x24,0x09,0xfc,0x09,0x24,0x09,0xfc,0x08,0x00,0x0b,0xff}}, // 橿
{0x3361,0x8A81,0xB3E1,0xE6A2B6,0x68B6,{0x08,0x00,0x09,0xfe,0x09,0x02,0x7f,0x02,0x09,0xfe,0x09,0x04,0x1d,0x18,0x1b,0xe0,0x19,0x20,0x29,0xfe,0x29,0x20,0x49,0xff,0x0a,0x20,0x0a,0x21,0x0c,0x21,0x08,0x1f}}, // 梶
{0x3362,0x8A82,0xB3E2,0xE9B08D,0x9C0D,{0x08,0x28,0x0e,0x48,0x13,0x88,0x24,0x8a,0x7e,0x9a,0x2b,0xfa,0x2a,0x9c,0x3e,0xa8,0x2a,0xc8,0x2b,0xc8,0x3e,0xac,0x02,0x94,0x34,0x94,0x2a,0xa2,0x2a,0xc2,0x40,0x81}}, // 鰍
{0x3363,0x8A83,0xB3E3,0xE6BD9F,0x6F5F,{0x10,0x40,0x08,0x80,0x0b,0x38,0x02,0x08,0x43,0xb8,0x22,0x08,0x22,0x08,0x03,0xf8,0x08,0x80,0x08,0xfe,0x11,0x02,0x16,0x12,0x23,0x4a,0x22,0xa2,0x44,0x82,0x48,0x0c}}, // 潟
{0x3364,0x8A84,0xB3E4,0xE589B2,0x5272,{0x04,0x02,0x3f,0xd2,0x20,0x92,0x44,0x12,0x3f,0x92,0x04,0x12,0x3f,0x92,0x04,0x12,0x7f,0xd2,0x00,0x12,0x1f,0x92,0x10,0x92,0x10,0x82,0x10,0x82,0x1f,0x82,0x10,0x86}}, // 割
{0x3365,0x8A85,0xB3E5,0xE5969D,0x559D,{0x00,0x00,0x01,0xf8,0x79,0x08,0x49,0x08,0x49,0xf8,0x49,0x08,0x49,0x08,0x49,0xf8,0x48,0x40,0x48,0xfe,0x79,0x12,0x4b,0xe2,0x05,0x02,0x01,0x12,0x00,0xf2,0x00,0x0c}}, // 喝
{0x3366,0x8A86,0xB3E6,0xE681B0,0x6070,{0x08,0x20,0x08,0x20,0x08,0x50,0x08,0x50,0x0c,0x88,0x2a,0x84,0x29,0x02,0x2a,0xfd,0x4c,0x00,0x08,0x00,0x08,0xfc,0x08,0x84,0x08,0x84,0x08,0x84,0x08,0xfc,0x08,0x84}}, // 恰
{0x3367,0x8A87,0xB3E7,0xE68BAC,0x62EC,{0x10,0x04,0x10,0x18,0x11,0xe0,0x10,0x20,0x7c,0x20,0x10,0x20,0x13,0xff,0x10,0x20,0x1c,0x20,0x70,0x20,0x11,0xfc,0x11,0x04,0x11,0x04,0x11,0x04,0x11,0xfc,0x31,0x04}}, // 括
{0x3368,0x8A88,0xB3E8,0xE6B4BB,0x6D3B,{0x10,0x04,0x08,0x18,0x09,0xe0,0x00,0x20,0x00,0x20,0x40,0x20,0x27,0xff,0x20,0x20,0x08,0x20,0x08,0x20,0x11,0xfc,0x11,0x04,0x21,0x04,0x21,0x04,0x41,0xfc,0x41,0x04}}, // 活
{0x3369,0x8A89,0xB3E9,0xE6B887,0x6E07,{0x10,0x00,0x09,0xf8,0x09,0x08,0x01,0xf8,0x41,0x08,0x21,0x08,0x21,0xf8,0x00,0x40,0x08,0xfe,0x09,0x12,0x13,0x22,0x15,0xc2,0x21,0x0a,0x20,0xfa,0x40,0x04,0x40,0x18}}, // 渇
{0x336A,0x8A8A,0xB3EA,0xE6BB91,0x6ED1,{0x10,0x00,0x09,0xf8,0x09,0x08,0x01,0x38,0x01,0x28,0x47,0xff,0x24,0x02,0x25,0xf8,0x09,0x08,0x01,0xf8,0x11,0x08,0x11,0xf8,0x21,0x08,0x21,0x08,0x41,0x18,0x41,0x08}}, // 滑
{0x336B,0x8A8B,0xB3EB,0xE8919B,0x845B,{0x04,0x20,0x04,0x20,0x7f,0xfe,0x04,0x20,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x02,0x00,0x07,0xfe,0x1c,0x62,0x67,0x82,0x04,0x12,0x03,0xf2,0x00,0x0c}}, // 葛
{0x336C,0x8A8C,0xB3EC,0xE8A490,0x8910,{0x08,0x00,0x08,0xfc,0x08,0x84,0x7e,0xfc,0x02,0x84,0x04,0x84,0x04,0xfc,0x0a,0x20,0x1a,0x3e,0x2c,0x4a,0x4a,0xd2,0x0b,0x62,0x08,0x4a,0x08,0x3a,0x08,0x02,0x08,0x0c}}, // 褐
{0x336D,0x8A8D,0xB3ED,0xE8BD84,0x8F44,{0x08,0x10,0x08,0x10,0x7f,0xff,0x08,0x82,0x3f,0x10,0x2a,0xfe,0x2a,0x10,0x3e,0x7c,0x2a,0x10,0x2a,0xff,0x3e,0x00,0x08,0x7c,0x7f,0x44,0x08,0x44,0x08,0x7c,0x08,0x44}}, // 轄
{0x336E,0x8A8E,0xB3EE,0xE4B894,0x4E14,{0x00,0x00,0x0f,0xf0,0x08,0x10,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x7f,0xfe,0x00,0x00}}, // 且
{0x336F,0x8A8F,0xB3EF,0xE9B0B9,0x9C39,{0x08,0x00,0x0e,0xf0,0x12,0xbe,0x24,0xaa,0x7e,0xfa,0x2a,0x9a,0x2a,0xf4,0x3e,0xa6,0x2a,0xaa,0x2a,0xf1,0x3e,0x10,0x05,0x7c,0x32,0x90,0x2a,0x10,0x29,0xff,0x40,0x00}}, // 鰹
{0x3370,0x8A90,0xB3F0,0xE58FB6,0x53F6,{0x00,0x10,0x00,0x10,0x3e,0x10,0x22,0x10,0x22,0x10,0x22,0x10,0x23,0xff,0x22,0x10,0x22,0x10,0x22,0x10,0x22,0x10,0x3e,0x10,0x22,0x10,0x20,0x10,0x00,0x10,0x00,0x10}}, // 叶
{0x3371,0x8A91,0xB3F1,0xE6A49B,0x691B,{0x08,0x88,0x08,0x88,0x0b,0xff,0x7e,0x88,0x08,0x88,0x08,0x50,0x1c,0x50,0x1a,0x92,0x18,0x94,0x29,0x98,0x2a,0x90,0x48,0x90,0x08,0x90,0x08,0x91,0x08,0x91,0x08,0x8f}}, // 椛
{0x3372,0x8A92,0xB3F2,0xE6A8BA,0x6A3A,{0x08,0x48,0x08,0x48,0x0b,0xff,0x7c,0x48,0x0b,0xfe,0x08,0xa4,0x1c,0xa4,0x1b,0xff,0x18,0xa4,0x28,0xa4,0x2b,0xfe,0x48,0x20,0x0b,0xff,0x08,0x20,0x08,0x20,0x08,0x20}}, // 樺
{0x3373,0x8A93,0xB3F3,0xE99E84,0x9784,{0x12,0x20,0x12,0x20,0x7f,0x20,0x12,0x7e,0x12,0x42,0x1e,0x7a,0x08,0x8a,0x3f,0x0a,0x29,0x7a,0x29,0x42,0x3f,0x42,0x08,0x4c,0x7f,0xc0,0x08,0x41,0x08,0x41,0x08,0x3f}}, // 鞄
{0x3374,0x8A94,0xB3F4,0xE6A0AA,0x682A,{0x08,0x10,0x08,0x90,0x08,0x90,0x7e,0x90,0x09,0xfe,0x09,0x10,0x1d,0x10,0x1a,0x10,0x1b,0xff,0x28,0x30,0x28,0x58,0x48,0x58,0x08,0x94,0x09,0x12,0x0a,0x11,0x08,0x10}}, // 株
{0x3375,0x8A95,0xB3F5,0xE5859C,0x515C,{0x04,0x80,0x09,0x00,0x33,0xdc,0x22,0x44,0x22,0x44,0x23,0xc4,0x22,0x44,0x22,0x44,0x3b,0xdc,0x20,0x04,0x02,0x40,0x02,0x40,0x02,0x42,0x04,0x42,0x18,0x42,0x60,0x3e}}, // 兜
{0x3376,0x8A96,0xB3F6,0xE7AB83,0x7AC3,{0x01,0x00,0x3f,0xfe,0x25,0x24,0x4b,0xde,0x11,0x00,0x7f,0xfe,0x09,0x10,0x0f,0xf0,0x09,0x10,0x1f,0xf8,0x11,0x08,0x1f,0xf8,0x11,0x08,0x1f,0xfa,0x01,0x02,0x00,0xfe}}, // 竃
{0x3377,0x8A97,0xB3F7,0xE892B2,0x84B2,{0x02,0x20,0x02,0x20,0x7f,0xff,0x02,0x28,0x18,0x24,0x07,0xfe,0x00,0x20,0x61,0xfc,0x11,0x24,0x01,0xfc,0x09,0x24,0x09,0xfc,0x11,0x24,0x11,0x24,0x21,0x24,0x41,0x2c}}, // 蒲
{0x3378,0x8A98,0xB3F8,0xE9879C,0x91DC,{0x02,0x20,0x04,0x18,0x0a,0x24,0x31,0x42,0x00,0x80,0x03,0x60,0x0c,0x18,0x77,0xf7,0x00,0x80,0x00,0x80,0x7f,0xff,0x08,0x88,0x04,0x88,0x04,0x90,0x3f,0xfe,0x00,0x00}}, // 釜
{0x3379,0x8A99,0xB3F9,0xE98E8C,0x938C,{0x08,0x88,0x08,0x50,0x17,0xff,0x12,0x50,0x21,0xfc,0x7e,0x54,0x08,0x54,0x09,0xff,0x7e,0x54,0x09,0xfc,0x48,0x58,0x2c,0xd4,0x28,0xd2,0x0f,0x51,0x1a,0x50,0x60,0x50}}, // 鎌
{0x337A,0x8A9A,0xB3FA,0xE5999B,0x565B,{0x00,0x20,0x01,0x20,0x79,0x3e,0x49,0x20,0x49,0x20,0x4f,0xff,0x4a,0x22,0x4a,0xaa,0x4a,0x72,0x4b,0xfe,0x4a,0x22,0x7a,0x72,0x4a,0xaa,0x03,0x22,0x03,0xfe,0x02,0x02}}, // 噛
{0x337B,0x8A9B,0xB3FB,0xE9B4A8,0x9D28,{0x00,0x20,0x7e,0x40,0x4a,0xfc,0x4a,0x84,0x4a,0xfc,0x7e,0x84,0x4a,0xfc,0x4a,0x80,0x4a,0xff,0x7e,0x80,0x08,0xfe,0x08,0x2a,0x09,0x96,0x09,0x52,0x0a,0x42,0x0c,0x0c}}, // 鴨
{0x337C,0x8A9C,0xB3FC,0xE6A0A2,0x6822,{0x08,0x00,0x0b,0xff,0x08,0x20,0x7e,0x20,0x08,0x40,0x08,0xfc,0x1c,0x84,0x1a,0x84,0x1a,0x84,0x28,0xfc,0x28,0x84,0x48,0x84,0x08,0x84,0x08,0x84,0x08,0xfc,0x08,0x84}}, // 栢
{0x337D,0x8A9D,0xB3FD,0xE88C85,0x8305,{0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x0f,0xf8,0x00,0x10,0x03,0x20,0x00,0xc0,0x7f,0xfe,0x00,0xc4,0x01,0x48,0x02,0x40,0x04,0x40,0x18,0x40,0x61,0xc0,0x00,0x40}}, // 茅
{0x337E,0x8A9E,0xB3FE,0xE890B1,0x8431,{0x08,0x20,0x08,0x20,0x7f,0xfe,0x08,0x20,0x01,0x00,0x3f,0xfe,0x20,0x04,0x5f,0xf8,0x00,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x00,0x00,0x7f,0xfe}}, // 萱
{0x3421,0x8A9F,0xB4A1,0xE7B2A5,0x7CA5,{0x00,0x00,0x78,0x9e,0x0c,0xa2,0x0a,0xa2,0x0a,0xc2,0x38,0x8e,0x27,0xf8,0x20,0x88,0x39,0xce,0x09,0xc2,0x0a,0xa2,0x0a,0xa2,0x0c,0x92,0x08,0x82,0x10,0x84,0x60,0x18}}, // 粥
{0x3422,0x8AA0,0xB4A2,0xE58888,0x5208,{0x01,0x02,0x01,0x22,0x01,0x22,0x01,0x22,0x21,0x22,0x11,0x22,0x0a,0x22,0x06,0x22,0x02,0x22,0x05,0x22,0x05,0x22,0x08,0x82,0x08,0x82,0x10,0x82,0x20,0x0e,0x40,0x02}}, // 刈
{0x3423,0x8AA1,0xB4A3,0xE88B85,0x82C5,{0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x02,0x12,0x01,0x02,0x31,0x22,0x09,0x22,0x06,0x22,0x02,0x22,0x05,0x22,0x05,0x22,0x08,0x82,0x10,0x82,0x20,0x8e,0x40,0x02}}, // 苅
{0x3424,0x8AA2,0xB4A4,0xE793A6,0x74E6,{0x00,0x00,0x3f,0xfe,0x02,0x00,0x02,0x00,0x02,0x00,0x03,0xf0,0x02,0x10,0x02,0x10,0x03,0x10,0x02,0x90,0x04,0x90,0x04,0x10,0x04,0x10,0x05,0xd2,0x0e,0x12,0x70,0x0e}}, // 瓦
{0x3425,0x8AA3,0xB4A5,0xE4B9BE,0x4E7E,{0x08,0x40,0x08,0x40,0x7f,0x40,0x08,0x7f,0x3e,0x40,0x22,0x80,0x22,0xfc,0x3f,0x04,0x22,0x08,0x22,0x10,0x3e,0x20,0x08,0x20,0x7f,0xc2,0x08,0x42,0x08,0x42,0x08,0x3e}}, // 乾
{0x3426,0x8AA4,0xB4A6,0xE4BE83,0x4F83,{0x04,0x00,0x05,0xfc,0x05,0x04,0x09,0x04,0x09,0x04,0x11,0xfc,0x10,0x00,0x31,0x24,0x51,0x24,0x11,0x24,0x11,0x24,0x11,0x24,0x11,0x24,0x12,0x25,0x12,0x25,0x14,0x03}}, // 侃
{0x3427,0x8AA5,0xB4A7,0xE586A0,0x51A0,{0x00,0x00,0x3f,0xfe,0x20,0x04,0x40,0x00,0x3f,0x08,0x00,0x08,0x00,0xfe,0x7f,0x08,0x12,0x88,0x12,0x48,0x12,0x48,0x12,0x08,0x12,0x08,0x22,0x1a,0x21,0x02,0x40,0xfe}}, // 冠
{0x3428,0x8AA6,0xB4A8,0xE5AF92,0x5BD2,{0x01,0x00,0x01,0x00,0x7f,0xfe,0x40,0x02,0x44,0x42,0x1f,0xf8,0x04,0x40,0x1f,0xf8,0x04,0x40,0x7f,0xfe,0x04,0x20,0x19,0x98,0x60,0x46,0x0f,0x00,0x00,0xe0,0x00,0x10}}, // 寒
{0x3429,0x8AA7,0xB4A9,0xE5888A,0x520A,{0x00,0x02,0x3f,0xa2,0x04,0x22,0x04,0x22,0x04,0x22,0x04,0x22,0x7f,0xe2,0x04,0x22,0x04,0x22,0x04,0x22,0x04,0x22,0x04,0x02,0x04,0x02,0x04,0x02,0x04,0x0e,0x04,0x02}}, // 刊
{0x342A,0x8AA8,0xB4AA,0xE58B98,0x52D8,{0x11,0x10,0x11,0x10,0x7f,0x90,0x11,0x10,0x1f,0x7e,0x11,0x12,0x1f,0x12,0x11,0x12,0x7f,0x92,0x2a,0x12,0x2a,0x12,0x2a,0xa2,0x31,0xa2,0x20,0x22,0x3f,0x42,0x20,0x8c}}, // 勘
{0x342B,0x8AA9,0xB4AB,0xE58BA7,0x52E7,{0x10,0x10,0x10,0x10,0x1f,0x90,0x24,0x10,0x24,0x7e,0x5f,0x92,0x09,0x12,0x12,0x12,0x3f,0x92,0x52,0x12,0x1f,0x22,0x12,0x22,0x1f,0x22,0x12,0x42,0x1f,0xc2,0x10,0x8c}}, // 勧
{0x342C,0x8AAA,0xB4AC,0xE5B7BB,0x5DFB,{0x08,0x88,0x04,0x88,0x04,0x90,0x1f,0xfe,0x00,0x80,0x01,0x40,0x7f,0xff,0x02,0x20,0x07,0xf0,0x18,0x1c,0x60,0x13,0x07,0xf0,0x04,0x00,0x04,0x08,0x04,0x08,0x03,0xf8}}, // 巻
{0x342D,0x8AAB,0xB4AD,0xE5969A,0x559A,{0x00,0x80,0x00,0xf8,0x79,0x10,0x4a,0x20,0x4f,0xfc,0x4a,0xa4,0x4a,0xa4,0x4a,0xac,0x4a,0x9c,0x4b,0x04,0x7a,0x24,0x4f,0xff,0x00,0x20,0x00,0x50,0x01,0x8c,0x0e,0x03}}, // 喚
{0x342E,0x8AAC,0xB4AE,0xE5A0AA,0x582A,{0x00,0x84,0x10,0x84,0x13,0xff,0x10,0x84,0x10,0xfc,0x7c,0x84,0x10,0xfc,0x10,0x84,0x10,0x84,0x17,0xff,0x12,0x50,0x16,0x52,0x1a,0x8e,0x63,0x00,0x03,0xff,0x02,0x00}}, // 堪
{0x342F,0x8AAD,0xB4AF,0xE5A7A6,0x59E6,{0x01,0x00,0x01,0x00,0x3f,0xfc,0x02,0x20,0x04,0x40,0x0f,0x80,0x02,0x70,0x3c,0x08,0x04,0x10,0x7f,0xff,0x09,0x24,0x09,0x24,0x3d,0xf4,0x06,0x18,0x0b,0x2c,0x70,0xc2}}, // 姦
{0x3430,0x8AAE,0xB4B0,0xE5AE8C,0x5B8C,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x40,0x00,0x1f,0xf8,0x00,0x00,0x00,0x00,0x7f,0xfe,0x02,0x40,0x02,0x40,0x02,0x40,0x04,0x42,0x08,0x42,0x10,0x22,0x60,0x1e}}, // 完
{0x3431,0x8AAF,0xB4B1,0xE5AE98,0x5B98,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x4f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 官
{0x3432,0x8AB0,0xB4B2,0xE5AF9B,0x5BDB,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x24,0x24,0x3f,0xf8,0x44,0x20,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf2,0x02,0x42,0x0c,0x42,0x70,0x3e}}, // 寛
{0x3433,0x8AB1,0xB4B3,0xE5B9B2,0x5E72,{0x00,0x00,0x1f,0xfc,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x82,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 干
{0x3434,0x8AB2,0xB4B4,0xE5B9B9,0x5E79,{0x08,0x10,0x08,0x10,0x7f,0x28,0x08,0x28,0x3e,0x44,0x22,0x82,0x23,0x7d,0x3e,0x10,0x22,0x10,0x22,0x10,0x3f,0xff,0x08,0x10,0x7f,0x10,0x08,0x10,0x08,0x10,0x08,0x10}}, // 幹
{0x3435,0x8AB3,0xB4B5,0xE682A3,0x60A3,{0x01,0x00,0x01,0x00,0x3f,0xf8,0x21,0x08,0x3f,0xf8,0x01,0x00,0x3f,0xf8,0x21,0x08,0x3f,0xf8,0x21,0x08,0x01,0x00,0x14,0x88,0x14,0x84,0x24,0x12,0x42,0x12,0x01,0xf0}}, // 患
{0x3436,0x8AB4,0xB4B6,0xE6849F,0x611F,{0x00,0x48,0x00,0x44,0x1f,0xff,0x10,0x40,0x1f,0xa4,0x10,0x24,0x17,0x98,0x14,0x90,0x17,0xaa,0x20,0x46,0x40,0x82,0x12,0x44,0x12,0x42,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 感
{0x3437,0x8AB5,0xB4B7,0xE685A3,0x6163,{0x08,0x00,0x08,0xfe,0x08,0x92,0x0b,0xff,0x09,0x24,0x2d,0xfc,0x2a,0x00,0x2b,0xfc,0x49,0x04,0x09,0xfc,0x09,0x04,0x09,0xfc,0x09,0x04,0x09,0xfc,0x08,0x4c,0x0b,0x83}}, // 慣
{0x3438,0x8AB6,0xB4B8,0xE686BE,0x61BE,{0x08,0x14,0x08,0x12,0x09,0xff,0x09,0x10,0x29,0xf2,0x2d,0x0a,0x2b,0xec,0x29,0xa4,0x4a,0xed,0x0a,0x93,0x0c,0x21,0x09,0x50,0x09,0x52,0x0a,0x45,0x0c,0x45,0x08,0x3c}}, // 憾
{0x3439,0x8AB7,0xB4B9,0xE68F9B,0x63DB,{0x10,0x40,0x10,0x7c,0x10,0x88,0x7d,0x10,0x13,0xfe,0x16,0x52,0x12,0x52,0x12,0x52,0x1e,0x8e,0x73,0x22,0x12,0x22,0x17,0xff,0x10,0x60,0x10,0x90,0x11,0x0c,0x36,0x03}}, // 換
{0x343A,0x8AB8,0xB4BA,0xE695A2,0x6562,{0x00,0x20,0x3f,0xa0,0x04,0x20,0x04,0x3f,0x7f,0xa4,0x11,0x44,0x11,0x64,0x1f,0xa4,0x11,0x14,0x1f,0x14,0x11,0x18,0x11,0x88,0x1f,0x14,0x71,0x24,0x01,0x42,0x01,0x81}}, // 敢
{0x343B,0x8AB9,0xB4BB,0xE69F91,0x67D1,{0x08,0x44,0x08,0x44,0x08,0x44,0x7f,0x44,0x09,0xff,0x08,0x44,0x1c,0x44,0x1a,0x44,0x19,0x44,0x29,0x7c,0x28,0x44,0x48,0x44,0x08,0x44,0x08,0x44,0x08,0x7c,0x08,0x44}}, // 柑
{0x343C,0x8ABA,0xB4BC,0xE6A193,0x6853,{0x08,0x00,0x09,0xfe,0x08,0x00,0x7e,0x00,0x08,0xfc,0x08,0x84,0x1c,0x84,0x1a,0xfc,0x1a,0x84,0x28,0x84,0x28,0x84,0x48,0xfc,0x08,0x84,0x08,0x00,0x0b,0xff,0x08,0x00}}, // 桓
{0x343D,0x8ABB,0xB4BD,0xE6A3BA,0x68FA,{0x08,0x20,0x08,0x20,0x09,0xff,0x7d,0x02,0x09,0x00,0x0a,0xf8,0x1c,0x88,0x1a,0x88,0x1a,0xf8,0x28,0x80,0x28,0x80,0x48,0xfc,0x08,0x84,0x08,0x84,0x08,0xfc,0x08,0x84}}, // 棺
{0x343E,0x8ABC,0xB4BE,0xE6ACBE,0x6B3E,{0x08,0x20,0x08,0x20,0x7f,0x20,0x08,0x3f,0x08,0x42,0x3f,0x54,0x00,0x90,0x3f,0x10,0x00,0x10,0x7f,0x90,0x08,0x28,0x2a,0x28,0x29,0x24,0x49,0x44,0x08,0x82,0x19,0x01}}, // 款
{0x343F,0x8ABD,0xB4BF,0xE6AD93,0x6B53,{0x10,0x20,0x10,0x20,0x1f,0xa0,0x24,0x3f,0x44,0x22,0x7f,0xd4,0x09,0x58,0x12,0x90,0x1f,0x90,0x32,0x10,0x5f,0x28,0x12,0x28,0x1f,0x24,0x12,0x44,0x1f,0x82,0x11,0x01}}, // 歓
{0x3440,0x8ABE,0xB4C0,0xE6B197,0x6C57,{0x10,0x00,0x0b,0xfe,0x08,0x20,0x00,0x20,0x40,0x20,0x20,0x20,0x20,0x20,0x07,0xff,0x08,0x20,0x08,0x20,0x10,0x20,0x10,0x20,0x20,0x20,0x20,0x20,0x40,0x20,0x40,0x20}}, // 汗
{0x3441,0x8ABF,0xB4C1,0xE6BCA2,0x6F22,{0x10,0x88,0x08,0x88,0x0f,0xff,0x00,0x88,0x40,0x00,0x23,0xfe,0x22,0x22,0x02,0x22,0x0b,0xfe,0x08,0x20,0x13,0xfc,0x10,0x20,0x27,0xff,0x20,0x50,0x41,0x8c,0x46,0x03}}, // 漢
{0x3442,0x8AC0,0xB4C2,0xE6BE97,0x6F97,{0x10,0x00,0x0b,0xde,0x0a,0x52,0x03,0xde,0x42,0x52,0x22,0x52,0x23,0xde,0x02,0x02,0x0a,0xfa,0x0a,0x8a,0x12,0xfa,0x12,0x8a,0x22,0x8a,0x22,0xfa,0x42,0x8a,0x42,0x06}}, // 澗
{0x3443,0x8AC1,0xB4C3,0xE6BD85,0x6F45,{0x21,0x00,0x11,0x00,0x11,0xfe,0x01,0x40,0x42,0x40,0x23,0xff,0x24,0x88,0x01,0x10,0x03,0xfe,0x0d,0x10,0x11,0xfc,0x11,0x10,0x21,0xfc,0x21,0x10,0x41,0xff,0x41,0x00}}, // 潅
{0x3444,0x8AC2,0xB4C4,0xE792B0,0x74B0,{0x00,0x00,0x01,0xfc,0x7f,0x54,0x11,0x54,0x11,0xfc,0x10,0x00,0x17,0xff,0x7c,0x00,0x11,0xfc,0x11,0x04,0x11,0xfc,0x14,0xe2,0x19,0x54,0x76,0x4c,0x00,0x43,0x00,0x40}}, // 環
{0x3445,0x8AC3,0xB4C5,0xE79498,0x7518,{0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x07,0xf0,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x07,0xf0,0x04,0x10}}, // 甘
{0x3446,0x8AC4,0xB4C6,0xE79BA3,0x76E3,{0x00,0x20,0x3f,0x20,0x24,0x20,0x24,0x3f,0x3f,0x40,0x21,0x40,0x3f,0xbe,0x24,0x00,0x3f,0x00,0x00,0x00,0x1f,0xfc,0x12,0x24,0x12,0x24,0x12,0x24,0x7f,0xff,0x00,0x00}}, // 監
{0x3447,0x8AC5,0xB4C7,0xE79C8B,0x770B,{0x00,0x08,0x00,0x70,0x0f,0x80,0x00,0x80,0x1f,0xfc,0x01,0x00,0x7f,0xff,0x02,0x00,0x07,0xf8,0x0a,0x08,0x13,0xf8,0x22,0x08,0x03,0xf8,0x02,0x08,0x03,0xf8,0x02,0x08}}, // 看
{0x3448,0x8AC6,0xB4C8,0xE7ABBF,0x7AFF,{0x08,0x20,0x08,0x20,0x1f,0xbf,0x24,0x48,0x42,0x84,0x00,0x00,0x1f,0xfc,0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 竿
{0x3449,0x8AC7,0xB4C9,0xE7AEA1,0x7BA1,{0x10,0x20,0x10,0x20,0x3f,0x7f,0x24,0x50,0x42,0x88,0x3f,0xfe,0x20,0x04,0x4f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 管
{0x344A,0x8AC8,0xB4CA,0xE7B0A1,0x7C21,{0x10,0x20,0x1f,0xbf,0x24,0x50,0x42,0x88,0x3f,0x7e,0x21,0x42,0x3f,0x7e,0x21,0x42,0x3f,0x7e,0x20,0x02,0x27,0xe2,0x24,0x22,0x27,0xe2,0x24,0x22,0x27,0xe2,0x20,0x06}}, // 簡
{0x344B,0x8AC9,0xB4CB,0xE7B7A9,0x7DE9,{0x08,0x04,0x08,0x1a,0x0b,0xe2,0x72,0x24,0x14,0x94,0x08,0x58,0x0d,0xfe,0x12,0x40,0x7d,0xff,0x08,0x40,0x2c,0x7c,0x2a,0xa4,0x2a,0x98,0x2b,0x10,0x48,0x6c,0x09,0x83}}, // 緩
{0x344C,0x8ACA,0xB4CC,0xE7BCB6,0x7F36,{0x08,0x00,0x08,0x00,0x08,0x00,0x0f,0xfc,0x10,0x80,0x10,0x80,0x20,0x80,0x40,0x80,0x7f,0xff,0x00,0x80,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x04}}, // 缶
{0x344D,0x8ACB,0xB4CD,0xE7BFB0,0x7FF0,{0x08,0x10,0x08,0x10,0x7f,0x28,0x08,0x44,0x3e,0x82,0x23,0xff,0x22,0x22,0x3f,0x32,0x22,0xaa,0x22,0xaa,0x3e,0x22,0x08,0x66,0x7f,0xaa,0x09,0x32,0x08,0x22,0x08,0x66}}, // 翰
{0x344E,0x8ACC,0xB4CE,0xE8829D,0x809D,{0x00,0x00,0x3e,0xfe,0x22,0x10,0x22,0x10,0x22,0x10,0x3e,0x10,0x22,0x10,0x23,0xff,0x22,0x10,0x3e,0x10,0x22,0x10,0x22,0x10,0x22,0x10,0x22,0x10,0x26,0x10,0x42,0x10}}, // 肝
{0x344F,0x8ACD,0xB4CF,0xE889A6,0x8266,{0x04,0x04,0x08,0xf4,0x3e,0xa4,0x22,0xa7,0x32,0xf8,0x2a,0x90,0x2a,0xf0,0x7f,0xaf,0x22,0xf0,0x32,0x00,0x2a,0xfe,0x2a,0xaa,0x2a,0xaa,0x22,0xaa,0x27,0xff,0x42,0x00}}, // 艦
{0x3450,0x8ACE,0xB4D0,0xE88E9E,0x839E,{0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x10,0x00,0x80,0x3f,0xfe,0x20,0x04,0x2f,0xf0,0x40,0x00,0x00,0x00,0x7f,0xfe,0x02,0x40,0x02,0x40,0x04,0x42,0x18,0x42,0x60,0x3e}}, // 莞
{0x3451,0x8ACF,0xB4D1,0xE8A6B3,0x89B3,{0x10,0x00,0x10,0x7e,0x3f,0x42,0x28,0x42,0x48,0x7e,0x7f,0xc2,0x12,0x42,0x14,0x7e,0x3f,0x42,0x64,0x42,0x3f,0x7e,0x24,0x28,0x3f,0x28,0x24,0x49,0x3f,0x89,0x21,0x07}}, // 観
{0x3452,0x8AD0,0xB4D2,0xE8AB8C,0x8ACC,{0x00,0x10,0x3c,0x10,0x01,0xff,0x7f,0x10,0x00,0xfc,0x3e,0x94,0x00,0x94,0x00,0xfc,0x3e,0x94,0x00,0x94,0x3e,0xfc,0x22,0x38,0x22,0x54,0x22,0x92,0x3f,0x11,0x22,0x10}}, // 諌
{0x3453,0x8AD1,0xB4D3,0xE8B2AB,0x8CAB,{0x00,0x00,0x0f,0xf8,0x08,0x88,0x7f,0xff,0x11,0x10,0x1f,0xf0,0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x04,0x18,0x38,0x06}}, // 貫
{0x3454,0x8AD2,0xB4D4,0xE98284,0x9084,{0x00,0x00,0x23,0xfc,0x12,0x94,0x13,0xfc,0x00,0x00,0x0f,0xff,0x00,0x00,0x79,0xf8,0x09,0x08,0x09,0xf8,0x08,0xc2,0x09,0x64,0x16,0x58,0x12,0x47,0x21,0xc0,0x40,0x7f}}, // 還
{0x3455,0x8AD3,0xB4D5,0xE99191,0x9451,{0x08,0x04,0x08,0xf4,0x14,0xa4,0x12,0xa7,0x20,0xf8,0x7e,0x90,0x08,0xf0,0x08,0xaf,0x7f,0xf0,0x08,0x00,0x4a,0xfe,0x2c,0xaa,0x29,0xaa,0x0e,0xaa,0x19,0xff,0x60,0x00}}, // 鑑
{0x3456,0x8AD4,0xB4D6,0xE99693,0x9593,{0x00,0x00,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x42,0x42,0x42,0x42,0x7e,0x7e,0x40,0x02,0x47,0xe2,0x44,0x22,0x47,0xe2,0x44,0x22,0x47,0xe2,0x44,0x22,0x40,0x06,0x40,0x02}}, // 間
{0x3457,0x8AD5,0xB4D7,0xE99691,0x9591,{0x00,0x00,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x41,0x02,0x41,0x02,0x5f,0xf2,0x41,0x02,0x43,0x82,0x45,0x42,0x49,0x22,0x51,0x12,0x41,0x06,0x40,0x02}}, // 閑
{0x3458,0x8AD6,0xB4D8,0xE996A2,0x95A2,{0x00,0x00,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x44,0x22,0x42,0x42,0x4f,0xf2,0x41,0x02,0x41,0x02,0x5f,0xfa,0x41,0x42,0x42,0x22,0x44,0x16,0x48,0x02}}, // 関
{0x3459,0x8AD7,0xB4D9,0xE999A5,0x9665,{0x00,0x20,0x3c,0x20,0x24,0x3c,0x24,0x44,0x28,0x48,0x30,0x88,0x28,0x10,0x29,0x3e,0x25,0x22,0x25,0x22,0x25,0x3e,0x25,0x22,0x39,0x22,0x21,0x22,0x21,0x3e,0x21,0x22}}, // 陥
{0x345A,0x8AD8,0xB4DA,0xE99F93,0x97D3,{0x08,0x10,0x08,0xfc,0x7f,0x24,0x08,0x24,0x3f,0xff,0x22,0x00,0x22,0xfc,0x3e,0x84,0x22,0xfe,0x22,0x08,0x3e,0x7e,0x08,0x48,0x7f,0x48,0x09,0xff,0x08,0x08,0x08,0x08}}, // 韓
{0x345B,0x8AD9,0xB4DB,0xE9A4A8,0x9928,{0x08,0x10,0x08,0x10,0x14,0xff,0x12,0x82,0x29,0x00,0x7e,0x7c,0x22,0x44,0x3e,0x44,0x22,0x7c,0x22,0x40,0x3e,0x40,0x24,0x7e,0x22,0x42,0x26,0x42,0x39,0x7e,0x60,0x42}}, // 館
{0x345C,0x8ADA,0xB4DC,0xE88898,0x8218,{0x08,0x10,0x08,0x10,0x14,0xff,0x12,0x82,0x21,0x00,0x5e,0x7c,0x08,0x44,0x08,0x44,0x7f,0x7c,0x08,0x40,0x3e,0x40,0x22,0x7e,0x22,0x42,0x22,0x42,0x3e,0x7e,0x22,0x42}}, // 舘
{0x345D,0x8ADB,0xB4DD,0xE4B8B8,0x4E38,{0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x7f,0xf0,0x02,0x10,0x02,0x10,0x0a,0x10,0x06,0x10,0x02,0x10,0x05,0x10,0x04,0x90,0x08,0x92,0x10,0x12,0x20,0x12,0x40,0x0e}}, // 丸
{0x345E,0x8ADC,0xB4DE,0xE590AB,0x542B,{0x00,0x80,0x00,0x80,0x01,0x40,0x02,0x20,0x07,0xf0,0x18,0x0c,0x60,0x03,0x0f,0xf0,0x00,0x10,0x00,0x20,0x00,0x40,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 含
{0x345F,0x8ADD,0xB4DF,0xE5B2B8,0x5CB8,{0x00,0x80,0x10,0x84,0x10,0x84,0x1f,0xfc,0x00,0x00,0x1f,0xff,0x10,0x00,0x17,0xfc,0x10,0x40,0x10,0x40,0x1f,0xff,0x10,0x40,0x20,0x40,0x20,0x40,0x40,0x40,0x00,0x40}}, // 岸
{0x3460,0x8ADE,0xB4E0,0xE5B78C,0x5DCC,{0x10,0x42,0x10,0x42,0x1f,0xfe,0x05,0x08,0x1f,0xff,0x17,0x90,0x12,0x10,0x1f,0xdf,0x14,0xa4,0x17,0xa4,0x14,0xd4,0x17,0x88,0x14,0x88,0x27,0x94,0x2c,0xa2,0x40,0xc1}}, // 巌
{0x3461,0x8ADF,0xB4E1,0xE78EA9,0x73A9,{0x00,0x00,0x00,0xfc,0x7e,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x13,0xff,0x7c,0x48,0x10,0x48,0x10,0x48,0x10,0x48,0x16,0x48,0x18,0x88,0x60,0x89,0x01,0x07,0x02,0x00}}, // 玩
{0x3462,0x8AE0,0xB4E2,0xE7998C,0x764C,{0x00,0x40,0x00,0x40,0x0f,0xfe,0x08,0x00,0x49,0xf8,0x29,0x08,0x29,0xf8,0x08,0x00,0x1f,0x9e,0x2c,0x92,0x4f,0xde,0x10,0x44,0x14,0x44,0x24,0x44,0x47,0xfc,0x04,0x04}}, // 癌
{0x3463,0x8AE1,0xB4E3,0xE79CBC,0x773C,{0x00,0x00,0x3c,0xfc,0x24,0x84,0x24,0x84,0x24,0xfc,0x3c,0x84,0x24,0x84,0x24,0xfe,0x3c,0x92,0x24,0x94,0x24,0x94,0x24,0x88,0x3c,0x88,0x24,0xb4,0x00,0xc2,0x03,0x81}}, // 眼
{0x3464,0x8AE2,0xB4E4,0xE5B2A9,0x5CA9,{0x00,0x80,0x10,0x84,0x10,0x84,0x10,0x84,0x1f,0xfc,0x00,0x00,0x00,0x00,0x7f,0xff,0x02,0x00,0x04,0x00,0x0f,0xf8,0x14,0x08,0x64,0x08,0x04,0x08,0x07,0xf8,0x04,0x08}}, // 岩
{0x3465,0x8AE3,0xB4E5,0xE7BFAB,0x7FEB,{0x00,0x00,0x7f,0xbe,0x08,0x80,0x4c,0x80,0x2a,0x80,0x19,0x80,0x6e,0xff,0x19,0x94,0x08,0x14,0x3f,0x14,0x21,0x14,0x3f,0x14,0x21,0x14,0x21,0x25,0x3f,0x25,0x21,0x43}}, // 翫
{0x3466,0x8AE4,0xB4E6,0xE8B48B,0x8D0B,{0x00,0x00,0x1f,0xfe,0x12,0x48,0x12,0xfe,0x15,0x90,0x1e,0xfc,0x14,0x90,0x17,0xff,0x12,0x08,0x13,0xf8,0x12,0x08,0x13,0xf8,0x22,0x08,0x23,0xf8,0x43,0x18,0x1c,0x06}}, // 贋
{0x3467,0x8AE5,0xB4E7,0xE99B81,0x96C1,{0x00,0x00,0x1f,0xff,0x11,0x20,0x11,0x24,0x11,0x48,0x12,0x7e,0x12,0xc8,0x17,0x48,0x1a,0x7e,0x12,0x48,0x12,0x48,0x12,0x7e,0x22,0x48,0x22,0x48,0x42,0x7f,0x02,0x40}}, // 雁
{0x3468,0x8AE6,0xB4E8,0xE9A091,0x9811,{0x00,0x00,0x01,0xff,0x3e,0x10,0x00,0x20,0x00,0xfe,0x00,0x82,0x7f,0x82,0x14,0xfe,0x14,0x82,0x14,0xfe,0x14,0x82,0x15,0x82,0x26,0xfe,0x24,0x24,0x40,0xc2,0x03,0x01}}, // 頑
{0x3469,0x8AE7,0xB4E9,0xE9A194,0x9854,{0x08,0x00,0x08,0xff,0x7f,0x10,0x22,0x20,0x14,0x7e,0x3f,0x42,0x22,0x42,0x24,0x7e,0x29,0x42,0x22,0x7e,0x24,0x42,0x28,0xc2,0x21,0x7e,0x42,0x24,0x0c,0x42,0x31,0x81}}, // 顔
{0x346A,0x8AE8,0xB4EA,0xE9A198,0x9858,{0x00,0x00,0x3f,0xff,0x22,0x08,0x24,0x10,0x2f,0xbe,0x28,0xa2,0x2f,0xa2,0x28,0xbe,0x28,0xa2,0x2f,0xbe,0x22,0x22,0x2b,0x22,0x2a,0xbe,0x4a,0x54,0x52,0x22,0x06,0xc1}}, // 願
{0x346B,0x8AE9,0xB4EB,0xE4BC81,0x4F01,{0x00,0x80,0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x8c,0x60,0x83,0x00,0x80,0x08,0xfc,0x08,0x80,0x08,0x80,0x08,0x80,0x08,0x80,0x08,0x80,0x7f,0xff,0x00,0x00}}, // 企
{0x346C,0x8AEA,0xB4EC,0xE4BC8E,0x4F0E,{0x04,0x20,0x04,0x20,0x04,0x20,0x0f,0xff,0x08,0x20,0x18,0x20,0x18,0x20,0x2b,0xfc,0x48,0x84,0x08,0x48,0x08,0x48,0x08,0x30,0x08,0x30,0x08,0x48,0x08,0x84,0x0b,0x03}}, // 伎
{0x346D,0x8AEB,0xB4ED,0xE58DB1,0x5371,{0x04,0x00,0x07,0xf0,0x08,0x20,0x10,0x40,0x3f,0xfe,0x50,0x00,0x10,0x00,0x13,0xf8,0x12,0x08,0x12,0x08,0x12,0x08,0x12,0x30,0x22,0x02,0x22,0x02,0x41,0x02,0x00,0xfe}}, // 危
{0x346E,0x8AEC,0xB4EE,0xE5969C,0x559C,{0x01,0x00,0x7f,0xfe,0x01,0x00,0x3f,0xfc,0x00,0x00,0x1f,0xf8,0x10,0x08,0x1f,0xf8,0x08,0x10,0x04,0x20,0xff,0xff,0x00,0x00,0x1f,0xf8,0x10,0x08,0x1f,0xf8,0x10,0x08}}, // 喜
{0x346F,0x8AED,0xB4EF,0xE599A8,0x5668,{0x00,0x00,0x1f,0x7c,0x11,0x44,0x11,0x44,0x1f,0x7c,0x11,0x44,0x00,0x80,0x7f,0xff,0x01,0x40,0x06,0x30,0x18,0x0c,0x7f,0x7f,0x11,0x44,0x11,0x44,0x1f,0x7c,0x11,0x44}}, // 器
{0x3470,0x8AEE,0xB4F0,0xE59FBA,0x57FA,{0x04,0x10,0x04,0x10,0x3f,0xfe,0x04,0x10,0x07,0xf0,0x04,0x10,0x07,0xf0,0x04,0x10,0x7f,0xff,0x04,0x90,0x08,0x88,0x17,0xf4,0x60,0x83,0x00,0x80,0x3f,0xfe,0x00,0x00}}, // 基
{0x3471,0x8AEF,0xB4F1,0xE5A587,0x5947,{0x00,0x80,0x00,0x80,0x3f,0xfe,0x01,0x40,0x02,0x20,0x0c,0x18,0x00,0x00,0x7f,0xff,0x00,0x08,0x0f,0xc8,0x08,0x48,0x08,0x48,0x0f,0xc8,0x08,0x48,0x00,0x08,0x00,0x18}}, // 奇
{0x3472,0x8AF0,0xB4F2,0xE5AC89,0x5B09,{0x08,0x10,0x09,0xff,0x08,0x10,0x08,0xfe,0x7e,0x00,0x12,0xfe,0x12,0x82,0x12,0xfe,0x22,0x44,0x24,0x28,0x7d,0xff,0x06,0x00,0x0a,0xfe,0x10,0x82,0x60,0xfe,0x00,0x82}}, // 嬉
{0x3473,0x8AF1,0xB4F3,0xE5AF84,0x5BC4,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x21,0x04,0x5f,0xf8,0x01,0x80,0x02,0x40,0x0c,0x30,0x7f,0xfe,0x00,0x10,0x1f,0x90,0x10,0x90,0x10,0x90,0x1f,0x90,0x10,0x90,0x00,0x30}}, // 寄
{0x3474,0x8AF2,0xB4F4,0xE5B290,0x5C90,{0x10,0x20,0x10,0x20,0x13,0xff,0x54,0x20,0x54,0x20,0x54,0x20,0x57,0xfc,0x54,0x84,0x54,0x88,0x54,0x48,0x54,0x50,0x7c,0x30,0x44,0x30,0x40,0x48,0x01,0x84,0x06,0x03}}, // 岐
{0x3475,0x8AF3,0xB4F5,0xE5B88C,0x5E0C,{0x06,0x04,0x01,0x98,0x00,0x60,0x03,0xb0,0x3c,0x88,0x01,0x00,0x7f,0xff,0x02,0x40,0x04,0x40,0x0f,0xfe,0x14,0x42,0x24,0x42,0x44,0x42,0x04,0x42,0x04,0x4c,0x00,0x40}}, // 希
{0x3476,0x8AF4,0xB4F6,0xE5B9BE,0x5E7E,{0x08,0x90,0x08,0x90,0x32,0xe4,0x0a,0x94,0x04,0x88,0x0a,0x94,0x0e,0x9c,0x31,0xf2,0x00,0x88,0x7f,0xff,0x04,0x40,0x06,0x44,0x09,0x28,0x08,0x32,0x10,0xca,0x23,0x06}}, // 幾
{0x3477,0x8AF5,0xB4F7,0xE5BF8C,0x5FCC,{0x00,0x00,0x1f,0xf0,0x00,0x10,0x00,0x10,0x1f,0xf0,0x10,0x00,0x10,0x08,0x10,0x08,0x0f,0xf8,0x00,0x80,0x12,0x44,0x12,0x22,0x12,0x21,0x22,0x09,0x41,0x08,0x00,0xf8}}, // 忌
{0x3478,0x8AF6,0xB4F8,0xE68FAE,0x63EE,{0x10,0x00,0x11,0xfe,0x11,0x24,0x12,0x20,0x7d,0xfe,0x10,0x20,0x11,0xfc,0x11,0x24,0x1d,0xfc,0x71,0x24,0x11,0x24,0x11,0xfc,0x10,0x20,0x17,0xff,0x10,0x20,0x30,0x20}}, // 揮
{0x3479,0x8AF7,0xB4F9,0xE69CBA,0x673A,{0x08,0x00,0x08,0x78,0x08,0x48,0x7f,0x48,0x08,0x48,0x08,0x48,0x1c,0x48,0x1a,0x48,0x1a,0x48,0x28,0x48,0x28,0x88,0x48,0x88,0x09,0x08,0x09,0x09,0x0a,0x09,0x0c,0x07}}, // 机
{0x347A,0x8AF8,0xB4FA,0xE69797,0x65D7,{0x08,0x40,0x08,0x40,0x08,0x7f,0x7e,0x80,0x11,0x44,0x13,0xff,0x10,0x44,0x1e,0x7c,0x12,0x44,0x12,0x7c,0x12,0x44,0x13,0xff,0x22,0x08,0x22,0x24,0x42,0x42,0x0d,0x82}}, // 旗
{0x347B,0x8AF9,0xB4FB,0xE697A2,0x65E2,{0x00,0x00,0x3e,0xfe,0x22,0x48,0x22,0x48,0x3e,0x48,0x22,0x48,0x22,0x48,0x3f,0xff,0x20,0x18,0x24,0x18,0x22,0x18,0x22,0x28,0x2d,0x28,0x31,0x49,0x60,0x89,0x03,0x07}}, // 既
{0x347C,0x8AFA,0xB4FC,0xE69C9F,0x671F,{0x11,0x00,0x11,0x3e,0x7f,0xe2,0x11,0x22,0x11,0x22,0x1f,0x3e,0x11,0x22,0x11,0x22,0x1f,0x22,0x11,0x3e,0x11,0x22,0x7f,0xe2,0x12,0x22,0x11,0x42,0x21,0x46,0x40,0x82}}, // 期
{0x347D,0x8AFB,0xB4FD,0xE6A38B,0x68CB,{0x08,0x44,0x08,0x44,0x09,0xff,0x7f,0x44,0x08,0x44,0x08,0x7c,0x1c,0x44,0x1a,0x44,0x19,0x7c,0x28,0x44,0x28,0x44,0x4b,0xff,0x08,0x08,0x08,0x44,0x08,0x82,0x0b,0x02}}, // 棋
{0x347E,0x8AFC,0xB4FE,0xE6A384,0x68C4,{0x00,0x80,0x7f,0xff,0x01,0x30,0x02,0x0c,0x1f,0xfa,0x08,0x88,0x7f,0xff,0x08,0x88,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80}}, // 棄
{0x3521,0x8B40,0xB5A1,0xE6A99F,0x6A5F,{0x08,0xa4,0x08,0xa4,0x0b,0x78,0x7c,0xa4,0x08,0xaa,0x09,0x7d,0x1b,0xe4,0x1c,0x22,0x1b,0xff,0x28,0x94,0x28,0x94,0x48,0xc8,0x09,0x29,0x09,0x15,0x0a,0x23,0x0c,0x41}}, // 機
{0x3522,0x8B41,0xB5A2,0xE5B8B0,0x5E30,{0x08,0x00,0x09,0xfc,0x08,0x04,0x28,0xfc,0x28,0x04,0x29,0xfc,0x28,0x00,0x2b,0xff,0x2a,0x21,0x4a,0x21,0x09,0xfc,0x09,0x24,0x09,0x24,0x11,0x24,0x11,0x2c,0x20,0x20}}, // 帰
{0x3523,0x8B42,0xB5A3,0xE6AF85,0x6BC5,{0x04,0x00,0x04,0x3c,0x3f,0xa4,0x11,0x24,0x0a,0x25,0x7f,0xa5,0x08,0x43,0x14,0x80,0x25,0x7c,0x0b,0x24,0x13,0x24,0x26,0x94,0x0a,0x48,0x12,0x14,0x22,0x62,0x0d,0x81}}, // 毅
{0x3524,0x8B43,0xB5A4,0xE6B097,0x6C17,{0x08,0x00,0x08,0x00,0x0f,0xfe,0x10,0x00,0x17,0xf8,0x20,0x00,0x40,0x00,0x1f,0xf8,0x00,0x48,0x0c,0x48,0x02,0x88,0x01,0x88,0x02,0x45,0x04,0x25,0x18,0x03,0x60,0x01}}, // 気
{0x3525,0x8B44,0xB5A5,0xE6B1BD,0x6C7D,{0x11,0x00,0x09,0x00,0x09,0xfe,0x02,0x00,0x02,0xf8,0x44,0x00,0x20,0x00,0x27,0xf8,0x00,0x08,0x08,0x08,0x10,0x08,0x10,0x08,0x20,0x05,0x20,0x05,0x40,0x03,0x40,0x01}}, // 汽
{0x3526,0x8B45,0xB5A6,0xE795BF,0x757F,{0x08,0x90,0x0a,0x94,0x32,0xe4,0x0c,0x98,0x04,0x88,0x0a,0x94,0x3e,0xbe,0x01,0x52,0x7f,0xff,0x1f,0x48,0x15,0x48,0x1f,0x30,0x15,0x12,0x15,0x2a,0x1f,0x46,0x01,0x82}}, // 畿
{0x3527,0x8B46,0xB5A7,0xE7A588,0x7948,{0x08,0x04,0x08,0x18,0x08,0xe0,0x7e,0x80,0x02,0x80,0x04,0xff,0x04,0x88,0x08,0x88,0x1c,0x88,0x2a,0x88,0x49,0x88,0x08,0x88,0x09,0x08,0x09,0x08,0x0a,0x08,0x08,0x08}}, // 祈
{0x3528,0x8B47,0xB5A8,0xE5ADA3,0x5B63,{0x00,0x08,0x00,0x30,0x1f,0xc0,0x00,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x0c,0x98,0x70,0x87,0x07,0xf0,0x00,0x40,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x01,0x80}}, // 季
{0x3529,0x8B48,0xB5A9,0xE7A880,0x7A00,{0x02,0x04,0x0c,0x64,0x78,0x18,0x09,0xe4,0x08,0x20,0x7f,0xff,0x08,0x50,0x1c,0x50,0x1a,0xfe,0x18,0xd2,0x29,0x52,0x2a,0x52,0x48,0x52,0x08,0x5c,0x08,0x50,0x08,0x10}}, // 稀
{0x352A,0x8B49,0xB5AA,0xE7B480,0x7D00,{0x08,0x00,0x08,0x7e,0x0a,0x02,0x72,0x02,0x14,0x02,0x08,0x02,0x0c,0x7e,0x12,0x40,0x7d,0x40,0x09,0x40,0x28,0x40,0x2a,0x40,0x29,0x41,0x29,0x21,0x48,0x1f,0x08,0x00}}, // 紀
{0x352B,0x8B4A,0xB5AB,0xE5BEBD,0x5FBD,{0x09,0x10,0x0d,0x50,0x15,0x50,0x17,0xdf,0x21,0x24,0x49,0x24,0x0a,0xd4,0x16,0x94,0x11,0x54,0x37,0xd4,0x51,0x28,0x15,0x88,0x15,0x4c,0x15,0x14,0x19,0x22,0x11,0x41}}, // 徽
{0x352C,0x8B4B,0xB5AC,0xE8A68F,0x898F,{0x08,0x00,0x08,0xfc,0x08,0x84,0x3f,0x84,0x08,0xfc,0x08,0x84,0x08,0x84,0x7f,0xfc,0x08,0x84,0x0c,0x84,0x14,0xfc,0x12,0x50,0x12,0x50,0x20,0x91,0x21,0x09,0x46,0x07}}, // 規
{0x352D,0x8B4C,0xB5AD,0xE8A898,0x8A18,{0x00,0x00,0x3e,0x7e,0x00,0x02,0x7f,0x82,0x00,0x02,0x3f,0x02,0x00,0x7e,0x3f,0x40,0x00,0x40,0x00,0x40,0x3f,0x40,0x21,0x40,0x21,0x41,0x21,0x21,0x3f,0x1f,0x21,0x00}}, // 記
{0x352E,0x8B4D,0xB5AE,0xE8B2B4,0x8CB4,{0x00,0x80,0x0f,0xf0,0x08,0x90,0x0f,0xf0,0x00,0x80,0x7f,0xfe,0x00,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x06,0x18,0x38,0x04}}, // 貴
{0x352F,0x8B4E,0xB5AF,0xE8B5B7,0x8D77,{0x04,0x00,0x04,0x3e,0x3f,0x82,0x04,0x02,0x04,0x02,0x04,0x02,0x7f,0xfe,0x04,0x20,0x14,0x20,0x17,0xa0,0x14,0x21,0x1c,0x11,0x14,0x0f,0x26,0x00,0x21,0xc0,0x40,0x3f}}, // 起
{0x3530,0x8B4F,0xB5B0,0xE8BB8C,0x8ECC,{0x04,0x20,0x04,0x20,0x7f,0xa0,0x04,0x20,0x3f,0xfc,0x25,0x24,0x25,0x24,0x3f,0x24,0x25,0x24,0x25,0x24,0x3f,0x24,0x04,0x24,0x7f,0xc4,0x04,0x45,0x04,0x85,0x05,0x03}}, // 軌
{0x3531,0x8B50,0xB5B1,0xE8BC9D,0x8F1D,{0x08,0x00,0x08,0x7f,0x4a,0x52,0x2a,0x90,0x2a,0xfe,0x2c,0x10,0x08,0x7e,0x7f,0x52,0x14,0x7e,0x14,0x52,0x14,0x52,0x15,0x7e,0x26,0x10,0x25,0xff,0x40,0x10,0x00,0x10}}, // 輝
{0x3532,0x8B51,0xB5B2,0xE9A3A2,0x98E2,{0x04,0x00,0x04,0x78,0x0a,0x48,0x09,0x48,0x14,0xc8,0x3f,0x48,0x51,0x48,0x1f,0x48,0x11,0x48,0x11,0x48,0x1f,0x48,0x14,0x48,0x12,0x49,0x13,0x49,0x1c,0x87,0x31,0x00}}, // 飢
{0x3533,0x8B52,0xB5B3,0xE9A88E,0x9A0E,{0x00,0x10,0x3f,0x10,0x24,0xfe,0x24,0x10,0x3f,0x28,0x24,0x44,0x24,0x80,0x3f,0xff,0x24,0x02,0x24,0x3a,0x3f,0xaa,0x14,0xaa,0x2a,0xba,0x2a,0xaa,0x20,0x86,0x43,0x02}}, // 騎
{0x3534,0x8B53,0xB5B4,0xE9ACBC,0x9B3C,{0x01,0x00,0x02,0x00,0x1f,0xf8,0x11,0x08,0x11,0x08,0x1f,0xf8,0x11,0x08,0x11,0x08,0x1f,0xf8,0x02,0x90,0x02,0x90,0x04,0xa8,0x04,0xf8,0x08,0x8a,0x10,0x42,0x60,0x3e}}, // 鬼
{0x3535,0x8B54,0xB5B5,0xE4BA80,0x4E80,{0x02,0x00,0x07,0xf0,0x08,0x20,0x1f,0xf8,0x68,0x88,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x00,0x80,0x1f,0xfc,0x10,0x84,0x1f,0xfc,0x10,0x84,0x1f,0xfd,0x00,0x81,0x00,0x7f}}, // 亀
{0x3536,0x8B55,0xB5B6,0xE581BD,0x507D,{0x0a,0x20,0x09,0x20,0x09,0x20,0x0b,0xf8,0x10,0x48,0x10,0x48,0x10,0xfc,0x30,0x84,0x51,0x04,0x11,0xfe,0x12,0x12,0x15,0x4a,0x1a,0xaa,0x12,0xa2,0x14,0x02,0x10,0x0c}}, // 偽
{0x3537,0x8B56,0xB5B7,0xE58480,0x5100,{0x09,0x08,0x08,0x90,0x1b,0xfe,0x10,0x20,0x11,0xf8,0x30,0x20,0x37,0xff,0x50,0x58,0x13,0x94,0x11,0x10,0x17,0xff,0x11,0x12,0x11,0xcc,0x17,0x0a,0x11,0x16,0x13,0x62}}, // 儀
{0x3538,0x8B57,0xB5B8,0xE5A693,0x5993,{0x08,0x10,0x08,0x10,0x09,0xff,0x08,0x10,0x7f,0x10,0x12,0x10,0x12,0xfc,0x12,0x44,0x22,0x44,0x24,0x28,0x7c,0x28,0x06,0x10,0x09,0x28,0x10,0x44,0x60,0x82,0x03,0x01}}, // 妓
{0x3539,0x8B58,0xB5B9,0xE5AE9C,0x5B9C,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x20,0x00,0x4f,0xe0,0x08,0x20,0x08,0x20,0x0f,0xe0,0x08,0x20,0x08,0x20,0x0f,0xe0,0x08,0x20,0x08,0x20,0x7f,0xfe,0x00,0x00}}, // 宜
{0x353A,0x8B59,0xB5BA,0xE688AF,0x622F,{0x08,0x18,0x0f,0x14,0x08,0x14,0x3f,0xd3,0x28,0x9c,0x2e,0x72,0x38,0x92,0x27,0x92,0x2a,0x14,0x2a,0x94,0x2b,0x08,0x3a,0x08,0x2a,0x95,0x2b,0x25,0x4c,0x43,0x30,0x01}}, // 戯
{0x353B,0x8B5A,0xB5BB,0xE68A80,0x6280,{0x10,0x20,0x10,0x20,0x10,0x20,0x13,0xff,0x7c,0x20,0x10,0x20,0x10,0x20,0x13,0xfc,0x10,0x84,0x1c,0x88,0x70,0x48,0x10,0x30,0x10,0x30,0x10,0x48,0x31,0x84,0x16,0x03}}, // 技
{0x353C,0x8B5B,0xB5BC,0xE693AC,0x64EC,{0x12,0x00,0x12,0x7e,0x13,0x82,0x12,0x14,0x7a,0x48,0x11,0xff,0x12,0x09,0x13,0xca,0x15,0x28,0x79,0x2e,0x17,0xe8,0x11,0x28,0x11,0xb8,0x12,0x68,0x34,0x44,0x18,0x83}}, // 擬
{0x353D,0x8B5C,0xB5BD,0xE6ACBA,0x6B3A,{0x11,0x20,0x11,0x20,0x7f,0xa0,0x11,0x3f,0x11,0x22,0x1f,0x54,0x11,0x50,0x11,0x90,0x1f,0x10,0x11,0x10,0x11,0x18,0x7f,0xa8,0x12,0x24,0x11,0x44,0x20,0x82,0x43,0x01}}, // 欺
{0x353E,0x8B5D,0xB5BE,0xE78AA0,0x72A0,{0x08,0x84,0x08,0x48,0x29,0xfe,0x28,0x20,0x3e,0xfc,0x28,0x20,0x2b,0xff,0x48,0x24,0x09,0xca,0x0c,0x48,0x1b,0xff,0x68,0x4a,0x08,0x64,0x0b,0xcd,0x08,0x73,0x08,0xc1}}, // 犠
{0x353F,0x8B5E,0xB5BF,0xE79691,0x7591,{0x20,0x00,0x22,0x7e,0x3c,0x24,0x21,0x18,0x21,0x08,0x1f,0xff,0x10,0x12,0x1f,0x14,0x24,0x50,0x44,0x5e,0x3f,0xd0,0x04,0x50,0x0a,0x70,0x09,0x90,0x10,0x8c,0x21,0x03}}, // 疑
{0x3540,0x8B5F,0xB5C0,0xE7A587,0x7947,{0x08,0x04,0x08,0x18,0x08,0xf0,0x7e,0x90,0x02,0x90,0x04,0x90,0x04,0x90,0x08,0xff,0x1c,0x90,0x2a,0x88,0x49,0x88,0x08,0x88,0x08,0x84,0x08,0xb5,0x08,0xc3,0x0b,0x01}}, // 祇
{0x3541,0x8B60,0xB5C1,0xE7BEA9,0x7FA9,{0x04,0x10,0x02,0x20,0x3f,0xfe,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x03,0x28,0x3c,0x24,0x04,0x20,0x7f,0xff,0x04,0x12,0x07,0x94,0x7c,0x09,0x04,0x35,0x0c,0xc3}}, // 義
{0x3542,0x8B61,0xB5C2,0xE89FBB,0x87FB,{0x08,0x44,0x08,0x28,0x08,0xfe,0x08,0x10,0x3e,0xfe,0x2a,0x10,0x2b,0xff,0x2a,0x2c,0x3f,0xca,0x08,0x48,0x0d,0xff,0x0a,0x4a,0x0a,0x6a,0x0f,0xc5,0x79,0x4b,0x00,0xd1}}, // 蟻
{0x3543,0x8B62,0xB5C3,0xE8AABC,0x8ABC,{0x00,0x20,0x3c,0x20,0x00,0xff,0x7e,0x82,0x01,0x00,0x3c,0xfc,0x00,0x84,0x00,0x84,0x3c,0xfc,0x00,0x84,0x3c,0x84,0x24,0xfc,0x24,0x84,0x24,0x84,0x3f,0xff,0x24,0x00}}, // 誼
{0x3544,0x8B63,0xB5C4,0xE8ADB0,0x8B70,{0x00,0x44,0x3c,0x28,0x00,0xfe,0x7e,0x10,0x00,0xfc,0x3c,0x10,0x03,0xff,0x00,0x2c,0x3d,0xca,0x00,0x48,0x3d,0xff,0x24,0x4a,0x24,0x6a,0x25,0xc5,0x3c,0x4b,0x24,0xd1}}, // 議
{0x3545,0x8B64,0xB5C5,0xE68EAC,0x63AC,{0x11,0x00,0x11,0x00,0x11,0x00,0x11,0xfe,0x7e,0x02,0x12,0x4a,0x15,0x52,0x11,0x42,0x1b,0xfe,0x70,0x42,0x10,0xe2,0x10,0xd2,0x11,0x4a,0x12,0x42,0x10,0x44,0x30,0x18}}, // 掬
{0x3546,0x8B65,0xB5C6,0xE88F8A,0x83CA,{0x04,0x20,0x04,0x20,0x7f,0xff,0x04,0x20,0x08,0x00,0x0f,0xfe,0x19,0x02,0x15,0x22,0x25,0x42,0x7f,0xfa,0x03,0x82,0x05,0x42,0x09,0x22,0x31,0x12,0x01,0x04,0x00,0x18}}, // 菊
{0x3547,0x8B66,0xB5C7,0xE99EA0,0x97A0,{0x14,0x40,0x14,0x40,0x7e,0xfe,0x14,0x82,0x15,0x2a,0x1e,0xaa,0x08,0xb2,0x3f,0xfe,0x2a,0x22,0x2a,0x72,0x3e,0x6a,0x08,0xa6,0x7f,0xa2,0x09,0x22,0x08,0x24,0x08,0x18}}, // 鞠
{0x3548,0x8B67,0xB5C8,0xE59089,0x5409,{0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x00,0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 吉
{0x3549,0x8B68,0xB5C9,0xE59083,0x5403,{0x00,0x80,0x00,0x80,0x78,0x80,0x49,0xff,0x49,0x00,0x49,0x00,0x4a,0xfc,0x4c,0x08,0x48,0x10,0x48,0x20,0x48,0x40,0x78,0x80,0x49,0x02,0x01,0x02,0x01,0x02,0x00,0xfe}}, // 吃
{0x354A,0x8B69,0xB5CA,0xE596AB,0x55AB,{0x01,0x00,0x01,0x3e,0x7f,0xca,0x49,0x0a,0x49,0x0a,0x4f,0xca,0x49,0x12,0x49,0xd2,0x4e,0x2c,0x48,0x40,0x7f,0xff,0x48,0x40,0x00,0xa0,0x01,0x10,0x06,0x0c,0x18,0x03}}, // 喫
{0x354B,0x8B6A,0xB5CB,0xE6A194,0x6854,{0x08,0x20,0x08,0x20,0x08,0x20,0x7f,0xff,0x08,0x20,0x08,0x20,0x1c,0x20,0x1b,0xfe,0x1a,0x00,0x28,0x00,0x28,0xfc,0x48,0x84,0x08,0x84,0x08,0x84,0x08,0xfc,0x08,0x84}}, // 桔
{0x354C,0x8B6B,0xB5CC,0xE6A998,0x6A58,{0x08,0x00,0x08,0xfc,0x08,0x48,0x7e,0x30,0x09,0xfe,0x08,0x54,0x18,0x90,0x1d,0x30,0x1b,0xfe,0x29,0x52,0x29,0x56,0x49,0x9e,0x09,0x7a,0x09,0x4a,0x09,0x7a,0x09,0x06}}, // 橘
{0x354D,0x8B6C,0xB5CD,0xE8A9B0,0x8A70,{0x00,0x20,0x3e,0x20,0x00,0x20,0x7f,0xff,0x00,0x20,0x3e,0x20,0x00,0x20,0x01,0xfe,0x3e,0x00,0x00,0x00,0x3e,0xfc,0x22,0x84,0x22,0x84,0x22,0x84,0x3e,0xfc,0x22,0x84}}, // 詰
{0x354E,0x8B6D,0xB5CE,0xE7A0A7,0x7827,{0x00,0x20,0x7f,0x20,0x08,0x20,0x08,0x20,0x08,0x3e,0x08,0x20,0x1e,0x20,0x12,0x20,0x32,0x20,0x32,0xfc,0x52,0x84,0x12,0x84,0x1e,0x84,0x12,0x84,0x10,0xfc,0x00,0x84}}, // 砧
{0x354F,0x8B6E,0xB5CF,0xE69DB5,0x6775,{0x08,0x40,0x08,0x40,0x08,0x40,0x7e,0x7e,0x08,0x90,0x08,0x90,0x1d,0x10,0x1a,0x10,0x1b,0xff,0x28,0x10,0x28,0x10,0x48,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10}}, // 杵
{0x3550,0x8B6F,0xB5D0,0xE9BB8D,0x9ECD,{0x00,0x08,0x00,0x70,0x1f,0x80,0x00,0x80,0x7f,0xff,0x02,0xa0,0x0c,0x98,0x71,0x47,0x02,0x20,0x0c,0x98,0x74,0x8f,0x02,0x90,0x03,0xe0,0x0c,0x98,0x30,0x86,0x01,0x80}}, // 黍
{0x3551,0x8B70,0xB5D1,0xE58DB4,0x5374,{0x04,0x00,0x04,0x3e,0x3f,0xa2,0x04,0x22,0x04,0x22,0x04,0x22,0x04,0x22,0x7f,0xe2,0x08,0x22,0x0a,0x22,0x09,0x22,0x11,0x22,0x13,0xac,0x7c,0xa0,0x00,0xa0,0x00,0x20}}, // 却
{0x3552,0x8B71,0xB5D2,0xE5AEA2,0x5BA2,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x22,0x04,0x43,0xe0,0x04,0x20,0x0a,0x40,0x31,0x80,0x02,0x40,0x04,0x20,0x1f,0xf8,0x68,0x16,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10}}, // 客
{0x3553,0x8B72,0xB5D3,0xE8849A,0x811A,{0x00,0x80,0x3c,0x9e,0x24,0x92,0x27,0xf2,0x24,0x92,0x3c,0x92,0x24,0x92,0x27,0xf2,0x24,0x92,0x3c,0x92,0x24,0xd2,0x25,0x52,0x25,0x7c,0x27,0xb0,0x24,0x30,0x4c,0x10}}, // 脚
{0x3554,0x8B73,0xB5D4,0xE89990,0x8650,{0x00,0x40,0x00,0x7e,0x00,0x40,0x1f,0xfe,0x11,0x04,0x11,0xf8,0x1f,0x02,0x11,0xfe,0x10,0x00,0x17,0xfc,0x14,0x00,0x17,0xfc,0x24,0x00,0x24,0x00,0x47,0xfe,0x04,0x00}}, // 虐
{0x3555,0x8B74,0xB5D5,0xE98086,0x9006,{0x01,0x08,0x20,0x88,0x10,0x90,0x17,0xff,0x00,0x20,0x01,0x24,0x01,0x24,0x79,0x24,0x09,0x24,0x09,0xfc,0x09,0x24,0x08,0x20,0x0c,0x40,0x14,0x80,0x23,0x00,0x40,0xff}}, // 逆
{0x3556,0x8B75,0xB5D6,0xE4B898,0x4E18,{0x00,0x10,0x00,0xe0,0x0f,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x0f,0xfc,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x7f,0xfe,0x00,0x00}}, // 丘
{0x3557,0x8B76,0xB5D7,0xE4B985,0x4E45,{0x01,0x00,0x01,0x00,0x01,0xf0,0x02,0x10,0x02,0x10,0x04,0x20,0x08,0x20,0x10,0x40,0x00,0x40,0x00,0xc0,0x00,0xa0,0x01,0x20,0x02,0x10,0x04,0x08,0x18,0x04,0x60,0x03}}, // 久
{0x3558,0x8B77,0xB5D8,0xE4BB87,0x4EC7,{0x04,0x80,0x04,0x80,0x04,0x80,0x08,0x80,0x08,0xf0,0x0f,0x90,0x10,0x90,0x30,0x90,0x50,0x90,0x10,0x90,0x10,0x90,0x11,0x12,0x11,0x12,0x12,0x12,0x14,0x0e,0x18,0x00}}, // 仇
{0x3559,0x8B78,0xB5D9,0xE4BC91,0x4F11,{0x08,0x40,0x08,0x40,0x08,0x40,0x08,0x40,0x17,0xfe,0x10,0xe0,0x10,0xe0,0x31,0x50,0x51,0x50,0x12,0x48,0x12,0x44,0x14,0x42,0x18,0x41,0x10,0x40,0x10,0x40,0x10,0x40}}, // 休
{0x355A,0x8B79,0xB5DA,0xE58F8A,0x53CA,{0x00,0x00,0x3f,0xe0,0x04,0x20,0x04,0x40,0x04,0x40,0x06,0xf0,0x06,0x10,0x05,0x10,0x05,0x10,0x08,0xa0,0x08,0x60,0x08,0x40,0x10,0xa0,0x11,0x10,0x22,0x08,0x4c,0x06}}, // 及
{0x355B,0x8B7A,0xB5DB,0xE590B8,0x5438,{0x00,0x00,0x01,0xf8,0x7c,0x88,0x44,0x90,0x44,0x90,0x44,0xbc,0x44,0xc4,0x44,0xc4,0x44,0xa4,0x45,0x28,0x7d,0x28,0x45,0x10,0x42,0x28,0x02,0x44,0x04,0x82,0x09,0x01}}, // 吸
{0x355C,0x8B7B,0xB5DC,0xE5AEAE,0x5BAE,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x4f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x01,0x00,0x02,0x00,0x1f,0xf8,0x10,0x08,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x08}}, // 宮
{0x355D,0x8B7C,0xB5DD,0xE5BC93,0x5F13,{0x00,0x00,0x3f,0xf0,0x00,0x10,0x00,0x10,0x00,0x10,0x1f,0xf0,0x10,0x00,0x10,0x00,0x10,0x00,0x1f,0xf8,0x10,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x10,0x00,0xe0}}, // 弓
{0x355E,0x8B7D,0xB5DE,0xE680A5,0x6025,{0x01,0x00,0x03,0xe0,0x04,0x40,0x08,0x80,0x3f,0xf8,0x00,0x08,0x00,0x08,0x0f,0xf8,0x00,0x08,0x1f,0xf8,0x00,0x80,0x12,0x44,0x12,0x42,0x22,0x49,0x42,0x09,0x01,0xf8}}, // 急
{0x355F,0x8B7E,0xB5DF,0xE69591,0x6551,{0x05,0x20,0x04,0xa0,0x04,0x20,0x7f,0xbf,0x04,0x24,0x44,0xa4,0x25,0x44,0x25,0x44,0x0e,0xa4,0x0e,0x28,0x15,0x18,0x15,0x10,0x24,0xa8,0x44,0x44,0x0c,0x82,0x05,0x01}}, // 救
{0x3560,0x8B80,0xB5E0,0xE69CBD,0x673D,{0x08,0x00,0x0b,0xff,0x08,0x20,0x7e,0x20,0x08,0x20,0x08,0x40,0x1c,0x7c,0x1a,0x84,0x1a,0x84,0x28,0x04,0x28,0x04,0x48,0x04,0x08,0x04,0x08,0x04,0x08,0x08,0x08,0x30}}, // 朽
{0x3561,0x8B81,0xB5E1,0xE6B182,0x6C42,{0x00,0x90,0x00,0x88,0x00,0x88,0x7f,0xff,0x00,0x80,0x10,0x84,0x08,0xc4,0x04,0xc4,0x04,0xa8,0x00,0xa8,0x01,0x90,0x02,0x88,0x04,0x84,0x18,0x82,0x61,0x81,0x00,0x80}}, // 求
{0x3562,0x8B82,0xB5E2,0xE6B1B2,0x6C72,{0x10,0x00,0x0b,0xf8,0x08,0x88,0x00,0x88,0x40,0x90,0x20,0x9c,0x20,0x84,0x00,0xc4,0x09,0x48,0x09,0x28,0x11,0x30,0x11,0x10,0x22,0x28,0x22,0x44,0x44,0x82,0x4b,0x01}}, // 汲
{0x3563,0x8B83,0xB5E3,0xE6B3A3,0x6CE3,{0x10,0x20,0x10,0x20,0x08,0x20,0x0b,0xfe,0x40,0x08,0x41,0x08,0x21,0x08,0x20,0x88,0x00,0x88,0x08,0x88,0x10,0x90,0x10,0x90,0x20,0x90,0x20,0x20,0x47,0xff,0x40,0x00}}, // 泣
{0x3564,0x8B84,0xB5E4,0xE781B8,0x7078,{0x02,0x00,0x03,0xf0,0x04,0x20,0x18,0x40,0x00,0xc0,0x03,0x20,0x0c,0x18,0x70,0x87,0x04,0x88,0x04,0x88,0x08,0x90,0x11,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x60,0x03}}, // 灸
{0x3565,0x8B85,0xB5E5,0xE79083,0x7403,{0x00,0x24,0x00,0x22,0x7c,0x22,0x13,0xff,0x10,0x20,0x12,0x22,0x11,0x32,0x7c,0xb4,0x10,0xb4,0x10,0x28,0x12,0x68,0x14,0xa4,0x19,0x22,0x66,0x21,0x00,0x20,0x00,0x60}}, // 球
{0x3566,0x8B86,0xB5E6,0xE7A9B6,0x7A76,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x24,0x44,0x44,0x40,0x04,0x44,0x08,0x3c,0x11,0x00,0x21,0x00,0x1f,0xe0,0x01,0x20,0x02,0x20,0x02,0x22,0x04,0x22,0x08,0x22,0x30,0x1e}}, // 究
{0x3567,0x8B87,0xB5E7,0xE7AAAE,0x7AAE,{0x01,0x00,0x01,0x00,0x7f,0xfe,0x44,0x42,0x18,0x7e,0x64,0x00,0x1f,0x7c,0x11,0x04,0x1f,0x7c,0x11,0x40,0x1f,0x7c,0x11,0x04,0x7f,0x04,0x05,0x04,0x19,0x04,0x63,0x18}}, // 窮
{0x3568,0x8B88,0xB5E8,0xE7AC88,0x7B08,{0x08,0x20,0x08,0x20,0x1f,0xbf,0x14,0x50,0x22,0x88,0x40,0x00,0x3f,0xf0,0x02,0x20,0x02,0x78,0x03,0x08,0x04,0x90,0x04,0x60,0x08,0x60,0x11,0x90,0x26,0x0c,0x58,0x03}}, // 笈
{0x3569,0x8B89,0xB5E9,0xE7B49A,0x7D1A,{0x08,0x00,0x09,0xfc,0x0a,0x44,0x72,0x48,0x14,0x48,0x08,0x5e,0x0c,0x62,0x12,0x62,0x7d,0x54,0x08,0x54,0x2c,0x98,0x2a,0x88,0x2a,0x94,0x29,0x24,0x4a,0x42,0x08,0x81}}, // 級
{0x356A,0x8B8A,0xB5EA,0xE7B3BE,0x7CFE,{0x08,0x08,0x08,0x48,0x0a,0x48,0x72,0x48,0x14,0x48,0x08,0x48,0x0c,0x48,0x12,0x48,0x7d,0x48,0x08,0x4f,0x2c,0x78,0x2b,0xc8,0x2a,0x08,0x2a,0x08,0x48,0x08,0x08,0x08}}, // 糾
{0x356B,0x8B8B,0xB5EB,0xE7B5A6,0x7D66,{0x08,0x10,0x08,0x10,0x0a,0x28,0x72,0x28,0x14,0x44,0x08,0x82,0x0d,0x7d,0x12,0x00,0x7d,0x00,0x09,0x7c,0x28,0x44,0x2a,0x44,0x29,0x44,0x29,0x44,0x48,0x7c,0x08,0x44}}, // 給
{0x356C,0x8B8C,0xB5EC,0xE697A7,0x65E7,{0x20,0x00,0x23,0xfc,0x22,0x04,0x22,0x04,0x22,0x04,0x22,0x04,0x22,0x04,0x23,0xfc,0x22,0x04,0x22,0x04,0x22,0x04,0x22,0x04,0x22,0x04,0x22,0x04,0x23,0xfc,0x22,0x04}}, // 旧
{0x356D,0x8B8D,0xB5ED,0xE7899B,0x725B,{0x00,0x80,0x04,0x80,0x04,0x80,0x04,0x80,0x0f,0xfc,0x08,0x80,0x10,0x80,0x20,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 牛
{0x356E,0x8B8E,0xB5EE,0xE58EBB,0x53BB,{0x00,0x80,0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0x00,0x01,0x20,0x02,0x10,0x02,0x08,0x04,0xf8,0x3f,0x04,0x00,0x04}}, // 去
{0x356F,0x8B8F,0xB5EF,0xE5B185,0x5C45,{0x00,0x00,0x1f,0xfc,0x10,0x04,0x10,0x04,0x1f,0xfc,0x10,0x44,0x10,0x40,0x1f,0xff,0x10,0x40,0x10,0x40,0x17,0xfc,0x14,0x04,0x24,0x04,0x24,0x04,0x47,0xfc,0x04,0x04}}, // 居
{0x3570,0x8B90,0xB5F0,0xE5B7A8,0x5DE8,{0x00,0x00,0x3f,0xfc,0x20,0x00,0x20,0x00,0x20,0x00,0x3f,0xf0,0x20,0x10,0x20,0x10,0x20,0x10,0x3f,0xf0,0x20,0x10,0x20,0x00,0x20,0x00,0x20,0x00,0x3f,0xfc,0x20,0x00}}, // 巨
{0x3571,0x8B91,0xB5F1,0xE68B92,0x62D2,{0x08,0x00,0x08,0xfe,0x08,0x80,0x08,0x80,0x7e,0x80,0x08,0xfc,0x08,0x84,0x08,0x84,0x08,0x84,0x0e,0xfc,0x78,0x84,0x08,0x80,0x08,0x80,0x08,0x80,0x18,0xff,0x08,0x80}}, // 拒
{0x3572,0x8B92,0xB5F2,0xE68BA0,0x62E0,{0x11,0x00,0x11,0x1c,0x11,0x14,0x11,0x14,0x7f,0xd4,0x12,0x54,0x12,0x54,0x15,0x54,0x14,0x94,0x18,0xa4,0x71,0xa5,0x11,0x45,0x12,0x43,0x14,0x20,0x38,0x18,0x10,0x07}}, // 拠
{0x3573,0x8B93,0xB5F3,0xE68C99,0x6319,{0x09,0x04,0x04,0x84,0x04,0x88,0x7f,0xff,0x02,0x20,0x04,0x30,0x18,0xcc,0x6f,0x83,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x3f,0xfe,0x00,0x80,0x00,0x80,0x01,0x80}}, // 挙
{0x3574,0x8B94,0xB5F4,0xE6B8A0,0x6E20,{0x00,0x00,0x19,0xfe,0x05,0x00,0x31,0xfc,0x09,0x04,0x01,0x04,0x05,0xfc,0x19,0x00,0x61,0xfe,0x00,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x0c,0x98,0x70,0x87,0x00,0x80}}, // 渠
{0x3575,0x8B95,0xB5F5,0xE8999A,0x865A,{0x00,0x80,0x00,0xfe,0x00,0x80,0x1f,0xff,0x11,0x02,0x11,0x34,0x1f,0xc0,0x11,0x02,0x10,0xfe,0x11,0x20,0x19,0x24,0x15,0x24,0x25,0x28,0x21,0x20,0x5f,0xff,0x00,0x00}}, // 虚
{0x3576,0x8B96,0xB5F6,0xE8A8B1,0x8A31,{0x00,0x40,0x3e,0x40,0x00,0x40,0x7f,0x7e,0x00,0x90,0x3e,0x90,0x01,0x10,0x3e,0x10,0x03,0xff,0x00,0x10,0x3e,0x10,0x22,0x10,0x22,0x10,0x22,0x10,0x3e,0x10,0x22,0x10}}, // 許
{0x3577,0x8B97,0xB5F7,0xE8B79D,0x8DDD,{0x00,0x00,0x3e,0xfe,0x22,0x80,0x22,0x80,0x22,0x80,0x22,0xfc,0x3e,0x84,0x08,0x84,0x28,0x84,0x2e,0xfc,0x28,0x80,0x28,0x80,0x28,0x80,0x2f,0x80,0x38,0xff,0x60,0x80}}, // 距
{0x3578,0x8B98,0xB5F8,0xE98BB8,0x92F8,{0x08,0x00,0x08,0xfe,0x14,0x82,0x12,0x82,0x20,0xfe,0x7e,0x88,0x08,0x88,0x08,0xff,0x7f,0x88,0x08,0x88,0x4a,0xbe,0x2c,0xa2,0x28,0xa2,0x0f,0x22,0x19,0x3e,0x62,0x22}}, // 鋸
{0x3579,0x8B99,0xB5F9,0xE6BC81,0x6F01,{0x10,0x40,0x08,0x40,0x08,0xf8,0x01,0x10,0x06,0x20,0x41,0xfc,0x21,0x24,0x21,0x24,0x09,0xfc,0x09,0x24,0x11,0x24,0x11,0xfc,0x22,0x00,0x22,0x92,0x44,0x49,0x48,0x49}}, // 漁
{0x357A,0x8B9A,0xB5FA,0xE7A6A6,0x79A6,{0x12,0x00,0x13,0xde,0x2d,0x12,0x4f,0xf2,0x11,0x12,0x35,0xd2,0x55,0x12,0x15,0xdc,0x16,0x10,0x17,0xf8,0x00,0x00,0x3f,0xff,0x02,0xb0,0x0c,0x8c,0x30,0x82,0x01,0x80}}, // 禦
{0x357B,0x8B9B,0xB5FB,0xE9AD9A,0x9B5A,{0x02,0x00,0x02,0x00,0x03,0xf0,0x04,0x20,0x18,0x40,0x6f,0xf8,0x08,0x88,0x08,0x88,0x0f,0xf8,0x08,0x88,0x08,0x88,0x0f,0xf8,0x10,0x08,0x14,0x44,0x22,0x22,0x42,0x22}}, // 魚
{0x357C,0x8B9C,0xB5FC,0xE4BAA8,0x4EA8,{0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x00,0x00,0x3f,0xfc,0x00,0x08,0x00,0x30,0x00,0xc0,0x00,0x80,0x00,0x80,0x00,0x80,0x01,0x80}}, // 亨
{0x357D,0x8B9D,0xB5FD,0xE4BAAB,0x4EAB,{0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x00,0x00,0x1f,0xf8,0x00,0x20,0x00,0x40,0x7f,0xfe,0x00,0x80,0x00,0x80,0x00,0x80,0x01,0x80}}, // 享
{0x357E,0x8B9E,0xB5FE,0xE4BAAC,0x4EAC,{0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x00,0x80,0x04,0xb0,0x08,0x88,0x10,0x84,0x61,0x82,0x00,0x80}}, // 京
{0x3621,0x8B9F,0xB6A1,0xE4BE9B,0x4F9B,{0x04,0x88,0x04,0x88,0x04,0x88,0x08,0x88,0x0b,0xfe,0x18,0x88,0x18,0x88,0x28,0x88,0x48,0x88,0x0f,0xff,0x08,0x00,0x08,0x88,0x08,0x84,0x09,0x04,0x0a,0x02,0x0c,0x02}}, // 供
{0x3622,0x8BA0,0xB6A2,0xE4BEA0,0x4FA0,{0x04,0x40,0x04,0x40,0x07,0xfe,0x08,0x40,0x0a,0x48,0x11,0x48,0x11,0x48,0x31,0x50,0x50,0x40,0x1f,0xff,0x10,0x60,0x10,0xa0,0x10,0x90,0x11,0x08,0x12,0x04,0x1c,0x02}}, // 侠
{0x3623,0x8BA1,0xB6A3,0xE58391,0x50D1,{0x04,0x0c,0x05,0xf0,0x04,0x40,0x0f,0xff,0x08,0x88,0x11,0xfc,0x16,0x8b,0x30,0xf8,0x50,0x00,0x13,0xfe,0x12,0x02,0x12,0xfa,0x12,0x8a,0x12,0xfa,0x12,0x8e,0x12,0x02}}, // 僑
{0x3624,0x8BA2,0xB6A4,0xE58587,0x5147,{0x00,0x20,0x10,0x28,0x16,0x48,0x11,0x48,0x10,0x88,0x11,0x48,0x12,0x28,0x1c,0x28,0x10,0x08,0x1f,0xf8,0x12,0x48,0x02,0x40,0x04,0x40,0x08,0x42,0x10,0x22,0x60,0x1e}}, // 兇
{0x3625,0x8BA3,0xB6A5,0xE7ABB6,0x7AF6,{0x04,0x10,0x04,0x10,0x3f,0xfe,0x11,0x44,0x0a,0x28,0x7f,0xff,0x00,0x00,0x1f,0x7c,0x11,0x44,0x11,0x44,0x1f,0x7c,0x0a,0x28,0x0a,0x28,0x12,0xa9,0x23,0x49,0x42,0x87}}, // 競
{0x3626,0x8BA4,0xB6A6,0xE585B1,0x5171,{0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x3f,0xfc,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x7f,0xff,0x00,0x00,0x04,0x20,0x04,0x10,0x08,0x08,0x10,0x04,0x20,0x04}}, // 共
{0x3627,0x8BA5,0xB6A7,0xE587B6,0x51F6,{0x00,0x00,0x00,0x10,0x20,0x12,0x20,0x12,0x26,0x22,0x21,0xa2,0x20,0x42,0x20,0x62,0x20,0x92,0x21,0x12,0x22,0x0a,0x24,0x0a,0x28,0x02,0x20,0x02,0x3f,0xfe,0x20,0x02}}, // 凶
{0x3628,0x8BA6,0xB6A8,0xE58D94,0x5354,{0x10,0x40,0x10,0x40,0x13,0xfc,0x10,0x44,0x10,0x44,0x7c,0x84,0x11,0x18,0x12,0x08,0x12,0x08,0x1f,0xff,0x12,0x49,0x12,0x49,0x12,0x49,0x14,0x49,0x14,0x51,0x19,0xa6}}, // 協
{0x3629,0x8BA7,0xB6A9,0xE58CA1,0x5321,{0x00,0x00,0x3f,0xfe,0x20,0x00,0x20,0x00,0x2f,0xf8,0x20,0x80,0x20,0x80,0x27,0xf0,0x20,0x80,0x20,0x80,0x20,0x80,0x2f,0xfc,0x20,0x00,0x20,0x00,0x3f,0xfe,0x20,0x00}}, // 匡
{0x362A,0x8BA8,0xB6AA,0xE58DBF,0x537F,{0x04,0x00,0x0b,0xde,0x32,0x52,0x2a,0x52,0x2b,0xd2,0x2a,0x52,0x2a,0x52,0x2b,0xd2,0x2a,0x12,0x2b,0x12,0x3a,0x92,0x6a,0x52,0x0b,0xdc,0x16,0x30,0x10,0x10,0x20,0x10}}, // 卿
{0x362B,0x8BA9,0xB6AB,0xE58FAB,0x53EB,{0x00,0x04,0x00,0x04,0x3e,0x44,0x22,0x44,0x22,0x44,0x22,0x44,0x22,0x44,0x22,0x44,0x22,0x44,0x22,0x44,0x22,0x47,0x3e,0x7c,0x23,0xc4,0x00,0x04,0x00,0x04,0x00,0x04}}, // 叫
{0x362C,0x8BAA,0xB6AC,0xE596AC,0x55AC,{0x00,0x38,0x1f,0xc0,0x01,0x00,0x7f,0xfe,0x02,0x20,0x07,0xf0,0x1a,0x2c,0x63,0xe2,0x00,0x00,0x1f,0xfc,0x10,0x04,0x13,0xe4,0x12,0x24,0x13,0xe4,0x12,0x2c,0x10,0x04}}, // 喬
{0x362D,0x8BAB,0xB6AD,0xE5A283,0x5883,{0x00,0x20,0x10,0x20,0x17,0xfe,0x11,0x08,0x10,0x90,0x7f,0xff,0x10,0x00,0x11,0xfc,0x11,0x04,0x11,0xfc,0x15,0x04,0x19,0xfc,0x60,0x50,0x00,0x91,0x03,0x11,0x0c,0x0f}}, // 境
{0x362E,0x8BAC,0xB6AE,0xE5B3A1,0x5CE1,{0x10,0x10,0x10,0x10,0x11,0xfe,0x54,0x10,0x54,0x92,0x54,0x52,0x54,0x54,0x54,0x10,0x57,0xff,0x54,0x10,0x54,0x10,0x7c,0x28,0x44,0x28,0x00,0x44,0x00,0x82,0x03,0x01}}, // 峡
{0x362F,0x8BAD,0xB6AF,0xE5BCB7,0x5F37,{0x00,0x40,0x7c,0x50,0x04,0x8c,0x07,0xfa,0x04,0x21,0x3c,0x20,0x21,0xfc,0x21,0x24,0x3d,0x24,0x25,0x24,0x05,0xfc,0x05,0x24,0x04,0x22,0x04,0x3e,0x0b,0xc1,0x30,0x01}}, // 強
{0x3630,0x8BAE,0xB6B0,0xE5BD8A,0x5F4A,{0x00,0x00,0x7f,0xff,0x04,0x00,0x05,0xfc,0x05,0x24,0x3d,0xfc,0x21,0x24,0x23,0xfe,0x3c,0x00,0x05,0xfc,0x05,0x24,0x05,0xfc,0x05,0x24,0x05,0xfc,0x08,0x00,0x33,0xff}}, // 彊
{0x3631,0x8BAF,0xB6B1,0xE680AF,0x602F,{0x08,0x20,0x08,0x20,0x08,0x20,0x09,0xfc,0x2c,0x20,0x2a,0x20,0x2a,0x20,0x28,0x20,0x4b,0xff,0x08,0x20,0x08,0x20,0x08,0x48,0x08,0x44,0x08,0xbc,0x0b,0xc2,0x08,0x02}}, // 怯
{0x3632,0x8BB0,0xB6B2,0xE68190,0x6050,{0x00,0x00,0x7f,0xf8,0x11,0x08,0x11,0x08,0x11,0x48,0x15,0x28,0x19,0x2a,0x62,0x0a,0x04,0x06,0x01,0x00,0x04,0x80,0x14,0x48,0x14,0x44,0x24,0x12,0x42,0x12,0x01,0xf0}}, // 恐
{0x3633,0x8BB1,0xB6B3,0xE681AD,0x606D,{0x02,0x20,0x02,0x20,0x1f,0xfc,0x02,0x20,0x02,0x20,0x02,0x20,0x7f,0xff,0x04,0x10,0x09,0x08,0x11,0x04,0x61,0x03,0x09,0x48,0x09,0x24,0x11,0x24,0x21,0x00,0x03,0x00}}, // 恭
{0x3634,0x8BB2,0xB6B4,0xE68C9F,0x631F,{0x10,0x20,0x10,0x20,0x13,0xfe,0x10,0x20,0x7e,0x24,0x11,0x24,0x10,0xa4,0x10,0xa8,0x1f,0xff,0x70,0x20,0x10,0x50,0x10,0x50,0x10,0x88,0x11,0x04,0x12,0x02,0x34,0x01}}, // 挟
{0x3635,0x8BB3,0xB6B5,0xE69599,0x6559,{0x04,0x20,0x04,0xa0,0x3f,0xa0,0x04,0xa0,0x05,0x3f,0x7f,0xe2,0x02,0x22,0x3f,0x62,0x09,0x54,0x12,0x94,0x64,0x08,0x07,0x88,0x7c,0x14,0x04,0x24,0x04,0xc2,0x0f,0x01}}, // 教
{0x3636,0x8BB4,0xB6B6,0xE6A98B,0x6A4B,{0x08,0x0c,0x09,0xf0,0x08,0x20,0x7f,0xff,0x08,0x48,0x08,0xfc,0x19,0x4b,0x1c,0x78,0x2a,0x00,0x2b,0xfe,0x49,0x02,0x09,0x7a,0x09,0x4a,0x09,0x7a,0x09,0x4a,0x09,0x06}}, // 橋
{0x3637,0x8BB5,0xB6B7,0xE6B381,0x6CC1,{0x10,0x00,0x0b,0xfc,0x0a,0x04,0x02,0x04,0x42,0x04,0x22,0x04,0x23,0xfc,0x02,0x94,0x08,0x90,0x08,0x90,0x10,0x90,0x11,0x10,0x21,0x10,0x22,0x11,0x44,0x11,0x48,0x0f}}, // 況
{0x3638,0x8BB6,0xB6B8,0xE78B82,0x72C2,{0x04,0x00,0x45,0xfe,0x28,0x20,0x10,0x20,0x10,0x20,0x28,0x20,0x48,0x20,0x09,0xfc,0x18,0x20,0x18,0x20,0x28,0x20,0x48,0x20,0x08,0x20,0x08,0x20,0x6f,0xff,0x10,0x00}}, // 狂
{0x3639,0x8BB7,0xB6B9,0xE78BAD,0x72ED,{0x04,0x20,0x44,0x20,0x2b,0xfe,0x10,0x20,0x32,0x24,0x51,0x24,0x08,0xa4,0x08,0xa8,0x1f,0xff,0x18,0x20,0x28,0x50,0x48,0x50,0x08,0x88,0x09,0x04,0x6a,0x02,0x14,0x01}}, // 狭
{0x363A,0x8BB8,0xB6BA,0xE79FAF,0x77EF,{0x10,0x0c,0x11,0xf0,0x10,0x20,0x3f,0xff,0x28,0x48,0x48,0xfc,0x09,0x4b,0x7e,0x78,0x08,0x00,0x09,0xfe,0x15,0x02,0x13,0x7a,0x23,0x4a,0x21,0x7a,0x41,0x4e,0x01,0x02}}, // 矯
{0x363B,0x8BB9,0xB6BB,0xE883B8,0x80F8,{0x00,0x80,0x3c,0x80,0x24,0x80,0x24,0xfe,0x25,0x12,0x3d,0x92,0x27,0x6a,0x25,0x2a,0x25,0x5a,0x3d,0x5a,0x25,0x8a,0x25,0x0a,0x25,0xfa,0x25,0x02,0x2c,0x04,0x44,0x18}}, // 胸
{0x363C,0x8BBA,0xB6BC,0xE88485,0x8105,{0x00,0x80,0x0f,0xf0,0x03,0x10,0x1c,0x60,0x08,0x10,0x7f,0xfe,0x11,0x22,0x66,0xcc,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x18}}, // 脅
{0x363D,0x8BBB,0xB6BD,0xE88888,0x8208,{0x04,0x00,0x08,0x00,0x37,0xfe,0x24,0x12,0x27,0xf2,0x3c,0x1e,0x25,0xd2,0x25,0x52,0x3d,0x5e,0x25,0xd2,0x25,0x52,0x24,0x12,0x7f,0xff,0x04,0x30,0x18,0x0c,0x60,0x02}}, // 興
{0x363E,0x8BBC,0xB6BE,0xE8958E,0x854E,{0x02,0x20,0x7f,0xff,0x02,0x20,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x02,0x20,0x07,0xf0,0x1a,0x2c,0x63,0xe3,0x00,0x00,0x1f,0xfc,0x13,0xe4,0x12,0x24,0x13,0xe4,0x10,0x0c}}, // 蕎
{0x363F,0x8BBD,0xB6BF,0xE983B7,0x90F7,{0x08,0x00,0x0b,0xde,0x12,0x52,0x16,0x52,0x67,0xd4,0x1a,0x58,0x0a,0x54,0x0f,0xd2,0x16,0x11,0x26,0x91,0x7a,0x51,0x0a,0x59,0x12,0xb6,0x13,0x30,0x26,0x10,0x40,0x10}}, // 郷
{0x3640,0x8BBE,0xB6C0,0xE98FA1,0x93E1,{0x08,0x10,0x08,0x10,0x15,0xfe,0x12,0x84,0x20,0x48,0x7f,0xff,0x08,0x00,0x08,0xfc,0x7f,0x84,0x08,0xfc,0x4a,0x84,0x2c,0xfc,0x28,0x28,0x0e,0x49,0x18,0x89,0x63,0x07}}, // 鏡
{0x3641,0x8BBF,0xB6C1,0xE99FBF,0x97FF,{0x11,0xee,0x65,0x2a,0x29,0xea,0x11,0x2c,0x1d,0xea,0x65,0x49,0x09,0xe9,0x13,0x2e,0x20,0x88,0x5f,0xfe,0x02,0x20,0x7f,0xff,0x07,0xf0,0x04,0x10,0x07,0xf0,0x04,0x10}}, // 響
{0x3642,0x8BC0,0xB6C2,0xE9A597,0x9957,{0x11,0xee,0x65,0x2a,0x29,0xea,0x11,0x2c,0x1d,0xea,0x65,0x49,0x0b,0xef,0x10,0xa8,0x61,0x48,0x03,0xf0,0x0c,0x1c,0x77,0xf3,0x04,0x10,0x07,0xf4,0x04,0xe8,0x7f,0x1e}}, // 饗
{0x3643,0x8BC1,0xB6C3,0xE9A99A,0x9A5A,{0x0a,0x20,0x3f,0xbf,0x0a,0x24,0x1f,0xd4,0x1e,0x98,0x2a,0x88,0x4e,0x94,0x03,0x22,0x0f,0xf9,0x08,0x80,0x0f,0xf8,0x08,0x80,0x0f,0xfc,0x29,0x24,0x24,0x94,0x40,0x18}}, // 驚
{0x3644,0x8BC2,0xB6C4,0xE4BBB0,0x4EF0,{0x04,0x40,0x04,0x80,0x07,0x3e,0x0a,0x22,0x0a,0x22,0x12,0x22,0x12,0x22,0x32,0x22,0x52,0x22,0x12,0x22,0x12,0x62,0x13,0xa2,0x16,0x2c,0x10,0x20,0x10,0x20,0x10,0x20}}, // 仰
{0x3645,0x8BC3,0xB6C5,0xE5879D,0x51DD,{0x04,0x00,0x04,0xbe,0x27,0x02,0x14,0x14,0x14,0x88,0x03,0x84,0x02,0x7f,0x13,0x8a,0x15,0x0c,0x11,0x28,0x2f,0xee,0x21,0x28,0x22,0xa8,0x42,0x58,0x44,0x4c,0x08,0x83}}, // 凝
{0x3646,0x8BC4,0xB6C6,0xE5B0AD,0x5C2D,{0x01,0x00,0x01,0x00,0x3f,0xf8,0x01,0x00,0x09,0x10,0x08,0x10,0x7f,0xfe,0x08,0x10,0x08,0x10,0x00,0x00,0x7f,0xfe,0x02,0x40,0x02,0x40,0x04,0x42,0x08,0x42,0x30,0x3e}}, // 尭
{0x3647,0x8BC5,0xB6C7,0xE69A81,0x6681,{0x00,0x20,0x00,0x20,0x79,0xfc,0x48,0x20,0x48,0xa8,0x48,0x88,0x4f,0xff,0x78,0x88,0x48,0x88,0x48,0x00,0x4b,0xfe,0x48,0x90,0x78,0x90,0x49,0x11,0x02,0x11,0x0c,0x0f}}, // 暁
{0x3648,0x8BC6,0xB6C8,0xE6A5AD,0x696D,{0x01,0x20,0x09,0x24,0x05,0x28,0x7f,0xff,0x04,0x08,0x02,0x10,0x3f,0xff,0x00,0x80,0x1f,0xfe,0x00,0x80,0x7f,0xff,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80}}, // 業
{0x3649,0x8BC7,0xB6C9,0xE5B180,0x5C40,{0x00,0x00,0x1f,0xfc,0x10,0x04,0x10,0x04,0x1f,0xfc,0x10,0x04,0x10,0x00,0x1f,0xfe,0x10,0x02,0x13,0xf2,0x12,0x12,0x12,0x12,0x13,0xf2,0x22,0x12,0x20,0x04,0x40,0x18}}, // 局
{0x364A,0x8BC8,0xB6CA,0xE69BB2,0x66F2,{0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x3f,0xfe,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x3f,0xfe,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x3f,0xfe,0x20,0x02}}, // 曲
{0x364B,0x8BC9,0xB6CB,0xE6A5B5,0x6975,{0x10,0x00,0x13,0xfe,0x10,0x40,0x7e,0x40,0x10,0xe0,0x10,0x3e,0x1b,0xa2,0x36,0xaa,0x32,0xa4,0x53,0xa4,0x52,0xaa,0x10,0x31,0x10,0xc0,0x10,0x00,0x17,0xff,0x10,0x00}}, // 極
{0x364C,0x8BCA,0xB6CC,0xE78E89,0x7389,{0x00,0x00,0x3f,0xfe,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x00,0x90,0x00,0x88,0x00,0x88,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 玉
{0x364D,0x8BCB,0xB6CD,0xE6A190,0x6850,{0x08,0x00,0x09,0xfe,0x09,0x02,0x7f,0x02,0x09,0xfe,0x09,0x02,0x1d,0x02,0x1b,0x7a,0x19,0x4a,0x29,0x4a,0x29,0x4a,0x49,0x7a,0x09,0x4a,0x09,0x02,0x09,0x02,0x09,0x06}}, // 桐
{0x364E,0x8BCC,0xB6CE,0xE7B281,0x7C81,{0x08,0x04,0x0a,0x18,0x4a,0xf0,0x2a,0x10,0x2c,0x10,0x08,0x10,0x7f,0x10,0x09,0xff,0x1c,0x10,0x1a,0x10,0x29,0x10,0x28,0x10,0x48,0x10,0x08,0x10,0x08,0x10,0x08,0x10}}, // 粁
{0x364F,0x8BCD,0xB6CF,0xE58385,0x50C5,{0x04,0x88,0x04,0x88,0x07,0xff,0x08,0x88,0x0b,0xfe,0x12,0x22,0x12,0x22,0x33,0xfe,0x50,0x20,0x11,0xfc,0x10,0x20,0x11,0xfc,0x10,0x20,0x10,0x20,0x17,0xff,0x10,0x00}}, // 僅
{0x3650,0x8BCE,0xB6D0,0xE58BA4,0x52E4,{0x11,0x10,0x11,0x10,0x7f,0xd0,0x11,0x10,0x00,0x7e,0x3f,0x92,0x24,0x92,0x24,0x92,0x3f,0x92,0x04,0x12,0x3f,0x92,0x04,0x22,0x3f,0xa2,0x04,0x22,0x07,0x42,0x78,0x8c}}, // 勤
{0x3651,0x8BCF,0xB6D1,0xE59D87,0x5747,{0x00,0x40,0x08,0x40,0x08,0x40,0x08,0xfe,0x7e,0x82,0x09,0x02,0x0a,0xc2,0x08,0x22,0x08,0x02,0x08,0x0a,0x0e,0x12,0x18,0x62,0x61,0x82,0x00,0x02,0x00,0x04,0x00,0x38}}, // 均
{0x3652,0x8BD0,0xB6D2,0xE5B7BE,0x5DFE,{0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x3f,0xfc,0x21,0x04,0x21,0x04,0x21,0x04,0x21,0x04,0x21,0x04,0x21,0x04,0x21,0x18,0x21,0x00,0x01,0x00,0x01,0x00,0x01,0x00}}, // 巾
{0x3653,0x8BD1,0xB6D3,0xE98CA6,0x9326,{0x04,0x10,0x04,0x20,0x0c,0x7c,0x0a,0x44,0x11,0x7c,0x3f,0x44,0x44,0x44,0x04,0x7c,0x7f,0x10,0x04,0xfe,0x25,0x92,0x16,0x92,0x14,0x92,0x07,0x9c,0x18,0x90,0x60,0x10}}, // 錦
{0x3654,0x8BD2,0xB6D4,0xE696A4,0x65A4,{0x00,0x08,0x00,0x30,0x0f,0xc0,0x08,0x00,0x08,0x00,0x08,0x00,0x0f,0xff,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x10,0x20,0x10,0x20,0x20,0x20,0x40,0x20,0x00,0x20}}, // 斤
{0x3655,0x8BD3,0xB6D5,0xE6ACA3,0x6B23,{0x02,0x20,0x04,0x20,0x38,0x20,0x20,0x3f,0x20,0x42,0x3f,0x54,0x24,0x90,0x25,0x10,0x24,0x10,0x24,0x18,0x24,0x28,0x24,0x28,0x24,0x24,0x24,0x44,0x44,0x82,0x07,0x01}}, // 欣
{0x3656,0x8BD4,0xB6D6,0xE6ACBD,0x6B3D,{0x08,0x40,0x08,0x40,0x14,0x40,0x12,0x7f,0x21,0x42,0x7e,0x94,0x08,0x90,0x09,0x10,0x7f,0x10,0x08,0x18,0x4a,0x18,0x2c,0x28,0x29,0x24,0x0e,0x44,0x18,0x82,0x63,0x01}}, // 欽
{0x3657,0x8BD5,0xB6D7,0xE790B4,0x7434,{0x00,0x00,0x7f,0x7e,0x08,0x08,0x3e,0x7e,0x08,0x08,0x0b,0x88,0x1c,0xbf,0x61,0x40,0x02,0x20,0x0c,0x18,0x73,0xe7,0x00,0x00,0x0f,0xf0,0x00,0x20,0x00,0x40,0x00,0x80}}, // 琴
{0x3658,0x8BD6,0xB6D8,0xE7A681,0x7981,{0x04,0x10,0x04,0x10,0x7f,0xff,0x0c,0x38,0x0e,0x34,0x15,0x54,0x24,0x92,0x44,0x11,0x0f,0xf8,0x00,0x00,0x7f,0xff,0x00,0x80,0x04,0xb0,0x18,0x8c,0x60,0x82,0x01,0x80}}, // 禁
{0x3659,0x8BD7,0xB6D9,0xE7A6BD,0x79BD,{0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x90,0x1f,0xfc,0x69,0x4b,0x08,0x88,0x0b,0x68,0x0f,0xf8,0x01,0x00,0x1f,0xfc,0x11,0x44,0x11,0x24,0x12,0xd4,0x1f,0x04,0x10,0x0c}}, // 禽
{0x365A,0x8BD8,0xB6DA,0xE7AD8B,0x7B4B,{0x10,0x20,0x10,0x20,0x1f,0x3f,0x24,0x48,0x22,0x44,0x40,0xa0,0x1e,0x20,0x12,0xfe,0x12,0x22,0x1e,0x22,0x12,0x22,0x12,0x22,0x1e,0x42,0x22,0x42,0x22,0x82,0x47,0x0c}}, // 筋
{0x365B,0x8BD9,0xB6DB,0xE7B78A,0x7DCA,{0x00,0x00,0x3f,0xfc,0x24,0x44,0x3f,0x24,0x21,0x28,0x3f,0x10,0x24,0x28,0x3f,0xc6,0x01,0x20,0x0e,0x50,0x01,0x8c,0x7f,0xfa,0x05,0x30,0x19,0x0c,0x61,0x02,0x01,0x00}}, // 緊
{0x365C,0x8BDA,0xB6DC,0xE88AB9,0x82B9,{0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x00,0x20,0x07,0xc0,0x04,0x00,0x04,0x00,0x07,0xff,0x04,0x20,0x04,0x20,0x08,0x20,0x08,0x20,0x10,0x20,0x20,0x20,0x00,0x20}}, // 芹
{0x365D,0x8BDB,0xB6DD,0xE88F8C,0x83CC,{0x04,0x20,0x04,0x20,0x7f,0xff,0x04,0x20,0x3f,0xfe,0x20,0x12,0x20,0xe2,0x27,0x82,0x20,0x82,0x3f,0xfe,0x22,0xa2,0x24,0x92,0x28,0x8a,0x20,0x82,0x3f,0xfe,0x20,0x02}}, // 菌
{0x365E,0x8BDC,0xB6DE,0xE8A1BF,0x887F,{0x08,0x10,0x08,0x10,0x08,0x28,0x7e,0x28,0x02,0x44,0x05,0x82,0x05,0x7d,0x09,0x00,0x1e,0x00,0x2a,0x7c,0x49,0x04,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x10,0x08,0x20}}, // 衿
{0x365F,0x8BDD,0xB6DF,0xE8A59F,0x895F,{0x10,0x88,0x10,0x88,0x13,0xff,0x7c,0x88,0x05,0xdc,0x09,0xaa,0x0a,0x89,0x16,0x88,0x18,0xfc,0x34,0x00,0x53,0xff,0x10,0xa8,0x10,0xa4,0x11,0x22,0x12,0x62,0x10,0x20}}, // 襟
{0x3660,0x8BDE,0xB6E0,0xE8ACB9,0x8B39,{0x00,0x44,0x3e,0x44,0x01,0xff,0x7e,0x44,0x00,0xfe,0x3e,0x92,0x00,0x92,0x00,0xfe,0x3e,0x10,0x00,0xfe,0x3e,0x10,0x22,0xfe,0x22,0x10,0x22,0x10,0x3f,0xff,0x22,0x00}}, // 謹
{0x3661,0x8BDF,0xB6E1,0xE8BF91,0x8FD1,{0x00,0x04,0x20,0x18,0x11,0xe0,0x11,0x00,0x01,0x00,0x01,0xfe,0x01,0x10,0x79,0x10,0x09,0x10,0x09,0x10,0x0a,0x10,0x0a,0x10,0x0c,0x10,0x14,0x10,0x23,0x00,0x40,0xff}}, // 近
{0x3662,0x8BE0,0xB6E2,0xE98791,0x91D1,{0x00,0x80,0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x67,0xf3,0x00,0x80,0x00,0x80,0x1f,0xfe,0x00,0x80,0x08,0x88,0x04,0x88,0x04,0x90,0x3f,0xfe,0x00,0x00}}, // 金
{0x3663,0x8BE1,0xB6E3,0xE5909F,0x541F,{0x00,0x20,0x00,0x20,0x7c,0x50,0x44,0x50,0x44,0x88,0x45,0x04,0x46,0xfa,0x44,0x01,0x44,0x00,0x45,0xfc,0x44,0x04,0x7c,0x08,0x44,0x08,0x00,0x10,0x00,0x10,0x00,0x20}}, // 吟
{0x3664,0x8BE2,0xB6E4,0xE98A80,0x9280,{0x04,0x00,0x04,0x7c,0x0c,0x44,0x0a,0x44,0x11,0x7c,0x3f,0xc4,0x44,0x44,0x04,0x7c,0x7f,0x52,0x04,0x52,0x25,0x54,0x16,0x48,0x14,0x48,0x07,0x54,0x18,0x62,0x61,0x81}}, // 銀
{0x3665,0x8BE3,0xB6E5,0xE4B99D,0x4E5D,{0x00,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x7f,0xe0,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x08,0x22,0x10,0x22,0x20,0x1e,0x40,0x00}}, // 九
{0x3666,0x8BE4,0xB6E6,0xE580B6,0x5036,{0x04,0x00,0x05,0xfc,0x05,0x04,0x09,0x04,0x09,0xfc,0x11,0x04,0x11,0x04,0x31,0xfc,0x51,0x04,0x11,0x04,0x11,0xfc,0x10,0x00,0x17,0xff,0x10,0x98,0x11,0x04,0x16,0x02}}, // 倶
{0x3667,0x8BE5,0xB6E7,0xE58FA5,0x53E5,{0x04,0x00,0x04,0x00,0x04,0x00,0x0f,0xfe,0x08,0x02,0x10,0x02,0x27,0xe2,0x44,0x22,0x04,0x22,0x04,0x22,0x04,0x22,0x07,0xe2,0x04,0x22,0x00,0x02,0x00,0x04,0x00,0x18}}, // 句
{0x3668,0x8BE6,0xB6E8,0xE58CBA,0x533A,{0x00,0x00,0x3f,0xfe,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x10,0x2e,0x10,0x21,0xa0,0x20,0x40,0x20,0xa0,0x21,0x10,0x22,0x08,0x24,0x08,0x28,0x00,0x3f,0xff,0x20,0x00}}, // 区
{0x3669,0x8BE7,0xB6E9,0xE78B97,0x72D7,{0x04,0x80,0x44,0x80,0x28,0x80,0x11,0xfe,0x29,0x02,0x4a,0x02,0x04,0xf2,0x0c,0x92,0x14,0x92,0x24,0x92,0x44,0x92,0x04,0xf2,0x04,0x92,0x08,0x02,0x68,0x04,0x10,0x18}}, // 狗
{0x366A,0x8BE8,0xB6EA,0xE78E96,0x7396,{0x00,0x40,0x00,0x40,0x7c,0x78,0x10,0x88,0x10,0x88,0x11,0x08,0x12,0x10,0x7c,0x10,0x10,0x20,0x10,0x20,0x10,0x50,0x12,0x48,0x1c,0x84,0x71,0x04,0x02,0x02,0x0c,0x02}}, // 玖
{0x366B,0x8BE9,0xB6EB,0xE79FA9,0x77E9,{0x10,0x00,0x10,0xfe,0x10,0x80,0x1f,0x80,0x28,0x80,0x28,0xfc,0x48,0x84,0x08,0x84,0x7f,0x84,0x08,0xfc,0x14,0x84,0x12,0x80,0x12,0x80,0x22,0x80,0x20,0xff,0x40,0x80}}, // 矩
{0x366C,0x8BEA,0xB6EC,0xE88BA6,0x82E6,{0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x10,0x04,0x90,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 苦
{0x366D,0x8BEB,0xB6ED,0xE8BAAF,0x8EAF,{0x08,0x00,0x10,0xfe,0x3e,0x80,0x22,0x84,0x3e,0x84,0x22,0xa4,0x3e,0x98,0x22,0x88,0x23,0x8c,0x3e,0x94,0x62,0x92,0x06,0xa2,0x0a,0xc0,0x12,0x80,0x66,0xff,0x02,0x80}}, // 躯
{0x366E,0x8BEC,0xB6EE,0xE9A786,0x99C6,{0x00,0x00,0x3f,0x7f,0x24,0x40,0x24,0x42,0x3f,0x42,0x24,0x52,0x3f,0x4c,0x24,0x44,0x24,0x44,0x3f,0xca,0x04,0xca,0x32,0xd2,0x2a,0xe0,0x28,0xc0,0x41,0x7f,0x06,0x40}}, // 駆
{0x366F,0x8BED,0xB6EF,0xE9A788,0x99C8,{0x00,0x04,0x3f,0x88,0x24,0x30,0x24,0x20,0x3f,0x20,0x24,0x3f,0x3f,0x24,0x24,0x24,0x24,0x24,0x3f,0xa4,0x04,0xa4,0x32,0xa4,0x2a,0xa4,0x28,0xa4,0x40,0xff,0x03,0x00}}, // 駈
{0x3670,0x8BEE,0xB6F0,0xE9A792,0x99D2,{0x00,0x20,0x3f,0x20,0x24,0x3e,0x24,0x22,0x3f,0x42,0x24,0x7a,0x3f,0xaa,0x25,0x2a,0x24,0x2a,0x3f,0xaa,0x04,0xba,0x32,0xaa,0x2a,0x82,0x28,0x82,0x40,0x84,0x03,0x18}}, // 駒
{0x3671,0x8BEF,0xB6F1,0xE585B7,0x5177,{0x00,0x00,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x00,0x00,0x7f,0xff,0x04,0x60,0x18,0x18,0x60,0x04}}, // 具
{0x3672,0x8BF0,0xB6F2,0xE6849A,0x611A,{0x00,0x00,0x1f,0xf0,0x11,0x10,0x1f,0xf0,0x11,0x10,0x1f,0xf0,0x01,0x00,0x7f,0xfc,0x41,0x34,0x41,0xec,0x5e,0x04,0x40,0x8c,0x14,0x40,0x14,0x54,0x24,0x12,0x43,0xf2}}, // 愚
{0x3673,0x8BF1,0xB6F3,0xE8999E,0x865E,{0x00,0x80,0x00,0xfc,0x00,0x80,0x1f,0xff,0x11,0x1a,0x1f,0xe0,0x11,0x02,0x10,0xfe,0x12,0x84,0x12,0xfc,0x12,0x00,0x13,0xf8,0x20,0x08,0x2f,0xff,0x43,0x18,0x1c,0x06}}, // 虞
{0x3674,0x8BF2,0xB6F4,0xE596B0,0x55B0,{0x00,0x20,0x00,0x20,0x7c,0x50,0x44,0x88,0x45,0x24,0x46,0xfb,0x44,0x88,0x44,0xf8,0x44,0x88,0x44,0x8a,0x44,0xfa,0x7c,0xa4,0x44,0x90,0x40,0x88,0x00,0xe4,0x07,0x03}}, // 喰
{0x3675,0x8BF3,0xB6F5,0xE7A9BA,0x7A7A,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x24,0x44,0x24,0x40,0x44,0x44,0x08,0x44,0x10,0x3c,0x20,0x00,0x1f,0xf8,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x7f,0xfe,0x00,0x00}}, // 空
{0x3676,0x8BF4,0xB6F6,0xE581B6,0x5076,{0x04,0x00,0x07,0xfc,0x06,0x24,0x0a,0x24,0x0b,0xfc,0x12,0x24,0x12,0x24,0x33,0xfc,0x50,0x20,0x17,0xfe,0x14,0x32,0x14,0x2a,0x14,0x36,0x15,0xc6,0x14,0x02,0x14,0x06}}, // 偶
{0x3677,0x8BF5,0xB6F7,0xE5AF93,0x5BD3,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x2f,0xf0,0x49,0x10,0x0f,0xf0,0x09,0x10,0x0f,0xf0,0x01,0x00,0x3f,0xfc,0x21,0x44,0x21,0x34,0x3f,0xcc,0x20,0x04,0x20,0x0c}}, // 寓
{0x3678,0x8BF6,0xB6F8,0xE98187,0x9047,{0x00,0x00,0x21,0xfc,0x11,0x24,0x11,0xfc,0x01,0x24,0x01,0x24,0x01,0xfc,0x78,0x20,0x0b,0xfe,0x0a,0x22,0x0a,0x2a,0x0a,0x3a,0x16,0xca,0x12,0x06,0x21,0x80,0x40,0x7f}}, // 遇
{0x3679,0x8BF7,0xB6F9,0xE99A85,0x9685,{0x00,0x00,0x3d,0xfc,0x25,0x24,0x25,0x24,0x29,0xfc,0x31,0x24,0x29,0x24,0x25,0xfc,0x24,0x20,0x27,0xfe,0x26,0x22,0x26,0x2a,0x3a,0x36,0x22,0xe6,0x22,0x02,0x22,0x06}}, // 隅
{0x367A,0x8BF8,0xB6FA,0xE4B8B2,0x4E32,{0x00,0x80,0x00,0x80,0x1f,0xfc,0x10,0x84,0x10,0x84,0x1f,0xfc,0x00,0x80,0x00,0x80,0x3f,0xfe,0x20,0x82,0x20,0x82,0x3f,0xfe,0x20,0x82,0x00,0x80,0x00,0x80,0x00,0x80}}, // 串
{0x367B,0x8BF9,0xB6FB,0xE6AB9B,0x6ADB,{0x11,0x10,0x11,0x10,0x11,0xdf,0x7a,0xa8,0x12,0x44,0x14,0x00,0x33,0xde,0x3a,0x52,0x37,0xd2,0x52,0x52,0x53,0xd2,0x12,0x12,0x12,0x92,0x13,0xdc,0x16,0x50,0x10,0x50}}, // 櫛
{0x367C,0x8BFA,0xB6FC,0xE987A7,0x91E7,{0x08,0x02,0x08,0x52,0x14,0x52,0x12,0x52,0x21,0x52,0x7e,0x52,0x08,0x52,0x08,0x52,0x7f,0x52,0x08,0x52,0x4a,0x52,0x2c,0x52,0x28,0x92,0x0e,0x82,0x19,0x02,0x62,0x02}}, // 釧
{0x367D,0x8BFB,0xB6FD,0xE5B191,0x5C51,{0x00,0x00,0x1f,0xfc,0x10,0x04,0x10,0x04,0x1f,0xfc,0x10,0x40,0x12,0x48,0x11,0x50,0x17,0xf8,0x14,0x08,0x17,0xf8,0x14,0x08,0x27,0xf8,0x24,0x08,0x44,0x08,0x04,0x18}}, // 屑
{0x367E,0x8BFC,0xB6FE,0xE5B188,0x5C48,{0x00,0x00,0x1f,0xfc,0x10,0x04,0x10,0x04,0x1f,0xfc,0x10,0x80,0x14,0x88,0x14,0x88,0x17,0xf8,0x14,0x88,0x10,0x80,0x18,0x84,0x28,0x84,0x28,0x84,0x4f,0xfc,0x08,0x04}}, // 屈
{0x3721,0x8C40,0xB7A1,0xE68E98,0x6398,{0x10,0x00,0x13,0xfe,0x12,0x02,0x12,0x02,0x7f,0xfe,0x12,0x10,0x12,0x92,0x12,0x92,0x1e,0x92,0x72,0xfe,0x12,0x10,0x12,0x92,0x14,0x92,0x14,0x92,0x18,0xfe,0x30,0x82}}, // 掘
{0x3722,0x8C41,0xB7A2,0xE7AA9F,0x7A9F,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x22,0x44,0x4c,0x7c,0x30,0x00,0x1f,0xfc,0x10,0x04,0x1f,0xfc,0x14,0x48,0x14,0x48,0x17,0xf8,0x28,0x44,0x28,0x44,0x4f,0xfc,0x08,0x04}}, // 窟
{0x3723,0x8C42,0xB7A3,0xE6B293,0x6C93,{0x00,0x80,0x00,0x84,0x3e,0xc8,0x02,0xd0,0x04,0xa0,0x08,0x90,0x10,0x8c,0x61,0x83,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 沓
{0x3724,0x8C43,0xB7A4,0xE99DB4,0x9774,{0x12,0x30,0x12,0x30,0x7f,0xb0,0x12,0x52,0x12,0x52,0x1e,0x54,0x08,0xd8,0x3f,0x50,0x29,0x50,0x29,0x50,0x3f,0x50,0x08,0x51,0x7f,0xd1,0x08,0x51,0x08,0x4f,0x08,0x40}}, // 靴
{0x3725,0x8C44,0xB7A5,0xE8BDA1,0x8F61,{0x10,0x84,0x13,0xe4,0x68,0x9a,0x13,0xe4,0x2a,0xaa,0x7f,0xff,0x12,0xa4,0x3b,0xee,0x34,0x8d,0x53,0xf4,0x10,0x84,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 轡
{0x3726,0x8C45,0xB7A6,0xE7AAAA,0x7AAA,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x22,0x44,0x24,0x42,0x78,0x3e,0x00,0x20,0x31,0xfc,0x08,0x20,0x63,0xfe,0x10,0x20,0x00,0x20,0x09,0xfc,0x10,0x20,0x27,0xff,0x40,0x00}}, // 窪
{0x3727,0x8C46,0xB7A7,0xE7868A,0x718A,{0x08,0x40,0x12,0x44,0x7f,0x78,0x00,0xc2,0x3e,0x42,0x22,0x3e,0x3e,0x00,0x22,0x44,0x3e,0x78,0x22,0x42,0x22,0x42,0x26,0x3e,0x10,0x08,0x14,0x44,0x22,0x22,0x42,0x22}}, // 熊
{0x3728,0x8C47,0xB7A8,0xE99A88,0x9688,{0x00,0x00,0x3d,0xfc,0x25,0x24,0x25,0x24,0x29,0xfc,0x31,0x24,0x29,0x24,0x29,0xfc,0x24,0x00,0x27,0xff,0x25,0x44,0x25,0x28,0x39,0x10,0x21,0x08,0x21,0xc4,0x27,0x03}}, // 隈
{0x3729,0x8C48,0xB7A9,0xE7B282,0x7C82,{0x01,0x00,0x03,0xf0,0x0c,0x20,0x30,0x40,0x00,0xa0,0x03,0x10,0x0c,0x8c,0x78,0x93,0x04,0x90,0x04,0xa0,0x7f,0xff,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80}}, // 粂
{0x372A,0x8C49,0xB7AA,0xE6A097,0x6817,{0x00,0x00,0x7f,0xff,0x02,0x20,0x02,0x20,0x1f,0xfc,0x12,0x24,0x12,0x24,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80,0x00,0x80}}, // 栗
{0x372B,0x8C4A,0xB7AB,0xE7B9B0,0x7E70,{0x08,0x00,0x08,0x7c,0x0a,0x44,0x72,0x44,0x14,0x7c,0x09,0xef,0x0d,0x29,0x13,0x29,0x7d,0xef,0x08,0x10,0x2d,0xff,0x2a,0x38,0x2a,0x54,0x2a,0x92,0x49,0x11,0x08,0x10}}, // 繰
{0x372C,0x8C4B,0xB7AC,0xE6A191,0x6851,{0x00,0x00,0x0f,0xf0,0x02,0x20,0x01,0xc0,0x06,0x30,0x7f,0x7e,0x12,0x24,0x0c,0x98,0x72,0xe7,0x00,0x80,0x7f,0xff,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80}}, // 桑
{0x372D,0x8C4C,0xB7AD,0xE98DAC,0x936C,{0x08,0x28,0x08,0x48,0x15,0xc8,0x12,0x4a,0x21,0x5a,0x7e,0x5a,0x09,0xea,0x08,0x4c,0x7f,0x68,0x08,0xd8,0x4a,0xcc,0x2d,0x54,0x28,0x54,0x0e,0x52,0x18,0x62,0x60,0x41}}, // 鍬
{0x372E,0x8C4D,0xB7AE,0xE58BB2,0x52F2,{0x01,0x10,0x3e,0x10,0x04,0x10,0x7f,0x90,0x04,0x7e,0x3f,0x12,0x25,0x12,0x3f,0x12,0x25,0x12,0x3f,0x22,0x1e,0x22,0x07,0x4c,0x78,0x00,0x12,0x24,0x21,0x12,0x41,0x11}}, // 勲
{0x372F,0x8C4E,0xB7AF,0xE5909B,0x541B,{0x00,0x00,0x1f,0xf8,0x01,0x08,0x01,0x08,0x7f,0xff,0x01,0x08,0x01,0x08,0x1f,0xf8,0x02,0x00,0x02,0x00,0x07,0xfc,0x0c,0x04,0x14,0x04,0x24,0x04,0x47,0xfc,0x04,0x04}}, // 君
{0x3730,0x8C4F,0xB7B0,0xE896AB,0x85AB,{0x04,0x10,0x3f,0xfe,0x04,0x18,0x1f,0xe0,0x00,0x80,0x7f,0xff,0x08,0x88,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x0a,0x44,0x31,0x22}}, // 薫
{0x3731,0x8C50,0xB7B1,0xE8A893,0x8A13,{0x00,0x02,0x3e,0x42,0x00,0x52,0x7f,0x52,0x00,0x52,0x3e,0x52,0x00,0x52,0x00,0x52,0x3e,0x52,0x00,0x52,0x3e,0x52,0x22,0x52,0x22,0x52,0x22,0x82,0x3e,0x82,0x23,0x02}}, // 訓
{0x3732,0x8C51,0xB7B2,0xE7BEA4,0x7FA4,{0x00,0x22,0x3f,0x12,0x09,0x14,0x09,0x7f,0x7f,0x88,0x09,0x08,0x09,0x08,0x3f,0x3e,0x08,0x08,0x10,0x08,0x1f,0x08,0x31,0xff,0x31,0x08,0x51,0x08,0x1f,0x08,0x11,0x08}}, // 群
{0x3733,0x8C52,0xB7B3,0xE8BB8D,0x8ECD,{0x00,0x00,0x1f,0xfe,0x10,0x84,0x20,0x80,0x5f,0xfc,0x00,0x80,0x1f,0xfc,0x10,0x84,0x1f,0xfc,0x10,0x84,0x10,0x84,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80}}, // 軍
{0x3734,0x8C53,0xB7B4,0xE983A1,0x90E1,{0x00,0x00,0x3f,0x3c,0x09,0x24,0x09,0x24,0x7f,0xa8,0x09,0x30,0x09,0x28,0x3f,0x24,0x08,0x24,0x10,0x22,0x1f,0x22,0x31,0x22,0x31,0x32,0x51,0x2c,0x1f,0x20,0x11,0x20}}, // 郡
{0x3735,0x8C54,0xB7B5,0xE58DA6,0x5366,{0x04,0x10,0x04,0x10,0x3f,0x90,0x04,0x10,0x04,0x10,0x04,0x18,0x7f,0xd4,0x04,0x12,0x04,0x12,0x3f,0x90,0x04,0x10,0x04,0x10,0x05,0xd0,0x0e,0x10,0x70,0x10,0x00,0x10}}, // 卦
{0x3736,0x8C55,0xB7B6,0xE8A288,0x8888,{0x04,0x00,0x04,0x3e,0x7f,0xa2,0x04,0xa2,0x08,0xa2,0x08,0xa2,0x13,0x3e,0x20,0xa2,0x00,0x80,0x7f,0xff,0x02,0x84,0x0c,0x48,0x74,0x30,0x04,0x10,0x07,0x8c,0x3c,0x03}}, // 袈
{0x3737,0x8C56,0xB7B7,0xE7A581,0x7941,{0x08,0x00,0x08,0x3e,0x08,0x22,0x7f,0x22,0x01,0x24,0x02,0x24,0x04,0x28,0x0c,0x24,0x1a,0x22,0x29,0x22,0x48,0xa1,0x08,0x31,0x08,0x29,0x08,0x26,0x08,0x20,0x08,0x20}}, // 祁
{0x3738,0x8C57,0xB7B8,0xE4BF82,0x4FC2,{0x04,0x06,0x04,0x38,0x07,0xc0,0x08,0x48,0x08,0x88,0x13,0x10,0x10,0xa0,0x30,0x48,0x50,0x84,0x17,0xfe,0x10,0x22,0x11,0x28,0x11,0x24,0x12,0x22,0x14,0x22,0x10,0x20}}, // 係
{0x3739,0x8C58,0xB7B9,0xE582BE,0x50BE,{0x08,0x00,0x09,0xff,0x08,0x10,0x14,0x20,0x14,0x7e,0x15,0x42,0x36,0x42,0x54,0x7e,0x14,0x42,0x14,0x7e,0x15,0x42,0x15,0x42,0x13,0x7e,0x10,0x14,0x10,0x22,0x10,0xc1}}, // 傾
{0x373A,0x8C59,0xB7BA,0xE58891,0x5211,{0x00,0x02,0x3f,0xe2,0x09,0x22,0x09,0x22,0x09,0x22,0x09,0x22,0x7f,0xe2,0x09,0x22,0x09,0x22,0x09,0x22,0x09,0x22,0x09,0x02,0x11,0x02,0x11,0x02,0x21,0x06,0x41,0x02}}, // 刑
{0x373B,0x8C5A,0xB7BB,0xE58584,0x5144,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x0a,0x48,0x02,0x40,0x02,0x40,0x04,0x40,0x04,0x42,0x08,0x42,0x10,0x22,0x20,0x1e}}, // 兄
{0x373C,0x8C5B,0xB7BC,0xE59593,0x5553,{0x00,0x10,0x7f,0x90,0x00,0x1f,0x1f,0x24,0x11,0x24,0x11,0x54,0x1f,0x08,0x10,0x34,0x20,0xc2,0x20,0x01,0x4f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 啓
{0x373D,0x8C5C,0xB7BD,0xE59CAD,0x572D,{0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x00,0x80,0x3f,0xfe,0x00,0x00,0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 圭
{0x373E,0x8C5D,0xB7BE,0xE78FAA,0x73EA,{0x00,0x20,0x7c,0x20,0x11,0xfc,0x10,0x20,0x10,0x20,0x10,0x20,0x7f,0xff,0x10,0x00,0x10,0x20,0x10,0x20,0x11,0xfc,0x1c,0x20,0x60,0x20,0x00,0x20,0x07,0xff,0x00,0x00}}, // 珪
{0x373F,0x8C5E,0xB7BF,0xE59E8B,0x578B,{0x00,0x04,0x7f,0xa4,0x12,0x24,0x12,0x24,0x12,0x24,0x7f,0xe4,0x12,0x24,0x12,0x24,0x12,0x04,0x22,0x8c,0x40,0x80,0x1f,0xf8,0x00,0x80,0x00,0x80,0x7f,0xfe,0x00,0x00}}, // 型
{0x3740,0x8C5F,0xB7C0,0xE5A591,0x5951,{0x04,0x00,0x04,0x00,0x3f,0xbe,0x04,0x12,0x3f,0x92,0x04,0x12,0x05,0xa2,0x0e,0x22,0x70,0x4c,0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0x40,0x02,0x20,0x0c,0x18,0x70,0x06}}, // 契
{0x3741,0x8C60,0xB7C1,0xE5BDA2,0x5F62,{0x00,0x04,0x3f,0xc4,0x09,0x08,0x09,0x08,0x09,0x12,0x09,0x22,0x7f,0xc4,0x09,0x04,0x09,0x09,0x09,0x11,0x09,0x22,0x11,0x02,0x11,0x04,0x11,0x08,0x21,0x10,0x41,0x20}}, // 形
{0x3742,0x8C61,0xB7C2,0xE5BE84,0x5F84,{0x08,0x00,0x0b,0xfc,0x11,0x04,0x10,0x88,0x24,0x50,0x44,0x30,0x08,0xcc,0x0f,0x03,0x10,0x20,0x10,0x20,0x33,0xfe,0x50,0x20,0x10,0x20,0x10,0x20,0x17,0xff,0x10,0x00}}, // 径
{0x3743,0x8C62,0xB7C3,0xE681B5,0x6075,{0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x1f,0xfc,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x84,0x1f,0xfc,0x00,0x40,0x12,0x24,0x12,0x22,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 恵
{0x3744,0x8C63,0xB7C4,0xE685B6,0x6176,{0x00,0x40,0x1f,0xff,0x11,0x10,0x1f,0xfe,0x11,0x12,0x1f,0xfe,0x10,0x00,0x1f,0xff,0x15,0x44,0x15,0x2a,0x19,0xf9,0x12,0x11,0x2d,0xa0,0x20,0xe0,0x43,0x18,0x1c,0x07}}, // 慶
{0x3745,0x8C64,0xB7C5,0xE685A7,0x6167,{0x08,0x10,0x7f,0xfe,0x08,0x10,0x7e,0xfe,0x08,0x10,0x7f,0xfe,0x08,0x10,0x1f,0xf8,0x00,0x08,0x0f,0xf8,0x00,0x08,0x3f,0xf8,0x14,0x84,0x14,0x52,0x24,0x12,0x43,0xf0}}, // 慧
{0x3746,0x8C65,0xB7C6,0xE686A9,0x61A9,{0x01,0x08,0x06,0x10,0x38,0x7c,0x08,0x44,0x7f,0xc4,0x08,0x7c,0x08,0x44,0x3f,0x7c,0x21,0x44,0x21,0x7c,0x3f,0x44,0x02,0x84,0x12,0x42,0x12,0x09,0x22,0x09,0x41,0xf8}}, // 憩
{0x3747,0x8C66,0xB7C7,0xE68EB2,0x63B2,{0x10,0x00,0x11,0xf8,0x11,0x08,0x11,0xf8,0x7d,0x08,0x11,0x08,0x11,0xf8,0x10,0x80,0x1c,0xfe,0x71,0x02,0x13,0x32,0x15,0xc2,0x11,0x02,0x11,0x12,0x10,0xf2,0x30,0x0c}}, // 掲
{0x3748,0x8C67,0xB7C8,0xE690BA,0x643A,{0x10,0x88,0x10,0x90,0x11,0xfe,0x13,0x10,0x7d,0xfc,0x11,0x10,0x11,0xfc,0x11,0x10,0x1d,0xfe,0x70,0x00,0x17,0xf8,0x10,0x48,0x10,0x4e,0x10,0x82,0x11,0x02,0x36,0x0c}}, // 携
{0x3749,0x8C68,0xB7C9,0xE695AC,0x656C,{0x12,0x20,0x12,0x20,0x7f,0xa0,0x12,0x3f,0x12,0x24,0x10,0x44,0x1f,0xc4,0x21,0x24,0x3d,0x28,0x65,0x18,0x25,0x10,0x3d,0x28,0x25,0x28,0x01,0x44,0x02,0x82,0x0d,0x01}}, // 敬
{0x374A,0x8C69,0xB7CA,0xE699AF,0x666F,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x02,0xb0,0x0c,0x8c,0x30,0x82,0x01,0x80}}, // 景
{0x374B,0x8C6A,0xB7CB,0xE6A182,0x6842,{0x08,0x20,0x08,0x20,0x09,0xfc,0x7e,0x20,0x08,0x20,0x08,0x20,0x1d,0xff,0x1a,0x00,0x1a,0x20,0x28,0x20,0x29,0xfc,0x48,0x20,0x08,0x20,0x08,0x20,0x0b,0xff,0x08,0x00}}, // 桂
{0x374C,0x8C6B,0xB7CC,0xE6B893,0x6E13,{0x10,0x04,0x08,0x18,0x0b,0xe2,0x00,0x42,0x42,0x24,0x21,0x28,0x21,0x00,0x00,0x20,0x09,0xfc,0x08,0x20,0x10,0x20,0x17,0xff,0x20,0x50,0x20,0x88,0x41,0x04,0x46,0x03}}, // 渓
{0x374D,0x8C6C,0xB7CD,0xE795A6,0x7566,{0x00,0x20,0x00,0x20,0x7d,0xfc,0x54,0x20,0x54,0x20,0x54,0x20,0x57,0xff,0x7c,0x20,0x54,0x20,0x54,0x20,0x55,0xfc,0x54,0x20,0x7c,0x20,0x44,0x20,0x03,0xff,0x00,0x00}}, // 畦
{0x374E,0x8C6D,0xB7CE,0xE7A8BD,0x7A3D,{0x02,0x24,0x0c,0x22,0x79,0xff,0x08,0x30,0x08,0x51,0x7e,0x9f,0x09,0x44,0x18,0x78,0x1c,0x41,0x2a,0x3f,0x2a,0xfe,0x48,0x82,0x08,0xfe,0x08,0x82,0x08,0xfe,0x08,0x82}}, // 稽
{0x374F,0x8C6E,0xB7CF,0xE7B3BB,0x7CFB,{0x00,0x0c,0x00,0xf0,0x7f,0x00,0x02,0x20,0x02,0x40,0x1c,0x40,0x02,0x80,0x01,0x20,0x02,0x18,0x7f,0xf4,0x01,0x02,0x05,0x20,0x09,0x18,0x11,0x04,0x61,0x02,0x01,0x00}}, // 系
{0x3750,0x8C6F,0xB7D0,0xE7B58C,0x7D4C,{0x08,0x00,0x08,0xfc,0x0a,0x44,0x72,0x24,0x14,0x28,0x08,0x18,0x0c,0x24,0x12,0xc3,0x7d,0x10,0x09,0x10,0x28,0xfe,0x2a,0x10,0x29,0x10,0x29,0x10,0x49,0xff,0x08,0x00}}, // 経
{0x3751,0x8C70,0xB7D1,0xE7B699,0x7D99,{0x08,0x88,0x08,0xca,0x0a,0xaa,0x72,0xac,0x14,0x88,0x08,0xff,0x0c,0x88,0x12,0x9c,0x7d,0x9c,0x08,0xaa,0x2c,0xaa,0x2a,0xc9,0x2a,0x88,0x2a,0x88,0x48,0xff,0x08,0x80}}, // 継
{0x3752,0x8C71,0xB7D2,0xE7B98B,0x7E4B,{0x04,0x00,0x7f,0xbc,0x04,0x25,0x3f,0x25,0x25,0x43,0x3f,0xfc,0x25,0x24,0x3f,0x18,0x04,0xa4,0x7f,0xa3,0x07,0x50,0x01,0x8c,0x7f,0xfa,0x05,0x21,0x19,0x18,0x61,0x04}}, // 繋
{0x3753,0x8C72,0xB7D3,0xE7BDAB,0x7F6B,{0x00,0x00,0x3f,0xfe,0x22,0x22,0x22,0x22,0x3f,0xfe,0x22,0x12,0x1f,0x90,0x02,0x10,0x02,0x18,0x7f,0xd4,0x02,0x12,0x1f,0x91,0x02,0x10,0x03,0xd0,0x7c,0x10,0x00,0x10}}, // 罫
{0x3754,0x8C73,0xB7D4,0xE88C8E,0x830E,{0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x00,0x00,0x1f,0xf8,0x04,0x10,0x03,0x20,0x00,0xc0,0x07,0xb8,0x78,0x87,0x0f,0xf8,0x00,0x80,0x00,0x80,0x7f,0xfe,0x00,0x00}}, // 茎
{0x3755,0x8C74,0xB7D5,0xE88D8A,0x834A,{0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x00,0x02,0x3f,0xd2,0x09,0x12,0x09,0x12,0x09,0x12,0x7f,0xf2,0x09,0x12,0x09,0x12,0x09,0x12,0x09,0x02,0x11,0x02,0x21,0x06}}, // 荊
{0x3756,0x8C75,0xB7D6,0xE89B8D,0x86CD,{0x02,0x08,0x11,0x08,0x09,0x10,0x08,0x20,0x3f,0xfe,0x21,0x04,0x41,0x00,0x1f,0xf8,0x11,0x08,0x11,0x08,0x11,0x08,0x1f,0xf8,0x01,0x10,0x01,0x0c,0x01,0xf2,0x7e,0x01}}, // 蛍
{0x3757,0x8C76,0xB7D7,0xE8A888,0x8A08,{0x00,0x10,0x3f,0x10,0x00,0x10,0x7f,0x90,0x00,0x10,0x3f,0x10,0x00,0xff,0x00,0x10,0x3f,0x10,0x00,0x10,0x3f,0x10,0x21,0x10,0x21,0x10,0x21,0x10,0x3f,0x10,0x21,0x10}}, // 計
{0x3758,0x8C77,0xB7D8,0xE8A9A3,0x8A63,{0x00,0x40,0x3e,0x46,0x00,0x78,0x7f,0x40,0x00,0x41,0x3e,0x41,0x00,0x3f,0x00,0x00,0x3e,0x7e,0x00,0x42,0x3e,0x42,0x22,0x7e,0x22,0x42,0x22,0x42,0x3e,0x7e,0x22,0x42}}, // 詣
{0x3759,0x8C78,0xB7D9,0xE8ADA6,0x8B66,{0x12,0x20,0x7f,0xa0,0x12,0x7f,0x1f,0xc4,0x3d,0x28,0x55,0x10,0x1d,0x6c,0x06,0x83,0x07,0xe0,0x00,0x00,0x7f,0xfe,0x00,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10}}, // 警
{0x375A,0x8C79,0xB7DA,0xE8BBBD,0x8EFD,{0x08,0x00,0x08,0xfe,0x7f,0x42,0x08,0x24,0x3e,0x28,0x2a,0x10,0x2a,0x6c,0x3f,0x83,0x2a,0x10,0x2a,0x10,0x3e,0xfe,0x08,0x10,0x7f,0x10,0x08,0x10,0x09,0xff,0x08,0x00}}, // 軽
{0x375B,0x8C7A,0xB7DB,0xE9A09A,0x981A,{0x00,0x00,0x7e,0xff,0x22,0x10,0x14,0x20,0x08,0x7e,0x08,0x42,0x14,0x42,0x22,0x7e,0x49,0x42,0x08,0x7e,0x3e,0x42,0x08,0x42,0x09,0x7e,0x0e,0x24,0x70,0x42,0x01,0x81}}, // 頚
{0x375C,0x8C7B,0xB7DC,0xE9B68F,0x9D8F,{0x06,0x10,0x79,0x20,0x11,0xfc,0x4a,0x84,0x2a,0xfc,0x24,0x84,0x08,0xfc,0x3e,0x80,0x08,0xff,0x08,0x80,0x7f,0xfe,0x08,0x52,0x14,0xaa,0x12,0xaa,0x23,0x02,0x40,0x0c}}, // 鶏
{0x375D,0x8C7C,0xB7DD,0xE88AB8,0x82B8,{0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x02,0x10,0x00,0x00,0x1f,0xfc,0x00,0x00,0x00,0x00,0x7f,0xff,0x01,0x00,0x01,0x20,0x02,0x10,0x04,0xf8,0x3f,0x04,0x00,0x04}}, // 芸
{0x375E,0x8C7D,0xB7DE,0xE8BF8E,0x8FCE,{0x00,0x20,0x20,0x40,0x11,0x9e,0x11,0x12,0x01,0x12,0x01,0x12,0x01,0x12,0x79,0x12,0x09,0x12,0x09,0x52,0x09,0x92,0x0b,0x1c,0x0c,0x10,0x16,0x10,0x21,0x00,0x40,0xff}}, // 迎
{0x375F,0x8C7E,0xB7DF,0xE9AFA8,0x9BE8,{0x08,0x10,0x0e,0x10,0x12,0xff,0x24,0x00,0x7f,0x7c,0x29,0x44,0x29,0x44,0x3f,0x44,0x29,0x7c,0x29,0x10,0x3f,0x58,0x02,0x54,0x35,0x52,0x2a,0x92,0x2a,0x10,0x40,0x30}}, // 鯨
{0x3760,0x8C80,0xB7E0,0xE58A87,0x5287,{0x04,0x02,0x07,0x92,0x04,0x12,0x3f,0xd2,0x25,0x52,0x3e,0x12,0x24,0x92,0x23,0x92,0x3f,0xd2,0x26,0x12,0x3a,0x52,0x25,0x42,0x3b,0x82,0x25,0x42,0x59,0x26,0x06,0x02}}, // 劇
{0x3761,0x8C81,0xB7E1,0xE6889F,0x621F,{0x04,0x20,0x04,0x28,0x7f,0xa4,0x04,0x20,0x04,0x27,0x3f,0xf8,0x21,0x24,0x3f,0x24,0x21,0x24,0x21,0x28,0x3f,0x18,0x04,0x12,0x7f,0xaa,0x04,0x2a,0x04,0x46,0x04,0x82}}, // 戟
{0x3762,0x8C82,0xB7E2,0xE69283,0x6483,{0x08,0x3c,0x7f,0xa5,0x29,0x25,0x3f,0x43,0x29,0xfc,0x3f,0x24,0x08,0x18,0x7f,0xa4,0x08,0x53,0x07,0xe0,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x80,0x01,0x80}}, // 撃
{0x3763,0x8C83,0xB7E3,0xE6BF80,0x6FC0,{0x21,0x10,0x12,0x10,0x17,0x90,0x04,0x9f,0x07,0x94,0x44,0xa4,0x27,0xa4,0x21,0x54,0x0f,0xd4,0x12,0x18,0x13,0x88,0x12,0x88,0x24,0x94,0x24,0x94,0x4b,0x22,0x50,0x41}}, // 激
{0x3764,0x8C84,0xB7E4,0xE99A99,0x9699,{0x00,0x20,0x3c,0xa8,0x24,0xa4,0x25,0x22,0x2e,0x20,0x31,0xfc,0x29,0x04,0x29,0xfc,0x25,0x04,0x25,0xfc,0x24,0x20,0x24,0xa8,0x38,0xa4,0x21,0x22,0x22,0x22,0x20,0x60}}, // 隙
{0x3765,0x8C85,0xB7E5,0xE6A181,0x6841,{0x08,0x40,0x08,0x5e,0x08,0x40,0x7e,0x80,0x08,0x80,0x09,0x20,0x1c,0x3f,0x1a,0x44,0x18,0x44,0x28,0x84,0x29,0x84,0x4a,0x84,0x08,0x84,0x08,0x84,0x08,0x8c,0x08,0x84}}, // 桁
{0x3766,0x8C86,0xB7E6,0xE58291,0x5091,{0x05,0x04,0x05,0xc4,0x05,0x7f,0x0b,0x54,0x0a,0xd4,0x14,0x94,0x10,0xbf,0x31,0x04,0x52,0x24,0x10,0x20,0x17,0xff,0x10,0x68,0x10,0xa4,0x11,0x22,0x12,0x21,0x10,0x20}}, // 傑
{0x3767,0x8C87,0xB7E7,0xE6ACA0,0x6B20,{0x04,0x00,0x04,0x00,0x04,0x00,0x08,0x00,0x0f,0xff,0x10,0x82,0x10,0x84,0x20,0x88,0x40,0x80,0x01,0x40,0x01,0x40,0x02,0x20,0x02,0x10,0x04,0x08,0x18,0x04,0x60,0x03}}, // 欠
{0x3768,0x8C88,0xB7E8,0xE6B1BA,0x6C7A,{0x10,0x40,0x08,0x40,0x08,0x40,0x07,0xfc,0x40,0x44,0x20,0x44,0x20,0x44,0x00,0x44,0x0f,0xff,0x08,0x40,0x10,0xa0,0x10,0xa0,0x21,0x10,0x22,0x08,0x44,0x04,0x48,0x03}}, // 決
{0x3769,0x8C89,0xB7E9,0xE6BD94,0x6F54,{0x21,0x00,0x17,0xde,0x11,0x0a,0x07,0xca,0x01,0x12,0x41,0xa2,0x26,0x4c,0x20,0x20,0x09,0xc8,0x08,0x58,0x10,0x26,0x17,0xfd,0x21,0x28,0x21,0x24,0x42,0x22,0x44,0x20}}, // 潔
{0x376A,0x8C8A,0xB7EA,0xE7A9B4,0x7A74,{0x01,0x00,0x01,0x00,0x01,0x02,0x3f,0xff,0x20,0x02,0x20,0x04,0x43,0xe0,0x00,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x08,0x10,0x08,0x10,0x10,0x08,0x20,0x04,0x40,0x02}}, // 穴
{0x376B,0x8C8B,0xB7EB,0xE7B590,0x7D50,{0x08,0x10,0x08,0x10,0x12,0x10,0x65,0xff,0x14,0x10,0x08,0x10,0x0c,0x10,0x12,0xfe,0x7d,0x00,0x09,0x00,0x28,0x7e,0x2a,0x42,0x29,0x42,0x29,0x42,0x48,0x7e,0x08,0x42}}, // 結
{0x376C,0x8C8C,0xB7EC,0xE8A180,0x8840,{0x01,0x00,0x01,0x00,0x02,0x00,0x1f,0xfc,0x12,0x44,0x12,0x44,0x12,0x44,0x12,0x44,0x12,0x44,0x12,0x44,0x12,0x44,0x12,0x44,0x12,0x44,0x7f,0xff,0x00,0x00,0x00,0x00}}, // 血
{0x376D,0x8C8D,0xB7ED,0xE8A8A3,0x8A23,{0x00,0x20,0x3e,0x20,0x00,0x20,0x7f,0xfc,0x00,0x24,0x3e,0x24,0x00,0x24,0x00,0x24,0x3f,0xff,0x00,0x20,0x3e,0x30,0x22,0x30,0x22,0x48,0x22,0x44,0x3e,0x82,0x23,0x01}}, // 訣
{0x376E,0x8C8E,0xB7EE,0xE69C88,0x6708,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x10,0x08,0x10,0x08,0x20,0x18,0x40,0x08}}, // 月
{0x376F,0x8C8F,0xB7EF,0xE4BBB6,0x4EF6,{0x04,0x20,0x05,0x20,0x05,0x20,0x09,0x20,0x09,0xfe,0x12,0x20,0x12,0x20,0x34,0x20,0x50,0x20,0x13,0xff,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20}}, // 件
{0x3770,0x8C90,0xB7F0,0xE580B9,0x5039,{0x04,0x20,0x04,0x20,0x04,0x50,0x08,0x88,0x09,0x04,0x1b,0xfe,0x1c,0x21,0x29,0xfc,0x49,0x24,0x09,0x24,0x09,0xfc,0x08,0x30,0x08,0x50,0x08,0x88,0x09,0x04,0x0e,0x03}}, // 倹
{0x3771,0x8C91,0xB7F1,0xE580A6,0x5026,{0x05,0x24,0x04,0xa4,0x04,0xa8,0x0f,0xfe,0x08,0x50,0x10,0x50,0x17,0xff,0x30,0x88,0x51,0x04,0x12,0xf2,0x14,0x11,0x10,0x10,0x11,0xf0,0x11,0x04,0x11,0x04,0x10,0xfc}}, // 倦
{0x3772,0x8C92,0xB7F2,0xE581A5,0x5065,{0x08,0x08,0x0f,0xbe,0x08,0x8a,0x09,0x0a,0x11,0x7f,0x12,0x0a,0x37,0x8a,0x30,0xbe,0x52,0x88,0x12,0xbe,0x12,0x88,0x11,0x7f,0x11,0x08,0x12,0x88,0x14,0x60,0x18,0x1f}}, // 健
{0x3773,0x8C93,0xB7F3,0xE585BC,0x517C,{0x08,0x10,0x04,0x20,0x7f,0xfe,0x02,0x40,0x1f,0xf8,0x02,0x48,0x02,0x48,0x7f,0xfe,0x02,0x48,0x1f,0xf8,0x02,0x40,0x06,0x60,0x0a,0x50,0x12,0x48,0x62,0x46,0x02,0x40}}, // 兼
{0x3774,0x8C94,0xB7F4,0xE588B8,0x5238,{0x08,0x88,0x04,0x88,0x04,0x90,0x1f,0xfe,0x00,0x80,0x01,0x40,0x7f,0xff,0x02,0x20,0x04,0x10,0x1f,0xfc,0x61,0x13,0x01,0x10,0x02,0x10,0x02,0x10,0x04,0x10,0x18,0x60}}, // 券
{0x3775,0x8C95,0xB7F5,0xE589A3,0x5263,{0x04,0x02,0x04,0x12,0x0a,0x12,0x09,0x12,0x10,0x92,0x3f,0x52,0x44,0x12,0x3f,0x92,0x24,0x92,0x24,0x92,0x3f,0x92,0x06,0x12,0x05,0x02,0x08,0x82,0x10,0x86,0x60,0x02}}, // 剣
{0x3776,0x8C96,0xB7F6,0xE596A7,0x55A7,{0x00,0x20,0x00,0x20,0x7b,0xff,0x4a,0x02,0x4c,0x00,0x49,0xfe,0x48,0x00,0x48,0xfc,0x48,0x84,0x48,0xfc,0x48,0x84,0x78,0x84,0x48,0xfc,0x00,0x00,0x07,0xff,0x00,0x00}}, // 喧
{0x3777,0x8C97,0xB7F7,0xE59C8F,0x570F,{0x00,0x00,0x3f,0xfe,0x24,0x92,0x22,0xa2,0x2f,0xfa,0x21,0x42,0x3f,0xfe,0x22,0x22,0x27,0xf2,0x38,0x2e,0x27,0xe2,0x24,0x12,0x23,0xf2,0x20,0x02,0x3f,0xfe,0x20,0x02}}, // 圏
{0x3778,0x8C98,0xB7F8,0xE5A085,0x5805,{0x00,0x00,0x3f,0xfc,0x24,0x24,0x24,0x24,0x3f,0x14,0x21,0x18,0x3f,0x08,0x24,0x14,0x24,0x62,0x3f,0x81,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 堅
{0x3779,0x8C99,0xB7F9,0xE5AB8C,0x5ACC,{0x11,0x04,0x10,0x88,0x13,0xff,0x10,0x50,0x7f,0xfc,0x12,0x54,0x12,0x54,0x13,0xff,0x22,0x54,0x24,0x54,0x7d,0xfc,0x06,0x58,0x0a,0xd4,0x11,0x52,0x62,0x51,0x00,0x50}}, // 嫌
{0x377A,0x8C9A,0xB7FA,0xE5BBBA,0x5EFA,{0x00,0x20,0x7d,0xfc,0x04,0x24,0x08,0x24,0x13,0xff,0x20,0x24,0x3d,0xfc,0x04,0x20,0x45,0xfc,0x24,0x20,0x18,0x20,0x0b,0xfe,0x14,0x20,0x13,0x20,0x20,0xc0,0x40,0x3f}}, // 建
{0x377B,0x8C9B,0xB7FB,0xE686B2,0x61B2,{0x01,0x00,0x3f,0xfe,0x21,0x04,0x3f,0xf8,0x41,0x00,0x0f,0xf0,0x01,0x00,0x7f,0xfe,0x00,0x00,0x1f,0xf8,0x12,0x48,0x1f,0xf8,0x24,0x88,0x24,0x44,0x44,0x12,0x03,0xf2}}, // 憲
{0x377C,0x8C9C,0xB7FC,0xE687B8,0x61F8,{0x00,0x06,0x5e,0x78,0x52,0x10,0x5e,0x14,0x52,0x68,0x5e,0x14,0x52,0xfe,0x7f,0x91,0x0c,0x54,0x2a,0x52,0x2a,0x92,0x48,0x40,0x12,0x42,0x12,0x01,0x22,0x09,0x41,0xf8}}, // 懸
{0x377D,0x8C9D,0xB7FD,0xE68BB3,0x62F3,{0x08,0x88,0x04,0x88,0x04,0x90,0x3f,0xfe,0x01,0x40,0x7f,0xff,0x02,0x20,0x04,0x50,0x1b,0x8c,0x60,0x83,0x0f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x01,0x80}}, // 拳
{0x377E,0x8C9E,0xB7FE,0xE68DB2,0x6372,{0x11,0x24,0x10,0xa4,0x10,0xa8,0x13,0xfe,0x7c,0x20,0x10,0x50,0x13,0xff,0x10,0x50,0x1c,0x88,0x71,0xf4,0x16,0x13,0x10,0x10,0x11,0xf0,0x11,0x04,0x11,0x04,0x30,0xfc}}, // 捲
{0x3821,0x8C9F,0xB8A1,0xE6A49C,0x691C,{0x08,0x20,0x08,0x20,0x08,0x50,0x7e,0x88,0x09,0x04,0x0b,0xfe,0x18,0x21,0x1d,0xfc,0x1b,0x24,0x29,0x24,0x29,0xfc,0x48,0x30,0x08,0x30,0x08,0x48,0x09,0x84,0x0e,0x02}}, // 検
{0x3822,0x8CA0,0xB8A2,0xE6A8A9,0x6A29,{0x08,0x80,0x08,0x80,0x08,0xfe,0x7f,0x20,0x09,0x20,0x0b,0xff,0x18,0x48,0x1c,0x50,0x1a,0xfe,0x28,0x90,0x29,0xfe,0x4a,0x90,0x08,0xfe,0x08,0x90,0x08,0xff,0x08,0x80}}, // 権
{0x3823,0x8CA1,0xB8A3,0xE789BD,0x727D,{0x01,0x00,0x01,0x00,0x3f,0xfc,0x06,0x60,0x03,0x80,0x3f,0xfe,0x22,0x44,0x44,0x30,0x1f,0xe8,0x09,0x00,0x0f,0xf0,0x11,0x00,0x21,0x00,0x7f,0xfe,0x01,0x00,0x01,0x00}}, // 牽
{0x3824,0x8CA2,0xB8A4,0xE78AAC,0x72AC,{0x00,0x80,0x00,0x90,0x00,0x88,0x00,0x84,0x00,0x84,0x7f,0xff,0x00,0x80,0x00,0x80,0x01,0x40,0x01,0x40,0x02,0x20,0x02,0x20,0x04,0x10,0x08,0x08,0x10,0x04,0x60,0x03}}, // 犬
{0x3825,0x8CA3,0xB8A5,0xE78CAE,0x732E,{0x04,0x08,0x04,0x08,0x7f,0xca,0x04,0x09,0x04,0x09,0x3f,0xff,0x32,0x88,0x2a,0x88,0x2c,0x88,0x3f,0x94,0x24,0x94,0x3f,0x94,0x24,0xa4,0x24,0xa2,0x24,0xc2,0x21,0x81}}, // 献
{0x3826,0x8CA4,0xB8A6,0xE7A094,0x7814,{0x00,0x00,0x7f,0xfe,0x08,0x44,0x08,0x44,0x08,0x44,0x08,0x44,0x10,0x44,0x1f,0xff,0x12,0x44,0x32,0x44,0x52,0x44,0x12,0x44,0x1e,0x44,0x12,0x84,0x10,0x84,0x01,0x04}}, // 研
{0x3827,0x8CA5,0xB8A7,0xE7A1AF,0x786F,{0x00,0x00,0x7f,0xfe,0x08,0x42,0x08,0x42,0x08,0x7e,0x10,0x42,0x1e,0x42,0x32,0x7e,0x32,0x42,0x52,0x42,0x12,0x7e,0x12,0x28,0x1e,0x28,0x12,0x49,0x10,0x89,0x03,0x07}}, // 硯
{0x3828,0x8CA6,0xB8A8,0xE7B5B9,0x7D79,{0x08,0x00,0x08,0x7e,0x0a,0x42,0x72,0x42,0x14,0x7e,0x08,0x00,0x0a,0x7e,0x12,0x42,0x7f,0x42,0x09,0x7e,0x2c,0x42,0x2a,0x42,0x2a,0x7e,0x29,0x42,0x48,0x46,0x08,0x42}}, // 絹
{0x3829,0x8CA7,0xB8A9,0xE79C8C,0x770C,{0x00,0x00,0x07,0xf8,0x24,0x08,0x24,0x08,0x27,0xf8,0x24,0x08,0x27,0xf8,0x24,0x08,0x24,0x08,0x27,0xf8,0x20,0x00,0x3f,0xff,0x24,0xb0,0x18,0x8c,0x60,0x82,0x00,0x80}}, // 県
{0x382A,0x8CA8,0xB8AA,0xE882A9,0x80A9,{0x00,0x00,0x7f,0xff,0x00,0x00,0x1f,0xfc,0x10,0x04,0x10,0x04,0x1f,0xfc,0x10,0x00,0x17,0xf8,0x14,0x08,0x17,0xf8,0x24,0x08,0x27,0xf8,0x44,0x08,0x04,0x18,0x04,0x08}}, // 肩
{0x382B,0x8CA9,0xB8AB,0xE8A68B,0x898B,{0x00,0x00,0x07,0xf8,0x04,0x08,0x04,0x08,0x07,0xf8,0x04,0x08,0x04,0x08,0x07,0xf8,0x04,0x08,0x04,0x08,0x07,0xf8,0x01,0x20,0x01,0x20,0x02,0x21,0x0c,0x21,0x70,0x1f}}, // 見
{0x382C,0x8CAA,0xB8AC,0xE8AC99,0x8B19,{0x01,0x04,0x3c,0x88,0x03,0xff,0x7e,0x50,0x01,0xfc,0x3c,0x54,0x00,0x54,0x03,0xff,0x3c,0x54,0x01,0xfc,0x3c,0x50,0x24,0xd8,0x24,0xd4,0x25,0x52,0x3e,0x51,0x24,0x50}}, // 謙
{0x382D,0x8CAB,0xB8AD,0xE8B3A2,0x8CE2,{0x00,0x00,0x3f,0xfc,0x24,0x44,0x3f,0x28,0x21,0x10,0x3f,0x28,0x24,0xc6,0x3f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x06,0x30,0x38,0x0c}}, // 賢
{0x382E,0x8CAC,0xB8AE,0xE8BB92,0x8ED2,{0x04,0x00,0x04,0x7e,0x7f,0x90,0x04,0x10,0x3f,0x10,0x25,0x10,0x25,0x10,0x3f,0xff,0x25,0x10,0x25,0x10,0x3f,0x10,0x04,0x10,0x7f,0x90,0x04,0x10,0x04,0x10,0x04,0x10}}, // 軒
{0x382F,0x8CAD,0xB8AF,0xE981A3,0x9063,{0x00,0x20,0x21,0xfc,0x11,0x24,0x11,0xfc,0x00,0x20,0x07,0xff,0x00,0x00,0x79,0xf8,0x09,0x08,0x09,0xf8,0x09,0x00,0x09,0xfc,0x15,0x04,0x13,0xfc,0x21,0x80,0x40,0x7f}}, // 遣
{0x3830,0x8CAE,0xB8B0,0xE98DB5,0x9375,{0x10,0x10,0x10,0x10,0x1b,0xfc,0x28,0x94,0x25,0xff,0x79,0x14,0x12,0x14,0x13,0xfc,0x7c,0x90,0x12,0xfc,0x56,0x90,0x39,0x7e,0x31,0x90,0x15,0x50,0x1a,0x30,0x64,0x0f}}, // 鍵
{0x3831,0x8CAF,0xB8B1,0xE999BA,0x967A,{0x00,0x20,0x3c,0x20,0x24,0x50,0x24,0x88,0x29,0x04,0x33,0xfe,0x28,0x21,0x29,0xfc,0x25,0x24,0x25,0x24,0x25,0xfc,0x24,0x20,0x38,0x50,0x20,0x88,0x21,0x04,0x26,0x03}}, // 険
{0x3832,0x8CB0,0xB8B2,0xE9A195,0x9855,{0x00,0x00,0x3f,0xff,0x22,0x10,0x22,0x20,0x3e,0x7e,0x22,0x42,0x22,0x42,0x3e,0x7e,0x14,0x42,0x15,0x7e,0x55,0x42,0x36,0x42,0x34,0x7e,0x17,0x24,0x1c,0x42,0x71,0x81}}, // 顕
{0x3833,0x8CB1,0xB8B3,0xE9A893,0x9A13,{0x00,0x10,0x3f,0x90,0x24,0x28,0x24,0x24,0x3f,0x7e,0x24,0x91,0x3f,0x7e,0x24,0x52,0x24,0x52,0x3f,0x7e,0x05,0x10,0x2b,0x18,0x2b,0x28,0x29,0x24,0x41,0x42,0x06,0x81}}, // 験
{0x3834,0x8CB2,0xB8B4,0xE9B9B8,0x9E78,{0x08,0x10,0x08,0x10,0x0f,0x28,0x08,0x24,0x08,0x7e,0x7f,0x91,0x49,0x7e,0x45,0x52,0x55,0x52,0x4b,0x7e,0x6d,0x10,0x4b,0x18,0x51,0x28,0x49,0x24,0x7f,0x42,0x41,0x81}}, // 鹸
{0x3835,0x8CB3,0xB8B5,0xE58583,0x5143,{0x00,0x00,0x0f,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7f,0xff,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x04,0x20,0x04,0x20,0x08,0x21,0x10,0x11,0x20,0x0f}}, // 元
{0x3836,0x8CB4,0xB8B6,0xE58E9F,0x539F,{0x00,0x00,0x1f,0xff,0x10,0x40,0x10,0x80,0x13,0xf8,0x12,0x08,0x13,0xf8,0x12,0x08,0x12,0x08,0x13,0xf8,0x10,0x40,0x12,0x48,0x22,0x44,0x24,0x42,0x48,0xc2,0x00,0x40}}, // 原
{0x3837,0x8CB5,0xB8B7,0xE58EB3,0x53B3,{0x08,0x84,0x04,0x48,0x1f,0xff,0x10,0x10,0x17,0xd0,0x11,0x10,0x1f,0xdf,0x14,0xa4,0x17,0xa4,0x14,0xd4,0x17,0x94,0x14,0x88,0x24,0xc8,0x27,0x94,0x5c,0xa2,0x00,0xc1}}, // 厳
{0x3838,0x8CB6,0xB8B8,0xE5B9BB,0x5E7B,{0x04,0x00,0x04,0x7e,0x04,0x02,0x08,0x02,0x09,0x02,0x71,0x02,0x11,0x02,0x0a,0x02,0x06,0x02,0x04,0x02,0x05,0x02,0x08,0x82,0x08,0x82,0x7f,0x42,0x00,0x44,0x00,0x18}}, // 幻
{0x3839,0x8CB7,0xB8B9,0xE5BCA6,0x5F26,{0x00,0x20,0x7c,0x20,0x04,0x20,0x07,0xff,0x04,0x20,0x3c,0x20,0x20,0x48,0x21,0x88,0x3c,0x50,0x24,0x50,0x04,0x20,0x04,0x28,0x04,0x44,0x04,0x9c,0x0b,0xe2,0x30,0x02}}, // 弦
{0x383A,0x8CB8,0xB8BA,0xE6B89B,0x6E1B,{0x10,0x14,0x08,0x12,0x08,0x12,0x03,0xff,0x42,0x10,0x23,0xf2,0x22,0x12,0x03,0xd2,0x0b,0x54,0x0b,0x5c,0x13,0x48,0x13,0xd8,0x25,0x25,0x24,0x45,0x48,0x83,0x51,0x01}}, // 減
{0x383B,0x8CB9,0xB8BB,0xE6BA90,0x6E90,{0x10,0x00,0x0b,0xfe,0x0a,0x10,0x02,0x20,0x42,0xfc,0x22,0x84,0x22,0x84,0x02,0xfc,0x0a,0x84,0x0a,0xfc,0x12,0x20,0x12,0xa8,0x24,0xa4,0x25,0x22,0x4a,0x62,0x40,0x20}}, // 源
{0x383C,0x8CBA,0xB8BC,0xE78E84,0x7384,{0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xfe,0x00,0x80,0x00,0x80,0x01,0x10,0x0e,0x10,0x01,0x20,0x01,0x40,0x00,0x80,0x01,0x10,0x02,0x08,0x04,0x7c,0x3f,0x82,0x00,0x02}}, // 玄
{0x383D,0x8CBB,0xB8BD,0xE78FBE,0x73FE,{0x00,0x00,0x01,0xfc,0x7d,0x04,0x11,0x04,0x11,0xfc,0x11,0x04,0x7d,0xfc,0x11,0x04,0x11,0x04,0x11,0xfc,0x10,0x50,0x1c,0x50,0x60,0x90,0x01,0x11,0x06,0x11,0x18,0x0f}}, // 現
{0x383E,0x8CBC,0xB8BE,0xE7B583,0x7D43,{0x08,0x10,0x08,0x10,0x0a,0x10,0x73,0xff,0x14,0x10,0x08,0x10,0x0a,0x24,0x12,0xc4,0x7f,0x28,0x09,0x28,0x2c,0x10,0x2a,0x14,0x2a,0x22,0x28,0x4e,0x49,0xf1,0x08,0x01}}, // 絃
{0x383F,0x8CBD,0xB8BF,0xE888B7,0x8237,{0x04,0x10,0x08,0x10,0x1f,0x10,0x11,0xff,0x19,0x08,0x15,0x08,0x15,0x10,0x7f,0x74,0x11,0x14,0x19,0x08,0x15,0x08,0x15,0x14,0x15,0x12,0x21,0x2e,0x21,0xf1,0x43,0x01}}, // 舷
{0x3840,0x8CBE,0xB8C0,0xE8A880,0x8A00,{0x00,0x00,0x07,0xf0,0x00,0x00,0x7f,0xff,0x00,0x00,0x0f,0xf8,0x00,0x00,0x00,0x00,0x0f,0xf8,0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 言
{0x3841,0x8CBF,0xB8C1,0xE8ABBA,0x8AFA,{0x00,0x10,0x3c,0x10,0x01,0xff,0x7e,0x44,0x00,0x28,0x3c,0xff,0x00,0x84,0x00,0x88,0x3c,0xb2,0x00,0x84,0x3c,0x88,0x24,0xb1,0x25,0x02,0x25,0x0c,0x3e,0x30,0x24,0xc0}}, // 諺
{0x3842,0x8CC0,0xB8C2,0xE99990,0x9650,{0x00,0x00,0x3c,0xfc,0x24,0x84,0x24,0x84,0x28,0xfc,0x30,0x84,0x28,0x84,0x24,0xfe,0x22,0xa2,0x22,0x94,0x22,0x94,0x32,0x88,0x2c,0x88,0x20,0xa4,0x20,0xc2,0x23,0x01}}, // 限
{0x3843,0x8CC1,0xB8C3,0xE4B98E,0x4E4E,{0x00,0x04,0x00,0x38,0x3f,0xc0,0x00,0x84,0x08,0x84,0x04,0x88,0x04,0x90,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x03,0x80,0x00,0x80}}, // 乎
{0x3844,0x8CC2,0xB8C4,0xE5808B,0x500B,{0x04,0x00,0x07,0xfe,0x06,0x22,0x0a,0x22,0x0a,0x22,0x13,0xfe,0x12,0x22,0x32,0x22,0x52,0xfa,0x12,0x8a,0x12,0x8a,0x12,0xfa,0x12,0x8a,0x12,0x02,0x13,0xfe,0x12,0x02}}, // 個
{0x3845,0x8CC3,0xB8C5,0xE58FA4,0x53E4,{0x00,0x80,0x00,0x80,0x00,0x82,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 古
{0x3846,0x8CC4,0xB8C6,0xE591BC,0x547C,{0x00,0x06,0x00,0x38,0x7d,0xe0,0x44,0x22,0x45,0x22,0x44,0xa4,0x44,0xa8,0x44,0x20,0x47,0xff,0x44,0x20,0x44,0x20,0x7c,0x20,0x44,0x20,0x00,0x20,0x00,0x60,0x00,0x20}}, // 呼
{0x3847,0x8CC5,0xB8C7,0xE59BBA,0x56FA,{0x00,0x00,0x3f,0xfe,0x20,0x82,0x20,0x82,0x20,0x82,0x3f,0xfe,0x20,0x82,0x20,0x82,0x27,0xf2,0x24,0x12,0x24,0x12,0x27,0xf2,0x24,0x12,0x20,0x02,0x3f,0xfe,0x20,0x02}}, // 固
{0x3848,0x8CC6,0xB8C8,0xE5A791,0x59D1,{0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x7f,0xff,0x12,0x20,0x12,0x20,0x12,0x20,0x22,0x20,0x22,0xfc,0x7c,0x84,0x04,0x84,0x0a,0x84,0x12,0x84,0x60,0xfc,0x00,0x84}}, // 姑
{0x3849,0x8CC7,0xB8C9,0xE5ADA4,0x5B64,{0x00,0x02,0x7e,0x0c,0x03,0xf4,0x05,0x04,0x09,0x24,0x09,0x24,0x0b,0x24,0x0d,0x24,0x79,0x24,0x09,0x24,0x09,0x24,0x09,0x34,0x0a,0x2a,0x0a,0x3a,0x0d,0xc6,0x18,0x01}}, // 孤
{0x384A,0x8CC8,0xB8CA,0xE5B7B1,0x5DF1,{0x00,0x00,0x3f,0xf8,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x1f,0xf8,0x10,0x08,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x04,0x10,0x04,0x08,0x04,0x07,0xfc,0x00,0x00}}, // 己
{0x384B,0x8CC9,0xB8CB,0xE5BAAB,0x5EAB,{0x00,0x40,0x1f,0xff,0x10,0x40,0x10,0x40,0x1f,0xfe,0x10,0x40,0x17,0xfc,0x14,0x44,0x17,0xfc,0x14,0x44,0x14,0x44,0x27,0xfc,0x20,0x40,0x3f,0xff,0x40,0x40,0x00,0x40}}, // 庫
{0x384C,0x8CCA,0xB8CC,0xE5BCA7,0x5F27,{0x00,0x02,0x78,0x1c,0x09,0xe4,0x09,0x04,0x09,0x24,0x79,0x24,0x41,0x24,0x41,0x24,0x79,0x24,0x49,0x24,0x09,0x24,0x09,0x34,0x09,0x2c,0x0a,0x3a,0x12,0xc6,0x64,0x01}}, // 弧
{0x384D,0x8CCB,0xB8CD,0xE688B8,0x6238,{0x00,0x00,0x7f,0xfe,0x00,0x00,0x00,0x00,0x1f,0xfc,0x10,0x04,0x10,0x04,0x10,0x04,0x1f,0xfc,0x10,0x04,0x10,0x00,0x10,0x00,0x10,0x00,0x20,0x00,0x20,0x00,0x40,0x00}}, // 戸
{0x384E,0x8CCC,0xB8CE,0xE69585,0x6545,{0x08,0x40,0x08,0x40,0x08,0x40,0x7f,0x7f,0x08,0x44,0x08,0x84,0x08,0xc4,0x09,0x44,0x3e,0x28,0x22,0x28,0x22,0x10,0x22,0x18,0x22,0x28,0x3e,0xc4,0x23,0x02,0x00,0x01}}, // 故
{0x384F,0x8CCD,0xB8CF,0xE69EAF,0x67AF,{0x08,0x20,0x08,0x20,0x08,0x20,0x7f,0x20,0x09,0xfe,0x08,0x20,0x1c,0x20,0x1a,0x20,0x1a,0xfc,0x28,0x84,0x28,0x84,0x48,0x84,0x08,0x84,0x08,0x84,0x08,0xfc,0x08,0x84}}, // 枯
{0x3850,0x8CCE,0xB8D0,0xE6B996,0x6E56,{0x21,0x00,0x11,0x1e,0x11,0x12,0x01,0x12,0x0f,0xf2,0x41,0x1e,0x21,0x12,0x21,0x12,0x07,0xd2,0x14,0x5e,0x14,0x52,0x24,0x52,0x27,0xd2,0x24,0x52,0x44,0x26,0x40,0x42}}, // 湖
{0x3851,0x8CCF,0xB8D1,0xE78B90,0x72D0,{0x04,0x02,0x44,0x0c,0x29,0xf4,0x11,0x04,0x11,0x24,0x29,0x24,0x49,0x24,0x09,0x24,0x19,0x24,0x29,0x24,0x49,0x34,0x09,0x34,0x09,0x2a,0x0a,0x3a,0x6a,0xc6,0x14,0x01}}, // 狐
{0x3852,0x8CD0,0xB8D2,0xE7B38A,0x7CCA,{0x10,0x80,0x14,0x9e,0x54,0x92,0x34,0x92,0x3b,0xf2,0x10,0x9e,0x7c,0x92,0x10,0x92,0x1b,0xd2,0x36,0x5e,0x32,0x52,0x52,0x52,0x53,0xd2,0x12,0x22,0x10,0x26,0x10,0x42}}, // 糊
{0x3853,0x8CD1,0xB8D3,0xE8A2B4,0x88B4,{0x08,0x10,0x08,0x10,0x09,0xff,0x7e,0x28,0x02,0x24,0x04,0x42,0x05,0xfd,0x09,0x00,0x1e,0xfe,0x2a,0x10,0x49,0x10,0x09,0x3e,0x08,0x22,0x08,0x02,0x08,0x02,0x08,0x0c}}, // 袴
{0x3854,0x8CD2,0xB8D4,0xE882A1,0x80A1,{0x00,0x00,0x3c,0xf0,0x24,0x90,0x24,0x92,0x24,0x92,0x3c,0x8e,0x25,0x00,0x27,0xf8,0x24,0x88,0x3c,0x88,0x24,0x50,0x24,0x50,0x24,0x20,0x24,0x50,0x2d,0x8c,0x46,0x03}}, // 股
{0x3855,0x8CD3,0xB8D5,0xE883A1,0x80E1,{0x04,0x00,0x04,0x3e,0x04,0x22,0x7f,0xe2,0x04,0x22,0x04,0x3e,0x04,0x22,0x04,0x22,0x1f,0x22,0x11,0x3e,0x11,0x22,0x11,0x22,0x11,0x22,0x1f,0x42,0x11,0x46,0x00,0x82}}, // 胡
{0x3856,0x8CD4,0xB8D6,0xE88FB0,0x83F0,{0x02,0x20,0x02,0x20,0x7f,0xff,0x02,0x20,0x00,0x02,0x7c,0x0c,0x05,0xf0,0x09,0x28,0x11,0x28,0x13,0x28,0x1d,0x28,0x71,0x34,0x11,0x2c,0x12,0x3a,0x33,0xca,0x14,0x01}}, // 菰
{0x3857,0x8CD5,0xB8D7,0xE8998E,0x864E,{0x00,0x80,0x00,0xf8,0x00,0x80,0x1f,0xfe,0x11,0x04,0x11,0x18,0x11,0xe0,0x1f,0x00,0x11,0x04,0x10,0xfc,0x11,0x20,0x11,0x20,0x21,0x20,0x22,0x22,0x44,0x12,0x18,0x0e}}, // 虎
{0x3858,0x8CD6,0xB8D8,0xE8AA87,0x8A87,{0x00,0x10,0x3e,0x10,0x00,0xff,0x7f,0x28,0x00,0x24,0x3e,0x42,0x00,0xfd,0x01,0x00,0x3e,0xff,0x00,0x10,0x3e,0x10,0x22,0x3e,0x22,0x22,0x22,0x02,0x3e,0x02,0x22,0x0c}}, // 誇
{0x3859,0x8CD7,0xB8D9,0xE8B7A8,0x8DE8,{0x00,0x10,0x3e,0x10,0x23,0xff,0x22,0x28,0x22,0x24,0x22,0x42,0x3e,0xfd,0x09,0x00,0x28,0xfe,0x2f,0x10,0x28,0x10,0x28,0x3e,0x28,0x22,0x2e,0x02,0x38,0x02,0x60,0x0c}}, // 跨
{0x385A,0x8CD8,0xB8DA,0xE988B7,0x9237,{0x08,0x10,0x08,0x10,0x14,0x10,0x12,0x10,0x21,0xff,0x7e,0x10,0x08,0x10,0x08,0x10,0x7f,0x10,0x08,0xfc,0x4a,0x84,0x2c,0x84,0x28,0x84,0x0f,0x84,0x18,0xfc,0x60,0x84}}, // 鈷
{0x385B,0x8CD9,0xB8DB,0xE99B87,0x96C7,{0x00,0x00,0x7f,0xff,0x00,0x00,0x1f,0xfc,0x10,0x04,0x1f,0xfc,0x12,0x10,0x12,0x20,0x17,0xfe,0x14,0x20,0x1f,0xfc,0x14,0x20,0x27,0xfc,0x24,0x20,0x47,0xfe,0x04,0x00}}, // 雇
{0x385C,0x8CDA,0xB8DC,0xE9A1A7,0x9867,{0x00,0x00,0x7f,0xff,0x00,0x10,0x3f,0x20,0x21,0x7e,0x3f,0x42,0x25,0x42,0x2a,0x7e,0x2f,0x42,0x3a,0x7e,0x2f,0x42,0x2a,0x42,0x2f,0x7e,0x4a,0x14,0x4f,0xa2,0x08,0xc1}}, // 顧
{0x385D,0x8CDB,0xB8DD,0xE9BC93,0x9F13,{0x08,0x10,0x08,0x10,0x7f,0xff,0x08,0x10,0x3e,0x10,0x00,0xfc,0x3e,0x44,0x22,0x44,0x22,0x44,0x3e,0x28,0x02,0x28,0x24,0x10,0x11,0x28,0x16,0x44,0x18,0x82,0x61,0x01}}, // 鼓
{0x385E,0x8CDC,0xB8DE,0xE4BA94,0x4E94,{0x00,0x00,0x3f,0xfe,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x1f,0xf8,0x01,0x08,0x01,0x08,0x01,0x08,0x01,0x08,0x02,0x08,0x02,0x08,0x02,0x08,0x7f,0xff,0x00,0x00}}, // 五
{0x385F,0x8CDD,0xB8DF,0xE4BA92,0x4E92,{0x00,0x00,0x3f,0xfe,0x02,0x00,0x02,0x00,0x02,0x00,0x03,0xf0,0x04,0x10,0x04,0x10,0x04,0x10,0x08,0x10,0x0f,0xe0,0x00,0x20,0x00,0x20,0x00,0x20,0x7f,0xff,0x00,0x00}}, // 互
{0x3860,0x8CDE,0xB8E0,0xE4BC8D,0x4F0D,{0x04,0x00,0x07,0xfe,0x04,0x40,0x08,0x40,0x08,0x40,0x10,0x40,0x13,0xf8,0x30,0x48,0x50,0x48,0x10,0x48,0x10,0x88,0x10,0x88,0x10,0x88,0x10,0x88,0x17,0xff,0x10,0x00}}, // 伍
{0x3861,0x8CDF,0xB8E1,0xE58D88,0x5348,{0x04,0x00,0x04,0x00,0x07,0xfc,0x08,0x80,0x08,0x80,0x10,0x80,0x20,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 午
{0x3862,0x8CE0,0xB8E2,0xE59189,0x5449,{0x00,0x00,0x03,0xf8,0x12,0x08,0x12,0x08,0x12,0x08,0x13,0xf8,0x12,0x08,0x10,0x00,0x1f,0xf8,0x10,0x08,0x00,0x08,0x7f,0xff,0x00,0x00,0x02,0x10,0x0c,0x08,0x30,0x04}}, // 呉
{0x3863,0x8CE1,0xB8E3,0xE590BE,0x543E,{0x00,0x00,0x3f,0xfc,0x01,0x00,0x01,0x00,0x1f,0xf0,0x02,0x10,0x02,0x10,0x02,0x10,0x7f,0xfe,0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 吾
{0x3864,0x8CE2,0xB8E4,0xE5A8AF,0x5A2F,{0x08,0x00,0x08,0xbc,0x08,0xa4,0x08,0xa4,0x7e,0xa4,0x12,0xbc,0x12,0xa4,0x12,0x80,0x22,0xfc,0x24,0x84,0x7c,0x04,0x05,0xff,0x0a,0x00,0x12,0x24,0x60,0x42,0x01,0x81}}, // 娯
{0x3865,0x8CE3,0xB8E5,0xE5BE8C,0x5F8C,{0x08,0x40,0x08,0x48,0x10,0x88,0x13,0x10,0x24,0xd0,0x44,0x24,0x08,0x42,0x0b,0xfd,0x10,0x41,0x10,0xfc,0x31,0x88,0x56,0x48,0x10,0x30,0x10,0x70,0x11,0x8c,0x16,0x03}}, // 後
{0x3866,0x8CE4,0xB8E6,0xE5BEA1,0x5FA1,{0x0a,0x00,0x0a,0x1e,0x13,0xf2,0x12,0x92,0x24,0x92,0x44,0x92,0x0b,0xf2,0x08,0x92,0x12,0x92,0x32,0xf2,0x52,0x92,0x12,0x92,0x12,0xfc,0x13,0x90,0x1c,0x10,0x10,0x10}}, // 御
{0x3867,0x8CE5,0xB8E7,0xE6829F,0x609F,{0x08,0x00,0x0b,0xfe,0x08,0x20,0x08,0x20,0x2d,0xf8,0x2a,0x48,0x2a,0x48,0x48,0x48,0x0b,0xff,0x08,0x00,0x09,0xfc,0x09,0x04,0x09,0x04,0x09,0x04,0x09,0xfc,0x09,0x04}}, // 悟
{0x3868,0x8CE6,0xB8E8,0xE6A2A7,0x68A7,{0x08,0x00,0x09,0xfe,0x08,0x20,0x7f,0x20,0x08,0xf8,0x08,0x48,0x1c,0x48,0x1a,0x48,0x1b,0xff,0x28,0x00,0x28,0xfc,0x48,0x84,0x08,0x84,0x08,0x84,0x08,0xfc,0x08,0x84}}, // 梧
{0x3869,0x8CE7,0xB8E9,0xE6AA8E,0x6A8E,{0x08,0x20,0x08,0x20,0x08,0x50,0x7e,0xa8,0x09,0xfc,0x1b,0x57,0x1d,0x24,0x19,0x54,0x29,0xfc,0x28,0x20,0x4b,0xfe,0x0a,0x22,0x0a,0x52,0x0b,0xea,0x0a,0x02,0x0a,0x06}}, // 檎
{0x386A,0x8CE8,0xB8EA,0xE7919A,0x745A,{0x01,0x00,0x01,0x1e,0x7d,0x12,0x17,0xf2,0x11,0x12,0x11,0x1e,0x11,0x12,0x7f,0xd2,0x12,0x52,0x12,0x5e,0x12,0x52,0x12,0x52,0x17,0xd2,0x1a,0x22,0x60,0x22,0x00,0x46}}, // 瑚
{0x386B,0x8CE9,0xB8EB,0xE7A281,0x7881,{0x04,0x10,0x04,0x10,0x3f,0xfe,0x04,0x10,0x07,0xf0,0x04,0x10,0x07,0xf0,0x04,0x10,0x7f,0xff,0x04,0x10,0x0f,0xf8,0x11,0x04,0x63,0xf3,0x0e,0x10,0x33,0xf0,0x02,0x10}}, // 碁
{0x386C,0x8CEA,0xB8EC,0xE8AA9E,0x8A9E,{0x00,0x00,0x3e,0xfe,0x00,0x10,0x7f,0x10,0x00,0xfc,0x3e,0x24,0x00,0x24,0x3e,0x24,0x01,0xff,0x00,0x00,0x3e,0x7e,0x22,0x42,0x22,0x42,0x22,0x42,0x3e,0x7e,0x22,0x42}}, // 語
{0x386D,0x8CEB,0xB8ED,0xE8AAA4,0x8AA4,{0x00,0x00,0x3e,0xbc,0x00,0xa4,0x7f,0xa4,0x00,0xa4,0x3e,0xbc,0x00,0xa4,0x00,0x80,0x3e,0xfc,0x00,0x84,0x3e,0x04,0x23,0xff,0x22,0x08,0x22,0x44,0x3e,0x42,0x22,0x82}}, // 誤
{0x386E,0x8CEC,0xB8EE,0xE8ADB7,0x8B77,{0x00,0x48,0x3e,0xfe,0x00,0x48,0x7f,0x7e,0x00,0x90,0x3e,0xfc,0x01,0x90,0x00,0xfc,0x3e,0x90,0x00,0xfe,0x3e,0x00,0x23,0xfc,0x22,0xc8,0x22,0x30,0x3e,0x68,0x23,0x87}}, // 護
{0x386F,0x8CED,0xB8EF,0xE98690,0x9190,{0x00,0x40,0x7f,0x4e,0x14,0x4a,0x14,0x4a,0x15,0xfa,0x3e,0x4e,0x2a,0x4a,0x2a,0x4a,0x37,0xea,0x33,0x2e,0x23,0x2a,0x3f,0x2a,0x23,0xea,0x23,0x12,0x3e,0x16,0x22,0x22}}, // 醐
{0x3870,0x8CEE,0xB8F0,0xE4B99E,0x4E5E,{0x04,0x00,0x04,0x00,0x04,0x00,0x0f,0xfe,0x08,0x00,0x10,0x00,0x2f,0xf0,0x40,0x40,0x01,0x80,0x02,0x00,0x04,0x00,0x08,0x00,0x10,0x00,0x10,0x04,0x10,0x04,0x0f,0xfc}}, // 乞
{0x3871,0x8CEF,0xB8F1,0xE9AF89,0x9BC9,{0x08,0x00,0x0f,0x7e,0x12,0x52,0x24,0x52,0x7f,0x7e,0x29,0x52,0x29,0x52,0x3f,0x52,0x29,0x7e,0x29,0x10,0x3f,0x10,0x05,0x7e,0x32,0x90,0x2a,0x10,0x28,0xff,0x40,0x00}}, // 鯉
{0x3872,0x8CF0,0xB8F2,0xE4BAA4,0x4EA4,{0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x04,0x20,0x04,0x10,0x08,0x28,0x0a,0x28,0x12,0x24,0x21,0x44,0x01,0x40,0x00,0x80,0x01,0x40,0x02,0x20,0x0c,0x18,0x70,0x07}}, // 交
{0x3873,0x8CF1,0xB8F3,0xE4BDBC,0x4F7C,{0x04,0x20,0x04,0x20,0x04,0x20,0x0b,0xff,0x08,0x88,0x10,0x84,0x11,0x0a,0x32,0x8a,0x54,0x88,0x10,0x50,0x10,0x50,0x10,0x20,0x10,0x50,0x10,0x88,0x11,0x04,0x16,0x03}}, // 佼
{0x3874,0x8CF2,0xB8F4,0xE4BEAF,0x4FAF,{0x04,0x00,0x05,0xf8,0x04,0x08,0x08,0x08,0x0f,0xff,0x10,0x80,0x10,0x80,0x30,0xfc,0x51,0x20,0x12,0x20,0x17,0xff,0x10,0x20,0x10,0x50,0x10,0x88,0x11,0x04,0x16,0x03}}, // 侯
{0x3875,0x8CF3,0xB8F5,0xE58099,0x5019,{0x08,0x00,0x09,0xf8,0x08,0x08,0x14,0x08,0x17,0xff,0x14,0x80,0x34,0x80,0x35,0xfe,0x55,0x20,0x16,0x20,0x17,0xff,0x14,0x30,0x14,0x50,0x14,0x88,0x11,0x04,0x12,0x03}}, // 候
{0x3876,0x8CF4,0xB8F6,0xE58096,0x5016,{0x04,0x20,0x04,0x20,0x05,0xfe,0x08,0x20,0x08,0x20,0x17,0xff,0x11,0x08,0x30,0x88,0x50,0x90,0x17,0xfe,0x10,0x20,0x10,0x20,0x13,0xfe,0x10,0x20,0x10,0x20,0x10,0x20}}, // 倖
{0x3877,0x8CF5,0xB8F7,0xE58589,0x5149,{0x00,0x80,0x00,0x80,0x08,0x88,0x04,0x88,0x04,0x90,0x04,0xa0,0x00,0x80,0x7f,0xff,0x01,0x20,0x01,0x20,0x01,0x20,0x02,0x20,0x02,0x20,0x04,0x21,0x08,0x11,0x30,0x0f}}, // 光
{0x3878,0x8CF6,0xB8F8,0xE585AC,0x516C,{0x01,0xe0,0x04,0x20,0x04,0x20,0x04,0x10,0x08,0x10,0x08,0x08,0x11,0x04,0x21,0x02,0x41,0x01,0x01,0x40,0x02,0x20,0x02,0x10,0x04,0x08,0x05,0xf8,0x3e,0x04,0x00,0x04}}, // 公
{0x3879,0x8CF7,0xB8F9,0xE58A9F,0x529F,{0x00,0x20,0x00,0x20,0x00,0x20,0x7e,0x20,0x09,0xfe,0x08,0x22,0x08,0x22,0x08,0x22,0x08,0x22,0x08,0x22,0x0e,0x42,0x18,0x42,0x60,0x42,0x00,0x82,0x01,0x04,0x02,0x18}}, // 功
{0x387A,0x8CF8,0xB8FA,0xE58AB9,0x52B9,{0x04,0x10,0x04,0x10,0x04,0x10,0x7f,0x90,0x12,0x7e,0x11,0x12,0x11,0x12,0x29,0x92,0x2a,0x12,0x46,0x12,0x02,0x22,0x05,0x22,0x09,0x42,0x10,0x42,0x20,0x82,0x41,0x0c}}, // 効
{0x387B,0x8CF9,0xB8FB,0xE58BBE,0x52FE,{0x08,0x00,0x08,0x00,0x08,0x00,0x0f,0xfe,0x09,0x02,0x11,0x02,0x11,0x02,0x21,0x02,0x42,0x42,0x02,0x22,0x02,0x22,0x04,0xf2,0x1f,0x12,0x00,0x02,0x00,0x04,0x00,0x38}}, // 勾
{0x387C,0x8CFA,0xB8FC,0xE58E9A,0x539A,{0x00,0x00,0x1f,0xfe,0x10,0x00,0x13,0xf8,0x12,0x08,0x13,0xf8,0x12,0x08,0x13,0xf8,0x10,0x00,0x17,0xf8,0x10,0x20,0x10,0x40,0x2f,0xff,0x20,0x40,0x40,0x40,0x00,0xc0}}, // 厚
{0x387D,0x8CFB,0xB8FD,0xE58FA3,0x53E3,{0x00,0x00,0x00,0x00,0x3f,0xfc,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x3f,0xfc,0x20,0x04,0x00,0x00}}, // 口
{0x387E,0x8CFC,0xB8FE,0xE59091,0x5411,{0x01,0x00,0x01,0x00,0x02,0x00,0x04,0x00,0x3f,0xfe,0x20,0x02,0x20,0x02,0x27,0xf2,0x24,0x12,0x24,0x12,0x24,0x12,0x27,0xf2,0x24,0x12,0x20,0x02,0x20,0x06,0x20,0x02}}, // 向
{0x3921,0x8D40,0xB9A1,0xE5908E,0x540E,{0x00,0x04,0x00,0x38,0x0f,0xc0,0x08,0x00,0x08,0x00,0x0f,0xff,0x08,0x00,0x08,0x00,0x08,0x00,0x0b,0xfc,0x0a,0x04,0x12,0x04,0x12,0x04,0x22,0x04,0x43,0xfc,0x02,0x04}}, // 后
{0x3922,0x8D41,0xB9A2,0xE59689,0x5589,{0x00,0x80,0x00,0xbc,0x78,0x84,0x49,0x04,0x49,0xff,0x4b,0x20,0x4b,0x20,0x4d,0x7e,0x49,0x50,0x49,0x90,0x49,0xff,0x79,0x28,0x49,0x28,0x01,0x44,0x01,0x82,0x01,0x01}}, // 喉
{0x3923,0x8D42,0xB9A3,0xE59D91,0x5751,{0x08,0x20,0x08,0x20,0x08,0x20,0x0b,0xff,0x7e,0x00,0x08,0x00,0x08,0xf0,0x08,0x90,0x08,0x90,0x08,0x90,0x0e,0x90,0x18,0x90,0x61,0x10,0x01,0x12,0x02,0x12,0x04,0x0e}}, // 坑
{0x3924,0x8D43,0xB9A4,0xE59EA2,0x57A2,{0x00,0x04,0x10,0x38,0x11,0xc0,0x11,0x00,0x11,0x00,0x7d,0xff,0x11,0x00,0x11,0x00,0x11,0xfc,0x13,0x84,0x15,0x84,0x1a,0x84,0x62,0x84,0x04,0x84,0x08,0xfc,0x00,0x84}}, // 垢
{0x3925,0x8D44,0xB9A5,0xE5A5BD,0x597D,{0x08,0x00,0x08,0x7e,0x08,0x02,0x08,0x04,0x7f,0x08,0x12,0x08,0x12,0x10,0x13,0xff,0x12,0x10,0x22,0x10,0x3c,0x10,0x26,0x10,0x09,0x10,0x10,0x10,0x60,0x70,0x00,0x10}}, // 好
{0x3926,0x8D45,0xB9A6,0xE5AD94,0x5B54,{0x00,0x20,0x3f,0xa0,0x01,0x20,0x02,0x20,0x04,0x20,0x04,0x20,0x04,0xa0,0x07,0x20,0x0c,0x20,0x74,0x20,0x04,0x20,0x04,0x20,0x04,0x21,0x04,0x21,0x0c,0x1f,0x04,0x00}}, // 孔
{0x3927,0x8D46,0xB9A7,0xE5AD9D,0x5B5D,{0x00,0x80,0x00,0x84,0x1f,0xfc,0x00,0x88,0x00,0x90,0x7f,0xff,0x00,0xc0,0x03,0x00,0x0f,0xf0,0x70,0x20,0x00,0x40,0x3f,0xfe,0x00,0x80,0x00,0x80,0x00,0x80,0x01,0x80}}, // 孝
{0x3928,0x8D47,0xB9A8,0xE5AE8F,0x5B8F,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x42,0x00,0x02,0x00,0x7f,0xfe,0x02,0x00,0x02,0x40,0x04,0x40,0x04,0x80,0x08,0x90,0x11,0x08,0x22,0x38,0x4f,0xc4,0x00,0x04}}, // 宏
{0x3929,0x8D48,0xB9A9,0xE5B7A5,0x5DE5,{0x00,0x00,0x00,0x00,0x3f,0xfe,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x82,0x7f,0xff,0x00,0x00,0x00,0x00}}, // 工
{0x392A,0x8D49,0xB9AA,0xE5B7A7,0x5DE7,{0x00,0x00,0x03,0xff,0x7e,0x20,0x08,0x20,0x08,0x40,0x08,0x40,0x08,0xfc,0x08,0x84,0x08,0x04,0x0e,0x04,0x18,0x04,0x60,0x04,0x00,0x04,0x00,0x04,0x00,0x08,0x00,0x70}}, // 巧
{0x392B,0x8D4A,0xB9AB,0xE5B7B7,0x5DF7,{0x02,0x20,0x02,0x20,0x1f,0xfc,0x02,0x20,0x02,0x20,0x7f,0xff,0x02,0x20,0x04,0x10,0x0f,0xf8,0x10,0x14,0x60,0x13,0x07,0xf0,0x04,0x00,0x04,0x04,0x04,0x04,0x03,0xfc}}, // 巷
{0x392C,0x8D4B,0xB9AC,0xE5B9B8,0x5E78,{0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x7f,0xff,0x04,0x10,0x02,0x10,0x02,0x20,0x3f,0xfe,0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x00,0x80}}, // 幸
{0x392D,0x8D4C,0xB9AD,0xE5BA83,0x5E83,{0x00,0x40,0x00,0x40,0x00,0x40,0x1f,0xff,0x10,0x00,0x10,0x80,0x10,0x80,0x10,0x80,0x10,0x80,0x10,0x80,0x11,0x10,0x11,0x08,0x11,0x04,0x22,0x7c,0x2f,0x82,0x40,0x02}}, // 広
{0x392E,0x8D4D,0xB9AE,0xE5BA9A,0x5E9A,{0x00,0x80,0x00,0x80,0x1f,0xff,0x10,0x40,0x17,0xfc,0x10,0x44,0x10,0x44,0x1f,0xff,0x10,0x44,0x17,0xfc,0x10,0x40,0x10,0x40,0x20,0xa0,0x21,0x10,0x46,0x0c,0x18,0x03}}, // 庚
{0x392F,0x8D4E,0xB9AF,0xE5BAB7,0x5EB7,{0x00,0x40,0x00,0x40,0x1f,0xff,0x10,0x40,0x17,0xfc,0x10,0x44,0x1f,0xff,0x10,0x44,0x17,0xfc,0x14,0x42,0x12,0x44,0x12,0xe8,0x21,0x50,0x26,0x4c,0x58,0xc3,0x00,0x40}}, // 康
{0x3930,0x8D4F,0xB9B0,0xE5BC98,0x5F18,{0x00,0x10,0x7e,0x10,0x02,0x10,0x02,0x10,0x02,0x10,0x3e,0x10,0x20,0x20,0x20,0x20,0x20,0x20,0x3e,0x28,0x22,0x24,0x02,0x44,0x02,0x42,0x02,0x5e,0x05,0xe2,0x38,0x02}}, // 弘
{0x3931,0x8D50,0xB9B1,0xE68192,0x6052,{0x08,0x00,0x09,0xfe,0x08,0x00,0x08,0x00,0x2c,0xfc,0x2a,0x84,0x2a,0x84,0x48,0xfc,0x08,0x84,0x08,0x84,0x08,0x84,0x08,0xfc,0x08,0x00,0x08,0x00,0x0b,0xff,0x08,0x00}}, // 恒
{0x3932,0x8D51,0xB9B2,0xE6858C,0x614C,{0x08,0x88,0x08,0x88,0x0b,0xff,0x08,0x88,0x28,0x20,0x2d,0xff,0x2a,0x80,0x2a,0x80,0x48,0x7c,0x08,0x00,0x09,0x24,0x09,0x24,0x09,0x24,0x09,0x25,0x0a,0x25,0x0c,0x03}}, // 慌
{0x3933,0x8D52,0xB9B3,0xE68A97,0x6297,{0x10,0x20,0x10,0x20,0x10,0x20,0x13,0xff,0x7c,0x00,0x10,0x00,0x10,0xf0,0x10,0x90,0x1c,0x90,0x70,0x90,0x10,0x90,0x10,0x90,0x11,0x10,0x11,0x12,0x32,0x12,0x14,0x0e}}, // 抗
{0x3934,0x8D53,0xB9B4,0xE68B98,0x62D8,{0x10,0x80,0x10,0x80,0x10,0x80,0x10,0xfe,0x7d,0x02,0x11,0x02,0x12,0xf2,0x14,0x92,0x10,0x92,0x1c,0x92,0x70,0x92,0x10,0xf2,0x10,0x92,0x10,0x02,0x30,0x04,0x10,0x18}}, // 拘
{0x3935,0x8D54,0xB9B5,0xE68EA7,0x63A7,{0x10,0x20,0x10,0x20,0x13,0xff,0x12,0x52,0x7c,0x50,0x10,0x52,0x10,0x8e,0x11,0x00,0x1e,0x00,0x71,0xfe,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x33,0xff,0x10,0x00}}, // 控
{0x3936,0x8D55,0xB9B6,0xE694BB,0x653B,{0x00,0x40,0x00,0x40,0x00,0x40,0x7e,0x7f,0x08,0x84,0x08,0x84,0x09,0x44,0x0a,0x44,0x08,0x28,0x08,0x28,0x0e,0x10,0x18,0x30,0x60,0x48,0x00,0x84,0x01,0x02,0x06,0x01}}, // 攻
{0x3937,0x8D56,0xB9B7,0xE69882,0x6602,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x02,0x00,0x3c,0x7e,0x20,0x42,0x20,0x42,0x23,0x42,0x2c,0x42,0x70,0x4c,0x00,0x40,0x00,0x40}}, // 昂
{0x3938,0x8D57,0xB9B8,0xE69983,0x6643,{0x00,0x00,0x1f,0xf8,0x10,0x08,0x1f,0xf8,0x10,0x08,0x1f,0xf8,0x08,0x88,0x04,0x90,0x04,0xa0,0x7f,0xff,0x02,0x40,0x02,0x40,0x02,0x40,0x04,0x42,0x18,0x22,0x60,0x1e}}, // 晃
{0x3939,0x8D58,0xB9B9,0xE69BB4,0x66F4,{0x00,0x00,0x7f,0xff,0x00,0x80,0x1f,0xf8,0x10,0x88,0x10,0x88,0x1f,0xf8,0x10,0x88,0x10,0x88,0x1f,0xf8,0x14,0x88,0x02,0x80,0x01,0x00,0x02,0xc0,0x0c,0x38,0x70,0x07}}, // 更
{0x393A,0x8D59,0xB9BA,0xE69DAD,0x676D,{0x08,0x20,0x08,0x20,0x08,0x20,0x7f,0xff,0x08,0x00,0x08,0x00,0x1c,0x78,0x1a,0x48,0x19,0x48,0x29,0x48,0x28,0x48,0x48,0x48,0x08,0x89,0x08,0x89,0x09,0x07,0x0a,0x00}}, // 杭
{0x393B,0x8D5A,0xB9BB,0xE6A0A1,0x6821,{0x08,0x10,0x08,0x10,0x08,0x10,0x7f,0xff,0x08,0x44,0x08,0x44,0x1c,0x42,0x1a,0xa5,0x19,0x25,0x29,0x28,0x28,0x10,0x48,0x10,0x08,0x28,0x08,0x44,0x08,0x82,0x0b,0x01}}, // 校
{0x393C,0x8D5B,0xB9BC,0xE6A297,0x6897,{0x08,0x00,0x0b,0xff,0x08,0x20,0x7d,0xfc,0x09,0x24,0x09,0x24,0x1d,0xfc,0x1b,0x24,0x1b,0x24,0x29,0xfc,0x28,0xa0,0x48,0x60,0x08,0x20,0x08,0x50,0x08,0x8c,0x0b,0x03}}, // 梗
{0x393D,0x8D5C,0xB9BD,0xE6A78B,0x69CB,{0x08,0x48,0x08,0x48,0x09,0xff,0x7e,0x48,0x09,0xfe,0x08,0x48,0x1b,0xff,0x1c,0x20,0x1b,0xfc,0x29,0x24,0x29,0xfc,0x49,0x24,0x0f,0xff,0x09,0x04,0x09,0x04,0x09,0x0c}}, // 構
{0x393E,0x8D5D,0xB9BE,0xE6B19F,0x6C5F,{0x10,0x00,0x08,0x00,0x0b,0xfc,0x00,0x20,0x40,0x20,0x20,0x20,0x20,0x20,0x00,0x20,0x08,0x20,0x08,0x20,0x10,0x20,0x10,0x20,0x20,0x20,0x2f,0xfe,0x40,0x00,0x40,0x00}}, // 江
{0x393F,0x8D5E,0xB9BF,0xE6B4AA,0x6D2A,{0x10,0x88,0x08,0x88,0x08,0x88,0x03,0xfe,0x40,0x88,0x20,0x88,0x20,0x88,0x00,0x88,0x08,0x88,0x0f,0xff,0x10,0x00,0x10,0x90,0x20,0x88,0x21,0x08,0x42,0x04,0x44,0x04}}, // 洪
{0x3940,0x8D5F,0xB9C0,0xE6B5A9,0x6D69,{0x10,0x20,0x09,0x20,0x09,0x20,0x01,0xfe,0x02,0x20,0x42,0x20,0x24,0x20,0x27,0xff,0x00,0x00,0x08,0x00,0x11,0xfc,0x11,0x04,0x21,0x04,0x21,0x04,0x41,0xfc,0x41,0x04}}, // 浩
{0x3941,0x8D60,0xB9C1,0xE6B8AF,0x6E2F,{0x10,0x88,0x08,0x88,0x0b,0xfe,0x00,0x88,0x00,0x88,0x47,0xff,0x20,0x88,0x21,0x04,0x09,0xfc,0x0a,0x0a,0x14,0x09,0x11,0xf8,0x21,0x00,0x21,0x04,0x41,0x04,0x40,0xfc}}, // 港
{0x3942,0x8D61,0xB9C2,0xE6BA9D,0x6E9D,{0x10,0x88,0x08,0x88,0x0b,0xfe,0x00,0x88,0x03,0xfe,0x40,0x88,0x27,0xff,0x20,0x20,0x09,0xfc,0x09,0x24,0x11,0xfc,0x11,0x24,0x27,0xff,0x21,0x04,0x41,0x04,0x41,0x0c}}, // 溝
{0x3943,0x8D62,0xB9C3,0xE794B2,0x7532,{0x00,0x00,0x1f,0xfc,0x10,0x84,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x84,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x84,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 甲
{0x3944,0x8D63,0xB9C4,0xE79A87,0x7687,{0x00,0x80,0x01,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x00,0x00,0x3f,0xfe,0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 皇
{0x3945,0x8D64,0xB9C5,0xE7A1AC,0x786C,{0x00,0x00,0x7f,0xff,0x08,0x10,0x08,0xfe,0x08,0x92,0x10,0x92,0x1e,0xfe,0x12,0x92,0x32,0x92,0x52,0xfe,0x12,0x50,0x12,0x20,0x1e,0x20,0x12,0x50,0x01,0x8c,0x06,0x03}}, // 硬
{0x3946,0x8D65,0xB9C6,0xE7A8BF,0x7A3F,{0x02,0x10,0x0c,0x10,0x79,0xff,0x08,0x00,0x08,0xfc,0x7e,0x84,0x08,0xfc,0x18,0x00,0x1d,0xfe,0x1b,0x02,0x29,0x7a,0x29,0x4a,0x49,0x4a,0x09,0x7a,0x09,0x02,0x09,0x06}}, // 稿
{0x3947,0x8D66,0xB9C7,0xE7B3A0,0x7CE0,{0x08,0x10,0x0a,0x10,0x4b,0xff,0x2d,0x10,0x29,0x7e,0x09,0x12,0x7f,0xff,0x09,0x12,0x09,0x7e,0x1d,0x91,0x1b,0x5a,0x29,0x74,0x2a,0x54,0x4b,0x92,0x0c,0x11,0x08,0x30}}, // 糠
{0x3948,0x8D67,0xB9C8,0xE7B485,0x7D05,{0x08,0x00,0x08,0x00,0x0a,0xfe,0x72,0x10,0x14,0x10,0x08,0x10,0x0c,0x10,0x12,0x10,0x7d,0x10,0x09,0x10,0x2c,0x10,0x2a,0x10,0x2a,0x10,0x2b,0xff,0x48,0x00,0x08,0x00}}, // 紅
{0x3949,0x8D68,0xB9C9,0xE7B498,0x7D18,{0x08,0x20,0x08,0x20,0x0a,0x20,0x73,0xff,0x14,0x20,0x08,0x28,0x0c,0x28,0x12,0x28,0x7d,0x48,0x08,0x48,0x2c,0x50,0x2a,0x94,0x2a,0x92,0x29,0x2e,0x48,0xf1,0x08,0x01}}, // 紘
{0x394A,0x8D69,0xB9CA,0xE7B59E,0x7D5E,{0x08,0x10,0x08,0x10,0x0a,0x10,0x73,0xff,0x14,0x48,0x08,0x44,0x0c,0x44,0x12,0x8a,0x7d,0x4a,0x09,0x28,0x2c,0x30,0x2a,0x10,0x2a,0x30,0x2a,0x48,0x48,0x84,0x09,0x03}}, // 絞
{0x394B,0x8D6A,0xB9CB,0xE7B6B1,0x7DB1,{0x08,0x00,0x08,0xfe,0x0a,0x82,0x72,0xca,0x14,0xaa,0x08,0x92,0x0c,0xfe,0x12,0x92,0x7e,0x92,0x09,0xd6,0x0c,0xd6,0x2a,0xfe,0x2a,0xc6,0x2a,0x82,0x48,0x82,0x08,0x86}}, // 綱
{0x394C,0x8D6B,0xB9CC,0xE88095,0x8015,{0x08,0x24,0x08,0x24,0x7f,0x24,0x08,0xff,0x08,0x24,0x3e,0x24,0x08,0x24,0x08,0x24,0x7f,0x24,0x08,0xff,0x1c,0x24,0x1a,0x24,0x29,0x24,0x48,0x44,0x08,0x44,0x08,0x84}}, // 耕
{0x394D,0x8D6C,0xB9CD,0xE88083,0x8003,{0x00,0x80,0x00,0x84,0x1f,0xfc,0x00,0x88,0x00,0x90,0x7f,0xff,0x00,0x40,0x00,0x80,0x03,0xfc,0x0e,0x00,0x72,0x00,0x03,0xf8,0x02,0x08,0x00,0x08,0x00,0x08,0x00,0x30}}, // 考
{0x394E,0x8D6D,0xB9CE,0xE882AF,0x80AF,{0x00,0x80,0x08,0x80,0x08,0xfc,0x08,0x80,0x7f,0xff,0x00,0x00,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x10,0x08,0x30}}, // 肯
{0x394F,0x8D6E,0xB9CF,0xE882B1,0x80B1,{0x00,0x20,0x3e,0x20,0x22,0x20,0x23,0xff,0x22,0x20,0x3e,0x28,0x22,0x28,0x22,0x48,0x22,0x48,0x3e,0x48,0x22,0x90,0x22,0x94,0x23,0x12,0x22,0x26,0x26,0xf9,0x42,0x01}}, // 肱
{0x3950,0x8D6F,0xB9D0,0xE88594,0x8154,{0x00,0x20,0x3c,0x20,0x25,0xff,0x25,0x52,0x26,0x50,0x3c,0x52,0x24,0x9e,0x25,0x00,0x26,0x00,0x3d,0xfc,0x24,0x20,0x24,0x20,0x24,0x20,0x24,0x20,0x2f,0xff,0x44,0x00}}, // 腔
{0x3951,0x8D70,0xB9D1,0xE8868F,0x818F,{0x00,0x80,0x7f,0xfe,0x08,0x10,0x0f,0xf0,0x00,0x00,0x3f,0xfe,0x28,0x14,0x4f,0xf0,0x00,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x30}}, // 膏
{0x3952,0x8D71,0xB9D2,0xE888AA,0x822A,{0x02,0x10,0x04,0x10,0x1f,0x10,0x11,0xff,0x19,0x00,0x15,0x3c,0x15,0x24,0x7f,0xa4,0x11,0x24,0x19,0x24,0x15,0x24,0x15,0x24,0x15,0x24,0x21,0x45,0x23,0x45,0x41,0x83}}, // 航
{0x3953,0x8D72,0xB9D3,0xE88D92,0x8352,{0x04,0x20,0x04,0x20,0x7f,0xfe,0x04,0x20,0x01,0x00,0x7f,0xfe,0x08,0x00,0x08,0x00,0x07,0xf0,0x00,0x00,0x09,0x10,0x09,0x10,0x09,0x12,0x11,0x12,0x21,0x12,0x40,0x0e}}, // 荒
{0x3954,0x8D73,0xB9D4,0xE8A18C,0x884C,{0x04,0x00,0x04,0xfe,0x08,0x00,0x08,0x00,0x12,0x00,0x22,0x00,0x05,0xff,0x04,0x08,0x08,0x08,0x18,0x08,0x28,0x08,0x48,0x08,0x08,0x08,0x08,0x08,0x08,0x38,0x08,0x08}}, // 行
{0x3955,0x8D74,0xB9D5,0xE8A1A1,0x8861,{0x09,0x00,0x09,0xde,0x12,0x40,0x14,0x80,0x23,0xe0,0x4a,0xbf,0x0b,0xe4,0x12,0xa4,0x12,0xa4,0x33,0xe4,0x50,0x84,0x17,0xf4,0x10,0xc4,0x11,0x24,0x12,0x2c,0x14,0x04}}, // 衡
{0x3956,0x8D75,0xB9D6,0xE8AC9B,0x8B1B,{0x00,0x48,0x3c,0x48,0x01,0xff,0x7e,0x48,0x00,0xfe,0x3c,0x48,0x03,0xff,0x00,0x10,0x3c,0xfe,0x00,0x92,0x3c,0xfe,0x24,0x92,0x27,0xff,0x24,0x82,0x3c,0x82,0x24,0x86}}, // 講
{0x3957,0x8D76,0xB9D7,0xE8B2A2,0x8CA2,{0x00,0x00,0x1f,0xf8,0x00,0x80,0x7f,0xfe,0x00,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x02,0x60,0x0c,0x18,0x30,0x04}}, // 貢
{0x3958,0x8D77,0xB9D8,0xE8B3BC,0x8CFC,{0x00,0x48,0x3c,0x48,0x25,0xfe,0x24,0x48,0x3d,0xfe,0x24,0x48,0x27,0xff,0x24,0x20,0x3c,0xfc,0x24,0xa4,0x24,0xfc,0x3c,0xa4,0x1b,0xff,0x14,0x84,0x24,0x84,0x40,0x8c}}, // 購
{0x3959,0x8D78,0xB9D9,0xE9838A,0x90CA,{0x08,0x00,0x08,0x3c,0x08,0x24,0x7f,0xa4,0x12,0x28,0x11,0x30,0x22,0xa8,0x52,0xa4,0x0a,0x22,0x0c,0x22,0x04,0x22,0x0a,0x22,0x09,0x32,0x11,0x2c,0x20,0x20,0x40,0x20}}, // 郊
{0x395A,0x8D79,0xB9DA,0xE985B5,0x9175,{0x00,0x10,0x7f,0x92,0x0c,0xfe,0x0c,0x14,0x3f,0x18,0x2d,0xff,0x2d,0x10,0x35,0x20,0x37,0x7c,0x21,0x84,0x21,0x08,0x3f,0xff,0x21,0x08,0x21,0x08,0x3f,0x18,0x21,0x08}}, // 酵
{0x395B,0x8D7A,0xB9DB,0xE989B1,0x9271,{0x08,0x10,0x08,0x10,0x14,0x10,0x12,0x7f,0x21,0x40,0x7e,0x48,0x08,0x48,0x08,0x48,0x7f,0x48,0x08,0x48,0x4a,0x50,0x2c,0x54,0x29,0x92,0x0e,0xae,0x19,0x71,0x62,0x01}}, // 鉱
{0x395C,0x8D7B,0xB9DC,0xE7A0BF,0x783F,{0x00,0x08,0x7f,0x08,0x08,0x08,0x08,0x7f,0x08,0x40,0x10,0x48,0x1e,0x48,0x32,0x48,0x32,0x48,0x52,0x48,0x12,0x54,0x12,0x92,0x1e,0x92,0x12,0xaf,0x11,0x71,0x02,0x01}}, // 砿
{0x395D,0x8D7C,0xB9DD,0xE98BBC,0x92FC,{0x08,0x00,0x08,0xfe,0x14,0x82,0x12,0xca,0x21,0xaa,0x7e,0x92,0x08,0xfe,0x08,0x92,0x7f,0x92,0x08,0xd6,0x4a,0xd6,0x2c,0xfe,0x29,0xc6,0x0e,0x82,0x18,0x82,0x60,0x86}}, // 鋼
{0x395E,0x8D7D,0xB9DE,0xE996A4,0x95A4,{0x00,0x00,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x40,0x82,0x41,0x42,0x46,0x22,0x5b,0xda,0x40,0x02,0x47,0xe2,0x44,0x22,0x44,0x22,0x47,0xe6,0x44,0x22}}, // 閤
{0x395F,0x8D7E,0xB9DF,0xE9998D,0x964D,{0x00,0x20,0x3c,0x20,0x24,0x7c,0x24,0xc4,0x2b,0x28,0x30,0x30,0x28,0xcc,0x2b,0x13,0x24,0x10,0x25,0xfe,0x24,0x90,0x24,0x90,0x3b,0xff,0x20,0x10,0x20,0x10,0x20,0x10}}, // 降
{0x3960,0x8D80,0xB9E0,0xE9A085,0x9805,{0x00,0x00,0x03,0xff,0x00,0x10,0x7e,0x20,0x08,0xfe,0x08,0x82,0x08,0x82,0x08,0xfe,0x08,0x82,0x0a,0xfe,0x0c,0x82,0x18,0x82,0x60,0xfe,0x00,0x4c,0x01,0x82,0x06,0x01}}, // 項
{0x3961,0x8D81,0xB9E1,0xE9A699,0x9999,{0x00,0x08,0x00,0x70,0x1f,0x80,0x00,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x04,0x90,0x18,0x8c,0x6f,0xfb,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 香
{0x3962,0x8D82,0xB9E2,0xE9AB98,0x9AD8,{0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00,0x07,0xf0,0x04,0x10,0x07,0xf0,0x00,0x00,0x3f,0xfe,0x20,0x02,0x27,0xf2,0x24,0x12,0x27,0xf2,0x24,0x12,0x20,0x06,0x20,0x02}}, // 高
{0x3963,0x8D83,0xB9E3,0xE9B4BB,0x9D3B,{0x20,0x08,0x10,0x10,0x10,0x7c,0x0f,0xc4,0x42,0x7c,0x22,0x44,0x22,0x7c,0x02,0x40,0x0a,0x7f,0x0a,0x40,0x13,0x7e,0x1c,0x0a,0x21,0x56,0x21,0x2a,0x42,0x22,0x40,0x0c}}, // 鴻
{0x3964,0x8D84,0xB9E4,0xE5899B,0x525B,{0x00,0x02,0x3f,0xd2,0x20,0x52,0x31,0x52,0x2a,0x52,0x20,0x52,0x3f,0xd2,0x24,0x52,0x35,0x52,0x35,0x52,0x35,0x52,0x3f,0x42,0x31,0x42,0x20,0x42,0x20,0xc6,0x20,0x42}}, // 剛
{0x3965,0x8D85,0xB9E5,0xE58AAB,0x52AB,{0x04,0x10,0x04,0x10,0x04,0x10,0x3f,0x90,0x04,0x7e,0x04,0x12,0x04,0x12,0x04,0x12,0x7f,0x92,0x04,0x12,0x04,0x12,0x0a,0x22,0x09,0x22,0x13,0x22,0x7c,0xc2,0x00,0x8c}}, // 劫
{0x3966,0x8D86,0xB9E6,0xE58FB7,0x53F7,{0x00,0x00,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10,0x00,0x00,0x7f,0xff,0x04,0x00,0x04,0x00,0x07,0xf0,0x08,0x10,0x00,0x10,0x00,0x10,0x00,0x20,0x00,0xc0}}, // 号
{0x3967,0x8D87,0xB9E7,0xE59088,0x5408,{0x00,0x80,0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x67,0xf3,0x00,0x00,0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 合
{0x3968,0x8D88,0xB9E8,0xE5A395,0x58D5,{0x00,0x20,0x17,0xff,0x10,0x00,0x11,0xfc,0x11,0x04,0x7d,0xfc,0x10,0x00,0x13,0xff,0x12,0x02,0x15,0xfc,0x10,0x22,0x14,0xd4,0x1b,0x38,0x60,0xd4,0x07,0x13,0x00,0x30}}, // 壕
{0x3969,0x8D89,0xB9E9,0xE68BB7,0x62F7,{0x10,0x40,0x10,0x44,0x13,0xfc,0x10,0x48,0x7c,0x50,0x17,0xff,0x10,0x20,0x10,0x40,0x1c,0xfc,0x71,0x40,0x16,0x40,0x10,0x7c,0x10,0x44,0x10,0x04,0x30,0x04,0x10,0x18}}, // 拷
{0x396A,0x8D8A,0xB9EA,0xE6BFA0,0x6FE0,{0x10,0x20,0x0f,0xff,0x08,0x00,0x01,0xfc,0x41,0x04,0x21,0xfc,0x20,0x00,0x03,0xff,0x0a,0x02,0x0d,0xfc,0x10,0x22,0x10,0xd4,0x23,0x38,0x20,0xd4,0x47,0x13,0x40,0x30}}, // 濠
{0x396B,0x8D8B,0xB9EB,0xE8B1AA,0x8C6A,{0x00,0x80,0x7f,0xff,0x00,0x00,0x07,0xf8,0x04,0x08,0x07,0xf8,0x00,0x00,0x3f,0xfe,0x20,0x04,0x4f,0xfa,0x1c,0x84,0x03,0x68,0x3c,0xd0,0x03,0x4c,0x3c,0x43,0x00,0xc0}}, // 豪
{0x396C,0x8D8C,0xB9EC,0xE8BD9F,0x8F5F,{0x00,0x80,0x1f,0xfc,0x00,0x80,0x07,0xf0,0x04,0x90,0x07,0xf0,0x04,0x90,0x3f,0xfe,0x00,0x80,0x08,0x10,0x7f,0xfe,0x2a,0x54,0x3e,0x7c,0x2a,0x54,0x7f,0xff,0x08,0x10}}, // 轟
{0x396D,0x8D8D,0xB9ED,0xE9BAB9,0x9EB9,{0x08,0x40,0x08,0x40,0x3e,0xfe,0x08,0xa2,0x3f,0x2a,0x08,0xb2,0x7f,0x62,0x10,0xfa,0x1e,0x22,0x12,0x72,0x34,0xaa,0x4d,0x22,0x0a,0x24,0x11,0x18,0x20,0xc0,0x40,0x3f}}, // 麹
{0x396E,0x8D8E,0xB9EE,0xE5858B,0x514B,{0x01,0x00,0x01,0x00,0x7f,0xfe,0x01,0x00,0x01,0x00,0x1f,0xf0,0x10,0x10,0x10,0x10,0x10,0x10,0x1f,0xf0,0x12,0x50,0x02,0x40,0x02,0x40,0x04,0x42,0x18,0x22,0x60,0x1e}}, // 克
{0x396F,0x8D8F,0xB9EF,0xE588BB,0x523B,{0x04,0x02,0x04,0x22,0x7f,0xe2,0x04,0x22,0x04,0x22,0x39,0x22,0x0a,0x22,0x06,0x22,0x04,0xa2,0x08,0xa2,0x11,0x22,0x23,0x02,0x04,0x82,0x08,0x42,0x10,0x46,0x60,0x02}}, // 刻
{0x3970,0x8D90,0xB9F0,0xE5918A,0x544A,{0x00,0x80,0x08,0x80,0x08,0x80,0x0f,0xfc,0x10,0x80,0x10,0x80,0x20,0x80,0x7f,0xff,0x00,0x00,0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 告
{0x3971,0x8D91,0xB9F1,0xE59BBD,0x56FD,{0x00,0x00,0x3f,0xfe,0x20,0x02,0x2f,0xfa,0x20,0x82,0x20,0x82,0x20,0x82,0x27,0xf2,0x20,0x82,0x20,0xa2,0x20,0x92,0x20,0x92,0x2f,0xfa,0x20,0x02,0x3f,0xfe,0x20,0x02}}, // 国
{0x3972,0x8D92,0xB9F2,0xE7A980,0x7A40,{0x08,0x00,0x08,0x3c,0x7f,0x24,0x08,0x25,0x3e,0x25,0x00,0x43,0x7f,0x80,0x45,0xfc,0x79,0x24,0x08,0x24,0x7f,0x14,0x0c,0x18,0x1a,0x08,0x29,0x14,0x48,0x62,0x09,0x81}}, // 穀
{0x3973,0x8D93,0xB9F3,0xE985B7,0x9177,{0x00,0x10,0x7f,0x50,0x0c,0x50,0x0c,0x7e,0x3f,0x90,0x2d,0x10,0x2d,0x10,0x2d,0xff,0x37,0x00,0x31,0x00,0x21,0x7c,0x3f,0x44,0x21,0x44,0x21,0x44,0x3f,0x7c,0x21,0x44}}, // 酷
{0x3974,0x8D94,0xB9F4,0xE9B5A0,0x9D60,{0x08,0x10,0x28,0x20,0x28,0xfc,0x3e,0x84,0x28,0xfc,0x48,0x84,0x08,0xfc,0x7f,0x80,0x00,0xff,0x3e,0x80,0x22,0xfe,0x22,0x52,0x22,0xaa,0x22,0xaa,0x3f,0x02,0x22,0x0c}}, // 鵠
{0x3975,0x8D95,0xB9F5,0xE9BB92,0x9ED2,{0x00,0x00,0x0f,0xf8,0x08,0x88,0x08,0x88,0x0f,0xf8,0x08,0x88,0x08,0x88,0x0f,0xf8,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x00,0x12,0x24,0x21,0x12,0x41,0x11}}, // 黒
{0x3976,0x8D96,0xB9F6,0xE78D84,0x7344,{0x08,0x08,0x4b,0xcc,0x28,0x0a,0x17,0xea,0x10,0x08,0x2b,0xff,0x48,0x08,0x0b,0xc8,0x18,0x08,0x18,0x0c,0x2b,0xd4,0x4a,0x54,0x0a,0x54,0x0a,0x62,0x6b,0xc2,0x10,0x81}}, // 獄
{0x3977,0x8D97,0xB9F7,0xE6BC89,0x6F09,{0x20,0x20,0x10,0x20,0x17,0xff,0x04,0x90,0x44,0x90,0x27,0xfe,0x24,0x92,0x04,0x92,0x07,0xfe,0x15,0x10,0x15,0x10,0x25,0xf2,0x29,0x1c,0x29,0x10,0x51,0xd1,0x46,0x0f}}, // 漉
{0x3978,0x8D98,0xB9F8,0xE885B0,0x8170,{0x00,0x00,0x3f,0xfe,0x24,0x50,0x24,0x50,0x25,0xfc,0x3d,0x54,0x25,0x54,0x25,0xfc,0x24,0x20,0x3f,0xff,0x24,0x48,0x24,0x88,0x25,0xd0,0x24,0x30,0x24,0x48,0x4d,0x84}}, // 腰
{0x3979,0x8D99,0xB9F9,0xE79491,0x7511,{0x22,0x00,0x14,0xff,0x7f,0x20,0x49,0x20,0x49,0x20,0x7f,0x3c,0x49,0x24,0x7f,0x24,0x00,0x34,0x3e,0x2c,0x22,0x24,0x3e,0x24,0x22,0x24,0x22,0x25,0x3e,0x75,0x23,0x83}}, // 甑
{0x397A,0x8D9A,0xB9FA,0xE5BFBD,0x5FFD,{0x02,0x00,0x02,0x00,0x07,0xfe,0x18,0x92,0x61,0x12,0x06,0x22,0x18,0x42,0x01,0x82,0x06,0x04,0x18,0x98,0x00,0x40,0x12,0x42,0x12,0x01,0x22,0x09,0x42,0x08,0x01,0xf8}}, // 忽
{0x397B,0x8D9B,0xB9FB,0xE6839A,0x60DA,{0x08,0x80,0x08,0x80,0x08,0xfe,0x08,0xaa,0x2d,0x2a,0x2a,0x4a,0x2a,0x92,0x28,0x22,0x48,0x4c,0x08,0x20,0x08,0x90,0x0a,0x94,0x0a,0x82,0x0a,0x89,0x0c,0x89,0x08,0x78}}, // 惚
{0x397C,0x8D9C,0xB9FC,0xE9AAA8,0x9AA8,{0x00,0x00,0x0f,0xf0,0x08,0x10,0x09,0xf0,0x09,0x10,0x3f,0xfe,0x20,0x04,0x4f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x10,0x08,0x70,0x08,0x10}}, // 骨
{0x397D,0x8D9D,0xB9FD,0xE78B9B,0x72DB,{0x04,0x20,0x44,0x20,0x28,0x20,0x10,0x40,0x11,0xfc,0x29,0x04,0x49,0x04,0x09,0x04,0x19,0x04,0x19,0xfc,0x29,0x04,0x49,0x04,0x09,0x04,0x09,0x04,0x69,0xfc,0x11,0x04}}, // 狛
{0x397E,0x8D9E,0xB9FE,0xE8BEBC,0x8FBC,{0x00,0x00,0x20,0xe0,0x10,0x20,0x10,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x78,0x50,0x08,0x50,0x08,0x88,0x09,0x04,0x0a,0x02,0x0c,0x01,0x14,0x00,0x23,0x00,0x40,0xff}}, // 込
{0x3A21,0x8D9F,0xBAA1,0xE6ADA4,0x6B64,{0x04,0x40,0x04,0x40,0x04,0x40,0x24,0x40,0x24,0x44,0x24,0x44,0x27,0xc8,0x24,0x50,0x24,0x60,0x24,0x40,0x24,0x40,0x24,0x42,0x24,0xc2,0x27,0x42,0x3c,0x3e,0x60,0x00}}, // 此
{0x3A22,0x8DA0,0xBAA2,0xE9A083,0x9803,{0x00,0x00,0x23,0xff,0x20,0x20,0x20,0x40,0x26,0xfe,0x38,0x82,0x20,0x82,0x20,0xfe,0x20,0x82,0x20,0xfe,0x22,0x82,0x22,0x82,0x1e,0xfe,0x00,0x44,0x01,0x82,0x06,0x01}}, // 頃
{0x3A23,0x8DA1,0xBAA3,0xE4BB8A,0x4ECA,{0x00,0x80,0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x08,0x08,0x13,0xe4,0x60,0x03,0x00,0x00,0x0f,0xf0,0x00,0x10,0x00,0x20,0x00,0x20,0x00,0x40,0x00,0x80,0x01,0x00}}, // 今
{0x3A24,0x8DA2,0xBAA4,0xE59BB0,0x56F0,{0x00,0x00,0x3f,0xfe,0x20,0x82,0x20,0x82,0x20,0x82,0x3f,0xfe,0x21,0xc2,0x21,0xc2,0x22,0xa2,0x22,0xa2,0x24,0x92,0x28,0x8a,0x30,0x86,0x20,0x82,0x3f,0xfe,0x20,0x02}}, // 困
{0x3A25,0x8DA3,0xBAA5,0xE59DA4,0x5764,{0x00,0x20,0x08,0x20,0x08,0x20,0x09,0xfe,0x09,0x22,0x7f,0x22,0x09,0xfe,0x09,0x22,0x09,0x22,0x09,0x22,0x09,0xfe,0x0e,0x22,0x18,0x20,0x60,0x20,0x00,0x20,0x00,0x20}}, // 坤
{0x3A26,0x8DA4,0xBAA6,0xE5A2BE,0x58BE,{0x04,0x00,0x39,0x7c,0x26,0x44,0x1c,0x7c,0x76,0x44,0x09,0x7e,0x33,0x52,0x05,0x54,0x19,0x48,0x62,0x74,0x0c,0xc3,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 墾
{0x3A27,0x8DA5,0xBAA7,0xE5A99A,0x5A5A,{0x08,0x06,0x08,0xf8,0x08,0x88,0x08,0x88,0x7e,0xff,0x12,0x88,0x12,0x88,0x12,0xe5,0x23,0x83,0x24,0xfd,0x7c,0x84,0x06,0x84,0x0a,0xfc,0x10,0x84,0x60,0xfc,0x00,0x84}}, // 婚
{0x3A28,0x8DA6,0xBAA8,0xE681A8,0x6068,{0x08,0x00,0x08,0xfc,0x08,0x84,0x08,0x84,0x2c,0xfc,0x2a,0x84,0x2a,0x84,0x28,0xfc,0x48,0xc2,0x08,0xa2,0x08,0xa4,0x08,0x98,0x08,0x88,0x08,0xa4,0x08,0xc2,0x0b,0x01}}, // 恨
{0x3A29,0x8DA7,0xBAA9,0xE68787,0x61C7,{0x04,0x00,0x39,0x7c,0x26,0x44,0x1c,0x7c,0x76,0x44,0x09,0x7e,0x33,0x52,0x05,0x54,0x19,0x48,0x62,0x74,0x0c,0xc3,0x12,0x84,0x12,0x42,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 懇
{0x3A2A,0x8DA8,0xBAAA,0xE6988F,0x660F,{0x00,0x10,0x00,0x60,0x0f,0xc0,0x08,0x40,0x0f,0xfe,0x08,0x40,0x08,0x22,0x0f,0x12,0x70,0x0e,0x0f,0xfa,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 昏
{0x3A2B,0x8DA9,0xBAAB,0xE69886,0x6606,{0x00,0x00,0x1f,0xf8,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x40,0x10,0x40,0x10,0x4c,0x1f,0x70,0x10,0x40,0x10,0x42,0x1f,0x42,0x70,0x3e}}, // 昆
{0x3A2C,0x8DAA,0xBAAC,0xE6A0B9,0x6839,{0x08,0x00,0x08,0xfc,0x08,0x84,0x7f,0x84,0x08,0x84,0x08,0xfc,0x1c,0x84,0x1a,0x84,0x1a,0xfe,0x2a,0xa2,0x28,0x94,0x48,0x98,0x08,0x88,0x08,0xa4,0x08,0xc2,0x0b,0x01}}, // 根
{0x3A2D,0x8DAB,0xBAAD,0xE6A2B1,0x68B1,{0x08,0x00,0x09,0xfe,0x09,0x02,0x7f,0x22,0x09,0x22,0x09,0xfe,0x1d,0x22,0x1b,0x72,0x19,0x72,0x29,0xaa,0x29,0xaa,0x49,0x26,0x09,0x22,0x09,0x02,0x09,0xfe,0x09,0x02}}, // 梱
{0x3A2E,0x8DAC,0xBAAE,0xE6B7B7,0x6DF7,{0x10,0x00,0x0b,0xf8,0x0a,0x08,0x02,0x08,0x03,0xf8,0x42,0x08,0x22,0x08,0x23,0xf8,0x0a,0x20,0x0a,0x24,0x12,0x28,0x13,0xf0,0x22,0x20,0x22,0x22,0x43,0xa2,0x4e,0x1e}}, // 混
{0x3A2F,0x8DAD,0xBAAF,0xE79795,0x75D5,{0x00,0x40,0x00,0x40,0x0f,0xff,0x48,0x00,0x29,0xf8,0x29,0x08,0x09,0x08,0x09,0xf8,0x19,0x08,0x29,0x08,0x49,0xfa,0x09,0x44,0x11,0x28,0x11,0x10,0x23,0xcc,0x4c,0x03}}, // 痕
{0x3A30,0x8DAE,0xBAB0,0xE7B4BA,0x7D3A,{0x08,0x44,0x08,0x44,0x0a,0x44,0x73,0xff,0x14,0x44,0x08,0x44,0x0c,0x44,0x12,0x44,0x7d,0x7c,0x09,0x44,0x28,0x44,0x2a,0x44,0x29,0x44,0x29,0x44,0x48,0x7c,0x08,0x44}}, // 紺
{0x3A31,0x8DAF,0xBAB1,0xE889AE,0x826E,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xfa,0x08,0x84,0x08,0x48,0x08,0x50,0x08,0x20,0x0b,0x10,0x0c,0x0c,0x30,0x03}}, // 艮
{0x3A32,0x8DB0,0xBAB2,0xE9AD82,0x9B42,{0x00,0x20,0x00,0x40,0x3d,0xfc,0x01,0x24,0x01,0x24,0x01,0xfc,0x7f,0x24,0x09,0x24,0x09,0xfc,0x08,0x54,0x14,0x54,0x12,0x5a,0x1e,0x5e,0x62,0x91,0x03,0x11,0x0c,0x0f}}, // 魂
{0x3A33,0x8DB1,0xBAB3,0xE4BA9B,0x4E9B,{0x04,0x40,0x04,0x40,0x14,0x44,0x17,0x78,0x14,0x40,0x14,0x40,0x14,0x42,0x17,0x42,0x18,0x3e,0x60,0x00,0x0f,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x7f,0xff,0x00,0x00}}, // 些
{0x3A34,0x8DB2,0xBAB4,0xE4BD90,0x4F50,{0x04,0x40,0x04,0x40,0x04,0x40,0x0b,0xff,0x08,0x40,0x10,0x40,0x10,0x80,0x30,0x80,0x51,0xfe,0x11,0x20,0x12,0x20,0x14,0x20,0x10,0x20,0x10,0x20,0x13,0xff,0x10,0x00}}, // 佐
{0x3A35,0x8DB3,0xBAB5,0xE58F89,0x53C9,{0x00,0x00,0x00,0x00,0x3f,0xf8,0x09,0x08,0x08,0x88,0x04,0x90,0x04,0x90,0x02,0x20,0x02,0x20,0x01,0x40,0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x60,0x03}}, // 叉
{0x3A36,0x8DB4,0xBAB6,0xE59486,0x5506,{0x00,0x40,0x00,0x50,0x00,0x8c,0x7b,0xfa,0x48,0x90,0x48,0x91,0x49,0x0f,0x4a,0x40,0x4c,0x78,0x48,0x88,0x49,0x08,0x7e,0xd0,0x48,0x20,0x00,0xd0,0x03,0x0c,0x0c,0x03}}, // 唆
{0x3A37,0x8DB5,0xBAB7,0xE5B5AF,0x5D6F,{0x10,0x84,0x10,0x48,0x13,0xfe,0x54,0x20,0x54,0x20,0x55,0xfc,0x54,0x20,0x54,0x20,0x57,0xff,0x54,0x80,0x54,0x80,0x7d,0xfe,0x42,0x10,0x44,0x10,0x01,0xff,0x00,0x00}}, // 嵯
{0x3A38,0x8DB6,0xBAB8,0xE5B7A6,0x5DE6,{0x01,0x00,0x01,0x00,0x01,0x00,0x7f,0xfe,0x01,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x07,0xfc,0x04,0x40,0x08,0x40,0x10,0x40,0x20,0x40,0x40,0x40,0x1f,0xff,0x00,0x00}}, // 左
{0x3A39,0x8DB7,0xBAB9,0xE5B7AE,0x5DEE,{0x04,0x10,0x02,0x20,0x1f,0xfe,0x00,0x80,0x00,0x80,0x0f,0xf8,0x00,0x80,0x00,0x80,0x7f,0xff,0x04,0x00,0x07,0xfc,0x08,0x40,0x08,0x40,0x10,0x40,0x2f,0xff,0x40,0x00}}, // 差
{0x3A3A,0x8DB8,0xBABA,0xE69FBB,0x67FB,{0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x04,0x90,0x18,0x8c,0x6f,0xfb,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x7f,0xff,0x00,0x00}}, // 査
{0x3A3B,0x8DB9,0xBABB,0xE6B299,0x6C99,{0x10,0x20,0x08,0x20,0x08,0x20,0x01,0x28,0x41,0x24,0x21,0x22,0x22,0x22,0x02,0x21,0x0c,0x25,0x08,0x64,0x10,0x08,0x10,0x10,0x20,0x20,0x20,0x40,0x41,0x80,0x4e,0x00}}, // 沙
{0x3A3C,0x8DBA,0xBABC,0xE791B3,0x7473,{0x01,0x04,0x00,0x88,0x7f,0xfe,0x10,0x20,0x10,0x20,0x11,0xfc,0x7c,0x20,0x10,0x20,0x13,0xff,0x10,0x80,0x10,0x80,0x1d,0x7e,0x72,0x10,0x04,0x10,0x09,0xff,0x00,0x00}}, // 瑳
{0x3A3D,0x8DBB,0xBABD,0xE7A082,0x7802,{0x00,0x10,0x7f,0x10,0x08,0x10,0x08,0x58,0x08,0x54,0x08,0x52,0x1e,0x92,0x12,0x91,0x33,0x15,0x32,0x14,0x52,0x38,0x12,0x08,0x1e,0x10,0x12,0x20,0x00,0xc0,0x03,0x00}}, // 砂
{0x3A3E,0x8DBC,0xBABE,0xE8A990,0x8A50,{0x00,0x40,0x3e,0x40,0x00,0x40,0x7f,0x7f,0x00,0x90,0x3e,0x90,0x01,0x10,0x00,0x1e,0x3e,0x10,0x00,0x10,0x3e,0x10,0x22,0x1e,0x22,0x10,0x22,0x10,0x3e,0x10,0x22,0x10}}, // 詐
{0x3A3F,0x8DBD,0xBABF,0xE98E96,0x9396,{0x08,0x10,0x08,0x92,0x14,0x52,0x12,0x54,0x21,0x7e,0x7e,0x42,0x08,0x42,0x08,0x7e,0x7f,0x42,0x08,0x7e,0x4a,0x42,0x2c,0x42,0x28,0x7e,0x0f,0x14,0x18,0x62,0x61,0x81}}, // 鎖
{0x3A40,0x8DBE,0xBAC0,0xE8A39F,0x88DF,{0x30,0x20,0x08,0xa8,0x00,0xa4,0x61,0x22,0x12,0x2a,0x00,0x68,0x0c,0x10,0x30,0x60,0x43,0x80,0x00,0x80,0x7f,0xff,0x02,0x88,0x0c,0x50,0x74,0x20,0x07,0x18,0x38,0x07}}, // 裟
{0x3A41,0x8DBF,0xBAC1,0xE59D90,0x5750,{0x00,0x80,0x00,0x80,0x08,0x88,0x08,0x88,0x08,0x88,0x08,0x88,0x0c,0x94,0x12,0x92,0x12,0xa2,0x20,0x80,0x0f,0xfc,0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 坐
{0x3A42,0x8DC0,0xBAC2,0xE5BAA7,0x5EA7,{0x00,0x80,0x00,0x80,0x1f,0xff,0x10,0x00,0x12,0x48,0x12,0x48,0x12,0x48,0x15,0x54,0x15,0x54,0x18,0xe2,0x17,0xfc,0x20,0x40,0x20,0x40,0x40,0x40,0x1f,0xff,0x00,0x00}}, // 座
{0x3A43,0x8DC1,0xBAC3,0xE68CAB,0x632B,{0x10,0x20,0x11,0x24,0x11,0x24,0x11,0x24,0x7d,0x24,0x11,0x2c,0x11,0xaa,0x12,0x72,0x12,0x21,0x1c,0x20,0x71,0xfc,0x10,0x20,0x10,0x20,0x10,0x20,0x17,0xff,0x30,0x00}}, // 挫
{0x3A44,0x8DC2,0xBAC4,0xE582B5,0x50B5,{0x04,0x20,0x07,0xfe,0x04,0x20,0x09,0xfc,0x08,0x20,0x1f,0xff,0x10,0x00,0x31,0xfc,0x51,0x04,0x11,0xfc,0x11,0x04,0x11,0xfc,0x11,0x04,0x11,0xfc,0x10,0x8c,0x17,0x03}}, // 債
{0x3A45,0x8DC3,0xBAC5,0xE582AC,0x50AC,{0x04,0x20,0x05,0x22,0x05,0x22,0x09,0xfe,0x08,0x88,0x10,0x90,0x11,0xfe,0x31,0x10,0x53,0x10,0x15,0xfe,0x11,0x10,0x11,0xfe,0x11,0x10,0x11,0x10,0x11,0xff,0x11,0x00}}, // 催
{0x3A46,0x8DC4,0xBAC6,0xE5868D,0x518D,{0x00,0x00,0x3f,0xfe,0x00,0x80,0x00,0x80,0x0f,0xf8,0x08,0x88,0x08,0x88,0x0f,0xf8,0x08,0x88,0x08,0x88,0x08,0x88,0x7f,0xff,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x18}}, // 再
{0x3A47,0x8DC5,0xBAC7,0xE69C80,0x6700,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x00,0x00,0x7f,0xff,0x11,0x00,0x1f,0x7c,0x11,0x44,0x1f,0x28,0x11,0x18,0x1f,0x24,0x61,0xc2,0x01,0x01}}, // 最
{0x3A48,0x8DC6,0xBAC8,0xE59389,0x54C9,{0x02,0x20,0x02,0x28,0x1f,0xe4,0x02,0x24,0x02,0x20,0x7f,0xff,0x00,0x24,0x00,0x24,0x1f,0x24,0x11,0x28,0x11,0x18,0x11,0x10,0x1f,0x2a,0x11,0x4a,0x10,0x86,0x03,0x02}}, // 哉
{0x3A49,0x8DC7,0xBAC9,0xE5A19E,0x585E,{0x01,0x00,0x01,0x00,0x7f,0xfe,0x44,0x42,0x5f,0xfa,0x04,0x40,0x1f,0xf8,0x04,0x40,0x7f,0xfe,0x04,0x40,0x09,0x20,0x1f,0xf8,0x61,0x06,0x01,0x00,0x7f,0xfe,0x00,0x00}}, // 塞
{0x3A4A,0x8DC8,0xBACA,0xE5A6BB,0x59BB,{0x00,0x80,0x00,0x80,0x3f,0xff,0x00,0x80,0x0f,0xfc,0x00,0x84,0x7f,0xff,0x00,0x84,0x0f,0xfc,0x00,0x80,0x7f,0xff,0x01,0x10,0x02,0x10,0x0f,0xe0,0x01,0x98,0x1e,0x04}}, // 妻
{0x3A4B,0x8DC9,0xBACB,0xE5AEB0,0x5BB0,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x41,0x00,0x3f,0xf8,0x08,0x20,0x04,0x40,0x7f,0xfe,0x01,0x00,0x01,0x00,0x3f,0xfc,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00}}, // 宰
{0x3A4C,0x8DCA,0xBACC,0xE5BDA9,0x5F69,{0x01,0x08,0x06,0x08,0x78,0x90,0x10,0x90,0x49,0x24,0x29,0x44,0x22,0x08,0x08,0x08,0x7f,0x92,0x08,0x22,0x0c,0x44,0x1a,0x04,0x19,0x08,0x28,0x10,0x48,0x20,0x08,0xc0}}, // 彩
{0x3A4D,0x8DCB,0xBACD,0xE6898D,0x624D,{0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x44,0x7f,0xfe,0x00,0x40,0x00,0x48,0x00,0x50,0x00,0x60,0x00,0xc0,0x01,0x40,0x06,0x40,0x18,0x40,0x60,0x40,0x01,0xc0,0x00,0x40}}, // 才
{0x3A4E,0x8DCC,0xBACE,0xE68EA1,0x63A1,{0x10,0x06,0x10,0x38,0x13,0xc2,0x12,0x42,0x7d,0x24,0x11,0x24,0x11,0x28,0x10,0x20,0x1c,0x20,0x73,0xff,0x10,0x70,0x10,0xa8,0x11,0x24,0x16,0x22,0x10,0x21,0x30,0x20}}, // 採
{0x3A4F,0x8DCD,0xBACF,0xE6A0BD,0x683D,{0x04,0x20,0x04,0x28,0x3f,0xa4,0x04,0x24,0x04,0x20,0x7f,0xff,0x00,0x20,0x04,0x24,0x04,0x24,0x7f,0xd4,0x0c,0x18,0x0e,0x18,0x15,0x2a,0x24,0xaa,0x44,0x46,0x04,0x82}}, // 栽
{0x3A50,0x8DCE,0xBAD0,0xE6ADB3,0x6B73,{0x00,0x80,0x08,0x80,0x08,0xfe,0x08,0x80,0x7f,0xff,0x00,0x24,0x00,0x22,0x1f,0xfe,0x10,0x20,0x17,0xd2,0x11,0x14,0x15,0x88,0x15,0x4d,0x29,0x15,0x23,0x23,0x40,0xc1}}, // 歳
{0x3A51,0x8DCF,0xBAD1,0xE6B888,0x6E08,{0x10,0x20,0x08,0x20,0x0f,0xff,0x01,0x08,0x40,0x90,0x20,0x60,0x20,0xd0,0x01,0x0c,0x0f,0x0b,0x09,0xf8,0x09,0x08,0x11,0xf8,0x11,0x08,0x21,0x08,0x22,0x08,0x44,0x08}}, // 済
{0x3A52,0x8DD0,0xBAD2,0xE781BD,0x707D,{0x08,0x42,0x08,0x42,0x10,0x84,0x21,0x08,0x10,0x84,0x08,0x42,0x08,0x42,0x00,0x84,0x08,0x84,0x08,0x88,0x09,0x50,0x11,0x40,0x02,0x20,0x04,0x10,0x08,0x0c,0x70,0x03}}, // 災
{0x3A53,0x8DD1,0xBAD3,0xE98787,0x91C7,{0x00,0x04,0x00,0x38,0x1f,0xc0,0x00,0x84,0x08,0x44,0x04,0x48,0x04,0x90,0x00,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80,0x00,0x80}}, // 采
{0x3A54,0x8DD2,0xBAD4,0xE78A80,0x7280,{0x00,0x00,0x1f,0xfe,0x10,0x02,0x10,0x02,0x1f,0xfe,0x10,0x42,0x17,0x5c,0x10,0x40,0x17,0x5c,0x10,0x00,0x12,0x40,0x13,0xfc,0x24,0x40,0x2f,0xff,0x40,0x40,0x00,0x40}}, // 犀
{0x3A55,0x8DD3,0xBAD5,0xE7A095,0x7815,{0x00,0x40,0x7f,0x40,0x09,0xf8,0x08,0x48,0x08,0x48,0x08,0x49,0x1e,0x89,0x13,0x27,0x32,0x20,0x32,0x20,0x53,0xfe,0x12,0x20,0x1e,0x20,0x12,0x20,0x10,0x20,0x00,0x20}}, // 砕
{0x3A56,0x8DD4,0xBAD6,0xE7A0A6,0x7826,{0x04,0x20,0x04,0x22,0x14,0x24,0x17,0xb8,0x14,0x20,0x14,0x21,0x17,0xa1,0x1c,0x1f,0x30,0x00,0x7f,0xff,0x02,0x00,0x07,0xfc,0x0c,0x04,0x14,0x04,0x67,0xfc,0x04,0x04}}, // 砦
{0x3A57,0x8DD5,0xBAD7,0xE7A5AD,0x796D,{0x04,0x00,0x07,0xfc,0x08,0x84,0x15,0x28,0x73,0x10,0x0a,0x68,0x04,0x84,0x1b,0xf3,0x60,0x00,0x00,0x00,0x7f,0xff,0x00,0x80,0x04,0xb0,0x18,0x8c,0x60,0x82,0x01,0x80}}, // 祭
{0x3A58,0x8DD6,0xBAD8,0xE6968E,0x658E,{0x00,0x80,0x00,0x80,0x7f,0xff,0x04,0x10,0x02,0x20,0x01,0xc0,0x03,0x60,0x0c,0x18,0x7b,0xef,0x08,0x08,0x0f,0xf8,0x08,0x88,0x0a,0xc8,0x12,0xa8,0x14,0xa8,0x21,0x88}}, // 斎
{0x3A59,0x8DD7,0xBAD9,0xE7B4B0,0x7D30,{0x08,0x00,0x08,0xfe,0x0a,0x92,0x72,0x92,0x14,0x92,0x08,0x92,0x0c,0x92,0x12,0xfe,0x7d,0x92,0x08,0x92,0x2c,0x92,0x2a,0x92,0x2a,0x92,0x2a,0xfe,0x48,0x82,0x08,0x00}}, // 細
{0x3A5A,0x8DD8,0xBADA,0xE88F9C,0x83DC,{0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x02,0x18,0x1f,0xe4,0x00,0x84,0x08,0x48,0x04,0x50,0x00,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x0c,0x98,0x70,0x87,0x00,0x80}}, // 菜
{0x3A5B,0x8DD9,0xBADB,0xE8A381,0x88C1,{0x04,0x20,0x04,0x24,0x3f,0xa2,0x04,0x22,0x04,0x20,0x7f,0xff,0x04,0x20,0x7f,0xa2,0x08,0x12,0x14,0x94,0x35,0x14,0x52,0x08,0x11,0x1a,0x14,0xa6,0x18,0x46,0x30,0x82}}, // 裁
{0x3A5C,0x8DDA,0xBADC,0xE8BC89,0x8F09,{0x04,0x28,0x04,0x24,0x3f,0xa4,0x04,0x20,0x7f,0xff,0x04,0x20,0x7f,0xe4,0x04,0x24,0x3f,0xa8,0x24,0x98,0x3f,0x90,0x24,0x98,0x3f,0xaa,0x04,0x2a,0x7f,0xc6,0x04,0x82}}, // 載
{0x3A5D,0x8DDB,0xBADD,0xE99A9B,0x969B,{0x00,0x80,0x3c,0xfe,0x25,0x22,0x25,0xb4,0x2a,0x48,0x35,0x58,0x28,0xa4,0x25,0xfa,0x26,0x01,0x24,0x00,0x27,0xfe,0x38,0x20,0x21,0x28,0x21,0x24,0x22,0x22,0x20,0x60}}, // 際
{0x3A5E,0x8DDC,0xBADE,0xE589A4,0x5264,{0x04,0x02,0x04,0x12,0x7f,0xf2,0x11,0x12,0x0a,0x12,0x06,0x12,0x19,0x92,0x70,0xf2,0x10,0x92,0x1f,0x92,0x10,0x92,0x1f,0x82,0x10,0x82,0x20,0x82,0x20,0x82,0x40,0x86}}, // 剤
{0x3A5F,0x8DDD,0xBADF,0xE59CA8,0x5728,{0x01,0x00,0x01,0x00,0x01,0x00,0x7f,0xff,0x02,0x20,0x02,0x20,0x0c,0x20,0x0c,0x20,0x0b,0xfe,0x18,0x20,0x28,0x20,0x48,0x20,0x08,0x20,0x08,0x20,0x0f,0xff,0x08,0x00}}, // 在
{0x3A60,0x8DDE,0xBAE0,0xE69D90,0x6750,{0x08,0x08,0x08,0x08,0x08,0x08,0x7f,0xff,0x08,0x08,0x08,0x18,0x1c,0x18,0x1a,0x28,0x19,0x28,0x29,0x48,0x28,0x48,0x48,0x88,0x09,0x08,0x08,0x08,0x08,0x18,0x08,0x08}}, // 材
{0x3A61,0x8DDF,0xBAE1,0xE7BDAA,0x7F6A,{0x00,0x00,0x3f,0xfe,0x22,0x22,0x22,0x22,0x3f,0xfe,0x20,0x22,0x02,0x20,0x3e,0x3e,0x02,0x20,0x3e,0x3e,0x02,0x20,0x0e,0x20,0x74,0x3f,0x04,0x20,0x08,0x20,0x10,0x20}}, // 罪
{0x3A62,0x8DE0,0xBAE2,0xE8B2A1,0x8CA1,{0x00,0x08,0x3e,0x08,0x22,0x08,0x22,0x08,0x3f,0xff,0x22,0x08,0x22,0x18,0x3e,0x18,0x22,0x28,0x22,0x28,0x22,0x48,0x3e,0x88,0x15,0x08,0x12,0x08,0x22,0x18,0x40,0x08}}, // 財
{0x3A63,0x8DE1,0xBAE3,0xE586B4,0x51B4,{0x00,0x00,0x23,0xfe,0x10,0x88,0x08,0x88,0x08,0x88,0x00,0x88,0x00,0x88,0x0b,0xff,0x08,0x28,0x10,0x28,0x10,0x48,0x20,0x88,0x21,0x08,0x42,0x08,0x4c,0x38,0x00,0x08}}, // 冴
{0x3A64,0x8DE2,0xBAE4,0xE59D82,0x5742,{0x08,0x00,0x09,0xff,0x09,0x00,0x09,0x00,0x7f,0x00,0x09,0xfc,0x09,0x44,0x09,0x44,0x09,0x44,0x09,0x28,0x0e,0x28,0x1a,0x10,0x62,0x18,0x04,0x24,0x08,0xc2,0x03,0x01}}, // 坂
{0x3A65,0x8DE3,0xBAE5,0xE998AA,0x962A,{0x00,0x00,0x3c,0xff,0x24,0x80,0x24,0x80,0x28,0x80,0x30,0xfe,0x28,0xa2,0x24,0xa2,0x24,0xa4,0x24,0x94,0x24,0x98,0x39,0x08,0x21,0x14,0x22,0x24,0x24,0xc2,0x23,0x01}}, // 阪
{0x3A66,0x8DE4,0xBAE6,0xE5A0BA,0x583A,{0x00,0x00,0x11,0xfe,0x11,0x22,0x11,0x22,0x11,0xfe,0x7d,0x22,0x11,0x22,0x11,0xfe,0x10,0x50,0x10,0x88,0x15,0x4c,0x1a,0x4b,0x60,0x48,0x00,0x88,0x01,0x08,0x02,0x08}}, // 堺
{0x3A67,0x8DE5,0xBAE7,0xE6A68A,0x698A,{0x09,0x08,0x09,0x08,0x09,0x08,0x7f,0xfe,0x08,0x6a,0x08,0xaa,0x1c,0xbe,0x1d,0x2a,0x19,0xaa,0x2b,0x6a,0x2d,0x3e,0x49,0x08,0x09,0x08,0x09,0x08,0x09,0x08,0x09,0x08}}, // 榊
{0x3A68,0x8DE6,0xBAE8,0xE882B4,0x80B4,{0x00,0x08,0x0f,0x30,0x00,0xc0,0x07,0x30,0x3a,0x08,0x7f,0xfe,0x02,0x00,0x04,0x00,0x07,0xf8,0x0c,0x08,0x17,0xf8,0x24,0x08,0x47,0xf8,0x04,0x08,0x04,0x18,0x04,0x08}}, // 肴
{0x3A69,0x8DE7,0xBAE9,0xE592B2,0x54B2,{0x01,0x04,0x00,0x84,0x00,0x48,0x3e,0x50,0x23,0xfe,0x22,0x20,0x22,0x20,0x22,0x20,0x23,0xff,0x22,0x20,0x3e,0x50,0x22,0x50,0x20,0x88,0x01,0x04,0x06,0x02,0x18,0x01}}, // 咲
{0x3A6A,0x8DE8,0xBAEA,0xE5B48E,0x5D0E,{0x00,0x20,0x10,0x20,0x13,0xfe,0x54,0x50,0x54,0x88,0x55,0x04,0x54,0x00,0x57,0xff,0x54,0x04,0x55,0xe4,0x55,0x24,0x7d,0x24,0x45,0xe4,0x41,0x24,0x00,0x0c,0x00,0x04}}, // 崎
{0x3A6B,0x8DE9,0xBAEB,0xE59FBC,0x57FC,{0x00,0x20,0x10,0x20,0x13,0xfe,0x10,0x30,0x10,0x48,0x7d,0x84,0x10,0x00,0x13,0xff,0x10,0x04,0x11,0xe4,0x11,0x24,0x15,0x24,0x19,0xe4,0x61,0x24,0x00,0x0c,0x00,0x04}}, // 埼
{0x3A6C,0x8DEA,0xBAEC,0xE7A295,0x7895,{0x00,0x20,0x7f,0x20,0x08,0xfe,0x08,0x50,0x08,0x88,0x09,0x04,0x1e,0x00,0x13,0xff,0x32,0x04,0x32,0xe4,0x52,0xa4,0x12,0xa4,0x1e,0xe4,0x12,0xa4,0x10,0x0c,0x00,0x04}}, // 碕
{0x3A6D,0x8DEB,0xBAED,0xE9B7BA,0x9DFA,{0x00,0x20,0x3e,0x3c,0x22,0xe4,0x3e,0x18,0x08,0x64,0x2f,0xff,0x28,0x44,0x3d,0x7c,0x67,0xf0,0x04,0x10,0x07,0xfc,0x04,0x00,0x07,0xfe,0x29,0x22,0x24,0x92,0x40,0x0c}}, // 鷺
{0x3A6E,0x8DEC,0xBAEE,0xE4BD9C,0x4F5C,{0x04,0x80,0x04,0x80,0x04,0x80,0x08,0xff,0x09,0x20,0x19,0x20,0x1a,0x20,0x2c,0x3e,0x48,0x20,0x08,0x20,0x08,0x20,0x08,0x3e,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20}}, // 作
{0x3A6F,0x8DED,0xBAEF,0xE5898A,0x524A,{0x08,0x02,0x49,0x22,0x29,0x22,0x2a,0x22,0x08,0x22,0x3f,0x22,0x21,0x22,0x21,0x22,0x3f,0x22,0x21,0x22,0x21,0x22,0x3f,0x22,0x21,0x02,0x21,0x02,0x23,0x0e,0x21,0x02}}, // 削
{0x3A70,0x8DEE,0xBAF0,0xE5928B,0x548B,{0x00,0x80,0x00,0x80,0x7c,0x80,0x44,0xff,0x45,0x20,0x45,0x20,0x46,0x20,0x44,0x3e,0x44,0x20,0x44,0x20,0x44,0x20,0x7c,0x3e,0x44,0x20,0x40,0x20,0x00,0x20,0x00,0x20}}, // 咋
{0x3A71,0x8DEF,0xBAF1,0xE690BE,0x643E,{0x10,0x40,0x10,0x40,0x13,0xff,0x12,0x92,0x7c,0x90,0x10,0x91,0x11,0x0f,0x12,0x80,0x1c,0xff,0x71,0x20,0x11,0x3e,0x12,0x20,0x14,0x3e,0x10,0x20,0x30,0x20,0x10,0x20}}, // 搾
{0x3A72,0x8DF0,0xBAF2,0xE698A8,0x6628,{0x00,0x40,0x00,0x40,0x3e,0x40,0x22,0x7f,0x22,0x50,0x22,0x90,0x22,0x90,0x3f,0x1e,0x22,0x10,0x22,0x10,0x22,0x10,0x22,0x1e,0x3e,0x10,0x22,0x10,0x20,0x10,0x00,0x10}}, // 昨
{0x3A73,0x8DF1,0xBAF3,0xE69C94,0x6714,{0x21,0x00,0x11,0x3e,0x12,0x22,0x7f,0xa2,0x04,0x22,0x04,0x3e,0x25,0x22,0x25,0x22,0x25,0x22,0x25,0x3e,0x3f,0x22,0x25,0x22,0x08,0x42,0x08,0x42,0x10,0x82,0x21,0x06}}, // 朔
{0x3A74,0x8DF2,0xBAF4,0xE69FB5,0x67F5,{0x08,0x00,0x09,0xfe,0x09,0x52,0x7f,0x52,0x09,0x52,0x09,0x52,0x1d,0x52,0x1b,0xff,0x19,0x52,0x29,0x52,0x29,0x52,0x49,0x52,0x09,0x52,0x09,0x52,0x09,0x56,0x09,0x02}}, // 柵
{0x3A75,0x8DF3,0xBAF5,0xE7AA84,0x7A84,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x22,0x44,0x44,0x40,0x18,0x44,0x62,0x3c,0x02,0x00,0x07,0xfe,0x19,0x00,0x61,0xfc,0x01,0x00,0x01,0xfc,0x01,0x00,0x01,0x00,0x01,0x00}}, // 窄
{0x3A76,0x8DF4,0xBAF6,0xE7AD96,0x7B56,{0x08,0x10,0x08,0x10,0x1f,0xbf,0x14,0x28,0x22,0x44,0x40,0x80,0x7f,0xff,0x00,0x80,0x1f,0xfc,0x10,0x84,0x11,0xc4,0x12,0xac,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80}}, // 策
{0x3A77,0x8DF5,0xBAF7,0xE7B4A2,0x7D22,{0x01,0x00,0x01,0x00,0x7f,0xfe,0x01,0x00,0x01,0x00,0x3f,0xfe,0x22,0x24,0x4c,0x40,0x02,0xb0,0x01,0x0c,0x7f,0xf2,0x01,0x00,0x09,0x30,0x11,0x08,0x61,0x04,0x01,0x00}}, // 索
{0x3A78,0x8DF6,0xBAF8,0xE98CAF,0x932F,{0x08,0x28,0x08,0x28,0x14,0x28,0x12,0xfe,0x21,0x28,0x7e,0x28,0x09,0xff,0x08,0x00,0x7f,0x7c,0x08,0x44,0x4a,0x44,0x2c,0x7c,0x29,0x44,0x0e,0x44,0x18,0x7c,0x60,0x44}}, // 錯
{0x3A79,0x8DF7,0xBAF9,0xE6A19C,0x685C,{0x08,0x22,0x09,0x12,0x08,0x92,0x7e,0x94,0x08,0x84,0x08,0x08,0x1c,0x20,0x1a,0x20,0x19,0xff,0x28,0x24,0x28,0x44,0x48,0x48,0x08,0xf8,0x08,0x28,0x08,0xc4,0x0b,0x02}}, // 桜
{0x3A7A,0x8DF8,0xBAFA,0xE9AEAD,0x9BAD,{0x08,0x10,0x0e,0x10,0x12,0xfe,0x24,0x10,0x7f,0x10,0x29,0x10,0x29,0xff,0x3f,0x00,0x29,0x10,0x29,0x10,0x3f,0xfe,0x02,0x10,0x35,0x10,0x2a,0x10,0x2b,0xff,0x40,0x00}}, // 鮭
{0x3A7B,0x8DF9,0xBAFB,0xE7ACB9,0x7B39,{0x08,0x20,0x08,0x20,0x1f,0xbf,0x14,0x48,0x22,0x84,0x42,0x04,0x08,0x88,0x08,0x88,0x7f,0xff,0x08,0x88,0x08,0x88,0x08,0xf8,0x08,0x88,0x08,0x00,0x0f,0xfe,0x08,0x00}}, // 笹
{0x3A7C,0x8DFA,0xBAFC,0xE58C99,0x5319,{0x00,0x20,0x1f,0x20,0x11,0x20,0x1f,0x22,0x11,0x24,0x11,0x38,0x1f,0x20,0x00,0x20,0x7f,0xa0,0x14,0x22,0x14,0x22,0x17,0xa2,0x1c,0x1e,0x24,0x00,0x23,0x00,0x40,0xff}}, // 匙
{0x3A7D,0x8DFB,0xBAFD,0xE5868A,0x518A,{0x00,0x00,0x1f,0xfc,0x12,0x24,0x12,0x24,0x12,0x24,0x12,0x24,0x12,0x24,0x7f,0xff,0x12,0x24,0x12,0x24,0x12,0x24,0x12,0x24,0x12,0x24,0x12,0x24,0x12,0x24,0x12,0x2c}}, // 冊
{0x3A7E,0x8DFC,0xBAFE,0xE588B7,0x5237,{0x00,0x02,0x3f,0x92,0x20,0x92,0x20,0x92,0x3f,0x92,0x24,0x12,0x24,0x12,0x3f,0x92,0x34,0x92,0x34,0x92,0x54,0x92,0x54,0x92,0x94,0x82,0x15,0x82,0x14,0x0e,0x04,0x02}}, // 刷
{0x3B21,0x8E40,0xBBA1,0xE5AF9F,0x5BDF,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x24,0x04,0x4f,0xfc,0x11,0x48,0x6a,0x30,0x04,0x50,0x19,0x88,0x67,0xe6,0x00,0x00,0x3f,0xfc,0x05,0x60,0x19,0x18,0x61,0x04,0x03,0x00}}, // 察
{0x3B22,0x8E41,0xBBA2,0xE68BB6,0x62F6,{0x10,0x92,0x10,0x92,0x13,0x6c,0x11,0x24,0x7c,0x92,0x10,0x92,0x10,0x20,0x10,0x3e,0x1c,0x42,0x70,0x84,0x11,0x44,0x16,0x28,0x10,0x10,0x10,0x20,0x30,0xc0,0x13,0x00}}, // 拶
{0x3B23,0x8E42,0xBBA3,0xE692AE,0x64AE,{0x10,0x00,0x11,0xfc,0x11,0x04,0x11,0xfc,0x7d,0x04,0x11,0xfc,0x10,0x00,0x17,0xff,0x1e,0x40,0x73,0xfe,0x12,0x52,0x13,0xd4,0x12,0x6c,0x13,0xca,0x16,0x71,0x30,0x40}}, // 撮
{0x3B24,0x8E43,0xBBA4,0xE693A6,0x64E6,{0x10,0x20,0x10,0x20,0x13,0xff,0x12,0x82,0x7c,0xfe,0x11,0x52,0x16,0xcc,0x11,0x94,0x1d,0x22,0x72,0xfd,0x14,0x00,0x13,0xfe,0x10,0xa4,0x11,0x22,0x16,0x21,0x30,0x60}}, // 擦
{0x3B25,0x8E44,0xBBA5,0xE69CAD,0x672D,{0x08,0x40,0x08,0x40,0x08,0x40,0x7f,0x40,0x08,0x40,0x08,0x40,0x1c,0x40,0x1a,0x40,0x19,0x40,0x28,0x40,0x28,0x40,0x48,0x42,0x08,0x42,0x08,0x22,0x08,0x1e,0x08,0x00}}, // 札
{0x3B26,0x8E45,0xBBA6,0xE6AEBA,0x6BBA,{0x02,0x00,0x22,0xf8,0x14,0x88,0x08,0x88,0x14,0x8a,0x62,0x8a,0x09,0x06,0x0a,0x00,0x7f,0xf8,0x08,0x48,0x1c,0x48,0x1a,0x28,0x2a,0x10,0x48,0x28,0x08,0xc4,0x0b,0x03}}, // 殺
{0x3B27,0x8E46,0xBBA7,0xE896A9,0x85A9,{0x04,0x20,0x7f,0xff,0x04,0x20,0x00,0x10,0x3d,0xfe,0x24,0x84,0x24,0x48,0x2b,0xff,0x32,0x90,0x2a,0xfe,0x26,0x90,0x27,0x7e,0x3a,0x10,0x24,0x10,0x25,0xff,0x28,0x00}}, // 薩
{0x3B28,0x8E47,0xBBA8,0xE99B91,0x96D1,{0x08,0x24,0x08,0x24,0x7e,0x28,0x0a,0x7f,0x0a,0x48,0x12,0xc8,0x11,0xc8,0x28,0x7e,0x08,0x48,0x7f,0xc8,0x0c,0x7e,0x1a,0x48,0x19,0x48,0x28,0x48,0x48,0x7f,0x08,0x40}}, // 雑
{0x3B29,0x8E48,0xBBA9,0xE79A90,0x7690,{0x00,0x80,0x01,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x00,0x00,0x1e,0xbc,0x00,0x80,0x1e,0xbc,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80}}, // 皐
{0x3B2A,0x8E49,0xBBAA,0xE9AF96,0x9BD6,{0x08,0x10,0x0e,0x10,0x12,0xfe,0x24,0x10,0x7f,0xfe,0x29,0x10,0x29,0xff,0x3f,0x00,0x29,0x7c,0x29,0x44,0x3f,0x7c,0x05,0x44,0x32,0xfc,0x2a,0x44,0x28,0x44,0x40,0x4c}}, // 鯖
{0x3B2B,0x8E4A,0xBBAB,0xE68D8C,0x634C,{0x10,0x02,0x17,0xd2,0x14,0x52,0x14,0x52,0x7c,0x52,0x17,0xd2,0x11,0x12,0x11,0x12,0x11,0xd2,0x1d,0x52,0x72,0x52,0x12,0x42,0x12,0x42,0x14,0x42,0x38,0x46,0x11,0x82}}, // 捌
{0x3B2C,0x8E4B,0xBBAC,0xE98C86,0x9306,{0x08,0x20,0x08,0x20,0x17,0xfe,0x12,0x20,0x22,0xfc,0x7e,0x20,0x09,0xff,0x08,0x00,0x7f,0xfc,0x08,0x84,0x4a,0xfc,0x2a,0x84,0x2c,0xfc,0x0e,0x84,0x18,0x84,0x60,0x8c}}, // 錆
{0x3B2D,0x8E4C,0xBBAD,0xE9AEAB,0x9BAB,{0x08,0x10,0x0e,0x10,0x12,0x10,0x24,0xff,0x7f,0x24,0x29,0x22,0x29,0x46,0x3f,0xa5,0x29,0x24,0x29,0x14,0x3f,0x18,0x05,0x08,0x32,0x94,0x2a,0x24,0x28,0x42,0x41,0x81}}, // 鮫
{0x3B2E,0x8E4D,0xBBAE,0xE79ABF,0x76BF,{0x00,0x00,0x00,0x00,0x1f,0xfc,0x12,0x24,0x12,0x24,0x12,0x24,0x12,0x24,0x12,0x24,0x12,0x24,0x12,0x24,0x12,0x24,0x12,0x24,0x12,0x24,0x7f,0xff,0x00,0x00,0x00,0x00}}, // 皿
{0x3B2F,0x8E4E,0xBBAF,0xE69992,0x6652,{0x00,0x00,0x07,0xff,0x78,0x50,0x48,0x50,0x48,0x50,0x4b,0xfe,0x4a,0x52,0x7a,0x52,0x4a,0x52,0x4a,0x52,0x4a,0x9e,0x4b,0x02,0x7a,0x02,0x4a,0x02,0x43,0xfe,0x02,0x02}}, // 晒
{0x3B30,0x8E4F,0xBBB0,0xE4B889,0x4E09,{0x00,0x08,0x1f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x7f,0xff,0x00,0x00,0x00,0x00}}, // 三
{0x3B31,0x8E50,0xBBB1,0xE58298,0x5098,{0x00,0x80,0x00,0x80,0x01,0x40,0x06,0x30,0x18,0x8c,0x68,0x8b,0x08,0x88,0x14,0x94,0x2a,0xaa,0x08,0x88,0x14,0x94,0x22,0xa2,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80}}, // 傘
{0x3B32,0x8E51,0xBBB2,0xE58F82,0x53C2,{0x01,0x00,0x01,0x60,0x02,0x18,0x1f,0xe4,0x01,0x00,0x7f,0xff,0x02,0x20,0x04,0x50,0x19,0x8c,0x6e,0x23,0x00,0x40,0x01,0x88,0x1e,0x10,0x00,0x60,0x01,0x80,0x1e,0x00}}, // 参
{0x3B33,0x8E52,0xBBB3,0xE5B1B1,0x5C71,{0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x20,0x82,0x20,0x82,0x20,0x82,0x20,0x82,0x20,0x82,0x20,0x82,0x20,0x82,0x20,0x82,0x20,0x82,0x3f,0xfe,0x20,0x02}}, // 山
{0x3B34,0x8E53,0xBBB4,0xE683A8,0x60E8,{0x08,0x20,0x08,0x28,0x08,0x44,0x09,0xfa,0x0c,0x20,0x2b,0xff,0x28,0x48,0x28,0x84,0x4b,0x12,0x08,0x61,0x09,0x88,0x08,0x32,0x09,0xc4,0x08,0x18,0x08,0x60,0x0b,0x80}}, // 惨
{0x3B35,0x8E54,0xBBB5,0xE69292,0x6492,{0x12,0x90,0x12,0x90,0x17,0xd0,0x12,0x9f,0x7a,0x94,0x17,0xf4,0x10,0x24,0x13,0xd4,0x1e,0x54,0x73,0xd4,0x12,0x48,0x13,0xcc,0x12,0x54,0x12,0x52,0x32,0x62,0x12,0xc1}}, // 撒
{0x3B36,0x8E55,0xBBB6,0xE695A3,0x6563,{0x12,0x20,0x12,0x20,0x7f,0x20,0x12,0x3f,0x12,0x24,0x7f,0xc4,0x00,0x44,0x3e,0xa4,0x22,0x24,0x3e,0x28,0x22,0x18,0x3e,0x10,0x22,0x28,0x22,0x44,0x22,0x82,0x27,0x01}}, // 散
{0x3B37,0x8E56,0xBBB7,0xE6A19F,0x685F,{0x08,0x14,0x08,0x12,0x08,0x12,0x7f,0x1e,0x08,0xf0,0x08,0x1e,0x1c,0xf0,0x1a,0x1f,0x19,0xf4,0x29,0x14,0x28,0x08,0x48,0x18,0x08,0x29,0x08,0xc5,0x0b,0x03,0x08,0x01}}, // 桟
{0x3B38,0x8E57,0xBBB8,0xE787A6,0x71E6,{0x11,0x00,0x11,0xde,0x11,0x02,0x15,0xd4,0x16,0x48,0x35,0x54,0x38,0xa2,0x51,0x25,0x56,0xa4,0x10,0xa8,0x1b,0xff,0x14,0x70,0x14,0xa8,0x21,0x24,0x22,0x23,0x40,0x20}}, // 燦
{0x3B39,0x8E58,0xBBB9,0xE78F8A,0x73CA,{0x00,0x00,0x7d,0xfc,0x11,0x54,0x11,0x54,0x11,0x54,0x11,0x54,0x7d,0x54,0x17,0xff,0x11,0x54,0x11,0x54,0x11,0x54,0x11,0x54,0x1d,0x54,0x71,0x54,0x01,0x54,0x01,0x0c}}, // 珊
{0x3B3A,0x8E59,0xBBBA,0xE794A3,0x7523,{0x00,0x80,0x00,0x80,0x3f,0xfe,0x04,0x10,0x02,0x10,0x02,0x20,0x1f,0xff,0x12,0x40,0x12,0x40,0x17,0xfc,0x14,0x40,0x18,0x40,0x27,0xfc,0x20,0x40,0x40,0x40,0x1f,0xff}}, // 産
{0x3B3B,0x8E5A,0xBBBB,0xE7AE97,0x7B97,{0x10,0x20,0x10,0x20,0x1f,0x7f,0x24,0x90,0x22,0x08,0x4f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x02,0x20,0x7f,0xff,0x04,0x20,0x08,0x20}}, // 算
{0x3B3C,0x8E5B,0xBBBC,0xE7BA82,0x7E82,{0x10,0x20,0x1f,0xbf,0x22,0x48,0x47,0xf0,0x04,0x10,0x07,0xf0,0x04,0x10,0x07,0xf0,0x04,0x10,0x7f,0xff,0x04,0xb0,0x1b,0x4c,0x61,0xb3,0x1f,0xec,0x04,0xb0,0x18,0x88}}, // 纂
{0x3B3D,0x8E5C,0xBBBD,0xE89A95,0x8695,{0x00,0x00,0x7f,0xfe,0x01,0x00,0x01,0x00,0x3f,0xfc,0x01,0x80,0x02,0x40,0x0d,0x30,0x71,0x0e,0x1f,0xf0,0x11,0x10,0x11,0x10,0x1f,0xf0,0x01,0x18,0x01,0xf4,0x7e,0x02}}, // 蚕
{0x3B3E,0x8E5D,0xBBBE,0xE8AE83,0x8B83,{0x00,0x44,0x3d,0xef,0x00,0x44,0x7f,0xef,0x00,0x44,0x3e,0xaa,0x01,0x01,0x00,0x7c,0x3e,0x44,0x00,0x7c,0x00,0x44,0x3e,0x7c,0x22,0x44,0x22,0x7c,0x3e,0x24,0x22,0xc2}}, // 讃
{0x3B3F,0x8E5E,0xBBBF,0xE8B39B,0x8CDB,{0x04,0x10,0x3f,0x7e,0x04,0x10,0x7f,0xff,0x0a,0x28,0x11,0x44,0x6f,0xfb,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x02,0x30,0x0c,0x0c,0x30,0x02}}, // 賛
{0x3B40,0x8E5F,0xBBC0,0xE985B8,0x9178,{0x00,0x10,0x7f,0x98,0x0c,0x26,0x0c,0xfd,0x3f,0x28,0x2d,0x2a,0x2d,0x46,0x35,0xa0,0x37,0x3c,0x31,0x44,0x21,0x54,0x3f,0x98,0x21,0x08,0x21,0x14,0x3f,0x22,0x21,0xc1}}, // 酸
{0x3B41,0x8E60,0xBBC1,0xE9A490,0x9910,{0x04,0x00,0x07,0xfe,0x04,0x22,0x0f,0x14,0x79,0x88,0x06,0xb4,0x19,0x43,0x62,0xa0,0x0f,0xf8,0x74,0x17,0x07,0xf0,0x04,0x10,0x07,0xf4,0x04,0x88,0x07,0x70,0x38,0x0f}}, // 餐
{0x3B42,0x8E61,0xBBC2,0xE696AC,0x65AC,{0x04,0x02,0x04,0x0c,0x7f,0xf0,0x04,0x20,0x3f,0xa0,0x24,0xbf,0x24,0xa4,0x3f,0xa4,0x24,0xa4,0x24,0xa4,0x3f,0xa4,0x04,0x24,0x7f,0xc4,0x04,0x44,0x04,0x84,0x04,0x04}}, // 斬
{0x3B43,0x8E62,0xBBC3,0xE69AAB,0x66AB,{0x04,0x02,0x7f,0xcc,0x04,0x30,0x3f,0xa0,0x24,0xbf,0x3f,0xa4,0x24,0xa4,0x7f,0xc4,0x04,0x44,0x04,0x84,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 暫
{0x3B44,0x8E63,0xBBC4,0xE6AE8B,0x6B8B,{0x00,0x20,0x7f,0x24,0x10,0x22,0x10,0x22,0x11,0xff,0x1e,0x20,0x12,0xfe,0x22,0x20,0x32,0x20,0x4d,0xff,0x04,0x12,0x08,0x0c,0x08,0x19,0x10,0x25,0x20,0xc3,0x43,0x01}}, // 残
{0x3B45,0x8E64,0xBBC5,0xE4BB95,0x4ED5,{0x04,0x20,0x04,0x20,0x04,0x20,0x08,0x20,0x08,0x20,0x10,0x20,0x17,0xff,0x30,0x20,0x50,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x13,0xfe,0x10,0x00}}, // 仕
{0x3B46,0x8E65,0xBBC6,0xE4BB94,0x4ED4,{0x04,0x00,0x05,0xfc,0x04,0x04,0x08,0x08,0x08,0x10,0x10,0x20,0x30,0x20,0x57,0xff,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0xe0,0x10,0x20}}, // 仔
{0x3B47,0x8E66,0xBBC7,0xE4BCBA,0x4F3A,{0x04,0x00,0x07,0xfe,0x04,0x02,0x08,0x02,0x0b,0xfa,0x10,0x02,0x10,0x02,0x31,0xf2,0x51,0x12,0x11,0x12,0x11,0x12,0x11,0xf2,0x11,0x12,0x10,0x02,0x10,0x02,0x10,0x06}}, // 伺
{0x3B48,0x8E67,0xBBC8,0xE4BDBF,0x4F7F,{0x04,0x20,0x04,0x20,0x07,0xff,0x08,0x20,0x08,0x20,0x13,0xfe,0x12,0x22,0x32,0x22,0x52,0x22,0x13,0xfe,0x12,0xa2,0x10,0x40,0x10,0x60,0x10,0x90,0x13,0x0c,0x1c,0x03}}, // 使
{0x3B49,0x8E68,0xBBC9,0xE588BA,0x523A,{0x04,0x02,0x04,0x12,0x7f,0xd2,0x04,0x12,0x04,0x12,0x3f,0x92,0x24,0x92,0x24,0x92,0x25,0x92,0x2e,0x12,0x0d,0x12,0x14,0x92,0x14,0x82,0x24,0x02,0x44,0x06,0x04,0x02}}, // 刺
{0x3B4A,0x8E69,0xBBCA,0xE58FB8,0x53F8,{0x00,0x00,0x7f,0xfc,0x00,0x04,0x00,0x04,0x3f,0xe4,0x00,0x04,0x00,0x04,0x1f,0xc4,0x10,0x44,0x10,0x44,0x10,0x44,0x1f,0xc4,0x10,0x44,0x00,0x04,0x00,0x08,0x00,0x30}}, // 司
{0x3B4B,0x8E6A,0xBBCB,0xE58FB2,0x53F2,{0x00,0x80,0x00,0x80,0x00,0x80,0x1f,0xfc,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x84,0x04,0x80,0x03,0x00,0x01,0x80,0x02,0x60,0x0c,0x18,0x30,0x07}}, // 史
{0x3B4C,0x8E6B,0xBBCC,0xE597A3,0x55E3,{0x00,0x00,0x3e,0xfe,0x22,0x02,0x22,0x02,0x3e,0xfe,0x00,0x02,0x7f,0x02,0x55,0x7a,0x55,0x4a,0x55,0x4a,0x7f,0x4a,0x55,0x7a,0x55,0x4a,0x55,0x02,0x55,0x02,0x43,0x0c}}, // 嗣
{0x3B4D,0x8E6C,0xBBCD,0xE59B9B,0x56DB,{0x00,0x00,0x00,0x00,0x7f,0xfe,0x44,0x42,0x44,0x42,0x44,0x42,0x44,0x42,0x44,0x46,0x48,0x46,0x48,0x3e,0x50,0x02,0x60,0x02,0x40,0x02,0x7f,0xfe,0x40,0x02,0x00,0x00}}, // 四
{0x3B4E,0x8E6D,0xBBCE,0xE5A3AB,0x58EB,{0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x82,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x3f,0xfe,0x00,0x00}}, // 士
{0x3B4F,0x8E6E,0xBBCF,0xE5A78B,0x59CB,{0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x24,0x7f,0x22,0x12,0x42,0x12,0x4f,0x13,0xf1,0x22,0x01,0x3c,0x00,0x44,0x7e,0x06,0x42,0x0a,0x42,0x10,0x42,0x60,0x7e,0x00,0x42}}, // 始
{0x3B50,0x8E6F,0xBBD0,0xE5A789,0x59C9,{0x08,0x10,0x08,0x10,0x08,0x10,0x09,0xff,0x7f,0x10,0x12,0x10,0x12,0xfe,0x12,0x92,0x22,0x92,0x3c,0x92,0x44,0x92,0x06,0x92,0x0a,0x9c,0x10,0x10,0x60,0x10,0x00,0x10}}, // 姉
{0x3B51,0x8E70,0xBBD1,0xE5A7BF,0x59FF,{0x01,0x00,0x21,0x00,0x11,0xfe,0x12,0x44,0x02,0x48,0x0c,0x60,0x31,0x98,0x4e,0x06,0x01,0x00,0x7f,0xff,0x02,0x10,0x04,0x10,0x1f,0xa0,0x00,0xe0,0x03,0x18,0x3c,0x04}}, // 姿
{0x3B52,0x8E71,0xBBD2,0xE5AD90,0x5B50,{0x00,0x00,0x1f,0xf8,0x00,0x08,0x00,0x10,0x00,0x20,0x00,0x40,0x00,0x80,0x00,0x82,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x03,0x80,0x00,0x80}}, // 子
{0x3B53,0x8E72,0xBBD3,0xE5B18D,0x5C4D,{0x00,0x00,0x1f,0xfc,0x10,0x04,0x10,0x04,0x1f,0xfc,0x10,0x04,0x10,0x00,0x1f,0xfe,0x12,0x20,0x13,0xa2,0x12,0xa4,0x14,0xb8,0x3b,0x20,0x21,0x22,0x46,0x22,0x18,0x1e}}, // 屍
{0x3B54,0x8E73,0xBBD4,0xE5B882,0x5E02,{0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x1f,0xfc,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x98,0x00,0x80,0x00,0x80,0x00,0x80}}, // 市
{0x3B55,0x8E74,0xBBD5,0xE5B8AB,0x5E2B,{0x04,0x00,0x09,0xff,0x3e,0x10,0x22,0x10,0x22,0xfe,0x22,0x92,0x3e,0x92,0x22,0x92,0x20,0x92,0x3e,0x92,0x22,0x92,0x22,0x92,0x22,0x9c,0x3e,0x90,0x20,0x10,0x20,0x10}}, // 師
{0x3B56,0x8E75,0xBBD6,0xE5BF97,0x5FD7,{0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x02,0x40,0x12,0x24,0x12,0x22,0x12,0x01,0x22,0x09,0x41,0x08,0x00,0xf8}}, // 志
{0x3B57,0x8E76,0xBBD7,0xE6809D,0x601D,{0x00,0x00,0x1f,0xfc,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x84,0x10,0x84,0x10,0x84,0x1f,0xfc,0x00,0x80,0x12,0x40,0x12,0x24,0x12,0x22,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 思
{0x3B58,0x8E77,0xBBD8,0xE68C87,0x6307,{0x08,0x80,0x08,0x86,0x08,0xf8,0x08,0x80,0x7f,0x81,0x08,0x81,0x08,0x7f,0x08,0x00,0x0e,0xfe,0x78,0x82,0x08,0x82,0x08,0xfe,0x08,0x82,0x08,0x82,0x18,0xfe,0x08,0x82}}, // 指
{0x3B59,0x8E78,0xBBD9,0xE694AF,0x652F,{0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x1f,0xf0,0x04,0x10,0x04,0x10,0x02,0x20,0x01,0x40,0x00,0x80,0x01,0x40,0x02,0x20,0x0c,0x18,0x70,0x07}}, // 支
{0x3B5A,0x8E79,0xBBDA,0xE5AD9C,0x5B5C,{0x00,0x40,0x7f,0x40,0x02,0x40,0x04,0x7f,0x08,0x44,0x08,0x44,0x0b,0x84,0x0c,0x84,0x19,0x28,0x68,0x28,0x08,0x10,0x08,0x18,0x08,0x28,0x08,0x44,0x18,0x82,0x09,0x01}}, // 孜
{0x3B5B,0x8E7A,0xBBDB,0xE696AF,0x65AF,{0x11,0x02,0x11,0x0c,0x7f,0xf0,0x11,0x20,0x11,0x20,0x1f,0x3f,0x11,0x24,0x11,0x24,0x1f,0x24,0x11,0x24,0x11,0x24,0x7f,0xe4,0x12,0x44,0x11,0x44,0x21,0x84,0x40,0x04}}, // 斯
{0x3B5C,0x8E7B,0xBBDC,0xE696BD,0x65BD,{0x08,0x20,0x08,0x20,0x08,0x20,0x7f,0x7f,0x10,0x48,0x10,0x88,0x1f,0x4e,0x12,0x7a,0x13,0xca,0x12,0x4a,0x12,0x4c,0x12,0x48,0x22,0x48,0x22,0x41,0x42,0x21,0x0c,0x1f}}, // 施
{0x3B5D,0x8E7C,0xBBDD,0xE697A8,0x65E8,{0x10,0x00,0x10,0x0c,0x10,0xf0,0x1f,0x00,0x10,0x02,0x10,0x02,0x0f,0xfe,0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 旨
{0x3B5E,0x8E7D,0xBBDE,0xE69E9D,0x679D,{0x08,0x10,0x08,0x10,0x08,0x10,0x7f,0xff,0x08,0x10,0x08,0x10,0x1d,0xfc,0x1c,0x44,0x1a,0x44,0x2a,0x28,0x2a,0x28,0x48,0x10,0x08,0x28,0x08,0x44,0x08,0x82,0x0b,0x01}}, // 枝
{0x3B5F,0x8E7E,0xBBDF,0xE6ADA2,0x6B62,{0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x08,0x80,0x08,0x80,0x08,0xfc,0x08,0x80,0x08,0x80,0x08,0x80,0x08,0x80,0x08,0x80,0x08,0x80,0x08,0x82,0x7f,0xff,0x00,0x00}}, // 止
{0x3B60,0x8E80,0xBBE0,0xE6ADBB,0x6B7B,{0x00,0x00,0x7f,0xff,0x08,0x40,0x08,0x40,0x0f,0x44,0x09,0x44,0x11,0x48,0x11,0x50,0x2a,0x60,0x46,0x40,0x04,0x40,0x04,0x40,0x08,0x42,0x10,0x42,0x20,0x3e,0x40,0x00}}, // 死
{0x3B61,0x8E81,0xBBE1,0xE6B08F,0x6C0F,{0x00,0x08,0x00,0x70,0x0f,0xc0,0x08,0x40,0x08,0x40,0x08,0x40,0x08,0x5e,0x0f,0xe0,0x08,0x40,0x08,0x20,0x08,0x20,0x08,0x10,0x08,0x09,0x0b,0x85,0x1c,0x03,0x60,0x01}}, // 氏
{0x3B62,0x8E82,0xBBE2,0xE78D85,0x7345,{0x09,0x00,0x4a,0x7f,0x2b,0x88,0x32,0x88,0x12,0xbe,0x12,0xaa,0x33,0xaa,0x4a,0x2a,0x1b,0xaa,0x1a,0xaa,0x2a,0xaa,0x4a,0xaa,0x0b,0xae,0x0a,0xa8,0x6a,0x08,0x10,0x08}}, // 獅
{0x3B63,0x8E83,0xBBE3,0xE7A589,0x7949,{0x08,0x10,0x08,0x10,0x08,0x10,0x7e,0x90,0x02,0x90,0x04,0x9e,0x04,0x90,0x08,0x90,0x0c,0x90,0x1a,0x90,0x29,0x90,0x48,0x90,0x08,0x90,0x08,0x90,0x0b,0xff,0x08,0x00}}, // 祉
{0x3B64,0x8E84,0xBBE4,0xE7A781,0x79C1,{0x01,0x10,0x06,0x10,0x3c,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x7f,0x90,0x06,0x20,0x0d,0x28,0x0c,0xa4,0x14,0xa4,0x14,0x42,0x24,0x5e,0x45,0xe2,0x04,0x01,0x04,0x01}}, // 私
{0x3B65,0x8E85,0xBBE5,0xE7B3B8,0x7CF8,{0x01,0x00,0x01,0x00,0x01,0x20,0x02,0x20,0x1c,0x40,0x06,0x80,0x01,0x20,0x02,0x18,0x7f,0xf4,0x01,0x02,0x09,0x20,0x09,0x10,0x09,0x10,0x11,0x08,0x21,0x08,0x01,0x00}}, // 糸
{0x3B66,0x8E86,0xBBE6,0xE7B499,0x7D19,{0x08,0x02,0x08,0x0c,0x0a,0x78,0x72,0x48,0x14,0x48,0x08,0x48,0x0c,0x48,0x12,0x7f,0x7d,0x48,0x09,0x48,0x28,0x48,0x2a,0x44,0x29,0x44,0x29,0x55,0x48,0x63,0x09,0x81}}, // 紙
{0x3B67,0x8E87,0xBBE7,0xE7B4AB,0x7D2B,{0x04,0x20,0x14,0x22,0x17,0xa4,0x14,0x38,0x14,0x21,0x17,0xa1,0x1c,0x9f,0x60,0x80,0x0f,0x10,0x02,0x60,0x01,0x8c,0x7f,0xf6,0x02,0xb1,0x0c,0x8c,0x30,0x82,0x00,0x80}}, // 紫
{0x3B68,0x8E88,0xBBE8,0xE882A2,0x80A2,{0x00,0x20,0x3e,0x20,0x22,0x20,0x23,0xfe,0x22,0x20,0x3e,0x20,0x23,0xfc,0x22,0x84,0x22,0x44,0x3e,0x48,0x22,0x28,0x22,0x10,0x22,0x30,0x22,0x48,0x26,0x84,0x43,0x03}}, // 肢
{0x3B69,0x8E89,0xBBE9,0xE88482,0x8102,{0x00,0x80,0x3e,0x84,0x22,0x98,0x22,0xe0,0x22,0x82,0x3e,0x82,0x22,0x7e,0x22,0x00,0x22,0xfc,0x3e,0x84,0x22,0x84,0x22,0xfc,0x22,0x84,0x22,0x84,0x26,0xfc,0x42,0x84}}, // 脂
{0x3B6A,0x8E8A,0xBBEA,0xE887B3,0x81F3,{0x00,0x00,0x7f,0xff,0x01,0x20,0x01,0x10,0x02,0x08,0x04,0x78,0x1f,0x84,0x00,0x04,0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 至
{0x3B6B,0x8E8B,0xBBEB,0xE8A696,0x8996,{0x08,0x00,0x08,0xfc,0x08,0x84,0x7e,0x84,0x02,0xfc,0x04,0x84,0x04,0x84,0x08,0xfc,0x0c,0x84,0x1a,0x84,0x29,0xfc,0x48,0x28,0x08,0x28,0x08,0x49,0x08,0x89,0x09,0x07}}, // 視
{0x3B6C,0x8E8C,0xBBEC,0xE8A99E,0x8A5E,{0x00,0x00,0x3e,0xfe,0x00,0x02,0x7f,0x02,0x00,0xfa,0x3e,0x02,0x00,0x02,0x00,0xf2,0x3e,0x92,0x00,0x92,0x3e,0x92,0x22,0xf2,0x22,0x92,0x22,0x02,0x3e,0x02,0x22,0x0c}}, // 詞
{0x3B6D,0x8E8D,0xBBED,0xE8A9A9,0x8A69,{0x00,0x10,0x3e,0x10,0x00,0xfe,0x7f,0x10,0x00,0x10,0x3e,0x10,0x01,0xff,0x00,0x04,0x3e,0x04,0x01,0xff,0x3e,0x84,0x22,0x44,0x22,0x44,0x22,0x04,0x3e,0x0c,0x22,0x04}}, // 詩
{0x3B6E,0x8E8E,0xBBEE,0xE8A9A6,0x8A66,{0x00,0x08,0x3e,0x0c,0x00,0x0a,0x7f,0x08,0x00,0xff,0x3e,0x08,0x00,0x08,0x01,0xf8,0x3e,0x48,0x00,0x48,0x3e,0x48,0x22,0x54,0x22,0x65,0x23,0x85,0x3e,0x03,0x22,0x01}}, // 試
{0x3B6F,0x8E8F,0xBBEF,0xE8AA8C,0x8A8C,{0x00,0x10,0x3e,0x10,0x00,0x10,0x7f,0xff,0x00,0x10,0x3e,0x10,0x00,0x10,0x00,0xfe,0x3e,0x10,0x00,0x08,0x3e,0xa8,0x22,0xa2,0x22,0xa1,0x22,0xa5,0x3f,0x24,0x22,0x1c}}, // 誌
{0x3B70,0x8E90,0xBBF0,0xE8ABAE,0x8AEE,{0x00,0x10,0x3f,0x10,0x00,0x9f,0x7f,0xaa,0x00,0x48,0x3e,0x08,0x00,0x54,0x00,0x94,0x3f,0x22,0x00,0x41,0x3e,0xfe,0x22,0x42,0x22,0x42,0x22,0x42,0x3e,0x7e,0x22,0x42}}, // 諮
{0x3B71,0x8E91,0xBBF1,0xE8B387,0x8CC7,{0x20,0x80,0x18,0xfe,0x01,0x22,0x06,0x24,0x18,0xd0,0x63,0x0c,0x0f,0xfa,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x02,0x30,0x0c,0x08,0x30,0x04}}, // 資
{0x3B72,0x8E92,0xBBF2,0xE8B39C,0x8CDC,{0x00,0x00,0x3e,0xfc,0x22,0x84,0x22,0x84,0x3e,0xfc,0x22,0x84,0x22,0x84,0x3e,0xfc,0x22,0x40,0x22,0xfe,0x23,0x2a,0x3e,0x4a,0x14,0x92,0x12,0x22,0x22,0x42,0x40,0x0c}}, // 賜
{0x3B73,0x8E93,0xBBF3,0xE99B8C,0x96CC,{0x0a,0x24,0x0a,0x24,0x0a,0x48,0x2a,0x7f,0x2a,0xc8,0x2a,0x48,0x2e,0xc8,0x2b,0x7e,0x2a,0x48,0x2a,0x48,0x2a,0x7e,0x2a,0x48,0x2a,0x48,0x2e,0x48,0x3a,0x7f,0x61,0xc0}}, // 雌
{0x3B74,0x8E94,0xBBF4,0xE9A3BC,0x98FC,{0x08,0x00,0x08,0xfe,0x14,0x02,0x12,0x02,0x29,0xfa,0x7e,0x02,0x22,0x02,0x3e,0xf2,0x22,0x92,0x22,0x92,0x3e,0x92,0x28,0xf2,0x24,0x92,0x26,0x02,0x3a,0x02,0x61,0x0c}}, // 飼
{0x3B75,0x8E95,0xBBF5,0xE6ADAF,0x6B6F,{0x00,0x80,0x08,0x80,0x08,0xfc,0x08,0x80,0x08,0x80,0x7f,0xff,0x14,0x94,0x12,0xa4,0x10,0x84,0x1f,0xfc,0x11,0xc4,0x12,0xa4,0x14,0x94,0x10,0x84,0x1f,0xfc,0x10,0x04}}, // 歯
{0x3B76,0x8E96,0xBBF6,0xE4BA8B,0x4E8B,{0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x00,0x80,0x1f,0xfc,0x00,0x84,0x7f,0xff,0x00,0x84,0x1f,0xfc,0x00,0x80,0x03,0x80,0x00,0x80}}, // 事
{0x3B77,0x8E97,0xBBF7,0xE4BCBC,0x4F3C,{0x04,0x04,0x05,0x04,0x05,0x04,0x09,0x84,0x09,0x44,0x11,0x24,0x11,0x24,0x31,0x04,0x51,0x04,0x11,0x04,0x11,0x04,0x11,0x4c,0x11,0x8a,0x13,0x12,0x1c,0x21,0x10,0x41}}, // 似
{0x3B78,0x8E98,0xBBF8,0xE4BE8D,0x4F8D,{0x04,0x20,0x04,0x20,0x05,0xfe,0x08,0x20,0x08,0x20,0x10,0x20,0x17,0xff,0x30,0x08,0x50,0x08,0x13,0xfe,0x11,0x08,0x10,0x88,0x10,0x88,0x10,0x88,0x10,0x38,0x10,0x08}}, // 侍
{0x3B79,0x8E99,0xBBF9,0xE58590,0x5150,{0x10,0x00,0x11,0xfc,0x11,0x04,0x11,0x04,0x11,0x04,0x11,0xfc,0x11,0x04,0x11,0x04,0x11,0x04,0x11,0xfc,0x12,0x40,0x02,0x40,0x02,0x40,0x04,0x41,0x18,0x41,0x60,0x3f}}, // 児
{0x3B7A,0x8E9A,0xBBFA,0xE5AD97,0x5B57,{0x00,0x80,0x00,0x80,0x3f,0xfe,0x20,0x04,0x20,0x00,0x4f,0xf0,0x00,0x20,0x00,0xc0,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x03,0x80,0x00,0x80}}, // 字
{0x3B7B,0x8E9B,0xBBFB,0xE5AFBA,0x5BFA,{0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x10,0x00,0x10,0x3f,0xfe,0x08,0x10,0x04,0x10,0x02,0x10,0x02,0x10,0x00,0x70,0x00,0x10}}, // 寺
{0x3B7C,0x8E9C,0xBBFC,0xE68588,0x6148,{0x04,0x08,0x02,0x10,0x7f,0xff,0x08,0x20,0x0a,0x28,0x32,0xc8,0x0c,0x30,0x05,0x14,0x09,0x24,0x7e,0xfa,0x00,0x82,0x12,0x44,0x12,0x42,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 慈
{0x3B7D,0x8E9D,0xBBFD,0xE68C81,0x6301,{0x08,0x20,0x08,0x20,0x09,0xfe,0x08,0x20,0x7e,0x20,0x08,0x20,0x0b,0xff,0x08,0x04,0x08,0x04,0x0f,0xff,0x78,0x84,0x08,0x44,0x08,0x44,0x08,0x04,0x18,0x1c,0x08,0x04}}, // 持
{0x3B7E,0x8E9E,0xBBFE,0xE69982,0x6642,{0x00,0x20,0x00,0x20,0x7d,0xfe,0x44,0x20,0x44,0x20,0x44,0x20,0x47,0xff,0x7c,0x04,0x44,0x04,0x47,0xff,0x45,0x04,0x44,0x84,0x7c,0x84,0x44,0x04,0x00,0x1c,0x00,0x04}}, // 時
{0x3C21,0x8E9F,0xBCA1,0xE6ACA1,0x6B21,{0x01,0x00,0x01,0x00,0x21,0x00,0x21,0x00,0x11,0xff,0x11,0x22,0x02,0x24,0x02,0x28,0x14,0x20,0x10,0x20,0x20,0x50,0x20,0x50,0x40,0x88,0x41,0x04,0x46,0x02,0x18,0x01}}, // 次
{0x3C22,0x8EA0,0xBCA2,0xE6BB8B,0x6ECB,{0x21,0x04,0x10,0x84,0x10,0x88,0x07,0xff,0x00,0x84,0x40,0x84,0x21,0x08,0x21,0x48,0x0e,0x72,0x09,0x4a,0x10,0x84,0x10,0x84,0x21,0x4a,0x22,0x52,0x4f,0xff,0x40,0x21}}, // 滋
{0x3C23,0x8EA1,0xBCA3,0xE6B2BB,0x6CBB,{0x10,0x40,0x08,0x40,0x08,0x40,0x00,0x90,0x00,0x88,0x41,0x04,0x21,0x3c,0x27,0xc2,0x08,0x02,0x09,0xfc,0x11,0x04,0x11,0x04,0x21,0x04,0x21,0x04,0x41,0xfc,0x41,0x04}}, // 治
{0x3C24,0x8EA2,0xBCA4,0xE788BE,0x723E,{0x00,0x00,0x7f,0xff,0x08,0x88,0x10,0x84,0x7f,0xff,0x20,0x82,0x2a,0xaa,0x24,0x92,0x3a,0xea,0x20,0x82,0x22,0x8a,0x3a,0xea,0x24,0x92,0x2a,0xaa,0x30,0xc2,0x20,0x86}}, // 爾
{0x3C25,0x8EA3,0xBCA5,0xE792BD,0x74BD,{0x00,0x00,0x7f,0xff,0x10,0x84,0x3f,0xfe,0x6a,0xab,0x24,0x92,0x2a,0xaa,0x24,0x92,0x2a,0xae,0x00,0x00,0x3f,0xfe,0x00,0x80,0x1f,0xfc,0x00,0x90,0x7f,0xff,0x00,0x00}}, // 璽
{0x3C26,0x8EA4,0xBCA6,0xE79794,0x75D4,{0x00,0x20,0x00,0x20,0x0f,0xff,0x08,0x20,0x49,0xfc,0x28,0x20,0x28,0x20,0x0f,0xff,0x08,0x04,0x18,0x04,0x2b,0xff,0x49,0x04,0x10,0x84,0x10,0x84,0x20,0x0c,0x40,0x04}}, // 痔
{0x3C27,0x8EA5,0xBCA7,0xE7A381,0x78C1,{0x00,0x84,0x00,0x44,0x7e,0x48,0x13,0xff,0x10,0x88,0x10,0x88,0x12,0xa8,0x3d,0x32,0x24,0xaa,0x64,0xcc,0x24,0x44,0x24,0x88,0x3c,0xcc,0x25,0x32,0x27,0xff,0x00,0x11}}, // 磁
{0x3C28,0x8EA6,0xBCA8,0xE7A4BA,0x793A,{0x00,0x00,0x00,0x00,0x1f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x7f,0xff,0x00,0x80,0x04,0x90,0x04,0x88,0x08,0x84,0x08,0x84,0x10,0x82,0x20,0x82,0x43,0x80,0x00,0x80}}, // 示
{0x3C29,0x8EA7,0xBCA9,0xE8808C,0x800C,{0x00,0x00,0x7f,0xfe,0x01,0x00,0x01,0x00,0x02,0x00,0x3f,0xfc,0x22,0x44,0x22,0x44,0x22,0x44,0x22,0x44,0x22,0x44,0x22,0x44,0x22,0x44,0x22,0x44,0x22,0x44,0x20,0x0c}}, // 而
{0x3C2A,0x8EA8,0xBCAA,0xE880B3,0x8033,{0x00,0x00,0x7f,0xff,0x04,0x10,0x04,0x10,0x07,0xf0,0x04,0x10,0x04,0x10,0x04,0x10,0x07,0xf0,0x04,0x10,0x04,0x10,0x04,0x1f,0x07,0xf0,0x78,0x10,0x00,0x10,0x00,0x10}}, // 耳
{0x3C2B,0x8EA9,0xBCAB,0xE887AA,0x81EA,{0x01,0x00,0x01,0x00,0x02,0x00,0x1f,0xfc,0x10,0x04,0x10,0x04,0x10,0x04,0x1f,0xfc,0x10,0x04,0x10,0x04,0x1f,0xfc,0x10,0x04,0x10,0x04,0x10,0x04,0x1f,0xfc,0x10,0x04}}, // 自
{0x3C2C,0x8EAA,0xBCAC,0xE89294,0x8494,{0x04,0x10,0x04,0x10,0x7f,0xfe,0x04,0x10,0x00,0x20,0x3d,0xfc,0x24,0x20,0x24,0x20,0x27,0xff,0x3c,0x08,0x25,0xfe,0x24,0x88,0x24,0x48,0x3c,0x48,0x24,0x18,0x00,0x08}}, // 蒔
{0x3C2D,0x8EAB,0xBCAD,0xE8BE9E,0x8F9E,{0x02,0x10,0x0c,0x10,0x79,0xfe,0x08,0x84,0x08,0x44,0x08,0x44,0x7f,0x48,0x09,0xff,0x08,0x10,0x3e,0x10,0x22,0xfe,0x22,0x10,0x22,0x10,0x22,0x10,0x3e,0x10,0x22,0x10}}, // 辞
{0x3C2E,0x8EAC,0xBCAE,0xE6B190,0x6C50,{0x10,0x20,0x08,0x20,0x08,0x20,0x00,0x3e,0x40,0x42,0x20,0x42,0x20,0x82,0x01,0x44,0x0a,0x24,0x08,0x18,0x10,0x08,0x10,0x10,0x20,0x20,0x20,0x40,0x41,0x80,0x46,0x00}}, // 汐
{0x3C2F,0x8EAD,0xBCAF,0xE9B9BF,0x9E7F,{0x00,0x80,0x00,0x80,0x1f,0xff,0x11,0x20,0x11,0x20,0x1f,0xfe,0x11,0x22,0x11,0x22,0x1f,0xfe,0x14,0x20,0x14,0x24,0x17,0xb8,0x24,0x20,0x24,0x22,0x47,0xa2,0x1c,0x1e}}, // 鹿
{0x3C30,0x8EAE,0xBCB0,0xE5BC8F,0x5F0F,{0x00,0x20,0x00,0x28,0x00,0x24,0x00,0x24,0x7f,0xff,0x00,0x20,0x00,0x20,0x3f,0xa0,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x08,0x05,0xc9,0x0e,0x05,0x70,0x03,0x00,0x01}}, // 式
{0x3C31,0x8EAF,0xBCB1,0xE8AD98,0x8B58,{0x00,0x88,0x3c,0x8c,0x03,0xfa,0x7d,0x2a,0x00,0xa8,0x3c,0xa8,0x03,0xff,0x00,0x08,0x3d,0xea,0x01,0x2a,0x3d,0xec,0x25,0x24,0x25,0x2d,0x25,0xeb,0x3d,0x13,0x24,0x21}}, // 識
{0x3C32,0x8EB0,0xBCB2,0xE9B4AB,0x9D2B,{0x00,0x20,0x00,0x40,0x7d,0xf8,0x55,0x08,0x55,0xf8,0x55,0x08,0x7d,0xf8,0x55,0x00,0x55,0xff,0x55,0x00,0x55,0xfe,0x7c,0x52,0x42,0xaa,0x02,0xa2,0x04,0x02,0x00,0x0c}}, // 鴫
{0x3C33,0x8EB1,0xBCB3,0xE7ABBA,0x7AFA,{0x08,0x10,0x08,0x10,0x08,0x10,0x0f,0xbf,0x14,0x28,0x12,0x24,0x22,0x44,0x40,0x00,0x00,0x00,0x1f,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7f,0xff,0x00,0x00}}, // 竺
{0x3C34,0x8EB2,0xBCB4,0xE8BBB8,0x8EF8,{0x04,0x08,0x04,0x08,0x7f,0xc8,0x04,0x08,0x3f,0x7f,0x25,0x49,0x25,0x49,0x3f,0x49,0x25,0x7f,0x25,0x49,0x3f,0x49,0x04,0x49,0x7f,0xc9,0x04,0x7f,0x04,0x41,0x04,0x40}}, // 軸
{0x3C35,0x8EB3,0xBCB5,0xE5AE8D,0x5B8D,{0x01,0x00,0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x21,0x00,0x41,0x00,0x01,0x00,0x7f,0xfe,0x00,0x00,0x04,0x20,0x04,0x10,0x08,0x08,0x08,0x08,0x10,0x04,0x20,0x04}}, // 宍
{0x3C36,0x8EB4,0xBCB6,0xE99BAB,0x96EB,{0x00,0x00,0x3f,0xfc,0x01,0x00,0x3f,0xfe,0x21,0x02,0x3d,0x74,0x41,0x00,0x1d,0x78,0x00,0x00,0x7f,0xfe,0x01,0x00,0x01,0xc0,0x01,0x30,0x01,0x08,0x01,0x00,0x01,0x00}}, // 雫
{0x3C37,0x8EB5,0xBCB7,0xE4B883,0x4E03,{0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x06,0x04,0x78,0x07,0x80,0x7c,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x04,0x04,0x04,0x02,0x04,0x01,0xfc,0x00,0x00}}, // 七
{0x3C38,0x8EB6,0xBCB8,0xE58FB1,0x53F1,{0x00,0x80,0x00,0x80,0x7c,0x80,0x44,0x84,0x44,0x88,0x44,0x90,0x44,0xa0,0x44,0xc0,0x47,0x80,0x44,0x80,0x44,0x80,0x7c,0x80,0x44,0x82,0x40,0x82,0x00,0x42,0x00,0x3e}}, // 叱
{0x3C39,0x8EB7,0xBCB9,0xE59FB7,0x57F7,{0x08,0x20,0x08,0x20,0x3f,0x20,0x08,0x20,0x08,0xfc,0x7f,0xa4,0x22,0x24,0x14,0xa4,0x7f,0x64,0x08,0x24,0x08,0x24,0x3f,0x54,0x08,0x54,0x08,0x85,0x09,0x05,0x0a,0x03}}, // 執
{0x3C3A,0x8EB8,0xBCBA,0xE5A4B1,0x5931,{0x00,0x80,0x08,0x80,0x08,0x80,0x08,0x80,0x0f,0xfc,0x10,0x80,0x10,0x80,0x20,0x80,0x7f,0xff,0x00,0x80,0x01,0x40,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x60,0x03}}, // 失
{0x3C3B,0x8EB9,0xBCBB,0xE5AB89,0x5AC9,{0x10,0x08,0x10,0x08,0x10,0xff,0x12,0x90,0x7d,0x90,0x25,0xbf,0x24,0xa8,0x24,0xc8,0x25,0x88,0x4a,0xff,0x78,0x88,0x0c,0x98,0x09,0x14,0x11,0x24,0x62,0x42,0x04,0x81}}, // 嫉
{0x3C3C,0x8EBA,0xBCBC,0xE5AEA4,0x5BA4,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x40,0x00,0x3f,0xfc,0x02,0x40,0x04,0x30,0x3f,0xc8,0x01,0x04,0x01,0x00,0x1f,0xf8,0x01,0x00,0x01,0x00,0x7f,0xff,0x00,0x00}}, // 室
{0x3C3D,0x8EBB,0xBCBD,0xE68289,0x6089,{0x00,0x08,0x00,0x70,0x3f,0x88,0x08,0x88,0x04,0x90,0x7f,0xff,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x02,0x40,0x12,0x24,0x12,0x22,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 悉
{0x3C3E,0x8EBC,0xBCBE,0xE6B9BF,0x6E7F,{0x10,0x00,0x0b,0xfc,0x0a,0x04,0x02,0x04,0x03,0xfc,0x42,0x04,0x22,0x04,0x23,0xfc,0x08,0x00,0x08,0x92,0x14,0x92,0x12,0x94,0x22,0x94,0x20,0x90,0x4f,0xff,0x40,0x00}}, // 湿
{0x3C3F,0x8EBD,0xBCBF,0xE6BC86,0x6F06,{0x10,0x20,0x08,0x20,0x0f,0xff,0x08,0x70,0x41,0xac,0x26,0x23,0x20,0x20,0x00,0x50,0x09,0xac,0x0e,0x23,0x11,0x24,0x10,0xa8,0x20,0xf0,0x21,0xac,0x46,0x23,0x40,0x60}}, // 漆
{0x3C40,0x8EBE,0xBCC0,0xE796BE,0x75BE,{0x00,0x20,0x00,0x20,0x0f,0xff,0x48,0x80,0x28,0x80,0x29,0xfe,0x09,0x20,0x0a,0x20,0x18,0x20,0x2f,0xff,0x48,0x30,0x10,0x50,0x10,0x48,0x20,0x84,0x43,0x02,0x0c,0x01}}, // 疾
{0x3C41,0x8EBF,0xBCC1,0xE8B3AA,0x8CEA,{0x02,0x04,0x3c,0x78,0x20,0x40,0x3f,0x7f,0x24,0x48,0x24,0x88,0x4f,0xf8,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x02,0x60,0x0c,0x18,0x30,0x04}}, // 質
{0x3C42,0x8EC0,0xBCC2,0xE5AE9F,0x5B9F,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x21,0x00,0x7f,0xf8,0x01,0x00,0x01,0x00,0x1f,0xf0,0x01,0x00,0x01,0x00,0x7f,0xfe,0x02,0x40,0x04,0x20,0x18,0x18,0x60,0x06}}, // 実
{0x3C43,0x8EC1,0xBCC3,0xE89480,0x8500,{0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x08,0x00,0x7f,0xbc,0x21,0x24,0x11,0x28,0x12,0x38,0x7f,0xa4,0x00,0x22,0x3f,0x22,0x21,0x22,0x21,0x3c,0x3f,0x20,0x21,0x20}}, // 蔀
{0x3C44,0x8EC2,0xBCC4,0xE7AFA0,0x7BE0,{0x10,0x40,0x1f,0x7f,0x24,0x50,0x22,0x88,0x44,0x40,0x04,0x7f,0x0c,0xa4,0x0f,0x18,0x14,0x34,0x35,0xc3,0x54,0x10,0x15,0xff,0x14,0x38,0x14,0x54,0x11,0x93,0x10,0x10}}, // 篠
{0x3C45,0x8EC3,0xBCC5,0xE581B2,0x5072,{0x04,0x00,0x05,0xfe,0x05,0x22,0x09,0x22,0x09,0xfe,0x11,0x22,0x11,0x22,0x31,0x22,0x51,0xfe,0x10,0x20,0x10,0x90,0x12,0x92,0x12,0x81,0x12,0x85,0x14,0x84,0x10,0x7c}}, // 偲
{0x3C46,0x8EC4,0xBCC6,0xE69FB4,0x67F4,{0x04,0x40,0x14,0x44,0x17,0xc8,0x14,0x70,0x14,0x42,0x17,0xc2,0x1c,0x3e,0x60,0x80,0x00,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80}}, // 柴
{0x3C47,0x8EC5,0xBCC7,0xE88A9D,0x829D,{0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x10,0x04,0x90,0x00,0x80,0x1f,0xfc,0x00,0x08,0x00,0x10,0x00,0x20,0x08,0x40,0x09,0x80,0x0e,0x00,0x09,0x00,0x10,0xe0,0x20,0x1f}}, // 芝
{0x3C48,0x8EC6,0xBCC8,0xE5B1A1,0x5C61,{0x00,0x00,0x1f,0xfe,0x10,0x02,0x10,0x02,0x1f,0xfe,0x12,0x48,0x11,0x50,0x1f,0xff,0x13,0x58,0x1c,0x46,0x11,0x40,0x1f,0xff,0x22,0x10,0x27,0xe0,0x41,0x98,0x1e,0x04}}, // 屡
{0x3C49,0x8EC7,0xBCC9,0xE8958A,0x854A,{0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x90,0x04,0x50,0x12,0x40,0x12,0x04,0x12,0x12,0x21,0xf2,0x04,0x08,0x02,0x04,0x0a,0x14,0x28,0x91,0x28,0xb1,0x49,0x52,0x07,0x0e}}, // 蕊
{0x3C4A,0x8EC8,0xBCCA,0xE7B89E,0x7E1E,{0x08,0x10,0x08,0x10,0x0a,0xff,0x72,0x00,0x14,0x7c,0x08,0x44,0x0c,0x7c,0x12,0x00,0x7d,0xfe,0x09,0x82,0x2c,0xba,0x2a,0xaa,0x2a,0xba,0x2a,0xaa,0x48,0x86,0x08,0x82}}, // 縞
{0x3C4B,0x8EC9,0xBCCB,0xE8888E,0x820E,{0x00,0x80,0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x90,0x18,0x8c,0x6f,0xfb,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 舎
{0x3C4C,0x8ECA,0xBCCC,0xE58699,0x5199,{0x00,0x00,0x3f,0xfe,0x20,0x04,0x24,0x00,0x47,0xf0,0x04,0x00,0x04,0x00,0x07,0xe0,0x00,0x20,0x00,0x20,0x7f,0xfe,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x40,0x03,0x80}}, // 写
{0x3C4D,0x8ECB,0xBCCD,0xE5B084,0x5C04,{0x02,0x04,0x04,0x04,0x1f,0x04,0x11,0x04,0x11,0xff,0x1f,0x04,0x11,0x04,0x1f,0x64,0x11,0x94,0x1f,0x14,0x71,0x04,0x03,0x04,0x05,0x04,0x19,0x04,0x63,0x0c,0x01,0x04}}, // 射
{0x3C4E,0x8ECC,0xBCCE,0xE68DA8,0x6368,{0x10,0x20,0x10,0x20,0x10,0x50,0x7c,0x88,0x11,0x24,0x16,0x23,0x11,0xfc,0x10,0x20,0x1c,0x20,0x73,0xff,0x10,0x00,0x11,0xfc,0x11,0x04,0x11,0x04,0x31,0xfc,0x11,0x04}}, // 捨
{0x3C4F,0x8ECD,0xBCCF,0xE8B5A6,0x8D66,{0x04,0x20,0x04,0x20,0x3f,0xa0,0x04,0x3f,0x04,0x44,0x04,0x44,0x7f,0x84,0x0a,0x24,0x0a,0x28,0x2b,0x28,0x2a,0x98,0x2a,0x98,0x4a,0x94,0x12,0x24,0x12,0x42,0x26,0x81}}, // 赦
{0x3C50,0x8ECE,0xBCD0,0xE6969C,0x659C,{0x04,0x04,0x04,0x44,0x0a,0x24,0x09,0x24,0x11,0x04,0x3f,0x44,0x44,0x24,0x04,0x24,0x7f,0x84,0x04,0x07,0x16,0x3c,0x15,0xc4,0x25,0x04,0x44,0x84,0x04,0x04,0x0c,0x04}}, // 斜
{0x3C51,0x8ECF,0xBCD1,0xE785AE,0x716E,{0x00,0x82,0x00,0x82,0x1f,0xfc,0x00,0x88,0x00,0xb0,0x7f,0xff,0x01,0x00,0x07,0xf8,0x1c,0x08,0x67,0xf8,0x04,0x08,0x07,0xf8,0x10,0x08,0x12,0x44,0x21,0x22,0x41,0x22}}, // 煮
{0x3C52,0x8ED0,0xBCD2,0xE7A4BE,0x793E,{0x08,0x10,0x08,0x10,0x08,0x10,0x7e,0x10,0x02,0x10,0x04,0xfe,0x04,0x10,0x08,0x10,0x0c,0x10,0x1a,0x10,0x29,0x10,0x48,0x10,0x08,0x10,0x08,0x10,0x09,0xff,0x08,0x00}}, // 社
{0x3C53,0x8ED1,0xBCD3,0xE7B497,0x7D17,{0x08,0x10,0x08,0x10,0x0a,0x10,0x72,0x14,0x14,0x52,0x08,0x52,0x0a,0x51,0x12,0x95,0x7f,0x14,0x09,0x34,0x28,0x08,0x2a,0x08,0x29,0x10,0x29,0x20,0x48,0xc0,0x0b,0x00}}, // 紗
{0x3C54,0x8ED2,0xBCD4,0xE88085,0x8005,{0x00,0x80,0x00,0x84,0x1f,0xf8,0x00,0x90,0x00,0xa0,0x00,0xc0,0x7f,0xff,0x01,0x00,0x03,0xf8,0x06,0x08,0x1a,0x08,0x63,0xf8,0x02,0x08,0x02,0x08,0x03,0xf8,0x02,0x08}}, // 者
{0x3C55,0x8ED3,0xBCD5,0xE8AC9D,0x8B1D,{0x00,0x42,0x3c,0x82,0x01,0xe2,0x7f,0x22,0x01,0x3f,0x3d,0xe2,0x01,0x22,0x01,0xf2,0x3d,0x2a,0x01,0x2a,0x3f,0xe2,0x24,0x62,0x24,0xa2,0x25,0x22,0x3e,0x66,0x24,0x22}}, // 謝
{0x3C56,0x8ED4,0xBCD6,0xE8BB8A,0x8ECA,{0x00,0x80,0x00,0x80,0x3f,0xfe,0x00,0x80,0x0f,0xf8,0x08,0x88,0x08,0x88,0x0f,0xf8,0x08,0x88,0x08,0x88,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80}}, // 車
{0x3C57,0x8ED5,0xBCD7,0xE981AE,0x906E,{0x00,0x10,0x20,0x10,0x11,0xff,0x11,0x00,0x01,0x24,0x01,0xff,0x01,0x24,0x79,0x24,0x09,0x3c,0x09,0x24,0x0a,0x00,0x0c,0x54,0x14,0xaa,0x13,0x29,0x21,0x80,0x40,0x7f}}, // 遮
{0x3C58,0x8ED6,0xBCD8,0xE89B87,0x86C7,{0x04,0x10,0x04,0x10,0x04,0x10,0x3f,0x7f,0x25,0x42,0x25,0x40,0x25,0xa0,0x25,0x24,0x3f,0x24,0x04,0x28,0x06,0x30,0x05,0x20,0x05,0x20,0x0f,0xa1,0x70,0xa1,0x00,0x1f}}, // 蛇
{0x3C59,0x8ED7,0xBCD9,0xE982AA,0x90AA,{0x00,0x00,0x3f,0x7c,0x12,0x44,0x12,0x44,0x12,0x48,0x12,0x50,0x7f,0xc8,0x06,0x44,0x06,0x44,0x0a,0x42,0x0a,0x42,0x12,0x62,0x22,0x5c,0x42,0x40,0x06,0x40,0x02,0x40}}, // 邪
{0x3C5A,0x8ED8,0xBCDA,0xE5809F,0x501F,{0x04,0x88,0x04,0x88,0x04,0x88,0x0b,0xfe,0x08,0x88,0x10,0x88,0x17,0xff,0x30,0x00,0x51,0xfc,0x11,0x04,0x11,0x04,0x11,0xfc,0x11,0x04,0x11,0x04,0x11,0xfc,0x11,0x04}}, // 借
{0x3C5B,0x8ED9,0xBCDB,0xE58BBA,0x52FA,{0x04,0x00,0x04,0x00,0x04,0x00,0x07,0xfe,0x08,0x02,0x08,0x02,0x10,0x02,0x23,0x02,0x40,0x82,0x00,0x42,0x00,0x42,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x04,0x00,0x18}}, // 勺
{0x3C5C,0x8EDA,0xBCDC,0xE5B0BA,0x5C3A,{0x00,0x00,0x07,0xfc,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x07,0xfc,0x04,0x84,0x04,0x80,0x04,0x80,0x08,0x40,0x08,0x40,0x08,0x20,0x10,0x10,0x20,0x0c,0x40,0x03}}, // 尺
{0x3C5D,0x8EDB,0xBCDD,0xE69D93,0x6753,{0x08,0x40,0x08,0x40,0x08,0x40,0x7f,0x7e,0x08,0x82,0x08,0x82,0x19,0x02,0x1c,0x42,0x1a,0x22,0x2a,0x22,0x2a,0x02,0x48,0x02,0x08,0x02,0x08,0x02,0x08,0x04,0x08,0x18}}, // 杓
{0x3C5E,0x8EDC,0xBCDE,0xE781BC,0x707C,{0x08,0x40,0x08,0x40,0x08,0x40,0x0a,0x7e,0x2a,0x42,0x2a,0x82,0x2c,0x82,0x29,0x22,0x48,0x12,0x08,0x12,0x0c,0x02,0x0a,0x02,0x11,0x02,0x11,0x02,0x20,0x04,0x40,0x18}}, // 灼
{0x3C5F,0x8EDD,0xBCDF,0xE788B5,0x7235,{0x00,0x0c,0x7f,0xf0,0x11,0x04,0x08,0x88,0x3f,0xfe,0x22,0x22,0x3f,0xfe,0x00,0x04,0x3f,0x04,0x21,0x7f,0x3f,0x04,0x21,0x24,0x3f,0x14,0x22,0x04,0x3d,0x04,0x60,0x8c}}, // 爵
{0x3C60,0x8EDE,0xBCE0,0xE9858C,0x914C,{0x00,0x20,0x7f,0xa0,0x0c,0x20,0x0c,0x3e,0x3f,0x42,0x2d,0x42,0x2d,0x82,0x35,0x22,0x37,0x12,0x21,0x12,0x21,0x02,0x3f,0x02,0x21,0x02,0x21,0x02,0x3f,0x04,0x21,0x18}}, // 酌
{0x3C61,0x8EDF,0xBCE1,0xE98788,0x91C8,{0x01,0x00,0x06,0x7e,0x78,0x42,0x09,0x42,0x49,0x42,0x2a,0x42,0x28,0x7e,0x7f,0x52,0x08,0x50,0x18,0x50,0x1c,0x48,0x2a,0x48,0x28,0x44,0x48,0x84,0x08,0x82,0x09,0x01}}, // 釈
{0x3C62,0x8EE0,0xBCE2,0xE98CAB,0x932B,{0x08,0x00,0x08,0xfc,0x14,0x84,0x12,0x84,0x21,0xfc,0x7e,0x84,0x08,0x84,0x08,0xfc,0x7f,0x20,0x08,0x7e,0x4a,0xaa,0x2d,0x2a,0x28,0x4a,0x0e,0x92,0x18,0x22,0x60,0x4c}}, // 錫
{0x3C63,0x8EE1,0xBCE3,0xE88BA5,0x82E5,{0x08,0x10,0x08,0x10,0x7f,0xfe,0x08,0x10,0x09,0x10,0x01,0x00,0x01,0x00,0x7f,0xfe,0x02,0x00,0x04,0x00,0x07,0xf8,0x0c,0x08,0x14,0x08,0x24,0x08,0x47,0xf8,0x04,0x08}}, // 若
{0x3C64,0x8EE2,0xBCE4,0xE5AF82,0x5BC2,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x28,0x04,0x28,0x00,0x4f,0x00,0x08,0xfc,0x08,0x44,0x7f,0xc4,0x08,0x28,0x1a,0x28,0x1a,0x10,0x29,0x10,0x49,0x28,0x18,0x44,0x09,0x83}}, // 寂
{0x3C65,0x8EE3,0xBCE5,0xE5BCB1,0x5F31,{0x00,0x00,0x3f,0x7e,0x01,0x02,0x01,0x02,0x1f,0x3e,0x10,0x20,0x10,0x20,0x1f,0x3e,0x01,0x02,0x31,0x62,0x09,0x12,0x07,0x0e,0x19,0x32,0x61,0xc2,0x02,0x04,0x0c,0x18}}, // 弱
{0x3C66,0x8EE4,0xBCE6,0xE683B9,0x60F9,{0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x10,0x01,0x00,0x7f,0xfe,0x02,0x00,0x07,0xf8,0x1c,0x08,0x64,0x08,0x07,0xf8,0x12,0x44,0x12,0x22,0x22,0x29,0x42,0x09,0x01,0xf8}}, // 惹
{0x3C67,0x8EE5,0xBCE7,0xE4B8BB,0x4E3B,{0x01,0x00,0x00,0x80,0x00,0x80,0x3f,0xfe,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 主
{0x3C68,0x8EE6,0xBCE8,0xE58F96,0x53D6,{0x00,0x00,0x7f,0x80,0x11,0x7e,0x11,0x22,0x11,0x22,0x1f,0x22,0x11,0x22,0x11,0x14,0x1f,0x14,0x11,0x18,0x11,0x08,0x11,0x14,0x1f,0x24,0x61,0x42,0x01,0x82,0x01,0x01}}, // 取
{0x3C69,0x8EE7,0xBCE9,0xE5AE88,0x5B88,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x20,0x20,0x40,0x20,0x00,0x20,0x7f,0xfe,0x00,0x20,0x08,0x20,0x04,0x20,0x04,0x20,0x00,0x20,0x00,0x20,0x00,0xe0,0x00,0x20}}, // 守
{0x3C6A,0x8EE8,0xBCEA,0xE6898B,0x624B,{0x00,0x08,0x00,0x30,0x0f,0xc0,0x00,0x80,0x00,0x80,0x00,0x80,0x3f,0xfe,0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x03,0x80,0x00,0x80}}, // 手
{0x3C6B,0x8EE9,0xBCEB,0xE69CB1,0x6731,{0x00,0x80,0x04,0x80,0x04,0x80,0x0f,0xfc,0x08,0x80,0x10,0x80,0x20,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80,0x00,0x80,0x00,0x80}}, // 朱
{0x3C6C,0x8EEA,0xBCEC,0xE6AE8A,0x6B8A,{0x00,0x10,0x7f,0x50,0x10,0x50,0x10,0x7e,0x1e,0x90,0x12,0x90,0x13,0x10,0x33,0xff,0x2a,0x38,0x44,0x38,0x04,0x54,0x04,0x54,0x08,0x92,0x09,0x11,0x10,0x10,0x20,0x10}}, // 殊
{0x3C6D,0x8EEB,0xBCED,0xE78BA9,0x72E9,{0x04,0x20,0x44,0x20,0x29,0xff,0x11,0x02,0x12,0x00,0x28,0x08,0x48,0x08,0x0b,0xff,0x18,0x08,0x18,0x88,0x28,0x48,0x48,0x48,0x08,0x08,0x08,0x08,0x68,0x38,0x10,0x08}}, // 狩
{0x3C6E,0x8EEC,0xBCEE,0xE78FA0,0x73E0,{0x00,0x20,0x00,0xa0,0x7c,0xa0,0x10,0xfe,0x11,0x20,0x12,0x20,0x7c,0x20,0x13,0xff,0x10,0x70,0x10,0x70,0x10,0xa8,0x1d,0x24,0x72,0x22,0x04,0x21,0x00,0x20,0x00,0x20}}, // 珠
{0x3C6F,0x8EED,0xBCEF,0xE7A8AE,0x7A2E,{0x02,0x04,0x0c,0x18,0x79,0xe0,0x08,0x20,0x0b,0xff,0x08,0x20,0x7f,0xfc,0x09,0x24,0x1d,0xfc,0x1b,0x24,0x29,0xfc,0x28,0x20,0x49,0xfe,0x08,0x20,0x0f,0xff,0x08,0x00}}, // 種
{0x3C70,0x8EEE,0xBCF0,0xE885AB,0x816B,{0x00,0x04,0x3c,0x18,0x25,0xe0,0x24,0x20,0x27,0xff,0x3c,0x20,0x25,0xfc,0x25,0x24,0x25,0xfc,0x3d,0x24,0x25,0xfc,0x24,0x20,0x25,0xfc,0x24,0x20,0x2f,0xff,0x44,0x00}}, // 腫
{0x3C71,0x8EEF,0xBCF1,0xE8B6A3,0x8DA3,{0x08,0x00,0x09,0xfe,0x08,0xa0,0x3e,0xbe,0x08,0xe2,0x08,0xaa,0x7f,0xaa,0x08,0xec,0x28,0xa4,0x2e,0xa4,0x28,0xea,0x3b,0x32,0x28,0x21,0x24,0x20,0x23,0x00,0x40,0xff}}, // 趣
{0x3C72,0x8EF0,0xBCF2,0xE98592,0x9152,{0x10,0x00,0x0f,0xff,0x08,0x50,0x00,0x50,0x43,0xfe,0x22,0x52,0x22,0x52,0x02,0x52,0x0a,0x92,0x0a,0x8e,0x13,0x02,0x13,0xfe,0x22,0x02,0x22,0x02,0x43,0xfe,0x42,0x02}}, // 酒
{0x3C73,0x8EF1,0xBCF3,0xE9A696,0x9996,{0x10,0x10,0x08,0x10,0x04,0x20,0x7f,0xfe,0x01,0x00,0x02,0x00,0x1f,0xf8,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x08,0x1f,0xf8,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x08}}, // 首
{0x3C74,0x8EF2,0xBCF4,0xE58492,0x5112,{0x04,0x00,0x07,0xfe,0x04,0x20,0x0b,0xff,0x0a,0x21,0x13,0xae,0x14,0x20,0x31,0xae,0x50,0x00,0x17,0xfe,0x10,0x20,0x13,0xfe,0x12,0x52,0x12,0x52,0x12,0x52,0x12,0x06}}, // 儒
{0x3C75,0x8EF3,0xBCF5,0xE58F97,0x53D7,{0x00,0x08,0x00,0x70,0x3f,0x88,0x12,0x08,0x09,0x10,0x09,0x20,0x3f,0xff,0x20,0x02,0x2f,0xf0,0x44,0x10,0x02,0x20,0x01,0x40,0x00,0x80,0x03,0x60,0x0c,0x18,0x70,0x06}}, // 受
{0x3C76,0x8EF4,0xBCF6,0xE591AA,0x546A,{0x00,0x00,0x01,0xfc,0x7d,0x04,0x45,0x04,0x45,0x04,0x45,0x04,0x45,0x04,0x45,0xfc,0x45,0x54,0x44,0x50,0x7c,0x50,0x44,0x90,0x40,0x90,0x01,0x11,0x02,0x11,0x04,0x0f}}, // 呪
{0x3C77,0x8EF5,0xBCF7,0xE5AFBF,0x5BFF,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x01,0x00,0x1f,0xf8,0x01,0x00,0x7f,0xfe,0x02,0x10,0x02,0x10,0x7f,0xff,0x04,0x10,0x05,0x10,0x08,0x90,0x10,0x90,0x20,0x30,0x00,0x10}}, // 寿
{0x3C78,0x8EF6,0xBCF8,0xE68E88,0x6388,{0x10,0x04,0x10,0x18,0x13,0xe4,0x11,0x24,0x7c,0x88,0x13,0xff,0x12,0x02,0x14,0x00,0x13,0xf8,0x1c,0x88,0x70,0x48,0x10,0x50,0x10,0x20,0x10,0x50,0x11,0x8c,0x36,0x03}}, // 授
{0x3C79,0x8EF7,0xBCF9,0xE6A8B9,0x6A39,{0x10,0x84,0x10,0x84,0x13,0xe4,0x7c,0x84,0x17,0xff,0x10,0x04,0x3b,0xc4,0x36,0x64,0x36,0x54,0x53,0xd4,0x50,0x44,0x12,0x44,0x11,0xb4,0x11,0xc4,0x17,0x0c,0x10,0x04}}, // 樹
{0x3C7A,0x8EF8,0xBCFA,0xE7B6AC,0x7DAC,{0x08,0x04,0x08,0x18,0x0b,0xe2,0x72,0x92,0x14,0x54,0x08,0xff,0x0c,0x82,0x13,0x00,0x7d,0xfc,0x08,0x44,0x2c,0x44,0x2a,0x28,0x2a,0x10,0x2a,0x30,0x48,0x4c,0x09,0x83}}, // 綬
{0x3C7B,0x8EF9,0xBCFB,0xE99C80,0x9700,{0x00,0x00,0x3f,0xfc,0x01,0x00,0x3f,0xfe,0x21,0x02,0x3d,0x74,0x41,0x00,0x1d,0x78,0x00,0x00,0x7f,0xfe,0x01,0x00,0x3f,0xfc,0x22,0x44,0x22,0x44,0x22,0x44,0x20,0x0c}}, // 需
{0x3C7C,0x8EFA,0xBCFC,0xE59B9A,0x56DA,{0x00,0x00,0x3f,0xfe,0x20,0x02,0x20,0x82,0x20,0x82,0x20,0x82,0x20,0x82,0x21,0x42,0x21,0x42,0x22,0x22,0x24,0x12,0x28,0x0a,0x30,0x06,0x20,0x02,0x3f,0xfe,0x20,0x02}}, // 囚
{0x3C7D,0x8EFB,0xBCFD,0xE58F8E,0x53CE,{0x04,0x00,0x04,0x00,0x27,0xfc,0x24,0x84,0x24,0x84,0x24,0x84,0x24,0x84,0x24,0x48,0x24,0x48,0x24,0x30,0x26,0x30,0x3c,0x28,0xc4,0x48,0x04,0x84,0x05,0x02,0x04,0x01}}, // 収
{0x3C7E,0x8EFC,0xBCFE,0xE591A8,0x5468,{0x00,0x00,0x1f,0xfe,0x10,0x42,0x10,0x42,0x17,0xfa,0x10,0x42,0x10,0x42,0x1f,0xfe,0x10,0x02,0x13,0xf2,0x12,0x12,0x12,0x12,0x13,0xf2,0x22,0x12,0x20,0x06,0x40,0x02}}, // 周
{0x3D21,0x8F40,0xBDA1,0xE5AE97,0x5B97,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x20,0x00,0x4f,0xf0,0x00,0x00,0x00,0x00,0x7f,0xfe,0x01,0x00,0x11,0x10,0x11,0x08,0x21,0x04,0x41,0x04,0x07,0x00,0x01,0x00}}, // 宗
{0x3D22,0x8F41,0xBDA2,0xE5B0B1,0x5C31,{0x04,0x14,0x04,0x12,0x04,0x12,0x7f,0x90,0x00,0x7f,0x3f,0x10,0x21,0x10,0x21,0x18,0x3f,0x18,0x04,0x28,0x15,0x28,0x14,0xa8,0x14,0xa8,0x24,0x49,0x4c,0x49,0x04,0x87}}, // 就
{0x3D23,0x8F42,0xBDA3,0xE5B79E,0x5DDE,{0x08,0x04,0x08,0x84,0x08,0x84,0x08,0x84,0x08,0x84,0x2c,0xa4,0x2a,0x94,0x2a,0x94,0x2a,0x94,0x48,0x84,0x08,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x20,0x04,0x40,0x04}}, // 州
{0x3D24,0x8F43,0xBDA4,0xE4BFAE,0x4FEE,{0x04,0x40,0x04,0x40,0x04,0x7f,0x08,0x88,0x09,0x88,0x16,0x50,0x14,0x30,0x34,0xcc,0x57,0x13,0x14,0x64,0x15,0x98,0x14,0x62,0x15,0x84,0x14,0x18,0x10,0x60,0x13,0x80}}, // 修
{0x3D25,0x8F44,0xBDA5,0xE68481,0x6101,{0x01,0x10,0x06,0x10,0x3c,0x12,0x04,0x52,0x7f,0x54,0x04,0xa8,0x0e,0x28,0x15,0x44,0x24,0x82,0x45,0x01,0x14,0x80,0x14,0x48,0x14,0x44,0x24,0x12,0x42,0x12,0x01,0xf0}}, // 愁
{0x3D26,0x8F45,0xBDA6,0xE68BBE,0x62FE,{0x10,0x20,0x10,0x20,0x10,0x50,0x10,0x50,0x7c,0x88,0x11,0x04,0x12,0xfa,0x14,0x01,0x1c,0x00,0x71,0xfc,0x11,0x04,0x11,0x04,0x11,0x04,0x11,0x04,0x31,0xfc,0x11,0x04}}, // 拾
{0x3D27,0x8F46,0xBDA7,0xE6B4B2,0x6D32,{0x11,0x02,0x09,0x22,0x09,0x22,0x01,0x22,0x41,0x22,0x25,0xb2,0x25,0x6a,0x05,0x6a,0x09,0x22,0x01,0x22,0x11,0x22,0x11,0x22,0x22,0x22,0x22,0x22,0x44,0x02,0x48,0x02}}, // 洲
{0x3D28,0x8F47,0xBDA8,0xE7A780,0x79C0,{0x00,0x08,0x00,0x70,0x1f,0x80,0x00,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x0c,0x98,0x70,0x87,0x1f,0xf0,0x01,0x10,0x01,0x1c,0x01,0x04,0x02,0x04,0x0c,0x04,0x30,0x18}}, // 秀
{0x3D29,0x8F48,0xBDA9,0xE7A78B,0x79CB,{0x02,0x20,0x0c,0x20,0x78,0x24,0x08,0xa4,0x08,0xa4,0x08,0xa8,0x7e,0xa8,0x08,0xa0,0x09,0x20,0x1c,0x50,0x1a,0x50,0x2a,0x88,0x28,0x88,0x49,0x04,0x0a,0x02,0x0c,0x01}}, // 秋
{0x3D2A,0x8F49,0xBDAA,0xE7B582,0x7D42,{0x08,0x20,0x08,0x20,0x12,0x3c,0x62,0x44,0x14,0x48,0x08,0xa8,0x0d,0x18,0x12,0x24,0x7d,0x42,0x09,0x81,0x28,0x38,0x2a,0x04,0x29,0x00,0x29,0x70,0x48,0x0c,0x08,0x02}}, // 終
{0x3D2B,0x8F4A,0xBDAB,0xE7B98D,0x7E4D,{0x08,0x10,0x08,0xfc,0x0a,0x14,0x73,0xff,0x14,0x14,0x08,0xfc,0x0c,0x12,0x14,0x92,0x7e,0xd6,0x0a,0xba,0x2c,0xfe,0x2a,0x92,0x2a,0xba,0x29,0x56,0x49,0x92,0x0a,0x12}}, // 繍
{0x3D2C,0x8F4B,0xBDAC,0xE7BF92,0x7FD2,{0x00,0x00,0x7f,0xfe,0x21,0x42,0x11,0x22,0x13,0x26,0x05,0x1a,0x19,0x62,0x60,0x86,0x01,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 習
{0x3D2D,0x8F4C,0xBDAD,0xE887AD,0x81ED,{0x00,0x80,0x01,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x01,0x40,0x02,0x20,0x0c,0x18,0x70,0x07}}, // 臭
{0x3D2E,0x8F4D,0xBDAE,0xE8889F,0x821F,{0x00,0x40,0x00,0x80,0x07,0xf8,0x04,0x08,0x05,0x08,0x04,0x88,0x04,0x88,0x04,0x08,0x7f,0xff,0x04,0x08,0x05,0x08,0x04,0x88,0x08,0x88,0x08,0x88,0x10,0x38,0x20,0x08}}, // 舟
{0x3D2F,0x8F4E,0xBDAF,0xE89290,0x8490,{0x04,0x20,0x04,0x20,0x7f,0xfe,0x04,0xa0,0x01,0x00,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x08,0x88,0x08,0x88,0x0f,0xf8,0x01,0x48,0x02,0x54,0x04,0x5e,0x18,0x42,0x60,0x3e}}, // 蒐
{0x3D30,0x8F4F,0xBDB0,0xE8A186,0x8846,{0x00,0x80,0x01,0x00,0x1f,0xfc,0x12,0x24,0x12,0x24,0x7f,0xff,0x00,0x20,0x04,0x44,0x09,0x84,0x36,0xa8,0x00,0x90,0x04,0x88,0x08,0x84,0x10,0x83,0x60,0x80,0x00,0x80}}, // 衆
{0x3D31,0x8F50,0xBDB1,0xE8A5B2,0x8972,{0x04,0x40,0x3f,0x7e,0x12,0x40,0x7f,0xfc,0x11,0x04,0x1f,0x7c,0x11,0x40,0x1f,0x7c,0x11,0x42,0x13,0x3e,0x11,0x00,0x7f,0xff,0x02,0x84,0x7c,0x48,0x07,0x30,0x38,0x0e}}, // 襲
{0x3D32,0x8F51,0xBDB2,0xE8AE90,0x8B90,{0x12,0x24,0x3f,0xbf,0x64,0xc8,0x3f,0x7e,0x24,0x48,0x3f,0x7e,0x24,0x48,0x7f,0xff,0x07,0xf0,0x00,0x00,0x07,0xf0,0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 讐
{0x3D33,0x8F52,0xBDB3,0xE8B9B4,0x8E74,{0x00,0x88,0x3c,0x8c,0x24,0x8a,0x27,0xea,0x24,0x3f,0x25,0xc8,0x3d,0x48,0x09,0x4c,0x09,0x4c,0x2f,0xcc,0x28,0x94,0x29,0xd4,0x29,0xb4,0x2a,0x95,0x3c,0xa5,0x61,0xc3}}, // 蹴
{0x3D34,0x8F53,0xBDB4,0xE8BCAF,0x8F2F,{0x08,0x00,0x08,0x7c,0x7f,0x44,0x08,0x7c,0x3e,0x00,0x2b,0xff,0x2a,0x44,0x3e,0x44,0x2a,0x7c,0x2a,0x44,0x3e,0x7c,0x08,0x44,0x7f,0x47,0x08,0x7c,0x09,0xc4,0x08,0x04}}, // 輯
{0x3D35,0x8F54,0xBDB5,0xE980B1,0x9031,{0x00,0x00,0x21,0xfe,0x11,0x22,0x11,0x22,0x01,0xfa,0x01,0x22,0x01,0xfe,0x79,0x02,0x09,0x7a,0x09,0x4a,0x09,0x4a,0x0a,0x7a,0x14,0x4a,0x12,0x06,0x21,0x80,0x40,0x7f}}, // 週
{0x3D36,0x8F55,0xBDB6,0xE9858B,0x914B,{0x08,0x10,0x04,0x10,0x04,0x20,0x7f,0xfe,0x02,0x40,0x02,0x40,0x3f,0xfc,0x22,0x44,0x24,0x4c,0x28,0x3c,0x30,0x04,0x3f,0xfc,0x20,0x04,0x20,0x04,0x3f,0xfc,0x20,0x04}}, // 酋
{0x3D37,0x8F56,0xBDB7,0xE985AC,0x916C,{0x00,0x02,0x7f,0xd2,0x0c,0x52,0x0c,0x52,0x3f,0x52,0x2d,0x5a,0x2d,0xd6,0x35,0xf2,0x37,0x52,0x21,0x52,0x21,0x52,0x3f,0x52,0x21,0x52,0x21,0x42,0x3f,0x82,0x21,0x02}}, // 酬
{0x3D38,0x8F57,0xBDB8,0xE99B86,0x96C6,{0x08,0x20,0x08,0x40,0x0f,0xfe,0x18,0x40,0x1f,0xfc,0x28,0x40,0x4f,0xfc,0x08,0x40,0x0f,0xfe,0x00,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x0c,0x98,0x70,0x87,0x00,0x80}}, // 集
{0x3D39,0x8F58,0xBDB9,0xE9869C,0x919C,{0x00,0x08,0x7f,0x90,0x0c,0x7e,0x0c,0x52,0x3f,0x52,0x2d,0x7e,0x2d,0x52,0x35,0x52,0x37,0x7e,0x31,0x14,0x21,0x34,0x3f,0x3a,0x21,0x5e,0x21,0x51,0x3f,0x91,0x21,0x0f}}, // 醜
{0x3D3A,0x8F59,0xBDBA,0xE4BB80,0x4EC0,{0x04,0x10,0x04,0x10,0x04,0x10,0x08,0x10,0x08,0x10,0x18,0x10,0x1b,0xff,0x28,0x10,0x48,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10}}, // 什
{0x3D3B,0x8F5A,0xBDBB,0xE4BD8F,0x4F4F,{0x04,0x40,0x04,0x20,0x04,0x20,0x0b,0xfe,0x08,0x20,0x10,0x20,0x10,0x20,0x30,0x20,0x53,0xfe,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x17,0xff,0x10,0x00}}, // 住
{0x3D3C,0x8F5B,0xBDBC,0xE58585,0x5145,{0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0x00,0x01,0x20,0x02,0x18,0x04,0x74,0x1f,0xa2,0x01,0x20,0x01,0x20,0x01,0x20,0x02,0x20,0x02,0x22,0x04,0x22,0x08,0x22,0x30,0x1e}}, // 充
{0x3D3D,0x8F5C,0xBDBD,0xE58D81,0x5341,{0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x82,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 十
{0x3D3E,0x8F5D,0xBDBE,0xE5BE93,0x5F93,{0x09,0x04,0x08,0x84,0x10,0x88,0x10,0x10,0x27,0xfe,0x48,0x20,0x08,0x20,0x11,0x20,0x11,0x3e,0x31,0x20,0x51,0x20,0x11,0x20,0x12,0xa0,0x12,0x60,0x14,0x30,0x18,0x0f}}, // 従
{0x3D3F,0x8F5E,0xBDBF,0xE6888E,0x620E,{0x00,0x48,0x00,0x44,0x00,0x44,0x7f,0xff,0x00,0x40,0x04,0x44,0x04,0x44,0x04,0x24,0x7f,0xa8,0x04,0x28,0x04,0x10,0x08,0x10,0x08,0x2a,0x10,0x4a,0x21,0x86,0x06,0x02}}, // 戎
{0x3D40,0x8F5F,0xBDC0,0xE69F94,0x67D4,{0x00,0x00,0x1f,0xf8,0x06,0x20,0x01,0x40,0x3f,0xfe,0x01,0x44,0x02,0x48,0x0c,0x40,0x30,0xc0,0x00,0x80,0x7f,0xff,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80}}, // 柔
{0x3D41,0x8F60,0xBDC1,0xE6B181,0x6C41,{0x10,0x20,0x08,0x20,0x08,0x20,0x00,0x20,0x00,0x20,0x40,0x20,0x27,0xff,0x20,0x20,0x08,0x20,0x08,0x20,0x10,0x20,0x10,0x20,0x20,0x20,0x20,0x20,0x40,0x20,0x40,0x20}}, // 汁
{0x3D42,0x8F61,0xBDC2,0xE6B88B,0x6E0B,{0x20,0x20,0x10,0x20,0x11,0x20,0x01,0x3e,0x41,0x20,0x21,0x20,0x21,0x20,0x07,0xff,0x08,0x00,0x0a,0x04,0x11,0x08,0x10,0x90,0x20,0x00,0x20,0x98,0x43,0x06,0x4c,0x01}}, // 渋
{0x3D43,0x8F62,0xBDC3,0xE78DA3,0x7363,{0x11,0x10,0x49,0x14,0x2a,0x12,0x3f,0x12,0x29,0x10,0x3f,0xff,0x29,0x10,0x3f,0x10,0x00,0x10,0x7f,0xa8,0x00,0x28,0x3f,0x28,0x21,0x44,0x21,0x44,0x3f,0x82,0x21,0x01}}, // 獣
{0x3D44,0x8F63,0xBDC4,0xE7B8A6,0x7E26,{0x08,0x22,0x08,0x52,0x0a,0x54,0x72,0x94,0x14,0xff,0x09,0x08,0x0c,0x48,0x14,0x68,0x7a,0xa8,0x08,0xae,0x2d,0x28,0x2b,0x28,0x29,0x58,0x29,0x48,0x49,0x84,0x09,0x03}}, // 縦
{0x3D45,0x8F64,0xBDC5,0xE9878D,0x91CD,{0x00,0x18,0x1f,0xe0,0x00,0x80,0x7f,0xff,0x00,0x80,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x08,0x88,0x08,0x88,0x0f,0xf8,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 重
{0x3D46,0x8F65,0xBDC6,0xE98A83,0x9283,{0x08,0x20,0x08,0x20,0x14,0x20,0x13,0xff,0x21,0x20,0x7e,0x50,0x08,0x8c,0x09,0xfa,0x7f,0x50,0x08,0x50,0x4a,0x50,0x2c,0x50,0x28,0x92,0x0e,0x92,0x19,0x12,0x62,0x0e}}, // 銃
{0x3D47,0x8F66,0xBDC7,0xE58F94,0x53D4,{0x04,0x00,0x04,0x00,0x04,0xfc,0x07,0x44,0x04,0x44,0x04,0x24,0x7f,0xa4,0x04,0x28,0x04,0x28,0x15,0x18,0x15,0x10,0x24,0x98,0x24,0xa8,0x44,0x44,0x04,0x82,0x0d,0x01}}, // 叔
{0x3D48,0x8F67,0xBDC8,0xE5A499,0x5919,{0x00,0x00,0x1f,0xf8,0x10,0x08,0x10,0x08,0x1f,0xf8,0x11,0x08,0x11,0xe8,0x11,0x28,0x12,0x28,0x13,0x28,0x14,0xc8,0x18,0x48,0x10,0x85,0x21,0x05,0x22,0x03,0x44,0x01}}, // 夙
{0x3D49,0x8F68,0xBDC9,0xE5AEBF,0x5BBF,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x44,0x00,0x07,0xfc,0x08,0x40,0x08,0x80,0x13,0xf8,0x32,0x08,0x52,0x08,0x13,0xf8,0x12,0x08,0x12,0x08,0x13,0xf8,0x12,0x08}}, // 宿
{0x3D4A,0x8F69,0xBDCA,0xE6B791,0x6DD1,{0x11,0x00,0x09,0x3e,0x09,0x02,0x01,0xe2,0x41,0x12,0x21,0x12,0x21,0x12,0x0f,0xf2,0x01,0x0a,0x11,0x0c,0x15,0x44,0x25,0x2c,0x25,0x2a,0x29,0x12,0x51,0x21,0x43,0x41}}, // 淑
{0x3D4B,0x8F6A,0xBDCB,0xE7A59D,0x795D,{0x08,0x00,0x08,0xfe,0x08,0x82,0x7e,0x82,0x02,0x82,0x04,0x82,0x04,0xfe,0x08,0xaa,0x1c,0x28,0x2a,0x28,0x49,0x28,0x08,0x48,0x08,0x48,0x08,0x89,0x08,0x89,0x09,0x07}}, // 祝
{0x3D4C,0x8F6B,0xBDCC,0xE7B8AE,0x7E2E,{0x08,0x10,0x08,0x10,0x0a,0xff,0x72,0x82,0x15,0x40,0x08,0x7e,0x0a,0x48,0x12,0x90,0x7f,0xbe,0x09,0xa2,0x28,0xa2,0x2c,0xbe,0x2a,0xa2,0x4a,0xa2,0x08,0xbe,0x08,0xa2}}, // 縮
{0x3D4D,0x8F6C,0xBDCD,0xE7B29B,0x7C9B,{0x00,0x80,0x1f,0xfc,0x00,0x84,0x7f,0xff,0x00,0x84,0x1f,0xfc,0x00,0x80,0x14,0x94,0x12,0xa4,0x1f,0xfc,0x10,0x84,0x11,0xc4,0x12,0xa4,0x2c,0x9c,0x20,0x84,0x40,0x84}}, // 粛
{0x3D4E,0x8F6D,0xBDCE,0xE5A1BE,0x587E,{0x04,0x10,0x7f,0x90,0x1e,0x10,0x12,0xfc,0x1e,0x14,0x00,0x54,0x3e,0x24,0x05,0x34,0x1e,0x55,0x64,0x8b,0x0c,0x81,0x1f,0xf8,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 塾
{0x3D4F,0x8F6E,0xBDCF,0xE7869F,0x719F,{0x04,0x10,0x7f,0x90,0x1e,0x10,0x12,0xfc,0x1e,0x14,0x00,0x94,0x3e,0x54,0x05,0x24,0x0e,0x25,0x74,0x55,0x04,0x93,0x0d,0x01,0x10,0x04,0x14,0x42,0x22,0x21,0x42,0x21}}, // 熟
{0x3D50,0x8F6F,0xBDD0,0xE587BA,0x51FA,{0x00,0x80,0x00,0x80,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x84,0x00,0x80,0x20,0x82,0x20,0x82,0x20,0x82,0x20,0x82,0x20,0x82,0x3f,0xfe,0x20,0x02}}, // 出
{0x3D51,0x8F70,0xBDD1,0xE8A193,0x8853,{0x08,0x80,0x08,0xde,0x10,0xa0,0x14,0xa0,0x24,0x80,0x47,0xff,0x08,0x84,0x08,0xc4,0x12,0xa4,0x32,0xa4,0x52,0x94,0x12,0x94,0x12,0x94,0x14,0x84,0x10,0x8c,0x10,0x84}}, // 術
{0x3D52,0x8F71,0xBDD2,0xE8BFB0,0x8FF0,{0x00,0x28,0x20,0x24,0x10,0x24,0x10,0x20,0x07,0xff,0x00,0x20,0x00,0x20,0x79,0x28,0x09,0x24,0x09,0x24,0x09,0x22,0x0a,0x22,0x0c,0x20,0x14,0x20,0x23,0x00,0x40,0xff}}, // 述
{0x3D53,0x8F72,0xBDD3,0xE4BF8A,0x4FCA,{0x04,0x40,0x04,0x50,0x04,0x8c,0x0b,0xfa,0x08,0x90,0x10,0x91,0x11,0x0f,0x32,0x80,0x54,0xf8,0x10,0x88,0x11,0x88,0x12,0x50,0x14,0x20,0x10,0x50,0x11,0x8c,0x16,0x03}}, // 俊
{0x3D54,0x8F73,0xBDD4,0xE5B3BB,0x5CFB,{0x00,0x40,0x10,0x50,0x10,0x8c,0x13,0xfa,0x54,0x50,0x54,0x51,0x54,0x9f,0x55,0x40,0x56,0x78,0x54,0x48,0x54,0x88,0x57,0x50,0x7c,0x20,0x44,0x50,0x41,0x8c,0x06,0x03}}, // 峻
{0x3D55,0x8F74,0xBDD5,0xE698A5,0x6625,{0x00,0x80,0x00,0x80,0x3f,0xfe,0x00,0x80,0x1f,0xfc,0x01,0x40,0x7f,0xff,0x02,0x20,0x04,0x10,0x1f,0xfc,0x64,0x13,0x07,0xf0,0x04,0x10,0x04,0x10,0x07,0xf0,0x04,0x10}}, // 春
{0x3D56,0x8F75,0xBDD6,0xE79EAC,0x77AC,{0x00,0x04,0x78,0x18,0x4b,0xe4,0x49,0x44,0x48,0xa8,0x7b,0xff,0x4a,0x8a,0x4c,0x88,0x79,0xc8,0x49,0x7e,0x49,0x68,0x4a,0xe8,0x7c,0xa8,0x48,0xff,0x01,0x08,0x02,0x08}}, // 瞬
{0x3D57,0x8F76,0xBDD7,0xE7ABA3,0x7AE3,{0x08,0x20,0x08,0x28,0x08,0x44,0x7f,0xfa,0x00,0x48,0x24,0x49,0x24,0xa7,0x15,0x20,0x14,0x7c,0x14,0x44,0x08,0x88,0x0f,0x50,0x18,0x20,0x60,0x50,0x01,0x8c,0x06,0x03}}, // 竣
{0x3D58,0x8F77,0xBDD8,0xE8889C,0x821C,{0x00,0x10,0x00,0xe4,0x7f,0x04,0x11,0x08,0x08,0x90,0x3f,0xfe,0x24,0x04,0x44,0x08,0x0f,0xfe,0x09,0x48,0x11,0x48,0x6a,0x48,0x07,0xff,0x04,0x08,0x18,0x08,0x60,0x08}}, // 舜
{0x3D59,0x8F78,0xBDD9,0xE9A7BF,0x99FF,{0x00,0x10,0x3f,0x98,0x24,0x26,0x24,0xfd,0x3f,0x28,0x24,0x29,0x3f,0x47,0x24,0x90,0x24,0x1c,0x3f,0xa4,0x04,0xe4,0x12,0xa8,0x2a,0x90,0x28,0xa8,0x41,0x44,0x06,0x83}}, // 駿
{0x3D5A,0x8F79,0xBDDA,0xE58786,0x51C6,{0x00,0x88,0x20,0x88,0x11,0x10,0x11,0xfe,0x03,0x10,0x03,0x10,0x05,0x10,0x01,0xfe,0x09,0x10,0x11,0x10,0x11,0xfe,0x21,0x10,0x21,0x10,0x41,0x10,0x41,0xff,0x01,0x00}}, // 准
{0x3D5B,0x8F7A,0xBDDB,0xE5BEAA,0x5FAA,{0x08,0x04,0x08,0x18,0x11,0xf0,0x11,0x10,0x25,0xff,0x45,0x10,0x09,0x7c,0x09,0x44,0x11,0x44,0x31,0x7c,0x52,0x44,0x12,0x7c,0x12,0x44,0x14,0x44,0x18,0x7c,0x10,0x44}}, // 循
{0x3D5C,0x8F7B,0xBDDC,0xE697AC,0x65EC,{0x04,0x00,0x04,0x00,0x07,0xfe,0x08,0x02,0x08,0x02,0x17,0xe2,0x24,0x22,0x44,0x22,0x07,0xe2,0x04,0x22,0x04,0x22,0x07,0xe2,0x04,0x22,0x04,0x02,0x00,0x04,0x00,0x18}}, // 旬
{0x3D5D,0x8F7C,0xBDDD,0xE6A5AF,0x696F,{0x08,0x04,0x08,0x18,0x09,0xf0,0x7f,0x10,0x09,0xff,0x09,0x10,0x1d,0x7e,0x1b,0x42,0x1b,0x42,0x29,0x7e,0x29,0x42,0x49,0x7e,0x0a,0x42,0x0a,0x42,0x0c,0x7e,0x08,0x42}}, // 楯
{0x3D5E,0x8F7D,0xBDDE,0xE6AE89,0x6B89,{0x00,0x40,0x7f,0x40,0x10,0x7e,0x10,0x42,0x10,0x82,0x1e,0xf2,0x13,0x92,0x22,0x92,0x32,0xf2,0x4c,0x92,0x04,0x92,0x08,0xf2,0x08,0x92,0x10,0x02,0x20,0x04,0x40,0x18}}, // 殉
{0x3D5F,0x8F7E,0xBDDF,0xE6B7B3,0x6DF3,{0x10,0x20,0x08,0x20,0x0f,0xfe,0x00,0x00,0x41,0xf8,0x21,0x08,0x21,0xf8,0x00,0x00,0x0b,0xfc,0x08,0x10,0x10,0x20,0x17,0xff,0x20,0x20,0x20,0x20,0x40,0x20,0x40,0x60}}, // 淳
{0x3D60,0x8F80,0xBDE0,0xE6BA96,0x6E96,{0x10,0x88,0x08,0x90,0x49,0xfe,0x23,0x20,0x23,0xfc,0x05,0x20,0x05,0xfc,0x09,0x20,0x11,0x20,0x21,0xfe,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80}}, // 準
{0x3D61,0x8F81,0xBDE1,0xE6BDA4,0x6F64,{0x10,0x00,0x0b,0xde,0x0a,0x52,0x03,0xde,0x42,0x52,0x23,0xde,0x22,0x02,0x06,0xfa,0x0a,0x22,0x0a,0x22,0x12,0xfa,0x12,0x22,0x22,0x22,0x22,0xfa,0x42,0x06,0x42,0x02}}, // 潤
{0x3D62,0x8F82,0xBDE2,0xE79BBE,0x76FE,{0x00,0x04,0x00,0x38,0x1f,0xc0,0x10,0x40,0x1f,0xff,0x10,0x40,0x13,0xf8,0x12,0x08,0x12,0x08,0x13,0xf8,0x12,0x08,0x13,0xf8,0x22,0x08,0x22,0x08,0x43,0xf8,0x02,0x08}}, // 盾
{0x3D63,0x8F83,0xBDE3,0xE7B494,0x7D14,{0x08,0x10,0x08,0x13,0x12,0x1c,0x63,0xf0,0x14,0x10,0x08,0x52,0x0c,0x52,0x12,0x52,0x7d,0x52,0x09,0x52,0x28,0x7e,0x2a,0x52,0x29,0x10,0x29,0x11,0x48,0x11,0x08,0x0f}}, // 純
{0x3D64,0x8F84,0xBDE4,0xE5B7A1,0x5DE1,{0x00,0x00,0x20,0x92,0x10,0x92,0x11,0x24,0x01,0x24,0x02,0x48,0x04,0x90,0x7c,0x90,0x0a,0x48,0x09,0x24,0x09,0x24,0x08,0x92,0x14,0x92,0x12,0x00,0x21,0x80,0x40,0x7f}}, // 巡
{0x3D65,0x8F85,0xBDE5,0xE981B5,0x9075,{0x01,0x04,0x20,0x88,0x17,0xff,0x10,0x90,0x03,0xfc,0x02,0x94,0x03,0x1c,0x7b,0xfc,0x0a,0x04,0x0b,0xfc,0x08,0x08,0x0f,0xff,0x14,0x88,0x12,0x48,0x21,0x98,0x40,0xff}}, // 遵
{0x3D66,0x8F86,0xBDE6,0xE98687,0x9187,{0x00,0x10,0x7f,0x10,0x0c,0xff,0x0c,0x00,0x3f,0x7c,0x2d,0x44,0x2d,0x7c,0x35,0x00,0x37,0x7c,0x21,0x08,0x21,0x10,0x3f,0xff,0x21,0x10,0x21,0x10,0x3f,0x30,0x21,0x10}}, // 醇
{0x3D67,0x8F87,0xBDE7,0xE9A086,0x9806,{0x00,0x00,0x2b,0xff,0x2a,0x10,0x2a,0x20,0x2a,0x7e,0x2a,0x42,0x2a,0x42,0x2a,0x7e,0x2a,0x42,0x2a,0x7e,0x2a,0x42,0x2a,0x42,0x2a,0x7e,0x22,0x2c,0x22,0xc2,0x43,0x01}}, // 順
{0x3D68,0x8F88,0xBDE8,0xE587A6,0x51E6,{0x08,0x00,0x08,0x3c,0x08,0x24,0x0f,0x24,0x09,0x24,0x11,0x24,0x11,0x24,0x2a,0x24,0x2a,0x24,0x44,0x44,0x04,0x45,0x0a,0x85,0x09,0x03,0x10,0x80,0x20,0x60,0x40,0x1f}}, // 処
{0x3D69,0x8F89,0xBDE9,0xE5889D,0x521D,{0x08,0x00,0x08,0x00,0x09,0xfe,0x7e,0x22,0x02,0x22,0x04,0x22,0x05,0x22,0x09,0x22,0x0e,0x22,0x1a,0x22,0x29,0x22,0x49,0x42,0x08,0x42,0x08,0x82,0x09,0x02,0x0a,0x0c}}, // 初
{0x3D6A,0x8F8A,0xBDEA,0xE68980,0x6240,{0x00,0x02,0x3f,0x8c,0x00,0x70,0x00,0x40,0x1f,0x40,0x11,0x7f,0x11,0x44,0x11,0x44,0x1f,0x44,0x10,0x44,0x10,0x44,0x10,0x84,0x10,0x84,0x21,0x04,0x22,0x04,0x40,0x04}}, // 所
{0x3D6B,0x8F8B,0xBDEB,0xE69A91,0x6691,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x0a,0x0f,0xfa,0x00,0x84,0x1f,0xf8,0x00,0x90,0x7f,0xff,0x03,0xf8,0x04,0x08,0x1f,0xf8,0x64,0x08,0x07,0xf8,0x04,0x08}}, // 暑
{0x3D6C,0x8F8C,0xBDEC,0xE69B99,0x66D9,{0x00,0x00,0x07,0xfe,0x04,0x92,0x7f,0xfe,0x48,0x42,0x4b,0xfc,0x48,0x48,0x7f,0xff,0x48,0x60,0x49,0xfc,0x4b,0x04,0x4d,0xfc,0x79,0x04,0x49,0x04,0x01,0xfc,0x01,0x04}}, // 曙
{0x3D6D,0x8F8D,0xBDED,0xE6B89A,0x6E1A,{0x10,0x40,0x08,0x44,0x0b,0xfc,0x00,0x48,0x00,0x50,0x47,0xff,0x20,0x20,0x20,0x40,0x09,0xf8,0x0b,0x08,0x15,0x08,0x11,0xf8,0x21,0x08,0x21,0x08,0x41,0xf8,0x41,0x08}}, // 渚
{0x3D6E,0x8F8E,0xBDEE,0xE5BAB6,0x5EB6,{0x00,0x80,0x00,0x80,0x1f,0xfe,0x10,0x00,0x11,0x10,0x11,0x10,0x1f,0xff,0x11,0x10,0x11,0x10,0x11,0x10,0x11,0xf0,0x20,0x00,0x2a,0x48,0x49,0x24,0x11,0x22,0x20,0x02}}, // 庶
{0x3D6F,0x8F8F,0xBDEF,0xE7B792,0x7DD2,{0x08,0x20,0x08,0x24,0x0a,0xfc,0x72,0x28,0x14,0x28,0x08,0x30,0x0d,0xff,0x12,0x20,0x7d,0x7c,0x08,0x44,0x28,0xc4,0x2d,0x7c,0x2a,0x44,0x2a,0x44,0x48,0x7c,0x08,0x44}}, // 緒
{0x3D70,0x8F90,0xBDF0,0xE7BDB2,0x7F72,{0x00,0x00,0x1f,0xfc,0x12,0x24,0x1f,0xfc,0x00,0x88,0x1f,0xfc,0x00,0x90,0x7f,0xff,0x01,0x80,0x07,0xf8,0x0c,0x08,0x34,0x08,0x07,0xf8,0x04,0x08,0x07,0xf8,0x04,0x08}}, // 署
{0x3D71,0x8F91,0xBDF1,0xE69BB8,0x66F8,{0x00,0x80,0x1f,0xfc,0x00,0x84,0x7f,0xff,0x00,0x84,0x1f,0xfc,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 書
{0x3D72,0x8F92,0xBDF2,0xE896AF,0x85AF,{0x04,0x10,0x7f,0xff,0x04,0x10,0x1f,0xfc,0x12,0x24,0x1f,0xfc,0x00,0x88,0x1f,0xfe,0x00,0xa0,0x7f,0xff,0x03,0xf8,0x0c,0x08,0x17,0xf8,0x64,0x08,0x07,0xf8,0x04,0x08}}, // 薯
{0x3D73,0x8F93,0xBDF3,0xE897B7,0x85F7,{0x04,0x20,0x04,0x20,0x7f,0xff,0x04,0x20,0x3e,0x12,0x00,0x7e,0x7f,0x14,0x00,0x18,0x3f,0xff,0x00,0x10,0x3e,0x7e,0x01,0xa2,0x3e,0x3e,0x22,0x22,0x3e,0x3e,0x22,0x22}}, // 藷
{0x3D74,0x8F94,0xBDF4,0xE8ABB8,0x8AF8,{0x00,0x20,0x3e,0x24,0x00,0xfc,0x7f,0x24,0x00,0x28,0x3e,0x28,0x01,0xff,0x00,0x20,0x3e,0x7c,0x00,0x44,0x3e,0xc4,0x23,0x7c,0x22,0x44,0x22,0x44,0x3e,0x7c,0x22,0x44}}, // 諸
{0x3D75,0x8F95,0xBDF5,0xE58AA9,0x52A9,{0x00,0x20,0x3e,0x20,0x22,0x20,0x22,0x20,0x23,0xfe,0x3e,0x22,0x22,0x22,0x22,0x22,0x3e,0x22,0x22,0x22,0x22,0x42,0x23,0x42,0x26,0x42,0x38,0x82,0x61,0x04,0x02,0x18}}, // 助
{0x3D76,0x8F96,0xBDF6,0xE58F99,0x53D9,{0x04,0x00,0x04,0xfc,0x0a,0x04,0x09,0x04,0x10,0x84,0x3f,0x24,0x44,0x24,0x04,0x28,0x7f,0xa8,0x04,0x18,0x15,0x10,0x14,0x98,0x24,0xa8,0x24,0x44,0x44,0x82,0x0d,0x01}}, // 叙
{0x3D77,0x8F97,0xBDF7,0xE5A5B3,0x5973,{0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0xff,0xff,0x02,0x10,0x02,0x10,0x02,0x10,0x04,0x20,0x04,0x20,0x1f,0x40,0x10,0xc0,0x01,0x20,0x02,0x10,0x0c,0x08,0x30,0x04}}, // 女
{0x3D78,0x8F98,0xBDF8,0xE5BA8F,0x5E8F,{0x00,0x40,0x00,0x40,0x1f,0xff,0x10,0x00,0x17,0xf8,0x10,0x10,0x11,0xa0,0x10,0x40,0x1f,0xfe,0x10,0x44,0x10,0x48,0x10,0x50,0x20,0x40,0x20,0x40,0x41,0xc0,0x00,0x40}}, // 序
{0x3D79,0x8F99,0xBDF9,0xE5BE90,0x5F90,{0x08,0x20,0x08,0x20,0x10,0x50,0x10,0x50,0x24,0x88,0x45,0x04,0x0a,0xfa,0x0c,0x21,0x10,0x20,0x37,0xfe,0x50,0x20,0x11,0x28,0x11,0x24,0x12,0x22,0x14,0x62,0x10,0x20}}, // 徐
{0x3D7A,0x8F9A,0xBDFA,0xE68195,0x6055,{0x04,0x00,0x04,0x00,0x7f,0xfe,0x09,0x22,0x09,0x22,0x11,0x22,0x3e,0x22,0x05,0x3e,0x18,0x22,0x61,0x00,0x00,0x80,0x12,0x44,0x12,0x42,0x22,0x09,0x42,0x09,0x01,0xf8}}, // 恕
{0x3D7B,0x8F9B,0xBDFB,0xE98BA4,0x92E4,{0x08,0x08,0x09,0xc8,0x15,0x48,0x13,0x48,0x21,0x7e,0x7f,0xca,0x09,0x4a,0x09,0x4a,0x7f,0x4a,0x09,0xca,0x4b,0x4a,0x2d,0x4a,0x29,0xf2,0x0f,0x12,0x18,0x22,0x60,0x4c}}, // 鋤
{0x3D7C,0x8F9C,0xBDFC,0xE999A4,0x9664,{0x00,0x20,0x3c,0x20,0x24,0x50,0x24,0x50,0x28,0x88,0x31,0x04,0x2a,0xfa,0x28,0x21,0x24,0x20,0x27,0xfe,0x24,0x20,0x24,0xa8,0x38,0xa4,0x21,0x22,0x22,0x62,0x20,0x20}}, // 除
{0x3D7D,0x8F9D,0xBDFD,0xE582B7,0x50B7,{0x04,0x80,0x04,0xfe,0x05,0x00,0x09,0xf8,0x0a,0x88,0x14,0xf8,0x10,0x88,0x30,0xf8,0x50,0x00,0x17,0xff,0x10,0x80,0x11,0xfe,0x16,0x4a,0x11,0x92,0x16,0x22,0x10,0xcc}}, // 傷
{0x3D7E,0x8F9E,0xBDFE,0xE5849F,0x511F,{0x05,0x24,0x04,0xa8,0x07,0xfe,0x0a,0x02,0x0a,0xfa,0x10,0x88,0x10,0xf8,0x31,0xfc,0x51,0x04,0x11,0xfc,0x11,0x04,0x11,0xfc,0x11,0x04,0x11,0xfc,0x10,0xcc,0x13,0x02}}, // 償
{0x3E21,0x8F9F,0xBEA1,0xE58B9D,0x52DD,{0x00,0x20,0x3d,0x24,0x24,0xa8,0x24,0x20,0x25,0xfe,0x3c,0x20,0x24,0x30,0x27,0xff,0x24,0x48,0x3c,0xa4,0x25,0xfe,0x26,0x25,0x24,0x24,0x24,0x44,0x2c,0x84,0x45,0x18}}, // 勝
{0x3E22,0x8FA0,0xBEA2,0xE58CA0,0x5320,{0x00,0x00,0x3f,0xfe,0x20,0x08,0x20,0x70,0x27,0x80,0x24,0x00,0x27,0xfc,0x24,0x20,0x24,0x20,0x24,0x20,0x24,0x20,0x28,0x20,0x28,0x20,0x30,0x20,0x3f,0xfe,0x20,0x00}}, // 匠
{0x3E23,0x8FA1,0xBEA3,0xE58D87,0x5347,{0x00,0x10,0x00,0x90,0x03,0x10,0x3c,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x08,0x10,0x08,0x10,0x10,0x10,0x20,0x10}}, // 升
{0x3E24,0x8FA2,0xBEA4,0xE58FAC,0x53EC,{0x00,0x00,0x7f,0xfe,0x01,0x02,0x01,0x02,0x02,0x02,0x02,0x02,0x04,0x02,0x18,0x0c,0x60,0x00,0x0f,0xfc,0x08,0x04,0x08,0x04,0x08,0x04,0x08,0x04,0x0f,0xfc,0x08,0x04}}, // 召
{0x3E25,0x8FA3,0xBEA5,0xE593A8,0x54E8,{0x00,0x10,0x00,0x92,0x00,0x52,0x3e,0x54,0x22,0x10,0x22,0xfe,0x22,0x82,0x22,0x82,0x22,0xfe,0x22,0x82,0x22,0x82,0x3e,0xfe,0x22,0x82,0x00,0x82,0x00,0x86,0x00,0x82}}, // 哨
{0x3E26,0x8FA4,0xBEA6,0xE59586,0x5546,{0x00,0x80,0x00,0x80,0x7f,0xff,0x04,0x10,0x02,0x20,0x3f,0xfe,0x22,0x22,0x22,0x22,0x24,0x1e,0x2b,0xe2,0x32,0x22,0x22,0x22,0x23,0xe2,0x22,0x22,0x20,0x06,0x20,0x02}}, // 商
{0x3E27,0x8FA5,0xBEA7,0xE594B1,0x5531,{0x00,0x00,0x00,0xfc,0x00,0x84,0x7c,0x84,0x44,0xfc,0x44,0x84,0x44,0x84,0x44,0xfc,0x44,0x00,0x45,0xfe,0x7d,0x02,0x45,0x02,0x01,0xfe,0x01,0x02,0x01,0xfe,0x01,0x02}}, // 唱
{0x3E28,0x8FA6,0xBEA8,0xE59897,0x5617,{0x11,0x10,0x09,0x20,0x3f,0xfe,0x20,0x04,0x4f,0xf0,0x08,0x10,0x2f,0xf0,0x20,0x18,0x3f,0xe0,0x20,0x02,0x1f,0xfe,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10}}, // 嘗
{0x3E29,0x8FA7,0xBEA9,0xE5A5A8,0x5968,{0x04,0x0c,0x25,0xf2,0x15,0x22,0x14,0xa4,0x04,0x88,0x0f,0xff,0x14,0x44,0x64,0x24,0x04,0x24,0x04,0x8c,0x00,0x80,0x7f,0xff,0x01,0x40,0x02,0x20,0x0c,0x18,0x70,0x07}}, // 奨
{0x3E2A,0x8FA8,0xBEAA,0xE5A6BE,0x59BE,{0x00,0x80,0x00,0x80,0x3f,0xfe,0x04,0x10,0x02,0x10,0x02,0x20,0x7f,0xff,0x00,0x00,0x01,0x00,0x7f,0xff,0x01,0x10,0x02,0x10,0x0f,0x20,0x00,0xe0,0x03,0x18,0x3c,0x04}}, // 妾
{0x3E2B,0x8FA9,0xBEAB,0xE5A8BC,0x5A3C,{0x08,0x00,0x08,0x7c,0x08,0x44,0x08,0x44,0x7e,0x7c,0x12,0x44,0x12,0x7c,0x12,0x00,0x22,0xfe,0x24,0x82,0x7c,0x82,0x06,0xfe,0x0a,0x82,0x10,0x82,0x60,0xfe,0x00,0x82}}, // 娼
{0x3E2C,0x8FAA,0xBEAC,0xE5AEB5,0x5BB5,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x21,0x04,0x49,0x20,0x05,0x20,0x05,0x40,0x1f,0xf0,0x10,0x10,0x10,0x10,0x1f,0xf0,0x10,0x10,0x1f,0xf0,0x10,0x10,0x10,0x30,0x10,0x10}}, // 宵
{0x3E2D,0x8FAB,0xBEAD,0xE5B086,0x5C06,{0x08,0x04,0x08,0x38,0x4b,0xc2,0x28,0x22,0x29,0x14,0x28,0x94,0x08,0x88,0x08,0x08,0x1b,0xff,0x29,0x08,0x28,0x88,0x48,0x88,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x18}}, // 将
{0x3E2E,0x8FAC,0xBEAE,0xE5B08F,0x5C0F,{0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x09,0x20,0x09,0x10,0x09,0x08,0x11,0x08,0x11,0x04,0x21,0x04,0x41,0x04,0x01,0x00,0x01,0x00,0x07,0x00,0x01,0x00}}, // 小
{0x3E2F,0x8FAD,0xBEAF,0xE5B091,0x5C11,{0x00,0x80,0x00,0x80,0x00,0x80,0x04,0x90,0x04,0x88,0x08,0x84,0x08,0x84,0x10,0x8a,0x20,0x8a,0x43,0x90,0x00,0x90,0x00,0x20,0x00,0x40,0x01,0x80,0x06,0x00,0x38,0x00}}, // 少
{0x3E30,0x8FAE,0xBEB0,0xE5B09A,0x5C1A,{0x00,0x80,0x10,0x88,0x08,0x88,0x04,0x90,0x04,0xa0,0x3f,0xfe,0x20,0x02,0x20,0x02,0x27,0xf2,0x24,0x12,0x24,0x12,0x24,0x12,0x27,0xf2,0x24,0x12,0x20,0x06,0x20,0x02}}, // 尚
{0x3E31,0x8FAF,0xBEB1,0xE5BA84,0x5E84,{0x00,0x40,0x00,0x40,0x1f,0xff,0x10,0x00,0x10,0x40,0x10,0x40,0x10,0x40,0x10,0x40,0x17,0xfc,0x10,0x40,0x10,0x40,0x10,0x40,0x20,0x40,0x20,0x42,0x5f,0xff,0x00,0x00}}, // 庄
{0x3E32,0x8FB0,0xBEB2,0xE5BA8A,0x5E8A,{0x00,0x40,0x00,0x40,0x1f,0xff,0x10,0x40,0x10,0x40,0x10,0x40,0x1f,0xff,0x10,0xe0,0x10,0xe0,0x11,0x50,0x11,0x50,0x12,0x48,0x24,0x44,0x28,0x42,0x40,0x40,0x00,0x40}}, // 床
{0x3E33,0x8FB1,0xBEB3,0xE5BBA0,0x5EE0,{0x00,0x80,0x00,0x80,0x1f,0xff,0x12,0x10,0x1a,0x50,0x16,0x90,0x12,0x1f,0x1f,0xe4,0x18,0x54,0x1f,0x54,0x1d,0x54,0x1d,0x48,0x2f,0x48,0x28,0x54,0x48,0x62,0x08,0xc1}}, // 廠
{0x3E34,0x8FB2,0xBEB4,0xE5BDB0,0x5F70,{0x04,0x08,0x04,0x08,0x7f,0xd0,0x11,0x10,0x0a,0x24,0x7f,0xc4,0x00,0x08,0x3f,0x88,0x20,0x92,0x3f,0xa2,0x20,0xc4,0x3f,0x84,0x04,0x08,0x7f,0xd0,0x04,0x20,0x04,0x40}}, // 彰
{0x3E35,0x8FB3,0xBEB5,0xE689BF,0x627F,{0x00,0x00,0x0f,0xf0,0x00,0x20,0x00,0x40,0x00,0x92,0x78,0x92,0x0f,0xf4,0x08,0x88,0x0f,0xf8,0x08,0x88,0x10,0x84,0x1f,0xfc,0x20,0x82,0x40,0x81,0x01,0x80,0x00,0x80}}, // 承
{0x3E36,0x8FB4,0xBEB6,0xE68A84,0x6284,{0x10,0x20,0x10,0x20,0x10,0x20,0x11,0x28,0x7d,0x24,0x11,0x24,0x12,0x22,0x12,0x22,0x14,0x25,0x1c,0x64,0x70,0x28,0x10,0x08,0x10,0x10,0x10,0x20,0x10,0xc0,0x33,0x00}}, // 抄
{0x3E37,0x8FB5,0xBEB7,0xE68B9B,0x62DB,{0x10,0x00,0x17,0xfe,0x10,0x42,0x10,0x42,0x7c,0x42,0x10,0x82,0x10,0x82,0x11,0x0c,0x1e,0x00,0x75,0xfc,0x11,0x04,0x11,0x04,0x11,0x04,0x11,0x04,0x11,0xfc,0x31,0x04}}, // 招
{0x3E38,0x8FB6,0xBEB8,0xE68E8C,0x638C,{0x11,0x10,0x09,0x10,0x09,0x20,0x7f,0xfe,0x40,0x02,0x4f,0xf2,0x08,0x10,0x0f,0xf0,0x00,0x18,0x0f,0xe0,0x00,0x80,0x3f,0xfc,0x00,0x80,0x7f,0xfe,0x00,0x80,0x01,0x80}}, // 掌
{0x3E39,0x8FB7,0xBEB9,0xE68DB7,0x6377,{0x10,0x20,0x10,0x20,0x13,0xff,0x10,0x20,0x7d,0xfc,0x10,0x24,0x13,0xff,0x10,0x24,0x1d,0xfc,0x70,0x20,0x11,0x20,0x11,0x3e,0x11,0xa0,0x12,0x60,0x14,0x30,0x38,0x0f}}, // 捷
{0x3E3A,0x8FB8,0xBEBA,0xE69887,0x6607,{0x00,0x00,0x0f,0xfc,0x08,0x04,0x0f,0xfc,0x08,0x04,0x08,0x04,0x0f,0xfc,0x01,0x10,0x0e,0x10,0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x04,0x10,0x04,0x10,0x08,0x10}}, // 昇
{0x3E3B,0x8FB9,0xBEBB,0xE6988C,0x660C,{0x00,0x00,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x00,0x00,0x3f,0xfc,0x20,0x04,0x20,0x04,0x3f,0xfc,0x20,0x04,0x20,0x04,0x3f,0xfc,0x20,0x04}}, // 昌
{0x3E3C,0x8FBA,0xBEBC,0xE698AD,0x662D,{0x00,0x00,0x03,0xfe,0x7c,0x22,0x44,0x22,0x44,0x42,0x44,0x42,0x44,0x82,0x7d,0x0c,0x46,0x00,0x44,0xfe,0x44,0x82,0x44,0x82,0x7c,0x82,0x44,0x82,0x00,0xfe,0x00,0x82}}, // 昭
{0x3E3D,0x8FBB,0xBEBD,0xE699B6,0x6676,{0x00,0x00,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x00,0x00,0x7e,0x7e,0x42,0x42,0x42,0x42,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x42,0x42}}, // 晶
{0x3E3E,0x8FBC,0xBEBE,0xE69DBE,0x677E,{0x08,0x38,0x08,0x08,0x08,0x48,0x7f,0x48,0x08,0x44,0x08,0x54,0x1c,0x92,0x1a,0x92,0x19,0x11,0x2a,0x20,0x28,0x28,0x48,0x24,0x08,0x44,0x08,0x7a,0x0b,0xc2,0x08,0x02}}, // 松
{0x3E3F,0x8FBD,0xBEBF,0xE6A2A2,0x68A2,{0x08,0x10,0x08,0x92,0x08,0x52,0x7f,0x54,0x08,0x10,0x08,0x7e,0x1c,0x42,0x1a,0x42,0x19,0x7e,0x29,0x42,0x28,0x42,0x48,0x7e,0x08,0x42,0x08,0x42,0x08,0x46,0x08,0x42}}, // 梢
{0x3E40,0x8FBE,0xBEC0,0xE6A89F,0x6A1F,{0x08,0x20,0x08,0x20,0x09,0xfe,0x7e,0x88,0x08,0x50,0x0b,0xff,0x1c,0x00,0x1b,0xfc,0x19,0x04,0x29,0xfc,0x29,0x04,0x49,0xfc,0x08,0x20,0x0b,0xff,0x08,0x20,0x08,0x20}}, // 樟
{0x3E41,0x8FBF,0xBEC1,0xE6A8B5,0x6A35,{0x08,0x44,0x08,0x48,0x08,0xff,0x7e,0x90,0x09,0x90,0x08,0xfe,0x18,0x90,0x1c,0x90,0x1a,0xfe,0x2a,0x90,0x28,0x90,0x48,0xff,0x08,0x00,0x09,0x52,0x09,0x29,0x0a,0x29}}, // 樵
{0x3E42,0x8FC0,0xBEC2,0xE6B2BC,0x6CBC,{0x10,0x00,0x0b,0xfe,0x08,0x22,0x00,0x22,0x40,0x42,0x20,0x42,0x20,0x82,0x01,0x0c,0x0a,0x00,0x09,0xfe,0x11,0x02,0x11,0x02,0x21,0x02,0x21,0x02,0x41,0xfe,0x41,0x02}}, // 沼
{0x3E43,0x8FC1,0xBEC3,0xE6B688,0x6D88,{0x10,0x20,0x0a,0x22,0x09,0x22,0x00,0xa4,0x40,0xa8,0x21,0xfc,0x21,0x04,0x01,0x04,0x09,0xfc,0x09,0x04,0x11,0x04,0x11,0xfc,0x21,0x04,0x21,0x04,0x41,0x1c,0x41,0x04}}, // 消
{0x3E44,0x8FC2,0xBEC4,0xE6B889,0x6E09,{0x10,0x20,0x09,0x20,0x09,0x3e,0x49,0x20,0x21,0x20,0x27,0xff,0x20,0x28,0x01,0x24,0x09,0x24,0x11,0x22,0x12,0x6a,0x14,0x28,0x20,0x10,0x20,0x20,0x40,0xc0,0x47,0x00}}, // 渉
{0x3E45,0x8FC3,0xBEC5,0xE6B998,0x6E58,{0x21,0x00,0x11,0x3e,0x11,0x22,0x01,0x22,0x0f,0xe2,0x41,0x3e,0x21,0x22,0x23,0xa2,0x03,0x62,0x15,0x7e,0x15,0x22,0x19,0x22,0x21,0x22,0x21,0x22,0x41,0x3e,0x41,0x22}}, // 湘
{0x3E46,0x8FC4,0xBEC6,0xE784BC,0x713C,{0x08,0x10,0x08,0x10,0x08,0xfe,0x0a,0x10,0x2a,0x54,0x2a,0x44,0x2d,0xff,0x28,0x44,0x48,0x44,0x08,0x00,0x0d,0xff,0x0a,0x28,0x12,0x28,0x10,0x49,0x20,0x89,0x41,0x07}}, // 焼
{0x3E47,0x8FC5,0xBEC7,0xE784A6,0x7126,{0x04,0x40,0x04,0x80,0x0f,0xfc,0x08,0x80,0x18,0x80,0x2f,0xf8,0x48,0x80,0x0f,0xf8,0x08,0x80,0x08,0x80,0x0f,0xfc,0x18,0x00,0x10,0x08,0x12,0x44,0x21,0x22,0x41,0x22}}, // 焦
{0x3E48,0x8FC6,0xBEC8,0xE785A7,0x7167,{0x00,0x00,0x3f,0xfe,0x22,0x22,0x22,0x22,0x22,0x42,0x3e,0x8c,0x23,0x00,0x22,0xfe,0x22,0x82,0x22,0x82,0x3e,0xfe,0x00,0x82,0x10,0x00,0x12,0x24,0x21,0x12,0x41,0x11}}, // 照
{0x3E49,0x8FC7,0xBEC9,0xE79787,0x75C7,{0x00,0x40,0x00,0x40,0x0f,0xff,0x48,0x00,0x28,0x00,0x2f,0xfe,0x08,0x20,0x08,0x20,0x19,0x20,0x29,0x3c,0x49,0x20,0x11,0x20,0x11,0x20,0x21,0x20,0x5f,0xff,0x00,0x00}}, // 症
{0x3E4A,0x8FC8,0xBECA,0xE79C81,0x7701,{0x00,0x80,0x00,0x90,0x04,0x8c,0x18,0x92,0x61,0xa1,0x00,0xc0,0x0f,0xf8,0x78,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 省
{0x3E4B,0x8FC9,0xBECB,0xE7A19D,0x785D,{0x00,0x10,0x7f,0x92,0x08,0x52,0x08,0x54,0x08,0x10,0x10,0x7e,0x1e,0x42,0x32,0x42,0x32,0x7e,0x52,0x42,0x12,0x42,0x12,0x7e,0x1e,0x42,0x12,0x42,0x10,0x42,0x00,0x46}}, // 硝
{0x3E4C,0x8FCA,0xBECC,0xE7A481,0x7901,{0x00,0x48,0x7f,0x50,0x08,0xff,0x09,0x90,0x0a,0x90,0x10,0xfe,0x1e,0x90,0x32,0x90,0x32,0xfe,0x52,0x90,0x12,0x90,0x12,0xff,0x1e,0x84,0x11,0x52,0x11,0x29,0x02,0x29}}, // 礁
{0x3E4D,0x8FCB,0xBECD,0xE7A5A5,0x7965,{0x08,0x84,0x08,0x44,0x08,0x48,0x7e,0xfe,0x02,0x10,0x04,0x10,0x04,0x10,0x08,0xfe,0x1c,0x10,0x2a,0x10,0x49,0x10,0x09,0xff,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10}}, // 祥
{0x3E4E,0x8FCC,0xBECE,0xE7A7B0,0x79F0,{0x02,0x40,0x0c,0x40,0x78,0x40,0x08,0x7f,0x08,0x90,0x7e,0x90,0x09,0x10,0x18,0x18,0x1c,0x54,0x1a,0x54,0x2a,0x52,0x28,0x92,0x49,0x12,0x08,0x10,0x08,0x30,0x08,0x10}}, // 称
{0x3E4F,0x8FCD,0xBECF,0xE7ABA0,0x7AE0,{0x00,0x80,0x00,0x80,0x3f,0xfe,0x04,0x10,0x02,0x20,0x7f,0xff,0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80}}, // 章
{0x3E50,0x8FCE,0xBED0,0xE7AC91,0x7B11,{0x08,0x20,0x08,0x20,0x0f,0x7f,0x14,0x48,0x22,0x84,0x40,0x10,0x00,0x60,0x1f,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x60,0x03}}, // 笑
{0x3E51,0x8FCF,0xBED1,0xE7B2A7,0x7CA7,{0x08,0x10,0x4a,0x10,0x2a,0x10,0x2c,0xff,0x28,0x80,0x08,0x90,0x7e,0x90,0x08,0x90,0x1c,0xfe,0x1a,0x90,0x2a,0x90,0x28,0x90,0x49,0x10,0x09,0x10,0x0a,0xff,0x08,0x00}}, // 粧
{0x3E52,0x8FD0,0xBED2,0xE7B4B9,0x7D39,{0x08,0x00,0x08,0xfe,0x0a,0x22,0x72,0x22,0x14,0x22,0x08,0x42,0x0a,0x42,0x12,0x8c,0x7f,0x00,0x09,0x7e,0x2c,0x42,0x2a,0x42,0x29,0x42,0x29,0x42,0x48,0x7e,0x08,0x42}}, // 紹
{0x3E53,0x8FD1,0xBED3,0xE88296,0x8096,{0x10,0x84,0x08,0x84,0x04,0x88,0x04,0x90,0x00,0x80,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x38,0x08,0x08}}, // 肖
{0x3E54,0x8FD2,0xBED4,0xE88F96,0x83D6,{0x04,0x20,0x04,0x20,0x7f,0xfe,0x04,0x20,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x00,0x00,0x3f,0xfc,0x20,0x04,0x3f,0xfc,0x20,0x04,0x3f,0xfc,0x20,0x04}}, // 菖
{0x3E55,0x8FD3,0xBED5,0xE8928B,0x848B,{0x04,0x20,0x04,0x20,0x7f,0xff,0x04,0x24,0x08,0x18,0x09,0xe2,0x49,0x12,0x28,0x94,0x28,0x88,0x08,0x08,0x1b,0xff,0x28,0x88,0x48,0x48,0x08,0x48,0x08,0x08,0x08,0x18}}, // 蒋
{0x3E56,0x8FD4,0xBED6,0xE89589,0x8549,{0x02,0x20,0x02,0x20,0x7f,0xff,0x0a,0x20,0x08,0x40,0x1f,0xfc,0x28,0x40,0x4f,0xf8,0x08,0x40,0x0f,0xf8,0x08,0x40,0x0f,0xfc,0x10,0x08,0x12,0x44,0x21,0x22,0x41,0x22}}, // 蕉
{0x3E57,0x8FD5,0xBED7,0xE8A19D,0x885D,{0x08,0x60,0x0b,0x9e,0x10,0x80,0x17,0xf0,0x20,0x80,0x4b,0xe0,0x0a,0xbf,0x13,0xe4,0x12,0xa4,0x33,0xe4,0x50,0x84,0x13,0xe4,0x10,0x84,0x10,0xf4,0x17,0x04,0x10,0x0c}}, // 衝
{0x3E58,0x8FD6,0xBED8,0xE8A3B3,0x88F3,{0x11,0x08,0x09,0x10,0x3f,0xfe,0x20,0x04,0x2f,0xf0,0x48,0x10,0x08,0x10,0x0f,0xf0,0x01,0x00,0x7f,0xfe,0x02,0x84,0x04,0x88,0x1c,0x50,0x64,0x20,0x07,0x18,0x38,0x06}}, // 裳
{0x3E59,0x8FD7,0xBED9,0xE8A89F,0x8A1F,{0x00,0x38,0x3e,0x08,0x00,0x48,0x7f,0x48,0x00,0x44,0x3e,0x84,0x00,0xa2,0x01,0x21,0x3e,0x20,0x00,0x30,0x3e,0x28,0x22,0x48,0x22,0x44,0x22,0x8c,0x3f,0xf2,0x22,0x02}}, // 訟
{0x3E5A,0x8FD8,0xBEDA,0xE8A8BC,0x8A3C,{0x00,0x00,0x3e,0xfe,0x00,0x10,0x7f,0x10,0x00,0x10,0x3e,0x90,0x00,0x90,0x00,0x9e,0x3e,0x90,0x00,0x90,0x3e,0x90,0x22,0x90,0x22,0x90,0x22,0x90,0x3f,0xff,0x22,0x00}}, // 証
{0x3E5B,0x8FD9,0xBEDB,0xE8A994,0x8A54,{0x00,0x00,0x3d,0xfe,0x00,0x22,0x7f,0x22,0x00,0x22,0x3e,0x42,0x00,0x42,0x3e,0x8c,0x01,0x00,0x00,0x7e,0x3e,0x42,0x22,0x42,0x22,0x42,0x22,0x42,0x3e,0x7e,0x22,0x42}}, // 詔
{0x3E5C,0x8FDA,0xBEDC,0xE8A9B3,0x8A73,{0x00,0x84,0x3e,0x44,0x00,0x48,0x7f,0xfe,0x00,0x10,0x3e,0x10,0x00,0x10,0x00,0xfc,0x3e,0x10,0x00,0x10,0x3e,0x10,0x23,0xfe,0x22,0x10,0x22,0x10,0x3e,0x10,0x22,0x10}}, // 詳
{0x3E5D,0x8FDB,0xBEDD,0xE8B1A1,0x8C61,{0x02,0x00,0x03,0xe0,0x04,0x40,0x18,0x80,0x7f,0xf8,0x10,0x88,0x10,0x88,0x1f,0xf8,0x02,0x02,0x05,0x44,0x39,0xd8,0x06,0xa0,0x39,0x90,0x06,0x8c,0x78,0x83,0x01,0x80}}, // 象
{0x3E5E,0x8FDC,0xBEDE,0xE8B39E,0x8CDE,{0x11,0x10,0x09,0x20,0x3f,0xfe,0x20,0x04,0x47,0xe0,0x04,0x20,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x0c,0x18,0x30,0x04}}, // 賞
{0x3E5F,0x8FDD,0xBEDF,0xE986A4,0x91A4,{0x24,0x0c,0x15,0xf4,0x05,0x44,0x0c,0xa8,0x17,0xff,0x24,0x88,0x04,0x18,0x7f,0xff,0x01,0x20,0x1f,0xfc,0x12,0x24,0x1c,0x3c,0x1f,0xfc,0x10,0x04,0x1f,0xfc,0x10,0x04}}, // 醤
{0x3E60,0x8FDE,0xBEE0,0xE989A6,0x9266,{0x08,0x00,0x08,0xfe,0x14,0x10,0x12,0x10,0x21,0x10,0x7e,0x50,0x08,0x50,0x08,0x5e,0x7f,0x50,0x08,0x50,0x4a,0x50,0x2c,0x50,0x28,0x50,0x0e,0x50,0x1b,0xff,0x60,0x00}}, // 鉦
{0x3E61,0x8FDF,0xBEE1,0xE98DBE,0x937E,{0x08,0x04,0x08,0x18,0x14,0xf0,0x12,0x10,0x21,0xff,0x7e,0x10,0x08,0xfe,0x08,0x92,0x7f,0xfe,0x08,0x92,0x4a,0xfe,0x2c,0x10,0x28,0xfe,0x0e,0x10,0x1b,0xff,0x60,0x00}}, // 鍾
{0x3E62,0x8FE0,0xBEE2,0xE99098,0x9418,{0x08,0x10,0x08,0x10,0x15,0xff,0x12,0x44,0x21,0xff,0x7f,0x00,0x08,0xfe,0x08,0x92,0x7e,0xfe,0x08,0x92,0x4a,0xfe,0x2c,0x10,0x28,0xfe,0x0e,0x10,0x19,0xff,0x60,0x00}}, // 鐘
{0x3E63,0x8FE1,0xBEE3,0xE99A9C,0x969C,{0x00,0x20,0x3c,0x20,0x25,0xfe,0x24,0x84,0x28,0x48,0x37,0xff,0x28,0x00,0x29,0xfc,0x25,0x04,0x25,0xfc,0x25,0x04,0x25,0xfc,0x38,0x20,0x23,0xff,0x20,0x20,0x20,0x20}}, // 障
{0x3E64,0x8FE2,0xBEE4,0xE99E98,0x9798,{0x12,0x10,0x12,0x92,0x7f,0x52,0x12,0x54,0x1e,0x10,0x08,0x7e,0x3f,0x42,0x29,0x42,0x29,0x7e,0x3f,0x42,0x08,0x42,0x7f,0xfe,0x08,0x42,0x08,0x42,0x08,0x42,0x08,0x46}}, // 鞘
{0x3E65,0x8FE3,0xBEE5,0xE4B88A,0x4E0A,{0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0xfc,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x82,0x7f,0xff,0x00,0x00}}, // 上
{0x3E66,0x8FE4,0xBEE6,0xE4B888,0x4E08,{0x00,0x40,0x00,0x40,0x00,0x42,0x3f,0xff,0x00,0x40,0x04,0x40,0x04,0x40,0x02,0x40,0x02,0x80,0x01,0x80,0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x60,0x03}}, // 丈
{0x3E67,0x8FE5,0xBEE7,0xE4B89E,0x4E1E,{0x00,0x00,0x1f,0xf8,0x00,0x10,0x00,0x60,0x00,0x82,0x3e,0xa2,0x02,0xa4,0x04,0x98,0x04,0x88,0x08,0x84,0x10,0x82,0x20,0x81,0x41,0x80,0x00,0x04,0x7f,0xfe,0x00,0x00}}, // 丞
{0x3E68,0x8FE6,0xBEE8,0xE4B997,0x4E57,{0x00,0x10,0x0f,0xe0,0x00,0x80,0x3f,0xfe,0x08,0x88,0x08,0x88,0x7f,0xff,0x08,0x88,0x08,0x88,0x3f,0xfe,0x01,0xc0,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80}}, // 乗
{0x3E69,0x8FE7,0xBEE9,0xE58697,0x5197,{0x00,0x00,0x3f,0xfe,0x20,0x02,0x20,0x04,0x43,0xe0,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x04,0x20,0x04,0x20,0x08,0x20,0x08,0x22,0x10,0x22,0x20,0x1e}}, // 冗
{0x3E6A,0x8FE8,0xBEEA,0xE589B0,0x5270,{0x01,0x02,0x1e,0x12,0x04,0x12,0x3f,0xd2,0x14,0x92,0x14,0x92,0x7f,0xf2,0x14,0x92,0x14,0x92,0x3f,0xd2,0x0e,0x12,0x0d,0x12,0x14,0x82,0x24,0x42,0x44,0x02,0x04,0x06}}, // 剰
{0x3E6B,0x8FE9,0xBEEB,0xE59F8E,0x57CE,{0x10,0x14,0x10,0x12,0x10,0x12,0x13,0xff,0x7e,0x10,0x12,0x12,0x13,0xd2,0x12,0x52,0x12,0x4c,0x16,0x4c,0x1a,0x48,0x62,0x58,0x04,0x55,0x05,0xa5,0x08,0x43,0x10,0x01}}, // 城
{0x3E6C,0x8FEA,0xBEEC,0xE5A0B4,0x5834,{0x00,0x00,0x10,0xfc,0x10,0x84,0x10,0xfc,0x10,0x84,0x7e,0xfc,0x10,0x00,0x17,0xff,0x10,0x80,0x10,0xfe,0x15,0x4a,0x1a,0x4a,0x10,0x92,0x61,0x12,0x02,0x22,0x00,0x4c}}, // 場
{0x3E6D,0x8FEB,0xBEED,0xE5A38C,0x58CC,{0x00,0x20,0x10,0x20,0x13,0xff,0x10,0x48,0x10,0x84,0x7f,0x4b,0x11,0xfe,0x10,0x48,0x11,0xfe,0x10,0x48,0x13,0xff,0x1c,0x62,0x70,0x94,0x07,0x88,0x00,0xe4,0x03,0x83}}, // 壌
{0x3E6E,0x8FEC,0xBEEE,0xE5ACA2,0x5B22,{0x08,0x10,0x08,0x10,0x09,0xff,0x08,0x44,0x7f,0xaa,0x12,0x29,0x12,0xfe,0x12,0x28,0x22,0xfe,0x24,0x28,0x7d,0xff,0x46,0x28,0x0a,0x4a,0x11,0xc4,0x60,0x72,0x01,0x81}}, // 嬢
{0x3E6F,0x8FED,0xBEEF,0xE5B8B8,0x5E38,{0x11,0x08,0x09,0x08,0x09,0x10,0x3f,0xfe,0x20,0x04,0x27,0xe0,0x44,0x20,0x04,0x20,0x07,0xe0,0x01,0x00,0x1f,0xf8,0x11,0x08,0x11,0x08,0x11,0x08,0x11,0x30,0x01,0x00}}, // 常
{0x3E70,0x8FEE,0xBEF0,0xE68385,0x60C5,{0x08,0x20,0x08,0x20,0x0b,0xfe,0x08,0x20,0x0d,0xfc,0x2a,0x20,0x2b,0xff,0x28,0x00,0x28,0xfc,0x48,0x84,0x08,0xfc,0x08,0x84,0x08,0xfc,0x08,0x84,0x08,0x84,0x08,0x8c}}, // 情
{0x3E71,0x8FEF,0xBEF1,0xE693BE,0x64FE,{0x10,0x00,0x13,0xff,0x10,0x20,0x10,0xfc,0x7c,0x84,0x10,0xfc,0x10,0x84,0x13,0xff,0x1e,0x55,0x71,0x4a,0x12,0x7d,0x14,0x89,0x13,0x50,0x10,0x30,0x10,0xcc,0x37,0x03}}, // 擾
{0x3E72,0x8FF0,0xBEF2,0xE69DA1,0x6761,{0x00,0x80,0x00,0x80,0x01,0xf8,0x02,0x10,0x0d,0x20,0x30,0xc0,0x03,0x20,0x0c,0x98,0x70,0x87,0x1f,0xfc,0x01,0xc0,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80}}, // 条
{0x3E73,0x8FF1,0xBEF3,0xE69D96,0x6756,{0x08,0x10,0x08,0x10,0x08,0x10,0x7f,0xff,0x08,0x10,0x08,0x90,0x18,0x90,0x1c,0x50,0x1a,0x50,0x2a,0x20,0x28,0x20,0x48,0x30,0x08,0x50,0x08,0x88,0x09,0x04,0x0a,0x03}}, // 杖
{0x3E74,0x8FF2,0xBEF4,0xE6B584,0x6D44,{0x10,0x40,0x08,0x78,0x08,0x88,0x01,0x10,0x40,0x20,0x23,0xfc,0x20,0x24,0x00,0x24,0x0f,0xff,0x08,0x24,0x10,0x24,0x13,0xfc,0x20,0x24,0x20,0x20,0x40,0x60,0x40,0x20}}, // 浄
{0x3E75,0x8FF3,0xBEF5,0xE78AB6,0x72B6,{0x04,0x20,0x04,0x24,0x24,0x22,0x24,0x22,0x14,0x20,0x17,0xff,0x04,0x20,0x04,0x20,0x0c,0x50,0x14,0x50,0x14,0x50,0x24,0x88,0x44,0x88,0x05,0x04,0x06,0x02,0x04,0x01}}, // 状
{0x3E76,0x8FF4,0xBEF6,0xE795B3,0x7573,{0x00,0x00,0x1f,0xf8,0x11,0x08,0x1f,0xf8,0x11,0x08,0x1f,0xf8,0x00,0x00,0x3f,0xfe,0x20,0x04,0x4f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x7f,0xfe}}, // 畳
{0x3E77,0x8FF5,0xBEF7,0xE7A9A3,0x7A63,{0x02,0x20,0x0c,0x20,0x7b,0xff,0x08,0x48,0x08,0x84,0x09,0x4a,0x7e,0xfd,0x08,0x48,0x1d,0xfe,0x1a,0x48,0x2b,0xff,0x28,0x52,0x48,0xd4,0x0b,0x48,0x08,0x64,0x0b,0x83}}, // 穣
{0x3E78,0x8FF6,0xBEF8,0xE892B8,0x84B8,{0x02,0x10,0x7f,0xff,0x02,0x10,0x00,0x00,0x0f,0xf4,0x00,0x24,0x3e,0x48,0x02,0xb0,0x04,0x90,0x18,0x8c,0x61,0x83,0x00,0x00,0x7f,0xff,0x12,0x24,0x31,0x12,0x41,0x11}}, // 蒸
{0x3E79,0x8FF7,0xBEF9,0xE8ADB2,0x8B72,{0x00,0x10,0x3c,0x10,0x01,0xff,0x7e,0x44,0x00,0xaa,0x3d,0x29,0x00,0xfe,0x00,0x28,0x3c,0xfe,0x00,0x28,0x3d,0xff,0x24,0x2a,0x24,0x4a,0x25,0xc4,0x3c,0x72,0x25,0x81}}, // 譲
{0x3E7A,0x8FF8,0xBEFA,0xE986B8,0x91B8,{0x00,0x10,0x7f,0x10,0x0d,0xff,0x0c,0x44,0x3f,0xaa,0x2d,0x29,0x2d,0xfe,0x35,0x28,0x37,0xfe,0x21,0x28,0x21,0xff,0x3f,0x28,0x21,0x4a,0x21,0xc4,0x3f,0x72,0x21,0x81}}, // 醸
{0x3E7B,0x8FF9,0xBEFB,0xE98CA0,0x9320,{0x08,0x10,0x08,0x10,0x14,0xff,0x12,0x82,0x21,0x00,0x7e,0xfe,0x08,0x10,0x08,0x10,0x7f,0x90,0x08,0x9e,0x4a,0x90,0x2c,0x90,0x28,0xd0,0x0e,0xb0,0x19,0x18,0x62,0x07}}, // 錠
{0x3E7C,0x8FFA,0xBEFC,0xE598B1,0x5631,{0x00,0x00,0x03,0xfe,0x7a,0x02,0x4b,0xfe,0x4a,0x04,0x4a,0xf8,0x4a,0x10,0x4a,0xfe,0x4a,0x92,0x4a,0xfe,0x7a,0x10,0x4b,0xff,0x05,0x15,0x05,0x1b,0x09,0xe1,0x11,0x03}}, // 嘱
{0x3E7D,0x8FFB,0xBEFD,0xE59FB4,0x57F4,{0x00,0x10,0x10,0x10,0x13,0xff,0x10,0x10,0x10,0x7c,0x7c,0x44,0x11,0x44,0x11,0x7c,0x11,0x44,0x11,0x7c,0x13,0x44,0x1d,0x44,0x71,0x7c,0x01,0x00,0x01,0xff,0x01,0x00}}, // 埴
{0x3E7E,0x8FFC,0xBEFE,0xE9A3BE,0x98FE,{0x08,0x40,0x08,0x40,0x14,0x40,0x12,0x7f,0x28,0x90,0x7e,0x90,0x23,0x7e,0x3e,0x52,0x22,0x52,0x22,0x52,0x3e,0x52,0x28,0x52,0x24,0x5c,0x26,0x50,0x3a,0x10,0x61,0x10}}, // 飾
{0x3F21,0x9040,0xBFA1,0xE68BAD,0x62ED,{0x10,0x10,0x10,0x14,0x10,0x12,0x10,0x12,0x7f,0xff,0x10,0x10,0x10,0x10,0x13,0xf0,0x1c,0x88,0x70,0x88,0x10,0x88,0x10,0xa8,0x10,0xc5,0x13,0x05,0x30,0x03,0x10,0x01}}, // 拭
{0x3F22,0x9041,0xBFA2,0xE6A48D,0x690D,{0x08,0x10,0x08,0x10,0x08,0xff,0x7f,0x10,0x08,0x7c,0x09,0x44,0x1d,0x44,0x1b,0x7c,0x1b,0x44,0x29,0x7c,0x29,0x44,0x49,0x44,0x09,0x7c,0x09,0x00,0x09,0xff,0x09,0x00}}, // 植
{0x3F23,0x9042,0xBFA3,0xE6AE96,0x6B96,{0x00,0x08,0x7f,0x08,0x08,0xff,0x08,0x08,0x08,0x3e,0x1e,0xa2,0x12,0xa2,0x12,0xbe,0x2a,0xa2,0x44,0xbe,0x04,0xa2,0x08,0xa2,0x08,0xbe,0x10,0x80,0x20,0xff,0x40,0x80}}, // 殖
{0x3F24,0x9043,0xBFA4,0xE787AD,0x71ED,{0x08,0x00,0x09,0xfe,0x09,0x52,0x09,0x52,0x2b,0xfe,0x2a,0x80,0x2c,0xfe,0x29,0x22,0x49,0xfa,0x0a,0xaa,0x08,0xfa,0x14,0x32,0x12,0x2a,0x20,0x3a,0x21,0xc6,0x40,0x0c}}, // 燭
{0x3F25,0x9044,0xBFA5,0xE7B994,0x7E54,{0x10,0x88,0x10,0x8c,0x17,0xfa,0x66,0x2a,0x29,0x28,0x11,0x48,0x1b,0xff,0x24,0x0a,0x7d,0xea,0x15,0x2a,0x39,0xe4,0x35,0x2c,0x35,0x2d,0x51,0xf5,0x11,0x13,0x10,0x21}}, // 織
{0x3F26,0x9045,0xBFA6,0xE881B7,0x8077,{0x00,0x88,0x7e,0x8c,0x27,0xfa,0x26,0x2a,0x25,0x28,0x3d,0x48,0x27,0xff,0x24,0x0a,0x3d,0xea,0x25,0x2a,0x25,0xe4,0x27,0x2c,0x3d,0x2c,0x65,0xf5,0x05,0x13,0x04,0x21}}, // 職
{0x3F27,0x9046,0xBFA7,0xE889B2,0x8272,{0x02,0x00,0x03,0xf0,0x04,0x20,0x08,0x40,0x10,0x80,0x7f,0xf8,0x11,0x08,0x11,0x08,0x11,0x08,0x1f,0xf8,0x10,0x00,0x10,0x00,0x10,0x02,0x10,0x02,0x10,0x02,0x0f,0xfe}}, // 色
{0x3F28,0x9047,0xBFA8,0xE8A7A6,0x89E6,{0x08,0x10,0x0f,0x10,0x12,0x10,0x24,0x7e,0x5f,0x52,0x15,0x52,0x15,0x52,0x1f,0x52,0x15,0x7e,0x15,0x10,0x1f,0x10,0x11,0x14,0x11,0x12,0x21,0x1e,0x23,0xf1,0x41,0x01}}, // 触
{0x3F29,0x9048,0xBFA9,0xE9A39F,0x98DF,{0x00,0x80,0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x90,0x1f,0xfc,0x64,0x13,0x07,0xf0,0x04,0x10,0x04,0x10,0x07,0xf4,0x04,0x88,0x04,0x50,0x04,0x20,0x07,0x98,0x38,0x07}}, // 食
{0x3F2A,0x9049,0xBFAA,0xE89D95,0x8755,{0x08,0x10,0x08,0x10,0x14,0x10,0x12,0xfe,0x29,0x92,0x7e,0x92,0x22,0x92,0x3e,0x92,0x22,0xfe,0x22,0x10,0x3e,0x18,0x28,0x14,0x24,0x12,0x2e,0x1e,0x32,0x71,0x61,0x81}}, // 蝕
{0x3F2B,0x904A,0xBFAB,0xE8BEB1,0x8FB1,{0x00,0x00,0x1f,0xfe,0x10,0x00,0x1f,0xfc,0x10,0x00,0x1f,0xff,0x14,0x88,0x24,0x50,0x27,0xb0,0x5c,0x0e,0x00,0x10,0x7f,0xff,0x04,0x10,0x02,0x10,0x02,0x10,0x00,0x30}}, // 辱
{0x3F2C,0x904B,0xBFAC,0xE5B0BB,0x5C3B,{0x00,0x00,0x1f,0xfc,0x10,0x04,0x10,0x04,0x1f,0xfc,0x11,0x04,0x11,0x00,0x11,0x00,0x1f,0xf0,0x11,0x10,0x11,0x10,0x11,0x12,0x22,0x12,0x22,0x12,0x44,0x0e,0x08,0x00}}, // 尻
{0x3F2D,0x904C,0xBFAD,0xE4BCB8,0x4F38,{0x04,0x20,0x04,0x20,0x04,0x20,0x0b,0xfe,0x0a,0x22,0x12,0x22,0x12,0x22,0x33,0xfe,0x52,0x22,0x12,0x22,0x13,0xfe,0x12,0x22,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20}}, // 伸
{0x3F2E,0x904D,0xBFAE,0xE4BFA1,0x4FE1,{0x08,0x00,0x09,0xf8,0x08,0x00,0x0f,0xff,0x10,0x00,0x10,0x00,0x33,0xfc,0x30,0x00,0x53,0xfc,0x10,0x00,0x13,0xfc,0x12,0x04,0x12,0x04,0x12,0x04,0x13,0xfc,0x12,0x04}}, // 信
{0x3F2F,0x904E,0xBFAF,0xE4BEB5,0x4FB5,{0x04,0x00,0x05,0xfc,0x04,0x04,0x08,0xfc,0x08,0x04,0x11,0xfc,0x10,0x00,0x33,0xff,0x52,0x02,0x17,0xf8,0x10,0x88,0x10,0x50,0x10,0x20,0x10,0x50,0x11,0x8c,0x16,0x03}}, // 侵
{0x3F30,0x904F,0xBFB0,0xE59487,0x5507,{0x00,0x00,0x1f,0xfe,0x10,0x00,0x1f,0xfc,0x10,0x00,0x1f,0xff,0x12,0x84,0x12,0x58,0x32,0x20,0x23,0x98,0x5c,0x07,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 唇
{0x3F31,0x9050,0xBFB1,0xE5A8A0,0x5A20,{0x08,0x00,0x08,0xff,0x08,0x80,0x08,0x80,0x7f,0xbe,0x12,0x80,0x12,0x80,0x12,0xff,0x22,0xaa,0x3c,0xaa,0x44,0xaa,0x07,0x2c,0x09,0x24,0x12,0x34,0x64,0x62,0x00,0x81}}, // 娠
{0x3F32,0x9051,0xBFB2,0xE5AF9D,0x5BDD,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x49,0xf8,0x08,0x08,0x49,0xf8,0x28,0x08,0x29,0xf8,0x0b,0xfe,0x1a,0x04,0x2d,0xf8,0x48,0x90,0x08,0x60,0x08,0xd8,0x0f,0x06}}, // 寝
{0x3F33,0x9052,0xBFB3,0xE5AFA9,0x5BE9,{0x01,0x00,0x01,0x00,0x1f,0xfe,0x10,0x34,0x2f,0xc8,0x04,0x88,0x02,0x90,0x7f,0xff,0x02,0xa0,0x04,0x90,0x1f,0xfc,0x68,0x8b,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x08,0x08}}, // 審
{0x3F34,0x9053,0xBFB4,0xE5BF83,0x5FC3,{0x02,0x00,0x01,0x00,0x00,0x80,0x00,0x40,0x02,0x40,0x02,0x00,0x12,0x08,0x12,0x04,0x12,0x02,0x12,0x02,0x22,0x09,0x22,0x09,0x42,0x08,0x01,0x08,0x00,0xf8,0x00,0x00}}, // 心
{0x3F35,0x9054,0xBFB5,0xE6858E,0x614E,{0x08,0x20,0x08,0x20,0x0b,0xff,0x08,0x20,0x08,0xfc,0x2c,0x84,0x2a,0xfc,0x2a,0x84,0x28,0xfc,0x48,0x84,0x08,0xfc,0x08,0x00,0x0b,0xff,0x08,0x48,0x08,0x84,0x0b,0x02}}, // 慎
{0x3F36,0x9055,0xBFB6,0xE68CAF,0x632F,{0x10,0x00,0x13,0xff,0x12,0x00,0x12,0x00,0x7e,0xfc,0x12,0x00,0x12,0x00,0x13,0xff,0x1e,0x92,0x72,0x92,0x12,0x94,0x12,0x88,0x14,0x88,0x14,0xa4,0x18,0xc2,0x33,0x01}}, // 振
{0x3F37,0x9056,0xBFB7,0xE696B0,0x65B0,{0x04,0x02,0x04,0x0c,0x7f,0x70,0x22,0x40,0x12,0x40,0x14,0x7f,0x7f,0xc4,0x08,0x44,0x08,0x44,0x7f,0x44,0x0c,0x44,0x1a,0x44,0x19,0x84,0x28,0x84,0x49,0x04,0x08,0x04}}, // 新
{0x3F38,0x9057,0xBFB8,0xE6998B,0x664B,{0x00,0x00,0x3f,0xfe,0x02,0x20,0x12,0x24,0x0a,0x24,0x0a,0x28,0x02,0x20,0x7f,0xff,0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 晋
{0x3F39,0x9058,0xBFB9,0xE6A3AE,0x68EE,{0x00,0x80,0x00,0x80,0x1f,0xfc,0x01,0xc0,0x02,0xa0,0x04,0x90,0x18,0x8c,0x04,0x90,0x04,0x10,0x7f,0xff,0x0c,0x10,0x0e,0x38,0x15,0x34,0x24,0x52,0x44,0x91,0x04,0x10}}, // 森
{0x3F3A,0x9059,0xBFBA,0xE6A69B,0x699B,{0x08,0x20,0x09,0xfe,0x08,0x20,0x7f,0xfc,0x08,0x50,0x0d,0xff,0x1a,0x88,0x19,0x14,0x1a,0xe2,0x2c,0x21,0x2b,0xfe,0x48,0x70,0x08,0xa8,0x09,0x24,0x0a,0x22,0x08,0x20}}, // 榛
{0x3F3B,0x905A,0xBFBB,0xE6B5B8,0x6D78,{0x10,0x00,0x09,0xf8,0x08,0x08,0x01,0xf8,0x40,0x08,0x21,0xf8,0x20,0x00,0x03,0xfe,0x0a,0x04,0x0f,0xf8,0x10,0x88,0x10,0x50,0x20,0x20,0x20,0x50,0x41,0x8c,0x46,0x03}}, // 浸
{0x3F3C,0x905B,0xBFBC,0xE6B7B1,0x6DF1,{0x10,0x00,0x0b,0xff,0x0a,0x52,0x04,0x50,0x40,0x92,0x20,0x8e,0x23,0x20,0x00,0x20,0x07,0xff,0x08,0x20,0x08,0x70,0x10,0xa8,0x11,0x24,0x26,0x23,0x20,0x20,0x40,0x20}}, // 深
{0x3F3D,0x905C,0xBFBD,0xE794B3,0x7533,{0x00,0x80,0x00,0x80,0x00,0x80,0x1f,0xfc,0x10,0x84,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x84,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 申
{0x3F3E,0x905D,0xBFBE,0xE796B9,0x75B9,{0x00,0x40,0x00,0x40,0x0f,0xff,0x08,0x40,0x48,0x60,0x28,0x90,0x29,0x0c,0x0e,0x23,0x18,0xc8,0x2b,0x10,0x48,0x20,0x10,0xc4,0x13,0x08,0x20,0x30,0x40,0xc0,0x07,0x00}}, // 疹
{0x3F3F,0x905E,0xBFBF,0xE79C9F,0x771F,{0x01,0x00,0x01,0x00,0x3f,0xfc,0x01,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x00,0x00,0x7f,0xfe,0x04,0x60,0x18,0x18,0x60,0x04}}, // 真
{0x3F40,0x905F,0xBFC0,0xE7A59E,0x795E,{0x08,0x10,0x08,0x10,0x08,0x10,0x7f,0xfe,0x02,0x92,0x04,0x92,0x04,0xfe,0x08,0x92,0x1c,0x92,0x2a,0x92,0x49,0xfe,0x09,0x12,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10}}, // 神
{0x3F41,0x9060,0xBFC1,0xE7A7A6,0x79E6,{0x00,0x80,0x3f,0xfe,0x00,0x80,0x1f,0xfc,0x01,0x40,0x7f,0xff,0x02,0x10,0x0c,0x6c,0x77,0x83,0x00,0x80,0x3f,0xfe,0x01,0xc0,0x02,0xa0,0x0c,0x98,0x30,0x86,0x00,0x80}}, // 秦
{0x3F42,0x9061,0xBFC2,0xE7B4B3,0x7D33,{0x08,0x10,0x08,0x10,0x0a,0x10,0x72,0xfe,0x14,0x92,0x08,0x92,0x0c,0x92,0x12,0xfe,0x7d,0x92,0x09,0x92,0x2c,0xfe,0x2a,0x92,0x2a,0x10,0x2a,0x10,0x48,0x10,0x08,0x10}}, // 紳
{0x3F43,0x9062,0xBFC3,0xE887A3,0x81E3,{0x00,0x00,0x3f,0xfe,0x20,0x80,0x20,0x80,0x20,0x80,0x3f,0xf8,0x20,0x08,0x20,0x08,0x20,0x08,0x3f,0xf8,0x20,0x88,0x20,0x80,0x20,0x80,0x20,0x80,0x3f,0xfe,0x20,0x00}}, // 臣
{0x3F44,0x9063,0xBFC4,0xE88AAF,0x82AF,{0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x10,0x04,0x10,0x00,0x80,0x00,0x40,0x02,0x20,0x02,0x20,0x12,0x04,0x12,0x02,0x12,0x01,0x22,0x09,0x22,0x08,0x41,0x08,0x00,0xf8}}, // 芯
{0x3F45,0x9064,0xBFC5,0xE896AA,0x85AA,{0x04,0x20,0x04,0x20,0x7f,0xff,0x04,0x20,0x04,0x04,0x3f,0xb8,0x11,0x20,0x0a,0x20,0x7f,0xbf,0x04,0x24,0x7f,0xa4,0x0e,0x24,0x15,0x44,0x24,0x44,0x44,0x84,0x04,0x04}}, // 薪
{0x3F46,0x9065,0xBFC6,0xE8A6AA,0x89AA,{0x08,0x00,0x08,0x7e,0x7f,0x42,0x22,0x42,0x12,0x7e,0x14,0x42,0x7f,0x42,0x08,0x7e,0x08,0x42,0x7f,0x42,0x1c,0x7e,0x1a,0x28,0x29,0x28,0x48,0x49,0x08,0x89,0x0b,0x07}}, // 親
{0x3F47,0x9066,0xBFC7,0xE8A8BA,0x8A3A,{0x00,0x10,0x3e,0x10,0x00,0x28,0x7f,0x28,0x00,0x44,0x3e,0x92,0x01,0x21,0x00,0xc4,0x3e,0x08,0x00,0x30,0x3e,0xc2,0x22,0x04,0x22,0x08,0x22,0x30,0x3e,0xc0,0x23,0x00}}, // 診
{0x3F48,0x9067,0xBFC8,0xE8BAAB,0x8EAB,{0x00,0x80,0x01,0x00,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x11,0x0f,0xf2,0x08,0x14,0x08,0x18,0x0f,0xf0,0x78,0x30,0x00,0xd0,0x03,0x10,0x3c,0x70,0x00,0x10}}, // 身
{0x3F49,0x9068,0xBFC9,0xE8BE9B,0x8F9B,{0x00,0x80,0x00,0x80,0x1f,0xfc,0x04,0x10,0x02,0x10,0x02,0x20,0x02,0x20,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x3f,0xfe,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 辛
{0x3F4A,0x9069,0xBFCA,0xE980B2,0x9032,{0x00,0x88,0x20,0x88,0x11,0x10,0x11,0xfe,0x03,0x10,0x05,0x10,0x01,0xfc,0x39,0x10,0x09,0x10,0x09,0xfc,0x09,0x10,0x09,0x10,0x15,0xfe,0x13,0x00,0x21,0x80,0x40,0x7f}}, // 進
{0x3F4B,0x906A,0xBFCB,0xE9879D,0x91DD,{0x04,0x10,0x04,0x10,0x0c,0x10,0x0a,0x10,0x11,0x10,0x3f,0x90,0x44,0xff,0x04,0x10,0x7f,0x90,0x04,0x10,0x25,0x10,0x16,0x10,0x14,0x10,0x07,0x10,0x1c,0x10,0x60,0x10}}, // 針
{0x3F4C,0x906B,0xBFCC,0xE99C87,0x9707,{0x00,0x00,0x3f,0xfc,0x01,0x00,0x7f,0xfe,0x41,0x02,0x5d,0x72,0x4f,0x3a,0x01,0x00,0x1f,0xfc,0x10,0x00,0x1f,0xf8,0x10,0x00,0x1f,0xff,0x24,0x48,0x27,0x30,0x5c,0x0e}}, // 震
{0x3F4D,0x906C,0xBFCD,0xE4BABA,0x4EBA,{0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x01,0x40,0x01,0x40,0x02,0x20,0x02,0x20,0x04,0x10,0x08,0x08,0x10,0x04,0x20,0x02,0x40,0x01}}, // 人
{0x3F4E,0x906D,0xBFCE,0xE4BB81,0x4EC1,{0x04,0x00,0x04,0x00,0x04,0x00,0x09,0xfc,0x08,0x00,0x10,0x00,0x30,0x00,0x50,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x02,0x17,0xff,0x10,0x00,0x10,0x00}}, // 仁
{0x3F4F,0x906E,0xBFCF,0xE58883,0x5203,{0x00,0x00,0x00,0x00,0x3f,0xfc,0x00,0x84,0x00,0x84,0x00,0x84,0x0c,0x84,0x03,0x04,0x01,0x84,0x02,0x44,0x02,0x24,0x04,0x04,0x08,0x04,0x10,0x08,0x20,0x30,0x00,0x00}}, // 刃
{0x3F50,0x906F,0xBFD0,0xE5A1B5,0x5875,{0x00,0x80,0x00,0x80,0x1f,0xff,0x11,0x20,0x1f,0xfc,0x11,0x24,0x1f,0xfc,0x14,0x20,0x17,0xa4,0x24,0x3a,0x27,0xa2,0x5c,0x9e,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 塵
{0x3F51,0x9070,0xBFD1,0xE5A3AC,0x58EC,{0x00,0x04,0x00,0x18,0x00,0xe0,0x1f,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x82,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x00}}, // 壬
{0x3F52,0x9071,0xBFD2,0xE5B08B,0x5C0B,{0x00,0x00,0x0f,0xf0,0x00,0x10,0x07,0xf0,0x00,0x10,0x0f,0xf0,0x00,0x3e,0x3f,0xa2,0x04,0x22,0x07,0xbe,0x38,0x10,0x7f,0xff,0x04,0x10,0x02,0x10,0x02,0x10,0x00,0x30}}, // 尋
{0x3F53,0x9072,0xBFD3,0xE7949A,0x751A,{0x04,0x10,0x1f,0xfe,0x04,0x10,0x04,0x10,0x07,0xf0,0x04,0x10,0x07,0xf0,0x04,0x10,0x04,0x10,0x7f,0xff,0x11,0x40,0x12,0x44,0x1c,0x3c,0x10,0x00,0x1f,0xfe,0x10,0x00}}, // 甚
{0x3F54,0x9073,0xBFD4,0xE5B0BD,0x5C3D,{0x00,0x00,0x0f,0xfc,0x08,0x04,0x08,0x04,0x08,0x04,0x0f,0xfc,0x08,0x80,0x08,0x40,0x0b,0x20,0x10,0x90,0x10,0x4c,0x20,0x03,0x47,0x00,0x00,0xc0,0x00,0x20,0x00,0x10}}, // 尽
{0x3F55,0x9074,0xBFD5,0xE8858E,0x814E,{0x00,0x00,0x7f,0xfc,0x48,0x44,0x7e,0x24,0x42,0x28,0x7e,0x18,0x48,0x64,0x7f,0x83,0x40,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x30}}, // 腎
{0x3F56,0x9075,0xBFD6,0xE8A88A,0x8A0A,{0x00,0x00,0x3e,0xf8,0x00,0x48,0x7f,0x48,0x00,0x48,0x3e,0x48,0x00,0x48,0x3e,0x78,0x01,0xc8,0x00,0x48,0x3e,0x48,0x22,0x48,0x22,0x89,0x22,0x85,0x3f,0x05,0x22,0x03}}, // 訊
{0x3F57,0x9076,0xBFD7,0xE8BF85,0x8FC5,{0x00,0x00,0x27,0xf8,0x10,0x08,0x10,0x88,0x00,0x88,0x00,0x88,0x00,0x88,0x7b,0xf8,0x08,0x88,0x08,0x88,0x08,0x85,0x08,0x85,0x0c,0x83,0x14,0x01,0x23,0x00,0x40,0xff}}, // 迅
{0x3F58,0x9077,0xBFD8,0xE999A3,0x9663,{0x00,0x20,0x3c,0x20,0x27,0xff,0x24,0x20,0x29,0xfc,0x31,0x24,0x29,0x24,0x25,0xfc,0x25,0x24,0x25,0x24,0x25,0xfc,0x24,0x20,0x3b,0xff,0x20,0x20,0x20,0x20,0x20,0x20}}, // 陣
{0x3F59,0x9078,0xBFD9,0xE99DAD,0x976D,{0x12,0x00,0x12,0xfe,0x7f,0x92,0x12,0x12,0x12,0x12,0x1e,0x12,0x08,0x72,0x3f,0x1a,0x29,0x16,0x29,0x12,0x3f,0x12,0x08,0x22,0x7f,0xa2,0x08,0x42,0x08,0x84,0x09,0x18}}, // 靭
{0x3F5A,0x9079,0xBFDA,0xE7ACA5,0x7B25,{0x08,0x20,0x08,0x20,0x0f,0xbf,0x14,0x48,0x22,0x44,0x40,0x80,0x7f,0xfc,0x00,0x04,0x1f,0xf4,0x00,0x04,0x0f,0xe4,0x08,0x24,0x08,0x24,0x0f,0xe4,0x00,0x04,0x00,0x38}}, // 笥
{0x3F5B,0x907A,0xBFDB,0xE8AB8F,0x8ACF,{0x00,0x00,0x3f,0xff,0x01,0x20,0x7f,0x20,0x01,0x3e,0x3d,0xf2,0x01,0x32,0x01,0x2a,0x3d,0xea,0x01,0x2c,0x3d,0x24,0x25,0x24,0x25,0xea,0x27,0x32,0x3c,0x21,0x24,0x20}}, // 諏
{0x3F5C,0x907B,0xBFDC,0xE9A088,0x9808,{0x08,0x00,0x0b,0xff,0x10,0x10,0x20,0x20,0x44,0xfe,0x04,0x82,0x08,0x82,0x08,0xfe,0x12,0x82,0x22,0xfe,0x44,0x82,0x04,0x82,0x08,0xfe,0x10,0x24,0x20,0xc2,0x43,0x01}}, // 須
{0x3F5D,0x907C,0xBFDD,0xE985A2,0x9162,{0x00,0x20,0x7f,0xa0,0x0c,0x20,0x0c,0x3f,0x3f,0x50,0x2d,0x50,0x2d,0x90,0x35,0x1e,0x37,0x10,0x21,0x10,0x21,0x10,0x3f,0x1e,0x21,0x10,0x21,0x10,0x3f,0x10,0x21,0x10}}, // 酢
{0x3F5E,0x907D,0xBFDE,0xE59BB3,0x56F3,{0x00,0x00,0x3f,0xfe,0x20,0x02,0x21,0x0a,0x28,0x8a,0x24,0x92,0x24,0x12,0x20,0x22,0x2e,0x42,0x21,0x82,0x21,0x42,0x26,0x22,0x38,0x12,0x20,0x02,0x3f,0xfe,0x20,0x02}}, // 図
{0x3F5F,0x907E,0xBFDF,0xE58EA8,0x53A8,{0x00,0x00,0x1f,0xff,0x10,0x00,0x10,0x04,0x1f,0xc4,0x10,0x04,0x17,0xff,0x14,0x84,0x14,0xc4,0x17,0xa4,0x10,0x24,0x14,0x84,0x22,0x84,0x23,0x64,0x43,0x8c,0x1c,0x04}}, // 厨
{0x3F60,0x9080,0xBFE0,0xE98097,0x9017,{0x00,0x00,0x27,0xfe,0x10,0x00,0x11,0xf8,0x01,0x08,0x01,0x08,0x01,0x08,0x79,0xf8,0x08,0x00,0x09,0x08,0x08,0x88,0x08,0x90,0x0f,0xfe,0x14,0x00,0x23,0x00,0x40,0xff}}, // 逗
{0x3F61,0x9081,0xBFE1,0xE590B9,0x5439,{0x00,0x80,0x00,0x80,0x7c,0x80,0x44,0xff,0x45,0x02,0x45,0x24,0x46,0x28,0x44,0x20,0x44,0x20,0x44,0x20,0x7c,0x50,0x44,0x50,0x40,0x88,0x01,0x04,0x06,0x02,0x18,0x01}}, // 吹
{0x3F62,0x9082,0xBFE2,0xE59E82,0x5782,{0x00,0x18,0x00,0xe0,0x1f,0x80,0x00,0x80,0x3f,0xfe,0x08,0x88,0x08,0x88,0x7f,0xff,0x08,0x88,0x08,0x88,0x08,0x88,0x3f,0xfe,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 垂
{0x3F63,0x9083,0xBFE3,0xE5B8A5,0x5E25,{0x08,0x10,0x10,0x10,0x3e,0x10,0x22,0xfe,0x22,0x92,0x22,0x92,0x3e,0x92,0x20,0x92,0x20,0x92,0x3e,0x92,0x22,0x92,0x22,0x9c,0x22,0x90,0x3e,0x90,0x22,0x10,0x20,0x10}}, // 帥
{0x3F64,0x9084,0xBFE4,0xE68EA8,0x63A8,{0x08,0x88,0x08,0x88,0x09,0x10,0x09,0xfe,0x7f,0x10,0x09,0x10,0x09,0x10,0x09,0xfe,0x0d,0x10,0x19,0x10,0x69,0xfe,0x09,0x10,0x09,0x10,0x09,0x10,0x09,0xff,0x19,0x00}}, // 推
{0x3F65,0x9085,0xBFE5,0xE6B0B4,0x6C34,{0x00,0x80,0x00,0x80,0x00,0x84,0x00,0x84,0x00,0x88,0x7e,0xd0,0x02,0xe0,0x02,0xc0,0x04,0xa0,0x04,0xa0,0x08,0x90,0x10,0x88,0x20,0x84,0x40,0x83,0x03,0x80,0x00,0x80}}, // 水
{0x3F66,0x9086,0xBFE6,0xE7828A,0x708A,{0x08,0x40,0x08,0x40,0x08,0x40,0x0a,0x7f,0x2a,0x42,0x2a,0x94,0x2c,0x90,0x29,0x10,0x48,0x10,0x0c,0x18,0x0a,0x28,0x09,0x28,0x11,0x24,0x10,0x44,0x20,0x82,0x41,0x01}}, // 炊
{0x3F67,0x9087,0xBFE7,0xE79DA1,0x7761,{0x00,0x08,0x00,0x30,0x7b,0xe0,0x48,0x20,0x4b,0xfe,0x79,0x24,0x49,0x24,0x49,0x24,0x7f,0xff,0x49,0x24,0x49,0x24,0x4b,0xfe,0x78,0x20,0x48,0x20,0x07,0xff,0x00,0x00}}, // 睡
{0x3F68,0x9088,0xBFE8,0xE7B28B,0x7C8B,{0x08,0x20,0x09,0x20,0x49,0xfc,0x2a,0x24,0x2a,0x24,0x08,0x25,0x7f,0x45,0x08,0x93,0x1c,0x10,0x1a,0x10,0x2b,0xfe,0x28,0x10,0x48,0x10,0x08,0x10,0x08,0x10,0x08,0x10}}, // 粋
{0x3F69,0x9089,0xBFE9,0xE7BFA0,0x7FE0,{0x00,0x00,0x7f,0xfe,0x11,0x22,0x0b,0x16,0x0d,0x1a,0x73,0x66,0x00,0x80,0x1f,0xfc,0x04,0x10,0x06,0x30,0x09,0xa8,0x10,0xc4,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80}}, // 翠
{0x3F6A,0x908A,0xBFEA,0xE8A1B0,0x8870,{0x00,0x80,0x00,0x80,0x3f,0xfe,0x00,0x00,0x0f,0xf8,0x08,0x08,0x7f,0xff,0x08,0x08,0x0f,0xfc,0x02,0x84,0x06,0x88,0x1a,0x50,0x62,0x20,0x02,0x10,0x03,0x8c,0x1c,0x03}}, // 衰
{0x3F6B,0x908B,0xBFEB,0xE98182,0x9042,{0x01,0x08,0x20,0x88,0x10,0x90,0x17,0xfe,0x00,0x44,0x00,0xa4,0x03,0x28,0x78,0x58,0x08,0x94,0x0b,0x34,0x08,0x52,0x09,0x91,0x0c,0x10,0x14,0x60,0x23,0x00,0x40,0xff}}, // 遂
{0x3F6C,0x908C,0xBFEC,0xE98594,0x9154,{0x00,0x20,0x7f,0x20,0x0c,0xfc,0x0c,0x24,0x3f,0x24,0x2d,0x25,0x2d,0x45,0x35,0x93,0x37,0x10,0x31,0x10,0x21,0xff,0x3f,0x10,0x21,0x10,0x21,0x10,0x3f,0x10,0x21,0x10}}, // 酔
{0x3F6D,0x908D,0xBFED,0xE98C90,0x9310,{0x08,0x24,0x08,0x24,0x14,0x48,0x12,0xff,0x21,0x48,0x7e,0x48,0x08,0x48,0x08,0x7e,0x7f,0x48,0x08,0x48,0x4a,0x7e,0x2c,0x48,0x28,0x48,0x0e,0x48,0x18,0x7f,0x60,0x40}}, // 錐
{0x3F6E,0x908E,0xBFEE,0xE98C98,0x9318,{0x08,0x04,0x08,0x18,0x14,0xf0,0x12,0x10,0x21,0xfe,0x7e,0x54,0x08,0x54,0x09,0xff,0x7e,0x54,0x08,0x54,0x4a,0x54,0x2c,0xfe,0x28,0x10,0x0e,0x10,0x19,0xff,0x60,0x00}}, // 錘
{0x3F6F,0x908F,0xBFEF,0xE99A8F,0x968F,{0x00,0x08,0x3d,0x08,0x24,0xff,0x24,0x90,0x28,0x10,0x30,0x1e,0x28,0x32,0x27,0xb2,0x24,0xde,0x24,0x92,0x24,0x9e,0x24,0x92,0x38,0xd2,0x21,0x56,0x22,0x30,0x24,0x0f}}, // 随
{0x3F70,0x9090,0xBFF0,0xE7919E,0x745E,{0x00,0x20,0x01,0x22,0x7d,0x22,0x11,0x22,0x11,0xfe,0x10,0x00,0x13,0xff,0x7c,0x20,0x10,0x40,0x11,0xfe,0x11,0x4a,0x11,0x4a,0x1d,0x4a,0x71,0x4a,0x01,0x4a,0x01,0x06}}, // 瑞
{0x3F71,0x9091,0xBFF1,0xE9AB84,0x9AC4,{0x00,0x08,0x3e,0x08,0x22,0x7f,0x2e,0x88,0x2a,0x50,0x7f,0x5e,0x41,0x32,0x7e,0x3e,0x23,0xd2,0x3e,0x52,0x22,0x5e,0x3e,0x52,0x22,0x52,0x22,0xb6,0x23,0x10,0x26,0x0f}}, // 髄
{0x3F72,0x9092,0xBFF2,0xE5B487,0x5D07,{0x21,0x04,0x21,0x04,0x3f,0xfc,0x21,0x04,0x01,0x00,0x3f,0xfe,0x20,0x04,0x4f,0xf0,0x00,0x00,0x00,0x00,0x7f,0xfe,0x04,0x90,0x18,0x8c,0x60,0x82,0x01,0x80,0x00,0x80}}, // 崇
{0x3F73,0x9093,0xBFF3,0xE5B5A9,0x5D69,{0x21,0x04,0x21,0x04,0x3f,0xfc,0x01,0x00,0x7f,0xff,0x00,0x00,0x07,0xe0,0x04,0x20,0x07,0xe0,0x00,0x00,0x3f,0xfc,0x20,0x04,0x27,0xe4,0x24,0x24,0x27,0xe4,0x20,0x0c}}, // 嵩
{0x3F74,0x9094,0xBFF4,0xE695B0,0x6570,{0x04,0xa0,0x24,0xa0,0x15,0x20,0x15,0x3f,0x7f,0xa4,0x0e,0x44,0x15,0xa4,0x24,0xa4,0x44,0x14,0x7f,0x98,0x09,0x08,0x11,0x18,0x3e,0x14,0x06,0x24,0x19,0x42,0x60,0x81}}, // 数
{0x3F75,0x9095,0xBFF5,0xE69EA2,0x67A2,{0x08,0x00,0x09,0xfe,0x09,0x00,0x7f,0x04,0x09,0x04,0x09,0x44,0x1d,0x28,0x1b,0x18,0x1b,0x08,0x29,0x14,0x29,0x24,0x49,0x44,0x09,0x80,0x09,0x00,0x09,0xff,0x09,0x00}}, // 枢
{0x3F76,0x9096,0xBFF6,0xE8B6A8,0x8DA8,{0x04,0x40,0x04,0x7e,0x04,0xa2,0x3f,0xaa,0x04,0xfa,0x04,0x22,0x7f,0x8c,0x04,0x40,0x14,0x7e,0x17,0xa2,0x14,0xaa,0x15,0xfa,0x1c,0x22,0x24,0xcc,0x23,0x00,0x40,0xff}}, // 趨
{0x3F77,0x9097,0xBFF7,0xE99B9B,0x96DB,{0x10,0x24,0x1f,0x24,0x31,0x48,0x55,0x7f,0x55,0xc8,0x7d,0x48,0x11,0x48,0x26,0x7e,0x10,0x48,0x1f,0x48,0x31,0x7e,0x55,0x48,0x55,0x48,0x7d,0x48,0x11,0x7f,0x26,0x40}}, // 雛
{0x3F78,0x9098,0xBFF8,0xE68DAE,0x636E,{0x10,0x00,0x13,0xfe,0x12,0x02,0x12,0x02,0x7f,0xfe,0x12,0x20,0x12,0x20,0x13,0xff,0x1e,0x20,0x72,0x20,0x12,0xfc,0x12,0x84,0x14,0x84,0x14,0x84,0x38,0xfc,0x10,0x84}}, // 据
{0x3F79,0x9099,0xBFF9,0xE69D89,0x6749,{0x08,0x08,0x08,0x08,0x08,0x10,0x7f,0x90,0x08,0x24,0x08,0x44,0x1c,0x08,0x1a,0x08,0x19,0x12,0x29,0x22,0x28,0x44,0x48,0x04,0x08,0x08,0x08,0x10,0x08,0x20,0x08,0xc0}}, // 杉
{0x3F7A,0x909A,0xBFFA,0xE6A499,0x6919,{0x08,0x00,0x08,0xfc,0x08,0x84,0x7e,0x84,0x08,0xfc,0x08,0x84,0x1c,0x84,0x1a,0xfc,0x1a,0x00,0x29,0xfe,0x29,0x02,0x49,0x02,0x09,0xfe,0x09,0x02,0x09,0xfe,0x09,0x02}}, // 椙
{0x3F7B,0x909B,0xBFFB,0xE88F85,0x83C5,{0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x00,0x80,0x1f,0xfe,0x10,0x04,0x27,0xf0,0x04,0x10,0x07,0xf0,0x04,0x00,0x07,0xf8,0x04,0x08,0x04,0x08,0x07,0xf8,0x04,0x08}}, // 菅
{0x3F7C,0x909C,0xBFFC,0xE9A097,0x9817,{0x04,0x00,0x04,0xff,0x04,0x10,0x3f,0xa0,0x25,0x7e,0x24,0x42,0x3f,0x42,0x29,0x7e,0x29,0x42,0x25,0x7e,0x26,0x42,0x22,0x42,0x25,0x7e,0x49,0x24,0x10,0x42,0x21,0x81}}, // 頗
{0x3F7D,0x909D,0xBFFD,0xE99B80,0x96C0,{0x00,0x80,0x04,0x88,0x04,0x84,0x08,0xa2,0x10,0xa2,0x61,0xc0,0x00,0x90,0x03,0x20,0x0f,0xfe,0x78,0x40,0x0f,0xfc,0x08,0x40,0x0f,0xfc,0x08,0x40,0x0f,0xfe,0x08,0x00}}, // 雀
{0x3F7E,0x909E,0xBFFE,0xE8A3BE,0x88FE,{0x10,0x00,0x10,0xfe,0x10,0x82,0x7c,0x82,0x04,0xfe,0x08,0x90,0x0a,0x90,0x12,0xff,0x1c,0x90,0x34,0x90,0x52,0xfe,0x10,0xc2,0x11,0x42,0x11,0x42,0x12,0x7e,0x10,0x42}}, // 裾
{0x4021,0x909F,0xC0A1,0xE6BE84,0x6F84,{0x11,0xd2,0x08,0x54,0x0a,0x89,0x02,0x8a,0x01,0x04,0x43,0xfe,0x24,0x01,0x21,0xf8,0x09,0x08,0x09,0x08,0x11,0xf8,0x11,0x08,0x20,0x88,0x20,0x90,0x4f,0xff,0x40,0x00}}, // 澄
{0x4022,0x90A0,0xC0A2,0xE691BA,0x647A,{0x10,0x00,0x17,0xfe,0x12,0x52,0x11,0x4a,0x7c,0xc6,0x11,0x4a,0x16,0x72,0x10,0xc6,0x1c,0x20,0x71,0xfc,0x11,0x04,0x11,0x04,0x11,0xfc,0x11,0x04,0x31,0xfc,0x11,0x04}}, // 摺
{0x4023,0x90A1,0xC0A3,0xE5AFB8,0x5BF8,{0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x3f,0xff,0x00,0x10,0x00,0x10,0x08,0x10,0x04,0x10,0x02,0x10,0x02,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x70,0x00,0x10}}, // 寸
{0x4024,0x90A2,0xC0A4,0xE4B896,0x4E16,{0x00,0x00,0x08,0x88,0x08,0x88,0x08,0x88,0x08,0x88,0x7f,0xff,0x08,0x88,0x08,0x88,0x08,0x88,0x08,0x88,0x08,0xf8,0x08,0x88,0x08,0x00,0x08,0x00,0x0f,0xfe,0x08,0x00}}, // 世
{0x4025,0x90A3,0xC0A5,0xE780AC,0x702C,{0x21,0x00,0x11,0x3f,0x11,0x04,0x0f,0xe8,0x41,0x1e,0x27,0xd2,0x25,0x52,0x05,0x5e,0x15,0x52,0x17,0xde,0x11,0x12,0x23,0x92,0x23,0x5e,0x25,0x14,0x49,0x22,0x41,0x41}}, // 瀬
{0x4026,0x90A4,0xC0A6,0xE7959D,0x755D,{0x08,0x20,0x08,0x20,0x08,0x3c,0x7f,0xa4,0x00,0x24,0x3f,0x44,0x29,0x44,0x29,0x88,0x29,0x08,0x3f,0x08,0x29,0x14,0x29,0x14,0x29,0x22,0x3f,0x42,0x20,0x81,0x01,0x01}}, // 畝
{0x4027,0x90A5,0xC0A7,0xE698AF,0x662F,{0x00,0x00,0x07,0xf8,0x04,0x08,0x07,0xf8,0x04,0x08,0x04,0x08,0x07,0xf8,0x00,0x00,0x7f,0xff,0x04,0x80,0x04,0x80,0x04,0xfc,0x0a,0x80,0x09,0x80,0x10,0x60,0x20,0x1f}}, // 是
{0x4028,0x90A6,0xC0A8,0xE58784,0x51C4,{0x00,0x40,0x20,0x40,0x17,0xfe,0x10,0x40,0x13,0xf8,0x00,0x48,0x0f,0xff,0x00,0x48,0x0b,0xf8,0x10,0x80,0x1f,0xff,0x20,0x88,0x21,0x10,0x43,0xf0,0x40,0xc8,0x0f,0x04}}, // 凄
{0x4029,0x90A7,0xC0A9,0xE588B6,0x5236,{0x02,0x02,0x12,0x12,0x12,0x12,0x1f,0xd2,0x22,0x12,0x22,0x12,0x7f,0xf2,0x02,0x12,0x1f,0xd2,0x12,0x52,0x12,0x52,0x12,0x52,0x12,0x42,0x13,0x82,0x12,0x0e,0x02,0x02}}, // 制
{0x402A,0x90A8,0xC0AA,0xE58BA2,0x52E2,{0x04,0x10,0x3f,0x10,0x04,0x10,0x7f,0xfc,0x15,0x14,0x15,0xd4,0x3f,0x24,0x44,0xb4,0x07,0x4d,0x79,0x85,0x01,0x03,0x3f,0xf8,0x01,0x08,0x02,0x08,0x0c,0x08,0x30,0x30}}, // 勢
{0x402B,0x90A9,0xC0AB,0xE5A793,0x59D3,{0x08,0x10,0x08,0x90,0x08,0x90,0x08,0x90,0x7e,0xfe,0x12,0x90,0x13,0x10,0x12,0x10,0x22,0x10,0x24,0xfe,0x7c,0x10,0x06,0x10,0x0a,0x10,0x10,0x10,0x63,0xff,0x00,0x00}}, // 姓
{0x402C,0x90AA,0xC0AC,0xE5BE81,0x5F81,{0x04,0x00,0x07,0xfe,0x08,0x20,0x08,0x20,0x10,0x20,0x25,0x20,0x45,0x20,0x09,0x3e,0x09,0x20,0x19,0x20,0x29,0x20,0x49,0x20,0x09,0x20,0x09,0x20,0x0f,0xff,0x08,0x00}}, // 征
{0x402D,0x90AB,0xC0AD,0xE680A7,0x6027,{0x08,0x20,0x08,0xa0,0x08,0xa0,0x08,0xa0,0x09,0xfe,0x2d,0x20,0x2b,0x20,0x2a,0x20,0x48,0x20,0x09,0xfc,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x0b,0xff,0x08,0x00}}, // 性
{0x402E,0x90AC,0xC0AE,0xE68890,0x6210,{0x00,0x24,0x00,0x22,0x00,0x22,0x1f,0xff,0x10,0x20,0x10,0x20,0x10,0x24,0x1f,0x24,0x11,0x14,0x11,0x14,0x11,0x18,0x11,0x18,0x11,0x29,0x26,0x45,0x20,0x83,0x40,0x01}}, // 成
{0x402F,0x90AD,0xC0AF,0xE694BF,0x653F,{0x00,0x20,0x00,0x20,0x7f,0xa0,0x04,0x3f,0x04,0x44,0x04,0x44,0x14,0xc4,0x17,0x44,0x14,0x28,0x14,0x28,0x14,0x10,0x15,0x90,0x16,0x28,0x18,0x44,0x61,0x82,0x06,0x01}}, // 政
{0x4030,0x90AE,0xC0B0,0xE695B4,0x6574,{0x04,0x20,0x7f,0xa0,0x04,0x3f,0x3f,0x64,0x25,0x54,0x3f,0x94,0x0e,0x08,0x15,0x34,0x64,0xc2,0x04,0x01,0x1f,0xfc,0x00,0x80,0x08,0xf8,0x08,0x80,0x7f,0xff,0x00,0x00}}, // 整
{0x4031,0x90AF,0xC0B1,0xE6989F,0x661F,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x04,0x80,0x04,0x80,0x0f,0xfc,0x10,0x80,0x2f,0xfc,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 星
{0x4032,0x90B0,0xC0B2,0xE699B4,0x6674,{0x00,0x20,0x00,0x20,0x3d,0xfe,0x24,0x20,0x25,0xfc,0x24,0x20,0x3f,0xff,0x24,0x00,0x24,0xfc,0x24,0x84,0x24,0xfc,0x3c,0x84,0x00,0xfc,0x00,0x84,0x00,0x84,0x00,0x8c}}, // 晴
{0x4033,0x90B1,0xC0B3,0xE6A3B2,0x68F2,{0x08,0x20,0x08,0x20,0x09,0xff,0x7e,0x20,0x09,0xfc,0x08,0x24,0x19,0xff,0x1c,0x24,0x1b,0xfc,0x28,0x20,0x2b,0xff,0x48,0x48,0x08,0x88,0x09,0xf0,0x08,0x28,0x09,0xc4}}, // 棲
{0x4034,0x90B2,0xC0B4,0xE6A096,0x6816,{0x08,0x00,0x0b,0xfe,0x08,0x50,0x7e,0x50,0x09,0xfe,0x09,0x52,0x1d,0x52,0x1b,0x52,0x19,0x52,0x29,0x8e,0x29,0x02,0x49,0x02,0x09,0x02,0x09,0xfe,0x09,0x02,0x08,0x00}}, // 栖
{0x4035,0x90B3,0xC0B5,0xE6ADA3,0x6B63,{0x00,0x00,0x3f,0xfe,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x08,0x80,0x08,0xfc,0x08,0x80,0x08,0x80,0x08,0x80,0x08,0x80,0x08,0x80,0x08,0x80,0x7f,0xff,0x00,0x00}}, // 正
{0x4036,0x90B4,0xC0B6,0xE6B885,0x6E05,{0x10,0x20,0x08,0x20,0x0b,0xfe,0x00,0x20,0x01,0xfc,0x40,0x20,0x27,0xff,0x20,0x00,0x09,0xfc,0x09,0x04,0x11,0xfc,0x11,0x04,0x21,0xfc,0x21,0x04,0x41,0x04,0x41,0x0c}}, // 清
{0x4037,0x90B5,0xC0B7,0xE789B2,0x7272,{0x04,0x10,0x14,0x90,0x14,0x90,0x14,0x90,0x1e,0xfe,0x24,0x90,0x25,0x10,0x45,0x10,0x06,0x10,0x0d,0xfe,0x34,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x07,0xff,0x04,0x00}}, // 牲
{0x4038,0x90B6,0xC0B8,0xE7949F,0x751F,{0x00,0x80,0x08,0x80,0x08,0x80,0x08,0x80,0x0f,0xfe,0x10,0x80,0x10,0x80,0x20,0x80,0x40,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 生
{0x4039,0x90B7,0xC0B9,0xE79B9B,0x76DB,{0x00,0x28,0x00,0x24,0x1f,0xfe,0x10,0x20,0x1f,0x24,0x11,0x18,0x11,0x12,0x21,0x2a,0x26,0xc6,0x40,0x02,0x1f,0xf8,0x12,0x48,0x12,0x48,0x12,0x48,0x7f,0xfe,0x00,0x00}}, // 盛
{0x403A,0x90B8,0xC0BA,0xE7B2BE,0x7CBE,{0x08,0x20,0x4a,0x20,0x2b,0xfe,0x2a,0x20,0x2c,0xfc,0x08,0x20,0x7f,0xff,0x08,0x00,0x1c,0xfc,0x1a,0x84,0x2a,0xfc,0x28,0x84,0x48,0xfc,0x08,0x84,0x08,0x84,0x08,0x8c}}, // 精
{0x403B,0x90B9,0xC0BB,0xE88196,0x8056,{0x00,0x00,0x7f,0xfe,0x11,0x22,0x1f,0x22,0x11,0x22,0x1f,0x22,0x11,0x22,0x1f,0x3e,0x71,0x22,0x01,0x00,0x3f,0xfe,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 聖
{0x403C,0x90BA,0xC0BC,0xE5A3B0,0x58F0,{0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x3f,0xfe,0x00,0x00,0x1f,0xfc,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x04,0x10,0x00,0x20,0x00,0x20,0x00,0x40,0x00}}, // 声
{0x403D,0x90BB,0xC0BD,0xE8A3BD,0x88FD,{0x14,0x04,0x1f,0xa4,0x24,0x24,0x3f,0xa4,0x44,0x24,0x3f,0xa4,0x24,0xa4,0x25,0x8c,0x04,0x80,0x7f,0xff,0x02,0x88,0x0c,0x50,0x74,0x20,0x04,0x10,0x0f,0x0c,0x30,0x03}}, // 製
{0x403E,0x90BC,0xC0BE,0xE8A5BF,0x897F,{0x00,0x00,0x7f,0xff,0x02,0x20,0x02,0x20,0x02,0x20,0x3f,0xfe,0x22,0x22,0x22,0x22,0x22,0x22,0x24,0x22,0x24,0x1e,0x28,0x02,0x30,0x02,0x3f,0xfe,0x20,0x02,0x00,0x00}}, // 西
{0x403F,0x90BD,0xC0BF,0xE8AAA0,0x8AA0,{0x00,0x08,0x3e,0x0a,0x00,0x09,0x7f,0xff,0x00,0x88,0x3e,0x88,0x00,0xea,0x00,0xaa,0x3e,0xaa,0x00,0xac,0x3e,0xa4,0x22,0xa4,0x22,0xed,0x22,0x95,0x3f,0x23,0x22,0x41}}, // 誠
{0x4040,0x90BE,0xC0C0,0xE8AA93,0x8A93,{0x08,0x0c,0x7e,0xf0,0x08,0x80,0x0c,0xff,0x78,0x88,0x09,0x08,0x1b,0xe8,0x00,0x00,0x7f,0xff,0x00,0x00,0x07,0xf0,0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 誓
{0x4041,0x90BF,0xC0C1,0xE8AB8B,0x8ACB,{0x00,0x10,0x3e,0x10,0x00,0xfe,0x7f,0x10,0x00,0xfe,0x3e,0x10,0x01,0xff,0x00,0x00,0x3e,0x7c,0x00,0x44,0x3e,0x7c,0x22,0x44,0x22,0x7c,0x22,0x44,0x3e,0x44,0x22,0x4c}}, // 請
{0x4042,0x90C0,0xC0C2,0xE9809D,0x901D,{0x01,0x04,0x21,0x38,0x11,0x20,0x11,0x20,0x07,0xff,0x01,0x24,0x01,0x24,0x79,0xe4,0x0f,0x24,0x09,0x24,0x09,0x44,0x09,0x84,0x17,0x04,0x12,0x04,0x21,0x80,0x40,0x7f}}, // 逝
{0x4043,0x90C1,0xC0C3,0xE98692,0x9192,{0x00,0x00,0x7f,0xfe,0x0c,0x42,0x0c,0x7e,0x3f,0x42,0x2d,0x42,0x2d,0x7e,0x35,0x10,0x37,0x50,0x21,0x7e,0x21,0x90,0x3f,0x7e,0x21,0x10,0x21,0x10,0x3f,0xff,0x21,0x00}}, // 醒
{0x4044,0x90C2,0xC0C4,0xE99D92,0x9752,{0x00,0x80,0x00,0x80,0x1f,0xfe,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x00,0x07,0xf8,0x04,0x08,0x07,0xf8,0x04,0x08,0x07,0xf8,0x04,0x08,0x04,0x08,0x04,0x18}}, // 青
{0x4045,0x90C3,0xC0C5,0xE99D99,0x9759,{0x08,0x20,0x08,0x38,0x7f,0x48,0x08,0x90,0x3f,0x20,0x08,0xfc,0x7f,0x24,0x00,0x24,0x3f,0xff,0x22,0x24,0x3e,0x24,0x22,0xfc,0x3e,0x24,0x22,0x20,0x22,0x60,0x26,0x20}}, // 静
{0x4046,0x90C4,0xC0C6,0xE69689,0x6589,{0x00,0x80,0x00,0x80,0x7f,0xff,0x02,0x10,0x01,0x20,0x00,0xc0,0x03,0x30,0x0c,0x0c,0x77,0xfb,0x04,0x08,0x04,0x08,0x07,0xf8,0x04,0x08,0x08,0x08,0x08,0x08,0x10,0x08}}, // 斉
{0x4047,0x90C5,0xC0C7,0xE7A88E,0x7A0E,{0x02,0x04,0x0c,0x84,0x38,0x48,0x08,0x50,0x08,0xfc,0x7f,0x84,0x08,0x84,0x08,0x84,0x1c,0xfc,0x1a,0x28,0x29,0x28,0x28,0x28,0x48,0x48,0x08,0x49,0x08,0x89,0x09,0x07}}, // 税
{0x4048,0x90C6,0xC0C8,0xE88486,0x8106,{0x00,0x40,0x3c,0x78,0x24,0x90,0x25,0x20,0x27,0xfe,0x3d,0x00,0x25,0x00,0x25,0x7c,0x25,0x44,0x3d,0x44,0x25,0x44,0x25,0x58,0x25,0x42,0x26,0x42,0x2c,0x42,0x44,0x3e}}, // 脆
{0x4049,0x90C7,0xC0C9,0xE99ABB,0x96BB,{0x08,0x20,0x08,0x40,0x1f,0xfc,0x10,0x80,0x3f,0xf8,0x50,0x80,0x1f,0xf8,0x10,0x80,0x1f,0xfe,0x00,0x00,0x3f,0xf8,0x04,0x10,0x03,0x60,0x01,0x80,0x06,0x70,0x78,0x0f}}, // 隻
{0x404A,0x90C8,0xC0CA,0xE5B8AD,0x5E2D,{0x00,0x40,0x00,0x40,0x1f,0xff,0x11,0x10,0x11,0x10,0x1f,0xfe,0x11,0x10,0x11,0x10,0x11,0xf0,0x10,0x40,0x17,0xfc,0x14,0x44,0x24,0x44,0x24,0x44,0x44,0x58,0x00,0x40}}, // 席
{0x404B,0x90C9,0xC0CB,0xE6839C,0x60DC,{0x08,0x48,0x08,0x48,0x09,0xfe,0x08,0x48,0x0c,0x48,0x2a,0x48,0x2b,0xff,0x28,0x00,0x48,0xfc,0x08,0x84,0x08,0x84,0x08,0xfc,0x08,0x84,0x08,0x84,0x08,0xfc,0x08,0x84}}, // 惜
{0x404C,0x90CA,0xC0CC,0xE6889A,0x621A,{0x00,0x28,0x00,0x24,0x00,0x24,0x1f,0xff,0x11,0x20,0x11,0x22,0x11,0xe2,0x11,0x12,0x1f,0xf4,0x11,0x14,0x15,0x88,0x15,0x48,0x19,0x5a,0x21,0x26,0x23,0x46,0x40,0x82}}, // 戚
{0x404D,0x90CB,0xC0CD,0xE696A5,0x65A5,{0x00,0x10,0x00,0x60,0x0f,0x80,0x08,0x00,0x08,0x00,0x0f,0xff,0x08,0x40,0x08,0x40,0x0f,0x40,0x08,0xf0,0x10,0x4c,0x10,0x42,0x20,0x40,0x40,0x40,0x00,0x40,0x00,0x40}}, // 斥
{0x404E,0x90CC,0xC0CE,0xE69894,0x6614,{0x02,0x20,0x02,0x20,0x1f,0xfc,0x02,0x20,0x02,0x20,0x02,0x20,0x7f,0xff,0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 昔
{0x404F,0x90CD,0xC0CF,0xE69E90,0x6790,{0x08,0x04,0x08,0x18,0x08,0xe0,0x7f,0x80,0x08,0x80,0x08,0xff,0x1c,0x88,0x1a,0x88,0x1a,0x88,0x28,0x88,0x28,0x88,0x48,0x88,0x09,0x08,0x09,0x08,0x0a,0x08,0x08,0x08}}, // 析
{0x4050,0x90CE,0xC0D0,0xE79FB3,0x77F3,{0x00,0x00,0x3f,0xff,0x01,0x00,0x01,0x00,0x01,0x00,0x02,0x00,0x02,0x00,0x07,0xfc,0x04,0x04,0x0c,0x04,0x0c,0x04,0x14,0x04,0x24,0x04,0x44,0x04,0x07,0xfc,0x04,0x04}}, // 石
{0x4051,0x90CF,0xC0D1,0xE7A98D,0x7A4D,{0x02,0x20,0x0d,0xfe,0x78,0x20,0x09,0xfc,0x08,0x20,0x7f,0xff,0x08,0x00,0x08,0xfc,0x1c,0x84,0x1a,0xfc,0x2a,0x84,0x28,0xfc,0x48,0x84,0x08,0xfc,0x08,0x4c,0x09,0x82}}, // 積
{0x4052,0x90D0,0xC0D2,0xE7B18D,0x7C4D,{0x10,0x20,0x1f,0xbf,0x24,0x48,0x42,0x84,0x08,0x24,0x3e,0xff,0x08,0x24,0x3e,0x24,0x08,0xff,0x7f,0x00,0x08,0x7e,0x1c,0x42,0x1a,0x7e,0x29,0x42,0x48,0x7e,0x08,0x42}}, // 籍
{0x4053,0x90D1,0xC0D3,0xE7B8BE,0x7E3E,{0x08,0x10,0x09,0xff,0x0a,0x10,0x72,0xfe,0x14,0x10,0x09,0xff,0x0c,0x00,0x12,0x7c,0x7d,0x44,0x09,0x7c,0x28,0x44,0x2a,0x7c,0x29,0x44,0x29,0x7c,0x48,0x4c,0x09,0x82}}, // 績
{0x4054,0x90D2,0xC0D4,0xE8848A,0x810A,{0x00,0x80,0x00,0x80,0x3d,0x5e,0x01,0x40,0x3a,0x2e,0x04,0x10,0x1f,0xfc,0x64,0x13,0x04,0x10,0x07,0xf0,0x04,0x10,0x04,0x10,0x07,0xf0,0x04,0x10,0x04,0x10,0x04,0x30}}, // 脊
{0x4055,0x90D3,0xC0D5,0xE8B2AC,0x8CAC,{0x00,0x80,0x1f,0xfe,0x00,0x80,0x0f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x00,0x07,0xf8,0x04,0x08,0x07,0xf8,0x04,0x08,0x07,0xf8,0x04,0x08,0x07,0xf8,0x02,0x30,0x1c,0x0e}}, // 責
{0x4056,0x90D4,0xC0D6,0xE8B5A4,0x8D64,{0x00,0x80,0x00,0x80,0x0f,0xf8,0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0x20,0x09,0x28,0x09,0x24,0x09,0x24,0x11,0x22,0x22,0x22,0x02,0x20,0x04,0x60,0x08,0x20}}, // 赤
{0x4057,0x90D5,0xC0D7,0xE8B7A1,0x8DE1,{0x00,0x10,0x3e,0x10,0x22,0x10,0x23,0xff,0x22,0x28,0x22,0x28,0x3e,0x28,0x08,0xac,0x28,0xaa,0x2e,0xaa,0x29,0x29,0x2a,0x29,0x28,0x48,0x2e,0x48,0x38,0x98,0x61,0x08}}, // 跡
{0x4058,0x90D6,0xC0D8,0xE8B99F,0x8E5F,{0x00,0x10,0x3e,0xfe,0x22,0x10,0x22,0xfe,0x22,0x10,0x23,0xff,0x3e,0x00,0x08,0x7c,0x28,0x44,0x2f,0x7c,0x28,0x44,0x28,0x7c,0x29,0x44,0x2e,0x7c,0x38,0x46,0x61,0x81}}, // 蹟
{0x4059,0x90D7,0xC0D9,0xE7A2A9,0x78A9,{0x00,0x00,0x7f,0xff,0x04,0x10,0x04,0x20,0x08,0x7e,0x08,0x42,0x1f,0x42,0x11,0x7e,0x31,0x42,0x51,0x7e,0x11,0x42,0x11,0x42,0x1f,0x7e,0x11,0x24,0x10,0xc2,0x03,0x01}}, // 碩
{0x405A,0x90D8,0xC0DA,0xE58887,0x5207,{0x10,0x00,0x11,0xfe,0x10,0x22,0x10,0x22,0x13,0x22,0x1c,0x22,0x70,0x22,0x10,0x22,0x10,0x22,0x10,0x22,0x12,0x42,0x12,0x42,0x0e,0x82,0x01,0x02,0x02,0x04,0x0c,0x18}}, // 切
{0x405B,0x90D9,0xC0DB,0xE68B99,0x62D9,{0x10,0x20,0x10,0x20,0x11,0x22,0x11,0x22,0x7d,0x22,0x11,0x22,0x11,0xfe,0x11,0x22,0x1c,0x20,0x70,0x20,0x11,0x22,0x11,0x22,0x11,0x22,0x11,0x22,0x11,0xfe,0x31,0x02}}, // 拙
{0x405C,0x90DA,0xC0DC,0xE68EA5,0x63A5,{0x10,0x20,0x10,0x20,0x13,0xfe,0x11,0x08,0x7c,0x88,0x10,0x90,0x17,0xff,0x10,0x40,0x10,0x40,0x1f,0xff,0x70,0x88,0x10,0x88,0x13,0xd0,0x10,0x30,0x10,0xcc,0x37,0x02}}, // 接
{0x405D,0x90DB,0xC0DD,0xE69182,0x6442,{0x10,0x00,0x13,0xfe,0x10,0x88,0x10,0xf8,0x7c,0x88,0x10,0xf8,0x10,0x88,0x10,0xfe,0x1f,0x08,0x70,0x04,0x11,0x88,0x10,0x50,0x10,0x00,0x10,0x58,0x11,0x84,0x36,0x02}}, // 摂
{0x405E,0x90DC,0xC0DE,0xE68A98,0x6298,{0x08,0x04,0x08,0x18,0x08,0xe0,0x08,0x80,0x7e,0x80,0x08,0xff,0x08,0x88,0x08,0x88,0x0e,0x88,0x78,0x88,0x08,0x88,0x08,0x88,0x09,0x08,0x09,0x08,0x1a,0x08,0x08,0x08}}, // 折
{0x405F,0x90DD,0xC0DF,0xE8A8AD,0x8A2D,{0x00,0x00,0x3e,0x7c,0x00,0x44,0x7f,0x44,0x00,0x45,0x3e,0x85,0x01,0x03,0x3e,0x00,0x01,0xfc,0x00,0x44,0x3e,0x48,0x22,0x28,0x22,0x10,0x22,0x28,0x3e,0xc4,0x23,0x03}}, // 設
{0x4060,0x90DE,0xC0E0,0xE7AA83,0x7A83,{0x01,0x00,0x01,0x00,0x7f,0xfe,0x42,0x42,0x42,0x42,0x04,0x44,0x18,0x3c,0x70,0x00,0x11,0xfc,0x1e,0x44,0x70,0x44,0x10,0x44,0x12,0x84,0x0e,0x84,0x01,0x04,0x06,0x18}}, // 窃
{0x4061,0x90DF,0xC0E1,0xE7AF80,0x7BC0,{0x10,0x40,0x10,0x40,0x3f,0x7e,0x28,0xa0,0x45,0x10,0x00,0x00,0x3f,0x7c,0x21,0x44,0x3f,0x44,0x21,0x44,0x3f,0x44,0x24,0x44,0x22,0x44,0x3d,0x58,0x61,0x40,0x00,0x40}}, // 節
{0x4062,0x90E0,0xC0E2,0xE8AAAC,0x8AAC,{0x00,0x84,0x1c,0x44,0x00,0x44,0x7f,0x28,0x00,0xfc,0x3e,0x84,0x00,0x84,0x3e,0x84,0x00,0xfc,0x00,0x28,0x3e,0x28,0x22,0x28,0x22,0x48,0x22,0x49,0x3e,0x89,0x23,0x07}}, // 説
{0x4063,0x90E1,0xC0E3,0xE99BAA,0x96EA,{0x00,0x00,0x3f,0xfc,0x00,0x80,0x3f,0xfe,0x20,0x82,0x3e,0xbc,0x40,0x80,0x1e,0xbc,0x00,0x00,0x1f,0xf8,0x00,0x08,0x0f,0xf8,0x00,0x08,0x00,0x08,0x1f,0xf8,0x00,0x08}}, // 雪
{0x4064,0x90E2,0xC0E4,0xE7B5B6,0x7D76,{0x08,0x20,0x08,0x3c,0x0a,0x48,0x72,0x48,0x14,0x90,0x09,0xfe,0x0c,0x92,0x12,0x92,0x7e,0x92,0x09,0xfe,0x2c,0x82,0x2a,0x80,0x2a,0x81,0x48,0x41,0x08,0x3f,0x08,0x00}}, // 絶
{0x4065,0x90E3,0xC0E5,0xE8888C,0x820C,{0x00,0x18,0x00,0xe0,0x1f,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 舌
{0x4066,0x90E4,0xC0E6,0xE89D89,0x8749,{0x08,0x22,0x08,0x92,0x08,0x54,0x08,0x7e,0x3f,0x52,0x29,0x52,0x29,0x7e,0x29,0x52,0x3f,0x52,0x08,0x7e,0x0c,0x10,0x0a,0x10,0x09,0xff,0x0f,0x10,0x70,0x90,0x00,0x10}}, // 蝉
{0x4067,0x90E5,0xC0E7,0xE4BB99,0x4ED9,{0x04,0x20,0x04,0x20,0x04,0x20,0x08,0x20,0x0a,0x22,0x12,0x22,0x12,0x22,0x32,0x22,0x52,0x22,0x12,0x22,0x12,0x22,0x12,0x22,0x12,0x22,0x12,0x22,0x13,0xfe,0x12,0x02}}, // 仙
{0x4068,0x90E6,0xC0E8,0xE58588,0x5148,{0x00,0x80,0x04,0x80,0x04,0x80,0x07,0xfc,0x08,0x80,0x08,0x80,0x10,0x80,0x7f,0xff,0x01,0x20,0x01,0x20,0x01,0x20,0x02,0x20,0x02,0x20,0x04,0x21,0x08,0x11,0x30,0x0f}}, // 先
{0x4069,0x90E7,0xC0E9,0xE58D83,0x5343,{0x00,0x08,0x00,0x30,0x1f,0xc0,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x82,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 千
{0x406A,0x90E8,0xC0EA,0xE58DA0,0x5360,{0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0xff,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x1f,0xf8,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x08}}, // 占
{0x406B,0x90E9,0xC0EB,0xE5AEA3,0x5BA3,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x3f,0xf8,0x40,0x00,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x00,0x00,0x7f,0xfe,0x00,0x00}}, // 宣
{0x406C,0x90EA,0xC0EC,0xE5B082,0x5C02,{0x00,0x80,0x7f,0xfe,0x00,0x80,0x1f,0xf8,0x10,0x88,0x1f,0xf8,0x10,0x88,0x10,0x88,0x1f,0xf8,0x00,0x20,0x7f,0xff,0x04,0x20,0x02,0x20,0x02,0x20,0x00,0x20,0x00,0x60}}, // 専
{0x406D,0x90EB,0xC0ED,0xE5B096,0x5C16,{0x00,0x80,0x00,0x80,0x02,0xa0,0x04,0x98,0x08,0x84,0x30,0x82,0x00,0x80,0x01,0x80,0x00,0x00,0x00,0x80,0x7f,0xff,0x00,0x80,0x01,0x40,0x02,0x20,0x0c,0x18,0x70,0x07}}, // 尖
{0x406E,0x90EC,0xC0EE,0xE5B79D,0x5DDD,{0x00,0x04,0x10,0x04,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x20,0x04,0x20,0x04,0x40,0x04,0x00,0x04}}, // 川
{0x406F,0x90ED,0xC0EF,0xE688A6,0x6226,{0x08,0x90,0x24,0x94,0x15,0x12,0x12,0x12,0x3f,0x9f,0x24,0xf0,0x24,0x92,0x3f,0x92,0x24,0x92,0x3f,0x94,0x04,0x0c,0x04,0x08,0x7f,0xcd,0x04,0x15,0x04,0x23,0x04,0x41}}, // 戦
{0x4070,0x90EE,0xC0F0,0xE68987,0x6247,{0x00,0x00,0x7f,0xff,0x00,0x00,0x1f,0xfc,0x10,0x04,0x10,0x04,0x1f,0xfc,0x10,0x00,0x1f,0xbe,0x10,0x82,0x18,0xa2,0x14,0x92,0x22,0x86,0x2c,0x9a,0x50,0xa2,0x01,0x86}}, // 扇
{0x4071,0x90EF,0xC0F1,0xE692B0,0x64B0,{0x10,0x00,0x13,0xde,0x10,0x42,0x13,0xde,0x7e,0x10,0x12,0x31,0x11,0xef,0x10,0x00,0x1c,0x88,0x73,0xfe,0x10,0x88,0x10,0x88,0x17,0xff,0x10,0x88,0x11,0x04,0x36,0x02}}, // 撰
{0x4072,0x90F0,0xC0F2,0xE6A093,0x6813,{0x08,0x20,0x08,0x30,0x08,0x50,0x7f,0x48,0x08,0x84,0x09,0x02,0x1a,0xfd,0x1c,0x20,0x1a,0x20,0x2a,0x20,0x29,0xfc,0x48,0x20,0x08,0x20,0x08,0x20,0x0b,0xff,0x08,0x00}}, // 栓
{0x4073,0x90F1,0xC0F3,0xE6A0B4,0x6834,{0x08,0x40,0x08,0x40,0x08,0x7f,0x7e,0x80,0x09,0x00,0x0a,0xfe,0x18,0x92,0x1c,0x92,0x1a,0x92,0x2a,0x92,0x29,0xff,0x48,0x82,0x08,0x82,0x08,0x82,0x08,0x86,0x08,0x82}}, // 栴
{0x4074,0x90F2,0xC0F4,0xE6B389,0x6CC9,{0x00,0x40,0x00,0x80,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xfa,0x00,0x82,0x3e,0xc4,0x02,0xa8,0x04,0x90,0x18,0x8c,0x63,0x83,0x00,0x80}}, // 泉
{0x4075,0x90F3,0xC0F5,0xE6B585,0x6D45,{0x10,0x48,0x08,0x44,0x08,0x7c,0x03,0xc0,0x40,0x40,0x20,0x7c,0x23,0xc0,0x00,0x20,0x08,0x3e,0x0b,0xe4,0x10,0x24,0x10,0x18,0x20,0x12,0x20,0x6a,0x43,0x86,0x40,0x02}}, // 浅
{0x4076,0x90F4,0xC0F6,0xE6B497,0x6D17,{0x10,0x20,0x09,0x20,0x09,0x20,0x01,0xfe,0x41,0x20,0x22,0x20,0x24,0x20,0x07,0xff,0x00,0x50,0x08,0x50,0x10,0x50,0x10,0x90,0x20,0x90,0x21,0x11,0x42,0x09,0x44,0x07}}, // 洗
{0x4077,0x90F5,0xC0F7,0xE69F93,0x67D3,{0x00,0x40,0x18,0x40,0x05,0xf8,0x60,0x48,0x10,0x48,0x00,0x48,0x04,0x8a,0x19,0x0a,0x62,0x06,0x00,0x80,0x7f,0xff,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80}}, // 染
{0x4078,0x90F6,0xC0F8,0xE6BD9C,0x6F5C,{0x11,0x04,0x09,0x04,0x0f,0xdf,0x01,0x04,0x07,0xdf,0x41,0x04,0x22,0x8a,0x24,0x51,0x08,0x00,0x09,0xfc,0x11,0x04,0x11,0x04,0x21,0xfc,0x21,0x04,0x41,0xfc,0x41,0x04}}, // 潜
{0x4079,0x90F7,0xC0F9,0xE7858E,0x714E,{0x04,0x08,0x02,0x10,0x7f,0xff,0x00,0x00,0x1f,0x22,0x11,0x22,0x1f,0x22,0x11,0x22,0x1f,0x22,0x11,0x02,0x11,0x02,0x13,0x06,0x00,0x00,0x12,0x24,0x21,0x12,0x41,0x11}}, // 煎
{0x407A,0x90F8,0xC0FA,0xE785BD,0x717D,{0x08,0x00,0x0b,0xff,0x08,0x00,0x0a,0xfe,0x2a,0x82,0x2a,0x82,0x2c,0xfe,0x48,0x80,0x08,0xff,0x0c,0x91,0x0a,0x99,0x13,0x55,0x11,0x33,0x12,0x55,0x24,0x99,0x40,0x33}}, // 煽
{0x407B,0x90F9,0xC0FB,0xE6978B,0x65CB,{0x08,0x40,0x08,0x40,0x08,0x7f,0x7f,0x80,0x10,0x80,0x11,0x7e,0x1e,0x12,0x12,0x14,0x12,0x50,0x12,0x50,0x12,0x5e,0x12,0x50,0x22,0x50,0x22,0xb0,0x42,0x98,0x0d,0x07}}, // 旋
{0x407C,0x90FA,0xC0FC,0xE7A9BF,0x7A7F,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x22,0x44,0x44,0x42,0x18,0x3e,0x60,0x00,0x3f,0xfc,0x04,0x20,0x04,0x20,0x7f,0xfe,0x00,0xa0,0x03,0x20,0x0c,0x20,0x70,0xe0,0x00,0x20}}, // 穿
{0x407D,0x90FB,0xC0FD,0xE7AEAD,0x7BAD,{0x10,0x20,0x10,0x20,0x3f,0x7f,0x24,0x50,0x44,0x88,0x02,0x10,0x7f,0xff,0x00,0x00,0x1f,0x24,0x11,0x24,0x1f,0x24,0x11,0x24,0x1f,0x24,0x11,0x24,0x11,0x24,0x13,0x0c}}, // 箭
{0x407E,0x90FC,0xC0FE,0xE7B79A,0x7DDA,{0x08,0x10,0x08,0x20,0x0a,0xfc,0x72,0x84,0x14,0xfc,0x08,0x84,0x0c,0x84,0x12,0xfc,0x7d,0x10,0x08,0x12,0x2d,0xfc,0x2a,0x58,0x2a,0x54,0x2a,0x92,0x49,0x31,0x08,0x10}}, // 線
{0x4121,0x9140,0xC1A1,0xE7B98A,0x7E4A,{0x08,0x88,0x08,0x8c,0x0b,0xea,0x72,0x8a,0x14,0x88,0x0b,0xff,0x09,0x48,0x15,0x4a,0x7f,0x5a,0x09,0x6a,0x2d,0x4c,0x2b,0x44,0x29,0x4d,0x29,0xf5,0x4f,0x23,0x08,0x41}}, // 繊
{0x4122,0x9141,0xC1A2,0xE7BEA8,0x7FA8,{0x04,0x10,0x02,0x20,0x3f,0xfe,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x10,0x80,0x08,0xfe,0x09,0x24,0x42,0x28,0x20,0x30,0x24,0x50,0x08,0x88,0x11,0x04,0x66,0x03}}, // 羨
{0x4123,0x9142,0xC1A3,0xE885BA,0x817A,{0x00,0x10,0x3c,0x20,0x24,0xfc,0x24,0x84,0x24,0xfc,0x3c,0x84,0x24,0x84,0x24,0xfc,0x24,0x22,0x3c,0x22,0x27,0xf4,0x24,0xa8,0x25,0x24,0x26,0x22,0x2c,0x61,0x44,0x20}}, // 腺
{0x4124,0x9143,0xC1A4,0xE8889B,0x821B,{0x08,0x04,0x08,0x04,0x0f,0x04,0x09,0x04,0x11,0x7f,0x11,0x44,0x2a,0x44,0x46,0x44,0x02,0x44,0x04,0x44,0x05,0xff,0x08,0x04,0x08,0x04,0x10,0x04,0x20,0x04,0x40,0x04}}, // 舛
{0x4125,0x9144,0xC1A5,0xE888B9,0x8239,{0x04,0x3c,0x08,0x04,0x1f,0x24,0x11,0x24,0x19,0x24,0x15,0x44,0x15,0x42,0x13,0x82,0x1d,0x7d,0x71,0x44,0x19,0x44,0x15,0x44,0x15,0x44,0x21,0x44,0x23,0x7c,0x41,0x44}}, // 船
{0x4126,0x9145,0xC1A6,0xE896A6,0x85A6,{0x04,0x08,0x7f,0xfe,0x04,0x08,0x00,0x40,0x1f,0xfe,0x11,0x20,0x1f,0xfc,0x11,0x24,0x1f,0xfc,0x12,0x00,0x13,0xff,0x12,0x00,0x23,0xfe,0x28,0x92,0x4a,0x4a,0x11,0x0c}}, // 薦
{0x4127,0x9146,0xC1A7,0xE8A9AE,0x8A6E,{0x00,0x10,0x3e,0x10,0x00,0x28,0x7f,0x44,0x00,0x82,0x3f,0x01,0x00,0xfe,0x00,0x10,0x3e,0x10,0x00,0x10,0x3e,0xfe,0x22,0x10,0x22,0x10,0x22,0x10,0x3f,0xff,0x22,0x00}}, // 詮
{0x4128,0x9147,0xC1A8,0xE8B38E,0x8CCE,{0x00,0x28,0x3e,0x24,0x22,0x20,0x22,0x2e,0x3e,0xf0,0x22,0x2e,0x22,0xf0,0x3e,0x17,0x22,0x18,0x23,0xf4,0x22,0x14,0x3e,0x08,0x14,0x1a,0x12,0x66,0x23,0x86,0x40,0x02}}, // 賎
{0x4129,0x9148,0xC1A9,0xE8B7B5,0x8DF5,{0x00,0x28,0x3e,0x24,0x22,0x20,0x22,0x3e,0x22,0xe0,0x22,0x3e,0x3e,0xe0,0x08,0x1f,0x28,0xf0,0x2e,0x14,0x28,0x14,0x28,0x08,0x29,0x1a,0x2e,0x66,0x39,0x86,0x60,0x02}}, // 践
{0x412A,0x9149,0xC1AA,0xE981B8,0x9078,{0x00,0x00,0x27,0xbc,0x10,0x84,0x17,0xbc,0x04,0x20,0x04,0x62,0x03,0xde,0x71,0x10,0x17,0xfc,0x11,0x10,0x11,0x10,0x1f,0xfe,0x10,0xa0,0x2b,0x18,0x26,0x04,0x41,0xff}}, // 選
{0x412B,0x914A,0xC1AB,0xE981B7,0x9077,{0x00,0x00,0x17,0xfe,0x08,0x90,0x0b,0xfc,0x02,0x94,0x03,0xfc,0x00,0x40,0x7f,0xff,0x08,0x88,0x09,0xf4,0x0a,0x13,0x0d,0xf4,0x09,0x04,0x14,0xfc,0x23,0x00,0x40,0xff}}, // 遷
{0x412C,0x914B,0xC1AC,0xE98AAD,0x92AD,{0x08,0x28,0x08,0x24,0x14,0x20,0x12,0x3e,0x21,0xe0,0x7e,0x3e,0x09,0xe0,0x08,0x2f,0x7e,0x34,0x09,0xe4,0x4a,0x18,0x2c,0x10,0x29,0x1a,0x0e,0x2a,0x18,0xc6,0x63,0x02}}, // 銭
{0x412D,0x914C,0xC1AD,0xE98A91,0x9291,{0x08,0x10,0x08,0x50,0x14,0x50,0x12,0x7e,0x21,0x90,0x7e,0x90,0x09,0x10,0x08,0xff,0x7f,0x28,0x08,0x28,0x4a,0x28,0x2c,0x48,0x28,0x49,0x0e,0x89,0x19,0x09,0x62,0x07}}, // 銑
{0x412E,0x914D,0xC1AE,0xE99683,0x9583,{0x00,0x00,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x41,0x02,0x41,0x02,0x41,0x02,0x41,0x82,0x42,0x82,0x42,0x42,0x44,0x22,0x48,0x12,0x40,0x06,0x40,0x02}}, // 閃
{0x412F,0x914E,0xC1AF,0xE9AEAE,0x9BAE,{0x08,0x44,0x0e,0x24,0x12,0x28,0x24,0xff,0x7f,0x10,0x29,0x10,0x29,0x7e,0x3f,0x10,0x29,0x10,0x29,0x10,0x3f,0xff,0x02,0x10,0x15,0x10,0x2a,0x90,0x2a,0x10,0x40,0x10}}, // 鮮
{0x4130,0x914F,0xC1B0,0xE5898D,0x524D,{0x08,0x10,0x04,0x10,0x04,0x20,0x7f,0xff,0x00,0x00,0x3e,0x44,0x22,0x44,0x22,0x44,0x3e,0x44,0x22,0x44,0x22,0x44,0x3e,0x44,0x22,0x44,0x22,0x04,0x26,0x0c,0x22,0x04}}, // 前
{0x4131,0x9150,0xC1B1,0xE59684,0x5584,{0x04,0x08,0x02,0x10,0x3f,0xfe,0x00,0x80,0x1f,0xfc,0x00,0x80,0x3f,0xfe,0x08,0x88,0x04,0x90,0x7f,0xff,0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 善
{0x4132,0x9151,0xC1B2,0xE6BCB8,0x6F38,{0x21,0x02,0x11,0x0c,0x1f,0xf0,0x01,0x10,0x47,0xd0,0x25,0x5f,0x25,0x54,0x07,0xd4,0x05,0x54,0x15,0x54,0x17,0xd4,0x21,0x24,0x2f,0xe4,0x21,0x44,0x41,0x04,0x41,0x04}}, // 漸
{0x4133,0x9152,0xC1B3,0xE784B6,0x7136,{0x04,0x10,0x04,0x14,0x0f,0x92,0x08,0x92,0x11,0xff,0x25,0x10,0x52,0x28,0x0a,0x28,0x04,0x44,0x18,0x82,0x63,0x01,0x00,0x00,0x12,0x48,0x11,0x24,0x21,0x22,0x40,0x02}}, // 然
{0x4134,0x9153,0xC1B4,0xE585A8,0x5168,{0x00,0x80,0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x6f,0xfb,0x00,0x80,0x00,0x80,0x00,0x80,0x1f,0xf8,0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 全
{0x4135,0x9154,0xC1B5,0xE7A685,0x7985,{0x09,0x22,0x08,0x92,0x08,0x94,0x7e,0xfe,0x02,0x92,0x04,0x92,0x04,0xfe,0x08,0x92,0x1c,0xfe,0x2a,0x10,0x49,0x10,0x09,0xff,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10}}, // 禅
{0x4136,0x9155,0xC1B6,0xE7B995,0x7E55,{0x08,0x82,0x08,0x44,0x0a,0xff,0x72,0x10,0x14,0x7e,0x08,0x10,0x0d,0xff,0x12,0x92,0x7d,0x54,0x09,0xff,0x28,0x00,0x2a,0x7e,0x29,0x42,0x29,0x42,0x48,0x7e,0x08,0x42}}, // 繕
{0x4137,0x9156,0xC1B7,0xE886B3,0x81B3,{0x01,0x02,0x3c,0x84,0x27,0xfe,0x24,0x20,0x25,0xfc,0x3c,0x20,0x27,0xff,0x25,0x24,0x24,0xa8,0x3f,0xff,0x24,0x00,0x25,0xfc,0x25,0x04,0x25,0x04,0x25,0xfc,0x4d,0x04}}, // 膳
{0x4138,0x9157,0xC1B8,0xE7B38E,0x7CCE,{0x08,0x00,0x49,0xff,0x2b,0x00,0x2d,0x7e,0x09,0x52,0x7f,0x52,0x09,0x7e,0x19,0x52,0x1d,0x52,0x2b,0x7e,0x29,0x10,0x49,0x7e,0x09,0x10,0x0a,0x10,0x0b,0xff,0x0c,0x00}}, // 糎
{0x4139,0x9158,0xC1B9,0xE5998C,0x564C,{0x01,0x04,0x00,0x88,0x7b,0xfe,0x4a,0x22,0x4b,0xfe,0x4a,0x22,0x4a,0x22,0x4b,0xfe,0x48,0x00,0x49,0xfc,0x79,0x04,0x49,0xfc,0x41,0x04,0x01,0x04,0x01,0xfc,0x01,0x04}}, // 噌
{0x413A,0x9159,0xC1BA,0xE5A191,0x5851,{0x11,0x00,0x0a,0x3e,0x7f,0xa2,0x04,0x3e,0x25,0x22,0x25,0x3e,0x25,0x22,0x3f,0x22,0x25,0x22,0x08,0x46,0x10,0x80,0x2f,0xf8,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 塑
{0x413B,0x915A,0xC1BB,0xE5B2A8,0x5CA8,{0x10,0x00,0x10,0xfc,0x10,0x84,0x54,0x84,0x54,0x84,0x54,0xfc,0x54,0x84,0x54,0x84,0x54,0x84,0x54,0xfc,0x54,0x84,0x7c,0x84,0x44,0x84,0x40,0x84,0x03,0xff,0x00,0x00}}, // 岨
{0x413C,0x915B,0xC1BC,0xE68EAA,0x63AA,{0x10,0x88,0x10,0x88,0x13,0xfe,0x10,0x88,0x7c,0x88,0x10,0x88,0x17,0xff,0x10,0x00,0x1d,0xfc,0x71,0x04,0x11,0x04,0x11,0xfc,0x11,0x04,0x11,0x04,0x31,0xfc,0x11,0x04}}, // 措
{0x413D,0x915C,0xC1BD,0xE69BBE,0x66FE,{0x04,0x10,0x04,0x10,0x08,0x08,0x1f,0xfc,0x30,0x96,0x54,0x95,0x12,0xa4,0x1f,0xfc,0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 曾
{0x413E,0x915D,0xC1BE,0xE69BBD,0x66FD,{0x08,0x10,0x04,0x20,0x3f,0xfc,0x21,0x04,0x21,0x04,0x3f,0xfc,0x21,0x04,0x3f,0xfc,0x00,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10}}, // 曽
{0x413F,0x915E,0xC1BF,0xE6A59A,0x695A,{0x04,0x08,0x04,0x08,0x7f,0xff,0x0c,0x1c,0x16,0x2a,0x15,0x29,0x24,0x48,0x44,0x08,0x00,0x00,0x3f,0xfe,0x08,0x84,0x08,0x80,0x0c,0xfc,0x12,0x80,0x21,0xc0,0x40,0x3f}}, // 楚
{0x4140,0x915F,0xC1C0,0xE78B99,0x72D9,{0x04,0x00,0x44,0xfc,0x28,0x84,0x10,0x84,0x10,0x84,0x28,0xfc,0x48,0x84,0x08,0x84,0x18,0x84,0x18,0xfc,0x28,0x84,0x48,0x84,0x08,0x84,0x08,0x84,0x6b,0xff,0x10,0x00}}, // 狙
{0x4141,0x9160,0xC1C1,0xE7968F,0x758F,{0x00,0x10,0x3f,0x10,0x01,0xff,0x02,0x10,0x04,0x28,0x14,0x46,0x14,0xfd,0x17,0x00,0x14,0x54,0x14,0x54,0x14,0x54,0x14,0x54,0x17,0x54,0x1c,0x95,0x60,0x85,0x01,0x03}}, // 疏
{0x4142,0x9161,0xC1C2,0xE7968E,0x758E,{0x00,0x10,0x3f,0x10,0x01,0xff,0x02,0x10,0x04,0x10,0x14,0xfe,0x14,0x92,0x17,0x92,0x14,0xfe,0x14,0x10,0x14,0x38,0x14,0x54,0x17,0x92,0x1d,0x11,0x60,0x10,0x00,0x10}}, // 疎
{0x4143,0x9162,0xC1C3,0xE7A48E,0x790E,{0x00,0x44,0x7f,0x44,0x09,0xff,0x08,0x44,0x08,0xee,0x11,0x55,0x1e,0x44,0x12,0x44,0x33,0xff,0x52,0x12,0x12,0x90,0x12,0x9e,0x1e,0xd0,0x12,0xb0,0x01,0x18,0x02,0x07}}, // 礎
{0x4144,0x9163,0xC1C4,0xE7A596,0x7956,{0x08,0x00,0x08,0xfc,0x08,0x84,0x7e,0x84,0x02,0x84,0x04,0xfc,0x04,0x84,0x08,0x84,0x1c,0x84,0x2a,0xfc,0x49,0x84,0x08,0x84,0x08,0x84,0x08,0x84,0x09,0xff,0x08,0x00}}, // 祖
{0x4145,0x9164,0xC1C5,0xE7A79F,0x79DF,{0x02,0x00,0x0c,0xfc,0x78,0x84,0x08,0x84,0x08,0x84,0x7e,0xfc,0x08,0x84,0x08,0x84,0x1c,0x84,0x1a,0xfc,0x2a,0x84,0x28,0x84,0x48,0x84,0x08,0x84,0x0b,0xff,0x08,0x00}}, // 租
{0x4146,0x9165,0xC1C6,0xE7B297,0x7C97,{0x08,0x00,0x4a,0xfc,0x2a,0x84,0x2c,0x84,0x08,0x84,0x7f,0xfc,0x08,0x84,0x08,0x84,0x1c,0x84,0x1a,0xfc,0x2a,0x84,0x28,0x84,0x48,0x84,0x08,0x84,0x0b,0xff,0x08,0x00}}, // 粗
{0x4147,0x9166,0xC1C7,0xE7B4A0,0x7D20,{0x00,0x80,0x3f,0xfe,0x00,0x80,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x00,0x80,0x03,0x20,0x0c,0x58,0x03,0x84,0x3f,0xfa,0x00,0x80,0x04,0xb0,0x18,0x8c,0x60,0x82,0x00,0x80}}, // 素
{0x4148,0x9167,0xC1C8,0xE7B584,0x7D44,{0x08,0x00,0x08,0x7c,0x0a,0x44,0x72,0x44,0x14,0x44,0x08,0x7c,0x0c,0x44,0x12,0x44,0x7d,0x44,0x09,0x7c,0x28,0x44,0x2a,0x44,0x29,0x44,0x29,0x44,0x49,0xff,0x08,0x00}}, // 組
{0x4149,0x9168,0xC1C9,0xE89887,0x8607,{0x04,0x20,0x7f,0xff,0x04,0x20,0x10,0x04,0x1e,0x18,0x24,0xf0,0x7f,0x10,0x29,0xff,0x3f,0x18,0x29,0x38,0x29,0x34,0x3f,0x54,0x15,0x92,0x2a,0x91,0x2a,0x10,0x40,0x10}}, // 蘇
{0x414A,0x9169,0xC1CA,0xE8A8B4,0x8A34,{0x00,0x04,0x3e,0x18,0x00,0xe0,0x7f,0x80,0x00,0x80,0x3e,0xff,0x00,0x88,0x00,0x88,0x3e,0x88,0x00,0xb8,0x3e,0x8e,0x22,0x89,0x22,0x88,0x22,0x88,0x3f,0x08,0x22,0x08}}, // 訴
{0x414B,0x916A,0xC1CB,0xE998BB,0x963B,{0x00,0x00,0x3c,0xfc,0x24,0x84,0x24,0x84,0x28,0x84,0x30,0xfc,0x28,0x84,0x24,0x84,0x22,0x84,0x22,0xfc,0x22,0x84,0x32,0x84,0x2c,0x84,0x20,0x84,0x23,0xff,0x20,0x00}}, // 阻
{0x414C,0x916B,0xC1CC,0xE981A1,0x9061,{0x02,0x20,0x21,0x3e,0x11,0x52,0x13,0xf2,0x00,0x9e,0x02,0xb2,0x02,0xb2,0x7a,0xb2,0x0b,0xfe,0x0a,0x92,0x08,0x92,0x09,0x12,0x16,0x22,0x12,0x46,0x21,0x80,0x40,0xff}}, // 遡
{0x414D,0x916C,0xC1CD,0xE9BCA0,0x9F20,{0x02,0x00,0x1c,0xf8,0x10,0x08,0x1e,0x78,0x10,0x08,0x1f,0xf8,0x00,0x00,0x14,0xc8,0x12,0xa8,0x10,0x88,0x14,0xc8,0x12,0xa8,0x10,0x85,0x16,0xb5,0x18,0xc3,0x63,0x01}}, // 鼠
{0x414E,0x916D,0xC1CE,0xE583A7,0x50E7,{0x05,0x04,0x04,0x88,0x07,0xfe,0x0a,0x22,0x0b,0xfe,0x12,0x22,0x12,0x22,0x33,0xfe,0x50,0x00,0x11,0xfc,0x11,0x04,0x11,0xfc,0x11,0x04,0x11,0x04,0x11,0xfc,0x11,0x04}}, // 僧
{0x414F,0x916E,0xC1CF,0xE589B5,0x5275,{0x02,0x02,0x02,0x12,0x05,0x12,0x08,0x92,0x1f,0x52,0x20,0x32,0x5f,0x92,0x10,0x92,0x1f,0x92,0x10,0x92,0x1f,0x92,0x10,0x12,0x2f,0x82,0x28,0x82,0x4f,0x86,0x08,0x82}}, // 創
{0x4150,0x916F,0xC1D0,0xE58F8C,0x53CC,{0x00,0x00,0x7f,0xfc,0x02,0x04,0x02,0x44,0x42,0x44,0x22,0x44,0x12,0x44,0x0c,0x28,0x04,0x28,0x06,0x10,0x0a,0x10,0x09,0x28,0x11,0x48,0x10,0x84,0x23,0x02,0x4c,0x01}}, // 双
{0x4151,0x9170,0xC1D1,0xE58FA2,0x53E2,{0x09,0x48,0x05,0x50,0x7f,0xff,0x02,0x20,0x1f,0xfc,0x00,0x80,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x11,0x00,0x1f,0x7c,0x11,0x24,0x1f,0x14,0x11,0x08,0x7f,0x34,0x01,0xc3}}, // 叢
{0x4152,0x9171,0xC1D2,0xE58089,0x5009,{0x00,0x80,0x00,0x80,0x01,0x40,0x02,0x20,0x07,0xf0,0x18,0x0c,0x67,0xf3,0x04,0x10,0x07,0xf0,0x04,0x10,0x07,0xf0,0x08,0x00,0x0f,0xf8,0x14,0x08,0x27,0xf8,0x04,0x08}}, // 倉
{0x4153,0x9172,0xC1D3,0xE596AA,0x55AA,{0x00,0x80,0x00,0x80,0x3f,0xfe,0x00,0x80,0x1e,0xbc,0x12,0xa4,0x1e,0xbc,0x12,0xa4,0x00,0x80,0x7f,0xff,0x04,0x84,0x04,0x44,0x04,0x28,0x04,0x90,0x07,0x0c,0x38,0x03}}, // 喪
{0x4154,0x9173,0xC1D4,0xE5A3AE,0x58EE,{0x04,0x10,0x04,0x10,0x04,0x10,0x24,0x10,0x24,0x10,0x17,0xff,0x14,0x10,0x04,0x10,0x0c,0x10,0x14,0x10,0x14,0x10,0x24,0x10,0x44,0x10,0x05,0xfe,0x04,0x00,0x04,0x00}}, // 壮
{0x4155,0x9174,0xC1D5,0xE5A58F,0x594F,{0x00,0x80,0x00,0x80,0x3f,0xfe,0x00,0x80,0x1f,0xfc,0x01,0x40,0x7f,0xff,0x02,0x20,0x04,0x10,0x1b,0xec,0x60,0x83,0x1f,0xfc,0x01,0x40,0x02,0x20,0x0c,0x18,0x30,0x06}}, // 奏
{0x4156,0x9175,0xC1D6,0xE788BD,0x723D,{0x00,0x80,0x00,0x80,0x7f,0xff,0x02,0x82,0x1a,0x9a,0x04,0x84,0x3a,0xba,0x00,0x80,0x1a,0x9a,0x04,0x84,0x0d,0x4c,0x33,0x72,0x02,0x20,0x04,0x10,0x18,0x0c,0x60,0x03}}, // 爽
{0x4157,0x9176,0xC1D7,0xE5AE8B,0x5B8B,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x21,0x00,0x41,0x00,0x01,0x00,0x7f,0xfe,0x01,0x00,0x03,0x80,0x05,0x40,0x09,0x20,0x11,0x18,0x61,0x06,0x01,0x00,0x01,0x00}}, // 宋
{0x4158,0x9177,0xC1D8,0xE5B1A4,0x5C64,{0x00,0x00,0x1f,0xfe,0x10,0x02,0x1f,0xfe,0x11,0x10,0x17,0xfc,0x14,0x44,0x17,0xfc,0x14,0x44,0x17,0xfc,0x10,0x00,0x13,0xf8,0x22,0x08,0x23,0xf8,0x42,0x08,0x03,0xf8}}, // 層
{0x4159,0x9178,0xC1D9,0xE58C9D,0x531D,{0x00,0x00,0x3f,0xfe,0x20,0x00,0x20,0x40,0x20,0x40,0x27,0xfc,0x24,0x44,0x24,0x44,0x24,0x44,0x24,0x44,0x24,0x58,0x24,0x40,0x20,0x40,0x20,0x40,0x3f,0xff,0x20,0x00}}, // 匝
{0x415A,0x9179,0xC1DA,0xE683A3,0x60E3,{0x08,0x80,0x28,0x80,0x3e,0xfe,0x29,0x2a,0x4a,0x2a,0x08,0x4a,0x0e,0x92,0x79,0x12,0x08,0x22,0x08,0x4c,0x08,0xc0,0x12,0x20,0x12,0x22,0x12,0x09,0x21,0x09,0x40,0xf8}}, // 惣
{0x415B,0x917A,0xC1DB,0xE683B3,0x60F3,{0x04,0x00,0x04,0x7e,0x7f,0xc2,0x04,0x42,0x0c,0x7e,0x0e,0x42,0x15,0x7e,0x24,0x42,0x44,0x7e,0x04,0xc2,0x02,0x40,0x12,0x24,0x12,0x22,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 想
{0x415C,0x917B,0xC1DC,0xE68D9C,0x635C,{0x10,0x20,0x10,0x20,0x11,0xfc,0x11,0x24,0x7d,0x24,0x11,0xfc,0x11,0x24,0x11,0x24,0x1d,0xfc,0x70,0x20,0x13,0xfc,0x10,0x88,0x10,0x50,0x10,0x20,0x30,0xd8,0x17,0x07}}, // 捜
{0x415D,0x917C,0xC1DD,0xE68E83,0x6383,{0x10,0x00,0x11,0xf8,0x10,0x08,0x10,0xf8,0x7c,0x08,0x11,0xf8,0x10,0x00,0x13,0xff,0x1e,0x22,0x75,0xfc,0x11,0x24,0x11,0x24,0x11,0x24,0x11,0x38,0x31,0x20,0x10,0x20}}, // 掃
{0x415E,0x917D,0xC1DE,0xE68CBF,0x633F,{0x10,0x04,0x10,0x18,0x11,0xe0,0x7c,0x20,0x17,0xff,0x10,0x20,0x11,0xfc,0x11,0x24,0x1d,0x24,0x71,0xfc,0x11,0x24,0x11,0x24,0x11,0xfc,0x10,0x20,0x30,0x20,0x10,0x20}}, // 挿
{0x415F,0x917E,0xC1DF,0xE68EBB,0x63BB,{0x10,0x00,0x13,0xfc,0x10,0x84,0x10,0x48,0x7c,0x30,0x10,0xcc,0x13,0x23,0x10,0x20,0x1d,0xfc,0x71,0x24,0x11,0x24,0x11,0xfc,0x10,0x20,0x10,0x2c,0x30,0x7a,0x17,0x81}}, // 掻
{0x4160,0x9180,0xC1E0,0xE6938D,0x64CD,{0x10,0x00,0x10,0xf8,0x10,0x88,0x10,0xf8,0x7c,0x88,0x13,0xde,0x12,0x52,0x13,0xde,0x1e,0x52,0x70,0x20,0x17,0xfe,0x10,0x70,0x10,0xa8,0x11,0x24,0x36,0x22,0x10,0x20}}, // 操
{0x4161,0x9181,0xC1E1,0xE697A9,0x65E9,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 早
{0x4162,0x9182,0xC1E2,0xE69BB9,0x66F9,{0x02,0x40,0x02,0x40,0x7f,0xfe,0x02,0x40,0x3f,0xfc,0x22,0x44,0x3f,0xfc,0x22,0x44,0x3f,0xfc,0x00,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10}}, // 曹
{0x4163,0x9183,0xC1E3,0xE5B7A3,0x5DE3,{0x09,0x08,0x04,0x88,0x04,0x90,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x08,0x88,0x08,0x88,0x0f,0xf8,0x00,0x80,0x7f,0xfe,0x01,0xc0,0x02,0xa0,0x0c,0x98,0x30,0x86,0x00,0x80}}, // 巣
{0x4164,0x9184,0xC1E4,0xE6A78D,0x69CD,{0x08,0x20,0x08,0x20,0x08,0x50,0x7e,0x88,0x09,0xfc,0x0a,0x02,0x1c,0xfd,0x1a,0x84,0x1a,0xfc,0x28,0x84,0x28,0xfc,0x49,0x00,0x09,0xfc,0x0a,0x84,0x0c,0xfc,0x08,0x84}}, // 槍
{0x4165,0x9185,0xC1E5,0xE6A7BD,0x69FD,{0x08,0x48,0x08,0x48,0x09,0xff,0x7e,0x48,0x09,0xfe,0x09,0x4a,0x1d,0xfe,0x1b,0x4a,0x19,0xfe,0x28,0x00,0x28,0xfc,0x48,0x84,0x08,0xfc,0x08,0x84,0x08,0xfc,0x08,0x84}}, // 槽
{0x4166,0x9186,0xC1E6,0xE6BC95,0x6F15,{0x10,0x50,0x08,0x50,0x0f,0xff,0x00,0x50,0x43,0xfe,0x22,0x52,0x23,0xfe,0x02,0x52,0x0b,0xfe,0x08,0x00,0x11,0xfc,0x11,0x04,0x21,0xfc,0x21,0x04,0x41,0xfc,0x41,0x04}}, // 漕
{0x4167,0x9187,0xC1E7,0xE787A5,0x71E5,{0x08,0x00,0x08,0x78,0x08,0x48,0x0a,0x48,0x2a,0x78,0x2b,0xde,0x2d,0x52,0x29,0x52,0x49,0xde,0x0c,0x20,0x15,0xfe,0x12,0x70,0x12,0xa8,0x21,0x24,0x22,0x22,0x40,0x20}}, // 燥
{0x4168,0x9188,0xC1E8,0xE4BA89,0x4E89,{0x01,0x00,0x01,0xe0,0x02,0x20,0x04,0x40,0x18,0x80,0x1f,0xf8,0x00,0x88,0x00,0x88,0x7f,0xff,0x00,0x88,0x00,0x88,0x1f,0xf8,0x00,0x88,0x00,0x80,0x03,0x80,0x00,0x80}}, // 争
{0x4169,0x9189,0xC1E9,0xE797A9,0x75E9,{0x00,0x40,0x00,0x40,0x0f,0xff,0x48,0x40,0x2b,0xfc,0x2a,0x44,0x0b,0xfc,0x0a,0x44,0x1b,0xfc,0x28,0x40,0x4f,0xf8,0x11,0x08,0x10,0x90,0x20,0x60,0x41,0x98,0x1e,0x07}}, // 痩
{0x416A,0x918A,0xC1EA,0xE79BB8,0x76F8,{0x08,0x00,0x08,0xfe,0x08,0x82,0x7f,0x82,0x08,0x82,0x08,0xfe,0x1c,0x82,0x1a,0x82,0x19,0x82,0x28,0xfe,0x28,0x82,0x48,0x82,0x08,0x82,0x08,0xfe,0x08,0x82,0x08,0x00}}, // 相
{0x416B,0x918B,0xC1EB,0xE7AA93,0x7A93,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x24,0x44,0x44,0x42,0x09,0x3e,0x11,0x00,0x62,0x60,0x04,0x18,0x1f,0xe4,0x01,0x02,0x12,0x88,0x12,0x44,0x22,0x4a,0x42,0x0a,0x01,0xf8}}, // 窓
{0x416C,0x918C,0xC1EC,0xE7B39F,0x7CDF,{0x08,0x48,0x0a,0x48,0x4b,0xff,0x2c,0x48,0x29,0xfe,0x09,0x4a,0x7f,0xfe,0x09,0x4a,0x1d,0xfe,0x1a,0x00,0x1a,0xfc,0x28,0x84,0x28,0xfc,0x48,0x84,0x08,0xfc,0x08,0x84}}, // 糟
{0x416D,0x918D,0xC1ED,0xE7B78F,0x7DCF,{0x08,0x3c,0x08,0x04,0x0a,0x44,0x72,0x52,0x14,0x92,0x09,0x29,0x0c,0x44,0x12,0xfc,0x7d,0x12,0x08,0x08,0x2c,0xa8,0x2a,0xaa,0x2a,0xa1,0x29,0x25,0x4a,0x25,0x08,0x1c}}, // 総
{0x416E,0x918E,0xC1EE,0xE7B69C,0x7D9C,{0x08,0x10,0x08,0x10,0x0a,0xff,0x72,0x82,0x15,0x00,0x08,0xfe,0x0c,0x00,0x12,0x00,0x7f,0xff,0x0a,0x10,0x08,0x14,0x2c,0x52,0x2a,0x52,0x2a,0x91,0x49,0x30,0x08,0x10}}, // 綜
{0x416F,0x918F,0xC1EF,0xE881A1,0x8061,{0x00,0x1c,0x7f,0x24,0x12,0x24,0x12,0x52,0x12,0x92,0x1f,0x19,0x12,0x24,0x12,0x2c,0x1e,0xf2,0x12,0x12,0x12,0x08,0x13,0xa8,0x1e,0xa2,0x72,0xa5,0x03,0x25,0x02,0x1c}}, // 聡
{0x4170,0x9190,0xC1F0,0xE88D89,0x8349,{0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80}}, // 草
{0x4171,0x9191,0xC1F1,0xE88D98,0x8358,{0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x00,0x00,0x04,0x10,0x24,0x10,0x14,0x10,0x17,0xff,0x04,0x10,0x0c,0x10,0x34,0x10,0x44,0x10,0x04,0x10,0x05,0xfe,0x04,0x00}}, // 荘
{0x4172,0x9192,0xC1F2,0xE891AC,0x846C,{0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x10,0x7f,0xff,0x02,0x22,0x07,0xa4,0x38,0xb8,0x05,0x20,0x06,0x22,0x3a,0x1e,0x02,0x10,0x7f,0xff,0x02,0x10,0x04,0x10,0x18,0x10}}, // 葬
{0x4173,0x9193,0xC1F3,0xE892BC,0x84BC,{0x04,0x08,0x7f,0xff,0x04,0x88,0x05,0x48,0x02,0x20,0x07,0xf0,0x18,0x0c,0x67,0xf3,0x04,0x10,0x07,0xf0,0x04,0x10,0x07,0xf0,0x08,0x00,0x0f,0xf8,0x14,0x08,0x27,0xf8}}, // 蒼
{0x4174,0x9194,0xC1F4,0xE897BB,0x85FB,{0x04,0x20,0x04,0x20,0x7f,0xff,0x04,0x20,0x10,0xf8,0x08,0x88,0x48,0xf8,0x23,0xde,0x22,0x52,0x03,0xde,0x08,0x20,0x17,0xff,0x10,0x70,0x21,0xac,0x26,0x23,0x40,0x20}}, // 藻
{0x4175,0x9195,0xC1F5,0xE8A385,0x88C5,{0x04,0x20,0x24,0x20,0x17,0xfe,0x14,0x20,0x04,0x20,0x1c,0x20,0x65,0xfc,0x04,0x80,0x00,0x80,0x7f,0xff,0x02,0x48,0x0c,0x48,0x74,0x30,0x04,0x10,0x07,0x8c,0x38,0x03}}, // 装
{0x4176,0x9196,0xC1F6,0xE8B5B0,0x8D70,{0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x08,0x80,0x08,0x80,0x08,0xfc,0x08,0x80,0x14,0x80,0x12,0x80,0x21,0xc0,0x40,0x3e}}, // 走
{0x4177,0x9197,0xC1F7,0xE98081,0x9001,{0x01,0x08,0x20,0x88,0x10,0x90,0x10,0x20,0x03,0xfe,0x00,0x20,0x00,0x20,0x78,0x20,0x0f,0xff,0x08,0x30,0x08,0x48,0x08,0x84,0x0d,0x02,0x14,0x02,0x23,0x00,0x40,0xff}}, // 送
{0x4178,0x9198,0xC1F8,0xE981AD,0x906D,{0x00,0x50,0x27,0xff,0x10,0x50,0x13,0xfe,0x02,0x52,0x03,0xfe,0x02,0x52,0x7b,0xfe,0x08,0x00,0x09,0xfc,0x09,0x04,0x09,0xfc,0x15,0x04,0x13,0xfc,0x21,0x80,0x40,0x7f}}, // 遭
{0x4179,0x9199,0xC1F9,0xE98E97,0x9397,{0x08,0x10,0x08,0x10,0x14,0x28,0x12,0x44,0x21,0xfe,0x7f,0x01,0x08,0x7c,0x08,0x44,0x7f,0x7c,0x08,0x44,0x4a,0x7c,0x2c,0x80,0x28,0xfe,0x0f,0x42,0x1a,0x7e,0x60,0x42}}, // 鎗
{0x417A,0x919A,0xC1FA,0xE99C9C,0x971C,{0x00,0x00,0x3f,0xfc,0x01,0x00,0x3f,0xfe,0x21,0x02,0x3d,0x74,0x4f,0x38,0x01,0x00,0x08,0x7c,0x7f,0x44,0x08,0x7c,0x1c,0x44,0x1a,0x7c,0x29,0x44,0x48,0x7c,0x08,0x44}}, // 霜
{0x417B,0x919B,0xC1FB,0xE9A892,0x9A12,{0x00,0x00,0x3f,0xfc,0x24,0x44,0x24,0x28,0x3f,0x10,0x24,0x2c,0x3f,0xd3,0x24,0x10,0x24,0x7c,0x3f,0x54,0x05,0x54,0x2b,0x7c,0x2b,0x18,0x29,0x14,0x41,0x1e,0x06,0xe1}}, // 騒
{0x417C,0x919C,0xC1FC,0xE5838F,0x50CF,{0x04,0x40,0x04,0x78,0x04,0x88,0x0b,0x10,0x0d,0xfe,0x11,0x22,0x11,0x22,0x31,0xfe,0x50,0xc4,0x17,0x24,0x10,0xd8,0x17,0x38,0x10,0x54,0x11,0x92,0x16,0x11,0x10,0x60}}, // 像
{0x417D,0x919D,0xC1FD,0xE5A297,0x5897,{0x01,0x04,0x10,0x88,0x13,0xfe,0x12,0x22,0x12,0x22,0x7f,0xfe,0x12,0x22,0x13,0xfe,0x10,0x00,0x11,0xfc,0x15,0x04,0x19,0xfc,0x61,0x04,0x01,0x04,0x01,0xfc,0x01,0x04}}, // 増
{0x417E,0x919E,0xC1FE,0xE6868E,0x618E,{0x09,0x04,0x08,0x88,0x0b,0xfe,0x0a,0x22,0x2e,0x22,0x2f,0xfe,0x2a,0x22,0x2b,0xfe,0x48,0x00,0x09,0xfc,0x09,0x04,0x09,0xfc,0x09,0x04,0x09,0x04,0x09,0xfc,0x09,0x04}}, // 憎
{0x4221,0x919F,0xC2A1,0xE88793,0x81D3,{0x00,0x88,0x3b,0xff,0x28,0x88,0x28,0x8a,0x28,0x09,0x3b,0xff,0x2a,0x08,0x2a,0xfa,0x3a,0xaa,0x2a,0xfa,0x2a,0x94,0x2a,0xf4,0x2a,0xa5,0x2a,0xfb,0x2c,0x13,0x58,0x21}}, // 臓
{0x4222,0x91A0,0xC2A2,0xE894B5,0x8535,{0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x14,0x00,0x12,0x1f,0xff,0x10,0x10,0x17,0xf2,0x14,0x92,0x17,0xf4,0x14,0x2c,0x17,0xe8,0x14,0x95,0x27,0xf5,0x20,0x23,0x40,0x41}}, // 蔵
{0x4223,0x91A1,0xC2A3,0xE8B488,0x8D08,{0x00,0x42,0x3e,0x24,0x22,0xff,0x22,0x91,0x22,0x91,0x3e,0xff,0x22,0x91,0x22,0xff,0x3e,0x00,0x22,0x7e,0x22,0x42,0x3e,0x7e,0x14,0x42,0x12,0x42,0x22,0x7e,0x40,0x42}}, // 贈
{0x4224,0x91A2,0xC2A4,0xE980A0,0x9020,{0x00,0x20,0x21,0x20,0x11,0x20,0x11,0xfe,0x02,0x20,0x02,0x20,0x07,0xff,0x78,0x00,0x09,0xfc,0x09,0x04,0x09,0x04,0x09,0x04,0x0d,0xfc,0x15,0x04,0x23,0x00,0x40,0xff}}, // 造
{0x4225,0x91A3,0xC2A5,0xE4BF83,0x4FC3,{0x04,0x00,0x05,0xfe,0x05,0x02,0x09,0x02,0x09,0x02,0x11,0xfe,0x11,0x22,0x30,0x20,0x50,0x20,0x11,0x20,0x11,0x3e,0x11,0x20,0x12,0xa0,0x12,0x60,0x14,0x30,0x18,0x0f}}, // 促
{0x4226,0x91A4,0xC2A6,0xE581B4,0x5074,{0x08,0x02,0x0f,0xd2,0x0c,0x52,0x14,0x52,0x17,0xd2,0x34,0x52,0x34,0x52,0x54,0x52,0x17,0xd2,0x14,0x52,0x14,0x52,0x17,0xd2,0x12,0x82,0x12,0x42,0x14,0x42,0x18,0x06}}, // 側
{0x4227,0x91A5,0xC2A7,0xE58987,0x5247,{0x00,0x02,0x3f,0x22,0x21,0x22,0x21,0x22,0x3f,0x22,0x21,0x22,0x21,0x22,0x21,0x22,0x3f,0x22,0x21,0x22,0x21,0x22,0x3f,0x22,0x12,0x22,0x11,0x02,0x21,0x02,0x40,0x06}}, // 則
{0x4228,0x91A6,0xC2A8,0xE58DB3,0x5373,{0x00,0x00,0x1f,0xbe,0x10,0xa2,0x10,0xa2,0x1f,0xa2,0x10,0xa2,0x10,0xa2,0x10,0xa2,0x1f,0xa2,0x14,0x22,0x12,0x22,0x11,0x22,0x16,0xac,0x18,0xa0,0x60,0x20,0x00,0x20}}, // 即
{0x4229,0x91A7,0xC2A9,0xE681AF,0x606F,{0x01,0x00,0x02,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x24,0x84,0x24,0x42,0x24,0x49,0x42,0x09,0x01,0xf8}}, // 息
{0x422A,0x91A8,0xC2AA,0xE68D89,0x6349,{0x10,0x00,0x11,0xfe,0x11,0x02,0x11,0x02,0x7d,0x02,0x11,0xfe,0x11,0x22,0x10,0x20,0x14,0x20,0x19,0x20,0x71,0x3e,0x11,0x20,0x12,0xa0,0x12,0x60,0x14,0x30,0x38,0x0f}}, // 捉
{0x422B,0x91A9,0xC2AB,0xE69D9F,0x675F,{0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x1f,0xfc,0x10,0x84,0x10,0x84,0x10,0x84,0x1f,0xfc,0x01,0xc0,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80}}, // 束
{0x422C,0x91AA,0xC2AC,0xE6B8AC,0x6E2C,{0x20,0x02,0x17,0xd2,0x14,0x52,0x04,0x52,0x44,0x52,0x27,0xd2,0x24,0x52,0x04,0x52,0x17,0xd2,0x14,0x52,0x14,0x52,0x27,0xd2,0x22,0x92,0x42,0x42,0x44,0x42,0x48,0x06}}, // 測
{0x422D,0x91AB,0xC2AD,0xE8B6B3,0x8DB3,{0x00,0x00,0x1f,0xf8,0x10,0x08,0x10,0x08,0x10,0x08,0x1f,0xf8,0x11,0x08,0x01,0x00,0x11,0x00,0x11,0x00,0x11,0xfc,0x19,0x00,0x15,0x00,0x23,0x00,0x20,0xc0,0x40,0x3f}}, // 足
{0x422E,0x91AC,0xC2AE,0xE9809F,0x901F,{0x00,0x20,0x20,0x20,0x17,0xff,0x10,0x20,0x00,0x20,0x03,0xfe,0x02,0x22,0x7a,0x22,0x0b,0xfe,0x08,0x70,0x08,0xa8,0x09,0x24,0x0e,0x23,0x14,0x20,0x23,0x00,0x40,0xff}}, // 速
{0x422F,0x91AD,0xC2AF,0xE4BF97,0x4FD7,{0x04,0x88,0x04,0x84,0x04,0x84,0x09,0x22,0x0a,0x22,0x10,0x50,0x10,0x50,0x30,0x88,0x51,0x04,0x13,0xfe,0x15,0x05,0x11,0x04,0x11,0x04,0x11,0x04,0x11,0xfc,0x11,0x04}}, // 俗
{0x4230,0x91AE,0xC2B0,0xE5B19E,0x5C5E,{0x00,0x00,0x1f,0xfc,0x10,0x04,0x1f,0xfc,0x10,0x0e,0x17,0xf0,0x10,0x40,0x17,0xfc,0x14,0x44,0x17,0xfc,0x10,0x40,0x1f,0xfe,0x28,0x52,0x28,0x6a,0x4b,0x8a,0x08,0x06}}, // 属
{0x4231,0x91AF,0xC2B1,0xE8B38A,0x8CCA,{0x00,0x10,0x3e,0x14,0x22,0x12,0x22,0x12,0x3f,0xff,0x22,0x10,0x22,0x52,0x3e,0x52,0x23,0xf2,0x22,0x4c,0x22,0x4c,0x3e,0x48,0x14,0x55,0x12,0x15,0x22,0x23,0x41,0x41}}, // 賊
{0x4232,0x91B0,0xC2B2,0xE6978F,0x65CF,{0x08,0x40,0x08,0x40,0x08,0x7f,0x7f,0x50,0x10,0x90,0x10,0xbe,0x1f,0x28,0x12,0x48,0x12,0x88,0x12,0xff,0x12,0x08,0x12,0x14,0x22,0x14,0x22,0x24,0x42,0x42,0x0c,0x81}}, // 族
{0x4233,0x91B1,0xC2B3,0xE7B69A,0x7D9A,{0x08,0x10,0x08,0x10,0x13,0xff,0x64,0x10,0x14,0x10,0x08,0xfe,0x0c,0x00,0x12,0xff,0x7d,0x82,0x09,0x28,0x28,0x28,0x2a,0x28,0x29,0x48,0x29,0x49,0x48,0x89,0x09,0x07}}, // 続
{0x4234,0x91B2,0xC2B4,0xE58D92,0x5352,{0x00,0x80,0x00,0x80,0x3f,0xfe,0x04,0x10,0x04,0x10,0x06,0x18,0x09,0x24,0x10,0xc2,0x20,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 卒
{0x4235,0x91B3,0xC2B5,0xE8A296,0x8896,{0x08,0x10,0x08,0x10,0x08,0x10,0x7e,0x10,0x02,0xfe,0x04,0x92,0x04,0x92,0x09,0x92,0x1e,0x92,0x2a,0xfe,0x49,0x92,0x08,0x92,0x08,0x92,0x08,0x92,0x08,0xfe,0x08,0x82}}, // 袖
{0x4236,0x91B4,0xC2B6,0xE585B6,0x5176,{0x04,0x10,0x04,0x10,0x3f,0xfe,0x04,0x10,0x04,0x10,0x07,0xf0,0x04,0x10,0x04,0x10,0x07,0xf0,0x04,0x10,0x04,0x10,0x7f,0xff,0x00,0x00,0x02,0x30,0x0c,0x0c,0x30,0x02}}, // 其
{0x4237,0x91B5,0xC2B7,0xE68F83,0x63C3,{0x11,0x04,0x10,0x84,0x10,0x88,0x17,0xff,0x7c,0x00,0x13,0xc2,0x12,0x52,0x12,0x52,0x1f,0xd2,0x72,0x52,0x12,0x52,0x13,0xd2,0x12,0x42,0x12,0x42,0x12,0xc6,0x32,0x42}}, // 揃
{0x4238,0x91B6,0xC2B8,0xE5AD98,0x5B58,{0x01,0x00,0x01,0x00,0x01,0x00,0x7f,0xff,0x02,0x00,0x05,0xfc,0x14,0x08,0x18,0x10,0x10,0x20,0x30,0x20,0x57,0xff,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0xe0,0x10,0x20}}, // 存
{0x4239,0x91B7,0xC2B9,0xE5ADAB,0x5B6B,{0x00,0x04,0x7e,0x18,0x03,0xe0,0x04,0x20,0x08,0x44,0x09,0xc8,0x08,0x30,0x0c,0x28,0x18,0x44,0x6b,0xfa,0x08,0x21,0x08,0xa8,0x08,0xa4,0x09,0x22,0x0a,0x22,0x18,0x20}}, // 孫
{0x423A,0x91B8,0xC2BA,0xE5B08A,0x5C0A,{0x08,0x10,0x04,0x20,0x7f,0xfe,0x02,0x40,0x1f,0xf8,0x12,0x48,0x14,0x48,0x1f,0xf8,0x10,0x08,0x1f,0xf8,0x00,0x20,0x7f,0xfe,0x08,0x20,0x04,0x20,0x04,0x20,0x00,0x60}}, // 尊
{0x423B,0x91B9,0xC2BB,0xE6908D,0x640D,{0x10,0x00,0x13,0xfc,0x12,0x04,0x12,0x04,0x7f,0xfc,0x10,0x00,0x13,0xfc,0x12,0x04,0x1f,0xfc,0x72,0x04,0x13,0xfc,0x12,0x04,0x13,0xfc,0x10,0x88,0x31,0x04,0x16,0x02}}, // 損
{0x423C,0x91BA,0xC2BC,0xE69D91,0x6751,{0x08,0x04,0x08,0x04,0x08,0x04,0x7f,0xff,0x08,0x04,0x08,0x04,0x1c,0x84,0x1a,0x44,0x19,0x24,0x29,0x24,0x28,0x04,0x48,0x04,0x08,0x04,0x08,0x04,0x08,0x1c,0x08,0x04}}, // 村
{0x423D,0x91BB,0xC2BD,0xE9819C,0x905C,{0x00,0x02,0x27,0x8c,0x10,0xf8,0x11,0x08,0x01,0x32,0x01,0x14,0x01,0x4c,0x79,0x92,0x0f,0x7d,0x09,0x08,0x09,0x2c,0x09,0x2a,0x09,0x49,0x17,0x08,0x22,0x00,0x41,0xff}}, // 遜
{0x423E,0x91BC,0xC2BE,0xE4BB96,0x4ED6,{0x04,0x10,0x04,0x10,0x04,0x90,0x08,0x92,0x08,0x9e,0x18,0xf2,0x1b,0x92,0x28,0x92,0x48,0x92,0x08,0x92,0x08,0x9c,0x08,0x90,0x08,0x81,0x08,0x81,0x08,0x41,0x08,0x3f}}, // 他
{0x423F,0x91BD,0xC2BF,0xE5A49A,0x591A,{0x01,0x00,0x01,0xf0,0x02,0x10,0x04,0x20,0x0a,0x40,0x31,0x80,0x01,0x20,0x02,0x3e,0x0c,0x42,0x30,0x84,0x03,0x48,0x0c,0x30,0x00,0x20,0x00,0xc0,0x03,0x00,0x3c,0x00}}, // 多
{0x4240,0x91BE,0xC2C0,0xE5A4AA,0x592A,{0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x82,0x7f,0xff,0x01,0x40,0x01,0x40,0x01,0x20,0x02,0x20,0x02,0x10,0x05,0x10,0x04,0x88,0x08,0x44,0x10,0x42,0x60,0x01}}, // 太
{0x4241,0x91BF,0xC2C1,0xE6B1B0,0x6C70,{0x10,0x40,0x08,0x40,0x08,0x40,0x00,0x40,0x00,0x40,0x4f,0xff,0x20,0x60,0x20,0xa0,0x08,0xa0,0x08,0x90,0x11,0x10,0x11,0x88,0x21,0x48,0x22,0x44,0x44,0x02,0x48,0x01}}, // 汰
{0x4242,0x91C0,0xC2C2,0xE8A991,0x8A51,{0x00,0x10,0x3e,0x10,0x00,0x10,0x7f,0xff,0x00,0x82,0x3e,0x80,0x01,0x40,0x00,0x44,0x3e,0x48,0x00,0x70,0x3e,0x40,0x22,0x40,0x22,0x40,0x22,0x42,0x3e,0x22,0x22,0x1e}}, // 詑
{0x4243,0x91C1,0xC2C3,0xE594BE,0x553E,{0x00,0x04,0x00,0x18,0x79,0xe0,0x48,0x20,0x4b,0xfe,0x49,0x24,0x49,0x24,0x49,0x24,0x4f,0xff,0x49,0x24,0x49,0x24,0x7b,0xfe,0x48,0x20,0x00,0x20,0x07,0xff,0x00,0x00}}, // 唾
{0x4244,0x91C2,0xC2C4,0xE5A095,0x5815,{0x00,0x40,0x3c,0x40,0x27,0xfe,0x28,0x40,0x30,0xfc,0x28,0x84,0x25,0xfc,0x25,0x84,0x3a,0xfc,0x24,0x84,0x20,0x8c,0x20,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 堕
{0x4245,0x91C3,0xC2C5,0xE5A6A5,0x59A5,{0x00,0x04,0x00,0x38,0x1f,0xc4,0x00,0x84,0x08,0x48,0x04,0x48,0x05,0x10,0x01,0x00,0x7f,0xff,0x02,0x10,0x02,0x10,0x04,0x20,0x0f,0xc0,0x00,0xb0,0x03,0x08,0x3c,0x04}}, // 妥
{0x4246,0x91C4,0xC2C6,0xE683B0,0x60F0,{0x08,0x20,0x08,0x20,0x09,0xff,0x08,0x40,0x2c,0x7e,0x2a,0x90,0x29,0xff,0x2a,0x00,0x48,0xfe,0x08,0x82,0x08,0xfe,0x08,0x82,0x08,0xfe,0x08,0x82,0x08,0x82,0x08,0x86}}, // 惰
{0x4247,0x91C5,0xC2C7,0xE68993,0x6253,{0x08,0x00,0x08,0x00,0x09,0xff,0x08,0x08,0x7e,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0e,0x08,0x18,0x08,0x68,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x18,0x38,0x08,0x08}}, // 打
{0x4248,0x91C6,0xC2C8,0xE69F81,0x67C1,{0x08,0x10,0x08,0x10,0x08,0x10,0x7e,0xff,0x08,0x82,0x09,0x40,0x1c,0x40,0x1a,0x44,0x1a,0x58,0x28,0x60,0x28,0x40,0x48,0x40,0x08,0x40,0x08,0x42,0x08,0x22,0x08,0x1e}}, // 柁
{0x4249,0x91C7,0xC2C9,0xE888B5,0x8235,{0x04,0x10,0x08,0x10,0x1f,0x10,0x11,0x7f,0x19,0x62,0x15,0xa0,0x15,0x20,0x13,0xa4,0x1d,0x24,0x71,0x28,0x19,0x30,0x15,0x20,0x15,0x21,0x21,0x21,0x21,0x11,0x43,0x0f}}, // 舵
{0x424A,0x91C8,0xC2CA,0xE6A595,0x6955,{0x08,0x20,0x08,0x20,0x09,0xff,0x7e,0x40,0x08,0x7e,0x08,0x90,0x1d,0x7f,0x1a,0x00,0x1a,0xfc,0x28,0x84,0x28,0xfc,0x48,0x84,0x08,0xfc,0x08,0x84,0x08,0x84,0x08,0x8c}}, // 楕
{0x424B,0x91C9,0xC2CB,0xE99980,0x9640,{0x00,0x10,0x3e,0x10,0x22,0x10,0x24,0xff,0x28,0x82,0x29,0x40,0x24,0x40,0x22,0x44,0x22,0x58,0x22,0x60,0x22,0x40,0x22,0x40,0x2c,0x40,0x20,0x41,0x20,0x21,0x20,0x1f}}, // 陀
{0x424C,0x91CA,0xC2CC,0xE9A784,0x99C4,{0x00,0x10,0x3f,0x90,0x24,0x10,0x24,0xff,0x3f,0x10,0x24,0x10,0x3f,0x10,0x24,0x18,0x24,0x28,0x3f,0xa8,0x04,0xa8,0x32,0xa8,0x2a,0xe4,0x28,0x94,0x40,0x92,0x03,0x01}}, // 駄
{0x424D,0x91CB,0xC2CD,0xE9A8A8,0x9A28,{0x00,0x91,0x3f,0x49,0x24,0x4a,0x24,0x7e,0x3f,0x4a,0x24,0x4a,0x3f,0x7e,0x24,0x4a,0x24,0x4a,0x3f,0xfe,0x04,0x88,0x32,0xff,0x2a,0x88,0x28,0x88,0x41,0x08,0x06,0x08}}, // 騨
{0x424E,0x91CC,0xC2CE,0xE4BD93,0x4F53,{0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x17,0xff,0x10,0x70,0x10,0x70,0x30,0xa8,0x50,0xa8,0x11,0x24,0x12,0x22,0x14,0xfd,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20}}, // 体
{0x424F,0x91CD,0xC2CF,0xE5A086,0x5806,{0x00,0x44,0x08,0x44,0x08,0x88,0x08,0xff,0x09,0x88,0x7e,0x88,0x08,0x88,0x08,0xfe,0x08,0x88,0x08,0x88,0x08,0xfe,0x0e,0x88,0x18,0x88,0x60,0x88,0x00,0xff,0x00,0x80}}, // 堆
{0x4250,0x91CE,0xC2D0,0xE5AFBE,0x5BFE,{0x04,0x04,0x04,0x04,0x04,0x04,0x7f,0xc4,0x01,0x7f,0x01,0x04,0x11,0x04,0x0a,0x44,0x06,0x24,0x02,0x14,0x05,0x14,0x09,0x04,0x08,0x84,0x10,0x84,0x20,0x0c,0x40,0x04}}, // 対
{0x4251,0x91CF,0xC2D1,0xE88090,0x8010,{0x00,0x04,0x7f,0xc4,0x04,0x04,0x04,0x04,0x08,0x7f,0x3f,0x84,0x2a,0x84,0x2a,0xa4,0x2a,0x94,0x2a,0x94,0x2a,0x84,0x2a,0x84,0x2a,0x84,0x2a,0x84,0x2a,0x84,0x21,0x8c}}, // 耐
{0x4252,0x91D0,0xC2D2,0xE5B2B1,0x5CB1,{0x04,0x48,0x04,0x44,0x08,0x44,0x0f,0xff,0x10,0x20,0x30,0x20,0x50,0x12,0x10,0x0a,0x10,0x86,0x10,0x82,0x20,0x84,0x20,0x84,0x20,0x84,0x20,0x84,0x3f,0xfc,0x20,0x04}}, // 岱
{0x4253,0x91D1,0xC2D3,0xE5B8AF,0x5E2F,{0x08,0x88,0x08,0x88,0x7f,0xff,0x08,0x88,0x08,0x88,0x0f,0xf8,0x00,0x00,0x7f,0xfe,0x40,0x82,0x4f,0xfa,0x08,0x88,0x08,0x88,0x08,0x88,0x08,0xb0,0x08,0x80,0x00,0x80}}, // 帯
{0x4254,0x91D2,0xC2D4,0xE5BE85,0x5F85,{0x04,0x20,0x04,0x20,0x09,0xfe,0x08,0x20,0x12,0x20,0x22,0x20,0x05,0xff,0x04,0x04,0x08,0x04,0x1b,0xff,0x28,0x84,0x48,0x44,0x08,0x44,0x08,0x04,0x08,0x1c,0x08,0x04}}, // 待
{0x4255,0x91D3,0xC2D5,0xE680A0,0x6020,{0x01,0x00,0x01,0x60,0x02,0x18,0x04,0xf4,0x7f,0x02,0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x00,0x80,0x12,0x44,0x12,0x42,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 怠
{0x4256,0x91D4,0xC2D6,0xE6858B,0x614B,{0x08,0x20,0x0a,0x26,0x11,0x38,0x7f,0xa1,0x11,0x9f,0x1f,0x20,0x11,0x26,0x1f,0x38,0x11,0x21,0x13,0x1f,0x00,0x80,0x12,0x44,0x12,0x42,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 態
{0x4257,0x91D5,0xC2D7,0xE688B4,0x6234,{0x02,0x18,0x1f,0xd4,0x02,0x14,0x7f,0xff,0x00,0x10,0x1f,0xd2,0x12,0x52,0x1f,0xd2,0x12,0x54,0x1f,0xcc,0x09,0x08,0x3f,0xe8,0x09,0x15,0x7f,0xe5,0x09,0x43,0x30,0x81}}, // 戴
{0x4258,0x91D6,0xC2D8,0xE69BBF,0x66FF,{0x04,0x10,0x04,0x10,0x3f,0x7e,0x04,0x10,0x04,0x10,0x7f,0xff,0x0a,0x28,0x11,0x44,0x20,0x82,0x4f,0xf1,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10}}, // 替
{0x4259,0x91D7,0xC2D9,0xE6B3B0,0x6CF0,{0x00,0x80,0x00,0x80,0x3f,0xfe,0x00,0x80,0x1f,0xfc,0x01,0x40,0x02,0x20,0x7f,0xff,0x08,0x90,0x10,0x8c,0x6c,0xcb,0x03,0xd0,0x02,0xa0,0x0c,0x90,0x30,0x8c,0x01,0x80}}, // 泰
{0x425A,0x91D8,0xC2DA,0xE6BB9E,0x6EDE,{0x11,0x24,0x09,0x24,0x0f,0xff,0x01,0x24,0x41,0x24,0x21,0xfc,0x20,0x00,0x07,0xff,0x04,0x21,0x0c,0x21,0x11,0xfe,0x11,0x22,0x21,0x22,0x21,0x2c,0x41,0x20,0x40,0x20}}, // 滞
{0x425B,0x91D9,0xC2DB,0xE8838E,0x80CE,{0x00,0x20,0x3e,0x20,0x22,0x20,0x22,0x48,0x22,0x44,0x3e,0x8e,0x23,0xf2,0x22,0x01,0x22,0x01,0x3e,0xfc,0x22,0x84,0x22,0x84,0x22,0x84,0x22,0x84,0x26,0xfc,0x42,0x84}}, // 胎
{0x425C,0x91DA,0xC2DC,0xE885BF,0x817F,{0x00,0x00,0x3c,0x3e,0x25,0x22,0x24,0xa2,0x24,0xbe,0x3c,0x22,0x24,0x22,0x27,0xbe,0x24,0xa9,0x3c,0xaa,0x24,0xa4,0x24,0xa4,0x25,0xb2,0x25,0x61,0x2e,0x30,0x44,0x0f}}, // 腿
{0x425D,0x91DB,0xC2DD,0xE88B94,0x82D4,{0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x10,0x01,0x00,0x01,0x20,0x02,0x18,0x04,0xf4,0x7f,0x02,0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 苔
{0x425E,0x91DC,0xC2DE,0xE8A28B,0x888B,{0x04,0x28,0x04,0x24,0x0b,0xfe,0x18,0x20,0x28,0x20,0x48,0x12,0x08,0x0a,0x08,0x86,0x00,0x82,0x7f,0xff,0x02,0x88,0x04,0x48,0x1c,0x30,0x64,0x90,0x07,0x0c,0x38,0x03}}, // 袋
{0x425F,0x91DD,0xC2DF,0xE8B2B8,0x8CB8,{0x04,0x48,0x04,0x44,0x0b,0xff,0x18,0x20,0x28,0x12,0x48,0x0a,0x0f,0xfe,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x02,0x30,0x0c,0x0c,0x30,0x02}}, // 貸
{0x4260,0x91DE,0xC2E0,0xE98080,0x9000,{0x00,0x00,0x21,0xf8,0x11,0x08,0x11,0x08,0x01,0xf8,0x01,0x08,0x01,0x08,0x79,0xfa,0x09,0x24,0x09,0x28,0x09,0x10,0x09,0xc8,0x0f,0x04,0x14,0x02,0x23,0x00,0x40,0xff}}, // 退
{0x4261,0x91DF,0xC2E1,0xE980AE,0x902E,{0x00,0x20,0x20,0x20,0x13,0xfc,0x10,0x24,0x07,0xff,0x00,0x24,0x03,0xfc,0x7a,0x24,0x09,0x24,0x09,0x28,0x08,0x70,0x09,0xac,0x0e,0x23,0x14,0x60,0x23,0x00,0x40,0xff}}, // 逮
{0x4262,0x91E0,0xC2E2,0xE99A8A,0x968A,{0x01,0x08,0x3c,0x88,0x24,0x90,0x27,0xff,0x28,0x40,0x30,0xa2,0x2b,0x2a,0x28,0x5c,0x24,0x98,0x27,0x34,0x24,0x54,0x24,0x92,0x3b,0x11,0x20,0x10,0x20,0x20,0x20,0xc0}}, // 隊
{0x4263,0x91E1,0xC2E3,0xE9BB9B,0x9EDB,{0x04,0x28,0x08,0x24,0x1b,0xff,0x68,0x20,0x08,0x11,0x0f,0xfd,0x08,0x8b,0x0f,0xf9,0x08,0x88,0x0f,0xf8,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x12,0x24,0x61,0x13}}, // 黛
{0x4264,0x91E2,0xC2E4,0xE9AF9B,0x9BDB,{0x08,0x00,0x0e,0x7e,0x12,0x52,0x24,0x52,0x7f,0x7e,0x29,0x52,0x29,0x52,0x3f,0x7e,0x29,0x42,0x29,0x7a,0x3f,0x6a,0x05,0x6a,0x32,0xfa,0x2a,0xaa,0x28,0x82,0x41,0x06}}, // 鯛
{0x4265,0x91E3,0xC2E5,0xE4BBA3,0x4EE3,{0x04,0x28,0x04,0x24,0x04,0x22,0x08,0x20,0x08,0x20,0x18,0x3f,0x1b,0xe0,0x28,0x20,0x48,0x10,0x08,0x10,0x08,0x10,0x08,0x08,0x08,0x09,0x08,0x05,0x08,0x03,0x08,0x01}}, // 代
{0x4266,0x91E4,0xC2E6,0xE58FB0,0x53F0,{0x01,0x00,0x01,0x00,0x02,0x20,0x02,0x10,0x04,0x08,0x08,0xfc,0x7f,0x04,0x00,0x02,0x00,0x02,0x1f,0xf8,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x08}}, // 台
{0x4267,0x91E5,0xC2E7,0xE5A4A7,0x5927,{0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x82,0x7f,0xff,0x00,0x80,0x00,0x80,0x01,0x40,0x01,0x40,0x02,0x20,0x02,0x20,0x04,0x10,0x08,0x08,0x10,0x04,0x60,0x03}}, // 大
{0x4268,0x91E6,0xC2E8,0xE7ACAC,0x7B2C,{0x10,0x20,0x10,0x20,0x1f,0xbf,0x24,0x50,0x42,0x88,0x3f,0xfc,0x00,0x84,0x00,0x84,0x1f,0xfc,0x10,0x80,0x1f,0xfe,0x01,0x82,0x02,0x82,0x0c,0x84,0x70,0x98,0x00,0x80}}, // 第
{0x4269,0x91E7,0xC2E9,0xE9868D,0x918D,{0x00,0x00,0x7f,0xfc,0x0c,0x44,0x0c,0x7c,0x3f,0x44,0x2d,0x44,0x2d,0x7c,0x35,0x00,0x37,0xff,0x21,0x10,0x21,0x50,0x3f,0x5e,0x21,0x50,0x21,0x70,0x3f,0x98,0x21,0x07}}, // 醍
{0x426A,0x91E8,0xC2EA,0xE9A18C,0x984C,{0x00,0x00,0x3f,0xff,0x22,0x10,0x3e,0x20,0x22,0x7e,0x22,0x42,0x3e,0x7e,0x00,0x42,0x7f,0xfe,0x08,0x42,0x28,0x42,0x2f,0x7e,0x38,0x14,0x28,0x22,0x26,0x42,0x41,0xff}}, // 題
{0x426B,0x91E9,0xC2EB,0xE9B7B9,0x9DF9,{0x00,0x40,0x1f,0xff,0x12,0x48,0x12,0xfe,0x15,0x90,0x1e,0xfe,0x14,0x90,0x14,0xff,0x11,0x00,0x13,0xf8,0x12,0x08,0x13,0xff,0x22,0x00,0x2b,0xfe,0x4a,0xaa,0x11,0x4c}}, // 鷹
{0x426C,0x91EA,0xC2EC,0xE6BB9D,0x6EDD,{0x10,0x40,0x08,0x40,0x0b,0xfe,0x01,0x08,0x40,0x90,0x27,0xff,0x20,0x00,0x03,0xfc,0x0a,0x44,0x0a,0x44,0x13,0xfc,0x12,0x44,0x23,0xfc,0x22,0x41,0x40,0x41,0x40,0x3f}}, // 滝
{0x426D,0x91EB,0xC2ED,0xE780A7,0x7027,{0x21,0x10,0x11,0x10,0x1f,0xff,0x04,0x50,0x02,0x9e,0x4f,0xe2,0x20,0x1e,0x27,0xd0,0x04,0x5f,0x17,0xd0,0x14,0x5f,0x27,0xd0,0x24,0x5f,0x24,0x50,0x44,0x51,0x44,0xcf}}, // 瀧
{0x426E,0x91EC,0xC2EE,0xE58D93,0x5353,{0x00,0x80,0x00,0x80,0x00,0xfc,0x00,0x80,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80}}, // 卓
{0x426F,0x91ED,0xC2EF,0xE59584,0x5544,{0x00,0x00,0x07,0xff,0x78,0x40,0x48,0xc2,0x49,0x22,0x4e,0x24,0x48,0x68,0x48,0x90,0x49,0x18,0x4e,0x38,0x78,0x54,0x48,0x92,0x03,0x11,0x0c,0x10,0x00,0x10,0x00,0x60}}, // 啄
{0x4270,0x91EE,0xC2F0,0xE5AE85,0x5B85,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x20,0x10,0x40,0x60,0x1f,0x80,0x02,0x00,0x02,0x0e,0x03,0xf0,0x7e,0x00,0x02,0x00,0x02,0x00,0x02,0x04,0x01,0x04,0x00,0xfc}}, // 宅
{0x4271,0x91EF,0xC2F1,0xE68998,0x6258,{0x08,0x04,0x08,0x18,0x09,0xe0,0x08,0x40,0x7e,0x40,0x08,0x40,0x08,0x4f,0x0b,0xf0,0x0e,0x40,0x78,0x40,0x08,0x40,0x08,0x40,0x08,0x40,0x08,0x42,0x08,0x22,0x18,0x1e}}, // 托
{0x4272,0x91F0,0xC2F2,0xE68A9E,0x629E,{0x10,0x00,0x10,0xfe,0x10,0x82,0x10,0x82,0x7c,0x82,0x10,0x82,0x10,0xfe,0x10,0xa2,0x1c,0xa0,0x70,0x90,0x10,0x90,0x11,0x08,0x11,0x08,0x12,0x04,0x14,0x02,0x38,0x01}}, // 択
{0x4273,0x91F1,0xC2F3,0xE68B93,0x62D3,{0x10,0x00,0x13,0xff,0x10,0x40,0x10,0x40,0x7c,0x40,0x10,0x40,0x10,0x80,0x10,0xfe,0x11,0x82,0x1d,0x82,0x72,0x82,0x14,0x82,0x10,0x82,0x10,0x82,0x10,0xfe,0x30,0x82}}, // 拓
{0x4274,0x91F2,0xC2F4,0xE6B2A2,0x6CA2,{0x10,0x00,0x09,0xfc,0x09,0x04,0x01,0x04,0x41,0x04,0x21,0x04,0x21,0xfc,0x01,0x24,0x09,0x20,0x09,0x20,0x11,0x10,0x12,0x10,0x22,0x08,0x24,0x04,0x48,0x02,0x50,0x01}}, // 沢
{0x4275,0x91F3,0xC2F5,0xE6BFAF,0x6FEF,{0x10,0x00,0x0f,0xdf,0x08,0x41,0x03,0xcf,0x40,0x41,0x27,0xdf,0x20,0x88,0x00,0x90,0x09,0xfe,0x0b,0x20,0x15,0xfc,0x11,0x20,0x21,0xfc,0x21,0x20,0x41,0xff,0x41,0x00}}, // 濯
{0x4276,0x91F4,0xC2F6,0xE790A2,0x7422,{0x00,0x00,0x7f,0xff,0x10,0x40,0x10,0x44,0x10,0xa4,0x13,0x24,0x7c,0x28,0x10,0x58,0x10,0x98,0x13,0x34,0x10,0x34,0x1c,0x52,0x70,0x91,0x03,0x10,0x00,0x10,0x00,0x60}}, // 琢
{0x4277,0x91F5,0xC2F7,0xE8A897,0x8A17,{0x00,0x04,0x3e,0x18,0x00,0xe0,0x7f,0x20,0x00,0x20,0x3e,0x20,0x00,0x20,0x01,0xff,0x3e,0x20,0x00,0x20,0x3e,0x20,0x22,0x20,0x22,0x22,0x22,0x22,0x3e,0x1e,0x22,0x00}}, // 託
{0x4278,0x91F6,0xC2F8,0xE990B8,0x9438,{0x08,0x00,0x08,0xfe,0x14,0xaa,0x12,0xaa,0x20,0xfe,0x7e,0x10,0x08,0xfe,0x08,0x10,0x7f,0xff,0x08,0x44,0x4a,0x28,0x2d,0xff,0x28,0x10,0x0e,0xfe,0x18,0x10,0x60,0x10}}, // 鐸
{0x4279,0x91F7,0xC2F9,0xE6BF81,0x6FC1,{0x10,0x00,0x0f,0xfc,0x0c,0xa4,0x04,0xa4,0x47,0xfc,0x21,0x00,0x21,0xfe,0x01,0x42,0x0b,0xfa,0x0b,0x4a,0x15,0xfa,0x10,0x62,0x20,0x52,0x20,0xfa,0x47,0x0a,0x40,0x0c}}, // 濁
{0x427A,0x91F8,0xC2FA,0xE8ABBE,0x8AFE,{0x00,0x44,0x3e,0x44,0x01,0xff,0x7f,0x44,0x00,0x54,0x3e,0x10,0x00,0x10,0x01,0xff,0x3e,0x20,0x00,0x20,0x3e,0x7e,0x22,0xa2,0x23,0x22,0x22,0x22,0x3e,0x3e,0x22,0x22}}, // 諾
{0x427B,0x91F9,0xC2FB,0xE88CB8,0x8338,{0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x10,0x00,0x00,0x7f,0xff,0x04,0x10,0x04,0x10,0x07,0xf0,0x04,0x10,0x07,0xf0,0x04,0x10,0x04,0x1e,0x07,0xf0,0x7c,0x10,0x00,0x10}}, // 茸
{0x427C,0x91FA,0xC2FC,0xE587A7,0x51E7,{0x00,0x00,0x1f,0xf8,0x10,0x08,0x11,0x08,0x11,0x08,0x17,0xe8,0x15,0x28,0x15,0x28,0x15,0x28,0x15,0x28,0x15,0x28,0x15,0x48,0x15,0x05,0x21,0x05,0x21,0x03,0x41,0x01}}, // 凧
{0x427D,0x91FB,0xC2FD,0xE89BB8,0x86F8,{0x08,0x10,0x08,0x92,0x08,0x52,0x08,0x54,0x3f,0x10,0x29,0x7e,0x29,0x42,0x29,0x42,0x3f,0x7e,0x28,0x42,0x0c,0x42,0x0a,0x7e,0x09,0x42,0x0f,0x42,0x71,0x46,0x00,0x42}}, // 蛸
{0x427E,0x91FC,0xC2FE,0xE58FAA,0x53EA,{0x00,0x00,0x00,0x00,0x1f,0xf8,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x08,0x04,0x20,0x04,0x10,0x08,0x08,0x10,0x04,0x20,0x04}}, // 只
{0x4321,0x9240,0xC3A1,0xE58FA9,0x53E9,{0x00,0x00,0x3e,0x7e,0x22,0x42,0x22,0x42,0x22,0x42,0x22,0x42,0x22,0x42,0x22,0x42,0x22,0x42,0x22,0x42,0x3e,0x42,0x22,0x5c,0x20,0x40,0x00,0x40,0x00,0x40,0x00,0x40}}, // 叩
{0x4322,0x9241,0xC3A2,0xE4BD86,0x4F46,{0x04,0x00,0x05,0xfc,0x05,0x04,0x09,0x04,0x09,0x04,0x19,0x04,0x19,0xfc,0x29,0x04,0x49,0x04,0x09,0x04,0x09,0xfc,0x09,0x04,0x08,0x00,0x08,0x00,0x0f,0xff,0x08,0x00}}, // 但
{0x4323,0x9242,0xC3A3,0xE98194,0x9054,{0x00,0x20,0x20,0x20,0x11,0xfc,0x10,0x20,0x07,0xff,0x00,0x88,0x00,0x50,0x7b,0xfe,0x08,0x20,0x09,0xfc,0x08,0x20,0x0b,0xfe,0x0c,0x20,0x14,0x20,0x23,0x20,0x40,0xff}}, // 達
{0x4324,0x9243,0xC3A4,0xE8BEB0,0x8FB0,{0x00,0x00,0x1f,0xfe,0x10,0x00,0x10,0x00,0x17,0xfc,0x10,0x00,0x10,0x00,0x1f,0xff,0x12,0x84,0x12,0x84,0x12,0x48,0x12,0x50,0x22,0x20,0x22,0x90,0x43,0x0c,0x1c,0x03}}, // 辰
{0x4325,0x9244,0xC3A5,0xE5A5AA,0x596A,{0x00,0x80,0x7f,0xff,0x01,0x40,0x06,0x30,0x1a,0x4c,0x67,0xfb,0x0c,0x40,0x37,0xf8,0x04,0x40,0x07,0xf8,0x00,0x10,0x7f,0xff,0x04,0x10,0x02,0x10,0x02,0x10,0x00,0x30}}, // 奪
{0x4326,0x9245,0xC3A6,0xE884B1,0x8131,{0x00,0x44,0x1e,0x24,0x12,0x28,0x12,0x7e,0x12,0x42,0x1e,0x42,0x12,0x42,0x12,0x42,0x12,0x7e,0x1e,0x28,0x12,0x28,0x12,0x28,0x12,0x48,0x22,0x49,0x26,0x89,0x43,0x07}}, // 脱
{0x4327,0x9246,0xC3A7,0xE5B7BD,0x5DFD,{0x00,0x00,0x3e,0x7c,0x02,0x04,0x3e,0x7c,0x20,0x40,0x21,0x42,0x1f,0x3e,0x00,0x00,0x02,0x20,0x1f,0xfc,0x02,0x20,0x02,0x20,0x7f,0xff,0x02,0x60,0x0c,0x18,0x30,0x04}}, // 巽
{0x4328,0x9247,0xC3A8,0xE7ABAA,0x7AEA,{0x00,0x00,0x3f,0x7c,0x24,0x04,0x3f,0x44,0x21,0x28,0x3f,0x28,0x24,0x10,0x3f,0x28,0x20,0xc6,0x00,0x80,0x3f,0xfe,0x04,0x10,0x02,0x10,0x02,0x20,0x7f,0xff,0x00,0x00}}, // 竪
{0x4329,0x9248,0xC3A9,0xE8BEBF,0x8FBF,{0x00,0x20,0x20,0x20,0x10,0x20,0x11,0x24,0x01,0x24,0x01,0x24,0x01,0x24,0x79,0x24,0x09,0x24,0x09,0x24,0x09,0x24,0x09,0x24,0x0d,0xfc,0x15,0x04,0x23,0x00,0x40,0xff}}, // 辿
{0x432A,0x9249,0xC3AA,0xE6A39A,0x68DA,{0x10,0x00,0x13,0xde,0x12,0x52,0x7e,0x52,0x12,0x52,0x13,0xde,0x3a,0x52,0x36,0x52,0x32,0x52,0x53,0xde,0x52,0x52,0x12,0x52,0x12,0x52,0x12,0x52,0x14,0xe6,0x18,0x42}}, // 棚
{0x432B,0x924A,0xC3AB,0xE8B0B7,0x8C37,{0x04,0x10,0x04,0x08,0x08,0x08,0x08,0x84,0x10,0x84,0x21,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x6f,0xfb,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 谷
{0x432C,0x924B,0xC3AC,0xE78BB8,0x72F8,{0x04,0x00,0x47,0xfc,0x29,0x24,0x11,0x24,0x11,0xfc,0x29,0x24,0x49,0x24,0x09,0x24,0x19,0xfc,0x18,0x20,0x28,0x20,0x4b,0xfe,0x08,0x20,0x08,0x20,0x6f,0xff,0x10,0x00}}, // 狸
{0x432D,0x924C,0xC3AD,0xE9B188,0x9C48,{0x10,0x00,0x1e,0xfe,0x12,0x10,0x24,0xff,0x7f,0x92,0x29,0xde,0x29,0x10,0x3f,0xdc,0x29,0x00,0x29,0xfc,0x3f,0x04,0x05,0x04,0x32,0xfc,0x2a,0x04,0x28,0xfc,0x40,0x04}}, // 鱈
{0x432E,0x924D,0xC3AE,0xE6A8BD,0x6A3D,{0x08,0x84,0x08,0x48,0x09,0xff,0x7e,0x50,0x09,0xfc,0x09,0x54,0x1d,0x9c,0x1b,0x04,0x1b,0xfc,0x29,0x04,0x29,0xfc,0x48,0x08,0x0b,0xff,0x08,0x88,0x08,0x48,0x08,0x18}}, // 樽
{0x432F,0x924E,0xC3AF,0xE8AAB0,0x8AB0,{0x00,0x24,0x3e,0x24,0x00,0x48,0x7f,0x7f,0x00,0xc8,0x3e,0xc8,0x01,0x48,0x00,0x7e,0x3e,0x48,0x00,0x48,0x3e,0x7e,0x22,0x48,0x22,0x48,0x22,0x48,0x3e,0x7f,0x22,0x40}}, // 誰
{0x4330,0x924F,0xC3B0,0xE4B8B9,0x4E39,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x0a,0x08,0x09,0x08,0x08,0x88,0x08,0x88,0x08,0x08,0x7f,0xff,0x08,0x08,0x08,0x08,0x08,0x08,0x10,0x08,0x10,0x08,0x20,0x08,0x40,0x18}}, // 丹
{0x4331,0x9250,0xC3B1,0xE58D98,0x5358,{0x09,0x08,0x04,0x88,0x04,0x90,0x0f,0xfc,0x08,0x84,0x08,0x84,0x0f,0xfc,0x08,0x84,0x08,0x84,0x0f,0xfc,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80}}, // 単
{0x4332,0x9251,0xC3B2,0xE59886,0x5606,{0x00,0x88,0x00,0x88,0x7f,0xff,0x48,0x88,0x4b,0xfe,0x4a,0x22,0x4a,0x22,0x4b,0xfe,0x48,0x20,0x4b,0xfc,0x48,0x20,0x7f,0xff,0x48,0x50,0x00,0x88,0x01,0x04,0x06,0x03}}, // 嘆
{0x4333,0x9252,0xC3B3,0xE59DA6,0x5766,{0x10,0x00,0x11,0xfc,0x11,0x04,0x11,0x04,0x7d,0x04,0x11,0x04,0x11,0xfc,0x11,0x04,0x11,0x04,0x17,0x04,0x19,0xfc,0x61,0x04,0x00,0x00,0x00,0x00,0x0f,0xff,0x00,0x00}}, // 坦
{0x4334,0x9253,0xC3B4,0xE68B85,0x62C5,{0x10,0x00,0x11,0xfc,0x11,0x04,0x11,0x04,0x7d,0x04,0x11,0x04,0x11,0xfc,0x11,0x04,0x1d,0x04,0x71,0x04,0x11,0xfc,0x11,0x04,0x10,0x00,0x10,0x00,0x17,0xff,0x30,0x00}}, // 担
{0x4335,0x9254,0xC3B5,0xE68EA2,0x63A2,{0x10,0x00,0x13,0xfe,0x12,0x52,0x12,0x54,0x7c,0x90,0x10,0x92,0x11,0x0e,0x12,0x20,0x10,0x20,0x1f,0xff,0x70,0x68,0x10,0xa4,0x11,0x22,0x12,0x21,0x30,0x20,0x10,0x20}}, // 探
{0x4336,0x9255,0xC3B6,0xE697A6,0x65E6,{0x00,0x00,0x0f,0xf0,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10,0x00,0x00,0x00,0x04,0x7f,0xfe,0x00,0x00}}, // 旦
{0x4337,0x9256,0xC3B7,0xE6AD8E,0x6B4E,{0x12,0x20,0x7f,0xa0,0x12,0x20,0x10,0x3f,0x3f,0x22,0x29,0x54,0x29,0x50,0x3f,0x90,0x08,0x10,0x3f,0x10,0x08,0x18,0x7f,0xa8,0x0c,0x24,0x12,0x44,0x20,0x82,0x41,0x01}}, // 歎
{0x4338,0x9257,0xC3B8,0xE6B7A1,0x6DE1,{0x10,0x40,0x09,0x44,0x09,0x44,0x0a,0x48,0x44,0xa0,0x20,0x90,0x21,0x08,0x26,0x46,0x08,0x40,0x09,0x44,0x11,0x44,0x12,0xa8,0x24,0xa0,0x21,0x10,0x42,0x0c,0x4c,0x03}}, // 淡
{0x4339,0x9258,0xC3B9,0xE6B99B,0x6E5B,{0x10,0x84,0x0b,0xff,0x08,0x84,0x00,0x84,0x40,0xfc,0x20,0x84,0x20,0xfc,0x00,0x84,0x08,0x84,0x0f,0xff,0x12,0x50,0x12,0x52,0x22,0x8e,0x23,0x00,0x43,0xff,0x42,0x00}}, // 湛
{0x433A,0x9259,0xC3BA,0xE782AD,0x70AD,{0x00,0x80,0x10,0x84,0x10,0x84,0x1f,0xfc,0x00,0x00,0x1f,0xff,0x10,0x00,0x10,0x44,0x12,0x44,0x12,0x48,0x12,0x50,0x14,0x40,0x20,0xa0,0x21,0x10,0x46,0x0c,0x18,0x03}}, // 炭
{0x433B,0x925A,0xC3BB,0xE79FAD,0x77ED,{0x00,0x00,0x11,0xfe,0x10,0x00,0x1f,0x00,0x28,0xfc,0x28,0x84,0x48,0x84,0x08,0x84,0x7f,0xfc,0x08,0x04,0x08,0x84,0x14,0x48,0x12,0x48,0x22,0x10,0x21,0xfe,0x40,0x00}}, // 短
{0x433C,0x925B,0xC3BC,0xE7ABAF,0x7AEF,{0x00,0x10,0x08,0x92,0x08,0x92,0x08,0x92,0x08,0xfe,0x7f,0x00,0x05,0xff,0x44,0x20,0x24,0x40,0x29,0xfe,0x29,0x4a,0x0b,0x4a,0x0d,0x4a,0x71,0x4a,0x01,0x4a,0x01,0x06}}, // 端
{0x433D,0x925C,0xC3BD,0xE7AEAA,0x7BAA,{0x10,0x10,0x10,0x10,0x1f,0xbf,0x22,0x50,0x29,0x08,0x44,0x88,0x04,0x90,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80}}, // 箪
{0x433E,0x925D,0xC3BE,0xE7B6BB,0x7DBB,{0x08,0x10,0x08,0x10,0x0a,0x7f,0x72,0x42,0x14,0x80,0x08,0xfe,0x0c,0x10,0x12,0x10,0x7d,0x50,0x08,0x5e,0x2c,0x50,0x2a,0x50,0x2a,0x50,0x2a,0xb0,0x48,0x98,0x09,0x07}}, // 綻
{0x433F,0x925E,0xC3BF,0xE880BD,0x803D,{0x00,0x10,0x7f,0x90,0x12,0x10,0x12,0x7f,0x12,0x52,0x1e,0x50,0x12,0x90,0x12,0x18,0x1e,0x18,0x12,0x18,0x12,0x28,0x13,0x28,0x1e,0x28,0x72,0x49,0x02,0x89,0x03,0x07}}, // 耽
{0x4340,0x925F,0xC3C0,0xE88386,0x80C6,{0x00,0x00,0x3e,0x7c,0x22,0x44,0x22,0x44,0x22,0x44,0x3e,0x44,0x22,0x7c,0x22,0x44,0x22,0x44,0x3e,0x44,0x22,0x7c,0x22,0x44,0x22,0x00,0x22,0x00,0x23,0xff,0x46,0x00}}, // 胆
{0x4341,0x9260,0xC3C1,0xE89B8B,0x86CB,{0x00,0x00,0x7f,0xff,0x00,0x82,0x08,0x80,0x08,0xfc,0x0c,0x80,0x13,0x80,0x20,0xff,0x40,0x80,0x0f,0xf8,0x08,0x88,0x08,0x88,0x0f,0xf8,0x00,0x8c,0x00,0xfa,0x7f,0x01}}, // 蛋
{0x4342,0x9261,0xC3C2,0xE8AA95,0x8A95,{0x00,0x01,0x3d,0xc6,0x00,0x5c,0x7e,0x44,0x00,0x84,0x3d,0x14,0x03,0xd7,0x00,0x54,0x3c,0x54,0x02,0x54,0x3d,0x54,0x24,0x94,0x24,0xff,0x25,0x20,0x3e,0x18,0x24,0x07}}, // 誕
{0x4343,0x9262,0xC3C3,0xE98D9B,0x935B,{0x08,0x40,0x09,0xbc,0x15,0x24,0x13,0x24,0x21,0xe5,0x7f,0x23,0x09,0x40,0x09,0xc0,0x7f,0x3e,0x09,0x02,0x4b,0x14,0x2d,0xd4,0x29,0x08,0x0f,0x14,0x19,0x22,0x61,0x41}}, // 鍛
{0x4344,0x9263,0xC3C4,0xE59BA3,0x56E3,{0x00,0x00,0x3f,0xfe,0x20,0x22,0x20,0x22,0x20,0x22,0x2f,0xfe,0x20,0x22,0x24,0x22,0x22,0x22,0x22,0x22,0x20,0x22,0x20,0x22,0x20,0x62,0x20,0x02,0x3f,0xfe,0x20,0x02}}, // 団
{0x4345,0x9264,0xC3C5,0xE5A387,0x58C7,{0x00,0x20,0x13,0xff,0x10,0x00,0x11,0xfe,0x11,0x7a,0x7d,0x4a,0x11,0x7a,0x11,0x02,0x11,0xfe,0x10,0x84,0x14,0xfc,0x18,0x84,0x60,0xfc,0x00,0x84,0x07,0xff,0x00,0x00}}, // 壇
{0x4346,0x9265,0xC3C6,0xE5BCBE,0x5F3E,{0x02,0x44,0x7d,0x24,0x05,0x28,0x05,0xfc,0x05,0x24,0x3d,0x24,0x21,0xfc,0x21,0x24,0x21,0x24,0x3d,0xfc,0x04,0x20,0x04,0x20,0x07,0xff,0x04,0x20,0x08,0x20,0x30,0x20}}, // 弾
{0x4347,0x9266,0xC3C7,0xE696AD,0x65AD,{0x04,0x02,0x44,0x0c,0x65,0x70,0x55,0x40,0x56,0x40,0x44,0x40,0x7f,0x7f,0x44,0x44,0x4e,0x44,0x4d,0x44,0x55,0x44,0x64,0x44,0x44,0x84,0x44,0x84,0x7f,0x04,0x40,0x04}}, // 断
{0x4348,0x9267,0xC3C8,0xE69A96,0x6696,{0x00,0x04,0x00,0x1a,0x3d,0xe2,0x24,0x24,0x24,0x94,0x24,0x58,0x25,0xfe,0x3c,0x40,0x27,0xff,0x24,0x40,0x24,0x7c,0x24,0xa4,0x3c,0x98,0x25,0x10,0x02,0x6c,0x01,0x83}}, // 暖
{0x4349,0x9268,0xC3C9,0xE6AA80,0x6A80,{0x08,0x20,0x0b,0xff,0x08,0x00,0x7f,0xfe,0x09,0x7a,0x09,0x4a,0x1d,0x7a,0x1b,0x02,0x1b,0xfe,0x28,0x84,0x28,0xfc,0x48,0x84,0x08,0xfc,0x08,0x84,0x0b,0xff,0x08,0x00}}, // 檀
{0x434A,0x9269,0xC3CA,0xE6AEB5,0x6BB5,{0x02,0x00,0x04,0xf8,0x38,0x88,0x20,0x88,0x20,0x8a,0x3c,0x8a,0x21,0x06,0x22,0x00,0x3d,0xf8,0x20,0x88,0x20,0x88,0x3e,0x50,0x60,0x20,0x20,0x50,0x21,0x8c,0x26,0x03}}, // 段
{0x434B,0x926A,0xC3CB,0xE794B7,0x7537,{0x00,0x00,0x1f,0xf8,0x11,0x08,0x11,0x08,0x1f,0xf8,0x11,0x08,0x11,0x08,0x1f,0xf8,0x01,0x00,0x01,0x00,0x3f,0xfc,0x01,0x04,0x02,0x04,0x04,0x04,0x18,0x04,0x60,0x18}}, // 男
{0x434C,0x926B,0xC3CC,0xE8AB87,0x8AC7,{0x00,0x10,0x3e,0x52,0x00,0x52,0x7f,0x54,0x00,0xa8,0x3e,0x28,0x00,0x44,0x3e,0x92,0x00,0x11,0x00,0x52,0x3e,0x52,0x22,0x9c,0x22,0x28,0x22,0x44,0x3e,0x82,0x23,0x01}}, // 談
{0x434D,0x926C,0xC3CD,0xE580A4,0x5024,{0x04,0x10,0x04,0x10,0x07,0xff,0x08,0x10,0x0a,0xfc,0x12,0x84,0x12,0x84,0x32,0xfc,0x52,0x84,0x12,0xfc,0x12,0x84,0x12,0x84,0x12,0xfc,0x12,0x00,0x13,0xff,0x12,0x00}}, // 値
{0x434E,0x926D,0xC3CE,0xE79FA5,0x77E5,{0x10,0x00,0x10,0x00,0x10,0x00,0x1f,0xfe,0x24,0x42,0x24,0x42,0x44,0x42,0x04,0x42,0x7f,0xc2,0x04,0x42,0x0a,0x42,0x09,0x42,0x11,0x7e,0x10,0xc2,0x20,0x80,0x40,0x00}}, // 知
{0x434F,0x926E,0xC3CF,0xE59CB0,0x5730,{0x08,0x10,0x08,0x90,0x08,0x90,0x08,0x92,0x7e,0x9e,0x08,0xf2,0x0b,0x92,0x08,0x92,0x08,0x92,0x08,0x92,0x0a,0x9c,0x0c,0x90,0x10,0x80,0x60,0x81,0x00,0x41,0x00,0x3f}}, // 地
{0x4350,0x926F,0xC3D0,0xE5BC9B,0x5F1B,{0x00,0x10,0x7e,0x90,0x02,0x90,0x02,0x92,0x02,0x9e,0x3e,0xf2,0x21,0x92,0x20,0x92,0x3e,0x92,0x02,0x9c,0x02,0x90,0x02,0x80,0x02,0x81,0x02,0x81,0x04,0x41,0x18,0x3f}}, // 弛
{0x4351,0x9270,0xC3D1,0xE681A5,0x6065,{0x00,0x00,0x7f,0xa0,0x12,0x10,0x12,0x08,0x12,0x28,0x1e,0x20,0x12,0x20,0x12,0x24,0x1e,0xa2,0x12,0xa1,0x12,0xa1,0x12,0xa0,0x1f,0x22,0x72,0x22,0x02,0x1e,0x02,0x00}}, // 恥
{0x4352,0x9271,0xC3D2,0xE699BA,0x667A,{0x10,0x00,0x1f,0xbe,0x14,0x22,0x24,0x22,0x7f,0xe2,0x06,0x22,0x05,0x3e,0x08,0xa2,0x10,0x00,0x6f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 智
{0x4353,0x9272,0xC3D3,0xE6B1A0,0x6C60,{0x10,0x10,0x08,0x90,0x08,0x90,0x00,0x92,0x00,0x9e,0x40,0xf2,0x27,0x92,0x20,0x92,0x08,0x92,0x08,0x92,0x10,0x9c,0x10,0x90,0x20,0x80,0x20,0x81,0x40,0x41,0x40,0x3f}}, // 池
{0x4354,0x9273,0xC3D4,0xE797B4,0x75F4,{0x00,0x40,0x00,0x40,0x0f,0xff,0x4a,0x00,0x2a,0x00,0x2b,0xde,0x2d,0x12,0x0d,0x12,0x19,0x12,0x2f,0xf2,0x49,0x12,0x12,0x92,0x12,0x92,0x24,0x5e,0x44,0x12,0x08,0x00}}, // 痴
{0x4355,0x9274,0xC3D5,0xE7A89A,0x7A1A,{0x02,0x44,0x0c,0x44,0x78,0x88,0x08,0xfe,0x09,0x88,0x0a,0x88,0x7e,0x88,0x08,0xfe,0x1c,0x88,0x1a,0x88,0x2a,0xfe,0x28,0x88,0x48,0x88,0x08,0x88,0x08,0xff,0x08,0x80}}, // 稚
{0x4356,0x9275,0xC3D6,0xE7BDAE,0x7F6E,{0x00,0x00,0x3f,0xfc,0x22,0x44,0x3f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x80,0x27,0xf0,0x24,0x10,0x27,0xf0,0x24,0x10,0x27,0xf0,0x24,0x10,0x27,0xf0,0x3f,0xff,0x20,0x00}}, // 置
{0x4357,0x9276,0xC3D7,0xE887B4,0x81F4,{0x00,0x40,0x7f,0x40,0x08,0x40,0x08,0x7f,0x14,0x44,0x12,0x84,0x26,0xa4,0x79,0x24,0x09,0x28,0x08,0x18,0x3e,0x10,0x08,0x18,0x0b,0x28,0x0c,0x44,0x70,0x82,0x03,0x01}}, // 致
{0x4358,0x9277,0xC3D8,0xE89C98,0x8718,{0x11,0x00,0x11,0x00,0x11,0x1e,0x13,0xf2,0x7c,0x92,0x54,0x92,0x54,0x92,0x57,0xf2,0x7c,0x92,0x10,0x92,0x18,0x92,0x15,0x52,0x15,0x5e,0x1a,0x32,0x64,0x20,0x08,0x00}}, // 蜘
{0x4359,0x9278,0xC3D9,0xE98185,0x9045,{0x00,0x00,0x21,0xfe,0x11,0x02,0x11,0x02,0x01,0xfe,0x01,0x44,0x01,0x28,0x79,0xfe,0x09,0x10,0x09,0xfe,0x0a,0x10,0x0a,0xff,0x14,0x10,0x12,0x10,0x21,0x90,0x40,0x7f}}, // 遅
{0x435A,0x9279,0xC3DA,0xE9A6B3,0x99B3,{0x00,0x08,0x3f,0xa8,0x24,0x28,0x24,0x2e,0x3f,0x2a,0x24,0x3a,0x3f,0xea,0x24,0x2a,0x24,0x2a,0x3f,0xaa,0x04,0xae,0x12,0xa8,0x2a,0xa8,0x28,0xa1,0x40,0xa1,0x03,0x1f}}, // 馳
{0x435B,0x927A,0xC3DB,0xE7AF89,0x7BC9,{0x10,0x20,0x10,0x20,0x3f,0x7f,0x24,0x90,0x42,0x08,0x3f,0x7c,0x08,0x44,0x08,0x64,0x0f,0x55,0x70,0x93,0x00,0x80,0x7f,0xfe,0x01,0xc0,0x0e,0xb8,0x70,0x87,0x00,0x80}}, // 築
{0x435C,0x927B,0xC3DC,0xE7959C,0x755C,{0x00,0x80,0x00,0x80,0x7f,0xff,0x02,0x40,0x02,0x50,0x1c,0x88,0x03,0x3c,0x7f,0xc4,0x00,0x02,0x1f,0xfa,0x10,0x88,0x1f,0xf8,0x10,0x88,0x10,0x88,0x1f,0xf8,0x10,0x08}}, // 畜
{0x435D,0x927C,0xC3DD,0xE7ABB9,0x7AF9,{0x08,0x20,0x08,0x20,0x08,0x20,0x0f,0xff,0x14,0x48,0x14,0x48,0x24,0x88,0x44,0x08,0x04,0x08,0x04,0x08,0x04,0x08,0x04,0x08,0x04,0x08,0x04,0x08,0x04,0x38,0x04,0x08}}, // 竹
{0x435E,0x927D,0xC3DE,0xE7AD91,0x7B51,{0x10,0x20,0x10,0x20,0x1f,0x7f,0x24,0x48,0x22,0x84,0x42,0x04,0x00,0x00,0x3e,0x7c,0x08,0x44,0x08,0x64,0x08,0x54,0x08,0x54,0x0e,0x84,0x18,0x85,0x61,0x05,0x02,0x03}}, // 筑
{0x435F,0x927E,0xC3DF,0xE89384,0x84C4,{0x04,0x08,0x04,0x08,0x7f,0xff,0x04,0x88,0x3f,0xff,0x01,0x90,0x07,0x28,0x01,0xcc,0x7f,0xf2,0x00,0x01,0x0f,0xfc,0x08,0x44,0x0f,0xfc,0x08,0x44,0x0f,0xfc,0x08,0x04}}, // 蓄
{0x4360,0x9280,0xC3E0,0xE98090,0x9010,{0x00,0x00,0x27,0xff,0x10,0x40,0x10,0x62,0x01,0xa2,0x06,0x34,0x00,0x54,0x78,0x98,0x0b,0x38,0x08,0x54,0x08,0x92,0x0b,0x11,0x0c,0x10,0x14,0x60,0x23,0x00,0x40,0xff}}, // 逐
{0x4361,0x9281,0xC3E1,0xE7A7A9,0x79E9,{0x02,0x10,0x0c,0x50,0x78,0x50,0x08,0xfe,0x08,0x90,0x7f,0x10,0x08,0x10,0x09,0xff,0x1c,0x10,0x1a,0x10,0x29,0x30,0x28,0x28,0x48,0x48,0x08,0x84,0x09,0x02,0x0a,0x01}}, // 秩
{0x4362,0x9282,0xC3E2,0xE7AA92,0x7A92,{0x01,0x00,0x3f,0xfe,0x22,0x44,0x42,0x42,0x04,0x3e,0x18,0x00,0x7f,0xfe,0x02,0x40,0x04,0x30,0x1f,0xe8,0x01,0x04,0x1f,0xf8,0x01,0x00,0x01,0x00,0x7f,0xfe,0x00,0x00}}, // 窒
{0x4363,0x9283,0xC3E3,0xE88CB6,0x8336,{0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x90,0x04,0x90,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x8c,0x6f,0xfb,0x00,0x80,0x02,0xa0,0x04,0x98,0x08,0x84,0x30,0x82,0x00,0x80}}, // 茶
{0x4364,0x9284,0xC3E4,0xE5ABA1,0x5AE1,{0x08,0x20,0x08,0x20,0x0b,0xff,0x08,0x84,0x7e,0x48,0x13,0xfe,0x13,0x22,0x13,0x22,0x23,0xfe,0x25,0x22,0x7d,0x7a,0x45,0x4a,0x09,0x4a,0x11,0x7a,0x61,0x4a,0x01,0x06}}, // 嫡
{0x4365,0x9285,0xC3E5,0xE79D80,0x7740,{0x04,0x10,0x02,0x20,0x3f,0xfe,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x04,0x00,0x07,0xf8,0x0c,0x08,0x0f,0xf8,0x14,0x08,0x27,0xf8,0x44,0x08,0x07,0xf8,0x04,0x08}}, // 着
{0x4366,0x9286,0xC3E6,0xE4B8AD,0x4E2D,{0x00,0x80,0x00,0x80,0x00,0x80,0x3f,0xfe,0x20,0x82,0x20,0x82,0x20,0x82,0x20,0x82,0x20,0x82,0x3f,0xfe,0x20,0x82,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 中
{0x4367,0x9287,0xC3E7,0xE4BBB2,0x4EF2,{0x04,0x20,0x04,0x20,0x04,0x20,0x08,0x20,0x0b,0xfe,0x1a,0x22,0x1a,0x22,0x2a,0x22,0x4a,0x22,0x0b,0xfe,0x0a,0x22,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20}}, // 仲
{0x4368,0x9288,0xC3E8,0xE5AE99,0x5B99,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x21,0x04,0x21,0x00,0x41,0x00,0x1f,0xf8,0x11,0x08,0x11,0x08,0x11,0x08,0x1f,0xf8,0x11,0x08,0x11,0x08,0x11,0x08,0x1f,0xf8,0x10,0x08}}, // 宙
{0x4369,0x9289,0xC3E9,0xE5BFA0,0x5FE0,{0x01,0x00,0x01,0x00,0x1f,0xf8,0x11,0x08,0x11,0x08,0x11,0x08,0x1f,0xf8,0x11,0x08,0x01,0x00,0x01,0x40,0x12,0x24,0x12,0x22,0x22,0x21,0x22,0x09,0x41,0x08,0x00,0xf8}}, // 忠
{0x436A,0x928A,0xC3EA,0xE68ABD,0x62BD,{0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x7d,0xfe,0x11,0x22,0x11,0x22,0x11,0x22,0x1d,0x22,0x71,0xfe,0x11,0x22,0x11,0x22,0x11,0x22,0x11,0x22,0x31,0xfe,0x11,0x02}}, // 抽
{0x436B,0x928B,0xC3EB,0xE698BC,0x663C,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x10,0x10,0x10,0x17,0xe8,0x24,0x28,0x27,0xe4,0x44,0x22,0x04,0x20,0x07,0xe0,0x00,0x00,0x7f,0xfe,0x00,0x00}}, // 昼
{0x436C,0x928C,0xC3EC,0xE69FB1,0x67F1,{0x08,0x40,0x08,0x20,0x08,0x20,0x7e,0x00,0x09,0xfe,0x08,0x20,0x1c,0x20,0x1a,0x20,0x1a,0x20,0x29,0xfc,0x28,0x20,0x48,0x20,0x08,0x20,0x08,0x20,0x0b,0xff,0x08,0x00}}, // 柱
{0x436D,0x928D,0xC3ED,0xE6B3A8,0x6CE8,{0x10,0x40,0x08,0x20,0x08,0x20,0x00,0x00,0x03,0xfe,0x40,0x20,0x20,0x20,0x20,0x20,0x08,0x20,0x09,0xfc,0x10,0x20,0x10,0x20,0x20,0x20,0x20,0x20,0x47,0xff,0x40,0x00}}, // 注
{0x436E,0x928E,0xC3EE,0xE899AB,0x866B,{0x01,0x00,0x01,0x00,0x01,0x00,0x1f,0xf8,0x11,0x08,0x11,0x08,0x11,0x08,0x11,0x08,0x1f,0xf8,0x11,0x00,0x01,0x10,0x01,0x08,0x01,0x3c,0x07,0xc4,0x78,0x02,0x00,0x02}}, // 虫
{0x436F,0x928F,0xC3EF,0xE8A1B7,0x8877,{0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x0f,0xf8,0x08,0x88,0x08,0x88,0x08,0x88,0x0f,0xfc,0x02,0x84,0x06,0x48,0x1a,0x50,0x62,0x20,0x02,0x10,0x03,0x8c,0x1c,0x03}}, // 衷
{0x4370,0x9290,0xC3F0,0xE8A8BB,0x8A3B,{0x00,0x20,0x3e,0x10,0x00,0x10,0x7f,0xfe,0x00,0x10,0x3e,0x10,0x00,0x10,0x00,0x10,0x3e,0xfe,0x00,0x10,0x3e,0x10,0x22,0x10,0x22,0x10,0x22,0x10,0x3f,0xff,0x22,0x00}}, // 註
{0x4371,0x9291,0xC3F1,0xE9858E,0x914E,{0x00,0x04,0x7f,0xc4,0x0a,0x04,0x0a,0x04,0x3f,0xff,0x2a,0x84,0x2a,0x84,0x2a,0xa4,0x2b,0x94,0x30,0x94,0x20,0x84,0x3f,0x84,0x20,0x84,0x20,0x84,0x3f,0x8c,0x20,0x84}}, // 酎
{0x4372,0x9292,0xC3F2,0xE98BB3,0x92F3,{0x08,0x20,0x08,0x20,0x14,0xfe,0x12,0x20,0x20,0xfc,0x7e,0x20,0x09,0xff,0x08,0x24,0x7e,0x24,0x09,0xff,0x4a,0x44,0x2c,0x44,0x28,0xa4,0x0f,0x24,0x1a,0x0c,0x60,0x04}}, // 鋳
{0x4373,0x9293,0xC3F3,0xE9A790,0x99D0,{0x00,0x10,0x3f,0x88,0x24,0x08,0x24,0x7f,0x3f,0x88,0x24,0x08,0x3f,0x88,0x24,0x08,0x24,0x7e,0x3f,0x88,0x04,0x88,0x12,0x88,0x2a,0x88,0x28,0x88,0x40,0xff,0x03,0x00}}, // 駐
{0x4374,0x9294,0xC3F4,0xE6A897,0x6A17,{0x08,0x00,0x08,0xfe,0x08,0x10,0x7f,0xff,0x09,0x11,0x09,0xdd,0x19,0x11,0x1c,0xdc,0x1a,0x00,0x28,0xfc,0x28,0x00,0x49,0xff,0x08,0x20,0x08,0x3c,0x08,0x44,0x08,0x0c}}, // 樗
{0x4375,0x9295,0xC3F5,0xE780A6,0x7026,{0x20,0x12,0x1f,0xd2,0x12,0x7e,0x02,0x14,0x05,0x54,0x49,0x98,0x23,0xff,0x25,0x10,0x09,0x7c,0x03,0xa4,0x13,0xa4,0x15,0x7c,0x29,0x64,0x21,0x24,0x41,0x3c,0x46,0x24}}, // 瀦
{0x4376,0x9296,0xC3F6,0xE78CAA,0x732A,{0x04,0x20,0x44,0x24,0x29,0xfe,0x10,0x24,0x10,0x24,0x28,0x28,0x4b,0xff,0x08,0x20,0x18,0xfc,0x19,0x84,0x2a,0x84,0x48,0xfc,0x08,0x84,0x08,0x84,0x68,0xfc,0x10,0x84}}, // 猪
{0x4377,0x9297,0xC3F7,0xE88BA7,0x82E7,{0x08,0x10,0x08,0x10,0x7f,0xff,0x08,0x90,0x00,0x80,0x1f,0xfe,0x10,0x04,0x20,0x00,0x00,0x00,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x03,0x80,0x00,0x80}}, // 苧
{0x4378,0x9298,0xC3F8,0xE89197,0x8457,{0x04,0x10,0x04,0x10,0x7f,0xfe,0x04,0x90,0x00,0x80,0x1f,0xf8,0x00,0x90,0x00,0xa0,0x7f,0xfe,0x01,0x80,0x07,0xf8,0x0c,0x08,0x37,0xf8,0x04,0x08,0x07,0xf8,0x04,0x08}}, // 著
{0x4379,0x9299,0xC3F9,0xE8B2AF,0x8CAF,{0x00,0x10,0x3e,0x10,0x22,0xff,0x22,0x82,0x3e,0x80,0x23,0x00,0x22,0xff,0x3e,0x10,0x22,0x10,0x22,0x10,0x22,0x10,0x3e,0x10,0x14,0x10,0x12,0x10,0x22,0x30,0x40,0x10}}, // 貯
{0x437A,0x929A,0xC3FA,0xE4B881,0x4E01,{0x00,0x00,0x00,0x02,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x03,0x80,0x00,0x80}}, // 丁
{0x437B,0x929B,0xC3FB,0xE58586,0x5146,{0x02,0x40,0x02,0x40,0x02,0x44,0x22,0x44,0x12,0x48,0x0a,0x50,0x02,0x40,0x02,0x40,0x06,0x70,0x1a,0x4c,0x62,0x42,0x04,0x40,0x04,0x40,0x08,0x41,0x10,0x21,0x60,0x1f}}, // 兆
{0x437C,0x929C,0xC3FC,0xE5878B,0x51CB,{0x00,0x00,0x23,0xfe,0x12,0x22,0x12,0x22,0x02,0xfa,0x02,0x22,0x02,0x22,0x0b,0xfe,0x0a,0x02,0x12,0xfa,0x12,0x8a,0x22,0x8a,0x22,0xfa,0x44,0x8a,0x44,0x02,0x08,0x06}}, // 凋
{0x437D,0x929D,0xC3FD,0xE5968B,0x558B,{0x01,0x24,0x01,0x24,0x7f,0xff,0x49,0x24,0x49,0x24,0x49,0x3c,0x49,0x00,0x49,0xfe,0x48,0x20,0x4f,0xff,0x78,0x70,0x48,0xa8,0x01,0x24,0x06,0x23,0x00,0x20,0x00,0x20}}, // 喋
{0x437E,0x929E,0xC3FE,0xE5AFB5,0x5BF5,{0x01,0x00,0x3f,0xfe,0x28,0x44,0x7f,0x78,0x22,0x40,0x14,0x7c,0x7f,0x84,0x00,0x7c,0x3e,0x40,0x22,0x7c,0x3e,0x40,0x22,0x7c,0x3e,0x40,0x22,0x7c,0x26,0x42,0x22,0x3e}}, // 寵
{0x4421,0x929F,0xC4A1,0xE5B896,0x5E16,{0x10,0x20,0x10,0x20,0x10,0x20,0x7e,0x20,0x52,0x3f,0x52,0x20,0x52,0x20,0x52,0x20,0x52,0xfc,0x52,0x84,0x56,0x84,0x50,0x84,0x10,0x84,0x10,0x84,0x10,0xfc,0x10,0x84}}, // 帖
{0x4422,0x92A0,0xC4A2,0xE5B8B3,0x5E33,{0x10,0x00,0x10,0x7e,0x10,0x40,0x7e,0x7c,0x52,0x40,0x52,0x7c,0x52,0x40,0x52,0x40,0x53,0xff,0x52,0x52,0x56,0x54,0x50,0x48,0x10,0x48,0x10,0x74,0x10,0xc2,0x11,0x01}}, // 帳
{0x4423,0x92A1,0xC4A3,0xE5BA81,0x5E81,{0x00,0x40,0x00,0x40,0x1f,0xfe,0x10,0x00,0x10,0x00,0x10,0x00,0x17,0xfe,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x20,0x20,0x20,0x20,0x40,0xe0,0x00,0x20}}, // 庁
{0x4424,0x92A2,0xC4A4,0xE5BC94,0x5F14,{0x00,0x00,0x7f,0xf8,0x01,0x08,0x01,0x08,0x01,0x08,0x3f,0xf8,0x21,0x00,0x21,0x00,0x3f,0xfc,0x21,0x04,0x01,0x04,0x01,0x04,0x01,0x04,0x01,0x08,0x01,0x30,0x01,0x00}}, // 弔
{0x4425,0x92A3,0xC4A5,0xE5BCB5,0x5F35,{0x00,0x00,0x7c,0xfe,0x04,0x80,0x04,0xfc,0x04,0x80,0x7c,0xfc,0x40,0x80,0x40,0x80,0x7f,0xff,0x44,0xa2,0x04,0xa4,0x04,0x90,0x04,0x88,0x08,0xa4,0x10,0xc2,0x63,0x01}}, // 張
{0x4426,0x92A4,0xC4A6,0xE5BDAB,0x5F6B,{0x00,0x04,0x3f,0xc4,0x24,0x48,0x24,0x48,0x2f,0x52,0x24,0x62,0x24,0x44,0x3f,0xc4,0x20,0x49,0x2f,0x51,0x29,0x42,0x29,0x42,0x2f,0x44,0x29,0x48,0x20,0xd0,0x40,0x60}}, // 彫
{0x4427,0x92A5,0xC4A7,0xE5BEB4,0x5FB4,{0x09,0x10,0x0d,0x50,0x15,0x50,0x15,0x5f,0x27,0xe4,0x48,0x24,0x08,0x44,0x17,0xd4,0x11,0x14,0x31,0x14,0x57,0xc8,0x11,0x08,0x11,0x4c,0x11,0x94,0x16,0x22,0x10,0x41}}, // 徴
{0x4428,0x92A6,0xC4A8,0xE687B2,0x61F2,{0x11,0x10,0x15,0x50,0x25,0x5f,0x4f,0xe4,0x08,0x24,0x17,0xd4,0x31,0x0c,0x57,0xc8,0x11,0x14,0x17,0xe2,0x12,0x41,0x15,0x08,0x14,0x84,0x24,0x92,0x44,0x12,0x03,0xf0}}, // 懲
{0x4429,0x92A7,0xC4A9,0xE68C91,0x6311,{0x10,0x50,0x10,0x50,0x12,0x54,0x11,0x54,0x7d,0x54,0x11,0x58,0x10,0x50,0x10,0x50,0x1c,0xd8,0x71,0x54,0x16,0x52,0x10,0x50,0x10,0x91,0x10,0x91,0x11,0x0f,0x32,0x00}}, // 挑
{0x442A,0x92A8,0xC4AA,0xE69AA2,0x66A2,{0x10,0x00,0x10,0xf8,0x10,0x88,0x7e,0xf8,0x52,0x88,0x52,0x88,0x7e,0xf8,0x52,0x00,0x53,0xff,0x52,0x40,0x7e,0xfe,0x53,0x4a,0x10,0x92,0x13,0x22,0x10,0x42,0x11,0x8c}}, // 暢
{0x442B,0x92A9,0xC4AB,0xE69C9D,0x671D,{0x08,0x00,0x08,0x3e,0x7f,0xa2,0x08,0x22,0x3f,0x22,0x21,0x3e,0x21,0x22,0x3f,0x22,0x21,0x22,0x21,0x3e,0x3f,0x22,0x08,0x22,0x7f,0xa2,0x08,0x42,0x08,0x46,0x08,0x82}}, // 朝
{0x442C,0x92AA,0xC4AC,0xE6BDAE,0x6F6E,{0x21,0x00,0x11,0x1e,0x1f,0xf2,0x01,0x12,0x47,0xd2,0x24,0x5e,0x24,0x52,0x07,0xd2,0x04,0x52,0x14,0x5e,0x17,0xd2,0x21,0x12,0x2f,0xf2,0x21,0x12,0x41,0x26,0x41,0x42}}, // 潮
{0x442D,0x92AB,0xC4AD,0xE78992,0x7252,{0x24,0x94,0x24,0x94,0x25,0xff,0x24,0x94,0x24,0x94,0x3e,0x9c,0x20,0x80,0x20,0xfe,0x3c,0x20,0x27,0xff,0x24,0x70,0x24,0x68,0x24,0xa4,0x25,0x22,0x26,0x21,0x44,0x20}}, // 牒
{0x442E,0x92AC,0xC4AE,0xE794BA,0x753A,{0x00,0x00,0x3f,0x80,0x24,0xff,0x24,0x88,0x24,0x88,0x3f,0x88,0x24,0x88,0x24,0x88,0x24,0x88,0x24,0x88,0x3f,0x88,0x20,0x88,0x00,0x08,0x00,0x08,0x00,0x38,0x00,0x08}}, // 町
{0x442F,0x92AD,0xC4AF,0xE79CBA,0x773A,{0x00,0x90,0x78,0x90,0x48,0x90,0x4c,0x94,0x4a,0x94,0x7a,0x98,0x4a,0x90,0x48,0x90,0x79,0x98,0x4a,0x94,0x4c,0x92,0x48,0x90,0x79,0x11,0x49,0x11,0x02,0x0f,0x04,0x00}}, // 眺
{0x4430,0x92AE,0xC4B0,0xE881B4,0x8074,{0x00,0x20,0x7f,0x20,0x25,0xfe,0x24,0x20,0x3c,0x20,0x25,0xfc,0x25,0x54,0x25,0x54,0x3d,0x54,0x25,0xfc,0x24,0x20,0x25,0x50,0x3d,0x52,0x65,0x45,0x06,0x45,0x04,0x3c}}, // 聴
{0x4431,0x92AF,0xC4B1,0xE884B9,0x8139,{0x00,0x00,0x3c,0xfe,0x24,0x80,0x24,0xfc,0x24,0x80,0x3c,0xfc,0x24,0x80,0x24,0x80,0x27,0xff,0x3c,0xa2,0x24,0x94,0x24,0x98,0x24,0x88,0x24,0xa4,0x24,0xc2,0x4f,0x01}}, // 脹
{0x4432,0x92B0,0xC4B2,0xE885B8,0x8178,{0x00,0x00,0x3c,0xfc,0x24,0x84,0x24,0xfc,0x24,0x84,0x3c,0x84,0x24,0xfc,0x24,0x00,0x27,0xff,0x3c,0x80,0x25,0xfe,0x26,0x52,0x24,0x92,0x25,0x22,0x24,0x42,0x4c,0x8c}}, // 腸
{0x4433,0x92B1,0xC4B3,0xE89DB6,0x8776,{0x08,0x54,0x08,0x54,0x09,0xff,0x3e,0x54,0x2a,0x54,0x2a,0x5c,0x2a,0x40,0x2a,0x7e,0x3e,0x10,0x09,0xff,0x0c,0x18,0x0a,0x34,0x0a,0x52,0x0f,0x91,0x71,0x10,0x01,0x10}}, // 蝶
{0x4434,0x92B2,0xC4B4,0xE8AABF,0x8ABF,{0x00,0x00,0x3e,0xfe,0x00,0x92,0x7f,0x92,0x00,0xfe,0x3e,0x92,0x00,0x92,0x00,0xfe,0x3e,0x82,0x00,0xba,0x3e,0xaa,0x22,0xaa,0x22,0xba,0x23,0x2a,0x3f,0x06,0x22,0x02}}, // 調
{0x4435,0x92B3,0xC4B5,0xE8AB9C,0x8ADC,{0x00,0x54,0x3e,0x54,0x01,0xff,0x7f,0x54,0x00,0x54,0x3e,0x5c,0x00,0x40,0x00,0x7f,0x3e,0x10,0x00,0xff,0x3e,0x38,0x22,0x34,0x22,0x52,0x22,0x91,0x3f,0x10,0x22,0x10}}, // 諜
{0x4436,0x92B4,0xC4B6,0xE8B685,0x8D85,{0x04,0x00,0x04,0xfe,0x3f,0x22,0x04,0x22,0x04,0x22,0x04,0x42,0x7f,0x4c,0x04,0x80,0x14,0x7e,0x17,0x42,0x14,0x42,0x1c,0x42,0x14,0x7e,0x22,0x42,0x21,0x80,0x40,0x7f}}, // 超
{0x4437,0x92B5,0xC4B7,0xE8B7B3,0x8DF3,{0x00,0x28,0x3e,0x28,0x22,0x2a,0x23,0x2a,0x22,0xac,0x22,0xac,0x3e,0x28,0x08,0x68,0x28,0x6c,0x2e,0xaa,0x29,0x29,0x28,0x48,0x28,0x48,0x2e,0x89,0x39,0x09,0x62,0x07}}, // 跳
{0x4438,0x92B6,0xC4B8,0xE98A9A,0x929A,{0x08,0x28,0x08,0x28,0x14,0x2a,0x12,0xaa,0x21,0x6c,0x7e,0x68,0x08,0x28,0x08,0x28,0x7f,0x6c,0x08,0xaa,0x4b,0x29,0x2c,0x28,0x28,0x48,0x0e,0x49,0x18,0x89,0x63,0x07}}, // 銚
{0x4439,0x92B7,0xC4B9,0xE995B7,0x9577,{0x00,0x00,0x07,0xfc,0x04,0x00,0x07,0xf8,0x04,0x00,0x07,0xf8,0x04,0x00,0x04,0x00,0x7f,0xff,0x05,0x08,0x04,0x88,0x04,0x50,0x04,0x20,0x05,0x90,0x0e,0x0c,0x30,0x03}}, // 長
{0x443A,0x92B8,0xC4BA,0xE9A082,0x9802,{0x00,0x00,0x03,0xff,0x7e,0x20,0x10,0x40,0x11,0xfc,0x11,0x04,0x11,0x04,0x11,0xfc,0x11,0x04,0x11,0xfc,0x11,0x04,0x11,0x04,0x11,0xfc,0x30,0x48,0x11,0x84,0x06,0x02}}, // 頂
{0x443B,0x92B9,0xC4BB,0xE9B3A5,0x9CE5,{0x00,0x80,0x01,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x00,0x0f,0xff,0x08,0x00,0x0f,0xfe,0x10,0x22,0x14,0x92,0x12,0x52,0x22,0x42,0x40,0x0c}}, // 鳥
{0x443C,0x92BA,0xC4BC,0xE58B85,0x52C5,{0x04,0x10,0x04,0x10,0x7f,0xd0,0x04,0x10,0x04,0xfe,0x3f,0x92,0x24,0x92,0x24,0x92,0x3f,0x92,0x0c,0x12,0x0e,0x12,0x15,0x22,0x14,0xa2,0x24,0x42,0x44,0x82,0x05,0x0c}}, // 勅
{0x443D,0x92BB,0xC4BD,0xE68D97,0x6357,{0x10,0x20,0x11,0x20,0x11,0x3e,0x11,0x20,0x7d,0x20,0x17,0xff,0x10,0x20,0x10,0xa8,0x1c,0xa4,0x71,0x22,0x12,0x2a,0x14,0x68,0x10,0x10,0x10,0x20,0x10,0xc0,0x33,0x00}}, // 捗
{0x443E,0x92BC,0xC4BE,0xE79BB4,0x76F4,{0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x07,0xf8,0x24,0x08,0x24,0x08,0x27,0xf8,0x24,0x08,0x27,0xf8,0x24,0x08,0x24,0x08,0x27,0xf8,0x20,0x00,0x3f,0xff,0x20,0x00}}, // 直
{0x443F,0x92BD,0xC4BF,0xE69C95,0x6715,{0x00,0x84,0x3e,0x44,0x22,0x48,0x22,0x10,0x22,0xfe,0x3e,0x10,0x22,0x10,0x22,0x10,0x23,0xff,0x3e,0x10,0x22,0x28,0x22,0x28,0x22,0x44,0x22,0x44,0x22,0x82,0x47,0x01}}, // 朕
{0x4440,0x92BE,0xC4C0,0xE6B288,0x6C88,{0x10,0x40,0x08,0x40,0x08,0x40,0x03,0xfe,0x02,0x42,0x42,0x44,0x24,0x40,0x20,0x60,0x08,0x60,0x08,0xa0,0x10,0xa0,0x11,0x20,0x21,0x20,0x22,0x21,0x44,0x11,0x48,0x0f}}, // 沈
{0x4441,0x92BF,0xC4C1,0xE78F8D,0x73CD,{0x00,0x20,0x00,0x20,0x7e,0x50,0x10,0x50,0x10,0x88,0x11,0x14,0x12,0x22,0x7c,0x45,0x11,0x88,0x10,0x10,0x10,0x62,0x11,0x84,0x1e,0x08,0x70,0x10,0x00,0x60,0x01,0x80}}, // 珍
{0x4442,0x92C0,0xC4C2,0xE8B383,0x8CC3,{0x04,0x18,0x09,0xe0,0x10,0x20,0x77,0xff,0x10,0x20,0x13,0xfc,0x10,0x00,0x1f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x04,0x30,0x38,0x0c}}, // 賃
{0x4443,0x92C1,0xC4C3,0xE98EAE,0x93AE,{0x08,0x10,0x08,0x10,0x15,0xff,0x12,0x10,0x21,0x7c,0x7e,0x44,0x08,0x7c,0x08,0x44,0x7f,0xfc,0x08,0x44,0x4a,0x7c,0x2c,0x00,0x29,0xff,0x0e,0x24,0x18,0xc2,0x63,0x01}}, // 鎮
{0x4444,0x92C2,0xC4C4,0xE999B3,0x9673,{0x00,0x20,0x3c,0x20,0x27,0xff,0x24,0x20,0x29,0xfc,0x31,0x24,0x29,0xfc,0x25,0x24,0x25,0x24,0x25,0xfc,0x24,0x70,0x24,0xa8,0x39,0x24,0x22,0x22,0x24,0x21,0x20,0x20}}, // 陳
{0x4445,0x92C3,0xC4C5,0xE6B4A5,0x6D25,{0x10,0x40,0x08,0x40,0x0b,0xfc,0x00,0x44,0x00,0x44,0x4f,0xff,0x20,0x44,0x23,0xfc,0x08,0x40,0x08,0x40,0x13,0xfc,0x10,0x40,0x20,0x40,0x2f,0xff,0x40,0x40,0x40,0x40}}, // 津
{0x4446,0x92C4,0xC4C6,0xE5A29C,0x589C,{0x00,0x84,0x3c,0x48,0x27,0xff,0x28,0x40,0x30,0xaa,0x2b,0x5c,0x24,0xb8,0x27,0x54,0x24,0x92,0x3b,0x11,0x20,0x30,0x20,0x80,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 墜
{0x4447,0x92C5,0xC4C7,0xE6A48E,0x690E,{0x08,0x44,0x08,0x44,0x08,0x88,0x7e,0xfe,0x09,0x88,0x09,0x88,0x1c,0x88,0x1a,0xfe,0x1a,0x88,0x28,0x88,0x28,0xfe,0x48,0x88,0x08,0x88,0x08,0x88,0x08,0xff,0x08,0x80}}, // 椎
{0x4448,0x92C6,0xC4C8,0xE6A78C,0x69CC,{0x10,0x08,0x11,0x10,0x10,0xbe,0x7e,0xa2,0x10,0x22,0x10,0x3e,0x18,0x20,0x37,0xa0,0x34,0xbe,0x50,0xa2,0x50,0xa2,0x10,0xa2,0x10,0xbe,0x11,0x62,0x12,0x30,0x14,0x0f}}, // 槌
{0x4449,0x92C7,0xC4C9,0xE8BFBD,0x8FFD,{0x00,0x20,0x20,0x40,0x11,0xf8,0x11,0x08,0x01,0x08,0x01,0x08,0x01,0xf8,0x79,0x00,0x09,0xfc,0x09,0x04,0x09,0x04,0x09,0x04,0x0d,0xfc,0x15,0x04,0x23,0x00,0x40,0xff}}, // 追
{0x444A,0x92C8,0xC4CA,0xE98E9A,0x939A,{0x08,0x08,0x09,0x10,0x14,0xbe,0x12,0xa2,0x20,0x22,0x7e,0x3e,0x08,0x20,0x0b,0xa0,0x7e,0xbe,0x08,0xa2,0x4a,0xa2,0x2c,0xa2,0x28,0xfe,0x0f,0x22,0x19,0x18,0x62,0x07}}, // 鎚
{0x444B,0x92C9,0xC4CB,0xE7979B,0x75DB,{0x00,0x40,0x00,0x40,0x0f,0xff,0x48,0x00,0x2b,0xfc,0x28,0x88,0x08,0x50,0x0b,0xfe,0x1a,0x22,0x2b,0xfe,0x4a,0x22,0x12,0x22,0x13,0xfe,0x22,0x22,0x42,0x22,0x02,0x26}}, // 痛
{0x444C,0x92CA,0xC4CC,0xE9809A,0x901A,{0x00,0x00,0x23,0xfc,0x10,0x88,0x10,0x50,0x01,0xfe,0x01,0x22,0x01,0x22,0x79,0xfe,0x09,0x22,0x09,0x22,0x09,0xfe,0x09,0x22,0x0d,0x22,0x15,0x26,0x23,0x00,0x40,0xff}}, // 通
{0x444D,0x92CB,0xC4CD,0xE5A19A,0x585A,{0x00,0x00,0x13,0xfe,0x12,0x04,0x14,0x00,0x13,0xfc,0x7c,0x40,0x10,0x84,0x11,0x54,0x16,0x74,0x10,0xa8,0x11,0x28,0x1e,0x64,0x70,0xa2,0x03,0x21,0x0c,0x20,0x00,0xc0}}, // 塚
{0x444E,0x92CC,0xC4CE,0xE6A082,0x6802,{0x08,0x00,0x08,0xfc,0x08,0x84,0x7e,0xa4,0x08,0x94,0x08,0x94,0x1c,0x84,0x1b,0xff,0x19,0x04,0x29,0x24,0x29,0x14,0x49,0x14,0x09,0xfe,0x08,0x04,0x08,0x08,0x08,0x30}}, // 栂
{0x444F,0x92CD,0xC4CF,0xE68EB4,0x63B4,{0x10,0x00,0x13,0xfe,0x12,0x02,0x12,0x02,0x7f,0xfe,0x12,0x22,0x12,0x22,0x12,0xfa,0x1e,0x22,0x72,0x32,0x12,0x2a,0x12,0x22,0x13,0xfe,0x12,0x02,0x13,0xfe,0x32,0x02}}, // 掴
{0x4450,0x92CE,0xC4D0,0xE6A7BB,0x69FB,{0x08,0x80,0x08,0x9e,0x0b,0xf2,0x7e,0x92,0x08,0x9e,0x08,0x92,0x1b,0xf2,0x1c,0x9e,0x2a,0x92,0x28,0xd2,0x49,0x5e,0x09,0x2c,0x0a,0x0c,0x0a,0x15,0x0c,0x25,0x08,0xc3}}, // 槻
{0x4451,0x92CF,0xC4D1,0xE4BD83,0x4F43,{0x04,0x00,0x05,0xfe,0x05,0x22,0x09,0x22,0x09,0x22,0x11,0x22,0x11,0x22,0x31,0xfe,0x51,0x22,0x11,0x22,0x11,0x22,0x11,0x22,0x11,0x22,0x11,0xfe,0x11,0x02,0x11,0x00}}, // 佃
{0x4452,0x92D0,0xC4D2,0xE6BCAC,0x6F2C,{0x10,0x20,0x0b,0xfe,0x08,0x20,0x01,0xfc,0x00,0x20,0x47,0xff,0x20,0x00,0x21,0xfc,0x09,0x04,0x09,0xfc,0x11,0x04,0x11,0xfc,0x21,0x04,0x21,0xfc,0x40,0x98,0x47,0x06}}, // 漬
{0x4453,0x92D1,0xC4D3,0xE69F98,0x67D8,{0x08,0x00,0x09,0xfe,0x08,0x20,0x7f,0x20,0x08,0x20,0x08,0x40,0x1c,0x40,0x1a,0xfc,0x18,0x84,0x29,0x84,0x2a,0x84,0x48,0x84,0x08,0x84,0x08,0x84,0x08,0xfc,0x08,0x84}}, // 柘
{0x4454,0x92D2,0xC4D4,0xE8BEBB,0x8FBB,{0x00,0x20,0x20,0x20,0x10,0x20,0x10,0x20,0x00,0x20,0x03,0xfe,0x00,0x20,0x78,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x0c,0x20,0x14,0x20,0x23,0x00,0x40,0xff}}, // 辻
{0x4455,0x92D3,0xC4D5,0xE894A6,0x8526,{0x04,0x10,0x7f,0xff,0x04,0x90,0x01,0x00,0x07,0xf8,0x04,0x08,0x07,0xf8,0x04,0x08,0x07,0xf8,0x04,0x00,0x07,0xff,0x04,0x00,0x17,0xfe,0x14,0x92,0x22,0x4a,0x40,0x0c}}, // 蔦
{0x4456,0x92D4,0xC4D6,0xE7B6B4,0x7DB4,{0x08,0x00,0x09,0xfe,0x0a,0x22,0x72,0xaa,0x14,0x44,0x08,0xaa,0x0d,0x11,0x12,0x00,0x7d,0xfe,0x08,0x22,0x2c,0xaa,0x2a,0xcc,0x2a,0x44,0x28,0xac,0x49,0x12,0x0a,0x21}}, // 綴
{0x4457,0x92D5,0xC4D7,0xE98D94,0x9354,{0x08,0x00,0x08,0xee,0x14,0xaa,0x12,0xaa,0x21,0xee,0x7e,0x00,0x08,0xfe,0x08,0x00,0x7f,0xff,0x08,0x20,0x4a,0x20,0x2c,0x7c,0x28,0x44,0x0e,0x04,0x18,0x04,0x60,0x18}}, // 鍔
{0x4458,0x92D6,0xC4D8,0xE6A4BF,0x693F,{0x08,0x20,0x08,0x20,0x0b,0xfe,0x7e,0x20,0x09,0xfc,0x08,0x50,0x1b,0xff,0x1c,0x48,0x1a,0x84,0x29,0xfa,0x2a,0x89,0x4c,0x88,0x08,0xf8,0x08,0x88,0x08,0xf8,0x08,0x88}}, // 椿
{0x4459,0x92D7,0xC4D9,0xE6BDB0,0x6F70,{0x10,0x20,0x09,0xfc,0x09,0x24,0x01,0xfc,0x40,0x20,0x27,0xff,0x20,0x00,0x01,0xfc,0x09,0x04,0x09,0xfc,0x11,0x04,0x11,0xfc,0x21,0x04,0x21,0xfc,0x40,0x8c,0x47,0x03}}, // 潰
{0x445A,0x92D8,0xC4DA,0xE59DAA,0x576A,{0x00,0x00,0x13,0xfe,0x10,0x24,0x11,0x24,0x10,0xa4,0x7c,0xa8,0x10,0xa0,0x10,0x20,0x17,0xff,0x10,0x20,0x10,0x20,0x16,0x20,0x18,0x20,0x60,0x20,0x00,0x20,0x00,0x20}}, // 坪
{0x445B,0x92D9,0xC4DB,0xE5A3B7,0x58F7,{0x01,0x00,0x01,0x00,0x7f,0xfe,0x01,0x00,0x1f,0xf8,0x00,0x00,0x7f,0xfe,0x42,0x42,0x5f,0xfa,0x12,0x48,0x12,0x48,0x1f,0xf8,0x02,0x40,0x02,0x40,0x7f,0xfe,0x00,0x00}}, // 壷
{0x445C,0x92DA,0xC4DC,0xE5ACAC,0x5B2C,{0x08,0x00,0x08,0xfe,0x08,0x10,0x09,0xff,0x7f,0x11,0x13,0x77,0x13,0x11,0x12,0x76,0x12,0x00,0x24,0xff,0x7c,0x10,0x06,0xfe,0x0a,0xaa,0x10,0xaa,0x60,0xaa,0x00,0x86}}, // 嬬
{0x445D,0x92DB,0xC4DD,0xE7B4AC,0x7D2C,{0x08,0x10,0x08,0x10,0x0a,0x10,0x72,0x10,0x14,0xfe,0x08,0x92,0x0c,0x92,0x12,0x92,0x7d,0x92,0x08,0xfe,0x2c,0x92,0x2a,0x92,0x2a,0x92,0x2a,0x92,0x48,0xfe,0x08,0x82}}, // 紬
{0x445E,0x92DC,0xC4DE,0xE788AA,0x722A,{0x00,0x08,0x00,0x70,0x1f,0x80,0x10,0x10,0x11,0x10,0x11,0x10,0x11,0x10,0x11,0x10,0x11,0x10,0x11,0x10,0x11,0x10,0x11,0x08,0x11,0x08,0x21,0x04,0x21,0x04,0x41,0x02}}, // 爪
{0x445F,0x92DD,0xC4DF,0xE5908A,0x540A,{0x00,0x00,0x07,0xf0,0x04,0x10,0x04,0x10,0x04,0x10,0x07,0xf0,0x04,0x90,0x00,0x80,0x1f,0xfc,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x98,0x10,0x80,0x00,0x80}}, // 吊
{0x4460,0x92DE,0xC4E0,0xE987A3,0x91E3,{0x04,0x20,0x04,0x20,0x0c,0x20,0x0a,0x3e,0x11,0x42,0x3f,0x42,0x44,0x42,0x04,0xa2,0x7f,0x12,0x04,0x12,0x25,0x12,0x16,0x02,0x14,0x02,0x07,0x02,0x18,0x04,0x60,0x18}}, // 釣
{0x4461,0x92DF,0xC4E1,0xE9B6B4,0x9DB4,{0x08,0x10,0x08,0x20,0x7f,0x7c,0x49,0x44,0x52,0x7c,0x14,0x44,0x3f,0x7c,0x24,0x40,0x64,0x7f,0x3f,0x40,0x24,0x7e,0x3f,0x2a,0x24,0x56,0x24,0x52,0x3f,0x82,0x21,0x0c}}, // 鶴
{0x4462,0x92E0,0xC4E2,0xE4BAAD,0x4EAD,{0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x00,0x00,0x7f,0xfe,0x40,0x02,0x4f,0xf2,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x01,0x80}}, // 亭
{0x4463,0x92E1,0xC4E3,0xE4BD8E,0x4F4E,{0x04,0x04,0x04,0x18,0x05,0xf0,0x09,0x10,0x09,0x10,0x11,0x10,0x11,0xff,0x31,0x10,0x51,0x10,0x11,0x08,0x11,0x08,0x11,0xc8,0x16,0x04,0x10,0x05,0x17,0xf3,0x10,0x01}}, // 低
{0x4464,0x92E2,0xC4E4,0xE5819C,0x505C,{0x04,0x20,0x04,0x20,0x07,0xff,0x08,0x00,0x09,0xfc,0x11,0x04,0x11,0xfc,0x30,0x00,0x13,0xff,0x12,0x02,0x15,0xfc,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x60}}, // 停
{0x4465,0x92E3,0xC4E5,0xE581B5,0x5075,{0x04,0x20,0x04,0x20,0x04,0x3f,0x08,0x20,0x09,0xfc,0x19,0x04,0x19,0x04,0x29,0xfc,0x49,0x04,0x09,0xfc,0x09,0x04,0x09,0x04,0x09,0xfc,0x08,0x98,0x09,0x04,0x0e,0x02}}, // 偵
{0x4466,0x92E4,0xC4E6,0xE58983,0x5243,{0x11,0x02,0x0a,0x12,0x7f,0x92,0x04,0x92,0x04,0x92,0x3f,0x92,0x24,0x12,0x24,0x12,0x3f,0xd2,0x04,0x52,0x0c,0x52,0x0c,0x42,0x14,0x42,0x25,0x82,0x44,0x02,0x04,0x06}}, // 剃
{0x4467,0x92E5,0xC4E7,0xE8B29E,0x8C9E,{0x01,0x00,0x01,0x00,0x01,0xf8,0x01,0x00,0x1f,0xf0,0x10,0x10,0x10,0x10,0x1f,0xf0,0x10,0x10,0x1f,0xf0,0x10,0x10,0x10,0x10,0x1f,0xf0,0x04,0x60,0x18,0x18,0x60,0x04}}, // 貞
{0x4468,0x92E6,0xC4E8,0xE59188,0x5448,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x00,0x00,0x1f,0xfc,0x00,0x80,0x00,0x80,0x0f,0xf8,0x00,0x80,0x00,0x80,0x7f,0xfe,0x00,0x00}}, // 呈
{0x4469,0x92E7,0xC4E9,0xE5A0A4,0x5824,{0x00,0x00,0x10,0xfc,0x10,0x84,0x10,0xfc,0x10,0x84,0x7c,0x84,0x10,0xfc,0x10,0x00,0x17,0xff,0x10,0x20,0x11,0x20,0x1d,0x3e,0x71,0x20,0x02,0xa0,0x04,0x60,0x18,0x1f}}, // 堤
{0x446A,0x92E8,0xC4EA,0xE5AE9A,0x5B9A,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x20,0x00,0x5f,0xf8,0x01,0x00,0x01,0x00,0x09,0x00,0x09,0xf8,0x09,0x00,0x09,0x00,0x15,0x00,0x13,0x00,0x21,0x80,0x40,0x7e}}, // 定
{0x446B,0x92E9,0xC4EB,0xE5B89D,0x5E1D,{0x00,0x80,0x00,0x80,0x3f,0xfe,0x08,0x10,0x04,0x10,0x04,0x20,0x3f,0xfe,0x20,0x84,0x20,0x80,0x4f,0xf8,0x08,0x88,0x08,0x88,0x08,0x88,0x08,0xb0,0x08,0x80,0x00,0x80}}, // 帝
{0x446C,0x92EA,0xC4EC,0xE5BA95,0x5E95,{0x00,0x40,0x00,0x40,0x1f,0xff,0x10,0x04,0x10,0x18,0x13,0xe0,0x12,0x20,0x12,0x20,0x13,0xff,0x12,0x10,0x12,0x10,0x13,0x88,0x2c,0x08,0x20,0x05,0x47,0xe3,0x00,0x01}}, // 底
{0x446D,0x92EB,0xC4ED,0xE5BAAD,0x5EAD,{0x00,0x40,0x00,0x40,0x1f,0xff,0x10,0x00,0x10,0x02,0x1f,0x7c,0x11,0x08,0x12,0x08,0x17,0x7f,0x11,0x08,0x15,0x08,0x15,0x08,0x22,0x3e,0x25,0x00,0x48,0xc0,0x10,0x3f}}, // 庭
{0x446E,0x92EC,0xC4EE,0xE5BBB7,0x5EF7,{0x00,0x08,0x7c,0x30,0x05,0xe0,0x08,0x20,0x08,0x20,0x10,0x20,0x3f,0xfe,0x04,0x20,0x24,0x20,0x24,0x20,0x14,0x20,0x08,0x20,0x0d,0xfc,0x12,0x00,0x21,0x80,0x40,0x7f}}, // 廷
{0x446F,0x92ED,0xC4EF,0xE5BC9F,0x5F1F,{0x08,0x20,0x04,0x20,0x04,0x40,0x3f,0xf8,0x01,0x08,0x01,0x08,0x3f,0xf8,0x21,0x00,0x21,0x00,0x3f,0xfc,0x23,0x04,0x03,0x04,0x05,0x04,0x19,0x08,0x61,0x30,0x01,0x00}}, // 弟
{0x4470,0x92EE,0xC4F0,0xE6828C,0x608C,{0x08,0x84,0x08,0x48,0x0b,0xfe,0x08,0x22,0x2c,0x22,0x2b,0xfe,0x29,0x20,0x29,0x20,0x49,0xfe,0x08,0x22,0x08,0x62,0x08,0xa2,0x09,0x22,0x0e,0x3c,0x08,0x20,0x08,0x20}}, // 悌
{0x4471,0x92EF,0xC4F1,0xE68AB5,0x62B5,{0x10,0x04,0x10,0x18,0x11,0xf0,0x11,0x10,0x7d,0x10,0x11,0x10,0x11,0xff,0x11,0x10,0x1d,0x10,0x71,0x10,0x11,0x08,0x11,0xca,0x17,0x0a,0x10,0x06,0x17,0xf6,0x30,0x02}}, // 抵
{0x4472,0x92F0,0xC4F2,0xE68CBA,0x633A,{0x10,0x02,0x17,0xcc,0x10,0xb8,0x10,0x88,0x7c,0x88,0x11,0x08,0x13,0xff,0x10,0x48,0x1e,0x48,0x71,0x48,0x11,0x88,0x10,0x88,0x11,0xbf,0x11,0x40,0x12,0x30,0x34,0x0f}}, // 挺
{0x4473,0x92F1,0xC4F3,0xE68F90,0x63D0,{0x10,0x00,0x10,0xfc,0x10,0x84,0x10,0xfc,0x7c,0x84,0x10,0x84,0x10,0xfc,0x10,0x00,0x13,0xff,0x1c,0x20,0x71,0x20,0x11,0x3e,0x11,0xa0,0x11,0x60,0x12,0x30,0x34,0x0f}}, // 提
{0x4474,0x92F2,0xC4F4,0xE6A2AF,0x68AF,{0x08,0x84,0x08,0x48,0x09,0xfe,0x7e,0x22,0x08,0x22,0x09,0xfe,0x1d,0x20,0x1b,0x20,0x19,0xfe,0x28,0x22,0x28,0x62,0x48,0xa2,0x09,0x22,0x0e,0x2c,0x08,0x20,0x08,0x20}}, // 梯
{0x4475,0x92F3,0xC4F5,0xE6B180,0x6C40,{0x10,0x00,0x08,0x00,0x0b,0xff,0x00,0x10,0x00,0x10,0x40,0x10,0x20,0x10,0x20,0x10,0x08,0x10,0x08,0x10,0x10,0x10,0x10,0x10,0x20,0x10,0x20,0x10,0x40,0x70,0x40,0x10}}, // 汀
{0x4476,0x92F4,0xC4F6,0xE7A287,0x7887,{0x00,0x10,0x7f,0x10,0x08,0xff,0x08,0x82,0x09,0x00,0x10,0xfc,0x1e,0x10,0x32,0x10,0x32,0x50,0x52,0x5e,0x12,0x50,0x12,0x50,0x1e,0xd0,0x12,0xb0,0x11,0x18,0x02,0x07}}, // 碇
{0x4477,0x92F5,0xC4F7,0xE7A68E,0x798E,{0x08,0x10,0x08,0x10,0x08,0x1f,0x7e,0x10,0x02,0xfc,0x04,0x84,0x04,0x84,0x08,0xfc,0x1c,0x84,0x2a,0xfc,0x49,0x84,0x08,0x84,0x08,0xfc,0x08,0x58,0x08,0x84,0x0b,0x02}}, // 禎
{0x4478,0x92F6,0xC4F8,0xE7A88B,0x7A0B,{0x02,0x00,0x0c,0xfc,0x78,0x84,0x08,0x84,0x08,0x84,0x08,0xfc,0x7f,0x84,0x08,0x00,0x08,0xfe,0x1c,0x10,0x1a,0x10,0x2a,0xfc,0x28,0x10,0x48,0x10,0x09,0xff,0x08,0x00}}, // 程
{0x4479,0x92F7,0xC4F9,0xE7B7A0,0x7DE0,{0x08,0x20,0x08,0x10,0x0a,0xfe,0x72,0x44,0x14,0x24,0x08,0x28,0x0c,0xff,0x12,0x92,0x7d,0x10,0x08,0xfe,0x2c,0x92,0x2a,0x92,0x2a,0x92,0x2a,0x9c,0x48,0x10,0x08,0x10}}, // 締
{0x447A,0x92F8,0xC4FA,0xE88987,0x8247,{0x04,0x02,0x09,0xcc,0x1e,0x78,0x12,0x48,0x12,0x88,0x1a,0x88,0x17,0xff,0x16,0x48,0x1b,0x48,0x73,0x48,0x1a,0xc8,0x16,0x48,0x16,0xff,0x22,0xa0,0x23,0x18,0x46,0x07}}, // 艇
{0x447B,0x92F9,0xC4FB,0xE8A882,0x8A02,{0x00,0x00,0x1e,0x00,0x00,0xff,0x7f,0x08,0x00,0x08,0x3e,0x08,0x00,0x08,0x00,0x08,0x3e,0x08,0x00,0x08,0x3e,0x08,0x22,0x08,0x22,0x08,0x22,0x08,0x3e,0x38,0x22,0x08}}, // 訂
{0x447C,0x92FA,0xC4FC,0xE8ABA6,0x8AE6,{0x00,0x10,0x3e,0x10,0x00,0xff,0x7f,0x44,0x00,0x24,0x3e,0x28,0x00,0xff,0x00,0x92,0x3f,0x10,0x00,0xfe,0x3e,0x92,0x22,0x92,0x22,0x92,0x22,0x9c,0x3e,0x10,0x22,0x10}}, // 諦
{0x447D,0x92FB,0xC4FD,0xE8B984,0x8E44,{0x00,0x10,0x3e,0x10,0x22,0xff,0x22,0x44,0x22,0x24,0x22,0x28,0x3e,0xff,0x08,0x92,0x29,0x10,0x2e,0xfe,0x28,0x92,0x28,0x92,0x28,0x92,0x2e,0x9c,0x38,0x10,0x60,0x10}}, // 蹄
{0x447E,0x92FC,0xC4FE,0xE98093,0x9013,{0x00,0x04,0x10,0x38,0x09,0xd0,0x09,0x10,0x01,0xff,0x01,0x10,0x01,0xff,0x79,0x10,0x09,0x7e,0x09,0x52,0x09,0x52,0x0a,0x52,0x0c,0x5c,0x14,0x10,0x23,0x10,0x40,0xff}}, // 逓
{0x4521,0x9340,0xC5A1,0xE982B8,0x90B8,{0x01,0x00,0x06,0x3e,0x38,0x22,0x24,0x24,0x24,0x24,0x24,0x28,0x3f,0xa4,0x24,0x22,0x24,0x22,0x24,0x21,0x22,0x21,0x3a,0xb9,0x62,0xa6,0x01,0xa0,0x7d,0xa0,0x00,0xa0}}, // 邸
{0x4522,0x9341,0xC5A2,0xE984AD,0x912D,{0x11,0x00,0x0a,0x1e,0x7f,0xd2,0x0a,0x12,0x3f,0x94,0x2a,0x98,0x33,0x94,0x20,0x92,0x3f,0x92,0x20,0x91,0x3f,0x91,0x04,0x19,0x7f,0xd6,0x0a,0x10,0x11,0x10,0x60,0x10}}, // 鄭
{0x4523,0x9342,0xC5A3,0xE98798,0x91D8,{0x04,0x00,0x04,0x00,0x0a,0xff,0x09,0x08,0x10,0x88,0x3f,0x08,0x44,0x08,0x04,0x08,0x3f,0x88,0x04,0x08,0x25,0x08,0x15,0x08,0x16,0x08,0x05,0x88,0x0e,0x18,0x70,0x08}}, // 釘
{0x4524,0x9343,0xC5A4,0xE9BC8E,0x9F0E,{0x00,0x00,0x17,0xf4,0x14,0x14,0x17,0xf4,0x14,0x14,0x17,0xf4,0x14,0x14,0x17,0xf4,0x10,0x04,0x3f,0x7c,0x01,0x40,0x7f,0x7f,0x09,0x44,0x09,0x44,0x11,0x44,0x21,0x44}}, // 鼎
{0x4525,0x9344,0xC5A5,0xE6B3A5,0x6CE5,{0x10,0x00,0x09,0xfe,0x09,0x02,0x01,0x02,0x41,0x02,0x21,0xfe,0x21,0x02,0x01,0x40,0x09,0x44,0x09,0x48,0x12,0x70,0x12,0x40,0x24,0x40,0x24,0x42,0x48,0x22,0x40,0x1e}}, // 泥
{0x4526,0x9345,0xC5A6,0xE69198,0x6458,{0x10,0x20,0x10,0x20,0x13,0xff,0x10,0x88,0x7c,0x50,0x13,0xfe,0x12,0x22,0x12,0x22,0x1f,0xfe,0x72,0x22,0x12,0xfa,0x12,0x8a,0x12,0x8a,0x12,0xfa,0x12,0x8e,0x32,0x02}}, // 摘
{0x4527,0x9346,0xC5A7,0xE693A2,0x64E2,{0x10,0x00,0x13,0xde,0x10,0x42,0x13,0xde,0x7c,0x42,0x13,0xde,0x10,0x88,0x10,0x90,0x1d,0xfe,0x73,0x20,0x15,0xfc,0x11,0x20,0x11,0xfc,0x11,0x20,0x31,0xff,0x11,0x00}}, // 擢
{0x4528,0x9347,0xC5A8,0xE695B5,0x6575,{0x04,0x10,0x04,0x10,0x7f,0xd0,0x11,0x1f,0x0a,0x24,0x3f,0xa4,0x24,0xd4,0x24,0x94,0x3f,0x94,0x24,0x88,0x2e,0x88,0x2a,0x94,0x2a,0x94,0x2e,0xa2,0x20,0xc2,0x21,0x81}}, // 敵
{0x4529,0x9348,0xC5A9,0xE6BBB4,0x6EF4,{0x10,0x20,0x08,0x20,0x0f,0xff,0x01,0x04,0x40,0x88,0x23,0xfe,0x22,0x22,0x02,0x22,0x0b,0xfe,0x0a,0x22,0x12,0xfa,0x12,0x8a,0x22,0x8a,0x22,0xfa,0x42,0x8e,0x42,0x02}}, // 滴
{0x452A,0x9349,0xC5AA,0xE79A84,0x7684,{0x08,0x40,0x08,0x40,0x10,0x40,0x3e,0x7e,0x22,0x42,0x22,0x82,0x22,0xc2,0x3f,0x22,0x22,0x12,0x22,0x12,0x22,0x02,0x22,0x02,0x3e,0x02,0x22,0x02,0x20,0x04,0x00,0x18}}, // 的
{0x452B,0x934A,0xC5AB,0xE7AC9B,0x7B1B,{0x10,0x20,0x10,0x20,0x1f,0xbf,0x14,0x50,0x22,0x88,0x23,0x08,0x41,0x00,0x1f,0xf8,0x11,0x08,0x11,0x08,0x1f,0xf8,0x11,0x08,0x11,0x08,0x11,0x08,0x1f,0xf8,0x10,0x08}}, // 笛
{0x452C,0x934B,0xC5AC,0xE981A9,0x9069,{0x00,0x20,0x20,0x20,0x13,0xff,0x10,0x84,0x00,0x48,0x01,0xfe,0x01,0x22,0x79,0xfe,0x09,0x22,0x09,0x7a,0x09,0x4a,0x09,0x7a,0x15,0x02,0x13,0x06,0x21,0x80,0x40,0x7f}}, // 適
{0x452D,0x934C,0xC5AD,0xE98F91,0x93D1,{0x08,0x10,0x08,0x10,0x14,0xff,0x12,0x44,0x21,0x28,0x7e,0xfe,0x08,0x82,0x08,0x92,0x7f,0xfe,0x08,0x92,0x4a,0xba,0x2c,0xaa,0x28,0xaa,0x0e,0xba,0x18,0x82,0x60,0x86}}, // 鏑
{0x452E,0x934D,0xC5AE,0xE6BABA,0x6EBA,{0x20,0x00,0x1f,0xbe,0x10,0x82,0x00,0x82,0x47,0x9e,0x24,0x10,0x24,0x10,0x07,0x9e,0x10,0x82,0x18,0xa2,0x14,0x92,0x21,0x86,0x26,0x9a,0x28,0xa2,0x41,0x04,0x46,0x18}}, // 溺
{0x452F,0x934E,0xC5AF,0xE593B2,0x54F2,{0x08,0x04,0x08,0xf8,0x7e,0x80,0x08,0x80,0x08,0xff,0x0e,0x88,0x78,0x88,0x09,0x08,0x09,0x08,0x1a,0x08,0x00,0x08,0x1f,0xf8,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x08}}, // 哲
{0x4530,0x934F,0xC5B0,0xE5BEB9,0x5FB9,{0x09,0x08,0x09,0x08,0x0f,0xe8,0x11,0x8f,0x15,0x54,0x26,0x54,0x0b,0xa4,0x08,0x14,0x13,0xd4,0x32,0x54,0x53,0xc8,0x12,0x48,0x13,0xcc,0x12,0x54,0x12,0x62,0x12,0xc1}}, // 徹
{0x4531,0x9350,0xC5B1,0xE692A4,0x64A4,{0x11,0x08,0x11,0x08,0x17,0xe8,0x11,0x8f,0x7d,0x54,0x12,0x54,0x17,0xa4,0x10,0x14,0x13,0xd4,0x1e,0x54,0x73,0xc8,0x12,0x48,0x13,0xcc,0x12,0x54,0x12,0x62,0x32,0xc1}}, // 撤
{0x4532,0x9351,0xC5B2,0xE8BD8D,0x8F4D,{0x11,0x08,0x11,0x08,0x7f,0xe8,0x11,0x8f,0x7d,0x54,0x56,0x54,0x57,0xa4,0x7c,0x14,0x57,0xd4,0x56,0x54,0x7f,0xc8,0x12,0x48,0x13,0xcc,0x7e,0x54,0x12,0x62,0x12,0xc1}}, // 轍
{0x4533,0x9352,0xC5B3,0xE8BFAD,0x8FED,{0x00,0x20,0x20,0xa0,0x10,0xa0,0x11,0xfe,0x01,0x20,0x02,0x20,0x00,0x20,0x7f,0xff,0x08,0x20,0x08,0x50,0x08,0x90,0x08,0x88,0x15,0x04,0x12,0x02,0x21,0x80,0x40,0x7f}}, // 迭
{0x4534,0x9353,0xC5B4,0xE98984,0x9244,{0x08,0x10,0x08,0x50,0x14,0x50,0x12,0x7e,0x21,0x90,0x7e,0x90,0x09,0x10,0x08,0xff,0x7f,0x10,0x08,0x10,0x4a,0x18,0x2c,0x28,0x28,0x24,0x0e,0x44,0x18,0x82,0x63,0x01}}, // 鉄
{0x4535,0x9354,0xC5B5,0xE585B8,0x5178,{0x02,0x20,0x02,0x20,0x02,0x20,0x1f,0xfc,0x12,0x24,0x12,0x24,0x12,0x24,0x1f,0xfc,0x12,0x24,0x12,0x24,0x12,0x24,0x7f,0xff,0x00,0x00,0x06,0x30,0x18,0x0c,0x60,0x02}}, // 典
{0x4536,0x9355,0xC5B6,0xE5A1AB,0x586B,{0x00,0x20,0x10,0x20,0x13,0xff,0x10,0x20,0x10,0xfc,0x7e,0x84,0x10,0xfc,0x10,0x84,0x10,0xfc,0x10,0x84,0x10,0xfc,0x14,0x00,0x1b,0xff,0x60,0x48,0x01,0x84,0x06,0x02}}, // 填
{0x4537,0x9356,0xC5B7,0xE5A4A9,0x5929,{0x00,0x00,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x3f,0xfc,0x00,0x80,0x00,0x80,0x01,0x40,0x01,0x40,0x02,0x20,0x04,0x10,0x08,0x08,0x10,0x04,0x60,0x03}}, // 天
{0x4538,0x9357,0xC5B8,0xE5B195,0x5C55,{0x00,0x00,0x1f,0xfe,0x10,0x02,0x10,0x02,0x1f,0xfe,0x11,0x10,0x11,0x10,0x17,0xfe,0x11,0x10,0x11,0x10,0x1f,0xff,0x12,0x84,0x12,0x48,0x22,0x30,0x23,0x8c,0x4c,0x03}}, // 展
{0x4539,0x9358,0xC5B9,0xE5BA97,0x5E97,{0x00,0x80,0x00,0x80,0x1f,0xfe,0x10,0x00,0x10,0x80,0x10,0x80,0x10,0xfe,0x10,0x80,0x10,0x80,0x10,0x80,0x17,0xfc,0x14,0x04,0x14,0x04,0x24,0x04,0x27,0xfc,0x44,0x04}}, // 店
{0x453A,0x9359,0xC5BA,0xE6B7BB,0x6DFB,{0x10,0x08,0x08,0x30,0x0b,0xc0,0x00,0x40,0x40,0x40,0x2f,0xff,0x20,0xa0,0x01,0x10,0x0a,0x8c,0x0c,0x83,0x10,0xc8,0x14,0xa4,0x24,0x92,0x24,0x92,0x48,0x80,0x41,0x80}}, // 添
{0x453B,0x935A,0xC5BB,0xE7BA8F,0x7E8F,{0x08,0x10,0x08,0xff,0x0a,0x80,0x74,0xfe,0x14,0xd2,0x08,0xfe,0x0c,0xd2,0x12,0xfe,0x7e,0x90,0x0a,0xff,0x2c,0xa8,0x2a,0xd7,0x2b,0x10,0x49,0x7c,0x0a,0x10,0x09,0xff}}, // 纏
{0x453C,0x935B,0xC5BC,0xE7949C,0x751C,{0x01,0x44,0x06,0x44,0x38,0x44,0x08,0x44,0x09,0xff,0x08,0x44,0x7f,0x44,0x08,0x44,0x08,0x44,0x08,0x7c,0x3e,0x44,0x22,0x44,0x22,0x44,0x22,0x44,0x3e,0x7c,0x22,0x44}}, // 甜
{0x453D,0x935C,0xC5BD,0xE8B2BC,0x8CBC,{0x00,0x10,0x3e,0x10,0x22,0x10,0x22,0x10,0x3e,0x1f,0x22,0x10,0x22,0x10,0x3e,0x10,0x22,0x10,0x22,0x7e,0x22,0x42,0x3e,0x42,0x14,0x42,0x12,0x42,0x22,0x7e,0x40,0x42}}, // 貼
{0x453E,0x935D,0xC5BE,0xE8BBA2,0x8EE2,{0x04,0x00,0x04,0x3e,0x7f,0xc0,0x04,0x00,0x3f,0x00,0x25,0x00,0x25,0xff,0x3f,0x10,0x25,0x10,0x25,0x10,0x3f,0x24,0x04,0x24,0x7f,0xa2,0x04,0x4e,0x05,0xf1,0x04,0x01}}, // 転
{0x453F,0x935E,0xC5BF,0xE9A19B,0x985B,{0x08,0x00,0x08,0xff,0x7f,0x90,0x08,0x20,0x3e,0x7e,0x22,0x42,0x3e,0x42,0x22,0x7e,0x3e,0x42,0x22,0x7e,0x3e,0x42,0x00,0x42,0x7f,0xfe,0x0a,0x24,0x11,0x42,0x61,0x81}}, // 顛
{0x4540,0x935F,0xC5C0,0xE782B9,0x70B9,{0x00,0x80,0x00,0x80,0x00,0x80,0x00,0xfe,0x00,0x80,0x00,0x80,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x00,0x00,0x24,0x44,0x22,0x22,0x42,0x22}}, // 点
{0x4541,0x9360,0xC5C1,0xE4BC9D,0x4F1D,{0x04,0x00,0x04,0x00,0x05,0xfc,0x08,0x00,0x08,0x00,0x10,0x00,0x17,0xff,0x30,0x40,0x50,0x40,0x10,0x50,0x10,0x88,0x10,0x84,0x11,0x04,0x11,0x3e,0x17,0xc2,0x10,0x02}}, // 伝
{0x4542,0x9361,0xC5C2,0xE6AEBF,0x6BBF,{0x00,0x00,0x3f,0x3c,0x21,0x24,0x21,0x24,0x3f,0x25,0x2a,0x25,0x2a,0x23,0x3f,0x40,0x2a,0xfc,0x2a,0x24,0x3f,0x94,0x20,0x18,0x2a,0x08,0x49,0x14,0x11,0x22,0x20,0xc1}}, // 殿
{0x4543,0x9362,0xC5C3,0xE6BEB1,0x6FB1,{0x20,0x00,0x17,0xdc,0x14,0x54,0x04,0x55,0x47,0xd5,0x25,0x53,0x25,0x60,0x07,0xc0,0x05,0x7e,0x15,0x52,0x17,0xea,0x24,0x0c,0x29,0x84,0x29,0x4c,0x52,0x12,0x44,0x61}}, // 澱
{0x4544,0x9363,0xC5C4,0xE794B0,0x7530,{0x00,0x00,0x3f,0xfe,0x20,0x82,0x20,0x82,0x20,0x82,0x20,0x82,0x20,0x82,0x3f,0xfe,0x20,0x82,0x20,0x82,0x20,0x82,0x20,0x82,0x20,0x82,0x20,0x82,0x3f,0xfe,0x20,0x02}}, // 田
{0x4545,0x9364,0xC5C5,0xE99BBB,0x96FB,{0x00,0x00,0x3f,0xfc,0x00,0x80,0x3f,0xfe,0x20,0x82,0x3e,0xbc,0x40,0x80,0x1e,0xbc,0x00,0x00,0x1f,0xf8,0x10,0x88,0x1f,0xf8,0x10,0x88,0x1f,0xf9,0x00,0x81,0x00,0x7f}}, // 電
{0x4546,0x9365,0xC5C6,0xE5858E,0x514E,{0x00,0x08,0x00,0x30,0x3f,0xc0,0x01,0x00,0x01,0x00,0x1f,0xf8,0x11,0x08,0x11,0x08,0x11,0x08,0x1f,0xf8,0x12,0x50,0x02,0x48,0x02,0x48,0x04,0x42,0x18,0x42,0x60,0x3e}}, // 兎
{0x4547,0x9366,0xC5C7,0xE59090,0x5410,{0x00,0x20,0x00,0x20,0x7c,0x20,0x44,0x20,0x44,0x20,0x44,0x20,0x47,0xfe,0x44,0x20,0x44,0x20,0x44,0x20,0x7c,0x20,0x44,0x20,0x40,0x20,0x00,0x20,0x0f,0xff,0x00,0x00}}, // 吐
{0x4548,0x9367,0xC5C8,0xE5A0B5,0x5835,{0x10,0x20,0x10,0x24,0x11,0xfc,0x10,0x24,0x7c,0x28,0x10,0x30,0x13,0xff,0x10,0x20,0x10,0xfc,0x12,0x84,0x1d,0x84,0x12,0xfc,0x64,0x84,0x00,0x84,0x00,0xfc,0x00,0x84}}, // 堵
{0x4549,0x9368,0xC5C9,0xE5A197,0x5857,{0x00,0x20,0x18,0x20,0x04,0x50,0x61,0x8c,0x16,0xfb,0x00,0x20,0x0f,0xff,0x11,0x28,0x21,0x24,0x42,0x62,0x00,0x80,0x0f,0xf8,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 塗
{0x454A,0x9369,0xC5CA,0xE5A6AC,0x59AC,{0x08,0x00,0x09,0xff,0x08,0x10,0x08,0x10,0x7e,0x10,0x12,0x20,0x12,0x20,0x12,0x7e,0x22,0x42,0x24,0xc2,0x7d,0x42,0x06,0x42,0x0a,0x42,0x10,0x42,0x60,0x7e,0x00,0x42}}, // 妬
{0x454B,0x936A,0xC5CB,0xE5B1A0,0x5C60,{0x00,0x00,0x1f,0xfe,0x10,0x02,0x10,0x02,0x1f,0xfe,0x10,0x44,0x13,0xfe,0x10,0x50,0x1f,0xff,0x10,0x40,0x11,0xfc,0x13,0x04,0x2d,0xfc,0x21,0x04,0x41,0xfc,0x01,0x04}}, // 屠
{0x454C,0x936B,0xC5CC,0xE5BE92,0x5F92,{0x08,0x20,0x08,0x20,0x11,0xfe,0x10,0x20,0x24,0x20,0x47,0xff,0x08,0x20,0x08,0x20,0x11,0x20,0x11,0x3e,0x31,0x20,0x51,0xa0,0x11,0x60,0x12,0x20,0x12,0x18,0x14,0x07}}, // 徒
{0x454D,0x936C,0xC5CD,0xE69697,0x6597,{0x00,0x10,0x00,0x10,0x0c,0x10,0x03,0x10,0x00,0x10,0x00,0x10,0x18,0x10,0x06,0x10,0x00,0x10,0x00,0x10,0x00,0x1f,0x03,0xf0,0x7c,0x10,0x00,0x10,0x00,0x10,0x00,0x10}}, // 斗
{0x454E,0x936D,0xC5CE,0xE69D9C,0x675C,{0x08,0x10,0x08,0x10,0x08,0x10,0x7f,0x10,0x08,0x10,0x08,0xfe,0x1c,0x10,0x1a,0x10,0x19,0x10,0x29,0x10,0x28,0x10,0x48,0x10,0x08,0x10,0x09,0xff,0x08,0x00,0x08,0x00}}, // 杜
{0x454F,0x936E,0xC5CF,0xE6B8A1,0x6E21,{0x10,0x20,0x08,0x20,0x0b,0xff,0x0a,0x44,0x42,0x44,0x23,0xff,0x22,0x44,0x22,0x7c,0x0a,0x00,0x0b,0xfc,0x12,0x44,0x12,0x48,0x24,0x28,0x24,0x30,0x48,0xcc,0x53,0x03}}, // 渡
{0x4550,0x936F,0xC5D0,0xE799BB,0x767B,{0x00,0x20,0x0f,0x24,0x01,0x18,0x22,0x11,0x14,0x0a,0x0f,0xfc,0x10,0x02,0x67,0xf9,0x04,0x08,0x04,0x08,0x07,0xf8,0x02,0x10,0x01,0x10,0x01,0x20,0x3f,0xff,0x00,0x00}}, // 登
{0x4551,0x9370,0xC5D1,0xE88F9F,0x83DF,{0x04,0x10,0x04,0x10,0x7f,0xff,0x05,0x10,0x01,0xf0,0x02,0x20,0x04,0x40,0x1f,0xf8,0x08,0x88,0x08,0x88,0x0f,0xf8,0x02,0x50,0x02,0x48,0x04,0x4a,0x18,0x22,0x60,0x1e}}, // 菟
{0x4552,0x9371,0xC5D2,0xE8B3AD,0x8CED,{0x00,0x22,0x3e,0x22,0x22,0xfc,0x22,0x24,0x3e,0x28,0x22,0x28,0x23,0xff,0x3e,0x20,0x22,0x7c,0x22,0xc4,0x23,0x44,0x3e,0x7c,0x14,0x44,0x12,0x44,0x22,0x7c,0x40,0x44}}, // 賭
{0x4553,0x9372,0xC5D3,0xE98094,0x9014,{0x00,0x20,0x20,0x20,0x10,0x50,0x10,0x50,0x00,0x88,0x01,0xfc,0x02,0x22,0x78,0x21,0x0b,0xfe,0x08,0xa8,0x08,0xa4,0x09,0x22,0x0e,0x22,0x14,0x60,0x23,0x00,0x40,0xff}}, // 途
{0x4554,0x9373,0xC5D4,0xE983BD,0x90FD,{0x04,0x00,0x04,0x9e,0x3f,0x92,0x04,0x92,0x05,0x14,0x05,0x14,0x7f,0xf8,0x04,0x14,0x0f,0x92,0x08,0x91,0x18,0x91,0x2f,0x91,0x48,0x99,0x08,0x96,0x0f,0x90,0x08,0x90}}, // 都
{0x4555,0x9374,0xC5D5,0xE98D8D,0x934D,{0x08,0x10,0x08,0x10,0x14,0xff,0x12,0xa4,0x20,0xa4,0x7e,0xff,0x08,0xa4,0x08,0xbc,0x7f,0x80,0x08,0xfe,0x4a,0xa4,0x2c,0x94,0x28,0x88,0x0f,0x14,0x19,0x22,0x62,0xc1}}, // 鍍
{0x4556,0x9375,0xC5D6,0xE7A0A5,0x7825,{0x00,0x04,0x7f,0x18,0x08,0xf0,0x08,0x90,0x08,0x90,0x08,0x90,0x1e,0xff,0x12,0x90,0x32,0x90,0x32,0x88,0x52,0x88,0x12,0xc8,0x1f,0x84,0x12,0x05,0x11,0xf3,0x00,0x01}}, // 砥
{0x4557,0x9376,0xC5D7,0xE7A0BA,0x783A,{0x00,0x00,0x7f,0xff,0x08,0x80,0x08,0x80,0x08,0xff,0x08,0x90,0x1e,0x90,0x12,0x9e,0x32,0x92,0x32,0x92,0x52,0x92,0x12,0xa2,0x1f,0x22,0x11,0x22,0x12,0x42,0x04,0x8c}}, // 砺
{0x4558,0x9377,0xC5D8,0xE58AAA,0x52AA,{0x04,0x00,0x04,0x00,0x7f,0xfc,0x09,0x44,0x09,0x44,0x11,0x28,0x3e,0x10,0x05,0x68,0x18,0x86,0x60,0x80,0x1f,0xf8,0x00,0x88,0x01,0x08,0x02,0x08,0x0c,0x08,0x30,0x30}}, // 努
{0x4559,0x9378,0xC5D9,0xE5BAA6,0x5EA6,{0x00,0x40,0x00,0x40,0x1f,0xfe,0x11,0x10,0x11,0x10,0x1f,0xfe,0x11,0x10,0x11,0xf0,0x10,0x00,0x17,0xf8,0x11,0x08,0x10,0x90,0x10,0x60,0x20,0xa0,0x23,0x18,0x5c,0x06}}, // 度
{0x455A,0x9379,0xC5DA,0xE59C9F,0x571F,{0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 土
{0x455B,0x937A,0xC5DB,0xE5A5B4,0x5974,{0x08,0x00,0x08,0x00,0x08,0xfc,0x08,0x04,0x7f,0x44,0x09,0x44,0x09,0x44,0x11,0x44,0x12,0x28,0x22,0x28,0x7c,0x18,0x06,0x10,0x0a,0x28,0x10,0x44,0x60,0x82,0x03,0x01}}, // 奴
{0x455C,0x937B,0xC5DC,0xE68092,0x6012,{0x04,0x00,0x04,0x00,0x7f,0xfe,0x09,0x22,0x09,0x14,0x12,0x08,0x3e,0x14,0x05,0x62,0x18,0x81,0x60,0x40,0x00,0x20,0x12,0x24,0x12,0x02,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 怒
{0x455D,0x937C,0xC5DD,0xE58092,0x5012,{0x08,0x02,0x0f,0xfa,0x09,0x0a,0x11,0x4a,0x11,0x2a,0x12,0x6a,0x33,0x9a,0x3c,0x9a,0x50,0x8a,0x17,0xea,0x10,0x8a,0x10,0x8a,0x10,0xb2,0x11,0xc2,0x16,0x02,0x10,0x06}}, // 倒
{0x455E,0x937D,0xC5DE,0xE5859A,0x515A,{0x00,0x80,0x08,0x88,0x04,0x88,0x04,0x90,0x7f,0xfe,0x40,0x02,0x4f,0xf2,0x48,0x12,0x08,0x10,0x0f,0xf0,0x02,0x40,0x02,0x40,0x02,0x42,0x04,0x42,0x18,0x22,0x60,0x1e}}, // 党
{0x455F,0x937E,0xC5DF,0xE586AC,0x51AC,{0x01,0x00,0x01,0x00,0x01,0xf8,0x02,0x08,0x06,0x10,0x19,0xa0,0x00,0x40,0x00,0xa0,0x03,0x10,0x0d,0x8c,0x70,0x43,0x00,0x20,0x06,0x00,0x01,0x80,0x00,0x60,0x00,0x10}}, // 冬
{0x4560,0x9380,0xC5E0,0xE5878D,0x51CD,{0x00,0x40,0x20,0x40,0x27,0xfe,0x10,0x40,0x13,0xfc,0x02,0x44,0x03,0xfc,0x02,0x44,0x0a,0x44,0x13,0xfc,0x10,0xe0,0x21,0x50,0x22,0x48,0x44,0x44,0x48,0x42,0x00,0x40}}, // 凍
{0x4561,0x9381,0xC5E1,0xE58880,0x5200,{0x00,0x00,0x00,0x00,0x3f,0xfe,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x01,0x02,0x01,0x02,0x01,0x02,0x02,0x02,0x04,0x02,0x08,0x04,0x10,0x18,0x00,0x00}}, // 刀
{0x4562,0x9382,0xC5E2,0xE59490,0x5510,{0x00,0x80,0x00,0x80,0x1f,0xff,0x10,0x40,0x17,0xfc,0x10,0x44,0x1f,0xff,0x10,0x44,0x10,0x44,0x17,0xfc,0x10,0x00,0x17,0xfc,0x24,0x04,0x24,0x04,0x47,0xfc,0x04,0x04}}, // 唐
{0x4563,0x9383,0xC5E3,0xE5A194,0x5854,{0x00,0x88,0x10,0x88,0x17,0xff,0x10,0x88,0x10,0x20,0x7c,0x20,0x10,0x50,0x10,0x88,0x11,0xfc,0x16,0x03,0x10,0x00,0x1d,0xfc,0x71,0x04,0x01,0x04,0x01,0xfc,0x01,0x04}}, // 塔
{0x4564,0x9384,0xC5E4,0xE5A198,0x5858,{0x00,0x20,0x10,0x20,0x11,0xff,0x11,0x10,0x11,0xfe,0x7d,0x12,0x11,0xff,0x11,0x12,0x11,0x12,0x11,0xfe,0x15,0x00,0x1a,0xfe,0x62,0x82,0x04,0x82,0x08,0xfe,0x00,0x82}}, // 塘
{0x4565,0x9385,0xC5E5,0xE5A597,0x5957,{0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0x40,0x02,0x20,0x0f,0xf8,0x72,0x07,0x03,0xf0,0x02,0x00,0x03,0xf0,0x02,0x00,0x7f,0xff,0x02,0x20,0x02,0x18,0x04,0xf4,0x3f,0x02}}, // 套
{0x4566,0x9386,0xC5E6,0xE5AE95,0x5B95,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x20,0x00,0x40,0x00,0x7f,0xfe,0x01,0x00,0x02,0x00,0x04,0x00,0x0f,0xf8,0x18,0x08,0x68,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 宕
{0x4567,0x9387,0xC5E7,0xE5B3B6,0x5CF6,{0x01,0x00,0x02,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x00,0x0f,0xff,0x08,0x00,0x0f,0xfe,0x02,0x02,0x22,0x22,0x22,0x22,0x3f,0xe2,0x20,0x1c}}, // 島
{0x4568,0x9388,0xC5E8,0xE5B68B,0x5D8B,{0x10,0x20,0x10,0x40,0x11,0xf8,0x55,0x08,0x55,0xf8,0x55,0x08,0x55,0xf8,0x55,0x00,0x55,0xff,0x55,0x00,0x55,0xfe,0x7e,0x52,0x43,0x2a,0x42,0xaa,0x04,0x82,0x08,0x0c}}, // 嶋
{0x4569,0x9389,0xC5E9,0xE682BC,0x60BC,{0x08,0x20,0x08,0x20,0x08,0x3f,0x08,0x20,0x2c,0xfc,0x2a,0x84,0x2a,0x84,0x28,0xfc,0x48,0x84,0x08,0x84,0x08,0xfc,0x08,0x20,0x0b,0xff,0x08,0x20,0x08,0x20,0x08,0x20}}, // 悼
{0x456A,0x938A,0xC5EA,0xE68A95,0x6295,{0x10,0x00,0x10,0xf8,0x10,0x88,0x10,0x88,0x7c,0x89,0x11,0x09,0x11,0x07,0x12,0x00,0x1d,0xf8,0x70,0x88,0x10,0x88,0x10,0x50,0x10,0x20,0x10,0x50,0x30,0x8c,0x13,0x03}}, // 投
{0x456B,0x938B,0xC5EB,0xE690AD,0x642D,{0x10,0x88,0x10,0x88,0x17,0xff,0x10,0x88,0x7c,0x20,0x10,0x20,0x10,0x50,0x10,0x88,0x11,0xfc,0x1e,0x03,0x70,0x00,0x11,0xfc,0x11,0x04,0x11,0x04,0x31,0xfc,0x11,0x04}}, // 搭
{0x456C,0x938C,0xC5EC,0xE69DB1,0x6771,{0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x1f,0xfc,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x84,0x1f,0xfc,0x01,0xc0,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80}}, // 東
{0x456D,0x938D,0xC5ED,0xE6A183,0x6843,{0x08,0x48,0x08,0x48,0x08,0x4a,0x7e,0x4a,0x09,0x4c,0x08,0xc8,0x1c,0x48,0x1a,0x48,0x1a,0xcc,0x29,0x4a,0x2a,0x49,0x48,0x49,0x08,0x88,0x08,0x89,0x09,0x09,0x0a,0x07}}, // 桃
{0x456E,0x938E,0xC5EE,0xE6A2BC,0x68BC,{0x08,0x20,0x08,0x20,0x09,0xfe,0x7e,0x20,0x08,0xfc,0x08,0x20,0x1d,0xff,0x1a,0x40,0x18,0x44,0x29,0xff,0x28,0x44,0x48,0xa4,0x08,0xa4,0x09,0x04,0x0a,0x0c,0x08,0x04}}, // 梼
{0x456F,0x938F,0xC5EF,0xE6A39F,0x68DF,{0x08,0x20,0x08,0x20,0x0b,0xff,0x7e,0x20,0x09,0xfc,0x09,0x24,0x1d,0xfc,0x1b,0x24,0x1b,0x24,0x29,0xfc,0x28,0x70,0x48,0x68,0x08,0xa4,0x09,0x22,0x0a,0x21,0x08,0x20}}, // 棟
{0x4570,0x9390,0xC5F0,0xE79B97,0x76D7,{0x00,0x80,0x10,0x80,0x08,0xfe,0x09,0x22,0x01,0x24,0x02,0x60,0x08,0x50,0x10,0x8c,0x21,0x03,0x22,0x00,0x1f,0xfc,0x12,0x24,0x12,0x24,0x12,0x24,0x7f,0xff,0x00,0x00}}, // 盗
{0x4571,0x9391,0xC5F1,0xE6B798,0x6DD8,{0x11,0x00,0x09,0x00,0x09,0xfe,0x02,0x82,0x02,0x82,0x45,0xfa,0x21,0x42,0x22,0x42,0x0b,0xfe,0x08,0x42,0x12,0x4a,0x12,0x4a,0x23,0xfa,0x22,0x0a,0x40,0x04,0x40,0x18}}, // 淘
{0x4572,0x9392,0xC5F2,0xE6B9AF,0x6E6F,{0x10,0x00,0x09,0xfc,0x09,0x04,0x01,0xfc,0x01,0x04,0x41,0x04,0x21,0xfc,0x20,0x00,0x0f,0xff,0x08,0x80,0x09,0xfe,0x12,0x4a,0x14,0x8a,0x21,0x12,0x22,0x22,0x40,0x4c}}, // 湯
{0x4573,0x9393,0xC5F3,0xE6B69B,0x6D9B,{0x10,0x40,0x08,0x40,0x0f,0xfe,0x00,0x40,0x03,0xfc,0x40,0x40,0x27,0xff,0x20,0x80,0x08,0x88,0x0f,0xff,0x11,0x08,0x11,0x48,0x22,0x28,0x24,0x28,0x48,0x08,0x40,0x18}}, // 涛
{0x4574,0x9394,0xC5F4,0xE781AF,0x706F,{0x04,0x00,0x04,0x00,0x04,0xff,0x04,0x88,0x14,0x88,0x15,0x08,0x15,0x08,0x24,0x08,0x04,0x08,0x06,0x08,0x09,0x08,0x09,0x08,0x10,0x88,0x10,0x88,0x20,0x18,0x40,0x08}}, // 灯
{0x4575,0x9395,0xC5F5,0xE78788,0x71C8,{0x09,0xd4,0x08,0x54,0x0a,0x49,0x09,0x8a,0x2c,0x84,0x2d,0xfa,0x2a,0x01,0x4d,0xfc,0x09,0x04,0x09,0x04,0x0d,0xfc,0x14,0x88,0x12,0x48,0x10,0x50,0x23,0xff,0x40,0x00}}, // 燈
{0x4576,0x9396,0xC5F6,0xE5BD93,0x5F53,{0x01,0x00,0x11,0x08,0x09,0x08,0x05,0x10,0x05,0x20,0x01,0x00,0x3f,0xfc,0x00,0x04,0x00,0x04,0x00,0x04,0x1f,0xfc,0x00,0x04,0x00,0x04,0x00,0x04,0x3f,0xfc,0x00,0x04}}, // 当
{0x4577,0x9397,0xC5F7,0xE79798,0x75D8,{0x00,0x40,0x00,0x40,0x0f,0xff,0x48,0x00,0x2f,0xfe,0x28,0x00,0x0b,0xfc,0x0a,0x04,0x1a,0x04,0x2a,0x04,0x4b,0xfc,0x11,0x08,0x10,0x88,0x20,0x90,0x5f,0xff,0x00,0x00}}, // 痘
{0x4578,0x9398,0xC5F8,0xE7A5B7,0x7977,{0x10,0x20,0x10,0x20,0x13,0xfe,0x7c,0x20,0x05,0xfc,0x08,0x20,0x0b,0xfe,0x10,0x48,0x18,0x48,0x37,0xff,0x54,0x88,0x10,0xc8,0x11,0x48,0x12,0x08,0x14,0x18,0x10,0x08}}, // 祷
{0x4579,0x9399,0xC5F9,0xE7AD89,0x7B49,{0x10,0x20,0x10,0x20,0x1f,0x7f,0x28,0x88,0x44,0x84,0x1f,0xfc,0x00,0x80,0x00,0x80,0x3f,0xfe,0x00,0x10,0x00,0x10,0x7f,0xff,0x04,0x10,0x02,0x10,0x02,0x30,0x00,0x10}}, // 等
{0x457A,0x939A,0xC5FA,0xE7AD94,0x7B54,{0x08,0x20,0x08,0x20,0x0f,0x3f,0x14,0x50,0x22,0x88,0x41,0x40,0x02,0x20,0x04,0x10,0x1f,0xfc,0x60,0x03,0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 答
{0x457B,0x939B,0xC5FB,0xE7AD92,0x7B52,{0x10,0x20,0x10,0x20,0x3f,0x7e,0x28,0x90,0x45,0x08,0x3f,0xfc,0x20,0x04,0x2f,0xf4,0x20,0x04,0x27,0xe4,0x24,0x24,0x24,0x24,0x27,0xe4,0x24,0x24,0x20,0x04,0x20,0x0c}}, // 筒
{0x457C,0x939C,0xC5FC,0xE7B396,0x7CD6,{0x08,0x20,0x0a,0x20,0x4b,0xff,0x2d,0x10,0x29,0x7e,0x09,0x12,0x7f,0xff,0x09,0x12,0x19,0x12,0x1d,0x7e,0x2b,0x00,0x29,0x7e,0x4a,0x42,0x0a,0x42,0x0c,0x7e,0x08,0x42}}, // 糖
{0x457D,0x939D,0xC5FD,0xE7B5B1,0x7D71,{0x08,0x20,0x08,0x20,0x0b,0xfe,0x72,0x20,0x14,0x48,0x08,0x9c,0x0d,0xe2,0x12,0x2a,0x7d,0x28,0x08,0x28,0x2c,0x48,0x2a,0x48,0x2a,0x88,0x2a,0x89,0x49,0x09,0x0a,0x07}}, // 統
{0x457E,0x939E,0xC5FE,0xE588B0,0x5230,{0x00,0x02,0x7f,0xe2,0x08,0x22,0x0a,0x22,0x11,0x22,0x13,0x22,0x7c,0xa2,0x04,0xa2,0x04,0x22,0x3f,0xa2,0x04,0x22,0x04,0x02,0x04,0x02,0x07,0x82,0x78,0x0e,0x00,0x02}}, // 到
{0x4621,0x939F,0xC6A1,0xE891A3,0x8463,{0x02,0x10,0x7f,0xff,0x02,0x18,0x0f,0xe0,0x00,0x80,0x7f,0xff,0x00,0x80,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff}}, // 董
{0x4622,0x93A0,0xC6A2,0xE895A9,0x8569,{0x02,0x10,0x7f,0xff,0x02,0x10,0x10,0xfc,0x08,0x84,0x08,0xfc,0x40,0x84,0x20,0xfc,0x20,0x00,0x03,0xff,0x08,0x80,0x11,0xfe,0x12,0x4a,0x24,0x92,0x21,0x22,0x40,0x0c}}, // 蕩
{0x4623,0x93A1,0xC6A3,0xE897A4,0x85E4,{0x02,0x20,0x7f,0xfe,0x02,0x20,0x00,0x20,0x3d,0x24,0x24,0xa8,0x25,0xfc,0x3c,0x50,0x25,0xfe,0x24,0xa8,0x3d,0x24,0x26,0xaa,0x24,0x70,0x24,0xa8,0x25,0x26,0x4c,0x60}}, // 藤
{0x4624,0x93A2,0xC6A4,0xE8A88E,0x8A0E,{0x00,0x04,0x3e,0x04,0x00,0x04,0x7f,0x04,0x00,0xff,0x3e,0x04,0x00,0x04,0x00,0x84,0x3e,0x44,0x00,0x44,0x3e,0x04,0x22,0x04,0x22,0x04,0x22,0x04,0x3e,0x1c,0x22,0x04}}, // 討
{0x4625,0x93A3,0xC6A5,0xE8AC84,0x8B04,{0x01,0x44,0x3c,0xa8,0x27,0xfe,0x24,0x50,0x27,0xff,0x3c,0x88,0x25,0x74,0x26,0x02,0x27,0xfd,0x3c,0x00,0x24,0xf8,0x24,0x00,0x25,0xfc,0x25,0x04,0x25,0xfc,0x4d,0x04}}, // 謄
{0x4626,0x93A4,0xC6A6,0xE8B186,0x8C46,{0x00,0x00,0x3f,0xfe,0x00,0x00,0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x00,0x00,0x04,0x10,0x02,0x10,0x02,0x20,0x00,0x42,0x7f,0xff,0x00,0x00}}, // 豆
{0x4627,0x93A5,0xC6A7,0xE8B88F,0x8E0F,{0x00,0x10,0x3e,0x12,0x23,0xf4,0x22,0x58,0x22,0x58,0x22,0x94,0x3f,0x12,0x08,0x31,0x28,0x00,0x2e,0xfc,0x28,0x84,0x28,0xfc,0x28,0x84,0x2e,0x84,0x38,0xfc,0x60,0x84}}, // 踏
{0x4628,0x93A6,0xC6A8,0xE98083,0x9003,{0x00,0xa0,0x20,0xa0,0x14,0xa4,0x12,0xa4,0x02,0xa8,0x00,0xb0,0x01,0xa0,0x7a,0xa8,0x0c,0xa4,0x08,0xa4,0x09,0x20,0x09,0x22,0x0e,0x22,0x14,0x1e,0x23,0x00,0x40,0xff}}, // 逃
{0x4629,0x93A7,0xC6A9,0xE9808F,0x900F,{0x00,0x04,0x20,0x18,0x11,0xe0,0x10,0x20,0x07,0xff,0x00,0x70,0x00,0xa8,0x79,0x24,0x0b,0xfb,0x08,0x48,0x08,0x4c,0x08,0x44,0x0c,0x84,0x15,0x18,0x23,0x00,0x40,0xff}}, // 透
{0x462A,0x93A8,0xC6AA,0xE99099,0x9419,{0x08,0xea,0x08,0x2c,0x14,0xa9,0x12,0x66,0x21,0x44,0x7e,0x82,0x09,0x7d,0x08,0x00,0x7f,0x7c,0x08,0x44,0x4a,0x44,0x2c,0x7c,0x28,0x44,0x0e,0x28,0x19,0xff,0x60,0x00}}, // 鐙
{0x462B,0x93A9,0xC6AB,0xE999B6,0x9676,{0x00,0x80,0x3c,0x80,0x24,0xfe,0x25,0x42,0x29,0x42,0x32,0xfa,0x29,0x22,0x26,0x22,0x27,0xfe,0x24,0x22,0x25,0x2a,0x39,0x2a,0x21,0xfa,0x21,0x0a,0x20,0x04,0x20,0x18}}, // 陶
{0x462C,0x93AA,0xC6AC,0xE9A0AD,0x982D,{0x00,0x00,0x7f,0xfe,0x00,0x20,0x00,0x40,0x3e,0xfc,0x22,0x84,0x22,0x84,0x22,0xfc,0x3e,0x84,0x02,0xfc,0x22,0x84,0x14,0x84,0x15,0xfc,0x0e,0x48,0x70,0x84,0x03,0x02}}, // 頭
{0x462D,0x93AB,0xC6AD,0xE9A8B0,0x9A30,{0x01,0x24,0x3c,0xa8,0x25,0xfe,0x24,0x50,0x27,0xff,0x3c,0x88,0x25,0xfc,0x26,0x92,0x24,0xfd,0x3c,0x90,0x24,0xfc,0x24,0x90,0x24,0xfe,0x25,0x52,0x25,0x2a,0x4e,0x0c}}, // 騰
{0x462E,0x93AC,0xC6AE,0xE99798,0x95D8,{0x00,0x00,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x40,0x02,0x5f,0x12,0x40,0xfe,0x5f,0x12,0x51,0x92,0x5f,0x52,0x4a,0x12,0x47,0x12,0x5c,0x32,0x40,0x06}}, // 闘
{0x462F,0x93AD,0xC6AF,0xE5838D,0x50CD,{0x08,0xc8,0x0f,0x08,0x09,0x08,0x0f,0xe8,0x11,0x1e,0x17,0xea,0x35,0x2a,0x37,0xea,0x55,0x2a,0x17,0xea,0x11,0x0a,0x17,0xca,0x11,0x32,0x11,0xd2,0x1e,0x22,0x10,0x4c}}, // 働
{0x4630,0x93AE,0xC6B0,0xE58B95,0x52D5,{0x01,0x90,0x1e,0x10,0x04,0x10,0x7f,0xd0,0x04,0x7e,0x1f,0x92,0x14,0x92,0x1f,0x92,0x14,0x92,0x14,0x92,0x1f,0x92,0x04,0x12,0x3f,0x22,0x05,0xa2,0x0e,0x42,0x70,0x8c}}, // 動
{0x4631,0x93AF,0xC6B1,0xE5908C,0x540C,{0x00,0x00,0x3f,0xfe,0x20,0x02,0x20,0x02,0x2f,0xfa,0x20,0x02,0x20,0x02,0x27,0xf2,0x24,0x12,0x24,0x12,0x24,0x12,0x27,0xf2,0x24,0x12,0x20,0x02,0x20,0x0e,0x20,0x02}}, // 同
{0x4632,0x93B0,0xC6B2,0xE5A082,0x5802,{0x11,0x10,0x09,0x10,0x09,0x20,0x3f,0xfe,0x20,0x04,0x4f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x01,0x00,0x01,0x00,0x1f,0xf8,0x01,0x00,0x01,0x00,0x7f,0xfe,0x00,0x00}}, // 堂
{0x4633,0x93B1,0xC6B3,0xE5B08E,0x5C0E,{0x00,0x88,0x27,0xff,0x10,0x40,0x11,0xfc,0x01,0x04,0x79,0xfc,0x09,0x04,0x09,0xfc,0x09,0x04,0x17,0x04,0x21,0xff,0x40,0x08,0x7f,0xff,0x04,0x08,0x02,0x08,0x00,0x18}}, // 導
{0x4634,0x93B2,0xC6B4,0xE686A7,0x61A7,{0x08,0x20,0x08,0x20,0x0b,0xfe,0x08,0x88,0x2f,0xff,0x28,0x00,0x2d,0xfc,0x2b,0x24,0x49,0xfc,0x09,0x24,0x09,0xfc,0x08,0x20,0x09,0xfc,0x08,0x20,0x0f,0xff,0x08,0x00}}, // 憧
{0x4635,0x93B3,0xC6B5,0xE6929E,0x649E,{0x10,0x20,0x10,0x20,0x13,0xfe,0x10,0x88,0x7f,0xff,0x10,0x00,0x11,0xfc,0x11,0x24,0x11,0xfc,0x1d,0x24,0x71,0xfc,0x10,0x20,0x11,0xfc,0x10,0x20,0x17,0xff,0x30,0x00}}, // 撞
{0x4636,0x93B4,0xC6B6,0xE6B49E,0x6D1E,{0x10,0x00,0x0b,0xfe,0x0a,0x02,0x02,0x02,0x43,0xfe,0x22,0x02,0x22,0x02,0x02,0xfa,0x0a,0x8a,0x0a,0x8a,0x12,0x8a,0x12,0xfa,0x22,0x8a,0x22,0x02,0x42,0x06,0x42,0x02}}, // 洞
{0x4637,0x93B5,0xC6B7,0xE79EB3,0x77B3,{0x00,0x20,0x7b,0xfe,0x48,0x88,0x48,0x50,0x4f,0xff,0x78,0x00,0x49,0xfc,0x49,0x24,0x79,0xfc,0x49,0x24,0x49,0xfc,0x48,0x20,0x79,0xfc,0x48,0x20,0x07,0xff,0x00,0x00}}, // 瞳
{0x4638,0x93B6,0xC6B8,0xE7ABA5,0x7AE5,{0x00,0x80,0x3f,0xfe,0x04,0x10,0x02,0x20,0x7f,0xff,0x00,0x00,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 童
{0x4639,0x93B7,0xC6B9,0xE883B4,0x80F4,{0x00,0x00,0x3d,0xfe,0x25,0x02,0x25,0x02,0x25,0xfe,0x3d,0x02,0x25,0x02,0x25,0x7a,0x25,0x4a,0x3d,0x4a,0x25,0x4a,0x25,0x7a,0x25,0x4a,0x25,0x02,0x2d,0x06,0x45,0x02}}, // 胴
{0x463A,0x93B8,0xC6BA,0xE89084,0x8404,{0x02,0x20,0x02,0x20,0x7f,0xff,0x0a,0x20,0x08,0x00,0x0f,0xfe,0x12,0x02,0x13,0xf2,0x24,0x82,0x4f,0xfa,0x10,0x82,0x08,0x92,0x08,0x92,0x0f,0xf2,0x08,0x14,0x00,0x18}}, // 萄
{0x463B,0x93B9,0xC6BB,0xE98193,0x9053,{0x01,0x04,0x20,0x88,0x17,0xff,0x10,0x40,0x00,0x80,0x01,0xfc,0x01,0x04,0x79,0xfc,0x09,0x04,0x09,0xfc,0x09,0x04,0x09,0x04,0x0d,0xfc,0x15,0x04,0x23,0x00,0x40,0xff}}, // 道
{0x463C,0x93BA,0xC6BC,0xE98A85,0x9285,{0x08,0x00,0x08,0xfe,0x14,0x82,0x12,0x82,0x20,0xfe,0x7e,0x82,0x08,0x82,0x08,0xba,0x7f,0xaa,0x08,0xaa,0x4a,0xaa,0x2a,0xba,0x2c,0xaa,0x0e,0x82,0x18,0x86,0x60,0x82}}, // 銅
{0x463D,0x93BB,0xC6BD,0xE5B3A0,0x5CE0,{0x10,0x20,0x10,0x20,0x10,0x3e,0x54,0x20,0x54,0x20,0x57,0xff,0x54,0x00,0x54,0x00,0x57,0xff,0x54,0x20,0x54,0x20,0x54,0x38,0x7c,0x26,0x44,0x20,0x00,0x20,0x00,0x20}}, // 峠
{0x463E,0x93BC,0xC6BE,0xE9B487,0x9D07,{0x20,0x10,0x24,0x20,0x38,0xfc,0x20,0x84,0x20,0xfc,0x22,0x84,0x1e,0xfc,0x08,0x80,0x08,0xff,0x08,0x80,0x7f,0xfe,0x08,0x2a,0x09,0x96,0x09,0x52,0x09,0x42,0x0a,0x0c}}, // 鴇
{0x463F,0x93BD,0xC6BF,0xE58CBF,0x533F,{0x00,0x00,0x3f,0xfe,0x20,0x00,0x22,0x10,0x3f,0xfe,0x22,0x90,0x20,0x80,0x3f,0xfe,0x21,0x00,0x23,0xf8,0x26,0x08,0x3a,0x08,0x23,0xf8,0x20,0x00,0x3f,0xfe,0x20,0x00}}, // 匿
{0x4640,0x93BE,0xC6C0,0xE5BE97,0x5F97,{0x08,0x00,0x09,0xfc,0x11,0x04,0x11,0xfc,0x25,0x04,0x45,0x04,0x09,0xfc,0x08,0x00,0x17,0xff,0x30,0x08,0x57,0xff,0x11,0x08,0x10,0x88,0x10,0x88,0x10,0x38,0x10,0x08}}, // 得
{0x4641,0x93BF,0xC6C1,0xE5BEB3,0x5FB3,{0x08,0x40,0x08,0x40,0x17,0xff,0x10,0x40,0x27,0xfc,0x46,0x94,0x0a,0x94,0x0a,0x94,0x13,0xfc,0x30,0x40,0x50,0x24,0x12,0xa2,0x12,0x81,0x14,0x89,0x18,0x88,0x10,0x78}}, // 徳
{0x4642,0x93C0,0xC6C2,0xE6B69C,0x6D9C,{0x10,0x20,0x08,0x20,0x0f,0xff,0x00,0x20,0x40,0x20,0x23,0xfe,0x20,0x00,0x03,0xfe,0x0a,0x02,0x0a,0x92,0x10,0x90,0x10,0x90,0x20,0x90,0x21,0x11,0x42,0x11,0x44,0x0f}}, // 涜
{0x4643,0x93C1,0xC6C3,0xE789B9,0x7279,{0x04,0x10,0x24,0x10,0x25,0xfe,0x24,0x10,0x3f,0x10,0x24,0x10,0x27,0xff,0x44,0x04,0x06,0x04,0x1d,0xff,0x64,0x44,0x04,0x24,0x04,0x24,0x04,0x04,0x04,0x1c,0x04,0x04}}, // 特
{0x4644,0x93C2,0xC6C4,0xE79DA3,0x7763,{0x04,0x00,0x07,0xfc,0x04,0x44,0x7f,0xa4,0x16,0x18,0x15,0x28,0x25,0x44,0x4c,0x83,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 督
{0x4645,0x93C3,0xC6C5,0xE7A6BF,0x79BF,{0x00,0x18,0x00,0xe0,0x3f,0x80,0x00,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x02,0x40,0x02,0x40,0x02,0x40,0x04,0x42,0x18,0x22,0x60,0x1e}}, // 禿
{0x4646,0x93C4,0xC6C6,0xE7AFA4,0x7BE4,{0x08,0x10,0x08,0x10,0x0f,0xbf,0x14,0x48,0x22,0x84,0x4f,0xfc,0x08,0x80,0x0f,0xf8,0x08,0x80,0x0f,0xf8,0x08,0x80,0x0f,0xfe,0x24,0x92,0x22,0x4a,0x22,0x42,0x40,0x0c}}, // 篤
{0x4647,0x93C5,0xC6C7,0xE6AF92,0x6BD2,{0x00,0x80,0x1f,0xfc,0x00,0x80,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x00,0x00,0x07,0xf8,0x04,0x88,0x04,0x88,0x7f,0xff,0x08,0x88,0x08,0x88,0x1f,0xfe,0x10,0x10,0x00,0x60}}, // 毒
{0x4648,0x93C6,0xC6C8,0xE78BAC,0x72EC,{0x04,0x20,0x44,0x20,0x28,0x20,0x13,0xfc,0x12,0x24,0x2a,0x24,0x4a,0x24,0x0a,0x24,0x1b,0xfc,0x18,0x20,0x28,0x20,0x48,0x28,0x08,0x24,0x08,0x3e,0x17,0xc2,0x60,0x02}}, // 独
{0x4649,0x93C7,0xC6C9,0xE8AAAD,0x8AAD,{0x00,0x10,0x3e,0x10,0x01,0xff,0x7e,0x10,0x00,0x10,0x3e,0xfe,0x00,0x00,0x00,0xff,0x3e,0x82,0x01,0x28,0x3e,0x28,0x22,0x28,0x22,0x48,0x22,0x49,0x3e,0x89,0x23,0x07}}, // 読
{0x464A,0x93C8,0xC6CA,0xE6A083,0x6803,{0x08,0x04,0x08,0x18,0x08,0xe0,0x7e,0x80,0x08,0xff,0x08,0x90,0x1c,0x90,0x1a,0x9e,0x1a,0x92,0x28,0x92,0x28,0x92,0x49,0x22,0x09,0x22,0x0a,0x42,0x0c,0x82,0x08,0x0c}}, // 栃
{0x464B,0x93C9,0xC6CB,0xE6A9A1,0x6A61,{0x08,0x40,0x08,0x78,0x08,0x90,0x7f,0x20,0x09,0xfc,0x09,0x24,0x1d,0x24,0x1b,0xfc,0x1a,0x22,0x28,0xc4,0x2b,0x28,0x48,0xd8,0x0b,0x34,0x08,0xd2,0x0b,0x11,0x08,0x60}}, // 橡
{0x464C,0x93CA,0xC6CC,0xE587B8,0x51F8,{0x00,0x00,0x03,0xe0,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x3e,0x3e,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x3f,0xfe,0x20,0x02,0x00,0x00}}, // 凸
{0x464D,0x93CB,0xC6CD,0xE7AA81,0x7A81,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x24,0x44,0x24,0x40,0x44,0x44,0x09,0x3c,0x11,0x00,0x21,0x00,0x7f,0xff,0x01,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x60,0x03}}, // 突
{0x464E,0x93CC,0xC6CE,0xE6A4B4,0x6934,{0x10,0x40,0x10,0xbc,0x13,0x24,0x7e,0x24,0x12,0x25,0x13,0xa5,0x3a,0x43,0x36,0x80,0x33,0xfc,0x52,0x24,0x52,0x24,0x13,0x98,0x16,0x08,0x12,0x14,0x12,0x22,0x12,0xc1}}, // 椴
{0x464F,0x93CD,0xC6CF,0xE5B18A,0x5C4A,{0x00,0x00,0x1f,0xfe,0x10,0x02,0x10,0x02,0x1f,0xfe,0x10,0x42,0x10,0x40,0x17,0xfe,0x14,0x42,0x14,0x42,0x14,0x42,0x17,0xfe,0x24,0x42,0x24,0x42,0x47,0xfe,0x04,0x02}}, // 届
{0x4650,0x93CE,0xC6D0,0xE9B3B6,0x9CF6,{0x01,0x10,0x01,0x08,0x7f,0xff,0x00,0x80,0x02,0x61,0x04,0x19,0x0f,0xf7,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xff,0x08,0x00,0x0f,0xfe,0x29,0x22,0x24,0x92,0x44,0x0c}}, // 鳶
{0x4651,0x93CF,0xC6D1,0xE88BAB,0x82EB,{0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x10,0x04,0x90,0x00,0x80,0x00,0x80,0x00,0xfe,0x00,0x80,0x00,0x80,0x1f,0xf8,0x10,0x08,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x08}}, // 苫
{0x4652,0x93D0,0xC6D2,0xE5AF85,0x5BC5,{0x01,0x00,0x01,0x00,0x7f,0xfe,0x40,0x02,0x5f,0xfa,0x01,0x00,0x1f,0xf8,0x11,0x08,0x11,0x08,0x1f,0xf8,0x11,0x08,0x11,0x08,0x1f,0xf8,0x04,0x20,0x18,0x18,0x60,0x04}}, // 寅
{0x4653,0x93D1,0xC6D3,0xE98589,0x9149,{0x00,0x00,0x7f,0xfe,0x02,0x40,0x02,0x40,0x3f,0xfc,0x22,0x44,0x22,0x44,0x24,0x4c,0x28,0x3c,0x30,0x04,0x20,0x04,0x3f,0xfc,0x20,0x04,0x20,0x04,0x3f,0xfc,0x20,0x04}}, // 酉
{0x4654,0x93D2,0xC6D4,0xE7809E,0x701E,{0x22,0x10,0x12,0x1e,0x1f,0xa4,0x02,0x48,0x4f,0xbe,0x22,0x0a,0x3f,0xca,0x00,0x7f,0x07,0x8a,0x14,0x8a,0x17,0xbe,0x24,0x8a,0x27,0x88,0x24,0x88,0x44,0x98,0x45,0x88}}, // 瀞
{0x4655,0x93D3,0xC6D5,0xE599B8,0x5678,{0x01,0x00,0x01,0x7f,0x71,0x04,0x51,0xe8,0x5f,0x1e,0x51,0x52,0x55,0x52,0x55,0x5e,0x55,0x52,0x57,0xde,0x55,0x52,0x71,0x12,0x41,0x5e,0x00,0xd4,0x00,0x22,0x00,0xc1}}, // 噸
{0x4656,0x93D4,0xC6D6,0xE5B1AF,0x5C6F,{0x00,0x80,0x00,0x83,0x00,0xfc,0x7f,0x80,0x00,0x80,0x00,0x80,0x08,0x88,0x08,0x88,0x08,0x88,0x08,0x88,0x08,0x88,0x0f,0xf8,0x08,0x88,0x00,0x82,0x00,0x42,0x00,0x3e}}, // 屯
{0x4657,0x93D5,0xC6D7,0xE68387,0x60C7,{0x08,0x20,0x08,0x20,0x0b,0xff,0x08,0x00,0x0c,0xfc,0x2a,0x84,0x2a,0xfc,0x28,0x00,0x49,0xfc,0x08,0x08,0x08,0x10,0x0b,0xff,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x30}}, // 惇
{0x4658,0x93D6,0xC6D8,0xE695A6,0x6566,{0x04,0x20,0x04,0x20,0x7f,0xa0,0x00,0x3f,0x1f,0x24,0x11,0x44,0x1f,0x44,0x00,0xa4,0x3f,0x24,0x02,0x14,0x04,0x18,0x07,0x88,0x7c,0x14,0x04,0x24,0x04,0x42,0x0d,0x81}}, // 敦
{0x4659,0x93D7,0xC6D9,0xE6B28C,0x6C8C,{0x10,0x40,0x08,0x44,0x08,0x58,0x07,0xe0,0x00,0x40,0x42,0x44,0x22,0x44,0x22,0x44,0x0a,0x44,0x0a,0x44,0x13,0xfc,0x12,0x44,0x22,0x40,0x20,0x42,0x40,0x22,0x40,0x1e}}, // 沌
{0x465A,0x93D8,0xC6DA,0xE8B19A,0x8C5A,{0x00,0x00,0x3d,0xff,0x24,0x40,0x24,0x22,0x24,0x62,0x3c,0x54,0x24,0x94,0x25,0x28,0x24,0x4c,0x3c,0x9c,0x25,0x1a,0x24,0x2a,0x24,0x49,0x24,0x88,0x2d,0x08,0x44,0x30}}, // 豚
{0x465B,0x93D9,0xC6DB,0xE98181,0x9041,{0x00,0x04,0x20,0x18,0x13,0xf0,0x12,0x10,0x03,0xff,0x02,0x10,0x02,0xfc,0x7a,0x84,0x0a,0xfc,0x0a,0x84,0x0a,0xfc,0x0c,0x84,0x14,0xfc,0x12,0x84,0x21,0x80,0x40,0x7f}}, // 遁
{0x465C,0x93DA,0xC6DC,0xE9A093,0x9813,{0x08,0x00,0x09,0xff,0x0f,0x10,0x78,0x20,0x08,0x7e,0x2a,0x42,0x2a,0x7e,0x2a,0x42,0x2a,0x42,0x2a,0x7e,0x3e,0x42,0x2a,0x42,0x28,0x7e,0x09,0x24,0x07,0x42,0x01,0x81}}, // 頓
{0x465D,0x93DB,0xC6DD,0xE59191,0x5451,{0x00,0x10,0x00,0x60,0x1f,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x6f,0xfb,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 呑
{0x465E,0x93DC,0xC6DE,0xE69B87,0x66C7,{0x00,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x3f,0xfc,0x01,0x00,0x3f,0xfe,0x2d,0x74,0x41,0x00,0x1f,0xf8,0x00,0x00,0x7f,0xfe,0x02,0x20,0x04,0xd8,0x3f,0x04}}, // 曇
{0x465F,0x93DD,0xC6DF,0xE9888D,0x920D,{0x08,0x20,0x08,0x22,0x14,0x2c,0x13,0xf0,0x22,0x20,0x7e,0xa4,0x08,0xa4,0x08,0xa4,0x7e,0xa4,0x08,0xa4,0x4a,0xfc,0x2c,0xa4,0x28,0xa0,0x0e,0x21,0x18,0x11,0x60,0x0f}}, // 鈍
{0x4660,0x93DE,0xC6E0,0xE5A588,0x5948,{0x00,0x80,0x00,0x80,0x3f,0xfe,0x01,0x40,0x02,0x20,0x04,0x10,0x1b,0xec,0x60,0x03,0x00,0x00,0x3f,0xfe,0x00,0x80,0x02,0xa0,0x04,0x98,0x18,0x84,0x61,0x82,0x00,0x80}}, // 奈
{0x4661,0x93DF,0xC6E1,0xE982A3,0x90A3,{0x00,0x00,0x7f,0x3e,0x09,0x22,0x09,0x24,0x09,0x28,0x3f,0x38,0x09,0x24,0x09,0x22,0x09,0x22,0x3f,0x21,0x09,0x31,0x09,0x29,0x11,0x26,0x11,0x20,0x21,0x20,0x43,0x20}}, // 那
{0x4662,0x93E0,0xC6E2,0xE58685,0x5185,{0x00,0x80,0x00,0x80,0x00,0x80,0x3f,0xfe,0x20,0x82,0x20,0x82,0x21,0x42,0x21,0x42,0x22,0x22,0x24,0x12,0x28,0x0a,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x0e,0x20,0x02}}, // 内
{0x4663,0x93E1,0xC6E3,0xE4B98D,0x4E4D,{0x04,0x00,0x04,0x00,0x04,0x00,0x07,0xfe,0x08,0x80,0x08,0x80,0x10,0x80,0x20,0xfc,0x40,0x80,0x00,0x80,0x00,0x80,0x00,0xfc,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 乍
{0x4664,0x93E2,0xC6E4,0xE587AA,0x51EA,{0x00,0x00,0x1f,0xf8,0x10,0x08,0x10,0x88,0x10,0x88,0x10,0x88,0x14,0x88,0x14,0x88,0x14,0xe8,0x14,0x88,0x14,0x88,0x14,0x88,0x14,0x85,0x24,0x85,0x3f,0xfb,0x40,0x01}}, // 凪
{0x4665,0x93E3,0xC6E5,0xE89699,0x8599,{0x04,0x20,0x04,0x20,0x7f,0xff,0x04,0x20,0x10,0x24,0x10,0x48,0x1f,0x7f,0x28,0xc8,0x48,0x48,0x7f,0x7e,0x08,0x48,0x0c,0x7e,0x12,0x48,0x11,0x48,0x21,0x7f,0x40,0x40}}, // 薙
{0x4666,0x93E4,0xC6E6,0xE8AC8E,0x8B0E,{0x00,0x08,0x3c,0x4a,0x00,0x2a,0x7f,0x2a,0x00,0x8c,0x3c,0xff,0x00,0x08,0x03,0x9c,0x3c,0x9c,0x00,0xaa,0x3c,0xaa,0x24,0xc9,0x25,0x48,0x25,0x28,0x3e,0x18,0x24,0x07}}, // 謎
{0x4667,0x93E5,0xC6E7,0xE78198,0x7058,{0x12,0x8a,0x0a,0x8a,0x0f,0xf4,0x02,0x9f,0x47,0xd4,0x25,0x74,0x25,0x54,0x07,0xdf,0x01,0x14,0x17,0xd4,0x11,0x1f,0x2f,0xf4,0x22,0x94,0x22,0x54,0x44,0x1f,0x48,0x10}}, // 灘
{0x4668,0x93E6,0xC6E8,0xE68DBA,0x637A,{0x10,0x20,0x10,0x20,0x13,0xff,0x10,0x30,0x7c,0x50,0x10,0x88,0x11,0x04,0x12,0xfa,0x1c,0x01,0x70,0x00,0x13,0xfe,0x10,0xa0,0x10,0xa8,0x11,0x24,0x12,0x62,0x30,0x20}}, // 捺
{0x4669,0x93E7,0xC6E9,0xE98D8B,0x934B,{0x08,0x00,0x08,0xfc,0x14,0x84,0x12,0xbc,0x22,0xa4,0x7e,0xa4,0x08,0xa4,0x09,0xfe,0x7f,0x02,0x09,0x7a,0x4b,0x4a,0x2d,0x4a,0x29,0x7a,0x0f,0x4a,0x19,0x02,0x61,0x06}}, // 鍋
{0x466A,0x93E8,0xC6EA,0xE6A5A2,0x6962,{0x08,0x84,0x08,0x44,0x08,0x48,0x0b,0xff,0x7e,0x48,0x08,0x48,0x09,0xfe,0x1d,0x4a,0x1b,0x4a,0x29,0x8e,0x29,0x02,0x49,0xfe,0x09,0x02,0x09,0x02,0x09,0xfe,0x09,0x02}}, // 楢
{0x466B,0x93E9,0xC6EB,0xE9A6B4,0x99B4,{0x00,0x22,0x3f,0xaa,0x24,0x2a,0x24,0x2a,0x3f,0x2a,0x24,0x2a,0x3f,0x2a,0x24,0x2a,0x24,0x2a,0x3f,0xaa,0x02,0xaa,0x35,0xaa,0x2a,0xaa,0x2a,0xa2,0x41,0x42,0x06,0x82}}, // 馴
{0x466C,0x93EA,0xC6EC,0xE7B884,0x7E04,{0x08,0x00,0x08,0xfc,0x0a,0x94,0x72,0xfc,0x14,0x94,0x08,0x94,0x0a,0xfc,0x12,0x10,0x7f,0xfe,0x09,0x92,0x2c,0xfe,0x2a,0x92,0x2a,0x92,0x4a,0xfe,0x48,0x11,0x08,0x0f}}, // 縄
{0x466D,0x93EB,0xC6ED,0xE795B7,0x7577,{0x00,0x00,0x03,0xde,0x7c,0x42,0x55,0x4a,0x54,0x84,0x54,0xc6,0x55,0x4a,0x7e,0x10,0x54,0x00,0x57,0xfe,0x54,0x52,0x55,0x4a,0x7c,0x84,0x01,0x4c,0x02,0x52,0x0c,0x21}}, // 畷
{0x466E,0x93EC,0xC6EE,0xE58D97,0x5357,{0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x1f,0xfc,0x12,0x24,0x11,0x44,0x17,0xf4,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x84,0x10,0x84,0x10,0x8c,0x10,0x84}}, // 南
{0x466F,0x93ED,0xC6EF,0xE6A5A0,0x6960,{0x08,0x20,0x08,0x20,0x0b,0xff,0x7c,0x20,0x08,0x20,0x09,0xfe,0x19,0x8a,0x1d,0x52,0x1b,0xfa,0x29,0x22,0x29,0x22,0x49,0xfa,0x09,0x22,0x09,0x22,0x09,0x26,0x09,0x22}}, // 楠
{0x4670,0x93EE,0xC6F0,0xE8BB9F,0x8EDF,{0x08,0x20,0x08,0x20,0x7f,0xa0,0x08,0x20,0x3f,0x7f,0x29,0x52,0x29,0x54,0x3f,0x90,0x29,0x10,0x29,0x10,0x3f,0x28,0x08,0x28,0x7f,0xc4,0x08,0x44,0x08,0x82,0x09,0x01}}, // 軟
{0x4671,0x93EF,0xC6F1,0xE99BA3,0x96E3,{0x12,0x24,0x7f,0xa4,0x12,0x28,0x12,0x7f,0x3f,0x48,0x25,0xc8,0x25,0x48,0x3f,0x7e,0x04,0x48,0x3f,0xc8,0x04,0x7e,0x7f,0xc8,0x0a,0x48,0x09,0x48,0x10,0xff,0x60,0x40}}, // 難
{0x4672,0x93F0,0xC6F2,0xE6B19D,0x6C5D,{0x10,0x40,0x08,0x40,0x08,0x40,0x00,0x40,0x4f,0xff,0x20,0x88,0x20,0x88,0x00,0x88,0x09,0x08,0x09,0x10,0x13,0xd0,0x12,0x20,0x20,0x50,0x20,0x88,0x43,0x04,0x4c,0x02}}, // 汝
{0x4673,0x93F1,0xC6F3,0xE4BA8C,0x4E8C,{0x00,0x00,0x00,0x08,0x1f,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x7f,0xff,0x00,0x00,0x00,0x00}}, // 二
{0x4674,0x93F2,0xC6F4,0xE5B0BC,0x5C3C,{0x00,0x00,0x1f,0xfe,0x10,0x02,0x10,0x02,0x10,0x02,0x1f,0xfe,0x12,0x02,0x12,0x00,0x12,0x04,0x12,0x38,0x13,0xc0,0x12,0x00,0x22,0x02,0x22,0x02,0x41,0x02,0x00,0xfe}}, // 尼
{0x4675,0x93F3,0xC6F5,0xE5BC90,0x5F10,{0x00,0x48,0x3f,0x44,0x00,0x44,0x00,0x40,0x7f,0xff,0x00,0x20,0x00,0x20,0x3f,0x20,0x00,0x20,0x00,0x10,0x00,0x10,0x01,0x90,0x0e,0x0a,0x70,0x0a,0x00,0x06,0x00,0x02}}, // 弐
{0x4676,0x93F4,0xC6F6,0xE8BFA9,0x8FE9,{0x01,0x00,0x21,0x00,0x11,0xfe,0x11,0x20,0x02,0x20,0x02,0x20,0x04,0xa8,0x78,0xa4,0x09,0x24,0x09,0x22,0x0a,0x22,0x0c,0x22,0x14,0x60,0x12,0x20,0x21,0x80,0x40,0x7f}}, // 迩
{0x4677,0x93F5,0xC6F7,0xE58C82,0x5302,{0x08,0x00,0x08,0x00,0x08,0x00,0x0f,0xfe,0x14,0x02,0x14,0x02,0x24,0x22,0x44,0xc2,0x07,0x02,0x04,0x02,0x04,0x12,0x04,0x12,0x03,0xf2,0x00,0x02,0x00,0x04,0x00,0x18}}, // 匂
{0x4678,0x93F6,0xC6F8,0xE8B391,0x8CD1,{0x00,0x00,0x3e,0xff,0x22,0x80,0x22,0x80,0x3e,0xbc,0x22,0x80,0x22,0x80,0x3e,0xfe,0x22,0xb0,0x22,0xb2,0x22,0xaa,0x3e,0xac,0x18,0xa4,0x15,0x24,0x21,0x32,0x42,0xc1}}, // 賑
{0x4679,0x93F7,0xC6F9,0xE88289,0x8089,{0x00,0x80,0x00,0x80,0x3f,0xfe,0x20,0x82,0x20,0x82,0x21,0x42,0x21,0x22,0x22,0x92,0x24,0x92,0x28,0x82,0x21,0x42,0x21,0x22,0x22,0x12,0x24,0x12,0x28,0x02,0x20,0x06}}, // 肉
{0x467A,0x93F8,0xC6FA,0xE899B9,0x8679,{0x08,0x00,0x08,0x00,0x08,0xfe,0x3f,0x10,0x29,0x10,0x29,0x10,0x29,0x10,0x29,0x10,0x3f,0x10,0x08,0x10,0x0a,0x10,0x09,0x10,0x09,0x10,0x0f,0xff,0x70,0x80,0x00,0x80}}, // 虹
{0x467B,0x93F9,0xC6FB,0xE5BBBF,0x5EFF,{0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x07,0xf0,0x04,0x10}}, // 廿
{0x467C,0x93FA,0xC6FC,0xE697A5,0x65E5,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 日
{0x467D,0x93FB,0xC6FD,0xE4B9B3,0x4E73,{0x00,0xa0,0x07,0x20,0x78,0xa0,0x24,0xa0,0x15,0x20,0x12,0x20,0x3f,0xa0,0x01,0x20,0x02,0x20,0x04,0x20,0x07,0xe0,0x7c,0x20,0x04,0x20,0x04,0x21,0x04,0x11,0x0c,0x0f}}, // 乳
{0x467E,0x93FC,0xC6FE,0xE585A5,0x5165,{0x03,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x01,0x40,0x01,0x40,0x02,0x20,0x02,0x20,0x04,0x10,0x08,0x08,0x10,0x04,0x20,0x02,0x40,0x01}}, // 入
{0x4721,0x9440,0xC7A1,0xE5A682,0x5982,{0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x7e,0x7f,0x42,0x12,0x42,0x12,0x42,0x12,0x42,0x22,0x42,0x24,0x42,0x7c,0x42,0x44,0x42,0x0a,0x7e,0x11,0x42,0x60,0x00,0x00,0x00}}, // 如
{0x4722,0x9441,0xC7A2,0xE5B0BF,0x5C3F,{0x00,0x00,0x1f,0xfc,0x10,0x04,0x10,0x04,0x1f,0xfc,0x10,0x44,0x10,0x40,0x10,0x44,0x1f,0x64,0x11,0x68,0x11,0x50,0x12,0x50,0x22,0x48,0x24,0x44,0x48,0x43,0x00,0xc0}}, // 尿
{0x4723,0x9442,0xC7A3,0xE99FAE,0x97EE,{0x02,0x20,0x02,0x20,0x7f,0xff,0x02,0x20,0x00,0x00,0x02,0x20,0x3e,0x3e,0x02,0x20,0x3e,0x3e,0x02,0x20,0x02,0x20,0x3e,0x3e,0x02,0x20,0x02,0x20,0x7f,0xff,0x00,0x00}}, // 韮
{0x4724,0x9443,0xC7A4,0xE4BBBB,0x4EFB,{0x04,0x04,0x04,0x18,0x04,0x60,0x0b,0xa0,0x08,0x20,0x18,0x20,0x18,0x20,0x2f,0xff,0x48,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x0b,0xfe,0x08,0x00,0x08,0x00}}, // 任
{0x4725,0x9444,0xC7A5,0xE5A68A,0x598A,{0x08,0x04,0x08,0x18,0x08,0xf0,0x08,0x10,0x7f,0x10,0x12,0x10,0x12,0x10,0x13,0xff,0x22,0x10,0x24,0x10,0x7c,0x10,0x46,0x10,0x0a,0x10,0x10,0x10,0x60,0xfe,0x00,0x00}}, // 妊
{0x4726,0x9445,0xC7A6,0xE5BF8D,0x5FCD,{0x00,0x00,0x3f,0xf8,0x00,0x88,0x18,0x88,0x05,0x08,0x02,0x08,0x05,0x08,0x18,0x88,0x60,0x30,0x04,0x80,0x04,0x40,0x14,0x48,0x14,0x04,0x24,0x12,0x42,0x12,0x01,0xf0}}, // 忍
{0x4727,0x9446,0xC7A7,0xE8AA8D,0x8A8D,{0x00,0x00,0x3e,0xfe,0x00,0x12,0x7f,0x52,0x00,0x22,0x3e,0x32,0x00,0x52,0x01,0x8c,0x3e,0x20,0x00,0x10,0x3e,0x28,0x22,0xaa,0x22,0xa1,0x22,0xa5,0x3f,0x25,0x22,0x1c}}, // 認
{0x4728,0x9447,0xC7A8,0xE6BFA1,0x6FE1,{0x20,0x00,0x13,0xfc,0x10,0x40,0x07,0xfe,0x44,0x42,0x25,0xda,0x24,0x42,0x01,0xd8,0x08,0x00,0x0f,0xff,0x10,0x40,0x13,0xfe,0x22,0x52,0x22,0x52,0x42,0x52,0x42,0x06}}, // 濡
{0x4729,0x9448,0xC7A9,0xE7A6B0,0x79B0,{0x10,0x00,0x13,0xff,0x11,0x24,0x7e,0x22,0x07,0xff,0x0a,0x22,0x0b,0x76,0x12,0xaa,0x13,0x76,0x3a,0x22,0x57,0x76,0x12,0xaa,0x13,0x76,0x12,0x22,0x12,0x22,0x12,0x06}}, // 禰
{0x472A,0x9449,0xC7AA,0xE7A5A2,0x7962,{0x08,0x40,0x08,0x40,0x08,0x40,0x7e,0x7f,0x02,0x90,0x04,0x90,0x05,0x10,0x08,0x58,0x1c,0x54,0x2a,0x54,0x49,0x52,0x08,0x92,0x09,0x12,0x08,0x10,0x08,0x10,0x08,0x30}}, // 祢
{0x472B,0x944A,0xC7AB,0xE5AFA7,0x5BE7,{0x01,0x00,0x01,0x00,0x7f,0xfe,0x45,0x02,0x54,0x8a,0x12,0x24,0x21,0xe2,0x5f,0xfa,0x12,0x48,0x1f,0xf8,0x00,0x00,0x7f,0xfe,0x00,0x80,0x00,0x80,0x00,0x80,0x01,0x80}}, // 寧
{0x472C,0x944B,0xC7AC,0xE891B1,0x8471,{0x02,0x20,0x02,0x20,0x7f,0xff,0x02,0x20,0x04,0x00,0x07,0xfc,0x09,0x24,0x17,0xa4,0x22,0x74,0x04,0x44,0x08,0x98,0x12,0x40,0x12,0x42,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 葱
{0x472D,0x944C,0xC7AD,0xE78CAB,0x732B,{0x04,0x88,0x44,0x88,0x2f,0xff,0x10,0x88,0x10,0x88,0x28,0x00,0x4b,0xfe,0x0a,0x22,0x1a,0x22,0x1a,0x22,0x2b,0xfe,0x4a,0x22,0x0a,0x22,0x0a,0x22,0x6b,0xfe,0x12,0x02}}, // 猫
{0x472E,0x944D,0xC7AE,0xE786B1,0x71B1,{0x04,0x10,0x04,0x10,0x3f,0x90,0x04,0x7c,0x7f,0x94,0x12,0x14,0x25,0x74,0x5f,0x94,0x04,0x2c,0x07,0xc5,0x78,0x83,0x00,0x00,0x14,0x88,0x12,0x44,0x21,0x22,0x41,0x22}}, // 熱
{0x472F,0x944E,0xC7AF,0xE5B9B4,0x5E74,{0x04,0x00,0x04,0x00,0x0f,0xfe,0x08,0x40,0x10,0x40,0x20,0x40,0x4f,0xfc,0x08,0x40,0x08,0x40,0x08,0x40,0x08,0x40,0x7f,0xff,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40}}, // 年
{0x4730,0x944F,0xC7B0,0xE5BFB5,0x5FF5,{0x00,0x80,0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x1b,0xec,0x60,0x03,0x0f,0xf0,0x00,0x20,0x00,0x40,0x12,0x80,0x12,0x48,0x12,0x24,0x22,0x2a,0x41,0x0a,0x00,0xf8}}, // 念
{0x4731,0x9450,0xC7B1,0xE68DBB,0x637B,{0x10,0x20,0x10,0x20,0x10,0x50,0x7d,0x8c,0x16,0xfb,0x10,0x00,0x11,0xfc,0x10,0x08,0x1c,0x10,0x70,0x50,0x12,0x20,0x12,0xa4,0x12,0xa2,0x14,0x89,0x38,0x49,0x10,0x38}}, // 捻
{0x4732,0x9451,0xC7B2,0xE6929A,0x649A,{0x11,0x08,0x11,0x0a,0x11,0xc9,0x11,0x7f,0x7d,0x48,0x12,0xc8,0x12,0x4c,0x15,0x94,0x10,0x92,0x19,0x22,0x72,0x41,0x14,0x00,0x11,0x52,0x11,0x52,0x12,0x49,0x34,0x49}}, // 撚
{0x4733,0x9452,0xC7B3,0xE78783,0x71C3,{0x09,0x08,0x09,0x0a,0x09,0xc9,0x09,0x7f,0x29,0x48,0x2a,0xc8,0x2e,0x8c,0x29,0x94,0x49,0x12,0x0a,0x22,0x0c,0x41,0x0a,0x00,0x13,0x52,0x11,0x52,0x22,0x49,0x44,0x49}}, // 燃
{0x4734,0x9453,0xC7B4,0xE7B298,0x7C98,{0x08,0x20,0x4a,0x20,0x2a,0x20,0x2c,0x20,0x28,0x3f,0x08,0x20,0x7f,0x20,0x08,0x20,0x1c,0x20,0x1a,0xfc,0x29,0x84,0x28,0x84,0x48,0x84,0x08,0x84,0x08,0xfc,0x08,0x84}}, // 粘
{0x4735,0x9454,0xC7B5,0xE4B983,0x4E43,{0x00,0x00,0x3f,0xf0,0x01,0x10,0x01,0x10,0x01,0x10,0x01,0x10,0x01,0x1c,0x02,0x04,0x02,0x04,0x04,0x04,0x04,0x04,0x08,0x04,0x10,0x04,0x20,0x08,0x40,0x30,0x00,0x00}}, // 乃
{0x4736,0x9455,0xC7B6,0xE5BBBC,0x5EFC,{0x00,0x00,0x7d,0xff,0x04,0x28,0x08,0x28,0x08,0xfe,0x10,0xaa,0x3c,0xaa,0x04,0xaa,0x24,0xae,0x14,0xc2,0x18,0x82,0x08,0x82,0x0c,0xfe,0x12,0x82,0x21,0x80,0x40,0x7f}}, // 廼
{0x4737,0x9456,0xC7B7,0xE4B98B,0x4E4B,{0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x08,0x00,0x10,0x00,0x10,0x00,0x20,0x00,0x40,0x08,0x80,0x09,0x00,0x0e,0x00,0x12,0x00,0x21,0x80,0x40,0x7f}}, // 之
{0x4738,0x9457,0xC7B8,0xE59F9C,0x57DC,{0x04,0x10,0x04,0x10,0x7f,0xff,0x0c,0x18,0x0e,0x38,0x15,0x54,0x24,0x92,0x44,0x11,0x04,0x10,0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 埜
{0x4739,0x9458,0xC7B9,0xE59AA2,0x56A2,{0x01,0x00,0x7f,0xfc,0x11,0x10,0x1f,0xf0,0x01,0x00,0x7f,0xfe,0x44,0x22,0x1a,0x5e,0x6f,0xf8,0x02,0x40,0x3f,0xf8,0x02,0x40,0x7f,0xfe,0x04,0x88,0x78,0x70,0x0e,0x0e}}, // 嚢
{0x473A,0x9459,0xC7BA,0xE682A9,0x60A9,{0x08,0x42,0x09,0x22,0x08,0xa4,0x08,0xa4,0x2c,0x88,0x2a,0x00,0x2b,0x0a,0x29,0x0a,0x49,0xca,0x09,0x32,0x09,0x12,0x09,0x2a,0x09,0x4a,0x09,0x82,0x09,0xfe,0x09,0x02}}, // 悩
{0x473B,0x945A,0xC7BB,0xE6BF83,0x6FC3,{0x10,0x50,0x0b,0xfe,0x0a,0x52,0x03,0xfe,0x42,0x52,0x23,0xfe,0x20,0x00,0x03,0xff,0x0a,0x00,0x0a,0xfe,0x12,0x00,0x13,0xff,0x24,0xa2,0x24,0x94,0x48,0xcc,0x53,0x03}}, // 濃
{0x473C,0x945B,0xC7BC,0xE7B48D,0x7D0D,{0x08,0x10,0x08,0x10,0x0a,0x10,0x72,0xfe,0x14,0x92,0x08,0x92,0x0c,0x92,0x12,0xaa,0x7d,0xaa,0x09,0xaa,0x2c,0xc6,0x2a,0x82,0x2a,0x82,0x2a,0x82,0x48,0x82,0x08,0x86}}, // 納
{0x473D,0x945C,0xC7BD,0xE883BD,0x80FD,{0x08,0x20,0x08,0x20,0x12,0x26,0x11,0x38,0x7e,0xa0,0x00,0xa1,0x3f,0x21,0x21,0x1f,0x21,0x20,0x3f,0x20,0x21,0x26,0x3f,0x38,0x21,0x20,0x21,0x21,0x23,0x21,0x21,0x1f}}, // 能
{0x473E,0x945D,0xC7BE,0xE884B3,0x8133,{0x00,0x22,0x3d,0x12,0x24,0x92,0x24,0x94,0x24,0x84,0x3c,0x08,0x24,0x86,0x24,0xca,0x24,0xaa,0x3c,0x92,0x24,0x9a,0x24,0xaa,0x24,0xa6,0x24,0xc2,0x2c,0xfe,0x44,0x82}}, // 脳
{0x473F,0x945E,0xC7BF,0xE886BF,0x81BF,{0x00,0x50,0x3d,0xfe,0x25,0x52,0x25,0xfe,0x25,0x52,0x3d,0xfe,0x24,0x00,0x25,0xfe,0x25,0x00,0x3d,0x7e,0x25,0x00,0x25,0xff,0x25,0x52,0x25,0x4c,0x2e,0x64,0x45,0x83}}, // 膿
{0x4740,0x945F,0xC7C0,0xE8BEB2,0x8FB2,{0x02,0x20,0x1f,0xfc,0x12,0x24,0x1f,0xfc,0x12,0x24,0x1f,0xfc,0x00,0x00,0x1f,0xfe,0x10,0x00,0x17,0xfc,0x10,0x00,0x1f,0xff,0x24,0x88,0x24,0x50,0x47,0x30,0x1c,0x0f}}, // 農
{0x4741,0x9460,0xC7C1,0xE8A697,0x8997,{0x00,0x00,0x7f,0x7e,0x01,0x42,0x01,0x42,0x7f,0x7e,0x01,0x42,0x3d,0x42,0x25,0x7e,0x25,0x42,0x25,0x42,0x3d,0x7e,0x25,0x28,0x01,0x28,0x01,0x29,0x01,0x49,0x06,0x87}}, // 覗
{0x4742,0x9461,0xC7C2,0xE89AA4,0x86A4,{0x00,0x00,0x3f,0xfc,0x04,0x88,0x22,0x50,0x11,0x20,0x10,0xc0,0x01,0xa0,0x06,0x98,0x78,0x87,0x0f,0xf8,0x08,0x88,0x08,0x88,0x0f,0xf8,0x00,0x8c,0x00,0xfa,0x7f,0x01}}, // 蚤
{0x4743,0x9462,0xC7C3,0xE5B7B4,0x5DF4,{0x00,0x00,0x3f,0xf8,0x21,0x08,0x21,0x08,0x21,0x08,0x21,0x08,0x21,0x08,0x3f,0xf8,0x20,0x08,0x20,0x00,0x20,0x00,0x20,0x02,0x20,0x02,0x10,0x02,0x0f,0xfe,0x00,0x00}}, // 巴
{0x4744,0x9463,0xC7C4,0xE68A8A,0x628A,{0x10,0x00,0x11,0xfc,0x11,0x24,0x11,0x24,0x7d,0x24,0x11,0x24,0x11,0x24,0x11,0xfc,0x1d,0x04,0x71,0x00,0x11,0x00,0x11,0x02,0x11,0x02,0x10,0x82,0x10,0x7e,0x30,0x00}}, // 把
{0x4745,0x9464,0xC7C5,0xE692AD,0x64AD,{0x10,0x0c,0x11,0xf0,0x11,0x24,0x7c,0xa8,0x17,0xff,0x10,0x70,0x10,0xa8,0x11,0x24,0x1f,0xfe,0x71,0x25,0x11,0x24,0x11,0xfc,0x11,0x24,0x11,0x24,0x11,0xfc,0x31,0x04}}, // 播
{0x4746,0x9465,0xC7C6,0xE8A687,0x8987,{0x00,0x00,0x7f,0xff,0x02,0x20,0x3f,0xfe,0x22,0x22,0x3f,0xfe,0x11,0x00,0x7f,0xbe,0x11,0x22,0x1f,0x22,0x04,0x3e,0x3f,0xa2,0x24,0xbe,0x7f,0xe2,0x04,0x22,0x04,0x46}}, // 覇
{0x4747,0x9466,0xC7C7,0xE69DB7,0x6777,{0x08,0x00,0x09,0xfc,0x09,0x24,0x7f,0x24,0x09,0x24,0x09,0x24,0x1d,0x24,0x1b,0xfc,0x1b,0x04,0x29,0x00,0x29,0x00,0x49,0x02,0x09,0x02,0x08,0x82,0x08,0x7e,0x08,0x00}}, // 杷
{0x4748,0x9467,0xC7C8,0xE6B3A2,0x6CE2,{0x10,0x20,0x08,0x20,0x08,0x20,0x03,0xfe,0x42,0x22,0x22,0x24,0x22,0x20,0x03,0xfc,0x0a,0x04,0x0a,0x88,0x12,0x88,0x12,0x50,0x22,0x20,0x24,0x50,0x44,0x8c,0x4b,0x03}}, // 波
{0x4749,0x9468,0xC7C9,0xE6B4BE,0x6D3E,{0x10,0x08,0x08,0x30,0x0b,0xc0,0x02,0x04,0x42,0x18,0x22,0x60,0x22,0x44,0x02,0x44,0x0a,0x68,0x0a,0x60,0x12,0x50,0x12,0x50,0x24,0x48,0x24,0x44,0x48,0x42,0x40,0x40}}, // 派
{0x474A,0x9469,0xC7CA,0xE790B6,0x7436,{0x00,0x00,0x7f,0x7f,0x08,0x08,0x3e,0x3e,0x08,0x08,0x0f,0x7f,0x70,0x00,0x1f,0xf8,0x10,0x88,0x10,0x88,0x10,0x88,0x1f,0xf8,0x10,0x00,0x10,0x02,0x08,0x02,0x07,0xfe}}, // 琶
{0x474B,0x946A,0xC7CB,0xE7A0B4,0x7834,{0x00,0x10,0x7f,0x10,0x08,0x10,0x08,0xff,0x08,0x92,0x10,0x94,0x1e,0x90,0x32,0xfe,0x32,0xc4,0x52,0xc4,0x12,0xa4,0x12,0xa8,0x1e,0x90,0x13,0x18,0x01,0x24,0x02,0x43}}, // 破
{0x474C,0x946B,0xC7CC,0xE5A986,0x5A46,{0x00,0x20,0x19,0xfe,0x05,0x24,0x61,0xfc,0x11,0x48,0x05,0x28,0x0a,0x30,0x12,0xc8,0x65,0x06,0x01,0x00,0x7f,0xff,0x02,0x10,0x0f,0x20,0x00,0xc0,0x03,0x30,0x3c,0x08}}, // 婆
{0x474D,0x946C,0xC7CD,0xE7BDB5,0x7F75,{0x00,0x00,0x3f,0xfe,0x22,0x22,0x3f,0xfe,0x00,0x00,0x0f,0xfc,0x08,0x80,0x0f,0xf0,0x08,0x80,0x0f,0xf0,0x08,0x80,0x0f,0xfe,0x10,0x92,0x14,0x4a,0x22,0x4a,0x42,0x1c}}, // 罵
{0x474E,0x946D,0xC7CE,0xE88AAD,0x82AD,{0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x00,0x00,0x1f,0xfc,0x10,0x84,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x04,0x10,0x00,0x10,0x00,0x10,0x02,0x08,0x02,0x07,0xfe}}, // 芭
{0x474F,0x946E,0xC7CF,0xE9A6AC,0x99AC,{0x00,0x00,0x0f,0xfc,0x08,0x80,0x08,0x80,0x0f,0xf8,0x08,0x80,0x08,0x80,0x0f,0xf8,0x08,0x80,0x08,0x80,0x0f,0xfe,0x00,0x22,0x14,0x92,0x12,0x52,0x22,0x42,0x40,0x0c}}, // 馬
{0x4750,0x946F,0xC7D0,0xE4BFB3,0x4FF3,{0x04,0x90,0x04,0x90,0x04,0x90,0x0f,0x9e,0x08,0x90,0x10,0x90,0x10,0x90,0x37,0x9e,0x50,0x90,0x10,0x90,0x13,0x90,0x1c,0x9f,0x11,0x10,0x11,0x10,0x12,0x10,0x14,0x10}}, // 俳
{0x4751,0x9470,0xC7D1,0xE5BB83,0x5EC3,{0x00,0x80,0x00,0x80,0x1f,0xff,0x10,0x20,0x17,0x94,0x10,0x99,0x15,0x0a,0x12,0x04,0x17,0xfb,0x18,0x90,0x10,0x90,0x17,0xff,0x20,0x90,0x21,0x11,0x46,0x11,0x18,0x0f}}, // 廃
{0x4752,0x9471,0xC7D2,0xE68B9D,0x62DD,{0x10,0x00,0x13,0xff,0x10,0x20,0x10,0x20,0x7d,0xfe,0x10,0x20,0x10,0x20,0x11,0xfe,0x1c,0x20,0x70,0x20,0x10,0x20,0x13,0xff,0x10,0x20,0x10,0x20,0x10,0x20,0x30,0x20}}, // 拝
{0x4753,0x9472,0xC7D3,0xE68E92,0x6392,{0x10,0x48,0x10,0x48,0x10,0x48,0x13,0xcf,0x7c,0x48,0x10,0x48,0x10,0x48,0x13,0xcf,0x1c,0x48,0x70,0x48,0x11,0xc8,0x16,0x4f,0x10,0x88,0x10,0x88,0x11,0x08,0x32,0x08}}, // 排
{0x4754,0x9473,0xC7D4,0xE69597,0x6557,{0x00,0x40,0x3e,0x40,0x22,0x40,0x22,0x7f,0x3e,0x44,0x22,0x44,0x22,0xc4,0x3e,0xa4,0x23,0x28,0x22,0x28,0x22,0x10,0x3e,0x18,0x14,0x28,0x12,0x44,0x22,0x82,0x41,0x01}}, // 敗
{0x4755,0x9474,0xC7D5,0xE69DAF,0x676F,{0x08,0x00,0x09,0xff,0x08,0x10,0x7f,0x10,0x08,0x10,0x08,0x20,0x1c,0x28,0x1a,0x64,0x1a,0x64,0x28,0xa2,0x29,0x22,0x48,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20}}, // 杯
{0x4756,0x9475,0xC7D6,0xE79B83,0x76C3,{0x00,0x00,0x3f,0xfe,0x00,0x40,0x00,0x80,0x03,0xb8,0x0c,0x86,0x70,0x81,0x00,0x80,0x00,0x80,0x00,0x00,0x1f,0xfc,0x12,0x24,0x12,0x24,0x12,0x24,0x7f,0xff,0x00,0x00}}, // 盃
{0x4757,0x9476,0xC7D7,0xE7898C,0x724C,{0x12,0x10,0x12,0x20,0x12,0xfe,0x12,0x92,0x12,0x92,0x1f,0xfe,0x10,0x92,0x10,0x92,0x10,0xfe,0x1e,0x24,0x12,0x44,0x13,0xff,0x12,0x04,0x22,0x04,0x22,0x04,0x42,0x04}}, // 牌
{0x4758,0x9477,0xC7D8,0xE8838C,0x80CC,{0x02,0x40,0x02,0x46,0x7e,0x78,0x02,0x40,0x02,0x41,0x0e,0x41,0x72,0x3f,0x02,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x10,0x08,0x30}}, // 背
{0x4759,0x9478,0xC7D9,0xE882BA,0x80BA,{0x00,0x20,0x3c,0x20,0x24,0x20,0x27,0xff,0x24,0x20,0x3c,0x20,0x25,0xfe,0x25,0x22,0x25,0x22,0x3d,0x22,0x25,0x22,0x25,0x22,0x25,0x2c,0x24,0x20,0x24,0x20,0x4c,0x20}}, // 肺
{0x475A,0x9479,0xC7DA,0xE8BCA9,0x8F29,{0x02,0x20,0x7e,0x3f,0x02,0x20,0x3e,0x3e,0x02,0x20,0x7e,0x3f,0x04,0x20,0x08,0xa0,0x7f,0xff,0x08,0x88,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x00,0x80}}, // 輩
{0x475B,0x947A,0xC7DB,0xE9858D,0x914D,{0x00,0x00,0x7f,0xfe,0x0a,0x02,0x0a,0x02,0x3f,0x82,0x2a,0x82,0x2a,0xbe,0x2a,0xa2,0x33,0xa0,0x30,0xa0,0x20,0xa0,0x3f,0xa0,0x20,0xa1,0x20,0xa1,0x3f,0x91,0x20,0x8f}}, // 配
{0x475C,0x947B,0xC7DC,0xE5808D,0x500D,{0x04,0x20,0x04,0x20,0x07,0xfe,0x09,0x04,0x08,0x84,0x10,0x88,0x10,0x88,0x37,0xff,0x50,0x00,0x10,0x00,0x11,0xfc,0x11,0x04,0x11,0x04,0x11,0x04,0x11,0xfc,0x11,0x04}}, // 倍
{0x475D,0x947C,0xC7DD,0xE59FB9,0x57F9,{0x00,0x20,0x10,0x20,0x13,0xfe,0x11,0x04,0x10,0x84,0x7c,0x88,0x10,0x88,0x17,0xff,0x10,0x00,0x10,0x00,0x17,0xfc,0x19,0x04,0x61,0x04,0x01,0x04,0x01,0xfc,0x01,0x04}}, // 培
{0x475E,0x947D,0xC7DE,0xE5AA92,0x5A92,{0x08,0x44,0x08,0x44,0x09,0xff,0x08,0x44,0x7f,0x7c,0x12,0x44,0x12,0x44,0x12,0x7c,0x22,0x10,0x23,0xff,0x7c,0x38,0x06,0x34,0x0a,0x54,0x10,0x92,0x63,0x11,0x00,0x10}}, // 媒
{0x475F,0x947E,0xC7DF,0xE6A285,0x6885,{0x08,0x40,0x08,0x40,0x08,0x7f,0x7e,0x80,0x08,0x80,0x09,0xfc,0x1c,0xa4,0x1a,0xa4,0x18,0xa4,0x2b,0xff,0x29,0x24,0x49,0x24,0x0b,0xff,0x0a,0x04,0x08,0x08,0x08,0x30}}, // 梅
{0x4760,0x9480,0xC7E0,0xE6A5B3,0x6973,{0x08,0x44,0x08,0x44,0x09,0xff,0x7e,0x44,0x08,0x7c,0x08,0x44,0x1c,0x44,0x1a,0x7c,0x1a,0x10,0x29,0xff,0x28,0x38,0x48,0x34,0x08,0x54,0x08,0x92,0x09,0x11,0x08,0x10}}, // 楳
{0x4761,0x9481,0xC7E1,0xE785A4,0x7164,{0x08,0x44,0x08,0x44,0x09,0xff,0x0a,0x44,0x2a,0x7c,0x2a,0x44,0x2c,0x44,0x28,0x7c,0x48,0x10,0x09,0xff,0x0c,0x38,0x0a,0x34,0x11,0x54,0x10,0x92,0x21,0x11,0x40,0x10}}, // 煤
{0x4762,0x9482,0xC7E2,0xE78BBD,0x72FD,{0x04,0x00,0x45,0xfc,0x29,0x04,0x11,0x04,0x11,0x04,0x29,0xfc,0x49,0x04,0x09,0x04,0x19,0xfc,0x19,0x04,0x29,0x04,0x49,0x04,0x09,0xfc,0x08,0x88,0x69,0x04,0x16,0x02}}, // 狽
{0x4763,0x9483,0xC7E3,0xE8B2B7,0x8CB7,{0x00,0x00,0x3f,0xfe,0x22,0x22,0x22,0x22,0x3f,0xfe,0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x02,0x30,0x0c,0x0c,0x30,0x02}}, // 買
{0x4764,0x9484,0xC7E4,0xE5A3B2,0x58F2,{0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x00,0x3f,0xff,0x20,0x02,0x22,0x24,0x42,0x20,0x02,0x20,0x04,0x20,0x08,0x21,0x10,0x21,0x60,0x1f}}, // 売
{0x4765,0x9485,0xC7E5,0xE8B3A0,0x8CE0,{0x00,0x20,0x3e,0x20,0x23,0xfe,0x22,0x84,0x22,0x44,0x3e,0x48,0x22,0x48,0x23,0xff,0x3e,0x00,0x22,0x00,0x22,0xfc,0x3e,0x84,0x14,0x84,0x12,0x84,0x22,0xfc,0x40,0x84}}, // 賠
{0x4766,0x9486,0xC7E6,0xE999AA,0x966A,{0x00,0x20,0x3c,0x20,0x25,0xfe,0x24,0x84,0x28,0x44,0x28,0x48,0x38,0x48,0x25,0xff,0x22,0x00,0x22,0x00,0x22,0xfc,0x22,0x84,0x3c,0x84,0x20,0x84,0x20,0xfc,0x20,0x84}}, // 陪
{0x4767,0x9487,0xC7E7,0xE98099,0x9019,{0x00,0x00,0x21,0xfc,0x10,0x00,0x17,0xff,0x00,0x00,0x01,0xfc,0x00,0x00,0x79,0xfc,0x08,0x00,0x09,0xfc,0x09,0x04,0x09,0x04,0x15,0xfc,0x13,0x04,0x21,0x80,0x40,0x7f}}, // 這
{0x4768,0x9488,0xC7E8,0xE89DBF,0x877F,{0x08,0x00,0x08,0xfe,0x08,0x92,0x08,0xfe,0x3e,0x92,0x2a,0x92,0x2a,0xfe,0x2a,0x10,0x3e,0xfe,0x08,0x92,0x0c,0xfe,0x0a,0x92,0x0a,0x92,0x0f,0xfe,0x71,0x11,0x01,0x0f}}, // 蝿
{0x4769,0x9489,0xC7E9,0xE7A7A4,0x79E4,{0x02,0x00,0x0d,0xfe,0x78,0x24,0x09,0x24,0x08,0xa4,0x08,0xa8,0x7e,0xa0,0x08,0x20,0x0b,0xff,0x1c,0x20,0x1a,0x20,0x2a,0x20,0x28,0x20,0x48,0x20,0x08,0x20,0x08,0x20}}, // 秤
{0x476A,0x948A,0xC7EA,0xE79FA7,0x77E7,{0x10,0x02,0x11,0xf2,0x10,0x12,0x3f,0x12,0x28,0x12,0x48,0xf2,0x08,0x82,0x7f,0x82,0x08,0x82,0x08,0xf2,0x0c,0x12,0x12,0x12,0x12,0x12,0x21,0x12,0x40,0x22,0x00,0xc2}}, // 矧
{0x476B,0x948B,0xC7EB,0xE890A9,0x8429,{0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x02,0x00,0x0c,0x10,0x38,0x12,0x08,0x52,0x7f,0x54,0x08,0x50,0x1c,0x90,0x1a,0x28,0x2a,0x28,0x48,0x44,0x08,0x82,0x09,0x01}}, // 萩
{0x476C,0x948C,0xC7EC,0xE4BCAF,0x4F2F,{0x04,0x20,0x04,0x20,0x04,0x40,0x09,0xfc,0x09,0x04,0x11,0x04,0x11,0x04,0x31,0x04,0x51,0xfc,0x11,0x04,0x11,0x04,0x11,0x04,0x11,0x04,0x11,0x04,0x11,0xfc,0x11,0x04}}, // 伯
{0x476D,0x948D,0xC7ED,0xE589A5,0x5265,{0x00,0x02,0x3f,0x12,0x01,0x12,0x3f,0x12,0x01,0x12,0x01,0x12,0x7f,0xd2,0x04,0x12,0x44,0x92,0x27,0x12,0x26,0x12,0x0d,0x02,0x14,0x82,0x64,0x42,0x0c,0x06,0x04,0x02}}, // 剥
{0x476E,0x948E,0xC7EE,0xE58D9A,0x535A,{0x10,0x28,0x10,0x24,0x17,0xff,0x10,0x20,0x11,0xfe,0x11,0x22,0x7d,0xfe,0x11,0x22,0x11,0xfe,0x10,0x08,0x17,0xff,0x11,0x08,0x10,0x88,0x10,0x88,0x10,0x08,0x10,0x18}}, // 博
{0x476F,0x948F,0xC7EF,0xE68B8D,0x62CD,{0x08,0x10,0x08,0x10,0x08,0x20,0x08,0xfe,0x7e,0x82,0x08,0x82,0x08,0x82,0x0a,0x82,0x0c,0xfe,0x18,0x82,0x68,0x82,0x08,0x82,0x08,0x82,0x08,0x82,0x08,0xfe,0x18,0x82}}, // 拍
{0x4770,0x9490,0xC7F0,0xE69F8F,0x67CF,{0x08,0x10,0x08,0x10,0x08,0x20,0x7f,0xfe,0x08,0x82,0x08,0x82,0x1c,0x82,0x1a,0x82,0x1a,0xfe,0x28,0x82,0x28,0x82,0x48,0x82,0x08,0x82,0x08,0x82,0x08,0xfe,0x08,0x82}}, // 柏
{0x4771,0x9491,0xC7F1,0xE6B38A,0x6CCA,{0x10,0x40,0x08,0x40,0x08,0x80,0x03,0xfc,0x02,0x04,0x42,0x04,0x22,0x04,0x22,0x04,0x0b,0xfc,0x0a,0x04,0x12,0x04,0x12,0x04,0x22,0x04,0x22,0x04,0x43,0xfc,0x42,0x04}}, // 泊
{0x4772,0x9492,0xC7F2,0xE799BD,0x767D,{0x01,0x00,0x01,0x00,0x02,0x00,0x1f,0xf8,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x08}}, // 白
{0x4773,0x9493,0xC7F3,0xE7AE94,0x7B94,{0x10,0x40,0x10,0x40,0x1f,0x7e,0x28,0x90,0x25,0x28,0x40,0x20,0x30,0x40,0x09,0xfc,0x01,0x04,0x61,0x04,0x11,0x04,0x01,0xfc,0x09,0x04,0x11,0x04,0x21,0xfc,0x41,0x04}}, // 箔
{0x4774,0x9494,0xC7F4,0xE7B295,0x7C95,{0x08,0x10,0x4a,0x10,0x2a,0x20,0x2c,0xfe,0x28,0x82,0x08,0x82,0x7f,0x82,0x08,0x82,0x1c,0xfe,0x1a,0x82,0x2a,0x82,0x28,0x82,0x48,0x82,0x08,0x82,0x08,0xfe,0x08,0x82}}, // 粕
{0x4775,0x9495,0xC7F5,0xE888B6,0x8236,{0x04,0x10,0x08,0x10,0x1f,0x20,0x11,0x7e,0x19,0x42,0x15,0x42,0x15,0x42,0x13,0xc2,0x1d,0x7e,0x71,0x42,0x19,0x42,0x15,0x42,0x15,0x42,0x21,0x42,0x21,0x7e,0x43,0x42}}, // 舶
{0x4776,0x9496,0xC7F6,0xE89684,0x8584,{0x04,0x20,0x7f,0xff,0x04,0x28,0x10,0x24,0x0b,0xff,0x08,0x20,0x41,0xfc,0x21,0x24,0x21,0xfc,0x01,0x24,0x11,0xfc,0x10,0x08,0x27,0xff,0x21,0x08,0x40,0x88,0x40,0x18}}, // 薄
{0x4777,0x9497,0xC7F7,0xE8BFAB,0x8FEB,{0x00,0x20,0x20,0x20,0x10,0x40,0x11,0xfc,0x01,0x04,0x01,0x04,0x01,0x04,0x79,0xfc,0x09,0x04,0x09,0x04,0x09,0x04,0x09,0xfc,0x0d,0x04,0x14,0x00,0x23,0x00,0x40,0xff}}, // 迫
{0x4778,0x9498,0xC7F8,0xE69B9D,0x66DD,{0x00,0xfc,0x3c,0x84,0x24,0xfc,0x24,0x84,0x24,0xfc,0x24,0x48,0x3d,0xfe,0x24,0x48,0x27,0xff,0x24,0x48,0x24,0xa4,0x25,0xab,0x3e,0x70,0x24,0xa8,0x01,0x26,0x00,0x60}}, // 曝
{0x4779,0x9499,0xC7F9,0xE6BCA0,0x6F20,{0x10,0x88,0x08,0x88,0x0f,0xff,0x00,0x88,0x40,0x88,0x21,0xfc,0x21,0x04,0x01,0xfc,0x09,0x04,0x09,0xfc,0x10,0x20,0x17,0xff,0x20,0x20,0x20,0x50,0x41,0x8c,0x46,0x03}}, // 漠
{0x477A,0x949A,0xC7FA,0xE78886,0x7206,{0x08,0xfc,0x08,0x84,0x08,0xfc,0x0a,0x84,0x2a,0xfc,0x2a,0x48,0x2d,0xfe,0x28,0x48,0x4b,0xff,0x08,0x48,0x14,0xa4,0x13,0xab,0x12,0x70,0x20,0xa8,0x23,0x26,0x40,0x60}}, // 爆
{0x477B,0x949B,0xC7FB,0xE7B89B,0x7E1B,{0x08,0x14,0x08,0x12,0x0b,0xff,0x72,0x10,0x14,0xfe,0x08,0x92,0x0c,0xfe,0x12,0x92,0x7d,0xfe,0x09,0x04,0x2c,0xff,0x2a,0x44,0x2a,0x24,0x2a,0x24,0x48,0x04,0x08,0x0c}}, // 縛
{0x477C,0x949C,0xC7FC,0xE88EAB,0x83AB,{0x02,0x20,0x02,0x20,0x7f,0xff,0x02,0x20,0x02,0x20,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x01,0x40,0x02,0x20,0x0c,0x18,0x70,0x07}}, // 莫
{0x477D,0x949D,0xC7FD,0xE9A781,0x99C1,{0x00,0x04,0x3f,0xc4,0x24,0x24,0x24,0x18,0x3f,0x08,0x24,0x14,0x3f,0x22,0x24,0x40,0x24,0x02,0x3f,0xa2,0x04,0x94,0x12,0x8c,0x2a,0x88,0x28,0x94,0x41,0x22,0x06,0xc1}}, // 駁
{0x477E,0x949E,0xC7FE,0xE9BAA6,0x9EA6,{0x00,0x80,0x00,0x80,0x3f,0xfe,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x01,0x00,0x01,0xf0,0x02,0x10,0x0e,0x20,0x31,0x40,0x01,0xc0,0x02,0x20,0x0c,0x18,0x70,0x07}}, // 麦
{0x4821,0x949F,0xC8A1,0xE587BD,0x51FD,{0x00,0x00,0x7f,0xff,0x02,0x00,0x02,0x00,0x23,0x8a,0x28,0x8a,0x24,0xd2,0x22,0xc2,0x20,0xa2,0x21,0xa2,0x26,0x92,0x38,0x8a,0x23,0x02,0x20,0x02,0x3f,0xfe,0x20,0x02}}, // 函
{0x4822,0x94A0,0xC8A2,0xE7AEB1,0x7BB1,{0x08,0x20,0x08,0x20,0x1f,0x7f,0x14,0x48,0x22,0x84,0x44,0x00,0x04,0x7e,0x7f,0x42,0x0c,0x42,0x0e,0x7e,0x15,0x42,0x24,0xfe,0x24,0x42,0x44,0x42,0x04,0x7e,0x04,0x42}}, // 箱
{0x4823,0x94A1,0xC8A3,0xE7A1B2,0x7872,{0x00,0x44,0x7f,0x44,0x04,0x42,0x04,0x52,0x08,0x92,0x09,0x28,0x1e,0x28,0x12,0x44,0x32,0x82,0x53,0x7d,0x12,0x44,0x12,0x44,0x1e,0x44,0x12,0x44,0x10,0x7c,0x00,0x44}}, // 硲
{0x4824,0x94A2,0xC8A4,0xE7AEB8,0x7BB8,{0x08,0x20,0x08,0x20,0x1f,0x7f,0x14,0x50,0x22,0x88,0x5f,0xfc,0x00,0x88,0x00,0x90,0x7f,0xff,0x00,0x80,0x07,0xf8,0x1c,0x08,0x67,0xf8,0x04,0x08,0x07,0xf8,0x04,0x08}}, // 箸
{0x4825,0x94A3,0xC8A5,0xE88287,0x8087,{0x00,0x10,0x3f,0xdf,0x0f,0x24,0x09,0x54,0x0f,0x08,0x10,0x96,0x2f,0xf8,0x00,0x88,0x3f,0xff,0x00,0x88,0x0f,0xf8,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x80}}, // 肇
{0x4826,0x94A4,0xC8A6,0xE7AD88,0x7B48,{0x08,0x20,0x08,0x20,0x0f,0x7f,0x14,0x50,0x22,0x88,0x40,0x34,0x0f,0xc0,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 筈
{0x4827,0x94A5,0xC8A7,0xE6ABA8,0x6AE8,{0x10,0x20,0x10,0x3c,0x10,0x20,0x13,0xfe,0x7e,0x44,0x13,0xf8,0x12,0x42,0x3a,0xfe,0x36,0xa4,0x32,0xfc,0x52,0xa4,0x54,0xfc,0x15,0xfe,0x19,0x52,0x17,0xff,0x10,0x00}}, // 櫨
{0x4828,0x94A6,0xC8A8,0xE5B9A1,0x5E61,{0x10,0x04,0x10,0x18,0x11,0xe4,0x7d,0x24,0x54,0xa8,0x57,0xff,0x54,0x70,0x54,0xa8,0x55,0x24,0x57,0xfe,0x5d,0x25,0x51,0xfc,0x11,0x24,0x11,0x24,0x11,0xfc,0x11,0x04}}, // 幡
{0x4829,0x94A7,0xC8A9,0xE8828C,0x808C,{0x00,0x00,0x3e,0x78,0x22,0x48,0x22,0x48,0x22,0x48,0x3e,0x48,0x22,0x48,0x22,0x48,0x22,0x48,0x3e,0x48,0x22,0x48,0x22,0x48,0x22,0x88,0x22,0x89,0x27,0x09,0x42,0x07}}, // 肌
{0x482A,0x94A8,0xC8AA,0xE79591,0x7551,{0x08,0x00,0x08,0xfe,0x08,0x92,0x0a,0x92,0x0a,0x92,0x2a,0x92,0x2c,0x92,0x28,0xfe,0x28,0x92,0x48,0x92,0x0c,0x92,0x0a,0x92,0x11,0x92,0x10,0x92,0x20,0xfe,0x40,0x82}}, // 畑
{0x482B,0x94A9,0xC8AB,0xE795A0,0x7560,{0x00,0x80,0x01,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x00,0x00,0x3f,0xfc,0x20,0x84,0x3f,0xfc,0x20,0x84,0x20,0x84,0x3f,0xfc,0x20,0x04}}, // 畠
{0x482C,0x94AA,0xC8AC,0xE585AB,0x516B,{0x00,0x00,0x03,0xe0,0x00,0x20,0x00,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x10,0x04,0x10,0x04,0x10,0x08,0x08,0x08,0x08,0x10,0x04,0x20,0x02,0x40,0x01}}, // 八
{0x482D,0x94AB,0xC8AD,0xE989A2,0x9262,{0x08,0x10,0x08,0x10,0x14,0x10,0x12,0x10,0x21,0xff,0x7e,0x38,0x08,0x38,0x08,0x54,0x7f,0x54,0x08,0x92,0x4a,0x91,0x2d,0x7c,0x28,0x10,0x0e,0x10,0x18,0x10,0x60,0x10}}, // 鉢
{0x482E,0x94AC,0xC8AE,0xE6BA8C,0x6E8C,{0x11,0xd0,0x08,0x54,0x0a,0x59,0x01,0x8a,0x40,0x84,0x21,0x02,0x23,0xfd,0x04,0x90,0x00,0x90,0x08,0x90,0x17,0xff,0x10,0x90,0x20,0x90,0x21,0x11,0x42,0x11,0x44,0x0f}}, // 溌
{0x482F,0x94AD,0xC8AF,0xE799BA,0x767A,{0x0f,0x24,0x01,0x24,0x01,0x18,0x12,0x11,0x0a,0x09,0x04,0x0a,0x0f,0xfc,0x12,0x22,0x62,0x21,0x02,0x20,0x7f,0xff,0x02,0x20,0x02,0x20,0x04,0x21,0x18,0x21,0x60,0x1f}}, // 発
{0x4830,0x94AE,0xC8B0,0xE98697,0x9197,{0x00,0xe8,0x7f,0x2a,0x0c,0xac,0x0c,0x65,0x3f,0x46,0x2d,0x42,0x2d,0xfd,0x35,0x28,0x37,0x28,0x31,0x28,0x21,0xff,0x3f,0x28,0x21,0x28,0x21,0x49,0x3f,0x49,0x21,0x87}}, // 醗
{0x4831,0x94AF,0xC8B1,0xE9ABAA,0x9AEA,{0x00,0x04,0x1f,0x98,0x10,0x60,0x1f,0x02,0x10,0x0c,0x7f,0x71,0x12,0x02,0x1d,0x0c,0x21,0x70,0x7f,0xff,0x01,0x00,0x03,0xf0,0x0e,0x20,0x71,0xc0,0x03,0x60,0x3c,0x1e}}, // 髪
{0x4832,0x94B0,0xC8B2,0xE4BC90,0x4F10,{0x04,0x88,0x04,0x84,0x04,0x84,0x08,0x80,0x0f,0xff,0x10,0x84,0x10,0x84,0x30,0x48,0x50,0x48,0x10,0x50,0x10,0x20,0x10,0x50,0x11,0x92,0x16,0x0a,0x10,0x06,0x10,0x02}}, // 伐
{0x4833,0x94B1,0xC8B3,0xE7BDB0,0x7F70,{0x00,0x00,0x3f,0xfc,0x22,0x44,0x22,0x44,0x3f,0xfc,0x00,0x02,0x3f,0x22,0x00,0x22,0x7f,0xa2,0x00,0x22,0x3f,0x22,0x00,0x22,0x3f,0x02,0x21,0x02,0x3f,0x06,0x21,0x02}}, // 罰
{0x4834,0x94B2,0xC8B4,0xE68A9C,0x629C,{0x10,0x40,0x10,0x40,0x10,0x40,0x13,0xff,0x7c,0x40,0x10,0x40,0x10,0xfc,0x10,0x84,0x1c,0xc4,0x70,0xa8,0x11,0x28,0x11,0x10,0x12,0x30,0x14,0x48,0x30,0x84,0x13,0x02}}, // 抜
{0x4835,0x94B3,0xC8B5,0xE7AD8F,0x7B4F,{0x08,0x10,0x08,0x10,0x1f,0xbf,0x14,0x28,0x22,0x44,0x44,0x48,0x04,0x44,0x08,0x44,0x13,0xff,0x30,0x20,0x50,0x22,0x10,0x14,0x10,0x18,0x10,0x69,0x13,0x85,0x10,0x03}}, // 筏
{0x4836,0x94B4,0xC8B6,0xE996A5,0x95A5,{0x00,0x00,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x42,0x22,0x42,0x52,0x47,0xfa,0x48,0x42,0x58,0x52,0x68,0x62,0x48,0xaa,0x4b,0x1a,0x48,0x0e,0x40,0x02}}, // 閥
{0x4837,0x94B5,0xC8B7,0xE9B3A9,0x9CE9,{0x10,0x20,0x10,0x40,0x10,0xfc,0x7c,0x84,0x14,0xfc,0x14,0x84,0x14,0xfc,0x14,0x80,0x14,0xff,0x15,0x80,0x15,0xfe,0x23,0x0a,0x20,0xa6,0x41,0x52,0x01,0x52,0x02,0x0c}}, // 鳩
{0x4838,0x94B6,0xC8B8,0xE599BA,0x567A,{0x01,0x02,0x01,0x1c,0x77,0xf0,0x54,0x50,0x52,0x50,0x52,0x9f,0x5f,0xf2,0x51,0x12,0x51,0x12,0x57,0xf2,0x51,0x92,0x73,0x52,0x55,0x22,0x09,0x22,0x01,0x42,0x01,0x02}}, // 噺
{0x4839,0x94B7,0xC8B9,0xE5A199,0x5859,{0x10,0x20,0x10,0x20,0x13,0xff,0x10,0x00,0x7c,0xf8,0x10,0x88,0x10,0xf8,0x10,0x00,0x13,0xfe,0x12,0x02,0x1e,0xfa,0x72,0x8a,0x02,0xfa,0x02,0x8a,0x02,0x06,0x02,0x02}}, // 塙
{0x483A,0x94B8,0xC8BA,0xE89BA4,0x86E4,{0x08,0x10,0x08,0x10,0x08,0x28,0x3f,0x28,0x29,0x24,0x29,0x42,0x29,0x7d,0x29,0x80,0x3f,0x00,0x08,0x7c,0x0c,0x44,0x0a,0x44,0x0a,0x44,0x0f,0x44,0x71,0x7c,0x00,0x44}}, // 蛤
{0x483B,0x94B9,0xC8BB,0xE99ABC,0x96BC,{0x04,0x20,0x04,0x20,0x08,0x40,0x0f,0xfc,0x18,0x40,0x2f,0xf8,0x48,0x40,0x0f,0xf8,0x08,0x40,0x0f,0xfc,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80}}, // 隼
{0x483C,0x94BA,0xC8BC,0xE4BCB4,0x4F34,{0x04,0x20,0x04,0x24,0x05,0x24,0x08,0xa4,0x08,0xa8,0x18,0x20,0x1b,0xfe,0x28,0x20,0x48,0x20,0x08,0x20,0x0f,0xff,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20}}, // 伴
{0x483D,0x94BB,0xC8BD,0xE588A4,0x5224,{0x04,0x02,0x04,0x92,0x24,0x92,0x14,0x92,0x15,0x12,0x04,0x12,0x7f,0xd2,0x04,0x12,0x04,0x12,0x04,0x12,0x7f,0xd2,0x04,0x12,0x04,0x02,0x04,0x02,0x04,0x06,0x04,0x02}}, // 判
{0x483E,0x94BC,0xC8BE,0xE58D8A,0x534A,{0x00,0x80,0x00,0x84,0x10,0x84,0x08,0x88,0x04,0x90,0x04,0x80,0x3f,0xfe,0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 半
{0x483F,0x94BD,0xC8BF,0xE58F8D,0x53CD,{0x00,0x00,0x1f,0xfe,0x10,0x00,0x10,0x00,0x10,0x00,0x1f,0xf8,0x12,0x08,0x12,0x08,0x11,0x10,0x11,0x10,0x10,0xa0,0x10,0x40,0x10,0xa0,0x21,0x10,0x26,0x0c,0x58,0x03}}, // 反
{0x4840,0x94BE,0xC8C0,0xE58F9B,0x53DB,{0x08,0x00,0x0a,0xff,0x4a,0x80,0x2a,0x80,0x2c,0x80,0x08,0xfc,0x7f,0xa4,0x08,0xa4,0x08,0xa4,0x0e,0x94,0x78,0x98,0x08,0x88,0x11,0x14,0x11,0x24,0x22,0x42,0x45,0x81}}, // 叛
{0x4841,0x94BF,0xC8C1,0xE5B886,0x5E06,{0x10,0x00,0x10,0x7c,0x10,0x44,0x7e,0x44,0x52,0x44,0x52,0x64,0x52,0x54,0x52,0x54,0x52,0x54,0x52,0x44,0x56,0x44,0x50,0x44,0x10,0x84,0x10,0x85,0x11,0x05,0x12,0x03}}, // 帆
{0x4842,0x94C0,0xC8C2,0xE690AC,0x642C,{0x10,0x80,0x11,0x1c,0x13,0xd4,0x12,0x55,0x7b,0x55,0x12,0xe3,0x12,0x40,0x17,0xfe,0x1a,0x52,0x73,0x52,0x12,0xca,0x12,0xcc,0x12,0x44,0x14,0x4c,0x14,0x52,0x38,0xe1}}, // 搬
{0x4843,0x94C1,0xC8C3,0xE69691,0x6591,{0x01,0x00,0x7d,0x3f,0x11,0x08,0x17,0xe8,0x10,0x48,0x12,0x48,0x7d,0x48,0x11,0x7e,0x11,0x88,0x10,0x88,0x10,0x88,0x15,0x48,0x1a,0x48,0x64,0x08,0x08,0x7f,0x00,0x00}}, // 斑
{0x4844,0x94C2,0xC8C4,0xE69DBF,0x677F,{0x08,0x00,0x08,0xff,0x08,0x80,0x7f,0x80,0x08,0x80,0x08,0xfe,0x0c,0xa2,0x1a,0xa2,0x1a,0xa4,0x18,0x94,0x28,0x98,0x28,0x88,0x48,0x94,0x09,0x24,0x09,0x42,0x0a,0x81}}, // 板
{0x4845,0x94C3,0xC8C5,0xE6B0BE,0x6C3E,{0x10,0x00,0x09,0xfc,0x09,0x04,0x01,0x04,0x41,0x04,0x21,0x04,0x21,0x04,0x01,0x04,0x05,0x18,0x05,0x00,0x09,0x00,0x09,0x00,0x11,0x01,0x10,0x81,0x20,0x7f,0x20,0x00}}, // 氾
{0x4846,0x94C4,0xC8C6,0xE6B18E,0x6C4E,{0x10,0x00,0x09,0xf8,0x09,0x08,0x01,0x08,0x41,0x08,0x21,0x88,0x21,0x48,0x05,0x48,0x05,0x28,0x09,0x28,0x09,0x08,0x11,0x08,0x12,0x08,0x22,0x09,0x24,0x09,0x28,0x07}}, // 汎
{0x4847,0x94C5,0xC8C7,0xE78988,0x7248,{0x12,0x00,0x12,0x7f,0x12,0x40,0x12,0x40,0x12,0x40,0x1f,0xfe,0x10,0x62,0x10,0x62,0x1e,0x52,0x12,0x54,0x12,0x54,0x12,0x48,0x12,0x4c,0x22,0x94,0x22,0xa2,0x43,0x41}}, // 版
{0x4848,0x94C6,0xC8C8,0xE78AAF,0x72AF,{0x04,0x00,0x44,0xfc,0x28,0x84,0x10,0x84,0x10,0x84,0x28,0x84,0x48,0x84,0x0c,0x84,0x14,0x98,0x14,0x80,0x24,0x80,0x44,0x80,0x04,0x81,0x04,0x81,0x34,0x7f,0x08,0x00}}, // 犯
{0x4849,0x94C7,0xC8C9,0xE78FAD,0x73ED,{0x00,0x40,0x7c,0x7f,0x12,0x48,0x12,0x48,0x12,0x48,0x12,0x48,0x7e,0x48,0x12,0x7e,0x12,0x48,0x12,0x48,0x10,0x48,0x14,0x48,0x18,0x88,0x10,0x88,0x61,0x3f,0x02,0x00}}, // 班
{0x484A,0x94C8,0xC8CA,0xE79594,0x7554,{0x00,0x20,0x7c,0x22,0x55,0x22,0x54,0xa4,0x54,0xa8,0x54,0x20,0x57,0xfe,0x7c,0x20,0x54,0x20,0x54,0x20,0x57,0xff,0x54,0x20,0x7c,0x20,0x44,0x20,0x00,0x20,0x00,0x20}}, // 畔
{0x484B,0x94C9,0xC8CB,0xE7B981,0x7E41,{0x10,0x20,0x1f,0xa0,0x10,0x3f,0x3f,0x24,0x55,0x64,0x1f,0x98,0x25,0x08,0x3f,0x94,0x20,0xe3,0x03,0x20,0x0e,0x50,0x01,0x8c,0x7f,0xfa,0x04,0xb0,0x18,0x8c,0x60,0x82}}, // 繁
{0x484C,0x94CA,0xC8CC,0xE888AC,0x822C,{0x04,0x00,0x08,0x78,0x1f,0x48,0x11,0x48,0x19,0x4a,0x15,0x4a,0x15,0x86,0x7f,0xfc,0x11,0x44,0x19,0x44,0x15,0x28,0x15,0x28,0x15,0x10,0x21,0x28,0x23,0x44,0x41,0x83}}, // 般
{0x484D,0x94CB,0xC8CD,0xE897A9,0x85E9,{0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x0c,0x13,0xf0,0x09,0x24,0x08,0xa8,0x47,0xff,0x20,0x68,0x20,0xa4,0x01,0xfe,0x0b,0x25,0x09,0xfc,0x11,0x24,0x21,0xfc,0x41,0x04}}, // 藩
{0x484E,0x94CC,0xC8CE,0xE8B2A9,0x8CA9,{0x00,0x00,0x3e,0x7f,0x22,0x40,0x22,0x40,0x3e,0x40,0x22,0x7e,0x22,0x62,0x22,0x62,0x3e,0x52,0x22,0x54,0x22,0x4c,0x3e,0x48,0x14,0x94,0x12,0x94,0x21,0x22,0x41,0x41}}, // 販
{0x484F,0x94CD,0xC8CF,0xE7AF84,0x7BC4,{0x08,0x20,0x08,0x20,0x1f,0xff,0x14,0x50,0x22,0x88,0x44,0x00,0x3f,0xbe,0x04,0x22,0x1f,0xa2,0x14,0xa2,0x1f,0xa2,0x14,0xac,0x1f,0xa0,0x04,0x21,0x3f,0xa1,0x04,0x1f}}, // 範
{0x4850,0x94CE,0xC8D0,0xE98786,0x91C6,{0x00,0x04,0x00,0x78,0x3f,0x88,0x08,0x88,0x04,0x90,0x04,0xa0,0x00,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80,0x00,0x80,0x00,0x80}}, // 釆
{0x4851,0x94CF,0xC8D1,0xE785A9,0x7169,{0x08,0x00,0x09,0xff,0x08,0x10,0x0a,0x20,0x2a,0xfe,0x2a,0x82,0x2c,0x82,0x48,0xfe,0x08,0x82,0x0c,0xfe,0x14,0x82,0x12,0x82,0x12,0xfe,0x20,0x24,0x20,0xc2,0x43,0x01}}, // 煩
{0x4852,0x94D0,0xC8D2,0xE9A092,0x9812,{0x00,0x00,0x0e,0xff,0x02,0x10,0x12,0x20,0x11,0x7e,0x11,0x42,0x20,0xc2,0x3f,0x7e,0x49,0x42,0x09,0x7e,0x09,0x42,0x11,0x42,0x11,0x7e,0x21,0x24,0x46,0x42,0x01,0x81}}, // 頒
{0x4853,0x94D1,0xC8D3,0xE9A3AF,0x98EF,{0x08,0x00,0x08,0x7f,0x14,0x40,0x12,0x40,0x29,0x40,0x7e,0x7e,0x22,0x42,0x3e,0x52,0x22,0x52,0x22,0x52,0x3e,0x54,0x28,0x4c,0x24,0x48,0x26,0x94,0x3a,0xa2,0x61,0x41}}, // 飯
{0x4854,0x94D2,0xC8D4,0xE68CBD,0x633D,{0x10,0x40,0x10,0x78,0x10,0x88,0x7d,0x10,0x12,0x20,0x15,0xfc,0x11,0x24,0x11,0x24,0x1d,0x24,0x71,0xfc,0x11,0x54,0x10,0x50,0x10,0x90,0x11,0x11,0x12,0x11,0x34,0x0f}}, // 挽
{0x4855,0x94D3,0xC8D5,0xE699A9,0x6669,{0x00,0x40,0x7c,0x78,0x44,0x88,0x45,0x10,0x46,0x20,0x45,0xfc,0x7d,0x24,0x45,0x24,0x45,0x24,0x45,0xfc,0x45,0x54,0x7c,0x50,0x44,0x90,0x01,0x11,0x02,0x11,0x04,0x0f}}, // 晩
{0x4856,0x94D4,0xC8D6,0xE795AA,0x756A,{0x00,0x08,0x00,0x70,0x1f,0x84,0x08,0x88,0x04,0x90,0x7f,0xff,0x02,0xa0,0x04,0x90,0x18,0x8c,0x6f,0xfb,0x08,0x88,0x0f,0xf8,0x08,0x88,0x08,0x88,0x0f,0xf8,0x08,0x08}}, // 番
{0x4857,0x94D5,0xC8D7,0xE79BA4,0x76E4,{0x04,0x00,0x1f,0x3c,0x19,0x25,0x15,0x23,0x17,0x40,0x79,0xfe,0x15,0x14,0x15,0x08,0x11,0x14,0x23,0x63,0x40,0x00,0x1f,0xfc,0x12,0x24,0x12,0x24,0x7f,0xff,0x00,0x00}}, // 盤
{0x4858,0x94D6,0xC8D8,0xE7A390,0x78D0,{0x04,0x00,0x1f,0x3c,0x11,0x25,0x15,0x47,0x7f,0x80,0x11,0x7c,0x15,0x24,0x15,0x18,0x23,0x24,0x40,0x43,0x7f,0xff,0x02,0x00,0x07,0xf8,0x1c,0x08,0x67,0xf8,0x04,0x08}}, // 磐
{0x4859,0x94D7,0xC8D9,0xE89583,0x8543,{0x02,0x10,0x7f,0xff,0x02,0x10,0x00,0x08,0x1f,0xf0,0x08,0x88,0x04,0x90,0x7f,0xff,0x02,0xa0,0x04,0x90,0x1f,0xfc,0x68,0x8b,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x08,0x08}}, // 蕃
{0x485A,0x94D8,0xC8DA,0xE89BAE,0x86EE,{0x00,0x80,0x00,0x80,0x7f,0xff,0x02,0x20,0x12,0x28,0x12,0x24,0x24,0xa2,0x48,0x82,0x1f,0xf8,0x10,0x88,0x10,0x88,0x1f,0xf8,0x00,0x88,0x00,0x84,0x01,0xfe,0x7e,0x02}}, // 蛮
{0x485B,0x94D9,0xC8DB,0xE58CAA,0x532A,{0x00,0x00,0x3f,0xfe,0x21,0x20,0x21,0x20,0x2f,0x3c,0x21,0x20,0x21,0x20,0x2f,0x3c,0x21,0x20,0x23,0xa0,0x2d,0x3e,0x22,0x20,0x22,0x20,0x24,0x00,0x3f,0xfe,0x20,0x00}}, // 匪
{0x485C,0x94DA,0xC8DC,0xE58D91,0x5351,{0x00,0x80,0x01,0x00,0x0f,0xfc,0x08,0x84,0x08,0x84,0x0f,0xfc,0x08,0x84,0x08,0x84,0x0f,0xfc,0x02,0x40,0x04,0x40,0x7f,0xff,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40}}, // 卑
{0x485D,0x94DB,0xC8DD,0xE590A6,0x5426,{0x00,0x00,0x7f,0xff,0x00,0x40,0x00,0xe0,0x01,0x98,0x06,0x84,0x18,0x82,0x60,0x81,0x00,0x80,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 否
{0x485E,0x94DC,0xC8DE,0xE5A683,0x5983,{0x08,0x00,0x08,0xfc,0x08,0x04,0x08,0x04,0x7e,0x04,0x12,0x04,0x12,0xfc,0x12,0x84,0x22,0x80,0x24,0x80,0x7c,0x80,0x46,0x80,0x0a,0x82,0x10,0x42,0x60,0x3e,0x00,0x00}}, // 妃
{0x485F,0x94DD,0xC8DF,0xE5BA87,0x5E87,{0x00,0x40,0x00,0x40,0x1f,0xff,0x10,0x00,0x12,0x20,0x12,0x20,0x12,0x22,0x12,0x24,0x13,0xb8,0x12,0x20,0x12,0x20,0x12,0x20,0x22,0x22,0x22,0x62,0x43,0xa2,0x0e,0x1e}}, // 庇
{0x4860,0x94DE,0xC8E0,0xE5BDBC,0x5F7C,{0x08,0x20,0x08,0x20,0x10,0x20,0x11,0xff,0x25,0x22,0x45,0x24,0x09,0x20,0x09,0xfc,0x11,0x44,0x31,0x44,0x51,0x48,0x11,0x28,0x12,0x10,0x12,0x28,0x14,0xc4,0x13,0x03}}, // 彼
{0x4861,0x94DF,0xC8E1,0xE682B2,0x60B2,{0x02,0x20,0x02,0x20,0x7e,0x3f,0x02,0x20,0x3e,0x3e,0x02,0x20,0x0e,0x20,0x72,0x3f,0x02,0x20,0x04,0x20,0x08,0x80,0x12,0x48,0x12,0x44,0x22,0x0a,0x41,0x0a,0x00,0xf8}}, // 悲
{0x4862,0x94E0,0xC8E2,0xE68989,0x6249,{0x00,0x00,0x3f,0xff,0x00,0x00,0x1f,0xfe,0x10,0x02,0x1f,0xfe,0x10,0x90,0x10,0x90,0x17,0x9e,0x10,0x90,0x17,0x9e,0x10,0x90,0x23,0x90,0x2d,0x1f,0x41,0x10,0x02,0x10}}, // 扉
{0x4863,0x94E1,0xC8E3,0xE689B9,0x6279,{0x12,0x20,0x12,0x20,0x12,0x20,0x12,0x20,0x7e,0x24,0x12,0x24,0x13,0xe8,0x12,0x30,0x1e,0x20,0x72,0x20,0x12,0x20,0x12,0x20,0x12,0x21,0x12,0xe1,0x33,0x1f,0x1c,0x00}}, // 批
{0x4864,0x94E2,0xC8E4,0xE68AAB,0x62AB,{0x10,0x10,0x10,0x10,0x10,0x10,0x11,0xff,0x7d,0x11,0x11,0x12,0x11,0x10,0x11,0xfc,0x1d,0x44,0x71,0x44,0x11,0x28,0x12,0x28,0x12,0x10,0x14,0x28,0x38,0xc4,0x13,0x03}}, // 披
{0x4865,0x94E3,0xC8E5,0xE69690,0x6590,{0x02,0x20,0x02,0x20,0x7e,0x3f,0x02,0x20,0x3e,0x3e,0x02,0x20,0x7c,0x3f,0x04,0xa0,0x08,0x80,0x7f,0xff,0x02,0x20,0x02,0x20,0x01,0x40,0x01,0xc0,0x06,0x30,0x38,0x0e}}, // 斐
{0x4866,0x94E4,0xC8E6,0xE6AF94,0x6BD4,{0x10,0x40,0x10,0x40,0x10,0x40,0x10,0x44,0x10,0x44,0x10,0x48,0x1f,0x50,0x10,0x60,0x10,0x40,0x10,0x40,0x10,0x40,0x10,0x40,0x11,0x40,0x16,0x41,0x18,0x21,0x60,0x1f}}, // 比
{0x4867,0x94E5,0xC8E7,0xE6B38C,0x6CCC,{0x10,0x80,0x08,0x40,0x08,0x20,0x00,0xa4,0x40,0x84,0x20,0x84,0x20,0x88,0x02,0x8c,0x0a,0x92,0x0a,0x91,0x14,0xa1,0x14,0xc0,0x28,0x82,0x21,0x42,0x42,0x3e,0x4c,0x00}}, // 泌
{0x4868,0x94E6,0xC8E8,0xE796B2,0x75B2,{0x00,0x40,0x00,0x40,0x0f,0xff,0x48,0x20,0x28,0x20,0x2b,0xfe,0x0a,0x22,0x0a,0x24,0x1b,0xf8,0x2a,0x88,0x4a,0x88,0x12,0x50,0x14,0x20,0x24,0x50,0x49,0x8c,0x16,0x03}}, // 疲
{0x4869,0x94E7,0xC8E9,0xE79AAE,0x76AE,{0x00,0x80,0x00,0x80,0x00,0x80,0x1f,0xfe,0x10,0x82,0x10,0x84,0x10,0x80,0x1f,0xf8,0x12,0x10,0x12,0x10,0x11,0x20,0x10,0xc0,0x20,0xc0,0x21,0x20,0x46,0x18,0x18,0x06}}, // 皮
{0x486A,0x94E8,0xC8EA,0xE7A291,0x7891,{0x00,0x10,0x3f,0x20,0x08,0xfe,0x08,0x92,0x08,0x92,0x08,0xfe,0x1e,0x92,0x12,0x92,0x32,0xfe,0x52,0x28,0x12,0x48,0x13,0xff,0x1e,0x08,0x12,0x08,0x00,0x08,0x00,0x08}}, // 碑
{0x486B,0x94E9,0xC8EB,0xE7A798,0x79D8,{0x01,0x20,0x06,0x10,0x38,0x10,0x08,0x54,0x08,0x44,0x7f,0x44,0x08,0x48,0x09,0x4a,0x1d,0x51,0x1b,0x51,0x29,0x61,0x2a,0xc0,0x49,0x42,0x0a,0x22,0x0c,0x1e,0x08,0x00}}, // 秘
{0x486C,0x94EA,0xC8EC,0xE7B78B,0x7DCB,{0x08,0x28,0x08,0x28,0x0a,0x28,0x72,0xee,0x14,0x28,0x08,0x28,0x0c,0x28,0x12,0xee,0x7d,0x28,0x08,0x28,0x2c,0x68,0x2b,0xaf,0x2a,0x48,0x2a,0x48,0x48,0x88,0x09,0x08}}, // 緋
{0x486D,0x94EB,0xC8ED,0xE7BDB7,0x7F77,{0x00,0x00,0x3f,0xfe,0x22,0x22,0x3f,0xfe,0x0c,0x20,0x13,0x26,0x7e,0xb8,0x00,0x20,0x3f,0x21,0x21,0x1f,0x3f,0x00,0x21,0x26,0x3f,0x38,0x21,0x20,0x21,0x21,0x23,0x1f}}, // 罷
{0x486E,0x94EC,0xC8EE,0xE882A5,0x80A5,{0x00,0x00,0x3e,0xfc,0x22,0xa4,0x22,0xa4,0x22,0xa4,0x3e,0xa4,0x22,0xa4,0x22,0xfc,0x22,0x84,0x3e,0x80,0x22,0x80,0x22,0x80,0x22,0x82,0x22,0x82,0x22,0x7e,0x46,0x00}}, // 肥
{0x486F,0x94ED,0xC8EF,0xE8A2AB,0x88AB,{0x08,0x10,0x08,0x10,0x08,0x10,0x7e,0xfe,0x02,0x92,0x04,0x94,0x05,0x90,0x0a,0xfc,0x1c,0xc4,0x2a,0xa4,0x49,0xa8,0x08,0x98,0x09,0x18,0x09,0x24,0x0a,0x42,0x09,0x81}}, // 被
{0x4870,0x94EE,0xC8F0,0xE8AAB9,0x8AB9,{0x00,0x48,0x3c,0x48,0x00,0x48,0x7f,0xcf,0x00,0x48,0x3c,0x48,0x00,0x48,0x01,0xcf,0x3c,0x48,0x00,0x48,0x3c,0xc8,0x27,0x4f,0x24,0x48,0x24,0x88,0x3c,0x88,0x25,0x08}}, // 誹
{0x4871,0x94EF,0xC8F1,0xE8B2BB,0x8CBB,{0x02,0x20,0x3f,0xfc,0x02,0x24,0x3f,0xfc,0x22,0x20,0x3f,0xfe,0x04,0x22,0x0f,0xfc,0x38,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x06,0x38,0x38,0x06}}, // 費
{0x4872,0x94F0,0xC8F2,0xE981BF,0x907F,{0x00,0x08,0x23,0xc8,0x12,0x7e,0x12,0x44,0x02,0x54,0x03,0xc8,0x02,0x7f,0x7a,0x08,0x0b,0xc8,0x0b,0x7e,0x0d,0x48,0x09,0x48,0x0d,0xc8,0x14,0x08,0x23,0x00,0x40,0xff}}, // 避
{0x4873,0x94F1,0xC8F3,0xE99D9E,0x975E,{0x02,0x20,0x02,0x20,0x02,0x20,0x3e,0x3e,0x02,0x20,0x02,0x20,0x02,0x20,0x3e,0x3e,0x02,0x20,0x02,0x20,0x0e,0x20,0x72,0x3f,0x04,0x20,0x04,0x20,0x08,0x20,0x10,0x20}}, // 非
{0x4874,0x94F2,0xC8F4,0xE9A39B,0x98DB,{0x00,0x00,0x1f,0xf2,0x01,0x1c,0x03,0x14,0x0d,0x0a,0x39,0x0a,0x09,0x06,0x7f,0xf2,0x09,0x12,0x09,0x14,0x09,0x18,0x11,0x14,0x11,0x0a,0x21,0x09,0x41,0x05,0x01,0x03}}, // 飛
{0x4875,0x94F3,0xC8F5,0xE6A88B,0x6A0B,{0x10,0x00,0x12,0x7c,0x11,0x04,0x7d,0x28,0x10,0x10,0x10,0x7e,0x38,0x52,0x37,0x7e,0x35,0x52,0x51,0x7e,0x51,0x52,0x11,0x52,0x11,0x52,0x12,0xc6,0x14,0x60,0x18,0x1f}}, // 樋
{0x4876,0x94F4,0xC8F6,0xE7B0B8,0x7C38,{0x10,0x20,0x10,0x20,0x3f,0x7f,0x28,0x50,0x44,0x88,0x12,0x08,0x7f,0xff,0x12,0x4a,0x1e,0x48,0x12,0x7e,0x1e,0x52,0x12,0x52,0x7f,0xcc,0x12,0x8c,0x21,0x12,0x42,0x61}}, // 簸
{0x4877,0x94F5,0xC8F7,0xE58299,0x5099,{0x04,0x88,0x04,0x88,0x07,0xfe,0x08,0x88,0x08,0x88,0x13,0xff,0x12,0x00,0x32,0xfe,0x52,0x92,0x12,0xfe,0x12,0x92,0x12,0x92,0x14,0xfe,0x14,0x92,0x18,0x92,0x10,0x86}}, // 備
{0x4878,0x94F6,0xC8F8,0xE5B0BE,0x5C3E,{0x00,0x00,0x1f,0xfc,0x10,0x04,0x10,0x04,0x1f,0xfc,0x10,0x14,0x10,0xe0,0x17,0x80,0x10,0x9c,0x1f,0xe0,0x10,0x80,0x10,0xfe,0x1f,0x80,0x20,0x82,0x20,0x82,0x40,0x7e}}, // 尾
{0x4879,0x94F7,0xC8F9,0xE5BEAE,0x5FAE,{0x09,0x08,0x0d,0x48,0x15,0x48,0x15,0x4f,0x27,0xca,0x4c,0x52,0x08,0x12,0x17,0xe2,0x12,0x8a,0x32,0x8a,0x52,0x84,0x12,0xa4,0x12,0xcc,0x14,0x92,0x18,0x22,0x10,0x41}}, // 微
{0x487A,0x94F8,0xC8FA,0xE69E87,0x6787,{0x09,0x10,0x09,0x10,0x09,0x10,0x7f,0x10,0x09,0x12,0x09,0x12,0x1d,0xf4,0x1b,0x18,0x1b,0x10,0x29,0x10,0x29,0x10,0x49,0x10,0x09,0x11,0x09,0x51,0x09,0x8f,0x0e,0x00}}, // 枇
{0x487B,0x94F9,0xC8FB,0xE6AF98,0x6BD8,{0x00,0x00,0x1f,0xf8,0x11,0x08,0x11,0x08,0x1f,0xf8,0x11,0x08,0x11,0x08,0x1f,0xf8,0x00,0x00,0x10,0x44,0x10,0x48,0x1f,0x70,0x10,0x40,0x10,0x42,0x1f,0x42,0x70,0x3e}}, // 毘
{0x487C,0x94FA,0xC8FC,0xE790B5,0x7435,{0x00,0x00,0x7f,0x7e,0x08,0x10,0x08,0x10,0x3e,0x7c,0x08,0x10,0x08,0x10,0x0f,0xfe,0x70,0x40,0x10,0x40,0x10,0x4c,0x1f,0x70,0x10,0x40,0x10,0x42,0x1f,0x42,0x70,0x3e}}, // 琵
{0x487D,0x94FB,0xC8FD,0xE79C89,0x7709,{0x00,0x00,0x1f,0xfe,0x10,0x42,0x10,0x42,0x1f,0xfe,0x10,0x00,0x13,0xfc,0x12,0x04,0x12,0x04,0x13,0xfc,0x12,0x04,0x13,0xfc,0x22,0x04,0x22,0x04,0x43,0xfc,0x02,0x04}}, // 眉
{0x487E,0x94FC,0xC8FE,0xE7BE8E,0x7F8E,{0x04,0x10,0x02,0x10,0x02,0x20,0x3f,0xff,0x00,0x80,0x0f,0xfc,0x00,0x80,0x00,0x80,0x1f,0xfe,0x00,0x80,0x00,0x80,0x3f,0xff,0x01,0x40,0x02,0x20,0x0c,0x18,0x70,0x07}}, // 美
{0x4921,0x9540,0xC9A1,0xE9BCBB,0x9F3B,{0x01,0x00,0x07,0xf0,0x04,0x10,0x07,0xf0,0x04,0x10,0x07,0xf0,0x04,0x10,0x1f,0xfc,0x10,0x84,0x1f,0xfc,0x10,0x84,0x1f,0xfc,0x02,0x10,0x7f,0xff,0x04,0x10,0x08,0x10}}, // 鼻
{0x4922,0x9541,0xC9A2,0xE69F8A,0x67CA,{0x08,0x40,0x08,0x40,0x08,0x7c,0x7e,0x44,0x08,0xc8,0x09,0x28,0x1c,0x10,0x1a,0x28,0x18,0xc4,0x2b,0x03,0x28,0x60,0x48,0x10,0x08,0x00,0x08,0xe0,0x08,0x18,0x08,0x04}}, // 柊
{0x4923,0x9542,0xC9A3,0xE7A897,0x7A17,{0x02,0x10,0x0c,0x20,0x79,0xfc,0x09,0x24,0x09,0x24,0x7f,0xfc,0x09,0x24,0x09,0x24,0x1d,0xfc,0x1a,0x48,0x28,0x88,0x2b,0xff,0x48,0x08,0x08,0x08,0x08,0x08,0x08,0x08}}, // 稗
{0x4924,0x9543,0xC9A4,0xE58CB9,0x5339,{0x00,0x00,0x00,0x00,0x7f,0xff,0x42,0x20,0x42,0x20,0x42,0x20,0x42,0x20,0x44,0x20,0x44,0x22,0x48,0x22,0x50,0x1e,0x40,0x00,0x40,0x00,0x7f,0xff,0x40,0x00,0x00,0x00}}, // 匹
{0x4925,0x9544,0xC9A5,0xE7968B,0x758B,{0x00,0x00,0x7f,0xfe,0x00,0x82,0x00,0x84,0x00,0x88,0x08,0x80,0x08,0x80,0x08,0xfc,0x08,0x80,0x08,0x80,0x08,0x80,0x08,0x80,0x14,0x80,0x12,0x80,0x21,0x80,0x40,0x7f}}, // 疋
{0x4926,0x9545,0xC9A6,0xE9ABAD,0x9AED,{0x00,0x04,0x1f,0x98,0x10,0x62,0x1f,0x0c,0x10,0x31,0x7f,0xc2,0x0a,0x0c,0x13,0x70,0x3c,0x80,0x04,0x20,0x24,0x22,0x27,0xec,0x24,0x30,0x25,0xa1,0x2e,0x21,0x70,0x1f}}, // 髭
{0x4927,0x9546,0xC9A7,0xE5BDA6,0x5F66,{0x00,0x80,0x00,0x80,0x7f,0xfe,0x04,0x10,0x02,0x20,0x1f,0xfe,0x10,0x10,0x10,0x60,0x11,0x88,0x1e,0x10,0x10,0x60,0x11,0x84,0x2e,0x08,0x20,0x30,0x41,0xc0,0x0e,0x00}}, // 彦
{0x4928,0x9547,0xC9A8,0xE8869D,0x819D,{0x00,0x20,0x3c,0x20,0x27,0xff,0x24,0x70,0x24,0xac,0x3f,0x23,0x24,0x50,0x24,0x8c,0x27,0x23,0x3d,0x24,0x24,0xa8,0x24,0xf0,0x25,0xac,0x26,0x23,0x24,0x20,0x4c,0x60}}, // 膝
{0x4929,0x9548,0xC9A9,0xE88FB1,0x83F1,{0x04,0x10,0x7f,0xff,0x04,0x90,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x02,0x20,0x05,0x22,0x19,0x1e,0x63,0xf0,0x06,0x10,0x39,0x20,0x00,0xc0,0x07,0x30,0x78,0x0e}}, // 菱
{0x492A,0x9549,0xC9AA,0xE88298,0x8098,{0x00,0x08,0x3e,0x08,0x22,0x08,0x22,0x08,0x23,0xff,0x3e,0x08,0x22,0x08,0x22,0x88,0x22,0x48,0x3e,0x48,0x22,0x08,0x22,0x08,0x22,0x08,0x22,0x08,0x26,0x18,0x42,0x08}}, // 肘
{0x492B,0x954A,0xC9AB,0xE5BCBC,0x5F3C,{0x00,0x00,0x78,0x1e,0x0f,0xe2,0x08,0x82,0x09,0x02,0x3b,0xde,0x22,0x50,0x22,0x50,0x3a,0x5e,0x2b,0xd2,0x0a,0x42,0x0a,0x42,0x0a,0x42,0x0b,0xc2,0x12,0x44,0x60,0x18}}, // 弼
{0x492C,0x954B,0xC9AC,0xE5BF85,0x5FC5,{0x01,0x00,0x00,0x88,0x00,0x48,0x02,0x48,0x02,0x10,0x02,0x10,0x12,0x24,0x12,0x22,0x12,0x42,0x22,0x81,0x23,0x01,0x42,0x04,0x02,0x04,0x05,0x04,0x18,0xfc,0x60,0x00}}, // 必
{0x492D,0x954C,0xC9AD,0xE795A2,0x7562,{0x00,0x00,0x1f,0xfc,0x10,0x84,0x1f,0xfc,0x10,0x84,0x1f,0xfc,0x08,0x88,0x08,0x88,0x7f,0xff,0x08,0x88,0x08,0x88,0x3f,0xfe,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80}}, // 畢
{0x492E,0x954D,0xC9AE,0xE7AD86,0x7B46,{0x10,0x20,0x10,0x20,0x1f,0x7e,0x28,0x90,0x44,0x88,0x1f,0xf8,0x00,0x88,0x7f,0xff,0x00,0x88,0x1f,0xf8,0x00,0x80,0x1f,0xf8,0x00,0x80,0x7f,0xfe,0x00,0x80,0x00,0x80}}, // 筆
{0x492F,0x954E,0xC9AF,0xE980BC,0x903C,{0x00,0x00,0x27,0xff,0x10,0x00,0x10,0xfc,0x00,0x84,0x00,0xfc,0x00,0x00,0x79,0xfe,0x09,0x22,0x09,0x22,0x09,0xfe,0x09,0x22,0x17,0x22,0x13,0xfe,0x21,0x80,0x40,0x7f}}, // 逼
{0x4930,0x954F,0xC9B0,0xE6A1A7,0x6867,{0x08,0x20,0x08,0x20,0x08,0x50,0x7e,0x48,0x08,0x84,0x09,0x02,0x1a,0xfd,0x1c,0x00,0x1a,0x00,0x2b,0xff,0x28,0x20,0x48,0x28,0x08,0x44,0x08,0x9c,0x0b,0xe2,0x08,0x02}}, // 桧
{0x4931,0x9550,0xC9B1,0xE5A7AB,0x59EB,{0x08,0x00,0x08,0xff,0x08,0x88,0x08,0x88,0x7f,0x88,0x12,0xfe,0x12,0x82,0x12,0x82,0x22,0x82,0x24,0xfe,0x7c,0x88,0x06,0x88,0x0a,0x88,0x12,0x88,0x60,0xff,0x00,0x80}}, // 姫
{0x4932,0x9551,0xC9B2,0xE5AA9B,0x5A9B,{0x08,0x04,0x08,0x1a,0x09,0xe2,0x08,0x24,0x7e,0x94,0x12,0x58,0x13,0xfe,0x12,0x40,0x23,0xff,0x24,0x40,0x7c,0x7c,0x46,0xa4,0x0a,0x98,0x11,0x10,0x62,0x6c,0x01,0x83}}, // 媛
{0x4933,0x9552,0xC9B3,0xE7B490,0x7D10,{0x08,0x00,0x09,0xfc,0x0a,0x24,0x72,0x24,0x14,0x24,0x08,0x24,0x0a,0x24,0x12,0xfe,0x7f,0x44,0x09,0x44,0x2c,0x44,0x2a,0x44,0x2a,0x44,0x2a,0x44,0x49,0xff,0x08,0x00}}, // 紐
{0x4934,0x9553,0xC9B4,0xE799BE,0x767E,{0x00,0x00,0x7f,0xfe,0x01,0x00,0x01,0x00,0x02,0x00,0x1f,0xf8,0x10,0x08,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x08}}, // 百
{0x4935,0x9554,0xC9B5,0xE8ACAC,0x8B2C,{0x00,0x00,0x3f,0xfe,0x01,0x32,0x7c,0xaa,0x00,0x66,0x3c,0xaa,0x03,0x76,0x00,0x50,0x3c,0x9c,0x03,0x23,0x3c,0x48,0x25,0x92,0x24,0x64,0x25,0x88,0x3c,0x30,0x25,0xc0}}, // 謬
{0x4936,0x9555,0xC9B6,0xE4BFB5,0x4FF5,{0x04,0x20,0x04,0x20,0x07,0xfe,0x08,0x20,0x0b,0xfe,0x10,0x20,0x10,0x20,0x37,0xff,0x50,0xa0,0x11,0x24,0x13,0x14,0x15,0x18,0x11,0x08,0x11,0x04,0x11,0xc2,0x16,0x01}}, // 俵
{0x4937,0x9556,0xC9B7,0xE5BDAA,0x5F6A,{0x04,0x08,0x07,0x88,0x04,0x10,0x3f,0xd0,0x24,0xa4,0x27,0x04,0x3c,0x08,0x24,0x90,0x23,0xa2,0x20,0x02,0x25,0x04,0x25,0x08,0x25,0x30,0x29,0x01,0x48,0x81,0x10,0x7f}}, // 彪
{0x4938,0x9557,0xC9B8,0xE6A899,0x6A19,{0x08,0x00,0x09,0xff,0x08,0x28,0x7f,0xfe,0x08,0xaa,0x08,0xaa,0x1c,0xfe,0x1a,0x00,0x1a,0xfc,0x28,0x00,0x2b,0xff,0x48,0x50,0x08,0x54,0x08,0x92,0x09,0x11,0x08,0x30}}, // 標
{0x4939,0x9558,0xC9B9,0xE6B0B7,0x6C37,{0x00,0x80,0x00,0x80,0x10,0x82,0x08,0x82,0x04,0x84,0x00,0xc8,0x7e,0xd0,0x02,0xa0,0x04,0xa0,0x04,0x90,0x08,0x88,0x10,0x84,0x20,0x82,0x40,0x81,0x03,0x80,0x00,0x80}}, // 氷
{0x493A,0x9559,0xC9BA,0xE6BC82,0x6F02,{0x10,0x00,0x0f,0xff,0x08,0x90,0x0b,0xfc,0x42,0x94,0x22,0x94,0x23,0xfc,0x00,0x00,0x09,0xfc,0x08,0x00,0x17,0xff,0x11,0x28,0x21,0x24,0x22,0x22,0x44,0x22,0x40,0x60}}, // 漂
{0x493B,0x955A,0xC9BB,0xE793A2,0x74E2,{0x00,0x02,0x7f,0x0c,0x14,0x74,0x7f,0x54,0x55,0x54,0x55,0x54,0x7f,0x54,0x00,0x54,0x3e,0x54,0x00,0x54,0x7f,0x54,0x08,0x54,0x2a,0x55,0x2a,0x9d,0x48,0xe3,0x19,0x01}}, // 瓢
{0x493C,0x955B,0xC9BC,0xE7A5A8,0x7968,{0x00,0x00,0x7f,0xff,0x02,0x20,0x1f,0xfc,0x12,0x24,0x12,0x24,0x1f,0xfc,0x00,0x00,0x0f,0xf8,0x00,0x00,0x7f,0xff,0x00,0x80,0x04,0xb0,0x18,0x8c,0x60,0x82,0x01,0x80}}, // 票
{0x493D,0x955C,0xC9BD,0xE8A1A8,0x8868,{0x00,0x80,0x00,0x80,0x3f,0xfe,0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x7f,0xff,0x02,0x84,0x0c,0x48,0x74,0x50,0x04,0x20,0x04,0x10,0x07,0x0c,0x38,0x03}}, // 表
{0x493E,0x955D,0xC9BE,0xE8A995,0x8A55,{0x00,0x00,0x3e,0xfe,0x00,0x12,0x7f,0x92,0x00,0x94,0x3e,0x54,0x00,0x58,0x00,0x50,0x3f,0xff,0x00,0x10,0x3e,0x10,0x22,0x10,0x22,0x10,0x22,0x10,0x3e,0x10,0x22,0x10}}, // 評
{0x493F,0x955E,0xC9BF,0xE8B1B9,0x8C79,{0x04,0x40,0x18,0x40,0x65,0x40,0x12,0x7e,0x0c,0x82,0x18,0x82,0x65,0x02,0x04,0x22,0x0a,0x12,0x12,0x12,0x66,0x02,0x0a,0x02,0x12,0x02,0x62,0x02,0x04,0x04,0x18,0x18}}, // 豹
{0x4940,0x955F,0xC9C0,0xE5BB9F,0x5EDF,{0x00,0x40,0x3f,0xff,0x22,0x00,0x22,0x3e,0x3f,0xe2,0x22,0x22,0x2f,0xa2,0x28,0xbe,0x2f,0xa2,0x28,0xa2,0x2f,0xbe,0x22,0x22,0x3f,0xe2,0x42,0x22,0x42,0x46,0x02,0x82}}, // 廟
{0x4941,0x9560,0xC9C1,0xE68F8F,0x63CF,{0x10,0x88,0x10,0x88,0x13,0xff,0x10,0x88,0x7c,0x88,0x10,0x00,0x11,0xfe,0x11,0x22,0x1d,0x22,0x71,0x22,0x11,0xfe,0x11,0x22,0x11,0x22,0x11,0x22,0x11,0xfe,0x31,0x02}}, // 描
{0x4942,0x9561,0xC9C2,0xE79785,0x75C5,{0x00,0x40,0x00,0x40,0x0f,0xff,0x48,0x00,0x28,0x00,0x2f,0xff,0x08,0x20,0x08,0x20,0x1b,0xfe,0x2a,0x22,0x4a,0x62,0x12,0x52,0x12,0x8a,0x23,0x0a,0x42,0x02,0x02,0x06}}, // 病
{0x4943,0x9562,0xC9C3,0xE7A792,0x79D2,{0x02,0x20,0x0c,0x20,0x78,0x20,0x08,0xa8,0x08,0xa4,0x08,0xa4,0x7e,0xa2,0x09,0x22,0x0c,0x26,0x1a,0x24,0x19,0x68,0x28,0x08,0x28,0x10,0x48,0x20,0x08,0xc0,0x0b,0x00}}, // 秒
{0x4944,0x9563,0xC9C4,0xE88B97,0x82D7,{0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x10,0x04,0x10,0x00,0x00,0x1f,0xfc,0x10,0x84,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x84,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x04}}, // 苗
{0x4945,0x9564,0xC9C5,0xE98CA8,0x9328,{0x08,0x44,0x08,0x44,0x15,0xff,0x12,0x44,0x21,0x44,0x7e,0x00,0x08,0x00,0x08,0xfe,0x7f,0x92,0x08,0x92,0x4a,0x92,0x2c,0xfe,0x28,0x92,0x0e,0x92,0x18,0xfe,0x60,0x82}}, // 錨
{0x4946,0x9565,0xC9C6,0xE98BB2,0x92F2,{0x08,0x08,0x08,0x10,0x14,0x60,0x12,0x40,0x21,0x40,0x7e,0x7e,0x08,0x44,0x08,0x44,0x7f,0x44,0x08,0x44,0x4b,0xff,0x2c,0x00,0x28,0x48,0x0e,0x44,0x18,0x82,0x61,0x02}}, // 鋲
{0x4947,0x9566,0xC9C7,0xE8929C,0x849C,{0x04,0x20,0x04,0x20,0x7f,0xff,0x04,0x20,0x00,0x00,0x1f,0x3e,0x00,0x00,0x00,0x00,0x7f,0xff,0x04,0x08,0x15,0x2a,0x15,0x2a,0x14,0xa9,0x24,0xc9,0x44,0x88,0x0c,0x18}}, // 蒜
{0x4948,0x9567,0xC9C8,0xE89BAD,0x86ED,{0x08,0x00,0x09,0xff,0x08,0x10,0x08,0x10,0x3f,0x2c,0x29,0x46,0x29,0xf9,0x29,0x00,0x3f,0x10,0x08,0x10,0x0a,0x7e,0x09,0x10,0x0b,0x10,0x1c,0x90,0x60,0xff,0x00,0x80}}, // 蛭
{0x4949,0x9568,0xC9C9,0xE9B0AD,0x9C2D,{0x08,0x20,0x0e,0x22,0x12,0xfc,0x24,0x28,0x7f,0xff,0x29,0x20,0x29,0xcc,0x3f,0x70,0x29,0x42,0x29,0x3e,0x3f,0x00,0x05,0x7c,0x32,0xc4,0x2a,0x7c,0x28,0x44,0x40,0x7c}}, // 鰭
{0x494A,0x9569,0xC9CA,0xE59381,0x54C1,{0x00,0x00,0x07,0xf0,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x07,0xf0,0x04,0x10,0x00,0x00,0x3f,0x7e,0x21,0x42,0x21,0x42,0x21,0x42,0x21,0x42,0x3f,0x7e,0x21,0x42}}, // 品
{0x494B,0x956A,0xC9CB,0xE5BDAC,0x5F6C,{0x10,0x84,0x10,0x84,0x10,0x88,0x7f,0xf8,0x10,0x92,0x10,0xa2,0x39,0xc4,0x35,0xa4,0x52,0x89,0x52,0x91,0x14,0xa2,0x10,0x82,0x10,0x84,0x10,0x88,0x10,0x90,0x10,0xa0}}, // 彬
{0x494C,0x956B,0xC9CC,0xE6968C,0x658C,{0x08,0x08,0x08,0xec,0x08,0x0a,0x7f,0x0a,0x05,0xff,0x24,0x28,0x14,0x28,0x14,0xa8,0x08,0xb8,0x0c,0xa4,0x14,0xa4,0x12,0xa4,0x12,0xad,0x20,0xb3,0x41,0xc3,0x00,0x01}}, // 斌
{0x494D,0x956C,0xC9CD,0xE6B59C,0x6D5C,{0x10,0x08,0x10,0x30,0x09,0xc0,0x09,0x00,0x41,0x00,0x41,0xfe,0x21,0x10,0x21,0x10,0x09,0x10,0x09,0x10,0x0f,0xff,0x10,0x00,0x11,0x10,0x21,0x08,0x22,0x04,0x44,0x04}}, // 浜
{0x494E,0x956D,0xC9CE,0xE78095,0x7015,{0x21,0x00,0x11,0x7f,0x15,0x08,0x05,0xd0,0x45,0x3e,0x25,0x22,0x2f,0xe2,0x01,0x3e,0x05,0xa2,0x15,0x7e,0x15,0x22,0x2b,0xa2,0x20,0xbe,0x21,0x14,0x42,0x22,0x4c,0xc1}}, // 瀕
{0x494F,0x956E,0xC9CF,0xE8B2A7,0x8CA7,{0x02,0x20,0x04,0x10,0x1f,0xf8,0x61,0x17,0x02,0x10,0x0c,0x60,0x30,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x04,0x18,0x38,0x06}}, // 貧
{0x4950,0x956F,0xC9D0,0xE8B393,0x8CD3,{0x01,0x00,0x7f,0xfe,0x40,0x02,0x5f,0xfa,0x05,0x10,0x19,0x68,0x63,0x86,0x0f,0xf0,0x78,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x06,0x18,0x78,0x06}}, // 賓
{0x4951,0x9570,0xC9D1,0xE9A0BB,0x983B,{0x04,0x00,0x14,0xff,0x17,0x10,0x14,0x20,0x14,0x7e,0x7f,0xc2,0x08,0x42,0x2a,0x7e,0x29,0x42,0x2b,0x7e,0x4a,0xc2,0x1c,0x42,0x04,0x7e,0x08,0x24,0x10,0xc2,0x63,0x01}}, // 頻
{0x4952,0x9571,0xC9D2,0xE6958F,0x654F,{0x10,0x20,0x10,0x20,0x1f,0xa0,0x20,0x3f,0x3f,0x24,0x55,0x44,0x15,0x44,0x15,0xa4,0x7f,0xa4,0x25,0x18,0x25,0x18,0x25,0x08,0x3f,0x94,0x01,0x24,0x02,0x42,0x0c,0x81}}, // 敏
{0x4953,0x9572,0xC9D3,0xE793B6,0x74F6,{0x21,0x00,0x11,0xff,0x12,0x20,0x14,0x20,0x7f,0xa0,0x12,0x3c,0x12,0x24,0x12,0x24,0x7f,0xb4,0x12,0x2c,0x12,0x2c,0x12,0x24,0x12,0x24,0x22,0x25,0x22,0x35,0x42,0xc3}}, // 瓶
{0x4954,0x9573,0xC9D4,0xE4B88D,0x4E0D,{0x00,0x00,0x7f,0xff,0x00,0x40,0x00,0x40,0x00,0x80,0x00,0xc0,0x01,0xb0,0x02,0x88,0x04,0x84,0x18,0x82,0x60,0x81,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 不
{0x4955,0x9574,0xC9D5,0xE4BB98,0x4ED8,{0x02,0x08,0x02,0x08,0x02,0x08,0x04,0x08,0x05,0xff,0x08,0x08,0x0a,0x08,0x19,0x08,0x28,0x88,0x48,0x88,0x08,0x88,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x38,0x08,0x08}}, // 付
{0x4956,0x9575,0xC9D6,0xE59FA0,0x57E0,{0x00,0x20,0x10,0x40,0x11,0xfc,0x11,0x04,0x11,0xfc,0x7d,0x00,0x11,0xfc,0x11,0x04,0x11,0x04,0x11,0xfc,0x14,0x20,0x1b,0xff,0x60,0x20,0x00,0x20,0x00,0x20,0x00,0x20}}, // 埠
{0x4957,0x9576,0xC9D7,0xE5A4AB,0x592B,{0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x01,0x40,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x60,0x03}}, // 夫
{0x4958,0x9577,0xC9D8,0xE5A9A6,0x5A66,{0x08,0x00,0x08,0xfc,0x08,0x04,0x08,0xfc,0x7e,0x04,0x12,0xfc,0x12,0x00,0x13,0xff,0x23,0x11,0x25,0x11,0x7c,0xfe,0x06,0x92,0x0a,0x92,0x10,0x9c,0x60,0x90,0x00,0x10}}, // 婦
{0x4959,0x9578,0xC9D9,0xE5AF8C,0x5BCC,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x3f,0xf8,0x40,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x00,0x00,0x1f,0xf8,0x11,0x08,0x1f,0xf8,0x11,0x08,0x1f,0xf8,0x10,0x08}}, // 富
{0x495A,0x9579,0xC9DA,0xE586A8,0x51A8,{0x00,0x00,0x3f,0xfe,0x20,0x04,0x3f,0xf8,0x40,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x00,0x00,0x1f,0xf8,0x11,0x08,0x11,0x08,0x1f,0xf8,0x11,0x08,0x1f,0xf8,0x10,0x08}}, // 冨
{0x495B,0x957A,0xC9DB,0xE5B883,0x5E03,{0x01,0x00,0x01,0x00,0x01,0x00,0x7f,0xff,0x02,0x40,0x02,0x40,0x04,0x40,0x07,0xfc,0x0c,0x44,0x14,0x44,0x24,0x44,0x44,0x44,0x04,0x44,0x04,0x58,0x00,0x40,0x00,0x40}}, // 布
{0x495C,0x957B,0xC9DC,0xE5BA9C,0x5E9C,{0x00,0x40,0x00,0x40,0x1f,0xfe,0x10,0x00,0x11,0x08,0x11,0x08,0x11,0xfe,0x12,0x08,0x12,0x88,0x16,0x48,0x1a,0x48,0x12,0x08,0x22,0x08,0x22,0x08,0x42,0x18,0x02,0x08}}, // 府
{0x495D,0x957C,0xC9DD,0xE68096,0x6016,{0x08,0x40,0x08,0x40,0x08,0x40,0x0b,0xff,0x08,0x40,0x0c,0x50,0x2a,0x90,0x28,0xfe,0x29,0x92,0x49,0x92,0x0a,0x92,0x08,0x92,0x08,0x92,0x08,0x9c,0x08,0x10,0x08,0x10}}, // 怖
{0x495E,0x957D,0xC9DE,0xE689B6,0x6276,{0x10,0x20,0x10,0x20,0x10,0x20,0x11,0xfc,0x7c,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x1b,0xff,0x70,0x50,0x10,0x50,0x10,0x88,0x10,0x88,0x11,0x04,0x32,0x02,0x14,0x01}}, // 扶
{0x495F,0x957E,0xC9DF,0xE695B7,0x6577,{0x0a,0x20,0x09,0x20,0x7f,0xa0,0x08,0x3f,0x3f,0x44,0x29,0x44,0x3f,0xa4,0x29,0x24,0x3f,0x24,0x08,0x18,0x7f,0x88,0x08,0x18,0x0e,0x14,0x12,0x24,0x22,0x42,0x4d,0x81}}, // 敷
{0x4960,0x9580,0xC9E0,0xE696A7,0x65A7,{0x02,0x40,0x04,0x20,0x1c,0x38,0x62,0x46,0x01,0x80,0x02,0x60,0x0c,0x18,0x70,0x67,0x0f,0x80,0x08,0x00,0x0f,0xfe,0x08,0x40,0x10,0x40,0x20,0x40,0x40,0x40,0x00,0x40}}, // 斧
{0x4961,0x9581,0xC9E1,0xE699AE,0x666E,{0x10,0x10,0x08,0x10,0x04,0x20,0x3f,0xfc,0x12,0x48,0x0a,0x48,0x0a,0x50,0x7f,0xff,0x00,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10}}, // 普
{0x4962,0x9582,0xC9E2,0xE6B5AE,0x6D6E,{0x10,0x08,0x08,0x30,0x0f,0xc4,0x02,0x44,0x01,0x28,0x41,0x28,0x23,0xfc,0x20,0x08,0x08,0x10,0x08,0x20,0x17,0xff,0x10,0x20,0x20,0x20,0x20,0x20,0x40,0xe0,0x40,0x20}}, // 浮
{0x4963,0x9583,0xC9E3,0xE788B6,0x7236,{0x02,0x20,0x02,0x10,0x04,0x08,0x04,0x04,0x08,0x04,0x14,0x12,0x64,0x10,0x02,0x10,0x02,0x20,0x01,0x20,0x01,0x40,0x00,0x80,0x01,0x40,0x02,0x20,0x0c,0x18,0x70,0x07}}, // 父
{0x4964,0x9584,0xC9E4,0xE7ACA6,0x7B26,{0x08,0x20,0x08,0x20,0x1f,0x7f,0x14,0x50,0x22,0x88,0x45,0x00,0x04,0x08,0x08,0x08,0x0b,0xff,0x18,0x08,0x29,0x08,0x48,0x88,0x08,0x88,0x08,0x08,0x08,0x18,0x08,0x08}}, // 符
{0x4965,0x9585,0xC9E5,0xE88590,0x8150,{0x00,0x80,0x00,0x80,0x1f,0xff,0x11,0x08,0x12,0xff,0x16,0x88,0x1a,0x48,0x12,0x18,0x10,0x40,0x17,0xfc,0x14,0xa4,0x15,0x54,0x24,0x44,0x24,0xa4,0x45,0x14,0x04,0x0c}}, // 腐
{0x4966,0x9586,0xC9E6,0xE8869A,0x819A,{0x00,0x80,0x00,0xfc,0x00,0x80,0x1f,0xff,0x11,0x1a,0x1f,0xe0,0x10,0x82,0x17,0xfe,0x14,0x44,0x17,0xfc,0x12,0x08,0x13,0xf8,0x22,0x08,0x23,0xf8,0x42,0x08,0x02,0x18}}, // 膚
{0x4967,0x9587,0xC9E7,0xE88A99,0x8299,{0x04,0x08,0x04,0x08,0x7f,0xff,0x04,0x08,0x04,0x88,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x60,0x03}}, // 芙
{0x4968,0x9588,0xC9E8,0xE8AD9C,0x8B5C,{0x00,0x84,0x3c,0x44,0x00,0x48,0x7f,0xfe,0x00,0x4a,0x3d,0x4a,0x00,0xcc,0x03,0xff,0x3c,0x00,0x00,0xfc,0x3c,0x84,0x24,0xfc,0x24,0x84,0x24,0x84,0x3c,0xfc,0x24,0x84}}, // 譜
{0x4969,0x9589,0xC9E9,0xE8B2A0,0x8CA0,{0x02,0x00,0x03,0xf0,0x04,0x20,0x08,0x40,0x1f,0xf8,0x28,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x02,0x30,0x0c,0x08,0x30,0x04}}, // 負
{0x496A,0x958A,0xC9EA,0xE8B3A6,0x8CE6,{0x00,0x08,0x3d,0xec,0x24,0x0a,0x24,0x0a,0x3f,0xff,0x24,0x48,0x24,0x48,0x25,0x48,0x3d,0x78,0x25,0x48,0x25,0x48,0x3d,0x44,0x19,0x75,0x15,0xc5,0x27,0x03,0x40,0x01}}, // 賦
{0x496B,0x958B,0xC9EB,0xE8B5B4,0x8D74,{0x04,0x10,0x04,0x10,0x3f,0x90,0x04,0x10,0x04,0x10,0x04,0x18,0x7f,0xd4,0x04,0x12,0x14,0x12,0x17,0x90,0x14,0x10,0x1c,0x10,0x14,0x10,0x23,0x10,0x20,0xe0,0x40,0x1f}}, // 赴
{0x496C,0x958C,0xC9EC,0xE9989C,0x961C,{0x00,0x80,0x01,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 阜
{0x496D,0x958D,0xC9ED,0xE99984,0x9644,{0x00,0x44,0x3c,0x44,0x24,0x44,0x24,0x84,0x28,0xff,0x30,0x84,0x29,0x84,0x26,0xa4,0x24,0x94,0x24,0x94,0x24,0x84,0x24,0x84,0x38,0x84,0x20,0x84,0x20,0x8c,0x20,0x84}}, // 附
{0x496E,0x958E,0xC9EE,0xE4BEAE,0x4FAE,{0x04,0x80,0x04,0x80,0x04,0xff,0x09,0x00,0x09,0x00,0x12,0xfc,0x14,0xa4,0x30,0xa4,0x57,0xff,0x11,0x24,0x11,0x24,0x11,0x24,0x13,0xff,0x12,0x04,0x10,0x08,0x10,0x30}}, // 侮
{0x496F,0x958F,0xC9EF,0xE692AB,0x64AB,{0x10,0x80,0x10,0x80,0x11,0xff,0x13,0x54,0x7d,0x54,0x11,0x54,0x13,0xff,0x11,0x54,0x11,0x54,0x1d,0x54,0x73,0xff,0x10,0x00,0x11,0x04,0x11,0x92,0x32,0x49,0x14,0x49}}, // 撫
{0x4970,0x9590,0xC9F0,0xE6ADA6,0x6B66,{0x00,0x24,0x1f,0xa2,0x00,0x22,0x00,0x20,0x7f,0xff,0x02,0x20,0x02,0x20,0x12,0x20,0x13,0xe0,0x12,0x10,0x12,0x10,0x12,0x10,0x13,0xca,0x1e,0x0a,0x70,0x06,0x00,0x02}}, // 武
{0x4971,0x9591,0xC9F1,0xE8889E,0x821E,{0x08,0x00,0x08,0x00,0x1f,0xfe,0x19,0x48,0x29,0x48,0x7f,0xff,0x09,0x48,0x09,0x48,0x7f,0xff,0x08,0x08,0x0f,0xfe,0x11,0x48,0x6a,0x48,0x05,0xff,0x18,0x08,0x60,0x08}}, // 舞
{0x4972,0x9592,0xC9F2,0xE891A1,0x8461,{0x04,0x20,0x7f,0xff,0x04,0x20,0x08,0x00,0x0f,0xfe,0x08,0xa2,0x1f,0xfa,0x20,0x82,0x4f,0xf2,0x08,0x92,0x0f,0xf2,0x08,0x92,0x0f,0xf2,0x08,0x92,0x08,0x34,0x00,0x18}}, // 葡
{0x4973,0x9593,0xC9F3,0xE895AA,0x856A,{0x02,0x20,0x02,0x20,0x7f,0xff,0x0a,0x20,0x08,0x00,0x1f,0xfe,0x29,0x48,0x49,0x48,0x7f,0xff,0x09,0x48,0x09,0x48,0x7f,0xff,0x10,0x00,0x14,0x44,0x22,0x22,0x42,0x21}}, // 蕪
{0x4974,0x9594,0xC9F4,0xE983A8,0x90E8,{0x08,0x00,0x08,0x3e,0x7f,0xa2,0x21,0x22,0x12,0x24,0x12,0x24,0x14,0x28,0xff,0xa4,0x00,0x22,0x00,0x22,0x3f,0x21,0x21,0x31,0x21,0x29,0x21,0x26,0x3f,0x20,0x21,0x20}}, // 部
{0x4975,0x9595,0xC9F5,0xE5B081,0x5C01,{0x04,0x04,0x04,0x04,0x3f,0x84,0x04,0x04,0x04,0x7f,0x7f,0x84,0x00,0x04,0x04,0x44,0x04,0x24,0x3f,0xa4,0x04,0x24,0x04,0x04,0x05,0x84,0x0e,0x04,0x70,0x0c,0x00,0x04}}, // 封
{0x4976,0x9596,0xC9F6,0xE6A593,0x6953,{0x10,0x00,0x13,0xfc,0x12,0x0c,0x7e,0x34,0x13,0xc4,0x12,0x44,0x3b,0xf4,0x37,0x54,0x33,0x54,0x53,0xf4,0x52,0x44,0x12,0x64,0x14,0x55,0x14,0x75,0x1b,0x8b,0x10,0x01}}, // 楓
{0x4977,0x9597,0xC9F7,0xE9A2A8,0x98A8,{0x00,0x00,0x1f,0xf8,0x10,0x28,0x10,0xc8,0x1f,0x08,0x11,0x08,0x17,0xe8,0x15,0x28,0x15,0x28,0x17,0xe8,0x11,0x08,0x11,0x48,0x11,0x25,0x21,0xf5,0x3e,0x13,0x40,0x01}}, // 風
{0x4978,0x9598,0xC9F8,0xE891BA,0x847A,{0x02,0x20,0x7f,0xfe,0x02,0x20,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x00,0x00,0x7f,0xfe,0x04,0x10,0x07,0xf0,0x04,0x10,0x07,0xf0,0x04,0x1c,0x07,0xf0,0x38,0x10,0x00,0x10}}, // 葺
{0x4979,0x9599,0xC9F9,0xE89597,0x8557,{0x04,0x20,0x04,0x20,0x7f,0xff,0x04,0x20,0x00,0x20,0x3e,0x3c,0x22,0x24,0x22,0x68,0x3e,0x98,0x08,0x24,0x2e,0x42,0x29,0xfd,0x28,0x44,0x2e,0x44,0x38,0x7c,0x60,0x44}}, // 蕗
{0x497A,0x959A,0xC9FA,0xE4BC8F,0x4F0F,{0x04,0x40,0x04,0x48,0x04,0x44,0x08,0x44,0x08,0x40,0x17,0xff,0x10,0x40,0x30,0x40,0x50,0x40,0x10,0x60,0x10,0xa0,0x10,0x90,0x11,0x08,0x12,0x04,0x14,0x02,0x18,0x01}}, // 伏
{0x497B,0x959B,0xC9FB,0xE589AF,0x526F,{0x00,0x02,0x7f,0xd2,0x00,0x12,0x1f,0x12,0x11,0x12,0x11,0x12,0x1f,0x12,0x00,0x12,0x3f,0x92,0x24,0x92,0x24,0x92,0x3f,0x92,0x24,0x82,0x24,0x82,0x3f,0x86,0x20,0x82}}, // 副
{0x497C,0x959C,0xC9FC,0xE5BEA9,0x5FA9,{0x08,0x80,0x08,0x80,0x10,0xff,0x15,0x00,0x25,0xfc,0x46,0x84,0x08,0xfc,0x08,0x84,0x18,0xfc,0x28,0x20,0x48,0x7c,0x08,0x84,0x09,0x68,0x08,0x10,0x08,0x6c,0x0b,0x83}}, // 復
{0x497D,0x959D,0xC9FD,0xE5B985,0x5E45,{0x10,0x00,0x11,0xfe,0x10,0x00,0x7e,0xfc,0x52,0x84,0x52,0x84,0x52,0xfc,0x52,0x00,0x53,0xfe,0x53,0x22,0x53,0x22,0x57,0xfe,0x51,0x22,0x11,0x22,0x11,0xfe,0x11,0x02}}, // 幅
{0x497E,0x959E,0xC9FE,0xE69C8D,0x670D,{0x00,0x00,0x3e,0xfe,0x22,0x82,0x22,0x82,0x22,0x8c,0x3e,0x80,0x22,0x80,0x22,0xfe,0x22,0xa2,0x3e,0xa4,0x22,0x94,0x22,0x98,0x22,0x88,0x22,0x94,0x22,0xa2,0x46,0xc1}}, // 服
{0x4A21,0x959F,0xCAA1,0xE7A68F,0x798F,{0x08,0x00,0x08,0xfe,0x08,0x00,0x7e,0x7c,0x02,0x44,0x04,0x44,0x04,0x7c,0x08,0x00,0x1c,0xfe,0x2a,0x92,0x49,0x92,0x08,0xfe,0x08,0x92,0x08,0x92,0x08,0xfe,0x08,0x82}}, // 福
{0x4A22,0x95A0,0xCAA2,0xE885B9,0x8179,{0x00,0x40,0x3e,0x40,0x22,0x7f,0x22,0x80,0x22,0xfc,0x3f,0x44,0x22,0x7c,0x22,0x44,0x22,0x7c,0x3e,0x20,0x22,0x7c,0x22,0xc4,0x23,0x28,0x22,0x18,0x26,0x64,0x43,0x83}}, // 腹
{0x4A23,0x95A1,0xCAA3,0xE8A487,0x8907,{0x08,0x40,0x08,0x40,0x08,0x7f,0x7e,0x80,0x03,0x7c,0x04,0x44,0x04,0x7c,0x09,0x44,0x0a,0x7c,0x1c,0x20,0x2a,0x7c,0x48,0xc4,0x0b,0x28,0x08,0x18,0x08,0x64,0x09,0x83}}, // 複
{0x4A24,0x95A2,0xCAA4,0xE8A686,0x8986,{0x00,0x00,0x7f,0xff,0x02,0x40,0x3f,0xfc,0x22,0x44,0x3f,0xfc,0x08,0x80,0x10,0xfe,0x25,0x84,0x46,0xfc,0x08,0x20,0x18,0x7c,0x2b,0xc8,0x48,0x30,0x08,0xcc,0x0b,0x03}}, // 覆
{0x4A25,0x95A3,0xCAA5,0xE6B7B5,0x6DF5,{0x12,0x02,0x0a,0x52,0x0a,0x52,0x02,0x52,0x43,0xde,0x22,0x02,0x22,0x02,0x03,0xfe,0x0a,0x02,0x0a,0x02,0x13,0xde,0x12,0x52,0x22,0x52,0x24,0x52,0x44,0x52,0x48,0x52}}, // 淵
{0x4A26,0x95A4,0xCAA6,0xE5BC97,0x5F17,{0x02,0x40,0x02,0x40,0x7f,0xfc,0x02,0x44,0x02,0x44,0x3f,0xfc,0x22,0x40,0x22,0x40,0x3f,0xfe,0x22,0x42,0x02,0x42,0x04,0x42,0x04,0x42,0x08,0x4c,0x10,0x40,0x20,0x40}}, // 弗
{0x4A27,0x95A5,0xCAA7,0xE68995,0x6255,{0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x7e,0x20,0x08,0x20,0x08,0x40,0x08,0x40,0x0e,0x50,0x78,0x48,0x08,0x88,0x08,0x84,0x08,0x84,0x09,0x3e,0x1f,0xc2,0x08,0x02}}, // 払
{0x4A28,0x95A6,0xCAA8,0xE6B2B8,0x6CB8,{0x10,0x90,0x08,0x90,0x0b,0xfc,0x00,0x94,0x40,0x94,0x23,0xfc,0x22,0x90,0x02,0x90,0x0b,0xfe,0x0a,0x92,0x10,0x92,0x10,0x92,0x21,0x12,0x21,0x1c,0x42,0x10,0x44,0x10}}, // 沸
{0x4A29,0x95A7,0xCAA9,0xE4BB8F,0x4ECF,{0x04,0x20,0x04,0x20,0x04,0x20,0x08,0x20,0x08,0x20,0x10,0x20,0x10,0x40,0x30,0x40,0x50,0x50,0x10,0x48,0x10,0x84,0x10,0x84,0x10,0x82,0x11,0x3e,0x17,0xc1,0x10,0x01}}, // 仏
{0x4A2A,0x95A8,0xCAAA,0xE789A9,0x7269,{0x04,0x40,0x14,0x40,0x14,0x40,0x14,0x7e,0x1f,0xaa,0x24,0xaa,0x24,0xaa,0x45,0x2a,0x05,0x4a,0x06,0x52,0x3c,0x92,0x05,0x22,0x04,0x22,0x04,0x42,0x04,0x04,0x04,0x18}}, // 物
{0x4A2B,0x95A9,0xCAAB,0xE9AE92,0x9B92,{0x08,0x12,0x0e,0x12,0x12,0x12,0x24,0x22,0x7f,0x3f,0x29,0x62,0x29,0xb2,0x3f,0x2a,0x29,0x2a,0x29,0x2a,0x3f,0x22,0x05,0x22,0x32,0xa2,0x2a,0x22,0x28,0x26,0x40,0x22}}, // 鮒
{0x4A2C,0x95AA,0xCAAC,0xE58886,0x5206,{0x03,0xe0,0x00,0x20,0x04,0x20,0x04,0x10,0x08,0x10,0x08,0x08,0x10,0x04,0x2f,0xf2,0x41,0x11,0x01,0x10,0x01,0x10,0x02,0x10,0x02,0x10,0x04,0x10,0x08,0x10,0x10,0x60}}, // 分
{0x4A2D,0x95AB,0xCAAD,0xE590BB,0x543B,{0x01,0x00,0x01,0x00,0x01,0x00,0x79,0xfe,0x49,0x4a,0x49,0x4a,0x4a,0x4a,0x4a,0x4a,0x4c,0x8a,0x48,0x92,0x49,0x12,0x4a,0x22,0x78,0x22,0x48,0x42,0x00,0x84,0x00,0x18}}, // 吻
{0x4A2E,0x95AC,0xCAAE,0xE599B4,0x5674,{0x00,0x20,0x03,0xfe,0x78,0x20,0x48,0x88,0x4f,0xff,0x48,0x88,0x48,0x00,0x49,0xfc,0x49,0x04,0x49,0xfc,0x79,0x04,0x49,0xfc,0x01,0x04,0x01,0xfc,0x01,0x8c,0x06,0x02}}, // 噴
{0x4A2F,0x95AD,0xCAAF,0xE5A2B3,0x58B3,{0x00,0x20,0x13,0xfe,0x10,0x20,0x10,0x88,0x17,0xff,0x7c,0x88,0x10,0x00,0x11,0xfc,0x11,0x04,0x11,0xfc,0x15,0x04,0x19,0xfc,0x61,0x04,0x01,0xfc,0x01,0x8c,0x06,0x02}}, // 墳
{0x4A30,0x95AE,0xCAB0,0xE686A4,0x61A4,{0x08,0x20,0x0b,0xfe,0x08,0x20,0x08,0x88,0x0f,0xff,0x28,0x88,0x2c,0x00,0x2b,0xfc,0x49,0x04,0x09,0xfc,0x09,0x04,0x09,0xfc,0x09,0x04,0x09,0xfc,0x09,0x8c,0x0e,0x02}}, // 憤
{0x4A31,0x95AF,0xCAB1,0xE689AE,0x626E,{0x10,0x78,0x10,0x08,0x10,0x48,0x10,0x44,0x7c,0x84,0x10,0x82,0x11,0x01,0x13,0xfc,0x1c,0x44,0x70,0x44,0x10,0x44,0x10,0x44,0x10,0x84,0x10,0x84,0x31,0x04,0x12,0x18}}, // 扮
{0x4A32,0x95B0,0xCAB2,0xE7849A,0x711A,{0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x10,0x0e,0x38,0x15,0x54,0x24,0x92,0x44,0x11,0x00,0x80,0x08,0x88,0x08,0x88,0x10,0x90,0x21,0x40,0x02,0x20,0x0c,0x18,0x70,0x07}}, // 焚
{0x4A33,0x95B1,0xCAB3,0xE5A5AE,0x596E,{0x00,0x80,0x7f,0xff,0x02,0x20,0x0d,0x58,0x77,0xf7,0x0c,0x40,0x17,0xf0,0x04,0x40,0x07,0xfc,0x04,0x00,0x1f,0xfc,0x10,0x84,0x1f,0xfc,0x10,0x84,0x1f,0xfc,0x10,0x04}}, // 奮
{0x4A34,0x95B2,0xCAB4,0xE7B289,0x7C89,{0x08,0x48,0x4a,0x48,0x2a,0x48,0x2a,0x48,0x2c,0x84,0x08,0x84,0x7f,0x02,0x0a,0xfd,0x1c,0x24,0x1a,0x24,0x2a,0x24,0x2a,0x24,0x48,0x44,0x08,0x44,0x08,0x88,0x09,0x30}}, // 粉
{0x4A35,0x95B3,0xCAB5,0xE7B39E,0x7CDE,{0x08,0x88,0x04,0x90,0x7f,0xff,0x02,0xa0,0x04,0x90,0x1f,0xfc,0x68,0x8b,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x02,0x20,0x3f,0xfe,0x02,0x20,0x7f,0xff,0x06,0x18,0x38,0x04}}, // 糞
{0x4A36,0x95B4,0xCAB6,0xE7B49B,0x7D1B,{0x08,0x48,0x08,0x48,0x0a,0x48,0x72,0x48,0x14,0x84,0x08,0x84,0x0b,0x02,0x12,0xfd,0x7f,0x24,0x09,0x24,0x2c,0x24,0x2a,0x24,0x29,0x44,0x29,0x44,0x48,0x88,0x09,0x30}}, // 紛
{0x4A37,0x95B5,0xCAB7,0xE99BB0,0x96F0,{0x00,0x00,0x3f,0xfc,0x01,0x00,0x3f,0xfe,0x21,0x04,0x3d,0x78,0x41,0x00,0x1d,0x78,0x07,0xe0,0x04,0x20,0x08,0x10,0x1f,0xe8,0x61,0x26,0x02,0x20,0x04,0x20,0x18,0xc0}}, // 雰
{0x4A38,0x95B6,0xCAB8,0xE69687,0x6587,{0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x04,0x10,0x04,0x10,0x04,0x10,0x02,0x20,0x02,0x20,0x01,0x40,0x00,0x80,0x00,0x80,0x01,0x40,0x02,0x20,0x0c,0x18,0x70,0x07}}, // 文
{0x4A39,0x95B7,0xCAB9,0xE8819E,0x805E,{0x00,0x00,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x40,0x02,0x5f,0xfa,0x44,0x22,0x47,0xe2,0x44,0x22,0x47,0xe2,0x44,0x22,0x47,0xe2,0x5c,0x26,0x40,0x22}}, // 聞
{0x4A3A,0x95B8,0xCABA,0xE4B899,0x4E19,{0x00,0x00,0x7f,0xff,0x00,0x80,0x00,0x80,0x1f,0xfc,0x10,0x84,0x10,0x84,0x11,0x44,0x12,0x24,0x1c,0x14,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x1c,0x10,0x04}}, // 丙
{0x4A3B,0x95B9,0xCABB,0xE4BDB5,0x4F75,{0x05,0x04,0x04,0x84,0x04,0x88,0x0b,0xfe,0x08,0x88,0x10,0x88,0x10,0x88,0x30,0x88,0x57,0xff,0x10,0x88,0x10,0x88,0x10,0x88,0x10,0x88,0x11,0x08,0x11,0x08,0x12,0x08}}, // 併
{0x4A3C,0x95BA,0xCABC,0xE585B5,0x5175,{0x00,0x10,0x00,0xe0,0x07,0x00,0x04,0x00,0x07,0xfe,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x7f,0xff,0x00,0x00,0x02,0x20,0x04,0x18,0x08,0x04,0x30,0x02}}, // 兵
{0x4A3D,0x95BB,0xCABD,0xE5A180,0x5840,{0x10,0x00,0x13,0xfe,0x12,0x02,0x12,0x02,0x7f,0xfe,0x12,0x84,0x12,0x48,0x13,0xfe,0x12,0x48,0x16,0x48,0x1b,0xff,0x62,0x48,0x04,0x48,0x04,0x88,0x08,0x88,0x11,0x08}}, // 塀
{0x4A3E,0x95BC,0xCABE,0xE5B9A3,0x5E63,{0x04,0x10,0x25,0x10,0x16,0x1f,0x3f,0xa2,0x24,0xb2,0x2e,0xcc,0x35,0x84,0x24,0x9a,0x25,0xe1,0x00,0x80,0x0f,0xfc,0x08,0x84,0x08,0x84,0x08,0x98,0x08,0x80,0x00,0x80}}, // 幣
{0x4A3F,0x95BD,0xCABF,0xE5B9B3,0x5E73,{0x00,0x00,0x1f,0xfc,0x00,0x80,0x08,0x88,0x04,0x88,0x04,0x90,0x04,0xa0,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 平
{0x4A40,0x95BE,0xCAC0,0xE5BC8A,0x5F0A,{0x24,0xa0,0x14,0xa0,0x15,0x3f,0x3f,0xa4,0x24,0xd4,0x2e,0x94,0x35,0x88,0x24,0x94,0x25,0xa2,0x20,0x41,0x04,0x20,0x7f,0xff,0x04,0x20,0x04,0x20,0x08,0x20,0x10,0x20}}, // 弊
{0x4A41,0x95BF,0xCAC1,0xE69F84,0x67C4,{0x08,0x00,0x0b,0xff,0x08,0x20,0x7e,0x20,0x09,0xfe,0x09,0x22,0x1d,0x22,0x1b,0x22,0x19,0x32,0x29,0x52,0x29,0x4a,0x49,0x86,0x09,0x02,0x09,0x02,0x09,0x06,0x09,0x02}}, // 柄
{0x4A42,0x95C0,0xCAC2,0xE4B8A6,0x4E26,{0x08,0x08,0x04,0x08,0x02,0x10,0x02,0x20,0x3f,0xfe,0x02,0x20,0x02,0x20,0x22,0x22,0x12,0x22,0x12,0x24,0x0a,0x24,0x0a,0x28,0x02,0x20,0x02,0x20,0x7f,0xff,0x00,0x00}}, // 並
{0x4A43,0x95C1,0xCAC3,0xE894BD,0x853D,{0x04,0x20,0x04,0x20,0x7f,0xff,0x04,0x20,0x08,0x00,0x49,0x20,0x29,0x3e,0x2a,0x24,0x7f,0x44,0x49,0x54,0x49,0x98,0x5d,0x08,0x6b,0x14,0x49,0x24,0x49,0x42,0x4b,0x81}}, // 蔽
{0x4A44,0x95C2,0xCAC4,0xE99689,0x9589,{0x00,0x00,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x42,0x42,0x42,0x42,0x7e,0x7e,0x40,0x82,0x40,0x82,0x4f,0xf2,0x41,0x82,0x42,0x82,0x44,0x82,0x58,0x82,0x41,0x86,0x40,0x02}}, // 閉
{0x4A45,0x95C3,0xCAC5,0xE9999B,0x965B,{0x01,0x10,0x3d,0x10,0x25,0x12,0x25,0xfc,0x29,0x10,0x31,0x10,0x29,0x11,0x29,0xcf,0x27,0x00,0x24,0x20,0x24,0x20,0x25,0xfc,0x38,0x20,0x20,0x20,0x27,0xff,0x20,0x00}}, // 陛
{0x4A46,0x95C4,0xCAC6,0xE7B1B3,0x7C73,{0x00,0x80,0x10,0x88,0x08,0x88,0x04,0x90,0x04,0xa0,0x00,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x02,0xa0,0x04,0x90,0x08,0x88,0x10,0x84,0x20,0x82,0x00,0x80,0x00,0x80}}, // 米
{0x4A47,0x95C5,0xCAC7,0xE9A081,0x9801,{0x00,0x00,0x7f,0xfe,0x01,0x00,0x02,0x00,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x02,0x20,0x0c,0x18,0x30,0x04}}, // 頁
{0x4A48,0x95C6,0xCAC8,0xE583BB,0x50FB,{0x08,0x08,0x0b,0xc8,0x0a,0x7f,0x12,0x42,0x12,0x62,0x13,0xd4,0x32,0x14,0x32,0x7f,0x52,0x08,0x17,0xc8,0x16,0x7f,0x1a,0x48,0x12,0x48,0x13,0xc8,0x12,0x48,0x12,0x08}}, // 僻
{0x4A49,0x95C7,0xCAC9,0xE5A381,0x58C1,{0x00,0x08,0x1f,0x08,0x11,0x7f,0x11,0x22,0x1f,0x14,0x10,0x7f,0x2f,0x08,0x29,0x7f,0x49,0x08,0x0f,0x08,0x00,0x88,0x1f,0xfc,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 壁
{0x4A4A,0x95C8,0xCACA,0xE79996,0x7656,{0x00,0x80,0x00,0x80,0x0f,0xff,0x48,0x08,0x2b,0xfe,0x2a,0x62,0x0a,0x52,0x0b,0xd4,0x1a,0x7f,0x2a,0x08,0x4b,0xc8,0x0e,0x7f,0x16,0x48,0x2a,0x48,0x53,0xc8,0x02,0x48}}, // 癖
{0x4A4B,0x95C9,0xCACB,0xE7A2A7,0x78A7,{0x00,0x10,0x7e,0x20,0x08,0xfc,0x08,0x84,0x7e,0x84,0x08,0xfc,0x08,0x84,0x0e,0x84,0x70,0xfc,0x00,0x00,0x7f,0xff,0x01,0x00,0x07,0xf8,0x1c,0x08,0x67,0xf8,0x04,0x08}}, // 碧
{0x4A4C,0x95CA,0xCACC,0xE588A5,0x5225,{0x00,0x02,0x3f,0xa2,0x20,0xa2,0x20,0xa2,0x20,0xa2,0x3f,0xa2,0x08,0x22,0x08,0x22,0x0f,0xa2,0x08,0xa2,0x08,0xa2,0x08,0x82,0x10,0x82,0x10,0x82,0x21,0x06,0x46,0x02}}, // 別
{0x4A4D,0x95CB,0xCACD,0xE79EA5,0x77A5,{0x24,0x90,0x15,0x1f,0x3f,0xa4,0x24,0xb4,0x2e,0xc8,0x35,0x94,0x24,0xa2,0x25,0xc1,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 瞥
{0x4A4E,0x95CC,0xCACE,0xE89491,0x8511,{0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x0f,0xfc,0x09,0x24,0x09,0x24,0x0f,0xfc,0x00,0x28,0x1f,0xff,0x10,0x24,0x16,0x28,0x11,0x12,0x10,0x2a,0x20,0xc6,0x43,0x02}}, // 蔑
{0x4A4F,0x95CD,0xCACF,0xE7AE86,0x7B86,{0x10,0x20,0x10,0x20,0x3f,0x7f,0x28,0x90,0x44,0x88,0x1f,0xfc,0x10,0x84,0x11,0x44,0x16,0x34,0x00,0x0c,0x10,0x44,0x1e,0x48,0x10,0x70,0x10,0x42,0x1f,0x42,0x70,0x3e}}, // 箆
{0x4A50,0x95CE,0xCAD0,0xE5818F,0x504F,{0x04,0x00,0x07,0xfe,0x04,0x00,0x0b,0xfc,0x0a,0x04,0x12,0x04,0x13,0xfc,0x32,0x00,0x53,0xfe,0x12,0x52,0x16,0x52,0x17,0xfe,0x1a,0x52,0x12,0x52,0x12,0x52,0x12,0x06}}, // 偏
{0x4A51,0x95CF,0xCAD1,0xE5A489,0x5909,{0x00,0x80,0x00,0x80,0x7f,0xff,0x02,0x20,0x12,0x28,0x12,0x24,0x12,0x24,0x24,0x62,0x4a,0x02,0x03,0xf0,0x04,0x20,0x0a,0x40,0x31,0x80,0x01,0xc0,0x0e,0x30,0x70,0x0f}}, // 変
{0x4A52,0x95D0,0xCAD2,0xE78987,0x7247,{0x08,0x40,0x08,0x40,0x08,0x40,0x08,0x40,0x0f,0xfe,0x08,0x00,0x08,0x00,0x08,0x00,0x0f,0xf0,0x08,0x10,0x08,0x10,0x10,0x10,0x10,0x10,0x20,0x10,0x40,0x10,0x00,0x10}}, // 片
{0x4A53,0x95D1,0xCAD3,0xE7AF87,0x7BC7,{0x10,0x20,0x1f,0x3f,0x24,0x48,0x42,0x84,0x7f,0xff,0x00,0x00,0x1f,0xfc,0x10,0x04,0x1f,0xfc,0x10,0x00,0x1f,0xfc,0x19,0x24,0x2f,0xfc,0x29,0x24,0x49,0x24,0x08,0x0c}}, // 篇
{0x4A54,0x95D2,0xCAD4,0xE7B7A8,0x7DE8,{0x08,0x00,0x09,0xff,0x0a,0x00,0x72,0xfe,0x14,0x82,0x08,0x82,0x0c,0xfe,0x12,0x80,0x7d,0xff,0x08,0xd5,0x2c,0xd5,0x2a,0xff,0x29,0x55,0x29,0x55,0x4a,0x55,0x08,0x43}}, // 編
{0x4A55,0x95D3,0xCAD5,0xE8BEBA,0x8FBA,{0x00,0x00,0x20,0x00,0x13,0xfe,0x10,0x42,0x00,0x42,0x00,0x42,0x00,0x42,0x78,0x42,0x08,0x82,0x08,0x82,0x09,0x02,0x0a,0x02,0x0c,0x04,0x14,0x18,0x23,0x00,0x40,0xff}}, // 辺
{0x4A56,0x95D4,0xCAD6,0xE8BF94,0x8FD4,{0x00,0x00,0x21,0xff,0x11,0x00,0x11,0x00,0x01,0x00,0x01,0xfc,0x01,0x44,0x79,0x44,0x09,0x28,0x09,0x18,0x0a,0x10,0x0a,0x68,0x0d,0x84,0x14,0x02,0x23,0x00,0x40,0xff}}, // 返
{0x4A57,0x95D5,0xCAD7,0xE9818D,0x904D,{0x00,0x00,0x23,0xff,0x10,0x00,0x11,0xfe,0x01,0x02,0x01,0xfe,0x01,0x00,0x79,0xfe,0x09,0xaa,0x09,0xaa,0x0a,0xfe,0x0a,0xaa,0x0c,0xaa,0x14,0xaa,0x23,0x86,0x40,0xff}}, // 遍
{0x4A58,0x95D6,0xCAD8,0xE4BEBF,0x4FBF,{0x04,0x00,0x07,0xff,0x04,0x20,0x09,0xfe,0x09,0x22,0x19,0x22,0x19,0xfe,0x29,0x22,0x49,0x22,0x09,0xfe,0x08,0xa0,0x08,0x40,0x08,0x60,0x08,0x90,0x0b,0x0c,0x0c,0x03}}, // 便
{0x4A59,0x95D7,0xCAD9,0xE58B89,0x52C9,{0x08,0x10,0x08,0x10,0x1e,0x10,0x12,0x10,0x24,0x10,0x7f,0xfe,0x24,0x92,0x24,0x92,0x24,0x92,0x3f,0x92,0x0a,0x22,0x0a,0x22,0x12,0x44,0x12,0x99,0x21,0x01,0x40,0xff}}, // 勉
{0x4A5A,0x95D8,0xCADA,0xE5A8A9,0x5A29,{0x08,0x20,0x08,0x3c,0x08,0x48,0x08,0x48,0x7e,0x90,0x13,0xfe,0x12,0x92,0x12,0x92,0x22,0x92,0x24,0xfe,0x7c,0x28,0x46,0x28,0x0a,0x28,0x10,0x49,0x60,0x89,0x03,0x07}}, // 娩
{0x4A5B,0x95D9,0xCADB,0xE5BC81,0x5F01,{0x01,0x00,0x01,0x20,0x02,0x10,0x02,0x38,0x07,0xc4,0x3c,0x04,0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x02,0x10,0x02,0x10,0x04,0x10,0x04,0x10,0x08,0x10,0x10,0x10}}, // 弁
{0x4A5C,0x95DA,0xCADC,0xE99EAD,0x97AD,{0x14,0x40,0x14,0x7f,0x7f,0x48,0x14,0x7e,0x14,0xaa,0x1c,0xaa,0x09,0xbe,0x3e,0xaa,0x2a,0xaa,0x2a,0xbe,0x3e,0x88,0x08,0xa8,0x7f,0x98,0x08,0x94,0x08,0xa2,0x08,0xc1}}, // 鞭
{0x4A5D,0x95DB,0xCADD,0xE4BF9D,0x4FDD,{0x04,0x00,0x05,0xfc,0x05,0x04,0x09,0x04,0x09,0x04,0x11,0xfc,0x10,0x20,0x30,0x20,0x57,0xff,0x10,0x70,0x10,0xa8,0x11,0x24,0x12,0x22,0x14,0x21,0x10,0x20,0x10,0x20}}, // 保
{0x4A5E,0x95DC,0xCADE,0xE88897,0x8217,{0x08,0x14,0x08,0x12,0x15,0xff,0x12,0x10,0x29,0x10,0x48,0xfe,0x3e,0x92,0x08,0x92,0x08,0xfe,0x7f,0x92,0x00,0x92,0x3e,0xfe,0x22,0x92,0x22,0x92,0x3e,0x96,0x22,0x92}}, // 舗
{0x4A5F,0x95DD,0xCADF,0xE98BAA,0x92EA,{0x08,0x14,0x08,0x12,0x15,0xff,0x12,0x10,0x21,0x10,0x7e,0xfe,0x08,0x92,0x08,0x92,0x7f,0xfe,0x08,0x92,0x4a,0x92,0x2c,0xfe,0x28,0x92,0x0f,0x92,0x18,0x96,0x60,0x92}}, // 鋪
{0x4A60,0x95DE,0xCAE0,0xE59C83,0x5703,{0x00,0x00,0x3f,0xfe,0x20,0x92,0x20,0x8a,0x3f,0xfe,0x20,0x82,0x2f,0xfa,0x28,0x8a,0x2f,0xfa,0x28,0x8a,0x2f,0xfa,0x28,0x8a,0x28,0x9a,0x20,0x02,0x3f,0xfe,0x20,0x02}}, // 圃
{0x4A61,0x95DF,0xCAE1,0xE68D95,0x6355,{0x10,0x28,0x10,0x24,0x13,0xff,0x10,0x20,0x7c,0x20,0x11,0xfe,0x11,0x22,0x11,0x22,0x1d,0xfe,0x71,0x22,0x11,0x22,0x11,0xfe,0x11,0x22,0x11,0x22,0x11,0x22,0x31,0x26}}, // 捕
{0x4A62,0x95E0,0xCAE2,0xE6ADA9,0x6B69,{0x00,0x80,0x08,0x80,0x08,0xfc,0x08,0x80,0x08,0x80,0x7f,0xff,0x00,0x80,0x04,0x90,0x04,0x88,0x08,0x84,0x11,0x8a,0x20,0x92,0x00,0x20,0x00,0xc0,0x03,0x00,0x1c,0x00}}, // 歩
{0x4A63,0x95E1,0xCAE3,0xE794AB,0x752B,{0x00,0x88,0x00,0x84,0x7f,0xff,0x00,0x80,0x00,0x80,0x1f,0xfc,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x84,0x10,0x84,0x10,0x8c,0x10,0x84}}, // 甫
{0x4A64,0x95E2,0xCAE4,0xE8A39C,0x88DC,{0x08,0x14,0x08,0x12,0x09,0xff,0x7e,0x10,0x02,0x10,0x04,0xfe,0x04,0x92,0x09,0x92,0x1a,0xfe,0x2c,0x92,0x4a,0x92,0x09,0xfe,0x08,0x92,0x08,0x92,0x08,0x96,0x08,0x82}}, // 補
{0x4A65,0x95E3,0xCAE5,0xE8BC94,0x8F14,{0x08,0x14,0x08,0x12,0x7f,0xff,0x08,0x10,0x3f,0x10,0x29,0x7e,0x29,0x52,0x3f,0x52,0x29,0x7e,0x29,0x52,0x3f,0x52,0x08,0x7e,0x7f,0x52,0x08,0x52,0x08,0x56,0x08,0x52}}, // 輔
{0x4A66,0x95E4,0xCAE6,0xE7A982,0x7A42,{0x02,0x10,0x0c,0x10,0x79,0xff,0x08,0x10,0x08,0xfe,0x7e,0x92,0x08,0xfe,0x08,0x92,0x1c,0x92,0x1a,0xfe,0x2a,0x20,0x28,0x10,0x49,0x52,0x09,0x41,0x0a,0x45,0x08,0x3c}}, // 穂
{0x4A67,0x95E5,0xCAE7,0xE58B9F,0x52DF,{0x02,0x20,0x7f,0xff,0x02,0x20,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x01,0x00,0x7f,0xff,0x04,0x90,0x1f,0xfc,0x61,0x13,0x02,0x10,0x0c,0x10,0x30,0x60}}, // 募
{0x4A68,0x95E6,0xCAE8,0xE5A293,0x5893,{0x02,0x20,0x7f,0xff,0x02,0x20,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x01,0x00,0x7f,0xff,0x02,0xa0,0x0f,0xf8,0x70,0x87,0x00,0x80,0x3f,0xfe,0x00,0x00}}, // 墓
{0x4A69,0x95E7,0xCAE9,0xE68595,0x6155,{0x02,0x20,0x7f,0xff,0x02,0x20,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x01,0x00,0x7f,0xff,0x04,0x10,0x19,0x0c,0x65,0x4b,0x09,0x24,0x11,0x24,0x03,0x00}}, // 慕
{0x4A6A,0x95E8,0xCAEA,0xE6888A,0x620A,{0x00,0x48,0x00,0x44,0x00,0x44,0x1f,0xff,0x10,0x40,0x10,0x40,0x10,0x42,0x10,0x42,0x10,0x24,0x10,0x24,0x10,0x38,0x10,0x10,0x10,0x6a,0x21,0x8a,0x26,0x06,0x40,0x02}}, // 戊
{0x4A6B,0x95E9,0xCAEB,0xE69AAE,0x66AE,{0x02,0x20,0x7f,0xff,0x02,0x20,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x01,0x00,0x7f,0xff,0x02,0x10,0x1f,0xfc,0x64,0x13,0x07,0xf0,0x04,0x10,0x07,0xf0}}, // 暮
{0x4A6C,0x95EA,0xCAEC,0xE6AF8D,0x6BCD,{0x00,0x00,0x07,0xf8,0x04,0x08,0x05,0x08,0x04,0x88,0x04,0x88,0x04,0x08,0x7f,0xff,0x09,0x08,0x08,0x88,0x08,0x48,0x08,0x48,0x1f,0xfe,0x10,0x10,0x00,0x10,0x00,0x60}}, // 母
{0x4A6D,0x95EB,0xCAED,0xE7B0BF,0x7C3F,{0x10,0x20,0x10,0x20,0x1f,0x7f,0x24,0x90,0x42,0x24,0x27,0xff,0x10,0x20,0x11,0xfc,0x41,0x24,0x21,0xfc,0x21,0x24,0x09,0xfc,0x08,0x08,0x17,0xff,0x21,0x08,0x40,0x98}}, // 簿
{0x4A6E,0x95EC,0xCAEE,0xE88FA9,0x83E9,{0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x10,0x00,0x80,0x3f,0xfe,0x04,0x10,0x02,0x10,0x02,0x20,0x7f,0xff,0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 菩
{0x4A6F,0x95ED,0xCAEF,0xE580A3,0x5023,{0x05,0x10,0x05,0x10,0x05,0x10,0x0f,0xff,0x0a,0x12,0x12,0x12,0x13,0xe2,0x32,0x74,0x52,0x54,0x12,0x54,0x12,0x48,0x14,0x58,0x14,0x54,0x18,0x64,0x10,0x42,0x11,0x81}}, // 倣
{0x4A70,0x95EE,0xCAF0,0xE4BFB8,0x4FF8,{0x04,0x20,0x04,0x20,0x07,0xfe,0x08,0x20,0x09,0xfe,0x10,0x50,0x17,0xff,0x30,0x88,0x51,0x24,0x16,0x23,0x11,0xfc,0x10,0x20,0x17,0xff,0x10,0x20,0x10,0x20,0x10,0x20}}, // 俸
{0x4A71,0x95EF,0xCAF1,0xE58C85,0x5305,{0x04,0x00,0x04,0x00,0x07,0xfc,0x08,0x04,0x08,0x04,0x1f,0xe4,0x20,0x24,0x40,0x24,0x00,0x24,0x0f,0xe8,0x08,0x30,0x08,0x00,0x08,0x00,0x08,0x02,0x04,0x02,0x03,0xfe}}, // 包
{0x4A72,0x95F0,0xCAF2,0xE59186,0x5446,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80}}, // 呆
{0x4A73,0x95F1,0xCAF3,0xE5A0B1,0x5831,{0x08,0x00,0x08,0x7e,0x3f,0x42,0x08,0x42,0x08,0x4c,0x7f,0x40,0x22,0x7e,0x12,0x62,0x14,0x62,0x7f,0xd4,0x08,0x54,0x08,0x48,0x3f,0x48,0x08,0x54,0x08,0x62,0x08,0x41}}, // 報
{0x4A74,0x95F2,0xCAF4,0xE5A589,0x5949,{0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x0f,0xf8,0x01,0x40,0x7f,0xff,0x02,0x20,0x04,0x90,0x18,0x8c,0x67,0xf3,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x00,0x80}}, // 奉
{0x4A75,0x95F3,0xCAF5,0xE5AE9D,0x5B9D,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x20,0x00,0x5f,0xf8,0x01,0x00,0x01,0x00,0x01,0x00,0x1f,0xf8,0x01,0x00,0x01,0x10,0x01,0x08,0x01,0x08,0x7f,0xfe,0x00,0x00}}, // 宝
{0x4A76,0x95F4,0xCAF6,0xE5B3B0,0x5CF0,{0x00,0x20,0x10,0x3c,0x10,0x44,0x54,0x88,0x57,0x50,0x54,0x20,0x54,0xd0,0x57,0x0c,0x54,0x23,0x55,0xfc,0x54,0x20,0x7d,0xfc,0x40,0x20,0x47,0xff,0x00,0x20,0x00,0x20}}, // 峰
{0x4A77,0x95F5,0xCAF7,0xE5B3AF,0x5CEF,{0x20,0x82,0x20,0x82,0x3f,0xfe,0x01,0x00,0x01,0xf0,0x06,0x20,0x3b,0x40,0x01,0xc0,0x06,0x38,0x78,0x87,0x0f,0xf8,0x00,0x80,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x00,0x80}}, // 峯
{0x4A78,0x95F6,0xCAF8,0xE5B4A9,0x5D29,{0x00,0x80,0x10,0x82,0x10,0x82,0x1f,0xfe,0x00,0x00,0x1f,0x3e,0x11,0x22,0x11,0x22,0x1f,0x3e,0x11,0x22,0x11,0x22,0x1f,0x3e,0x11,0x22,0x21,0x42,0x23,0x46,0x41,0x82}}, // 崩
{0x4A79,0x95F7,0xCAF9,0xE5BA96,0x5E96,{0x00,0x80,0x00,0x80,0x1f,0xff,0x12,0x00,0x12,0x00,0x13,0xfc,0x14,0x04,0x17,0xe4,0x18,0x24,0x10,0x24,0x17,0xe4,0x14,0x18,0x24,0x02,0x24,0x02,0x42,0x02,0x01,0xfe}}, // 庖
{0x4A7A,0x95F8,0xCAFA,0xE68AB1,0x62B1,{0x10,0x80,0x10,0x80,0x10,0xfe,0x10,0x82,0x7d,0x02,0x11,0xf2,0x11,0x12,0x12,0x12,0x1c,0x12,0x71,0xf2,0x11,0x04,0x11,0x18,0x11,0x01,0x11,0x01,0x10,0x81,0x30,0x7f}}, // 抱
{0x4A7B,0x95F9,0xCAFB,0xE68DA7,0x6367,{0x10,0x20,0x10,0x20,0x13,0xfe,0x10,0x20,0x7d,0xfc,0x10,0x50,0x17,0xff,0x10,0x88,0x1d,0x24,0x76,0x23,0x11,0xfc,0x10,0x20,0x13,0xfe,0x10,0x20,0x10,0x20,0x30,0x20}}, // 捧
{0x4A7C,0x95FA,0xCAFC,0xE694BE,0x653E,{0x08,0x20,0x08,0x20,0x08,0x20,0x7f,0xa0,0x08,0x7f,0x08,0x44,0x0f,0x44,0x09,0xa4,0x09,0x24,0x09,0x14,0x09,0x18,0x11,0x08,0x11,0x14,0x21,0x24,0x41,0xc2,0x06,0x01}}, // 放
{0x4A7D,0x95FB,0xCAFD,0xE696B9,0x65B9,{0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0xf8,0x01,0x08,0x01,0x08,0x02,0x08,0x02,0x08,0x04,0x08,0x04,0x08,0x08,0x08,0x10,0x70}}, // 方
{0x4A7E,0x95FC,0xCAFE,0xE69C8B,0x670B,{0x00,0x00,0x1f,0x3e,0x11,0x22,0x11,0x22,0x11,0x22,0x1f,0x3e,0x11,0x22,0x11,0x22,0x11,0x22,0x1f,0x3e,0x11,0x22,0x11,0x22,0x11,0x22,0x21,0x42,0x23,0x46,0x41,0x82}}, // 朋
{0x4B21,0x9640,0xCBA1,0xE6B395,0x6CD5,{0x10,0x20,0x08,0x20,0x08,0x20,0x03,0xfe,0x40,0x20,0x20,0x20,0x20,0x20,0x07,0xff,0x08,0x40,0x08,0x40,0x10,0x48,0x10,0x84,0x20,0x9c,0x27,0xe2,0x40,0x02,0x40,0x02}}, // 法
{0x4B22,0x9641,0xCBA2,0xE6B3A1,0x6CE1,{0x11,0x00,0x09,0x00,0x09,0xfe,0x01,0x02,0x42,0x02,0x23,0xf2,0x22,0x12,0x04,0x12,0x00,0x12,0x0b,0xf2,0x12,0x04,0x12,0x18,0x22,0x00,0x22,0x01,0x41,0x01,0x40,0xff}}, // 泡
{0x4B23,0x9642,0xCBA3,0xE783B9,0x70F9,{0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00,0x07,0xf0,0x04,0x10,0x07,0xf0,0x00,0x00,0x3f,0xfc,0x00,0x30,0x00,0xc0,0x00,0x80,0x11,0x88,0x12,0x24,0x21,0x12,0x41,0x12}}, // 烹
{0x4B24,0x9643,0xCBA4,0xE7A0B2,0x7832,{0x00,0x40,0x7f,0x40,0x08,0x7e,0x08,0x42,0x08,0x82,0x10,0xfa,0x1f,0x0a,0x32,0x0a,0x32,0x7a,0x52,0x42,0x12,0x4c,0x12,0x40,0x1e,0x40,0x12,0x42,0x10,0x22,0x00,0x1e}}, // 砲
{0x4B25,0x9644,0xCBA5,0xE7B8AB,0x7E2B,{0x08,0x10,0x08,0x1e,0x0a,0x22,0x72,0x54,0x15,0x08,0x09,0x14,0x0c,0x63,0x13,0x88,0x7e,0xbe,0x0a,0x88,0x28,0xbe,0x2c,0x88,0x2a,0xff,0x49,0x48,0x09,0x30,0x0a,0x0f}}, // 縫
{0x4B26,0x9645,0xCBA6,0xE8839E,0x80DE,{0x00,0x40,0x3e,0x40,0x22,0x7e,0x22,0x42,0x22,0x42,0x3e,0xf2,0x22,0x92,0x23,0x12,0x22,0x12,0x3e,0xf2,0x22,0x8c,0x22,0x80,0x22,0x80,0x22,0x81,0x22,0x41,0x46,0x3f}}, // 胞
{0x4B27,0x9646,0xCBA7,0xE88AB3,0x82B3,{0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x10,0x04,0x90,0x00,0x80,0x3f,0xfe,0x01,0x00,0x01,0x00,0x01,0xf8,0x01,0x08,0x02,0x08,0x02,0x08,0x04,0x08,0x18,0x08,0x60,0x30}}, // 芳
{0x4B28,0x9647,0xCBA8,0xE8908C,0x840C,{0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x00,0x00,0x3e,0x7e,0x22,0x42,0x22,0x42,0x3e,0x7e,0x22,0x42,0x22,0x42,0x22,0x7e,0x3e,0x42,0x22,0x42,0x00,0x86,0x01,0x02}}, // 萌
{0x4B29,0x9648,0xCBA9,0xE893AC,0x84EC,{0x02,0x20,0x7f,0xff,0x02,0x20,0x00,0x20,0x20,0x7c,0x13,0xc8,0x10,0x30,0x00,0xcc,0x03,0x23,0x79,0xfe,0x08,0x20,0x08,0xfc,0x08,0x20,0x17,0xff,0x23,0x20,0x40,0xff}}, // 蓬
{0x4B2A,0x9649,0xCBAA,0xE89C82,0x8702,{0x08,0x20,0x08,0x3c,0x08,0x44,0x3e,0xa8,0x2b,0x10,0x2a,0x28,0x2a,0xd4,0x2b,0x13,0x3f,0xfe,0x08,0x10,0x0c,0xfc,0x0a,0x10,0x0b,0xff,0x0e,0x10,0x71,0x10,0x01,0x10}}, // 蜂
{0x4B2B,0x964A,0xCBAB,0xE8A492,0x8912,{0x00,0x80,0x00,0x80,0x7f,0xff,0x04,0xfc,0x04,0x84,0x08,0xfc,0x18,0x20,0x2b,0xff,0x48,0xec,0x0b,0x23,0x08,0x20,0x02,0x88,0x04,0x50,0x7c,0x20,0x07,0x98,0x1c,0x07}}, // 褒
{0x4B2C,0x964B,0xCBAC,0xE8A8AA,0x8A2A,{0x00,0x10,0x3e,0x10,0x00,0x10,0x7f,0xff,0x00,0x20,0x3e,0x20,0x00,0x20,0x3e,0x3e,0x00,0x22,0x00,0x22,0x3e,0x22,0x22,0x42,0x22,0x42,0x22,0x82,0x3f,0x04,0x22,0x18}}, // 訪
{0x4B2D,0x964C,0xCBAD,0xE8B18A,0x8C4A,{0x02,0x20,0x1f,0xfc,0x12,0x24,0x1f,0xfc,0x12,0x24,0x1f,0xfc,0x00,0x00,0x7f,0xff,0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x04,0x10,0x02,0x20,0x7f,0xff,0x00,0x00}}, // 豊
{0x4B2E,0x964D,0xCBAE,0xE982A6,0x90A6,{0x04,0x00,0x04,0x3c,0x3f,0xa4,0x04,0x24,0x04,0x28,0x3f,0xb0,0x04,0x28,0x04,0x24,0x04,0x22,0x7f,0xa2,0x04,0x22,0x04,0x22,0x08,0x32,0x08,0x2c,0x10,0x20,0x20,0x20}}, // 邦
{0x4B2F,0x964E,0xCBAF,0xE98B92,0x92D2,{0x08,0x20,0x08,0x3c,0x14,0x24,0x12,0x48,0x21,0xb0,0x7e,0x18,0x08,0x64,0x09,0x93,0x7e,0xfe,0x08,0x10,0x4a,0x7c,0x2c,0x10,0x29,0xff,0x0e,0x10,0x18,0x10,0x60,0x10}}, // 鋒
{0x4B30,0x964F,0xCBB0,0xE9A3BD,0x98FD,{0x08,0x40,0x08,0x40,0x14,0x7e,0x12,0x42,0x29,0x82,0x7e,0xfa,0x22,0x8a,0x3f,0x0a,0x22,0x0a,0x22,0x7a,0x3e,0x4c,0x28,0x40,0x24,0x40,0x24,0x41,0x3a,0x21,0x61,0x1f}}, // 飽
{0x4B31,0x9650,0xCBB1,0xE9B3B3,0x9CF3,{0x00,0x00,0x1f,0xfc,0x10,0x04,0x1f,0xfc,0x11,0x04,0x17,0xe4,0x14,0x24,0x17,0xe4,0x14,0x24,0x17,0xfc,0x14,0x04,0x17,0xf4,0x11,0x54,0x2c,0xb5,0x2a,0x13,0x50,0x61}}, // 鳳
{0x4B32,0x9651,0xCBB2,0xE9B5AC,0x9D6C,{0x00,0x08,0x3b,0x90,0x2a,0xbc,0x2a,0xa4,0x2a,0xbc,0x3b,0xa4,0x2a,0xbc,0x2a,0xa0,0x2a,0xbf,0x3b,0xa0,0x2a,0xbe,0x2a,0x92,0x2a,0xaa,0x2a,0xaa,0x2c,0xc2,0x59,0x8c}}, // 鵬
{0x4B33,0x9652,0xCBB3,0xE4B98F,0x4E4F,{0x00,0x04,0x00,0x38,0x7f,0xc0,0x01,0x00,0x01,0x00,0x01,0x00,0x3f,0xf8,0x00,0x08,0x00,0x10,0x00,0x20,0x08,0x40,0x09,0x80,0x1e,0x00,0x12,0x00,0x21,0x80,0x40,0x7f}}, // 乏
{0x4B34,0x9653,0xCBB4,0xE4BAA1,0x4EA1,{0x00,0x80,0x00,0x80,0x00,0x82,0x7f,0xff,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x04,0x00,0x03,0xfc,0x00,0x00}}, // 亡
{0x4B35,0x9654,0xCBB5,0xE5828D,0x508D,{0x04,0x20,0x04,0x20,0x07,0xfe,0x08,0x88,0x08,0x50,0x13,0xff,0x12,0x02,0x34,0x20,0x50,0x20,0x13,0xfe,0x10,0x40,0x10,0x7c,0x10,0x44,0x10,0x84,0x11,0x04,0x16,0x18}}, // 傍
{0x4B36,0x9655,0xCBB6,0xE58996,0x5256,{0x04,0x02,0x04,0x12,0x3f,0xd2,0x10,0x92,0x08,0x92,0x09,0x12,0x09,0x12,0x7f,0xf2,0x00,0x12,0x00,0x12,0x1f,0x92,0x10,0x92,0x10,0x82,0x10,0x82,0x1f,0x86,0x10,0x82}}, // 剖
{0x4B37,0x9656,0xCBB7,0xE59D8A,0x574A,{0x08,0x20,0x08,0x20,0x08,0x20,0x0b,0xff,0x7e,0x20,0x08,0x20,0x08,0x20,0x08,0x3c,0x08,0x44,0x08,0x44,0x0e,0x44,0x18,0x84,0x60,0x84,0x01,0x04,0x02,0x04,0x04,0x18}}, // 坊
{0x4B38,0x9657,0xCBB8,0xE5A6A8,0x59A8,{0x08,0x20,0x08,0x20,0x08,0x20,0x09,0xff,0x7e,0x40,0x12,0x40,0x12,0x40,0x12,0x7c,0x22,0x44,0x24,0x44,0x7c,0x44,0x46,0x44,0x0a,0x84,0x10,0x84,0x61,0x04,0x02,0x18}}, // 妨
{0x4B39,0x9658,0xCBB9,0xE5B8BD,0x5E3D,{0x10,0x00,0x11,0xfe,0x11,0x02,0x7f,0xfe,0x53,0x02,0x53,0xfe,0x52,0x00,0x52,0xfc,0x52,0x84,0x52,0xfc,0x5c,0x84,0x50,0xfc,0x50,0x84,0x10,0x84,0x10,0xfc,0x10,0x84}}, // 帽
{0x4B3A,0x9659,0xCBBA,0xE5BF98,0x5FD8,{0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x03,0xfc,0x00,0x80,0x12,0x40,0x12,0x24,0x12,0x22,0x22,0x09,0x42,0x09,0x01,0xf8}}, // 忘
{0x4B3B,0x965A,0xCBBB,0xE5BF99,0x5FD9,{0x08,0x20,0x08,0x20,0x08,0x20,0x0b,0xff,0x08,0x80,0x2c,0x80,0x2a,0x80,0x2a,0x80,0x28,0x80,0x48,0x80,0x08,0x80,0x08,0x80,0x08,0x80,0x08,0x40,0x08,0x3e,0x08,0x00}}, // 忙
{0x4B3C,0x965B,0xCBBC,0xE688BF,0x623F,{0x00,0x00,0x7f,0xfe,0x00,0x00,0x1f,0xf8,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x80,0x10,0x80,0x1f,0xfe,0x11,0x00,0x11,0xf8,0x21,0x08,0x22,0x08,0x44,0x08,0x18,0x30}}, // 房
{0x4B3D,0x965C,0xCBBD,0xE69AB4,0x66B4,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x02,0x20,0x1f,0xfc,0x02,0x20,0x7f,0xff,0x04,0x88,0x18,0x96,0x65,0xe1,0x06,0xb0,0x38,0x8e,0x01,0x80}}, // 暴
{0x4B3E,0x965D,0xCBBE,0xE69C9B,0x671B,{0x08,0x00,0x08,0x3e,0x7f,0xa2,0x10,0x3e,0x10,0x22,0x10,0x3e,0x10,0x22,0x0f,0x42,0x00,0x84,0x3f,0xfe,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 望
{0x4B3F,0x965E,0xCBBF,0xE69F90,0x67D0,{0x04,0x10,0x04,0x10,0x3f,0xff,0x04,0x10,0x04,0x10,0x07,0xf0,0x04,0x10,0x04,0x10,0x07,0xf0,0x00,0x80,0x7f,0xff,0x01,0xa0,0x02,0x90,0x0c,0x8c,0x70,0x83,0x00,0x80}}, // 某
{0x4B40,0x965F,0xCBC0,0xE6A392,0x68D2,{0x08,0x20,0x08,0x20,0x0b,0xfe,0x7e,0x20,0x09,0xfc,0x08,0x50,0x1f,0xff,0x1a,0x88,0x19,0x24,0x2a,0x23,0x29,0xfc,0x48,0x20,0x0b,0xfe,0x08,0x20,0x08,0x20,0x08,0x20}}, // 棒
{0x4B41,0x9660,0xCBC1,0xE58692,0x5192,{0x00,0x00,0x3f,0xfc,0x20,0x04,0x3f,0xfc,0x20,0x04,0x3f,0xfc,0x00,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10}}, // 冒
{0x4B42,0x9661,0xCBC2,0xE7B4A1,0x7D21,{0x08,0x10,0x08,0x10,0x0a,0x10,0x73,0xff,0x14,0x20,0x08,0x20,0x0a,0x20,0x12,0x3c,0x7f,0x24,0x09,0x24,0x2c,0x24,0x2a,0x44,0x29,0x44,0x29,0x44,0x48,0x84,0x09,0x18}}, // 紡
{0x4B43,0x9662,0xCBC3,0xE882AA,0x80AA,{0x00,0x10,0x3e,0x10,0x22,0x10,0x23,0xff,0x22,0x20,0x3e,0x20,0x22,0x20,0x22,0x3c,0x22,0x24,0x3e,0x24,0x22,0x24,0x22,0x24,0x22,0x44,0x22,0x44,0x22,0x84,0x47,0x18}}, // 肪
{0x4B44,0x9663,0xCBC4,0xE886A8,0x81A8,{0x00,0x84,0x3c,0x84,0x27,0xe4,0x24,0x88,0x24,0x88,0x3f,0xf2,0x24,0x02,0x25,0xe4,0x25,0x24,0x3d,0xe9,0x26,0x31,0x25,0x22,0x25,0x42,0x24,0xe4,0x27,0x08,0x4c,0x30}}, // 膨
{0x4B45,0x9664,0xCBC5,0xE8AC80,0x8B00,{0x00,0x44,0x3e,0x44,0x00,0xff,0x7f,0x44,0x00,0x7c,0x3e,0x44,0x00,0x44,0x00,0x7c,0x3e,0x10,0x01,0xff,0x3e,0x38,0x22,0x38,0x22,0x54,0x22,0x92,0x3f,0x11,0x22,0x10}}, // 謀
{0x4B46,0x9665,0xCBC6,0xE8B28C,0x8C8C,{0x04,0x10,0x08,0x20,0x15,0xfe,0x62,0x82,0x14,0x82,0x08,0xfe,0x14,0x82,0x64,0x82,0x0a,0xfe,0x12,0x28,0x66,0x28,0x0a,0x28,0x12,0x48,0x62,0x49,0x04,0x89,0x19,0x07}}, // 貌
{0x4B47,0x9666,0xCBC7,0xE8B2BF,0x8CBF,{0x01,0x00,0x1e,0x7e,0x10,0x12,0x12,0x12,0x11,0x22,0x1f,0x42,0x71,0x8c,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x06,0x18,0x38,0x06}}, // 貿
{0x4B48,0x9667,0xCBC8,0xE989BE,0x927E,{0x08,0x10,0x08,0x10,0x14,0x28,0x12,0x44,0x21,0xfe,0x7e,0x02,0x08,0x50,0x08,0x50,0x7e,0xfe,0x09,0x10,0x4a,0x10,0x2d,0xff,0x28,0x10,0x0e,0x10,0x18,0x10,0x60,0x10}}, // 鉾
{0x4B49,0x9668,0xCBC9,0xE998B2,0x9632,{0x00,0x20,0x3c,0x20,0x24,0x20,0x27,0xff,0x28,0x20,0x30,0x20,0x28,0x20,0x24,0x3e,0x22,0x42,0x22,0x42,0x22,0x42,0x22,0x82,0x3c,0x82,0x21,0x02,0x22,0x04,0x24,0x18}}, // 防
{0x4B4A,0x9669,0xCBCA,0xE590A0,0x5420,{0x00,0x20,0x00,0x28,0x3e,0x24,0x22,0x24,0x22,0x20,0x23,0xff,0x22,0x20,0x22,0x20,0x22,0x20,0x22,0x50,0x3e,0x50,0x22,0x88,0x20,0x88,0x01,0x04,0x06,0x02,0x18,0x01}}, // 吠
{0x4B4B,0x966A,0xCBCB,0xE9A0AC,0x982C,{0x04,0x00,0x04,0xff,0x3f,0x10,0x04,0x20,0x25,0x7e,0x15,0x42,0x16,0x42,0x04,0x7e,0x7f,0xc2,0x04,0x7e,0x04,0x42,0x0a,0x42,0x09,0x7e,0x11,0x24,0x20,0x42,0x40,0x81}}, // 頬
{0x4B4C,0x966B,0xCBCC,0xE58C97,0x5317,{0x04,0x40,0x04,0x40,0x04,0x40,0x04,0x44,0x04,0x44,0x7c,0x48,0x04,0x50,0x04,0x60,0x04,0x40,0x04,0x40,0x0c,0x40,0x14,0x42,0x64,0x42,0x04,0x22,0x04,0x1e,0x04,0x00}}, // 北
{0x4B4D,0x966C,0xCBCD,0xE58395,0x50D5,{0x04,0x50,0x06,0x52,0x05,0x54,0x08,0x50,0x0f,0xff,0x11,0x08,0x10,0x90,0x37,0xfe,0x50,0x20,0x13,0xfc,0x10,0x20,0x17,0xff,0x10,0x50,0x10,0x88,0x13,0x04,0x1c,0x03}}, // 僕
{0x4B4E,0x966D,0xCBCE,0xE58D9C,0x535C,{0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x03,0x80,0x02,0x40,0x02,0x20,0x02,0x10,0x02,0x08,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00}}, // 卜
{0x4B4F,0x966E,0xCBCF,0xE5A2A8,0x58A8,{0x00,0x00,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xfe,0x12,0x24,0x61,0x92,0x1f,0xf8,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 墨
{0x4B50,0x966F,0xCBD0,0xE692B2,0x64B2,{0x10,0x50,0x12,0x52,0x11,0x54,0x10,0x50,0x7f,0xff,0x10,0x88,0x10,0x50,0x13,0xfe,0x1c,0x20,0x71,0xfc,0x10,0x20,0x13,0xff,0x10,0x50,0x10,0x88,0x13,0x04,0x3c,0x03}}, // 撲
{0x4B51,0x9670,0xCBD1,0xE69CB4,0x6734,{0x08,0x20,0x08,0x20,0x08,0x20,0x7f,0x20,0x08,0x20,0x08,0x30,0x1c,0x28,0x1a,0x24,0x19,0x22,0x29,0x22,0x28,0x20,0x48,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20}}, // 朴
{0x4B52,0x9671,0xCBD2,0xE789A7,0x7267,{0x04,0x40,0x14,0x40,0x14,0x40,0x14,0x7f,0x1f,0x44,0x24,0x44,0x44,0x84,0x04,0x84,0x07,0x28,0x1c,0x28,0x64,0x10,0x04,0x10,0x04,0x28,0x04,0x44,0x04,0x82,0x05,0x01}}, // 牧
{0x4B53,0x9672,0xCBD3,0xE79DA6,0x7766,{0x00,0x20,0x7c,0x20,0x45,0xfc,0x44,0x20,0x44,0x20,0x7f,0xff,0x44,0x88,0x44,0x88,0x7d,0x27,0x46,0x20,0x44,0x20,0x45,0xfc,0x7c,0x20,0x40,0x20,0x07,0xff,0x00,0x00}}, // 睦
{0x4B54,0x9673,0xCBD4,0xE7A986,0x7A46,{0x02,0x10,0x0c,0x20,0x78,0xfc,0x08,0x84,0x08,0xfc,0x7e,0x84,0x08,0xfc,0x0c,0x10,0x1a,0x54,0x19,0x9b,0x28,0x34,0x29,0xc9,0x48,0x32,0x08,0xcc,0x08,0x30,0x0b,0xc0}}, // 穆
{0x4B55,0x9674,0xCBD5,0xE987A6,0x91E6,{0x04,0x00,0x04,0x00,0x0a,0x7e,0x09,0x42,0x10,0xc2,0x3f,0x42,0x44,0x42,0x04,0x42,0x7f,0xc2,0x04,0x42,0x25,0x42,0x16,0x42,0x14,0xc2,0x07,0x7e,0x1c,0x42,0x60,0x40}}, // 釦
{0x4B56,0x9675,0xCBD6,0xE58B83,0x52C3,{0x04,0x10,0x04,0x10,0x3f,0x10,0x04,0x10,0x04,0x7e,0x7f,0x92,0x40,0x92,0x5e,0x92,0x02,0x12,0x04,0x12,0x07,0xa2,0x7c,0x22,0x04,0x22,0x04,0x42,0x04,0x82,0x0d,0x0c}}, // 勃
{0x4B57,0x9676,0xCBD7,0xE6B2A1,0x6CA1,{0x10,0x00,0x09,0xf0,0x09,0x10,0x01,0x12,0x01,0x12,0x41,0x12,0x22,0x0e,0x24,0x00,0x03,0xf8,0x08,0x88,0x10,0x90,0x10,0x50,0x20,0x20,0x20,0x50,0x41,0x8c,0x46,0x03}}, // 没
{0x4B58,0x9677,0xCBD8,0xE6AE86,0x6B86,{0x00,0x20,0x7f,0x20,0x10,0x20,0x10,0x48,0x1e,0x44,0x12,0x44,0x12,0x9e,0x33,0xe2,0x2a,0x02,0x44,0xfc,0x04,0x84,0x08,0x84,0x08,0x84,0x10,0x84,0x20,0xfc,0x40,0x84}}, // 殆
{0x4B59,0x9678,0xCBD9,0xE5A080,0x5800,{0x00,0x00,0x13,0xfe,0x12,0x02,0x12,0x02,0x13,0xfe,0x7e,0x10,0x12,0x92,0x12,0x92,0x12,0x92,0x12,0xfe,0x16,0x10,0x1a,0x92,0x64,0x92,0x04,0x92,0x08,0xfe,0x10,0x82}}, // 堀
{0x4B5A,0x9679,0xCBDA,0xE5B98C,0x5E4C,{0x10,0x00,0x10,0xfc,0x10,0x84,0x7e,0xfc,0x52,0x84,0x52,0xfc,0x52,0x92,0x52,0x52,0x52,0x54,0x53,0xff,0x56,0x48,0x50,0x48,0x50,0x48,0x10,0x89,0x11,0x09,0x16,0x07}}, // 幌
{0x4B5B,0x967A,0xCBDB,0xE5A594,0x5954,{0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0x40,0x02,0x20,0x04,0x90,0x18,0x8c,0x67,0xfb,0x00,0x80,0x04,0x90,0x04,0x90,0x7f,0xff,0x04,0x10,0x08,0x10,0x08,0x10,0x10,0x10}}, // 奔
{0x4B5C,0x967B,0xCBDC,0xE69CAC,0x672C,{0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x82,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x02,0xa0,0x04,0x90,0x08,0x88,0x10,0x84,0x27,0xf2,0x40,0x81,0x00,0x80,0x00,0x80,0x00,0x80}}, // 本
{0x4B5D,0x967C,0xCBDD,0xE7BFBB,0x7FFB,{0x02,0x00,0x0d,0xfe,0x7a,0x22,0x2a,0x22,0x1c,0x22,0x7f,0x32,0x0c,0xaa,0x1a,0xaa,0x29,0x22,0x7e,0x66,0x2a,0xaa,0x3f,0x32,0x2a,0x22,0x2a,0x22,0x3e,0x66,0x22,0x22}}, // 翻
{0x4B5E,0x967D,0xCBDE,0xE587A1,0x51E1,{0x00,0x00,0x07,0xe0,0x04,0x20,0x04,0x20,0x04,0x20,0x06,0x20,0x05,0x20,0x04,0xa0,0x04,0xa0,0x04,0x20,0x04,0x20,0x08,0x20,0x08,0x22,0x10,0x22,0x20,0x1e,0x40,0x00}}, // 凡
{0x4B5F,0x967E,0xCBDF,0xE79B86,0x76C6,{0x02,0xf0,0x02,0x10,0x04,0x08,0x18,0x04,0x6f,0xfb,0x00,0x88,0x01,0x08,0x06,0x08,0x38,0x30,0x00,0x00,0x1f,0xfc,0x12,0x24,0x12,0x24,0x12,0x24,0x7f,0xff,0x00,0x00}}, // 盆
{0x4B60,0x9680,0xCBE0,0xE691A9,0x6469,{0x00,0x80,0x00,0x80,0x1f,0xfe,0x11,0x08,0x1f,0xfe,0x13,0x1c,0x15,0xaa,0x19,0x49,0x11,0x18,0x13,0xe0,0x10,0x40,0x17,0xfe,0x20,0x40,0x3f,0xff,0x40,0x40,0x00,0xc0}}, // 摩
{0x4B61,0x9681,0xCBE1,0xE7A3A8,0x78E8,{0x00,0x40,0x00,0x40,0x1f,0xfe,0x11,0x08,0x1f,0xfe,0x13,0x88,0x15,0x5c,0x19,0x2a,0x11,0x09,0x1f,0xfe,0x10,0x80,0x13,0xf8,0x26,0x08,0x3a,0x08,0x43,0xf8,0x02,0x08}}, // 磨
{0x4B62,0x9682,0xCBE2,0xE9AD94,0x9B54,{0x00,0x40,0x1f,0xff,0x11,0x08,0x1f,0xff,0x11,0x8c,0x13,0x5a,0x15,0x29,0x1b,0xfc,0x12,0x44,0x13,0xfc,0x12,0x44,0x13,0xfc,0x20,0xaa,0x21,0x2e,0x46,0x21,0x18,0x1f}}, // 魔
{0x4B63,0x9683,0xCBE3,0xE9BABB,0x9EBB,{0x00,0x80,0x00,0x80,0x1f,0xfe,0x12,0x10,0x12,0x10,0x12,0x10,0x1f,0xfe,0x12,0x10,0x16,0x38,0x17,0x38,0x16,0xd4,0x1a,0x54,0x2a,0x92,0x32,0x10,0x42,0x10,0x02,0x10}}, // 麻
{0x4B64,0x9684,0xCBE4,0xE59F8B,0x57CB,{0x08,0x00,0x09,0xfc,0x09,0x24,0x09,0x24,0x09,0xfc,0x7f,0x24,0x09,0x24,0x09,0xfc,0x08,0x20,0x08,0x20,0x0d,0xfe,0x18,0x20,0x60,0x20,0x00,0x20,0x07,0xff,0x00,0x00}}, // 埋
{0x4B65,0x9685,0xCBE5,0xE5A6B9,0x59B9,{0x08,0x10,0x08,0x10,0x08,0x10,0x08,0xfe,0x7f,0x10,0x12,0x10,0x12,0x10,0x13,0xff,0x22,0x38,0x24,0x38,0x7c,0x54,0x04,0x54,0x0a,0x92,0x11,0x11,0x60,0x10,0x00,0x10}}, // 妹
{0x4B66,0x9686,0xCBE6,0xE698A7,0x6627,{0x00,0x20,0x00,0x20,0x7c,0x20,0x47,0xfe,0x44,0x20,0x44,0x20,0x44,0x20,0x7f,0xff,0x44,0x70,0x44,0x70,0x44,0xa8,0x44,0xa4,0x7d,0x22,0x46,0x21,0x44,0x20,0x00,0x20}}, // 昧
{0x4B67,0x9687,0xCBE7,0xE69E9A,0x679A,{0x08,0x40,0x08,0x40,0x08,0x40,0x08,0x40,0x7f,0xff,0x08,0x84,0x08,0xc4,0x1d,0x44,0x1a,0x28,0x19,0x28,0x29,0x10,0x28,0x10,0x48,0x28,0x08,0x44,0x08,0x82,0x0b,0x01}}, // 枚
{0x4B68,0x9688,0xCBE8,0xE6AF8E,0x6BCE,{0x08,0x00,0x08,0x00,0x0f,0xfe,0x10,0x00,0x17,0xf8,0x24,0x88,0x44,0x88,0x04,0x88,0x7f,0xff,0x08,0x88,0x08,0x88,0x08,0x88,0x1f,0xfc,0x10,0x08,0x00,0x10,0x00,0x60}}, // 毎
{0x4B69,0x9689,0xCBE9,0xE593A9,0x54E9,{0x00,0x00,0x01,0xfc,0x7d,0x24,0x45,0x24,0x45,0xfc,0x45,0x24,0x45,0x24,0x45,0x24,0x45,0xfc,0x44,0x20,0x7c,0x20,0x47,0xfe,0x00,0x20,0x00,0x20,0x07,0xff,0x00,0x00}}, // 哩
{0x4B6A,0x968A,0xCBEA,0xE6A799,0x69D9,{0x08,0x10,0x08,0x10,0x0b,0xff,0x7e,0x10,0x08,0xfc,0x08,0x84,0x1c,0xfc,0x1a,0x84,0x1a,0xfc,0x28,0x84,0x28,0xfc,0x48,0x00,0x09,0xff,0x08,0x48,0x08,0x86,0x0b,0x01}}, // 槙
{0x4B6B,0x968B,0xCBEB,0xE5B995,0x5E55,{0x02,0x10,0x7f,0xff,0x02,0x10,0x07,0xf8,0x04,0x08,0x07,0xf8,0x04,0x08,0x07,0xf8,0x01,0x00,0x7f,0xff,0x04,0x90,0x0f,0xfc,0x14,0x8b,0x64,0x88,0x04,0xb0,0x00,0x80}}, // 幕
{0x4B6C,0x968C,0xCBEC,0xE8869C,0x819C,{0x00,0x48,0x3c,0x48,0x27,0xff,0x24,0x48,0x24,0x48,0x3c,0xfc,0x24,0x84,0x24,0xfc,0x24,0x84,0x3c,0xfc,0x24,0x20,0x27,0xff,0x24,0x20,0x24,0x50,0x25,0x8c,0x4e,0x03}}, // 膜
{0x4B6D,0x968D,0xCBED,0xE69E95,0x6795,{0x08,0x20,0x08,0x20,0x08,0x20,0x7e,0xff,0x08,0xa2,0x08,0xa0,0x1d,0x20,0x1a,0x30,0x1a,0x30,0x28,0x50,0x28,0x50,0x48,0x50,0x08,0x90,0x08,0x91,0x09,0x11,0x0a,0x0f}}, // 枕
{0x4B6E,0x968E,0xCBEE,0xE9AEAA,0x9BAA,{0x08,0x10,0x0e,0x10,0x13,0xff,0x24,0x10,0x7f,0x10,0x29,0x20,0x29,0x3e,0x3f,0x62,0x29,0xa2,0x29,0x3e,0x3f,0x22,0x05,0x3e,0x32,0xa2,0x2a,0x22,0x28,0x22,0x40,0x26}}, // 鮪
{0x4B6F,0x968F,0xCBEF,0xE69FBE,0x67FE,{0x08,0x00,0x09,0xfe,0x08,0x10,0x7f,0x10,0x08,0x10,0x08,0x90,0x1c,0x90,0x1a,0x9e,0x1a,0x90,0x28,0x90,0x28,0x90,0x48,0x90,0x08,0x90,0x08,0x90,0x0b,0xff,0x08,0x00}}, // 柾
{0x4B70,0x9690,0xCBF0,0xE9B192,0x9C52,{0x08,0x42,0x0e,0x24,0x12,0xff,0x24,0x18,0x7f,0x7e,0x29,0x5a,0x29,0x6a,0x3f,0x7e,0x29,0x42,0x29,0x7e,0x3f,0x04,0x05,0xff,0x32,0x44,0x2a,0x24,0x28,0x04,0x40,0x0c}}, // 鱒
{0x4B71,0x9691,0xCBF1,0xE6A19D,0x685D,{0x11,0x04,0x11,0x04,0x11,0x04,0x7d,0xc4,0x11,0x5e,0x11,0x54,0x32,0x54,0x3a,0x54,0x35,0x54,0x50,0x94,0x50,0xbf,0x10,0x84,0x11,0x04,0x11,0x04,0x12,0x04,0x14,0x04}}, // 桝
{0x4B72,0x9692,0xCBF2,0xE4BAA6,0x4EA6,{0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x02,0x20,0x02,0x20,0x0a,0x28,0x0a,0x24,0x0a,0x24,0x12,0x22,0x22,0x22,0x42,0x22,0x04,0x20,0x04,0x20,0x08,0x60,0x10,0x20}}, // 亦
{0x4B73,0x9693,0xCBF3,0xE4BFA3,0x4FE3,{0x04,0x00,0x05,0xfc,0x05,0x04,0x09,0x04,0x09,0x04,0x11,0xfc,0x10,0x00,0x33,0xfe,0x50,0x20,0x10,0x20,0x17,0xff,0x10,0x50,0x10,0x48,0x10,0x84,0x11,0x02,0x12,0x01}}, // 俣
{0x4B74,0x9694,0xCBF4,0xE58F88,0x53C8,{0x00,0x00,0x00,0x00,0x3f,0xfc,0x04,0x04,0x04,0x04,0x04,0x08,0x02,0x08,0x02,0x10,0x01,0x10,0x00,0xa0,0x00,0xc0,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x60,0x03}}, // 又
{0x4B75,0x9695,0xCBF5,0xE68AB9,0x62B9,{0x10,0x20,0x10,0x20,0x10,0x20,0x17,0xff,0x7c,0x20,0x10,0x20,0x10,0x20,0x13,0xfe,0x1c,0x70,0x70,0x70,0x10,0xa8,0x10,0xa8,0x11,0x24,0x12,0x22,0x14,0x21,0x30,0x20}}, // 抹
{0x4B76,0x9696,0xCBF6,0xE69CAB,0x672B,{0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x01,0xc0,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80,0x00,0x80}}, // 末
{0x4B77,0x9697,0xCBF7,0xE6B2AB,0x6CAB,{0x10,0x20,0x08,0x20,0x08,0x20,0x07,0xff,0x00,0x20,0x40,0x20,0x20,0x20,0x23,0xfe,0x08,0x70,0x08,0x70,0x10,0xa8,0x10,0xa8,0x21,0x24,0x22,0x22,0x44,0x21,0x40,0x20}}, // 沫
{0x4B78,0x9698,0xCBF8,0xE8BF84,0x8FC4,{0x01,0x00,0x21,0x00,0x11,0xff,0x11,0x00,0x02,0x00,0x03,0xfc,0x04,0x10,0x78,0x20,0x08,0x40,0x08,0x80,0x08,0x80,0x09,0x02,0x0d,0x02,0x14,0xfe,0x23,0x00,0x40,0xff}}, // 迄
{0x4B79,0x9699,0xCBF9,0xE4BEAD,0x4FAD,{0x04,0x00,0x05,0xfc,0x05,0x04,0x09,0x04,0x09,0x04,0x11,0xfc,0x11,0x10,0x31,0x10,0x52,0x08,0x12,0xc4,0x14,0x22,0x18,0x11,0x11,0x80,0x10,0x60,0x10,0x10,0x10,0x08}}, // 侭
{0x4B7A,0x969A,0xCBFA,0xE7B9AD,0x7E6D,{0x04,0x20,0x7f,0xff,0x04,0x20,0x00,0x00,0x3f,0xfe,0x24,0x92,0x38,0x92,0x2a,0xfe,0x24,0xd6,0x2a,0xd6,0x3f,0xfe,0x24,0x9a,0x2e,0x96,0x2d,0x9e,0x34,0xe6,0x24,0x82}}, // 繭
{0x4B7B,0x969B,0xCBFB,0xE9BABF,0x9EBF,{0x00,0x80,0x00,0x80,0x1f,0xff,0x12,0x08,0x1f,0xff,0x13,0x1c,0x16,0xaa,0x1a,0x49,0x13,0xf8,0x12,0x08,0x13,0xf8,0x10,0x40,0x27,0xfc,0x24,0x04,0x47,0xfc,0x04,0x04}}, // 麿
{0x4B7C,0x969C,0xCBFC,0xE4B887,0x4E07,{0x00,0x00,0x7f,0xfe,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0xf8,0x01,0x08,0x01,0x08,0x02,0x08,0x02,0x08,0x02,0x08,0x04,0x08,0x04,0x08,0x08,0x08,0x10,0x10,0x20,0x60}}, // 万
{0x4B7D,0x969D,0xCBFD,0xE685A2,0x6162,{0x08,0x00,0x08,0xfc,0x08,0x84,0x08,0xfc,0x2c,0x84,0x2a,0xfc,0x28,0x00,0x2b,0xfe,0x4a,0x4a,0x0b,0xfe,0x08,0x00,0x0b,0xfc,0x08,0xc8,0x08,0x30,0x08,0xcc,0x0b,0x03}}, // 慢
{0x4B7E,0x969E,0xCBFE,0xE6BA80,0x6E80,{0x10,0x88,0x08,0x88,0x0b,0xfe,0x00,0x88,0x00,0x88,0x47,0xff,0x20,0x20,0x23,0xfe,0x0a,0x22,0x0a,0xaa,0x12,0xaa,0x12,0xaa,0x22,0xfa,0x22,0x8a,0x42,0x06,0x42,0x02}}, // 満
{0x4C21,0x969F,0xCCA1,0xE6BCAB,0x6F2B,{0x10,0x00,0x09,0xf8,0x09,0x08,0x01,0xf8,0x41,0x08,0x21,0xf8,0x20,0x00,0x0b,0xfe,0x0a,0x52,0x0b,0xfe,0x10,0x00,0x17,0xfc,0x20,0x88,0x20,0x70,0x41,0x98,0x4e,0x07}}, // 漫
{0x4C22,0x96A0,0xCCA2,0xE89493,0x8513,{0x04,0x20,0x7f,0xfe,0x04,0x20,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x3f,0xfc,0x22,0x24,0x3f,0xfc,0x00,0x00,0x1f,0xf8,0x06,0x20,0x01,0xc0,0x06,0x30,0x78,0x0f}}, // 蔓
{0x4C23,0x96A1,0xCCA3,0xE591B3,0x5473,{0x00,0x20,0x00,0x20,0x78,0x20,0x4b,0xfe,0x48,0x20,0x48,0x20,0x48,0x20,0x4f,0xff,0x48,0x70,0x48,0x70,0x48,0xa8,0x79,0x24,0x4a,0x22,0x04,0x21,0x00,0x20,0x00,0x20}}, // 味
{0x4C24,0x96A2,0xCCA4,0xE69CAA,0x672A,{0x00,0x80,0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80,0x00,0x80,0x00,0x80}}, // 未
{0x4C25,0x96A3,0xCCA5,0xE9AD85,0x9B45,{0x08,0x08,0x10,0x08,0x3f,0x08,0x29,0x7e,0x29,0x08,0x3f,0x08,0x29,0xff,0x29,0x08,0x3f,0x9c,0x14,0x9c,0x14,0xaa,0x15,0x49,0x15,0x48,0x27,0xa9,0x22,0x01,0x41,0xff}}, // 魅
{0x4C26,0x96A4,0xCCA6,0xE5B7B3,0x5DF3,{0x00,0x00,0x3f,0xf8,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x3f,0xf8,0x20,0x08,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x02,0x10,0x02,0x0f,0xfe,0x00,0x00}}, // 巳
{0x4C27,0x96A5,0xCCA7,0xE7AE95,0x7B95,{0x08,0x20,0x08,0x20,0x1f,0xbf,0x14,0x48,0x22,0x84,0x44,0x10,0x3f,0xfe,0x04,0x10,0x07,0xf0,0x04,0x10,0x07,0xf0,0x04,0x10,0x7f,0xff,0x02,0x30,0x0c,0x0c,0x30,0x02}}, // 箕
{0x4C28,0x96A6,0xCCA8,0xE5B2AC,0x5CAC,{0x10,0x00,0x11,0xfe,0x11,0x22,0x55,0x22,0x55,0x22,0x55,0xfe,0x55,0x22,0x55,0x22,0x55,0x22,0x55,0xfe,0x55,0x22,0x7c,0x20,0x44,0x20,0x40,0x20,0x00,0x20,0x00,0x20}}, // 岬
{0x4C29,0x96A7,0xCCA9,0xE5AF86,0x5BC6,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x21,0x04,0x24,0xa0,0x54,0xa0,0x14,0x48,0x24,0x94,0x43,0x12,0x1d,0xf2,0x01,0x00,0x21,0x08,0x21,0x08,0x21,0x08,0x3f,0xf8,0x20,0x08}}, // 密
{0x4C2A,0x96A8,0xCCAA,0xE89C9C,0x871C,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x21,0x04,0x44,0xa0,0x24,0x48,0x25,0x94,0x46,0x12,0x1b,0xf2,0x61,0x00,0x1f,0xf0,0x11,0x10,0x1f,0xf0,0x01,0x18,0x01,0xf4,0x7e,0x02}}, // 蜜
{0x4C2B,0x96A9,0xCCAB,0xE6B98A,0x6E4A,{0x10,0x20,0x08,0x20,0x0b,0xfe,0x00,0x20,0x41,0xfc,0x20,0x50,0x27,0xff,0x00,0x88,0x09,0x04,0x0b,0xfe,0x14,0x21,0x11,0xfe,0x20,0x20,0x20,0x50,0x41,0x8c,0x46,0x03}}, // 湊
{0x4C2C,0x96AA,0xCCAC,0xE89391,0x84D1,{0x04,0x10,0x7f,0xff,0x04,0x10,0x00,0x80,0x3f,0xfe,0x00,0x00,0x07,0xf0,0x04,0x10,0x7f,0xff,0x04,0x10,0x07,0xf0,0x01,0x44,0x06,0x28,0x7c,0x10,0x07,0x8c,0x1c,0x03}}, // 蓑
{0x4C2D,0x96AB,0xCCAD,0xE7A894,0x7A14,{0x02,0x20,0x0c,0x20,0x78,0x50,0x08,0x8c,0x0b,0xfb,0x08,0x00,0x7f,0xf8,0x08,0x08,0x1c,0x10,0x1a,0x10,0x2a,0xa0,0x29,0x94,0x49,0x92,0x0a,0x8a,0x0c,0x8a,0x08,0x78}}, // 稔
{0x4C2E,0x96AC,0xCCAE,0xE88488,0x8108,{0x00,0x04,0x3c,0x18,0x24,0xe2,0x24,0x84,0x24,0xb8,0x3c,0xa2,0x24,0xa2,0x24,0xb4,0x24,0xb4,0x3c,0xb8,0x24,0xa8,0x24,0xa8,0x25,0x24,0x25,0x24,0x2e,0x22,0x44,0x21}}, // 脈
{0x4C2F,0x96AD,0xCCAF,0xE5A699,0x5999,{0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x58,0x7e,0x54,0x12,0x52,0x12,0x92,0x12,0x91,0x23,0x15,0x22,0x14,0x7c,0x38,0x46,0x08,0x09,0x10,0x10,0x20,0x60,0xc0,0x03,0x00}}, // 妙
{0x4C30,0x96AE,0xCCB0,0xE7B28D,0x7C8D,{0x08,0x04,0x0a,0x18,0x4a,0xe0,0x2c,0x20,0x28,0x20,0x08,0x3e,0x7f,0xe0,0x08,0x20,0x1c,0x20,0x1a,0x3e,0x2b,0xe0,0x28,0x20,0x48,0x21,0x08,0x21,0x08,0x1f,0x08,0x00}}, // 粍
{0x4C31,0x96AF,0xCCB1,0xE6B091,0x6C11,{0x00,0x00,0x1f,0xfc,0x10,0x04,0x10,0x04,0x10,0x04,0x1f,0xfc,0x10,0x80,0x10,0x80,0x1f,0xff,0x10,0x40,0x10,0x40,0x10,0x20,0x10,0x20,0x13,0x12,0x1c,0x0a,0x60,0x06}}, // 民
{0x4C32,0x96B0,0xCCB2,0xE79CA0,0x7720,{0x00,0x00,0x79,0xfc,0x49,0x04,0x49,0x04,0x49,0x04,0x79,0xfc,0x49,0x10,0x49,0x10,0x79,0xff,0x49,0x10,0x49,0x10,0x49,0x08,0x79,0x0a,0x49,0x6a,0x41,0x86,0x06,0x02}}, // 眠
{0x4C33,0x96B1,0xCCB3,0xE58B99,0x52D9,{0x00,0x40,0x3f,0x40,0x02,0x7f,0x14,0x84,0x09,0x44,0x08,0x28,0x7f,0x10,0x0a,0x6c,0x0b,0xa3,0x1c,0x20,0x19,0xfc,0x28,0x24,0x28,0x24,0x48,0x44,0x08,0x84,0x19,0x18}}, // 務
{0x4C34,0x96B2,0xCCB4,0xE5A4A2,0x5922,{0x04,0x20,0x04,0x20,0x7f,0xfe,0x04,0x20,0x1f,0xf8,0x12,0x48,0x1f,0xf8,0x00,0x00,0x3f,0xfe,0x21,0x04,0x43,0xf0,0x0e,0x20,0x31,0x40,0x01,0x80,0x06,0x00,0x38,0x00}}, // 夢
{0x4C35,0x96B3,0xCCB5,0xE784A1,0x7121,{0x08,0x00,0x08,0x00,0x0f,0xfe,0x19,0x48,0x19,0x48,0x29,0x48,0x7f,0xfe,0x09,0x48,0x09,0x48,0x09,0x48,0x7f,0xff,0x00,0x00,0x12,0x48,0x12,0x24,0x21,0x12,0x41,0x12}}, // 無
{0x4C36,0x96B4,0xCCB6,0xE7899F,0x725F,{0x01,0x00,0x01,0x20,0x02,0x18,0x3f,0xf4,0x00,0x82,0x08,0x80,0x08,0x80,0x0f,0xf8,0x10,0x80,0x20,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 牟
{0x4C37,0x96B5,0xCCB7,0xE79F9B,0x77DB,{0x00,0x00,0x1f,0xf8,0x00,0x10,0x03,0x20,0x00,0xc0,0x00,0x40,0x3f,0xfe,0x00,0x42,0x00,0xc4,0x01,0x48,0x02,0x40,0x04,0x40,0x18,0x40,0x60,0x40,0x00,0xc0,0x00,0x40}}, // 矛
{0x4C38,0x96B6,0xCCB8,0xE99CA7,0x9727,{0x00,0x00,0x3f,0xfc,0x01,0x00,0x3f,0xfe,0x21,0x02,0x3d,0x74,0x4f,0x3c,0x01,0x40,0x3f,0x7e,0x0a,0x48,0x04,0xb0,0x7f,0x2e,0x0d,0xfc,0x16,0x24,0x64,0x44,0x0c,0x98}}, // 霧
{0x4C39,0x96B7,0xCCB9,0xE9B5A1,0x9D61,{0x02,0x10,0x3b,0x20,0x02,0xfc,0x02,0x44,0x7f,0xfc,0x02,0x44,0x0a,0x7c,0x2a,0x40,0x2e,0x7f,0x2a,0x40,0x2a,0x7e,0x29,0x0a,0x2f,0x56,0x39,0x56,0x61,0x82,0x00,0x8c}}, // 鵡
{0x4C3A,0x96B8,0xCCBA,0xE6A48B,0x690B,{0x08,0x10,0x08,0x10,0x09,0xff,0x7f,0x00,0x08,0x00,0x08,0x7c,0x1c,0x44,0x1a,0x44,0x19,0x44,0x28,0x7c,0x28,0x10,0x48,0x94,0x08,0x92,0x09,0x11,0x0a,0x31,0x08,0x10}}, // 椋
{0x4C3B,0x96B9,0xCCBB,0xE5A9BF,0x5A7F,{0x08,0x00,0x09,0xff,0x08,0x12,0x08,0x9e,0x7e,0xd0,0x12,0xb0,0x13,0x1f,0x12,0x00,0x22,0xfc,0x7c,0x84,0x44,0xfc,0x06,0x84,0x0a,0xfc,0x12,0x84,0x60,0x84,0x00,0x8c}}, // 婿
{0x4C3C,0x96BA,0xCCBC,0xE5A898,0x5A18,{0x08,0x20,0x08,0x20,0x08,0xfc,0x08,0x84,0x7f,0x84,0x12,0xfc,0x12,0x84,0x12,0x84,0x22,0xfe,0x7c,0x92,0x44,0x94,0x06,0x88,0x0a,0x88,0x10,0xa4,0x60,0xc2,0x03,0x01}}, // 娘
{0x4C3D,0x96BB,0xCCBD,0xE586A5,0x51A5,{0x00,0x00,0x3f,0xfe,0x20,0x04,0x2f,0xf0,0x48,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x01,0x00,0x7f,0xfe,0x00,0x00,0x04,0x60,0x18,0x18,0x60,0x04}}, // 冥
{0x4C3E,0x96BC,0xCCBE,0xE5908D,0x540D,{0x01,0x00,0x01,0x00,0x01,0xf8,0x02,0x08,0x04,0x10,0x0a,0x20,0x11,0x40,0x20,0x80,0x01,0x00,0x07,0xfe,0x1a,0x02,0x62,0x02,0x02,0x02,0x02,0x02,0x03,0xfe,0x02,0x02}}, // 名
{0x4C3F,0x96BD,0xCCBF,0xE591BD,0x547D,{0x00,0x80,0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x1b,0xec,0x60,0x03,0x00,0x00,0x1e,0x7c,0x12,0x44,0x12,0x44,0x12,0x44,0x1e,0x44,0x12,0x58,0x00,0x40,0x00,0x40}}, // 命
{0x4C40,0x96BE,0xCCC0,0xE6988E,0x660E,{0x00,0x00,0x3e,0x7e,0x22,0x42,0x22,0x42,0x22,0x42,0x22,0x7e,0x3e,0x42,0x22,0x42,0x22,0x42,0x22,0x7e,0x22,0x42,0x3e,0x42,0x22,0x82,0x00,0x82,0x01,0x06,0x02,0x02}}, // 明
{0x4C41,0x96BF,0xCCC1,0xE79B9F,0x76DF,{0x00,0x00,0x3e,0x7e,0x22,0x42,0x22,0x7e,0x3e,0x42,0x22,0x7e,0x22,0x42,0x3e,0x42,0x22,0x82,0x01,0x06,0x1f,0xfc,0x12,0x24,0x12,0x24,0x12,0x24,0x7f,0xff,0x00,0x00}}, // 盟
{0x4C42,0x96C0,0xCCC2,0xE8BFB7,0x8FF7,{0x00,0x20,0x21,0x24,0x10,0xa4,0x10,0xa8,0x00,0x20,0x07,0xff,0x00,0x70,0x78,0x70,0x08,0xa8,0x08,0xa8,0x09,0x24,0x0a,0x22,0x08,0x20,0x14,0x20,0x23,0x00,0x40,0xff}}, // 迷
{0x4C43,0x96C1,0xCCC3,0xE98A98,0x9298,{0x08,0x20,0x08,0x20,0x14,0x3c,0x12,0x44,0x20,0x44,0x7f,0xc8,0x09,0x28,0x08,0x10,0x7e,0x20,0x08,0x7e,0x4a,0xc2,0x2d,0x42,0x28,0x42,0x0e,0x42,0x18,0x7e,0x60,0x42}}, // 銘
{0x4C44,0x96C2,0xCCC4,0xE9B3B4,0x9CF4,{0x00,0x20,0x00,0x40,0x79,0xf8,0x49,0x08,0x49,0xf8,0x49,0x08,0x49,0xf8,0x49,0x00,0x49,0xff,0x49,0x00,0x79,0xfe,0x49,0x52,0x02,0xaa,0x02,0xaa,0x04,0x84,0x08,0x18}}, // 鳴
{0x4C45,0x96C3,0xCCC5,0xE5A7AA,0x59EA,{0x08,0x00,0x09,0xff,0x08,0x20,0x08,0x28,0x7e,0x24,0x12,0x4e,0x13,0xf1,0x12,0x00,0x22,0x10,0x7c,0x10,0x44,0xfe,0x06,0x10,0x0a,0x10,0x10,0x10,0x63,0xff,0x00,0x00}}, // 姪
{0x4C46,0x96C4,0xCCC6,0xE7899D,0x725D,{0x04,0x40,0x14,0x40,0x14,0x40,0x14,0x44,0x1f,0x44,0x24,0x48,0x24,0x50,0x44,0x60,0x07,0x40,0x0c,0x40,0x74,0x40,0x04,0x40,0x04,0x42,0x04,0x42,0x04,0x22,0x04,0x1e}}, // 牝
{0x4C47,0x96C5,0xCCC7,0xE6BB85,0x6EC5,{0x10,0x0c,0x08,0x0a,0x08,0x08,0x03,0xff,0x42,0x08,0x23,0xfa,0x22,0x4a,0x03,0x5a,0x0a,0xea,0x0a,0xcc,0x12,0x44,0x12,0xac,0x24,0x95,0x25,0x15,0x46,0x23,0x48,0x41}}, // 滅
{0x4C48,0x96C6,0xCCC8,0xE5858D,0x514D,{0x01,0x00,0x01,0xe0,0x02,0x20,0x04,0x40,0x08,0x80,0x3f,0xfc,0x08,0x84,0x08,0x84,0x08,0x84,0x0f,0xfc,0x01,0x20,0x01,0x20,0x02,0x20,0x04,0x21,0x18,0x11,0x60,0x0f}}, // 免
{0x4C49,0x96C7,0xCCC9,0xE6A389,0x68C9,{0x08,0x10,0x08,0x20,0x08,0xfc,0x7e,0x84,0x08,0xfc,0x08,0x84,0x1c,0x84,0x1a,0xfc,0x1a,0x20,0x29,0xfe,0x29,0x22,0x49,0x22,0x09,0x22,0x09,0x2c,0x08,0x20,0x08,0x20}}, // 棉
{0x4C4A,0x96C8,0xCCCA,0xE7B6BF,0x7DBF,{0x08,0x10,0x08,0x20,0x0a,0x7c,0x72,0x44,0x14,0x7c,0x08,0x44,0x0c,0x44,0x12,0x7c,0x7d,0x10,0x08,0xfe,0x2c,0x92,0x2a,0x92,0x2a,0x92,0x2a,0x9c,0x48,0x10,0x08,0x10}}, // 綿
{0x4C4B,0x96C9,0xCCCB,0xE7B7AC,0x7DEC,{0x08,0x00,0x09,0xff,0x0a,0x20,0x72,0x40,0x15,0xfe,0x09,0x4a,0x0d,0x4a,0x13,0x7a,0x7d,0x4a,0x09,0x4a,0x29,0x7a,0x2d,0x4a,0x2b,0x4a,0x49,0x4a,0x09,0xfe,0x09,0x02}}, // 緬
{0x4C4C,0x96CA,0xCCCC,0xE99DA2,0x9762,{0x00,0x00,0x7f,0xff,0x01,0x00,0x01,0x00,0x02,0x00,0x3f,0xfe,0x22,0x22,0x22,0x22,0x23,0xe2,0x22,0x22,0x23,0xe2,0x22,0x22,0x22,0x22,0x22,0x22,0x3f,0xfe,0x20,0x02}}, // 面
{0x4C4D,0x96CB,0xCCCD,0xE9BABA,0x9EBA,{0x08,0x00,0x09,0xff,0x7f,0x10,0x08,0x20,0x3e,0xfe,0x08,0xaa,0x7f,0xba,0x08,0xaa,0x0e,0xaa,0x12,0xba,0x2a,0xaa,0x44,0xaa,0x0c,0xfe,0x12,0x00,0x21,0x80,0x40,0x7f}}, // 麺
{0x4C4E,0x96CC,0xCCCE,0xE691B8,0x6478,{0x10,0x48,0x10,0x48,0x13,0xff,0x10,0x48,0x7c,0x48,0x10,0xfc,0x10,0x84,0x10,0xfc,0x10,0x84,0x1c,0xfc,0x70,0x20,0x13,0xff,0x10,0x20,0x10,0x50,0x30,0x8c,0x13,0x03}}, // 摸
{0x4C4F,0x96CD,0xCCCF,0xE6A8A1,0x6A21,{0x08,0x48,0x08,0x48,0x0b,0xff,0x7e,0x48,0x08,0x48,0x08,0xfc,0x1c,0x84,0x1a,0xfc,0x1a,0x84,0x28,0xfc,0x28,0x20,0x4b,0xff,0x08,0x20,0x08,0x50,0x08,0x8c,0x0b,0x03}}, // 模
{0x4C50,0x96CE,0xCCD0,0xE88C82,0x8302,{0x04,0x20,0x04,0x20,0x7f,0xff,0x04,0x20,0x04,0xa8,0x00,0x84,0x1f,0xfe,0x10,0x80,0x10,0x84,0x10,0x48,0x10,0x50,0x10,0x20,0x10,0x62,0x21,0x92,0x2e,0x0a,0x40,0x06}}, // 茂
{0x4C51,0x96CF,0xCCD1,0xE5A684,0x5984,{0x00,0x80,0x00,0x80,0x7f,0xff,0x08,0x00,0x08,0x00,0x08,0x00,0x07,0xfc,0x01,0x00,0x01,0x00,0x7f,0xff,0x02,0x10,0x04,0x10,0x0f,0xa0,0x00,0xe0,0x03,0x18,0x3c,0x04}}, // 妄
{0x4C52,0x96D0,0xCCD2,0xE5AD9F,0x5B5F,{0x00,0x00,0x1f,0xf8,0x00,0x10,0x00,0x60,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x01,0x80,0x00,0x00,0x1f,0xfc,0x12,0x24,0x12,0x24,0x12,0x24,0x7f,0xff,0x00,0x00}}, // 孟
{0x4C53,0x96D1,0xCCD3,0xE6AF9B,0x6BDB,{0x00,0x10,0x00,0x60,0x1f,0x80,0x01,0x00,0x01,0x00,0x01,0x1c,0x03,0xe0,0x3d,0x00,0x01,0x00,0x01,0x0f,0x07,0xf0,0x79,0x00,0x01,0x00,0x01,0x02,0x00,0x82,0x00,0x7e}}, // 毛
{0x4C54,0x96D2,0xCCD4,0xE78C9B,0x731B,{0x04,0x00,0x45,0xfc,0x28,0x08,0x10,0x10,0x10,0x20,0x2f,0xff,0x48,0x20,0x08,0x20,0x18,0x60,0x18,0x00,0x2b,0xfe,0x4a,0x52,0x0a,0x52,0x0a,0x52,0x6f,0xff,0x10,0x00}}, // 猛
{0x4C55,0x96D3,0xCCD5,0xE79BB2,0x76F2,{0x00,0x80,0x00,0x80,0x7f,0xff,0x10,0x00,0x10,0x00,0x0f,0xfc,0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 盲
{0x4C56,0x96D4,0xCCD6,0xE7B6B2,0x7DB2,{0x08,0x00,0x09,0xfe,0x0b,0x02,0x73,0x46,0x15,0x2a,0x09,0xfe,0x0d,0x12,0x13,0x12,0x7f,0xfe,0x0b,0x22,0x29,0x22,0x2d,0x22,0x2b,0x1e,0x2b,0x02,0x49,0x06,0x09,0x02}}, // 網
{0x4C57,0x96D5,0xCCD7,0xE88097,0x8017,{0x08,0x04,0x08,0x18,0x7f,0xe0,0x08,0x20,0x08,0x20,0x3e,0x2e,0x08,0xf0,0x7f,0x20,0x08,0x20,0x1c,0x2f,0x1b,0xf0,0x29,0x20,0x48,0x20,0x08,0x22,0x08,0x22,0x08,0x1e}}, // 耗
{0x4C58,0x96D6,0xCCD8,0xE89299,0x8499,{0x02,0x20,0x7f,0xff,0x02,0x20,0x1f,0xfe,0x10,0x04,0x27,0xf0,0x00,0x00,0x7f,0xfe,0x01,0x04,0x06,0xa4,0x39,0x68,0x06,0xd0,0x39,0x48,0x06,0x44,0x78,0x43,0x01,0x80}}, // 蒙
{0x4C59,0x96D7,0xCCD9,0xE584B2,0x5132,{0x08,0x08,0x0b,0x88,0x08,0x3e,0x1f,0xca,0x10,0x0c,0x17,0x8c,0x30,0x7f,0x30,0x10,0x57,0xbe,0x10,0x62,0x17,0xa2,0x14,0xbe,0x14,0xa2,0x14,0xa2,0x17,0xbe,0x14,0xa2}}, // 儲
{0x4C5A,0x96D8,0xCCDA,0xE69CA8,0x6728,{0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x82,0x7f,0xff,0x01,0xc0,0x01,0xc0,0x02,0xa0,0x02,0xa0,0x04,0x90,0x08,0x88,0x10,0x84,0x20,0x82,0x40,0x81,0x00,0x80,0x00,0x80}}, // 木
{0x4C5B,0x96D9,0xCCDB,0xE9BB99,0x9ED9,{0x00,0x10,0x3f,0x14,0x29,0x12,0x3f,0x10,0x29,0xff,0x29,0x10,0x3f,0x28,0x08,0x28,0x3f,0x24,0x08,0x44,0x0e,0x82,0x79,0x01,0x10,0x08,0x14,0x44,0x22,0x22,0x42,0x22}}, // 黙
{0x4C5C,0x96DA,0xCCDC,0xE79BAE,0x76EE,{0x00,0x00,0x1f,0xf8,0x10,0x08,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x08,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x08}}, // 目
{0x4C5D,0x96DB,0xCCDD,0xE69DA2,0x6762,{0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80,0x00,0x00,0x1f,0xfc,0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 杢
{0x4C5E,0x96DC,0xCCDE,0xE58BBF,0x52FF,{0x08,0x00,0x08,0x00,0x08,0x00,0x0f,0xfc,0x12,0x24,0x12,0x24,0x22,0x24,0x44,0x44,0x04,0x44,0x08,0x44,0x10,0x84,0x20,0x84,0x01,0x04,0x02,0x04,0x04,0x08,0x00,0x30}}, // 勿
{0x4C5F,0x96DD,0xCCDF,0xE9A485,0x9905,{0x08,0x42,0x08,0x22,0x14,0x24,0x12,0x00,0x29,0xff,0x7e,0x24,0x22,0x24,0x3e,0x24,0x22,0xff,0x22,0x24,0x3e,0x24,0x28,0x24,0x24,0x24,0x2e,0x44,0x31,0x44,0x60,0x84}}, // 餅
{0x4C60,0x96DE,0xCCE0,0xE5B0A4,0x5C24,{0x01,0x00,0x01,0x10,0x01,0x08,0x01,0x08,0x7f,0xff,0x01,0x00,0x01,0x00,0x01,0x80,0x01,0x40,0x01,0x40,0x01,0x40,0x02,0x40,0x02,0x42,0x04,0x42,0x18,0x42,0x60,0x3e}}, // 尤
{0x4C61,0x96DF,0xCCE1,0xE688BB,0x623B,{0x00,0x00,0x3f,0xff,0x00,0x00,0x1f,0xfc,0x10,0x04,0x10,0x04,0x1f,0xfc,0x10,0x40,0x10,0x40,0x1f,0xff,0x10,0x40,0x10,0xc0,0x20,0xa0,0x21,0x10,0x46,0x08,0x18,0x06}}, // 戻
{0x4C62,0x96E0,0xCCE2,0xE7B1BE,0x7C7E,{0x08,0x00,0x08,0xfe,0x4a,0x12,0x2a,0x12,0x2c,0x92,0x08,0x52,0x7f,0x32,0x08,0x12,0x1c,0x12,0x1a,0x32,0x29,0x2a,0x28,0x2a,0x48,0x42,0x08,0x42,0x08,0x84,0x09,0x18}}, // 籾
{0x4C63,0x96E1,0xCCE3,0xE8B2B0,0x8CB0,{0x09,0x10,0x7f,0xff,0x09,0x10,0x09,0xf0,0x08,0x00,0x0f,0xfc,0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x06,0x30,0x38,0x0c}}, // 貰
{0x4C64,0x96E2,0xCCE4,0xE5958F,0x554F,{0x00,0x00,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x42,0x42,0x42,0x42,0x7e,0x7e,0x40,0x02,0x47,0xe2,0x44,0x22,0x44,0x22,0x44,0x22,0x47,0xe2,0x44,0x22,0x40,0x06,0x40,0x02}}, // 問
{0x4C65,0x96E3,0xCCE5,0xE682B6,0x60B6,{0x00,0x00,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x42,0x42,0x42,0x42,0x7e,0x7e,0x41,0x02,0x42,0x82,0x42,0x92,0x4a,0x0a,0x4a,0x2a,0x4a,0x22,0x51,0xe2,0x40,0x06,0x40,0x02}}, // 悶
{0x4C66,0x96E4,0xCCE6,0xE7B48B,0x7D0B,{0x08,0x10,0x08,0x10,0x0a,0x10,0x73,0xff,0x14,0x44,0x08,0x44,0x0c,0x44,0x12,0x28,0x7d,0x28,0x09,0x10,0x28,0x10,0x2a,0x18,0x29,0x28,0x29,0x44,0x48,0x82,0x0b,0x01}}, // 紋
{0x4C67,0x96E5,0xCCE7,0xE99680,0x9580,{0x00,0x00,0x7e,0x7e,0x42,0x42,0x7e,0x7e,0x42,0x42,0x42,0x42,0x7e,0x7e,0x40,0x02,0x40,0x02,0x40,0x02,0x40,0x02,0x40,0x02,0x40,0x02,0x40,0x02,0x40,0x0e,0x40,0x02}}, // 門
{0x4C68,0x96E6,0xCCE8,0xE58C81,0x5301,{0x08,0x00,0x08,0x00,0x0f,0xfc,0x08,0x84,0x18,0x84,0x14,0x84,0x24,0x84,0x42,0x84,0x01,0x04,0x01,0x84,0x01,0x64,0x02,0x1c,0x04,0x07,0x18,0x04,0x60,0x08,0x00,0x70}}, // 匁
{0x4C69,0x96E7,0xCCE9,0xE4B99F,0x4E5F,{0x00,0x80,0x08,0x80,0x08,0x80,0x08,0x98,0x08,0xe8,0x0f,0x88,0x78,0x88,0x08,0x88,0x08,0x88,0x08,0x88,0x08,0xb0,0x08,0x82,0x08,0x02,0x04,0x02,0x03,0xfe,0x00,0x00}}, // 也
{0x4C6A,0x96E8,0xCCEA,0xE586B6,0x51B6,{0x00,0x40,0x20,0x40,0x10,0x40,0x08,0x90,0x08,0x88,0x01,0x04,0x01,0x3c,0x07,0xc2,0x08,0x02,0x09,0xfc,0x11,0x04,0x11,0x04,0x21,0x04,0x21,0x04,0x41,0xfc,0x01,0x04}}, // 冶
{0x4C6B,0x96E9,0xCCEB,0xE5A49C,0x591C,{0x00,0x80,0x00,0x80,0x7f,0xff,0x02,0x40,0x02,0x40,0x04,0x7c,0x04,0x44,0x08,0xc4,0x18,0xa8,0x29,0x98,0x4a,0x50,0x08,0x20,0x08,0x20,0x08,0x50,0x09,0x8c,0x0e,0x03}}, // 夜
{0x4C6C,0x96EA,0xCCEC,0xE788BA,0x723A,{0x02,0x20,0x0c,0x18,0x32,0x26,0x01,0xc0,0x07,0x60,0x78,0x1f,0x00,0x00,0x7f,0xfe,0x11,0x22,0x1f,0x24,0x11,0x28,0x1f,0x24,0x11,0x22,0x1f,0x32,0x71,0x2c,0x01,0x20}}, // 爺
{0x4C6D,0x96EB,0xCCED,0xE880B6,0x8036,{0x00,0x00,0x7f,0xbe,0x11,0x22,0x11,0x24,0x11,0x24,0x1f,0x28,0x11,0x24,0x11,0x22,0x1f,0x22,0x11,0x21,0x11,0x31,0x11,0xa9,0x1f,0x26,0x71,0x20,0x01,0x20,0x01,0x20}}, // 耶
{0x4C6E,0x96EC,0xCCEE,0xE9878E,0x91CE,{0x00,0x00,0x3f,0xfe,0x29,0x04,0x29,0x48,0x3f,0x30,0x29,0x10,0x29,0xff,0x3f,0x12,0x08,0x14,0x08,0x18,0x7f,0x10,0x08,0x10,0x08,0x10,0x0f,0x10,0x70,0x30,0x00,0x10}}, // 野
{0x4C6F,0x96ED,0xCCEF,0xE5BCA5,0x5F25,{0x00,0x40,0x7c,0x40,0x04,0x40,0x04,0xff,0x04,0x90,0x3d,0x10,0x22,0x10,0x20,0x18,0x3c,0x54,0x24,0x54,0x04,0x92,0x04,0x92,0x05,0x12,0x04,0x10,0x08,0x30,0x30,0x10}}, // 弥
{0x4C70,0x96EE,0xCCF0,0xE79FA2,0x77E2,{0x04,0x00,0x04,0x00,0x07,0xfe,0x08,0x80,0x08,0x80,0x10,0x80,0x20,0x80,0x7f,0xff,0x01,0x40,0x01,0x40,0x02,0x20,0x02,0x20,0x04,0x10,0x08,0x08,0x10,0x04,0x60,0x03}}, // 矢
{0x4C71,0x96EF,0xCCF1,0xE58E84,0x5384,{0x00,0x00,0x1f,0xff,0x10,0x00,0x10,0x00,0x13,0xf8,0x12,0x08,0x12,0x08,0x12,0x08,0x12,0x08,0x12,0x08,0x12,0x30,0x12,0x02,0x22,0x02,0x21,0x02,0x40,0xfe,0x00,0x00}}, // 厄
{0x4C72,0x96F0,0xCCF2,0xE5BDB9,0x5F79,{0x08,0x00,0x08,0xf8,0x10,0x88,0x10,0x89,0x24,0x89,0x44,0x89,0x09,0x07,0x0a,0x00,0x17,0xfc,0x30,0x84,0x50,0x88,0x10,0x50,0x10,0x20,0x10,0x50,0x11,0x8c,0x16,0x03}}, // 役
{0x4C73,0x96F1,0xCCF3,0xE7B484,0x7D04,{0x08,0x40,0x08,0x40,0x0a,0x40,0x72,0x7e,0x14,0x82,0x08,0x82,0x0d,0x02,0x12,0x42,0x7d,0x22,0x09,0x12,0x28,0x12,0x2a,0x02,0x29,0x02,0x29,0x02,0x48,0x04,0x08,0x18}}, // 約
{0x4C74,0x96F2,0xCCF4,0xE896AC,0x85AC,{0x02,0x10,0x7f,0xff,0x02,0x10,0x00,0x82,0x33,0xf2,0x0a,0x14,0x07,0xf8,0x0a,0x16,0x33,0xf1,0x00,0x80,0x7f,0xff,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80}}, // 薬
{0x4C75,0x96F3,0xCCF5,0xE8A8B3,0x8A33,{0x00,0x00,0x3e,0x7e,0x00,0x42,0x7f,0x42,0x00,0x42,0x3e,0x42,0x00,0x7e,0x00,0x52,0x3e,0x50,0x00,0x50,0x3e,0x48,0x22,0x48,0x22,0x84,0x22,0x84,0x3e,0x82,0x21,0x01}}, // 訳
{0x4C76,0x96F4,0xCCF6,0xE8BA8D,0x8E8D,{0x00,0x00,0x3f,0xfe,0x22,0x22,0x22,0xee,0x22,0x22,0x3f,0xfe,0x08,0x44,0x08,0x48,0x28,0xff,0x2f,0x88,0x28,0xfe,0x28,0x88,0x28,0xfe,0x2e,0x88,0x38,0xff,0x60,0x80}}, // 躍
{0x4C77,0x96F5,0xCCF7,0xE99D96,0x9756,{0x00,0x10,0x08,0x10,0x09,0xfe,0x08,0x10,0x7f,0xfc,0x02,0x10,0x23,0xff,0x12,0x00,0x12,0xfc,0x14,0x84,0x14,0xfc,0x0b,0x84,0x1c,0xfc,0x60,0x84,0x00,0x84,0x00,0x8c}}, // 靖
{0x4C78,0x96F6,0xCCF8,0xE69FB3,0x67F3,{0x08,0x20,0x08,0x40,0x09,0x9e,0x7d,0x52,0x09,0x52,0x0d,0x52,0x1b,0x52,0x1b,0x52,0x29,0x52,0x29,0x52,0x49,0x52,0x0b,0xd2,0x0c,0x5c,0x08,0x90,0x08,0x90,0x09,0x10}}, // 柳
{0x4C79,0x96F7,0xCCF9,0xE896AE,0x85AE,{0x04,0x20,0x7f,0xff,0x04,0x20,0x24,0xa0,0x15,0x20,0x7f,0xbf,0x16,0x24,0x25,0x44,0x44,0xa4,0x08,0x14,0x7f,0xd4,0x09,0x08,0x19,0x0c,0x06,0x14,0x19,0x22,0x60,0xc1}}, // 薮
{0x4C7A,0x96F8,0xCCFA,0xE99193,0x9453,{0x08,0x08,0x08,0x3e,0x14,0x2a,0x15,0x3e,0x22,0x88,0x7e,0xff,0x08,0x00,0x08,0x3e,0x7f,0xa2,0x08,0xbe,0x4a,0xa0,0x2c,0xbe,0x28,0xa2,0x0d,0x7e,0x19,0x30,0x62,0x0f}}, // 鑓
{0x4C7B,0x96F9,0xCCFB,0xE68489,0x6109,{0x08,0x20,0x08,0x20,0x08,0x50,0x08,0x48,0x0c,0x84,0x2b,0x7a,0x2a,0x01,0x29,0xea,0x49,0x2a,0x09,0xea,0x09,0x2a,0x09,0xea,0x09,0x2a,0x09,0x22,0x09,0x66,0x09,0x22}}, // 愉
{0x4C7C,0x96FA,0xCCFC,0xE68488,0x6108,{0x00,0x80,0x01,0x40,0x02,0x20,0x0f,0xf8,0x70,0x07,0x1f,0x04,0x11,0x24,0x1f,0x24,0x11,0x24,0x1f,0x24,0x11,0x04,0x13,0x8c,0x02,0x44,0x12,0x42,0x22,0x11,0x41,0xf1}}, // 愈
{0x4C7D,0x96FB,0xCCFD,0xE6B2B9,0x6CB9,{0x10,0x20,0x08,0x20,0x08,0x20,0x00,0x20,0x43,0xfe,0x22,0x22,0x22,0x22,0x02,0x22,0x0a,0x22,0x0b,0xfe,0x12,0x22,0x12,0x22,0x22,0x22,0x22,0x22,0x43,0xfe,0x42,0x02}}, // 油
{0x4C7E,0x96FC,0xCCFE,0xE79992,0x7652,{0x00,0x40,0x0f,0xff,0x08,0x20,0x48,0x50,0x29,0xfc,0x2e,0x03,0x0b,0xd2,0x0a,0x52,0x1b,0xd2,0x2a,0x52,0x4b,0xd2,0x12,0x46,0x11,0x40,0x29,0x24,0x49,0x0a,0x10,0xf9}}, // 癒
{0x4D21,0x9740,0xCDA1,0xE8ABAD,0x8AED,{0x00,0x10,0x3c,0x30,0x00,0x28,0x7e,0x44,0x00,0xfe,0x3d,0x01,0x03,0xe2,0x01,0x2a,0x3d,0x2a,0x01,0xea,0x3d,0x2a,0x25,0x2a,0x25,0xe2,0x25,0x22,0x3d,0x22,0x25,0x66}}, // 諭
{0x4D22,0x9741,0xCDA2,0xE8BCB8,0x8F38,{0x08,0x10,0x08,0x10,0x7f,0x28,0x08,0x44,0x3e,0xfe,0x2b,0x01,0x2a,0xea,0x3e,0xaa,0x2a,0xaa,0x2a,0xea,0x3e,0xaa,0x08,0xaa,0x7f,0xea,0x08,0xaa,0x08,0xa2,0x08,0xa6}}, // 輸
{0x4D23,0x9742,0xCDA3,0xE594AF,0x552F,{0x00,0x44,0x00,0x44,0x3c,0x48,0x24,0xff,0x24,0x88,0x25,0x88,0x26,0x88,0x24,0xfe,0x24,0x88,0x24,0x88,0x24,0xfe,0x3c,0x88,0x24,0x88,0x00,0x88,0x00,0xff,0x00,0x80}}, // 唯
{0x4D24,0x9743,0xCDA4,0xE4BD91,0x4F51,{0x04,0x40,0x04,0x40,0x04,0x40,0x0f,0xff,0x08,0x40,0x10,0x40,0x10,0x80,0x30,0x80,0x51,0xfc,0x11,0x84,0x12,0x84,0x14,0x84,0x10,0x84,0x10,0x84,0x10,0xfc,0x10,0x84}}, // 佑
{0x4D25,0x9744,0xCDA5,0xE584AA,0x512A,{0x04,0x00,0x07,0xff,0x04,0x20,0x09,0xfc,0x09,0x04,0x11,0xfc,0x11,0x04,0x37,0xff,0x54,0xa5,0x12,0x92,0x12,0x7d,0x14,0x89,0x13,0x50,0x10,0x30,0x10,0xcc,0x17,0x03}}, // 優
{0x4D26,0x9745,0xCDA6,0xE58B87,0x52C7,{0x00,0x00,0x1f,0xf0,0x06,0x40,0x01,0x80,0x1f,0xf8,0x11,0x08,0x1f,0xf8,0x11,0x08,0x11,0x08,0x1f,0xf8,0x01,0x00,0x7f,0xfc,0x01,0x04,0x02,0x04,0x0c,0x04,0x70,0x38}}, // 勇
{0x4D27,0x9746,0xCDA7,0xE58F8B,0x53CB,{0x01,0x00,0x01,0x00,0x01,0x02,0x7f,0xff,0x01,0x00,0x01,0x00,0x03,0xf0,0x02,0x10,0x03,0x10,0x05,0x20,0x04,0xa0,0x08,0x40,0x10,0xa0,0x21,0x10,0x46,0x0c,0x18,0x03}}, // 友
{0x4D28,0x9747,0xCDA8,0xE5AEA5,0x5BA5,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x22,0x04,0x42,0x00,0x7f,0xfc,0x02,0x00,0x04,0x00,0x07,0xf0,0x0c,0x10,0x17,0xf0,0x24,0x10,0x47,0xf0,0x04,0x10,0x04,0x30,0x04,0x10}}, // 宥
{0x4D29,0x9748,0xCDA9,0xE5B9BD,0x5E7D,{0x00,0x80,0x24,0x92,0x24,0x92,0x24,0x92,0x25,0x96,0x39,0xe6,0x2e,0x9a,0x22,0x8a,0x24,0x92,0x26,0x9a,0x2a,0xaa,0x2f,0xbe,0x39,0xe6,0x21,0x86,0x3f,0xfe,0x20,0x02}}, // 幽
{0x4D2A,0x9749,0xCDAA,0xE682A0,0x60A0,{0x04,0x20,0x04,0x20,0x08,0x7f,0x0a,0x44,0x12,0xc4,0x33,0x28,0x52,0x10,0x12,0x28,0x10,0x44,0x11,0x83,0x04,0x80,0x14,0x44,0x14,0x42,0x24,0x09,0x42,0x09,0x01,0xf8}}, // 悠
{0x4D2B,0x974A,0xCDAB,0xE68682,0x6182,{0x00,0x00,0x7f,0xfe,0x01,0x00,0x0f,0xe0,0x08,0x20,0x0f,0xe0,0x08,0x20,0x3f,0xfe,0x25,0x04,0x54,0xa8,0x23,0xe4,0x44,0x22,0x0f,0x40,0x30,0xc0,0x07,0x30,0x78,0x0e}}, // 憂
{0x4D2C,0x974B,0xCDAC,0xE68F96,0x63D6,{0x10,0x00,0x11,0xfc,0x11,0x04,0x11,0x04,0x7d,0xfc,0x10,0x00,0x17,0xff,0x11,0x04,0x1d,0xfc,0x71,0x04,0x11,0xfc,0x11,0x07,0x11,0xfc,0x17,0x04,0x10,0x04,0x30,0x04}}, // 揖
{0x4D2D,0x974C,0xCDAD,0xE69C89,0x6709,{0x01,0x00,0x01,0x00,0x7f,0xff,0x02,0x00,0x02,0x00,0x07,0xf8,0x0c,0x08,0x0c,0x08,0x17,0xf8,0x24,0x08,0x44,0x08,0x07,0xf8,0x04,0x08,0x04,0x08,0x04,0x18,0x04,0x08}}, // 有
{0x4D2E,0x974D,0xCDAE,0xE69F9A,0x67DA,{0x08,0x10,0x08,0x10,0x08,0x10,0x7f,0x10,0x08,0xfe,0x08,0x92,0x1c,0x92,0x1a,0x92,0x1a,0x92,0x29,0xfe,0x29,0x92,0x48,0x92,0x08,0x92,0x08,0x92,0x08,0xfe,0x08,0x82}}, // 柚
{0x4D2F,0x974E,0xCDAF,0xE6B9A7,0x6E67,{0x10,0x00,0x0b,0xfc,0x08,0xc8,0x00,0x30,0x41,0xfc,0x21,0x24,0x21,0xfc,0x01,0x24,0x09,0x24,0x09,0xfc,0x10,0x20,0x17,0xfe,0x20,0x22,0x20,0x42,0x41,0x82,0x46,0x0c}}, // 湧
{0x4D30,0x974F,0xCDB0,0xE6B68C,0x6D8C,{0x10,0x00,0x0b,0xfc,0x08,0x08,0x00,0xd0,0x40,0x20,0x23,0xfe,0x22,0x22,0x02,0x22,0x0b,0xfe,0x0a,0x22,0x12,0x22,0x13,0xfe,0x22,0x22,0x22,0x22,0x42,0x22,0x42,0x26}}, // 涌
{0x4D31,0x9750,0xCDB1,0xE78CB6,0x7336,{0x05,0x04,0x44,0x84,0x28,0x88,0x13,0xff,0x10,0x50,0x28,0x50,0x49,0xfe,0x09,0x52,0x19,0x52,0x19,0x9e,0x29,0x02,0x49,0xfe,0x09,0x02,0x09,0x02,0x69,0xfe,0x11,0x02}}, // 猶
{0x4D32,0x9751,0xCDB2,0xE78CB7,0x7337,{0x21,0x10,0x11,0x14,0x12,0x12,0x7f,0xd2,0x0a,0x10,0x0a,0x7f,0x3f,0x90,0x2a,0x90,0x2a,0x90,0x2b,0x90,0x30,0xa8,0x20,0xa8,0x3f,0xa4,0x20,0xc4,0x3f,0xc2,0x20,0x81}}, // 猷
{0x4D33,0x9752,0xCDB3,0xE794B1,0x7531,{0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x3f,0xfc,0x21,0x04,0x21,0x04,0x21,0x04,0x3f,0xfc,0x21,0x04,0x21,0x04,0x21,0x04,0x21,0x04,0x3f,0xfc,0x20,0x04,0x00,0x00}}, // 由
{0x4D34,0x9753,0xCDB4,0xE7A590,0x7950,{0x08,0x20,0x08,0x20,0x08,0x20,0x7f,0xff,0x02,0x20,0x04,0x20,0x04,0x20,0x08,0x40,0x1c,0x7e,0x2a,0xc2,0x48,0xc2,0x09,0x42,0x0a,0x42,0x08,0x42,0x08,0x7e,0x08,0x42}}, // 祐
{0x4D35,0x9754,0xCDB5,0xE8A395,0x88D5,{0x08,0x48,0x08,0x44,0x08,0x44,0x7e,0x92,0x02,0x92,0x04,0x28,0x05,0x28,0x09,0x44,0x1e,0x82,0x2a,0x7d,0x49,0x44,0x08,0x44,0x08,0x44,0x08,0x44,0x08,0x7c,0x08,0x44}}, // 裕
{0x4D36,0x9755,0xCDB6,0xE8AA98,0x8A98,{0x00,0x02,0x3c,0x1c,0x00,0xf0,0x7e,0x10,0x01,0xff,0x3e,0x38,0x00,0x54,0x3e,0x92,0x01,0x11,0x00,0xf8,0x3e,0x28,0x22,0x2e,0x22,0x22,0x22,0x42,0x3e,0x42,0x22,0x8c}}, // 誘
{0x4D37,0x9756,0xCDB7,0xE9818A,0x904A,{0x01,0x08,0x01,0x08,0x21,0x08,0x17,0xff,0x11,0x10,0x01,0x3e,0x01,0xc2,0x79,0x44,0x09,0x48,0x0a,0x7f,0x0a,0x48,0x0c,0x48,0x08,0x48,0x15,0x98,0x23,0x00,0x40,0xff}}, // 遊
{0x4D38,0x9757,0xCDB8,0xE98291,0x9091,{0x00,0x00,0x0f,0xe0,0x08,0x20,0x08,0x20,0x0f,0xe0,0x00,0x00,0x3f,0xf8,0x21,0x08,0x21,0x08,0x21,0x08,0x3f,0xf8,0x20,0x00,0x20,0x00,0x20,0x02,0x10,0x02,0x0f,0xfe}}, // 邑
{0x4D39,0x9758,0xCDB9,0xE983B5,0x90F5,{0x00,0x80,0x03,0x3c,0x3c,0x24,0x04,0x24,0x3f,0xe8,0x14,0xb0,0x14,0xa8,0x7f,0xe4,0x14,0xa2,0x14,0xa2,0x3f,0xe2,0x04,0x32,0x04,0x2c,0x05,0xa0,0x0e,0x20,0x30,0x20}}, // 郵
{0x4D3A,0x9759,0xCDBA,0xE99B84,0x96C4,{0x08,0x24,0x08,0x24,0x08,0x28,0x7f,0xff,0x08,0x48,0x0a,0xc8,0x0b,0x48,0x0a,0x7e,0x12,0x48,0x14,0x48,0x16,0x7e,0x25,0x48,0x29,0x48,0x4e,0xc8,0x38,0xff,0x00,0x40}}, // 雄
{0x4D3B,0x975A,0xCDBB,0xE89E8D,0x878D,{0x00,0x10,0x7f,0x10,0x00,0x10,0x3e,0x7e,0x22,0x52,0x3e,0x52,0x00,0x52,0x7f,0x52,0x55,0x7e,0x55,0x10,0x63,0x10,0x5d,0x14,0x49,0x12,0x49,0x1e,0x49,0xe1,0x4b,0x01}}, // 融
{0x4D3C,0x975B,0xCDBC,0xE5A495,0x5915,{0x01,0x00,0x01,0x00,0x01,0xfc,0x01,0x04,0x02,0x04,0x02,0x04,0x04,0x08,0x0a,0x08,0x11,0x90,0x00,0x50,0x00,0x20,0x00,0x40,0x00,0x80,0x03,0x00,0x0c,0x00,0x30,0x00}}, // 夕
{0x4D3D,0x975C,0xCDBD,0xE4BA88,0x4E88,{0x00,0x00,0x1f,0xf8,0x00,0x10,0x06,0x20,0x01,0x40,0x00,0x80,0x7f,0xfe,0x00,0x82,0x00,0x84,0x00,0x88,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x03,0x80,0x00,0x80}}, // 予
{0x4D3E,0x975D,0xCDBE,0xE4BD99,0x4F59,{0x00,0x80,0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x67,0xfb,0x00,0x80,0x00,0x80,0x3f,0xfe,0x00,0x80,0x04,0x90,0x04,0x88,0x08,0x84,0x11,0x84,0x00,0x80}}, // 余
{0x4D3F,0x975E,0xCDBF,0xE4B88E,0x4E0E,{0x02,0x00,0x02,0x00,0x03,0xfc,0x02,0x00,0x02,0x00,0x03,0xf0,0x00,0x10,0x00,0x10,0x7f,0xff,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x60,0x01,0x80}}, // 与
{0x4D40,0x975F,0xCDC0,0xE8AA89,0x8A89,{0x11,0x08,0x08,0x90,0x7f,0xff,0x08,0x10,0x0b,0xd0,0x08,0x08,0x1f,0xfc,0x10,0x02,0x27,0xe1,0x40,0x00,0x07,0xe0,0x00,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10}}, // 誉
{0x4D41,0x9760,0xCDC1,0xE8BCBF,0x8F3F,{0x04,0x00,0x38,0x9e,0x27,0xf2,0x20,0x82,0x3b,0xee,0x22,0xa2,0x23,0xe2,0x22,0xa2,0x3b,0xee,0x20,0x82,0x27,0xf2,0x20,0x82,0x7f,0xff,0x04,0x30,0x18,0x0c,0x60,0x02}}, // 輿
{0x4D42,0x9761,0xCDC2,0xE9A090,0x9810,{0x00,0x00,0x7f,0xff,0x02,0x10,0x34,0x20,0x08,0x7e,0x08,0x42,0x7f,0x42,0x09,0x7e,0x0a,0x42,0x0c,0x7e,0x08,0x42,0x08,0x42,0x08,0x7e,0x08,0x14,0x18,0x62,0x09,0x81}}, // 預
{0x4D43,0x9762,0xCDC3,0xE582AD,0x50AD,{0x04,0x20,0x07,0xff,0x06,0x10,0x0a,0xfe,0x0a,0x12,0x13,0xff,0x12,0x12,0x32,0xfe,0x52,0x10,0x12,0xfe,0x12,0x92,0x14,0xfe,0x14,0x92,0x18,0xfe,0x10,0x92,0x10,0x96}}, // 傭
{0x4D44,0x9763,0xCDC4,0xE5B9BC,0x5E7C,{0x04,0x20,0x04,0x20,0x04,0x20,0x08,0x20,0x0a,0xfe,0x12,0x22,0x62,0x22,0x14,0x22,0x0c,0x22,0x06,0x22,0x0a,0x22,0x09,0x42,0x13,0x42,0x1c,0x82,0x61,0x04,0x02,0x18}}, // 幼
{0x4D45,0x9764,0xCDC5,0xE5A696,0x5996,{0x08,0x04,0x08,0x18,0x08,0xf0,0x08,0x10,0x7f,0x10,0x12,0x10,0x13,0xff,0x12,0x10,0x22,0x10,0x22,0x10,0x7c,0x28,0x44,0x28,0x0a,0x44,0x12,0x84,0x61,0x02,0x02,0x01}}, // 妖
{0x4D46,0x9765,0xCDC6,0xE5AEB9,0x5BB9,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x24,0x44,0x44,0x20,0x09,0x10,0x11,0x90,0x22,0x40,0x04,0x20,0x18,0x18,0x6f,0xf6,0x08,0x10,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10}}, // 容
{0x4D47,0x9766,0xCDC7,0xE5BAB8,0x5EB8,{0x00,0x80,0x1f,0xff,0x10,0x40,0x17,0xfc,0x10,0x44,0x1f,0xff,0x10,0x44,0x17,0xfc,0x10,0x40,0x17,0xfc,0x14,0x44,0x17,0xfc,0x24,0x44,0x27,0xfc,0x44,0x44,0x04,0x4c}}, // 庸
{0x4D48,0x9767,0xCDC8,0xE68F9A,0x63DA,{0x10,0x00,0x11,0xf8,0x11,0x08,0x11,0xf8,0x7d,0x08,0x11,0x08,0x11,0xf8,0x10,0x00,0x1b,0xff,0x70,0x40,0x11,0xfe,0x16,0x52,0x10,0x92,0x13,0x22,0x10,0x44,0x31,0x98}}, // 揚
{0x4D49,0x9768,0xCDC9,0xE68FBA,0x63FA,{0x10,0x06,0x10,0x18,0x13,0xe2,0x11,0x22,0x7c,0x94,0x10,0x94,0x11,0xfe,0x10,0x20,0x10,0x20,0x1f,0xff,0x70,0x20,0x11,0x22,0x11,0x22,0x11,0x22,0x31,0xfe,0x11,0x02}}, // 揺
{0x4D4A,0x9769,0xCDCA,0xE69381,0x64C1,{0x10,0x40,0x10,0x40,0x17,0xff,0x11,0x12,0x7d,0x14,0x11,0x3f,0x16,0xe4,0x12,0xa4,0x19,0x3e,0x71,0xa4,0x12,0xa4,0x17,0xbe,0x10,0xa4,0x11,0x24,0x11,0x3f,0x32,0x20}}, // 擁
{0x4D4B,0x976A,0xCDCB,0xE69B9C,0x66DC,{0x00,0x00,0x03,0xde,0x78,0x42,0x4b,0xde,0x48,0x42,0x4b,0xde,0x48,0x88,0x78,0x90,0x49,0xfe,0x4b,0x10,0x4d,0xfc,0x49,0x10,0x79,0xfc,0x49,0x10,0x01,0xff,0x01,0x00}}, // 曜
{0x4D4C,0x976B,0xCDCC,0xE6A58A,0x694A,{0x08,0x00,0x08,0x7c,0x08,0x44,0x7f,0x7c,0x08,0x44,0x08,0x44,0x1c,0x7c,0x1a,0x00,0x19,0xff,0x28,0x40,0x28,0xfe,0x49,0x2a,0x0a,0x4a,0x08,0x92,0x08,0x22,0x08,0x4c}}, // 楊
{0x4D4D,0x976C,0xCDCD,0xE6A798,0x69D8,{0x08,0x84,0x08,0x48,0x09,0xfe,0x7e,0x10,0x09,0xfc,0x08,0x10,0x1c,0x10,0x1b,0xff,0x1a,0x12,0x28,0x9c,0x28,0x58,0x48,0x74,0x08,0x92,0x0b,0x11,0x08,0x30,0x08,0x10}}, // 様
{0x4D4E,0x976D,0xCDCE,0xE6B48B,0x6D0B,{0x11,0x04,0x08,0x84,0x08,0x88,0x0b,0xfe,0x40,0x20,0x20,0x20,0x20,0x20,0x21,0xfc,0x08,0x20,0x08,0x20,0x10,0x20,0x17,0xff,0x20,0x20,0x20,0x20,0x40,0x20,0x40,0x20}}, // 洋
{0x4D4F,0x976E,0xCDCF,0xE6BAB6,0x6EB6,{0x10,0x20,0x08,0x20,0x0b,0xfe,0x02,0x02,0x42,0x92,0x20,0x88,0x20,0xa4,0x01,0x24,0x0a,0x50,0x08,0x88,0x11,0x04,0x13,0xfe,0x25,0x05,0x21,0x04,0x41,0xfc,0x41,0x04}}, // 溶
{0x4D50,0x976F,0xCDD0,0xE78694,0x7194,{0x08,0x10,0x08,0x10,0x09,0xff,0x09,0x01,0x0b,0x49,0x2a,0x44,0x2c,0x92,0x29,0x12,0x48,0x28,0x08,0x44,0x0c,0x82,0x0b,0xfd,0x12,0x84,0x10,0x84,0x20,0xfc,0x40,0x84}}, // 熔
{0x4D51,0x9770,0xCDD1,0xE794A8,0x7528,{0x00,0x00,0x1f,0xfc,0x10,0x84,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x84,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x84,0x10,0x84,0x10,0x84,0x20,0x84,0x20,0x8c,0x40,0x84}}, // 用
{0x4D52,0x9771,0xCDD2,0xE7AAAF,0x7AAF,{0x01,0x00,0x7f,0xfe,0x44,0x42,0x04,0x46,0x18,0x3c,0x64,0x20,0x02,0x40,0x3f,0xfe,0x01,0x00,0x1f,0xfc,0x01,0x00,0x7f,0xff,0x00,0x00,0x24,0x48,0x22,0x24,0x42,0x22}}, // 窯
{0x4D53,0x9772,0xCDD3,0xE7BE8A,0x7F8A,{0x04,0x10,0x02,0x10,0x02,0x20,0x3f,0xfe,0x00,0x80,0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 羊
{0x4D54,0x9773,0xCDD4,0xE88080,0x8000,{0x08,0x00,0x09,0xfe,0x4a,0x22,0x2a,0xee,0x2c,0x22,0x09,0xfe,0x7e,0x48,0x14,0x90,0x14,0xfe,0x15,0x90,0x15,0xfe,0x16,0x90,0x14,0xfe,0x24,0x90,0x20,0xff,0x40,0x80}}, // 耀
{0x4D55,0x9774,0xCDD5,0xE89189,0x8449,{0x02,0x10,0x7f,0xff,0x02,0x10,0x04,0x90,0x3f,0xfe,0x04,0x90,0x04,0xf0,0x04,0x00,0x07,0xfc,0x00,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x0c,0x98,0x70,0x87,0x00,0x80}}, // 葉
{0x4D56,0x9775,0xCDD6,0xE89389,0x84C9,{0x04,0x10,0x7f,0xff,0x04,0x90,0x00,0x80,0x3f,0xff,0x22,0x22,0x22,0x90,0x44,0x88,0x09,0x48,0x06,0x30,0x18,0x0c,0x6f,0xfb,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 蓉
{0x4D57,0x9776,0xCDD7,0xE8A681,0x8981,{0x00,0x00,0x7f,0xfe,0x02,0x40,0x02,0x40,0x1f,0xf8,0x12,0x48,0x12,0x48,0x1f,0xf8,0x01,0x00,0x7f,0xff,0x02,0x20,0x04,0x20,0x0f,0x40,0x00,0xe0,0x03,0x18,0x3c,0x04}}, // 要
{0x4D58,0x9777,0xCDD8,0xE8ACA1,0x8B21,{0x00,0x04,0x3c,0x18,0x00,0xe2,0x7e,0x92,0x00,0x54,0x3c,0x48,0x00,0x00,0x00,0xfe,0x3c,0x10,0x00,0x10,0x3f,0xff,0x24,0x10,0x24,0x92,0x24,0x92,0x3c,0xfe,0x24,0x82}}, // 謡
{0x4D59,0x9778,0xCDD9,0xE8B88A,0x8E0A,{0x00,0x00,0x3e,0xfe,0x22,0x04,0x22,0x68,0x22,0x10,0x3e,0xfe,0x08,0x92,0x28,0x92,0x28,0xfe,0x2e,0x92,0x28,0x92,0x28,0xfe,0x28,0x92,0x2e,0x92,0x38,0x92,0x60,0x96}}, // 踊
{0x4D5A,0x9779,0xCDDA,0xE981A5,0x9065,{0x00,0x0c,0x23,0xf0,0x10,0x84,0x12,0x44,0x01,0x48,0x01,0x10,0x03,0xfc,0x78,0x20,0x08,0x20,0x0f,0xfe,0x09,0x24,0x09,0x24,0x15,0xfc,0x13,0x04,0x21,0x80,0x40,0x7f}}, // 遥
{0x4D5B,0x977A,0xCDDB,0xE999BD,0x967D,{0x00,0x00,0x3d,0xf8,0x25,0x08,0x25,0xf8,0x29,0x08,0x31,0x08,0x29,0xf8,0x24,0x00,0x27,0xff,0x24,0x80,0x25,0xfe,0x26,0x52,0x38,0x92,0x21,0x22,0x20,0x44,0x20,0x98}}, // 陽
{0x4D5C,0x977B,0xCDDC,0xE9A48A,0x990A,{0x04,0x10,0x02,0x20,0x3f,0xfe,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x02,0xa0,0x07,0xf0,0x1c,0x1c,0x67,0xf3,0x04,0x10,0x07,0xf4,0x04,0x48,0x07,0xb0,0x38,0x0f}}, // 養
{0x4D5D,0x977C,0xCDDD,0xE685BE,0x617E,{0x12,0x20,0x11,0x20,0x15,0x3f,0x26,0x52,0x09,0x54,0x10,0x90,0x3f,0x18,0x51,0x28,0x11,0x24,0x1f,0x42,0x00,0x81,0x12,0x44,0x12,0x42,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 慾
{0x4D5E,0x977D,0xCDDE,0xE68A91,0x6291,{0x10,0x40,0x10,0x80,0x13,0x3e,0x12,0x22,0x7e,0x22,0x12,0x22,0x12,0x22,0x12,0x22,0x1e,0x22,0x72,0x22,0x12,0x62,0x13,0xa2,0x16,0x2c,0x10,0x20,0x30,0x20,0x10,0x20}}, // 抑
{0x4D5F,0x977E,0xCDDF,0xE6ACB2,0x6B32,{0x0a,0x20,0x0a,0x20,0x09,0x20,0x11,0x3f,0x15,0x52,0x24,0x54,0x0a,0x98,0x0a,0x10,0x11,0x10,0x20,0x90,0x5f,0x28,0x11,0x28,0x11,0x24,0x11,0x44,0x1f,0x82,0x11,0x01}}, // 欲
{0x4D60,0x9780,0xCDE0,0xE6B283,0x6C83,{0x10,0x04,0x08,0x18,0x0b,0xe0,0x00,0x20,0x00,0x20,0x40,0x20,0x27,0xff,0x20,0x20,0x08,0x30,0x08,0x50,0x10,0x50,0x10,0x88,0x20,0x88,0x21,0x04,0x42,0x02,0x44,0x01}}, // 沃
{0x4D61,0x9781,0xCDE1,0xE6B5B4,0x6D74,{0x10,0x88,0x08,0x84,0x09,0x04,0x01,0x22,0x42,0x22,0x20,0x50,0x20,0x50,0x00,0x88,0x09,0x04,0x0b,0xfe,0x15,0x05,0x11,0x04,0x21,0x04,0x21,0x04,0x41,0xfc,0x41,0x04}}, // 浴
{0x4D62,0x9782,0xCDE2,0xE7BF8C,0x7FCC,{0x00,0x00,0x7f,0xfe,0x11,0x22,0x09,0x12,0x03,0x06,0x05,0x0a,0x19,0x32,0x03,0x86,0x00,0x80,0x1f,0xfc,0x04,0x10,0x02,0x10,0x02,0x20,0x02,0x20,0x7f,0xff,0x00,0x00}}, // 翌
{0x4D63,0x9783,0xCDE3,0xE7BFBC,0x7FFC,{0x00,0x00,0x7f,0xfe,0x11,0x22,0x0b,0x16,0x0d,0x1a,0x31,0x62,0x03,0x06,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x08,0x88,0x1f,0xfc,0x02,0x20,0x7f,0xff,0x04,0x18,0x18,0x04}}, // 翼
{0x4D64,0x9784,0xCDE4,0xE6B780,0x6DC0,{0x10,0x20,0x08,0x20,0x09,0xff,0x01,0x02,0x42,0x00,0x21,0xfe,0x20,0x20,0x00,0x20,0x09,0x20,0x09,0x3e,0x11,0x20,0x11,0x20,0x22,0xa0,0x22,0x60,0x44,0x30,0x48,0x0f}}, // 淀
{0x4D65,0x9785,0xCDE5,0xE7BE85,0x7F85,{0x00,0x00,0x3f,0xfe,0x22,0x22,0x22,0x22,0x3f,0xfe,0x08,0x24,0x08,0x28,0x72,0x7f,0x14,0xc8,0x0a,0x7e,0x7d,0x48,0x08,0x7e,0x2a,0x48,0x29,0x48,0x49,0x7f,0x08,0x40}}, // 羅
{0x4D66,0x9786,0xCDE6,0xE89EBA,0x87BA,{0x08,0x00,0x08,0xfe,0x08,0x92,0x3e,0xfe,0x2a,0x92,0x2a,0xfe,0x2a,0x10,0x2a,0x24,0x3e,0xe8,0x08,0x18,0x0c,0x26,0x0b,0xfd,0x0a,0x94,0x0e,0x92,0x71,0x12,0x00,0x10}}, // 螺
{0x4D67,0x9787,0xCDE7,0xE8A3B8,0x88F8,{0x08,0x00,0x08,0xfe,0x08,0x92,0x7e,0x92,0x02,0xfe,0x04,0x92,0x04,0x92,0x0a,0xfe,0x1a,0x10,0x2d,0xff,0x4a,0x38,0x09,0x54,0x08,0x92,0x0b,0x11,0x08,0x10,0x08,0x10}}, // 裸
{0x4D68,0x9788,0xCDE8,0xE69DA5,0x6765,{0x00,0x80,0x00,0x80,0x3f,0xfe,0x00,0x88,0x08,0x88,0x04,0x90,0x04,0xa0,0x7f,0xff,0x00,0x80,0x01,0xc0,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80,0x00,0x80}}, // 来
{0x4D69,0x9789,0xCDE9,0xE88EB1,0x83B1,{0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x00,0x80,0x3f,0xfe,0x08,0x88,0x04,0x90,0x04,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80}}, // 莱
{0x4D6A,0x978A,0xCDEA,0xE9A0BC,0x983C,{0x08,0x00,0x08,0xff,0x7f,0x10,0x08,0x20,0x08,0x7e,0x3f,0x42,0x29,0x7e,0x29,0x42,0x3f,0x42,0x28,0x7e,0x1c,0x42,0x1a,0x42,0x29,0x7e,0x28,0x24,0x48,0x42,0x09,0x81}}, // 頼
{0x4D6B,0x978B,0xCDEB,0xE99BB7,0x96F7,{0x00,0x00,0x3f,0xfc,0x01,0x00,0x3f,0xfe,0x21,0x02,0x3f,0x7c,0x41,0x00,0x1f,0x78,0x00,0x00,0x3f,0xfc,0x21,0x04,0x21,0x04,0x3f,0xfc,0x21,0x04,0x3f,0xfc,0x20,0x04}}, // 雷
{0x4D6C,0x978C,0xCDEC,0xE6B49B,0x6D1B,{0x10,0x80,0x08,0x80,0x08,0xf8,0x01,0x08,0x41,0x88,0x22,0x50,0x24,0x20,0x00,0x50,0x08,0x88,0x09,0x04,0x13,0xfb,0x15,0x08,0x21,0x08,0x21,0x08,0x41,0xf8,0x41,0x08}}, // 洛
{0x4D6D,0x978D,0xCDED,0xE7B5A1,0x7D61,{0x08,0x20,0x08,0x20,0x12,0x7c,0x64,0x44,0x14,0xc8,0x09,0x28,0x0c,0x10,0x12,0x28,0x7d,0x44,0x08,0x82,0x2d,0xfd,0x2a,0x84,0x2a,0x84,0x2a,0x84,0x48,0xfc,0x08,0x84}}, // 絡
{0x4D6E,0x978E,0xCDEE,0xE890BD,0x843D,{0x02,0x20,0x02,0x20,0x7f,0xff,0x02,0xa0,0x10,0x80,0x08,0xfc,0x08,0x88,0x41,0x50,0x22,0x20,0x20,0xd8,0x09,0x04,0x0f,0xff,0x11,0x04,0x11,0x04,0x21,0xfc,0x21,0x04}}, // 落
{0x4D6F,0x978F,0xCDEF,0xE985AA,0x916A,{0x00,0x20,0x7f,0xa0,0x0c,0x3c,0x0c,0x24,0x3f,0x44,0x2d,0xa8,0x2d,0x18,0x35,0x18,0x37,0x24,0x21,0x42,0x21,0xfd,0x3f,0x44,0x21,0x44,0x21,0x44,0x3f,0x7c,0x21,0x44}}, // 酪
{0x4D70,0x9790,0xCDF0,0xE4B9B1,0x4E71,{0x01,0x20,0x06,0x20,0x38,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x7f,0xa0,0x08,0x20,0x08,0x20,0x08,0x20,0x3f,0x20,0x21,0x20,0x21,0x20,0x21,0x21,0x3f,0x21,0x21,0x1f}}, // 乱
{0x4D71,0x9791,0xCDF1,0xE58DB5,0x5375,{0x02,0x00,0x04,0x00,0x18,0x3e,0x11,0x22,0x11,0x22,0x11,0x22,0x19,0x32,0x15,0x2a,0x15,0x2a,0x11,0x22,0x11,0x22,0x1f,0x22,0x62,0x2c,0x02,0x20,0x04,0x20,0x08,0x20}}, // 卵
{0x4D72,0x9792,0xCDF2,0xE5B590,0x5D50,{0x11,0x08,0x11,0x08,0x1f,0xf8,0x00,0x00,0x1f,0xf8,0x10,0x28,0x1f,0xc8,0x11,0x08,0x17,0xe8,0x15,0x28,0x15,0x28,0x17,0xe8,0x11,0x44,0x21,0x25,0x2f,0xd3,0x40,0x11}}, // 嵐
{0x4D73,0x9793,0xCDF3,0xE6AC84,0x6B04,{0x10,0x00,0x13,0xde,0x12,0x52,0x7f,0xde,0x12,0x52,0x13,0xde,0x3a,0x22,0x37,0xfe,0x52,0xaa,0x52,0xfa,0x12,0xaa,0x12,0xfa,0x12,0x72,0x12,0xaa,0x13,0x22,0x12,0x26}}, // 欄
{0x4D74,0x9794,0xCDF4,0xE6BFAB,0x6FEB,{0x20,0x10,0x17,0xd0,0x15,0x10,0x07,0xdf,0x04,0x60,0x47,0xc0,0x25,0x1e,0x25,0x00,0x0f,0xc0,0x08,0x00,0x13,0xfc,0x12,0x94,0x22,0x94,0x22,0x94,0x4f,0xff,0x40,0x00}}, // 濫
{0x4D75,0x9795,0xCDF5,0xE8978D,0x85CD,{0x02,0x10,0x7f,0xff,0x02,0x10,0x3f,0x90,0x24,0x3f,0x3f,0x20,0x21,0x40,0x3f,0xbe,0x24,0x00,0x3f,0x80,0x00,0x00,0x1f,0xfc,0x12,0x24,0x12,0x24,0x7f,0xff,0x00,0x00}}, // 藍
{0x4D76,0x9796,0xCDF6,0xE898AD,0x862D,{0x04,0x20,0x7f,0xff,0x04,0x20,0x3e,0x7e,0x22,0x42,0x3e,0x7e,0x3e,0x7e,0x20,0x82,0x2f,0xfa,0x24,0x92,0x27,0xf2,0x24,0x92,0x27,0xf2,0x22,0xa2,0x24,0x92,0x20,0x06}}, // 蘭
{0x4D77,0x9797,0xCDF7,0xE8A6A7,0x89A7,{0x3f,0x90,0x24,0x1f,0x3f,0x20,0x21,0x40,0x3f,0x3e,0x24,0x00,0x3f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x02,0x21,0x0c,0x21,0x70,0x1f}}, // 覧
{0x4D78,0x9798,0xCDF8,0xE588A9,0x5229,{0x00,0x82,0x03,0x22,0x3c,0x22,0x04,0x22,0x04,0x22,0x04,0x22,0x7f,0xa2,0x0c,0x22,0x0e,0x22,0x15,0x22,0x14,0xa2,0x24,0xa2,0x44,0x02,0x04,0x02,0x04,0x06,0x04,0x02}}, // 利
{0x4D79,0x9799,0xCDF9,0xE5908F,0x540F,{0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x1f,0xf8,0x10,0x88,0x10,0x88,0x10,0x88,0x1f,0xf8,0x14,0x88,0x02,0x80,0x01,0x00,0x01,0x80,0x02,0x60,0x0c,0x18,0x70,0x06}}, // 吏
{0x4D7A,0x979A,0xCDFA,0xE5B1A5,0x5C65,{0x00,0x00,0x1f,0xfe,0x10,0x02,0x1f,0xfe,0x12,0x40,0x12,0x7e,0x14,0x84,0x19,0xfc,0x12,0x84,0x12,0xfc,0x14,0x20,0x1c,0x7c,0x25,0xc8,0x24,0x30,0x44,0x4c,0x07,0x83}}, // 履
{0x4D7B,0x979B,0xCDFB,0xE69D8E,0x674E,{0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x0c,0x98,0x70,0x87,0x00,0x80,0x0f,0xf0,0x00,0x20,0x00,0xc0,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x01,0x80}}, // 李
{0x4D7C,0x979C,0xCDFC,0xE6A2A8,0x68A8,{0x03,0x02,0x3c,0x22,0x04,0x22,0x7f,0xa2,0x04,0x22,0x0e,0x22,0x15,0x22,0x64,0x06,0x04,0x82,0x04,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x0c,0x98,0x70,0x87,0x00,0x80}}, // 梨
{0x4D7D,0x979D,0xCDFD,0xE79086,0x7406,{0x00,0x00,0x01,0xfe,0x7f,0x22,0x11,0x22,0x11,0xfe,0x11,0x22,0x7d,0x22,0x11,0x22,0x11,0xfe,0x10,0x20,0x14,0x20,0x19,0xfe,0x60,0x20,0x00,0x20,0x07,0xff,0x00,0x00}}, // 理
{0x4D7E,0x979E,0xCDFE,0xE79283,0x7483,{0x00,0x20,0x00,0x20,0x7f,0xff,0x10,0x10,0x11,0xd4,0x11,0x24,0x7d,0x54,0x11,0x8c,0x11,0xfc,0x10,0x20,0x13,0xfe,0x1e,0x32,0x72,0x4a,0x03,0xf6,0x02,0x02,0x02,0x06}}, // 璃
{0x4E21,0x979F,0xCEA1,0xE797A2,0x75E2,{0x00,0x40,0x00,0x40,0x0f,0xff,0x48,0x00,0x28,0x42,0x2f,0x92,0x09,0x12,0x09,0x12,0x1f,0xd2,0x29,0x12,0x4b,0x92,0x13,0x52,0x15,0x12,0x29,0x02,0x41,0x06,0x01,0x02}}, // 痢
{0x4E22,0x97A0,0xCEA2,0xE8A38F,0x88CF,{0x00,0x80,0x3f,0xfe,0x00,0x00,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x02,0x42,0x7c,0x24,0x07,0x98,0x1c,0x07}}, // 裏
{0x4E23,0x97A1,0xCEA3,0xE8A3A1,0x88E1,{0x08,0x00,0x08,0xfe,0x08,0x92,0x7e,0x92,0x02,0xfe,0x04,0x92,0x08,0x92,0x09,0xfe,0x1a,0x10,0x2c,0x10,0x4a,0xfe,0x09,0x10,0x08,0x10,0x08,0x10,0x0b,0xff,0x08,0x00}}, // 裡
{0x4E24,0x97A2,0xCEA4,0xE9878C,0x91CC,{0x00,0x00,0x1f,0xfc,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x84,0x10,0x84,0x10,0x84,0x1f,0xfc,0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 里
{0x4E25,0x97A3,0xCEA5,0xE99BA2,0x96E2,{0x08,0x24,0x08,0x24,0x7f,0x48,0x26,0x7f,0x3a,0xc8,0x2b,0x48,0x36,0x48,0x3e,0x7e,0x08,0x48,0x7f,0x48,0x49,0x7e,0x55,0x48,0x7b,0x48,0x41,0x48,0x41,0x7f,0x43,0x40}}, // 離
{0x4E26,0x97A4,0xCEA6,0xE999B8,0x9678,{0x00,0x20,0x3c,0x20,0x25,0xfc,0x24,0x20,0x24,0x20,0x2b,0xff,0x30,0x90,0x28,0x92,0x25,0x2e,0x22,0x20,0x22,0x20,0x23,0xfe,0x3c,0x20,0x20,0x20,0x23,0xff,0x20,0x00}}, // 陸
{0x4E27,0x97A5,0xCEA7,0xE5BE8B,0x5F8B,{0x08,0x20,0x08,0x20,0x13,0xfc,0x10,0x24,0x24,0x24,0x47,0xff,0x08,0x24,0x08,0x24,0x13,0xfc,0x10,0x20,0x33,0xfc,0x50,0x20,0x10,0x20,0x17,0xff,0x10,0x20,0x10,0x20}}, // 律
{0x4E28,0x97A6,0xCEA8,0xE78E87,0x7387,{0x00,0x80,0x00,0x80,0x3f,0xfe,0x10,0x84,0x0b,0x28,0x05,0x40,0x00,0x90,0x0d,0x2c,0x33,0xf2,0x00,0x90,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 率
{0x4E29,0x97A7,0xCEA9,0xE7AB8B,0x7ACB,{0x00,0x80,0x00,0x80,0x00,0x80,0x3f,0xfe,0x00,0x10,0x08,0x10,0x08,0x10,0x04,0x10,0x04,0x10,0x04,0x20,0x02,0x20,0x02,0x20,0x02,0x40,0x00,0x40,0x7f,0xff,0x00,0x00}}, // 立
{0x4E2A,0x97A8,0xCEAA,0xE8918E,0x844E,{0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x10,0x08,0x20,0x09,0xfc,0x10,0x24,0x27,0xff,0x44,0x24,0x09,0xfc,0x10,0x20,0x31,0xfe,0x50,0x20,0x17,0xff,0x10,0x20,0x10,0x20}}, // 葎
{0x4E2B,0x97A9,0xCEAB,0xE68EA0,0x63A0,{0x10,0x20,0x10,0x20,0x10,0x20,0x17,0xff,0x7c,0x00,0x11,0xfc,0x11,0x04,0x11,0x04,0x1d,0xfc,0x70,0x20,0x11,0x28,0x11,0x24,0x11,0x22,0x12,0x22,0x34,0x60,0x10,0x20}}, // 掠
{0x4E2C,0x97AA,0xCEAC,0xE795A5,0x7565,{0x00,0x40,0x00,0x40,0x7c,0x7c,0x54,0x84,0x54,0x88,0x55,0x50,0x56,0x30,0x7c,0x48,0x54,0x84,0x55,0x02,0x56,0xfd,0x54,0x84,0x7c,0x84,0x44,0x84,0x40,0xfc,0x00,0x84}}, // 略
{0x4E2D,0x97AB,0xCEAD,0xE58A89,0x5289,{0x08,0x02,0x33,0xc2,0x21,0x52,0x29,0x52,0x3a,0x52,0x65,0xd2,0x04,0x12,0x0b,0x12,0x10,0xd2,0x7f,0x12,0x04,0x12,0x7f,0xd2,0x04,0x82,0x25,0x02,0x17,0x82,0x78,0x06}}, // 劉
{0x4E2E,0x97AC,0xCEAE,0xE6B581,0x6D41,{0x10,0x20,0x08,0x20,0x0f,0xff,0x00,0x50,0x00,0x48,0x40,0x84,0x23,0xfa,0x20,0x02,0x09,0x48,0x09,0x48,0x11,0x48,0x11,0x48,0x22,0x48,0x22,0x49,0x44,0x09,0x48,0x07}}, // 流
{0x4E2F,0x97AD,0xCEAF,0xE6BA9C,0x6E9C,{0x10,0x40,0x0b,0xbe,0x0a,0x0a,0x02,0x8a,0x02,0x52,0x42,0x52,0x23,0xec,0x26,0x40,0x01,0xfc,0x09,0x24,0x09,0x24,0x11,0xfc,0x11,0x24,0x21,0x24,0x21,0xfc,0x41,0x04}}, // 溜
{0x4E30,0x97AE,0xCEB0,0xE79089,0x7409,{0x00,0x20,0x7c,0x20,0x13,0xff,0x10,0x20,0x10,0x58,0x10,0x8c,0x7d,0xf2,0x10,0x00,0x10,0xa4,0x10,0xa4,0x12,0xa4,0x1c,0xa4,0x70,0xa4,0x01,0x25,0x01,0x05,0x02,0x03}}, // 琉
{0x4E31,0x97AF,0xCEB1,0xE79599,0x7559,{0x06,0x00,0x38,0xfe,0x20,0x12,0x24,0x12,0x22,0x12,0x26,0x22,0x39,0x42,0x60,0x8c,0x1f,0xf8,0x11,0x08,0x11,0x08,0x1f,0xf8,0x11,0x08,0x11,0x08,0x1f,0xf8,0x10,0x08}}, // 留
{0x4E32,0x97B0,0xCEB2,0xE7A1AB,0x786B,{0x00,0x20,0x7e,0x20,0x09,0xff,0x08,0x20,0x08,0x58,0x10,0x8c,0x1f,0xf2,0x32,0x00,0x32,0xa4,0x52,0xa4,0x12,0xa4,0x12,0xa4,0x1e,0xa4,0x11,0x25,0x11,0x05,0x02,0x03}}, // 硫
{0x4E33,0x97B1,0xCEB3,0xE7B292,0x7C92,{0x08,0x20,0x0a,0x20,0x4a,0x20,0x2b,0xfe,0x2c,0x00,0x08,0x84,0x7f,0x84,0x08,0x84,0x1c,0x44,0x1a,0x48,0x2a,0x48,0x28,0x48,0x48,0x50,0x08,0x10,0x09,0xff,0x08,0x00}}, // 粒
{0x4E34,0x97B2,0xCEB4,0xE99A86,0x9686,{0x00,0x40,0x3c,0x40,0x24,0xfc,0x25,0x08,0x2a,0x90,0x34,0x60,0x28,0xd8,0x27,0x87,0x24,0xa0,0x25,0xfe,0x26,0x20,0x25,0xfc,0x38,0x20,0x20,0x20,0x23,0xff,0x20,0x00}}, // 隆
{0x4E35,0x97B3,0xCEB5,0xE7AB9C,0x7ADC,{0x00,0x80,0x00,0x80,0x1f,0xfc,0x04,0x10,0x02,0x20,0x7f,0xff,0x00,0x00,0x0f,0xf8,0x08,0x88,0x08,0x88,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x08,0x8a,0x00,0x82,0x00,0x7e}}, // 竜
{0x4E36,0x97B4,0xCEB6,0xE9BE8D,0x9F8D,{0x04,0x20,0x04,0x20,0x3f,0xbf,0x11,0x20,0x0a,0x3e,0x7f,0xc2,0x00,0x3e,0x1f,0x20,0x11,0x3e,0x1f,0x20,0x11,0x3e,0x1f,0x20,0x11,0x3e,0x11,0x21,0x11,0x11,0x13,0x0f}}, // 龍
{0x4E37,0x97B5,0xCEB7,0xE4BEB6,0x4FB6,{0x04,0x00,0x05,0xfc,0x05,0x04,0x09,0x04,0x09,0x04,0x11,0xfc,0x11,0x24,0x30,0x20,0x50,0x40,0x13,0xfe,0x12,0x02,0x12,0x02,0x12,0x02,0x12,0x02,0x13,0xfe,0x12,0x02}}, // 侶
{0x4E38,0x97B6,0xCEB8,0xE685AE,0x616E,{0x00,0x80,0x00,0xfc,0x00,0x80,0x1f,0xff,0x10,0x9a,0x1f,0xe0,0x10,0x82,0x17,0xfe,0x14,0x48,0x17,0xf8,0x14,0x48,0x17,0xf8,0x2a,0x44,0x2a,0x2a,0x52,0x09,0x21,0xf9}}, // 慮
{0x4E39,0x97B7,0xCEB9,0xE69785,0x65C5,{0x08,0x40,0x08,0x40,0x08,0x40,0x7f,0x7f,0x08,0x90,0x08,0x92,0x09,0x22,0x0f,0x34,0x09,0x74,0x09,0xa8,0x09,0x28,0x11,0x24,0x11,0x24,0x21,0x22,0x41,0x21,0x06,0x20}}, // 旅
{0x4E3A,0x97B8,0xCEBA,0xE8999C,0x865C,{0x00,0x80,0x00,0xfe,0x00,0x80,0x1f,0xff,0x10,0x9a,0x1f,0xe0,0x10,0x82,0x17,0xfe,0x14,0x48,0x17,0xf8,0x14,0x48,0x17,0xf8,0x2f,0xfe,0x20,0x82,0x43,0x02,0x0c,0x0c}}, // 虜
{0x4E3B,0x97B9,0xCEBB,0xE4BA86,0x4E86,{0x00,0x00,0x3f,0xfc,0x00,0x08,0x00,0x10,0x00,0x20,0x00,0xc0,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x03,0x80,0x00,0x80}}, // 了
{0x4E3C,0x97BA,0xCEBC,0xE4BAAE,0x4EAE,{0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x00,0x00,0x3f,0xfe,0x20,0x04,0x22,0x40,0x42,0x40,0x02,0x40,0x04,0x41,0x18,0x21,0x60,0x1f}}, // 亮
{0x4E3D,0x97BB,0xCEBD,0xE5839A,0x50DA,{0x04,0x20,0x04,0x20,0x07,0xff,0x08,0x50,0x0a,0x8a,0x11,0x04,0x13,0xfe,0x35,0x05,0x51,0xfc,0x11,0x04,0x11,0xfc,0x10,0x28,0x11,0x24,0x12,0x22,0x14,0x62,0x10,0x20}}, // 僚
{0x4E3E,0x97BC,0xCEBE,0xE4B8A1,0x4E21,{0x00,0x00,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x3f,0xfe,0x20,0x82,0x24,0x92,0x24,0x92,0x24,0x92,0x24,0x92,0x27,0xf2,0x24,0x12,0x20,0x02,0x20,0x06,0x20,0x02}}, // 両
{0x4E3F,0x97BD,0xCEBF,0xE5878C,0x51CC,{0x00,0x20,0x20,0x20,0x13,0xfe,0x10,0x20,0x00,0x20,0x07,0xff,0x00,0x90,0x08,0x92,0x09,0x4e,0x12,0x78,0x14,0x88,0x21,0x90,0x26,0x50,0x40,0x60,0x41,0x98,0x06,0x07}}, // 凌
{0x4E40,0x97BE,0xCEC0,0xE5AFAE,0x5BEE,{0x01,0x00,0x7f,0xfe,0x41,0x02,0x01,0x00,0x7f,0xfe,0x22,0x44,0x14,0x28,0x1f,0xf8,0x68,0x16,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x05,0x60,0x19,0x18,0x61,0x04,0x03,0x00}}, // 寮
{0x4E41,0x97BF,0xCEC1,0xE69699,0x6599,{0x08,0x04,0x49,0x44,0x29,0x24,0x2a,0x14,0x0c,0x14,0x7f,0x84,0x08,0x44,0x0c,0x24,0x1a,0x24,0x19,0x07,0x29,0x3c,0x28,0xc4,0x48,0x04,0x08,0x04,0x08,0x04,0x08,0x04}}, // 料
{0x4E42,0x97C0,0xCEC2,0xE6A281,0x6881,{0x00,0x00,0x37,0xf8,0x08,0x48,0x02,0x4a,0x62,0x49,0x14,0x89,0x01,0x08,0x0a,0x30,0x30,0x80,0x40,0x80,0x7f,0xff,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80}}, // 梁
{0x4E43,0x97C1,0xCEC3,0xE6B6BC,0x6DBC,{0x10,0x20,0x08,0x20,0x0f,0xff,0x00,0x00,0x40,0x00,0x21,0xfc,0x21,0x04,0x01,0x04,0x09,0x04,0x09,0xfc,0x10,0x20,0x11,0x28,0x21,0x24,0x22,0x22,0x44,0x22,0x40,0x60}}, // 涼
{0x4E44,0x97C2,0xCEC4,0xE78C9F,0x731F,{0x04,0x44,0x46,0x24,0x29,0x28,0x11,0x10,0x11,0xfc,0x29,0x24,0x49,0x24,0x09,0xfc,0x19,0x24,0x19,0x24,0x29,0xfc,0x49,0x24,0x09,0x24,0x0a,0x25,0x6a,0x25,0x14,0x23}}, // 猟
{0x4E45,0x97C3,0xCEC5,0xE79982,0x7642,{0x00,0x40,0x00,0x40,0x0f,0xff,0x48,0x40,0x2f,0xfe,0x2a,0x94,0x09,0x08,0x0b,0xfc,0x1d,0x0a,0x29,0xf9,0x49,0x08,0x09,0xf8,0x11,0x58,0x12,0x44,0x2c,0x42,0x40,0xc0}}, // 療
{0x4E46,0x97C4,0xCEC6,0xE79EAD,0x77AD,{0x00,0x20,0x78,0x20,0x4f,0xff,0x48,0x50,0x4a,0x8a,0x79,0x04,0x4b,0xfe,0x4d,0x05,0x79,0xfc,0x49,0x04,0x49,0xfc,0x48,0x28,0x79,0x24,0x4a,0x22,0x04,0x62,0x00,0x20}}, // 瞭
{0x4E47,0x97C5,0xCEC7,0xE7A89C,0x7A1C,{0x02,0x20,0x0c,0x20,0x79,0xfe,0x08,0x20,0x0b,0xff,0x7e,0x50,0x08,0x52,0x1c,0x8e,0x1b,0x40,0x2a,0x78,0x28,0x88,0x4b,0x50,0x08,0x20,0x08,0x50,0x09,0x8c,0x0e,0x03}}, // 稜
{0x4E48,0x97C6,0xCEC8,0xE7B3A7,0x7CE7,{0x08,0x00,0x4a,0xfc,0x2a,0x84,0x2c,0xfc,0x08,0x84,0x7f,0xff,0x08,0x00,0x08,0xfc,0x1c,0xa4,0x1a,0xfc,0x2a,0xa4,0x28,0xfc,0x48,0x20,0x09,0xfe,0x08,0x20,0x0f,0xff}}, // 糧
{0x4E49,0x97C7,0xCEC9,0xE889AF,0x826F,{0x01,0x00,0x01,0x00,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf4,0x09,0x04,0x08,0x88,0x08,0x50,0x08,0x20,0x0b,0x10,0x0c,0x0c,0x70,0x03}}, // 良
{0x4E4A,0x97C8,0xCECA,0xE8AB92,0x8AD2,{0x00,0x10,0x3e,0x10,0x01,0xff,0x7f,0x00,0x00,0x00,0x3e,0x7c,0x00,0x44,0x00,0x44,0x3e,0x44,0x00,0x7c,0x3e,0x10,0x22,0x58,0x22,0x54,0x22,0x92,0x3f,0x32,0x22,0x10}}, // 諒
{0x4E4B,0x97C9,0xCECB,0xE981BC,0x907C,{0x00,0x20,0x20,0x20,0x17,0xff,0x12,0x4a,0x01,0x84,0x01,0xfe,0x02,0x85,0x7c,0xfc,0x08,0x84,0x08,0xfc,0x09,0x24,0x09,0x22,0x0a,0x22,0x14,0x60,0x23,0x00,0x40,0xff}}, // 遼
{0x4E4C,0x97CA,0xCECC,0xE9878F,0x91CF,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x7f,0xff,0x00,0x00,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff}}, // 量
{0x4E4D,0x97CB,0xCECD,0xE999B5,0x9675,{0x00,0x20,0x3c,0x20,0x25,0xfe,0x24,0x20,0x27,0xff,0x28,0x50,0x30,0x52,0x28,0x8e,0x27,0x40,0x24,0x78,0x24,0x88,0x27,0x50,0x38,0x20,0x20,0x50,0x21,0x8c,0x26,0x03}}, // 陵
{0x4E4E,0x97CC,0xCECE,0xE9A098,0x9818,{0x08,0x00,0x08,0xff,0x14,0x10,0x12,0x20,0x21,0x7e,0x5e,0x42,0x00,0x7e,0x00,0x42,0x7e,0x42,0x12,0x7e,0x12,0x42,0x12,0x42,0x12,0x7e,0x14,0x24,0x10,0x42,0x11,0x81}}, // 領
{0x4E4F,0x97CD,0xCECF,0xE58A9B,0x529B,{0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x7f,0xfc,0x01,0x04,0x01,0x04,0x01,0x04,0x02,0x04,0x02,0x04,0x02,0x04,0x04,0x04,0x04,0x04,0x08,0x04,0x10,0x08,0x20,0x30}}, // 力
{0x4E50,0x97CE,0xCED0,0xE7B791,0x7DD1,{0x08,0x00,0x08,0xfc,0x0a,0x04,0x72,0xfc,0x14,0x04,0x08,0x04,0x0d,0xff,0x12,0x10,0x7d,0x92,0x09,0x52,0x2c,0x5c,0x2a,0x38,0x2a,0x54,0x28,0x92,0x4b,0x11,0x08,0x30}}, // 緑
{0x4E51,0x97CF,0xCED1,0xE580AB,0x502B,{0x04,0x20,0x04,0x60,0x04,0x50,0x08,0x88,0x09,0x04,0x16,0xfb,0x10,0x00,0x30,0x00,0x53,0xfe,0x12,0x52,0x12,0x52,0x13,0xfe,0x12,0x52,0x12,0x52,0x12,0x52,0x12,0x56}}, // 倫
{0x4E52,0x97D0,0xCED2,0xE58E98,0x5398,{0x00,0x00,0x1f,0xff,0x10,0x00,0x13,0xfc,0x12,0x44,0x13,0xfc,0x12,0x44,0x12,0x44,0x13,0xfc,0x10,0x40,0x10,0x40,0x17,0xfe,0x20,0x40,0x20,0x40,0x5f,0xff,0x00,0x00}}, // 厘
{0x4E53,0x97D1,0xCED3,0xE69E97,0x6797,{0x08,0x10,0x08,0x10,0x08,0x10,0x7f,0xff,0x08,0x10,0x08,0x10,0x1c,0x38,0x1a,0x38,0x19,0x54,0x28,0x54,0x28,0x92,0x49,0x11,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10}}, // 林
{0x4E54,0x97D2,0xCED4,0xE6B78B,0x6DCB,{0x11,0x08,0x09,0x08,0x09,0x08,0x07,0xff,0x41,0x08,0x21,0x08,0x23,0x9c,0x03,0x5c,0x05,0x2a,0x05,0x2a,0x19,0x49,0x11,0x08,0x21,0x08,0x21,0x08,0x41,0x08,0x41,0x08}}, // 淋
{0x4E55,0x97D3,0xCED5,0xE78790,0x71D0,{0x08,0x92,0x08,0x52,0x08,0x54,0x0b,0xff,0x2a,0x38,0x2a,0x54,0x2d,0x93,0x28,0x90,0x48,0x84,0x08,0xdf,0x0d,0x54,0x0b,0x54,0x12,0xbf,0x10,0x84,0x21,0x04,0x42,0x04}}, // 燐
{0x4E56,0x97D4,0xCED6,0xE790B3,0x7433,{0x00,0x88,0x7c,0x88,0x10,0x88,0x13,0xff,0x10,0x88,0x10,0x88,0x7d,0xdc,0x11,0xbc,0x12,0xaa,0x12,0xaa,0x14,0xc9,0x10,0x88,0x1c,0x88,0x60,0x88,0x00,0x88,0x00,0x88}}, // 琳
{0x4E57,0x97D5,0xCED7,0xE887A8,0x81E8,{0x00,0x40,0x7e,0x40,0x48,0xfe,0x48,0x80,0x49,0xf8,0x7e,0x88,0x42,0x88,0x42,0xf8,0x7e,0x88,0x48,0x00,0x4b,0xde,0x4a,0x52,0x4a,0x52,0x7e,0x52,0x43,0xde,0x02,0x52}}, // 臨
{0x4E58,0x97D6,0xCED8,0xE8BCAA,0x8F2A,{0x08,0x10,0x08,0x10,0x7f,0x28,0x08,0x24,0x3e,0x42,0x2a,0xfd,0x2b,0x00,0x3e,0xfe,0x2a,0xaa,0x2a,0xaa,0x3e,0xfe,0x08,0xaa,0x7f,0xaa,0x08,0xaa,0x08,0xaa,0x08,0x86}}, // 輪
{0x4E59,0x97D7,0xCED9,0xE99AA3,0x96A3,{0x00,0x20,0x3d,0x24,0x24,0xa8,0x27,0xfe,0x28,0x70,0x30,0xac,0x2b,0x23,0x25,0x24,0x25,0xc4,0x25,0x7f,0x26,0x54,0x25,0x94,0x38,0xff,0x21,0x04,0x22,0x04,0x24,0x04}}, // 隣
{0x4E5A,0x97D8,0xCEDA,0xE9B197,0x9C57,{0x08,0x10,0x0e,0x92,0x12,0x54,0x24,0xff,0x7e,0x38,0x2a,0x54,0x2a,0x92,0x3f,0x51,0x2a,0x52,0x2a,0x6f,0x3e,0xaa,0x05,0xaa,0x32,0x7f,0x2a,0x42,0x28,0x82,0x41,0x02}}, // 鱗
{0x4E5B,0x97D9,0xCEDB,0xE9BA9F,0x9E9F,{0x04,0x0a,0x04,0x2a,0x3f,0x9c,0x2a,0x7f,0x3f,0x9c,0x2a,0xaa,0x2a,0xc9,0x3f,0xa8,0x20,0x22,0x2a,0x3a,0x2a,0xaf,0x2f,0x6a,0x2a,0x9a,0x2a,0x9f,0x4e,0xa2,0x11,0xc2}}, // 麟
{0x4E5C,0x97DA,0xCEDC,0xE791A0,0x7460,{0x00,0x40,0x7f,0xbe,0x12,0x0a,0x12,0x8a,0x12,0x52,0x12,0x52,0x7b,0xa2,0x16,0x4c,0x10,0x00,0x11,0xfe,0x11,0x22,0x15,0x22,0x19,0xfe,0x61,0x22,0x01,0xfe,0x01,0x02}}, // 瑠
{0x4E5D,0x97DB,0xCEDD,0xE5A181,0x5841,{0x00,0x00,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x08,0x88,0x08,0x88,0x0f,0xfa,0x30,0x0c,0x08,0x10,0x03,0x40,0x0c,0xb8,0x30,0x86,0x07,0xf8,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 塁
{0x4E5E,0x97DC,0xCEDE,0xE6B699,0x6D99,{0x10,0x00,0x0b,0xff,0x08,0x00,0x03,0xfe,0x42,0x02,0x22,0x02,0x23,0xfe,0x02,0x20,0x0a,0x20,0x0b,0xff,0x12,0x20,0x12,0x30,0x24,0x50,0x24,0x48,0x48,0x84,0x43,0x03}}, // 涙
{0x4E5F,0x97DD,0xCEDF,0xE7B4AF,0x7D2F,{0x00,0x00,0x1f,0xfc,0x10,0x84,0x1f,0xfc,0x10,0x84,0x10,0x84,0x1f,0xfc,0x01,0x90,0x0e,0x28,0x01,0x44,0x7f,0xfa,0x00,0x80,0x04,0xb0,0x18,0x8c,0x60,0x82,0x00,0x80}}, // 累
{0x4E60,0x97DE,0xCEE0,0xE9A19E,0x985E,{0x08,0x00,0x49,0xff,0x29,0x10,0x2a,0x20,0x7f,0x7e,0x1c,0x42,0x1a,0x42,0x2a,0x7e,0x48,0x42,0x08,0x7e,0x7f,0x42,0x08,0x42,0x14,0x7e,0x12,0x24,0x22,0x42,0x41,0x81}}, // 類
{0x4E61,0x97DF,0xCEE1,0xE4BBA4,0x4EE4,{0x00,0x80,0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x67,0xf3,0x00,0x00,0x00,0x00,0x3f,0xfc,0x00,0x84,0x00,0x84,0x00,0x84,0x00,0x98,0x00,0x80,0x00,0x80}}, // 令
{0x4E62,0x97E0,0xCEE2,0xE4BCB6,0x4F36,{0x04,0x20,0x04,0x20,0x04,0x50,0x08,0x88,0x09,0x04,0x12,0xfa,0x14,0x01,0x30,0x00,0x53,0xfc,0x10,0x44,0x10,0x44,0x10,0x44,0x10,0x44,0x10,0x58,0x10,0x40,0x10,0x40}}, // 伶
{0x4E63,0x97E1,0xCEE3,0xE4BE8B,0x4F8B,{0x08,0x02,0x0f,0xf2,0x09,0x12,0x11,0x12,0x11,0x12,0x11,0xd2,0x32,0x52,0x32,0x52,0x53,0x52,0x14,0xd2,0x18,0x92,0x10,0x82,0x11,0x02,0x11,0x02,0x12,0x06,0x14,0x02}}, // 例
{0x4E64,0x97E2,0xCEE4,0xE586B7,0x51B7,{0x00,0x40,0x20,0x60,0x10,0xa0,0x10,0x90,0x11,0x08,0x01,0xfc,0x02,0x02,0x04,0x01,0x13,0xfc,0x10,0x44,0x10,0x44,0x20,0x44,0x20,0x58,0x40,0x40,0x40,0x40,0x00,0x40}}, // 冷
{0x4E65,0x97E3,0xCEE5,0xE58AB1,0x52B1,{0x00,0x10,0x1f,0xd0,0x10,0x10,0x10,0x10,0x1f,0xfe,0x14,0x12,0x14,0x12,0x17,0x92,0x14,0x92,0x14,0x92,0x14,0x92,0x14,0x92,0x28,0xa2,0x28,0xa2,0x51,0x42,0x06,0x8c}}, // 励
{0x4E66,0x97E4,0xCEE6,0xE5B6BA,0x5DBA,{0x10,0x84,0x10,0x84,0x1f,0xfc,0x14,0x04,0x0c,0xff,0x0a,0x10,0x11,0x20,0x3e,0x7e,0x40,0x42,0x3f,0x7e,0x09,0x42,0x09,0x7e,0x09,0x42,0x0e,0x7e,0x08,0x26,0x09,0xc1}}, // 嶺
{0x4E67,0x97E5,0xCEE7,0xE6809C,0x601C,{0x08,0x20,0x08,0x20,0x08,0x50,0x08,0x88,0x0d,0x04,0x2a,0xfe,0x2a,0x01,0x28,0x00,0x29,0xfc,0x48,0x44,0x08,0x44,0x08,0x44,0x08,0x44,0x08,0x58,0x08,0x40,0x08,0x40}}, // 怜
{0x4E68,0x97E6,0xCEE8,0xE78EB2,0x73B2,{0x00,0x20,0x7e,0x20,0x10,0x50,0x10,0x48,0x10,0x84,0x11,0xfa,0x7e,0x01,0x10,0x00,0x11,0xfc,0x10,0x44,0x14,0x44,0x18,0x44,0x60,0x44,0x00,0x58,0x00,0x40,0x00,0x40}}, // 玲
{0x4E69,0x97E7,0xCEE9,0xE7A4BC,0x793C,{0x08,0x40,0x08,0x40,0x08,0x40,0x7e,0x40,0x02,0x40,0x04,0x40,0x04,0x40,0x08,0x40,0x0c,0x40,0x1a,0x40,0x29,0x40,0x48,0x42,0x08,0x42,0x08,0x42,0x08,0x3e,0x08,0x00}}, // 礼
{0x4E6A,0x97E8,0xCEEA,0xE88B93,0x82D3,{0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x90,0x04,0x90,0x01,0x40,0x06,0x20,0x1b,0xf8,0x60,0x07,0x00,0x00,0x1f,0xf8,0x01,0x08,0x01,0x08,0x01,0x30,0x01,0x00,0x01,0x00}}, // 苓
{0x4E6B,0x97E9,0xCEEB,0xE988B4,0x9234,{0x08,0x10,0x08,0x10,0x14,0x28,0x12,0x44,0x21,0x82,0x7f,0x7d,0x08,0x00,0x08,0x00,0x7f,0xfc,0x08,0x24,0x4a,0x24,0x2c,0x24,0x28,0x24,0x0e,0x38,0x18,0x20,0x60,0x20}}, // 鈴
{0x4E6C,0x97EA,0xCEEC,0xE99AB7,0x96B7,{0x08,0x10,0x08,0x10,0x7f,0x10,0x08,0xfe,0x3e,0x12,0x01,0xff,0x3e,0x12,0x00,0xfe,0x7f,0x10,0x08,0x92,0x2c,0x5c,0x2a,0x78,0x2a,0x54,0x4b,0x92,0x08,0x11,0x18,0x30}}, // 隷
{0x4E6D,0x97EB,0xCEED,0xE99BB6,0x96F6,{0x00,0x00,0x3f,0xfc,0x01,0x00,0x3f,0xfe,0x21,0x04,0x3d,0x7c,0x41,0x00,0x1d,0x78,0x02,0x80,0x04,0x40,0x1f,0xf0,0x60,0x0e,0x1f,0xf0,0x01,0x10,0x01,0x60,0x01,0x00}}, // 零
{0x4E6E,0x97EC,0xCEEE,0xE99C8A,0x970A,{0x00,0x00,0x3f,0xfc,0x01,0x00,0x3f,0xfe,0x21,0x02,0x3d,0x74,0x4f,0x3c,0x00,0x00,0x1f,0xf8,0x00,0x00,0x7f,0xfe,0x02,0x48,0x12,0x48,0x0a,0x50,0x7f,0xfe,0x00,0x00}}, // 霊
{0x4E6F,0x97ED,0xCEEF,0xE9BA97,0x9E97,{0x3f,0x7e,0x00,0x00,0x1f,0x7c,0x11,0x44,0x15,0x54,0x00,0x80,0x1f,0xfe,0x11,0x20,0x1f,0xfc,0x11,0x24,0x1f,0xfc,0x14,0x24,0x27,0xb8,0x24,0x22,0x47,0xa2,0x38,0x1e}}, // 麗
{0x4E70,0x97EE,0xCEF0,0xE9BDA2,0x9F62,{0x04,0x10,0x14,0x10,0x17,0xa8,0x14,0x28,0x14,0x44,0x7f,0xba,0x25,0x81,0x36,0x80,0x2c,0xfe,0x3f,0x92,0x24,0x92,0x2e,0x92,0x35,0x9c,0x24,0x90,0x3f,0x90,0x20,0x90}}, // 齢
{0x4E71,0x97EF,0xCEF1,0xE69AA6,0x66A6,{0x00,0x00,0x1f,0xff,0x11,0x08,0x11,0x08,0x1f,0xff,0x13,0x9c,0x15,0x6a,0x19,0x49,0x11,0x08,0x17,0xfc,0x14,0x04,0x17,0xfc,0x24,0x04,0x24,0x04,0x47,0xfc,0x04,0x04}}, // 暦
{0x4E72,0x97F0,0xCEF2,0xE6ADB4,0x6B74,{0x00,0x00,0x1f,0xff,0x11,0x08,0x11,0x08,0x1f,0xff,0x13,0x8c,0x15,0x5a,0x19,0x29,0x11,0x08,0x11,0x48,0x12,0x40,0x12,0x7e,0x22,0x40,0x22,0x40,0x5f,0xff,0x00,0x00}}, // 歴
{0x4E73,0x97F1,0xCEF3,0xE58897,0x5217,{0x00,0x02,0x7f,0xe2,0x08,0x22,0x08,0x22,0x08,0x22,0x0f,0x22,0x11,0x22,0x11,0x22,0x29,0x22,0x46,0x22,0x02,0x22,0x04,0x02,0x04,0x02,0x08,0x02,0x10,0x0e,0x20,0x02}}, // 列
{0x4E74,0x97F2,0xCEF4,0xE58AA3,0x52A3,{0x00,0x80,0x04,0x90,0x04,0x88,0x08,0x84,0x10,0x94,0x21,0xa2,0x00,0xc2,0x07,0x40,0x78,0x40,0x00,0x40,0x1f,0xfc,0x00,0x84,0x01,0x04,0x02,0x04,0x0c,0x04,0x30,0x18}}, // 劣
{0x4E75,0x97F3,0xCEF5,0xE78388,0x70C8,{0x00,0x04,0x7f,0xa4,0x08,0x24,0x08,0x24,0x0f,0x24,0x11,0x24,0x12,0x24,0x2a,0x24,0x44,0x24,0x08,0x04,0x10,0x0c,0x20,0x04,0x10,0x00,0x14,0x44,0x22,0x22,0x42,0x21}}, // 烈
{0x4E76,0x97F4,0xCEF6,0xE8A382,0x88C2,{0x00,0x02,0x3f,0xd2,0x04,0x12,0x07,0x92,0x08,0x92,0x35,0x12,0x02,0x12,0x0c,0x02,0x70,0x86,0x00,0x80,0x7f,0xff,0x01,0x88,0x06,0x50,0x7c,0x20,0x07,0x18,0x18,0x07}}, // 裂
{0x4E77,0x97F5,0xCEF7,0xE5BB89,0x5EC9,{0x00,0x80,0x1f,0xff,0x12,0x08,0x11,0x10,0x1f,0xfe,0x11,0x20,0x17,0xfc,0x11,0x24,0x1f,0xff,0x11,0x24,0x17,0xfc,0x13,0x30,0x25,0x28,0x29,0x24,0x51,0x22,0x01,0x20}}, // 廉
{0x4E78,0x97F6,0xCEF8,0xE6818B,0x604B,{0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0x20,0x09,0x28,0x09,0x24,0x11,0x24,0x22,0x22,0x42,0x62,0x04,0x00,0x00,0x80,0x12,0x44,0x12,0x42,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 恋
{0x4E79,0x97F7,0xCEF9,0xE68690,0x6190,{0x08,0x92,0x08,0x52,0x08,0x54,0x09,0xff,0x2c,0x38,0x2a,0x54,0x2b,0x93,0x28,0x90,0x48,0x84,0x08,0xff,0x09,0x54,0x0b,0x54,0x0c,0xbf,0x08,0x84,0x09,0x04,0x0a,0x04}}, // 憐
{0x4E7A,0x97F8,0xCEFA,0xE6BCA3,0x6F23,{0x20,0x10,0x14,0x10,0x13,0xff,0x02,0x10,0x40,0xfe,0x20,0x92,0x20,0x92,0x0e,0xfe,0x02,0x92,0x12,0x92,0x12,0xfe,0x22,0x10,0x23,0xff,0x25,0x10,0x48,0xd0,0x50,0x3f}}, // 漣
{0x4E7B,0x97F9,0xCEFB,0xE78589,0x7149,{0x08,0x10,0x08,0x10,0x09,0xff,0x0a,0x10,0x2a,0xfe,0x2c,0x92,0x28,0xfe,0x28,0x92,0x48,0x92,0x08,0xfe,0x0c,0x38,0x0a,0x54,0x11,0x52,0x10,0x91,0x21,0x10,0x40,0x10}}, // 煉
{0x4E7C,0x97FA,0xCEFC,0xE7B0BE,0x7C3E,{0x10,0x20,0x1f,0xbf,0x28,0x50,0x44,0x88,0x1f,0xfe,0x12,0x10,0x11,0x20,0x1f,0xfe,0x11,0x24,0x1f,0xff,0x11,0x24,0x17,0xfc,0x23,0x30,0x25,0x2c,0x59,0x23,0x01,0x20}}, // 簾
{0x4E7D,0x97FB,0xCEFD,0xE7B7B4,0x7DF4,{0x08,0x10,0x08,0x10,0x13,0xff,0x72,0x10,0x14,0xfe,0x08,0x92,0x0c,0xfe,0x12,0x92,0x7d,0x92,0x08,0xfe,0x2c,0x38,0x2a,0x54,0x2a,0x54,0x2a,0x92,0x49,0x11,0x08,0x10}}, // 練
{0x4E7E,0x97FC,0xCEFE,0xE881AF,0x806F,{0x00,0x44,0x7e,0x44,0x25,0xba,0x24,0xaa,0x24,0x44,0x3c,0x44,0x24,0xaa,0x25,0xff,0x3c,0x00,0x25,0x2a,0x25,0x2a,0x25,0xea,0x3d,0x2e,0x65,0x4a,0x04,0x48,0x04,0x88}}, // 聯
{0x4F21,0x9840,0xCFA1,0xE893AE,0x84EE,{0x04,0x10,0x7f,0xff,0x04,0x10,0x00,0x20,0x13,0xfe,0x08,0x20,0x09,0xfc,0x01,0x24,0x01,0xfc,0x79,0x24,0x09,0xfc,0x08,0x20,0x0b,0xfe,0x14,0x20,0x23,0x20,0x40,0xff}}, // 蓮
{0x4F22,0x9841,0xCFA2,0xE980A3,0x9023,{0x00,0x20,0x20,0x20,0x17,0xff,0x10,0x20,0x01,0xfc,0x01,0x24,0x01,0x24,0x79,0xfc,0x09,0x24,0x09,0x24,0x09,0xfc,0x08,0x20,0x0f,0xff,0x14,0x20,0x23,0x20,0x40,0xff}}, // 連
{0x4F23,0x9842,0xCFA3,0xE98CAC,0x932C,{0x08,0x10,0x08,0x10,0x15,0xff,0x12,0x10,0x20,0xfe,0x7e,0x92,0x08,0xfe,0x08,0x92,0x7f,0x92,0x08,0xfe,0x4a,0x38,0x2c,0x34,0x28,0x52,0x0e,0x91,0x19,0x10,0x60,0x10}}, // 錬
{0x4F24,0x9843,0xCFA4,0xE59182,0x5442,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x88,0x00,0x80,0x01,0x00,0x1f,0xfc,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x1f,0xfc,0x10,0x04}}, // 呂
{0x4F25,0x9844,0xCFA5,0xE9ADAF,0x9B6F,{0x02,0x00,0x07,0xe0,0x18,0x40,0x7f,0xfc,0x10,0x84,0x1f,0xfc,0x10,0x84,0x1f,0xfc,0x14,0x48,0x22,0x24,0x4f,0xfa,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 魯
{0x4F26,0x9845,0xCFA6,0xE6AB93,0x6AD3,{0x08,0x10,0x08,0x3c,0x08,0x48,0x7f,0xfe,0x08,0x92,0x08,0xfe,0x1c,0x92,0x1a,0xfe,0x18,0xaa,0x29,0x15,0x28,0xfe,0x48,0x82,0x08,0xfe,0x08,0x82,0x08,0xfe,0x08,0x82}}, // 櫓
{0x4F27,0x9846,0xCFA7,0xE78289,0x7089,{0x08,0x00,0x08,0xff,0x08,0x00,0x09,0x00,0x29,0x7e,0x29,0x42,0x2a,0x42,0x48,0x7e,0x08,0x42,0x08,0x40,0x0c,0x40,0x0a,0x40,0x11,0x80,0x10,0x80,0x21,0x00,0x42,0x00}}, // 炉
{0x4F28,0x9847,0xCFA8,0xE8B382,0x8CC2,{0x00,0x20,0x3e,0x20,0x22,0x3c,0x22,0x44,0x3e,0x48,0x22,0xa8,0x23,0x10,0x22,0x28,0x3e,0x44,0x22,0x82,0x23,0x7d,0x3e,0x44,0x14,0x44,0x12,0x44,0x22,0x7c,0x40,0x44}}, // 賂
{0x4F29,0x9848,0xCFA9,0xE8B7AF,0x8DEF,{0x00,0x40,0x3e,0x40,0x22,0x7c,0x22,0x44,0x22,0xc8,0x3e,0xa8,0x09,0x10,0x28,0x28,0x28,0x44,0x2e,0x82,0x29,0x7d,0x28,0x44,0x29,0x44,0x2e,0x44,0x38,0x7c,0x60,0x44}}, // 路
{0x4F2A,0x9849,0xCFAA,0xE99CB2,0x9732,{0x00,0x00,0x3f,0xfc,0x01,0x00,0x3f,0xfe,0x21,0x02,0x3d,0x74,0x4f,0x3c,0x01,0x10,0x3e,0x3c,0x22,0x64,0x3e,0x98,0x08,0x28,0x2e,0x7c,0x29,0xc7,0x2e,0x7c,0x70,0x44}}, // 露
{0x4F2B,0x984A,0xCFAB,0xE58AB4,0x52B4,{0x11,0x04,0x08,0x84,0x08,0x88,0x08,0x90,0x3f,0xfe,0x20,0x04,0x21,0x00,0x41,0x00,0x3f,0xf8,0x01,0x08,0x01,0x08,0x02,0x08,0x02,0x08,0x04,0x08,0x18,0x08,0x60,0x30}}, // 労
{0x4F2C,0x984B,0xCFAC,0xE5A981,0x5A41,{0x00,0x80,0x0f,0xf8,0x08,0x88,0x7f,0xff,0x08,0x88,0x0f,0xf8,0x00,0x80,0x1f,0xfc,0x10,0x84,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x02,0x10,0x0f,0xe0,0x01,0xb0,0x1e,0x0c}}, // 婁
{0x4F2D,0x984C,0xCFAD,0xE5BB8A,0x5ECA,{0x00,0x40,0x00,0x40,0x1f,0xff,0x11,0x00,0x11,0x1e,0x17,0xd2,0x14,0x54,0x17,0xd8,0x14,0x54,0x17,0xd2,0x14,0x11,0x15,0x11,0x24,0x99,0x27,0xd6,0x58,0x30,0x00,0x10}}, // 廊
{0x4F2E,0x984D,0xCFAE,0xE5BC84,0x5F04,{0x00,0x00,0x1f,0xfc,0x00,0x80,0x00,0x80,0x0f,0xf8,0x00,0x80,0x00,0x80,0x7f,0xff,0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x10,0x04,0x10,0x08,0x10,0x08,0x10,0x10,0x10}}, // 弄
{0x4F2F,0x984E,0xCFAF,0xE69C97,0x6717,{0x08,0x00,0x08,0x3e,0x3f,0x22,0x21,0x22,0x21,0x22,0x3f,0x3e,0x21,0x22,0x21,0x22,0x3f,0x22,0x20,0x3e,0x24,0x22,0x22,0x22,0x22,0x42,0x2d,0x42,0x30,0x86,0x61,0x02}}, // 朗
{0x4F30,0x984F,0xCFB0,0xE6A5BC,0x697C,{0x08,0x10,0x08,0x92,0x08,0x54,0x7f,0xff,0x08,0x38,0x08,0x54,0x1c,0x92,0x1a,0x11,0x1a,0x20,0x29,0xff,0x29,0x24,0x48,0x44,0x08,0xe8,0x08,0x18,0x08,0x64,0x09,0x82}}, // 楼
{0x4F31,0x9850,0xCFB1,0xE6A694,0x6994,{0x10,0x80,0x10,0x9e,0x13,0xd2,0x7e,0x52,0x12,0x54,0x13,0xd8,0x3a,0x54,0x36,0x52,0x33,0xd2,0x52,0x11,0x52,0x91,0x12,0x59,0x12,0xd6,0x13,0x30,0x16,0x30,0x10,0x10}}, // 榔
{0x4F32,0x9851,0xCFB2,0xE6B5AA,0x6D6A,{0x10,0x20,0x08,0x20,0x09,0xfc,0x01,0x04,0x41,0x04,0x21,0xfc,0x21,0x04,0x01,0x04,0x09,0xfc,0x09,0x22,0x11,0x22,0x11,0x14,0x21,0x18,0x21,0x48,0x41,0x84,0x46,0x03}}, // 浪
{0x4F33,0x9852,0xCFB3,0xE6BC8F,0x6F0F,{0x10,0x00,0x0b,0xfe,0x0a,0x02,0x02,0x02,0x43,0xfe,0x22,0x00,0x23,0xff,0x02,0x20,0x0b,0xfe,0x0b,0xb2,0x15,0x6a,0x15,0x22,0x25,0xb2,0x29,0x6a,0x51,0x22,0x41,0x26}}, // 漏
{0x4F34,0x9853,0xCFB4,0xE789A2,0x7262,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x29,0x00,0x49,0x00,0x09,0x00,0x1f,0xfc,0x11,0x00,0x21,0x00,0x01,0x00,0x7f,0xfe,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00}}, // 牢
{0x4F35,0x9854,0xCFB5,0xE78BBC,0x72FC,{0x04,0x20,0x44,0x20,0x29,0xf8,0x11,0x08,0x11,0x08,0x29,0xf8,0x49,0x08,0x09,0x08,0x19,0xfa,0x19,0x22,0x29,0x24,0x49,0x10,0x09,0x08,0x09,0x64,0x69,0x82,0x16,0x01}}, // 狼
{0x4F36,0x9855,0xCFB6,0xE7AFAD,0x7BED,{0x10,0x20,0x1f,0xbf,0x14,0x48,0x22,0x84,0x40,0x80,0x1f,0xfc,0x02,0x20,0x7f,0xff,0x00,0x00,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x08,0x88,0x0f,0xfa,0x00,0x82,0x00,0x7e}}, // 篭
{0x4F37,0x9856,0xCFB7,0xE88081,0x8001,{0x00,0x80,0x00,0x84,0x1f,0xfc,0x00,0x88,0x00,0x90,0x00,0xa0,0x7f,0xff,0x00,0xc0,0x00,0x80,0x03,0x08,0x0e,0x30,0x73,0xc0,0x02,0x00,0x02,0x04,0x01,0x04,0x00,0xfc}}, // 老
{0x4F38,0x9857,0xCFB8,0xE881BE,0x807E,{0x04,0x20,0x3f,0xbf,0x0a,0x20,0x7f,0xfe,0x11,0x02,0x1f,0x3e,0x11,0x20,0x1f,0x3e,0x11,0x20,0x13,0x21,0x7f,0xff,0x04,0x08,0x07,0xf8,0x04,0x0e,0x7f,0xf8,0x00,0x08}}, // 聾
{0x4F39,0x9858,0xCFB9,0xE89D8B,0x874B,{0x08,0x42,0x09,0x22,0x08,0xa4,0x08,0x88,0x3e,0xfc,0x2a,0xa4,0x2a,0xa4,0x2a,0xfc,0x3e,0xa4,0x08,0xa4,0x0c,0xfc,0x0a,0xa4,0x0a,0xa4,0x0d,0x25,0x71,0x25,0x02,0x23}}, // 蝋
{0x4F3A,0x9859,0xCFBA,0xE9838E,0x90CE,{0x08,0x00,0x08,0x3c,0x3f,0x24,0x21,0x24,0x21,0x24,0x3f,0x28,0x21,0x30,0x21,0x28,0x3f,0x24,0x24,0x22,0x22,0x22,0x21,0x22,0x27,0x32,0x38,0xac,0x60,0xa0,0x00,0x20}}, // 郎
{0x4F3B,0x985A,0xCFBB,0xE585AD,0x516D,{0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x82,0x7f,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x20,0x04,0x10,0x04,0x08,0x08,0x08,0x08,0x04,0x10,0x04,0x20,0x04,0x00,0x00}}, // 六
{0x4F3C,0x985B,0xCFBC,0xE9BA93,0x9E93,{0x08,0x08,0x7f,0x7f,0x1c,0x1c,0x2a,0x2a,0x48,0x49,0x00,0x80,0x1f,0xff,0x11,0x20,0x1f,0xfe,0x11,0x22,0x1f,0xfe,0x14,0x24,0x27,0xb8,0x24,0x22,0x47,0xe2,0x1c,0x1e}}, // 麓
{0x4F3D,0x985C,0xCFBD,0xE7A684,0x7984,{0x08,0x00,0x08,0xfc,0x08,0x04,0x7e,0xfc,0x02,0x04,0x04,0x04,0x05,0xff,0x08,0x12,0x1c,0x92,0x2a,0x5c,0x49,0x38,0x08,0x34,0x08,0xd2,0x0b,0x11,0x08,0x30,0x08,0x10}}, // 禄
{0x4F3E,0x985D,0xCFBE,0xE8828B,0x808B,{0x00,0x20,0x3e,0x20,0x22,0x20,0x22,0x20,0x23,0xfe,0x3e,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x3e,0x22,0x22,0x22,0x22,0x22,0x22,0x42,0x22,0x42,0x26,0x84,0x43,0x18}}, // 肋
{0x4F3F,0x985E,0xCFBF,0xE98CB2,0x9332,{0x04,0x00,0x04,0xfc,0x0c,0x04,0x0a,0xfc,0x11,0x04,0x3f,0x04,0x44,0xff,0x04,0x12,0x7f,0x92,0x04,0x5c,0x25,0x38,0x16,0x34,0x14,0xd2,0x07,0x11,0x18,0x30,0x60,0x10}}, // 録
{0x4F40,0x985F,0xCFC0,0xE8AB96,0x8AD6,{0x00,0x20,0x3c,0x20,0x00,0x50,0x7e,0x50,0x00,0x88,0x3d,0xfc,0x02,0x02,0x00,0x01,0x3d,0xfc,0x01,0x54,0x3d,0x54,0x25,0xfc,0x25,0x54,0x25,0x54,0x3d,0x54,0x25,0x0c}}, // 論
{0x4F41,0x9860,0xCFC1,0xE580AD,0x502D,{0x04,0x08,0x04,0x30,0x05,0xe0,0x08,0x20,0x0f,0xff,0x10,0x70,0x11,0xac,0x36,0x23,0x50,0x60,0x17,0xff,0x10,0x48,0x10,0x88,0x11,0xd0,0x10,0x70,0x11,0x88,0x16,0x04}}, // 倭
{0x4F42,0x9861,0xCFC2,0xE5928C,0x548C,{0x01,0x00,0x06,0x00,0x3c,0x7e,0x04,0x42,0x04,0x42,0x04,0x42,0x7f,0xc2,0x0c,0x42,0x0e,0x42,0x15,0x42,0x14,0xc2,0x24,0x42,0x44,0x7e,0x04,0x42,0x04,0x40,0x04,0x00}}, // 和
{0x4F43,0x9862,0xCFC3,0xE8A9B1,0x8A71,{0x00,0x04,0x3e,0x18,0x00,0xf0,0x7f,0x10,0x00,0x10,0x3e,0x10,0x01,0xff,0x3e,0x10,0x00,0x10,0x00,0x10,0x3e,0xfe,0x22,0x82,0x22,0x82,0x22,0x82,0x3e,0xfe,0x22,0x82}}, // 話
{0x4F44,0x9863,0xCFC4,0xE6ADAA,0x6B6A,{0x00,0x00,0x7f,0xff,0x00,0x40,0x00,0x80,0x03,0xf0,0x0c,0x8c,0x70,0x82,0x00,0x80,0x1f,0xfc,0x00,0x80,0x08,0x80,0x08,0xf8,0x08,0x80,0x08,0x80,0x7f,0xff,0x00,0x00}}, // 歪
{0x4F45,0x9864,0xCFC5,0xE8B384,0x8CC4,{0x00,0x10,0x3e,0x10,0x23,0xff,0x22,0x10,0x3e,0x20,0x22,0x3e,0x22,0x62,0x3e,0x62,0x22,0xbe,0x23,0x22,0x22,0x22,0x3e,0x3e,0x14,0x22,0x12,0x22,0x22,0x26,0x40,0x22}}, // 賄
{0x4F46,0x9865,0xCFC6,0xE88487,0x8107,{0x00,0x40,0x3c,0x40,0x25,0xfc,0x24,0x44,0x24,0x44,0x3c,0x44,0x24,0x98,0x25,0x00,0x25,0x08,0x3f,0xfe,0x25,0x4a,0x25,0x4a,0x25,0x4a,0x25,0x52,0x2e,0x62,0x44,0xcc}}, // 脇
{0x4F47,0x9866,0xCFC7,0xE68391,0x60D1,{0x00,0x48,0x00,0x44,0x7f,0xff,0x00,0x40,0x1f,0x44,0x11,0x24,0x11,0x28,0x1f,0x12,0x07,0xaa,0x78,0x46,0x02,0x82,0x12,0x44,0x12,0x42,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 惑
{0x4F48,0x9867,0xCFC8,0xE69EA0,0x67A0,{0x08,0x20,0x08,0x20,0x09,0xf8,0x7e,0x28,0x08,0x28,0x0c,0x49,0x1a,0x49,0x1a,0x87,0x19,0x20,0x28,0x20,0x2b,0xfe,0x48,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20}}, // 枠
{0x4F49,0x9868,0xCFC9,0xE9B7B2,0x9DF2,{0x08,0x14,0x7f,0x12,0x22,0xff,0x3e,0x18,0x0a,0x28,0x29,0x2a,0x29,0x4a,0x5a,0x86,0x0f,0xf0,0x08,0x10,0x0f,0xfe,0x08,0x00,0x0f,0xfe,0x29,0x22,0x24,0x92,0x40,0x0c}}, // 鷲
{0x4F4A,0x9869,0xCFCA,0xE4BA99,0x4E99,{0x00,0x00,0x3f,0xfe,0x02,0x00,0x02,0x00,0x03,0xf0,0x02,0x10,0x05,0x90,0x04,0x50,0x04,0x10,0x0b,0x20,0x08,0xa0,0x08,0x20,0x00,0x20,0x00,0x22,0x7f,0xff,0x00,0x00}}, // 亙
{0x4F4B,0x986A,0xCFCB,0xE4BA98,0x4E98,{0x00,0x00,0x3f,0xfc,0x00,0x00,0x00,0x00,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10,0x08,0x10,0x08,0x10,0x0f,0xf0,0x00,0x00,0x00,0x02,0x7f,0xff,0x00,0x00}}, // 亘
{0x4F4C,0x986B,0xCFCC,0xE9B090,0x9C10,{0x08,0x00,0x0e,0xee,0x12,0xaa,0x24,0xaa,0x7f,0xee,0x29,0x00,0x29,0x7e,0x3f,0x00,0x29,0xff,0x29,0x10,0x3f,0x10,0x05,0x3e,0x32,0xa2,0x2a,0x02,0x28,0x02,0x40,0x0c}}, // 鰐
{0x4F4D,0x986C,0xCFCD,0xE8A9AB,0x8A6B,{0x00,0x10,0x3e,0x10,0x00,0xff,0x7e,0x82,0x01,0x00,0x3e,0x18,0x01,0xe0,0x00,0x20,0x3e,0x20,0x00,0x3f,0x3f,0xe0,0x22,0x20,0x22,0x20,0x22,0x21,0x3e,0x11,0x22,0x0f}}, // 詫
{0x4F4E,0x986D,0xCFCE,0xE89781,0x85C1,{0x04,0x10,0x7f,0xff,0x04,0x90,0x3f,0xfe,0x04,0x10,0x07,0xf0,0x00,0x00,0x3f,0xfe,0x22,0x22,0x23,0xe6,0x00,0x80,0x7f,0xff,0x02,0xa0,0x0c,0x98,0x70,0x87,0x00,0x80}}, // 藁
{0x4F4F,0x986E,0xCFCF,0xE895A8,0x8568,{0x02,0x10,0x3f,0xff,0x02,0x10,0x00,0x00,0x1f,0xff,0x14,0x90,0x13,0x10,0x1f,0xdf,0x12,0x2a,0x1a,0xac,0x1a,0xc8,0x1a,0x8c,0x2f,0x94,0x22,0x92,0x44,0x22,0x08,0x41}}, // 蕨
{0x4F50,0x986F,0xCFD0,0xE6A480,0x6900,{0x08,0x10,0x08,0x10,0x09,0xff,0x7f,0x02,0x09,0x40,0x0a,0x4e,0x1c,0xfa,0x1a,0x9a,0x1a,0x9a,0x29,0x2a,0x2a,0xaa,0x48,0x4c,0x08,0x48,0x08,0x89,0x09,0x09,0x0a,0x07}}, // 椀
{0x4F51,0x9870,0xCFD1,0xE6B9BE,0x6E7E,{0x10,0x20,0x08,0x20,0x0f,0xff,0x00,0x90,0x42,0x94,0x22,0x92,0x24,0xb2,0x01,0x00,0x0b,0xf8,0x08,0x08,0x13,0xf8,0x12,0x00,0x23,0xfc,0x20,0x04,0x40,0x04,0x40,0x38}}, // 湾
{0x4F52,0x9871,0xCFD2,0xE7A297,0x7897,{0x00,0x10,0x7f,0x10,0x08,0xff,0x08,0x82,0x09,0x40,0x10,0x4e,0x1e,0xfa,0x32,0x9a,0x32,0x9a,0x53,0x2a,0x12,0xaa,0x12,0x4c,0x1e,0x48,0x12,0x89,0x11,0x09,0x06,0x07}}, // 碗
{0x4F53,0x9872,0xCFD3,0xE88595,0x8155,{0x00,0x10,0x3c,0x10,0x25,0xff,0x25,0x02,0x25,0x40,0x3e,0x4e,0x24,0xfa,0x24,0x9a,0x24,0x9a,0x3d,0x2a,0x26,0xaa,0x24,0x4c,0x24,0x48,0x24,0x89,0x2d,0x09,0x46,0x07}}, // 腕
{0x5021,0x989F,0xD0A1,0xE5BC8C,0x5F0C,{0x00,0x48,0x00,0x44,0x00,0x44,0x00,0x40,0x7f,0xff,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x10,0x7f,0x90,0x00,0x10,0x00,0x0a,0x00,0x0a,0x00,0x06,0x00,0x02}}, // 弌
{0x5022,0x98A0,0xD0A2,0xE4B890,0x4E10,{0x00,0x00,0x7f,0xff,0x00,0x80,0x08,0x80,0x08,0xfe,0x08,0x80,0x08,0x80,0x0f,0xfc,0x08,0x04,0x08,0x04,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x08,0x00,0x08,0x00,0x30}}, // 丐
{0x5023,0x98A1,0xD0A3,0xE4B895,0x4E15,{0x00,0x00,0x3f,0xfe,0x00,0x40,0x00,0x40,0x00,0x80,0x01,0x80,0x02,0xb0,0x04,0x8c,0x18,0x82,0x60,0x81,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x00,0x3f,0xfe,0x00,0x00}}, // 丕
{0x5024,0x98A2,0xD0A4,0xE4B8AA,0x4E2A,{0x00,0x80,0x00,0x80,0x01,0x40,0x01,0x40,0x02,0x20,0x04,0x10,0x08,0x88,0x10,0x84,0x20,0x82,0x40,0x81,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 个
{0x5025,0x98A3,0xD0A5,0xE4B8B1,0x4E31,{0x02,0x20,0x02,0x20,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x3e,0x3e,0x22,0x22,0x24,0x20,0x04,0x20,0x08,0x20,0x10,0x20}}, // 丱
{0x5026,0x98A4,0xD0A6,0xE4B8B6,0x4E36,{0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x03,0x00,0x00,0x80,0x00,0x40,0x00,0x20,0x00,0x20,0x00,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // 丶
{0x5027,0x98A5,0xD0A7,0xE4B8BC,0x4E3C,{0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x3f,0xfc,0x04,0x20,0x05,0x20,0x04,0xa0,0x04,0xa0,0x7f,0xfe,0x04,0x20,0x04,0x20,0x04,0x20,0x08,0x20,0x08,0x20,0x10,0x20}}, // 丼
{0x5028,0x98A6,0xD0A8,0xE4B8BF,0x4E3F,{0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x40,0x00,0x80,0x00,0x80,0x01,0x00,0x02,0x00,0x0c,0x00,0x30,0x00}}, // 丿
{0x5029,0x98A7,0xD0A9,0xE4B982,0x4E42,{0x00,0x00,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x02,0x20,0x02,0x20,0x01,0x40,0x01,0x40,0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x60,0x03}}, // 乂
{0x502A,0x98A8,0xD0AA,0xE4B996,0x4E56,{0x00,0x08,0x00,0x70,0x1f,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x04,0x90,0x04,0x93,0x7c,0x9c,0x04,0x90,0x04,0x91,0x1c,0x91,0x64,0x8f,0x04,0x80,0x00,0x80}}, // 乖
{0x502B,0x98A9,0xD0AB,0xE4B998,0x4E58,{0x00,0x08,0x00,0x70,0x1f,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x04,0x92,0x7c,0x9c,0x04,0x91,0x1c,0x91,0x65,0xcf,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80}}, // 乘
{0x502C,0x98AA,0xD0AC,0xE4BA82,0x4E82,{0x01,0x10,0x06,0x10,0x7c,0x90,0x12,0x50,0x22,0x50,0x7f,0xd0,0x11,0x10,0x0a,0x10,0x3f,0xd0,0x25,0x50,0x3e,0xd0,0x20,0x51,0x2f,0x51,0x25,0x51,0x22,0x4f,0x2d,0xc0}}, // 亂
{0x502D,0x98AB,0xD0AD,0xE4BA85,0x4E85,{0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x03,0x80,0x00,0x80}}, // 亅
{0x502E,0x98AC,0xD0AE,0xE8B1AB,0x8C6B,{0x00,0x20,0x3e,0x38,0x02,0x48,0x14,0x90,0x09,0xfe,0x08,0x92,0x7e,0x92,0x0a,0xfe,0x0c,0x62,0x08,0xa2,0x0b,0x54,0x08,0xb8,0x0b,0x54,0x08,0x92,0x0b,0x11,0x18,0x30}}, // 豫
{0x502F,0x98AD,0xD0AF,0xE4BA8A,0x4E8A,{0x00,0x80,0x00,0x80,0x3f,0xfe,0x08,0x88,0x04,0x90,0x04,0x80,0x1f,0xfc,0x00,0x84,0x00,0x84,0x7f,0xff,0x00,0x84,0x00,0x84,0x1f,0xfc,0x00,0x80,0x00,0x80,0x01,0x80}}, // 亊
{0x5030,0x98AE,0xD0B0,0xE88892,0x8212,{0x08,0x00,0x08,0xfc,0x14,0x04,0x12,0x48,0x21,0x30,0x7e,0x10,0x09,0xff,0x08,0x12,0x7f,0x14,0x08,0x18,0x08,0x10,0x3e,0x10,0x22,0x10,0x22,0x10,0x3e,0x10,0x22,0x30}}, // 舒
{0x5031,0x98AF,0xD0B1,0xE5BC8D,0x5F0D,{0x00,0x48,0x00,0x44,0x00,0x44,0x00,0x40,0x7f,0xff,0x00,0x20,0x00,0x20,0x00,0x20,0x3f,0xa0,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x0a,0x7f,0xca,0x00,0x06,0x00,0x02}}, // 弍
{0x5032,0x98B0,0xD0B2,0xE4BA8E,0x4E8E,{0x00,0x00,0x1f,0xfc,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x82,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x03,0x80,0x00,0x80}}, // 于
{0x5033,0x98B1,0xD0B3,0xE4BA9E,0x4E9E,{0x00,0x00,0x7f,0xff,0x02,0x20,0x02,0x20,0x02,0x20,0x3e,0x3e,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x3e,0x3e,0x22,0x22,0x02,0x20,0x02,0x20,0x7f,0xff,0x00,0x00}}, // 亞
{0x5034,0x98B2,0xD0B4,0xE4BA9F,0x4E9F,{0x00,0x00,0x3f,0xfe,0x01,0x00,0x01,0x00,0x03,0xc0,0x00,0x7e,0x3e,0x42,0x22,0x54,0x22,0x4c,0x3e,0x4c,0x22,0x52,0x00,0xa1,0x03,0x00,0x00,0x00,0x7f,0xff,0x00,0x00}}, // 亟
{0x5035,0x98B3,0xD0B5,0xE4BAA0,0x4EA0,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x82,0x7f,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // 亠
{0x5036,0x98B4,0xD0B6,0xE4BAA2,0x4EA2,{0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xfe,0x00,0x00,0x00,0x00,0x03,0xe0,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x04,0x22,0x04,0x22,0x08,0x22,0x30,0x1e}}, // 亢
{0x5037,0x98B5,0xD0B7,0xE4BAB0,0x4EB0,{0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x00,0x80,0x04,0xa0,0x08,0x98,0x10,0x84,0x61,0x82,0x00,0x80}}, // 亰
{0x5038,0x98B6,0xD0B8,0xE4BAB3,0x4EB3,{0x01,0x00,0x7f,0xfe,0x00,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x00,0x00,0x7f,0xfe,0x40,0x12,0x41,0xe2,0x1f,0x00,0x01,0x00,0x7f,0xfe,0x01,0x00,0x00,0x82,0x00,0x7e}}, // 亳
{0x5039,0x98B7,0xD0B9,0xE4BAB6,0x4EB6,{0x00,0x80,0x7f,0xff,0x00,0x00,0x1f,0xfc,0x13,0xe4,0x12,0x24,0x13,0xe4,0x10,0x04,0x1f,0xfc,0x04,0x10,0x07,0xf0,0x04,0x10,0x07,0xf0,0x00,0x00,0x7f,0xff,0x00,0x00}}, // 亶
{0x503A,0x98B8,0xD0BA,0xE4BB8E,0x4ECE,{0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x06,0x10,0x0a,0x18,0x09,0x28,0x09,0x28,0x10,0xc4,0x10,0x44,0x20,0x82,0x41,0x01}}, // 从
{0x503B,0x98B9,0xD0BB,0xE4BB8D,0x4ECD,{0x04,0x00,0x07,0xf8,0x04,0x88,0x08,0x88,0x08,0x88,0x10,0x88,0x10,0x8e,0x30,0x82,0x50,0x82,0x10,0x82,0x10,0x82,0x11,0x02,0x11,0x02,0x12,0x02,0x14,0x04,0x18,0x18}}, // 仍
{0x503C,0x98BA,0xD0BC,0xE4BB84,0x4EC4,{0x00,0x00,0x1f,0xff,0x10,0x00,0x10,0x40,0x10,0x40,0x10,0x40,0x10,0x40,0x10,0x40,0x10,0x40,0x10,0x40,0x10,0xa0,0x10,0xa0,0x21,0x10,0x22,0x08,0x4c,0x04,0x30,0x03}}, // 仄
{0x503D,0x98BB,0xD0BD,0xE4BB86,0x4EC6,{0x02,0x20,0x02,0x20,0x04,0x20,0x04,0x20,0x08,0x20,0x08,0x20,0x18,0x30,0x28,0x28,0x48,0x24,0x08,0x22,0x08,0x22,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20}}, // 仆
{0x503E,0x98BC,0xD0BE,0xE4BB82,0x4EC2,{0x04,0x40,0x04,0x40,0x04,0x40,0x08,0x40,0x0b,0xfe,0x10,0x42,0x10,0x42,0x30,0x42,0x50,0x42,0x10,0x42,0x10,0x42,0x10,0x82,0x10,0x82,0x11,0x02,0x12,0x04,0x14,0x18}}, // 仂
{0x503F,0x98BD,0xD0BF,0xE4BB97,0x4ED7,{0x04,0x20,0x04,0x20,0x04,0x20,0x08,0x20,0x0b,0xff,0x10,0x20,0x11,0x20,0x31,0x20,0x50,0xa0,0x10,0xa0,0x10,0x40,0x10,0x40,0x10,0xa0,0x11,0x10,0x12,0x0c,0x1c,0x03}}, // 仗
{0x5040,0x98BE,0xD0C0,0xE4BB9E,0x4EDE,{0x04,0x00,0x07,0xfe,0x04,0x42,0x08,0x42,0x08,0x42,0x11,0x42,0x11,0x42,0x31,0x42,0x52,0x42,0x14,0x42,0x10,0x42,0x10,0x82,0x10,0x82,0x11,0x02,0x12,0x04,0x14,0x18}}, // 仞
{0x5041,0x98BF,0xD0C1,0xE4BBAD,0x4EED,{0x04,0x00,0x07,0xfc,0x04,0x44,0x08,0x44,0x08,0x44,0x10,0x44,0x12,0x44,0x31,0x44,0x50,0xc4,0x10,0x74,0x10,0x4f,0x10,0x84,0x10,0x84,0x11,0x04,0x12,0x08,0x14,0x30}}, // 仭
{0x5042,0x98C0,0xD0C2,0xE4BB9F,0x4EDF,{0x04,0x04,0x04,0x18,0x05,0xe0,0x08,0x20,0x08,0x20,0x10,0x20,0x10,0x20,0x37,0xff,0x50,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20}}, // 仟
{0x5043,0x98C1,0xD0C3,0xE4BBB7,0x4EF7,{0x04,0x20,0x04,0x20,0x04,0x50,0x08,0x50,0x08,0x88,0x11,0x8c,0x12,0x8a,0x34,0x89,0x50,0x88,0x10,0x88,0x10,0x88,0x10,0x88,0x11,0x08,0x11,0x08,0x12,0x08,0x14,0x08}}, // 价
{0x5044,0x98C2,0xD0C4,0xE4BC89,0x4F09,{0x04,0x20,0x04,0x20,0x04,0x20,0x0b,0xff,0x08,0x00,0x10,0x00,0x10,0xf0,0x30,0x90,0x50,0x90,0x10,0x90,0x10,0x90,0x11,0x10,0x11,0x10,0x12,0x12,0x14,0x12,0x18,0x0e}}, // 伉
{0x5045,0x98C3,0xD0C5,0xE4BD9A,0x4F5A,{0x04,0x20,0x05,0x20,0x05,0x20,0x09,0x20,0x09,0xfe,0x12,0x20,0x12,0x20,0x34,0x20,0x53,0xff,0x10,0x30,0x10,0x50,0x10,0x48,0x10,0x88,0x11,0x04,0x12,0x02,0x14,0x01}}, // 佚
{0x5046,0x98C4,0xD0C6,0xE4BCB0,0x4F30,{0x04,0x20,0x04,0x20,0x04,0x20,0x08,0x20,0x0f,0xff,0x10,0x20,0x10,0x20,0x30,0x20,0x50,0x20,0x11,0xfc,0x11,0x04,0x11,0x04,0x11,0x04,0x11,0x04,0x11,0xfc,0x11,0x04}}, // 估
{0x5047,0x98C5,0xD0C7,0xE4BD9B,0x4F5B,{0x04,0x90,0x04,0x90,0x07,0xfe,0x08,0x92,0x08,0x92,0x13,0xfe,0x12,0x90,0x32,0x90,0x53,0xff,0x10,0x91,0x10,0x91,0x10,0x91,0x11,0x12,0x11,0x1c,0x12,0x10,0x14,0x10}}, // 佛
{0x5048,0x98C6,0xD0C8,0xE4BD9D,0x4F5D,{0x04,0x80,0x04,0x80,0x04,0x80,0x08,0xfe,0x09,0x02,0x11,0x02,0x13,0xf2,0x35,0x12,0x51,0x12,0x11,0x12,0x11,0x12,0x11,0xf2,0x11,0x12,0x10,0x02,0x10,0x04,0x10,0x18}}, // 佝
{0x5049,0x98C7,0xD0C9,0xE4BD97,0x4F57,{0x04,0x20,0x04,0x20,0x04,0x20,0x0b,0xff,0x0a,0x02,0x12,0x80,0x14,0x80,0x30,0x84,0x50,0x98,0x10,0xe0,0x10,0x80,0x10,0x80,0x10,0x80,0x10,0x82,0x10,0x42,0x10,0x3e}}, // 佗
{0x504A,0x98C8,0xD0CA,0xE4BD87,0x4F47,{0x04,0x20,0x04,0x20,0x05,0xff,0x09,0x02,0x09,0x00,0x12,0x00,0x17,0xff,0x30,0x20,0x50,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0xe0,0x10,0x20}}, // 佇
{0x504B,0x98C9,0xD0CB,0xE4BDB6,0x4F76,{0x04,0x20,0x04,0x20,0x04,0x20,0x0f,0xff,0x08,0x20,0x10,0x20,0x10,0x20,0x33,0xfe,0x50,0x00,0x10,0x00,0x11,0xfc,0x11,0x04,0x11,0x04,0x11,0x04,0x11,0xfc,0x11,0x04}}, // 佶
{0x504C,0x98CA,0xD0CC,0xE4BE88,0x4F88,{0x04,0x40,0x04,0x40,0x04,0x78,0x08,0x88,0x09,0x90,0x16,0x50,0x10,0x20,0x30,0x50,0x51,0x9e,0x16,0x22,0x10,0x64,0x11,0x94,0x10,0x08,0x10,0x10,0x10,0x60,0x13,0x80}}, // 侈
{0x504D,0x98CB,0xD0CD,0xE4BE8F,0x4F8F,{0x04,0x20,0x04,0xa0,0x04,0xa0,0x08,0xfe,0x09,0x20,0x12,0x20,0x10,0x20,0x33,0xff,0x50,0x70,0x10,0x70,0x10,0xa8,0x11,0x28,0x12,0x24,0x14,0x22,0x10,0x21,0x10,0x20}}, // 侏
{0x504E,0x98CC,0xD0CE,0xE4BE98,0x4F98,{0x04,0x20,0x04,0x20,0x07,0xff,0x0a,0x02,0x0a,0x08,0x14,0x30,0x13,0xc0,0x30,0x40,0x50,0x40,0x10,0x7f,0x17,0xc0,0x10,0x40,0x10,0x40,0x10,0x42,0x10,0x22,0x10,0x1e}}, // 侘
{0x504F,0x98CD,0xD0CF,0xE4BDBB,0x4F7B,{0x04,0x90,0x04,0x90,0x04,0x92,0x08,0x92,0x0c,0x94,0x12,0x90,0x12,0x90,0x30,0x98,0x50,0x94,0x11,0x92,0x12,0x91,0x1c,0x90,0x11,0x10,0x11,0x11,0x12,0x11,0x14,0x0f}}, // 佻
{0x5050,0x98CE,0xD0D0,0xE4BDA9,0x4F69,{0x08,0x00,0x0b,0xfc,0x0a,0x04,0x0a,0x04,0x13,0xfc,0x12,0x44,0x32,0x44,0x33,0xf4,0x53,0x54,0x13,0x54,0x13,0x54,0x13,0x54,0x15,0x75,0x15,0x45,0x18,0x43,0x10,0x41}}, // 佩
{0x5051,0x98CF,0xD0D1,0xE4BDB0,0x4F70,{0x04,0x00,0x07,0xff,0x04,0x20,0x08,0x20,0x08,0x40,0x11,0xfc,0x11,0x04,0x31,0x04,0x51,0x04,0x11,0xfc,0x11,0x04,0x11,0x04,0x11,0x04,0x11,0x04,0x11,0xfc,0x11,0x04}}, // 佰
{0x5052,0x98D0,0xD0D2,0xE4BE91,0x4F91,{0x04,0x40,0x04,0x40,0x07,0xff,0x08,0x40,0x08,0x80,0x10,0xfc,0x11,0x84,0x31,0x84,0x52,0xfc,0x14,0x84,0x10,0x84,0x10,0xfc,0x10,0x84,0x10,0x84,0x10,0x8c,0x10,0x84}}, // 侑
{0x5053,0x98D1,0xD0D3,0xE4BDAF,0x4F6F,{0x04,0x84,0x04,0x44,0x04,0x48,0x0b,0xfe,0x08,0x20,0x10,0x20,0x10,0x20,0x31,0xfc,0x50,0x20,0x10,0x20,0x10,0x20,0x17,0xff,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20}}, // 佯
{0x5054,0x98D2,0xD0D4,0xE4BE86,0x4F86,{0x00,0x80,0x00,0x80,0x7f,0xff,0x08,0x88,0x08,0x88,0x0c,0x8c,0x14,0x94,0x12,0x92,0x20,0xa0,0x01,0xc0,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80,0x00,0x80}}, // 來
{0x5055,0x98D3,0xD0D5,0xE4BE96,0x4F96,{0x00,0x80,0x00,0x80,0x01,0x40,0x02,0x30,0x0c,0x0c,0x37,0xfb,0x00,0x00,0x00,0x00,0x0f,0xfc,0x09,0x24,0x09,0x24,0x0f,0xfc,0x09,0x24,0x09,0x24,0x09,0x24,0x09,0x2c}}, // 侖
{0x5056,0x98D4,0xD0D6,0xE58498,0x5118,{0x04,0x20,0x05,0xfc,0x04,0x24,0x0b,0xff,0x08,0x24,0x11,0xfc,0x10,0x20,0x37,0xff,0x52,0xa4,0x12,0x52,0x14,0x02,0x13,0xfc,0x12,0x94,0x12,0x94,0x1f,0xff,0x10,0x00}}, // 儘
{0x5057,0x98D5,0xD0D7,0xE4BF94,0x4FD4,{0x04,0x00,0x05,0xfc,0x05,0x04,0x09,0x04,0x09,0xfc,0x11,0x04,0x11,0xfc,0x31,0x04,0x51,0x04,0x11,0xfc,0x10,0x50,0x10,0x50,0x10,0x90,0x11,0x11,0x12,0x11,0x1c,0x0f}}, // 俔
{0x5058,0x98D6,0xD0D8,0xE4BF9F,0x4FDF,{0x04,0x40,0x04,0x50,0x04,0x4c,0x08,0x9a,0x0b,0xe1,0x10,0x80,0x10,0x80,0x31,0xfe,0x51,0x20,0x12,0x20,0x17,0xff,0x10,0x50,0x10,0x48,0x10,0x84,0x13,0x02,0x1c,0x01}}, // 俟
{0x5059,0x98D7,0xD0D9,0xE4BF8E,0x4FCE,{0x08,0x00,0x08,0x7c,0x08,0x44,0x14,0x44,0x12,0x44,0x21,0x7c,0x40,0x44,0x08,0x44,0x08,0x44,0x08,0x7c,0x14,0x44,0x12,0x44,0x21,0x44,0x40,0x44,0x03,0xff,0x00,0x00}}, // 俎
{0x505A,0x98D8,0xD0DA,0xE4BF98,0x4FD8,{0x04,0x04,0x04,0x38,0x07,0xc4,0x09,0x22,0x09,0x22,0x12,0x01,0x15,0xfd,0x30,0x08,0x50,0x10,0x10,0x20,0x17,0xff,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0xe0,0x10,0x20}}, // 俘
{0x505B,0x98D9,0xD0DB,0xE4BF9B,0x4FDB,{0x04,0x40,0x04,0x78,0x04,0x88,0x09,0x10,0x0a,0x20,0x15,0xfe,0x11,0x22,0x31,0x22,0x51,0x42,0x11,0xfe,0x11,0x52,0x10,0x50,0x10,0x90,0x11,0x11,0x12,0x11,0x1c,0x0f}}, // 俛
{0x505C,0x98DA,0xD0DC,0xE4BF91,0x4FD1,{0x04,0x00,0x07,0xfc,0x04,0x08,0x08,0xd0,0x08,0x20,0x13,0xfe,0x12,0x22,0x32,0x22,0x53,0xfe,0x12,0x22,0x12,0x22,0x13,0xfe,0x12,0x22,0x12,0x22,0x12,0x22,0x12,0x26}}, // 俑
{0x505D,0x98DB,0xD0DD,0xE4BF9A,0x4FDA,{0x04,0x00,0x05,0xfc,0x05,0x24,0x09,0x24,0x09,0xfc,0x11,0x24,0x11,0x24,0x31,0xfc,0x50,0x20,0x10,0x20,0x13,0xfe,0x10,0x20,0x10,0x20,0x10,0x20,0x17,0xff,0x10,0x00}}, // 俚
{0x505E,0x98DC,0xD0DE,0xE4BF90,0x4FD0,{0x08,0x42,0x09,0x92,0x0f,0x12,0x11,0x12,0x11,0x12,0x1f,0xd2,0x31,0x12,0x31,0x12,0x53,0x92,0x13,0x52,0x15,0x52,0x15,0x12,0x19,0x02,0x11,0x02,0x11,0x06,0x11,0x02}}, // 俐
{0x505F,0x98DD,0xD0DF,0xE4BFA4,0x4FE4,{0x05,0x08,0x04,0x88,0x04,0x90,0x0f,0xfe,0x08,0x22,0x10,0x22,0x13,0xfe,0x32,0x20,0x52,0x20,0x13,0xfe,0x12,0x62,0x10,0xa2,0x11,0x22,0x12,0x22,0x14,0x2c,0x10,0x20}}, // 俤
{0x5060,0x98DE,0xD0E0,0xE4BFA5,0x4FE5,{0x04,0x20,0x04,0x20,0x07,0xff,0x08,0x20,0x09,0xfc,0x11,0x24,0x11,0x24,0x31,0xfc,0x51,0x24,0x11,0x24,0x11,0xfc,0x10,0x20,0x17,0xff,0x10,0x20,0x10,0x20,0x10,0x20}}, // 俥
{0x5061,0x98DF,0xD0E1,0xE5809A,0x501A,{0x04,0x20,0x04,0x20,0x07,0xfe,0x08,0x50,0x08,0x88,0x13,0x04,0x10,0x00,0x37,0xff,0x50,0x04,0x13,0xe4,0x12,0x24,0x12,0x24,0x13,0xe4,0x12,0x24,0x10,0x0c,0x10,0x04}}, // 倚
{0x5062,0x98E0,0xD0E2,0xE580A8,0x5028,{0x04,0x00,0x05,0xfe,0x05,0x02,0x09,0x02,0x09,0xfe,0x11,0x10,0x11,0x10,0x31,0xff,0x51,0x10,0x11,0x10,0x12,0xfe,0x12,0x82,0x14,0x82,0x18,0x82,0x10,0xfe,0x10,0x82}}, // 倨
{0x5063,0x98E1,0xD0E3,0xE58094,0x5014,{0x04,0x00,0x07,0xfe,0x06,0x02,0x0a,0x02,0x0b,0xfe,0x12,0x10,0x12,0x92,0x32,0x92,0x52,0x92,0x12,0xfe,0x12,0x10,0x12,0x92,0x14,0x92,0x14,0x92,0x18,0xfe,0x10,0x82}}, // 倔
{0x5064,0x98E2,0xD0E4,0xE580AA,0x502A,{0x04,0x20,0x04,0x40,0x07,0x9c,0x0a,0x04,0x0a,0x04,0x13,0xbc,0x12,0x04,0x32,0x04,0x53,0xfc,0x10,0x50,0x10,0x50,0x10,0x90,0x10,0x91,0x11,0x11,0x12,0x11,0x14,0x0f}}, // 倪
{0x5065,0x98E3,0xD0E5,0xE580A5,0x5025,{0x04,0x20,0x04,0x20,0x07,0xff,0x0a,0x52,0x0a,0x50,0x14,0x50,0x10,0x92,0x31,0x0e,0x52,0x00,0x11,0xfc,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x17,0xff,0x10,0x00}}, // 倥
{0x5066,0x98E4,0xD0E6,0xE58085,0x5005,{0x04,0x20,0x04,0x20,0x07,0xff,0x09,0x08,0x09,0x08,0x11,0x8c,0x12,0x52,0x34,0x20,0x50,0x20,0x17,0xff,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20}}, // 倅
{0x5067,0x98E5,0xD0E7,0xE4BC9C,0x4F1C,{0x04,0x40,0x04,0x40,0x07,0xf8,0x08,0x48,0x08,0x88,0x10,0x89,0x11,0x09,0x32,0x07,0x54,0x20,0x10,0x20,0x17,0xff,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20}}, // 伜
{0x5068,0x98E6,0xD0E8,0xE4BFB6,0x4FF6,{0x09,0x00,0x09,0x3e,0x09,0x02,0x19,0xe2,0x11,0x12,0x31,0x12,0x3f,0xf4,0x51,0x14,0x11,0x14,0x15,0x88,0x15,0x48,0x15,0x4c,0x19,0x14,0x11,0x22,0x13,0x42,0x10,0x81}}, // 俶
{0x5069,0x98E7,0xD0E9,0xE580A1,0x5021,{0x04,0x00,0x05,0xfc,0x05,0x04,0x09,0x04,0x09,0xfc,0x11,0x04,0x11,0x04,0x31,0xfc,0x50,0x00,0x13,0xfe,0x12,0x02,0x13,0xfe,0x12,0x02,0x12,0x02,0x13,0xfe,0x12,0x02}}, // 倡
{0x506A,0x98E8,0xD0EA,0xE580A9,0x5029,{0x04,0x20,0x04,0x20,0x07,0xfe,0x08,0x20,0x09,0xfc,0x10,0x20,0x17,0xff,0x30,0x00,0x51,0xfc,0x11,0x24,0x11,0x24,0x11,0xfc,0x11,0x04,0x11,0x04,0x11,0x04,0x11,0x0c}}, // 倩
{0x506B,0x98E9,0xD0EB,0xE580AC,0x502C,{0x04,0x20,0x04,0x20,0x04,0x3f,0x08,0x20,0x09,0xfc,0x11,0x04,0x11,0x04,0x31,0xfc,0x51,0x04,0x11,0x04,0x11,0xfc,0x10,0x20,0x17,0xff,0x10,0x20,0x10,0x20,0x10,0x20}}, // 倬
{0x506C,0x98EA,0xD0EC,0xE4BFBE,0x4FFE,{0x04,0x20,0x04,0x40,0x07,0xfc,0x0a,0x24,0x0a,0x24,0x13,0xfc,0x12,0x24,0x32,0x24,0x53,0xfc,0x10,0x90,0x11,0x10,0x17,0xff,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10}}, // 俾
{0x506D,0x98EB,0xD0ED,0xE4BFAF,0x4FEF,{0x04,0x20,0x04,0x20,0x07,0xff,0x0a,0x00,0x0a,0x44,0x12,0x44,0x12,0x7f,0x32,0x84,0x52,0xa4,0x13,0x94,0x12,0x94,0x12,0x84,0x14,0x84,0x14,0x84,0x18,0x84,0x10,0x8c}}, // 俯
{0x506E,0x98EC,0xD0EE,0xE58091,0x5011,{0x08,0x00,0x0b,0xde,0x0a,0x52,0x0b,0xde,0x12,0x52,0x12,0x52,0x33,0xde,0x32,0x02,0x52,0x02,0x12,0x02,0x12,0x02,0x12,0x02,0x12,0x02,0x12,0x02,0x12,0x0e,0x12,0x02}}, // 們
{0x506F,0x98ED,0xD0EF,0xE58086,0x5006,{0x08,0x00,0x0f,0xff,0x08,0x20,0x08,0x20,0x13,0xfe,0x12,0x22,0x32,0x22,0x33,0xfe,0x52,0x66,0x12,0xaa,0x12,0xaa,0x13,0x76,0x12,0x22,0x12,0x22,0x12,0x26,0x12,0x22}}, // 倆
{0x5070,0x98EE,0xD0F0,0xE58183,0x5043,{0x08,0x00,0x0b,0xff,0x0a,0x00,0x12,0x7e,0x12,0x42,0x32,0x7e,0x32,0x42,0x52,0x7e,0x12,0x10,0x13,0xff,0x12,0x24,0x12,0x78,0x12,0x14,0x12,0x62,0x13,0xff,0x12,0x00}}, // 偃
{0x5071,0x98EF,0xD0F1,0xE58187,0x5047,{0x04,0x00,0x07,0xde,0x06,0x42,0x0a,0x42,0x0a,0x42,0x13,0xde,0x12,0x00,0x32,0x7e,0x53,0xa4,0x12,0x24,0x12,0x14,0x13,0x98,0x12,0x08,0x12,0x14,0x12,0x22,0x12,0xc1}}, // 假
{0x5072,0x98F0,0xD0F2,0xE69C83,0x6703,{0x00,0x80,0x00,0x80,0x01,0x40,0x06,0x30,0x18,0x0c,0x7f,0xff,0x14,0x94,0x12,0xa4,0x1f,0xfc,0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 會
{0x5073,0x98F1,0xD0F3,0xE58195,0x5055,{0x05,0x10,0x05,0x32,0x05,0xdc,0x09,0x10,0x09,0x10,0x11,0x31,0x11,0xcf,0x32,0x20,0x50,0x40,0x11,0xfc,0x11,0x04,0x11,0xfc,0x11,0x04,0x11,0x04,0x11,0xfc,0x11,0x04}}, // 偕
{0x5074,0x98F2,0xD0F4,0xE58190,0x5050,{0x04,0x20,0x07,0xff,0x04,0x48,0x08,0x30,0x08,0xcc,0x13,0xff,0x12,0x08,0x32,0x10,0x52,0x62,0x13,0x84,0x12,0x08,0x12,0x31,0x14,0xc2,0x14,0x0c,0x18,0x30,0x11,0xc0}}, // 偐
{0x5075,0x98F3,0xD0F5,0xE58188,0x5048,{0x04,0x00,0x05,0xfc,0x05,0x04,0x09,0xfc,0x09,0x04,0x11,0x04,0x11,0xfc,0x30,0x80,0x51,0xfe,0x12,0x22,0x1d,0x32,0x11,0x52,0x11,0x82,0x11,0xfa,0x11,0x02,0x10,0x1c}}, // 偈
{0x5076,0x98F4,0xD0F6,0xE5819A,0x505A,{0x09,0x10,0x09,0x10,0x09,0x10,0x0f,0xdf,0x11,0x24,0x11,0x24,0x31,0x44,0x31,0x14,0x57,0xd4,0x14,0x54,0x14,0x48,0x14,0x48,0x17,0xd4,0x14,0x24,0x10,0x42,0x11,0x81}}, // 做
{0x5077,0x98F5,0xD0F7,0xE58196,0x5056,{0x04,0x40,0x04,0x44,0x07,0xfc,0x08,0x48,0x08,0x48,0x10,0x50,0x17,0xff,0x30,0x48,0x50,0x84,0x10,0xfc,0x11,0x84,0x12,0xfc,0x14,0x84,0x10,0x84,0x10,0xfc,0x10,0x84}}, // 偖
{0x5078,0x98F6,0xD0F8,0xE581AC,0x506C,{0x04,0x80,0x04,0x80,0x04,0xfe,0x09,0x2a,0x09,0x2a,0x12,0xea,0x14,0x5a,0x30,0x96,0x51,0x22,0x10,0x0c,0x12,0xa0,0x12,0x92,0x12,0x91,0x14,0x85,0x18,0x45,0x10,0x3c}}, // 偬
{0x5079,0x98F7,0xD0F9,0xE581B8,0x5078,{0x04,0xe0,0x04,0x20,0x04,0x50,0x08,0x88,0x0b,0x04,0x1d,0xfb,0x10,0x00,0x33,0xd2,0x52,0x52,0x13,0x52,0x12,0xe4,0x13,0x64,0x12,0xe4,0x12,0x52,0x12,0x52,0x12,0xd2}}, // 偸
{0x507A,0x98F8,0xD0FA,0xE58280,0x5080,{0x04,0x20,0x04,0x40,0x07,0xfc,0x0a,0x44,0x0a,0x44,0x13,0xfc,0x12,0x44,0x32,0x44,0x53,0xfc,0x10,0xa4,0x10,0xa4,0x11,0x2a,0x11,0x3e,0x12,0x21,0x14,0x11,0x18,0x0f}}, // 傀
{0x507B,0x98F9,0xD0FB,0xE5829A,0x509A,{0x09,0x10,0x09,0x10,0x09,0x10,0x1f,0xdf,0x10,0x14,0x12,0xa4,0x32,0xa4,0x34,0x54,0x5a,0xb4,0x12,0x94,0x11,0x08,0x11,0x88,0x12,0x4c,0x12,0x14,0x14,0x22,0x18,0xc1}}, // 傚
{0x507C,0x98FA,0xD0FC,0xE58285,0x5085,{0x04,0x24,0x04,0x22,0x07,0xff,0x08,0x20,0x0b,0xfc,0x12,0x24,0x13,0xfc,0x32,0x24,0x53,0xfc,0x12,0x24,0x10,0x08,0x17,0xff,0x11,0x08,0x10,0x88,0x10,0x88,0x10,0x18}}, // 傅
{0x507D,0x98FB,0xD0FD,0xE582B4,0x50B4,{0x04,0x00,0x07,0xfe,0x06,0x00,0x0a,0x78,0x0a,0x48,0x12,0x48,0x12,0x78,0x32,0x00,0x52,0xee,0x12,0xaa,0x12,0xaa,0x12,0xee,0x12,0xaa,0x12,0x00,0x13,0xff,0x12,0x00}}, // 傴
{0x507E,0x98FC,0xD0FE,0xE582B2,0x50B2,{0x09,0x10,0x09,0x10,0x0f,0xd0,0x09,0x1f,0x11,0x14,0x17,0xe4,0x31,0x44,0x31,0x14,0x5f,0xf4,0x11,0x14,0x11,0xd8,0x11,0x48,0x12,0x54,0x12,0x54,0x14,0x62,0x11,0x81}}, // 傲
{0x5121,0x9940,0xD1A1,0xE58389,0x50C9,{0x00,0x80,0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x1b,0xec,0x60,0x03,0x1f,0x7c,0x11,0x44,0x11,0x44,0x1f,0x7c,0x04,0x10,0x06,0x18,0x09,0x24,0x11,0x42,0x60,0x80}}, // 僉
{0x5122,0x9941,0xD1A2,0xE5838A,0x50CA,{0x08,0x00,0x0f,0xff,0x08,0x90,0x0b,0xfc,0x12,0x94,0x12,0x94,0x33,0xfc,0x30,0x80,0x57,0xff,0x11,0x08,0x13,0xf4,0x15,0x13,0x19,0xf0,0x11,0x04,0x11,0x04,0x10,0xfc}}, // 僊
{0x5123,0x9942,0xD1A3,0xE582B3,0x50B3,{0x04,0x20,0x04,0x20,0x07,0xff,0x08,0x20,0x0b,0xfc,0x12,0x24,0x13,0xfc,0x32,0x24,0x53,0xfc,0x10,0x2e,0x17,0xf9,0x10,0x08,0x17,0xfe,0x11,0x08,0x10,0x88,0x10,0x18}}, // 傳
{0x5124,0x9943,0xD1A4,0xE58382,0x50C2,{0x04,0x20,0x05,0xfe,0x05,0x22,0x0f,0xff,0x09,0x22,0x11,0xfe,0x10,0x20,0x31,0xfe,0x51,0x22,0x11,0xfe,0x10,0x20,0x17,0xff,0x10,0x44,0x10,0xf8,0x10,0x34,0x11,0xc2}}, // 僂
{0x5125,0x9944,0xD1A5,0xE58396,0x50D6,{0x04,0x20,0x07,0xff,0x04,0x20,0x0b,0xfc,0x08,0x00,0x13,0xfc,0x12,0x04,0x33,0xfc,0x51,0x08,0x10,0x90,0x1f,0xff,0x10,0x00,0x13,0xfc,0x12,0x04,0x13,0xfc,0x12,0x04}}, // 僖
{0x5126,0x9945,0xD1A6,0xE5839E,0x50DE,{0x08,0x18,0x0b,0xe0,0x09,0x48,0x0a,0x44,0x17,0xf4,0x12,0x10,0x32,0x10,0x33,0xfc,0x52,0x04,0x12,0x04,0x13,0xff,0x14,0x25,0x14,0x95,0x1a,0x51,0x11,0x42,0x11,0x0c}}, // 僞
{0x5127,0x9946,0xD1A7,0xE583A5,0x50E5,{0x04,0x20,0x05,0xfc,0x04,0x20,0x0b,0xfe,0x08,0x00,0x11,0x04,0x17,0xdf,0x31,0x04,0x51,0xc4,0x16,0x1f,0x10,0x00,0x17,0xff,0x10,0x50,0x10,0x91,0x13,0x11,0x1c,0x0f}}, // 僥
{0x5128,0x9947,0xD1A8,0xE583AD,0x50ED,{0x08,0x84,0x0f,0xde,0x0a,0x94,0x0a,0x94,0x17,0xff,0x11,0xac,0x32,0xcd,0x32,0x97,0x54,0x20,0x11,0xfc,0x11,0x04,0x11,0xfc,0x11,0x04,0x11,0x04,0x11,0xfc,0x11,0x04}}, // 僭
{0x5129,0x9948,0xD1A9,0xE583A3,0x50E3,{0x09,0x08,0x09,0x08,0x0f,0xde,0x09,0x08,0x17,0xff,0x11,0x08,0x32,0x8c,0x32,0x52,0x54,0x21,0x19,0xfc,0x11,0x04,0x11,0xfc,0x11,0x04,0x11,0x04,0x11,0xfc,0x11,0x04}}, // 僣
{0x512A,0x9949,0xD1AA,0xE583AE,0x50EE,{0x04,0x20,0x04,0x20,0x07,0xfe,0x08,0x88,0x0f,0xff,0x10,0x00,0x11,0xfc,0x31,0x24,0x51,0xfc,0x11,0x24,0x11,0xfc,0x10,0x20,0x13,0xfe,0x10,0x20,0x17,0xff,0x10,0x00}}, // 僮
{0x512B,0x994A,0xD1AB,0xE583B9,0x50F9,{0x04,0x00,0x07,0xff,0x04,0x90,0x0b,0xfe,0x0a,0x92,0x13,0xfe,0x10,0x00,0x31,0xfc,0x51,0x04,0x11,0xfc,0x11,0x04,0x11,0xfc,0x11,0x04,0x11,0xfc,0x10,0x8c,0x13,0x02}}, // 價
{0x512C,0x994B,0xD1AC,0xE583B5,0x50F5,{0x04,0x00,0x07,0xff,0x04,0x00,0x09,0xfc,0x09,0x24,0x11,0xfc,0x11,0x24,0x37,0xff,0x50,0x00,0x11,0xfc,0x11,0x24,0x11,0xfc,0x11,0x24,0x11,0xfc,0x17,0xff,0x10,0x00}}, // 僵
{0x512D,0x994C,0xD1AD,0xE58489,0x5109,{0x04,0x20,0x04,0x20,0x04,0x50,0x08,0x88,0x09,0x04,0x16,0xfb,0x10,0x00,0x33,0xde,0x52,0x52,0x12,0x52,0x13,0xde,0x11,0x08,0x11,0x08,0x11,0x8c,0x12,0x52,0x14,0x21}}, // 儉
{0x512E,0x994D,0xD1AE,0xE58481,0x5101,{0x04,0x88,0x04,0x90,0x05,0xff,0x09,0x10,0x0b,0xfe,0x15,0x10,0x11,0xfe,0x31,0x10,0x51,0xff,0x10,0x00,0x13,0xde,0x12,0x52,0x12,0x52,0x12,0x72,0x12,0x02,0x12,0x06}}, // 儁
{0x512F,0x994E,0xD1AF,0xE58482,0x5102,{0x04,0x50,0x05,0xfc,0x05,0x54,0x09,0xfc,0x09,0x54,0x11,0xfc,0x10,0x00,0x33,0xff,0x52,0x00,0x12,0xfc,0x12,0x00,0x13,0xff,0x12,0xa4,0x14,0x98,0x18,0xec,0x13,0x03}}, // 儂
{0x5130,0x994F,0xD1B0,0xE58496,0x5116,{0x08,0x08,0x0f,0xc8,0x0d,0x08,0x15,0x1f,0x17,0xd0,0x34,0x60,0x37,0xdf,0x55,0x00,0x17,0xc0,0x10,0x00,0x13,0xfe,0x12,0x52,0x12,0x52,0x12,0x52,0x1f,0xff,0x10,0x00}}, // 儖
{0x5131,0x9950,0xD1B1,0xE58495,0x5115,{0x04,0x20,0x04,0x20,0x07,0xff,0x08,0x51,0x0f,0xae,0x12,0xaa,0x12,0xaa,0x35,0xad,0x50,0x00,0x11,0x04,0x11,0xfc,0x11,0x04,0x11,0xfc,0x11,0x04,0x12,0x04,0x14,0x04}}, // 儕
{0x5132,0x9951,0xD1B2,0xE58494,0x5114,{0x04,0x20,0x07,0xfe,0x04,0x20,0x09,0xfc,0x08,0x00,0x17,0xff,0x10,0x22,0x33,0xf8,0x50,0x00,0x17,0xff,0x10,0x04,0x17,0xff,0x14,0xa4,0x14,0x94,0x17,0x84,0x10,0x0c}}, // 儔
{0x5133,0x9952,0xD1B3,0xE5849A,0x511A,{0x04,0x88,0x04,0x88,0x07,0xff,0x08,0x88,0x0b,0xfe,0x12,0x52,0x13,0xfe,0x30,0x00,0x53,0xff,0x12,0x22,0x14,0x7c,0x10,0xc4,0x13,0x28,0x10,0x10,0x10,0x60,0x13,0x80}}, // 儚
{0x5134,0x9953,0xD1B4,0xE584A1,0x5121,{0x04,0x00,0x05,0xfc,0x05,0x24,0x09,0xfc,0x09,0x24,0x11,0x24,0x11,0xfc,0x30,0x00,0x57,0xdf,0x15,0x55,0x15,0x55,0x17,0xdf,0x15,0x55,0x15,0x55,0x17,0xdf,0x14,0x51}}, // 儡
{0x5135,0x9954,0xD1B5,0xE584BA,0x513A,{0x0a,0x8a,0x0f,0xea,0x0a,0x94,0x0b,0x9f,0x11,0x34,0x17,0xd4,0x35,0x54,0x37,0xdf,0x51,0x14,0x17,0xd4,0x11,0x1f,0x17,0xd4,0x12,0x94,0x12,0x54,0x14,0x5f,0x18,0x00}}, // 儺
{0x5136,0x9955,0xD1B6,0xE584B7,0x5137,{0x0b,0xdf,0x08,0x00,0x0f,0xdf,0x0c,0x51,0x15,0x55,0x10,0x20,0x33,0xff,0x32,0x50,0x53,0xfe,0x12,0x52,0x13,0xfe,0x13,0x10,0x15,0xfe,0x15,0x10,0x19,0xd1,0x13,0x0f}}, // 儷
{0x5137,0x9956,0xD1B7,0xE584BC,0x513C,{0x08,0x00,0x0b,0xde,0x0a,0x52,0x0b,0xde,0x10,0x00,0x17,0xff,0x34,0x08,0x37,0xe8,0x54,0x8f,0x17,0xf2,0x15,0x4a,0x15,0xca,0x15,0xc4,0x15,0x6c,0x1b,0xd2,0x10,0x61}}, // 儼
{0x5138,0x9957,0xD1B8,0xE584BB,0x513B,{0x05,0x24,0x04,0xa8,0x07,0xfe,0x0a,0x8a,0x0a,0xfa,0x10,0x00,0x11,0xfc,0x31,0x2c,0x51,0xb4,0x11,0xfc,0x10,0x20,0x13,0xfe,0x10,0x20,0x17,0xff,0x12,0x92,0x14,0x49}}, // 儻
{0x5139,0x9958,0xD1B9,0xE584BF,0x513F,{0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x04,0x21,0x04,0x21,0x08,0x11,0x10,0x0f,0x60,0x00}}, // 儿
{0x513A,0x9959,0xD1BA,0xE58580,0x5140,{0x00,0x02,0x7f,0xff,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x04,0x20,0x04,0x21,0x08,0x11,0x10,0x0f,0x60,0x00}}, // 兀
{0x513B,0x995A,0xD1BB,0xE58592,0x5152,{0x01,0x00,0x02,0x00,0x1c,0xfc,0x10,0x04,0x10,0x04,0x1e,0x7c,0x10,0x04,0x10,0x04,0x10,0x04,0x1f,0xfc,0x12,0x44,0x02,0x40,0x02,0x41,0x04,0x41,0x18,0x21,0x60,0x1f}}, // 兒
{0x513C,0x995B,0xD1BC,0xE5858C,0x514C,{0x01,0xe0,0x04,0x20,0x04,0x20,0x08,0x10,0x0f,0xf0,0x18,0x18,0x28,0x14,0x48,0x13,0x0f,0xf0,0x0a,0x50,0x02,0x40,0x02,0x40,0x02,0x40,0x04,0x41,0x18,0x21,0x60,0x1f}}, // 兌
{0x513D,0x995C,0xD1BD,0xE58594,0x5154,{0x01,0x00,0x01,0xe0,0x02,0x20,0x04,0x40,0x18,0x80,0x7f,0xf8,0x10,0x88,0x10,0x88,0x11,0x08,0x1f,0xf8,0x01,0x50,0x02,0x48,0x02,0x48,0x04,0x41,0x18,0x21,0x60,0x1f}}, // 兔
{0x513E,0x995D,0xD1BE,0xE585A2,0x5162,{0x08,0x10,0x08,0x10,0x7f,0xff,0x08,0x10,0x08,0x10,0x3e,0x7c,0x22,0x44,0x22,0x44,0x22,0x44,0x3e,0x7c,0x14,0x28,0x14,0x28,0x15,0x48,0x26,0x49,0x2c,0x89,0x41,0x07}}, // 兢
{0x513F,0x995E,0xD1BF,0xE7ABB8,0x7AF8,{0x08,0x10,0x3f,0x7e,0x12,0x24,0x12,0x24,0x7f,0xff,0x00,0x00,0x3e,0x7c,0x22,0x44,0x3e,0x7c,0x22,0x44,0x3e,0x7c,0x14,0x28,0x15,0x28,0x16,0x49,0x2c,0x89,0x43,0x07}}, // 竸
{0x5140,0x995F,0xD1C0,0xE585A9,0x5169,{0x00,0x00,0x7f,0xff,0x00,0x80,0x00,0x80,0x3f,0xfe,0x20,0x82,0x20,0x82,0x2c,0xb2,0x24,0x92,0x24,0x92,0x2a,0xaa,0x2a,0xaa,0x31,0xc6,0x20,0x82,0x20,0x8e,0x20,0x82}}, // 兩
{0x5141,0x9960,0xD1C1,0xE585AA,0x516A,{0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x67,0xf3,0x00,0x00,0x3e,0x22,0x22,0x22,0x2a,0x44,0x26,0x88,0x23,0x10,0x2a,0x88,0x26,0x44,0x22,0x22,0x26,0x22}}, // 兪
{0x5142,0x9961,0xD1C2,0xE585AE,0x516E,{0x00,0xe0,0x02,0x20,0x02,0x10,0x04,0x10,0x0f,0xf8,0x11,0x04,0x21,0x02,0x42,0x01,0x07,0xf8,0x04,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x10,0x00,0x10,0x00,0x60}}, // 兮
{0x5143,0x9962,0xD1C3,0xE58680,0x5180,{0x02,0x22,0x7e,0x24,0x02,0x39,0x0e,0x21,0x72,0x1f,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x02,0x20,0x1f,0xfc,0x02,0x20,0x7f,0xff,0x06,0x38,0x78,0x06}}, // 冀
{0x5144,0x9963,0xD1C4,0xE58682,0x5182,{0x00,0x00,0x3f,0xfe,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x0e,0x20,0x02}}, // 冂
{0x5145,0x9964,0xD1C5,0xE59B98,0x56D8,{0x00,0x00,0x3f,0xfe,0x20,0x02,0x20,0x02,0x27,0xe2,0x24,0x22,0x24,0x22,0x27,0xe2,0x24,0x22,0x24,0x02,0x24,0x12,0x24,0x12,0x23,0xf2,0x20,0x02,0x20,0x0e,0x20,0x02}}, // 囘
{0x5146,0x9965,0xD1C6,0xE5868C,0x518C,{0x00,0x00,0x1e,0x3c,0x12,0x24,0x12,0x24,0x12,0x24,0x12,0x24,0x12,0x24,0x7f,0xff,0x12,0x24,0x12,0x24,0x12,0x24,0x12,0x24,0x12,0x44,0x12,0x44,0x26,0x84,0x41,0x0c}}, // 册
{0x5147,0x9966,0xD1C7,0xE58689,0x5189,{0x00,0x80,0x00,0x80,0x00,0x80,0x1f,0xfc,0x10,0x84,0x10,0x84,0x1f,0xfc,0x10,0x84,0x10,0x84,0x10,0x84,0x7f,0xff,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x1c,0x10,0x04}}, // 冉
{0x5148,0x9967,0xD1C8,0xE5868F,0x518F,{0x00,0x00,0x3f,0xfe,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x26,0x24,0x1e,0x28,0x02,0x33,0xe2,0x22,0x22,0x22,0x22,0x22,0x22,0x23,0xe2,0x22,0x22,0x20,0x06,0x20,0x02}}, // 冏
{0x5149,0x9968,0xD1C9,0xE58691,0x5191,{0x00,0x80,0x00,0x80,0x3f,0xfe,0x20,0x82,0x3f,0xfe,0x20,0x82,0x3f,0xfe,0x00,0x00,0x1f,0xfc,0x10,0x04,0x17,0xf4,0x10,0x04,0x17,0xf4,0x10,0x04,0x10,0x0c,0x10,0x04}}, // 冑
{0x514A,0x9969,0xD1CA,0xE58693,0x5193,{0x02,0x20,0x02,0x20,0x3f,0xfe,0x02,0x20,0x1f,0xfc,0x02,0x20,0x7f,0xff,0x00,0x80,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x08,0x88,0x7f,0xff,0x08,0x08,0x08,0x18,0x08,0x08}}, // 冓
{0x514B,0x996A,0xD1CB,0xE58695,0x5195,{0x00,0x00,0x3f,0xfc,0x20,0x04,0x2f,0xf4,0x20,0x04,0x2f,0xf4,0x22,0x04,0x07,0xc0,0x18,0x80,0x7f,0xf0,0x11,0x10,0x11,0x10,0x1f,0xf2,0x02,0x42,0x0c,0x42,0x70,0x3e}}, // 冕
{0x514C,0x996B,0xD1CC,0xE58696,0x5196,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x3f,0xff,0x20,0x02,0x20,0x04,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // 冖
{0x514D,0x996C,0xD1CD,0xE586A4,0x51A4,{0x00,0x00,0x3f,0xfe,0x21,0x02,0x23,0xe4,0x44,0x40,0x18,0x80,0x7f,0xf8,0x11,0x08,0x11,0x08,0x1f,0xf8,0x02,0x40,0x02,0x50,0x04,0x48,0x08,0x42,0x10,0x22,0x60,0x1e}}, // 冤
{0x514E,0x996D,0xD1CE,0xE586A6,0x51A6,{0x00,0x00,0x3f,0xfe,0x20,0x24,0x40,0x20,0x3e,0x3c,0x00,0x20,0x00,0xf8,0x7f,0x08,0x14,0x48,0x14,0x50,0x14,0x30,0x14,0x48,0x15,0x86,0x24,0x02,0x22,0x02,0x41,0xfe}}, // 冦
{0x514F,0x996E,0xD1CF,0xE586A2,0x51A2,{0x00,0x00,0x3f,0xfe,0x20,0x04,0x20,0x00,0x5f,0xf8,0x02,0x00,0x0d,0x08,0x71,0x48,0x12,0xd0,0x0c,0xa0,0x79,0xa0,0x06,0x90,0x0c,0x8c,0x70,0x83,0x00,0x80,0x03,0x00}}, // 冢
{0x5150,0x996F,0xD1D0,0xE586A9,0x51A9,{0x00,0x00,0x3f,0xfe,0x21,0x04,0x22,0x00,0x4c,0xf0,0x08,0x10,0x0f,0x70,0x08,0x10,0x0f,0xf0,0x04,0x00,0x0f,0xfc,0x10,0x24,0x64,0x94,0x12,0x54,0x12,0x44,0x20,0x18}}, // 冩
{0x5151,0x9970,0xD1D1,0xE586AA,0x51AA,{0x00,0x00,0x3f,0xfe,0x24,0x24,0x3f,0xfe,0x48,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x02,0x00,0x7f,0xfe,0x09,0x10,0x1f,0xf8,0x29,0x14,0x49,0x12,0x09,0x60,0x01,0x00}}, // 冪
{0x5152,0x9971,0xD1D2,0xE586AB,0x51AB,{0x00,0x00,0x02,0x00,0x01,0x00,0x00,0x80,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x20,0x00,0x40,0x00,0x80,0x00,0x80,0x01,0x00,0x02,0x00,0x04,0x00,0x00,0x00}}, // 冫
{0x5153,0x9972,0xD1D3,0xE586B3,0x51B3,{0x00,0x40,0x20,0x40,0x10,0x40,0x13,0xfc,0x00,0x44,0x00,0x44,0x00,0x44,0x08,0x44,0x0f,0xff,0x10,0x60,0x10,0x50,0x20,0x90,0x20,0x88,0x41,0x04,0x42,0x02,0x0c,0x01}}, // 决
{0x5154,0x9973,0xD1D4,0xE586B1,0x51B1,{0x00,0x00,0x27,0xfe,0x10,0x80,0x10,0x80,0x00,0x80,0x00,0xf8,0x00,0x88,0x09,0x08,0x09,0x08,0x11,0x08,0x13,0xf0,0x22,0x10,0x20,0x10,0x40,0x10,0x4f,0xff,0x00,0x00}}, // 冱
{0x5155,0x9974,0xD1D5,0xE586B2,0x51B2,{0x00,0x20,0x20,0x20,0x10,0x20,0x10,0x20,0x03,0xfe,0x02,0x22,0x02,0x22,0x0a,0x22,0x0a,0x22,0x13,0xfe,0x12,0x22,0x20,0x20,0x20,0x20,0x40,0x20,0x40,0x20,0x00,0x20}}, // 冲
{0x5156,0x9975,0xD1D6,0xE586B0,0x51B0,{0x00,0x40,0x20,0x40,0x10,0x42,0x10,0x42,0x00,0x64,0x0f,0x64,0x01,0x68,0x01,0x50,0x09,0x50,0x12,0x48,0x12,0x48,0x24,0x44,0x24,0x42,0x48,0x41,0x50,0xc0,0x00,0x40}}, // 冰
{0x5157,0x9976,0xD1D7,0xE586B5,0x51B5,{0x00,0x00,0x23,0xfc,0x12,0x04,0x12,0x04,0x02,0x04,0x02,0x04,0x02,0x04,0x0b,0xfc,0x0a,0x94,0x10,0x90,0x10,0x90,0x20,0x90,0x21,0x11,0x41,0x11,0x42,0x11,0x04,0x0f}}, // 况
{0x5158,0x9977,0xD1D8,0xE586BD,0x51BD,{0x00,0x02,0x2f,0xf2,0x12,0x12,0x12,0x12,0x02,0x12,0x03,0xd2,0x02,0x52,0x12,0x52,0x15,0x52,0x14,0x92,0x28,0x92,0x21,0x02,0x41,0x02,0x42,0x02,0x44,0x02,0x18,0x06}}, // 冽
{0x5159,0x9978,0xD1D9,0xE58785,0x51C5,{0x00,0x00,0x27,0xfe,0x14,0x42,0x14,0x42,0x07,0xfe,0x04,0x42,0x04,0x42,0x04,0xf2,0x14,0x92,0x14,0x92,0x14,0xf2,0x24,0x92,0x24,0x02,0x44,0x02,0x47,0xfe,0x04,0x02}}, // 凅
{0x515A,0x9979,0xD1DA,0xE58789,0x51C9,{0x00,0x20,0x20,0x20,0x10,0x20,0x17,0xff,0x00,0x00,0x01,0xfc,0x01,0x04,0x09,0x04,0x09,0x04,0x11,0xfc,0x10,0x20,0x21,0x28,0x21,0x24,0x42,0x22,0x44,0x62,0x00,0x20}}, // 凉
{0x515B,0x997A,0xD1DB,0xE5879B,0x51DB,{0x00,0x20,0x27,0xff,0x12,0x04,0x12,0xf4,0x02,0x94,0x02,0xf4,0x02,0x04,0x0b,0xfc,0x08,0x00,0x13,0xfc,0x10,0x00,0x2f,0xff,0x21,0x28,0x41,0x24,0x42,0x22,0x04,0x60}}, // 凛
{0x515C,0x997B,0xD1DC,0xE587A0,0x51E0,{0x00,0x00,0x07,0xe0,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x08,0x20,0x08,0x21,0x10,0x21,0x20,0x1f,0x40,0x00}}, // 几
{0x515D,0x997C,0xD1DD,0xE89995,0x8655,{0x00,0x80,0x00,0xfc,0x00,0x80,0x1f,0xff,0x10,0x91,0x10,0xe2,0x17,0x88,0x10,0xf8,0x14,0x00,0x17,0xbc,0x14,0xa4,0x19,0x24,0x35,0x25,0x23,0x47,0x44,0x80,0x18,0x7f}}, // 處
{0x515E,0x997D,0xD1DE,0xE587A9,0x51E9,{0x00,0x00,0x1f,0xf8,0x10,0x08,0x10,0x88,0x10,0x88,0x17,0xf8,0x10,0x88,0x10,0x88,0x11,0xc8,0x11,0xc8,0x12,0xa8,0x12,0xa8,0x14,0x95,0x28,0x85,0x20,0x83,0x40,0x81}}, // 凩
{0x515F,0x997E,0xD1DF,0xE587AD,0x51ED,{0x04,0x08,0x04,0x30,0x09,0xe0,0x10,0x20,0x37,0xff,0x50,0x20,0x10,0x20,0x13,0xfe,0x10,0x00,0x00,0x00,0x07,0xe0,0x04,0x20,0x04,0x20,0x08,0x22,0x10,0x22,0x60,0x1e}}, // 凭
{0x5160,0x9980,0xD1E0,0xE587B0,0x51F0,{0x00,0x00,0x1f,0xfc,0x10,0x84,0x11,0x04,0x17,0xf4,0x14,0x14,0x17,0xf4,0x14,0x14,0x17,0xf4,0x10,0x04,0x17,0xf4,0x10,0x84,0x13,0xe5,0x20,0x85,0x2f,0xfb,0x40,0x01}}, // 凰
{0x5161,0x9981,0xD1E1,0xE587B5,0x51F5,{0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x3f,0xfe,0x20,0x02}}, // 凵
{0x5162,0x9982,0xD1E2,0xE587BE,0x51FE,{0x00,0x00,0x0f,0xf8,0x00,0x10,0x00,0x60,0x20,0x82,0x2e,0xfa,0x2a,0x8a,0x2a,0xaa,0x2a,0xaa,0x2a,0xb2,0x2e,0xd2,0x28,0x8a,0x21,0x86,0x20,0x02,0x3f,0xfe,0x20,0x02}}, // 凾
{0x5163,0x9983,0xD1E3,0xE58884,0x5204,{0x00,0x00,0x7f,0xfc,0x00,0x84,0x00,0x84,0x10,0x84,0x08,0x84,0x04,0x84,0x03,0x04,0x01,0x04,0x01,0x84,0x02,0x64,0x02,0x1c,0x04,0x07,0x08,0x04,0x10,0x08,0x20,0x70}}, // 刄
{0x5164,0x9984,0xD1E4,0xE5888B,0x520B,{0x00,0x82,0x07,0x22,0x7c,0x22,0x04,0x22,0x04,0x22,0x04,0x22,0x7f,0xa2,0x04,0x22,0x04,0x22,0x04,0x22,0x04,0x22,0x08,0x22,0x08,0x02,0x10,0x02,0x20,0x06,0x40,0x02}}, // 刋
{0x5165,0x9985,0xD1E5,0xE58894,0x5214,{0x04,0x02,0x04,0x12,0x04,0x12,0x3f,0x92,0x04,0x92,0x04,0x92,0x04,0x92,0x04,0x92,0x7f,0xf2,0x04,0x12,0x06,0x12,0x09,0x02,0x09,0x02,0x10,0x82,0x20,0x46,0x40,0x02}}, // 刔
{0x5166,0x9986,0xD1E6,0xE5888E,0x520E,{0x10,0x02,0x10,0x12,0x1f,0x92,0x15,0x92,0x25,0x92,0x25,0x92,0x49,0x92,0x0a,0x92,0x12,0x92,0x12,0x92,0x24,0x92,0x44,0x92,0x08,0x82,0x10,0x82,0x20,0x86,0x03,0x02}}, // 刎
{0x5167,0x9987,0xD1E7,0xE588A7,0x5227,{0x04,0x00,0x04,0x7e,0x04,0x12,0x3f,0x92,0x04,0x12,0x04,0x12,0x04,0x12,0x7f,0xd2,0x04,0x12,0x04,0x12,0x08,0x12,0x0a,0x22,0x09,0x22,0x13,0x42,0x7c,0x82,0x00,0x8c}}, // 刧
{0x5168,0x9988,0xD1E8,0xE588AA,0x522A,{0x00,0x02,0x3f,0x92,0x2a,0x92,0x2a,0x92,0x2a,0x92,0x2a,0x92,0x2a,0x92,0x7f,0xd2,0x2a,0x92,0x2a,0x92,0x2a,0x92,0x2a,0x82,0x2a,0x82,0x2a,0x82,0x2a,0x86,0x21,0x82}}, // 刪
{0x5169,0x9989,0xD1E9,0xE588AE,0x522E,{0x00,0x82,0x03,0x12,0x3c,0x12,0x04,0x12,0x04,0x12,0x04,0x12,0x7f,0xd2,0x04,0x12,0x04,0x12,0x04,0x12,0x1f,0x92,0x10,0x82,0x10,0x82,0x10,0x82,0x1f,0x86,0x10,0x82}}, // 刮
{0x516A,0x998A,0xD1EA,0xE588B3,0x5233,{0x04,0x02,0x04,0x12,0x7f,0xd2,0x0a,0x12,0x11,0x12,0x20,0x92,0x5f,0x52,0x00,0x12,0x7f,0xd2,0x08,0x12,0x08,0x12,0x1f,0x02,0x11,0x02,0x01,0x02,0x01,0x06,0x06,0x02}}, // 刳
{0x516B,0x998B,0xD1EB,0xE588B9,0x5239,{0x02,0x02,0x02,0x22,0x34,0x22,0x0c,0x22,0x0a,0x22,0x11,0x22,0x25,0x22,0x44,0x22,0x7f,0xa2,0x04,0x22,0x0e,0x22,0x15,0x02,0x24,0x82,0x44,0x02,0x04,0x06,0x04,0x02}}, // 刹
{0x516C,0x998C,0xD1EC,0xE5898F,0x524F,{0x21,0x00,0x11,0x7e,0x12,0x12,0x7f,0x92,0x12,0x12,0x12,0x12,0x12,0x52,0x7f,0xb2,0x12,0x12,0x12,0x1a,0x12,0x16,0x12,0x23,0x12,0x22,0x22,0x42,0x22,0x82,0x43,0x0c}}, // 剏
{0x516D,0x998D,0xD1ED,0xE58984,0x5244,{0x00,0x02,0x7f,0x92,0x00,0x12,0x12,0x52,0x12,0x52,0x6d,0x92,0x24,0x92,0x12,0x52,0x00,0x12,0x7f,0xd2,0x04,0x12,0x04,0x02,0x04,0x02,0x05,0x82,0x1e,0x06,0x60,0x02}}, // 剄
{0x516E,0x998E,0xD1EE,0xE5898B,0x524B,{0x04,0x04,0x04,0x24,0x7f,0xe4,0x04,0x24,0x04,0x24,0x3f,0xa4,0x20,0xa4,0x20,0xa4,0x20,0xa4,0x3f,0xa4,0x0a,0x04,0x0a,0x04,0x0a,0x0c,0x12,0x01,0x21,0x01,0x40,0xff}}, // 剋
{0x516F,0x998F,0xD1EF,0xE5898C,0x524C,{0x04,0x02,0x04,0x12,0x7f,0xd2,0x04,0x12,0x04,0x12,0x3f,0x92,0x24,0x92,0x24,0x92,0x24,0x92,0x3f,0x92,0x0c,0x12,0x0e,0x02,0x15,0x02,0x24,0x82,0x44,0x06,0x04,0x02}}, // 剌
{0x5170,0x9990,0xD1F0,0xE5899E,0x525E,{0x04,0x02,0x04,0x12,0x7f,0xd2,0x04,0x12,0x0a,0x12,0x31,0x12,0x00,0x12,0x7f,0xf2,0x00,0x92,0x3c,0x92,0x24,0x92,0x24,0x82,0x3c,0x82,0x24,0x82,0x01,0x86,0x00,0x82}}, // 剞
{0x5171,0x9991,0xD1F1,0xE58994,0x5254,{0x00,0x02,0x1f,0x92,0x10,0x92,0x1f,0x92,0x10,0x92,0x10,0x92,0x1f,0x92,0x08,0x12,0x0f,0xd2,0x15,0x52,0x25,0x52,0x49,0x42,0x12,0x42,0x24,0x42,0x08,0x46,0x01,0x82}}, // 剔
{0x5172,0x9992,0xD1F2,0xE589AA,0x526A,{0x04,0x10,0x02,0x20,0x7f,0xff,0x11,0x04,0x1d,0x24,0x13,0x24,0x1d,0x24,0x13,0x24,0x11,0x24,0x13,0x0c,0x00,0x00,0x7f,0xfe,0x01,0x02,0x02,0x02,0x0c,0x02,0x70,0x0c}}, // 剪
{0x5173,0x9993,0xD1F3,0xE589B4,0x5274,{0x04,0x02,0x24,0x92,0x24,0x92,0x3f,0x92,0x00,0x12,0x7f,0xd2,0x00,0x12,0x3f,0x92,0x20,0x92,0x20,0x92,0x3f,0x92,0x11,0x02,0x09,0x02,0x0a,0xc2,0x0f,0x06,0x70,0x02}}, // 剴
{0x5174,0x9994,0xD1F4,0xE589A9,0x5269,{0x01,0x02,0x3e,0x12,0x04,0x12,0x7f,0xd2,0x04,0x12,0x15,0x52,0x75,0x92,0x15,0x12,0x35,0x52,0x54,0xd2,0x0e,0x12,0x0d,0x02,0x14,0x82,0x24,0x42,0x44,0x06,0x04,0x02}}, // 剩
{0x5175,0x9995,0xD1F5,0xE589B3,0x5273,{0x11,0x02,0x11,0x12,0x7f,0xd2,0x11,0x12,0x04,0x12,0x04,0x12,0x0a,0x12,0x11,0x12,0x3f,0x92,0x40,0x52,0x00,0x12,0x3f,0x82,0x20,0x82,0x20,0x82,0x3f,0x86,0x20,0x82}}, // 剳
{0x5176,0x9996,0xD1F6,0xE589BF,0x527F,{0x12,0x82,0x24,0x92,0x6d,0x12,0x12,0x92,0x3f,0x92,0x24,0x92,0x3f,0x92,0x24,0x92,0x3f,0x92,0x04,0x12,0x7f,0xd2,0x0e,0x02,0x15,0x02,0x24,0x82,0x44,0x46,0x04,0x02}}, // 剿
{0x5177,0x9997,0xD1F7,0xE589BD,0x527D,{0x00,0x02,0x7f,0xf2,0x09,0x12,0x3f,0xd2,0x29,0x52,0x29,0x52,0x3f,0xd2,0x00,0x12,0x3f,0xd2,0x00,0x12,0x7f,0xf2,0x12,0x92,0x12,0x42,0x22,0x42,0x42,0x06,0x06,0x02}}, // 剽
{0x5178,0x9998,0xD1F8,0xE58A8D,0x528D,{0x04,0x02,0x04,0x12,0x0a,0x12,0x11,0x12,0x20,0x92,0x5f,0x52,0x00,0x12,0x3b,0x92,0x2a,0x92,0x2a,0x92,0x3b,0x92,0x11,0x12,0x19,0x82,0x26,0x42,0x22,0x02,0x44,0x06}}, // 劍
{0x5179,0x9999,0xD1F9,0xE58A94,0x5294,{0x04,0x00,0x04,0x7e,0x0a,0x12,0x11,0x12,0x20,0x92,0x5f,0x12,0x00,0x52,0x3b,0xb2,0x2a,0x92,0x2a,0x9a,0x3b,0x97,0x11,0x12,0x19,0xa2,0x26,0x62,0x22,0x42,0x44,0x8c}}, // 劔
{0x517A,0x999A,0xD1FA,0xE58A92,0x5292,{0x04,0x00,0x04,0x7e,0x0a,0x12,0x11,0x12,0x20,0x92,0x5f,0x12,0x00,0x32,0x3b,0xb2,0x2a,0xd2,0x2a,0x92,0x3b,0x92,0x11,0x12,0x19,0xa2,0x26,0x62,0x22,0x42,0x44,0x8c}}, // 劒
{0x517B,0x999B,0xD1FB,0xE589B1,0x5271,{0x04,0x00,0x04,0x7e,0x0a,0x12,0x11,0x12,0x3f,0x92,0x44,0x52,0x04,0x12,0x3f,0xb2,0x24,0x92,0x24,0x9a,0x3f,0x96,0x04,0x13,0x0a,0x12,0x11,0x22,0x21,0x42,0x40,0x8c}}, // 剱
{0x517C,0x999C,0xD1FC,0xE58A88,0x5288,{0x00,0x08,0x1f,0x08,0x11,0x7f,0x11,0x22,0x1f,0x14,0x10,0xff,0x1f,0x08,0x29,0x7f,0x29,0x08,0x4f,0x08,0x00,0x00,0x7f,0xfe,0x00,0x82,0x03,0x02,0x0c,0x02,0x70,0x1c}}, // 劈
{0x517D,0x999D,0xD1FD,0xE58A91,0x5291,{0x04,0x02,0x04,0x12,0x7f,0xf2,0x0a,0x52,0x75,0x92,0x35,0x52,0x35,0x52,0x55,0xb2,0x00,0x12,0x10,0x92,0x1f,0x92,0x10,0x82,0x1f,0x82,0x10,0x82,0x20,0x86,0x40,0x82}}, // 劑
{0x517E,0x999E,0xD1FE,0xE8BEA8,0x8FA8,{0x08,0x48,0x09,0x48,0x7f,0x7f,0x23,0x62,0x15,0x52,0x15,0x54,0x7f,0x7f,0x09,0x48,0x09,0x48,0x7f,0x7f,0x09,0x48,0x08,0x48,0x10,0x88,0x10,0x88,0x21,0x08,0x42,0x08}}, // 辨
{0x5221,0x999F,0xD2A1,0xE8BEA7,0x8FA7,{0x10,0x08,0x10,0x08,0x7f,0xfe,0x25,0x52,0x25,0x52,0x29,0x54,0x7d,0x7f,0x11,0x48,0x11,0x48,0x7d,0x7f,0x11,0x48,0x12,0x48,0x12,0x48,0x24,0x48,0x28,0x48,0x41,0x88}}, // 辧
{0x5222,0x99A0,0xD2A2,0xE58AAC,0x52AC,{0x08,0x10,0x08,0x10,0x08,0x10,0x1f,0x90,0x10,0xfe,0x20,0x92,0x3e,0x92,0x52,0x92,0x12,0x92,0x12,0x92,0x1e,0x92,0x12,0xa2,0x00,0xa2,0x00,0xa2,0x01,0x42,0x06,0x8c}}, // 劬
{0x5223,0x99A1,0xD2A3,0xE58AAD,0x52AD,{0x00,0x10,0x7f,0x90,0x08,0x90,0x08,0x90,0x08,0xfe,0x10,0x92,0x20,0x92,0x43,0x12,0x00,0x12,0x3f,0x12,0x21,0x12,0x21,0x22,0x21,0x22,0x21,0x22,0x3f,0x42,0x21,0x8c}}, // 劭
{0x5224,0x99A2,0xD2A4,0xE58ABC,0x52BC,{0x08,0x10,0x08,0x10,0x08,0x10,0x7f,0x90,0x08,0xfe,0x08,0x12,0x08,0x12,0x3f,0x12,0x00,0x12,0x00,0x12,0x3f,0x12,0x21,0x22,0x21,0x22,0x21,0x42,0x3f,0x82,0x21,0x0c}}, // 劼
{0x5225,0x99A3,0xD2A5,0xE58AB5,0x52B5,{0x04,0x90,0x04,0x88,0x08,0x88,0x3f,0xfe,0x00,0x80,0x01,0x40,0x7f,0xff,0x02,0x20,0x04,0x90,0x18,0x8c,0x6f,0xf3,0x01,0x10,0x01,0x10,0x02,0x10,0x0c,0x10,0x30,0x60}}, // 劵
{0x5226,0x99A4,0xD2A6,0xE58B81,0x52C1,{0x00,0x10,0x7f,0x90,0x00,0x10,0x15,0x10,0x15,0x7e,0x2a,0x12,0x6a,0x12,0x15,0x12,0x15,0x12,0x00,0x12,0x7f,0x12,0x08,0x22,0x08,0x22,0x0b,0x22,0x1c,0x42,0x60,0x8c}}, // 勁
{0x5227,0x99A5,0xD2A7,0xE58B8D,0x52CD,{0x04,0x10,0x04,0x10,0x04,0x10,0x7f,0x90,0x00,0x7e,0x1f,0x12,0x11,0x12,0x11,0x12,0x11,0x12,0x1f,0x12,0x04,0x22,0x16,0x22,0x15,0x22,0x25,0x42,0x44,0x82,0x0d,0x0c}}, // 勍
{0x5228,0x99A6,0xD2A8,0xE58B97,0x52D7,{0x00,0x00,0x1f,0xf8,0x10,0x08,0x1f,0xf8,0x10,0x08,0x1f,0xf8,0x00,0x10,0x1f,0x10,0x11,0xfe,0x1f,0x12,0x11,0x12,0x1f,0x22,0x11,0xa2,0x1f,0x42,0x70,0x82,0x01,0x0c}}, // 勗
{0x5229,0x99A7,0xD2A9,0xE58B9E,0x52DE,{0x04,0x10,0x15,0x54,0x15,0x54,0x2a,0x28,0x11,0x44,0x20,0x80,0x7f,0xfe,0x41,0x02,0x41,0x02,0x3f,0xf8,0x01,0x08,0x01,0x08,0x02,0x08,0x04,0x08,0x18,0x08,0x60,0x30}}, // 勞
{0x522A,0x99A8,0xD2AA,0xE58BA3,0x52E3,{0x04,0x10,0x3f,0x10,0x04,0x10,0x3f,0x10,0x04,0x7e,0x7f,0x92,0x00,0x12,0x1f,0x12,0x11,0x12,0x1f,0x12,0x11,0x12,0x1f,0x12,0x11,0x22,0x1f,0x22,0x19,0x42,0x60,0x8c}}, // 勣
{0x522B,0x99A9,0xD2AB,0xE58BA6,0x52E6,{0x12,0x90,0x24,0x90,0x6d,0x10,0x12,0x90,0x3f,0xfe,0x24,0x92,0x3f,0x92,0x24,0x92,0x3f,0x92,0x04,0x12,0x7f,0xd2,0x0d,0x12,0x14,0xa2,0x24,0x22,0x44,0x42,0x04,0x8c}}, // 勦
{0x522C,0x99AA,0xD2AC,0xE9A3AD,0x98ED,{0x08,0x40,0x08,0x40,0x14,0x40,0x1e,0x7f,0x21,0x80,0x7e,0x90,0x23,0x10,0x3e,0xfe,0x22,0x12,0x22,0x12,0x3e,0x12,0x20,0x12,0x3e,0x22,0x20,0x22,0x3f,0x42,0x20,0x8c}}, // 飭
{0x522D,0x99AB,0xD2AD,0xE58BA0,0x52E0,{0x00,0x10,0x7f,0x90,0x2a,0x90,0x4c,0x90,0x19,0xfe,0x6a,0x92,0x0c,0x92,0x0a,0x12,0x11,0x12,0x64,0x92,0x0a,0x12,0x34,0x92,0x09,0x22,0x32,0x22,0x0c,0x42,0x70,0x8c}}, // 勠
{0x522E,0x99AC,0xD2AE,0xE58BB3,0x52F3,{0x02,0x10,0x3c,0x10,0x08,0x10,0x7f,0x90,0x08,0x7e,0x3f,0x12,0x3b,0x12,0x2d,0x12,0x3f,0x12,0x08,0x12,0x3f,0x12,0x08,0x12,0x7f,0xa2,0x35,0x22,0x2a,0x42,0x4a,0x8c}}, // 勳
{0x522F,0x99AD,0xD2AF,0xE58BB5,0x52F5,{0x00,0x08,0x3f,0xc8,0x25,0x08,0x3f,0xc8,0x25,0x7e,0x2f,0x8a,0x2a,0x8a,0x2f,0x8a,0x2a,0x8a,0x2f,0x8a,0x22,0x0a,0x3f,0xd2,0x35,0x52,0x5e,0xe2,0x10,0x42,0x10,0xcc}}, // 勵
{0x5230,0x99AE,0xD2B0,0xE58BB8,0x52F8,{0x09,0x10,0x7f,0xd0,0x09,0x10,0x3b,0x90,0x2a,0xfe,0x3b,0x92,0x12,0x12,0x14,0x12,0x3f,0x92,0x64,0x12,0x3f,0x12,0x24,0x12,0x3f,0x22,0x24,0x22,0x3f,0xc2,0x00,0x8c}}, // 勸
{0x5231,0x99AF,0xD2B1,0xE58BB9,0x52F9,{0x08,0x00,0x08,0x00,0x0f,0xfe,0x08,0x02,0x10,0x02,0x10,0x02,0x20,0x02,0x40,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x04,0x00,0x38}}, // 勹
{0x5232,0x99B0,0xD2B2,0xE58C86,0x5306,{0x08,0x00,0x08,0x00,0x0f,0xfe,0x09,0x22,0x11,0x22,0x11,0x22,0x21,0x22,0x4e,0x22,0x03,0x22,0x04,0xc2,0x18,0x62,0x60,0x92,0x01,0x02,0x06,0x02,0x18,0x04,0x00,0x18}}, // 匆
{0x5233,0x99B1,0xD2B3,0xE58C88,0x5308,{0x08,0x00,0x08,0x00,0x0f,0xfe,0x08,0x02,0x10,0x22,0x12,0x22,0x29,0x4a,0x48,0xca,0x08,0xca,0x08,0xaa,0x09,0x2a,0x0a,0x0a,0x0f,0xfa,0x08,0x0a,0x00,0x04,0x00,0x18}}, // 匈
{0x5234,0x99B2,0xD2B4,0xE794B8,0x7538,{0x04,0x00,0x04,0x00,0x07,0xfe,0x08,0x02,0x0f,0xf2,0x19,0x12,0x29,0x12,0x49,0x12,0x0f,0xf2,0x09,0x12,0x09,0x12,0x09,0x12,0x0f,0xf2,0x08,0x12,0x00,0x04,0x00,0x38}}, // 甸
{0x5235,0x99B3,0xD2B5,0xE58C8D,0x530D,{0x08,0x00,0x08,0x00,0x0f,0xfe,0x08,0x42,0x11,0x22,0x1f,0xfa,0x21,0x02,0x5f,0xf2,0x11,0x12,0x1f,0xf2,0x11,0x12,0x1f,0xf2,0x11,0x12,0x11,0x12,0x11,0x34,0x00,0x18}}, // 匍
{0x5236,0x99B4,0xD2B6,0xE58C90,0x5310,{0x08,0x00,0x08,0x00,0x0f,0xfe,0x10,0x02,0x1f,0xf2,0x20,0x02,0x4f,0xe2,0x08,0x22,0x0f,0xe2,0x00,0x02,0x1f,0xf2,0x11,0x12,0x1f,0xf2,0x11,0x12,0x1f,0xf4,0x10,0x18}}, // 匐
{0x5237,0x99B5,0xD2B7,0xE58C8F,0x530F,{0x08,0x20,0x08,0x20,0x7f,0x3e,0x14,0x22,0x12,0x42,0x21,0x7a,0x7e,0xca,0x00,0x4a,0x7f,0x7a,0x10,0x42,0x10,0x42,0x3e,0x4c,0x22,0x40,0x02,0x41,0x02,0x21,0x0c,0x1f}}, // 匏
{0x5238,0x99B6,0xD2B8,0xE58C95,0x5315,{0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x04,0x08,0x08,0x08,0x10,0x08,0x60,0x09,0x80,0x0e,0x00,0x38,0x00,0x08,0x00,0x08,0x00,0x08,0x02,0x08,0x02,0x04,0x02,0x03,0xfe}}, // 匕
{0x5239,0x99B7,0xD2B9,0xE58C9A,0x531A,{0x00,0x00,0x3f,0xfe,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x02,0x3f,0xff,0x20,0x00}}, // 匚
{0x523A,0x99B8,0xD2BA,0xE58CA3,0x5323,{0x00,0x00,0x3f,0xfe,0x20,0x00,0x27,0xfc,0x24,0x44,0x24,0x44,0x27,0xfc,0x24,0x44,0x24,0x44,0x27,0xfc,0x24,0x44,0x20,0x40,0x20,0x40,0x20,0x40,0x3f,0xff,0x20,0x00}}, // 匣
{0x523B,0x99B9,0xD2BB,0xE58CAF,0x532F,{0x00,0x00,0x3f,0xff,0x28,0x00,0x24,0x88,0x20,0x90,0x31,0xfe,0x29,0x20,0x23,0xfc,0x21,0x20,0x25,0xfc,0x29,0x20,0x29,0x20,0x31,0xfe,0x21,0x00,0x3f,0xff,0x20,0x00}}, // 匯
{0x523C,0x99BA,0xD2BC,0xE58CB1,0x5331,{0x00,0x00,0x3f,0xff,0x20,0x40,0x23,0xfc,0x22,0x44,0x23,0xfc,0x20,0x40,0x2f,0xff,0x21,0x08,0x21,0xf8,0x21,0x08,0x21,0xf8,0x21,0x98,0x26,0x04,0x3f,0xff,0x20,0x00}}, // 匱
{0x523D,0x99BB,0xD2BD,0xE58CB3,0x5333,{0x00,0x00,0x3f,0xff,0x20,0x40,0x20,0xa0,0x21,0x10,0x27,0xec,0x38,0x03,0x27,0xbc,0x24,0xa4,0x27,0xbc,0x22,0x08,0x23,0x0c,0x24,0x92,0x28,0x20,0x3f,0xff,0x20,0x00}}, // 匳
{0x523E,0x99BC,0xD2BE,0xE58CB8,0x5338,{0x00,0x02,0x7f,0xff,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x08,0x00,0x07,0xfe,0x00,0x00}}, // 匸
{0x523F,0x99BD,0xD2BF,0xE58D80,0x5340,{0x00,0x00,0x7f,0xff,0x20,0x00,0x23,0xf0,0x22,0x10,0x22,0x10,0x23,0xf0,0x20,0x00,0x2f,0x3c,0x29,0x24,0x29,0x24,0x29,0x24,0x2f,0x3c,0x20,0x00,0x3f,0xff,0x00,0x00}}, // 區
{0x5240,0x99BE,0xD2C0,0xE58D86,0x5346,{0x02,0x00,0x02,0x00,0x7f,0xe0,0x02,0x20,0x02,0x20,0x04,0x20,0x08,0x22,0x11,0x12,0x61,0x0e,0x01,0x00,0x7f,0xfe,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00}}, // 卆
{0x5241,0x99BF,0xD2C1,0xE58D85,0x5345,{0x08,0x88,0x08,0x88,0x08,0x88,0x08,0x88,0x08,0x88,0x08,0x88,0x7f,0xff,0x08,0x88,0x08,0x88,0x08,0x88,0x08,0x88,0x08,0x88,0x10,0x88,0x10,0x88,0x20,0x88,0x40,0x88}}, // 卅
{0x5242,0x99C0,0xD2C2,0xE4B897,0x4E17,{0x08,0x88,0x08,0x88,0x08,0x88,0x08,0x88,0x08,0x88,0x08,0x88,0x7f,0xff,0x08,0x88,0x08,0x88,0x08,0x88,0x08,0x88,0x08,0x88,0x08,0x88,0x08,0x88,0x0f,0xf8,0x08,0x08}}, // 丗
{0x5243,0x99C1,0xD2C3,0xE58D89,0x5349,{0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x04,0x88,0x04,0x08,0x04,0x08,0x7f,0xff,0x04,0x08,0x04,0x08,0x04,0x08,0x08,0x08,0x08,0x08,0x10,0x08,0x20,0x08}}, // 卉
{0x5244,0x99C2,0xD2C4,0xE58D8D,0x534D,{0x00,0x02,0x7f,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x00,0x82,0x3f,0xfe,0x20,0x80,0x20,0x80,0x20,0x80,0x20,0x80,0x20,0x80,0x20,0x80,0x20,0xff,0x20,0x00}}, // 卍
{0x5245,0x99C3,0xD2C5,0xE58796,0x51D6,{0x00,0x88,0x20,0x90,0x11,0xfe,0x11,0x20,0x03,0xfc,0x05,0x20,0x01,0xfc,0x09,0x20,0x31,0xfe,0x40,0x80,0x00,0x80,0x7f,0xfe,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 凖
{0x5246,0x99C4,0xD2C6,0xE58D9E,0x535E,{0x00,0x80,0x00,0x82,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0xc0,0x00,0xb0,0x00,0x88,0x00,0x84,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 卞
{0x5247,0x99C5,0xD2C7,0xE58DA9,0x5369,{0x00,0x00,0x0f,0xf0,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0xe0,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00}}, // 卩
{0x5248,0x99C6,0xD2C8,0xE58DAE,0x536E,{0x00,0x08,0x00,0x70,0x1f,0x80,0x10,0x00,0x10,0x00,0x1f,0xff,0x10,0x00,0x13,0xf8,0x12,0x08,0x12,0x08,0x12,0x08,0x12,0x38,0x22,0x02,0x22,0x02,0x41,0x02,0x00,0xfe}}, // 卮
{0x5249,0x99C7,0xD2C9,0xE5A498,0x5918,{0x04,0x00,0x04,0x3e,0x07,0xa2,0x08,0xa2,0x08,0xa2,0x10,0xa2,0x19,0x22,0x25,0x22,0x43,0x22,0x02,0x22,0x02,0x22,0x04,0x22,0x04,0x2c,0x08,0x20,0x10,0x20,0x20,0x20}}, // 夘
{0x524A,0x99C8,0xD2CA,0xE58DBB,0x537B,{0x04,0x00,0x0a,0x3e,0x09,0x22,0x10,0xa2,0x24,0xa2,0x4a,0x22,0x09,0x22,0x10,0xa2,0x10,0xa2,0x3f,0x22,0x51,0x22,0x11,0x22,0x11,0x2c,0x11,0x20,0x1f,0x20,0x11,0x20}}, // 卻
{0x524B,0x99C9,0xD2CB,0xE58DB7,0x5377,{0x04,0x90,0x04,0x88,0x08,0x88,0x3f,0xfe,0x00,0x80,0x01,0x40,0x7f,0xff,0x02,0x20,0x04,0x10,0x1f,0xfc,0x64,0x13,0x04,0x10,0x04,0x60,0x04,0x04,0x02,0x04,0x01,0xfc}}, // 卷
{0x524C,0x99CA,0xD2CC,0xE58E82,0x5382,{0x00,0x00,0x1f,0xfe,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x20,0x00,0x20,0x00,0x40,0x00,0x00,0x00}}, // 厂
{0x524D,0x99CB,0xD2CD,0xE58E96,0x5396,{0x00,0x00,0x1f,0xff,0x10,0x04,0x12,0x84,0x12,0x48,0x12,0x12,0x1f,0xe2,0x12,0x04,0x12,0x09,0x13,0x11,0x15,0x22,0x15,0x04,0x25,0x08,0x29,0x31,0x49,0x01,0x10,0xff}}, // 厖
{0x524E,0x99CC,0xD2CE,0xE58EA0,0x53A0,{0x00,0x00,0x1f,0xff,0x10,0x00,0x17,0xc2,0x14,0x52,0x14,0x52,0x17,0xd2,0x14,0x52,0x14,0x52,0x17,0xd2,0x14,0x52,0x14,0x52,0x27,0xc2,0x22,0x82,0x44,0x46,0x08,0x02}}, // 厠
{0x524F,0x99CD,0xD2CF,0xE58EA6,0x53A6,{0x00,0x00,0x1f,0xff,0x10,0x00,0x1f,0xff,0x10,0x40,0x13,0xfc,0x12,0x04,0x13,0xfc,0x12,0x04,0x13,0xfc,0x10,0x40,0x10,0xfc,0x23,0x88,0x2c,0x70,0x40,0xd8,0x1f,0x07}}, // 厦
{0x5250,0x99CE,0xD2D0,0xE58EA5,0x53A5,{0x00,0x00,0x1f,0xff,0x14,0x50,0x12,0x50,0x12,0x90,0x1f,0xdf,0x11,0x21,0x15,0x6a,0x15,0x48,0x15,0x48,0x15,0x48,0x17,0xd4,0x22,0x14,0x22,0x24,0x44,0x42,0x08,0x81}}, // 厥
{0x5251,0x99CF,0xD2D1,0xE58EAE,0x53AE,{0x00,0x00,0x1f,0xff,0x10,0x02,0x14,0x84,0x14,0x98,0x1f,0xf0,0x14,0x9f,0x17,0x92,0x14,0x92,0x17,0x92,0x14,0x92,0x14,0x92,0x3f,0xe2,0x25,0x22,0x48,0xc2,0x10,0x82}}, // 厮
{0x5252,0x99D0,0xD2D2,0xE58EB0,0x53B0,{0x00,0x00,0x3f,0xff,0x21,0x08,0x25,0x48,0x25,0x48,0x29,0x2f,0x21,0x12,0x2f,0xd2,0x28,0x52,0x2b,0xea,0x2a,0xca,0x2a,0xc4,0x2b,0xc4,0x28,0x4a,0x48,0x52,0x08,0xe1}}, // 厰
{0x5253,0x99D1,0xD2D3,0xE58EB6,0x53B6,{0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x02,0x00,0x02,0x20,0x02,0x10,0x02,0x08,0x04,0x08,0x04,0x3c,0x09,0xc4,0x7e,0x02,0x00,0x02}}, // 厶
{0x5254,0x99D2,0xD2D4,0xE58F83,0x53C3,{0x01,0x40,0x02,0x30,0x1f,0xe8,0x08,0x08,0x0c,0x8c,0x12,0x92,0x7d,0x7d,0x02,0x20,0x04,0x90,0x19,0x1c,0x66,0x23,0x18,0xc8,0x03,0x10,0x1c,0x60,0x01,0x80,0x1e,0x00}}, // 參
{0x5255,0x99D3,0xD2D5,0xE7B092,0x7C12,{0x10,0x20,0x1f,0x3f,0x24,0x44,0x4f,0xf8,0x08,0x08,0x0f,0xe8,0x0b,0xf8,0x08,0x08,0x0f,0xf8,0x01,0x00,0x7f,0xff,0x05,0x10,0x1a,0x8c,0x64,0xa3,0x19,0x10,0x07,0xe8}}, // 簒
{0x5256,0x99D4,0xD2D6,0xE99B99,0x96D9,{0x09,0x24,0x12,0x28,0x3f,0xff,0x52,0x48,0x1f,0x7e,0x12,0x48,0x1f,0x7e,0x12,0x48,0x1f,0xff,0x00,0x00,0x3f,0xf8,0x02,0x10,0x01,0x20,0x00,0xc0,0x07,0x30,0x78,0x0f}}, // 雙
{0x5257,0x99D5,0xD2D7,0xE58F9F,0x53DF,{0x01,0x00,0x05,0x00,0x19,0x78,0x11,0x08,0x11,0x08,0x1d,0x78,0x11,0x08,0x11,0x08,0x1f,0xf8,0x01,0x00,0x7f,0xf8,0x08,0x10,0x06,0x20,0x01,0xc0,0x0e,0x38,0x70,0x07}}, // 叟
{0x5258,0x99D6,0xD2D8,0xE69BBC,0x66FC,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x00,0x00,0x3f,0xfe,0x22,0x22,0x3f,0xfe,0x00,0x00,0x3f,0xf8,0x06,0x20,0x01,0xc0,0x07,0x38,0x78,0x07}}, // 曼
{0x5259,0x99D7,0xD2D9,0xE787AE,0x71EE,{0x10,0x04,0x13,0xc4,0x34,0x0d,0x37,0xed,0x38,0x0e,0x53,0xd4,0x18,0x06,0x17,0xca,0x22,0x4a,0x23,0xd1,0x40,0x20,0x3f,0xf8,0x06,0x30,0x01,0xc0,0x07,0x30,0x78,0x0f}}, // 燮
{0x525A,0x99D8,0xD2DA,0xE58FAE,0x53EE,{0x00,0x00,0x03,0xff,0x7c,0x10,0x44,0x10,0x44,0x10,0x44,0x10,0x44,0x10,0x44,0x10,0x44,0x10,0x44,0x10,0x44,0x10,0x7c,0x10,0x44,0x10,0x40,0x10,0x00,0x70,0x00,0x10}}, // 叮
{0x525B,0x99D9,0xD2DB,0xE58FA8,0x53E8,{0x00,0x00,0x01,0xfe,0x3e,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x42,0x3e,0x42,0x22,0x42,0x20,0x82,0x01,0x02,0x02,0x04,0x04,0x18}}, // 叨
{0x525C,0x99DA,0xD2DC,0xE58FAD,0x53ED,{0x00,0xf8,0x00,0x08,0x7c,0x08,0x44,0x08,0x44,0x88,0x44,0x88,0x44,0x88,0x44,0x88,0x44,0x88,0x44,0x88,0x7c,0x88,0x44,0x88,0x41,0x04,0x01,0x04,0x02,0x02,0x04,0x01}}, // 叭
{0x525D,0x99DB,0xD2DD,0xE58FBA,0x53FA,{0x00,0xe0,0x00,0x20,0x7c,0x20,0x44,0x20,0x44,0x20,0x44,0x20,0x44,0x20,0x44,0x30,0x44,0x30,0x44,0x50,0x7c,0x50,0x44,0x88,0x40,0x88,0x01,0x04,0x06,0x02,0x18,0x01}}, // 叺
{0x525E,0x99DC,0xD2DE,0xE59081,0x5401,{0x00,0x00,0x01,0xfc,0x7c,0x20,0x44,0x20,0x44,0x20,0x44,0x20,0x44,0x20,0x47,0xff,0x44,0x20,0x44,0x20,0x7c,0x20,0x44,0x20,0x40,0x20,0x00,0x20,0x00,0xe0,0x00,0x20}}, // 吁
{0x525F,0x99DD,0xD2DF,0xE590BD,0x543D,{0x00,0x20,0x01,0x20,0x79,0x20,0x49,0x20,0x4b,0xfe,0x4a,0x20,0x4c,0x20,0x48,0x20,0x48,0x20,0x4f,0xff,0x78,0x20,0x48,0x20,0x40,0x20,0x00,0x20,0x00,0x20,0x00,0x20}}, // 吽
{0x5260,0x99DE,0xD2E0,0xE59180,0x5440,{0x00,0x00,0x03,0xfe,0x78,0x88,0x48,0x88,0x48,0x88,0x48,0x88,0x48,0x88,0x4f,0xff,0x48,0x28,0x48,0x28,0x78,0x48,0x48,0x88,0x41,0x08,0x02,0x08,0x04,0x38,0x00,0x08}}, // 呀
{0x5261,0x99DF,0xD2E1,0xE590AC,0x542C,{0x00,0x04,0x00,0x18,0x7c,0xe0,0x44,0x80,0x44,0x80,0x44,0xff,0x44,0x88,0x44,0x88,0x44,0x88,0x44,0x88,0x7c,0x88,0x45,0x08,0x41,0x08,0x02,0x08,0x04,0x08,0x00,0x08}}, // 听
{0x5262,0x99E0,0xD2E2,0xE590AD,0x542D,{0x00,0x20,0x00,0x20,0x7c,0x20,0x47,0xff,0x44,0x00,0x44,0x00,0x44,0xf8,0x44,0x88,0x44,0x88,0x44,0x88,0x7c,0x88,0x44,0x88,0x40,0x89,0x01,0x09,0x02,0x07,0x04,0x00}}, // 吭
{0x5263,0x99E1,0xD2E3,0xE590BC,0x543C,{0x00,0x08,0x03,0xe8,0x78,0x28,0x48,0x48,0x48,0x88,0x48,0x88,0x48,0xa8,0x48,0xc8,0x49,0x88,0x4e,0x88,0x48,0x88,0x78,0x88,0x48,0x88,0x40,0x89,0x01,0x89,0x00,0x87}}, // 吼
{0x5264,0x99E2,0xD2E4,0xE590AE,0x542E,{0x00,0x20,0x00,0x20,0x7c,0x40,0x44,0x50,0x44,0x4c,0x44,0x9a,0x47,0xe9,0x44,0x48,0x44,0x48,0x44,0x48,0x44,0x48,0x7c,0x88,0x44,0x88,0x41,0x09,0x02,0x09,0x04,0x07}}, // 吮
{0x5265,0x99E3,0xD2E5,0xE590B6,0x5436,{0x00,0x20,0x00,0x20,0x78,0x20,0x4b,0xfe,0x4a,0x22,0x4a,0x22,0x4a,0x22,0x4a,0x22,0x4a,0x52,0x4a,0x52,0x4a,0x8a,0x7b,0x06,0x4a,0x02,0x42,0x02,0x02,0x06,0x02,0x02}}, // 吶
{0x5266,0x99E4,0xD2E6,0xE590A9,0x5429,{0x00,0x78,0x00,0x08,0x78,0x88,0x48,0x88,0x48,0x84,0x49,0x04,0x49,0xfe,0x4a,0x25,0x4c,0x24,0x48,0x24,0x48,0x24,0x78,0x44,0x48,0x44,0x40,0x84,0x01,0x04,0x02,0x18}}, // 吩
{0x5267,0x99E5,0xD2E7,0xE5909D,0x541D,{0x00,0x80,0x00,0x80,0x7f,0xff,0x04,0x10,0x02,0x20,0x01,0x40,0x00,0x80,0x03,0x60,0x0c,0x18,0x70,0x07,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 吝
{0x5268,0x99E6,0xD2E8,0xE5918E,0x544E,{0x00,0x00,0x01,0xfc,0x7d,0x04,0x45,0x04,0x45,0x04,0x45,0x04,0x45,0xfc,0x45,0x24,0x45,0x20,0x45,0x20,0x7d,0x10,0x46,0x10,0x42,0x08,0x04,0x04,0x08,0x02,0x10,0x01}}, // 呎
{0x5269,0x99E7,0xD2E9,0xE5928F,0x548F,{0x00,0x40,0x00,0x20,0x00,0x20,0x78,0x00,0x49,0xe2,0x48,0x22,0x48,0x34,0x4f,0xb4,0x48,0xb8,0x49,0x28,0x49,0x28,0x7a,0x24,0x44,0x22,0x18,0x21,0x00,0x60,0x00,0x20}}, // 咏
{0x526A,0x99E8,0xD2EA,0xE591B5,0x5475,{0x00,0x00,0x07,0xff,0x78,0x04,0x48,0x04,0x49,0xe4,0x49,0x24,0x49,0x24,0x49,0x24,0x49,0x24,0x49,0xe4,0x49,0x24,0x78,0x04,0x48,0x04,0x40,0x04,0x00,0x0c,0x00,0x04}}, // 呵
{0x526B,0x99E9,0xD2EB,0xE5928E,0x548E,{0x08,0x10,0x0f,0x10,0x09,0x10,0x12,0x10,0x32,0x28,0x4c,0x44,0x04,0x82,0x0b,0x00,0x10,0xc0,0x20,0x3f,0x40,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 咎
{0x526C,0x99EA,0xD2EC,0xE5919F,0x545F,{0x00,0x20,0x00,0x20,0x00,0x20,0x7f,0xff,0x48,0x20,0x48,0x20,0x48,0x48,0x4b,0x88,0x48,0x50,0x48,0x60,0x48,0x20,0x78,0x48,0x48,0x84,0x41,0x3c,0x07,0xc2,0x00,0x02}}, // 呟
{0x526D,0x99EB,0xD2ED,0xE591B1,0x5471,{0x00,0x04,0x00,0x18,0x7b,0xe8,0x4a,0x08,0x4a,0x48,0x4a,0x48,0x4a,0x48,0x4a,0x48,0x4a,0x48,0x4a,0x48,0x7a,0x64,0x4a,0x54,0x44,0x54,0x04,0x5a,0x0b,0xea,0x10,0x09}}, // 呱
{0x526E,0x99EC,0xD2EE,0xE591B7,0x5477,{0x00,0x00,0x01,0xfe,0x3d,0x22,0x25,0x22,0x25,0x22,0x25,0xfe,0x25,0x22,0x25,0x22,0x25,0x22,0x25,0xfe,0x3d,0x22,0x24,0x20,0x20,0x20,0x00,0x20,0x00,0x20,0x00,0x20}}, // 呷
{0x526F,0x99ED,0xD2EF,0xE591B0,0x5470,{0x04,0x40,0x04,0x42,0x14,0x4c,0x17,0xf0,0x14,0x40,0x14,0x40,0x14,0x42,0x17,0x42,0x1c,0x3e,0x60,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 呰
{0x5270,0x99EE,0xD2F0,0xE59292,0x5492,{0x00,0x00,0x3e,0x7c,0x22,0x44,0x22,0x44,0x22,0x44,0x3e,0x7c,0x22,0x44,0x07,0xe0,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x22,0x04,0x22,0x08,0x22,0x10,0x1e,0x60,0x00}}, // 咒
{0x5271,0x99EF,0xD2F1,0xE591BB,0x547B,{0x00,0x20,0x00,0x20,0x3d,0xfe,0x25,0x22,0x25,0x22,0x25,0x22,0x25,0xfe,0x25,0x22,0x25,0x22,0x25,0x22,0x3d,0xfe,0x25,0x22,0x24,0x20,0x00,0x20,0x00,0x20,0x00,0x20}}, // 呻
{0x5272,0x99F0,0xD2F2,0xE59280,0x5480,{0x00,0x00,0x00,0xfc,0x7c,0x84,0x44,0x84,0x44,0x84,0x44,0xfc,0x44,0x84,0x44,0x84,0x44,0x84,0x44,0xfc,0x7c,0x84,0x44,0x84,0x40,0x84,0x00,0x84,0x07,0xff,0x00,0x00}}, // 咀
{0x5273,0x99F1,0xD2F3,0xE591B6,0x5476,{0x01,0x00,0x01,0x3e,0x79,0x02,0x4f,0xc2,0x49,0x52,0x49,0x52,0x49,0x52,0x4a,0x52,0x4a,0x54,0x4f,0xd4,0x78,0x88,0x48,0xcc,0x41,0x14,0x02,0x22,0x0c,0x42,0x00,0x81}}, // 呶
{0x5274,0x99F2,0xD2F4,0xE59284,0x5484,{0x00,0x20,0x02,0x22,0x7a,0x22,0x4a,0x22,0x4a,0x22,0x4a,0x22,0x4b,0xfe,0x48,0x20,0x48,0x20,0x4a,0x22,0x7a,0x22,0x4a,0x22,0x42,0x22,0x02,0x22,0x03,0xfe,0x02,0x02}}, // 咄
{0x5275,0x99F3,0xD2F5,0xE59290,0x5490,{0x00,0x84,0x00,0x84,0x78,0x84,0x48,0x84,0x49,0x7f,0x49,0x04,0x4b,0x04,0x4d,0x44,0x49,0x24,0x49,0x24,0x79,0x04,0x49,0x04,0x41,0x04,0x01,0x04,0x01,0x0c,0x01,0x04}}, // 咐
{0x5276,0x99F4,0xD2F6,0xE59286,0x5486,{0x01,0x00,0x01,0x00,0x79,0xfe,0x49,0x02,0x4a,0x02,0x4b,0xf2,0x4d,0x12,0x49,0x12,0x49,0x12,0x49,0xf2,0x49,0x04,0x79,0x18,0x49,0x01,0x41,0x01,0x00,0x81,0x00,0x7f}}, // 咆
{0x5277,0x99F5,0xD2F7,0xE59387,0x54C7,{0x00,0x20,0x00,0x20,0x7d,0xfc,0x44,0x20,0x44,0x20,0x44,0x20,0x47,0xfe,0x44,0x00,0x44,0x20,0x44,0x20,0x47,0xfe,0x7c,0x20,0x44,0x20,0x00,0x20,0x07,0xff,0x00,0x00}}, // 哇
{0x5278,0x99F6,0xD2F8,0xE592A2,0x54A2,{0x00,0x00,0x1f,0x3e,0x11,0x22,0x11,0x22,0x1f,0x3e,0x00,0x00,0x0f,0xfc,0x00,0x00,0x7f,0xff,0x01,0x00,0x01,0x00,0x03,0xf8,0x02,0x08,0x00,0x08,0x00,0x10,0x00,0xe0}}, // 咢
{0x5279,0x99F7,0xD2F9,0xE592B8,0x54B8,{0x00,0x24,0x00,0x22,0x00,0x22,0x1f,0xff,0x10,0x20,0x10,0x20,0x1f,0xe2,0x10,0x12,0x10,0x12,0x17,0xd4,0x14,0x54,0x14,0x48,0x17,0xd9,0x24,0x65,0x20,0x43,0x40,0x81}}, // 咸
{0x527A,0x99F8,0xD2FA,0xE592A5,0x54A5,{0x00,0x00,0x07,0xff,0x00,0x40,0x7c,0x50,0x44,0x8c,0x45,0x1a,0x47,0xe1,0x44,0x00,0x44,0x20,0x44,0x20,0x7d,0xfe,0x44,0x20,0x40,0x20,0x00,0x20,0x07,0xff,0x00,0x00}}, // 咥
{0x527B,0x99F9,0xD2FB,0xE592AC,0x54AC,{0x00,0x20,0x00,0x20,0x78,0x20,0x4f,0xff,0x48,0x88,0x48,0x84,0x49,0x02,0x4a,0x8a,0x48,0x88,0x48,0x50,0x78,0x50,0x48,0x20,0x40,0x50,0x00,0x88,0x03,0x04,0x0c,0x03}}, // 咬
{0x527C,0x99FA,0xD2FC,0xE59384,0x54C4,{0x00,0x88,0x00,0x88,0x78,0x88,0x4b,0xfe,0x48,0x88,0x48,0x88,0x48,0x88,0x48,0x88,0x48,0x88,0x4f,0xff,0x78,0x00,0x48,0x00,0x40,0x88,0x01,0x04,0x02,0x02,0x0c,0x02}}, // 哄
{0x527D,0x99FB,0xD2FD,0xE59388,0x54C8,{0x00,0x20,0x00,0x20,0x78,0x50,0x48,0x50,0x48,0x88,0x49,0x04,0x4a,0x02,0x4d,0xfd,0x48,0x00,0x48,0x00,0x79,0xfc,0x49,0x04,0x41,0x04,0x01,0x04,0x01,0xfc,0x01,0x04}}, // 哈
{0x527E,0x99FC,0xD2FE,0xE592A8,0x54A8,{0x00,0x80,0x00,0x80,0x79,0xff,0x01,0x22,0x02,0x24,0x00,0x30,0x0c,0x48,0x31,0x84,0x46,0x03,0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 咨
{0x5321,0x9A40,0xD3A1,0xE592AB,0x54AB,{0x00,0x00,0x1f,0x7e,0x11,0x42,0x11,0x42,0x11,0x42,0x11,0x42,0x11,0x42,0x1f,0x7e,0x19,0x00,0x18,0x24,0x14,0x22,0x14,0x41,0x12,0x81,0x21,0x00,0x20,0xc0,0x40,0x3f}}, // 咫
{0x5322,0x9A41,0xD3A2,0xE59382,0x54C2,{0x00,0x00,0x07,0xff,0x78,0x50,0x48,0x50,0x48,0x50,0x4b,0xfe,0x4a,0x52,0x4a,0x52,0x4a,0x56,0x4a,0x96,0x7a,0x8e,0x4b,0x02,0x42,0x02,0x02,0x02,0x03,0xfe,0x02,0x02}}, // 哂
{0x5323,0x9A42,0xD3A3,0xE592A4,0x54A4,{0x00,0x20,0x00,0x20,0x7b,0xff,0x4a,0x02,0x4a,0x08,0x4c,0x30,0x4b,0xc0,0x48,0x40,0x48,0x40,0x48,0x7f,0x4f,0xc0,0x78,0x40,0x48,0x40,0x00,0x42,0x00,0x22,0x00,0x1e}}, // 咤
{0x5324,0x9A43,0xD3A4,0xE592BE,0x54BE,{0x00,0x40,0x00,0x44,0x03,0xfc,0x7c,0x48,0x44,0x48,0x44,0x50,0x47,0xff,0x44,0x20,0x44,0x40,0x44,0x44,0x44,0xc8,0x7d,0x70,0x42,0x40,0x44,0x42,0x00,0x22,0x00,0x1e}}, // 咾
{0x5325,0x9A44,0xD3A5,0xE592BC,0x54BC,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0xf8,0x08,0x88,0x08,0x88,0x08,0x88,0x3f,0xfe,0x20,0x02,0x23,0xe2,0x22,0x22,0x22,0x22,0x22,0x22,0x23,0xe2,0x22,0x22,0x20,0x06}}, // 咼
{0x5326,0x9A45,0xD3A6,0xE59398,0x54D8,{0x00,0x80,0x00,0x9e,0x79,0x00,0x49,0x00,0x4a,0x40,0x4c,0x40,0x48,0xbf,0x48,0x84,0x49,0x04,0x4b,0x04,0x4d,0x04,0x79,0x04,0x49,0x04,0x01,0x04,0x01,0x0c,0x01,0x04}}, // 哘
{0x5327,0x9A46,0xD3A7,0xE593A5,0x54E5,{0x00,0x00,0x7f,0xff,0x00,0x08,0x0f,0x88,0x08,0x88,0x08,0x88,0x0f,0x98,0x00,0x00,0x7f,0xff,0x00,0x08,0x0f,0x88,0x08,0x88,0x08,0x88,0x0f,0x88,0x08,0x88,0x00,0x18}}, // 哥
{0x5328,0x9A47,0xD3A8,0xE593A6,0x54E6,{0x00,0x30,0x00,0xd4,0x7b,0x92,0x48,0x92,0x48,0x90,0x4f,0xff,0x48,0x90,0x48,0x92,0x48,0x92,0x48,0xd4,0x7b,0x8c,0x48,0x88,0x40,0x95,0x00,0xa5,0x01,0xc3,0x00,0x81}}, // 哦
{0x5329,0x9A48,0xD3A9,0xE5948F,0x550F,{0x00,0x04,0x00,0xc8,0x78,0x30,0x48,0x68,0x4b,0xa4,0x48,0x40,0x4f,0xff,0x48,0x40,0x48,0xa0,0x49,0xfc,0x7b,0x24,0x4d,0x24,0x49,0x24,0x01,0x38,0x01,0x20,0x00,0x20}}, // 唏
{0x532A,0x9A49,0xD3AA,0xE59494,0x5514,{0x00,0x00,0x07,0xfe,0x78,0x40,0x48,0x40,0x4b,0xf8,0x48,0x88,0x48,0x88,0x48,0x88,0x4f,0xff,0x48,0x00,0x79,0xfc,0x49,0x04,0x41,0x04,0x01,0x04,0x01,0xfc,0x01,0x04}}, // 唔
{0x532B,0x9A4A,0xD3AB,0xE593BD,0x54FD,{0x00,0x00,0x07,0xff,0x78,0x20,0x49,0xfc,0x49,0x24,0x49,0x24,0x49,0xfc,0x49,0x24,0x49,0x24,0x49,0xfc,0x79,0x24,0x48,0xa0,0x40,0x40,0x00,0xa0,0x03,0x18,0x0c,0x07}}, // 哽
{0x532C,0x9A4B,0xD3AC,0xE593AE,0x54EE,{0x00,0x40,0x00,0x44,0x7b,0xfc,0x48,0x48,0x48,0x50,0x4f,0xff,0x48,0x20,0x48,0x7c,0x48,0x88,0x4b,0x10,0x7c,0x20,0x4b,0xff,0x40,0x20,0x00,0x20,0x00,0x20,0x00,0x60}}, // 哮
{0x532D,0x9A4C,0xD3AD,0xE593AD,0x54ED,{0x00,0x00,0x3e,0x7c,0x22,0x44,0x22,0x44,0x22,0x44,0x3e,0x7c,0x22,0xd0,0x00,0x88,0x00,0x88,0x7f,0xff,0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x60,0x03}}, // 哭
{0x532E,0x9A4D,0xD3AE,0xE593BA,0x54FA,{0x00,0x28,0x00,0x24,0x07,0xff,0x78,0x20,0x48,0x20,0x4b,0xfc,0x4a,0x24,0x4a,0x24,0x4b,0xfc,0x4a,0x24,0x4a,0x24,0x7b,0xfc,0x4a,0x24,0x42,0x24,0x02,0x24,0x02,0x2c}}, // 哺
{0x532F,0x9A4E,0xD3AF,0xE593A2,0x54E2,{0x00,0x00,0x03,0xfe,0x78,0x20,0x48,0x20,0x49,0xfc,0x48,0x20,0x48,0x20,0x4f,0xff,0x48,0x88,0x48,0x88,0x4f,0xff,0x78,0x88,0x48,0x88,0x01,0x08,0x01,0x08,0x02,0x08}}, // 哢
{0x5330,0x9A4F,0xD3B0,0xE594B9,0x5539,{0x01,0x08,0x01,0x08,0x79,0x08,0x4f,0xf4,0x49,0x14,0x49,0x14,0x49,0xe2,0x49,0x72,0x49,0x49,0x49,0x48,0x7a,0x40,0x4a,0x50,0x42,0x48,0x04,0x44,0x08,0x42,0x11,0x82}}, // 唹
{0x5331,0x9A50,0xD3B1,0xE59580,0x5540,{0x00,0x00,0x03,0xff,0x7a,0x10,0x4a,0x10,0x4a,0xfe,0x4a,0x10,0x4a,0x10,0x4b,0xff,0x4a,0x00,0x4a,0x10,0x7a,0x10,0x4c,0xfe,0x44,0x10,0x08,0x10,0x13,0xff,0x00,0x00}}, // 啀
{0x5332,0x9A51,0xD3B2,0xE595A3,0x5563,{0x01,0x00,0x01,0x1e,0x79,0xf2,0x4a,0x92,0x4c,0x92,0x4f,0xf2,0x48,0x92,0x48,0x92,0x4a,0xf2,0x4a,0x92,0x4a,0x92,0x7a,0xb2,0x4a,0xdc,0x43,0x10,0x0c,0x10,0x00,0x10}}, // 啣
{0x5333,0x9A52,0xD3B3,0xE5958C,0x554C,{0x00,0x20,0x00,0x20,0x7b,0xff,0x4a,0x52,0x4a,0x50,0x4c,0x50,0x48,0x92,0x49,0x0e,0x4a,0x00,0x49,0xfc,0x48,0x20,0x78,0x20,0x48,0x20,0x00,0x20,0x07,0xfe,0x00,0x00}}, // 啌
{0x5334,0x9A53,0xD3B4,0xE594AE,0x552E,{0x08,0x20,0x08,0x40,0x1f,0xfe,0x10,0x40,0x3f,0xfc,0x50,0x40,0x1f,0xfc,0x10,0x40,0x1f,0xfe,0x00,0x00,0x1f,0xf8,0x10,0x08,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x08}}, // 售
{0x5335,0x9A54,0xD3B5,0xE5959C,0x555C,{0x00,0x00,0x03,0xfe,0x78,0x44,0x49,0x94,0x48,0x88,0x49,0x54,0x4a,0x24,0x48,0x40,0x4b,0xfe,0x48,0x42,0x7a,0x54,0x49,0x94,0x40,0x88,0x01,0x54,0x02,0x22,0x0c,0x41}}, // 啜
{0x5336,0x9A55,0xD3B6,0xE59585,0x5545,{0x00,0x20,0x00,0x20,0x78,0x3e,0x48,0x20,0x49,0xfc,0x49,0x04,0x49,0x04,0x49,0xfc,0x49,0x04,0x49,0x04,0x49,0xfc,0x78,0x20,0x07,0xff,0x00,0x20,0x00,0x20,0x00,0x20}}, // 啅
{0x5337,0x9A56,0xD3B7,0xE59596,0x5556,{0x00,0x20,0x00,0x24,0x79,0x24,0x49,0x28,0x49,0x50,0x4a,0x48,0x48,0x84,0x49,0x04,0x4a,0x20,0x49,0x24,0x49,0x24,0x79,0x38,0x02,0x50,0x00,0x88,0x03,0x04,0x0c,0x03}}, // 啖
{0x5338,0x9A57,0xD3B8,0xE59597,0x5557,{0x00,0x40,0x00,0x7c,0x78,0x84,0x48,0x84,0x49,0x04,0x4a,0x38,0x48,0x20,0x48,0x40,0x49,0x8e,0x49,0x02,0x79,0x02,0x49,0xde,0x41,0x02,0x01,0x02,0x01,0xfe,0x01,0x02}}, // 啗
{0x5339,0x9A58,0xD3B9,0xE594B8,0x5538,{0x00,0x20,0x00,0x20,0x00,0x50,0x78,0x88,0x49,0x04,0x4e,0xfb,0x48,0x00,0x49,0xf8,0x48,0x08,0x48,0x10,0x78,0x20,0x4a,0x94,0x42,0x92,0x04,0x85,0x08,0x85,0x00,0x7c}}, // 唸
{0x533A,0x9A59,0xD3BA,0xE594B3,0x5533,{0x00,0x00,0x03,0xff,0x78,0x00,0x49,0xfe,0x49,0x02,0x49,0x02,0x49,0xfe,0x49,0x10,0x49,0x10,0x49,0xff,0x79,0x10,0x4a,0x18,0x42,0x28,0x04,0x44,0x09,0x82,0x06,0x01}}, // 唳
{0x533B,0x9A5A,0xD3BB,0xE5959D,0x555D,{0x00,0x20,0x00,0xc0,0x7b,0x9e,0x48,0x92,0x48,0x92,0x4f,0xf2,0x48,0x92,0x48,0x92,0x49,0xd2,0x49,0xd2,0x7a,0xbe,0x4a,0x92,0x44,0x88,0x00,0x84,0x00,0x80,0x00,0x80}}, // 啝
{0x533C,0x9A5B,0xD3BC,0xE59699,0x5599,{0x00,0x40,0x00,0xfc,0x78,0x88,0x49,0xf8,0x48,0x10,0x4f,0xff,0x48,0x40,0x48,0xaa,0x4b,0x2c,0x48,0x58,0x78,0x94,0x4b,0x34,0x40,0x52,0x01,0x91,0x06,0x10,0x00,0x60}}, // 喙
{0x533D,0x9A5C,0xD3BD,0xE59680,0x5580,{0x00,0x20,0x00,0x20,0x7b,0xff,0x4a,0x42,0x4a,0x78,0x4c,0x88,0x49,0x50,0x4a,0x30,0x48,0x48,0x49,0x84,0x4f,0xff,0x79,0x04,0x49,0x04,0x01,0x04,0x01,0xfc,0x01,0x04}}, // 喀
{0x533E,0x9A5D,0xD3BE,0xE592AF,0x54AF,{0x00,0x40,0x00,0x40,0x78,0xf8,0x48,0x88,0x49,0x88,0x49,0x50,0x4a,0x20,0x48,0x50,0x48,0x8c,0x49,0x03,0x4f,0xfc,0x79,0x04,0x49,0x04,0x01,0x04,0x01,0xfc,0x01,0x04}}, // 咯
{0x533F,0x9A5E,0xD3BF,0xE5968A,0x558A,{0x00,0x14,0x00,0x12,0x78,0x12,0x4b,0xff,0x4a,0x10,0x4b,0xf0,0x4a,0x12,0x4a,0xf2,0x4a,0xb4,0x4a,0xac,0x7a,0xa8,0x4a,0xe9,0x44,0x95,0x04,0x25,0x08,0x43,0x10,0x01}}, // 喊
{0x5340,0x9A5F,0xD3C0,0xE5969F,0x559F,{0x00,0x00,0x03,0xfe,0x7a,0x22,0x4b,0xfe,0x4a,0x22,0x4a,0x22,0x4b,0xfe,0x48,0x00,0x49,0xfc,0x49,0x04,0x79,0xfc,0x49,0x04,0x01,0xfc,0x01,0x04,0x01,0x04,0x01,0x0c}}, // 喟
{0x5341,0x9A60,0xD3C1,0xE595BB,0x557B,{0x01,0x00,0x7f,0xfe,0x08,0x20,0x04,0x40,0x7f,0xfe,0x41,0x02,0x5f,0xfa,0x11,0x08,0x11,0x08,0x11,0x30,0x01,0x00,0x1f,0xf8,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x08}}, // 啻
{0x5342,0x9A61,0xD3C2,0xE595BE,0x557E,{0x00,0x48,0x01,0x88,0x07,0x0a,0x79,0x0a,0x49,0x2a,0x4f,0xec,0x49,0x28,0x49,0x28,0x4b,0xa8,0x4b,0x4c,0x7b,0x14,0x4d,0x14,0x45,0x14,0x09,0x22,0x01,0x42,0x01,0x81}}, // 啾
{0x5343,0x9A62,0xD3C3,0xE59698,0x5598,{0x00,0x20,0x02,0x22,0x7a,0x22,0x4a,0x22,0x4b,0xfe,0x48,0x00,0x4f,0xff,0x48,0x20,0x48,0x40,0x4b,0xfe,0x7a,0x92,0x4a,0x92,0x42,0x92,0x02,0x92,0x02,0x92,0x02,0x06}}, // 喘
{0x5344,0x9A63,0xD3C4,0xE5969E,0x559E,{0x01,0x00,0x01,0x1e,0x7b,0xd2,0x4a,0x52,0x4a,0x52,0x4b,0xd2,0x4a,0x52,0x4a,0x52,0x4b,0xd2,0x4a,0x12,0x7a,0x12,0x4b,0xdc,0x42,0x10,0x02,0x10,0x03,0xd0,0x02,0x10}}, // 喞
{0x5345,0x9A64,0xD3C5,0xE596AE,0x55AE,{0x00,0x00,0x1f,0x7c,0x11,0x44,0x1f,0x7c,0x00,0x00,0x0f,0xf8,0x08,0x88,0x08,0x88,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80}}, // 單
{0x5346,0x9A65,0xD3C6,0xE595BC,0x557C,{0x00,0x20,0x00,0x20,0x7b,0xfe,0x48,0x88,0x48,0x48,0x48,0x50,0x4b,0xff,0x4a,0x21,0x4a,0x21,0x49,0xfe,0x79,0x22,0x49,0x22,0x41,0x22,0x01,0x2c,0x00,0x20,0x00,0x20}}, // 啼
{0x5347,0x9A66,0xD3C7,0xE59683,0x5583,{0x00,0x20,0x00,0x20,0x07,0xff,0x78,0x20,0x48,0x20,0x4b,0xfe,0x4a,0x8a,0x4a,0x4a,0x4a,0x52,0x4a,0xfa,0x7a,0x22,0x4a,0x22,0x42,0xfa,0x02,0x22,0x02,0x22,0x02,0x26}}, // 喃
{0x5348,0x9A67,0xD3C8,0xE596A9,0x55A9,{0x00,0x20,0x00,0x20,0x78,0x50,0x48,0x88,0x49,0xfc,0x4a,0x02,0x4f,0xd3,0x4e,0x52,0x4b,0x52,0x4a,0xe4,0x4a,0x64,0x7b,0x64,0x4a,0xd2,0x42,0x52,0x02,0x52,0x02,0xd2}}, // 喩
{0x5349,0x9A68,0xD3C9,0xE59687,0x5587,{0x00,0x82,0x78,0x8a,0x4f,0xfa,0x48,0x8a,0x4b,0xea,0x4a,0xaa,0x4a,0xaa,0x4a,0xaa,0x4b,0xea,0x48,0x8a,0x79,0xca,0x49,0xa2,0x42,0x92,0x04,0x82,0x08,0x86,0x00,0x82}}, // 喇
{0x534A,0x9A69,0xD3CA,0xE596A8,0x55A8,{0x00,0x20,0x00,0x20,0x7b,0xff,0x48,0x00,0x48,0xfc,0x48,0x84,0x48,0xfc,0x48,0x00,0x4b,0xff,0x4a,0x02,0x7c,0x48,0x48,0x48,0x40,0x48,0x00,0x89,0x03,0x09,0x0c,0x07}}, // 喨
{0x534B,0x9A6A,0xD3CB,0xE5979A,0x55DA,{0x00,0x20,0x00,0x40,0x79,0xf8,0x49,0x08,0x49,0x08,0x49,0xf8,0x49,0x08,0x49,0x00,0x49,0xff,0x49,0x00,0x79,0xfe,0x48,0x92,0x46,0x4a,0x05,0x42,0x05,0x04,0x08,0x18}}, // 嗚
{0x534C,0x9A6B,0xD3CC,0xE59785,0x55C5,{0x00,0x20,0x00,0x40,0x79,0xfc,0x49,0x04,0x49,0xfc,0x49,0x04,0x49,0xfc,0x49,0x04,0x49,0x04,0x49,0xfc,0x78,0x28,0x48,0x24,0x0f,0xff,0x00,0x50,0x01,0x8c,0x0e,0x03}}, // 嗅
{0x534D,0x9A6C,0xD3CD,0xE5979F,0x55DF,{0x00,0x84,0x00,0x48,0x7b,0xfe,0x48,0x20,0x48,0x20,0x49,0xfc,0x48,0x20,0x4f,0xff,0x48,0x80,0x48,0x80,0x79,0xfe,0x4a,0x10,0x44,0x10,0x08,0x10,0x03,0xff,0x00,0x00}}, // 嗟
{0x534E,0x9A6D,0xD3CE,0xE59784,0x55C4,{0x00,0x00,0x07,0xff,0x00,0x40,0x79,0xfc,0x49,0x04,0x49,0xfc,0x49,0x04,0x49,0xfc,0x49,0x04,0x49,0xfc,0x48,0x20,0x78,0xfc,0x47,0x48,0x40,0x30,0x00,0xd8,0x0f,0x07}}, // 嗄
{0x534F,0x9A6E,0xD3CF,0xE5979C,0x55DC,{0x00,0x40,0x00,0x44,0x7b,0xf8,0x48,0x50,0x4f,0xff,0x48,0x84,0x49,0xf8,0x4e,0x81,0x48,0x7f,0x48,0x00,0x79,0xfc,0x49,0x04,0x41,0xfc,0x01,0x04,0x01,0xfc,0x01,0x04}}, // 嗜
{0x5350,0x9A6F,0xD3D0,0xE597A4,0x55E4,{0x00,0x20,0x02,0x22,0x7a,0x22,0x4b,0xfe,0x48,0x40,0x48,0x80,0x4f,0xff,0x48,0x20,0x49,0xfc,0x49,0x24,0x79,0x24,0x49,0xfc,0x41,0x28,0x00,0x24,0x00,0xfe,0x07,0x01}}, // 嗤
{0x5351,0x9A70,0xD3D1,0xE59794,0x55D4,{0x01,0x04,0x01,0xf8,0x79,0x02,0x48,0xfe,0x4a,0x00,0x4a,0xfc,0x4a,0x84,0x4a,0xfc,0x4a,0x84,0x4a,0xfc,0x7a,0x84,0x4a,0xfc,0x42,0x00,0x03,0xff,0x01,0x8c,0x0e,0x02}}, // 嗔
{0x5352,0x9A71,0xD3D2,0xE59894,0x5614,{0x00,0x00,0x03,0xff,0x7a,0x00,0x4a,0x7c,0x4a,0x44,0x4a,0x44,0x4a,0x7c,0x4a,0x00,0x4a,0xee,0x4a,0xaa,0x7a,0xaa,0x4a,0xaa,0x42,0xee,0x02,0x00,0x03,0xff,0x02,0x00}}, // 嘔
{0x5353,0x9A72,0xD3D3,0xE597B7,0x55F7,{0x01,0x10,0x01,0x10,0x7b,0xd0,0x49,0x1f,0x49,0x24,0x4f,0xe4,0x49,0x04,0x49,0x14,0x4f,0xf4,0x49,0x14,0x79,0xc8,0x49,0x48,0x42,0x54,0x04,0x54,0x08,0x62,0x01,0x81}}, // 嗷
{0x5354,0x9A73,0xD3D4,0xE59896,0x5616,{0x00,0x40,0x03,0xfe,0x78,0x40,0x4b,0xfc,0x48,0x40,0x4f,0xff,0x48,0x00,0x49,0xf8,0x49,0x08,0x49,0xf8,0x79,0x08,0x49,0xf8,0x41,0x08,0x01,0xf8,0x00,0x8c,0x07,0x02}}, // 嘖
{0x5355,0x9A74,0xD3D5,0xE597BE,0x55FE,{0x01,0x10,0x01,0x10,0x79,0x10,0x4f,0xdf,0x4a,0x20,0x4a,0x50,0x4b,0xde,0x4a,0x68,0x4a,0x48,0x4a,0x7f,0x7a,0x48,0x4a,0x48,0x42,0x54,0x04,0x54,0x04,0x62,0x09,0x81}}, // 嗾
{0x5356,0x9A75,0xD3D6,0xE597BD,0x55FD,{0x01,0x08,0x01,0x08,0x7f,0xe8,0x51,0x1f,0x57,0xd1,0x55,0x6a,0x55,0x48,0x55,0x48,0x57,0xc8,0x51,0x08,0x73,0x94,0x53,0x54,0x45,0x14,0x09,0x22,0x01,0x42,0x01,0x81}}, // 嗽
{0x5357,0x9A76,0xD3D7,0xE5989B,0x561B,{0x00,0x20,0x00,0x20,0x77,0xff,0x54,0x88,0x54,0x88,0x57,0xff,0x54,0x88,0x54,0xac,0x56,0xac,0x56,0xac,0x76,0xad,0x4a,0xad,0x0a,0xab,0x14,0xc8,0x20,0x88,0x00,0x88}}, // 嘛
{0x5358,0x9A77,0xD3D8,0xE597B9,0x55F9,{0x00,0x10,0x02,0x10,0x71,0xff,0x51,0x10,0x54,0x7e,0x52,0x52,0x52,0x52,0x50,0x7e,0x5f,0x52,0x51,0x52,0x71,0x7e,0x51,0x10,0x42,0xff,0x02,0x90,0x04,0x70,0x08,0x1f}}, // 嗹
{0x5359,0x9A78,0xD3D9,0xE5998E,0x564E,{0x00,0x20,0x00,0x20,0x07,0xff,0x78,0x20,0x49,0xfc,0x48,0x00,0x4b,0xff,0x4a,0x02,0x4a,0xf8,0x4c,0x00,0x79,0xfc,0x49,0x04,0x41,0xfc,0x00,0x88,0x0f,0xff,0x00,0x00}}, // 噎
{0x535A,0x9A79,0xD3DA,0xE59990,0x5650,{0x00,0x00,0x3e,0x7c,0x22,0x44,0x22,0x44,0x3e,0x7c,0x00,0x00,0x1f,0xf8,0x01,0x00,0x01,0x00,0x7f,0xff,0x00,0x00,0x3e,0x7c,0x22,0x44,0x22,0x44,0x3e,0x7c,0x22,0x44}}, // 噐
{0x535B,0x9A7A,0xD3DB,0xE7879F,0x71DF,{0x08,0x10,0x2a,0x54,0x2a,0x54,0x54,0xa8,0x22,0x44,0x3f,0xfe,0x20,0x04,0x2f,0xf0,0x48,0x10,0x0f,0xf0,0x01,0x00,0x1f,0xf8,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x08}}, // 營
{0x535C,0x9A7B,0xD3DC,0xE598B4,0x5634,{0x00,0x90,0x02,0x92,0x7a,0xfc,0x4a,0x90,0x4a,0xf1,0x4f,0x4f,0x48,0xf0,0x49,0x20,0x4b,0xfe,0x49,0x22,0x79,0xfe,0x49,0x22,0x41,0xfe,0x01,0x02,0x02,0x02,0x04,0x06}}, // 嘴
{0x535D,0x9A7C,0xD3DD,0xE598B6,0x5636,{0x04,0x82,0x04,0x84,0x74,0x98,0x5f,0xf0,0x54,0x90,0x54,0x9f,0x57,0x92,0x54,0x92,0x57,0x92,0x54,0x92,0x54,0x92,0x7f,0xf2,0x55,0x22,0x44,0xa2,0x08,0x42,0x10,0x82}}, // 嘶
{0x535E,0x9A7D,0xD3DE,0xE598B2,0x5632,{0x00,0x80,0x00,0x9e,0x7f,0xf2,0x48,0x92,0x4b,0xd2,0x4a,0x5e,0x4a,0x52,0x4b,0xd2,0x4a,0x52,0x4a,0x5e,0x4b,0xd2,0x78,0x92,0x4f,0xf2,0x40,0x92,0x00,0xa2,0x00,0xc6}}, // 嘲
{0x535F,0x9A7E,0xD3DF,0xE598B8,0x5638,{0x00,0x80,0x00,0x80,0x79,0xff,0x4b,0x54,0x4d,0x54,0x49,0x54,0x49,0x54,0x4f,0xff,0x49,0x54,0x49,0x54,0x79,0x54,0x4f,0xff,0x40,0x00,0x02,0x94,0x04,0x4a,0x08,0x49}}, // 嘸
{0x5360,0x9A80,0xD3E0,0xE599AB,0x566B,{0x00,0x20,0x00,0x20,0x7b,0xfe,0x48,0x88,0x48,0x50,0x4f,0xff,0x48,0x00,0x49,0xfc,0x49,0x04,0x49,0xfc,0x79,0x04,0x49,0xfc,0x44,0xa0,0x04,0x92,0x08,0x85,0x00,0x7c}}, // 噫
{0x5361,0x9A81,0xD3E1,0xE599A4,0x5664,{0x00,0x88,0x00,0x88,0x07,0xff,0x78,0x88,0x49,0xdc,0x4a,0xaa,0x4c,0x89,0x48,0x88,0x49,0xfc,0x48,0x00,0x4b,0xfe,0x78,0x20,0x49,0x24,0x42,0x22,0x04,0x22,0x00,0x60}}, // 噤
{0x5362,0x9A82,0xD3E2,0xE598AF,0x562F,{0x00,0x20,0x03,0xfe,0x78,0x22,0x4f,0xff,0x48,0x22,0x4b,0xfe,0x48,0x20,0x4a,0xaa,0x4a,0xaa,0x4b,0xae,0x7a,0x22,0x4b,0xfe,0x42,0x22,0x03,0xae,0x04,0xaa,0x08,0xaa}}, // 嘯
{0x5363,0x9A83,0xD3E3,0xE599AC,0x566C,{0x01,0x08,0x01,0x08,0x79,0xef,0x4a,0x94,0x4a,0x52,0x4c,0x20,0x4b,0xfe,0x49,0x24,0x49,0x24,0x49,0xa6,0x7a,0xaa,0x4a,0x69,0x44,0x30,0x00,0x20,0x0f,0xff,0x00,0x00}}, // 噬
{0x5364,0x9A84,0xD3E4,0xE599AA,0x566A,{0x00,0x00,0x00,0xf8,0x00,0x88,0x78,0x88,0x48,0xf8,0x4b,0xde,0x4a,0x52,0x4a,0x52,0x4b,0xde,0x48,0x20,0x4f,0xff,0x78,0x70,0x48,0xa8,0x41,0x24,0x06,0x23,0x00,0x20}}, // 噪
{0x5365,0x9A85,0xD3E5,0xE59A86,0x5686,{0x00,0x88,0x07,0xff,0x78,0x88,0x48,0x20,0x4f,0xff,0x48,0x00,0x49,0xf8,0x49,0x08,0x49,0xf8,0x48,0x00,0x7b,0xfe,0x4a,0x02,0x42,0xfa,0x02,0x8a,0x02,0xfa,0x02,0x06}}, // 嚆
{0x5366,0x9A86,0xD3E6,0xE59A80,0x5680,{0x00,0x20,0x07,0xff,0x7c,0xa1,0x4c,0x91,0x4a,0x8a,0x4a,0x79,0x4c,0x01,0x4b,0xfe,0x4a,0x92,0x4b,0xfe,0x78,0x00,0x47,0xff,0x40,0x20,0x00,0x20,0x00,0x20,0x00,0x60}}, // 嚀
{0x5367,0x9A87,0xD3E7,0xE59A8A,0x568A,{0x00,0x20,0x00,0xf8,0x78,0x88,0x48,0xf8,0x48,0x88,0x48,0xf8,0x48,0x88,0x4b,0xfe,0x4a,0x22,0x4b,0xfe,0x7a,0x22,0x4b,0xfe,0x40,0x00,0x0f,0xff,0x00,0x88,0x01,0x08}}, // 嚊
{0x5368,0x9A88,0xD3E8,0xE59AA0,0x56A0,{0x01,0x02,0x06,0xfa,0x74,0x2a,0x55,0x2a,0x57,0x4a,0x54,0x9a,0x51,0x4a,0x52,0x2a,0x55,0xda,0x50,0x8a,0x53,0xfa,0x70,0xa2,0x54,0xc2,0x42,0xb2,0x01,0xc6,0x06,0x02}}, // 嚠
{0x5369,0x9A89,0xD3E9,0xE59A94,0x5694,{0x00,0x20,0x03,0xfe,0x78,0x20,0x4b,0xff,0x4a,0x02,0x4b,0xfc,0x4d,0x24,0x49,0xfc,0x49,0x24,0x49,0xfc,0x78,0x46,0x4f,0xfd,0x41,0x20,0x01,0xbc,0x02,0x60,0x0c,0x1f}}, // 嚔
{0x536A,0x9A8A,0xD3EA,0xE59A8F,0x568F,{0x00,0x20,0x03,0xfe,0x78,0x20,0x4b,0xff,0x4a,0x02,0x4b,0xfc,0x4d,0x24,0x49,0xfc,0x49,0x24,0x49,0xfc,0x78,0x00,0x4f,0xff,0x41,0x22,0x01,0xbc,0x02,0x60,0x0c,0x1f}}, // 嚏
{0x536B,0x9A8B,0xD3EB,0xE59AA5,0x56A5,{0x00,0x88,0x00,0x88,0x07,0xff,0x78,0x88,0x48,0xf8,0x49,0x04,0x4f,0x75,0x49,0x56,0x49,0x54,0x49,0x54,0x7b,0x75,0x4d,0x53,0x40,0x00,0x02,0x94,0x04,0x4a,0x08,0x49}}, // 嚥
{0x536C,0x9A8C,0xD3EC,0xE59AAE,0x56AE,{0x11,0xe0,0x10,0x0e,0x65,0xea,0x29,0x2a,0x11,0xec,0x1d,0x0a,0x65,0xe9,0x09,0x09,0x11,0xee,0x21,0x08,0x7f,0xfc,0x20,0x04,0x27,0xe4,0x24,0x24,0x27,0xe4,0x20,0x0c}}, // 嚮
{0x536D,0x9A8D,0xD3ED,0xE59AB6,0x56B6,{0x00,0x00,0x03,0xde,0x02,0x52,0x7b,0xde,0x4a,0x52,0x4b,0xde,0x4a,0x52,0x4b,0xde,0x49,0x4a,0x4e,0x31,0x48,0x40,0x7f,0xff,0x48,0x88,0x43,0xd0,0x00,0x78,0x07,0x84}}, // 嚶
{0x536E,0x9A8E,0xD3EE,0xE59AB4,0x56B4,{0x0f,0x3c,0x09,0x24,0x0f,0x3c,0x00,0x00,0x1f,0xff,0x10,0x00,0x17,0x90,0x12,0x10,0x1f,0xdf,0x14,0xa4,0x17,0xb4,0x14,0xd8,0x27,0x88,0x24,0x94,0x47,0xa2,0x18,0xc1}}, // 嚴
{0x536F,0x9A8F,0xD3EF,0xE59B82,0x56C2,{0x1f,0x7c,0x11,0x44,0x1f,0x7c,0x00,0x00,0x7f,0xff,0x01,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x10,0x04,0x3f,0x7e,0x51,0x45,0x1f,0x7c,0x11,0x44}}, // 囂
{0x5370,0x9A90,0xD3F0,0xE59ABC,0x56BC,{0x00,0x0c,0x03,0xf4,0x79,0x22,0x4a,0x11,0x4f,0xfe,0x4a,0x52,0x4b,0xfe,0x48,0x00,0x4b,0xe2,0x4a,0x3f,0x4b,0xe2,0x7a,0x32,0x4b,0xea,0x42,0x0a,0x03,0xe2,0x02,0x06}}, // 嚼
{0x5371,0x9A91,0xD3F1,0xE59B81,0x56C1,{0x00,0x00,0x03,0xfe,0x78,0x88,0x48,0xf8,0x48,0x88,0x48,0xfe,0x4b,0x88,0x48,0x08,0x4f,0xff,0x4a,0x52,0x7b,0xde,0x4a,0x52,0x43,0xde,0x02,0x53,0x0f,0xfe,0x00,0x42}}, // 囁
{0x5372,0x9A92,0xD3F2,0xE59B83,0x56C3,{0x01,0x12,0x01,0x12,0x7f,0xe4,0x54,0xbf,0x54,0xe4,0x54,0xa4,0x5b,0x64,0x5a,0x3f,0x51,0x24,0x5f,0xe4,0x71,0x3f,0x53,0xa4,0x43,0x64,0x05,0x24,0x09,0x3f,0x01,0x20}}, // 囃
{0x5373,0x9A93,0xD3F3,0xE59B80,0x56C0,{0x01,0x08,0x01,0x7f,0x7f,0xc8,0x51,0x3e,0x57,0xaa,0x55,0xbe,0x55,0xaa,0x57,0xbe,0x55,0x92,0x55,0xfd,0x77,0x84,0x51,0x7f,0x4f,0xa4,0x01,0x14,0x01,0x04,0x01,0x0c}}, // 囀
{0x5374,0x9A94,0xD3F4,0xE59B88,0x56C8,{0x00,0x90,0x07,0xff,0x78,0x90,0x49,0x08,0x4b,0xc8,0x49,0x3e,0x4f,0xea,0x4a,0x5a,0x4d,0x6e,0x7b,0x8a,0x49,0xd3,0x46,0x21,0x0f,0xfe,0x00,0x98,0x0f,0xf4,0x00,0x02}}, // 囈
{0x5375,0x9A95,0xD3F5,0xE59B8E,0x56CE,{0x00,0x1c,0x07,0x94,0x74,0xa2,0x54,0xff,0x54,0xab,0x57,0xbd,0x54,0xa9,0x54,0xbf,0x57,0x80,0x54,0x9e,0x74,0x92,0x57,0x9e,0x43,0x12,0x02,0x92,0x04,0x9e,0x08,0x12}}, // 囎
{0x5376,0x9A96,0xD3F6,0xE59B91,0x56D1,{0x00,0x00,0x07,0xfe,0x04,0x02,0x77,0xfe,0x57,0xae,0x55,0xe7,0x55,0xfe,0x55,0x4a,0x55,0xfe,0x54,0x40,0x74,0xfe,0x55,0xaa,0x4a,0xfa,0x08,0x2a,0x11,0xf6,0x20,0x0c}}, // 囑
{0x5377,0x9A97,0xD3F7,0xE59B93,0x56D3,{0x01,0x00,0x01,0xff,0x77,0x09,0x51,0xc9,0x57,0x11,0x51,0xe3,0x57,0x3c,0x51,0x20,0x5f,0xff,0x54,0x92,0x75,0x6a,0x57,0xfe,0x44,0x92,0x05,0x6a,0x07,0xfe,0x04,0x02}}, // 囓
{0x5378,0x9A98,0xD3F8,0xE59B97,0x56D7,{0x00,0x00,0x3f,0xfe,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x20,0x02,0x3f,0xfe,0x20,0x02}}, // 囗
{0x5379,0x9A99,0xD3F9,0xE59BAE,0x56EE,{0x00,0x00,0x3f,0xfe,0x22,0x02,0x22,0x82,0x24,0x92,0x24,0x92,0x2c,0xa2,0x34,0xc2,0x24,0x82,0x24,0x82,0x24,0x8a,0x24,0x8a,0x24,0x7a,0x24,0x02,0x3f,0xfe,0x20,0x02}}, // 囮
{0x537A,0x9A9A,0xD3FA,0xE59BB9,0x56F9,{0x00,0x00,0x3f,0xfe,0x20,0x82,0x21,0x42,0x22,0x22,0x24,0x12,0x3b,0xee,0x20,0x02,0x2f,0xf2,0x21,0x12,0x21,0x12,0x21,0x62,0x21,0x02,0x21,0x02,0x3f,0xfe,0x20,0x02}}, // 囹
{0x537B,0x9A9B,0xD3FB,0xE59C80,0x5700,{0x00,0x00,0x3f,0xfe,0x21,0x22,0x26,0x26,0x38,0x9e,0x20,0x82,0x3f,0xfe,0x21,0x02,0x21,0xf2,0x21,0x12,0x22,0x12,0x24,0x12,0x38,0x62,0x20,0x02,0x3f,0xfe,0x20,0x02}}, // 圀
{0x537C,0x9A9C,0xD3FC,0xE59BBF,0x56FF,{0x00,0x00,0x3f,0xfe,0x20,0x82,0x20,0x82,0x3f,0xfe,0x21,0x02,0x23,0xf2,0x22,0x12,0x27,0xf2,0x2a,0x12,0x33,0xf2,0x22,0x12,0x22,0x12,0x22,0x32,0x3f,0xfe,0x20,0x02}}, // 囿
{0x537D,0x9A9D,0xD3FD,0xE59C84,0x5704,{0x00,0x00,0x3f,0xfe,0x20,0x02,0x2f,0xfa,0x20,0x82,0x2f,0xf2,0x21,0x12,0x3f,0xfe,0x20,0x02,0x27,0xf2,0x24,0x12,0x24,0x12,0x27,0xf2,0x20,0x02,0x3f,0xfe,0x20,0x02}}, // 圄
{0x537E,0x9A9E,0xD3FE,0xE59C89,0x5709,{0x00,0x00,0x3f,0xfe,0x20,0x82,0x20,0x82,0x27,0xfa,0x20,0x82,0x3f,0xfe,0x24,0x12,0x22,0x22,0x2f,0xfa,0x20,0x82,0x3f,0xfe,0x20,0x82,0x20,0x82,0x3f,0xfe,0x20,0x02}}, // 圉
{0x5421,0x9A9F,0xD4A1,0xE59C88,0x5708,{0x00,0x00,0x3f,0xfe,0x22,0xa2,0x24,0x92,0x2f,0xfa,0x21,0x22,0x3f,0xfe,0x22,0x12,0x27,0xfa,0x2a,0x26,0x32,0x62,0x22,0x0a,0x21,0xfa,0x20,0x02,0x3f,0xfe,0x20,0x02}}, // 圈
{0x5422,0x9AA0,0xD4A2,0xE59C8B,0x570B,{0x00,0x00,0x3f,0xfe,0x20,0x52,0x20,0x4a,0x3f,0xfe,0x20,0x42,0x2f,0x4a,0x29,0x4a,0x2f,0x52,0x20,0x22,0x23,0x6a,0x3c,0x9a,0x21,0x0a,0x20,0x02,0x3f,0xfe,0x20,0x02}}, // 國
{0x5423,0x9AA1,0xD4A3,0xE59C8D,0x570D,{0x00,0x00,0x3f,0xfe,0x21,0x02,0x27,0xf2,0x21,0x12,0x3f,0xfe,0x24,0x12,0x27,0xf2,0x20,0x42,0x2f,0xfa,0x28,0x42,0x2f,0xfe,0x20,0x42,0x20,0x42,0x3f,0xfe,0x20,0x02}}, // 圍
{0x5424,0x9AA2,0xD4A4,0xE59C93,0x5713,{0x00,0x00,0x3f,0xfe,0x20,0x02,0x27,0xf2,0x24,0x12,0x2f,0xfa,0x28,0x0a,0x2f,0xfa,0x28,0x0a,0x2f,0xfa,0x28,0x0a,0x2f,0xfa,0x22,0x32,0x2c,0x0a,0x3f,0xfe,0x20,0x02}}, // 圓
{0x5425,0x9AA3,0xD4A5,0xE59C98,0x5718,{0x00,0x00,0x3f,0xfe,0x20,0x82,0x3f,0xfe,0x20,0x82,0x27,0xf2,0x24,0x92,0x27,0xf2,0x24,0x9a,0x3f,0xf6,0x20,0x22,0x3f,0xfe,0x22,0x22,0x20,0x62,0x3f,0xfe,0x20,0x02}}, // 團
{0x5426,0x9AA4,0xD4A6,0xE59C96,0x5716,{0x00,0x00,0x3f,0xfe,0x20,0x02,0x27,0xf2,0x24,0x12,0x27,0xf2,0x20,0x82,0x3f,0xfe,0x28,0x0a,0x2b,0xea,0x2a,0x2a,0x2b,0xea,0x2f,0xfa,0x20,0x02,0x3f,0xfe,0x20,0x02}}, // 圖
{0x5427,0x9AA5,0xD4A7,0xE59787,0x55C7,{0x00,0x80,0x00,0x80,0x3f,0xfe,0x04,0x88,0x04,0x88,0x0a,0x94,0x10,0xa2,0x7f,0xff,0x00,0x00,0x1f,0xfc,0x13,0xe4,0x12,0x24,0x13,0xe4,0x10,0x04,0x1f,0xfc,0x10,0x04}}, // 嗇
{0x5428,0x9AA6,0xD4A8,0xE59C9C,0x571C,{0x00,0x00,0x3f,0xfe,0x20,0x02,0x2f,0xfa,0x29,0x4a,0x3f,0xfe,0x20,0x02,0x27,0xf2,0x24,0x12,0x27,0xf2,0x21,0x8a,0x26,0x52,0x3b,0xa2,0x26,0x1a,0x3f,0xfe,0x00,0x02}}, // 圜
{0x5429,0x9AA7,0xD4A9,0xE59CA6,0x5726,{0x08,0x00,0x08,0xe0,0x08,0x20,0x08,0x20,0x08,0x20,0x7e,0x20,0x08,0x20,0x08,0x20,0x08,0x30,0x08,0x50,0x0e,0x50,0x18,0x88,0x60,0x88,0x01,0x04,0x02,0x02,0x0c,0x01}}, // 圦
{0x542A,0x9AA8,0xD4AA,0xE59CB7,0x5737,{0x00,0x00,0x0b,0xff,0x08,0x20,0x08,0x20,0x08,0x20,0x7e,0x30,0x08,0x28,0x08,0x24,0x08,0x22,0x08,0x20,0x0e,0x20,0x18,0x20,0x60,0x20,0x00,0x20,0x00,0x20,0x00,0x20}}, // 圷
{0x542B,0x9AA9,0xD4AB,0xE59CB8,0x5738,{0x00,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x11,0x22,0x7d,0x22,0x11,0x22,0x11,0x22,0x11,0x22,0x11,0x22,0x15,0x22,0x19,0x22,0x61,0x22,0x01,0xfe,0x01,0x02,0x01,0x02}}, // 圸
{0x542C,0x9AAA,0xD4AC,0xE59D8E,0x574E,{0x00,0x80,0x10,0x80,0x10,0x80,0x10,0xfe,0x10,0x82,0x7d,0x24,0x11,0x28,0x12,0x20,0x10,0x20,0x10,0x30,0x14,0x50,0x18,0x48,0x60,0x88,0x01,0x04,0x02,0x02,0x0c,0x01}}, // 坎
{0x542D,0x9AAB,0xD4AD,0xE59CBB,0x573B,{0x10,0x04,0x10,0x18,0x10,0xe0,0x10,0x80,0x7c,0x80,0x10,0xff,0x10,0x88,0x10,0x88,0x10,0x88,0x14,0x88,0x18,0x88,0x61,0x08,0x01,0x08,0x02,0x08,0x04,0x08,0x00,0x08}}, // 圻
{0x542E,0x9AAC,0xD4AE,0xE59D80,0x5740,{0x00,0x20,0x10,0x20,0x10,0x20,0x11,0x20,0x11,0x20,0x7d,0x20,0x11,0x3e,0x11,0x20,0x11,0x20,0x11,0x20,0x15,0x20,0x19,0x20,0x61,0x20,0x01,0x20,0x0f,0xff,0x00,0x00}}, // 址
{0x542F,0x9AAD,0xD4AF,0xE59D8F,0x574F,{0x00,0x00,0x13,0xff,0x10,0x10,0x10,0x10,0x10,0x20,0x7c,0x20,0x10,0x68,0x10,0xa4,0x11,0x22,0x12,0x21,0x10,0x20,0x1c,0x20,0x60,0x20,0x00,0x20,0x00,0x20,0x00,0x20}}, // 坏
{0x5430,0x9AAE,0xD4B0,0xE59DA9,0x5769,{0x10,0x84,0x10,0x84,0x10,0x84,0x17,0xff,0x10,0x84,0x7c,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0xfc,0x14,0x84,0x18,0x84,0x60,0x84,0x00,0x84,0x00,0xfc,0x00,0x84}}, // 坩
{0x5431,0x9AAF,0xD4B1,0xE59F80,0x57C0,{0x00,0x08,0x00,0x70,0x1f,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x04,0x92,0x3c,0x9c,0x04,0x90,0x0c,0x91,0x34,0x8f,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 埀
{0x5432,0x9AB0,0xD4B2,0xE59E88,0x5788,{0x04,0x28,0x04,0x24,0x08,0x24,0x0b,0xff,0x18,0x20,0x28,0x10,0x48,0x10,0x08,0x09,0x08,0x85,0x08,0x83,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 垈
{0x5433,0x9AB1,0xD4B3,0xE59DA1,0x5761,{0x00,0x20,0x10,0x20,0x10,0x20,0x13,0xff,0x12,0x22,0x7e,0x24,0x12,0x20,0x13,0xfc,0x12,0x84,0x12,0x88,0x16,0x48,0x1a,0x30,0x64,0x30,0x04,0x48,0x09,0x84,0x16,0x03}}, // 坡
{0x5434,0x9AB2,0xD4B4,0xE59DBF,0x577F,{0x00,0x44,0x10,0x44,0x10,0x84,0x10,0x84,0x11,0x7f,0x7d,0x04,0x13,0x04,0x15,0x44,0x11,0x24,0x11,0x24,0x15,0x04,0x19,0x04,0x61,0x04,0x01,0x04,0x01,0x0c,0x01,0x04}}, // 坿
{0x5435,0x9AB3,0xD4B5,0xE59E89,0x5789,{0x00,0x40,0x08,0x40,0x08,0x7e,0x08,0x82,0x7e,0x82,0x09,0xf2,0x0a,0x92,0x08,0x92,0x08,0x92,0x08,0xf2,0x0e,0x84,0x18,0x98,0x60,0x80,0x00,0x81,0x00,0x81,0x00,0x7e}}, // 垉
{0x5436,0x9AB4,0xD4B6,0xE59E93,0x5793,{0x10,0x20,0x10,0x20,0x10,0x20,0x17,0xff,0x10,0x40,0x7c,0x48,0x10,0x48,0x11,0x90,0x10,0x54,0x10,0x24,0x14,0x48,0x19,0x90,0x60,0x30,0x00,0x48,0x01,0x84,0x06,0x02}}, // 垓
{0x5437,0x9AB5,0xD4B7,0xE59EA0,0x57A0,{0x10,0x00,0x11,0xfc,0x11,0x04,0x11,0x04,0x11,0xfc,0x7f,0x04,0x11,0x04,0x11,0xfc,0x11,0x22,0x11,0x22,0x15,0x14,0x19,0x18,0x61,0x08,0x01,0x64,0x01,0x82,0x06,0x01}}, // 垠
{0x5438,0x9AB6,0xD4B8,0xE59EB3,0x57B3,{0x00,0x80,0x10,0xbe,0x11,0x00,0x11,0x00,0x12,0x00,0x7c,0xff,0x10,0x84,0x11,0x04,0x13,0x04,0x15,0x04,0x11,0x04,0x1d,0x04,0x61,0x04,0x01,0x04,0x01,0x0c,0x01,0x04}}, // 垳
{0x5439,0x9AB7,0xD4B9,0xE59EA4,0x57A4,{0x00,0x00,0x17,0xff,0x10,0x40,0x10,0x50,0x10,0x4c,0x7c,0x9a,0x13,0xe1,0x10,0x00,0x10,0x20,0x10,0x20,0x15,0xfc,0x18,0x20,0x60,0x20,0x00,0x20,0x07,0xff,0x00,0x00}}, // 垤
{0x543A,0x9AB8,0xD4BA,0xE59EAA,0x57AA,{0x01,0x04,0x10,0x84,0x10,0x88,0x13,0xfe,0x10,0x88,0x7c,0x88,0x10,0x88,0x10,0x88,0x17,0xff,0x10,0x88,0x10,0x88,0x1c,0x88,0x71,0x08,0x01,0x08,0x02,0x08,0x04,0x08}}, // 垪
{0x543B,0x9AB9,0xD4BB,0xE59EB0,0x57B0,{0x00,0x20,0x10,0x20,0x10,0x3e,0x10,0x20,0x10,0x20,0x7f,0xff,0x10,0x00,0x10,0x00,0x13,0xff,0x10,0x20,0x14,0x30,0x18,0x2c,0x60,0x22,0x00,0x20,0x00,0x20,0x00,0x20}}, // 垰
{0x543C,0x9ABA,0xD4BC,0xE59F83,0x57C3,{0x00,0x20,0x10,0x28,0x10,0x44,0x10,0x8c,0x13,0xf2,0x7c,0x82,0x10,0x80,0x10,0xfe,0x11,0x20,0x12,0x20,0x13,0xff,0x1c,0x20,0x70,0x50,0x00,0x88,0x03,0x04,0x0c,0x03}}, // 埃
{0x543D,0x9ABB,0xD4BD,0xE59F86,0x57C6,{0x00,0x40,0x10,0x7c,0x10,0x88,0x11,0x10,0x13,0xfe,0x7d,0x12,0x11,0x12,0x11,0xfe,0x11,0x12,0x11,0x12,0x15,0xfe,0x19,0x02,0x61,0x02,0x02,0x02,0x02,0x02,0x04,0x06}}, // 埆
{0x543E,0x9ABC,0xD4BE,0xE59F94,0x57D4,{0x00,0x24,0x10,0x22,0x13,0xff,0x10,0x20,0x10,0x20,0x7d,0xfe,0x11,0x22,0x11,0x22,0x11,0xfe,0x11,0x22,0x15,0x22,0x19,0xfe,0x61,0x22,0x01,0x22,0x01,0x26,0x01,0x22}}, // 埔
{0x543F,0x9ABD,0xD4BF,0xE59F92,0x57D2,{0x00,0x04,0x10,0x38,0x13,0xc4,0x10,0x22,0x11,0x11,0x7d,0x11,0x12,0x00,0x10,0x08,0x13,0xff,0x10,0x08,0x14,0x88,0x18,0x48,0x60,0x48,0x00,0x08,0x00,0x18,0x00,0x08}}, // 埒
{0x5440,0x9ABE,0xD4C0,0xE59F93,0x57D3,{0x10,0x10,0x10,0x20,0x10,0xd2,0x13,0x8c,0x10,0x48,0x7c,0x30,0x10,0x60,0x13,0x88,0x10,0x08,0x11,0xff,0x12,0x08,0x1d,0x08,0x60,0x88,0x00,0x88,0x00,0x18,0x00,0x08}}, // 埓
{0x5441,0x9ABF,0xD4C1,0xE5A08A,0x580A,{0x00,0x00,0x3f,0xfe,0x02,0x20,0x0e,0x38,0x08,0x08,0x08,0x08,0x0e,0x38,0x02,0x20,0x7f,0xff,0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 堊
{0x5442,0x9AC0,0xD4C2,0xE59F96,0x57D6,{0x00,0x88,0x10,0x88,0x17,0xff,0x10,0x88,0x10,0x88,0x7c,0x50,0x10,0x50,0x10,0x52,0x10,0x92,0x10,0x94,0x15,0x98,0x1a,0x90,0x60,0x90,0x00,0x91,0x00,0x91,0x00,0x8f}}, // 埖
{0x5443,0x9AC1,0xD4C3,0xE59FA3,0x57E3,{0x10,0x20,0x10,0x20,0x13,0xfe,0x11,0x08,0x11,0x08,0x7d,0x8c,0x12,0x52,0x14,0x60,0x10,0x00,0x10,0x20,0x17,0xff,0x18,0x20,0x60,0x20,0x00,0x20,0x00,0x20,0x00,0x20}}, // 埣
{0x5444,0x9AC2,0xD4C4,0xE5A08B,0x580B,{0x10,0x00,0x13,0xde,0x12,0x52,0x12,0x52,0x7e,0x52,0x13,0xde,0x12,0x52,0x12,0x52,0x12,0x52,0x17,0xde,0x1a,0x52,0x62,0x52,0x02,0x52,0x02,0x52,0x04,0x62,0x08,0xc6}}, // 堋
{0x5445,0x9AC3,0xD4C5,0xE5A099,0x5819,{0x00,0x00,0x17,0xff,0x10,0x50,0x10,0x50,0x11,0xfe,0x7d,0x52,0x11,0x52,0x11,0x52,0x11,0xfe,0x10,0x20,0x14,0x20,0x1b,0xfe,0x60,0x20,0x00,0x20,0x07,0xff,0x00,0x00}}, // 堙
{0x5446,0x9AC4,0xD4C6,0xE5A09D,0x581D,{0x00,0x00,0x10,0xf8,0x10,0x88,0x10,0x88,0x10,0xb8,0x7e,0xa8,0x10,0xa8,0x13,0xfe,0x12,0x02,0x12,0x7a,0x12,0x4a,0x1e,0x4a,0x72,0x7a,0x02,0x4a,0x02,0x02,0x02,0x06}}, // 堝
{0x5447,0x9AC5,0xD4C7,0xE5A1B2,0x5872,{0x10,0x40,0x10,0x7e,0x10,0x80,0x11,0xfc,0x7e,0x84,0x10,0xfc,0x10,0x84,0x10,0xfc,0x10,0x00,0x13,0xff,0x1c,0x80,0x71,0xfe,0x02,0x4a,0x04,0x92,0x01,0x22,0x00,0x4c}}, // 塲
{0x5448,0x9AC6,0xD4C8,0xE5A0A1,0x5821,{0x04,0x00,0x05,0xfc,0x09,0x04,0x11,0x04,0x31,0xfc,0x50,0x20,0x17,0xff,0x10,0x70,0x11,0xac,0x16,0x23,0x00,0xa0,0x1f,0xfc,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 堡
{0x5449,0x9AC7,0xD4C9,0xE5A1A2,0x5862,{0x10,0x20,0x10,0x40,0x11,0xfc,0x11,0x04,0x11,0x04,0x7d,0xfc,0x11,0x04,0x11,0x00,0x11,0xff,0x11,0x00,0x15,0xfe,0x18,0x2a,0x62,0x96,0x02,0x52,0x04,0x42,0x08,0x0c}}, // 塢
{0x544A,0x9AC8,0xD4CA,0xE5A18B,0x584B,{0x08,0x10,0x2a,0x54,0x2a,0x54,0x28,0x50,0x4c,0x98,0x12,0x24,0x20,0x40,0x3f,0xfe,0x20,0x04,0x21,0x00,0x41,0x00,0x1f,0xf8,0x01,0x00,0x01,0x00,0x7f,0xfe,0x00,0x00}}, // 塋
{0x544B,0x9AC9,0xD4CB,0xE5A1B0,0x5870,{0x00,0x80,0x10,0xff,0x09,0x00,0x02,0xfc,0x24,0xa4,0x10,0x94,0x03,0xff,0x09,0x24,0x11,0x14,0x21,0xff,0x40,0x04,0x00,0x98,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 塰
{0x544C,0x9ACA,0xD4CC,0xE6AF80,0x6BC0,{0x08,0x00,0x33,0x3c,0x21,0x24,0x21,0x25,0x3b,0x25,0x21,0x43,0x21,0x80,0x3f,0xfc,0x04,0x04,0x04,0x24,0x3f,0x24,0x04,0x18,0x04,0x18,0x07,0x24,0x1c,0xc2,0x63,0x01}}, // 毀
{0x544D,0x9ACB,0xD4CD,0xE5A192,0x5852,{0x10,0x10,0x10,0x10,0x13,0xfe,0x12,0x90,0x12,0x90,0x7e,0x90,0x12,0xff,0x13,0x84,0x12,0x84,0x12,0xff,0x16,0x84,0x1a,0xc4,0x63,0xa4,0x00,0x04,0x00,0x0c,0x00,0x04}}, // 塒
{0x544E,0x9ACC,0xD4CE,0xE5A0BD,0x583D,{0x10,0x00,0x11,0xfe,0x11,0x52,0x11,0x52,0x11,0xfe,0x7e,0x00,0x11,0xff,0x10,0x20,0x10,0x20,0x11,0x20,0x17,0x3e,0x19,0x20,0x61,0x20,0x01,0x20,0x01,0xff,0x01,0x00}}, // 堽
{0x544F,0x9ACD,0xD4CF,0xE5A1B9,0x5879,{0x04,0x04,0x7f,0xb8,0x04,0x20,0x3f,0x20,0x25,0x3f,0x3f,0x24,0x25,0x24,0x3f,0x24,0x04,0x24,0x7f,0xc4,0x04,0x04,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 塹
{0x5450,0x9ACE,0xD4D0,0xE5A285,0x5885,{0x00,0x00,0x3f,0x7e,0x29,0x02,0x3f,0x14,0x29,0x08,0x3f,0x7f,0x08,0x0a,0x3f,0x0c,0x08,0x08,0x0f,0x08,0x70,0x98,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 墅
{0x5451,0x9ACF,0xD4D1,0xE5A2B9,0x58B9,{0x10,0x00,0x13,0xde,0x12,0x52,0x13,0xde,0x12,0x52,0x7e,0x52,0x13,0xde,0x12,0x02,0x12,0xfa,0x12,0x8a,0x16,0xfa,0x1a,0x8a,0x62,0x8a,0x02,0xfa,0x02,0x8a,0x02,0x06}}, // 墹
{0x5452,0x9AD0,0xD4D2,0xE5A29F,0x589F,{0x10,0x20,0x10,0x3e,0x10,0x20,0x11,0xff,0x11,0x42,0x7d,0x48,0x11,0x70,0x11,0xc2,0x11,0x3e,0x11,0x00,0x15,0xaa,0x1a,0xaa,0x62,0xee,0x04,0x28,0x0b,0xff,0x00,0x00}}, // 墟
{0x5453,0x9AD1,0xD4D3,0xE5A2AB,0x58AB,{0x10,0xbc,0x10,0x84,0x11,0xfc,0x12,0x52,0x15,0xfd,0x7d,0x54,0x11,0x9c,0x11,0xfc,0x11,0x04,0x11,0xfc,0x14,0x08,0x1b,0xff,0x60,0x88,0x00,0x48,0x00,0x08,0x00,0x18}}, // 墫
{0x5454,0x9AD2,0xD4D4,0xE5A2BA,0x58BA,{0x10,0x20,0x10,0x40,0x11,0xfe,0x11,0x12,0x11,0xea,0x7d,0xb2,0x11,0xfe,0x11,0x72,0x11,0xaa,0x11,0x26,0x14,0x20,0x1b,0xff,0x60,0x30,0x00,0x48,0x01,0x84,0x06,0x03}}, // 墺
{0x5455,0x9AD3,0xD4D5,0xE5A39E,0x58DE,{0x10,0x10,0x13,0xff,0x10,0x00,0x11,0xfe,0x7d,0x4a,0x11,0xfe,0x10,0x00,0x13,0xae,0x10,0x20,0x13,0xbe,0x1c,0x52,0x70,0x8c,0x07,0x88,0x00,0x84,0x00,0xf2,0x03,0x01}}, // 壞
{0x5456,0x9AD4,0xD4D6,0xE5A2BB,0x58BB,{0x10,0x20,0x13,0xfe,0x11,0x24,0x11,0x24,0x11,0xa6,0x7d,0x6a,0x12,0x30,0x17,0xff,0x10,0x00,0x11,0xfe,0x15,0x7a,0x19,0x4a,0x61,0x7a,0x01,0x02,0x01,0xfe,0x01,0x02}}, // 墻
{0x5457,0x9AD5,0xD4D7,0xE5A2B8,0x58B8,{0x10,0x88,0x10,0x88,0x17,0xff,0x10,0xa8,0x10,0x24,0x7d,0xfc,0x10,0x28,0x17,0xff,0x10,0x28,0x10,0x44,0x14,0xfc,0x19,0x84,0x66,0xfc,0x00,0x84,0x00,0xfc,0x00,0x84}}, // 墸
{0x5458,0x9AD6,0xD4D8,0xE5A2AE,0x58AE,{0x00,0x20,0x3d,0xff,0x24,0x40,0x28,0xfe,0x31,0x10,0x2a,0xff,0x24,0x44,0x24,0x7c,0x24,0x44,0x38,0x7c,0x20,0x4c,0x20,0x80,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 墮
{0x5459,0x9AD7,0xD4D9,0xE5A385,0x58C5,{0x00,0x80,0x7f,0xff,0x08,0x24,0x0a,0x48,0x74,0xfe,0x15,0x90,0x08,0xfe,0x0e,0x90,0x72,0xfe,0x04,0x90,0x08,0xff,0x30,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 壅
{0x545A,0x9AD8,0xD4DA,0xE5A393,0x58D3,{0x00,0x00,0x1f,0xff,0x14,0x8c,0x17,0x8a,0x10,0x7f,0x17,0x88,0x14,0x88,0x17,0x94,0x14,0x94,0x27,0xa2,0x24,0xc1,0x40,0x80,0x0f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 壓
{0x545B,0x9AD9,0xD4DB,0xE5A391,0x58D1,{0x04,0x00,0x07,0xfc,0x04,0x24,0x7f,0xa4,0x44,0xa4,0x25,0x14,0x4a,0x98,0x11,0x08,0x7f,0x94,0x11,0x22,0x1f,0x41,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 壑
{0x545C,0x9ADA,0xD4DC,0xE5A397,0x58D7,{0x10,0x20,0x11,0xfc,0x10,0x24,0x17,0xff,0x7c,0x24,0x11,0xfc,0x10,0x20,0x17,0xff,0x12,0x92,0x12,0x49,0x1c,0x00,0x73,0xfe,0x02,0x92,0x02,0x92,0x0f,0xff,0x00,0x00}}, // 壗
{0x545D,0x9ADB,0xD4DD,0xE5A399,0x58D9,{0x10,0x10,0x10,0x10,0x13,0xff,0x12,0x48,0x7e,0xfe,0x12,0x48,0x12,0x78,0x13,0xff,0x12,0x10,0x16,0xfe,0x1a,0x92,0x64,0xfe,0x04,0x92,0x08,0xfe,0x10,0xc6,0x07,0x01}}, // 壙
{0x545E,0x9ADC,0xD4DE,0xE5A398,0x58D8,{0x00,0x00,0x07,0xf0,0x04,0x90,0x07,0xf0,0x04,0x90,0x07,0xf0,0x3e,0x3e,0x2a,0x2a,0x3e,0x3e,0x2a,0x2a,0x3e,0xbe,0x00,0x80,0x1f,0xfe,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 壘
{0x545F,0x9ADD,0xD4DF,0xE5A3A5,0x58E5,{0x10,0x00,0x13,0xfe,0x12,0x00,0x12,0xfc,0x7e,0xac,0x12,0xf4,0x12,0xa4,0x13,0xfe,0x12,0x20,0x17,0xff,0x1a,0xca,0x65,0x25,0x05,0xfc,0x08,0x20,0x07,0xff,0x00,0x00}}, // 壥
{0x5460,0x9ADE,0xD4E0,0xE5A39C,0x58DC,{0x11,0xfc,0x11,0x04,0x11,0xfc,0x11,0x04,0x13,0xfe,0x7c,0x20,0x13,0xff,0x12,0x22,0x15,0xac,0x10,0x20,0x1d,0xfc,0x60,0x00,0x07,0xff,0x00,0x58,0x00,0x8c,0x03,0xf2}}, // 壜
{0x5461,0x9ADF,0xD4E1,0xE5A3A4,0x58E4,{0x00,0x20,0x13,0xff,0x10,0x00,0x11,0xce,0x11,0x4a,0x7d,0xce,0x10,0x48,0x11,0xfe,0x10,0x48,0x11,0xfe,0x14,0x48,0x1b,0xff,0x60,0x51,0x03,0x8a,0x00,0xe4,0x01,0x83}}, // 壤
{0x5462,0x9AE0,0xD4E2,0xE5A39F,0x58DF,{0x04,0x20,0x3f,0xbf,0x11,0x20,0x7f,0xfe,0x00,0x02,0x1f,0x3e,0x11,0x20,0x1f,0x3e,0x11,0x3e,0x1f,0x21,0x11,0x9f,0x00,0x80,0x1f,0xf8,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 壟
{0x5463,0x9AE1,0xD4E3,0xE5A3AF,0x58EF,{0x02,0x10,0x12,0x10,0x12,0x10,0x12,0x10,0x12,0x10,0x1f,0xff,0x02,0x10,0x02,0x10,0x3e,0x10,0x12,0x10,0x12,0x10,0x12,0x10,0x22,0x10,0x22,0x10,0x42,0xfe,0x02,0x00}}, // 壯
{0x5464,0x9AE2,0xD4E4,0xE5A3BA,0x58FA,{0x00,0x80,0x00,0x80,0x7f,0xfe,0x00,0x80,0x1f,0xf8,0x00,0x00,0x3f,0xfe,0x22,0x44,0x22,0x40,0x5e,0x78,0x10,0x08,0x1e,0x78,0x12,0x48,0x02,0x40,0x7f,0xfe,0x00,0x00}}, // 壺
{0x5465,0x9AE3,0xD4E5,0xE5A3B9,0x58F9,{0x00,0x80,0x7f,0xfe,0x00,0x80,0x1f,0xf8,0x00,0x00,0x3f,0xfe,0x20,0x04,0x3f,0xf8,0x40,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x04,0x20,0x02,0x40,0x7f,0xfe,0x00,0x00}}, // 壹
{0x5466,0x9AE4,0xD4E6,0xE5A3BB,0x58FB,{0x00,0x00,0x13,0xff,0x10,0x12,0x10,0x90,0x10,0x9e,0x7d,0x70,0x12,0x1f,0x14,0x00,0x11,0xfc,0x11,0x04,0x11,0xfc,0x1d,0x04,0x71,0xfc,0x01,0x04,0x01,0x04,0x01,0x0c}}, // 壻
{0x5467,0x9AE5,0xD4E7,0xE5A3BC,0x58FC,{0x00,0x80,0x3f,0xfe,0x00,0x80,0x0f,0xf8,0x00,0x00,0x3f,0xff,0x20,0x02,0x3f,0xfc,0x42,0x40,0x1e,0x78,0x10,0x08,0x1e,0x78,0x12,0x48,0x02,0x40,0x7f,0xff,0x00,0x00}}, // 壼
{0x5468,0x9AE6,0xD4E8,0xE5A3BD,0x58FD,{0x00,0x80,0x3f,0xfe,0x00,0x80,0x0f,0xf8,0x00,0x00,0x7f,0xfe,0x00,0x04,0x0f,0xf0,0x00,0x80,0x7f,0xff,0x00,0x08,0x1f,0xff,0x12,0x88,0x1e,0x48,0x12,0x08,0x00,0x18}}, // 壽
{0x5469,0x9AE7,0xD4E9,0xE5A482,0x5902,{0x02,0x00,0x02,0x00,0x02,0x00,0x07,0xf0,0x04,0x10,0x0a,0x10,0x0a,0x20,0x11,0x20,0x21,0x40,0x00,0x80,0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x60,0x03}}, // 夂
{0x546A,0x9AE8,0xD4EA,0xE5A48A,0x590A,{0x02,0x00,0x12,0x00,0x12,0x00,0x0b,0xf0,0x0a,0x10,0x04,0x10,0x0c,0x20,0x12,0x20,0x22,0x40,0x01,0x80,0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x60,0x03}}, // 夊
{0x546B,0x9AE9,0xD4EB,0xE5A490,0x5910,{0x02,0x00,0x07,0xe0,0x18,0x40,0x7f,0xfe,0x20,0xc2,0x23,0x22,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x00,0x80,0x03,0xf8,0x3d,0x10,0x01,0xe0,0x7e,0x1f}}, // 夐
{0x546C,0x9AEA,0xD4EC,0xE5A49B,0x591B,{0x00,0x00,0x0f,0xf0,0x00,0x10,0x0f,0xf0,0x00,0x10,0x00,0x10,0x7f,0xff,0x01,0x00,0x03,0xf8,0x0c,0x08,0x33,0x10,0x00,0xa0,0x00,0x40,0x01,0x80,0x06,0x00,0x38,0x00}}, // 夛
{0x546D,0x9AEB,0xD4ED,0xE6A2A6,0x68A6,{0x04,0x08,0x04,0x08,0x7f,0xff,0x0e,0x0c,0x0d,0x1c,0x14,0xaa,0x24,0x49,0x44,0x88,0x01,0xf8,0x02,0x08,0x0d,0x10,0x30,0xa0,0x00,0x40,0x01,0x80,0x06,0x00,0x38,0x00}}, // 梦
{0x546E,0x9AEC,0xD4EE,0xE5A4A5,0x5925,{0x00,0x08,0x3f,0x8e,0x24,0x92,0x24,0xa4,0x3f,0xd4,0x24,0x88,0x24,0x90,0x3f,0xa4,0x04,0x47,0x7f,0xc9,0x0e,0x12,0x0d,0x2a,0x14,0x84,0x24,0x88,0x44,0x10,0x04,0x60}}, // 夥
{0x546F,0x9AED,0xD4EF,0xE5A4AC,0x592C,{0x00,0x80,0x00,0x80,0x00,0x80,0x1f,0xf8,0x00,0x88,0x00,0x88,0x00,0x88,0x00,0x88,0x7f,0xff,0x00,0x80,0x00,0xc0,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x60,0x03}}, // 夬
{0x5470,0x9AEE,0xD4F0,0xE5A4AD,0x592D,{0x00,0x10,0x00,0x60,0x1f,0x80,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x7f,0xfe,0x01,0x80,0x01,0x80,0x01,0x40,0x02,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x60,0x03}}, // 夭
{0x5471,0x9AEF,0xD4F1,0xE5A4B2,0x5932,{0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x8c,0x60,0x83,0x00,0x80,0x3f,0xfe,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 夲
{0x5472,0x9AF0,0xD4F2,0xE5A4B8,0x5938,{0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0x40,0x02,0x20,0x04,0x10,0x1b,0xec,0x60,0x03,0x00,0x00,0x1f,0xfc,0x02,0x00,0x07,0xf0,0x04,0x10,0x00,0x10,0x00,0x10,0x00,0x60}}, // 夸
{0x5473,0x9AF1,0xD4F3,0xE5A4BE,0x593E,{0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x08,0x88,0x08,0x88,0x08,0x88,0x14,0x94,0x12,0x94,0x20,0xa2,0x41,0x41,0x01,0x40,0x02,0x20,0x04,0x10,0x18,0x0c,0x60,0x03}}, // 夾
{0x5474,0x9AF2,0xD4F4,0xE7AB92,0x7AD2,{0x00,0x80,0x00,0x80,0x1f,0xfc,0x04,0x10,0x02,0x10,0x02,0x20,0x7f,0xff,0x00,0x08,0x0f,0xc8,0x08,0x48,0x08,0x48,0x08,0x48,0x0f,0xc8,0x08,0x48,0x00,0x18,0x00,0x08}}, // 竒
{0x5475,0x9AF3,0xD4F5,0xE5A595,0x5955,{0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0x20,0x09,0x28,0x09,0x24,0x09,0x22,0x12,0x22,0x24,0x60,0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0x40,0x02,0x20,0x0c,0x18,0x70,0x07}}, // 奕
{0x5476,0x9AF4,0xD4F6,0xE5A590,0x5950,{0x02,0x00,0x03,0xe0,0x04,0x40,0x18,0x80,0x7f,0xfc,0x11,0x44,0x11,0x44,0x12,0x44,0x14,0x3c,0x10,0x84,0x00,0x80,0x7f,0xff,0x01,0x40,0x02,0x20,0x0c,0x18,0x70,0x07}}, // 奐
{0x5477,0x9AF5,0xD4F7,0xE5A58E,0x594E,{0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0x40,0x02,0xa0,0x0c,0x98,0x77,0xf7,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 奎
{0x5478,0x9AF6,0xD4F8,0xE5A59A,0x595A,{0x00,0x04,0x00,0x38,0x3f,0xc8,0x08,0x44,0x09,0x22,0x11,0x02,0x2e,0x20,0x42,0x48,0x01,0x84,0x1f,0xfa,0x00,0x80,0x7f,0xff,0x01,0x40,0x02,0x20,0x0c,0x18,0x70,0x07}}, // 奚
{0x5479,0x9AF7,0xD4F9,0xE5A598,0x5958,{0x24,0x20,0x24,0x20,0x24,0x20,0x3f,0xff,0x04,0x20,0x7c,0x20,0x14,0x20,0x15,0xfe,0x24,0x00,0x44,0x80,0x00,0x80,0x7f,0xff,0x01,0x40,0x02,0x20,0x0c,0x18,0x70,0x07}}, // 奘
{0x547A,0x9AF8,0xD4FA,0xE5A5A2,0x5962,{0x00,0x80,0x00,0x80,0x7f,0xff,0x02,0x20,0x04,0x90,0x1f,0xfc,0x60,0x93,0x00,0xa0,0x7f,0xff,0x01,0x10,0x07,0xf8,0x1c,0x08,0x67,0xf8,0x04,0x08,0x07,0xf8,0x04,0x08}}, // 奢
{0x547B,0x9AF9,0xD4FB,0xE5A5A0,0x5960,{0x0b,0xf8,0x08,0x08,0x0f,0xf8,0x11,0x24,0x2f,0xfe,0x49,0x2d,0x0a,0x1c,0x0c,0x04,0x0f,0xfc,0x08,0x04,0x0f,0xfc,0x00,0x80,0x7f,0xff,0x01,0x20,0x06,0x18,0x78,0x07}}, // 奠
{0x547C,0x9AFA,0xD4FC,0xE5A5A7,0x5967,{0x00,0x80,0x01,0x00,0x1f,0xfc,0x10,0x24,0x13,0xc4,0x14,0x94,0x12,0xa4,0x1f,0xfc,0x11,0xc4,0x12,0xa4,0x14,0x94,0x00,0x80,0x7f,0xff,0x01,0x40,0x06,0x30,0x78,0x0f}}, // 奧
{0x547D,0x9AFB,0xD4FD,0xE5A5AC,0x596C,{0x24,0x10,0x24,0x3e,0x25,0xca,0x3c,0x2c,0x05,0xf0,0x7c,0x04,0x25,0xff,0x24,0x44,0x24,0x24,0x44,0x8c,0x00,0x80,0x7f,0xff,0x01,0x40,0x02,0x20,0x0c,0x18,0x70,0x07}}, // 奬
{0x547E,0x9AFC,0xD4FE,0xE5A5A9,0x5969,{0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0x40,0x06,0x30,0x1f,0xfc,0x70,0x03,0x11,0xf0,0x11,0x10,0x11,0xf0,0x17,0xbc,0x14,0xa4,0x17,0xbc,0x10,0x00,0x1f,0xfe,0x10,0x00}}, // 奩
{0x5521,0x9B40,0xD5A1,0xE5A5B8,0x5978,{0x08,0x00,0x08,0xfe,0x08,0x10,0x08,0x10,0x7f,0x10,0x11,0x10,0x11,0x10,0x11,0xff,0x22,0x10,0x7a,0x10,0x46,0x10,0x05,0x10,0x09,0x10,0x10,0x10,0x60,0x10,0x00,0x10}}, // 奸
{0x5522,0x9B41,0xD5A2,0xE5A681,0x5981,{0x08,0x40,0x08,0x40,0x08,0x40,0x08,0x7e,0x7e,0x42,0x12,0x82,0x12,0x82,0x13,0x42,0x22,0x22,0x22,0x22,0x7c,0x22,0x46,0x02,0x05,0x02,0x18,0x82,0x60,0x04,0x00,0x18}}, // 妁
{0x5523,0x9B42,0xD5A3,0xE5A69D,0x599D,{0x04,0x20,0x24,0x20,0x24,0x20,0x24,0x20,0x27,0xff,0x3c,0x44,0x04,0x44,0x04,0x44,0x7c,0x44,0x14,0x88,0x15,0xe8,0x14,0x10,0x24,0x28,0x24,0x44,0x45,0x82,0x06,0x02}}, // 妝
{0x5524,0x9B43,0xD5A4,0xE4BD9E,0x4F5E,{0x04,0x00,0x05,0xfc,0x04,0x00,0x08,0x00,0x08,0x00,0x17,0xff,0x10,0x40,0x30,0x40,0x57,0xff,0x10,0x88,0x10,0x88,0x11,0x10,0x13,0xf0,0x10,0x28,0x10,0xc4,0x17,0x02}}, // 佞
{0x5525,0x9B44,0xD5A5,0xE4BEAB,0x4FAB,{0x04,0x20,0x04,0x20,0x05,0xff,0x05,0x00,0x09,0x00,0x10,0xfe,0x10,0x40,0x30,0x40,0x57,0xff,0x10,0x88,0x10,0x88,0x11,0x10,0x13,0xf0,0x10,0x28,0x10,0xc4,0x17,0x02}}, // 侫
{0x5526,0x9B45,0xD5A6,0xE5A6A3,0x59A3,{0x08,0x88,0x08,0x88,0x08,0x88,0x08,0x88,0x7f,0x89,0x12,0x89,0x12,0xfa,0x12,0x8c,0x22,0x88,0x24,0x88,0x7c,0x88,0x46,0x88,0x0a,0x88,0x10,0xb9,0x60,0xc9,0x03,0x07}}, // 妣
{0x5527,0x9B46,0xD5A7,0xE5A6B2,0x59B2,{0x08,0x00,0x08,0xfc,0x08,0x84,0x08,0x84,0x7e,0x84,0x12,0x84,0x12,0xfc,0x12,0x84,0x22,0x84,0x24,0x84,0x7c,0xfc,0x46,0x84,0x0a,0x00,0x10,0x00,0x63,0xff,0x00,0x00}}, // 妲
{0x5528,0x9B47,0xD5A8,0xE5A786,0x59C6,{0x08,0x00,0x08,0x7e,0x08,0x42,0x08,0x52,0x7f,0x4a,0x12,0x4a,0x12,0x42,0x13,0xff,0x22,0x82,0x24,0xa2,0x7c,0x92,0x46,0x92,0x0b,0xff,0x10,0x02,0x60,0x04,0x00,0x18}}, // 姆
{0x5529,0x9B48,0xD5A9,0xE5A7A8,0x59E8,{0x08,0x10,0x08,0x10,0x09,0xff,0x08,0x10,0x7e,0xfe,0x12,0x12,0x12,0xfe,0x12,0x90,0x22,0x90,0x7c,0xff,0x44,0x11,0x06,0x29,0x0a,0x2a,0x10,0x44,0x61,0x82,0x06,0x01}}, // 姨
{0x552A,0x9B49,0xD5AA,0xE5A79C,0x59DC,{0x04,0x10,0x02,0x20,0x3f,0xfe,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0x00,0x3f,0xfe,0x02,0x20,0x04,0x20,0x0f,0xc0,0x01,0x60,0x06,0x10,0x38,0x08}}, // 姜
{0x552B,0x9B4A,0xD5AB,0xE5A68D,0x598D,{0x08,0x00,0x08,0xff,0x08,0x24,0x08,0x24,0x7e,0x24,0x12,0x24,0x13,0xff,0x12,0x24,0x22,0x24,0x24,0x24,0x7c,0x24,0x46,0x24,0x0a,0x44,0x11,0x44,0x60,0x84,0x01,0x04}}, // 妍
{0x552C,0x9B4B,0xD5AC,0xE5A799,0x59D9,{0x10,0x42,0x10,0x44,0x10,0x78,0x10,0x88,0x7e,0x88,0x13,0x88,0x12,0x88,0x12,0xff,0x22,0x88,0x24,0x88,0x7c,0x88,0x46,0x88,0x0a,0x88,0x10,0x88,0x60,0xbf,0x00,0x80}}, // 姙
{0x552D,0x9B4C,0xD5AD,0xE5A79A,0x59DA,{0x08,0x28,0x08,0x28,0x08,0x2a,0x09,0x2a,0x7e,0xaa,0x12,0xac,0x12,0xac,0x12,0x28,0x22,0x2c,0x24,0x6a,0x7c,0xc9,0x47,0x48,0x0a,0x48,0x10,0x89,0x61,0x09,0x06,0x07}}, // 姚
{0x552E,0x9B4D,0xD5AE,0xE5A8A5,0x5A25,{0x08,0x28,0x08,0x4c,0x09,0xca,0x08,0x4a,0x7e,0x48,0x13,0xff,0x12,0x48,0x12,0x4a,0x22,0x4a,0x24,0x6c,0x7d,0xc4,0x46,0x4d,0x0a,0x55,0x10,0x63,0x60,0x43,0x00,0xc1}}, // 娥
{0x552F,0x9B4E,0xD5AF,0xE5A89F,0x5A1F,{0x08,0x00,0x08,0xfe,0x08,0x82,0x08,0x82,0x7e,0xfe,0x12,0x00,0x12,0xfe,0x12,0x82,0x22,0x82,0x24,0xfe,0x7c,0x82,0x46,0x82,0x0a,0xfe,0x10,0x82,0x60,0x82,0x00,0x86}}, // 娟
{0x5530,0x9B4F,0xD5B0,0xE5A891,0x5A11,{0x00,0x10,0x18,0x10,0x04,0x94,0x60,0x92,0x11,0x11,0x02,0x34,0x08,0x08,0x30,0x30,0x41,0xc0,0x01,0x00,0x7f,0xff,0x02,0x20,0x04,0x20,0x0f,0xc0,0x01,0xb0,0x3e,0x0c}}, // 娑
{0x5531,0x9B50,0xD5B1,0xE5A89C,0x5A1C,{0x10,0x00,0x13,0xef,0x10,0xa9,0x10,0xa9,0x7e,0xaa,0x15,0xec,0x14,0xaa,0x14,0xaa,0x24,0xa9,0x25,0xe9,0x78,0xa9,0x0c,0xa9,0x0b,0x2e,0x11,0x28,0x62,0x28,0x04,0x68}}, // 娜
{0x5532,0x9B51,0xD5B2,0xE5A889,0x5A09,{0x08,0x10,0x08,0x10,0x08,0xfe,0x08,0x92,0x7e,0xfe,0x12,0x92,0x12,0x92,0x12,0xfe,0x22,0x00,0x25,0xff,0x7c,0x20,0x46,0x7c,0x0a,0x44,0x10,0x04,0x60,0x04,0x00,0x18}}, // 娉
{0x5533,0x9B52,0xD5B3,0xE5A89A,0x5A1A,{0x08,0x00,0x08,0xfe,0x08,0x92,0x08,0x92,0x7e,0xfe,0x12,0x92,0x12,0x92,0x12,0xfe,0x22,0x20,0x24,0x20,0x7c,0xfe,0x46,0x22,0x0a,0x22,0x10,0x42,0x60,0x82,0x03,0x0c}}, // 娚
{0x5534,0x9B53,0xD5B4,0xE5A980,0x5A40,{0x08,0x00,0x09,0xdf,0x09,0x42,0x09,0x42,0x7f,0x7a,0x15,0xaa,0x15,0xaa,0x15,0x6a,0x25,0x6a,0x25,0x7a,0x79,0x6a,0x0d,0x42,0x09,0xc2,0x11,0x02,0x61,0x02,0x01,0x06}}, // 婀
{0x5535,0x9B54,0xD5B5,0xE5A9AC,0x5A6C,{0x08,0x02,0x08,0x0c,0x08,0xf0,0x08,0x04,0x7f,0x52,0x12,0x49,0x12,0x89,0x12,0x04,0x22,0xf8,0x24,0x10,0x7c,0x10,0x47,0xff,0x0a,0x10,0x10,0x10,0x61,0xfe,0x00,0x00}}, // 婬
{0x5536,0x9B55,0xD5B6,0xE5A989,0x5A49,{0x08,0x10,0x08,0x10,0x08,0xff,0x08,0x82,0x7f,0x00,0x12,0x80,0x12,0xee,0x12,0xaa,0x25,0x2a,0x25,0x2a,0x7e,0xaa,0x04,0x4e,0x08,0x48,0x10,0x89,0x61,0x09,0x02,0x07}}, // 婉
{0x5537,0x9B56,0xD5B7,0xE5A8B5,0x5A35,{0x08,0x00,0x0b,0xff,0x09,0x20,0x09,0x20,0x7d,0x3e,0x15,0xea,0x15,0x2a,0x15,0x2a,0x25,0x2a,0x25,0xea,0x79,0x24,0x09,0x24,0x0d,0xea,0x17,0x32,0x60,0x21,0x00,0x20}}, // 娵
{0x5538,0x9B57,0xD5B8,0xE5A8B6,0x5A36,{0x00,0x00,0x7f,0x80,0x11,0xfe,0x1f,0x42,0x11,0x24,0x1f,0x28,0x11,0x18,0x1f,0x24,0x71,0xc3,0x01,0x00,0x7f,0xff,0x02,0x20,0x04,0x20,0x0f,0xc0,0x01,0xb0,0x3e,0x08}}, // 娶
{0x5539,0x9B58,0xD5B9,0xE5A9A2,0x5A62,{0x08,0x10,0x08,0x20,0x08,0xfe,0x08,0x92,0x7e,0x92,0x12,0xfe,0x12,0x92,0x12,0x92,0x22,0xfe,0x24,0x28,0x7c,0x48,0x07,0xff,0x0a,0x08,0x10,0x08,0x60,0x08,0x00,0x08}}, // 婢
{0x553A,0x9B59,0xD5BA,0xE5A9AA,0x5A6A,{0x04,0x10,0x04,0x10,0x7f,0xff,0x0e,0x18,0x0d,0x34,0x14,0xd4,0x24,0x92,0x44,0x11,0x01,0x00,0x7f,0xff,0x02,0x20,0x04,0x20,0x0f,0x40,0x00,0xc0,0x03,0x30,0x3c,0x08}}, // 婪
{0x553B,0x9B5A,0xD5BB,0xE5AA9A,0x5A9A,{0x08,0x00,0x08,0xff,0x08,0x91,0x08,0x91,0x7e,0xff,0x12,0x80,0x12,0xbe,0x12,0xa2,0x22,0xa2,0x24,0xbe,0x7c,0xa2,0x46,0xbe,0x09,0x22,0x11,0x22,0x62,0x3e,0x00,0x22}}, // 媚
{0x553C,0x9B5B,0xD5BC,0xE5AABC,0x5ABC,{0x08,0x00,0x08,0xfc,0x08,0xa4,0x08,0xa4,0x7e,0xb4,0x12,0xd4,0x12,0x8c,0x12,0xfc,0x22,0x00,0x24,0xfe,0x7c,0xaa,0x46,0xaa,0x0a,0xaa,0x10,0xaa,0x63,0xff,0x00,0x00}}, // 媼
{0x553D,0x9B5C,0xD5BD,0xE5AABE,0x5ABE,{0x08,0x48,0x08,0x48,0x08,0xfe,0x08,0x48,0x7e,0xfe,0x12,0x48,0x13,0xff,0x12,0x10,0x22,0xfe,0x24,0x92,0x7c,0xfe,0x46,0x92,0x0b,0xff,0x10,0x82,0x60,0x82,0x00,0x86}}, // 媾
{0x553E,0x9B5D,0xD5BE,0xE5AB8B,0x5ACB,{0x10,0x00,0x11,0xfe,0x10,0x22,0x10,0x22,0x7d,0xee,0x15,0x08,0x15,0x08,0x25,0xee,0x24,0x66,0x24,0xaa,0x79,0x32,0x4c,0x66,0x0a,0xaa,0x11,0x32,0x60,0x44,0x01,0x98}}, // 嫋
{0x553F,0x9B5E,0xD5BF,0xE5AB82,0x5AC2,{0x08,0x10,0x08,0x50,0x08,0xd6,0x08,0x92,0x7e,0x92,0x12,0xd6,0x12,0x92,0x12,0x92,0x22,0xfe,0x24,0x10,0x7d,0xfe,0x46,0x44,0x0a,0x28,0x10,0x30,0x60,0xcc,0x03,0x03}}, // 嫂
{0x5540,0x9B5F,0xD5C0,0xE5AABD,0x5ABD,{0x08,0x00,0x08,0xfe,0x08,0x90,0x08,0x90,0x7e,0xfc,0x12,0x90,0x12,0x90,0x12,0xfc,0x22,0x90,0x24,0x90,0x7c,0xfe,0x46,0x2a,0x0b,0x56,0x11,0x52,0x62,0x02,0x00,0x0c}}, // 媽
{0x5541,0x9B60,0xD5C1,0xE5ABA3,0x5AE3,{0x08,0x00,0x09,0xff,0x08,0x10,0x08,0x50,0x7e,0x5e,0x12,0x50,0x12,0x50,0x13,0xff,0x22,0x80,0x24,0xff,0x7c,0x80,0x46,0xfe,0x0a,0x0a,0x11,0x56,0x61,0x52,0x02,0x0c}}, // 嫣
{0x5542,0x9B61,0xD5C2,0xE5AB97,0x5AD7,{0x08,0x00,0x09,0xff,0x09,0x00,0x09,0x7c,0x7f,0x44,0x15,0x44,0x15,0x7c,0x15,0x00,0x25,0xee,0x25,0xaa,0x79,0xaa,0x4d,0xaa,0x0b,0xee,0x11,0x00,0x61,0xff,0x01,0x00}}, // 嫗
{0x5543,0x9B62,0xD5C3,0xE5ABA6,0x5AE6,{0x08,0x92,0x08,0x52,0x08,0x54,0x09,0xff,0x7f,0x01,0x13,0x7d,0x12,0x44,0x12,0x44,0x22,0x7c,0x24,0x10,0x7c,0xfe,0x46,0x92,0x0a,0x92,0x10,0x92,0x60,0x9c,0x00,0x10}}, // 嫦
{0x5544,0x9B63,0xD5C4,0xE5ABA9,0x5AE9,{0x11,0x10,0x11,0x10,0x17,0xd0,0x11,0x1f,0x7f,0xd4,0x15,0x64,0x15,0x54,0x15,0x54,0x27,0xd4,0x25,0x18,0x79,0x88,0x0b,0x54,0x13,0x14,0x25,0x22,0x41,0x42,0x01,0x81}}, // 嫩
{0x5545,0x9B64,0xD5C5,0xE5AB96,0x5AD6,{0x08,0x00,0x09,0xff,0x08,0x28,0x08,0xfe,0x7e,0xaa,0x12,0xaa,0x12,0xfe,0x12,0x00,0x22,0xfe,0x24,0x00,0x7d,0xff,0x46,0x10,0x0a,0x94,0x10,0x92,0x61,0x12,0x00,0x30}}, // 嫖
{0x5546,0x9B65,0xD5C6,0xE5ABBA,0x5AFA,{0x10,0x00,0x11,0xde,0x11,0x52,0x11,0xde,0x7f,0x52,0x15,0x52,0x15,0xde,0x15,0x02,0x25,0x7a,0x25,0x4a,0x79,0x7a,0x0d,0x4a,0x09,0x7a,0x11,0x4a,0x61,0x9a,0x01,0x06}}, // 嫺
{0x5547,0x9B66,0xD5C7,0xE5ABBB,0x5AFB,{0x10,0x00,0x11,0xde,0x11,0x52,0x11,0xde,0x7f,0x52,0x15,0x52,0x15,0xde,0x15,0x22,0x25,0x22,0x25,0xfa,0x79,0x32,0x4d,0x6a,0x09,0xa6,0x11,0x22,0x61,0x22,0x01,0x06}}, // 嫻
{0x5548,0x9B67,0xD5C8,0xE5AC8C,0x5B0C,{0x08,0x0c,0x08,0xf0,0x08,0x10,0x09,0xff,0x7e,0x48,0x12,0xfc,0x13,0x4b,0x12,0x78,0x22,0x00,0x25,0xfe,0x7d,0x02,0x47,0x7a,0x0b,0x4a,0x11,0x7a,0x61,0x4a,0x01,0x06}}, // 嬌
{0x5549,0x9B68,0xD5C9,0xE5AC8B,0x5B0B,{0x08,0x00,0x09,0xef,0x09,0x29,0x09,0xef,0x7e,0x00,0x12,0xfe,0x12,0x92,0x12,0xfe,0x22,0x92,0x24,0x92,0x7c,0xfe,0x46,0x10,0x0b,0xff,0x10,0x10,0x60,0x10,0x00,0x10}}, // 嬋
{0x554A,0x9B69,0xD5CA,0xE5AC96,0x5B16,{0x00,0x10,0x1f,0x10,0x11,0xfe,0x11,0x44,0x1f,0x28,0x10,0xff,0x1f,0x10,0x29,0xfe,0x29,0x10,0x4f,0x10,0x01,0x00,0x7f,0xff,0x04,0x20,0x0f,0xc0,0x01,0xb0,0x3e,0x0c}}, // 嬖
{0x554B,0x9B6A,0xD5CB,0xE5ACB2,0x5B32,{0x01,0x00,0x7d,0x1f,0x55,0x15,0x55,0x15,0x7f,0xff,0x55,0x55,0x55,0x55,0x7d,0x5f,0x12,0x44,0x7e,0x5f,0x17,0x85,0x14,0xc5,0x24,0xa9,0x25,0x09,0x46,0x11,0x18,0x26}}, // 嬲
{0x554C,0x9B6B,0xD5CC,0xE5AB90,0x5AD0,{0x10,0x08,0x13,0xe8,0x12,0xa8,0x12,0xa8,0x7f,0xff,0x2a,0xaa,0x2a,0xaa,0x2b,0xea,0x28,0x8a,0x4b,0xf2,0x70,0xbc,0x48,0xa4,0x14,0xa6,0x25,0x2a,0x42,0x31,0x04,0xc1}}, // 嫐
{0x554D,0x9B6C,0xD5CD,0xE5ACAA,0x5B2A,{0x08,0x20,0x09,0xff,0x09,0x02,0x0a,0xfc,0x7e,0xa4,0x14,0xa8,0x15,0x30,0x14,0xfc,0x27,0x84,0x24,0xfc,0x78,0x84,0x0c,0xfc,0x0a,0x84,0x10,0xfc,0x60,0xc4,0x03,0x02}}, // 嬪
{0x554E,0x9B6D,0xD5CE,0xE5ACB6,0x5B36,{0x08,0x20,0x08,0xfc,0x08,0x84,0x08,0xfc,0x7e,0x84,0x12,0xfc,0x12,0x84,0x13,0xfe,0x25,0x22,0x7d,0xfe,0x45,0x22,0x09,0xfe,0x08,0x00,0x13,0xff,0x60,0x88,0x01,0x08}}, // 嬶
{0x554F,0x9B6E,0xD5CF,0xE5ACBE,0x5B3E,{0x11,0x00,0x11,0x3f,0x17,0xe9,0x11,0x09,0x7f,0xd6,0x15,0x60,0x15,0x5e,0x25,0x52,0x27,0xde,0x79,0x12,0x4b,0x9e,0x0b,0x52,0x15,0x3e,0x25,0x0c,0x49,0x12,0x01,0x61}}, // 嬾
{0x5550,0x9B6F,0xD5D0,0xE5AD83,0x5B43,{0x08,0x20,0x0b,0xff,0x08,0x00,0x09,0xfe,0x7f,0x32,0x13,0xfe,0x12,0x48,0x15,0xfe,0x24,0x48,0x25,0xfe,0x7c,0x48,0x07,0xff,0x08,0xd0,0x13,0x4a,0x60,0x74,0x01,0xc3}}, // 孃
{0x5551,0x9B70,0xD5D1,0xE5AD85,0x5B45,{0x11,0x28,0x11,0x2a,0x12,0xd9,0x12,0x49,0x7c,0x88,0x17,0xff,0x15,0x48,0x17,0x6a,0x25,0x4a,0x27,0x6a,0x79,0x44,0x0f,0x64,0x15,0x5d,0x21,0xeb,0x47,0x13,0x00,0x21}}, // 孅
{0x5552,0x9B71,0xD5D2,0xE5AD80,0x5B40,{0x10,0x00,0x13,0xfe,0x10,0x10,0x11,0xff,0x7d,0x12,0x17,0x9c,0x14,0xd6,0x24,0x00,0x25,0x3e,0x7f,0xe2,0x49,0x3e,0x0b,0xa2,0x17,0x7e,0x65,0x22,0x09,0x3e,0x01,0x22}}, // 孀
{0x5553,0x9B72,0xD5D3,0xE5AD91,0x5B51,{0x00,0x00,0x1f,0xf8,0x00,0x10,0x00,0x20,0x00,0x40,0x00,0x80,0x00,0x82,0x00,0x9c,0x03,0xe0,0x7c,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x03,0x80,0x00,0x80}}, // 孑
{0x5554,0x9B73,0xD5D4,0xE5AD95,0x5B55,{0x00,0x00,0x3f,0xf8,0x01,0x08,0x01,0x08,0x02,0x1e,0x04,0x02,0x18,0x02,0x67,0xf2,0x00,0x2c,0x00,0x40,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x01,0x80}}, // 孕
{0x5555,0x9B74,0xD5D5,0xE5AD9A,0x5B5A,{0x00,0x08,0x00,0x70,0x1f,0x80,0x10,0x84,0x10,0x42,0x20,0x41,0x4f,0xf8,0x00,0x10,0x00,0x20,0x00,0x40,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x01,0x80}}, // 孚
{0x5556,0x9B75,0xD5D6,0xE5AD9B,0x5B5B,{0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x3f,0xfe,0x20,0x04,0x20,0x00,0x4f,0xf0,0x00,0x60,0x00,0x80,0x7f,0xfe,0x00,0x80,0x00,0x80,0x00,0x80,0x01,0x80}}, // 孛
{0x5557,0x9B76,0xD5D7,0xE5ADA5,0x5B65,{0x04,0x00,0x04,0x00,0x7f,0xfe,0x08,0xa2,0x09,0x24,0x11,0x14,0x3e,0x18,0x05,0x64,0x18,0x03,0x67,0xf0,0x00,0x60,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x01,0x80}}, // 孥
{0x5558,0x9B77,0xD5D8,0xE5ADA9,0x5B69,{0x00,0x20,0x7e,0x20,0x02,0x20,0x07,0xff,0x08,0x20,0x08,0x28,0x09,0xc8,0x0e,0x52,0x78,0x32,0x08,0x24,0x08,0x44,0x09,0x88,0x08,0x10,0x08,0x28,0x08,0xc4,0x1b,0x02}}, // 孩
{0x5559,0x9B78,0xD5D9,0xE5ADB0,0x5B70,{0x08,0x10,0x08,0x10,0x7f,0x90,0x00,0x10,0x3e,0xfc,0x22,0x14,0x3e,0x14,0x00,0x94,0x7f,0x54,0x02,0x24,0x04,0x24,0x07,0x34,0x7c,0x55,0x04,0x55,0x04,0x83,0x0d,0x01}}, // 孰
{0x555A,0x9B79,0xD5DA,0xE5ADB3,0x5B73,{0x08,0x08,0x04,0x10,0x7f,0xff,0x04,0x10,0x19,0x64,0x0a,0x28,0x05,0x14,0x3e,0xfa,0x00,0x00,0x0f,0xf8,0x00,0x60,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x01,0x80}}, // 孳
{0x555B,0x9B7A,0xD5DB,0xE5ADB5,0x5B75,{0x08,0x02,0x33,0x8c,0x2a,0xf2,0x2a,0xa9,0x2a,0xa9,0x3b,0xa1,0x3b,0xc0,0x2b,0xbe,0x2a,0x84,0x2a,0x88,0x3a,0xff,0x6b,0x88,0x12,0x08,0x12,0x08,0x22,0x08,0x42,0x18}}, // 孵
{0x555C,0x9B7B,0xD5DC,0xE5ADB8,0x5B78,{0x04,0x00,0x1a,0xb8,0x11,0x08,0x1e,0xb8,0x12,0x88,0x1d,0x38,0x12,0x88,0x3f,0xff,0x20,0x02,0x4f,0xf0,0x00,0x40,0x00,0x80,0x7f,0xfe,0x00,0x80,0x00,0x80,0x01,0x80}}, // 學
{0x555D,0x9B7C,0xD5DD,0xE69688,0x6588,{0x00,0x80,0x00,0x80,0x7f,0xff,0x02,0x10,0x01,0x20,0x00,0xc0,0x03,0x60,0x0c,0x18,0x70,0x07,0x0f,0xf0,0x00,0x60,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x01,0x80}}, // 斈
{0x555E,0x9B7D,0xD5DE,0xE5ADBA,0x5B7A,{0x00,0x00,0x7d,0xfe,0x04,0x10,0x09,0xff,0x19,0x11,0x12,0xde,0x10,0x12,0x14,0xdc,0x18,0x00,0x77,0xff,0x10,0x20,0x11,0xfe,0x11,0x52,0x11,0x52,0x31,0x52,0x11,0x06}}, // 孺
{0x555F,0x9B7E,0xD5DF,0xE5AE80,0x5B80,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x82,0x3f,0xff,0x20,0x02,0x20,0x04,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, // 宀
{0x5560,0x9B80,0xD5E0,0xE5AE83,0x5B83,{0x01,0x00,0x01,0x00,0x3f,0xff,0x20,0x02,0x28,0x00,0x48,0x00,0x08,0x10,0x08,0x20,0x08,0xc0,0x0f,0x00,0x08,0x00,0x08,0x02,0x08,0x02,0x04,0x02,0x03,0xfe,0x00,0x00}}, // 它
{0x5561,0x9B81,0xD5E1,0xE5AEA6,0x5BA6,{0x00,0x80,0x00,0x80,0x3f,0xff,0x20,0x02,0x3f,0xf8,0x50,0x80,0x10,0x80,0x1f,0xf8,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x80,0x10,0x80,0x10,0x80,0x1f,0xfc,0x10,0x00}}, // 宦
{0x5562,0x9B82,0xD5E2,0xE5AEB8,0x5BB8,{0x00,0x80,0x00,0x80,0x3f,0xff,0x20,0x02,0x20,0x00,0x5f,0xfc,0x10,0x00,0x17,0xf8,0x10,0x00,0x1f,0xfe,0x14,0x88,0x14,0x50,0x24,0x20,0x24,0x10,0x47,0x8c,0x1c,0x03}}, // 宸
{0x5563,0x9B83,0xD5E3,0xE5AF83,0x5BC3,{0x00,0x80,0x00,0x80,0x3f,0xff,0x21,0x02,0x23,0xe0,0x44,0x40,0x18,0x80,0x7f,0xf8,0x11,0x08,0x11,0x08,0x1f,0xf8,0x02,0xa0,0x02,0x90,0x04,0x8a,0x18,0x82,0x60,0x7e}}, // 寃
{0x5564,0x9B84,0xD5E4,0xE5AF87,0x5BC7,{0x01,0x00,0x01,0x00,0x3f,0xfe,0x20,0x04,0x20,0x20,0x5e,0x20,0x00,0x3c,0x00,0x20,0x7f,0xf8,0x14,0x88,0x14,0x50,0x14,0x20,0x14,0xd2,0x17,0x0e,0x22,0x02,0x41,0xfe}}, // 寇
{0x5565,0x9B85,0xD5E5,0xE5AF89,0x5BC9,{0x00,0x80,0x00,0x80,0x3f,0xff,0x24,0x02,0x24,0x20,0x48,0x40,0x1f,0xfc,0x10,0x80,0x30,0x80,0x5f,0xf8,0x10,0x80,0x1f,0xf8,0x10,0x80,0x10,0x80,0x1f,0xfe,0x10,0x00}}, // 寉
{0x5566,0x9B86,0xD5E6,0xE5AF94,0x5BD4,{0x00,0x80,0x00,0x80,0x3f,0xff,0x20,0x02,0x27,0xf0,0x44,0x10,0x07,0xf0,0x04,0x10,0x07,0xf0,0x00,0x00,0x7f,0xff,0x04,0x80,0x04,0xfc,0x0c,0x80,0x13,0x80,0x60,0xff}}, // 寔
{0x5567,0x9B87,0xD5E7,0xE5AF90,0x5BD0,{0x00,0x80,0x00,0x80,0x3f,0xff,0x20,0x02,0x44,0x20,0x24,0x20,0x25,0xfc,0x24,0x20,0x3c,0x20,0x07,0xff,0x04,0x70,0x7c,0xa8,0x25,0x24,0x26,0x23,0x44,0x20,0x04,0x60}}, // 寐
{0x5568,0x9B88,0xD5E8,0xE5AFA4,0x5BE4,{0x00,0x80,0x00,0x80,0x3f,0xff,0x24,0x02,0x45,0xfc,0x24,0x40,0x27,0xf8,0x24,0x88,0x3c,0x88,0x07,0xff,0x04,0x00,0x7d,0xfc,0x25,0x04,0x25,0x04,0x45,0xfc,0x05,0x04}}, // 寤
{0x5569,0x9B89,0xD5E9,0xE5AFA6,0x5BE6,{0x00,0x80,0x3f,0xff,0x20,0x02,0x27,0xf8,0x44,0x88,0x3f,0xfe,0x11,0x10,0x1f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x06,0x18,0x38,0x06}}, // 實
{0x556A,0x9B8A,0xD5EA,0xE5AFA2,0x5BE2,{0x00,0x80,0x00,0x80,0x3f,0xff,0x20,0x02,0x44,0xf8,0x24,0x08,0x25,0xfe,0x3c,0x08,0x07,0xfe,0x06,0x02,0x7d,0xf8,0x24,0x88,0x24,0x50,0x24,0x20,0x44,0xd8,0x07,0x07}}, // 寢
{0x556B,0x9B8B,0xD5EB,0xE5AF9E,0x5BDE,{0x00,0x80,0x00,0x80,0x3f,0xff,0x24,0x22,0x3f,0xf8,0x44,0x20,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x00,0x80,0x7f,0xfe,0x01,0x40,0x06,0x30,0x78,0x0f}}, // 寞
{0x556C,0x9B8C,0xD5EC,0xE5AFA5,0x5BE5,{0x00,0x80,0x00,0x80,0x3f,0xff,0x20,0x02,0x3e,0xf8,0x4a,0x28,0x36,0xd8,0x0a,0xa8,0x33,0x48,0x06,0x60,0x19,0x98,0x6e,0x47,0x01,0x90,0x1e,0x60,0x01,0x80,0x1e,0x00}}, // 寥
{0x556D,0x9B8D,0xD5ED,0xE5AFAB,0x5BEB,{0x00,0x80,0x00,0x80,0x3f,0xff,0x21,0x02,0x2e,0x70,0x48,0x10,0x0e,0x70,0x08,0x10,0x0f,0xf0,0x04,0x00,0x0f,0xfc,0x10,0x24,0x64,0x94,0x12,0x54,0x12,0x44,0x20,0x18}}, // 寫
{0x556E,0x9B8E,0xD5EE,0xE5AFB0,0x5BF0,{0x00,0x80,0x3f,0xff,0x20,0x02,0x3f,0xf8,0x52,0x48,0x1f,0xf8,0x00,0x00,0x7f,0xfe,0x00,0x00,0x1f,0xf8,0x10,0x08,0x1f,0xfc,0x02,0x84,0x0e,0x68,0x73,0x98,0x0e,0x07}}, // 寰
{0x556F,0x9B8F,0xD5EF,0xE5AFB6,0x5BF6,{0x00,0x80,0x3f,0xff,0x20,0x42,0x5e,0x7c,0x08,0x90,0x3e,0x7c,0x08,0x92,0x1f,0xfe,0x68,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x06,0x30,0x38,0x0c}}, // 寶
{0x5570,0x9B90,0xD5F0,0xE5AFB3,0x5BF3,{0x00,0x80,0x3f,0xff,0x20,0x42,0x5e,0x7e,0x08,0x90,0x3e,0x54,0x08,0x92,0x1f,0xf2,0x68,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x06,0x30,0x38,0x0c}}, // 寳
{0x5571,0x9B91,0xD5F1,0xE5B085,0x5C05,{0x04,0x04,0x04,0x04,0x7f,0xc4,0x04,0x04,0x04,0x7f,0x3f,0x04,0x21,0x04,0x21,0x44,0x3f,0x24,0x2a,0x24,0x0a,0x04,0x0a,0x04,0x12,0x0d,0x12,0x05,0x21,0x01,0x40,0xff}}, // 尅
{0x5572,0x9B92,0xD5F2,0xE5B087,0x5C07,{0x04,0x20,0x24,0x3c,0x24,0x44,0x24,0xa8,0x25,0x50,0x3c,0x20,0x04,0xc0,0x07,0x08,0x7c,0x08,0x27,0xff,0x24,0x08,0x24,0x88,0x24,0x48,0x24,0x48,0x44,0x08,0x04,0x18}}, // 將
{0x5573,0x9B93,0xD5F3,0xE5B088,0x5C08,{0x00,0x80,0x7f,0xff,0x00,0x80,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x00,0x88,0x01,0xf4,0x3e,0x02,0x00,0x08,0x7f,0xff,0x04,0x08,0x02,0x08,0x00,0x18}}, // 專
{0x5574,0x9B94,0xD5F4,0xE5B08D,0x5C0D,{0x0a,0x04,0x4a,0x84,0x2b,0x04,0x0a,0x04,0x7f,0xff,0x00,0x04,0x11,0x04,0x0a,0x44,0x7f,0xa4,0x04,0x24,0x04,0x04,0x3f,0x84,0x04,0x04,0x07,0x84,0x0c,0x04,0x70,0x0c}}, // 對
{0x5575,0x9B95,0xD5F5,0xE5B093,0x5C13,{0x08,0x00,0x08,0x00,0x08,0x00,0x0f,0xff,0x10,0x80,0x10,0x80,0x20,0x80,0x44,0x90,0x04,0x88,0x04,0x84,0x08,0x84,0x08,0x82,0x10,0x82,0x20,0x82,0x00,0x80,0x01,0x80}}, // 尓
{0x5576,0x9B96,0xD5F6,0xE5B0A0,0x5C20,{0x11,0x08,0x11,0x08,0x7f,0x88,0x11,0x2c,0x1f,0x2a,0x11,0x2a,0x1f,0x49,0x11,0x09,0x7f,0xc8,0x2a,0x1a,0x2a,0x82,0x29,0x84,0x30,0x04,0x20,0x08,0x3f,0xb0,0x00,0xc0}}, // 尠
{0x5577,0x9B97,0xD5F7,0xE5B0A2,0x5C22,{0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x3f,0xff,0x00,0x80,0x00,0xc0,0x00,0xa0,0x00,0xa0,0x01,0x20,0x01,0x20,0x02,0x20,0x02,0x21,0x04,0x21,0x18,0x11,0x60,0x0f}}, // 尢
{0x5578,0x9B98,0xD5F8,0xE5B0A8,0x5C28,{0x08,0x08,0x0a,0x08,0x09,0x08,0x08,0x12,0x7f,0xd2,0x08,0x24,0x08,0x45,0x0c,0x89,0x0a,0x12,0x0a,0x22,0x0a,0x44,0x12,0x08,0x12,0x10,0x12,0x21,0x21,0x01,0x40,0xff}}, // 尨
{0x5579,0x9B99,0xD5F9,0xE5B0B8,0x5C38,{0x00,0x00,0x0f,0xfe,0x08,0x02,0x08,0x02,0x08,0x02,0x0f,0xfe,0x08,0x02,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x10,0x00,0x10,0x00,0x20,0x00,0x40,0x00}}, // 尸
{0x557A,0x9B9A,0xD5FA,0xE5B0B9,0x5C39,{0x00,0x00,0x1f,0xfc,0x00,0x84,0x00,0x84,0x00,0x84,0x7f,0xff,0x00,0x84,0x00,0x84,0x00,0x84,0x1f,0xfc,0x00,0x80,0x00,0x80,0x01,0x00,0x02,0x00,0x0c,0x00,0x30,0x00}}, // 尹
{0x557B,0x9B9B,0xD5FB,0xE5B181,0x5C41,{0x00,0x00,0x1f,0xfe,0x10,0x02,0x10,0x02,0x1f,0xfe,0x10,0x02,0x12,0x10,0x12,0x10,0x12,0x12,0x13,0xd4,0x12,0x18,0x12,0x10,0x22,0x10,0x22,0xd1,0x47,0x11,0x18,0x0f}}, // 屁
{0x557C,0x9B9C,0xD5FC,0xE5B186,0x5C46,{0x00,0x00,0x1f,0xfe,0x10,0x02,0x10,0x02,0x1f,0xfe,0x10,0x02,0x10,0x20,0x14,0x22,0x17,0xfe,0x14,0x22,0x14,0x22,0x14,0x22,0x25,0xfa,0x24,0x02,0x47,0xfe,0x04,0x02}}, // 屆
{0x557D,0x9B9D,0xD5FD,0xE5B18E,0x5C4E,{0x00,0x00,0x1f,0xfe,0x10,0x02,0x10,0x02,0x1f,0xfe,0x10,0x42,0x14,0x48,0x12,0x48,0x12,0x50,0x1f,0xfe,0x10,0xe0,0x11,0x50,0x26,0x4c,0x38,0x43,0x40,0x40,0x00,0x40}}, // 屎
{0x557E,0x9B9E,0xD5FE,0xE5B193,0x5C53,{0x00,0x00,0x1f,0xfe,0x10,0x02,0x10,0x02,0x1f,0xfe,0x10,0x00,0x17,0xfc,0x14,0x04,0x17,0xfc,0x14,0x04,0x17,0xfc,0x14,0x04,0x27,0xfc,0x21,0x10,0x46,0x0c,0x18,0x02}}, // 屓
{0x5621,0x9B9F,0xD6A1,0xE5B190,0x5C50,{0x00,0x00,0x1f,0xfe,0x10,0x02,0x10,0x02,0x1f,0xfe,0x12,0x10,0x12,0xff,0x15,0x10,0x19,0x10,0x12,0xfc,0x12,0x44,0x16,0x28,0x2a,0x10,0x22,0x28,0x42,0x44,0x03,0x83}}, // 屐
{0x5622,0x9BA0,0xD6A2,0xE5B18F,0x5C4F,{0x00,0x00,0x1f,0xfe,0x10,0x02,0x10,0x02,0x1f,0xfe,0x12,0x08,0x11,0x10,0x17,0xfe,0x11,0x10,0x11,0x10,0x1f,0xff,0x11,0x10,0x21,0x10,0x22,0x10,0x42,0x10,0x04,0x10}}, // 屏
{0x5623,0x9BA1,0xD6A3,0xE5ADB1,0x5B71,{0x00,0x00,0x1f,0xfe,0x10,0x02,0x1f,0xfe,0x10,0x00,0x13,0xf0,0x10,0x20,0x1f,0xfe,0x10,0x20,0x10,0x60,0x17,0xbe,0x11,0x04,0x3f,0xff,0x22,0x08,0x42,0x08,0x06,0x18}}, // 孱
{0x5624,0x9BA2,0xD6A4,0xE5B1AC,0x5C6C,{0x00,0x00,0x1f,0xfe,0x10,0x02,0x1f,0xfe,0x17,0x5c,0x10,0x40,0x17,0xfc,0x14,0xa4,0x17,0xfc,0x11,0x00,0x13,0xfe,0x16,0x4a,0x2b,0xfa,0x20,0x52,0x4f,0xea,0x00,0x0c}}, // 屬
{0x5625,0x9BA3,0xD6A5,0xE5B1AE,0x5C6E,{0x01,0x00,0x01,0x00,0x01,0x00,0x21,0x04,0x21,0x04,0x21,0x04,0x21,0x04,0x21,0x04,0x21,0x04,0x3f,0xfc,0x21,0x04,0x21,0x00,0x02,0x00,0x04,0x00,0x18,0x00,0x60,0x00}}, // 屮
{0x5626,0x9BA4,0xD6A6,0xE4B9A2,0x4E62,{0x08,0x40,0x08,0x40,0x08,0x40,0x29,0x40,0x29,0x40,0x29,0x40,0x29,0x40,0x29,0x40,0x29,0x40,0x29,0x40,0x29,0x40,0x29,0x41,0x3f,0x41,0x21,0x41,0x20,0x3f,0x00,0x00}}, // 乢
{0x5627,0x9BA5,0xD6A7,0xE5B1B6,0x5C76,{0x01,0x00,0x21,0x04,0x21,0x04,0x21,0x04,0x3f,0xfc,0x20,0x04,0x00,0x00,0x7f,0xfe,0x00,0x82,0x00,0x82,0x01,0x02,0x01,0x02,0x02,0x02,0x04,0x02,0x18,0x04,0x60,0x18}}, // 屶
{0x5628,0x9BA6,0xD6A8,0xE5B1B9,0x5C79,{0x10,0x40,0x10,0x40,0x10,0x40,0x10,0xff,0x54,0x80,0x55,0x00,0x57,0xfc,0x54,0x08,0x54,0x10,0x54,0x20,0x54,0x40,0x54,0x80,0x7d,0x02,0x01,0x02,0x00,0x82,0x00,0x7e}}, // 屹
{0x5629,0x9BA7,0xD6A9,0xE5B28C,0x5C8C,{0x00,0x80,0x20,0x82,0x20,0x82,0x3f,0xfe,0x00,0x00,0x3f,0xe0,0x02,0x20,0x02,0x20,0x03,0xf8,0x05,0x08,0x05,0x10,0x08,0xa0,0x10,0x40,0x20,0xa0,0x43,0x18,0x1c,0x07}}, // 岌
{0x562A,0x9BA8,0xD6AA,0xE5B291,0x5C91,{0x00,0x80,0x20,0x82,0x20,0x82,0x3f,0xfe,0x00,0x80,0x01,0x40,0x02,0x20,0x07,0xf0,0x18,0x0c,0x60,0x03,0x0f,0xf0,0x00,0x10,0x00,0x20,0x00,0x20,0x00,0x40,0x00,0x80}}, // 岑
{0x562B,0x9BA9,0xD6AB,0xE5B294,0x5C94,{0x03,0xe0,0x00,0x20,0x04,0x10,0x08,0x08,0x1f,0xf4,0x61,0x13,0x01,0x10,0x02,0x10,0x0c,0x10,0x30,0x60,0x00,0x80,0x20,0x82,0x20,0x82,0x20,0x82,0x3f,0xfe,0x20,0x02}}, // 岔
{0x562C,0x9BAA,0xD6AC,0xE5A69B,0x599B,{0x00,0x80,0x10,0x84,0x10,0x84,0x10,0x84,0x1f,0xfc,0x00,0x00,0x7f,0xff,0x00,0x00,0x02,0x00,0x7f,0xff,0x02,0x10,0x04,0x10,0x1f,0x20,0x01,0xc0,0x06,0x30,0x38,0x0c}}, // 妛
{0x562D,0x9BAB,0xD6AD,0xE5B2AB,0x5CAB,{0x10,0x20,0x10,0x20,0x10,0x20,0x54,0x20,0x55,0xfe,0x55,0x22,0x55,0x22,0x55,0x22,0x55,0x22,0x55,0xfe,0x55,0x22,0x55,0x22,0x7d,0x22,0x45,0x22,0x41,0xfe,0x01,0x02}}, // 岫
{0x562E,0x9BAC,0xD6AE,0xE5B2BB,0x5CBB,{0x10,0x04,0x10,0x18,0x55,0xf0,0x55,0x10,0x55,0x10,0x55,0x10,0x55,0xff,0x55,0x10,0x55,0x10,0x55,0x08,0x55,0x08,0x7d,0xe8,0x07,0x05,0x00,0x05,0x07,0xf3,0x00,0x01}}, // 岻
{0x562F,0x9BAD,0xD6AF,0xE5B2B6,0x5CB6,{0x10,0x10,0x10,0x10,0x10,0x20,0x52,0xfe,0x52,0x82,0x52,0x82,0x52,0x82,0x52,0x82,0x52,0xfe,0x52,0x82,0x52,0x82,0x52,0x82,0x7e,0x82,0x42,0x82,0x40,0xfe,0x00,0x82}}, // 岶
{0x5630,0x9BAE,0xD6B0,0xE5B2BC,0x5CBC,{0x10,0x00,0x11,0xfe,0x10,0x20,0x54,0xa8,0x54,0xa8,0x54,0xa4,0x55,0x24,0x54,0x20,0x57,0xff,0x54,0x20,0x54,0x20,0x7c,0x20,0x44,0x20,0x40,0x20,0x00,0x20,0x00,0x20}}, // 岼
{0x5631,0x9BAF,0xD6B1,0xE5B2B7,0x5CB7,{0x10,0x00,0x11,0xfe,0x11,0x02,0x11,0x02,0x55,0x02,0x55,0xfe,0x55,0x12,0x55,0x10,0x55,0xff,0x55,0x10,0x55,0x10,0x55,0x08,0x7d,0x08,0x45,0x65,0x41,0x83,0x06,0x01}}, // 岷
{0x5632,0x9BB0,0xD6B2,0xE5B385,0x5CC5,{0x10,0x20,0x10,0x20,0x10,0x48,0x54,0x8c,0x57,0xf2,0x54,0x89,0x54,0x88,0x54,0x88,0x57,0xff,0x54,0x88,0x54,0x88,0x7c,0x88,0x45,0x08,0x41,0x08,0x02,0x08,0x04,0x08}}, // 峅
{0x5633,0x9BB1,0xD6B3,0xE5B2BE,0x5CBE,{0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x54,0x3f,0x54,0x20,0x54,0x20,0x54,0x20,0x54,0x20,0x55,0xfc,0x55,0x04,0x55,0x04,0x7d,0x04,0x45,0x04,0x41,0xfc,0x01,0x04}}, // 岾
{0x5634,0x9BB2,0xD6B4,0xE5B387,0x5CC7,{0x00,0x80,0x20,0x82,0x20,0x82,0x3f,0xfe,0x00,0x80,0x00,0x80,0x01,0x40,0x06,0x30,0x1b,0xec,0x60,0x03,0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 峇
{0x5635,0x9BB3,0xD6B5,0xE5B399,0x5CD9,{0x10,0x20,0x10,0x20,0x11,0xfe,0x10,0x20,0x54,0x20,0x54,0x20,0x57,0xff,0x54,0x04,0x54,0x04,0x57,0xff,0x55,0x04,0x54,0x84,0x7c,0x44,0x44,0x44,0x40,0x0c,0x00,0x04}}, // 峙
{0x5636,0x9BB4,0xD6B6,0xE5B3A9,0x5CE9,{0x00,0x80,0x20,0x82,0x20,0x82,0x3f,0xfe,0x02,0x00,0x0c,0x28,0x38,0x24,0x08,0x24,0x7f,0xff,0x08,0x20,0x09,0x24,0x0e,0x18,0x78,0x12,0x08,0x2a,0x08,0xc6,0x1b,0x02}}, // 峩
{0x5637,0x9BB5,0xD6B7,0xE5B3BD,0x5CFD,{0x00,0x20,0x10,0x20,0x13,0xff,0x54,0x20,0x55,0x24,0x55,0x24,0x55,0x24,0x55,0xa6,0x56,0x69,0x56,0x30,0x54,0x50,0x7c,0x50,0x00,0x88,0x01,0x04,0x02,0x02,0x0c,0x01}}, // 峽
{0x5638,0x9BB6,0xD6B8,0xE5B3BA,0x5CFA,{0x10,0x00,0x13,0xff,0x10,0x20,0x55,0xfc,0x55,0x24,0x55,0x24,0x55,0xfc,0x55,0x24,0x55,0x24,0x55,0xfc,0x54,0x20,0x7c,0xa0,0x00,0x60,0x00,0x90,0x03,0x0c,0x0c,0x03}}, // 峺
{0x5639,0x9BB7,0xD6B9,0xE5B3AD,0x5CED,{0x10,0x28,0x11,0x24,0x11,0x22,0x12,0x22,0x54,0x20,0x55,0xfc,0x55,0x04,0x55,0x04,0x55,0xfc,0x55,0x04,0x55,0x04,0x55,0xfc,0x7d,0x04,0x01,0x04,0x01,0x04,0x01,0x0c}}, // 峭
{0x563A,0x9BB8,0xD6BA,0xE5B68C,0x5D8C,{0x20,0x82,0x20,0x82,0x3f,0xfe,0x01,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x00,0x0f,0xff,0x08,0x00,0x0f,0xfe,0x24,0x92,0x22,0x4a,0x40,0x0c}}, // 嶌
{0x563B,0x9BB9,0xD6BB,0xE5B3AA,0x5CEA,{0x10,0x88,0x10,0x88,0x10,0x84,0x55,0x24,0x55,0x24,0x56,0x50,0x54,0x48,0x54,0x84,0x55,0x02,0x56,0x01,0x55,0xfc,0x7d,0x04,0x45,0x04,0x41,0x04,0x01,0xfc,0x01,0x04}}, // 峪
{0x563C,0x9BBA,0xD6BC,0xE5B48B,0x5D0B,{0x00,0x80,0x20,0x82,0x20,0x82,0x3f,0xfe,0x00,0x00,0x3f,0xfe,0x08,0x88,0x08,0x88,0x7f,0xff,0x08,0x88,0x08,0x88,0x3f,0xfe,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80}}, // 崋
{0x563D,0x9BBB,0xD6BD,0xE5B495,0x5D15,{0x10,0x00,0x11,0xff,0x11,0x10,0x55,0x10,0x55,0x7e,0x55,0x10,0x55,0x10,0x55,0xff,0x55,0x10,0x55,0x10,0x7d,0xfe,0x02,0x10,0x02,0x10,0x04,0x10,0x09,0xff,0x00,0x00}}, // 崕
{0x563E,0x9BBC,0xD6BE,0xE5B497,0x5D17,{0x00,0x80,0x20,0x82,0x20,0x82,0x3f,0xfe,0x00,0x00,0x3f,0xfe,0x24,0x12,0x22,0x22,0x3f,0xfe,0x20,0x82,0x24,0x92,0x24,0x92,0x24,0x92,0x27,0xf2,0x24,0x12,0x20,0x06}}, // 崗
{0x563F,0x9BBD,0xD6BF,0xE5B59C,0x5D5C,{0x00,0x80,0x10,0x82,0x10,0x82,0x1f,0xfe,0x00,0x80,0x3f,0xfe,0x04,0x10,0x02,0x20,0x7f,0xff,0x00,0x04,0x0f,0xc4,0x08,0x44,0x08,0x44,0x0f,0xc4,0x08,0x44,0x00,0x0c}}, // 嵜
{0x5640,0x9BBE,0xD6C0,0xE5B49F,0x5D1F,{0x00,0x80,0x20,0x82,0x20,0x82,0x3f,0xfe,0x00,0x80,0x01,0x40,0x06,0x30,0x1f,0xfc,0x60,0x83,0x00,0x80,0x7f,0xff,0x00,0x80,0x08,0x88,0x04,0x90,0x3f,0xfe,0x00,0x00}}, // 崟
{0x5641,0x9BBF,0xD6C1,0xE5B49B,0x5D1B,{0x10,0x00,0x11,0xfe,0x11,0x02,0x55,0x02,0x55,0xfe,0x55,0x10,0x55,0x92,0x55,0x92,0x55,0x92,0x55,0xfe,0x55,0x10,0x7d,0x90,0x02,0x92,0x02,0x92,0x04,0xfe,0x08,0x00}}, // 崛
{0x5642,0x9BC0,0xD6C2,0xE5B491,0x5D11,{0x00,0x80,0x20,0x82,0x20,0x82,0x3f,0xfe,0x00,0x00,0x1f,0xf8,0x10,0x08,0x1f,0xf8,0x10,0x08,0x1f,0xf8,0x10,0x40,0x10,0x44,0x1f,0x58,0x10,0x62,0x1f,0x42,0x70,0x3e}}, // 崑
{0x5643,0x9BC1,0xD6C3,0xE5B494,0x5D14,{0x00,0x80,0x20,0x82,0x20,0x82,0x3f,0xfe,0x08,0x20,0x08,0x40,0x1f,0xfe,0x30,0x80,0x50,0x80,0x1f,0xfc,0x10,0x80,0x1f,0xfc,0x10,0x80,0x10,0x80,0x1f,0xff,0x00,0x00}}, // 崔
{0x5644,0x9BC2,0xD6C4,0xE5B4A2,0x5D22,{0x10,0x04,0x10,0x18,0x13,0xe4,0x10,0x92,0x55,0x12,0x57,0xfc,0x54,0x24,0x54,0x24,0x57,0xff,0x54,0x24,0x54,0x24,0x55,0xfc,0x7c,0x20,0x00,0x20,0x00,0x20,0x00,0x60}}, // 崢
{0x5645,0x9BC3,0xD6C5,0xE5B49A,0x5D1A,{0x10,0x20,0x10,0x20,0x13,0xfe,0x10,0x20,0x57,0xff,0x54,0x88,0x54,0x89,0x55,0x27,0x56,0x20,0x54,0x7c,0x54,0x84,0x57,0x48,0x7c,0x30,0x00,0x70,0x01,0x8c,0x0e,0x03}}, // 崚
{0x5646,0x9BC4,0xD6C6,0xE5B499,0x5D19,{0x00,0x80,0x20,0x82,0x20,0x82,0x3f,0xfe,0x00,0x80,0x01,0x40,0x06,0x30,0x1b,0xec,0x60,0x03,0x1f,0xfc,0x12,0x24,0x12,0x24,0x1f,0xfc,0x12,0x24,0x12,0x24,0x12,0x2c}}, // 崙
{0x5647,0x9BC5,0xD6C7,0xE5B498,0x5D18,{0x10,0x20,0x10,0x20,0x10,0x50,0x10,0x48,0x54,0x84,0x55,0xfa,0x56,0x01,0x54,0x00,0x55,0xfe,0x55,0x52,0x55,0x52,0x55,0xfe,0x7d,0x52,0x01,0x52,0x01,0x52,0x01,0x06}}, // 崘
{0x5648,0x9BC6,0xD6C8,0xE5B58C,0x5D4C,{0x00,0x80,0x20,0x82,0x20,0x82,0x3f,0xfe,0x00,0x40,0x22,0x40,0x22,0x7f,0x7f,0x42,0x22,0x94,0x23,0x10,0x3e,0x10,0x22,0x28,0x22,0x28,0x22,0x44,0x3e,0x82,0x23,0x01}}, // 嵌
{0x5649,0x9BC7,0xD6C9,0xE5B592,0x5D52,{0x00,0x00,0x0f,0xf0,0x08,0x10,0x08,0x10,0x0f,0xf0,0x00,0x00,0x7e,0x7e,0x42,0x42,0x42,0x42,0x7e,0x7e,0x43,0x42,0x21,0x04,0x21,0x04,0x21,0x04,0x3f,0xfc,0x20,0x04}}, // 嵒
{0x564A,0x9BC8,0xD6CA,0xE5B58E,0x5D4E,{0x10,0x00,0x11,0xfc,0x11,0x24,0x55,0x24,0x55,0xfc,0x55,0x24,0x55,0x24,0x55,0xfc,0x54,0x20,0x57,0xfe,0x56,0x22,0x7e,0x2a,0x02,0x7a,0x03,0x86,0x02,0x02,0x02,0x06}}, // 嵎
{0x564B,0x9BC9,0xD6CB,0xE5B58B,0x5D4B,{0x10,0x00,0x11,0xfe,0x11,0x12,0x55,0x12,0x55,0xfe,0x55,0x00,0x55,0x7e,0x55,0x42,0x55,0x42,0x55,0x7e,0x55,0x42,0x7d,0x7e,0x42,0x42,0x42,0x42,0x04,0x7e,0x08,0x42}}, // 嵋
{0x564C,0x9BCA,0xD6CC,0xE5B5AC,0x5D6C,{0x00,0x80,0x20,0x82,0x20,0x82,0x3f,0xfe,0x01,0x00,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x08,0x88,0x08,0x88,0x0f,0xfc,0x01,0x44,0x01,0x4a,0x02,0x5f,0x0c,0x21,0x70,0x1f}}, // 嵬
{0x564D,0x9BCB,0xD6CD,0xE5B5B3,0x5D73,{0x20,0x82,0x20,0x82,0x3f,0xfe,0x04,0x10,0x02,0x20,0x3f,0xfc,0x00,0x80,0x1f,0xf8,0x00,0x80,0x7f,0xff,0x02,0x00,0x07,0xfc,0x08,0x40,0x10,0x40,0x6f,0xff,0x00,0x00}}, // 嵳
{0x564E,0x9BCC,0xD6CE,0xE5B5B6,0x5D76,{0x10,0x00,0x13,0xfe,0x10,0x42,0x54,0x42,0x54,0x42,0x55,0xde,0x55,0x10,0x55,0x10,0x55,0xde,0x55,0x4a,0x56,0x52,0x54,0xc6,0x7d,0x4a,0x02,0x52,0x00,0x42,0x01,0x8c}}, // 嵶
{0x564F,0x9BCD,0xD6CF,0xE5B687,0x5D87,{0x10,0x00,0x11,0xff,0x11,0x00,0x55,0x3c,0x55,0x24,0x55,0x24,0x55,0x3c,0x55,0x00,0x55,0xee,0x55,0xaa,0x55,0xaa,0x55,0xaa,0x7d,0xee,0x01,0x00,0x01,0xff,0x00,0x00}}, // 嶇
{0x5650,0x9BCE,0xD6D0,0xE5B684,0x5D84,{0x00,0x80,0x20,0x82,0x20,0x82,0x3f,0xfe,0x04,0x02,0x7f,0xc4,0x04,0x38,0x3f,0xa0,0x24,0xbf,0x3f,0xa4,0x24,0xa4,0x3f,0xa4,0x04,0x24,0x7f,0xc4,0x04,0x44,0x04,0x84}}, // 嶄
{0x5651,0x9BCF,0xD6D1,0xE5B682,0x5D82,{0x10,0x20,0x10,0x20,0x11,0xfe,0x54,0x84,0x54,0x48,0x57,0xff,0x54,0x00,0x54,0xfc,0x54,0x84,0x54,0xfc,0x54,0x84,0x7c,0xfc,0x00,0x20,0x07,0xff,0x00,0x20,0x00,0x20}}, // 嶂
{0x5652,0x9BD0,0xD6D2,0xE5B6A2,0x5DA2,{0x10,0x20,0x10,0xfc,0x10,0x20,0x57,0xfe,0x54,0x00,0x54,0x84,0x55,0xff,0x54,0x84,0x54,0xe4,0x57,0x9f,0x54,0x00,0x7d,0xff,0x00,0x48,0x00,0x49,0x01,0x89,0x06,0x07}}, // 嶢
{0x5653,0x9BD1,0xD6D3,0xE5B69D,0x5D9D,{0x11,0xd2,0x10,0x54,0x11,0x49,0x54,0x8a,0x54,0xfc,0x55,0x02,0x56,0x01,0x54,0xfc,0x54,0x84,0x54,0x84,0x54,0xfc,0x7c,0x84,0x00,0x44,0x00,0x48,0x07,0xff,0x00,0x00}}, // 嶝
{0x5654,0x9BD2,0xD6D4,0xE5B6AC,0x5DAC,{0x10,0x84,0x10,0x48,0x11,0xfe,0x54,0x20,0x54,0xfc,0x54,0x20,0x57,0xff,0x54,0x54,0x55,0x92,0x54,0x90,0x57,0xff,0x7c,0x8a,0x00,0xe4,0x07,0x85,0x00,0x8b,0x01,0x91}}, // 嶬
{0x5655,0x9BD3,0xD6D5,0xE5B6AE,0x5DAE,{0x10,0x20,0x10,0x20,0x10,0x50,0x54,0x88,0x55,0x04,0x56,0xfa,0x54,0x01,0x57,0xde,0x56,0x52,0x56,0x52,0x57,0xde,0x55,0x08,0x7d,0x08,0x01,0x8c,0x02,0x52,0x04,0x22}}, // 嶮
{0x5656,0x9BD4,0xD6D6,0xE5B6BD,0x5DBD,{0x20,0x82,0x20,0x82,0x3f,0xfe,0x00,0x00,0x4b,0xca,0x28,0x09,0x17,0xe8,0x30,0x3f,0x4b,0xc8,0x08,0x08,0x1b,0xcc,0x28,0x0c,0x4b,0xd4,0x0a,0x52,0x6b,0xe2,0x10,0x41}}, // 嶽
{0x5657,0x9BD5,0xD6D7,0xE5B690,0x5D90,{0x21,0x02,0x21,0x02,0x3f,0xfe,0x00,0x80,0x3c,0xf8,0x25,0x88,0x2b,0x50,0x30,0x70,0x29,0x8c,0x26,0x7b,0x24,0xa0,0x25,0xfe,0x3a,0x20,0x20,0xfc,0x20,0x20,0x27,0xff}}, // 嶐
{0x5658,0x9BD6,0xD6D8,0xE5B6B7,0x5DB7,{0x20,0x82,0x20,0x82,0x3f,0xfe,0x00,0x00,0x26,0x7e,0x38,0x04,0x21,0x38,0x1f,0x08,0x10,0xff,0x1f,0x12,0x24,0x50,0x7f,0xde,0x04,0x50,0x0a,0x70,0x12,0x98,0x61,0x07}}, // 嶷
{0x5659,0x9BD7,0xD6D9,0xE5B6BC,0x5DBC,{0x10,0x60,0x11,0xa6,0x11,0x3a,0x55,0x22,0x55,0xa6,0x55,0x3a,0x55,0x0a,0x55,0xae,0x55,0x2a,0x55,0x2a,0x55,0x2a,0x57,0xff,0x7c,0x00,0x00,0x88,0x03,0x06,0x0c,0x01}}, // 嶼
{0x565A,0x9BD8,0xD6DA,0xE5B789,0x5DC9,{0x10,0x78,0x10,0x90,0x13,0xfe,0x55,0x02,0x55,0xfe,0x54,0x99,0x54,0xee,0x54,0x89,0x55,0xf7,0x54,0x38,0x55,0xfe,0x7d,0x12,0x01,0xfe,0x00,0x34,0x00,0xd1,0x07,0x0f}}, // 巉
{0x565B,0x9BD9,0xD6DB,0xE5B78D,0x5DCD,{0x20,0x82,0x20,0x82,0x3f,0xfe,0x02,0x10,0x3c,0x20,0x08,0xfe,0x7f,0x92,0x1c,0xfe,0x2a,0x92,0x49,0xfe,0x7f,0x34,0x14,0x34,0x34,0x5a,0x08,0x5f,0x14,0x91,0x63,0x0f}}, // 巍
{0x565C,0x9BDA,0xD6DC,0xE5B793,0x5DD3,{0x20,0x82,0x20,0x82,0x3f,0xfe,0x26,0x00,0x38,0xff,0x21,0x10,0x5f,0x7e,0x52,0x42,0x5e,0x7e,0x52,0x42,0x5e,0x7e,0x52,0x42,0x5e,0x7e,0x7f,0x14,0x22,0x62,0x41,0x81}}, // 巓
{0x565D,0x9BDB,0xD6DD,0xE5B792,0x5DD2,{0x11,0xc4,0x10,0x04,0x6f,0xfa,0x28,0x0a,0x11,0xc4,0x28,0x0a,0x7d,0xdf,0x10,0x04,0x59,0xd6,0x55,0x55,0x11,0xe4,0x00,0x80,0x20,0x82,0x20,0x82,0x3f,0xfe,0x00,0x00}}, // 巒
{0x565E,0x9BDC,0xD6DE,0xE5B796,0x5DD6,{0x08,0x42,0x0f,0xfe,0x00,0x00,0x07,0xbc,0x04,0xa4,0x1f,0xff,0x10,0x10,0x17,0xd0,0x11,0x1f,0x1f,0xe4,0x14,0xa4,0x17,0xd4,0x14,0x88,0x27,0x94,0x2c,0xa2,0x40,0xc1}}, // 巖
{0x565F,0x9BDD,0xD6DF,0xE5B79B,0x5DDB,{0x04,0x21,0x04,0x21,0x08,0x42,0x08,0x42,0x10,0x84,0x10,0x84,0x21,0x08,0x42,0x10,0x42,0x10,0x21,0x08,0x10,0x84,0x10,0x84,0x08,0x42,0x08,0x42,0x04,0x21,0x04,0x21}}, // 巛
{0x5660,0x9BDE,0xD6E0,0xE5B7AB,0x5DEB,{0x00,0x00,0x3f,0xfe,0x00,0x80,0x08,0x88,0x08,0x88,0x08,0x88,0x08,0x88,0x0c,0x8c,0x14,0x94,0x12,0x92,0x22,0xa2,0x40,0xc0,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x00}}, // 巫
{0x5661,0x9BDF,0xD6E1,0xE5B7B2,0x5DF2,{0x00,0x00,0x7f,0xfc,0x00,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x3f,0xfc,0x20,0x04,0x20,0x00,0x20,0x00,0x20,0x00,0x20,0x02,0x20,0x02,0x10,0x02,0x0f,0xfe,0x00,0x00}}, // 已
{0x5662,0x9BE0,0xD6E2,0xE5B7B5,0x5DF5,{0x00,0x08,0x00,0x30,0x1f,0xc0,0x10,0x00,0x1f,0xff,0x10,0x00,0x17,0xfc,0x14,0x44,0x14,0x44,0x14,0x44,0x17,0xfc,0x14,0x00,0x24,0x02,0x24,0x02,0x42,0x02,0x01,0xfe}}, // 巵
{0x5663,0x9BE1,0xD6E3,0xE5B88B,0x5E0B,{0x00,0x04,0x00,0x38,0x1f,0xc0,0x10,0x40,0x1f,0xff,0x10,0x40,0x10,0x22,0x1e,0x1a,0x70,0x86,0x00,0x80,0x1f,0xfc,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x98,0x00,0x80}}, // 帋
{0x5664,0x9BE2,0xD6E4,0xE5B89A,0x5E1A,{0x00,0x00,0x1f,0xf8,0x00,0x08,0x7f,0xff,0x00,0x08,0x1f,0xf8,0x00,0x00,0x3f,0xfe,0x21,0x04,0x41,0x00,0x1f,0xf8,0x11,0x08,0x11,0x08,0x11,0x08,0x11,0x30,0x01,0x00}}, // 帚
{0x5665,0x9BE3,0xD6E5,0xE5B899,0x5E19,{0x10,0x10,0x10,0x50,0x10,0x50,0x7e,0x7e,0x52,0x90,0x52,0x90,0x53,0x10,0x53,0xff,0x52,0x10,0x52,0x10,0x56,0x28,0x50,0x28,0x10,0x44,0x10,0x84,0x11,0x02,0x12,0x01}}, // 帙
{0x5666,0x9BE4,0xD6E6,0xE5B891,0x5E11,{0x04,0x00,0x04,0x00,0x7f,0xfe,0x09,0x22,0x09,0x22,0x11,0x14,0x3e,0x08,0x04,0x94,0x18,0xe3,0x60,0x80,0x1f,0xfc,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x98,0x00,0x80}}, // 帑
{0x5667,0x9BE5,0xD6E7,0xE5B89B,0x5E1B,{0x01,0x00,0x02,0x00,0x1f,0xf8,0x10,0x08,0x1f,0xf8,0x10,0x08,0x10,0x08,0x1f,0xf8,0x01,0x00,0x3f,0xfc,0x21,0x04,0x21,0x04,0x21,0x04,0x21,0x18,0x21,0x00,0x01,0x00}}, // 帛
{0x5668,0x9BE6,0xD6E8,0xE5B8B6,0x5E36,{0x0a,0xa0,0x0a,0xa0,0x7f,0xff,0x0a,0xa0,0x0a,0xa4,0x13,0x9c,0x20,0x00,0x7f,0xfe,0x41,0x02,0x41,0x02,0x1f,0xf8,0x11,0x08,0x11,0x08,0x11,0x30,0x11,0x00,0x01,0x00}}, // 帶
{0x5669,0x9BE7,0xD6E9,0xE5B8B7,0x5E37,{0x10,0x24,0x10,0x24,0x10,0x48,0x7e,0x7f,0x52,0xc8,0x52,0xc8,0x53,0x48,0x52,0x7e,0x52,0x48,0x52,0x48,0x56,0x7e,0x50,0x48,0x10,0x48,0x10,0x48,0x10,0x7f,0x10,0x00}}, // 帷
{0x566A,0x9BE8,0xD6EA,0xE5B984,0x5E44,{0x10,0x00,0x11,0xfe,0x11,0x02,0x7d,0x02,0x55,0xfe,0x55,0x00,0x55,0xff,0x55,0x28,0x55,0x44,0x55,0xfa,0x5d,0x10,0x52,0xfe,0x12,0x10,0x14,0x10,0x19,0xff,0x10,0x00}}, // 幄
{0x566B,0x9BE9,0xD6EB,0xE5B983,0x5E43,{0x10,0x20,0x11,0xfc,0x10,0x44,0x7c,0x44,0x57,0xff,0x54,0x00,0x54,0xfc,0x54,0x84,0x54,0xfc,0x54,0x08,0x5d,0xfe,0x10,0x88,0x10,0x88,0x13,0xff,0x10,0x08,0x10,0x08}}, // 幃
{0x566C,0x9BEA,0xD6EC,0xE5B980,0x5E40,{0x10,0x20,0x10,0x20,0x10,0x3f,0x7e,0x20,0x52,0xfc,0x52,0x84,0x52,0x84,0x52,0xfc,0x52,0x84,0x52,0xfc,0x56,0x84,0x50,0x84,0x10,0xfc,0x10,0x48,0x10,0x84,0x13,0x02}}, // 幀
{0x566D,0x9BEB,0xD6ED,0xE5B98E,0x5E4E,{0x10,0x00,0x11,0xff,0x11,0x01,0x7d,0x7d,0x54,0x44,0x54,0x44,0x54,0x7c,0x54,0x44,0x54,0x44,0x54,0x7c,0x5c,0x10,0x53,0xff,0x10,0x00,0x10,0x44,0x10,0x82,0x13,0x02}}, // 幎
{0x566E,0x9BEC,0xD6EE,0xE5B997,0x5E57,{0x10,0x00,0x11,0xfe,0x11,0x1a,0x7d,0x16,0x55,0xfe,0x55,0x12,0x55,0x76,0x55,0x56,0x55,0x76,0x55,0x1a,0x5d,0xea,0x11,0x1e,0x11,0x26,0x11,0x42,0x11,0xfe,0x10,0x00}}, // 幗
{0x566F,0x9BED,0xD6EF,0xE5B994,0x5E54,{0x10,0x00,0x10,0xfe,0x10,0x82,0x7c,0xfe,0x54,0x82,0x54,0xfe,0x54,0x00,0x55,0xff,0x55,0x29,0x55,0xff,0x5c,0x00,0x51,0xfe,0x10,0x64,0x10,0x18,0x10,0x6c,0x13,0x83}}, // 幔
{0x5670,0x9BEE,0xD6F0,0xE5B99F,0x5E5F,{0x10,0x88,0x10,0x8c,0x13,0xfa,0x7d,0x2a,0x54,0xa8,0x54,0xc8,0x57,0xff,0x54,0x08,0x55,0xea,0x55,0x2a,0x5d,0xea,0x51,0x24,0x11,0x25,0x11,0xeb,0x10,0x13,0x10,0x21}}, // 幟
{0x5671,0x9BEF,0xD6F1,0xE5B9A2,0x5E62,{0x10,0x20,0x13,0xfe,0x10,0x88,0x7c,0x50,0x57,0xff,0x54,0x00,0x55,0xfc,0x55,0x24,0x55,0xfc,0x55,0x24,0x5d,0xfc,0x10,0x20,0x11,0xfe,0x10,0x20,0x17,0xff,0x10,0x00}}, // 幢
{0x5672,0x9BF0,0xD6F2,0xE5B9A4,0x5E64,{0x08,0x20,0x2a,0x20,0x49,0x3f,0x7f,0x44,0x41,0x64,0x5d,0x94,0x55,0x08,0x5d,0x14,0x43,0x62,0x00,0x81,0x1f,0xfc,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x98,0x00,0x80}}, // 幤
{0x5673,0x9BF1,0xD6F3,0xE5B987,0x5E47,{0x04,0x04,0x3f,0x04,0x04,0x7f,0x7f,0x84,0x04,0x24,0x3f,0x14,0x04,0x14,0x07,0x84,0x79,0x0c,0x01,0x00,0x1f,0xfc,0x11,0x04,0x11,0x04,0x11,0x18,0x11,0x00,0x01,0x00}}, // 幇
{0x5674,0x9BF2,0xD6F4,0xE5B9B5,0x5E75,{0x00,0x00,0x3e,0x3e,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x7f,0x7f,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08}}, // 幵
{0x5675,0x9BF3,0xD6F5,0xE5B9B6,0x5E76,{0x08,0x10,0x04,0x10,0x04,0x20,0x3f,0xfc,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x7f,0xff,0x04,0x20,0x04,0x20,0x04,0x20,0x08,0x20,0x08,0x20,0x10,0x20,0x20,0x20}}, // 并
{0x5676,0x9BF4,0xD6F6,0xE5B9BA,0x5E7A,{0x00,0x80,0x00,0x80,0x00,0x80,0x01,0x00,0x01,0x10,0x02,0x10,0x1c,0x20,0x02,0x20,0x01,0x40,0x01,0x80,0x00,0x90,0x01,0x08,0x02,0x04,0x04,0x7c,0x7f,0x82,0x00,0x02}}, // 幺
{0x5677,0x9BF5,0xD6F7,0xE9BABC,0x9EBC,{0x00,0x80,0x00,0x80,0x1f,0xff,0x11,0x08,0x1f,0xff,0x11,0x08,0x15,0x5a,0x15,0x5a,0x19,0x5b,0x10,0x88,0x10,0x90,0x17,0x20,0x21,0x48,0x20,0x84,0x5f,0xfa,0x00,0x02}}, // 麼
{0x5678,0x9BF6,0xD6F8,0xE5B9BF,0x5E7F,{0x00,0x80,0x00,0x80,0x1f,0xfe,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x20,0x00,0x20,0x00,0x40,0x00,0x00,0x00}}, // 广
{0x5679,0x9BF7,0xD6F9,0xE5BAA0,0x5EA0,{0x00,0x40,0x00,0x40,0x1f,0xff,0x10,0x00,0x12,0x08,0x11,0x10,0x17,0xfe,0x10,0x40,0x10,0x40,0x13,0xfc,0x10,0x40,0x10,0x40,0x2f,0xff,0x20,0x40,0x40,0x40,0x00,0x40}}, // 庠
{0x567A,0x9BF8,0xD6FA,0xE5BB81,0x5EC1,{0x00,0x40,0x00,0x40,0x1f,0xff,0x10,0x00,0x17,0xc2,0x14,0x52,0x14,0x52,0x17,0xd2,0x14,0x52,0x17,0xd2,0x14,0x52,0x14,0x52,0x27,0xd2,0x22,0x82,0x44,0x42,0x08,0x06}}, // 廁
{0x567B,0x9BF9,0xD6FB,0xE5BB82,0x5EC2,{0x00,0x40,0x00,0x40,0x1f,0xff,0x12,0x00,0x12,0x00,0x12,0x3e,0x1f,0xe2,0x12,0x22,0x13,0x3e,0x16,0xa2,0x16,0xa2,0x1a,0x3e,0x2a,0x22,0x22,0x22,0x42,0x3e,0x02,0x22}}, // 廂
{0x567C,0x9BFA,0xD6FC,0xE5BB88,0x5EC8,{0x00,0x40,0x00,0x40,0x1f,0xff,0x10,0x00,0x1f,0xff,0x10,0x40,0x13,0xf8,0x12,0x08,0x13,0xf8,0x12,0x08,0x13,0xf8,0x10,0x80,0x21,0xf0,0x27,0x10,0x40,0xe0,0x1f,0x1f}}, // 廈
{0x567D,0x9BFB,0xD6FD,0xE5BB90,0x5ED0,{0x00,0x40,0x00,0x40,0x1f,0xff,0x12,0x00,0x17,0xfe,0x14,0xa4,0x17,0xa4,0x14,0xa4,0x14,0xbf,0x17,0x88,0x10,0x08,0x14,0x8c,0x27,0x14,0x24,0x15,0x44,0xa5,0x03,0xc3}}, // 廐
{0x567E,0x9BFC,0xD6FE,0xE5BB8F,0x5ECF,{0x00,0x40,0x00,0x40,0x1f,0xff,0x12,0x00,0x17,0xbc,0x14,0xa4,0x17,0xa5,0x14,0xa3,0x14,0xc0,0x17,0xbc,0x10,0x04,0x14,0xa4,0x27,0x18,0x24,0x18,0x44,0xa4,0x03,0xc3}}, // 廏
{0x5721,0x9C40,0xD7A1,0xE5BB96,0x5ED6,{0x00,0x40,0x00,0x40,0x1f,0xff,0x10,0x00,0x1f,0xbe,0x12,0x8a,0x15,0x96,0x12,0xca,0x14,0xa2,0x13,0x58,0x1c,0x97,0x13,0x20,0x20,0xc4,0x23,0x18,0x40,0x60,0x07,0x80}}, // 廖
{0x5722,0x9C41,0xD7A2,0xE5BBA3,0x5EE3,{0x00,0x80,0x00,0x80,0x1f,0xff,0x11,0x10,0x1f,0xfe,0x11,0x10,0x11,0xf0,0x1f,0xff,0x10,0x40,0x17,0xfc,0x14,0x44,0x17,0xfc,0x24,0x44,0x27,0xfc,0x43,0x0c,0x1c,0x02}}, // 廣
{0x5723,0x9C42,0xD7A3,0xE5BB9D,0x5EDD,{0x00,0x40,0x00,0x40,0x1f,0xff,0x10,0x00,0x14,0x86,0x1f,0xf8,0x14,0xa0,0x17,0xbf,0x14,0xa4,0x17,0xa4,0x14,0xa4,0x14,0xa4,0x2f,0xe4,0x25,0x24,0x48,0xc4,0x10,0x84}}, // 廝
{0x5724,0x9C43,0xD7A4,0xE5BB9A,0x5EDA,{0x00,0x40,0x00,0x40,0x1f,0xff,0x11,0x00,0x1f,0xe4,0x11,0x04,0x17,0xff,0x10,0x04,0x17,0xc4,0x14,0xa4,0x17,0xa4,0x10,0x84,0x24,0x84,0x23,0x04,0x43,0xc4,0x1c,0x0c}}, // 廚
{0x5725,0x9C44,0xD7A5,0xE5BB9B,0x5EDB,{0x00,0x40,0x00,0x40,0x1f,0xff,0x10,0x00,0x13,0xfc,0x12,0x44,0x13,0xfc,0x12,0x44,0x13,0xfc,0x10,0x40,0x1f,0xff,0x11,0x12,0x26,0x4e,0x3b,0xf8,0x40,0x40,0x1f,0xff}}, // 廛
{0x5726,0x9C45,0xD7A6,0xE5BBA2,0x5EE2,{0x00,0x40,0x00,0x40,0x1f,0xff,0x10,0x14,0x13,0xd8,0x14,0x8a,0x13,0x04,0x17,0xba,0x18,0xa9,0x17,0xaa,0x14,0x46,0x17,0xbc,0x20,0xa4,0x20,0x98,0x41,0x2c,0x06,0xc3}}, // 廢
{0x5727,0x9C46,0xD7A7,0xE5BBA1,0x5EE1,{0x00,0x40,0x00,0x40,0x1f,0xff,0x11,0x00,0x12,0x00,0x17,0xff,0x1a,0x94,0x12,0x94,0x1f,0xff,0x12,0x94,0x12,0x94,0x17,0xff,0x20,0x00,0x25,0x24,0x48,0x92,0x10,0x91}}, // 廡
{0x5728,0x9C47,0xD7A8,0xE5BBA8,0x5EE8,{0x00,0x40,0x00,0x40,0x1f,0xff,0x12,0x00,0x13,0xfe,0x14,0x92,0x19,0x12,0x17,0xe6,0x15,0x58,0x17,0xe8,0x15,0x7e,0x17,0xc8,0x24,0x48,0x28,0x7f,0x48,0x48,0x10,0xc8}}, // 廨
{0x5729,0x9C48,0xD7A9,0xE5BBA9,0x5EE9,{0x00,0x80,0x1f,0xff,0x10,0x40,0x1f,0xfe,0x15,0xf4,0x15,0x14,0x15,0xf4,0x14,0x04,0x17,0xfc,0x10,0x0c,0x17,0xf0,0x10,0x40,0x3f,0xff,0x21,0x50,0x46,0x4c,0x18,0x43}}, // 廩
{0x572A,0x9C49,0xD7AA,0xE5BBAC,0x5EEC,{0x00,0x40,0x1f,0xff,0x10,0x7c,0x10,0x40,0x17,0xff,0x14,0x9a,0x17,0xe0,0x14,0x82,0x15,0xfe,0x15,0x24,0x15,0xfc,0x15,0x24,0x2b,0xfe,0x32,0x52,0x4f,0xff,0x00,0x00}}, // 廬
{0x572B,0x9C4A,0xD7AB,0xE5BBB1,0x5EF1,{0x00,0x40,0x1f,0xff,0x15,0x48,0x1a,0x8a,0x15,0x54,0x10,0x1f,0x17,0xb4,0x14,0x94,0x17,0x9f,0x10,0x14,0x1f,0xd4,0x1a,0x5f,0x2f,0xd4,0x28,0x14,0x48,0x5f,0x07,0xd0}}, // 廱
{0x572C,0x9C4B,0xD7AC,0xE5BBB3,0x5EF3,{0x00,0x40,0x3f,0xff,0x20,0x08,0x3f,0x88,0x24,0xff,0x27,0x88,0x24,0xbe,0x27,0xaa,0x24,0xbe,0x27,0x80,0x38,0xff,0x2e,0x98,0x24,0xb5,0x2e,0xb1,0x44,0xd2,0x0e,0x8e}}, // 廳
{0x572D,0x9C4C,0xD7AD,0xE5BBB0,0x5EF0,{0x00,0x40,0x00,0x40,0x1f,0xff,0x10,0x10,0x1f,0xd0,0x15,0x7f,0x15,0x10,0x17,0x7e,0x15,0x6a,0x15,0x6a,0x17,0x7e,0x15,0x30,0x25,0x6a,0x27,0x61,0x5d,0xa5,0x01,0x1c}}, // 廰
{0x572E,0x9C4D,0xD7AE,0xE5BBB4,0x5EF4,{0x00,0x00,0x7c,0x00,0x04,0x00,0x08,0x00,0x08,0x00,0x10,0x00,0x3c,0x00,0x04,0x00,0x04,0x00,0x44,0x00,0x28,0x00,0x18,0x00,0x08,0x00,0x16,0x00,0x21,0x80,0x40,0x7f}}, // 廴
{0x572F,0x9C4E,0xD7AF,0xE5BBB8,0x5EF8,{0x00,0x20,0x7c,0x20,0x04,0x20,0x09,0xfe,0x09,0x22,0x11,0x22,0x3d,0x22,0x05,0xfe,0x05,0x22,0x45,0x22,0x29,0x22,0x19,0xfe,0x09,0x02,0x16,0x00,0x21,0x80,0x40,0x7f}}, // 廸
{0x5730,0x9C4F,0xD7B0,0xE5BBBE,0x5EFE,{0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x7f,0xff,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x08,0x10,0x08,0x10,0x10,0x10,0x20,0x10,0x40,0x10}}, // 廾
{0x5731,0x9C50,0xD7B1,0xE5BC83,0x5F03,{0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0x20,0x01,0x18,0x02,0x6c,0x1f,0x92,0x02,0x10,0x02,0x10,0x7f,0xff,0x02,0x10,0x02,0x10,0x04,0x10,0x04,0x10,0x08,0x10,0x10,0x10}}, // 弃
{0x5732,0x9C51,0xD7B2,0xE5BC89,0x5F09,{0x24,0x20,0x24,0x20,0x24,0x20,0x3f,0xff,0x04,0x20,0x7c,0x20,0x24,0x20,0x25,0xfe,0x44,0x00,0x02,0x10,0x7f,0xff,0x02,0x10,0x02,0x10,0x04,0x10,0x08,0x10,0x10,0x10}}, // 弉
{0x5733,0x9C52,0xD7B3,0xE5BD9D,0x5F5D,{0x02,0x00,0x03,0xf8,0x04,0x10,0x0f,0xf0,0x00,0x20,0x7f,0xff,0x08,0x10,0x2a,0x64,0x7f,0x1a,0x1c,0xfd,0x2a,0x2a,0x48,0xc9,0x02,0x10,0x7f,0xff,0x02,0x10,0x04,0x10}}, // 彝
{0x5734,0x9C53,0xD7B4,0xE5BD9C,0x5F5C,{0x02,0x00,0x03,0xf8,0x04,0x10,0x0f,0xf0,0x00,0x20,0x7f,0xff,0x08,0x14,0x2a,0x22,0x7f,0x7d,0x1c,0x94,0x2a,0x24,0x48,0x4c,0x04,0x20,0x7f,0xff,0x04,0x20,0x18,0x20}}, // 彜
{0x5735,0x9C54,0xD7B5,0xE5BC8B,0x5F0B,{0x01,0x10,0x01,0x08,0x01,0x08,0x01,0x00,0x7f,0xff,0x01,0x00,0x01,0x00,0x01,0x00,0x00,0x80,0x00,0x80,0x00,0x40,0x00,0x40,0x00,0x22,0x00,0x12,0x00,0x0a,0x00,0x06}}, // 弋
{0x5736,0x9C55,0xD7B6,0xE5BC91,0x5F11,{0x02,0x0c,0x22,0x0a,0x14,0x0a,0x08,0x08,0x15,0xff,0x22,0x08,0x48,0x08,0x0b,0xf8,0x7e,0x48,0x08,0x48,0x1c,0x48,0x1a,0x54,0x28,0x65,0x4b,0x83,0x08,0x03,0x08,0x01}}, // 弑
{0x5737,0x9C56,0xD7B7,0xE5BC96,0x5F16,{0x00,0x00,0x1f,0xf8,0x00,0x08,0x00,0x08,0x0f,0xf8,0x08,0x00,0x08,0x00,0x0f,0xfc,0x00,0x04,0x00,0x04,0x00,0x04,0x00,0x08,0x00,0x70,0x00,0x00,0x7f,0xff,0x00,0x00}}, // 弖
{0x5738,0x9C57,0xD7B8,0xE5BCA9,0x5F29,{0x04,0x00,0x04,0x00,0x7f,0xfe,0x09,0x22,0x11,0x14,0x3e,0x08,0x05,0x94,0x18,0x63,0x6f,0xf0,0x00,0x10,0x0f,0xf0,0x08,0x00,0x0f,0xf8,0x00,0x08,0x00,0x08,0x00,0x70}}, // 弩
{0x5739,0x9C58,0xD7B9,0xE5BCAD,0x5F2D,{0x00,0x00,0x7f,0xff,0x04,0x84,0x04,0x84,0x04,0xfc,0x3c,0x84,0x20,0x84,0x20,0x84,0x20,0xfc,0x3c,0x84,0x04,0x84,0x04,0x86,0x04,0xfc,0x07,0x84,0x08,0x04,0x30,0x04}}, // 弭
{0x573A,0x9C59,0xD7BA,0xE5BCB8,0x5F38,{0x00,0x00,0x7b,0xde,0x0a,0x52,0x0a,0x52,0x0a,0x52,0x7b,0xde,0x42,0x52,0x42,0x52,0x42,0x52,0x7b,0xde,0x0a,0x52,0x0a,0x52,0x0a,0x52,0x0a,0x52,0x12,0x62,0x64,0xc6}}, // 弸
{0x573B,0x9C5A,0xD7BB,0xE5BD81,0x5F41,{0x00,0x00,0x7f,0xff,0x04,0x04,0x04,0xf4,0x04,0x94,0x3c,0xf4,0x20,0x94,0x20,0x0c,0x3d,0xff,0x04,0x04,0x04,0xf4,0x04,0x94,0x04,0xf4,0x04,0x94,0x08,0x04,0x30,0x0c}}, // 彁
{0x573C,0x9C5B,0xD7BC,0xE5BD88,0x5F48,{0x00,0x00,0x7f,0xde,0x06,0x52,0x07,0xde,0x04,0x00,0x3d,0xfc,0x21,0x24,0x21,0x24,0x21,0xfc,0x3d,0x24,0x05,0xfc,0x04,0x20,0x07,0xff,0x04,0x20,0x08,0x20,0x30,0x20}}, // 彈
{0x573D,0x9C5C,0xD7BD,0xE5BD8C,0x5F4C,{0x00,0x00,0x7f,0xff,0x09,0x24,0x0a,0x22,0x0f,0xff,0x7b,0x76,0x42,0xaa,0x42,0xee,0x43,0x76,0x7a,0x22,0x0b,0x66,0x0a,0xba,0x0a,0xee,0x0b,0x76,0x12,0x22,0x62,0x26}}, // 彌
{0x573E,0x9C5D,0xD7BE,0xE5BD8E,0x5F4E,{0x11,0x84,0x17,0xe4,0x68,0x1a,0x13,0xc4,0x28,0x0a,0x7f,0xdf,0x12,0x44,0x3b,0xd6,0x54,0x25,0x1f,0xf4,0x00,0x10,0x0f,0xf0,0x08,0x00,0x0f,0xf8,0x00,0x08,0x00,0x70}}, // 彎
{0x573F,0x9C5E,0xD7BF,0xE5BCAF,0x5F2F,{0x00,0x80,0x00,0x80,0x7f,0xff,0x02,0x40,0x0a,0x58,0x12,0x44,0x64,0x42,0x00,0x00,0x1f,0xf8,0x00,0x08,0x0f,0xf8,0x08,0x00,0x0f,0xfc,0x08,0x04,0x00,0x04,0x00,0x78}}, // 弯
{0x5740,0x9C5F,0xD7C0,0xE5BD91,0x5F51,{0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x03,0xf0,0x04,0x10,0x04,0x10,0x04,0x10,0x04,0x10,0x08,0x20,0x0f,0xe0,0x00,0x20,0x00,0x20,0x00,0x20,0x7f,0xff,0x00,0x00}}, // 彑
{0x5741,0x9C60,0xD7C1,0xE5BD96,0x5F56,{0x02,0x00,0x03,0xf8,0x04,0x10,0x0f,0xf0,0x00,0x20,0x7f,0xff,0x01,0x00,0x06,0xa4,0x38,0xa8,0x03,0x58,0x0c,0x50,0x30,0xc8,0x03,0x44,0x0c,0x42,0x70,0x41,0x01,0x80}}, // 彖
{0x5742,0x9C61,0xD7C2,0xE5BD97,0x5F57,{0x08,0x10,0x08,0x10,0x7f,0xfe,0x08,0x10,0x3e,0x7c,0x08,0x10,0x0e,0xfe,0x78,0x10,0x08,0x10,0x1f,0xf8,0x00,0x08,0x00,0x08,0x7f,0xff,0x00,0x08,0x1f,0xf8,0x00,0x08}}, // 彗
{0x5743,0x9C62,0xD7C3,0xE5BD99,0x5F59,{0x02,0x00,0x03,0xf8,0x04,0x10,0x0f,0xf0,0x00,0x20,0x7f,0xff,0x00,0x00,0x3f,0xff,0x28,0x8a,0x4f,0xf8,0x08,0x88,0x0f,0xf8,0x7f,0xff,0x02,0xa0,0x0c,0x98,0x70,0x87}}, // 彙
{0x5744,0x9C63,0xD7C4,0xE5BDA1,0x5F61,{0x00,0x20,0x00,0x20,0x00,0x40,0x00,0x80,0x03,0x00,0x0c,0x10,0x00,0x20,0x00,0x40,0x00,0x80,0x03,0x08,0x0c,0x10,0x00,0x20,0x00,0x40,0x00,0x80,0x03,0x00,0x1c,0x00}}, // 彡
{0x5745,0x9C64,0xD7C5,0xE5BDAD,0x5F6D,{0x04,0x04,0x04,0x04,0x7f,0xc8,0x04,0x12,0x04,0x22,0x3f,0x84,0x00,0x04,0x3f,0x88,0x20,0x91,0x20,0xa1,0x3f,0x82,0x11,0x02,0x0a,0x04,0x09,0xc8,0x1e,0x10,0x70,0x60}}, // 彭
{0x5746,0x9C65,0xD7C6,0xE5BDB3,0x5F73,{0x00,0x40,0x00,0x40,0x00,0x80,0x01,0x00,0x02,0x10,0x04,0x20,0x18,0x40,0x00,0x80,0x01,0x80,0x02,0x80,0x0c,0x80,0x30,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}, // 彳
{0x5747,0x9C66,0xD7C7,0xE5BDB7,0x5F77,{0x08,0x20,0x08,0x20,0x10,0x20,0x13,0xff,0x24,0x40,0x44,0x40,0x08,0x40,0x08,0x7c,0x18,0x44,0x28,0x44,0x48,0x44,0x08,0x84,0x08,0x84,0x09,0x04,0x0a,0x04,0x0c,0x18}}, // 彷
{0x5748,0x9C67,0xD7C8,0xE5BE83,0x5F83,{0x08,0x20,0x09,0x20,0x11,0x20,0x11,0x20,0x25,0xfe,0x46,0x20,0x0a,0x20,0x0c,0x20,0x10,0x20,0x31,0xfc,0x50,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x17,0xff,0x10,0x00}}, // 徃
{0x5749,0x9C68,0xD7C9,0xE5BE82,0x5F82,{0x08,0x00,0x09,0xfc,0x11,0x04,0x11,0x04,0x25,0x04,0x45,0xfc,0x09,0x04,0x09,0x04,0x11,0x04,0x31,0xfc,0x51,0x04,0x11,0x04,0x11,0x04,0x11,0x04,0x17,0xff,0x10,0x00}}, // 徂
{0x574A,0x9C69,0xD7CA,0xE5BDBF,0x5F7F,{0x08,0x90,0x08,0x90,0x13,0xfe,0x10,0x92,0x24,0x92,0x47,0xfe,0x0a,0x90,0x0a,0x90,0x13,0xfe,0x32,0x92,0x50,0x92,0x10,0x92,0x10,0x92,0x11,0x1c,0x12,0x10,0x14,0x10}}, // 彿
{0x574B,0x9C6A,0xD7CB,0xE5BE8A,0x5F8A,{0x08,0x00,0x0b,0xfe,0x12,0x02,0x12,0x02,0x26,0xfa,0x46,0x8a,0x0a,0x8a,0x0a,0x8a,0x1a,0x8a,0x2a,0x8a,0x4a,0xfa,0x0a,0x8a,0x0a,0x02,0x0a,0x02,0x0b,0xfe,0x0a,0x02}}, // 徊
{0x574C,0x9C6B,0xD7CC,0xE5BE88,0x5F88,{0x08,0x00,0x09,0xfc,0x11,0x04,0x11,0x04,0x25,0xfc,0x45,0x04,0x09,0x04,0x09,0xfc,0x11,0x22,0x31,0x24,0x51,0x18,0x11,0x10,0x11,0x08,0x11,0x64,0x11,0x82,0x16,0x01}}, // 很
{0x574D,0x9C6C,0xD7CD,0xE5BE91,0x5F91,{0x08,0x00,0x0b,0xfe,0x10,0x00,0x11,0x24,0x25,0x24,0x46,0x48,0x0a,0xd8,0x09,0x24,0x19,0x24,0x18,0x00,0x29,0xfc,0x48,0x20,0x08,0x20,0x08,0x20,0x0f,0xff,0x08,0x00}}, // 徑
{0x574E,0x9C6D,0xD7CE,0xE5BE87,0x5F87,{0x08,0x80,0x08,0x80,0x10,0xfe,0x14,0x82,0x25,0x02,0x49,0xf2,0x0b,0x12,0x15,0x12,0x11,0xf2,0x31,0x12,0x51,0x12,0x11,0xf2,0x11,0x12,0x10,0x02,0x10,0x04,0x10,0x18}}, // 徇
{0x574F,0x9C6E,0xD7CF,0xE5BE9E,0x5F9E,{0x08,0x84,0x08,0x84,0x10,0x84,0x10,0xc6,0x25,0x4a,0x45,0x29,0x0a,0x10,0x08,0x10,0x10,0x90,0x30,0x90,0x50,0x9e,0x10,0x90,0x11,0x50,0x11,0x30,0x12,0x18,0x14,0x07}}, // 從
{0x5750,0x9C6F,0xD7D0,0xE5BE99,0x5F99,{0x08,0x10,0x08,0x90,0x10,0x90,0x10,0x9e,0x24,0x90,0x44,0x90,0x0b,0xff,0x08,0x10,0x10,0x90,0x30,0x90,0x50,0x9e,0x10,0x90,0x11,0x50,0x11,0x30,0x12,0x18,0x14,0x07}}, // 徙
{0x5751,0x9C70,0xD7D1,0xE5BE98,0x5F98,{0x08,0x48,0x08,0x48,0x10,0x48,0x13,0xcf,0x24,0x48,0x44,0x48,0x08,0x48,0x0b,0xcf,0x10,0x48,0x30,0x48,0x51,0xc8,0x16,0x4f,0x10,0x88,0x10,0x88,0x11,0x08,0x12,0x08}}, // 徘
{0x5752,0x9C71,0xD7D2,0xE5BEA0,0x5FA0,{0x08,0x20,0x08,0x20,0x13,0xff,0x10,0x20,0x25,0x24,0x45,0x24,0x09,0x26,0x0a,0xaa,0x12,0x69,0x34,0x30,0x50,0x70,0x10,0xa8,0x11,0x24,0x12,0x22,0x14,0x21,0x10,0x20}}, // 徠
{0x5753,0x9C72,0xD7D3,0xE5BEA8,0x5FA8,{0x08,0x20,0x08,0x40,0x11,0xfc,0x11,0x04,0x25,0xfc,0x45,0x04,0x09,0x04,0x09,0xfc,0x10,0x00,0x33,0xfe,0x50,0x20,0x11,0xfc,0x10,0x20,0x10,0x20,0x17,0xff,0x10,0x00}}, // 徨
{0x5754,0x9C73,0xD7D4,0xE5BEAD,0x5FAD,{0x08,0x10,0x08,0x3e,0x10,0x62,0x11,0x94,0x24,0x48,0x44,0x30,0x09,0xc0,0x0e,0xfe,0x10,0xa0,0x31,0x20,0x57,0xff,0x10,0x20,0x12,0x22,0x12,0x22,0x13,0xfe,0x12,0x02}}, // 徭
{0x5755,0x9C74,0xD7D5,0xE5BEBC,0x5FBC,{0x09,0x08,0x0a,0x08,0x17,0xc8,0x14,0x4f,0x27,0xd4,0x4c,0x64,0x0f,0xd4,0x11,0x14,0x1f,0xf4,0x32,0x14,0x53,0x88,0x12,0x88,0x12,0x94,0x14,0x94,0x18,0xa2,0x11,0xc1}}, // 徼
{0x5756,0x9C75,0xD7D6,0xE5BF96,0x5FD6,{0x08,0x08,0x08,0x08,0x08,0x08,0x09,0xff,0x0c,0x08,0x2a,0x08,0x2a,0x08,0x28,0x88,0x28,0x48,0x48,0x48,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x18,0x08,0x08}}, // 忖
{0x5757,0x9C76,0xD7D7,0xE5BFBB,0x5FFB,{0x08,0x04,0x08,0x18,0x08,0xe0,0x08,0x80,0x0c,0x80,0x2a,0xff,0x2a,0x88,0x28,0x88,0x28,0x88,0x48,0x88,0x08,0x88,0x08,0x88,0x09,0x08,0x09,0x08,0x0a,0x08,0x08,0x08}}, // 忻
{0x5758,0x9C77,0xD7D8,0xE5BFA4,0x5FE4,{0x08,0x80,0x08,0x80,0x08,0xfe,0x08,0x90,0x0d,0x10,0x2a,0x10,0x2a,0x10,0x2b,0xff,0x28,0x10,0x48,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10}}, // 忤
{0x5759,0x9C78,0xD7D9,0xE5BFB8,0x5FF8,{0x08,0x00,0x09,0xfc,0x08,0x44,0x08,0x44,0x08,0x44,0x2c,0x44,0x2a,0x44,0x2b,0xff,0x28,0x44,0x48,0x44,0x08,0x44,0x08,0x44,0x08,0x44,0x08,0x44,0x0b,0xff,0x08,0x00}}, // 忸
{0x575A,0x9C79,0xD7DA,0xE5BFB1,0x5FF1,{0x08,0x20,0x08,0x20,0x08,0x20,0x09,0xff,0x09,0x22,0x2d,0x20,0x2a,0x20,0x2a,0x30,0x28,0x30,0x48,0x30,0x08,0x50,0x08,0x50,0x08,0x90,0x09,0x11,0x0a,0x09,0x0c,0x07}}, // 忱
{0x575B,0x9C7A,0xD7DB,0xE5BF9D,0x5FDD,{0x00,0x08,0x00,0x70,0x1f,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0x40,0x02,0x20,0x0d,0x18,0x71,0x07,0x01,0x48,0x09,0x24,0x09,0x12,0x11,0x12,0x21,0x00,0x03,0x00}}, // 忝
{0x575C,0x9C7B,0xD7DC,0xE682B3,0x60B3,{0x00,0x80,0x7f,0xff,0x00,0x80,0x07,0xf8,0x24,0x08,0x27,0xf8,0x24,0x08,0x27,0xf8,0x24,0x08,0x27,0xf8,0x3f,0xff,0x02,0x80,0x12,0x44,0x12,0x52,0x22,0x11,0x41,0xf1}}, // 悳
{0x575D,0x9C7C,0xD7DD,0xE5BFBF,0x5FFF,{0x01,0xe0,0x04,0x20,0x04,0x10,0x08,0x08,0x1f,0xf4,0x62,0x13,0x02,0x10,0x04,0x10,0x08,0x10,0x30,0xe0,0x00,0x40,0x12,0x24,0x12,0x22,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 忿
{0x575E,0x9C7D,0xD7DE,0xE680A1,0x6021,{0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x28,0x2c,0x44,0x2a,0x44,0x2a,0x8e,0x2b,0xf2,0x48,0x02,0x08,0x00,0x09,0xfc,0x09,0x04,0x09,0x04,0x09,0x04,0x09,0xfc,0x09,0x04}}, // 怡
{0x575F,0x9C7E,0xD7DF,0xE681A0,0x6060,{0x08,0x20,0x08,0x20,0x08,0x20,0x0b,0xff,0x08,0x40,0x0c,0x48,0x2a,0xc8,0x2a,0x88,0x28,0xbe,0x49,0x88,0x0a,0x88,0x0c,0x88,0x08,0x88,0x08,0x88,0x08,0xff,0x08,0x80}}, // 恠
{0x5760,0x9C80,0xD7E0,0xE68099,0x6019,{0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x0b,0xff,0x2c,0x20,0x2a,0x20,0x2a,0x20,0x48,0x20,0x09,0xfc,0x09,0x04,0x09,0x04,0x09,0x04,0x09,0x04,0x09,0xfc,0x09,0x04}}, // 怙
{0x5761,0x9C81,0xD7E1,0xE68090,0x6010,{0x08,0x40,0x08,0x40,0x08,0x40,0x08,0xfe,0x2c,0x82,0x2b,0x02,0x2a,0xf2,0x28,0x92,0x48,0x92,0x08,0x92,0x08,0xf2,0x08,0x92,0x08,0x02,0x08,0x02,0x08,0x04,0x08,0x18}}, // 怐
{0x5762,0x9C82,0xD7E2,0xE680A9,0x6029,{0x08,0x00,0x09,0xfe,0x09,0x02,0x09,0x02,0x0d,0xfe,0x2b,0x02,0x29,0x40,0x29,0x44,0x49,0x48,0x09,0x70,0x09,0x40,0x09,0x40,0x0a,0x41,0x0a,0x41,0x0c,0x21,0x08,0x1f}}, // 怩
{0x5763,0x9C83,0xD7E3,0xE6808E,0x600E,{0x04,0x00,0x04,0x00,0x0f,0xfe,0x09,0x00,0x11,0x00,0x21,0xf8,0x41,0x00,0x01,0x00,0x01,0xf8,0x01,0x00,0x01,0x40,0x12,0x24,0x12,0x22,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 怎
{0x5764,0x9C84,0xD7E4,0xE680B1,0x6031,{0x04,0x00,0x04,0x00,0x0f,0xfc,0x09,0x24,0x11,0x24,0x2f,0x44,0x44,0xe4,0x08,0x94,0x01,0x08,0x02,0x30,0x00,0x80,0x12,0x44,0x12,0x42,0x22,0x09,0x42,0x09,0x01,0xf8}}, // 怱
{0x5765,0x9C85,0xD7E5,0xE6809B,0x601B,{0x08,0x00,0x08,0xfc,0x08,0x84,0x08,0x84,0x2c,0x84,0x2a,0xfc,0x2a,0x84,0x28,0x84,0x48,0x84,0x08,0x84,0x08,0xfc,0x08,0x84,0x08,0x00,0x08,0x00,0x0b,0xff,0x08,0x00}}, // 怛
{0x5766,0x9C86,0xD7E6,0xE68095,0x6015,{0x08,0x10,0x08,0x10,0x08,0x20,0x08,0xfe,0x0c,0x82,0x2a,0x82,0x2a,0x82,0x28,0x82,0x28,0xfe,0x48,0x82,0x08,0x82,0x08,0x82,0x08,0x82,0x08,0x82,0x08,0xfe,0x08,0x82}}, // 怕
{0x5767,0x9C87,0xD7E7,0xE680AB,0x602B,{0x10,0x90,0x10,0x90,0x17,0xfe,0x10,0x92,0x30,0x92,0x3b,0xfe,0x36,0x90,0x52,0x90,0x53,0xfe,0x12,0x92,0x10,0x92,0x10,0x92,0x10,0x92,0x11,0x1c,0x11,0x10,0x12,0x10}}, // 怫
{0x5768,0x9C88,0xD7E8,0xE680A6,0x6026,{0x08,0x00,0x0b,0xfe,0x08,0x20,0x08,0x28,0x2c,0xa4,0x2a,0xa4,0x29,0x22,0x2a,0x20,0x4b,0xff,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20}}, // 怦
{0x5769,0x9C89,0xD7E9,0xE6808F,0x600F,{0x08,0x10,0x08,0x10,0x08,0x10,0x08,0xfe,0x2c,0x92,0x2a,0x92,0x2a,0x92,0x28,0x92,0x48,0x92,0x0b,0xff,0x08,0x10,0x08,0x28,0x08,0x28,0x08,0x44,0x08,0x82,0x0b,0x01}}, // 怏
{0x576A,0x9C8A,0xD7EA,0xE680BA,0x603A,{0x08,0x40,0x08,0x20,0x08,0x10,0x08,0x00,0x0c,0xe0,0x2a,0x22,0x28,0x22,0x2b,0xb4,0x28,0xb4,0x48,0xa8,0x09,0x28,0x09,0x24,0x0a,0x24,0x0c,0x22,0x08,0x21,0x08,0x60}}, // 怺
{0x576B,0x9C8B,0xD7EB,0xE6819A,0x605A,{0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x3f,0xfe,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x40,0x12,0x22,0x12,0x29,0x22,0x09,0x41,0xf8}}, // 恚
{0x576C,0x9C8C,0xD7EC,0xE68181,0x6041,{0x04,0x04,0x04,0x38,0x0b,0xe0,0x08,0x20,0x10,0x20,0x37,0xff,0x50,0x20,0x10,0x20,0x10,0x20,0x13,0xfe,0x10,0x40,0x12,0x24,0x12,0x22,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 恁
{0x576D,0x9C8D,0xD7ED,0xE681AA,0x606A,{0x08,0x40,0x08,0x40,0x08,0x7c,0x08,0x84,0x2c,0xc8,0x2b,0x28,0x2a,0x10,0x28,0x28,0x48,0x44,0x08,0x82,0x09,0xfd,0x0a,0x84,0x08,0x84,0x08,0x84,0x08,0xfc,0x08,0x84}}, // 恪
{0x576E,0x9C8E,0xD7EE,0xE681B7,0x6077,{0x04,0x20,0x04,0x20,0x08,0x20,0x17,0xff,0x30,0x70,0x50,0xa8,0x11,0x24,0x12,0x22,0x14,0x21,0x10,0x20,0x00,0x80,0x12,0x44,0x12,0x42,0x22,0x09,0x42,0x09,0x01,0xf8}}, // 恷
{0x576F,0x9C8F,0xD7EF,0xE6819F,0x605F,{0x08,0x80,0x08,0x80,0x08,0xfe,0x08,0x82,0x2d,0x12,0x2d,0x12,0x2a,0x9a,0x29,0x6a,0x49,0x2a,0x09,0x5a,0x09,0x8a,0x09,0x0a,0x09,0xfa,0x09,0x0a,0x08,0x04,0x08,0x18}}, // 恟
{0x5770,0x9C90,0xD7F0,0xE6818A,0x604A,{0x08,0x40,0x08,0x40,0x09,0xfc,0x08,0x44,0x2c,0x44,0x2a,0x84,0x2b,0x18,0x28,0x00,0x49,0x08,0x0f,0xff,0x09,0x29,0x09,0x29,0x09,0x29,0x0a,0x31,0x0c,0x21,0x08,0xc6}}, // 恊
{0x5771,0x9C91,0xD7F1,0xE68186,0x6046,{0x08,0x00,0x0b,0xff,0x08,0x40,0x08,0x40,0x0c,0x7c,0x2a,0x64,0x2a,0x94,0x28,0x94,0x48,0xc4,0x08,0xa8,0x09,0x28,0x09,0x08,0x08,0x08,0x08,0x08,0x0b,0xff,0x08,0x00}}, // 恆
{0x5772,0x9C92,0xD7F2,0xE6818D,0x604D,{0x08,0x20,0x08,0x24,0x09,0x24,0x08,0xa4,0x2c,0xa8,0x2a,0x20,0x2a,0x20,0x2b,0xff,0x48,0x50,0x08,0x50,0x08,0x50,0x08,0x90,0x08,0x90,0x09,0x11,0x0a,0x11,0x0c,0x0f}}, // 恍
{0x5773,0x9C93,0xD7F3,0xE681A3,0x6063,{0x00,0x80,0x00,0x80,0x79,0xfe,0x01,0x22,0x02,0x24,0x04,0x20,0x00,0x50,0x18,0x88,0x63,0x04,0x0c,0x43,0x00,0x20,0x12,0x24,0x12,0x02,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 恣
{0x5774,0x9C94,0xD7F4,0xE68183,0x6043,{0x08,0x10,0x08,0x10,0x08,0xfe,0x08,0x10,0x2c,0x10,0x2a,0x10,0x2b,0xff,0x28,0x04,0x48,0x04,0x0b,0xff,0x08,0x04,0x08,0x84,0x08,0x44,0x08,0x44,0x08,0x1c,0x08,0x04}}, // 恃
{0x5775,0x9C95,0xD7F5,0xE681A4,0x6064,{0x08,0x20,0x08,0x20,0x08,0x40,0x08,0x80,0x2d,0xfc,0x2b,0x54,0x29,0x54,0x29,0x54,0x49,0x54,0x09,0x54,0x09,0x54,0x09,0x54,0x09,0x54,0x09,0x54,0x0b,0xff,0x08,0x00}}, // 恤
{0x5776,0x9C96,0xD7F6,0xE68182,0x6042,{0x08,0x80,0x08,0x80,0x08,0xfe,0x08,0x82,0x29,0x02,0x2d,0xf2,0x2a,0x92,0x2a,0x92,0x48,0xf2,0x08,0x92,0x08,0x92,0x08,0xf2,0x08,0x92,0x08,0x02,0x08,0x04,0x08,0x18}}, // 恂
{0x5777,0x9C97,0xD7F7,0xE681AC,0x606C,{0x08,0x08,0x08,0x30,0x09,0xe0,0x0c,0x20,0x2a,0x20,0x28,0x20,0x2b,0xff,0x28,0x20,0x48,0x20,0x08,0x20,0x09,0xfc,0x09,0x04,0x09,0x04,0x09,0x04,0x09,0xfc,0x09,0x04}}, // 恬
{0x5778,0x9C98,0xD7F8,0xE681AB,0x606B,{0x08,0x00,0x09,0xfe,0x09,0x02,0x09,0x02,0x2d,0xfe,0x2b,0x02,0x29,0x02,0x29,0x7a,0x49,0x4a,0x09,0x4a,0x09,0x4a,0x09,0x7a,0x09,0x4a,0x09,0x02,0x09,0x02,0x09,0x06}}, // 恫
{0x5779,0x9C99,0xD7F9,0xE68199,0x6059,{0x04,0x08,0x02,0x10,0x02,0x20,0x3f,0xfe,0x00,0x80,0x00,0x80,0x1f,0xfc,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x40,0x12,0x24,0x12,0x22,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 恙
{0x577A,0x9C9A,0xD7FA,0xE68281,0x6081,{0x08,0x00,0x08,0xfe,0x08,0x82,0x08,0x82,0x2c,0xfe,0x2a,0x00,0x2a,0xfe,0x28,0x82,0x48,0x82,0x08,0xfe,0x08,0x82,0x08,0x82,0x08,0xfe,0x08,0x82,0x08,0x86,0x08,0x82}}, // 悁
{0x577B,0x9C9B,0xD7FB,0xE6828D,0x608D,{0x08,0x00,0x09,0xfc,0x09,0x04,0x09,0xfc,0x2d,0x04,0x2b,0x04,0x29,0xfc,0x28,0x00,0x4b,0xfe,0x08,0x20,0x08,0x20,0x0f,0xff,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20}}, // 悍
{0x577C,0x9C9C,0xD7FC,0xE683A7,0x60E7,{0x08,0x00,0x08,0xfc,0x08,0x84,0x08,0x84,0x2c,0xfc,0x2a,0x84,0x2a,0x84,0x28,0xfc,0x48,0x84,0x08,0x84,0x08,0xfc,0x08,0x84,0x0b,0xff,0x08,0x28,0x08,0xc4,0x0b,0x02}}, // 惧
{0x577D,0x9C9D,0xD7FD,0xE68283,0x6083,{0x08,0x00,0x0b,0xfe,0x0a,0x22,0x0a,0x22,0x2e,0x22,0x2b,0xfe,0x2a,0x22,0x2a,0x72,0x4a,0x72,0x0a,0xaa,0x0a,0xaa,0x0b,0x26,0x0a,0x22,0x0a,0x02,0x0b,0xfe,0x0a,0x02}}, // 悃
{0x577E,0x9C9E,0xD7FE,0xE6829A,0x609A,{0x08,0x20,0x08,0x20,0x0b,0xff,0x08,0x20,0x2d,0xfc,0x2b,0x24,0x2b,0x24,0x29,0x24,0x49,0xfc,0x09,0x70,0x08,0x68,0x08,0xa4,0x09,0x22,0x0a,0x21,0x0c,0x20,0x08,0x20}}, // 悚
{0x5821,0x9C9F,0xD8A1,0xE68284,0x6084,{0x08,0x10,0x08,0x54,0x08,0x52,0x08,0x92,0x2d,0x10,0x2a,0xfe,0x2a,0x82,0x28,0x82,0x48,0xfe,0x08,0x82,0x08,0x82,0x08,0xfe,0x08,0x82,0x08,0x82,0x08,0x86,0x08,0x82}}, // 悄
{0x5822,0x9CA0,0xD8A2,0xE6829B,0x609B,{0x08,0x40,0x08,0x50,0x08,0x8c,0x0b,0xfa,0x08,0x50,0x2c,0x51,0x2a,0x8f,0x2b,0x20,0x48,0x78,0x08,0x88,0x0b,0x50,0x08,0x30,0x08,0x20,0x08,0xd0,0x0b,0x0c,0x0c,0x03}}, // 悛
{0x5823,0x9CA1,0xD8A3,0xE68296,0x6096,{0x08,0x10,0x08,0x10,0x0b,0xff,0x08,0x10,0x0c,0x10,0x2b,0xff,0x29,0x02,0x2a,0x00,0x48,0xfe,0x08,0x04,0x08,0x08,0x0b,0xff,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x30}}, // 悖
{0x5824,0x9CA2,0xD8A4,0xE68297,0x6097,{0x08,0x40,0x08,0x7c,0x08,0x48,0x08,0x88,0x2d,0x10,0x2b,0xfe,0x29,0x22,0x29,0x22,0x49,0x42,0x09,0xfe,0x09,0x52,0x08,0x50,0x08,0x90,0x08,0x91,0x09,0x11,0x0a,0x0f}}, // 悗
{0x5825,0x9CA3,0xD8A5,0xE68292,0x6092,{0x08,0x00,0x08,0xfc,0x08,0x84,0x08,0x84,0x2c,0xfc,0x2a,0x00,0x29,0xfe,0x29,0x22,0x49,0x22,0x09,0xfe,0x09,0x02,0x09,0x00,0x09,0x01,0x09,0x01,0x08,0xff,0x08,0x00}}, // 悒
{0x5826,0x9CA4,0xD8A6,0xE682A7,0x60A7,{0x10,0x22,0x10,0xc2,0x13,0x92,0x10,0x92,0x18,0x92,0x37,0xf2,0x34,0x92,0x30,0x92,0x51,0xd2,0x51,0xb2,0x12,0x92,0x12,0x82,0x14,0x82,0x10,0x82,0x10,0x86,0x10,0x82}}, // 悧
{0x5827,0x9CA5,0xD8A7,0xE6828B,0x608B,{0x08,0x20,0x08,0x20,0x0b,0xff,0x08,0x88,0x2c,0x88,0x2a,0x50,0x28,0x20,0x28,0x50,0x49,0x8c,0x0e,0x03,0x09,0xfc,0x09,0x04,0x09,0x04,0x09,0x04,0x09,0xfc,0x09,0x04}}, // 悋
{0x5828,0x9CA6,0xD8A8,0xE683A1,0x60E1,{0x00,0x00,0x7f,0xff,0x02,0x20,0x02,0x20,0x1e,0x3c,0x10,0x04,0x10,0x04,0x1e,0x3c,0x02,0x20,0x7f,0xff,0x00,0x80,0x12,0x44,0x12,0x42,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 惡
{0x5829,0x9CA7,0xD8A9,0xE682B8,0x60B8,{0x08,0x04,0x08,0x18,0x09,0xe0,0x08,0x20,0x2d,0xff,0x2a,0x70,0x28,0xac,0x2b,0x23,0x48,0x20,0x09,0xfc,0x08,0x10,0x08,0x20,0x0b,0xff,0x08,0x20,0x08,0x20,0x08,0x60}}, // 悸
{0x582A,0x9CA8,0xD8AA,0xE683A0,0x60E0,{0x01,0x00,0x7f,0xfe,0x01,0x00,0x1f,0xf8,0x11,0x08,0x1f,0xf8,0x11,0x08,0x1f,0xf8,0x01,0x18,0x01,0xf4,0x7e,0x82,0x10,0x44,0x12,0x42,0x22,0x09,0x42,0x09,0x01,0xf8}}, // 惠
{0x582B,0x9CA9,0xD8AB,0xE68393,0x60D3,{0x08,0xa8,0x08,0xa4,0x09,0x24,0x0b,0xfe,0x28,0x20,0x2c,0x50,0x2b,0xff,0x28,0x48,0x48,0x84,0x09,0xfa,0x0a,0x89,0x08,0x88,0x08,0xb0,0x08,0x84,0x08,0x84,0x08,0x7c}}, // 惓
{0x582C,0x9CAA,0xD8AC,0xE682B4,0x60B4,{0x08,0x20,0x08,0x20,0x0b,0xfe,0x08,0x00,0x2c,0x88,0x2a,0x88,0x2a,0xcc,0x29,0x32,0x4a,0x20,0x08,0x20,0x0b,0xff,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20}}, // 悴
{0x582D,0x9CAB,0xD8AD,0xE5BFB0,0x5FF0,{0x08,0x40,0x08,0x40,0x09,0xf8,0x08,0x48,0x2c,0x48,0x2a,0x89,0x28,0x89,0x29,0x27,0x4a,0x20,0x08,0x20,0x0b,0xff,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20}}, // 忰
{0x582E,0x9CAC,0xD8AE,0xE682BD,0x60BD,{0x08,0x20,0x08,0x20,0x0b,0xff,0x08,0x20,0x2d,0xfc,0x2a,0x24,0x2b,0xff,0x28,0x24,0x49,0xfc,0x08,0x20,0x0b,0xff,0x08,0x48,0x08,0x88,0x09,0xf0,0x08,0x68,0x0b,0x84}}, // 悽
{0x582F,0x9CAD,0xD8AF,0xE68386,0x60C6,{0x08,0x00,0x09,0xfe,0x09,0x22,0x09,0x22,0x29,0x7a,0x2d,0x22,0x2b,0x22,0x29,0xfe,0x49,0x22,0x09,0x7a,0x09,0x4a,0x09,0x4a,0x09,0x7a,0x09,0x4a,0x09,0x02,0x0a,0x06}}, // 惆
{0x5830,0x9CAE,0xD8B0,0xE682B5,0x60B5,{0x08,0x00,0x08,0xfe,0x08,0x80,0x08,0xfc,0x2c,0x80,0x2a,0xfc,0x2a,0x80,0x28,0x80,0x4b,0xff,0x08,0xa2,0x08,0x92,0x08,0x94,0x08,0x88,0x08,0x84,0x08,0xe2,0x0b,0x01}}, // 悵
{0x5831,0x9CAF,0xD8B1,0xE68398,0x60D8,{0x08,0x00,0x09,0xfe,0x09,0x0a,0x09,0x4a,0x29,0x32,0x2d,0xfe,0x2b,0x22,0x29,0x22,0x49,0xfe,0x09,0x42,0x09,0x42,0x09,0x42,0x09,0x3a,0x09,0x02,0x09,0x06,0x09,0x02}}, // 惘
{0x5832,0x9CB0,0xD8B2,0xE6858D,0x614D,{0x08,0x00,0x08,0xfc,0x08,0xa4,0x08,0xa4,0x28,0xb4,0x2c,0xd4,0x2a,0x8c,0x28,0xfc,0x48,0x00,0x09,0xfe,0x09,0x4a,0x09,0x4a,0x09,0x4a,0x09,0x4a,0x0b,0xff,0x08,0x00}}, // 慍
{0x5833,0x9CB1,0xD8B3,0xE68495,0x6115,{0x08,0x00,0x0b,0xde,0x0a,0x52,0x0a,0x52,0x0b,0xde,0x2c,0x00,0x2b,0xfc,0x28,0x00,0x4b,0xff,0x08,0x40,0x08,0x40,0x08,0xfc,0x08,0x84,0x08,0x04,0x08,0x04,0x08,0x18}}, // 愕
{0x5834,0x9CB2,0xD8B4,0xE68486,0x6106,{0x09,0x00,0x08,0xbe,0x10,0x80,0x26,0x00,0x45,0x7f,0x09,0x04,0x10,0x44,0x30,0x84,0x50,0x84,0x11,0x04,0x12,0x8c,0x00,0x40,0x12,0x42,0x12,0x09,0x22,0x09,0x41,0xf8}}, // 愆
{0x5835,0x9CB3,0xD8B5,0xE683B6,0x60F6,{0x08,0x20,0x08,0x40,0x09,0xfc,0x09,0x04,0x2d,0xfc,0x2b,0x04,0x29,0x04,0x29,0xfc,0x48,0x00,0x0b,0xfe,0x08,0x20,0x09,0xfc,0x08,0x20,0x08,0x20,0x0f,0xff,0x08,0x00}}, // 惶
{0x5836,0x9CB4,0xD8B6,0xE683B7,0x60F7,{0x00,0x80,0x3f,0xfe,0x00,0x80,0x1f,0xfc,0x01,0x40,0x7f,0xff,0x02,0x20,0x0f,0xf8,0x74,0x17,0x07,0xf0,0x04,0x10,0x17,0xf0,0x12,0x42,0x22,0x21,0x42,0x09,0x01,0xf8}}, // 惷
{0x5837,0x9CB5,0xD8B7,0xE68480,0x6100,{0x10,0x48,0x11,0x88,0x17,0x08,0x11,0x0a,0x19,0x2a,0x37,0xec,0x31,0x2c,0x31,0x48,0x53,0x88,0x13,0x54,0x15,0x54,0x15,0x14,0x19,0x24,0x11,0x22,0x11,0x22,0x11,0x41}}, // 愀
{0x5838,0x9CB6,0xD8B8,0xE683B4,0x60F4,{0x08,0x20,0x09,0x22,0x09,0x22,0x09,0x22,0x0d,0xfe,0x2a,0x00,0x2b,0xff,0x28,0x20,0x48,0x40,0x09,0xfe,0x09,0x52,0x09,0x52,0x09,0x52,0x09,0x52,0x09,0x52,0x09,0x06}}, // 惴
{0x5839,0x9CB7,0xD8B9,0xE683BA,0x60FA,{0x08,0x00,0x09,0xfc,0x09,0x04,0x09,0xfc,0x2d,0x04,0x2b,0x04,0x29,0xfc,0x28,0xa0,0x48,0xa0,0x09,0xfe,0x0a,0x20,0x0b,0xfc,0x08,0x20,0x08,0x20,0x0f,0xff,0x08,0x00}}, // 惺
{0x583A,0x9CB8,0xD8BA,0xE68483,0x6103,{0x08,0x20,0x08,0x20,0x09,0xff,0x09,0x02,0x2a,0xfc,0x2c,0x00,0x2a,0xfc,0x28,0x84,0x48,0x84,0x08,0xfc,0x08,0x84,0x08,0x84,0x08,0xfc,0x08,0x00,0x0b,0xff,0x08,0x00}}, // 愃
{0x583B,0x9CB9,0xD8BB,0xE684A1,0x6121,{0x08,0x80,0x08,0x80,0x08,0xfe,0x09,0x4a,0x2b,0x4a,0x2c,0xd2,0x29,0x32,0x2a,0x2a,0x48,0x42,0x08,0x0c,0x08,0xa0,0x0a,0x90,0x0a,0x92,0x0a,0x85,0x0c,0x45,0x08,0x3c}}, // 愡
{0x583C,0x9CBA,0xD8BC,0xE683BB,0x60FB,{0x10,0x02,0x13,0xd2,0x12,0x52,0x12,0x52,0x33,0xd2,0x3a,0x52,0x36,0x52,0x52,0x52,0x53,0xd2,0x12,0x52,0x12,0x52,0x13,0xd2,0x11,0x42,0x11,0x22,0x12,0x06,0x14,0x02}}, // 惻
{0x583D,0x9CBB,0xD8BD,0xE683B1,0x60F1,{0x08,0x92,0x08,0x92,0x0b,0x6c,0x09,0x24,0x2c,0x92,0x2a,0x92,0x2a,0x20,0x29,0xfe,0x49,0x0a,0x09,0x4a,0x09,0x32,0x09,0x2a,0x09,0x4a,0x09,0x82,0x09,0xfe,0x09,0x02}}, // 惱
{0x583E,0x9CBC,0xD8BE,0xE6848D,0x610D,{0x00,0x20,0x3f,0x20,0x21,0x3f,0x21,0x24,0x3f,0x54,0x28,0x94,0x3f,0x08,0x24,0x08,0x22,0x94,0x39,0xa2,0x60,0xc1,0x12,0x24,0x12,0x22,0x22,0x09,0x42,0x09,0x01,0xf8}}, // 愍
{0x583F,0x9CBD,0xD8BF,0xE6848E,0x610E,{0x08,0x40,0x08,0x40,0x08,0xff,0x08,0x80,0x2d,0xfc,0x2a,0x84,0x2a,0xfc,0x28,0x84,0x48,0xfc,0x08,0x20,0x08,0x7c,0x08,0x88,0x0b,0x50,0x08,0x30,0x08,0xcc,0x0f,0x03}}, // 愎
{0x5840,0x9CBE,0xD8C0,0xE68587,0x6147,{0x02,0x00,0x1c,0x78,0x10,0x49,0x1e,0x49,0x12,0x87,0x1f,0x00,0x12,0xfc,0x1e,0x24,0x10,0x28,0x1e,0x10,0x22,0x6c,0x47,0x83,0x12,0x44,0x12,0x22,0x22,0x09,0x41,0xf8}}, // 慇
{0x5841,0x9CBF,0xD8C1,0xE684BE,0x613E,{0x08,0x40,0x08,0x40,0x08,0xfe,0x08,0x80,0x09,0x78,0x2c,0x00,0x2b,0xfc,0x28,0x44,0x4a,0x54,0x09,0x64,0x08,0x44,0x0b,0xf5,0x08,0xe5,0x09,0x53,0x0a,0x4b,0x08,0x41}}, // 愾
{0x5842,0x9CC0,0xD8C2,0xE684A8,0x6128,{0x08,0x00,0x08,0x78,0x7f,0x49,0x08,0x49,0x3e,0x47,0x00,0x80,0x3f,0xfc,0x22,0x44,0x40,0x28,0x3e,0x10,0x00,0x6c,0x12,0x83,0x12,0x44,0x22,0x4a,0x42,0x09,0x01,0xf8}}, // 愨
{0x5843,0x9CC1,0xD8C3,0xE684A7,0x6127,{0x08,0x20,0x08,0x40,0x09,0xfc,0x09,0x24,0x0d,0x24,0x2b,0xfc,0x2b,0x24,0x29,0x24,0x29,0xfc,0x48,0x54,0x08,0x54,0x08,0x5a,0x08,0x9e,0x08,0x91,0x09,0x11,0x0a,0x0f}}, // 愧
{0x5844,0x9CC2,0xD8C4,0xE6858A,0x614A,{0x08,0x44,0x09,0x98,0x08,0x48,0x0b,0xff,0x08,0x48,0x2d,0xfe,0x2a,0x4a,0x2b,0xff,0x28,0x4a,0x49,0xfe,0x08,0x48,0x08,0xcc,0x09,0x4a,0x0a,0x49,0x08,0x48,0x08,0x48}}, // 慊
{0x5845,0x9CC3,0xD8C5,0xE684BF,0x613F,{0x00,0x00,0x1f,0xff,0x10,0x40,0x13,0xfc,0x12,0x04,0x13,0xfc,0x12,0x04,0x13,0xfc,0x22,0x48,0x24,0x44,0x48,0xc2,0x02,0x40,0x12,0x22,0x12,0x09,0x22,0x09,0x41,0xf8}}, // 愿
{0x5846,0x9CC4,0xD8C6,0xE684BC,0x613C,{0x08,0x8c,0x08,0xf0,0x08,0x81,0x08,0x7f,0x2d,0x00,0x2b,0x7e,0x2b,0x42,0x29,0x7e,0x49,0x42,0x09,0x7e,0x09,0x42,0x09,0x7e,0x09,0x00,0x09,0xff,0x08,0x66,0x0b,0x81}}, // 愼
{0x5847,0x9CC5,0xD8C7,0xE684AC,0x612C,{0x21,0x00,0x11,0x3e,0x12,0x22,0x7f,0xe2,0x04,0x3e,0x24,0xa2,0x24,0xbe,0x3f,0xa2,0x24,0xa2,0x08,0x46,0x30,0x80,0x12,0x40,0x12,0x42,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 愬
{0x5848,0x9CC6,0xD8C8,0xE684B4,0x6134,{0x08,0x20,0x08,0x20,0x08,0x50,0x08,0x48,0x08,0xf4,0x2d,0x02,0x2b,0xfd,0x29,0x04,0x49,0xfc,0x09,0x04,0x09,0xfc,0x09,0x00,0x0a,0xfe,0x0a,0x82,0x0c,0xfe,0x08,0x82}}, // 愴
{0x5849,0x9CC7,0xD8C9,0xE684BD,0x613D,{0x08,0x24,0x08,0x22,0x0b,0xff,0x08,0x20,0x2d,0xfc,0x2b,0x24,0x29,0xfc,0x29,0x24,0x49,0xfc,0x09,0x24,0x08,0x08,0x0b,0xff,0x09,0x08,0x08,0x88,0x08,0x88,0x08,0x18}}, // 愽
{0x584A,0x9CC8,0xD8CA,0xE68582,0x6142,{0x10,0x00,0x0b,0xfc,0x08,0x88,0x40,0x50,0x23,0xfe,0x22,0x22,0x03,0xfe,0x0a,0x22,0x13,0xfe,0x22,0x22,0x40,0x26,0x12,0x44,0x12,0x22,0x22,0x29,0x41,0x09,0x00,0xf8}}, // 慂
{0x584B,0x9CC9,0xD8CB,0xE68584,0x6144,{0x08,0x00,0x0b,0xff,0x08,0x48,0x08,0x48,0x0d,0xfe,0x2b,0x4a,0x29,0x4a,0x29,0xfe,0x48,0x20,0x0f,0xff,0x08,0x70,0x08,0xa8,0x09,0x24,0x0e,0x23,0x08,0x20,0x08,0x20}}, // 慄
{0x584C,0x9CCA,0xD8CC,0xE685B3,0x6173,{0x10,0x00,0x13,0xfe,0x12,0x92,0x12,0x92,0x33,0xea,0x3a,0x2a,0x37,0xe4,0x32,0x8a,0x52,0x91,0x13,0xe0,0x10,0x20,0x13,0xfe,0x10,0x20,0x10,0x20,0x17,0xff,0x10,0x00}}, // 慳
{0x584D,0x9CCB,0xD8CD,0xE685B7,0x6177,{0x10,0x20,0x10,0x20,0x13,0xff,0x12,0x20,0x33,0xfc,0x3a,0x24,0x37,0xff,0x32,0x24,0x53,0xfc,0x13,0x22,0x12,0xb2,0x12,0xac,0x14,0x68,0x14,0xa4,0x1b,0x23,0x10,0x60}}, // 慷
{0x584E,0x9CCC,0xD8CE,0xE68598,0x6158,{0x08,0x20,0x08,0x20,0x08,0x50,0x09,0xfc,0x09,0x04,0x2a,0x8a,0x2f,0x7d,0x28,0x50,0x49,0x8c,0x0e,0x23,0x08,0x48,0x09,0x92,0x08,0x64,0x09,0x88,0x08,0x30,0x0b,0xc0}}, // 慘
{0x584F,0x9CCD,0xD8CF,0xE68599,0x6159,{0x04,0x04,0x7f,0xf8,0x04,0x20,0x3f,0xa0,0x24,0xbf,0x3f,0xa4,0x24,0xa4,0x3f,0xa4,0x04,0x44,0x7f,0x84,0x04,0x84,0x12,0x44,0x12,0x42,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 慙
{0x5850,0x9CCE,0xD8D0,0xE6859A,0x615A,{0x11,0x02,0x11,0x04,0x17,0xf8,0x11,0x10,0x17,0xd0,0x3d,0x5f,0x35,0x52,0x37,0xd2,0x55,0x52,0x15,0x52,0x17,0xd2,0x11,0x12,0x1f,0xf2,0x11,0x12,0x11,0x22,0x11,0x02}}, // 慚
{0x5851,0x9CCF,0xD8D1,0xE685AB,0x616B,{0x08,0x84,0x08,0x84,0x11,0x4a,0x25,0x29,0x46,0x10,0x08,0x90,0x18,0x9e,0x28,0x90,0x49,0x50,0x0a,0x30,0x0c,0x8f,0x12,0x44,0x12,0x42,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 慫
{0x5852,0x9CD0,0xD8D2,0xE685B4,0x6174,{0x08,0x00,0x0b,0xff,0x08,0xa5,0x09,0x29,0x2c,0x63,0x2a,0xa5,0x29,0x29,0x28,0x63,0x48,0x10,0x08,0xfe,0x08,0x82,0x08,0xfe,0x08,0x82,0x08,0x82,0x08,0xfe,0x08,0x82}}, // 慴
{0x5853,0x9CD1,0xD8D3,0xE685AF,0x616F,{0x08,0x80,0x08,0xff,0x09,0x00,0x0a,0xfc,0x2c,0x84,0x2a,0xfc,0x28,0x84,0x28,0xfc,0x48,0x00,0x0b,0xff,0x08,0x80,0x09,0xfe,0x0a,0x4a,0x08,0x92,0x09,0x22,0x08,0x4c}}, // 慯
{0x5854,0x9CD2,0xD8D4,0xE685A5,0x6165,{0x08,0x08,0x09,0x28,0x08,0xa8,0x08,0xbe,0x0a,0x48,0x2d,0x08,0x2d,0x7f,0x28,0x08,0x2b,0xbe,0x48,0xa2,0x08,0xa2,0x08,0xbe,0x08,0xa2,0x09,0x40,0x0a,0x30,0x0c,0x0f}}, // 慥
{0x5855,0x9CD3,0xD8D5,0xE685B1,0x6171,{0x08,0x20,0x08,0x20,0x0b,0xff,0x08,0x20,0x09,0xfc,0x2d,0x24,0x2b,0xfc,0x2b,0x24,0x29,0xfc,0x48,0x24,0x0b,0xfe,0x08,0x09,0x0f,0xff,0x09,0x08,0x08,0x88,0x08,0x18}}, // 慱
{0x5856,0x9CD4,0xD8D6,0xE6859F,0x615F,{0x10,0x48,0x17,0x88,0x11,0x08,0x17,0xe8,0x39,0x1e,0x37,0xca,0x35,0x4a,0x37,0xca,0x55,0x4a,0x17,0xca,0x11,0x0a,0x17,0xca,0x11,0x12,0x11,0xd2,0x16,0x22,0x10,0x4c}}, // 慟
{0x5857,0x9CD5,0xD8D7,0xE6859D,0x615D,{0x00,0x00,0x3f,0xfe,0x22,0x10,0x3f,0xfe,0x21,0x10,0x3f,0xfc,0x22,0x00,0x27,0xf8,0x2a,0x08,0x33,0xf8,0x20,0x00,0x3f,0xfe,0x12,0x40,0x12,0x22,0x22,0x09,0x41,0xf9}}, // 慝
{0x5858,0x9CD6,0xD8D8,0xE68593,0x6153,{0x08,0x00,0x0b,0xff,0x08,0x48,0x09,0xfe,0x0d,0x4a,0x2b,0x4a,0x2b,0xfe,0x28,0x00,0x29,0xfe,0x48,0x00,0x0b,0xff,0x08,0x10,0x08,0x94,0x09,0x12,0x0a,0x11,0x08,0x30}}, // 慓
{0x5859,0x9CD7,0xD8D9,0xE685B5,0x6175,{0x10,0x10,0x13,0xff,0x12,0x10,0x12,0xfe,0x3a,0x12,0x37,0xff,0x32,0x12,0x52,0xfe,0x52,0x10,0x12,0xfe,0x12,0x92,0x12,0xfe,0x14,0x92,0x14,0xfe,0x18,0x92,0x10,0x96}}, // 慵
{0x585A,0x9CD8,0xD8DA,0xE68699,0x6199,{0x00,0x80,0x3f,0xfe,0x00,0x80,0x0f,0xf8,0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x02,0x20,0x7f,0xff,0x08,0x08,0x0f,0xf8,0x12,0x40,0x12,0x2a,0x21,0x09,0x40,0xf9}}, // 憙
{0x585B,0x9CD9,0xD8DB,0xE68696,0x6196,{0x04,0x14,0x04,0x12,0x7f,0x92,0x15,0x7f,0x15,0x10,0x1e,0xa8,0x24,0xa8,0x4e,0x24,0x15,0x42,0x24,0x81,0x44,0x80,0x12,0x44,0x12,0x42,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 憖
{0x585C,0x9CDA,0xD8DC,0xE68687,0x6187,{0x02,0x44,0x0c,0x44,0x79,0xff,0x08,0x44,0x7f,0x44,0x08,0x7c,0x3e,0x44,0x22,0x44,0x3e,0x7c,0x22,0x44,0x04,0x80,0x14,0x44,0x14,0x42,0x24,0x09,0x42,0x09,0x01,0xf8}}, // 憇
{0x585D,0x9CDB,0xD8DD,0xE686AC,0x61AC,{0x08,0x00,0x09,0xfc,0x09,0x04,0x09,0xfc,0x09,0x04,0x2d,0xfc,0x2a,0x20,0x2b,0xff,0x48,0x00,0x09,0xfc,0x09,0x04,0x09,0xfc,0x08,0xa8,0x09,0x24,0x0a,0x22,0x08,0x60}}, // 憬
{0x585E,0x9CDC,0xD8DE,0xE68694,0x6194,{0x08,0x44,0x08,0x48,0x08,0xff,0x08,0x90,0x2d,0x90,0x2a,0xfe,0x28,0x90,0x28,0xfe,0x48,0x90,0x08,0x90,0x08,0xff,0x08,0x00,0x08,0x84,0x08,0xd2,0x09,0x29,0x0a,0x29}}, // 憔
{0x585F,0x9CDD,0xD8DF,0xE6869A,0x619A,{0x08,0x00,0x0b,0xde,0x0a,0x52,0x0b,0xde,0x28,0x00,0x2d,0xfc,0x2b,0x24,0x29,0xfc,0x49,0x24,0x09,0x24,0x09,0xfc,0x08,0x20,0x0f,0xff,0x08,0x20,0x08,0x20,0x08,0x20}}, // 憚
{0x5860,0x9CDE,0xD8E0,0xE6868A,0x618A,{0x04,0x48,0x05,0xfe,0x08,0x48,0x0b,0xff,0x12,0xfe,0x32,0x92,0x52,0xfe,0x12,0x92,0x12,0xfe,0x14,0x92,0x18,0x96,0x02,0x40,0x12,0x22,0x12,0x09,0x21,0x09,0x40,0xf8}}, // 憊
{0x5861,0x9CDF,0xD8E1,0xE68691,0x6191,{0x00,0x00,0x23,0xfc,0x12,0x20,0x03,0xf8,0x02,0x20,0x0b,0xf8,0x0a,0x20,0x13,0xfe,0x24,0x92,0x44,0x4a,0x08,0x8c,0x02,0x40,0x12,0x42,0x22,0x09,0x42,0x09,0x01,0xf8}}, // 憑
{0x5862,0x9CE0,0xD8E2,0xE686AB,0x61AB,{0x10,0x00,0x13,0xde,0x12,0x52,0x13,0xde,0x32,0x52,0x3b,0xde,0x36,0x02,0x32,0x22,0x53,0xfe,0x12,0x8a,0x12,0x52,0x12,0x22,0x12,0x52,0x12,0x8a,0x12,0x02,0x12,0x06}}, // 憫
{0x5863,0x9CE1,0xD8E3,0xE686AE,0x61AE,{0x09,0x00,0x09,0x00,0x0b,0xff,0x0d,0x54,0x29,0x54,0x2d,0x54,0x2b,0xff,0x29,0x54,0x49,0x54,0x09,0x54,0x0f,0xff,0x08,0x00,0x0a,0x04,0x0a,0x92,0x0c,0x49,0x08,0x49}}, // 憮
{0x5864,0x9CE2,0xD8E4,0xE6878C,0x61CC,{0x08,0x00,0x09,0xfe,0x09,0x52,0x09,0xfe,0x28,0x20,0x2d,0xfe,0x2a,0x20,0x2b,0xff,0x48,0x84,0x08,0x48,0x09,0xfe,0x08,0x20,0x09,0xfe,0x08,0x20,0x08,0x20,0x08,0x20}}, // 懌
{0x5865,0x9CE3,0xD8E5,0xE6878A,0x61CA,{0x08,0x20,0x08,0x40,0x09,0xfe,0x09,0x1a,0x29,0x62,0x2d,0xaa,0x2b,0xfe,0x29,0x6a,0x49,0xa6,0x09,0x22,0x08,0x20,0x0b,0xff,0x08,0x20,0x08,0x50,0x09,0x8c,0x0e,0x03}}, // 懊
{0x5866,0x9CE4,0xD8E6,0xE68789,0x61C9,{0x00,0x80,0x00,0x80,0x1f,0xff,0x12,0x48,0x12,0xfe,0x15,0x90,0x16,0xfc,0x1c,0x90,0x14,0xfc,0x14,0x90,0x14,0xff,0x15,0x40,0x25,0x22,0x29,0x29,0x51,0x09,0x00,0xf8}}, // 應
{0x5867,0x9CE5,0xD8E7,0xE687B7,0x61F7,{0x08,0x20,0x0b,0xff,0x08,0x00,0x09,0xfe,0x29,0x52,0x2d,0xfe,0x2a,0x20,0x2b,0xae,0x48,0x20,0x0b,0xae,0x08,0x52,0x09,0x94,0x0e,0x88,0x08,0x84,0x08,0xe2,0x0b,0x01}}, // 懷
{0x5868,0x9CE6,0xD8E8,0xE68788,0x61C8,{0x10,0x80,0x10,0xff,0x11,0x29,0x12,0x49,0x37,0xe9,0x3a,0xb3,0x36,0xa4,0x33,0xe4,0x52,0xb4,0x12,0xbf,0x13,0xe4,0x12,0x24,0x12,0x3f,0x12,0x24,0x12,0x24,0x14,0x64}}, // 懈
{0x5869,0x9CE7,0xD8E9,0xE68783,0x61C3,{0x12,0x10,0x7f,0x90,0x12,0x10,0x3f,0x7e,0x25,0x12,0x3f,0x12,0x04,0x12,0x3f,0x12,0x04,0x22,0x07,0x22,0x78,0x42,0x04,0x8c,0x14,0x40,0x14,0x4a,0x22,0x09,0x41,0xf9}}, // 懃
{0x586A,0x9CE8,0xD8EA,0xE68786,0x61C6,{0x08,0x00,0x08,0xf8,0x08,0x88,0x08,0x88,0x0c,0xf8,0x2b,0xde,0x2a,0x52,0x2a,0x52,0x4b,0xde,0x08,0x20,0x0b,0xff,0x08,0x70,0x08,0xa8,0x09,0x24,0x0a,0x23,0x08,0x20}}, // 懆
{0x586B,0x9CE9,0xD8EB,0xE686BA,0x61BA,{0x08,0x20,0x08,0x78,0x08,0x90,0x0b,0xff,0x29,0x2a,0x2d,0x46,0x2b,0xbc,0x29,0x00,0x49,0xff,0x09,0x00,0x09,0x3c,0x09,0x00,0x0a,0x7e,0x0a,0x42,0x0c,0x7e,0x08,0x42}}, // 憺
{0x586C,0x9CEA,0xD8EC,0xE6878B,0x61CB,{0x10,0x04,0x13,0xe4,0x7d,0x5f,0x10,0x84,0x13,0xe4,0x38,0xae,0x35,0xce,0x52,0x95,0x54,0xa4,0x11,0x84,0x00,0x80,0x12,0x44,0x12,0x42,0x22,0x09,0x42,0x09,0x01,0xf8}}, // 懋
{0x586D,0x9CEB,0xD8ED,0xE7BDB9,0x7F79,{0x00,0x00,0x3f,0xfe,0x22,0x22,0x22,0x22,0x3f,0xfe,0x08,0x48,0x08,0x50,0x08,0xff,0x2d,0x90,0x2a,0xfe,0x28,0x90,0x48,0xfe,0x08,0x90,0x08,0x90,0x08,0xff,0x08,0x80}}, // 罹
{0x586E,0x9CEC,0xD8EE,0xE6878D,0x61CD,{0x08,0x10,0x0b,0xff,0x08,0x82,0x08,0xba,0x2c,0xaa,0x2a,0xba,0x2a,0x82,0x28,0xfe,0x48,0x04,0x09,0xf8,0x08,0x10,0x0b,0xff,0x08,0x38,0x08,0xd4,0x0b,0x13,0x08,0x10}}, // 懍
{0x586F,0x9CED,0xD8EF,0xE687A6,0x61E6,{0x10,0x00,0x13,0xfe,0x10,0x10,0x11,0xff,0x31,0x12,0x3a,0xd6,0x34,0x10,0x30,0xd6,0x50,0x00,0x17,0xff,0x10,0x40,0x13,0xfe,0x12,0x52,0x12,0x52,0x12,0x52,0x12,0x06}}, // 懦
{0x5870,0x9CEE,0xD8F0,0xE687A3,0x61E3,{0x20,0x88,0x17,0xff,0x10,0x88,0x00,0xf8,0x40,0x20,0x23,0xfe,0x0a,0xaa,0x0a,0xaa,0x12,0xee,0x23,0x32,0x42,0x26,0x12,0x40,0x12,0x22,0x22,0x09,0x41,0x09,0x00,0xf8}}, // 懣
{0x5871,0x9CEF,0xD8F1,0xE687B6,0x61F6,{0x11,0x00,0x11,0x3e,0x11,0x0a,0x17,0xea,0x39,0x12,0x37,0xe4,0x35,0x7e,0x55,0x62,0x57,0xfe,0x11,0x22,0x13,0xbe,0x13,0x62,0x15,0x3e,0x19,0x14,0x11,0x22,0x11,0xc1}}, // 懶
{0x5872,0x9CF0,0xD8F2,0xE687BA,0x61FA,{0x12,0x48,0x12,0x4c,0x13,0xaa,0x14,0x9a,0x38,0x08,0x37,0xff,0x31,0x48,0x37,0x6a,0x51,0x4a,0x17,0x6a,0x11,0x44,0x17,0x6c,0x11,0x4d,0x11,0xf5,0x17,0x23,0x10,0x41}}, // 懺
{0x5873,0x9CF1,0xD8F3,0xE687B4,0x61F4,{0x10,0x88,0x10,0x8c,0x13,0xea,0x10,0x8a,0x38,0x88,0x37,0xff,0x31,0x48,0x37,0x6a,0x51,0x4a,0x17,0x6a,0x11,0x44,0x17,0x6c,0x11,0x4d,0x11,0xf5,0x17,0x23,0x10,0x41}}, // 懴
{0x5874,0x9CF2,0xD8F4,0xE687BF,0x61FF,{0x08,0x10,0x7f,0x10,0x08,0x9f,0x3e,0x69,0x00,0x0a,0x3f,0x48,0x22,0x94,0x5f,0x22,0x00,0xc1,0x3e,0x10,0x22,0x08,0x3e,0xaa,0x22,0xa1,0x15,0x25,0x1e,0x24,0x60,0x1c}}, // 懿
{0x5875,0x9CF3,0xD8F5,0xE687BD,0x61FD,{0x08,0x88,0x0b,0xff,0x08,0x88,0x0b,0xde,0x2a,0x52,0x2b,0xde,0x2c,0x48,0x2a,0x90,0x49,0xfe,0x0b,0x10,0x09,0xfc,0x09,0x10,0x09,0xfc,0x09,0x10,0x09,0xff,0x09,0x00}}, // 懽
{0x5876,0x9CF4,0xD8F6,0xE687BC,0x61FC,{0x08,0x00,0x0b,0xde,0x0a,0x52,0x0b,0xde,0x2e,0x52,0x2b,0xde,0x2a,0x52,0x2b,0xde,0x48,0x90,0x09,0xfe,0x0b,0x20,0x0d,0xfc,0x09,0xfc,0x09,0x20,0x09,0xff,0x09,0x00}}, // 懼
{0x5877,0x9CF5,0xD8F7,0xE687BE,0x61FE,{0x08,0x00,0x0b,0xfe,0x08,0x88,0x08,0xf8,0x28,0x88,0x2c,0xfe,0x2b,0x88,0x28,0x08,0x4f,0xff,0x0a,0x52,0x0b,0xde,0x0a,0x52,0x0b,0xde,0x0a,0x53,0x0f,0xfe,0x08,0x42}}, // 懾
{0x5878,0x9CF6,0xD8F8,0xE68880,0x6200,{0x13,0xc4,0x10,0x04,0x6b,0xfa,0x10,0x04,0x2b,0xca,0x7c,0x3f,0x17,0xc5,0x30,0x14,0x3b,0xd6,0x56,0x65,0x13,0xc4,0x02,0x40,0x12,0x22,0x12,0x09,0x21,0x09,0x40,0xf8}}, // 戀
{0x5879,0x9CF7,0xD8F9,0xE68888,0x6208,{0x01,0x10,0x01,0x08,0x01,0x08,0x01,0x00,0x7f,0xff,0x01,0x00,0x01,0x08,0x01,0x08,0x00,0x90,0x00,0xa0,0x00,0x40,0x00,0xc0,0x01,0x22,0x06,0x12,0x78,0x0a,0x00,0x06}}, // 戈
{0x587A,0x9CF8,0xD8FA,0xE68889,0x6209,{0x00,0x48,0x00,0x44,0x00,0x44,0x00,0x40,0x1f,0xff,0x10,0x40,0x10,0x44,0x10,0x44,0x10,0x28,0x10,0x28,0x10,0x30,0x13,0x10,0x1c,0x29,0x70,0x45,0x01,0x83,0x0e,0x01}}, // 戉
{0x587B,0x9CF9,0xD8FB,0xE6888D,0x620D,{0x00,0x24,0x00,0x22,0x00,0x22,0x00,0x20,0x1f,0xff,0x10,0x20,0x10,0x20,0x14,0x24,0x12,0x24,0x11,0x18,0x11,0x10,0x10,0x28,0x10,0x49,0x21,0x85,0x26,0x03,0x40,0x01}}, // 戍
{0x587C,0x9CFA,0xD8FC,0xE6888C,0x620C,{0x00,0x24,0x00,0x22,0x00,0x22,0x00,0x20,0x1f,0xff,0x10,0x20,0x10,0x20,0x10,0x24,0x17,0xa4,0x10,0x18,0x10,0x10,0x10,0x28,0x10,0x49,0x21,0x85,0x26,0x03,0x40,0x01}}, // 戌
{0x587D,0x9CFB,0xD8FD,0xE68894,0x6214,{0x04,0x80,0x04,0x40,0x7f,0xfe,0x02,0x10,0x01,0x20,0x00,0xc2,0x07,0x32,0x38,0x0e,0x04,0x40,0x04,0x20,0x7f,0xff,0x02,0x10,0x01,0x20,0x00,0xc2,0x07,0x32,0x38,0x0e}}, // 戔
{0x587E,0x9CFC,0xD8FE,0xE6889B,0x621B,{0x00,0x00,0x7f,0xfe,0x01,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x01,0x04,0x7f,0xff,0x00,0x90,0x00,0x62,0x03,0x9a,0x3c,0x06}}, // 戛
{0x5921,0x9D40,0xD9A1,0xE6889E,0x621E,{0x00,0x00,0x7f,0xfe,0x01,0x00,0x0f,0xf0,0x08,0x10,0x0f,0xf0,0x08,0x10,0x7f,0xfe,0x42,0x22,0x42,0x12,0x3f,0xfc,0x01,0x10,0x00,0xa0,0x00,0xc2,0x03,0x32,0x3c,0x0e}}, // 戞
{0x5922,0x9D41,0xD9A2,0xE688A1,0x6221,{0x11,0x14,0x11,0x12,0x7f,0xd2,0x11,0x10,0x1f,0x17,0x11,0xf8,0x1f,0x12,0x11,0x12,0x11,0x12,0x7f,0xd4,0x2a,0x0c,0x2a,0x08,0x33,0x95,0x20,0x25,0x3f,0xc3,0x20,0x81}}, // 戡
{0x5923,0x9D42,0xD9A3,0xE688AA,0x622A,{0x02,0x10,0x02,0x14,0x3f,0xd2,0x02,0x12,0x02,0x10,0x7f,0xff,0x08,0x90,0x09,0x12,0x1f,0xd2,0x32,0x14,0x5f,0xcc,0x12,0x08,0x1f,0xcd,0x12,0x15,0x1f,0xe3,0x10,0x41}}, // 截
{0x5924,0x9D43,0xD9A4,0xE688AE,0x622E,{0x00,0x14,0x7f,0x92,0x2a,0x92,0x4c,0x90,0x19,0x9f,0x2a,0xf0,0x4c,0x92,0x0c,0x12,0x12,0x12,0x25,0x8c,0x5a,0x0c,0x04,0x08,0x39,0x15,0x02,0x25,0x0c,0x43,0x70,0x81}}, // 戮
{0x5925,0x9D44,0xD9A5,0xE688B0,0x6230,{0x00,0x14,0x7b,0xd2,0x4a,0x52,0x7b,0xd0,0x00,0x1f,0x3f,0xf0,0x24,0x92,0x3f,0x92,0x24,0x94,0x24,0x94,0x3f,0x88,0x04,0x08,0x7f,0x95,0x04,0x23,0x04,0x43,0x04,0x81}}, // 戰
{0x5926,0x9D45,0xD9A6,0xE688B2,0x6232,{0x02,0x14,0x03,0xd2,0x02,0x12,0x1f,0xf0,0x12,0x3f,0x1f,0xd0,0x12,0x12,0x11,0xd2,0x1f,0xd2,0x10,0x14,0x17,0xcc,0x14,0x48,0x27,0xcd,0x22,0x95,0x41,0xe3,0x0e,0x41}}, // 戲
{0x5927,0x9D46,0xD9A7,0xE688B3,0x6233,{0x00,0x14,0x7b,0xd2,0x29,0x52,0x5a,0xd0,0x29,0x57,0x4a,0x78,0x11,0x12,0x12,0x12,0x3f,0x94,0x64,0x14,0x3f,0x88,0x24,0x09,0x3f,0x95,0x24,0x25,0x3f,0xc3,0x00,0x81}}, // 戳
{0x5928,0x9D47,0xD9A8,0xE68981,0x6241,{0x00,0x00,0x7f,0xff,0x00,0x00,0x1f,0xfc,0x10,0x04,0x10,0x04,0x1f,0xfc,0x10,0x00,0x1f,0xfc,0x19,0x24,0x19,0x24,0x1f,0xfc,0x29,0x24,0x29,0x24,0x49,0x24,0x09,0x2c}}, // 扁
{0x5929,0x9D48,0xD9A9,0xE6898E,0x624E,{0x08,0x40,0x08,0x40,0x08,0x40,0x08,0x40,0x7f,0x40,0x08,0x40,0x08,0x40,0x08,0x40,0x0b,0x40,0x1c,0x40,0x68,0x40,0x08,0x41,0x08,0x41,0x08,0x21,0x08,0x1f,0x18,0x00}}, // 扎
{0x592A,0x9D49,0xD9AA,0xE6899E,0x625E,{0x08,0x00,0x08,0xfe,0x08,0x10,0x08,0x10,0x7e,0x10,0x08,0x10,0x08,0x10,0x09,0xff,0x0e,0x10,0x18,0x10,0x68,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x18,0x10}}, // 扞
{0x592B,0x9D4A,0xD9AB,0xE689A3,0x6263,{0x10,0x00,0x11,0xfe,0x11,0x02,0x11,0x02,0x7d,0x02,0x11,0x02,0x11,0x02,0x11,0x02,0x11,0x02,0x1d,0x02,0x71,0x02,0x11,0x02,0x11,0x02,0x11,0x02,0x31,0xfe,0x11,0x02}}, // 扣
{0x592C,0x9D4B,0xD9AC,0xE6899B,0x625B,{0x08,0x00,0x08,0x00,0x09,0xfe,0x08,0x20,0x7e,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x0e,0x20,0x18,0x20,0x68,0x20,0x08,0x20,0x08,0x20,0x0b,0xff,0x18,0x00,0x08,0x00}}, // 扛
{0x592D,0x9D4C,0xD9AD,0xE689A0,0x6260,{0x10,0x00,0x13,0xfc,0x10,0x04,0x11,0x04,0x7d,0x44,0x11,0x24,0x10,0xa8,0x10,0x88,0x1c,0x48,0x70,0x50,0x10,0x30,0x10,0x30,0x10,0x48,0x10,0x84,0x33,0x02,0x1c,0x01}}, // 扠
{0x592E,0x9D4D,0xD9AE,0xE689A8,0x6268,{0x10,0x00,0x13,0xfc,0x10,0x44,0x10,0x44,0x7c,0x44,0x10,0x44,0x11,0x44,0x10,0xc4,0x1c,0x44,0x70,0x64,0x10,0x5c,0x10,0x87,0x10,0x84,0x11,0x04,0x32,0x08,0x14,0x30}}, // 扨
{0x592F,0x9D4E,0xD9AF,0xE689BC,0x627C,{0x10,0x00,0x11,0xff,0x11,0x00,0x11,0x00,0x7d,0x7c,0x11,0x44,0x11,0x44,0x11,0x44,0x1d,0x44,0x71,0x58,0x11,0x40,0x11,0x42,0x12,0x42,0x12,0x42,0x34,0x22,0x10,0x1e}}, // 扼
{0x5930,0x9D4F,0xD9B0,0xE68A82,0x6282,{0x10,0x00,0x13,0xfe,0x10,0x20,0x10,0x20,0x7c,0x20,0x10,0x20,0x10,0x20,0x11,0xfc,0x1c,0x20,0x70,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x37,0xff,0x10,0x00}}, // 抂
{0x5931,0x9D50,0xD9B1,0xE68A89,0x6289,{0x10,0x40,0x10,0x40,0x10,0x40,0x13,0xfc,0x7c,0x44,0x10,0x44,0x10,0x44,0x10,0x44,0x1f,0xff,0x70,0x40,0x10,0x60,0x10,0xa0,0x10,0x90,0x11,0x08,0x32,0x04,0x14,0x02}}, // 抉
{0x5932,0x9D51,0xD9B2,0xE689BE,0x627E,{0x10,0x48,0x10,0x44,0x10,0x44,0x10,0x40,0x7f,0xff,0x10,0x40,0x10,0x44,0x10,0x44,0x1c,0x48,0x70,0x28,0x10,0x30,0x10,0x22,0x10,0x52,0x11,0x8a,0x36,0x06,0x10,0x02}}, // 找
{0x5933,0x9D52,0xD9B3,0xE68A92,0x6292,{0x10,0x00,0x11,0xfc,0x10,0x04,0x10,0xc8,0x7c,0x30,0x10,0x10,0x17,0xff,0x10,0x22,0x1c,0x24,0x70,0x28,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x30,0xe0,0x10,0x20}}, // 抒
{0x5934,0x9D53,0xD9B4,0xE68A93,0x6293,{0x10,0x04,0x10,0x18,0x11,0xe8,0x11,0x08,0x7d,0x28,0x11,0x28,0x11,0x28,0x11,0x28,0x11,0x28,0x1d,0x28,0x71,0x28,0x11,0x28,0x12,0x24,0x12,0x24,0x34,0x22,0x18,0x01}}, // 抓
{0x5935,0x9D54,0xD9B5,0xE68A96,0x6296,{0x08,0x04,0x08,0x44,0x08,0x24,0x08,0x24,0x7e,0x04,0x08,0x04,0x08,0x84,0x08,0x44,0x0e,0x44,0x18,0x07,0x68,0x3c,0x09,0xc4,0x08,0x04,0x08,0x04,0x18,0x04,0x08,0x04}}, // 抖
{0x5936,0x9D55,0xD9B6,0xE68B94,0x62D4,{0x10,0x48,0x10,0x44,0x10,0x44,0x13,0xff,0x7c,0x40,0x10,0x44,0x10,0x44,0x10,0x44,0x1c,0xa8,0x70,0xa8,0x11,0x10,0x11,0x10,0x12,0x28,0x14,0x44,0x30,0x82,0x11,0x01}}, // 拔
{0x5937,0x9D56,0xD9B7,0xE68A83,0x6283,{0x08,0x20,0x08,0x20,0x0b,0xff,0x08,0x20,0x7e,0x20,0x08,0x20,0x08,0x30,0x08,0x28,0x0e,0x24,0x78,0x24,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x18,0x20,0x08,0x20}}, // 抃
{0x5938,0x9D57,0xD9B8,0xE68A94,0x6294,{0x10,0x00,0x17,0xff,0x10,0x20,0x10,0x20,0x7c,0x20,0x10,0x40,0x10,0x50,0x10,0xc8,0x1c,0xc4,0x71,0x42,0x12,0x42,0x14,0x40,0x10,0x40,0x10,0x40,0x30,0x40,0x10,0x40}}, // 抔
{0x5939,0x9D58,0xD9B9,0xE68B97,0x62D7,{0x10,0x88,0x10,0x88,0x10,0x88,0x10,0x88,0x7d,0x3e,0x11,0x4a,0x16,0x4a,0x11,0x4a,0x1c,0x8a,0x70,0x8a,0x11,0x92,0x11,0x52,0x12,0x52,0x1f,0xa2,0x30,0x42,0x10,0x8c}}, // 拗
{0x593A,0x9D59,0xD9BA,0xE68B91,0x62D1,{0x10,0x84,0x10,0x84,0x10,0x84,0x13,0xff,0x7c,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x1c,0xfc,0x70,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x10,0x84,0x30,0xfc,0x10,0x84}}, // 拑
{0x593B,0x9D5A,0xD9BB,0xE68ABB,0x62BB,{0x10,0x20,0x10,0x20,0x10,0x20,0x11,0xfe,0x7d,0x22,0x11,0x22,0x11,0x22,0x11,0xfe,0x1d,0x22,0x71,0x22,0x11,0xfe,0x11,0x22,0x10,0x20,0x10,0x20,0x30,0x20,0x10,0x20}}, // 抻
{0x593C,0x9D5B,0xD9BC,0xE68B8F,0x62CF,{0x04,0x00,0x04,0x00,0x7f,0x7e,0x09,0x22,0x11,0x14,0x3e,0x08,0x05,0x34,0x19,0xc3,0x60,0x10,0x0f,0xe0,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x80,0x01,0x80}}, // 拏
{0x593D,0x9D5C,0xD9BD,0xE68BBF,0x62FF,{0x00,0x80,0x01,0x40,0x02,0x20,0x07,0xf0,0x18,0x0c,0x6f,0xfb,0x08,0x08,0x0f,0xf8,0x00,0x10,0x0f,0xe0,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x80,0x01,0x80}}, // 拿
{0x593E,0x9D5D,0xD9BE,0xE68B86,0x62C6,{0x10,0x02,0x10,0x0c,0x10,0xf0,0x10,0x80,0x7c,0x80,0x10,0xff,0x10,0x88,0x10,0x88,0x1c,0xb8,0x70,0x8e,0x10,0x89,0x10,0x88,0x11,0x08,0x11,0x08,0x32,0x08,0x10,0x08}}, // 拆
{0x593F,0x9D5E,0xD9BF,0xE69394,0x64D4,{0x10,0x40,0x10,0xf8,0x11,0x10,0x13,0xff,0x7e,0x48,0x12,0x47,0x12,0xbc,0x13,0x00,0x1f,0xff,0x72,0x00,0x12,0x7c,0x12,0x00,0x14,0xfe,0x14,0x82,0x38,0xfe,0x10,0x82}}, // 擔
{0x5940,0x9D5F,0xD9C0,0xE68B88,0x62C8,{0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x20,0x7e,0x3f,0x08,0x20,0x08,0x20,0x08,0x20,0x0e,0x20,0x19,0xfc,0x69,0x04,0x09,0x04,0x09,0x04,0x09,0x04,0x19,0xfc,0x09,0x04}}, // 拈
{0x5941,0x9D60,0xD9C1,0xE68B9C,0x62DC,{0x02,0x00,0x0d,0xff,0x78,0x10,0x08,0x10,0x08,0xfe,0x7e,0x10,0x08,0x10,0x08,0xfe,0x0e,0x10,0x18,0x10,0x68,0x10,0x09,0xff,0x10,0x10,0x10,0x10,0x20,0x10,0x40,0x10}}, // 拜
{0x5942,0x9D61,0xD9C2,0xE68B8C,0x62CC,{0x10,0x20,0x10,0xa8,0x10,0xa4,0x11,0x22,0x7e,0x22,0x11,0xfc,0x10,0x20,0x10,0x20,0x1c,0x20,0x73,0xff,0x10,0x20,0x10,0x20,0x10,0x20,0x10,0x20,0x30,0x20,0x10,0x20}}, // 拌
{0x5943,0x9D62,0xD9C3,0xE68B8A,0x62CA,{0x10,0x84,0x10,0x84,0x10,0x84,0x11,0x04,0x7d,0x7f,0x13,0x04,0x13,0x04,0x15,0x44,0x11,0x24,0x1d,0x24,0x71,0x04,0x11,0x04,0x11,0x04,0x11,0x04,0x31,0x0c,0x11,0x04}}, // 拊
{0x5944,0x9D63,0xD9C4,0xE68B82,0x62C2,{0x10,0x50,0x10,0x50,0x13,0xfe,0x10,0x52,0x7c,0x52,0x13,0xfe,0x12,0x50,0x12,0x50,0x1b,0xfe,0x70,0x52,0x10,0x52,0x10,0x92,0x10,0x92,0x11,0x1c,0x32,0x10,0x14,0x10}}, // 拂
{0x5945,0x9D64,0xD9C5,0xE68B87,0x62C7,{0x10,0x00,0x11,0xfc,0x11,0x04,0x11,0x44,0x7d,0x24,0x11,0x24,0x11,0x04,0x17,0xff,0x12,0x04,0x1e,0x44,0x72,0x24,0x12,0x24,0x13,0xff,0x10,0x04,0x30,0x08,0x10,0x30}}, // 拇
{0x5946,0x9D65,0xD9C6,0xE68A9B,0x629B,{0x12,0x10,0x12,0x10,0x12,0x10,0x12,0x7e,0x7f,0x92,0x12,0x92,0x12,0x92,0x12,0x92,0x1a,0x92,0x72,0xa2,0x12,0xa2,0x12,0xc2,0x14,0x8c,0x14,0x81,0x38,0x41,0x10,0x3f}}, // 抛
{0x5947,0x9D66,0xD9C7,0xE68B89,0x62C9,{0x10,0x20,0x10,0x20,0x10,0x20,0x13,0xfe,0x7c,0x00,0x10,0x08,0x11,0x08,0x11,0x08,0x1c,0x88,0x70,0x88,0x10,0x90,0x10,0x90,0x10,0x10,0x10,0x20,0x37,0xff,0x10,0x00}}, // 拉
{0x5948,0x9D67,0xD9C8,0xE68C8C,0x630C,{0x10,0x40,0x10,0x40,0x10,0x7c,0x10,0x84,0x7c,0x88,0x11,0x50,0x12,0x20,0x10,0x50,0x19,0x8c,0x76,0x03,0x11,0xfc,0x11,0x04,0x11,0x04,0x11,0x04,0x31,0xfc,0x11,0x04}}, // 挌
{0x5949,0x9D68,0xD9C9,0xE68BAE,0x62EE,{0x10,0x20,0x10,0x20,0x10,0x20,0x13,0xff,0x7c,0x20,0x10,0x20,0x10,0x20,0x11,0xfe,0x1c,0x00,0x70,0x00,0x11,0xfc,0x11,0x04,0x11,0x04,0x11,0x04,0x31,0xfc,0x11,0x04}}, // 拮
{0x594A,0x9D69,0xD9CA,0xE68BB1,0x62F1,{0x10,0x88,0x10,0x88,0x10,0x88,0x10,0x88,0x7b,0xfe,0x10,0x88,0x10,0x88,0x10,0x88,0x1c,0x88,0x70,0x88,0x17,0xff,0x10,0x00,0x10,0x88,0x10,0x84,0x31,0x02,0x12,0x02}}, // 拱
{0x594B,0x9D6A,0xD9CB,0xE68CA7,0x6327,{0x10,0x00,0x17,0xfe,0x10,0x42,0x10,0xc6,0x7c,0xc6,0x11,0x4a,0x12,0x52,0x14,0x62,0x1c,0xc6,0x70,0xc6,0x11,0x4a,0x12,0x52,0x14,0x62,0x10,0x42,0x30,0xc6,0x10,0x42}}, // 挧
{0x594C,0x9D6B,0xD9CC,0xE68C82,0x6302,{0x10,0x20,0x10,0x20,0x11,0xfc,0x7c,0x20,0x10,0x20,0x10,0x20,0x13,0xfe,0x10,0x00,0x1c,0x20,0x70,0x20,0x11,0xfc,0x10,0x20,0x10,0x20,0x10,0x20,0x37,0xff,0x10,0x00}}, // 挂
{0x594D,0x9D6C,0xD9CD,0xE68C88,0x6308,{0x04,0x00,0x07,0x7e,0x7c,0x12,0x07,0x12,0x3c,0x12,0x05,0xa2,0x0e,0x42,0x74,0x8c,0x00,0x10,0x07,0xe0,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x80,0x01,0x80}}, // 挈
{0x594E,0x9D6D,0xD9CE,0xE68BAF,0x62EF,{0x10,0x00,0x13,0xfc,0x10,0x08,0x10,0x10,0x7c,0x22,0x13,0xa2,0x10,0xb4,0x10,0xb4,0x1d,0x28,0x71,0x24,0x12,0x22,0x14,0x21,0x10,0x60,0x10,0x00,0x37,0xff,0x10,0x00}}, // 拯
{0x594F,0x9D6E,0xD9CF,0xE68BB5,0x62F5,{0x10,0x20,0x10,0x20,0x10,0x20,0x13,0xff,0x7c,0x40,0x10,0x40,0x10,0x7e,0x10,0x84,0x1d,0x88,0x71,0x08,0x13,0x7f,0x15,0x08,0x11,0x08,0x11,0x08,0x31,0x18,0x11,0x08}}, // 拵
{0x5950,0x9D6F,0xD9D0,0xE68D90,0x6350,{0x10,0x00,0x11,0xfc,0x11,0x04,0x11,0x04,0x7d,0xfc,0x10,0x00,0x11,0xfc,0x11,0x04,0x1d,0x04,0x71,0xfc,0x11,0x04,0x11,0x04,0x11,0xfc,0x11,0x04,0x31,0x0c,0x11,0x04}}, // 捐
{0x5951,0x9D70,0xD9D1,0xE68CBE,0x633E,{0x10,0x20,0x10,0x20,0x17,0xff,0x10,0x20,0x7d,0x24,0x11,0x24,0x11,0x24,0x11,0xaa,0x1e,0x6a,0x72,0x31,0x14,0x50,0x10,0x50,0x10,0x88,0x11,0x04,0x32,0x02,0x14,0x01}}, // 挾
{0x5952,0x9D71,0xD9D2,0xE68D8D,0x634D,{0x10,0x00,0x11,0xfc,0x11,0x04,0x11,0xfc,0x7d,0x04,0x11,0x04,0x11,0xfc,0x10,0x00,0x1b,0xfe,0x70,0x20,0x10,0x20,0x17,0xff,0x10,0x20,0x10,0x20,0x30,0x20,0x10,0x20}}, // 捍
{0x5953,0x9D72,0xD9D3,0xE6909C,0x641C,{0x10,0x20,0x10,0x60,0x11,0xae,0x11,0x22,0x7d,0x22,0x11,0xae,0x11,0x22,0x11,0x22,0x1d,0xfe,0x70,0x20,0x13,0xfe,0x10,0x84,0x10,0x48,0x10,0x30,0x30,0xcc,0x17,0x03}}, // 搜
{0x5954,0x9D73,0xD9D4,0xE68D8F,0x634F,{0x10,0x00,0x11,0xfc,0x11,0x04,0x11,0x04,0x7d,0xfc,0x11,0x04,0x11,0x04,0x11,0xfc,0x1d,0x24,0x70,0x20,0x13,0xfe,0x10,0x20,0x10,0x20,0x10,0x20,0x37,0xff,0x10,0x00}}, // 捏
{0x5955,0x9D74,0xD9D5,0xE68E96,0x6396,{0x10,0x20,0x10,0x20,0x17,0xff,0x10,0x90,0x7c,0x90,0x10,0x9c,0x11,0x24,0x11,0x34,0x1f,0x2c,0x73,0x44,0x15,0xa8,0x11,0x18,0x11,0x18,0x11,0x24,0x31,0x42,0x11,0x81}}, // 掖
{0x5956,0x9D75,0xD9D6,0xE68E8E,0x638E,{0x10,0x20,0x10,0x20,0x13,0xfe,0x10,0x30,0x7c,0x48,0x11,0x84,0x10,0x00,0x17,0xff,0x1c,0x04,0x71,0xe4,0x11,0x24,0x11,0x24,0x11,0xe4,0x11,0x24,0x30,0x0c,0x10,0x04}}, // 掎
{0x5957,0x9D76,0xD9D7,0xE68E80,0x6380,{0x10,0x48,0x10,0x88,0x13,0x08,0x12,0x1f,0x7e,0x11,0x13,0xfa,0x12,0x5c,0x12,0x68,0x1e,0x48,0x72,0x48,0x12,0x54,0x12,0x54,0x12,0x54,0x12,0x62,0x34,0x62,0x10,0x41}}, // 掀
{0x5958,0x9D77,0xD9D8,0xE68EAB,0x63AB,{0x10,0x00,0x17,0xff,0x12,0x40,0x12,0x40,0x7e,0x7e,0x13,0xc2,0x12,0x52,0x12,0x54,0x1f,0xd4,0x72,0x4c,0x12,0x48,0x12,0x4c,0x13,0xd4,0x16,0x54,0x30,0x62,0x10,0x41}}, // 掫
{0x5959,0x9D78,0xD9D9,0xE68DB6,0x6376,{0x10,0x04,0x10,0x18,0x13,0xe0,0x10,0x20,0x7f,0xfe,0x11,0x24,0x11,0x24,0x17,0xff,0x19,0x24,0x71,0x24,0x11,0x24,0x13,0xfe,0x10,0x20,0x10,0x20,0x37,0xff,0x10,0x00}}, // 捶
{0x595A,0x9D79,0xD9DA,0xE68EA3,0x63A3,{0x14,0x02,0x1f,0x12,0x24,0x12,0x7f,0x92,0x04,0x12,0x3f,0x92,0x24,0x82,0x25,0x82,0x20,0x16,0x07,0xe0,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x80,0x01,0x80}}, // 掣
{0x595B,0x9D7A,0xD9DB,0xE68E8F,0x638F,{0x11,0x00,0x11,0x00,0x11,0xfe,0x11,0x02,0x7e,0x82,0x12,0xfa,0x15,0x42,0x12,0x42,0x1f,0xfe,0x70,0x42,0x11,0x4a,0x11,0x4a,0x11,0xfa,0x11,0x0a,0x30,0x04,0x10,0x18}}, // 掏
{0x595C,0x9D7B,0xD9DC,0xE68E89,0x6389,{0x10,0x20,0x10,0x20,0x10,0x3e,0x10,0x20,0x7d,0xfc,0x11,0x04,0x11,0x04,0x11,0xfc,0x1d,0x04,0x71,0x04,0x11,0xfc,0x10,0x20,0x17,0xff,0x10,0x20,0x30,0x20,0x10,0x20}}, // 掉
{0x595D,0x9D7C,0xD9DD,0xE68E9F,0x639F,{0x10,0x20,0x10,0x20,0x11,0xff,0x11,0x02,0x7e,0x00,0x11,0xfc,0x10,0x20,0x10,0x20,0x1d,0x20,0x71,0x3e,0x11,0x20,0x11,0x20,0x11,0x20,0x12,0xa0,0x32,0x60,0x14,0x1f}}, // 掟
{0x595E,0x9D7D,0xD9DE,0xE68EB5,0x63B5,{0x10,0x20,0x10,0x20,0x10,0x50,0x10,0x88,0x7d,0x04,0x12,0xfa,0x14,0x01,0x10,0x00,0x1f,0xde,0x72,0x52,0x12,0x52,0x12,0x52,0x13,0xd2,0x12,0x5c,0x30,0x10,0x10,0x10}}, // 掵
{0x595F,0x9D7E,0xD9DF,0xE68DAB,0x636B,{0x10,0x00,0x13,0xde,0x12,0x52,0x13,0xde,0x7e,0x52,0x12,0x52,0x13,0xde,0x12,0x02,0x1e,0x02,0x72,0x02,0x12,0x02,0x12,0x02,0x12,0x02,0x12,0x02,0x32,0x06,0x12,0x02}}, // 捫
{0x5960,0x9D80,0xD9E0,0xE68DA9,0x6369,{0x10,0x00,0x13,0xff,0x10,0x00,0x11,0xfe,0x7d,0x02,0x11,0x02,0x11,0xfe,0x11,0x12,0x1d,0x10,0x71,0xff,0x11,0x10,0x12,0x28,0x12,0x28,0x14,0x44,0x38,0x82,0x13,0x01}}, // 捩
{0x5961,0x9D81,0xD9E1,0xE68EBE,0x63BE,{0x10,0x40,0x10,0x7c,0x10,0x88,0x11,0xf8,0x7c,0x10,0x13,0xff,0x10,0x40,0x10,0xaa,0x1b,0x2a,0x70,0x5c,0x10,0x94,0x13,0x34,0x10,0x52,0x10,0x91,0x33,0x10,0x10,0x60}}, // 掾
{0x5962,0x9D82,0xD9E2,0xE68FA9,0x63E9,{0x11,0x10,0x11,0x10,0x11,0x12,0x11,0xdc,0x7d,0x10,0x11,0x11,0x11,0xcf,0x17,0x20,0x18,0x40,0x71,0xfc,0x11,0x04,0x11,0xfc,0x11,0x04,0x11,0x04,0x31,0xfc,0x11,0x04}}, // 揩
{0x5963,0x9D83,0xD9E3,0xE68F80,0x63C0,{0x10,0x20,0x10,0x20,0x17,0xff,0x10,0x20,0x7d,0xfc,0x11,0x24,0x11,0xac,0x11,0x74,0x1d,0x24,0x71,0xfc,0x10,0x70,0x10,0xa8,0x11,0x24,0x16,0x23,0x30,0x20,0x10,0x20}}, // 揀
{0x5964,0x9D84,0xD9E4,0xE68F86,0x63C6,{0x10,0x10,0x11,0xd4,0x10,0x58,0x12,0x4a,0x7d,0x8c,0x10,0x84,0x11,0x02,0x13,0xfd,0x1c,0x20,0x70,0x20,0x17,0xff,0x10,0x20,0x10,0x30,0x10,0x48,0x31,0x84,0x16,0x03}}, // 揆
{0x5965,0x9D85,0xD9E5,0xE68FA3,0x63E3,{0x10,0x20,0x11,0x22,0x11,0x22,0x11,0x22,0x7d,0xfe,0x10,0x00,0x13,0xff,0x10,0x20,0x1c,0x40,0x73,0xfe,0x12,0x52,0x12,0x52,0x12,0x52,0x12,0x52,0x32,0x52,0x12,0x06}}, // 揣
{0x5966,0x9D86,0xD9E6,0xE68F89,0x63C9,{0x10,0x00,0x11,0xfc,0x10,0xc8,0x10,0x30,0x7f,0xff,0x10,0x32,0x10,0x54,0x11,0x90,0x1e,0x30,0x70,0x20,0x13,0xff,0x10,0x70,0x10,0xa8,0x11,0x24,0x36,0x23,0x10,0x20}}, // 揉
{0x5967,0x9D87,0xD9E7,0xE68F92,0x63D2,{0x10,0x04,0x10,0x38,0x11,0xe0,0x10,0x20,0x7c,0x20,0x13,0xff,0x10,0x20,0x10,0xa0,0x1f,0x2e,0x72,0x22,0x12,0x22,0x13,0xae,0x12,0x22,0x12,0x22,0x33,0xfe,0x12,0x02}}, // 插
{0x5968,0x9D88,0xD9E8,0xE68FB6,0x63F6,{0x10,0x00,0x17,0xfe,0x12,0x52,0x12,0x52,0x7e,0x54,0x13,0xd8,0x12,0x54,0x12,0x52,0x1b,0xd2,0x72,0x51,0x12,0x51,0x12,0x59,0x13,0xd6,0x16,0x50,0x30,0x50,0x10,0x50}}, // 揶
{0x5969,0x9D89,0xD9E9,0xE68F84,0x63C4,{0x10,0xe0,0x10,0x20,0x10,0x50,0x7c,0x88,0x11,0xf6,0x12,0x01,0x17,0xd2,0x12,0x52,0x1f,0x52,0x72,0xe4,0x12,0x64,0x13,0x64,0x12,0xd2,0x12,0x52,0x32,0x52,0x12,0xd2}}, // 揄
{0x596A,0x9D8A,0xD9EA,0xE69096,0x6416,{0x10,0x20,0x10,0x7c,0x10,0xc4,0x13,0x28,0x7c,0x90,0x10,0x60,0x11,0x80,0x16,0xfc,0x19,0x20,0x72,0x20,0x17,0xff,0x10,0x20,0x12,0x24,0x12,0x24,0x33,0xfc,0x12,0x04}}, // 搖
{0x596B,0x9D8B,0xD9EB,0xE690B4,0x6434,{0x00,0x80,0x3f,0xff,0x22,0x22,0x2f,0xf8,0x42,0x20,0x0f,0xf8,0x02,0x20,0x7f,0xff,0x04,0x30,0x1b,0xcc,0x60,0x83,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x00,0x80,0x01,0x80}}, // 搴
{0x596C,0x9D8C,0xD9EC,0xE69086,0x6406,{0x10,0x88,0x10,0x88,0x13,0xfe,0x10,0x88,0x7d,0xfe,0x10,0x88,0x17,0xff,0x10,0x20,0x1d,0xfc,0x71,0x24,0x11,0xfc,0x11,0x24,0x17,0xff,0x11,0x04,0x31,0x04,0x11,0x0c}}, // 搆
{0x596D,0x9D8D,0xD9ED,0xE69093,0x6413,{0x11,0x04,0x10,0x88,0x13,0xfe,0x10,0x20,0x7c,0x20,0x11,0xfc,0x10,0x20,0x1f,0xff,0x10,0x40,0x70,0x40,0x10,0xfe,0x11,0x10,0x12,0x10,0x1c,0x10,0x31,0xff,0x10,0x00}}, // 搓
{0x596E,0x9D8E,0xD9EE,0xE690A6,0x6426,{0x10,0x00,0x17,0xde,0x10,0x42,0x7c,0x42,0x13,0xde,0x12,0x10,0x12,0x10,0x13,0xde,0x1c,0xc6,0x71,0x4a,0x12,0x52,0x10,0xc6,0x11,0x4a,0x12,0x52,0x30,0x82,0x13,0x0c}}, // 搦
{0x596F,0x9D8F,0xD9EF,0xE690B6,0x6436,{0x10,0x20,0x10,0x20,0x10,0x50,0x7c,0x88,0x11,0xfc,0x12,0x02,0x15,0xfd,0x11,0x04,0x1d,0xfc,0x71,0x04,0x11,0xfc,0x11,0x00,0x12,0xfe,0x12,0x82,0x34,0xfe,0x10,0x82}}, // 搶
{0x5970,0x9D90,0xD9F0,0xE6949D,0x651D,{0x10,0x00,0x13,0xfe,0x10,0x88,0x7c,0xf8,0x10,0x88,0x10,0xfe,0x13,0x88,0x10,0x08,0x1f,0xff,0x72,0x52,0x13,0xde,0x12,0x52,0x13,0xde,0x12,0x53,0x37,0xfe,0x10,0x42}}, // 攝
{0x5971,0x9D91,0xD9F1,0xE69097,0x6417,{0x10,0x20,0x10,0x40,0x11,0xf8,0x11,0x08,0x7d,0xf8,0x11,0x08,0x11,0xf8,0x11,0x00,0x1d,0xff,0x71,0x00,0x11,0xfe,0x14,0x82,0x14,0x92,0x17,0xf2,0x34,0x12,0x10,0x0c}}, // 搗
{0x5972,0x9D92,0xD9F2,0xE690A8,0x6428,{0x10,0x00,0x11,0xfc,0x11,0x04,0x11,0xfc,0x7d,0x04,0x11,0xfc,0x10,0x00,0x13,0xde,0x1c,0xc6,0x71,0x4a,0x16,0x72,0x10,0xc6,0x11,0x4a,0x16,0x72,0x30,0x42,0x10,0xc6}}, // 搨
{0x5973,0x9D93,0xD9F3,0xE6908F,0x640F,{0x10,0x24,0x10,0x22,0x13,0xff,0x10,0x20,0x7d,0xfc,0x11,0x24,0x11,0xfc,0x11,0x24,0x1d,0xfc,0x71,0x24,0x11,0x2c,0x10,0x08,0x17,0xff,0x11,0x08,0x30,0x88,0x10,0x18}}, // 搏
{0x5974,0x9D94,0xD9F4,0xE691A7,0x6467,{0x10,0x20,0x11,0x22,0x11,0x22,0x11,0xfe,0x7c,0x88,0x10,0x90,0x11,0xfe,0x13,0x10,0x1d,0x10,0x71,0xfe,0x11,0x10,0x11,0xfe,0x11,0x10,0x11,0x10,0x31,0xff,0x11,0x00}}, // 摧
{0x5975,0x9D95,0xD9F5,0xE691AF,0x646F,{0x04,0x10,0x3f,0x10,0x04,0x7c,0x7f,0x94,0x12,0x54,0x7f,0x24,0x04,0x55,0x3f,0x95,0x04,0x33,0x07,0xc0,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x80,0x01,0x80}}, // 摯
{0x5976,0x9D96,0xD9F6,0xE691B6,0x6476,{0x10,0x28,0x10,0x24,0x13,0xff,0x10,0x20,0x7d,0xfc,0x11,0x24,0x11,0xfc,0x11,0x24,0x1d,0xfc,0x71,0x24,0x11,0x24,0x10,0x08,0x17,0xff,0x11,0x08,0x30,0x88,0x10,0x18}}, // 摶
{0x5977,0x9D97,0xD9F7,0xE6918E,0x644E,{0x10,0x00,0x13,0xde,0x11,0x4a,0x12,0x52,0x7c,0xc6,0x11,0x4a,0x16,0x72,0x10,0x56,0x1c,0x88,0x71,0x24,0x16,0x4b,0x11,0x90,0x10,0x64,0x13,0x88,0x30,0x30,0x13,0xc0}}, // 摎
{0x5978,0x9D98,0xD9F8,0xE694AA,0x652A,{0x10,0x40,0x11,0xdc,0x11,0x24,0x11,0xdc,0x7d,0x24,0x11,0xdc,0x17,0xff,0x14,0x02,0x19,0xfc,0x71,0x04,0x11,0xfc,0x11,0x04,0x11,0xfc,0x10,0x50,0x31,0x91,0x16,0x0f}}, // 攪
{0x5979,0x9D99,0xD9F9,0xE69295,0x6495,{0x12,0x42,0x12,0x44,0x17,0xf8,0x12,0x50,0x7a,0x50,0x13,0xdf,0x12,0x52,0x12,0x52,0x1b,0xd2,0x72,0x52,0x12,0x52,0x17,0xf2,0x10,0x92,0x12,0x62,0x32,0x42,0x14,0x02}}, // 撕
{0x597A,0x9D9A,0xD9FA,0xE69293,0x6493,{0x10,0x20,0x10,0xf8,0x10,0x20,0x13,0xfe,0x7c,0x00,0x10,0x84,0x13,0xff,0x10,0x84,0x1c,0xe4,0x73,0x9f,0x10,0x00,0x13,0xff,0x10,0x48,0x10,0x49,0x30,0x89,0x17,0x07}}, // 撓
{0x597B,0x9D9B,0xD9FB,0xE692A5,0x64A5,{0x10,0x12,0x13,0xd4,0x10,0x59,0x10,0x8a,0x7c,0x8c,0x11,0x04,0x13,0xba,0x14,0xa9,0x10,0xaa,0x77,0xc6,0x14,0x7c,0x17,0xa4,0x10,0xa8,0x10,0x98,0x30,0xa4,0x13,0x43}}, // 撥
{0x597C,0x9D9C,0xD9FC,0xE692A9,0x64A9,{0x10,0x20,0x10,0x20,0x13,0xff,0x10,0x50,0x7d,0x4a,0x10,0x84,0x11,0xfe,0x13,0x05,0x1d,0xfc,0x71,0x04,0x11,0xfc,0x10,0x28,0x10,0xa4,0x11,0x22,0x32,0x22,0x10,0x60}}, // 撩
{0x597D,0x9D9D,0xD9FD,0xE69288,0x6488,{0x10,0x88,0x12,0xaa,0x12,0xaa,0x14,0x8c,0x7d,0x54,0x11,0x22,0x12,0x01,0x13,0xff,0x1a,0x02,0x74,0x40,0x13,0xfc,0x10,0x44,0x10,0x44,0x10,0x84,0x31,0x04,0x16,0x18}}, // 撈
{0x597E,0x9D9E,0xD9FE,0xE692BC,0x64BC,{0x10,0x14,0x10,0x12,0x13,0xff,0x12,0x10,0x7b,0xf2,0x12,0x0a,0x12,0xec,0x12,0xac,0x1e,0xf5,0x72,0x23,0x14,0xd1,0x11,0x08,0x11,0x4a,0x12,0x41,0x34,0x45,0x10,0x3c}}, // 撼
{0x5A21,0x9D9F,0xDAA1,0xE6939A,0x64DA,{0x10,0x20,0x10,0x3e,0x10,0x20,0x13,0xff,0x7e,0x4a,0x13,0xf0,0x12,0x44,0x12,0x3c,0x1f,0xff,0x72,0x62,0x13,0xb4,0x12,0x58,0x15,0xb4,0x14,0x52,0x1b,0x91,0x30,0x30}}, // 據
{0x5A22,0x9DA0,0xDAA2,0xE69392,0x64D2,{0x10,0x20,0x10,0x20,0x10,0x50,0x7d,0xac,0x17,0xff,0x11,0x54,0x11,0x24,0x11,0x54,0x1d,0xfc,0x70,0x20,0x13,0xfe,0x12,0x22,0x12,0x5a,0x13,0xf6,0x12,0x02,0x32,0x06}}, // 擒
{0x5A23,0x9DA1,0xDAA3,0xE69385,0x64C5,{0x10,0x20,0x13,0xff,0x10,0x00,0x11,0xfe,0x7d,0x7a,0x11,0x4a,0x11,0x7a,0x11,0x02,0x1d,0xfe,0x70,0x84,0x10,0xfc,0x10,0x84,0x10,0xfc,0x10,0x00,0x17,0xff,0x30,0x00}}, // 擅
{0x5A24,0x9DA2,0xDAA4,0xE69387,0x64C7,{0x10,0x00,0x13,0xfe,0x12,0x92,0x13,0xfe,0x7c,0x20,0x11,0xfc,0x10,0x20,0x17,0xff,0x1d,0x08,0x70,0x90,0x13,0xfe,0x10,0x20,0x13,0xfe,0x10,0x20,0x10,0x20,0x30,0x20}}, // 擇
{0x5A25,0x9DA3,0xDAA5,0xE692BB,0x64BB,{0x10,0x10,0x12,0x10,0x11,0x7c,0x11,0x10,0x7c,0xff,0x12,0x44,0x12,0x28,0x10,0xff,0x17,0x10,0x19,0x7e,0x71,0x10,0x11,0x7e,0x11,0x10,0x12,0x90,0x14,0x60,0x38,0x1f}}, // 撻
{0x5A26,0x9DA4,0xDAA6,0xE69398,0x64D8,{0x00,0x08,0x1f,0x7e,0x11,0x24,0x1f,0x28,0x10,0xff,0x1f,0x08,0x29,0x7e,0x2f,0x08,0x40,0x28,0x07,0xc0,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x80,0x01,0x80}}, // 擘
{0x5A27,0x9DA5,0xDAA7,0xE69382,0x64C2,{0x10,0x00,0x11,0xfe,0x10,0x20,0x11,0xff,0x7d,0x22,0x13,0xac,0x10,0x20,0x11,0xac,0x1c,0x00,0x71,0xfe,0x11,0x22,0x11,0xfe,0x11,0x22,0x11,0x22,0x11,0xfe,0x31,0x02}}, // 擂
{0x5A28,0x9DA6,0xDAA8,0xE693B1,0x64F1,{0x10,0x00,0x13,0xde,0x12,0x52,0x13,0xde,0x7e,0x52,0x13,0xde,0x12,0x22,0x12,0x3a,0x1e,0x4a,0x72,0xb2,0x12,0x4a,0x12,0xfe,0x13,0x4a,0x12,0x7a,0x12,0x4a,0x32,0x06}}, // 擱
{0x5A29,0x9DA7,0xDAA9,0xE693A7,0x64E7,{0x02,0x80,0x1c,0xdc,0x10,0x84,0x1c,0xdc,0x10,0x44,0x1d,0x5c,0x11,0x44,0x7f,0xff,0x08,0x28,0x13,0xc4,0x20,0x82,0x4f,0xf9,0x00,0x80,0x3f,0xfe,0x00,0x80,0x01,0x80}}, // 擧
{0x5A2A,0x9DA8,0xDAAA,0xE88889,0x8209,{0x02,0x80,0x1c,0xdc,0x10,0x84,0x1c,0xdc,0x10,0x44,0x1d,0x5c,0x11,0x44,0x7f,0xff,0x08,0x88,0x10,0x84,0x27,0xf2,0x40,0x81,0x00,0x80,0x3f,0xfe,0x00,0x80,0x00,0x80}}, // 舉
{0x5A2B,0x9DA9,0xDAAB,0xE693A0,0x64E0,{0x10,0x20,0x10,0x20,0x17,0xff,0x10,0x51,0x7f,0xae,0x12,0xaa,0x12,0xaa,0x15,0xad,0x18,0x00,0x71,0x04,0x11,0xfc,0x11,0x04,0x11,0xfc,0x11,0x04,0x12,0x04,0x34,0x04}}, // 擠
{0x5A2C,0x9DAA,0xDAAC,0xE693A1,0x64E1,{0x10,0x20,0x17,0xff,0x10,0x20,0x13,0xfe,0x7d,0x04,0x11,0xfc,0x10,0x00,0x13,0xff,0x12,0x02,0x1d,0xfe,0x70,0x98,0x13,0xf4,0x10,0x20,0x11,0xfc,0x10,0x20,0x37,0xff}}, // 擡
{0x5A2D,0x9DAB,0xDAAD,0xE68AAC,0x62AC,{0x10,0x40,0x10,0x40,0x10,0x40,0x10,0x50,0x7c,0x88,0x10,0x84,0x11,0x1c,0x13,0xe2,0x1c,0x02,0x70,0x00,0x11,0xfc,0x11,0x04,0x11,0x04,0x11,0x04,0x11,0xfc,0x31,0x04}}, // 抬
{0x5A2E,0x9DAC,0xDAAE,0xE693A3,0x64E3,{0x10,0x20,0x13,0xfe,0x10,0x20,0x11,0xfc,0x7c,0x00,0x17,0xff,0x10,0x02,0x11,0xfc,0x18,0x20,0x77,0xff,0x10,0x04,0x13,0xff,0x12,0x64,0x13,0xd4,0x32,0x44,0x10,0x0c}}, // 擣
{0x5A2F,0x9DAD,0xDAAF,0xE693AF,0x64EF,{0x10,0x20,0x11,0xff,0x11,0x02,0x12,0xfe,0x7c,0xa4,0x11,0x28,0x16,0x70,0x10,0xfc,0x19,0x84,0x76,0xfc,0x10,0x84,0x10,0xfc,0x10,0x84,0x10,0xfc,0x30,0xc4,0x13,0x02}}, // 擯
{0x5A30,0x9DAE,0xDAB0,0xE694AC,0x652C,{0x10,0x08,0x13,0xef,0x12,0x90,0x13,0xef,0x7e,0x40,0x13,0xdf,0x12,0x95,0x13,0xff,0x1d,0x04,0x71,0xf4,0x11,0x7c,0x11,0x04,0x11,0xfc,0x10,0x51,0x31,0x91,0x16,0x0f}}, // 攬
{0x5A31,0x9DAF,0xDAB1,0xE693B6,0x64F6,{0x11,0x08,0x11,0x08,0x11,0xef,0x12,0x94,0x7c,0x22,0x10,0x88,0x17,0xff,0x10,0x00,0x13,0xd2,0x1e,0x52,0x73,0xd2,0x12,0x52,0x13,0xd2,0x12,0x52,0x32,0x42,0x12,0xc6}}, // 擶
{0x5A32,0x9DB0,0xDAB2,0xE693B4,0x64F4,{0x10,0x10,0x10,0x10,0x13,0xff,0x12,0x48,0x7f,0xfe,0x12,0x48,0x12,0x78,0x13,0xff,0x1e,0x10,0x72,0xfe,0x12,0x92,0x12,0xfe,0x12,0x92,0x12,0xfe,0x34,0x66,0x11,0x81}}, // 擴
{0x5A33,0x9DB1,0xDAB3,0xE693B2,0x64F2,{0x11,0x60,0x11,0x2e,0x13,0xea,0x14,0x9a,0x7b,0xea,0x12,0xac,0x13,0x6c,0x12,0x2a,0x1b,0xe9,0x72,0x29,0x13,0xe9,0x10,0x89,0x17,0xfe,0x11,0x48,0x32,0x28,0x14,0x08}}, // 擲
{0x5A34,0x9DB2,0xDAB4,0xE693BA,0x64FA,{0x10,0x00,0x13,0xfe,0x12,0x52,0x13,0xfe,0x7c,0x90,0x11,0x52,0x17,0xbc,0x10,0x10,0x1f,0xd1,0x72,0x4f,0x13,0xd0,0x12,0x52,0x13,0xdc,0x12,0x50,0x32,0x51,0x12,0xcf}}, // 擺
{0x5A35,0x9DB3,0xDAB5,0xE69480,0x6500,{0x08,0x48,0x3f,0x7f,0x08,0x8c,0x1d,0x5a,0x2b,0x69,0x48,0x88,0x0b,0x48,0x7f,0xff,0x02,0x30,0x0f,0xcc,0x70,0x83,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x00,0x80,0x01,0x80}}, // 攀
{0x5A36,0x9DB4,0xDAB6,0xE693BD,0x64FD,{0x11,0x22,0x11,0x42,0x12,0xfd,0x12,0xcd,0x7d,0x7a,0x11,0x4a,0x13,0x4e,0x12,0xfd,0x1b,0xaf,0x70,0x20,0x13,0xff,0x10,0x68,0x10,0xa4,0x11,0x22,0x36,0x21,0x10,0x20}}, // 擽
{0x5A37,0x9DB5,0xDAB7,0xE69498,0x6518,{0x10,0x20,0x13,0xff,0x10,0x00,0x11,0xce,0x7d,0x4a,0x11,0xce,0x10,0x48,0x11,0xfe,0x1c,0x48,0x71,0xfe,0x10,0x48,0x13,0xff,0x10,0xd2,0x17,0x8c,0x30,0xe4,0x13,0x83}}, // 攘
{0x5A38,0x9DB6,0xDAB8,0xE6949C,0x651C,{0x11,0x12,0x11,0x12,0x11,0xfe,0x10,0x88,0x7d,0xfe,0x13,0x10,0x11,0xfe,0x11,0x10,0x1d,0xfe,0x71,0x10,0x13,0xff,0x12,0x52,0x12,0xfe,0x13,0x52,0x32,0x72,0x12,0x06}}, // 攜
{0x5A39,0x9DB7,0xDAB9,0xE69485,0x6505,{0x10,0x84,0x13,0xff,0x10,0x84,0x13,0xff,0x7c,0x84,0x11,0x4a,0x12,0x31,0x11,0xfc,0x1d,0x04,0x71,0xfc,0x11,0x04,0x11,0xfc,0x11,0x04,0x11,0xfc,0x30,0xcc,0x17,0x03}}, // 攅
{0x5A3A,0x9DB8,0xDABA,0xE694A4,0x6524,{0x12,0x88,0x1f,0xea,0x12,0x92,0x13,0x9f,0x79,0x34,0x17,0xd4,0x15,0x54,0x17,0xdf,0x19,0x14,0x77,0xf4,0x11,0x1f,0x1f,0xf4,0x12,0x94,0x12,0x54,0x34,0x5f,0x18,0x10}}, // 攤
{0x5A3B,0x9DB9,0xDABB,0xE694A3,0x6523,{0x08,0x84,0x0b,0xf4,0x74,0x1a,0x15,0xea,0x0a,0x05,0x7f,0xff,0x09,0x24,0x2d,0xf6,0x2a,0x15,0x49,0xe4,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x00,0x80,0x01,0x80}}, // 攣
{0x5A3C,0x9DBA,0xDABC,0xE694AB,0x652B,{0x13,0xde,0x12,0x52,0x13,0xde,0x12,0x52,0x7f,0xde,0x12,0x52,0x13,0xfe,0x13,0x10,0x1d,0xfc,0x71,0x10,0x11,0xfc,0x11,0x10,0x13,0xfe,0x10,0xc8,0x30,0x30,0x17,0xcf}}, // 攫
{0x5A3D,0x9DBB,0xDABD,0xE694B4,0x6534,{0x00,0x80,0x00,0x80,0x00,0x80,0x00,0xff,0x00,0x80,0x00,0x80,0x3f,0xf8,0x04,0x08,0x02,0x10,0x02,0x10,0x01,0x20,0x00,0xc0,0x00,0xc0,0x03,0x20,0x0c,0x18,0x70,0x07}}, // 攴
{0x5A3E,0x9DBC,0xDABE,0xE694B5,0x6535,{0x04,0x00,0x04,0x00,0x04,0x00,0x07,0xff,0x08,0x10,0x08,0x10,0x12,0x10,0x22,0x10,0x41,0x20,0x01,0x20,0x00,0xc0,0x00,0xc0,0x01,0x20,0x02,0x10,0x0c,0x0c,0x70,0x03}}, // 攵
{0x5A3F,0x9DBD,0xDABF,0xE694B7,0x6537,{0x00,0x40,0x7f,0x40,0x08,0x40,0x08,0x7f,0x10,0x44,0x10,0x84,0x3e,0xc4,0x23,0x44,0x02,0x28,0x02,0x28,0x02,0x10,0x02,0x18,0x04,0x28,0x04,0x44,0x04,0x82,0x1b,0x01}}, // 攷
{0x5A40,0x9DBE,0xDAC0,0xE694B6,0x6536,{0x02,0x40,0x02,0x40,0x12,0x40,0x12,0x7f,0x12,0x44,0x12,0x84,0x12,0xc4,0x13,0x44,0x12,0x48,0x12,0x28,0x1e,0x10,0x62,0x18,0x02,0x28,0x02,0x44,0x03,0x82,0x02,0x01}}, // 收
{0x5A41,0x9DBF,0xDAC1,0xE694B8,0x6538,{0x04,0x40,0x04,0x40,0x04,0x40,0x0a,0x7f,0x0a,0x44,0x12,0x84,0x12,0x84,0x33,0x24,0x52,0x28,0x12,0x38,0x12,0x10,0x12,0x18,0x12,0x28,0x10,0x44,0x11,0x82,0x16,0x01}}, // 攸
{0x5A42,0x9DC0,0xDAC2,0xE7958B,0x754B,{0x00,0x40,0x00,0x40,0x7e,0x40,0x52,0x7f,0x52,0x44,0x52,0x84,0x52,0xc4,0x7f,0x44,0x52,0x48,0x52,0x28,0x52,0x10,0x52,0x18,0x7e,0x28,0x42,0x44,0x01,0x82,0x06,0x01}}, // 畋
{0x5A43,0x9DC1,0xDAC3,0xE69588,0x6548,{0x08,0x20,0x08,0x20,0x08,0x20,0x7f,0xbf,0x12,0x44,0x11,0x44,0x23,0x44,0x2a,0xa4,0x4a,0xa8,0x04,0x38,0x06,0x10,0x09,0x18,0x11,0x28,0x20,0x44,0x41,0x82,0x06,0x01}}, // 效
{0x5A44,0x9DC2,0xDAC4,0xE69596,0x6556,{0x04,0x20,0x04,0x20,0x3f,0x20,0x04,0x3f,0x7f,0xc4,0x04,0x44,0x04,0x44,0x7f,0xa4,0x08,0x28,0x0f,0x38,0x09,0x10,0x09,0x18,0x11,0x28,0x11,0x44,0x21,0x82,0x46,0x01}}, // 敖
{0x5A45,0x9DC3,0xDAC5,0xE69595,0x6555,{0x04,0x20,0x04,0x20,0x7f,0xa0,0x04,0x3f,0x04,0x44,0x3f,0x44,0x25,0x44,0x25,0xa4,0x3f,0x28,0x04,0x38,0x0e,0x10,0x15,0x18,0x24,0x28,0x44,0x44,0x05,0x82,0x06,0x01}}, // 敕
{0x5A46,0x9DC4,0xDAC6,0xE6958D,0x654D,{0x04,0x10,0x04,0x10,0x0a,0x1f,0x0a,0x10,0x11,0x10,0x3f,0xfc,0x44,0x04,0x04,0x24,0x7f,0xa4,0x04,0x24,0x15,0x18,0x14,0x88,0x24,0x98,0x44,0x24,0x0c,0x42,0x05,0x81}}, // 敍
{0x5A47,0x9DC5,0xDAC7,0xE69598,0x6558,{0x04,0x20,0x04,0x20,0x0a,0x20,0x0a,0x3f,0x11,0x44,0x3f,0xc4,0x44,0x44,0x04,0xa4,0x7f,0xa4,0x04,0x14,0x15,0x18,0x14,0x88,0x24,0x98,0x44,0x24,0x0c,0x42,0x05,0x81}}, // 敘
{0x5A48,0x9DC6,0xDAC8,0xE6959E,0x655E,{0x08,0x20,0x08,0x20,0x2a,0x20,0x29,0x3f,0x49,0x24,0x08,0x44,0x7f,0x44,0x41,0xa4,0x5d,0x24,0x55,0x28,0x55,0x18,0x5d,0x10,0x55,0x28,0x41,0x44,0x43,0x82,0x41,0x01}}, // 敞
{0x5A49,0x9DC7,0xDAC9,0xE6959D,0x655D,{0x08,0x10,0x08,0x10,0x2a,0x10,0x29,0x1f,0x49,0x14,0x08,0x24,0x7f,0xa4,0x48,0xd4,0x6a,0x94,0x6a,0x94,0x6a,0x88,0x6a,0x88,0x48,0x94,0x48,0xa2,0x49,0xc2,0x40,0x81}}, // 敝
{0x5A4A,0x9DC8,0xDACA,0xE695B2,0x6572,{0x08,0x10,0x08,0x10,0x7f,0x9f,0x00,0x10,0x3e,0x10,0x22,0xfc,0x3e,0x44,0x00,0x44,0x7f,0x44,0x41,0x28,0x5d,0x28,0x55,0x10,0x5d,0x18,0x55,0x24,0x43,0x42,0x41,0x81}}, // 敲
{0x5A4B,0x9DC9,0xDACB,0xE695B8,0x6578,{0x04,0x10,0x1f,0x90,0x14,0x90,0x7f,0xdf,0x14,0xa4,0x1f,0xa4,0x04,0x24,0x1f,0xd4,0x14,0x94,0x1f,0x98,0x04,0x08,0x7f,0xc8,0x09,0x14,0x1e,0x24,0x05,0x42,0x38,0x81}}, // 數
{0x5A4C,0x9DCA,0xDACC,0xE69682,0x6582,{0x04,0x10,0x04,0x10,0x0a,0x10,0x11,0x1f,0x20,0xa4,0x5f,0x24,0x00,0x24,0x3b,0xd4,0x2a,0x94,0x2a,0x98,0x3b,0x88,0x11,0x08,0x19,0x94,0x15,0x64,0x22,0x42,0x44,0x81}}, // 斂
{0x5A4D,0x9DCB,0xDACD,0xE69683,0x6583,{0x08,0x20,0x2a,0x20,0x49,0x3f,0x3f,0x44,0x29,0xa8,0x2d,0x10,0x3b,0x2c,0x29,0xc3,0x2b,0x00,0x7f,0xff,0x04,0x40,0x0f,0x4c,0x71,0x70,0x0a,0x42,0x0c,0x42,0x70,0x3e}}, // 斃
{0x5A4E,0x9DCC,0xDACE,0xE8AE8A,0x8B8A,{0x10,0x04,0x11,0xc4,0x68,0x1a,0x13,0xe4,0x28,0x0a,0x7d,0xdf,0x14,0x05,0x31,0xd4,0x39,0x56,0x55,0xe5,0x12,0x04,0x07,0xfc,0x1a,0x10,0x61,0xe0,0x07,0x30,0x78,0x0f}}, // 變
{0x5A4F,0x9DCD,0xDACF,0xE6969B,0x659B,{0x08,0x04,0x0e,0x44,0x12,0x24,0x24,0x24,0x7f,0x04,0x25,0x84,0x25,0x44,0x3f,0x44,0x25,0x04,0x25,0x07,0x3f,0x1c,0x21,0xe4,0x21,0x04,0x21,0x04,0x21,0x04,0x43,0x04}}, // 斛
{0x5A50,0x9DCE,0xDAD0,0xE6969F,0x659F,{0x11,0x04,0x11,0x04,0x7f,0xa4,0x11,0x14,0x1f,0x14,0x11,0x04,0x1f,0x44,0x11,0x24,0x11,0x24,0x7f,0xc4,0x2a,0x07,0x2a,0x9c,0x33,0xe4,0x20,0x04,0x3f,0xc4,0x20,0x04}}, // 斟
{0x5A51,0x9DCF,0xDAD1,0xE696AB,0x65AB,{0x00,0x04,0x7f,0x98,0x08,0x60,0x08,0x40,0x08,0x40,0x10,0x7f,0x1e,0x44,0x12,0x44,0x32,0x44,0x32,0x44,0x52,0x44,0x12,0x44,0x1e,0x84,0x12,0x84,0x11,0x04,0x00,0x04}}, // 斫
{0x5A52,0x9DD0,0xDAD2,0xE696B7,0x65B7,{0x09,0x02,0x52,0x04,0x56,0xb8,0x49,0x20,0x56,0xa0,0x5f,0xbf,0x40,0x24,0x7f,0xa4,0x49,0x24,0x56,0xa4,0x49,0x24,0x56,0xa4,0x5f,0xa4,0x40,0x24,0x7f,0xc4,0x40,0x84}}, // 斷
{0x5A53,0x9DD1,0xDAD3,0xE69783,0x65C3,{0x08,0x20,0x08,0x20,0x08,0x20,0x7f,0x7f,0x10,0x40,0x10,0x80,0x1f,0x7c,0x12,0x54,0x12,0x54,0x12,0x54,0x13,0xff,0x22,0x44,0x22,0x44,0x42,0x44,0x02,0x4c,0x0c,0x44}}, // 旃
{0x5A54,0x9DD2,0xDAD4,0xE69786,0x65C6,{0x08,0x20,0x08,0x20,0x08,0x20,0x7f,0x7f,0x10,0x50,0x10,0x90,0x1e,0xff,0x13,0x10,0x12,0x10,0x12,0xfe,0x12,0x92,0x22,0x92,0x22,0x92,0x42,0x9c,0x02,0x10,0x0c,0x10}}, // 旆
{0x5A55,0x9DD3,0xDAD5,0xE69781,0x65C1,{0x00,0x80,0x00,0x80,0x1f,0xfc,0x04,0x10,0x02,0x20,0x3f,0xff,0x20,0x82,0x40,0x80,0x1f,0xfe,0x01,0x00,0x01,0xf8,0x01,0x08,0x02,0x08,0x02,0x08,0x0c,0x08,0x30,0x30}}, // 旁
{0x5A56,0x9DD4,0xDAD6,0xE69784,0x65C4,{0x08,0x40,0x08,0x40,0x08,0x40,0x7e,0xff,0x10,0x82,0x11,0x0c,0x1e,0xf0,0x12,0x20,0x12,0xfc,0x12,0x20,0x12,0x20,0x23,0xfe,0x22,0x20,0x42,0x21,0x02,0x11,0x0c,0x0f}}, // 旄
{0x5A57,0x9DD5,0xDAD7,0xE6978C,0x65CC,{0x08,0x40,0x08,0x40,0x08,0x40,0x7e,0xff,0x10,0x80,0x11,0x50,0x1e,0x50,0x12,0x7e,0x12,0x90,0x13,0x10,0x12,0x7e,0x12,0x10,0x22,0x10,0x42,0x10,0x03,0xff,0x0c,0x00}}, // 旌
{0x5A58,0x9DD6,0xDAD8,0xE69792,0x65D2,{0x08,0x40,0x08,0x40,0x08,0x40,0x7e,0xff,0x10,0x90,0x11,0x10,0x1e,0xff,0x12,0x24,0x12,0xfa,0x12,0x45,0x12,0x54,0x12,0x54,0x22,0x54,0x42,0x55,0x02,0x85,0x0d,0x03}}, // 旒
{0x5A59,0x9DD7,0xDAD9,0xE6979B,0x65DB,{0x08,0x20,0x08,0x20,0x08,0x7f,0x7f,0x82,0x10,0xfc,0x10,0x92,0x1e,0x54,0x13,0xff,0x12,0x54,0x12,0x92,0x13,0xff,0x22,0x92,0x22,0xfe,0x42,0x92,0x02,0xfe,0x0c,0x82}}, // 旛
{0x5A5A,0x9DD8,0xDADA,0xE69799,0x65D9,{0x08,0x04,0x08,0x18,0x09,0xf2,0x7e,0x92,0x10,0x54,0x11,0xff,0x1e,0x38,0x12,0x54,0x12,0x92,0x13,0xff,0x12,0x92,0x22,0xfe,0x22,0x92,0x42,0x92,0x02,0xfe,0x0c,0x82}}, // 旙
{0x5A5B,0x9DD9,0xDADB,0xE697A0,0x65E0,{0x00,0x00,0x1f,0xfc,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0xc0,0x01,0x40,0x01,0x40,0x02,0x40,0x04,0x41,0x08,0x41,0x10,0x21,0x60,0x1f}}, // 无
{0x5A5C,0x9DDA,0xDADC,0xE697A1,0x65E1,{0x00,0x00,0x1f,0xf8,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x07,0xff,0x00,0x40,0x00,0x60,0x00,0xa0,0x01,0x20,0x02,0x21,0x04,0x21,0x18,0x11,0x60,0x0f}}, // 旡
{0x5A5D,0x9DDB,0xDADD,0xE697B1,0x65F1,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x00,0x00,0x1f,0xfc,0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x00,0x80}}, // 旱
{0x5A5E,0x9DDC,0xDADE,0xE69DB2,0x6772,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80,0x00,0x80}}, // 杲
{0x5A5F,0x9DDD,0xDADF,0xE6988A,0x660A,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x00,0x00,0x7f,0xff,0x00,0x80,0x00,0x80,0x1f,0xfc,0x01,0x20,0x02,0x10,0x0c,0x0c,0x70,0x03}}, // 昊
{0x5A60,0x9DDE,0xDAE0,0xE69883,0x6603,{0x00,0x00,0x0f,0xfc,0x08,0x04,0x0f,0xfc,0x08,0x04,0x0f,0xfc,0x00,0x00,0x1f,0xff,0x10,0x40,0x10,0x40,0x10,0x40,0x10,0x40,0x20,0xa0,0x21,0x10,0x46,0x0c,0x18,0x03}}, // 昃
{0x5A61,0x9DDF,0xDAE1,0xE697BB,0x65FB,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x00,0x80,0x00,0x80,0x7f,0xff,0x04,0x10,0x02,0x20,0x01,0x40,0x00,0x80,0x03,0x60,0x0c,0x18,0x70,0x07}}, // 旻
{0x5A62,0x9DE0,0xDAE2,0xE69DB3,0x6773,{0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 杳
{0x5A63,0x9DE1,0xDAE3,0xE698B5,0x6635,{0x00,0x00,0x01,0xfe,0x79,0x02,0x49,0x02,0x49,0x02,0x49,0xfe,0x49,0x02,0x79,0x40,0x49,0x42,0x49,0x4c,0x49,0x70,0x7a,0x40,0x4a,0x41,0x44,0x41,0x08,0x21,0x00,0x1f}}, // 昵
{0x5A64,0x9DE2,0xDAE4,0xE698B6,0x6636,{0x00,0x00,0x3f,0x00,0x00,0x7e,0x00,0x42,0x3c,0x42,0x04,0xc2,0x04,0xfe,0x77,0x42,0x16,0x42,0x16,0x42,0x15,0x7e,0x25,0x42,0x24,0x80,0x44,0x60,0x0c,0x1f,0x04,0x00}}, // 昶
{0x5A65,0x9DE3,0xDAE5,0xE698B4,0x6634,{0x00,0x00,0x0f,0xfc,0x08,0x04,0x0f,0xfc,0x08,0x04,0x08,0x04,0x0f,0xfc,0x03,0x00,0x1c,0x3e,0x11,0x22,0x11,0x22,0x11,0x22,0x1f,0x22,0x72,0x3c,0x02,0x20,0x0c,0x20}}, // 昴
{0x5A66,0x9DE4,0xDAE6,0xE6989C,0x661C,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x00,0x00,0x7f,0xff,0x02,0x00,0x07,0xfe,0x18,0x92,0x61,0x12,0x06,0x22,0x18,0x42,0x01,0x8c}}, // 昜
{0x5A67,0x9DE5,0xDAE7,0xE6998F,0x664F,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x00,0x80,0x3f,0xff,0x20,0x02,0x21,0x00,0x5f,0xff,0x02,0x10,0x07,0x10,0x00,0xe0,0x03,0x98,0x3c,0x04}}, // 晏
{0x5A68,0x9DE6,0xDAE8,0xE69984,0x6644,{0x00,0x20,0x00,0x22,0x7e,0x22,0x45,0x24,0x44,0xa4,0x44,0xa8,0x44,0x20,0x7f,0xff,0x44,0x48,0x44,0x48,0x44,0x48,0x7c,0x48,0x44,0x88,0x40,0x89,0x03,0x09,0x0c,0x07}}, // 晄
{0x5A69,0x9DE7,0xDAE9,0xE69989,0x6649,{0x00,0x00,0x3f,0xfe,0x04,0x10,0x05,0x14,0x09,0xa6,0x3e,0x79,0x00,0x00,0x7f,0xff,0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 晉
{0x5A6A,0x9DE8,0xDAEA,0xE69981,0x6641,{0x00,0x00,0x1f,0xf8,0x10,0x08,0x1f,0xf8,0x10,0x08,0x1f,0xf8,0x00,0x00,0x12,0x44,0x0a,0x44,0x0a,0x48,0x02,0x60,0x1a,0x58,0x62,0x46,0x04,0x41,0x18,0x41,0x60,0x3f}}, // 晁
{0x5A6B,0x9DE9,0xDAEB,0xE6999E,0x665E,{0x00,0x04,0x01,0xc8,0x78,0x30,0x48,0x68,0x4b,0x84,0x48,0x40,0x4f,0xff,0x78,0xa0,0x49,0x20,0x4b,0xfc,0x4d,0x24,0x79,0x24,0x49,0x24,0x41,0x38,0x01,0x20,0x00,0x20}}, // 晞
{0x5A6C,0x9DEA,0xDAEC,0xE6999D,0x665D,{0x00,0x80,0x1f,0xfc,0x00,0x84,0x7f,0xff,0x00,0x84,0x1f,0xfc,0x00,0x80,0x1f,0xfc,0x00,0x80,0x7f,0xff,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x00,0x00,0x7f,0xff}}, // 晝
{0x5A6D,0x9DEB,0xDAED,0xE699A4,0x6664,{0x00,0x00,0x03,0xfe,0x78,0x40,0x48,0x40,0x4b,0xf8,0x48,0x88,0x48,0x88,0x78,0x88,0x4f,0xff,0x48,0x00,0x49,0xfc,0x49,0x04,0x79,0x04,0x49,0x04,0x01,0xfc,0x01,0x04}}, // 晤
{0x5A6E,0x9DEC,0xDAEE,0xE699A7,0x6667,{0x00,0x20,0x00,0xa0,0x3c,0xa0,0x25,0xfe,0x25,0x20,0x26,0x20,0x24,0x20,0x3f,0xff,0x24,0x20,0x24,0x00,0x25,0xfc,0x25,0x04,0x3d,0x04,0x25,0x04,0x21,0xfc,0x01,0x04}}, // 晧
{0x5A6F,0x9DED,0xDAEF,0xE699A8,0x6668,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x00,0x00,0x1f,0xfe,0x10,0x00,0x17,0xfc,0x10,0x00,0x1f,0xff,0x22,0x44,0x22,0x28,0x43,0x98,0x0e,0x07}}, // 晨
{0x5A70,0x9DEE,0xDAF0,0xE6999F,0x665F,{0x00,0x00,0x1f,0xfc,0x10,0x04,0x1f,0xfc,0x10,0x04,0x1f,0xfc,0x00,0x50,0x00,0x48,0x1f,0xfe,0x10,0x44,0x1f,0x24,0x11,0x28,0x11,0x10,0x21,0x29,0x2e,0x45,0x41,0x83}}, // 晟
{0x5A71,0x9DEF,0xDAF1,0xE699A2,0x6662,{0x08,0x04,0x08,0x78,0x7f,0x40,0x08,0x40,0x08,0x7f,0x0e,0x48,0x78,0x88,0x08,0x88,0x19,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x08,0x08}}, // 晢
{0x5A72,0x9DF0,0xDAF2,0xE699B0,0x6670,{0x01,0x02,0x01,0x0c,0x79,0x30,0x4f,0xe0,0x49,0x20,0x49,0x3f,0x49,0xa4,0x7b,0x64,0x4b,0x24,0x4d,0x24,0x49,0x24,0x79,0x24,0x49,0x44,0x41,0x44,0x01,0x84,0x01,0x04}}, // 晰
{0x5A73,0x9DF1,0xDAF3,0xE69A83,0x6683,{0x00,0x00,0x1f,0xf8,0x10,0x08,0x1f,0xf8,0x10,0x08,0x1f,0xf8,0x00,0x40,0x02,0x40,0x3e,0x7e,0x02,0x40,0x3e,0x7e,0x02,0x40,0x0e,0x7f,0x74,0x40,0x08,0x40,0x10,0x40}}, // 暃
{0x5A74,0x9DF2,0xDAF4,0xE69A88,0x6688,{0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x3f,0xff,0x20,0x82,0x3f,0xfc,0x40,0x80,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x08,0x88,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x00,0x80}}, // 暈
{0x5A75,0x9DF3,0xDAF5,0xE69A8E,0x668E,{0x00,0x88,0x00,0x88,0x7b,0xff,0x48,0x88,0x48,0x88,0x48,0x20,0x49,0xfc,0x79,0x24,0x49,0x24,0x49,0x24,0x4f,0xff,0x78,0x20,0x48,0x50,0x40,0x88,0x03,0x04,0x0c,0x03}}, // 暎
{0x5A76,0x9DF4,0xDAF6,0xE69A89,0x6689,{0x00,0x00,0x03,0xff,0x7a,0x02,0x4a,0x20,0x4d,0xfe,0x48,0x20,0x49,0xfc,0x79,0x24,0x49,0xfc,0x49,0x24,0x49,0x24,0x79,0xfc,0x48,0x20,0x47,0xff,0x00,0x20,0x00,0x20}}, // 暉
{0x5A77,0x9DF5,0xDAF7,0xE69A84,0x6684,{0x00,0x20,0x00,0x20,0x7b,0xff,0x4a,0x02,0x4a,0xfc,0x4c,0x00,0x48,0xfc,0x78,0x84,0x48,0x84,0x48,0xfc,0x48,0x84,0x78,0x84,0x48,0xfc,0x40,0x00,0x03,0xff,0x00,0x00}}, // 暄
{0x5A78,0x9DF6,0xDAF8,0xE69A98,0x6698,{0x00,0x00,0x01,0xf8,0x79,0x08,0x49,0xf8,0x49,0x08,0x49,0x08,0x49,0xf8,0x78,0x00,0x4f,0xff,0x48,0x80,0x49,0xfe,0x7e,0x52,0x48,0x92,0x43,0x22,0x00,0x42,0x01,0x9c}}, // 暘
{0x5A79,0x9DF7,0xDAF9,0xE69A9D,0x669D,{0x00,0x00,0x03,0xff,0x7a,0x02,0x4a,0xfc,0x4c,0x84,0x48,0x84,0x48,0xfc,0x78,0x84,0x48,0x84,0x48,0xfc,0x48,0x20,0x7b,0xff,0x48,0x00,0x40,0x48,0x01,0x84,0x06,0x02}}, // 暝
{0x5A7A,0x9DF8,0xDAFA,0xE69B81,0x66C1,{0x08,0x00,0x3f,0x7e,0x21,0x48,0x3f,0x48,0x21,0xff,0x3f,0x18,0x26,0x28,0x3d,0x49,0x6f,0xff,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x00,0x00,0x7f,0xff,0x00,0x00}}, // 曁
{0x5A7B,0x9DF9,0xDAFB,0xE69AB9,0x66B9,{0x10,0x00,0x09,0xfc,0x09,0x04,0x01,0xfc,0x21,0x04,0x11,0xfc,0x10,0x90,0x01,0xfe,0x7b,0x20,0x0d,0xfc,0x09,0x20,0x09,0xfc,0x15,0x20,0x13,0xfe,0x21,0x80,0x40,0x7f}}, // 暹
{0x5A7C,0x9DFA,0xDAFC,0xE69B89,0x66C9,{0x00,0x20,0x01,0xfc,0x78,0x20,0x4b,0xfe,0x48,0x00,0x48,0x84,0x7b,0xff,0x48,0x84,0x48,0xe4,0x4f,0x1f,0x48,0x00,0x7b,0xff,0x48,0x48,0x40,0x89,0x03,0x09,0x0c,0x07}}, // 曉
{0x5A7D,0x9DFB,0xDAFD,0xE69ABE,0x66BE,{0x01,0x08,0x01,0x08,0x7f,0xe8,0x48,0x0f,0x4b,0xd2,0x4a,0x52,0x4b,0xe2,0x78,0x0a,0x4f,0xca,0x48,0x8c,0x49,0x04,0x79,0xcc,0x4f,0x0c,0x41,0x12,0x01,0x22,0x03,0x41}}, // 暾
{0x5A7E,0x9DFC,0xDAFE,0xE69ABC,0x66BC,{0x08,0x20,0x2a,0x20,0x49,0x3f,0x7f,0x44,0x49,0x64,0x5d,0x98,0x6b,0x18,0x49,0x24,0x4b,0x43,0x1f,0xf8,0x10,0x08,0x1f,0xf8,0x10,0x08,0x10,0x08,0x1f,0xf8,0x10,0x08}}, // 暼
{0x5B21,0x9E40,0xDBA1,0xE69B84,0x66C4,{0x00,0x88,0x00,0x88,0x7b,0xff,0x48,0x88,0x4b,0xfe,0x49,0x24,0x49,0x24,0x7f,0xff,0x49,0x24,0x49,0x24,0x4b,0xfe,0x78,0x20,0x48,0x20,0x07,0xff,0x00,0x20,0x00,0x20}}, // 曄
{0x5B22,0x9E41,0xDBA2,0xE69AB8,0x66B8,{0x00,0x20,0x00,0x20,0x7b,0xff,0x48,0x50,0x4a,0x8a,0x49,0x04,0x4b,0xfe,0x7d,0x05,0x49,0xfc,0x49,0x04,0x49,0xfc,0x79,0x20,0x49,0x24,0x02,0x22,0x04,0x22,0x00,0x60}}, // 暸
{0x5B23,0x9E42,0xDBA3,0xE69B96,0x66D6,{0x00,0x0c,0x03,0xf4,0x79,0x44,0x48,0xa8,0x4f,0xff,0x4c,0xa5,0x4a,0x8a,0x7a,0x79,0x4c,0x41,0x48,0x7c,0x48,0x84,0x79,0x68,0x4e,0x10,0x40,0x70,0x01,0x8c,0x0e,0x03}}, // 曖
{0x5B24,0x9E43,0xDBA4,0xE69B9A,0x66DA,{0x00,0x88,0x07,0xff,0x78,0x88,0x4b,0xff,0x4a,0x02,0x4c,0xf8,0x48,0x00,0x7f,0xff,0x48,0x40,0x48,0xaa,0x4b,0x5a,0x78,0x94,0x4b,0x34,0x40,0xd2,0x07,0x11,0x00,0x60}}, // 曚
{0x5B25,0x9E44,0xDBA5,0xE69BA0,0x66E0,{0x00,0x20,0x00,0x20,0x7b,0xff,0x4a,0x48,0x4b,0xff,0x4a,0x48,0x7a,0x78,0x4b,0xff,0x4a,0x10,0x4a,0xfe,0x4a,0x92,0x7c,0xfe,0x44,0x92,0x48,0xfe,0x10,0x66,0x03,0x81}}, // 曠
{0x5B26,0x9E45,0xDBA6,0xE698BF,0x663F,{0x00,0x10,0x00,0x10,0x78,0x10,0x49,0xff,0x49,0x00,0x49,0x10,0x49,0x10,0x79,0x10,0x49,0x10,0x49,0x10,0x49,0x14,0x7a,0x22,0x4a,0x22,0x44,0x4f,0x09,0xf1,0x00,0x01}}, // 昿
{0x5B27,0x9E46,0xDBA7,0xE69BA6,0x66E6,{0x01,0x04,0x00,0x88,0x7b,0xfe,0x48,0x20,0x49,0xfc,0x48,0x20,0x4f,0xff,0x78,0x44,0x4b,0x8a,0x48,0x88,0x4f,0xff,0x79,0xca,0x4a,0xa4,0x45,0xd5,0x00,0x4b,0x01,0x91}}, // 曦
{0x5B28,0x9E47,0xDBA8,0xE69BA9,0x66E9,{0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x00,0x80,0x7f,0xff,0x09,0x48,0x0f,0x78,0x02,0x20,0x0f,0xf8,0x02,0x20,0x7f,0xff,0x0c,0x48,0x77,0x30,0x0c,0x0e}}, // 曩
{0x5B29,0x9E48,0xDBA9,0xE69BB0,0x66F0,{0x00,0x00,0x3f,0xfc,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x3f,0xc4,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x20,0x04,0x3f,0xfc,0x20,0x04}}, // 曰
{0x5B2A,0x9E49,0xDBAA,0xE69BB5,0x66F5,{0x01,0x00,0x01,0x10,0x01,0x08,0x1f,0xfc,0x11,0x04,0x11,0x04,0x1f,0xe4,0x11,0x04,0x11,0x04,0x1f,0xfc,0x11,0x14,0x00,0xa0,0x00,0xc1,0x07,0x21,0x78,0x19,0x00,0x07}}, // 曵
{0x5B2B,0x9E4A,0xDBAB,0xE69BB7,0x66F7,{0x00,0x00,0x0f,0xf8,0x08,0x08,0x0f,0xf8,0x08,0x08,0x08,0x08,0x0f,0xf8,0x02,0x00,0x07,0xfc,0x08,0x84,0x18,0xc4,0x69,0x24,0x0a,0x04,0x0f,0xe4,0x08,0x04,0x00,0x18}}, // 曷
{0x5B2C,0x9E4B,0xDBAC,0xE69C8F,0x670F,{0x00,0x10,0x3e,0x10,0x22,0x92,0x22,0x92,0x22,0x92,0x3e,0x92,0x22,0xfe,0x22,0x10,0x22,0x10,0x3e,0x92,0x22,0x92,0x22,0x92,0x22,0x92,0x22,0x92,0x22,0xfe,0x46,0x00}}, // 朏
{0x5B2D,0x9E4C,0xDBAD,0xE69C96,0x6716,{0x00,0x10,0x3e,0x10,0x22,0xfc,0x22,0x84,0x22,0x84,0x3e,0xfc,0x22,0x84,0x22,0x84,0x22,0xfe,0x3e,0x92,0x22,0x94,0x22,0x88,0x22,0x88,0x22,0xb4,0x22,0xc2,0x47,0x01}}, // 朖
{0x5B2E,0x9E4D,0xDBAE,0xE69C9E,0x671E,{0x04,0x10,0x3f,0xfe,0x04,0x10,0x07,0xf0,0x04,0x10,0x07,0xf0,0x04,0x10,0x7f,0xff,0x08,0x08,0x17,0xf4,0x24,0x12,0x47,0xf1,0x04,0x10,0x07,0xf0,0x04,0x10,0x04,0x30}}, // 朞
{0x5B2F,0x9E4E,0xDBAF,0xE69CA6,0x6726,{0x00,0x48,0x3d,0xff,0x24,0x48,0x25,0xff,0x25,0x02,0x3e,0x78,0x24,0x00,0x27,0xff,0x24,0x40,0x3c,0xaa,0x27,0x5a,0x24,0x94,0x27,0x34,0x24,0x52,0x25,0x91,0x4c,0x60}}, // 朦
{0x5B30,0x9E4F,0xDBB0,0xE69CA7,0x6727,{0x00,0x88,0x3c,0x88,0x27,0xff,0x25,0x28,0x24,0xcf,0x3f,0xf1,0x24,0x0f,0x25,0xe8,0x25,0x2e,0x3d,0xe8,0x25,0x2e,0x25,0xe8,0x25,0x2e,0x25,0x29,0x25,0x29,0x4d,0x67}}, // 朧
{0x5B31,0x9E50,0xDBB1,0xE99CB8,0x9738,{0x00,0x00,0x1f,0xfc,0x00,0x80,0x3f,0xff,0x20,0x82,0x3c,0xf8,0x4e,0xbc,0x12,0x00,0x7f,0xbe,0x12,0x22,0x3f,0x3e,0x25,0x22,0x3f,0x3e,0x04,0x22,0x7f,0xc2,0x04,0x86}}, // 霸
{0x5B32,0x9E51,0xDBB2,0xE69CAE,0x672E,{0x00,0x88,0x00,0x84,0x00,0x84,0x7f,0xff,0x00,0x80,0x00,0x80,0x04,0x90,0x04,0x90,0x04,0x90,0x04,0x90,0x04,0x90,0x08,0x90,0x08,0x91,0x10,0x91,0x20,0x8f,0x00,0x80}}, // 朮
{0x5B33,0x9E52,0xDBB3,0xE69CBF,0x673F,{0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x1f,0xfc,0x10,0x84,0x10,0x84,0x11,0xc4,0x11,0xc4,0x12,0xb8,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80,0x00,0x80}}, // 朿
{0x5B34,0x9E53,0xDBB4,0xE69CB6,0x6736,{0x00,0x00,0x3f,0xf0,0x01,0x10,0x01,0x10,0x02,0x3e,0x04,0x02,0x08,0x02,0x30,0x8c,0x00,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x0c,0x98,0x70,0x87,0x00,0x80,0x00,0x80}}, // 朶
{0x5B35,0x9E54,0xDBB5,0xE69D81,0x6741,{0x08,0x00,0x08,0x70,0x08,0x10,0x7f,0x10,0x08,0x10,0x08,0x10,0x1c,0x10,0x1a,0x10,0x19,0x18,0x28,0x28,0x28,0x28,0x48,0x48,0x08,0x44,0x08,0x84,0x09,0x02,0x0a,0x01}}, // 杁
{0x5B36,0x9E55,0xDBB6,0xE69CB8,0x6738,{0x08,0x20,0x08,0x20,0x08,0x20,0x7f,0x20,0x09,0xfe,0x08,0x22,0x1c,0x22,0x1a,0x22,0x1a,0x22,0x28,0x42,0x28,0x42,0x48,0x42,0x08,0x82,0x08,0x82,0x09,0x02,0x0a,0x0c}}, // 朸
{0x5B37,0x9E56,0xDBB7,0xE69CB7,0x6737,{0x08,0x00,0x09,0xfe,0x08,0x22,0x7f,0x22,0x08,0x22,0x08,0x22,0x1c,0x22,0x1a,0x22,0x1a,0x22,0x28,0x42,0x28,0x42,0x48,0x42,0x08,0x82,0x08,0x82,0x09,0x02,0x0a,0x0c}}, // 朷
{0x5B38,0x9E57,0xDBB8,0xE69D86,0x6746,{0x08,0x00,0x08,0xfe,0x08,0x10,0x7e,0x10,0x08,0x10,0x08,0x10,0x18,0x10,0x1d,0xff,0x1a,0x10,0x2a,0x10,0x28,0x10,0x48,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10}}, // 杆
{0x5B39,0x9E58,0xDBB9,0xE69D9E,0x675E,{0x08,0x00,0x08,0xfe,0x08,0x02,0x7f,0x02,0x08,0x02,0x08,0x02,0x1c,0xfe,0x1a,0x82,0x1a,0x80,0x28,0x80,0x28,0x80,0x48,0x81,0x08,0x81,0x08,0x41,0x08,0x3f,0x08,0x00}}, // 杞
{0x5B3A,0x9E59,0xDBBA,0xE69DA0,0x6760,{0x08,0x00,0x08,0x00,0x09,0xfe,0x7e,0x10,0x08,0x10,0x08,0x10,0x1c,0x10,0x1a,0x10,0x1a,0x10,0x28,0x10,0x28,0x10,0x48,0x10,0x08,0x10,0x0b,0xff,0x08,0x00,0x08,0x00}}, // 杠
{0x5B3B,0x9E5A,0xDBBB,0xE69D99,0x6759,{0x08,0x24,0x08,0x22,0x08,0x22,0x7f,0x20,0x09,0xff,0x08,0x20,0x1c,0x20,0x1a,0x20,0x1a,0x10,0x28,0x10,0x28,0x10,0x48,0x08,0x08,0x09,0x08,0x05,0x08,0x03,0x08,0x01}}, // 杙
{0x5B3C,0x9E5B,0xDBBC,0xE69DA3,0x6763,{0x08,0x10,0x08,0x10,0x08,0x10,0x7f,0x10,0x08,0x10,0x08,0x92,0x1c,0x92,0x1a,0x92,0x1a,0x92,0x28,0x92,0x28,0x92,0x48,0x92,0x08,0x92,0x08,0x92,0x08,0xfe,0x08,0x82}}, // 杣
{0x5B3D,0x9E5C,0xDBBD,0xE69DA4,0x6764,{0x08,0x00,0x0b,0xff,0x08,0x40,0x7f,0x40,0x08,0x40,0x08,0x7c,0x1c,0x44,0x1a,0x44,0x1a,0x44,0x28,0x44,0x28,0x44,0x48,0x84,0x08,0x84,0x08,0x84,0x09,0x04,0x0a,0x18}}, // 杤
{0x5B3E,0x9E5D,0xDBBE,0xE69E89,0x6789,{0x08,0x00,0x09,0xfe,0x08,0x20,0x7f,0x20,0x08,0x20,0x08,0x20,0x1c,0x20,0x1a,0xfc,0x1a,0x20,0x28,0x20,0x28,0x20,0x48,0x20,0x08,0x20,0x08,0x20,0x0b,0xff,0x08,0x00}}, // 枉
{0x5B3F,0x9E5E,0xDBBF,0xE69DB0,0x6770,{0x00,0x80,0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80,0x00,0x80,0x00,0x00,0x14,0x44,0x12,0x22,0x21,0x11,0x41,0x11}}, // 杰
{0x5B40,0x9E5F,0xDBC0,0xE69EA9,0x67A9,{0x00,0x80,0x00,0x80,0x7f,0xff,0x01,0xc0,0x06,0xb0,0x18,0x8c,0x60,0x83,0x02,0xe0,0x02,0x20,0x04,0x90,0x18,0x8c,0x61,0x03,0x01,0x40,0x02,0x30,0x04,0xe8,0x3f,0x04}}, // 枩
{0x5B41,0x9E60,0xDBC1,0xE69DBC,0x677C,{0x08,0x00,0x09,0xfe,0x08,0x04,0x7e,0xc8,0x08,0x30,0x08,0x10,0x1b,0xff,0x1c,0x12,0x1a,0x14,0x2a,0x10,0x28,0x10,0x48,0x10,0x08,0x10,0x08,0x10,0x08,0x30,0x08,0x10}}, // 杼
{0x5B42,0x9E61,0xDBC2,0xE69DAA,0x676A,{0x08,0x20,0x08,0x20,0x08,0x20,0x7e,0x28,0x08,0xa4,0x08,0xa2,0x18,0xa2,0x1d,0x21,0x1a,0x25,0x2a,0x24,0x28,0x68,0x48,0x08,0x08,0x10,0x08,0x20,0x08,0xc0,0x0b,0x00}}, // 杪
{0x5B43,0x9E62,0xDBC3,0xE69E8C,0x678C,{0x08,0x78,0x08,0x08,0x08,0x48,0x7e,0x84,0x08,0x84,0x09,0x02,0x1a,0x01,0x1c,0xfc,0x1a,0x24,0x2a,0x24,0x28,0x24,0x48,0x24,0x08,0x44,0x08,0x44,0x08,0x84,0x09,0x18}}, // 枌
{0x5B44,0x9E63,0xDBC4,0xE69E8B,0x678B,{0x08,0x20,0x08,0x20,0x08,0x20,0x7f,0xff,0x08,0x40,0x08,0x40,0x1c,0x40,0x1a,0x7c,0x19,0x44,0x28,0x44,0x28,0x44,0x48,0x44,0x08,0x84,0x08,0x84,0x09,0x04,0x0a,0x18}}, // 枋
{0x5B45,0x9E64,0xDBC5,0xE69EA6,0x67A6,{0x08,0x00,0x09,0xff,0x08,0x00,0x7f,0x00,0x08,0xfe,0x08,0x82,0x1c,0x82,0x1a,0x82,0x1a,0xfe,0x28,0x82,0x28,0x80,0x48,0x80,0x08,0x80,0x09,0x00,0x09,0x00,0x0a,0x00}}, // 枦
{0x5B46,0x9E65,0xDBC6,0xE69EA1,0x67A1,{0x08,0x24,0x08,0x44,0x09,0xc4,0x7e,0x44,0x08,0x44,0x08,0x44,0x19,0xff,0x1c,0x44,0x1a,0x44,0x2a,0x44,0x28,0x44,0x48,0x44,0x08,0x84,0x08,0x84,0x09,0x04,0x0a,0x04}}, // 枡
{0x5B47,0x9E66,0xDBC7,0xE69E85,0x6785,{0x08,0x00,0x09,0xff,0x08,0x44,0x7f,0x44,0x08,0x44,0x08,0x44,0x19,0xff,0x1c,0x44,0x1a,0x44,0x2a,0x44,0x28,0x44,0x48,0x44,0x08,0x84,0x08,0x84,0x09,0x04,0x0a,0x04}}, // 枅
{0x5B48,0x9E67,0xDBC8,0xE69EB7,0x67B7,{0x11,0x00,0x11,0x00,0x11,0x1e,0x7d,0x12,0x17,0xd2,0x11,0x52,0x39,0x52,0x39,0x52,0x35,0x52,0x51,0x52,0x51,0x52,0x12,0x52,0x12,0x52,0x14,0x5e,0x18,0x52,0x11,0x80}}, // 枷
{0x5B49,0x9E68,0xDBC9,0xE69FAF,0x67EF,{0x08,0x00,0x09,0xff,0x08,0x04,0x7f,0x04,0x08,0xf4,0x08,0x94,0x1c,0x94,0x1a,0x94,0x1a,0x94,0x28,0xf4,0x28,0x94,0x48,0x04,0x08,0x04,0x08,0x04,0x08,0x0c,0x08,0x04}}, // 柯
{0x5B4A,0x9E69,0xDBCA,0xE69EB4,0x67B4,{0x08,0x00,0x08,0xfc,0x08,0x84,0x7f,0x84,0x08,0x84,0x08,0xfc,0x1c,0x84,0x1a,0x00,0x19,0xfe,0x28,0x22,0x28,0x22,0x48,0x22,0x08,0x42,0x08,0x42,0x08,0x82,0x09,0x0c}}, // 枴
{0x5B4B,0x9E6A,0xDBCB,0xE69FAC,0x67EC,{0x00,0x80,0x00,0x80,0x7f,0xff,0x00,0x80,0x00,0x80,0x1f,0xfc,0x14,0x94,0x12,0xa4,0x12,0x84,0x1f,0xfc,0x11,0xc4,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80}}, // 柬
{0x5B4C,0x9E6B,0xDBCC,0xE69EB3,0x67B3,{0x08,0x00,0x08,0x7e,0x08,0x42,0x7f,0x42,0x08,0x42,0x08,0x42,0x1c,0x42,0x1a,0x7e,0x19,0x42,0x28,0x00,0x28,0x00,0x48,0x44,0x08,0x42,0x08,0x82,0x09,0x01,0x0a,0x01}}, // 枳
{0x5B4D,0x9E6C,0xDBCD,0xE69FA9,0x67E9,{0x08,0x00,0x09,0xff,0x09,0x10,0x7f,0x10,0x09,0x1c,0x09,0x24,0x1d,0x24,0x1b,0x48,0x19,0x88,0x29,0x14,0x29,0x14,0x49,0x22,0x09,0x42,0x09,0x80,0x09,0xff,0x09,0x00}}, // 柩
{0x5B4E,0x9E6D,0xDBCE,0xE69EB8,0x67B8,{0x08,0x80,0x08,0x80,0x08,0x80,0x7e,0xfe,0x09,0x02,0x09,0x02,0x1a,0xf2,0x1c,0x92,0x1a,0x92,0x2a,0x92,0x28,0xf2,0x48,0x92,0x08,0x02,0x08,0x02,0x08,0x04,0x08,0x18}}, // 枸
{0x5B4F,0x9E6E,0xDBCF,0xE69FA4,0x67E4,{0x08,0x00,0x08,0xfc,0x08,0x84,0x7f,0x84,0x08,0x84,0x08,0xfc,0x1c,0x84,0x1a,0x84,0x1a,0x84,0x28,0xfc,0x28,0x84,0x48,0x84,0x08,0x84,0x08,0x84,0x0b,0xff,0x08,0x00}}, // 柤
{0x5B50,0x9E6F,0xDBD0,0xE69F9E,0x67DE,{0x08,0x40,0x08,0x40,0x08,0x40,0x7f,0x7f,0x08,0x90,0x08,0x90,0x1d,0x10,0x1a,0x1e,0x1a,0x10,0x28,0x10,0x28,0x10,0x48,0x1e,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10}}, // 柞
{0x5B51,0x9E70,0xDBD1,0xE69F9D,0x67DD,{0x08,0x02,0x08,0x0c,0x08,0xf0,0x7f,0x80,0x08,0x80,0x08,0xff,0x1c,0x88,0x1a,0x88,0x1a,0x88,0x28,0xb8,0x28,0x8c,0x48,0x8a,0x09,0x09,0x09,0x08,0x0a,0x08,0x08,0x08}}, // 柝
{0x5B52,0x9E71,0xDBD2,0xE69FA2,0x67E2,{0x08,0x04,0x08,0x18,0x08,0xf0,0x7f,0x90,0x08,0x90,0x08,0x90,0x1c,0xff,0x1a,0x88,0x1a,0x88,0x28,0x88,0x28,0x88,0x48,0xe4,0x0b,0x85,0x08,0x05,0x0b,0xf3,0x08,0x01}}, // 柢
{0x5B53,0x9E72,0xDBD3,0xE69FAE,0x67EE,{0x08,0x10,0x08,0x10,0x08,0x92,0x7f,0x92,0x08,0x92,0x08,0x92,0x1c,0xfe,0x1a,0x10,0x1a,0x10,0x28,0x92,0x28,0x92,0x48,0x92,0x08,0x92,0x08,0x92,0x08,0xfe,0x08,0x82}}, // 柮
{0x5B54,0x9E73,0xDBD4,0xE69EB9,0x67B9,{0x08,0x40,0x08,0x40,0x08,0x7e,0x7e,0x42,0x08,0x82,0x08,0xf2,0x19,0x92,0x1c,0x92,0x1a,0x92,0x2a,0xf2,0x28,0x84,0x48,0x98,0x08,0x80,0x08,0x81,0x08,0x81,0x08,0x7f}}, // 枹
{0x5B55,0x9E74,0xDBD5,0xE69F8E,0x67CE,{0x08,0x44,0x08,0x44,0x08,0x44,0x7e,0x84,0x08,0xff,0x09,0x84,0x1d,0x84,0x1a,0xa4,0x18,0x94,0x28,0x94,0x28,0x84,0x48,0x84,0x08,0x84,0x08,0x84,0x08,0x84,0x08,0x8c}}, // 柎
{0x5B56,0x9E75,0xDBD6,0xE69F86,0x67C6,{0x08,0x20,0x08,0x20,0x08,0x20,0x7f,0xfe,0x08,0x00,0x08,0x84,0x1c,0x84,0x1a,0x44,0x1a,0x44,0x28,0x48,0x28,0x48,0x48,0x48,0x08,0x10,0x08,0x10,0x0b,0xff,0x08,0x00}}, // 柆
{0x5B57,0x9E76,0xDBD7,0xE69FA7,0x67E7,{0x08,0x04,0x08,0x18,0x08,0xe4,0x7e,0x84,0x08,0xa4,0x08,0xa4,0x1c,0xa4,0x1a,0xa4,0x1a,0xa4,0x28,0xa4,0x28,0xa4,0x48,0xb4,0x08,0xac,0x09,0x3a,0x09,0xea,0x0a,0x05}}, // 柧
{0x5B58,0x9E77,0xDBD8,0xE6AA9C,0x6A9C,{0x08,0x20,0x08,0x30,0x08,0x48,0x7e,0xf4,0x0b,0x03,0x09,0xfe,0x1d,0xa6,0x1b,0x6a,0x19,0xfe,0x28,0x00,0x28,0xfc,0x48,0x84,0x08,0xfc,0x08,0x84,0x08,0xfc,0x08,0x84}}, // 檜
{0x5B59,0x9E78,0xDBD9,0xE6A09E,0x681E,{0x00,0x00,0x3e,0x3e,0x08,0x08,0x08,0x08,0x7f,0x7f,0x08,0x08,0x08,0x08,0x08,0x88,0x00,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80}}, // 栞
{0x5B5A,0x9E79,0xDBDA,0xE6A186,0x6846,{0x08,0x00,0x09,0xff,0x09,0x00,0x7f,0xfe,0x09,0x10,0x09,0x10,0x1d,0x10,0x1b,0x7c,0x19,0x10,0x29,0x10,0x29,0x10,0x49,0xfe,0x09,0x00,0x09,0x00,0x09,0xff,0x09,0x00}}, // 框
{0x5B5B,0x9E7A,0xDBDB,0xE6A0A9,0x6829,{0x08,0x00,0x09,0xee,0x08,0x22,0x7e,0x66,0x08,0x66,0x08,0xaa,0x1c,0xaa,0x1b,0x32,0x2a,0x66,0x28,0x66,0x48,0xaa,0x08,0xaa,0x09,0x32,0x0a,0x22,0x08,0x22,0x08,0x66}}, // 栩
{0x5B5C,0x9E7B,0xDBDC,0xE6A180,0x6840,{0x04,0x08,0x04,0x08,0x0f,0x7e,0x09,0x48,0x11,0x48,0x6a,0x48,0x04,0xff,0x18,0x08,0x60,0x88,0x00,0x80,0x7f,0xff,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80}}, // 桀
{0x5B5D,0x9E7C,0xDBDD,0xE6A18D,0x684D,{0x08,0x20,0x08,0x20,0x09,0xff,0x7e,0x30,0x08,0x48,0x08,0xfc,0x19,0x02,0x1c,0x01,0x1b,0xfe,0x2a,0x40,0x28,0x40,0x48,0xfc,0x08,0x84,0x08,0x04,0x08,0x04,0x08,0x18}}, // 桍
{0x5B5E,0x9E7D,0xDBDE,0xE6A0B2,0x6832,{0x08,0x20,0x08,0x22,0x09,0xfe,0x7e,0x24,0x08,0x28,0x0b,0xff,0x1c,0x20,0x1a,0x40,0x18,0xfc,0x29,0x40,0x2a,0x40,0x48,0x7c,0x08,0x44,0x08,0x04,0x08,0x04,0x08,0x18}}, // 栲
{0x5B5F,0x9E7E,0xDBDF,0xE6A18E,0x684E,{0x08,0x00,0x0b,0xff,0x08,0x20,0x7e,0x20,0x08,0x48,0x08,0x84,0x1d,0xfa,0x1a,0x00,0x1a,0x20,0x28,0x20,0x29,0xfc,0x48,0x20,0x08,0x20,0x08,0x20,0x0b,0xff,0x08,0x00}}, // 桎
{0x5B60,0x9E80,0xDBE0,0xE6A2B3,0x68B3,{0x08,0x10,0x08,0x10,0x09,0xff,0x7e,0x20,0x08,0x2c,0x08,0x4a,0x1d,0xf1,0x1a,0x00,0x1a,0xa4,0x28,0xa4,0x28,0xa4,0x48,0xa4,0x08,0xa4,0x09,0x25,0x09,0x05,0x0a,0x03}}, // 梳
{0x5B61,0x9E81,0xDBE1,0xE6A0AB,0x682B,{0x08,0x20,0x08,0x20,0x09,0xff,0x7e,0x20,0x08,0x20,0x08,0x7e,0x1c,0x42,0x1a,0x84,0x18,0x88,0x29,0xff,0x2a,0x88,0x48,0x88,0x08,0x88,0x08,0x88,0x08,0x88,0x08,0x98}}, // 栫
{0x5B62,0x9E82,0xDBE2,0xE6A199,0x6859,{0x08,0x20,0x08,0x28,0x08,0x44,0x7e,0x8e,0x09,0xf1,0x08,0x00,0x1c,0x50,0x1a,0x50,0x18,0xfe,0x29,0x10,0x28,0x10,0x4b,0xff,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10}}, // 桙
{0x5B63,0x9E83,0xDBE3,0xE6A1A3,0x6863,{0x08,0x10,0x09,0x12,0x08,0x92,0x7e,0x94,0x08,0x98,0x08,0x10,0x1d,0xfe,0x1a,0x02,0x1a,0x02,0x28,0x02,0x28,0xfe,0x48,0x02,0x08,0x02,0x08,0x02,0x09,0xfe,0x08,0x02}}, // 档
{0x5B64,0x9E84,0xDBE4,0xE6A1B7,0x6877,{0x08,0x40,0x08,0x78,0x08,0x48,0x7e,0x90,0x09,0xfe,0x08,0x92,0x1c,0x92,0x1a,0xfe,0x1a,0x92,0x28,0x92,0x28,0xfe,0x48,0x82,0x08,0x82,0x09,0x02,0x09,0x02,0x0a,0x06}}, // 桷
{0x5B65,0x9E85,0xDBE5,0xE6A1BF,0x687F,{0x08,0x00,0x08,0xfc,0x08,0x84,0x7e,0xfc,0x08,0x84,0x08,0x84,0x1c,0xfc,0x1a,0x00,0x1a,0xfe,0x28,0x10,0x28,0x10,0x4b,0xff,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x10}}, // 桿
{0x5B66,0x9E86,0xDBE6,0xE6A29F,0x689F,{0x01,0x00,0x1f,0xf8,0x10,0x08,0x1f,0xf8,0x10,0x08,0x1f,0xff,0x10,0x00,0x1f,0xfe,0x00,0x02,0x00,0x82,0x00,0x8c,0x7f,0xff,0x02,0xa0,0x0c,0x98,0x70,0x87,0x00,0x80}}, // 梟
{0x5B67,0x9E87,0xDBE7,0xE6A28F,0x688F,{0x08,0x10,0x08,0x90,0x08,0x90,0x7e,0xfe,0x08,0x90,0x09,0x10,0x1c,0x10,0x1b,0xff,0x1a,0x10,0x28,0x00,0x28,0xfe,0x48,0x82,0x08,0x82,0x08,0x82,0x08,0xfe,0x08,0x82}}, // 梏
{0x5B68,0x9E88,0xDBE8,0xE6A2AD,0x68AD,{0x08,0x20,0x08,0x28,0x08,0x44,0x7f,0xfa,0x08,0x48,0x08,0x49,0x1c,0x87,0x1b,0x40,0x1a,0x78,0x28,0x88,0x29,0x88,0x4a,0x50,0x08,0x20,0x08,0x50,0x09,0x8c,0x0e,0x03}}, // 梭
{0x5B69,0x9E89,0xDBE9,0xE6A294,0x6894,{0x08,0x04,0x08,0x18,0x08,0xe0,0x7e,0x80,0x08,0xff,0x08,0x80,0x1c,0xfe,0x1a,0xd2,0x1a,0xd2,0x28,0xd2,0x28,0xfe,0x49,0x42,0x09,0x40,0x0a,0x41,0x0c,0x21,0x08,0x1f}}, // 梔
{0x5B6A,0x9E8A,0xDBEA,0xE6A29D,0x689D,{0x04,0x40,0x04,0x40,0x04,0x7f,0x08,0x84,0x09,0x24,0x12,0x28,0x12,0x10,0x32,0x6c,0x53,0x93,0x12,0x10,0x13,0xff,0x12,0x38,0x12,0x54,0x10,0x92,0x11,0x11,0x10,0x10}}, // 條
{0x5B6B,0x9E8B,0xDBEB,0xE6A29B,0x689B,{0x08,0x00,0x0b,0xef,0x08,0xa9,0x7e,0xaa,0x08,0xaa,0x0b,0xec,0x1c,0xaa,0x1a,0xa9,0x28,0xa9,0x2b,0xe9,0x48,0xa9,0x08,0xa9,0x09,0x2e,0x09,0x28,0x0a,0x28,0x08,0xc8}}, // 梛
{0x5B6C,0x9E8C,0xDBEC,0xE6A283,0x6883,{0x08,0x02,0x08,0x0c,0x0b,0xf8,0x7e,0x48,0x08,0x88,0x09,0x08,0x19,0xff,0x1c,0x48,0x2a,0x48,0x2a,0x48,0x49,0x48,0x08,0xc8,0x08,0xbe,0x09,0x40,0x09,0x30,0x0a,0x0f}}, // 梃
{0x5B6D,0x9E8D,0xDBED,0xE6AAAE,0x6AAE,{0x08,0x20,0x09,0xfe,0x08,0x20,0x7e,0xfc,0x08,0x00,0x09,0xff,0x1c,0x02,0x1a,0xf8,0x18,0x20,0x2b,0xff,0x28,0x04,0x4b,0xff,0x09,0x64,0x09,0xd4,0x09,0x44,0x08,0x0c}}, // 檮
{0x5B6E,0x9E8E,0xDBEE,0xE6A2B9,0x68B9,{0x08,0x04,0x08,0x18,0x08,0xe0,0x7e,0x80,0x08,0xfe,0x08,0x88,0x1c,0x88,0x1a,0x88,0x18,0x88,0x28,0x88,0x2b,0xff,0x48,0x00,0x08,0x88,0x08,0x84,0x09,0x02,0x0a,0x02}}, // 梹
{0x5B6F,0x9E8F,0xDBEF,0xE6A1B4,0x6874,{0x08,0x04,0x08,0x18,0x09,0xe4,0x7e,0xa2,0x08,0x92,0x09,0x11,0x1c,0xfd,0x1a,0x04,0x1a,0x08,0x28,0x10,0x29,0xff,0x48,0x10,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x30}}, // 桴
{0x5B70,0x9E90,0xDBF0,0xE6A2B5,0x68B5,{0x08,0x10,0x08,0x10,0x7f,0xff,0x0c,0x38,0x1a,0x34,0x19,0x52,0x28,0x91,0x49,0x10,0x00,0x00,0x07,0xf0,0x04,0x10,0x05,0x10,0x04,0x92,0x08,0x92,0x10,0x12,0x60,0x0e}}, // 梵
{0x5B71,0x9E91,0xDBF1,0xE6A2A0,0x68A0,{0x08,0x00,0x08,0xfc,0x08,0x84,0x7f,0x84,0x08,0x84,0x08,0xfc,0x1c,0xa4,0x1a,0x20,0x19,0x20,0x28,0x40,0x29,0xfe,0x49,0x02,0x09,0x02,0x09,0x02,0x09,0xfe,0x09,0x02}}, // 梠
{0x5B72,0x9E92,0xDBF2,0xE6A2BA,0x68BA,{0x04,0x10,0x04,0x10,0x7f,0xff,0x0e,0x38,0x0d,0x34,0x14,0x52,0x24,0x91,0x04,0x10,0x00,0x00,0x7f,0xff,0x00,0x80,0x00,0xe0,0x00,0x98,0x00,0x84,0x00,0x80,0x00,0x80}}, // 梺
{0x5B73,0x9E93,0xDBF3,0xE6A48F,0x690F,{0x08,0x00,0x09,0xff,0x08,0x28,0x7e,0x28,0x08,0x28,0x08,0xee,0x1c,0x82,0x1a,0x82,0x1a,0x82,0x28,0xee,0x28,0xaa,0x48,0x28,0x08,0x28,0x08,0x28,0x09,0xff,0x08,0x00}}, // 椏
{0x5B74,0x9E94,0xDBF4,0xE6A28D,0x688D,{0x08,0x10,0x08,0x20,0x08,0xfc,0x7e,0x84,0x08,0x84,0x08,0xfc,0x1c,0x84,0x1a,0x84,0x1a,0xfc,0x28,0xa0,0x28,0x27,0x48,0x38,0x0b,0xe0,0x08,0x21,0x08,0x21,0x08,0x1f}}, // 梍
{0x5B75,0x9E95,0xDBF5,0xE6A1BE,0x687E,{0x08,0x00,0x08,0xfc,0x08,0x24,0x7e,0x24,0x09,0xff,0x08,0x24,0x1c,0x24,0x1a,0xfc,0x1a,0x44,0x28,0x40,0x28,0xfe,0x48,0xc2,0x09,0x42,0x0a,0x42,0x08,0x7e,0x08,0x42}}, // 桾
{0x5B76,0x9E96,0xDBF6,0xE6A481,0x6901,{0x08,0x10,0x08,0x10,0x09,0xff,0x7e,0x00,0x08,0x7c,0x08,0x44,0x1c,0x7c,0x1a,0x00,0x19,0xfc,0x28,0x08,0x28,0x10,0x49,0xff,0x08,0x10,0x08,0x10,0x08,0x10,0x08,0x30}}, // 椁
{0x5B77,0x9E97,0xDBF7,0xE6A38A,0x68CA,{0x04,0x10,0x3f,0xfe,0x04,0x10,0x07,0xf0,0x04,0x10,0x07,0xf0,0x04,0x10,0x7f,0xff,0x04,0x90,0x08,0x88,0x17,0xf4,0x61,0xc3,0x02,0xa0,0x0c,0x98,0x30,0x86,0x00,0x80}}, // 棊
{0x5B78,0x9E98,0xDBF8,0xE6A488,0x6908,{0x08,0x40,0x08,0x40,0x08,0x7e,0x7e,0x82,0x08,0xa2,0x09,0x2a,0x18,0xb2,0x1d,0xfa,0x1a,0x22,0x28,0x72,0x28,0x6a,0x48,0xa6,0x09,0x22,0x08,0x22,0x08,0x04,0x08,0x18}}, // 椈
{0x5B79,0x9E99,0xDBF9,0xE6A398,0x68D8,{0x08,0x10,0x08,0x10,0x7f,0x7f,0x08,0x10,0x08,0x10,0x3f,0x7e,0x29,0x52,0x29,0x52,0x2b,0x56,0x28,0x50,0x1c,0x38,0x1a,0x34,0x29,0x52,0x48,0x91,0x08,0x10,0x08,0x10}}, // 棘
{0x5B7A,0x9E9A,0xDBFA,0xE6A4A2,0x6922,{0x10,0x00,0x13,0xfe,0x12,0x02,0x7f,0xfe,0x12,0x22,0x12,0x22,0x3a,0x22,0x36,0xfa,0x32,0x22,0x52,0x32,0x52,0x2a,0x12,0x22,0x13,0xfe,0x12,0x02,0x13,0xfe,0x12,0x02}}, // 椢
{0x5B7B,0x9E9B,0xDBFB,0xE6A4A6,0x6926,{0x08,0x20,0x08,0xa8,0x09,0x24,0x7e,0xfa,0x08,0x20,0x08,0x50,0x1d,0xff,0x1a,0x48,0x18,0xa4,0x29,0x22,0x2b,0xfd,0x48,0x24,0x08,0x44,0x08,0x44,0x08,0x84,0x09,0x18}}, // 椦
{0x5B7C,0x9E9C,0xDBFC,0xE6A3A1,0x68E1,{0x08,0x00,0x09,0xfe,0x09,0x02,0x7f,0x8a,0x09,0x4a,0x09,0x52,0x1d,0xfe,0x1b,0x22,0x2b,0x22,0x29,0xaa,0x49,0xaa,0x09,0xfa,0x09,0x8a,0x09,0x02,0x09,0x02,0x09,0x06}}, // 棡
{0x5B7D,0x9E9D,0xDBFD,0xE6A48C,0x690C,{0x08,0x10,0x08,0x10,0x08,0xff,0x7e,0xaa,0x08,0xa8,0x09,0x4a,0x1c,0x46,0x1a,0x80,0x19,0x00,0x28,0xfe,0x28,0x10,0x48,0x10,0x08,0x10,0x08,0x10,0x09,0xff,0x08,0x00}}, // 椌
{0x5B7E,0x9E9E,0xDBFE,0xE6A38D,0x68CD,{0x08,0x00,0x08,0xfc,0x08,0x84,0x7f,0x84,0x08,0xfc,0x08,0x84,0x1c,0x84,0x1a,0xfc,0x1a,0x84,0x29,0x10,0x29,0x12,0x49,0xdc,0x09,0x10,0x09,0x11,0x09,0xd1,0x0b,0x0f}}, // 棍
{0x5C21,0x9E9F,0xDCA1,0xE6A394,0x68D4,{0x08,0x06,0x08,0xf8,0x08,0x90,0x7f,0x90,0x08,0xff,0x08,0x88,0x1c,0x88,0x1a,0xe5,0x1b,0x83,0x28,0xfd,0x28,0x84,0x48,0xfc,0x08,0x84,0x08,0x84,0x08,0xfc,0x08,0x84}}, // 棔
{0x5C22,0x9EA0,0xDCA2,0xE6A3A7,0x68E7,{0x08,0x28,0x08,0x24,0x08,0x3e,0x7f,0xd0,0x08,0x16,0x08,0x18,0x1c,0x65,0x1b,0xa3,0x1a,0x29,0x28,0x24,0x28,0x1e,0x4b,0xf0,0x08,0x14,0x08,0x19,0x08,0x67,0x0b,0x81}}, // 棧
{0x5C23,0x9EA1,0xDCA3,0xE6A395,0x68D5,{0x08,0x10,0x08,0x10,0x09,0xff,0x7f,0x02,0x09,0x00,0x0a,0xfe,0x18,0x00,0x1c,0x00,0x1b,0xff,0x2a,0x10,0x28,0x54,0x48,0x52,0x08,0x92,0x09,0x11,0x08,0x10,0x08,0x30}}, // 棕
{0x5C24,0x9EA2,0xDCA4,0xE6A4B6,0x6936,{0x08,0x8a,0x08,0xea,0x08,0x92,0x7e,0xaa,0x08,0xc2,0x08,0xfe,0x1c,0x48,0x1a,0x89,0x19,0x27,0x2a,0x3c,0x28,0x44,0x48,0xa8,0x09,0x18,0x08,0x30,0x08,0xcc,0x0b,0x03}}, // 椶
{0x5C25,0x9EA3,0xDCA5,0xE6A492,0x6912,{0x10,0x80,0x10,0x9e,0x10,0x82,0x7e,0xf2,0x10,0x92,0x10,0x92,0x38,0x8a,0x37,0xea,0x30,0x8c,0x52,0xc4,0x52,0xa4,0x12,0xac,0x12,0x8a,0x14,0x92,0x10,0xa1,0x11,0xc1}}, // 椒
{0x5C26,0x9EA4,0xDCA6,0xE6A484,0x6904,{0x08,0x10,0x08,0x10,0x08,0xfe,0x7f,0x44,0x08,0x24,0x08,0x28,0x1d,0xff,0x1a,0x20,0x18,0x20,0x29,0xff,0x28,0x24,0x48,0x44,0x08,0xe8,0x08,0x18,0x08,0x64,0x09,0x82}}, // 椄
{0x5C27,0x9EA5,0xDCA7,0xE6A397,0x68D7,{0x00,0x80,0x3f,0xfe,0x00,0x80,0x1f,0xfc,0x11,0xc4,0x16,0xb4,0x38,0x8e,0x00,0x80,0x7f,0xff,0x00,0x80,0x1f,0xfc,0x11,0xc4,0x12,0xac,0x0c,0x98,0x70,0x87,0x00,0x80}}, // 棗
{0x5C28,0x9EA6,0xDCA8,0xE6A3A3,0x68E3,{0x08,0x20,0x08,0x20,0x09,0xfc,0x7e,0x24,0x09,0xff,0x08,0x24,0x1c,0x24,0x1b,0xfc,0x18,0x22,0x2a,0x32,0x29,0x34,0x49,0x68,0x09,0xa4,0x0e,0x22,0x08,0x21,0x08,0x60}}, // 棣
{0x5C29,0x9EA7,0xDCA9,0xE6A4A5,0x6925,{0x12,0x00,0x12,0x00,0x12,0x1e,0x7b,0xd2,0x15,0x12,0x15,0x12,0x39,0x12,0x37,0xf2,0x31,0x12,0x51,0x12,0x51,0x92,0x11,0x92,0x12,0x52,0x12,0x5e,0x14,0x12,0x18,0x00}}, // 椥
{0x5C2A,0x9EA8,0xDCAA,0xE6A3B9,0x68F9,{0x08,0x20,0x08,0x20,0x08,0x3e,0x7f,0x20,0x08,0x20,0x08,0xfc,0x1c,0x84,0x1a,0xfc,0x1a,0x84,0x28,0x84,0x28,0xfc,0x48,0x20,0x0b,0xff,0x08,0x20,0x08,0x20,0x08,0x20}}, // 棹
{0x5C2B,0x9EA9,0xDCAB,0xE6A3A0,0x68E0,{0x08,0x88,0x04,0x88,0x04,0x90,0x3f,0xff,0x20,0x02,0x27,0xf0,0x44,0x10,0x04,0x10,0x07,0xf0,0x00,0x80,0x7f,0xff,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80}}, // 棠
{0x5C2C,0x9EAA,0xDCAC,0xE6A3AF,0x68EF,{0x08,0x20,0x08,0x20,0x08,0x50,0x7e,0x88,0x09,0x04,0x0a,0xfa,0x1c,0x01,0x1a,0xfc,0x1a,0x08,0x28,0x10,0x28,0x20,0x49,0x50,0x09,0x52,0x0a,0x45,0x0c,0x45,0x08,0x3c}}, // 棯
{0x5C2D,0x9EAB,0xDCAD,0xE6A4A8,0x6928,{0x08,0x20,0x08,0x20,0x09,0xff,0x7f,0x00,0x09,0x24,0x09,0x24,0x1d,0x3f,0x1b,0x44,0x29,0x64,0x29,0xd4,0x49,0x54,0x09,0x44,0x0a,0x44,0x0a,0x44,0x0c,0x44,0x08,0x4c}}, // 椨
{0x5C2E,0x9EAC,0xDCAE,0xE6A4AA,0x692A,{0x08,0x84,0x08,0x44,0x08,0x48,0x7e,0x00,0x09,0xfe,0x0c,0x48,0x1a,0x4a,0x18,0x4a,0x19,0x4a,0x28,0xcc,0x28,0xcc,0x48,0x48,0x08,0x48,0x08,0x48,0x0b,0xff,0x08,0x00}}, // 椪
{0x5C2F,0x9EAD,0xDCAF,0xE6A49A,0x691A,{0x10,0x00,0x13,0xde,0x12,0x52,0x7f,0xde,0x12,0x52,0x13,0xde,0x3a,0x02,0x36,0x02,0x32,0x02,0x52,0x02,0x52,0x02,0x12,0x02,0x12,0x02,0x12,0x02,0x12,0x06,0x12,0x02}}, // 椚
{0x5C30,0x9EAE,0xDCB0,0xE6A4A3,0x6923,{0x08,0x50,0x08,0x50,0x08,0x50,0x7f,0xfe,0x09,0x52,0x09,0x52,0x1d,0x52,0x1b,0xfe,0x29,0x52,0x29,0x52,0x49,0x52,0x0b,0xff,0x08,0x00,0x08,0x48,0x08,0x84,0x0b,0x02}}, // 椣
{0x5C31,0x9EAF,0xDCB1,0xE6A4A1,0x6921,{0x10,0x02,0x17,0xf2,0x10,0x8a,0x7c,0x8a,0x11,0x4a,0x11,0x6a,0x37,0xaa,0x38,0x8a,0x34,0x8a,0x53,0xea,0x50,0x8a,0x10,0x82,0x10,0xe2,0x11,0x82,0x16,0x06,0x10,0x02}}, // 椡
{0x5C32,0x9EB0,0xDCB2,0xE6A386,0x68C6,{0x08,0x10,0x08,0x10,0x08,0x28,0x7f,0x44,0x08,0x82,0x09,0x7d,0x1c,0x00,0x1a,0x00,0x19,0xfe,0x28,0xaa,0x28,0xaa,0x48,0xfe,0x08,0xaa,0x08,0xaa,0x08,0xaa,0x08,0x86}}, // 棆
{0x5C33,0x9EB1,0xDCB3,0xE6A5B9,0x6979,{0x08,0x00,0x09,0xfc,0x08,0x84,0x7e,0x84,0x08,0xf6,0x0c,0xd2,0x1a,0xa2,0x19,0x52,0x1a,0x8c,0x28,0x00,0x29,0xfe,0x49,0x4a,0x09,0x4a,0x09,0x4a,0x0b,0xff,0x08,0x00}}, // 楹
{0x5C34,0x9EB2,0xDCB4,0xE6A5B7,0x6977,{0x09,0x10,0x09,0x10,0x09,0x12,0x7f,0xdc,0x09,0x11,0x09,0x31,0x19,0xcf,0x1f,0x20,0x1a,0x40,0x29,0xfc,0x29,0x04,0x49,0x04,0x09,0xfc,0x09,0x04,0x09,0xfc,0x09,0x04}}, // 楷
{0x5C35,0x9EB3,0xDCB5,0xE6A59C,0x695C,{0x10,0x80,0x10,0x9e,0x10,0x92,0x7c,0x92,0x17,0xf2,0x10,0x9e,0x38,0x92,0x34,0x92,0x33,0xd2,0x52,0x5e,0x52,0x52,0x12,0x52,0x13,0xd2,0x12,0x62,0x10,0x22,0x10,0x46}}, // 楜
{0x5C36,0x9EB4,0xDCB6,0xE6A5B8,0x6978,{0x10,0x28,0x10,0x48,0x13,0x88,0x7c,0x8a,0x10,0x9a,0x10,0x9a,0x3b,0xfc,0x34,0xa8,0x30,0xc8,0x51,0xac,0x51,0x8c,0x12,0x94,0x12,0x94,0x14,0x92,0x10,0xa2,0x10,0xc1}}, // 楸
{0x5C37,0x9EB5,0xDCB7,0xE6A5AB,0x696B,{0x08,0x00,0x08,0xfe,0x08,0x82,0x7e,0x82,0x08,0xfe,0x08,0x00,0x1d,0xff,0x1a,0x82,0x1a,0xfe,0x28,0x82,0x28,0xfe,0x48,0x82,0x08,0x83,0x08,0xfe,0x0b,0x82,0x08,0x02}}, // 楫
{0x5C38,0x9EB6,0xDCB8,0xE6A594,0x6954,{0x10,0x80,0x10,0xbe,0x13,0xea,0x7c,0x8a,0x10,0x8a,0x13,0xea,0x38,0x92,0x34,0xd2,0x53,0xa2,0x50,0xac,0x10,0x20,0x17,0xff,0x10,0x20,0x10,0x50,0x11,0x8c,0x16,0x03}}, // 楔
{0x5C39,0x9EB7,0xDCB9,0xE6A5BE,0x697E,{0x08,0x10,0x08,0x10,0x08,0xfc,0x7f,0x84,0x08,0xfc,0x08,0x84,0x1c,0x84,0x1a,0xfc,0x1a,0x12,0x29,0xd2,0x28,0x5c,0x48,0x94,0x09,0x12,0x0a,0x11,0x08,0x10,0x08,0x30}}, // 楾
{0x5C3A,0x9EB8,0xDCBA,0xE6A5AE,0x696E,{0x08,0x20,0x08,0x24,0x08,0xfe,0x7f,0x24,0x08,0x28,0x08,0x30,0x1d,0xff,0x1a,0x24,0x1a,0x42,0x28,0xfe,0x29,0x42,0x48,0x7e,0x08,0x42,0x08,0x42,0x08,0x7e,0x08,0x42}}, // 楮
{0x5C3B,0x9EB9,0xDCBB,0xE6A4B9,0x6939,{0x08,0x44,0x08,0x44,0x09,0xff,0x7f,0x44,0x08,0x7c,0x08,0x44,0x1c,0x7c,0x1a,0x44,0x18,0x44,0x2b,0xff,0x29,0x28,0x49,0x28,0x09,0x4f,0x09,0x80,0x09,0xff,0x09,0x00}}, // 椹
{0x5C3C,0x9EBA,0xDCBC,0xE6A5B4,0x6974,{0x08,0x20,0x08,0x20,0x09,0xff,0x7e,0x84,0x08,0x44,0x08,0x48,0x1d,0xff,0x1b,0x12,0x19,0x10,0x2a,0xfe,0x28,0x92,0x48,0x92,0x08,0x92,0x08,0x9c,0x08,0x10,0x08,0x10}}, // 楴
{0x5C3D,0x9EBB,0xDCBD,0xE6A4BD,0x693D,{0x08,0x20,0x08,0x3e,0x08,0x44,0x7e,0xf8,0x08,0x08,0x09,0xff,0x1c,0x22,0x1a,0x52,0x19,0x94,0x28,0x28,0x28,0x4c,0x49,0x9c,0x08,0x2a,0x08,0x49,0x09,0x88,0x08,0x30}}, // 椽
{0x5C3E,0x9EBC,0xDCBE,0xE6A599,0x6959,{0x10,0x04,0x13,0xe4,0x10,0x24,0x7d,0x5f,0x10,0x84,0x18,0x84,0x37,0xee,0x34,0xae,0x31,0xd5,0x51,0x95,0x52,0xa4,0x12,0x84,0x14,0x84,0x10,0x84,0x10,0x84,0x11,0x84}}, // 楙
{0x5C3F,0x9EBD,0xDCBF,0xE6A4B0,0x6930,{0x08,0x00,0x0b,0xff,0x09,0x29,0x7f,0x2a,0x09,0x2a,0x09,0xec,0x1d,0x2a,0x1b,0x2a,0x29,0xe9,0x29,0x29,0x49,0x29,0x09,0x39,0x09,0xee,0x0b,0x28,0x08,0x28,0x08,0x28}}, // 椰
{0x5C40,0x9EBE,0xDCC0,0xE6A5A1,0x6961,{0x08,0x30,0x08,0x10,0x08,0x28,0x7e,0x44,0x08,0xfa,0x09,0x01,0x1b,0xea,0x1d,0x2a,0x2b,0xaa,0x29,0x74,0x49,0x34,0x09,0xb4,0x09,0x6a,0x09,0x2a,0x09,0x2a,0x09,0x2a}}, // 楡
{0x5C41,0x9EBF,0xDCC1,0xE6A59E,0x695E,{0x08,0x00,0x09,0xff,0x09,0x29,0x7f,0x29,0x09,0xff,0x09,0x11,0x1c,0x10,0x1b,0xff,0x2a,0x20,0x28,0x20,0x48,0x3c,0x08,0x24,0x08,0x44,0x08,0x44,0x08,0x84,0x09,0x18}}, // 楞
{0x5C42,0x9EC0,0xDCC2,0xE6A59D,0x695D,{0x08,0x10,0x08,0x10,0x09,0xff,0x7e,0x10,0x08,0x10,0x08,0xfe,0x1c,0x96,0x1a,0xda,0x2a,0xb2,0x28,0xfe,0x48,0x98,0x08,0x34,0x08,0x52,0x08,0x91,0x09,0x10,0x08,0x10}}, // 楝
{0x5C43,0x9EC1,0xDCC3,0xE6A681,0x6981,{0x08,0x10,0x08,0x10,0x09,0xff,0x7f,0x02,0x09,0x00,0x0a,0xfe,0x1c,0x28,0x1a,0x44,0x1b,0xfa,0x28,0x10,0x28,0x10,0x48,0xfe,0x08,0x10,0x08,0x10,0x0b,0xff,0x08,0x00}}, // 榁
{0x5C44,0x9EC2,0xDCC4,0xE6A5AA,0x696A,{0x08,0xa4,0x08,0xa4,0x0b,0xff,0x7e,0xa4,0x08,0xa4,0x08,0xbc,0x1c,0x80,0x1a,0xfe,0x28,0x20,0x2b,0xff,0x48,0x70,0x08,0x68,0x08,0xa4,0x09,0x22,0x0a,0x21,0x08,0x20}}, // 楪
{0x5C45,0x9EC3,0xDCC5,0xE6A6B2,0x69B2,{0x08,0x00,0x08,0xfc,0x08,0xa4,0x7f,0xa4,0x08,0xb4,0x08,0xcc,0x1c,0xc4,0x1a,0xfc,0x1a,0x00,0x29,0xfe,0x29,0x52,0x49,0x52,0x09,0x52,0x09,0x52,0x0b,0xff,0x08,0x00}}, // 榲
{0x5C46,0x9EC4,0xDCC6,0xE6A6AE,0x69AE,{0x04,0x10,0x15,0x52,0x16,0x54,0x26,0x98,0x09,0x24,0x30,0xc0,0x3f,0xfe,0x20,0x02,0x20,0x84,0x40,0x80,0x3f,0xfe,0x01,0xc0,0x02,0xa0,0x0c,0x98,0x70,0x87,0x00,0x80}}, // 榮
{0x5C47,0x9EC5,0xDCC7,0xE6A790,0x69D0,{0x08,0x20,0x08,0x40,0x09,0xfc,0x7f,0x24,0x09,0x24,0x09,0xfc,0x1d,0x24,0x1b,0x24,0x19,0xfe,0x28,0x52,0x28,0x52,0x48,0x55,0x08,0x9f,0x08,0x91,0x09,0x11,0x0a,0x0f}}, // 槐
{0x5C48,0x9EC6,0xDCC8,0xE6A6BF,0x69BF,{0x10,0x20,0x11,0x22,0x11,0x22,0x7d,0xfe,0x10,0x00,0x13,0xfe,0x38,0x00,0x35,0xfc,0x35,0x04,0x51,0x04,0x51,0xfc,0x10,0x88,0x10,0x48,0x10,0x50,0x17,0xff,0x10,0x00}}, // 榿
{0x5C49,0x9EC7,0xDCC9,0xE6A781,0x69C1,{0x08,0x20,0x08,0x20,0x0b,0xff,0x7e,0x00,0x08,0xfc,0x08,0x84,0x1c,0xfc,0x1a,0x00,0x1b,0xfe,0x29,0x02,0x29,0x7a,0x49,0x4a,0x09,0x7a,0x09,0x4a,0x09,0x02,0x09,0x06}}, // 槁
{0x5C4A,0x9EC8,0xDCCA,0xE6A793,0x69D3,{0x08,0x00,0x08,0xfe,0x08,0x10,0x7e,0x10,0x09,0xff,0x08,0x00,0x1c,0xfe,0x1a,0x82,0x1a,0xfe,0x28,0x82,0x28,0xfe,0x48,0x82,0x08,0xfe,0x08,0x24,0x08,0xc2,0x0b,0x01}}, // 槓
{0x5C4B,0x9EC9,0xDCCB,0xE6A6BE,0x69BE,{0x08,0x00,0x08,0xfc,0x08,0x84,0x7e,0xbc,0x08,0xa4,0x08,0xa4,0x1b,0xff,0x1a,0x02,0x2c,0xfc,0x2a,0x84,0x48,0xfc,0x08,0x84,0x08,0xfc,0x08,0x84,0x08,0x84,0x08,0x8c}}, // 榾
{0x5C4C,0x9ECA,0xDCCC,0xE6A78E,0x69CE,{0x08,0x88,0x08,0x50,0x09,0xfe,0x7e,0x20,0x08,0x20,0x09,0xfc,0x1c,0x20,0x1a,0x20,0x1b,0xff,0x28,0x40,0x28,0x40,0x48,0xfe,0x09,0x10,0x0a,0x10,0x09,0xff,0x08,0x00}}, // 槎
{0x5C4D,0x9ECB,0xDCCD,0xE5AFA8,0x5BE8,{0x00,0x80,0x00,0x80,0x3f,0xff,0x22,0x22,0x2f,0xf8,0x42,0x20,0x0f,0xf8,0x02,0x20,0x7f,0xff,0x04,0x90,0x18,0x8c,0x6f,0xfb,0x02,0xa0,0x0c,0x98,0x70,0x87,0x00,0x80}}, // 寨
{0x5C4E,0x9ECC,0xDCCE,0xE6A78A,0x69CA,{0x11,0x00,0x0a,0x3e,0x7f,0xa2,0x04,0x3e,0x24,0xa2,0x24,0xbe,0x3f,0xa2,0x04,0x22,0x08,0x46,0x10,0x80,0x7f,0xff,0x01,0xc0,0x02,0xa0,0x0c,0x98,0x70,0x87,0x00,0x80}}, // 槊
{0x5C4F,0x9ECD,0xDCCF,0xE6A79D,0x69DD,{0x08,0x20,0x08,0x40,0x08,0xfc,0x7f,0x84,0x08,0xfc,0x08,0x84,0x1c,0xfc,0x1a,0x80,0x1a,0xff,0x28,0x80,0x28,0xfe,0x4a,0x42,0x0a,0x4a,0x0b,0xfa,0x0a,0x02,0x08,0x0c}}, // 槝
{0x5C50,0x9ECE,0xDCD0,0xE6A6BB,0x69BB,{0x08,0x00,0x08,0xfc,0x08,0x84,0x7e,0xfc,0x08,0x84,0x08,0xfc,0x1c,0x00,0x1b,0xfe,0x2a,0xaa,0x28,0xaa,0x49,0x76,0x0a,0x66,0x08,0xaa,0x09,0x32,0x08,0x22,0x08,0x66}}, // 榻
{0x5C51,0x9ECF,0xDCD1,0xE6A783,0x69C3,{0x04,0x00,0x1f,0x3c,0x19,0x24,0x15,0x25,0x17,0x43,0x79,0xfc,0x15,0x24,0x25,0x18,0x43,0x64,0x00,0x82,0x7f,0xff,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80}}, // 槃
{0x5C52,0x9ED0,0xDCD2,0xE6A6A7,0x69A7,{0x08,0x00,0x09,0xff,0x09,0x14,0x7f,0x14,0x09,0x77,0x09,0x14,0x1d,0x74,0x1b,0x17,0x29,0x3c,0x29,0xd4,0x49,0x27,0x09,0x24,0x09,0x44,0x09,0x00,0x09,0xff,0x09,0x00}}, // 榧
{0x5C53,0x9ED1,0xDCD3,0xE6A8AE,0x6A2E,{0x08,0x00,0x0b,0xff,0x08,0x50,0x7e,0x50,0x09,0xfe,0x09,0x52,0x1d,0x52,0x1b,0xfe,0x29,0x00,0x28,0x22,0x48,0xa2,0x08,0xa4,0x09,0x30,0x08,0x48,0x09,0x84,0x0e,0x02}}, // 樮
{0x5C54,0x9ED2,0xDCD4,0xE6A691,0x6991,{0x08,0x24,0x08,0x22,0x0b,0xff,0x7e,0x20,0x09,0xfc,0x09,0x24,0x1d,0xfc,0x1b,0x24,0x29,0xfc,0x29,0x24,0x48,0x08,0x0b,0xff,0x08,0x88,0x08,0x48,0x08,0x08,0x08,0x18}}, // 榑
{0x5C55,0x9ED3,0xDCD5,0xE6A6A0,0x69A0,{0x08,0x00,0x08,0xff,0x08,0x82,0x7e,0xfc,0x09,0x44,0x08,0x44,0x1c,0x7c,0x1a,0x44,0x1a,0x44,0x28,0x7c,0x28,0x10,0x4b,0xff,0x08,0x00,0x08,0x24,0x08,0xc2,0x0b,0x01}}, // 榠
{0x5C56,0x9ED4,0xDCD6,0xE6A69C,0x699C,{0x08,0x20,0x08,0x20,0x0b,0xff,0x7e,0x84,0x08,0x48,0x09,0xff,0x19,0x02,0x1d,0x20,0x2a,0x20,0x2b,0xff,0x48,0x40,0x08,0x7c,0x08,0x44,0x08,0x84,0x09,0x04,0x0a,0x18}}, // 榜
{0x5C57,0x9ED5,0xDCD7,0xE6A695,0x6995,{0x08,0x10,0x08,0x10,0x09,0xff,0x7f,0x09,0x09,0x45,0x08,0x52,0x18,0x92,0x1c,0x28,0x1a,0x44,0x28,0x82,0x29,0x01,0x4a,0xfe,0x08,0x82,0x08,0x82,0x08,0xfe,0x08,0x82}}, // 榕
{0x5C58,0x9ED6,0xDCD8,0xE6A6B4,0x69B4,{0x08,0x40,0x08,0x5f,0x09,0x85,0x7f,0x05,0x09,0x45,0x09,0x29,0x1d,0xd1,0x1b,0x26,0x1a,0x00,0x28,0xfe,0x28,0x92,0x48,0xfe,0x08,0x92,0x08,0x92,0x08,0xfe,0x08,0x82}}, // 榴
{0x5C59,0x9ED7,0xDCD9,0xE6A79E,0x69DE,{0x08,0x20,0x08,0x20,0x09,0xfc,0x7e,0x88,0x08,0x50,0x0b,0xff,0x1c,0x00,0x1b,0xfc,0x1b,0x24,0x29,0x24,0x29,0xfc,0x49,0x24,0x09,0xfc,0x09,0x25,0x08,0x21,0x08,0x1f}}, // 槞
{0x5C5A,0x9ED8,0xDCDA,0xE6A7A8,0x69E8,{0x10,0x80,0x10,0x9e,0x17,0xf2,0x7c,0x12,0x13,0xd4,0x12,0x54,0x3b,0xd8,0x34,0x14,0x33,0xd4,0x50,0x52,0x50,0x92,0x10,0xf2,0x17,0x92,0x10,0x9c,0x10,0x90,0x11,0x90}}, // 槨
{0x5C5B,0x9ED9,0xDCDB,0xE6A882,0x6A02,{0x08,0x44,0x08,0x84,0x0b,0xe5,0x75,0x3a,0x15,0x2a,0x09,0xe4,0x09,0x24,0x15,0x2a,0x7b,0xfd,0x00,0x80,0x7f,0xff,0x02,0xa0,0x04,0x90,0x18,0x8c,0x60,0x83,0x00,0x80}}, // 樂
{0x5C5C,0x9EDA,0xDCDC,0xE6A89B,0x6A1B,{0x08,0x00,0x0b,0xde,0x08,0xc6,0x7f,0x5a,0x08,0xc6,0x09,0x5a,0x1c,0x62,0x1a,0x30,0x18,0x48,0x28,0x94,0x2b,0x23,0x48,0xc8,0x08,0x32,0x09,0xc4,0x08,0x18,0x09,0xe0}}, // 樛
{0x5C5D,0x9EDB,0xDCDD,0xE6A7BF,0x69FF,{0x08,0x44,0x08,0x44,0x09,0xff,0x7e,0x44,0x08,0x7c,0x08,0x10,0x1c,0xfe,0x1a,0x92,0x1a,0xfe,0x28,0x10,0x28,0xfe,0x48,0x10,0x08,0xfe,0x08,0x10,0x0b,0xff,0x08,0x00}}, // 槿
{0x5C5E,0x9EDC,0xDCDE,0xE6AC8A,0x6B0A,{0x08,0x48,0x0b,0xff,0x08,0x48,0x7f,0xef,0x09,0x29,0x09,0xef,0x1c,0x48,0x1a,0x90,0x29,0xff,0x2a,0x90,0x48,0xfe,0x08,0x90,0x08,0xfe,0x08,0x90,0x08,0xff,0x08,0x80}}, // 權
{0x5C5F,0x9EDD,0xDCDF,0xE6A7B9,0x69F9,{0x08,0x20,0x08,0x40,0x08,0xfc,0x7e,0x84,0x08,0xfc,0x0c,0x84,0x1a,0xfc,0x18,0x00,0x1b,0xae,0x28,0x20,0x2b,0xae,0x48,0x20,0x0f,0xff,0x08,0x20,0x08,0x20,0x08,0x20}}, // 槹
{0x5C60,0x9EDE,0xDCE0,0xE6A7B2,0x69F2,{0x11,0x02,0x11,0xc2,0x11,0x52,0x7a,0x8a,0x17,0xea,0x12,0xa2,0x3a,0xb2,0x37,0xea,0x32,0xaa,0x52,0xa2,0x53,0xe3,0x12,0x2e,0x12,0x32,0x12,0x22,0x12,0x22,0x14,0x62}}, // 槲
{0x5C61,0x9EDF,0xDCE1,0xE6A7A7,0x69E7,{0x04,0x02,0x04,0x0c,0x7f,0xb0,0x25,0x20,0x3f,0x3f,0x25,0x24,0x3f,0x24,0x04,0x24,0x7f,0xc4,0x04,0x84,0x00,0x80,0x7f,0xff,0x02,0xa0,0x0c,0x98,0x70,0x87,0x00,0x80}}, // 槧
{0x5C62,0x9EE0,0xDCE2,0xE6A885,0x6A05,{0x11,0x22,0x11,0x22,0x11,0x22,0x7e,0x55,0x12,0x49,0x10,0x80,0x38,0x88,0x35,0x08,0x31,0x28,0x53,0x2e,0x55,0x28,0x11,0x28,0x11,0x28,0x11,0x58,0x11,0x48,0x11,0x87}}, // 樅
{0x5C63,0x9EE1,0xDCE3,0xE6A6B1,0x69B1,{0x08,0x20,0x08,0x20,0x0b,0xff,0x7e,0x00,0x08,0xfc,0x08,0x84,0x1b,0xff,0x1c,0x84,0x1a,0xfc,0x2a,0x32,0x28,0xd2,0x4b,0x8c,0x08,0x88,0x08,0x84,0x08,0xe2,0x0b,0x81}}, // 榱
{0x5C64,0x9EE2,0xDCE4,0xE6A89E,0x6A1E,{0x08,0x00,0x09,0xff,0x09,0x00,0x7f,0x3c,0x09,0x24,0x09,0x24,0x1d,0x3c,0x1b,0x00,0x19,0xee,0x29,0xaa,0x29,0xaa,0x49,0xee,0x09,0xaa,0x09,0x00,0x09,0xff,0x09,0x00}}, // 樞
{0x5C65,0x9EE3,0xDCE5,0xE6A7AD,0x69ED,{0x08,0x08,0x08,0x0a,0x08,0x09,0x7f,0xff,0x09,0x08,0x09,0x48,0x1d,0x7a,0x1b,0x4a,0x29,0xfa,0x29,0x4a,0x49,0x6c,0x09,0xd4,0x0a,0xd5,0x0b,0x4b,0x0c,0xd3,0x08,0x21}}, // 槭
{0x5C66,0x9EE4,0xDCE6,0xE6A894,0x6A14,{0x08,0x49,0x09,0xb6,0x08,0x92,0x7f,0x49,0x08,0xfe,0x08,0x92,0x1c,0xfe,0x1a,0x92,0x1a,0xfe,0x28,0x10,0x29,0xff,0x48,0x38,0x08,0x54,0x08,0x92,0x0b,0x11,0x08,0x10}}, // 樔
{0x5C67,0x9EE5,0xDCE7,0xE6A7AB,0x69EB,{0x08,0x20,0x08,0x20,0x0b,0xff,0x7e,0x20,0x09,0xfc,0x09,0x24,0x1d,0xfc,0x1b,0x24,0x29,0xfc,0x28,0x22,0x4b,0xfd,0x08,0x08,0x0b,0xff,0x08,0x88,0x08,0x48,0x08,0x18}}, // 槫
{0x5C68,0x9EE6,0xDCE8,0xE6A88A,0x6A0A,{0x08,0x44,0x09,0x44,0x7e,0x9f,0x09,0x44,0x1c,0x0e,0x1a,0x4e,0x29,0x95,0x48,0xa5,0x09,0x44,0x0a,0x84,0x00,0x80,0x7f,0xff,0x01,0x40,0x02,0x20,0x0c,0x18,0x70,0x07}}, // 樊
{0x5C69,0x9EE7,0xDCE9,0xE6A892,0x6A12,{0x08,0x10,0x08,0x10,0x08,0xff,0x7e,0xa6,0x09,0x14,0x0c,0xa8,0x1a,0xaa,0x19,0x31,0x2a,0x62,0x29,0x9e,0x48,0x10,0x09,0x11,0x09,0x11,0x09,0x11,0x09,0xff,0x09,0x01}}, // 樒
{0x5C6A,0x9EE8,0xDCEA,0xE6AB81,0x6AC1,{0x08,0x10,0x08,0x10,0x08,0xff,0x7e,0xa6,0x09,0x14,0x08,0xaa,0x19,0x31,0x1a,0x62,0x29,0x9e,0x28,0x10,0x48,0xfe,0x08,0x92,0x08,0xfe,0x08,0x94,0x08,0x3e,0x0b,0xc1}}, // 櫁
{0x5C6B,0x9EE9,0xDCEB,0xE6A8A3,0x6A23,{0x08,0x84,0x08,0x48,0x09,0xfe,0x7e,0x10,0x08,0xfc,0x08,0x10,0x1b,0xff,0x1c,0x20,0x1a,0x18,0x28,0x72,0x28,0x1a,0x49,0xdc,0x08,0x54,0x08,0x92,0x0b,0x11,0x08,0x30}}, // 樣
{0x5C6C,0x9EEA,0xDCEC,0xE6A893,0x6A13,{0x08,0x20,0x09,0xfc,0x09,0x24,0x7f,0xff,0x09,0x24,0x09,0xfc,0x1c,0x20,0x1b,0xfc,0x19,0x24,0x29,0xfc,0x28,0x40,0x4b,0xff,0x08,0x48,0x09,0xc8,0x08,0x38,0x09,0xc4}}, // 樓
{0x5C6D,0x9EEB,0xDCED,0xE6A984,0x6A44,{0x10,0x08,0x13,0xe8,0x11,0x08,0x7d,0x0f,0x17,0xf2,0x12,0x52,0x3a,0x6a,0x37,0xca,0x32,0x4a,0x52,0x4c,0x53,0xc4,0x12,0x44,0x12,0x4a,0x13,0xd2,0x16,0x61,0x10,0x41}}, // 橄
{0x5C6E,0x9EEC,0xDCEE,0xE6A88C,0x6A0C,{0x08,0x00,0x08,0xfc,0x08,0xa4,0x7f,0xff,0x09,0x28,0x09,0xf8,0x1c,0x00,0x1b,0xfc,0x1b,0x04,0x29,0xfc,0x29,0x04,0x49,0xfc,0x09,0x04,0x09,0xfc,0x08,0x8c,0x0b,0x02}}, // 樌
{0x5C6F,0x9EED,0xDCEF,0xE6A9B2,0x6A72,{0x08,0x10,0x09,0xff,0x08,0x10,0x7e,0xfe,0x08,0x00,0x08,0xfe,0x1c,0x82,0x1a,0xfe,0x1a,0x44,0x28,0x28,0x29,0xff,0x48,0x00,0x08,0xfe,0x08,0x82,0x08,0xfe,0x08,0x82}}, // 橲
{0x5C70,0x9EEE,0xDCF0,0xE6A8B6,0x6A36,{0x08,0x00,0x08,0xfc,0x08,0x84,0x7e,0xfc,0x08,0x84,0x08,0xfc,0x1b,0xff,0x1d,0x20,0x2b,0xfe,0x29,0x2a,0x49,0xea,0x09,0x24,0x09,0x24,0x09,0xea,0x0b,0x31,0x08,0x20}}, // 樶
{0x5C71,0x9EEF,0xDCF1,0xE6A9B8,0x6A78,{0x08,0x00,0x08,0xfc,0x08,0x84,0x7f,0x84,0x08,0xfc,0x08,0x84,0x1c,0xfc,0x1a,0x00,0x28,0x00,0x2b,0xdf,0x4a,0x51,0x0b,0xdf,0x0a,0x51,0x0a,0x51,0x0b,0xdf,0x0a,0x51}}, // 橸
{0x5C72,0x9EF0,0xDCF2,0xE6A987,0x6A47,{0x08,0x08,0x09,0xf0,0x08,0x20,0x7e,0x3c,0x09,0xe0,0x08,0x3c,0x1d,0xe2,0x1a,0x1e,0x28,0x44,0x2b,0xb8,0x49,0xcf,0x0f,0x38,0x09,0xcf,0x0f,0x38,0x09,0x29,0x08,0xe7}}, // 橇
{0x5C73,0x9EF1,0xDCF3,0xE6A9A2,0x6A62,{0x10,0x10,0x13,0x90,0x12,0xff,0x7e,0x90,0x13,0x3e,0x13,0x48,0x3a,0xbf,0x36,0x80,0x32,0xbe,0x52,0xa2,0x52,0xbe,0x13,0xa2,0x12,0x3e,0x12,0x22,0x12,0x22,0x12,0x26}}, // 橢
{0x5C74,0x9EF2,0xDCF4,0xE6A999,0x6A59,{0x08,0xea,0x08,0x2c,0x09,0x29,0x7e,0xc6,0x08,0x44,0x08,0xfa,0x1d,0x01,0x1a,0xfc,0x1a,0x84,0x28,0x84,0x28,0xfc,0x48,0x84,0x08,0x44,0x08,0x48,0x0b,0xff,0x08,0x00}}, // 橙
{0x5C75,0x9EF3,0xDCF5,0xE6A9A6,0x6A66,{0x08,0x10,0x08,0xfe,0x08,0x44,0x7f,0x28,0x09,0xff,0x08,0x00,0x1c,0xfe,0x1a,0x92,0x1a,0xfe,0x28,0x92,0x28,0xfe,0x48,0x10,0x08,0xfe,0x08,0x10,0x0b,0xff,0x08,0x00}}, // 橦
{0x5C76,0x9EF4,0xDCF6,0xE6A988,0x6A48,{0x08,0x20,0x08,0xfc,0x08,0x20,0x7f,0xfe,0x08,0x00,0x0c,0x44,0x1b,0xff,0x1a,0x44,0x28,0x64,0x29,0x9f,0x48,0x00,0x0b,0xff,0x08,0x48,0x08,0x49,0x08,0x89,0x0b,0x07}}, // 橈
{0x5C77,0x9EF5,0xDCF7,0xE6A8B8,0x6A38,{0x08,0x28,0x08,0xaa,0x08,0x6c,0x7f,0x28,0x09,0xff,0x08,0x44,0x1c,0x28,0x1a,0xfe,0x29,0x10,0x28,0x7c,0x48,0x10,0x09,0xff,0x08,0x10,0x08,0x28,0x08,0xc4,0x0b,0x03}}, // 樸
{0x5C78,0x9EF6,0xDCF8,0xE6A8A2,0x6A22,{0x08,0x20,0x08,0x40,0x08,0xfc,0x7e,0x84,0x08,0xfc,0x08,0x84,0x1c,0xfc,0x1a,0x80,0x1a,0xff,0x28,0x80,0x28,0xfe,0x48,0x2a,0x09,0x96,0x09,0x52,0x0a,0x42,0x08,0x0c}}, // 樢
{0x5C79,0x9EF7,0xDCF9,0xE6AA90,0x6A90,{0x08,0x40,0x08,0x78,0x08,0x90,0x7f,0xff,0x09,0x2a,0x09,0xc6,0x1d,0x3c,0x1b,0x00,0x29,0xff,0x29,0x00,0x49,0x7c,0x09,0x00,0x0a,0x7e,0x0a,0x42,0x0c,0x7e,0x08,0x42}}, // 檐
{0x5C7A,0x9EF8,0xDCFA,0xE6AA8D,0x6A8D,{0x08,0x20,0x08,0x20,0x09,0xfe,0x7e,0x84,0x08,0x48,0x0b,0xff,0x1c,0x00,0x1a,0xfc,0x1a,0x84,0x28,0xfc,0x28,0x84,0x48,0xfc,0x09,0x50,0x09,0x4a,0x0a,0x45,0x08,0x3c}}, // 檍
{0x5C7B,0x9EF9,0xDCFB,0xE6AAA0,0x6AA0,{0x12,0x10,0x7f,0x90,0x12,0x3f,0x1f,0x24,0x21,0x44,0x5d,0x94,0x15,0x08,0x1d,0x34,0x01,0x42,0x06,0x81,0x00,0x80,0x7f,0xff,0x02,0xa0,0x0c,0x98,0x70,0x87,0x00,0x80}}, // 檠
{0x5C7C,0x9EFA,0xDCFC,0xE6AA84,0x6A84,{0x10,0x88,0x11,0x08,0x13,0xc8,0x7e,0x4f,0x13,0xd2,0x12,0x52,0x33,0xea,0x39,0x0a,0x37,0xea,0x51,0x0c,0x51,0xc4,0x11,0x44,0x12,0x4e,0x12,0x4a,0x14,0x52,0x11,0xa1}}, // 檄
{0x5C7D,0x9EFB,0xDCFD,0xE6AAA2,0x6AA2,{0x08,0x10,0x08,0x30,0x08,0x28,0x7f,0x48,0x08,0x84,0x09,0xfa,0x1c,0x01,0x1b,0xde,0x29,0x52,0x29,0x52,0x49,0xde,0x08,0x88,0x08,0x88,0x08,0xcc,0x09,0x32,0x0a,0x22}}, // 檢
{0x5C7E,0x9EFC,0xDCFE,0xE6AAA3,0x6AA3,{0x08,0x20,0x08,0x20,0x0b,0xff,0x7e,0xa4,0x08,0xa6,0x08,0xe5,0x1d,0x28,0x1b,0xff,0x28,0x00,0x29,0xfe,0x49,0x7a,0x09,0x4a,0x09,0x7a,0x09,0x02,0x09,0xfe,0x09,0x02}}, // 檣
{0x5D21,0x9F40,0xDDA1,0xE6AA97,0x6A97,{0x00,0x08,0x1f,0x08,0x11,0x7e,0x11,0x22,0x1f,0x14,0x10,0x7f,0x2f,0x08,0x29,0x7e,0x4f,0x08,0x09,0x08,0x00,0x80,0x7f,0xff,0x02,0xa0,0x0c,0x98,0x70,0x87,0x00,0x80}}, // 檗
{0x5D22,0x9F41,0xDDA2,0xE89897,0x8617,{0x02,0x10,0x7f,0xff,0x02,0x10,0x1f,0x7e,0x11,0x24,0x1f,0x18,0x10,0xff,0x3f,0x08,0x51,0x7e,0x1f,0x08,0x00,0x80,0x7f,0xff,0x02,0xa0,0x0c,0x98,0x70,0x87,0x00,0x80}}, // 蘗
{0x5D23,0x9F42,0xDDA3,0xE6AABB,0x6ABB,{0x08,0x04,0x09,0xe4,0x09,0x44,0x7f,0x4f,0x09,0xe8,0x09,0x30,0x1d,0xe0,0x1b,0x5f,0x29,0x40,0x29,0xf0,0x48,0x00,0x09,0xfe,0x09,0x52,0x09,0x52,0x0b,0xff,0x08,0x00}}, // 檻
{0x5D24,0x9F43,0xDDA4,0xE6AB83,0x6AC3,{0x10,0x00,0x13,0xff,0x12,0x20,0x7e,0xfc,0x12,0xa4,0x12,0xfc,0x3a,0x20,0x37,0xff,0x32,0x84,0x52,0xfc,0x12,0x84,0x12,0xfc,0x12,0x44,0x13,0x82,0x13,0xff,0x12,0x00}}, // 櫃
{0x5D25,0x9F44,0xDDA5,0xE6AB82,0x6AC2,{0x08,0x00,0x0b,0xde,0x09,0x4a,0x7e,0xd6,0x09,0x4a,0x0a,0x52,0x18,0x48,0x1c,0x50,0x2a,0xfe,0x29,0x90,0x4a,0xfe,0x08,0x90,0x08,0xfe,0x08,0x90,0x08,0xff,0x08,0x80}}, // 櫂
{0x5D26,0x9F45,0xDDA6,0xE6AAB8,0x6AB8,{0x08,0x20,0x08,0x20,0x09,0xff,0x7d,0x22,0x0a,0x54,0x19,0x4a,0x1a,0x39,0x1d,0xfd,0x29,0x54,0x29,0xfc,0x48,0x00,0x0b,0xff,0x08,0x20,0x08,0x20,0x08,0x20,0x08,0x60}}, // 檸
{0x5D27,0x9F46,0xDDA7,0xE6AAB3,0x6AB3,{0x08,0x20,0x09,0xff,0x09,0x02,0x7e,0xfe,0x08,0xa4,0x08,0xa8,0x19,0x30,0x1c,0xfc,0x2b,0x84,0x2a,0xfc,0x48,0x84,0x08,0xfc,0x08,0x84,0x08,0xfc,0x08,0xcc,0x0b,0x02}}, // 檳
{0x5D28,0x9F47,0xDDA8,0xE6AAAC,0x6AAC,{0x08,0x48,0x09,0xff,0x08,0x48,0x7e,0xff,0x08,0x82,0x19,0x7c,0x1c,0x00,0x1b,0xff,0x2a,0x40,0x28,0xaa,0x4b,0x6a,0x08,0x94,0x0b,0x34,0x08,0x52,0x09,0x91,0x08,0x30}}, // 檬
{0x5D29,0x9F48,0xDDA9,0xE6AB9E,0x6ADE,{0x11,0x08,0x11,0x0e,0x11,0x12,0x7e,0x5c,0x12,0x84,0x19,0x7f,0x35,0x10,0x32,0xaa,0x3f,0xca,0x51,0x14,0x55,0x2c,0x15,0x4e,0x15,0x56,0x15,0x65,0x19,0x04,0x11,0x18}}, // 櫞
{0x5D2A,0x9F49,0xDDAA,0xE6AB91,0x6AD1,{0x08,0x00,0x08,0xfc,0x08,0xa4,0x7e,0xfc,0x08,0xa4,0x18,0xa4,0x1c,0xfc,0x1a,0x00,0x2b,0xff,0x2a,0xb5,0x4a,0xb5,0x0b,0xff,0x0a,0xb5,0x0a,0xb5,0x0b,0xff,0x08,0x00}}, // 櫑
{0x5D2B,0x9F4A,0xDDAB,0xE6AB9F,0x6ADF,{0x08,0x92,0x08,0xa2,0x08,0xba,0x7f,0x6d,0x09,0x6d,0x08,0xba,0x1c,0xaa,0x1b,0x7d,0x29,0xd7,0x28,0x10,0x49,0xff,0x08,0x38,0x08,0x54,0x08,0x92,0x09,0x11,0x08,0x10}}, // 櫟
{0x5D2C,0x9F4B,0xDDAC,0xE6AAAA,0x6AAA,{0x08,0x10,0x09,0x21,0x08,0xba,0x7e,0xaa,0x08,0x2c,0x08,0x78,0x1c,0xac,0x1a,0xaa,0x2b,0x39,0x28,0x10,0x49,0xff,0x08,0x38,0x08,0x54,0x08,0x92,0x09,0x11,0x08,0x10}}, // 檪
{0x5D2D,0x9F4C,0xDDAD,0xE6AB9A,0x6ADA,{0x10,0x00,0x13,0xde,0x12,0x52,0x7f,0xde,0x12,0x52,0x13,0xde,0x3a,0x02,0x36,0xfa,0x52,0x8a,0x52,0xfa,0x12,0x42,0x12,0xfa,0x12,0x8a,0x12,0xfa,0x12,0x02,0x12,0x06}}, // 櫚
{0x5D2E,0x9F4D,0xDDAE,0xE6ABAA,0x6AEA,{0x08,0x00,0x09,0xff,0x09,0x12,0x7f,0x6c,0x09,0x24,0x0d,0xff,0x1d,0x34,0x1b,0x6e,0x29,0xb5,0x29,0x24,0x49,0x48,0x0a,0x4f,0x0a,0x48,0x0c,0x48,0x09,0xff,0x08,0x00}}, // 櫪
{0x5D2F,0x9F4E,0xDDAF,0xE6ABBB,0x6AFB,{0x10,0x00,0x13,0xde,0x12,0x52,0x7f,0xde,0x12,0x52,0x13,0xde,0x3a,0x52,0x37,0xde,0x35,0x54,0x52,0x22,0x50,0x40,0x17,0xff,0x10,0x88,0x11,0xf0,0x10,0xd8,0x17,0x04}}, // 櫻
{0x5D30,0x9F4F,0xDDB0,0xE6AC85,0x6B05,{0x08,0x20,0x08,0x76,0x08,0xa2,0x7e,0xf6,0x08,0xaa,0x08,0xee,0x1d,0xff,0x1a,0xcc,0x19,0x72,0x2a,0x11,0x28,0xfe,0x48,0x10,0x09,0xff,0x08,0x10,0x08,0x10,0x08,0x30}}, // 欅
{0x5D31,0x9F50,0xDDB1,0xE89896,0x8616,{0x02,0x10,0x7f,0xff,0x02,0x10,0x08,0x08,0x3f,0x7f,0x21,0x22,0x3f,0x14,0x20,0x7f,0x3f,0x08,0x21,0x7e,0x3f,0x08,0x00,0x80,0x7f,0xff,0x02,0xa0,0x0c,0x98,0x70,0x87}}, // 蘖
{0x5D32,0x9F51,0xDDB2,0xE6ABBA,0x6AFA,{0x08,0x00,0x09,0xfe,0x08,0x10,0x7f,0xff,0x09,0x12,0x09,0xdc,0x1d,0x10,0x1a,0xdc,0x28,0x10,0x28,0x00,0x49,0xff,0x09,0x6d,0x09,0x6d,0x09,0x6d,0x09,0xff,0x09,0x6d}}, // 櫺
{0x5D33,0x9F52,0xDDB3,0xE6AC92,0x6B12,{0x10,0x04,0x13,0xc4,0x68,0x1a,0x17,0xe4,0x28,0x0a,0x7f,0xdf,0x10,0x04,0x3b,0xd6,0x56,0x65,0x13,0xc4,0x00,0x80,0x7f,0xff,0x02,0xa0,0x0c,0x98,0x70,0x87,0x00,0x80}}, // 欒
{0x5D34,0x9F53,0xDDB4,0xE6AC96,0x6B16,{0x13,0xe8,0x12,0x8f,0x13,0xd0,0x7e,0x6e,0x13,0xdf,0x12,0x95,0x3b,0xff,0x35,0x04,0x31,0xfc,0x51,0x04,0x51,0xfc,0x11,0x04,0x11,0xfc,0x10,0x51,0x11,0x91,0x16,0x0f}}, // 欖
{0x5D35,0x9F54,0xDDB5,0xE9ACB1,0x9B31,{0x09,0x08,0x09,0xe8,0x7e,0x9f,0x19,0xec,0x2e,0xba,0x4b,0xe9,0x08,0x08,0x7f,0xfe,0x4a,0x82,0x24,0x8a,0x2a,0xf0,0x3f,0x84,0x12,0x78,0x1c,0x02,0x11,0x0c,0x0f,0x70}}, // 鬱
{0x5D36,0x9F55,0xDDB6,0xE6AC9F,0x6B1F,{0x11,0x40,0x11,0x5e,0x17,0xf2,0x79,0x52,0x13,0xfe,0x1a,0xb2,0x37,0xfe,0x31,0x52,0x53,0xf2,0x56,0x9e,0x13,0xcc,0x12,0x8c,0x13,0xd4,0x12,0x95,0x13,0xe5,0x10,0x43}}, // 欟
{0x5D37,0x9F56,0xDDB7,0xE6ACB8,0x6B38,{0x08,0x20,0x0a,0x20,0x09,0x20,0x12,0xff,0x7c,0x41,0x08,0x92,0x0f,0x94,0x14,0x10,0x24,0x10,0x7f,0x90,0x04,0x28,0x06,0x28,0x09,0x24,0x09,0x44,0x10,0x82,0x21,0x01}}, // 欸
{0x5D38,0x9F57,0xDDB8,0xE6ACB7,0x6B37,{0x01,0x20,0x32,0x20,0x0c,0x20,0x1a,0x3f,0x65,0x41,0x04,0x52,0x7f,0x94,0x08,0x10,0x18,0x10,0x3f,0x10,0x69,0x28,0x29,0x28,0x29,0x24,0x2a,0x44,0x08,0x82,0x09,0x01}}, // 欷
{0x5D39,0x9F58,0xDDB9,0xE79B9C,0x76DC,{0x08,0x40,0x04,0x40,0x44,0xff,0x20,0x92,0x21,0x14,0x0a,0x10,0x08,0x28,0x10,0xc4,0x23,0x03,0x40,0x00,0x1f,0xfc,0x12,0x24,0x12,0x24,0x12,0x24,0x7f,0xff,0x00,0x00}}, // 盜
{0x5D3A,0x9F59,0xDDBA,0xE6ACB9,0x6B39,{0x04,0x20,0x04,0x20,0x3f,0x20,0x04,0x3f,0x0a,0x41,0x31,0x52,0x00,0x94,0x7f,0x90,0x01,0x10,0x3d,0x10,0x25,0x28,0x25,0x28,0x3d,0x24,0x25,0x44,0x01,0x42,0x03,0x81}}, // 欹
{0x5D3B,0x9F5A,0xDDBB,0xE9A3AE,0x98EE,{0x08,0x20,0x08,0x20,0x14,0x20,0x12,0x3f,0x3d,0x42,0x60,0x54,0x3e,0x90,0x22,0x10,0x3e,0x10,0x22,0x18,0x3e,0x18,0x20,0x28,0x3e,0x24,0x20,0x44,0x3e,0x82,0x21,0x01}}, // 飮
{0x5D3C,0x9F5B,0xDDBC,0xE6AD87,0x6B47,{0x00,0x20,0x3e,0x20,0x22,0x20,0x3e,0x7f,0x22,0x42,0x22,0x54,0x3e,0x90,0x08,0x10,0x1f,0x10,0x29,0x18,0x6d,0x18,0x2b,0x28,0x31,0x24,0x3d,0x44,0x02,0x42,0x0c,0x81}}, // 歇
{0x5D3D,0x9F5C,0xDDBD,0xE6AD83,0x6B43,{0x00,0xa0,0x03,0x20,0x3c,0x20,0x04,0x7f,0x04,0x42,0x7f,0x54,0x04,0x90,0x0c,0x10,0x35,0x90,0x24,0x98,0x24,0x98,0x35,0xa8,0x24,0xa4,0x24,0xc4,0x3f,0xc2,0x20,0x81}}, // 歃
{0x5D3E,0x9F5D,0xDDBE,0xE6AD89,0x6B49,{0x09,0x10,0x12,0x10,0x7f,0xd0,0x0a,0x1f,0x3f,0xa1,0x0a,0xaa,0x7f,0xcc,0x0a,0x88,0x3f,0x88,0x0a,0x08,0x1b,0x0c,0x1a,0x94,0x2a,0x94,0x4a,0x22,0x0a,0x42,0x0a,0x81}}, // 歉
{0x5D3F,0x9F5E,0xDDBF,0xE6AD90,0x6B50,{0x00,0x10,0x3f,0x90,0x20,0x10,0x2f,0x1f,0x29,0x21,0x29,0x2a,0x2f,0x48,0x20,0x08,0x3d,0xc8,0x35,0x48,0x35,0x54,0x3d,0xd4,0x35,0x54,0x20,0x22,0x3f,0xc2,0x20,0x81}}, // 歐
{0x5D40,0x9F5F,0xDDC0,0xE6AD99,0x6B59,{0x04,0x10,0x0a,0x10,0x11,0x10,0x6e,0xdf,0x00,0x11,0x1f,0x2a,0x11,0x2a,0x1f,0x48,0x00,0x08,0x7f,0x88,0x19,0x8c,0x6e,0x94,0x19,0x94,0x6e,0xa2,0x08,0xc2,0x19,0x81}}, // 歙
{0x5D41,0x9F60,0xDDC1,0xE6AD94,0x6B54,{0x04,0x10,0x07,0x10,0x04,0x10,0x3f,0xbf,0x25,0x21,0x3e,0xaa,0x24,0xcc,0x23